
//============================================================================================
/**
 * @file	shinka.c
 * @bfief	퓬ifvO
 * @author	HisashiSogabe
 * @date	05.10.25
 */
//============================================================================================

#include "common.h"

#include "system/arc_tool.h"
#include "system/arc_util.h"
#include "system/softsprite.h"
#include "system/brightness.h"
#include "system/snd_tool.h"
#include "system/msgdata.h"
#include "system/buflen.h"
#include "system/zukanwork.h"

#include "battle/battle_common.h"
#include "battle/battle_server.h"
#include "battle/fight_tool.h"
#include "battle/shinka.h"
#include "poketool/poke_tool.h"
#include "poketool/pokeparty.h"

#include "fight_def.h"				///<퓬̍\̂Ԏ؂肷邽߂ɁA
#include "shinka_def.h"

#include "battle/graphic/batt_bg_def.h"

#include "msgdata/msg.naix"
#include "msgdata/msg_fightmsg_dp.h"

#include "gflib/mmap_get.h"

#define	SHINKA_BMP_WIN_MAX	(1)		///<ifŎgpBMPWINMAX

//============================================================================================
/**
 * vg^Cv錾
 */
//============================================================================================

void	FightShinkaInit(PROC *proc,BATTLE_PARAM *bp);
BOOL	FightShinkaMain(PROC *proc);
void	FightShinkaEnd(PROC *proc);

static BOOL ShinkaSequence(SHINKA_WORK *sw);

static	void	ShinkaBGCreate(SHINKA_WORK *sw, GF_BGL_INI *bgl);
static	void	ShinkaBGEnd(GF_BGL_INI *bgl);
static	BOOL	ShinkaOBJCreate(SHINKA_WORK *sw,int *flag);
static	void	ShinkaVBlank(void *work);

//--------------------------------------------------------------
/**
 * @brief	퓬if
 */
//--------------------------------------------------------------
void	FightShinkaInit(PROC *proc,BATTLE_PARAM *bp)
{
	SHINKA_WORK	*sw=PROC_AllocWork(proc,sizeof(SHINKA_WORK), HEAPID_BATTLE);
	SOFT_SPRITE_ARC	ssa;
	int			i;

	MI_CpuClearFast(sw,sizeof(SHINKA_WORK));
	MI_CpuFill16((void*)GF_MMAP_MainBgPlttAddr(), 0x0000, GF_MMAP_MainBgPlttSize());
	MI_CpuFill16((void*)GF_MMAP_SubBgPlttAddr(), 0x0000, GF_MMAP_SubBgPlttSize());

	sw->bw=sys_AllocMemory(HEAPID_BATTLE,sizeof(BATTLE_WORK));

	sw->bw->poke_party[0]=PokeParty_AllocPartyWork(HEAPID_BATTLE);
	PokeParty_Copy(bp->poke_party[0],sw->bw->poke_party[0]);

	sw->bw->zw=ZukanWork_AllocWork(HEAPID_BATTLE);
	ZukanWork_Copy(bp->zw,sw->bw->zw);

	sw->bw->pfd = PaletteFadeInit(HEAPID_BATTLE);
	PaletteTrans_AutoSet(sw->bw->pfd, TRUE);
	PaletteFadeWorkAllocSet(sw->bw->pfd, FADE_MAIN_BG, 0x200, HEAPID_BATTLE);
	PaletteFadeWorkAllocSet(sw->bw->pfd, FADE_SUB_BG, 0x200, HEAPID_BATTLE);
	PaletteFadeWorkAllocSet(sw->bw->pfd, FADE_MAIN_OBJ, 0x200, HEAPID_BATTLE);
	PaletteFadeWorkAllocSet(sw->bw->pfd, FADE_SUB_OBJ, 0x200, HEAPID_BATTLE);

	sw->bw->bgl=GF_BGL_BglIniAlloc(HEAPID_BATTLE);
	sw->bw->win=GF_BGL_BmpWinAllocGet(HEAPID_BATTLE,SHINKA_BMP_WIN_MAX);

	ShinkaBGCreate(sw, sw->bw->bgl);

	sw->bw->soft_sprite=SoftSpriteInit(HEAPID_BATTLE);

	//bZ[W}l[W쐬
	sw->bw->fight_msg=MSGMAN_Create(MSGMAN_TYPE_NORMAL,ARC_MSG,NARC_msg_fightmsg_dp_dat,HEAPID_BATTLE);
	//Pobt@쐬
	sw->bw->wordset=WORDSET_Create(HEAPID_BATTLE);
	sw->bw->msg_buf=STRBUF_Create(BATTLE_MESSAGE_BUF_SIZE,HEAPID_BATTLE);

	while(ShinkaOBJCreate(sw,&bp->level_up_flag)==FALSE);

	GF_BGL_BmpWinAdd(sw->bw->bgl,sw->bw->win,GF_BGL_FRAME1_M,0x02,0x13,28,4,0x0a,0x0d);

//	PaletteFadeReq(sw->bw->pfd,PF_BIT_NORMAL_ALL,0xffff,0,16,0,0x0000);
	ChangeBrightnessRequest(16,0,-16,PLANEMASK_ALL,MASK_DOUBLE_DISPLAY);
}

//--------------------------------------------------------------
/**
 * @brief	퓬if
 */
//--------------------------------------------------------------
BOOL	FightShinkaMain(PROC *proc)
{
	SHINKA_WORK	*sw=PROC_GetWork(proc);
	BOOL		ret=FALSE;

	ret=ShinkaSequence(sw);

	SoftSpriteMain(sw->bw->soft_sprite);
	GF_G3_RequestSwapBuffers(GX_SORTMODE_MANUAL, GX_BUFFERMODE_Z);

	return ret;
}

//--------------------------------------------------------------
/**
 * @brief	퓬if
 */
//--------------------------------------------------------------
void	FightShinkaEnd(PROC *proc)
{
	SHINKA_WORK		*sw=PROC_GetWork(proc);
	BATTLE_PARAM	*bp=PROC_GetParentWork(proc);
	int	i;

	PokeParty_Copy(sw->bw->poke_party[0],bp->poke_party[0]);
	sys_FreeMemoryEz(sw->bw->poke_party[0]);

	ZukanWork_Copy(sw->bw->zw,bp->zw);
	sys_FreeMemoryEz(sw->bw->zw);

	GF_BGL_BmpWinFree(sw->bw->win,SHINKA_BMP_WIN_MAX);

	//pbgtF[hVXe폜
	PaletteFadeWorkAllocFree(sw->bw->pfd, FADE_MAIN_BG);
	PaletteFadeWorkAllocFree(sw->bw->pfd, FADE_SUB_BG);
	PaletteFadeWorkAllocFree(sw->bw->pfd, FADE_MAIN_OBJ);
	PaletteFadeWorkAllocFree(sw->bw->pfd, FADE_SUB_OBJ);
	PaletteFadeFree(sw->bw->pfd);

	SoftSpriteEnd(sw->bw->soft_sprite);

	ShinkaBGEnd(sw->bw->bgl);

	//bZ[W}l[W̍폜
	MSGMAN_Delete(sw->bw->fight_msg);

	//Pobt@폜
	WORDSET_Delete(sw->bw->wordset);
	sys_FreeMemoryEz(sw->bw->msg_buf);

	sys_FreeMemoryEz(sw->bw->bgl);

	sys_FreeMemoryEz(sw->bw);
	sys_FreeMemoryEz(sw);
}

//--------------------------------------------------------------
/**
 * @brief	퓬if
 */
//--------------------------------------------------------------
enum{
	SEQ_SHIKA_BEFORE_MSG_INIT=0,
	SEQ_SHIKA_BEFORE_MSG_WAIT,
	SEQ_SHIKA_MORPH,
	SEQ_SHIKA_AFTER_MSG_INIT,
	SEQ_SHIKA_AFTER_MSG_WAIT,
	SEQ_SHIKA_END
};
static BOOL ShinkaSequence(SHINKA_WORK *sw)
{
	BOOL ret=FALSE;
	switch(sw->seq_no){
	case SEQ_SHIKA_BEFORE_MSG_INIT:
		{
			MESSAGE_PARAM	mp;

			Snd_PMVoicePlay(sw->before_mons_no);
			mp.msg_id=ShinkaBeforeMsg;
			mp.msg_tag=TAG_NICK;
			mp.msg_para[0]=(sw->sel_mons_no<<8);
			sw->msg_index=BattleMSG_Print(sw->bw,sw->bw->win,sw->bw->fight_msg,&mp,1);
			sw->wait=40;
			sw->seq_no++;
		}
		break;
	case SEQ_SHIKA_BEFORE_MSG_WAIT:
		if(GF_MSG_PrintEndCheck(sw->msg_index)==0){
			if(--sw->wait==0){
				sw->seq_no++;
			}
		}
		break;
	case SEQ_SHIKA_MORPH:
		SoftSpriteParaCalc(sw->ss[0],SS_PARA_AFF_X,-2);
		SoftSpriteParaCalc(sw->ss[0],SS_PARA_AFF_Y,-2);
		SoftSpriteParaCalc(sw->ss[1],SS_PARA_AFF_X,2);
		SoftSpriteParaCalc(sw->ss[1],SS_PARA_AFF_Y,2);
		if(SoftSpriteParaGet(sw->ss[0],SS_PARA_AFF_X)==0){
			Snd_PMVoicePlay(sw->after_mons_no);
			sw->seq_no++;
		}
		break;
	case SEQ_SHIKA_AFTER_MSG_INIT:
		{
			MESSAGE_PARAM	mp;

			mp.msg_id=ShinkaAfterMsg;
			mp.msg_tag=TAG_NICK_POKE;
			mp.msg_para[0]=(sw->sel_mons_no<<8);
			mp.msg_para[1]=(sw->sel_mons_no<<8);
			sw->msg_index=BattleMSG_Print(sw->bw,sw->bw->win,sw->bw->fight_msg,&mp,1);
			sw->wait=40;
			sw->seq_no++;
		}
		break;
	case SEQ_SHIKA_AFTER_MSG_WAIT:
		if(GF_MSG_PrintEndCheck(sw->msg_index)==0){
			if(--sw->wait==0){
				{
					STRCODE			buf[BUFLEN_POKEMON_NAME];
					POKEMON_PARAM	*pp;

					pp=PokeParty_GetMemberPointer(sw->bw->poke_party[0],sw->sel_mons_no);

					if(PokeParaGet(pp,ID_PARA_nickname_flag,NULL)==0){
						MSGDAT_MonsNameGet(sw->after_mons_no,HEAPID_BASE_SYSTEM,buf);
						PokeParaPut(pp,ID_PARA_nickname,(u8 *)&buf);
					}
				}
				PaletteFadeReq(sw->bw->pfd,PF_BIT_NORMAL_ALL,0xffff,1,0,16,0x0000);
				SoftSpritePalFadeSetAll(sw->bw->soft_sprite,0,16,0,0x0000);
				sw->seq_no++;
			}
		}
		break;
	case SEQ_SHIKA_END:
		if(PaletteFadeCheck(sw->bw->pfd)==0){
			ret=TRUE;
		}
		break;
	}
	return ret;
}

//============================================================================================
/**
 *	ifwiʏʐ
 */
//============================================================================================
static	void	ShinkaBGCreate(SHINKA_WORK *sw, GF_BGL_INI *bgl)
{
	GF_Disp_GX_VisibleControlInit();

	//VRAMݒ
	{
		GF_BGL_DISPVRAM vramSetTable = {
			GX_VRAM_BG_128_C,				// C2DGWBG
			GX_VRAM_BGEXTPLTT_NONE,			// C2DGWBGgpbg
			GX_VRAM_SUB_BG_32_H,			// Tu2DGWBG
			GX_VRAM_SUB_BGEXTPLTT_NONE,		// Tu2DGWBGgpbg
			GX_VRAM_OBJ_64_E,				// C2DGWOBJ
			GX_VRAM_OBJEXTPLTT_NONE,		// C2DGWOBJgpbg
			GX_VRAM_SUB_OBJ_16_I,			// Tu2DGWOBJ
			GX_VRAM_SUB_OBJEXTPLTT_NONE,	// Tu2DGWOBJgpbg
			GX_VRAM_TEX_01_AB,				// eNX`C[WXbg
			GX_VRAM_TEXPLTT_01_FG			// eNX`pbgXbg
		};
		GF_Disp_SetBank( &vramSetTable );
	}

	// BG SYSTEM
	{
		GF_BGL_SYS_HEADER BGsys_data = {
			GX_DISPMODE_GRAPHICS, GX_BGMODE_0, GX_BGMODE_0, GX_BG0_AS_3D,
		};
		GF_BGL_InitBG( &BGsys_data );
	}

	//Cʃt[ݒ
	{
		GF_BGL_BGCNT_HEADER TextBgCntDat[] = {
			///<FRAME1_M
			{
				0, 0, 0x0800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
				GX_BG_SCRBASE_0x0000, GX_BG_CHARBASE_0x04000, GX_BG_EXTPLTT_01,
				0, 0, 0, FALSE
			},
			///<FRAME2_M
			{
				0, 0, 0x2000, 0, GF_BGL_SCRSIZ_512x512, GX_BG_COLORMODE_16,
				GX_BG_SCRBASE_0x1000, GX_BG_CHARBASE_0x0c000, GX_BG_EXTPLTT_01,
				1, 0, 0, FALSE
			},
			///<FRAME3_M
			{
				0, 0, 0x1000, 0, GF_BGL_SCRSIZ_512x256, GX_BG_COLORMODE_256,
				GX_BG_SCRBASE_0x3000, GX_BG_CHARBASE_0x10000, GX_BG_EXTPLTT_01,
				3, 0, 0, FALSE
			},
		};
		GF_BGL_BGControlSet(bgl, GF_BGL_FRAME1_M, &TextBgCntDat[0], GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear(bgl, GF_BGL_FRAME1_M );
		GF_BGL_BGControlSet(bgl, GF_BGL_FRAME2_M, &TextBgCntDat[1], GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear(bgl, GF_BGL_FRAME2_M );
		GF_BGL_BGControlSet(bgl, GF_BGL_FRAME3_M, &TextBgCntDat[2], GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear(bgl, GF_BGL_FRAME3_M );

		G2_SetBG0Priority(0x01);
		GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG0, VISIBLE_ON );
	}
	//Tuʃt[ݒ
	{
//		BINPUT_DefaultFrameSet(bgl);
	}

	//wiOtBbNf[^[h
	{
		ArcUtil_BgCharSet(ARC_BATT_BG,BATTLE_WBG0A_NCGR_BIN,bgl,GF_BGL_FRAME1_M,0,0,1,HEAPID_BATTLE);
		ArcUtil_ScrnSet(ARC_BATT_BG,BATTLE_WBG0A_NSCR_BIN,bgl,GF_BGL_FRAME1_M,0,0,1,HEAPID_BATTLE);
		ArcUtil_BgCharSet(ARC_BATT_BG,BATTLE_BG00_NCGR_BIN,bgl,GF_BGL_FRAME3_M,0,0,1,HEAPID_BATTLE);
//		ArcUtil_PalSet(ARC_BATT_BG,BATTLE_BG00_NCLR,PALTYPE_MAIN_BG,0,0,HEAPID_BATTLE);
		PaletteWorkSet_Arc(sw->bw->pfd, ARC_BATT_BG, BATT_BG00_D_NCLR, HEAPID_BATTLE, 
			FADE_MAIN_BG, 0, 0);
		ArcUtil_ScrnSet(ARC_BATT_BG,BATTLE_BG00_NSCR_BIN,bgl,GF_BGL_FRAME3_M,0,0,1,HEAPID_BATTLE);
	}

	GF_Disp_DispOn();

//	GF_Disp_GX_VisibleControl(GX_PLANEMASK_OBJ, VISIBLE_ON);
//	GF_Disp_GXS_VisibleControl(GX_PLANEMASK_OBJ, VISIBLE_ON);
	sys_VBlankFuncChange(ShinkaVBlank,sw->bw);
}

static	void	ShinkaBGEnd(GF_BGL_INI *bgl)
{
	GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG0, VISIBLE_OFF );
	GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG1, VISIBLE_OFF );
	GF_BGL_BGControlExit(bgl, GF_BGL_FRAME1_M );
	GF_BGL_BGControlExit(bgl, GF_BGL_FRAME2_M );
	GF_BGL_BGControlExit(bgl, GF_BGL_FRAME3_M );
	//Tu
//	BINPUT_FrameExit(bgl);
}

static	BOOL	ShinkaOBJCreate(SHINKA_WORK *sw,int *flag)
{
	POKEMON_PARAM *pp;

	for(sw->sel_mons_no=0;sw->sel_mons_no<POKEMON_TEMOTI_MAX;sw->sel_mons_no++){
		if(flag[0]&No2Bit(sw->sel_mons_no)){
			break;
		}
	}
	flag[0]&=No2Bit(sw->sel_mons_no);
	pp=PokeParty_GetMemberPointer(sw->bw->poke_party[0],sw->sel_mons_no);

	if(sw->after_mons_no=PokeShinkaCheck(pp,LEVELUP_SHINKA,NULL)){
		{
			SOFT_SPRITE_ARC	ssa;

			sw->before_mons_no=PokeParaGet(pp,ID_PARA_monsno,NULL);
			PokeGraArcDataGetPP(&ssa,pp,PARA_FRONT);
			sw->ss[0]=SoftSpriteAdd(sw->bw->soft_sprite,&ssa,128,80,0,0,NULL,NULL);
			PokeParaPut(pp,ID_PARA_monsno,(u8 *)&sw->after_mons_no);
			PokeParaCalc(pp);
			PokeGraArcDataGetPP(&ssa,pp,PARA_FRONT);
			sw->ss[1]=SoftSpriteAdd(sw->bw->soft_sprite,&ssa,128,80,0,0,NULL,NULL);
			SoftSpriteParaSet(sw->ss[1],SS_PARA_AFF_X,AFF_APPEAR_X_S);
			SoftSpriteParaSet(sw->ss[1],SS_PARA_AFF_Y,AFF_APPEAR_Y_S);
		}
		return TRUE;
	}
	return FALSE;
}

//--------------------------------------------------------------
/**
 * @brief	VBLANK֐
 *
 * @param	work	VBLankɂ͈KvȂ̂Œ`Ă邪ۂɂNULLĂ̂ŁAANZX͋֎~I
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
static	void	ShinkaVBlank(void *work)
{
	BATTLE_WORK *bw = work;

	SoftSpriteTextureTrans(bw->soft_sprite);
	PaletteFadeTrans(bw->pfd);
	OS_SetIrqCheckFlag( OS_IE_V_BLANK);
}

