
//============================================================================================
/**
 * @file	skill_intp.c
 * @bfief	ZV[PX߃vO
 * @author	HisashiSogabe
 * @date	05.05.25
 */
//============================================================================================

#include "common.h"

#include "battle/battle_common.h"
#include "battle/battle_server.h"
#include "battle/fight_tool.h"
#include "battle/server.h"
#include "battle/server_tool.h"
#include "battle/scio.h"
#include "battle/tokusyu_def.h"
#include "battle/wazano_def.h"

#include "itemtool/item.h"
#include "itemtool/itemequip.h"
#include "itemtool/itemsym.h"

#include "poketool/boxdata.h"
#include "poketool/pokeparty.h"
#include "poketool/tr_tool.h"
#include "poketool/waza_tool.h"
#include "poketool/monsno.h"

#include "system/arc_tool.h"
#include "system/brightness.h"
#include "system/snd_tool.h"

#include "application/app_tool.h"

#include "msgdata/msg_fightmsg_dp.h"

#include "fight_def.h"		///<BattleWorkւ̈ˑx\[XȂ̂ŁA
#include "server_def.h"		///<ServerParamւ̈ˑx\[XȂ̂ŁA
#include "client_def.h"		///<ClientParamւ̈ˑx\[XȂ̂ŁA

//============================================================================================
/**
 *	\̐錾
 */
//============================================================================================
//============================================================================================
/**
 *	vg^Cv錾
 */
//============================================================================================

//OJ֐
BOOL	SkillIntp(BATTLE_WORK *bw,SERVER_PARAM *sp);

//߉ߊ֐Q
static	BOOL	WS_ENCOUNT_EFFECT(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_POKEMON_ENCOUNT(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_POKEMON_APPEAR(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_POKEMON_RETURN(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_POKEMON_DELETE(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_TRAINER_ENCOUNT(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_TRAINER_OUT(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_TRAINER_IN(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_TRAINER_BG_SLIDEIN(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_HP_GAUGE_IN(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_HP_GAUGE_IN_WAIT(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_HP_GAUGE_OUT(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_SERVER_WAIT(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_DAMAGE_CALC(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_ATTACK_MESSAGE(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_MESSAGE(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_MESSAGE_NO_DIR(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_MESSAGE_WORK(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_MESSAGE_PARAM(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_WAZA_EFFECT(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_POKEMON_BLINK(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_HP_CALC(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_HP_GAUGE_CALC(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_KIZETSU_CHECK(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_KIZETSU_EFFECT(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_WAIT(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_SE_PLAY(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_IF(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_IF_PSP(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_FADE_OUT(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_JUMP(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_JUMP_BE_SEQ(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_JUMP_WAZA_WORK(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_CRITICAL_CHECK(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_GET_EXP_CHECK(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_GET_EXP_INIT(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_GET_EXP(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_GET_EXP_LOOP(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_POKEMON_LIST(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_POKEMON_LIST_WAIT(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_POKEMON_RESHUFFLE(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_POKEMON_RESHUFFLE_LOOP(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_POKEMON_GET_INIT(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_POKEMON_GET(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_RENZOKU(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_VALUE(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_ABICNT_CALC(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_PSP_VALUE(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_CONDITION2_OFF(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_VANISH_ON_OFF(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_TOKUSEI_CHECK(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_RANDOM_GET(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_VALUE_WORK(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_PSP_VALUE_WORK(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_BRANCH(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_GOSUB(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_GOSUB_WORK(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_OUMU_CHECK(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_KUROIKIRI(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_KEEP_OFF(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_STATUS_SET(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_TRAINER_MESSAGE(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_OKODUKAI_CALC(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_STATUS_EFFECT(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_STATUS_EFFECT_WORK(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_MODOSU_MESSAGE(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_KURIDASU_MESSAGE(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_TRAINER_MESSAGE_WORK(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_TEXTURE(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_IF_WORK(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_IF_PSP_WORK(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_KOBAN_CHECK(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_HIKARINOKABE(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_RIHUREKUTAA(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_SIROIKIRI(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_ICHIGEKI(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_DAMAGE_DIV(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_DAMAGE_DIV_WORK(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_MONOMANE(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_YUBIWOHURU(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_KANASIBARI(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_COUNTER(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_MIRROR_CORT(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_ENCORE(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_TEXTURE2(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_SKETCH(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_NEGOTO(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_JITABATA(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_URAMI(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_IYASINOSUZU(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_DOROBOU(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_GUARD_SUCCESS_CHECK(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_MIGAWARI(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_HUKITOBASI(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_HENSIN(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_MAKIBISI(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_MAKIBISI_CHECK(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_HOROBINOUTA(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_CLIENT_NO_GET_AGI(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_CLIENT_SET_MAX_LOOP(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_TENKOU_DAMAGE(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_KOROGARU(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_RENZOKUGIRI(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_MEROMERO(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_SHINPI(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_PRESENT(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_MAGNITUDE(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_RESHUFFLE_CHECK(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_KOUSOKUSPIN(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_WEATHER_KAIFUKU(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_MEZAMERU_POWER(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_JIKOANJI(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_MIRAIYOCHI(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_HITCHECK(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_TELEPORT(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_HUKURODATAKI(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_KONOYUBITOMARE(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_TEDASUKE(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_TRICK(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_NEGAIGOTO(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_NEKONOTE(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_MAGIC_CORT(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_MAGIC_CORT_A_D(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_REVENGE(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_KAWARAWARI(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_AKUBI(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_HATAKIOTOSU(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_HUNKA(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_HUUIN(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_ONNEN(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_YOKODORI(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_KETAGURI(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_WEATHER_BALL(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_OIUCHI_CHECK(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_TYPE_CHECK(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_OTF_SET(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_SIOMIZU(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_GIROBALL(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_METALMIRROR(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_TAMEUCHI(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_KIRIHUDA(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_SIBORITORU(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_SAKIDORI(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_MANEKKO(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_OSIOKI(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_HUIUCHI(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_SIDE_CONDITION_CHECK(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_FEINT(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_SURIKOMI(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_TOTTEOKI(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_DOKUBISI(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_DOKUBISI_CHECK(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_KATAYABURI_TOKUSEI_CHECK(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_SIDE_CHECK(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_MONOHIROI(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_TRICKROOM(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_WAZA_OUT_CHECK(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_SOUBI_CHECK(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_SOUBI_PARA_GET(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_HOGOSYOKU(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_SHIZENNOCHIKARA(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_HIMITSUNOCHIKARA(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_SHIZENNOMEGUMI(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_TSUIBAMU(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	WS_NAGETSUKERU(BATTLE_WORK *bw,SERVER_PARAM *sp);

static	BOOL	WS_SEQ_END(BATTLE_WORK *bw,SERVER_PARAM *sp);

//OJ֐
static	int		SkillSeqDataRead(SERVER_PARAM *sp);
static	void	SkillSeqInc(SERVER_PARAM *sp,int cnt);
static	void	SkillSequenceJump(SERVER_PARAM *sp,int arc_kind,int adrs);
static	void	SkillSequenceGosub(SERVER_PARAM *sp,int arc_kind,int adrs);
static	void	*WS_SrcPointerGet(BATTLE_WORK *bw,SERVER_PARAM *sp,int para);
static	int		SideClientNoGet(BATTLE_WORK *bw,SERVER_PARAM *sp,int side);
static	void	MessageParamDataMake(SERVER_PARAM *sp,MESSAGE_PARAM_DATA *mpd);
static	void	MessageParamMake(BATTLE_WORK *bw,SERVER_PARAM *sp,MESSAGE_PARAM_DATA *mpd,MESSAGE_PARAM *mp);
static	int		MessageParamNicknameGet(BATTLE_WORK *bw,SERVER_PARAM *sp,int para);
static	int		MessageParamWazaGet(SERVER_PARAM *sp,int para);
static	int		MessageParamItemGet(SERVER_PARAM *sp,int para);
static	int		MessageParamNumGet(SERVER_PARAM *sp,int para);
static	int		MessageParamTypeGet(SERVER_PARAM *sp,int para);
static	int		MessageParamTokuseiGet(BATTLE_WORK *bw,SERVER_PARAM *sp,int para);
static	int		MessageParamStatusGet(SERVER_PARAM *sp,int para);
static	int		MessageParamConditionGet(SERVER_PARAM *sp,int para);
static	int		MessageParamPokenameGet(BATTLE_WORK *bw,SERVER_PARAM *sp,int para);
static	int		MessageParamPolockGet(SERVER_PARAM *sp,int para);
static	int		MessageParamTasteGet(SERVER_PARAM *sp,int para);
static	int		MessageParamTRTypeGet(BATTLE_WORK *bw,SERVER_PARAM *sp,int para);
static	int		MessageParamTRNameGet(BATTLE_WORK *bw,SERVER_PARAM *sp,int para);
static	u32		OkodukaiCalcAct(BATTLE_WORK *bw,SERVER_PARAM *sp,int num);
static	void	PokeExpCalc(POKEPARTY *ppt,int pos,int mons_no);

//TCB֐
static	void	TCB_GetExp(TCB_PTR tcb,void *work);
static	void	TCB_GetPokemon(TCB_PTR tcb,void *work);

//============================================================================================
/**
 *	߃e[u
 *	waza_seq_def.h̃CfbNXƈ΂ɂȂ悤ɂ
 */
//============================================================================================

static	const	siFunc	SkillIntpTable[]={
	WS_ENCOUNT_EFFECT,
	WS_POKEMON_ENCOUNT,
	WS_POKEMON_APPEAR,
	WS_POKEMON_RETURN,
	WS_POKEMON_DELETE,
	WS_TRAINER_ENCOUNT,
	WS_TRAINER_OUT,
	WS_TRAINER_IN,
	WS_TRAINER_BG_SLIDEIN,
	WS_HP_GAUGE_IN,
	WS_HP_GAUGE_IN_WAIT,
	WS_HP_GAUGE_OUT,
	WS_SERVER_WAIT,
	WS_DAMAGE_CALC,
	WS_ATTACK_MESSAGE,
	WS_MESSAGE,
	WS_MESSAGE_NO_DIR,
	WS_MESSAGE_WORK,
	WS_MESSAGE_PARAM,
	WS_WAZA_EFFECT,
	WS_POKEMON_BLINK,
	WS_HP_CALC,
	WS_HP_GAUGE_CALC,
	WS_KIZETSU_CHECK,
	WS_KIZETSU_EFFECT,
	WS_WAIT,
	WS_SE_PLAY,
	WS_IF,
	WS_IF_PSP,
	WS_FADE_OUT,
	WS_JUMP,
	WS_JUMP_BE_SEQ,
	WS_JUMP_WAZA_WORK,
	WS_CRITICAL_CHECK,
	WS_GET_EXP_CHECK,
	WS_GET_EXP_INIT,
	WS_GET_EXP,
	WS_GET_EXP_LOOP,
	WS_POKEMON_LIST,
	WS_POKEMON_LIST_WAIT,
	WS_POKEMON_RESHUFFLE,
	WS_POKEMON_RESHUFFLE_LOOP,
	WS_POKEMON_GET_INIT,
	WS_POKEMON_GET,
	WS_RENZOKU,
	WS_VALUE,
	WS_ABICNT_CALC,
	WS_PSP_VALUE,
	WS_CONDITION2_OFF,
	WS_VANISH_ON_OFF,
	WS_TOKUSEI_CHECK,
	WS_RANDOM_GET,
	WS_VALUE_WORK,
	WS_PSP_VALUE_WORK,
	WS_BRANCH,
	WS_GOSUB,
	WS_GOSUB_WORK,
	WS_OUMU_CHECK,
	WS_KUROIKIRI,
	WS_KEEP_OFF,
	WS_STATUS_SET,
	WS_TRAINER_MESSAGE,
	WS_OKODUKAI_CALC,
	WS_STATUS_EFFECT,
	WS_STATUS_EFFECT_WORK,
	WS_MODOSU_MESSAGE,
	WS_KURIDASU_MESSAGE,
	WS_TRAINER_MESSAGE_WORK,
	WS_TEXTURE,
	WS_IF_WORK,
	WS_IF_PSP_WORK,
	WS_KOBAN_CHECK,
	WS_HIKARINOKABE,
	WS_RIHUREKUTAA,
	WS_SIROIKIRI,
	WS_ICHIGEKI,
	WS_DAMAGE_DIV,
	WS_DAMAGE_DIV_WORK,
	WS_MONOMANE,
	WS_YUBIWOHURU,
	WS_KANASIBARI,
	WS_COUNTER,
	WS_MIRROR_CORT,
	WS_ENCORE,
	WS_TEXTURE2,
	WS_SKETCH,
	WS_NEGOTO,
	WS_JITABATA,
	WS_URAMI,
	WS_IYASINOSUZU,
	WS_DOROBOU,
	WS_GUARD_SUCCESS_CHECK,
	WS_MIGAWARI,
	WS_HUKITOBASI,
	WS_HENSIN,
	WS_MAKIBISI,
	WS_MAKIBISI_CHECK,
	WS_HOROBINOUTA,
	WS_CLIENT_NO_GET_AGI,
	WS_CLIENT_SET_MAX_LOOP,
	WS_TENKOU_DAMAGE,
	WS_KOROGARU,
	WS_RENZOKUGIRI,
	WS_MEROMERO,
	WS_SHINPI,
	WS_PRESENT,
	WS_MAGNITUDE,
	WS_RESHUFFLE_CHECK,
	WS_KOUSOKUSPIN,
	WS_WEATHER_KAIFUKU,
	WS_MEZAMERU_POWER,
	WS_JIKOANJI,
	WS_MIRAIYOCHI,
	WS_HITCHECK,
	WS_TELEPORT,
	WS_HUKURODATAKI,
	WS_KONOYUBITOMARE,
	WS_TEDASUKE,
	WS_TRICK,
	WS_NEGAIGOTO,
	WS_NEKONOTE,
	WS_MAGIC_CORT,
	WS_MAGIC_CORT_A_D,
	WS_REVENGE,
	WS_KAWARAWARI,
	WS_AKUBI,
	WS_HATAKIOTOSU,
	WS_HUNKA,
	WS_HUUIN,
	WS_ONNEN,
	WS_YOKODORI,
	WS_KETAGURI,
	WS_WEATHER_BALL,
	WS_OIUCHI_CHECK,
	WS_TYPE_CHECK,
	WS_OTF_SET,
	WS_SIOMIZU,
	WS_GIROBALL,
	WS_METALMIRROR,
	WS_TAMEUCHI,
	WS_KIRIHUDA,
	WS_SIBORITORU,
	WS_SAKIDORI,
	WS_MANEKKO,
	WS_OSIOKI,
	WS_HUIUCHI,
	WS_SIDE_CONDITION_CHECK,
	WS_FEINT,
	WS_SURIKOMI,
	WS_TOTTEOKI,
	WS_DOKUBISI,
	WS_DOKUBISI_CHECK,
	WS_KATAYABURI_TOKUSEI_CHECK,
	WS_SIDE_CHECK,
	WS_MONOHIROI,
	WS_TRICKROOM,
	WS_WAZA_OUT_CHECK,
	WS_SOUBI_CHECK,
	WS_SOUBI_PARA_GET,
	WS_HOGOSYOKU,
	WS_SHIZENNOCHIKARA,
	WS_HIMITSUNOCHIKARA,
	WS_SHIZENNOMEGUMI,
	WS_TSUIBAMU,
	WS_NAGETSUKERU,

	WS_SEQ_END
};

//============================================================================================
/**
 *	߉ߊ֐փWv
 *
 * @param[in]	bw	퓬[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
BOOL	SkillIntp(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	return SkillIntpTable[sp->SkillSeqWork[sp->skill_seq_no]](bw,sp);
}

//============================================================================================
//	ߊ֐Q
//============================================================================================
//============================================================================================
/**
 *	GJEgGtFNgZbg
 *
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_ENCOUNT_EFFECT(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	SCIO_EncountEffectSet(bw,CLIENT_NO_MINE);

	return	FALSE;
}

//============================================================================================
/**
 *	GJEgp|PZbg
 *
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 *
 * f[^F
 * 0:GJEg|PZbg鑤̎w(SIDE_ALL:ׂ SIDE_MINE: SIDE_ENEMYF葤)
 */
//============================================================================================
static	BOOL	WS_POKEMON_ENCOUNT(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	client_no;
	int	dir;
	int	client_set_max=BattleWorkClientSetMaxGet(bw);

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//Zbg鑤f[^[h
	dir=SkillSeqDataRead(sp);

	switch(dir){
	default:
	case SIDE_ALL:
		for(client_no=0;client_no<client_set_max;client_no++){
			SCIO_PokemonEncountSet(bw,client_no);
			FT_ZukanFlagSetSee(bw,client_no);
		}
		break;
	case SIDE_MINE:
		OS_Printf("ɂ͂Ȃ͂\n");
		break;
	case SIDE_ENEMY:
		{
			CLIENT_PARAM	*cp;
			for(client_no=0;client_no<client_set_max;client_no++){
				cp=BattleWorkClientParamGet(bw,client_no);
				if(cp->client_type&CLIENT_ENEMY_FLAG){
					SCIO_PokemonEncountSet(bw,client_no);
					FT_ZukanFlagSetSee(bw,client_no);
				}
			}
		}
		break;
	}

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_POKEMON_APPEAR(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	client_no;
	int	dir;
	int	client_set_max=BattleWorkClientSetMaxGet(bw);
	CLIENT_PARAM	*cp;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//Zbg鑤f[^[h
	dir=SkillSeqDataRead(sp);

	switch(dir){
	default:
	case SIDE_ALL:
		for(client_no=0;client_no<client_set_max;client_no++){
			SCIO_PokemonAppearSet(bw,client_no);
			FT_ZukanFlagSetSee(bw,client_no);
		}
		break;
	case SIDE_MINE:
		for(client_no=0;client_no<client_set_max;client_no++){
			cp=BattleWorkClientParamGet(bw,client_no);
			if((cp->client_type&CLIENT_ENEMY_FLAG)==0){
				SCIO_PokemonAppearSet(bw,client_no);
				FT_ZukanFlagSetSee(bw,client_no);
			}
		}
		ST_ServerGetExpRightFlagSet(sp,CLIENT_NO_ENEMY);
		ST_ServerGetExpRightFlagSet(sp,CLIENT_NO_ENEMY2);
		break;
	case SIDE_ENEMY:
		for(client_no=0;client_no<client_set_max;client_no++){
			cp=BattleWorkClientParamGet(bw,client_no);
			if(cp->client_type&CLIENT_ENEMY_FLAG){
				ST_ServerGetExpRightFlagClear(sp,client_no);
				ST_ServerGetExpRightFlagSet(sp,client_no);
				SCIO_PokemonAppearSet(bw,client_no);
				FT_ZukanFlagSetSee(bw,client_no);
			}
		}
		break;
	case SIDE_ATTACK:
		cp=BattleWorkClientParamGet(bw,sp->attack_client);
		if((cp->client_type&CLIENT_ENEMY_FLAG)==0){
			ST_ServerGetExpRightFlagSet(sp,CLIENT_NO_ENEMY);
			ST_ServerGetExpRightFlagSet(sp,CLIENT_NO_ENEMY2);
		}
		else{
			ST_ServerGetExpRightFlagClear(sp,sp->attack_client);
			ST_ServerGetExpRightFlagSet(sp,sp->attack_client);
		}
		FT_ZukanFlagSetSee(bw,sp->attack_client);
		SCIO_PokemonAppearSet(bw,sp->attack_client);
		break;
	case SIDE_DEFENCE:
		cp=BattleWorkClientParamGet(bw,sp->defence_client);
		if((cp->client_type&CLIENT_ENEMY_FLAG)==0){
			ST_ServerGetExpRightFlagSet(sp,CLIENT_NO_ENEMY);
			ST_ServerGetExpRightFlagSet(sp,CLIENT_NO_ENEMY2);
		}
		else{
			ST_ServerGetExpRightFlagClear(sp,sp->defence_client);
			ST_ServerGetExpRightFlagSet(sp,sp->defence_client);
		}
		FT_ZukanFlagSetSee(bw,sp->defence_client);
		SCIO_PokemonAppearSet(bw,sp->defence_client);
		break;
	case SIDE_RESHUFFLE:
		cp=BattleWorkClientParamGet(bw,sp->reshuffle_client);
		if((cp->client_type&CLIENT_ENEMY_FLAG)==0){
			ST_ServerGetExpRightFlagSet(sp,CLIENT_NO_ENEMY);
			ST_ServerGetExpRightFlagSet(sp,CLIENT_NO_ENEMY2);
		}
		else{
			ST_ServerGetExpRightFlagClear(sp,sp->reshuffle_client);
			ST_ServerGetExpRightFlagSet(sp,sp->reshuffle_client);
		}
		FT_ZukanFlagSetSee(bw,sp->reshuffle_client);
		SCIO_PokemonAppearSet(bw,sp->reshuffle_client);
		break;
	}

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_POKEMON_RETURN(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	client_no;
	int	side;
	int	client_set_max=BattleWorkClientSetMaxGet(bw);
	CLIENT_PARAM	*cp;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//Zbg鑤f[^[h
	side=SkillSeqDataRead(sp);

	switch(side){
	case SIDE_ALL:
		for(client_no=0;client_no<client_set_max;client_no++){
			SCIO_PokemonReturnSet(bw,client_no);
		}
		break;
	case SIDE_MINE:
		for(client_no=0;client_no<client_set_max;client_no++){
			cp=BattleWorkClientParamGet(bw,client_no);
			if((cp->client_type&CLIENT_ENEMY_FLAG)==0){
				SCIO_PokemonReturnSet(bw,client_no);
			}
		}
		break;
	case SIDE_ENEMY:
		for(client_no=0;client_no<client_set_max;client_no++){
			cp=BattleWorkClientParamGet(bw,client_no);
			if(cp->client_type&CLIENT_ENEMY_FLAG){
				SCIO_PokemonReturnSet(bw,client_no);
			}
		}
		break;
	default:
		client_no=SideClientNoGet(bw,sp,side);
		SCIO_PokemonReturnSet(bw,client_no);
		break;
	}

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_POKEMON_DELETE(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	client_no;
	int	side;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//side[h
	side=SkillSeqDataRead(sp);

	client_no=SideClientNoGet(bw,sp,side);

	SCIO_PokemonDeleteSet(bw,client_no);

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_TRAINER_ENCOUNT(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	client_no;
	int	dir;
	int	client_set_max=BattleWorkClientSetMaxGet(bw);
	CLIENT_PARAM	*cp;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//Zbg鑤f[^[h
	dir=SkillSeqDataRead(sp);

	switch(dir){
	default:
	case SIDE_ALL:
		for(client_no=0;client_no<client_set_max;client_no++){
			if(((BattleWorkFightTypeGet(bw)&FIGHT_TYPE_MULTI)==0)&&
			    (BattleWorkFightTypeGet(bw)&FIGHT_TYPE_2vs2)&&
				(client_no>1)){
				break;
			}
			SCIO_TrainerEncountSet(bw,client_no);
		}
		break;
	case SIDE_MINE:
		for(client_no=0;client_no<client_set_max;client_no++){
			cp=BattleWorkClientParamGet(bw,client_no);
			if((cp->client_type&CLIENT_ENEMY_FLAG)==0){
				SCIO_TrainerEncountSet(bw,client_no);
				if(((BattleWorkFightTypeGet(bw)&FIGHT_TYPE_MULTI)==0)&&
				    (BattleWorkFightTypeGet(bw)&FIGHT_TYPE_2vs2)){
					break;
				}
			}
		}
		break;
	case SIDE_ENEMY:
		for(client_no=0;client_no<client_set_max;client_no++){
			cp=BattleWorkClientParamGet(bw,client_no);
			if(cp->client_type&CLIENT_ENEMY_FLAG){
				SCIO_TrainerEncountSet(bw,client_no);
				if(((BattleWorkFightTypeGet(bw)&FIGHT_TYPE_MULTI)==0)&&
				    (BattleWorkFightTypeGet(bw)&FIGHT_TYPE_2vs2)){
					break;
				}
			}
		}
		break;
	}

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_TRAINER_OUT(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	client_no;
	int	dir;
	int	client_set_max=BattleWorkClientSetMaxGet(bw);
	CLIENT_PARAM	*cp;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//Zbg鑤f[^[h
	dir=SkillSeqDataRead(sp);

	switch(dir){
	default:
	case SIDE_ALL:
		for(client_no=0;client_no<client_set_max;client_no++){
			if(((BattleWorkFightTypeGet(bw)&FIGHT_TYPE_MULTI)==0)&&
			    (BattleWorkFightTypeGet(bw)&FIGHT_TYPE_2vs2)&&
				(client_no>1)){
				break;
			}
			SCIO_TrainerOutSet(bw,client_no);
		}
		break;
	case SIDE_MINE:
		for(client_no=0;client_no<client_set_max;client_no++){
			cp=BattleWorkClientParamGet(bw,client_no);
			if((cp->client_type&CLIENT_ENEMY_FLAG)==0){
				SCIO_TrainerOutSet(bw,client_no);
				if(((BattleWorkFightTypeGet(bw)&FIGHT_TYPE_MULTI)==0)&&
				    (BattleWorkFightTypeGet(bw)&FIGHT_TYPE_2vs2)){
					break;
				}
			}
		}
		break;
	case SIDE_ENEMY:
		for(client_no=0;client_no<client_set_max;client_no++){
			cp=BattleWorkClientParamGet(bw,client_no);
			if(cp->client_type&CLIENT_ENEMY_FLAG){
				SCIO_TrainerOutSet(bw,client_no);
				if(((BattleWorkFightTypeGet(bw)&FIGHT_TYPE_MULTI)==0)&&
				    (BattleWorkFightTypeGet(bw)&FIGHT_TYPE_2vs2)){
					break;
				}
			}
		}
		break;
	}

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_TRAINER_IN(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	client_no;
	int	dir;
	int	pos;
	int	client_set_max=BattleWorkClientSetMaxGet(bw);
	CLIENT_PARAM	*cp;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//Zbg鑤f[^[h
	dir=SkillSeqDataRead(sp);

	//oʒuf[^[h
	pos=SkillSeqDataRead(sp);

	switch(dir){
	default:
	case SIDE_ALL:
		for(client_no=0;client_no<client_set_max;client_no++){
			if((BattleWorkFightTypeGet(bw)&FIGHT_TYPE_2vs2)&&(client_no>1)){
				break;
			}
			SCIO_TrainerInSet(bw,client_no,pos);
		}
		break;
	case SIDE_MINE:
		for(client_no=0;client_no<client_set_max;client_no++){
			cp=BattleWorkClientParamGet(bw,client_no);
			if((cp->client_type&CLIENT_ENEMY_FLAG)==0){
				SCIO_TrainerInSet(bw,client_no,pos);
				if(BattleWorkFightTypeGet(bw)&FIGHT_TYPE_2vs2){
					break;
				}
			}
		}
		break;
	case SIDE_ENEMY:
		for(client_no=0;client_no<client_set_max;client_no++){
			cp=BattleWorkClientParamGet(bw,client_no);
			if(cp->client_type&CLIENT_ENEMY_FLAG){
				SCIO_TrainerInSet(bw,client_no,pos);
				if(BattleWorkFightTypeGet(bw)&FIGHT_TYPE_2vs2){
					break;
				}
			}
		}
		break;
	case SIDE_MINE_1:
		for(client_no=0;client_no<client_set_max;client_no++){
			cp=BattleWorkClientParamGet(bw,client_no);
			if((cp->client_type==CLIENT_TYPE_AA)||(cp->client_type==CLIENT_TYPE_A)){
				SCIO_TrainerInSet(bw,client_no,pos);
				break;
			}
		}
		break;
	case SIDE_ENEMY_1:
		for(client_no=0;client_no<client_set_max;client_no++){
			cp=BattleWorkClientParamGet(bw,client_no);
			if((cp->client_type==CLIENT_TYPE_BB)||(cp->client_type==CLIENT_TYPE_B)){
				SCIO_TrainerInSet(bw,client_no,pos);
				break;
			}
		}
		break;
	case SIDE_MINE_2:
		for(client_no=0;client_no<client_set_max;client_no++){
			cp=BattleWorkClientParamGet(bw,client_no);
			if(cp->client_type==CLIENT_TYPE_C){
				SCIO_TrainerInSet(bw,client_no,pos);
				break;
			}
		}
		break;
	case SIDE_ENEMY_2:
		for(client_no=0;client_no<client_set_max;client_no++){
			cp=BattleWorkClientParamGet(bw,client_no);
			if(cp->client_type==CLIENT_TYPE_D){
				SCIO_TrainerInSet(bw,client_no,pos);
				break;
			}
		}
		break;
	}

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_TRAINER_BG_SLIDEIN(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	client_no;
	int	client_set_max=BattleWorkClientSetMaxGet(bw);

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	for(client_no=0;client_no<client_set_max;client_no++){
		SCIO_TrainerBGSlideInSet(bw,client_no);
	}

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_HP_GAUGE_IN(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	client_no;
	int	side;
	int	client_set_max=BattleWorkClientSetMaxGet(bw);
	CLIENT_PARAM	*cp;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//Zbg鑤f[^[h
	side=SkillSeqDataRead(sp);

	switch(side){
	case SIDE_ALL:
		for(client_no=0;client_no<client_set_max;client_no++){
			SCIO_HPGaugeInSet(bw,sp,client_no,0);
		}
		break;
	case SIDE_MINE:
		for(client_no=0;client_no<client_set_max;client_no++){
			cp=BattleWorkClientParamGet(bw,client_no);
			if((cp->client_type&CLIENT_ENEMY_FLAG)==0){
				SCIO_HPGaugeInSet(bw,sp,client_no,0);
			}
		}
		break;
	case SIDE_ENEMY:
		for(client_no=0;client_no<client_set_max;client_no++){
			cp=BattleWorkClientParamGet(bw,client_no);
			if(cp->client_type&CLIENT_ENEMY_FLAG){
				SCIO_HPGaugeInSet(bw,sp,client_no,0);
			}
		}
		break;
	default:
		client_no=SideClientNoGet(bw,sp,side);
		SCIO_HPGaugeInSet(bw,sp,client_no,0);
		break;
	}

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_HP_GAUGE_IN_WAIT(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	client_no;
	int	side;
	int	client_set_max=BattleWorkClientSetMaxGet(bw);
	CLIENT_PARAM	*cp;
	u8	wait;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//Zbg鑤f[^[h
	side=SkillSeqDataRead(sp);

	wait=0;

	switch(side){
	case SIDE_ALL:
		for(client_no=0;client_no<client_set_max;client_no++){
			SCIO_HPGaugeInSet(bw,sp,client_no,0);
		}
		break;
	case SIDE_MINE:
		for(client_no=0;client_no<client_set_max;client_no++){
			cp=BattleWorkClientParamGet(bw,client_no);
			if((cp->client_type&CLIENT_ENEMY_FLAG)==0){
				SCIO_HPGaugeInSet(bw,sp,client_no,wait);
				wait+=HP_GAUGE_IN_WAIT;
			}
		}
		break;
	case SIDE_ENEMY:
		for(client_no=0;client_no<client_set_max;client_no++){
			cp=BattleWorkClientParamGet(bw,client_no);
			if(cp->client_type&CLIENT_ENEMY_FLAG){
				SCIO_HPGaugeInSet(bw,sp,client_no,wait);
				wait+=HP_GAUGE_IN_WAIT;
			}
		}
		break;
	default:
		client_no=SideClientNoGet(bw,sp,side);
		SCIO_HPGaugeInSet(bw,sp,client_no,wait);
		break;
	}

	return	FALSE;
}


//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_HP_GAUGE_OUT(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	client_no;
	int	side;
	int	client_set_max=BattleWorkClientSetMaxGet(bw);
	CLIENT_PARAM	*cp;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//Zbg鑤f[^[h
	side=SkillSeqDataRead(sp);

	switch(side){
	case SIDE_ALL:
		for(client_no=0;client_no<client_set_max;client_no++){
			SCIO_HPGaugeOutSet(bw,client_no);
		}
		break;
	case SIDE_MINE:
		for(client_no=0;client_no<client_set_max;client_no++){
			cp=BattleWorkClientParamGet(bw,client_no);
			if((cp->client_type&CLIENT_ENEMY_FLAG)==0){
				SCIO_HPGaugeOutSet(bw,client_no);
			}
		}
		break;
	case SIDE_ENEMY:
		for(client_no=0;client_no<client_set_max;client_no++){
			cp=BattleWorkClientParamGet(bw,client_no);
			if(cp->client_type&CLIENT_ENEMY_FLAG){
				SCIO_HPGaugeOutSet(bw,client_no);
			}
		}
		break;
	default:
		client_no=SideClientNoGet(bw,sp,side);
		SCIO_HPGaugeOutSet(bw,client_no);
		break;
	}

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_SERVER_WAIT(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	if(ST_ServerQueCheck(sp)){
		SkillSeqInc(sp,1);
	}

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_DAMAGE_CALC(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	type;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	sp->damage=WT_WazaDamageCalc(bw,sp,
								 sp->waza_no_now,
								 sp->side_condition[BattleWorkMineEnemyCheck(bw,sp->defence_client)],
								 sp->field_condition,
								 sp->damage_power,
								 0,
								 sp->attack_client,sp->defence_client,sp->critical);
	sp->damage*=sp->critical;		//NeBJqbgɂ_[WvZ

	GF_ASSERT_MSG(sp->damage_value>=10,"damage_value Under 10!\n");

	sp->damage=sp->damage*sp->damage_value/10;	//Zɂ_[W{[Nɂ_[WvZ

	//イł񒆂͗̓_[W2{
	if((sp->psp[sp->attack_client].waza_kouka&WAZAKOUKA_JUUDEN)&&
	   (WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_wazatype)==ELECTRIC_TYPE)){	
		sp->damage*=2;
	}

	//Ă̓_[W1.5{
	if(sp->otf[sp->attack_client].tedasuke_flag){	
		sp->damage=sp->damage*15/10;
	}


	//ʈЗ̓Abv́AЗ́_[WʃAbv
	if(ST_ServerSoubiEqpGet(sp,sp->attack_client)==SOUBI_WAZAIRYOKUUPHPMAINASU){
		sp->damage=sp->damage*(100+ST_ServerSoubiAtkGet(sp,sp->attack_client))/100;
	}

	sp->damage=WT_DamageLossCalc(sp->damage);
	sp->damage*=-1;

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_ATTACK_MESSAGE(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

#if 0
	//AU̎́Aŏ1ڂ\
	if((sp->loop_flag==0)&&
	//A^bNbZ[W\ȂtOĂ鎞́A\Ȃ
	  ((sp->server_status_flag&SERVER_STATUS_FLAG_NO_ATTACK_MSG)==0)){
		SCIO_AttackMessageSet(bw,sp);
	}
#endif
	//A^bNbZ[W\ȂtOĂ鎞́A\Ȃ
	if((sp->server_status_flag&SERVER_STATUS_FLAG_NO_ATTACK_MSG)==0){
		SCIO_AttackMessageSet(bw,sp);
	}
	//\ȂtOON
	sp->server_status_flag|=SERVER_STATUS_FLAG_NO_ATTACK_MSG;

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_MESSAGE(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	MESSAGE_PARAM_DATA	mpd;
	MESSAGE_PARAM		mp;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	MessageParamDataMake(sp,&mpd);
	MessageParamMake(bw,sp,&mpd,&mp);

	SCIO_MessageSet(bw,sp,&mp);

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_MESSAGE_NO_DIR(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	MESSAGE_PARAM_DATA	mpd;
	MESSAGE_PARAM		mp;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	MessageParamDataMake(sp,&mpd);
	MessageParamMake(bw,sp,&mpd,&mp);

	mp.msg_tag|=TAG_NO_DIR;

	SCIO_MessageSet(bw,sp,&mp);

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_MESSAGE_WORK(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	SCIO_MessageSet(bw,sp,&sp->mp);

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_MESSAGE_PARAM(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	MESSAGE_PARAM_DATA	mpd;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	MessageParamDataMake(sp,&mpd);
	MessageParamMake(bw,sp,&mpd,&sp->mp);

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_WAZA_EFFECT(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//ZGtFNg\ȂtOĂ鎞́A\Ȃ
	if((sp->server_status_flag&SERVER_STATUS_FLAG_NO_WAZA_EFFECT)==0){
		sp->server_status_flag|=SERVER_STATUS_FLAG_NO_WAZA_EFFECT;
		SCIO_WazaEffectSet(bw,sp);
	}

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_POKEMON_BLINK(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	side;
	int	client_no;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//Zbg鑤f[^[h
	side=SkillSeqDataRead(sp);

	client_no=SideClientNoGet(bw,sp,side);

	SCIO_PokemonBlinkSet(bw,client_no);

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_HP_CALC(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	side,client_no;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//vZ鑤f[^[h
	side=SkillSeqDataRead(sp);

	client_no=SideClientNoGet(bw,sp,side);

	sp->psp[client_no].hp+=sp->hp_calc_work;
	if(sp->psp[client_no].hp<0){
		sp->psp[client_no].hp=0;
	}
	else if(sp->psp[client_no].hp>sp->psp[client_no].hpmax){
		sp->psp[client_no].hp=sp->psp[client_no].hpmax;
	}
	ST_PSPtoPPCopy(bw,sp,client_no);

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_HP_GAUGE_CALC(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	side,client_no;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//vZ鑤f[^[h
	side=SkillSeqDataRead(sp);

	client_no=SideClientNoGet(bw,sp,side);

	SCIO_HPGaugeCalcSet(bw,sp,client_no);

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_KIZETSU_CHECK(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	side,client_no,adrs;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//vZ鑤f[^[h
	side=SkillSeqDataRead(sp);

	client_no=SideClientNoGet(bw,sp,side);

	if(sp->psp[client_no].hp==0){
		sp->kizetsu_client=client_no;
		sp->server_status_flag|=(No2Bit(client_no)<<SERVER_STATUS_FLAG_KIZETSU_SHIFT);
	}

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_KIZETSU_EFFECT(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	SCIO_KizetsuEffectSet(bw,sp,sp->kizetsu_client);

	ST_ServerKizetsuWorkInit(bw,sp,sp->kizetsu_client);

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_WAIT(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	wait;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//WAIT_TIME[h
	wait=SkillSeqDataRead(sp);

	if(wait!=sp->wait_cnt){
		//V[PXJE^𖽗߃R[h܂ł܂߂
		SkillSeqInc(sp,-2);
		sp->wait_cnt++;
	}
	else{
		sp->wait_cnt=0;
	}

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_SE_PLAY(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	se_no;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//se_no[h
	se_no=SkillSeqDataRead(sp);

	SCIO_SePlaySet(bw,sp,se_no);

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_IF(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	act;
	int	src;
	int	dest;
	int	adrs;
	int	*data;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//act[h
	act=SkillSeqDataRead(sp);

	//src[h
	src=SkillSeqDataRead(sp);

	//dest[h
	dest=SkillSeqDataRead(sp);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	data=WS_SrcPointerGet(bw,sp,src);

	switch(act){
	case IF_FLAG_EQ:		//v
		if(data[0]!=dest){
			adrs=0;
		}
		break;
	case IF_FLAG_NE:		//sv
		if(data[0]==dest){
			adrs=0;
		}
		break;
	case IF_FLAG_C:			//
		if(data[0]<=dest){
			adrs=0;
		}
		break;
	case IF_FLAG_NC:		//ȉ
		if(data[0]>dest){
			adrs=0;
		}
		break;
	case IF_FLAG_BIT:		//rbgON
		if((data[0]&dest)==0){
			adrs=0;
		}
		break;
	case IF_FLAG_NBIT:		//rbgOFF
		if(data[0]&dest){
			adrs=0;
		}
		break;
	case IF_FLAG_AND:		//rbgMASKĊSv邩H
		if((data[0]&dest)!=dest){
			adrs=0;
		}
		break;
	default:
		GF_ASSERT_MSG(TRUE,"sȒ`ł\n");
		break;
	}
	if(adrs){
		SkillSeqInc(sp,adrs);
	}
	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_IF_PSP(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	act;
	int	side;
	int	src;
	int	dest;
	int	adrs;
	int	data;
	int	client_no;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//act[h
	act=SkillSeqDataRead(sp);

	//side[h
	side=SkillSeqDataRead(sp);

	//src[h
	src=SkillSeqDataRead(sp);

	//dest[h
	dest=SkillSeqDataRead(sp);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	client_no=SideClientNoGet(bw,sp,side);

	data=ST_ServerPokemonServerParamGet(sp,client_no,src,NULL);

	switch(act){
	case IF_FLAG_EQ:		//v
		if(data!=dest){
			adrs=0;
		}
		break;
	case IF_FLAG_NE:		//sv
		if(data==dest){
			adrs=0;
		}
		break;
	case IF_FLAG_C:			//
		if(data<=dest){
			adrs=0;
		}
		break;
	case IF_FLAG_NC:		//ȉ
		if(data>dest){
			adrs=0;
		}
		break;
	case IF_FLAG_BIT:		//rbgON
		if((data&dest)==0){
			adrs=0;
		}
		break;
	case IF_FLAG_NBIT:		//rbgOFF
		if(data&dest){
			adrs=0;
		}
		break;
	case IF_FLAG_AND:		//rbgMASKĊSv邩H
		if((data&dest)!=dest){
			adrs=0;
		}
		break;
	default:
		GF_ASSERT_MSG(TRUE,"sȒ`ł\n");
		break;
	}
	if(adrs){
		SkillSeqInc(sp,adrs);
	}
	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_FADE_OUT(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	SCIO_FadeOutSet(bw,sp);
	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_JUMP(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	seq_no;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//be_seq_no[h
	seq_no=SkillSeqDataRead(sp);

	SkillSequenceJump(sp,ARC_SUB_SEQ,seq_no);

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_JUMP_BE_SEQ(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	adrs;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//ѐQbg
	adrs=WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_battleeffect);

	SkillSequenceJump(sp,ARC_BE_SEQ,adrs);

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_JUMP_WAZA_WORK(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	adrs;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//ѐQbg
	adrs=WT_WazaDataParaGet(sp->waza_work,ID_WTD_battleeffect);

	//ATTACK_MESSAGEo悤ɃtO𗎂Ƃ
	sp->server_status_flag&=SERVER_STATUS_FLAG_NO_ATTACK_MSG_OFF;

	sp->waza_no_now=sp->waza_work;

	sp->defence_client=ST_ServerDefenceClientSet(bw,sp,sp->attack_client,sp->waza_work,1,0);

	SkillSequenceJump(sp,ARC_BE_SEQ,adrs);

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_CRITICAL_CHECK(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	sp->critical=WT_CriticalCheck(sp,sp->attack_client,sp->defence_client,sp->critical_count);

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_GET_EXP_CHECK(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int				adrs;
	u32				fight_type=BattleWorkFightTypeGet(bw);
	CLIENT_PARAM	*cp=BattleWorkClientParamGet(bw,sp->kizetsu_client);

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//olQbgȂƂ̂Ƃѐ[h
	adrs=SkillSeqDataRead(sp);

	if((cp->client_type&CLIENT_ENEMY_FLAG)&&((fight_type&FIGHT_TYPE_NO_EXP)==0)){
		{
			int	i;
			int	total_exp;
			int	get_exp_poke_total=0;
			int	get_exp_item_total=0;
			u16	itemno;
			u16	totalexp;
			u8	eqp;
			POKEMON_PARAM	*pp;

			//莝|PwKuĂ邩`FbN
			for(i=0;i<PokeParty_GetPokeCount(BattleWorkPokePartyGet(bw,CLIENT_NO_MINE));i++){
				pp=BattleWorkPokemonParamGet(bw,CLIENT_NO_MINE,i);
				if((PokeParaGet(pp,ID_PARA_monsno,NULL))&&(PokeParaGet(pp,ID_PARA_hp,NULL))){
					if(sp->get_exp_right_flag[(sp->kizetsu_client>>1)&1]&No2Bit(i)){
						get_exp_poke_total++;
					}
					itemno=PokeParaGet(pp,ID_PARA_item,NULL);
					eqp=ItemParamGet(itemno,ITEM_PRM_EQUIP,HEAPID_BATTLE);
					if(eqp==SOUBI_KEIKENTIGET){
						get_exp_item_total++;
					}
				}
			}
			totalexp=PokePersonalParaGet(sp->psp[sp->kizetsu_client].monsno,ID_PER_give_exp);
			totalexp=(totalexp*sp->psp[sp->kizetsu_client].level)/7;
			if(get_exp_item_total){
				sp->get_exp=(totalexp/2)/get_exp_poke_total;
				if(sp->get_exp==0){
					sp->get_exp=1;
				}
				sp->gakusyuu_get_exp=(totalexp/2)/get_exp_item_total;
				if(sp->gakusyuu_get_exp==0){
					sp->gakusyuu_get_exp=1;
				}
			}
			else{
				sp->get_exp=totalexp/get_exp_poke_total;
				if(sp->get_exp==0){
					sp->get_exp=1;
				}
				sp->gakusyuu_get_exp=0;
			}
		}
	}
	else{
		SkillSeqInc(sp,adrs);
	}

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_GET_EXP_INIT(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	sp->tsiw=(TCB_SKILL_INTP_WORK *)sys_AllocMemory(HEAPID_BATTLE,sizeof(TCB_SKILL_INTP_WORK));
	sp->tsiw->bw=bw;
	sp->tsiw->sp=sp;
	sp->tsiw->seq_no=0;
	TCB_Add(TCB_GetExp,sp->tsiw,NULL);

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_GET_EXP(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	if(sp->tsiw==NULL){
		//߃R[hǂݔ΂
		SkillSeqInc(sp,1);
	}

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_GET_EXP_LOOP(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	adrs;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//olQbg[vȂƂ̂Ƃѐ[h
	adrs=SkillSeqDataRead(sp);

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_POKEMON_LIST(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	client_no;
	int	client_set_max=BattleWorkClientSetMaxGet(bw);

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	for(client_no=0;client_no<client_set_max;client_no++){
		if(sp->client_status[client_no]&CLIENT_STATUS_POKE_RESHUFFLE){
			SCIO_PokemonSelectSet(bw,sp,client_no,BPL_MODE_NO_CANCEL,0);
		}
	}

	for(client_no=0;client_no<client_set_max;client_no++){
		if(sp->client_status[client_no]&CLIENT_STATUS_POKE_RESHUFFLE){
			sp->reshuffle_client=client_no;
			break;
		}
	}

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_POKEMON_LIST_WAIT(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	client_no;
	int	client_set_max;
	int	reshuffle_count;

	client_set_max=BattleWorkClientSetMaxGet(bw);
	reshuffle_count=0;

	for(client_no=0;client_no<client_set_max;client_no++){
		if(sp->client_status[client_no]&CLIENT_STATUS_POKE_RESHUFFLE){
			reshuffle_count++;
		}
	}

	for(client_no=0;client_no<client_set_max;client_no++){
		if((sp->client_status[client_no]&CLIENT_STATUS_POKE_RESHUFFLE)&&(sp->server_buffer[client_no][0])){
			sp->reshuffle_sel_mons_no[client_no]=sp->server_buffer[client_no][0]-1;
			reshuffle_count--;
		}
	}

	if(reshuffle_count==0){
		//߃R[hǂݔ΂
		SkillSeqInc(sp,1);
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_POKEMON_RESHUFFLE(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	client_no;
	int	side;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//Zbg鑤f[^[h
	side=SkillSeqDataRead(sp);

	switch(side){
	default:
		OS_Printf("WS_POKEMON_RESHUFFLE:ɂ̂͂\n");
		break;
	case SIDE_ATTACK:
		client_no=sp->attack_client;
		sp->sel_mons_no[sp->attack_client]=sp->reshuffle_sel_mons_no[sp->attack_client];
		ST_PokemonParamGet(bw,sp,sp->attack_client,sp->sel_mons_no[sp->attack_client]);
		break;
	case SIDE_RESHUFFLE:
		client_no=sp->reshuffle_client;
		sp->sel_mons_no[sp->reshuffle_client]=sp->reshuffle_sel_mons_no[sp->reshuffle_client];
		ST_ServerBufferClear(sp,sp->reshuffle_client);
		ST_PokemonParamGet(bw,sp,sp->reshuffle_client,sp->sel_mons_no[sp->reshuffle_client]);
		break;
	case SIDE_HUKITOBASI:
		client_no=sp->defence_client;
		ST_PokemonParamGet(bw,sp,sp->defence_client,sp->sel_mons_no[sp->defence_client]);
		break;
	}
	ST_ServerReshuffleWorkInit(bw,sp,client_no);

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_POKEMON_RESHUFFLE_LOOP(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	client_no;
	int	client_set_max=BattleWorkClientSetMaxGet(bw);
	int	adrs;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//|Pւ[vȂƂ̔ѐ[h
	adrs=SkillSeqDataRead(sp);

	sp->client_status[sp->reshuffle_client]&=CLIENT_STATUS_POKE_RESHUFFLE_OFF;

	for(client_no=0;client_no<client_set_max;client_no++){
		if(sp->client_status[client_no]&CLIENT_STATUS_POKE_RESHUFFLE){
			sp->reshuffle_client=client_no;
			SkillSeqInc(sp,adrs);
			break;
		}
	}

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_POKEMON_GET_INIT(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	sp->tsiw=(TCB_SKILL_INTP_WORK *)sys_AllocMemory(HEAPID_BATTLE,sizeof(TCB_SKILL_INTP_WORK));
	sp->tsiw->bw=bw;
	sp->tsiw->sp=sp;
	sp->tsiw->seq_no=0;
	TCB_Add(TCB_GetPokemon,sp->tsiw,NULL);

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_POKEMON_GET(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	if(sp->tsiw==NULL){
		//߃R[hǂݔ΂
		SkillSeqInc(sp,1);
	}

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_RENZOKU(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	para;
	int	flag;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//[vp[^[h
	para=SkillSeqDataRead(sp);

	//HITCHECKLtO[h
	flag=SkillSeqDataRead(sp);

	if(sp->renzoku_count_temp==0){
		if(para==0){
			//XLŃAAUJE^őɂ
			if(ST_ServerTokuseiGet(sp,sp->attack_client)==TOKUSYU_SUKIRURINKU){
				para=5;
			}
			else{
				if((para=gf_rand()&3)<2){
					para+=2;
				}
				else{
					para=(gf_rand()&3)+2;
				}
			}
		}
		sp->renzoku_count=para;
		sp->renzoku_count_temp=para;
		sp->loop_hit_check=flag;
	}

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_VALUE(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	act;
	int	src;
	int	value;
	int	*data;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//act[h
	act=SkillSeqDataRead(sp);

	//src[h
	src=SkillSeqDataRead(sp);

	//value[h
	value=SkillSeqDataRead(sp);

	data=WS_SrcPointerGet(bw,sp,src);

	switch(act){
	case VAL_SET:		//Zbg
		data[0]=value;
		break;
	case VAL_ADD:		//Z
		data[0]+=value;
		break;
	case VAL_SUB:		//Z
		data[0]-=value;
		break;
	case VAL_BIT:		//OR
		data[0]|=value;
		break;
	case VAL_NBIT:		//lrbg]AND
		data[0]&=(value^0xffffffff);
		break;
	case VAL_MUL:		//|Z
		data[0]*=value;
		break;
	case VAL_DIV:		//Z
		data[0]/=value;
		break;
	case VAL_LSH:		//Vtg
		data[0]=data[0]<<value;
		break;
	case VAL_RSH:		//EVtg
		data[0]=data[0]>>value;
		break;
	case VAL_TO_BIT:	//lrbgɕϊ
		data[0]=No2Bit(value);
		break;
	case VAL_GET:		//l擾
		GF_ASSERT_MSG(0,"VAL_GET͎wł܂");
		break;
	case VAL_SUB_ZERO:	//Z
		data[0]-=value;
		if(data[0]<0){
			data[0]=0;
		}
		break;
	case VAL_XOR:		//XOR
		data[0]^=value;
		break;
	default:
		GF_ASSERT_MSG(0,"sȒ`ł\n");
		break;
	}

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_ABICNT_CALC(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	adrs1;
	int	adrs2;
	int	para;
	int	value;
	u32	flag;
	POKEMON_SERVER_PARAM	*psp=&sp->psp[sp->tsuika_client];

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//adrs[h
	adrs1=SkillSeqDataRead(sp);
	adrs2=SkillSeqDataRead(sp);

	flag=sp->tsuika_para&ADD_STATUS_NO_TOKUSEI;
	sp->tsuika_para&=(ADD_STATUS_NO_TOKUSEI^0xffffffff);

	//abiritycntグoȂtO
	sp->server_status_flag&=SERVER_STATUS_FLAG_COND_CHG_NG_OFF;

	//2iKDOWN
	if(sp->tsuika_para>=ADD_COND2_POWDOWN2){
		para=sp->tsuika_para-ADD_COND2_POWDOWN2;
		value=-2;
		sp->temp_work=STATUS_EFF_DOWN;
	}
	//2iKUP
	else if(sp->tsuika_para>=ADD_COND2_POWUP2){
		para=sp->tsuika_para-ADD_COND2_POWUP2;
		value=2;
		sp->temp_work=STATUS_EFF_UP;
	}
	//1iKDOWN
	else if(sp->tsuika_para>=ADD_COND2_POWDOWN){
		para=sp->tsuika_para-ADD_COND2_POWDOWN;
		value=-1;
		sp->temp_work=STATUS_EFF_DOWN;
	}
	//1iKUP
	else{
		para=sp->tsuika_para-ADD_COND2_POWUP;
		value=1;
		sp->temp_work=STATUS_EFF_UP;
	}
	if(value>0){
		if(psp->abiritycnt[COND_POW+para]==12){
			//abiritycntグoȂtOZbg
			sp->server_status_flag|=SERVER_STATUS_FLAG_COND_CHG_NG;
			if((sp->tsuika_type==ADD_STATUS_INDIRECT)||
			   (sp->tsuika_type==ADD_STATUS_TOKUSEI)){
				SkillSeqInc(sp,adrs2);
			}
			else{
				sp->mp.msg_id=StatusNoUpMineMsg;
				sp->mp.msg_tag=TAG_NICK_STAT;
				sp->mp.msg_para[0]=ST_ServerTagNickParaMake(sp,sp->tsuika_client);
				sp->mp.msg_para[1]=COND_POW+para;
				SkillSeqInc(sp,adrs1);
			}
		}
		else{
			if(sp->tsuika_type==ADD_STATUS_TOKUSEI){
				sp->mp.msg_id=TokuseiStatusUpMineMsg;
				sp->mp.msg_tag=TAG_NICK_TOKU_STAT;
				sp->mp.msg_para[0]=ST_ServerTagNickParaMake(sp,sp->tsuika_client);
				sp->mp.msg_para[1]=sp->psp[sp->tsuika_client].speabino;
				sp->mp.msg_para[2]=COND_POW+para;
			}
			else if(sp->tsuika_type==ADD_STATUS_SOUBIITEM){
				sp->mp.msg_id=ItemCondUp1MineMsg;
				sp->mp.msg_tag=TAG_NICK_ITEM_STAT;
				sp->mp.msg_para[0]=ST_ServerTagNickParaMake(sp,sp->tsuika_client);
				sp->mp.msg_para[1]=sp->item_work;
				sp->mp.msg_para[2]=COND_POW+para;
			}
			else{
				sp->mp.msg_id=(value==1?CondUp1MineMsg:CondUp2MineMsg);
				sp->mp.msg_tag=TAG_NICK_STAT;
				sp->mp.msg_para[0]=ST_ServerTagNickParaMake(sp,sp->tsuika_client);
				sp->mp.msg_para[1]=COND_POW+para;
			}
			psp->abiritycnt[COND_POW+para]+=value;
			if(psp->abiritycnt[COND_POW+para]>12){
				psp->abiritycnt[COND_POW+para]=12;
			}
		}
	}
	else{
		if(psp->abiritycnt[COND_POW+para]==0){
			//abiritycntグoȂtOZbg
			sp->server_status_flag|=SERVER_STATUS_FLAG_COND_CHG_NG;
			if((sp->tsuika_type==ADD_STATUS_INDIRECT)||
			   (sp->tsuika_type==ADD_STATUS_TOKUSEI)){
				SkillSeqInc(sp,adrs2);
			}
			else{
				sp->mp.msg_id=StatusNoDownMineMsg;
				sp->mp.msg_tag=TAG_NICK_STAT;
				sp->mp.msg_para[0]=ST_ServerTagNickParaMake(sp,sp->tsuika_client);
				sp->mp.msg_para[1]=COND_POW+para;
				SkillSeqInc(sp,adrs1);
			}
		}
		else{
			if((flag&ADD_STATUS_NO_TOKUSEI)==0){
				//\͒ቺꍇ́AZʂł͖hȂ
				if(sp->attack_client!=sp->tsuika_client){
					//낢́A\͒ቺ󂯂Ȃ
					if(sp->scw[BattleWorkMineEnemyCheck(bw,sp->tsuika_client)].shiroikiri_count){
						sp->mp.msg_id=ShiroikiriGuardMineMsg;
						sp->mp.msg_tag=TAG_NICK;
						sp->mp.msg_para[0]=ST_ServerTagNickParaMake(sp,sp->tsuika_client);
						flag=1;
					}
					//NA{fBA낢ނ́A\͒ቺ󂯂Ȃ
					else if((ST_ServerKatayaburiTokuseiCheck(sp,sp->attack_client,sp->tsuika_client,TOKUSYU_KURIABODHI)==TRUE)||
							(ST_ServerKatayaburiTokuseiCheck(sp,sp->attack_client,sp->tsuika_client,TOKUSYU_SIROIKEMURI)==TRUE)){
						if(sp->tsuika_type==ADD_STATUS_TOKUSEI){
							sp->mp.msg_id=TokuseiNoTokuseiM2MMsg;
							sp->mp.msg_tag=TAG_NICK_TOKU_NICK_TOKU;
							sp->mp.msg_para[0]=ST_ServerTagNickParaMake(sp,sp->tsuika_client);
							sp->mp.msg_para[1]=sp->psp[sp->tsuika_client].speabino;
							sp->mp.msg_para[2]=ST_ServerTagNickParaMake(sp,sp->attack_client);
							sp->mp.msg_para[3]=sp->psp[sp->attack_client].speabino;
						}
						else{
							sp->mp.msg_id=ClearBodyMineMsg;
							sp->mp.msg_tag=TAG_NICK_TOKU;
							sp->mp.msg_para[0]=ST_ServerTagNickParaMake(sp,sp->tsuika_client);
							sp->mp.msg_para[1]=sp->psp[sp->tsuika_client].speabino;
						}
						flag=1;
					}
					//ǂ߂́AȂ
					//肫oT~́AU͂Ȃ
					else if( ((ST_ServerKatayaburiTokuseiCheck(sp,sp->attack_client,sp->tsuika_client,TOKUSYU_SURUDOIME)==TRUE)&&
							 ((COND_POW+para)==COND_HIT))||
							 ((ST_ServerKatayaburiTokuseiCheck(sp,sp->attack_client,sp->tsuika_client,TOKUSYU_KAIRIKIBASAMI)==TRUE)&&
							 ((COND_POW+para)==COND_POW))){
						if(sp->tsuika_type==ADD_STATUS_TOKUSEI){
							sp->mp.msg_id=TokuseiNoTokuseiM2MMsg;
							sp->mp.msg_tag=TAG_NICK_TOKU_NICK_TOKU;
							sp->mp.msg_para[0]=ST_ServerTagNickParaMake(sp,sp->tsuika_client);
							sp->mp.msg_para[1]=sp->psp[sp->tsuika_client].speabino;
							sp->mp.msg_para[2]=ST_ServerTagNickParaMake(sp,sp->attack_client);
							sp->mp.msg_para[3]=sp->psp[sp->attack_client].speabino;
						}
						else{
							sp->mp.msg_id=TokuseiNoCondDownMineMsg;
							sp->mp.msg_tag=TAG_NICK_TOKU_STAT;
							sp->mp.msg_para[0]=ST_ServerTagNickParaMake(sp,sp->tsuika_client);
							sp->mp.msg_para[1]=sp->psp[sp->tsuika_client].speabino;
							sp->mp.msg_para[2]=COND_POW+para;
						}
						flag=1;
					}
					//Ղ́Aǉʂ󂯂Ȃ
					else if((ST_ServerKatayaburiTokuseiCheck(sp,sp->attack_client,sp->tsuika_client,TOKUSYU_RINPUN)==TRUE)&&
							(sp->tsuika_type==ADD_STATUS_INDIRECT)){
						flag=1;
					}
				}
				if((flag)&&(sp->tsuika_type==ADD_STATUS_INDIRECT)){
					SkillSeqInc(sp,adrs2);
					return FALSE;
				}
				else if(flag){
					SkillSeqInc(sp,adrs1);
					return FALSE;
				}
			}
			if(sp->tsuika_type==ADD_STATUS_TOKUSEI){
				sp->mp.msg_id=TokuseiStatusDownM2MMsg;
				sp->mp.msg_tag=TAG_NICK_TOKU_NICK_STAT;
				sp->mp.msg_para[0]=ST_ServerTagNickParaMake(sp,sp->attack_client);
				sp->mp.msg_para[1]=sp->psp[sp->attack_client].speabino;
				sp->mp.msg_para[2]=ST_ServerTagNickParaMake(sp,sp->tsuika_client);
				sp->mp.msg_para[3]=COND_POW+para;
			}
			else{
				sp->mp.msg_id=(value==-1?CondDown1MineMsg:CondDown2MineMsg);
				sp->mp.msg_tag=TAG_NICK_STAT;
				sp->mp.msg_para[0]=ST_ServerTagNickParaMake(sp,sp->tsuika_client);
				sp->mp.msg_para[1]=COND_POW+para;
			}
			psp->abiritycnt[COND_POW+para]+=value;
			if(psp->abiritycnt[COND_POW+para]<0){
				psp->abiritycnt[COND_POW+para]=0;
			}
		}
	}

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_PSP_VALUE(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	act;
	int	side;
	int	src;
	int	value;
	int	client_no;
	int	data;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//act[h
	act=SkillSeqDataRead(sp);

	//side[h
	side=SkillSeqDataRead(sp);

	//src[h
	src=SkillSeqDataRead(sp);

	//value[h
	value=SkillSeqDataRead(sp);

	client_no=SideClientNoGet(bw,sp,side);

	data=ST_ServerPokemonServerParamGet(sp,client_no,src,NULL);

	switch(act){
	case VAL_SET:		//Zbg
		data=value;
		break;
	case VAL_ADD:		//Z
		data+=value;
		break;
	case VAL_SUB:		//Z
		data-=value;
		break;
	case VAL_BIT:		//lOR
		data|=value;
		break;
	case VAL_NBIT:		//lrbg]AND
		data&=(value^0xffffffff);
		break;
	case VAL_MUL:		//|Z
		data*=value;
		break;
	case VAL_DIV:		//Z
		data/=value;
		break;
	case VAL_LSH:		//Vtg
		data=data<<value;
		break;
	case VAL_RSH:		//EVtg
		data=data>>value;
		break;
	case VAL_TO_BIT:	//lrbgɕϊ
		data=No2Bit(value);
		break;
	case VAL_GET:		//l擾
		GF_ASSERT_MSG(0,"VAL_GET͎wł܂");
		break;
	case VAL_SUB_ZERO:		//Z
		data-=value;
		if(data<0){
			data=0;
		}
		break;
	case VAL_XOR:		//XOR
		data^=value;
		break;
	default:
		GF_ASSERT_MSG(0,"sȒ`ł\n");
		break;
	}

	ST_ServerPokemonServerParamPut(sp,client_no,src,(u8 *)&data);
	ST_PSPtoPPCopy(bw,sp,client_no);

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_CONDITION2_OFF(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	client_no;
	int	side;
	int	value;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//side[h
	side=SkillSeqDataRead(sp);

	//value[h
	value=SkillSeqDataRead(sp);

	client_no=SideClientNoGet(bw,sp,side);

	sp->condition2_off_req[client_no]|=value;

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_VANISH_ON_OFF(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	side;
	int	sw;
	int	client_no;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//side[h
	side=SkillSeqDataRead(sp);

	//sw[h
	sw=SkillSeqDataRead(sp);

	client_no=SideClientNoGet(bw,sp,side);

	SCIO_PokemonVanishOnOff(bw,client_no,sw);

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_TOKUSEI_CHECK(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	flag;
	int	side;
	int	tokusei;
	int	adrs;
	int	client_no;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//flag[h
	flag=SkillSeqDataRead(sp);

	//side[h
	side=SkillSeqDataRead(sp);

	//tokusei[h
	tokusei=SkillSeqDataRead(sp);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	//SIDE_ALL̎́AɂłĂ|PׂĂ`FbN
	if(side==SIDE_ALL){
		{
			int	client_set_max;

			client_set_max=BattleWorkClientSetMaxGet(bw);

			for(client_no=0;client_no<client_set_max;client_no++){
				if(flag==TOKUSEI_HAVE){
					if(ST_ServerTokuseiGet(sp,client_no)==tokusei){
						SkillSeqInc(sp,adrs);
						sp->tokusei_client=client_no;
						break;
					}
				}
				else{
					//NĂȂƂ`FbN
					if(ST_ServerTokuseiGet(sp,client_no)==tokusei){
						break;
					}
				}
			}
		}
	}
	else{
		client_no=SideClientNoGet(bw,sp,side);
	
		if(flag==TOKUSEI_HAVE){
			if(ST_ServerTokuseiGet(sp,client_no)==tokusei){
				SkillSeqInc(sp,adrs);
				sp->tokusei_client=client_no;
			}
		}
		else{
			if(ST_ServerTokuseiGet(sp,client_no)!=tokusei){
				SkillSeqInc(sp,adrs);
				sp->tokusei_client=client_no;
			}
		}
	}

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_RANDOM_GET(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	range;
	int	ofs;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//range[h
	range=SkillSeqDataRead(sp);
	range+=1;

	//ofs[h
	ofs=SkillSeqDataRead(sp);

	sp->calc_work=(gf_rand()%range)+ofs;

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_VALUE_WORK(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	act;
	int	src;
	int	dest;
	int	*data_s;
	int	*data_d;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//act[h
	act=SkillSeqDataRead(sp);

	//src[h
	src=SkillSeqDataRead(sp);

	//dest[h
	dest=SkillSeqDataRead(sp);

	data_s=WS_SrcPointerGet(bw,sp,src);
	data_d=WS_SrcPointerGet(bw,sp,dest);

	switch(act){
	case VAL_SET:		//Zbg
		data_s[0]=data_d[0];
		break;
	case VAL_ADD:		//Z
		data_s[0]+=data_d[0];
		break;
	case VAL_SUB:		//Z
		data_s[0]-=data_d[0];
		break;
	case VAL_BIT:		//OR
		data_s[0]|=data_d[0];
		break;
	case VAL_NBIT:		//lrbg]AND
		data_s[0]&=(data_d[0]^0xffffffff);
		break;
	case VAL_MUL:		//|Z
		data_s[0]*=data_d[0];
		break;
	case VAL_DIV:		//Z
		data_s[0]/=data_d[0];
		break;
	case VAL_LSH:		//Vtg
		data_s[0]=data_s[0]<<data_d[0];
		break;
	case VAL_RSH:		//EVtg
		data_s[0]=data_s[0]>>data_d[0];
		break;
	case VAL_TO_BIT:	//lrbgɕϊ
		data_s[0]=No2Bit(data_d[0]);
		break;
	case VAL_GET:		//l擾
		data_d[0]=data_s[0];
		break;
	case VAL_SUB_ZERO:	//Z
		data_s[0]-=data_d[0];
		if(data_s[0]<0){
			data_s[0]=0;
		}
		break;
	case VAL_XOR:		//XOR
		data_s[0]^=data_d[0];
		break;
	default:
		GF_ASSERT_MSG(0,"sȒ`ł\n");
		break;
	}

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_PSP_VALUE_WORK(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	act;
	int	side;
	int	src;
	int	dest;
	int	client_no;
	int	data;
	int	*data_d;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//act[h
	act=SkillSeqDataRead(sp);

	//side[h
	side=SkillSeqDataRead(sp);

	//src[h
	src=SkillSeqDataRead(sp);

	//dest[h
	dest=SkillSeqDataRead(sp);

	client_no=SideClientNoGet(bw,sp,side);

	data=ST_ServerPokemonServerParamGet(sp,client_no,src,NULL);
	data_d=WS_SrcPointerGet(bw,sp,dest);

	switch(act){
	case VAL_SET:		//Zbg
		data=data_d[0];
		break;
	case VAL_ADD:		//Z
		data+=data_d[0];
		break;
	case VAL_SUB:		//Z
		data-=data_d[0];
		break;
	case VAL_BIT:		//lOR
		data|=data_d[0];
		break;
	case VAL_NBIT:		//lrbg]AND
		data&=(data_d[0]^0xffffffff);
		break;
	case VAL_MUL:		//|Z
		data*=data_d[0];
		break;
	case VAL_DIV:		//Z
		data/=data_d[0];
		break;
	case VAL_LSH:		//Vtg
		data=data<<data_d[0];
		break;
	case VAL_RSH:		//EVtg
		data=data>>data_d[0];
		break;
	case VAL_TO_BIT:	//lrbgɕϊ
		data=No2Bit(data_d[0]);
		break;
	case VAL_GET:		//l擾
		data_d[0]=data;
		break;
	case VAL_SUB_ZERO:
		data-=data_d[0];
		if(data<0){
			data=0;
		}
		break;
	case VAL_XOR:		//XOR
		data^=data_d[0];
		break;
	default:
		GF_ASSERT_MSG(0,"sȒ`ł\n");
		break;
	}

	if(act!=VAL_GET){
		ST_ServerPokemonServerParamPut(sp,client_no,src,(u8 *)&data);
		ST_PSPtoPPCopy(bw,sp,client_no);
	}

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_BRANCH(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	adrs;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	SkillSeqInc(sp,adrs);

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_GOSUB(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	seq_no;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//seq_no[h
	seq_no=SkillSeqDataRead(sp);

	SkillSequenceGosub(sp,ARC_SUB_SEQ,seq_no);

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_GOSUB_WORK(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	para;
	int	*data;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//para[h
	para=SkillSeqDataRead(sp);

	data=WS_SrcPointerGet(bw,sp,para);

	SkillSequenceGosub(sp,ARC_SUB_SEQ,data[0]);

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_OUMU_CHECK(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	fight_type;
	int	waza_no;

	waza_no=0;
	fight_type=BattleWorkFightTypeGet(bw);

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	if(sp->waza_no_oumu[sp->attack_client]){
		waza_no=sp->waza_no_oumu[sp->attack_client];
	}
	else{
		if(fight_type&FIGHT_TYPE_2vs2){
			//󂯂ĂZ̒烉_ŌJo
			waza_no=sp->waza_no_oumu_hit[sp->attack_client][0]+
					sp->waza_no_oumu_hit[sp->attack_client][1]+
					sp->waza_no_oumu_hit[sp->attack_client][2]+
					sp->waza_no_oumu_hit[sp->attack_client][3];
			if(waza_no){
				do{
					waza_no=sp->waza_no_oumu_hit[sp->attack_client][gf_rand()%4];
				}while(waza_no==0);
			}
		}
	}
	if((waza_no)&&(WT_OumuEncoreNGCheck(waza_no)==TRUE)){
		//ʂ̋ZV[PXփWv
		sp->waza_no_now=waza_no;
		sp->defence_client=ST_ServerDefenceClientSet(bw,sp,sp->attack_client,waza_no,1,0);
		SkillSequenceJump(sp,ARC_WAZA_SEQ,waza_no);
	}
	else{
		sp->ostf[sp->attack_client].no_pressure_flag=1;
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_KUROIKIRI(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	i;
	int	client_no;
	int	client_set_max;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	client_set_max=BattleWorkClientSetMaxGet(bw);

	for(client_no=0;client_no<client_set_max;client_no++){
		for(i=COND_HP;i<COND_MAX;i++){
			sp->psp[client_no].abiritycnt[i]=COND_NUM_DEFAULT;
		}
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_KEEP_OFF(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	side;
	int	client_no;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//side[h
	side=SkillSeqDataRead(sp);

	client_no=SideClientNoGet(bw,sp,side);

	ST_ServerKeepOff(bw,sp,client_no);

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_STATUS_SET(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	side;
	int	status;
	int	client_no;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//side[h
	side=SkillSeqDataRead(sp);

	//status[h
	status=SkillSeqDataRead(sp);

	client_no=SideClientNoGet(bw,sp,side);

	SCIO_HPGaugeStatusSet(bw,client_no,status);

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_TRAINER_MESSAGE(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	side;
	int	type;
	int	client_no;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//side[h
	side=SkillSeqDataRead(sp);

	//type[h
	type=SkillSeqDataRead(sp);

	client_no=SideClientNoGet(bw,sp,side);

	SCIO_TrainerMessageSet(bw,client_no,type);

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	u32	OkodukaiCalcAct(BATTLE_WORK *bw,SERVER_PARAM *sp,int num)
{
	int				i=0;
	void			*buf;
	u32				money;
	u8				level=0;
	TRAINER_DATA	td;

	buf=sys_AllocMemory(HEAPID_BATTLE,sizeof(POKEDATA_TYPE_MULTI));
	TT_TrainerDataGet(bw->trainer_id[num],&td);
	TT_TrainerPokeDataGet(bw->trainer_id[num],buf);

	switch(td.data_type){
	default:
	case DATATYPE_NORMAL:
		{
			POKEDATA_TYPE_NORMAL	*ptn;

			ptn=(POKEDATA_TYPE_NORMAL *)buf;
			level=ptn[td.poke_count-1].level;
		}
		break;
	case DATATYPE_WAZA:
		{
			POKEDATA_TYPE_WAZA	*ptw;

			ptw=(POKEDATA_TYPE_WAZA *)buf;
			level=ptw[td.poke_count-1].level;
		}
		break;
	case DATATYPE_ITEM:
		{
			POKEDATA_TYPE_ITEM	*pti;

			pti=(POKEDATA_TYPE_ITEM *)buf;
			level=pti[td.poke_count-1].level;
		}
		break;
	case DATATYPE_MULTI:
		{
			POKEDATA_TYPE_MULTI	*ptm;

			ptm=(POKEDATA_TYPE_MULTI *)buf;
			level=ptm[td.poke_count-1].level;
		}
		break;
	}
#warning OKODUKAI TRAINER PARAM Undefine
#if 0
		while(TMD[i].trtype!=0xff){
			if(TMD[i].trtype==TD[FieldTrainerID].type)
				break;
			i++;
		}
#endif
#warning OKODUKAI TRAINER PARAM Undefine
	//^bOog͓{
	if(bw->fight_type&FIGHT_TYPE_TAG){
//		money=level*4*sp->okodukai_value*TMD[i].money;
		money=level*4*sp->okodukai_value*5;
	}
	//_uog͂Q{
	else if(bw->fight_type&FIGHT_TYPE_TAG){
//		money=level*4*sp->okodukai_value*2*TMD[i].money;
		money=level*4*sp->okodukai_value*2*5;
	}
	//VOog͓{
	else{
//		money=level*4*sp->okodukai_value*TMD[i].money;
		money=level*4*sp->okodukai_value*5;
	}

	sys_FreeMemoryEz(buf);

	return money;
}

static	BOOL	WS_OKODUKAI_CALC(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	u32	money;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	if(sp->win_lose_flag==FIGHT_WIN){
		money=OkodukaiCalcAct(bw,sp,CLIENT_NO_ENEMY);
		if(bw->fight_type&FIGHT_TYPE_TAG){
			money+=OkodukaiCalcAct(bw,sp,CLIENT_NO_ENEMY2);
		}
		Mystatus_AddGold(BattleWorkMyStatusGet(bw,CLIENT_NO_MINE),money);
	}
	else{
		money=CalcLosePenalty(bw->poke_party[CLIENT_NO_MINE],bw->my_status[CLIENT_NO_MINE]);
		Mystatus_SubGold(BattleWorkMyStatusGet(bw,CLIENT_NO_MINE),money);
	}

	if(money){
		sp->msg_work=money;
	}
	else{
		sp->msg_work=0;
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_STATUS_EFFECT(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	client_no;
	int	side;
	int	status;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//side[h
	side=SkillSeqDataRead(sp);

	//status[h
	status=SkillSeqDataRead(sp);

	client_no=SideClientNoGet(bw,sp,side);

	SCIO_StatusEffectSet(bw,sp,client_no,status);

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_STATUS_EFFECT_WORK(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	client_no;
	int	side;
	int	status;
	int	*data;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//side[h
	side=SkillSeqDataRead(sp);

	//status[h
	status=SkillSeqDataRead(sp);

	client_no=SideClientNoGet(bw,sp,side);
	data=WS_SrcPointerGet(bw,sp,status);

	SCIO_StatusEffectSet(bw,sp,client_no,data[0]);

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_MODOSU_MESSAGE(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	client_no;
	int	side;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//side[h
	side=SkillSeqDataRead(sp);

	client_no=SideClientNoGet(bw,sp,side);

	SCIO_ModosuMessageSet(bw,client_no,sp->sel_mons_no[client_no]);

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_KURIDASU_MESSAGE(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	client_no;
	int	side;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//side[h
	side=SkillSeqDataRead(sp);

	client_no=SideClientNoGet(bw,sp,side);

	SCIO_KuridasuMessageSet(bw,client_no,sp->sel_mons_no[client_no]);

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_TRAINER_MESSAGE_WORK(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	side;
	int	client_no;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//side[h
	side=SkillSeqDataRead(sp);

	client_no=SideClientNoGet(bw,sp,side);

	SCIO_TrainerMessageSet(bw,client_no,sp->msg_work);

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_TEXTURE(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	cnt,i;
	int	adrs;
	int	wazatype;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	//ZĂ邩o
	for(cnt=0;cnt<4;cnt++){
		if(sp->psp[sp->attack_client].waza[cnt]==0){
			break;
		}
	}
	//ĂZ̃^Cv̒A݂̎̃^Cvł͂Ȃ̂邩`FbN
	for(i=0;i<cnt;i++){
		wazatype=WT_WazaDataParaGet(sp->psp[sp->attack_client].waza[i],ID_WTD_wazatype);
		if(wazatype==HATE_TYPE){
			if((sp->psp[sp->attack_client].type1==GHOST_TYPE)||(sp->psp[sp->attack_client].type2==GHOST_TYPE)){
				wazatype=GHOST_TYPE;
			}
			else{
				wazatype=NORMAL_TYPE;
			}
		}
		if((wazatype!=sp->psp[sp->attack_client].type1)&&(wazatype!=sp->psp[sp->attack_client].type2)){
			break;
		}
	}
	//Ȃꍇ́A܂܂ɂ
	if(i==cnt){
		SkillSeqInc(sp,adrs);
		sp->waza_status_flag|=WAZA_STATUS_FLAG_UMAKUKIMARAN;
	}
	else{
		//ĂZ̃^CvÃ^Cvł͂Ȃ̂_őI
		do{
			do{
				i=gf_rand()%4;
			}while(i>=cnt);
			wazatype=WT_WazaDataParaGet(sp->psp[sp->attack_client].waza[i],ID_WTD_wazatype);
			if(wazatype==HATE_TYPE){
				if((sp->psp[sp->attack_client].type1==GHOST_TYPE)||(sp->psp[sp->attack_client].type2==GHOST_TYPE)){
					wazatype=GHOST_TYPE;
				}
				else{
					wazatype=NORMAL_TYPE;
				}
			}
		}while((wazatype==sp->psp[sp->attack_client].type1)||(wazatype==sp->psp[sp->attack_client].type2));
		sp->psp[sp->attack_client].type1=wazatype;
		sp->psp[sp->attack_client].type2=wazatype;
		sp->msg_work=wazatype;
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_IF_WORK(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	act;
	int	src;
	int	dest;
	int	adrs;
	u32	*data_s;
	u32	*data_d;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//act[h
	act=SkillSeqDataRead(sp);

	//src[h
	src=SkillSeqDataRead(sp);

	//dest[h
	dest=SkillSeqDataRead(sp);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	data_s=WS_SrcPointerGet(bw,sp,src);
	data_d=WS_SrcPointerGet(bw,sp,dest);

	switch(act){
	case IF_FLAG_EQ:		//v
		if(data_s[0]!=data_d[0]){
			adrs=0;
		}
		break;
	case IF_FLAG_NE:		//sv
		if(data_s[0]==data_d[0]){
			adrs=0;
		}
		break;
	case IF_FLAG_C:			//
		if(data_s[0]<=data_d[0]){
			adrs=0;
		}
		break;
	case IF_FLAG_NC:		//ȉ
		if(data_s[0]>data_d[0]){
			adrs=0;
		}
		break;
	case IF_FLAG_BIT:		//rbgON
		if((data_s[0]&data_d[0])==0){
			adrs=0;
		}
		break;
	case IF_FLAG_NBIT:		//rbgOFF
		if(data_s[0]&data_d[0]){
			adrs=0;
		}
		break;
	case IF_FLAG_AND:		//rbgMASKĊSv邩H
		if((data_s[0]&data_d[0])!=data_d[0]){
			adrs=0;
		}
		break;
	default:
		GF_ASSERT_MSG(TRUE,"sȒ`ł\n");
		break;
	}
	if(adrs){
		SkillSeqInc(sp,adrs);
	}
	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_IF_PSP_WORK(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	act;
	int	side;
	int	src;
	int	dest;
	int	adrs;
	u32	data_s;
	u32	*data_d;
	int	client_no;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//act[h
	act=SkillSeqDataRead(sp);

	//side[h
	side=SkillSeqDataRead(sp);

	//src[h
	src=SkillSeqDataRead(sp);

	//dest[h
	dest=SkillSeqDataRead(sp);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	client_no=SideClientNoGet(bw,sp,side);

	data_s=ST_ServerPokemonServerParamGet(sp,client_no,src,NULL);
	data_d=WS_SrcPointerGet(bw,sp,dest);

	switch(act){
	case IF_FLAG_EQ:		//v
		if(data_s!=data_d[0]){
			adrs=0;
		}
		break;
	case IF_FLAG_NE:		//sv
		if(data_s==data_d[0]){
			adrs=0;
		}
		break;
	case IF_FLAG_C:			//
		if(data_s<=data_d[0]){
			adrs=0;
		}
		break;
	case IF_FLAG_NC:		//ȉ
		if(data_s>data_d[0]){
			adrs=0;
		}
		break;
	case IF_FLAG_BIT:		//rbgON
		if((data_s&data_d[0])==0){
			adrs=0;
		}
		break;
	case IF_FLAG_NBIT:		//rbgOFF
		if(data_s&data_d[0]){
			adrs=0;
		}
		break;
	case IF_FLAG_AND:		//rbgMASKĊSv邩H
		if((data_s&data_d[0])!=data_d[0]){
			adrs=0;
		}
		break;
	default:
		GF_ASSERT_MSG(TRUE,"sȒ`ł\n");
		break;
	}
	if(adrs){
		SkillSeqInc(sp,adrs);
	}
	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_KOBAN_CHECK(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	sp->msg_work=sp->koban_counter*sp->okodukai_value;
	if(sp->msg_work>KOBAN_MAX){
		sp->msg_work=KOBAN_MAX;
	}
	Mystatus_AddGold(BattleWorkMyStatusGet(bw,CLIENT_NO_MINE),sp->msg_work);

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_HIKARINOKABE(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	adrs;
	int	dir;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	dir=BattleWorkMineEnemyCheck(bw,sp->attack_client);


	if(sp->side_condition[dir]&SIDE_CONDITION_TOKUSYUGUARD){
		SkillSeqInc(sp,adrs);
		sp->waza_status_flag|=WAZA_STATUS_FLAG_UMAKUKIMARAN;
	}
	else{
		sp->side_condition[dir]|=SIDE_CONDITION_TOKUSYUGUARD;
		sp->scw[dir].tokusyu_guard_count=5;
		sp->scw[dir].tokusyu_guard_client=sp->attack_client;
		//ʂŕǂ̃JE^
		if(ST_ServerSoubiEqpGet(sp,sp->attack_client)==SOUBI_KABENOZIKANHUERU){
			sp->scw[dir].tokusyu_guard_count+=ST_ServerSoubiAtkGet(sp,sp->attack_client);
		}
		sp->mp.msg_tag=TAG_WAZA;
		sp->mp.msg_para[0]=sp->waza_no_now;
		if(ST_ServerHitCountCheck(bw,sp,SHCC_SIDE,sp->attack_client)==2){
			sp->mp.msg_id=TokusyuGuardMineMsg2vs2;
		}
		else{
			sp->mp.msg_id=TokusyuGuardMineMsg;
		}
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_RIHUREKUTAA(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	adrs;
	int	dir;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	dir=BattleWorkMineEnemyCheck(bw,sp->attack_client);

	if(sp->side_condition[dir]&SIDE_CONDITION_BUTSURIGUARD){
		SkillSeqInc(sp,adrs);
		sp->waza_status_flag|=WAZA_STATUS_FLAG_UMAKUKIMARAN;
	}
	else{
		sp->side_condition[dir]|=SIDE_CONDITION_BUTSURIGUARD;
		sp->scw[dir].butsuri_guard_count=5;
		sp->scw[dir].butsuri_guard_client=sp->attack_client;
		//ʂŕǂ̃JE^
		if(ST_ServerSoubiEqpGet(sp,sp->attack_client)==SOUBI_KABENOZIKANHUERU){
			sp->scw[dir].butsuri_guard_count+=ST_ServerSoubiAtkGet(sp,sp->attack_client);
		}
		sp->mp.msg_tag=TAG_WAZA;
		sp->mp.msg_para[0]=sp->waza_no_now;
		if(ST_ServerHitCountCheck(bw,sp,SHCC_SIDE,sp->attack_client)==2){
			sp->mp.msg_id=ButsuriGuardMineMsg2vs2;
		}
		else{
			sp->mp.msg_id=ButsuriGuardMineMsg;
		}
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_SIROIKIRI(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	adrs;
	int	dir;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	dir=BattleWorkMineEnemyCheck(bw,sp->attack_client);

	if(sp->side_condition[dir]&SIDE_CONDITION_SHIROIKIRI){
		SkillSeqInc(sp,adrs);
		sp->waza_status_flag|=WAZA_STATUS_FLAG_UMAKUKIMARAN;
	}
	else{
		sp->side_condition[dir]|=SIDE_CONDITION_SHIROIKIRI;
		sp->scw[dir].shiroikiri_count=5;
		sp->scw[dir].shiroikiri_client=sp->attack_client;
		sp->mp.msg_tag=TAG_NONE;
		sp->mp.msg_id=ShiroikiriMineMsg;
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_ICHIGEKI(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	u16	hit;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//ʏ̖vZȂ悤ɂ
	sp->server_status_flag|=SERVER_STATUS_FLAG_OTHER_HIT_CALC;

	//񂶂傤́AꌂKEłȂ
	if(ST_ServerKatayaburiTokuseiCheck(sp,sp->attack_client,sp->defence_client,TOKUSYU_GANZYOU)==TRUE){
		sp->waza_status_flag|=WAZA_STATUS_FLAG_GANZYOU_NOHIT;
	}
	else{
		if(((sp->psp[sp->defence_client].waza_kouka&WAZAKOUKA_LOCKON)==0)&&
		    (ST_ServerTokuseiGet(sp,sp->attack_client)!=TOKUSYU_NOOGAADO)&&
		    (ST_ServerTokuseiGet(sp,sp->defence_client)!=TOKUSYU_NOOGAADO)){
			hit=WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_hitprobability)+
				(sp->psp[sp->attack_client].level-sp->psp[sp->defence_client].level);
			if(((gf_rand()%100)+1<hit)&&(sp->psp[sp->attack_client].level>=sp->psp[sp->defence_client].level)){
				hit=1;
			}
			else{
				hit=0;
			}
		}
		else{
			if((sp->psp[sp->defence_client].wkw.lockon_client_no==sp->attack_client)&&
			   (sp->psp[sp->attack_client].level>=sp->psp[sp->defence_client].level)){
				hit=1;
			}
			else{
				hit=WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_hitprobability)+
					(sp->psp[sp->attack_client].level-sp->psp[sp->defence_client].level);
				if(((gf_rand()%100)+1<hit)&&(sp->psp[sp->attack_client].level>=sp->psp[sp->defence_client].level)){
					hit=1;
				}
				else{
					hit=0;
				}
			}
		}
		if(hit){
			sp->damage=sp->psp[sp->defence_client].hp*-1;
			sp->waza_status_flag|=WAZA_STATUS_FLAG_ICHIGEKI;
		}
		else{
			if(sp->psp[sp->attack_client].level>=sp->psp[sp->defence_client].level){
				sp->waza_status_flag|=WAZA_STATUS_FLAG_NOHIT;
			}
			else{
				sp->waza_status_flag|=WAZA_STATUS_FLAG_ICHIGEKI_NOHIT;
			}
		}
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_DAMAGE_DIV(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	para;
	int	value;
	int	*data;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//para[h
	para=SkillSeqDataRead(sp);

	//value[h
	value=SkillSeqDataRead(sp);

	data=WS_SrcPointerGet(bw,sp,para);

	data[0]=ST_ServerDamageDiv(data[0],value);

	return FALSE;
}
//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_DAMAGE_DIV_WORK(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	para;
	int	value;
	int	zero_work;
	int	*data_s;
	int	*data_d;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//para[h
	para=SkillSeqDataRead(sp);

	//value[h
	value=SkillSeqDataRead(sp);

	data_s=WS_SrcPointerGet(bw,sp,para);
	data_d=WS_SrcPointerGet(bw,sp,value);

	if(data_s[0]<0){
		zero_work=-1;
	}
	else{
		zero_work=1;
	}

	data_s[0]/=data_d[0];

	if(data_s[0]==0){
		data_s[0]=zero_work;
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_MONOMANE(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	adrs;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//adrs[h
	adrs=SkillSeqDataRead(sp);
	
		//̂܂˂łȂZA
	if((WT_MonomaneNGCheck(sp->waza_no_out[sp->defence_client])==FALSE)||
		//ւ񂵂񒆂A
	   (sp->psp[sp->attack_client].condition2&CONDITION2_HENSHIN)||
		//݂oĂ邩A
	   (sp->psp[sp->defence_client].condition2&CONDITION2_MIGAWARI)||
	   //肪ZôsĂ鎞́Â܂ˎs
	   (sp->waza_no_out[sp->defence_client]==FALSE)){
		SkillSeqInc(sp,adrs);
	}
	else{
		{
			int	waza_pos;
			int	waza_set_pos=-1;

			//ƂƎĂZ玸s
			for(waza_pos=0;waza_pos<WAZA_TEMOTI_MAX;waza_pos++){
				if(sp->psp[sp->attack_client].waza[waza_pos]==sp->waza_no_out[sp->defence_client]){
					break;
				}
				if((sp->psp[sp->attack_client].waza[waza_pos]==WAZANO_MONOMANE)&&(waza_set_pos==-1)){
					waza_set_pos=waza_pos;
				}
			}
			if(waza_pos==WAZA_TEMOTI_MAX){
				sp->waza_work=sp->waza_no_out[sp->defence_client];
				sp->psp[sp->attack_client].waza[waza_set_pos]=sp->waza_work;
				if(WT_WazaDataParaGet(sp->waza_work,ID_WTD_pp)<5){
					sp->psp[sp->attack_client].pp[waza_set_pos]=WT_WazaDataParaGet(sp->waza_work,ID_WTD_pp);
				}
				else{
					sp->psp[sp->attack_client].pp[waza_set_pos]=5;
				}
				sp->psp[sp->attack_client].wkw.monomane_bit|=No2Bit(waza_set_pos);
			}
			else{
				SkillSeqInc(sp,adrs);
			}
		}
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_YUBIWOHURU(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	waza_pos;
	u16	waza_no;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	while(1){
		waza_no=(gf_rand()%WAZANO_MAX)+1;
		//ĂZ͏oȂ
		for(waza_pos=0;waza_pos<WAZA_TEMOTI_MAX;waza_pos++){
			if(sp->psp[sp->attack_client].waza[waza_pos]==waza_no){
				continue;
			}
		}
		if(WT_YubiwohuruNGCheck(waza_no)==FALSE){
			continue;
		}
		//ʂ̋ZV[PXփWv
		sp->waza_no_now=waza_no;
		sp->defence_client=ST_ServerDefenceClientSet(bw,sp,sp->attack_client,waza_no,1,0);
		SkillSequenceJump(sp,ARC_WAZA_SEQ,waza_no);
		//ATTACK_MESSAGEo悤ɃtO𗎂Ƃ
		sp->server_status_flag&=SERVER_STATUS_FLAG_NO_ATTACK_MSG_OFF;
		break;
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_KANASIBARI(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	adrs;
	int	waza_pos;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	waza_pos=ST_ServerWazaPosGet(&sp->psp[sp->defence_client],sp->waza_no_out[sp->defence_client]);

	if((sp->psp[sp->defence_client].wkw.kanashibari_wazano==0)&&
	   (waza_pos!=WAZA_TEMOTI_MAX)&&
	   (sp->psp[sp->defence_client].pp[waza_pos])&&
	   (sp->waza_no_out[sp->defence_client])){
		sp->waza_work=sp->waza_no_out[sp->defence_client];
		sp->psp[sp->defence_client].wkw.kanashibari_wazano=sp->waza_work;
		sp->psp[sp->defence_client].wkw.kanashibari_count=gf_rand()%4+3;	//Q`Tiۂ͂R`Uɂj
	}
	else{
		SkillSeqInc(sp,adrs);
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_COUNTER(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	dir_a,dir_d;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	dir_a=BattleWorkMineEnemyCheck(bw,sp->attack_client);
	dir_d=BattleWorkMineEnemyCheck(bw,sp->otf[sp->attack_client].butsuri_otf_client);

	if((sp->otf[sp->attack_client].butsuri_otf_damage)&&
	   (dir_a!=dir_d)&&
	   (sp->psp[sp->otf[sp->attack_client].butsuri_otf_client].hp)){
		sp->damage=sp->otf[sp->attack_client].butsuri_otf_damage*2;
		if((sp->scw[dir_d].konoyubitomare_flag)&&(sp->psp[sp->scw[dir_d].konoyubitomare_client].hp)){
			sp->defence_client=sp->scw[dir_d].konoyubitomare_client;
		}
		else{
			sp->defence_client=sp->otf[sp->attack_client].butsuri_otf_client;
		}
	}
	else{
		//vbV[̉e󂯂Ȃ悤ɂ
		sp->ostf[sp->attack_client].no_pressure_flag=1;
		sp->waza_status_flag|=WAZA_STATUS_FLAG_UMAKUKIMARAN;
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_MIRROR_CORT(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	dir_a,dir_d;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	dir_a=BattleWorkMineEnemyCheck(bw,sp->attack_client);
	dir_d=BattleWorkMineEnemyCheck(bw,sp->otf[sp->attack_client].tokusyu_otf_client);

	if((sp->otf[sp->attack_client].tokusyu_otf_damage)&&
	   (dir_a!=dir_d)&&
	   (sp->psp[sp->otf[sp->attack_client].tokusyu_otf_client].hp)){
		sp->damage=sp->otf[sp->attack_client].tokusyu_otf_damage*2;
		if((sp->scw[dir_d].konoyubitomare_flag)&&(sp->psp[sp->scw[dir_d].konoyubitomare_client].hp)){
			sp->defence_client=sp->scw[dir_d].konoyubitomare_client;
		}
		else{
			sp->defence_client=sp->otf[sp->attack_client].tokusyu_otf_client;
		}
	}
	else{
		//vbV[̉e󂯂Ȃ悤ɂ
		sp->ostf[sp->attack_client].no_pressure_flag=1;
		sp->waza_status_flag|=WAZA_STATUS_FLAG_UMAKUKIMARAN;
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_ENCORE(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	adrs;
	int	waza_pos;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	waza_pos=ST_ServerWazaPosGet(&sp->psp[sp->defence_client],sp->waza_no_out[sp->defence_client]);

	//AR[łȂZ̎w
	if(WT_OumuEncoreNGCheck(sp->waza_no_out[sp->defence_client])==FALSE){
		waza_pos=WAZA_TEMOTI_MAX;
	}

	if((sp->psp[sp->defence_client].wkw.encore_wazano==0)&&
	   (waza_pos!=WAZA_TEMOTI_MAX)&&
	   (sp->psp[sp->defence_client].pp[waza_pos])&&
	   (sp->waza_no_out[sp->defence_client])){
		sp->waza_work=sp->waza_no_out[sp->defence_client];
		sp->psp[sp->defence_client].wkw.encore_wazano=sp->waza_work;
		sp->psp[sp->defence_client].wkw.encore_count=gf_rand()%5+3;		//Q`Uiۂ́AR`Vɂj
	}
	else{
		sp->waza_status_flag|=WAZA_STATUS_FLAG_UMAKUKIMARAN;
		SkillSeqInc(sp,adrs);
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_TEXTURE2(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	i,j;
	int	adrs;
	int	wazatype;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//adrs[h
	adrs=SkillSeqDataRead(sp);


	if((sp->waza_no_hit[sp->attack_client])&&(sp->waza_no_hit_client[sp->attack_client]!=NONE_CLIENT_NO)){
		if((ST_TameWazaCheck(sp,sp->waza_no_hit[sp->attack_client]))&&
		   (sp->psp[sp->waza_no_hit_client[sp->attack_client]].condition2&CONDITION2_KEEP)){
			sp->waza_status_flag|=WAZA_STATUS_FLAG_UMAKUKIMARAN;
			SkillSeqInc(sp,adrs);
		}
		else{
			{
				u8	type_w,type_p,value;

				wazatype=sp->waza_no_hit_type[sp->attack_client];
				//ꉞA1000񂵂ă^Cv擾Ă݂
				for(i=0;i<1000;i++){
					ST_ServerTypeCheckTableParaGet(0xffff,&type_w,&type_p,&value);
					if((type_w==wazatype)&&(value<=5)&&
					   (sp->psp[sp->attack_client].type1!=type_p)&&
					   (sp->psp[sp->attack_client].type2!=type_p)){
					   sp->psp[sp->attack_client].type1=type_p;
					   sp->psp[sp->attack_client].type2=type_p;
					   sp->msg_work=type_p;
					   return FALSE;
					}
				}
				//1000񂵂Ă_Ȏ̓e[uォȂ߂Ĉv̂T
				i=0;
				while(ST_ServerTypeCheckTableParaGet(i,&type_w,&type_p,&value)==TRUE){
					if((type_w==wazatype)&&(value<=5)&&
					   (sp->psp[sp->attack_client].type1!=type_p)&&
					   (sp->psp[sp->attack_client].type2!=type_p)){
					   sp->psp[sp->attack_client].type1=type_p;
					   sp->psp[sp->attack_client].type2=type_p;
					   sp->msg_work=type_p;
					   return FALSE;
					}
					i++;
				}
			}
		}
	}
	sp->waza_status_flag|=WAZA_STATUS_FLAG_UMAKUKIMARAN;
	SkillSeqInc(sp,adrs);

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_SKETCH(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	pos;
	int	set_pos=-1;
	int	adrs;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	if((sp->psp[sp->attack_client].condition2&CONDITION2_HENSHIN)||
	   (sp->waza_no_sketch[sp->defence_client]==WAZANO_WARUAGAKI)||
	   (sp->waza_no_sketch[sp->defence_client]==WAZANO_SUKETTI)||
	   (sp->waza_no_sketch[sp->defence_client]==0)){
		SkillSeqInc(sp,adrs);
	}
	else{
		for(pos=0;pos<WAZA_TEMOTI_MAX;pos++){
			if((sp->psp[sp->attack_client].waza[pos]!=WAZANO_SUKETTI)&&
			   (sp->psp[sp->attack_client].waza[pos]==sp->waza_no_sketch[sp->defence_client])){
				break;
			}
			if((sp->psp[sp->attack_client].waza[pos]==WAZANO_SUKETTI)&&(set_pos==-1)){
				set_pos=pos;
			}
		}
		if(pos==WAZA_TEMOTI_MAX){
			sp->psp[sp->attack_client].waza[set_pos]=sp->waza_no_sketch[sp->defence_client];
			sp->psp[sp->attack_client].pp[set_pos]=WT_WazaDataParaGet(sp->waza_no_sketch[sp->defence_client],ID_WTD_pp);
			SCIO_PSPtoPPCopy(bw,sp,sp->attack_client);
			sp->waza_work=sp->waza_no_sketch[sp->defence_client];
		}
		else{
			SkillSeqInc(sp,adrs);
		}
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_NEGOTO(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	pos;
	int	wazabit;
	int	adrs;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	wazabit=0;

	for(pos=0;pos<WAZA_TEMOTI_MAX;pos++){
		if((ST_RendouWazaCheck(sp->psp[sp->attack_client].waza[pos]))||
		   (sp->psp[sp->attack_client].waza[pos]==WAZANO_KIAIPANTI)||
		   (sp->psp[sp->attack_client].waza[pos]==WAZANO_SAWAGU)||
		   (ST_TameWazaCheck(sp,sp->psp[sp->attack_client].waza[pos]))){
			wazabit|=No2Bit(pos);
		}
	}

	wazabit=ST_ServerWaruagakiCheck(bw,sp,sp->attack_client,wazabit,(SSWC_PP_NONE^0xff));

	if(wazabit==0x0f){
		SkillSeqInc(sp,adrs);
	}
	else{
		do{
			pos=gf_rand()%4;
		}while((wazabit&No2Bit(pos)));
		sp->waza_work=sp->psp[sp->attack_client].waza[pos];
	}
	return FALSE;
}

//============================================================================================
/**
 *	΂U̓e[u
 */
//============================================================================================

enum{
	HP_DOT=0,
	POWER
};

static	const	u8	JitabataPowerTable[][2]={
	{ 1,200},
	{ 5,150},
	{12,100},
	{21, 80},
	{42, 40},
	{64, 20},
};

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_JITABATA(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	i;
	int	dot;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	dot=GetNumDotto(sp->psp[sp->attack_client].hp,sp->psp[sp->attack_client].hpmax,64);
	for(i=0;i<NELEMS(JitabataPowerTable);i++){
		if(dot<=JitabataPowerTable[i][HP_DOT]){
			break;
		}
	}
	sp->damage_power=JitabataPowerTable[i][POWER];

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_URAMI(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	adrs;
	int	waza_pos;
	int	pp_dec;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	if(sp->waza_no_out[sp->defence_client]){
		waza_pos=ST_ServerWazaPosGet(&sp->psp[sp->defence_client],sp->waza_no_out[sp->defence_client]);
		if((waza_pos==WAZA_TEMOTI_MAX)||
		   (sp->psp[sp->defence_client].pp[waza_pos]<2)){
			SkillSeqInc(sp,adrs);
		}
		else{
			pp_dec=gf_rand()%4+2;
			if(sp->psp[sp->defence_client].pp[waza_pos]<pp_dec){
				pp_dec=sp->psp[sp->defence_client].pp[waza_pos];
			}
			sp->waza_work=sp->waza_no_out[sp->defence_client];
			sp->msg_work=pp_dec;
			sp->psp[sp->defence_client].pp[waza_pos]-=pp_dec;
			ST_PSPtoPPCopy(bw,sp,sp->defence_client);
			//PPOɂȂAߌntO𗎂Ƃ
			if(sp->psp[sp->defence_client].pp[waza_pos]==0){
				ST_ServerKeepOff(bw,sp,sp->defence_client);
			}
		}
	}
	else{
		SkillSeqInc(sp,adrs);
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_IYASINOSUZU(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	u32	fight_type;
	int	client_no;

	fight_type=BattleWorkFightTypeGet(bw);

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//ڂŖhtOɗp
	sp->calc_work=0;

	if(sp->waza_no_now==WAZANO_IYASINOSUZU){
		sp->waza_work=sp->waza_no_now;
		//₵̂́Ah`FbN
		if(ST_ServerTokuseiGet(sp,sp->attack_client)!=TOKUSYU_BOUON){
			sp->psp[sp->attack_client].condition=0;
			sp->psp[sp->attack_client].condition2&=CONDITION2_AKUMU_OFF;
		}
		else{
			sp->calc_work|=(BOUON_SIDE_1|NOSET_SIDE_1);
		}
			
		if(fight_type&FIGHT_TYPE_2vs2){
			client_no=SideClientNoGet(bw,sp,SIDE_ATTACK_PAIR);
			if((sp->no_reshuffle_client&No2Bit(client_no))==0){
				if(ST_ServerTokuseiGet(sp,client_no)!=TOKUSYU_BOUON){
					sp->psp[client_no].condition=0;
					sp->psp[client_no].condition2&=CONDITION2_AKUMU_OFF;
				}
				else{
					sp->client_work=client_no;
					sp->calc_work|=(BOUON_SIDE_2|NOSET_SIDE_2);
				}
			}
		}
		else{
			sp->calc_work|=NOSET_SIDE_2;
		}
	}
	else{
		//A}Zs[͑SȂ
		sp->psp[sp->attack_client].condition=0;
		sp->psp[sp->attack_client].condition2&=CONDITION2_AKUMU_OFF;
		if(fight_type&FIGHT_TYPE_2vs2){
			client_no=SideClientNoGet(bw,sp,SIDE_ATTACK_PAIR);
			if((sp->no_reshuffle_client&No2Bit(client_no))==0){
				sp->psp[client_no].condition=0;
				sp->psp[client_no].condition2&=CONDITION2_AKUMU_OFF;
			}
		}
		else{
			sp->calc_work|=NOSET_SIDE_2;
		}
	}

	SCIO_PokemonRefreshSet(bw,sp->attack_client,sp->waza_no_now);

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_DOROBOU(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	adrs;
	u32	fight_type;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	fight_type=BattleWorkFightTypeGet(bw);

	//ĜǂڂŁAsFightType`FbN
	if((BattleWorkMineEnemyCheck(bw,sp->attack_client))&&((fight_type&FIGHT_TYPE_DOROBOU)==0)){
		SkillSeqInc(sp,adrs);
	}
	else{
		if((sp->psp[sp->defence_client].item)&&
		   (ST_ServerKatayaburiTokuseiCheck(sp,sp->attack_client,sp->defence_client,TOKUSYU_NENTYAKU)==TRUE)){
			sp->mp.msg_id=TokuseiNoWazaMineMsg;
			sp->mp.msg_tag=TAG_NICK_TOKU_WAZA;
			sp->mp.msg_para[0]=ST_ServerTagNickParaMake(sp,sp->defence_client);
			sp->mp.msg_para[1]=sp->psp[sp->defence_client].speabino;
			sp->mp.msg_para[2]=sp->waza_no_now;
		}
		else if((sp->psp[sp->attack_client].item==0)&&
				(ST_ServerDorobouItemCheck(sp,sp->defence_client))){
			sp->mp.msg_id=DorobouM2MMsg;
			sp->mp.msg_tag=TAG_NICK_NICK_ITEM;
			sp->mp.msg_para[0]=ST_ServerTagNickParaMake(sp,sp->attack_client);
			sp->mp.msg_para[1]=ST_ServerTagNickParaMake(sp,sp->defence_client);
			sp->mp.msg_para[2]=sp->psp[sp->defence_client].item;
			sp->psp[sp->attack_client].item=sp->psp[sp->defence_client].item;
			sp->psp[sp->defence_client].item=0;
			ST_PSPtoPPCopy(bw,sp,sp->attack_client);
			ST_PSPtoPPCopy(bw,sp,sp->defence_client);
		}
		else{
			SkillSeqInc(sp,adrs);
		}
	}

	return FALSE;
}

//============================================================================================
/**
 * WS_GUARD_SUCCESS_CHECKpme[u
 */
//============================================================================================
static	const	u16	GSC_Table[]={
	0xffff/1,
	0xffff/2,
	0xffff/4,
	0xffff/8,
};

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_GUARD_SUCCESS_CHECK(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	flag;
	int	client_set_max;
	int	adrs;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//adrs[h
	adrs=SkillSeqDataRead(sp);
	
	if((sp->waza_no_out[sp->attack_client]!=WAZANO_MAMORU)&&
	   (sp->waza_no_out[sp->attack_client]!=WAZANO_MIKIRI)&&
	   (sp->waza_no_out[sp->attack_client]!=WAZANO_KORAERU)){
		sp->psp[sp->attack_client].wkw.success_count=0;
	}

	client_set_max=BattleWorkClientSetMaxGet(bw);

	//ŌȂ玸sɂiĂӖȂ̂Łj
	if(sp->agi_cnt==client_set_max-1){
		flag=0;
	}
	else{
		flag=1;
	}

	if((GSC_Table[sp->psp[sp->attack_client].wkw.success_count]>=gf_rand())&&(flag)){
		//܂A݂
		if(WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_battleeffect)==111){
			sp->otf[sp->attack_client].mamoru_flag=1;
			sp->mp.msg_id=MamoruMineMsg;
		}
		//炦
		if(WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_battleeffect)==116){
			sp->otf[sp->attack_client].koraeru_flag=1;
			sp->mp.msg_id=KoraeruMineMsg;
		}
		sp->mp.msg_tag=TAG_NICK;
		sp->mp.msg_para[0]=ST_ServerTagNickParaMake(sp,sp->attack_client);
		if(sp->psp[sp->attack_client].wkw.success_count<NELEMS(GSC_Table)-1){
			sp->psp[sp->attack_client].wkw.success_count++;
		}
	}
	else{
		sp->psp[sp->attack_client].wkw.success_count=0;
		SkillSeqInc(sp,adrs);
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_MIGAWARI(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	adrs;
	int	hpmax;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	hpmax=ST_ServerDamageDiv(sp->psp[sp->attack_client].hpmax,4);

	if(sp->psp[sp->attack_client].hp<=hpmax){
		SkillSeqInc(sp,adrs);
	}
	else{
		sp->hp_calc_work=hpmax*-1;
		sp->psp[sp->attack_client].condition2|=CONDITION2_MIGAWARI;
		sp->psp[sp->attack_client].wkw.migawari_hp=hpmax;
		//OƂ̐̂߁AgoߋZnJ
		sp->psp[sp->attack_client].condition2&=CONDITION2_SHIME_OFF;
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_HUKITOBASI(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	adrs;
	u32	fight_type;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	fight_type=BattleWorkFightTypeGet(bw);

	if(fight_type&FIGHT_TYPE_TRAINER){
		{
			POKEPARTY		*poke_p;
			POKEMON_PARAM	*pp;
			int				poke_count;
			int				cnt=0,cntmax,i,start,end,rnd_max;
			int				selmons1,selmons2;

			poke_p=BattleWorkPokePartyGet(bw,sp->defence_client);
			poke_count=BattleWorkPokeCountGet(bw,sp->defence_client);

			//_u
			if(fight_type&FIGHT_TYPE_2vs2){
				start=0;
				end=poke_count;
				rnd_max=poke_count;
				cntmax=2;
				selmons1=sp->sel_mons_no[sp->defence_client];
				selmons2=sp->sel_mons_no[sp->defence_client^2];
			}
			//VO
			else{
				start=0;
				end=poke_count;
				rnd_max=poke_count;
				cntmax=1;
				selmons1=sp->sel_mons_no[sp->defence_client];
				selmons2=sp->sel_mons_no[sp->defence_client];
			}

			for(i=start;i<end;i++){
				pp=PokeParty_GetMemberPointer(poke_p,i);
				if((PokeParaGet(pp,ID_PARA_monsno,NULL))&&
				   (PokeParaGet(pp,ID_PARA_tamago_flag,NULL)==0)&&
				   (PokeParaGet(pp,ID_PARA_hp,NULL))){
					cnt++;
				}
			}
			if(cnt<=cntmax){
				SkillSeqInc(sp,adrs);
			}
			else{
				if(ST_ServerHukitobasiCheck(sp)){
					do{
						do{
							i=gf_rand()%rnd_max;
							i+=start;
						}while((i==selmons1)||(i==selmons2));
						pp=PokeParty_GetMemberPointer(poke_p,i);
					}while((PokeParaGet(pp,ID_PARA_monsno,NULL)==0)||
						   (PokeParaGet(pp,ID_PARA_tamago_flag,NULL)==1)||
						   (PokeParaGet(pp,ID_PARA_hp,NULL)==0));
				}
				sp->sel_mons_no[sp->defence_client]=i;
			}
		}
	}
	else{
		if(ST_ServerHukitobasiCheck(sp)==FALSE){
			SkillSeqInc(sp,adrs);
		}
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_HENSIN(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	i;
	u8	*src,*dest;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	sp->psp[sp->attack_client].condition2|=CONDITION2_HENSHIN;
	sp->psp[sp->attack_client].wkw.kanashibari_wazano=0;
	sp->psp[sp->attack_client].wkw.kanashibari_count=0;
	sp->psp[sp->attack_client].wkw.henshin_rnd=sp->psp[sp->defence_client].personal_rnd;
	sp->psp[sp->attack_client].wkw.monomane_bit=0;

	src=(u8 *)&sp->psp[sp->attack_client];
	dest=(u8 *)&sp->psp[sp->defence_client];

	for(i=0;i<XtOffset(POKEMON_SERVER_PARAM *,speabino)+1;i++){
		src[i]=dest[i];
	}
	//ZPP͂TɂiftHgT̂̂́Â܂܂̒lj
	for(i=0;i<WAZA_TEMOTI_MAX;i++){
		if(WT_WazaDataParaGet(sp->psp[sp->attack_client].waza[i],ID_WTD_pp)<5){
			sp->psp[sp->attack_client].pp[i]=WT_WazaDataParaGet(sp->psp[sp->attack_client].waza[i],ID_WTD_pp);
		}
		else{
			sp->psp[sp->attack_client].pp[i]=5;
		}
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_MAKIBISI(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	adrs;
	int	dir;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	dir=BattleWorkMineEnemyCheck(bw,sp->attack_client)^1;

	if(sp->scw[dir].makibisi_count==3){
		sp->ostf[sp->attack_client].no_pressure_flag=1;
		SkillSeqInc(sp,adrs);
	}
	else{
		sp->scw[dir].makibisi_count++;
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_MAKIBISI_CHECK(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	side;
	int	adrs;
	int	client_no;
	int	dir;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//side[h
	side=SkillSeqDataRead(sp);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	client_no=SideClientNoGet(bw,sp,side);
	dir=BattleWorkMineEnemyCheck(bw,client_no);

	if(sp->scw[dir].makibisi_count){
		sp->hp_calc_work=(5-sp->scw[dir].makibisi_count)*2;
		sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[client_no].hpmax*-1,sp->hp_calc_work);
	}
	else{
		SkillSeqInc(sp,adrs);
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_HOROBINOUTA(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	adrs;
	int	client_no;
	int	count;
	int	client_set_max;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	client_set_max=BattleWorkClientSetMaxGet(bw);
	sp->calc_work=client_set_max;
	count=0;

	for(client_no=0;client_no<client_set_max;client_no++){
		if((sp->psp[client_no].waza_kouka&WAZAKOUKA_HOROBINOUTA)||
		   (ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_BOUON)){
			count++;
		}
		else{
			sp->psp[client_no].waza_kouka|=WAZAKOUKA_HOROBINOUTA;
			sp->psp[client_no].wkw.horobinouta_count=3;
		}
	}
	if(count==client_set_max){
		SkillSeqInc(sp,adrs);
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_CLIENT_NO_GET_AGI(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	para;
	u32	*data;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//para1[h
	para=SkillSeqDataRead(sp);

	data=WS_SrcPointerGet(bw,sp,para);

	data[0]=sp->psp_agi_work[sp->client_no_agi];

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_CLIENT_SET_MAX_LOOP(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	para;
	int	adrs;
	u32	*data;
	int	client_set_max;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//para[h
	para=SkillSeqDataRead(sp);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	data=WS_SrcPointerGet(bw,sp,para);
	client_set_max=BattleWorkClientSetMaxGet(bw);

	if(data[0]<client_set_max){
		SkillSeqInc(sp,adrs);
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_TENKOU_DAMAGE(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	side;
	int	client_no;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//side[h
	side=SkillSeqDataRead(sp);

	client_no=SideClientNoGet(bw,sp,side);

	sp->temp_work=0;
	sp->hp_calc_work=0;

	if((ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ALL_HP,0,TOKUSYU_NOOTENKI)==0)&&
	   (ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ALL_HP,0,TOKUSYU_EAROKKU)==0)){
		//Ȃ炵`FbN
		if(sp->field_condition&FIELD_CONDITION_SUNAARASHI_ALL){
			if((sp->psp[client_no].type1!=IWA_TYPE)&&
			   (sp->psp[client_no].type2!=IWA_TYPE)&&
			   (sp->psp[client_no].type1!=METAL_TYPE)&&
			   (sp->psp[client_no].type2!=METAL_TYPE)&&
			   (sp->psp[client_no].type1!=JIMEN_TYPE)&&
			   (sp->psp[client_no].type2!=JIMEN_TYPE)&&
			   (sp->psp[client_no].hp)&&
			   (ST_ServerTokuseiGet(sp,client_no)!=TOKUSYU_SUNAGAKURE)&&
			  ((sp->psp[client_no].waza_kouka&(WAZAKOUKA_ANAWOHORU|WAZAKOUKA_DAIBINGU))==0)){
				sp->waza_work=WAZANO_SUNAARASI;
				sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[client_no].hpmax*-1,16);
			}
		}
		//ɂق΂`FbN
		if(sp->field_condition&FIELD_CONDITION_HARE_ALL){
			if((sp->psp[client_no].hp)&&
			  ((sp->psp[client_no].waza_kouka&(WAZAKOUKA_ANAWOHORU|WAZAKOUKA_DAIBINGU))==0)){
				//񂻂͂ATp[́A͂̎AHPMAX1/8_[W
				if((ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_KANSOUHADA)||
				   (ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_SANPAWAA)){
					sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[client_no].hpmax*-1,8);
				}
				if(ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_SANPAWAA){
					sp->temp_work=TENKOU_SUNPOWER;
				}
			}
		}
		//`FbN
		if(sp->field_condition&FIELD_CONDITION_ARARE){
			if((sp->psp[client_no].hp)&&
			  ((sp->psp[client_no].waza_kouka&(WAZAKOUKA_ANAWOHORU|WAZAKOUKA_DAIBINGU))==0)){
				//ACX{fB́A̎AHPMAX1/16
				if(ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_AISUBODHI){
					if(sp->psp[client_no].hp<sp->psp[client_no].hpmax){
						sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[client_no].hpmax,16);
					}
				}
				else if((sp->psp[client_no].type1!=KOORI_TYPE)&&
						(sp->psp[client_no].type2!=KOORI_TYPE)){
					sp->waza_work=WAZANO_ARARE;
					sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[client_no].hpmax*-1,16);
				}
			}
		}
		//܂`FbN
		if(sp->field_condition&FIELD_CONDITION_AME_ALL){
			if((sp->psp[client_no].hp)&&
			   (sp->psp[client_no].hp<sp->psp[client_no].hpmax)&&
			   (ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_AMEUKEZARA)){
				sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[client_no].hpmax,16);
			}
			if((sp->psp[client_no].hp)&&
			   (sp->psp[client_no].hp<sp->psp[client_no].hpmax)&&
			   (ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_KANSOUHADA)){
				sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[client_no].hpmax,8);
			}
			if((sp->psp[client_no].hp)&&
			   (sp->psp[client_no].condition&CONDITION_BAD)&&
			   (ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_URUOIBODHI)){
				if(sp->psp[client_no].condition&CONDITION_NEMURI){
					sp->msg_work=MSG_COND_NEMURI;
				}
				else if(sp->psp[client_no].condition&CONDITION_DOKUALL){
					sp->msg_work=MSG_COND_DOKU;
				}
				else if(sp->psp[client_no].condition&CONDITION_YAKEDO){
					sp->msg_work=MSG_COND_YAKEDO;
				}
				else if(sp->psp[client_no].condition&CONDITION_MAHI){
					sp->msg_work=MSG_COND_MAHI;
				}
				else{
					sp->msg_work=MSG_COND_KOORI;
				}
				sp->temp_work=TENKOU_URUOIBODY;
			}
		}
	}
	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_KOROGARU(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	i;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	if((sp->psp[sp->attack_client].condition2&CONDITION2_KEEP)==0){
		sp->psp[sp->attack_client].condition2|=CONDITION2_KEEP;
		sp->psp[sp->attack_client].wkw.korogaru_count=0;
	}

	if(++sp->psp[sp->attack_client].wkw.korogaru_count==5){
		ST_ServerKeepOff(bw,sp,sp->attack_client);
	}

	sp->damage_power=WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_damage);

	for(i=1;i<sp->psp[sp->attack_client].wkw.korogaru_count;i++){
		sp->damage_power*=2;
	}

	if(sp->psp[sp->attack_client].condition2&CONDITION2_MARUKUNARU){
		sp->damage_power*=2;
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_RENZOKUGIRI(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	i;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	if(sp->psp[sp->attack_client].wkw.renzokugiri_count<5){
		sp->psp[sp->attack_client].wkw.renzokugiri_count++;
	}

	sp->damage_power=WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_damage);

	for(i=1;i<sp->psp[sp->attack_client].wkw.renzokugiri_count;i++){
		sp->damage_power*=2;
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_MEROMERO(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	adrs;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	if((PokeSexGetMonsNo(sp->psp[sp->client_work].monsno,sp->psp[sp->client_work].personal_rnd)==
	    PokeSexGetMonsNo(sp->psp[sp->tsuika_client].monsno,sp->psp[sp->tsuika_client].personal_rnd))||
	   (sp->psp[sp->tsuika_client].condition2&CONDITION2_MEROMERO)||
	   (PokeSexGetMonsNo(sp->psp[sp->client_work].monsno,sp->psp[sp->client_work].personal_rnd)==PARA_UNK)||
	   (PokeSexGetMonsNo(sp->psp[sp->tsuika_client].monsno,sp->psp[sp->tsuika_client].personal_rnd)==PARA_UNK)){
		SkillSeqInc(sp,adrs);
	}
	else{
		sp->psp[sp->tsuika_client].condition2|=No2Bit(sp->client_work)<<MEROMERO_SHIFT;
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_SHINPI(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	adrs;
	int	dir;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	dir=BattleWorkMineEnemyCheck(bw,sp->attack_client);

	if(sp->side_condition[dir]&SIDE_CONDITION_SHINPI){
		SkillSeqInc(sp,adrs);
		sp->waza_status_flag|=WAZA_STATUS_FLAG_UMAKUKIMARAN;
	}
	else{
		sp->side_condition[dir]|=SIDE_CONDITION_SHINPI;
		sp->scw[dir].shinpi_count=5;
		sp->scw[dir].shinpi_client=sp->attack_client;
		sp->mp.msg_tag=TAG_NONE_DIR;
		sp->mp.msg_para[0]=sp->attack_client;
		sp->mp.msg_id=ShinpiMineMsg;
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_PRESENT(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	adrs;
	int	present;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	present=gf_rand()&0xff;

	if(present<(255*40/100)){
		sp->damage_power=40;
	}
	else if(present<(255*70/100)){
		sp->damage_power=80;
	}
	else if(present<(255*80/100)){
		sp->damage_power=120;
	}
	else{
		sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[sp->defence_client].hpmax,4);
		SkillSeqInc(sp,adrs);
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_MAGNITUDE(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	if(sp->magnitude==0){
		sp->magnitude=gf_rand()%100;
		if(sp->magnitude<5){
			sp->damage_power=10;
			sp->magnitude=4;
		}
		else if(sp->magnitude<15){
			sp->damage_power=30;
			sp->magnitude=5;
		}
		else if(sp->magnitude<35){
			sp->damage_power=50;
			sp->magnitude=6;
		}
		else if(sp->magnitude<65){
			sp->damage_power=70;
			sp->magnitude=7;
		}
		else if(sp->magnitude<85){
			sp->damage_power=90;
			sp->magnitude=8;
		}
		else if(sp->magnitude<95){
			sp->damage_power=110;
			sp->magnitude=9;
		}
		else{
			sp->damage_power=150;
			sp->magnitude=10;
		}
	}

	sp->add_status_flag_direct=ADD_COND2_MAGNITUDE|ADD_STATUS_WAZAKOUKA_NOHIT;
	sp->msg_work=sp->magnitude;

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_RESHUFFLE_CHECK(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	side;
	int	flag;
	int	adrs;
	int	client_no;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);
	
	//side[h
	side=SkillSeqDataRead(sp);

	//flag[h
	flag=SkillSeqDataRead(sp);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	client_no=SideClientNoGet(bw,sp,side);

	if(ST_ServerReshuffleCheck(bw,sp,client_no)==FALSE){
		SkillSeqInc(sp,adrs);
	}
	else{
		if(flag==POKE_LIST_ON){
			sp->client_status[client_no]|=CLIENT_STATUS_POKE_RESHUFFLE;
		}
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_KOUSOKUSPIN(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	//ߌn̋Z
	if(sp->psp[sp->attack_client].condition2&CONDITION2_SHIME){
		sp->psp[sp->attack_client].condition2&=CONDITION2_SHIME_OFF;
		sp->client_work=sp->psp[sp->attack_client].wkw.shime_client_no;
		sp->waza_work=sp->psp[sp->attack_client].wkw.shime_wazano;
		SkillSequenceGosub(sp,ARC_SUB_SEQ,SUB_SEQ_SHIME_ESCAPE);
		return FALSE;
	}
	//ǂ肬̂
	if(sp->psp[sp->attack_client].waza_kouka&WAZAKOUKA_YADORARE){
		sp->psp[sp->attack_client].waza_kouka&=WAZAKOUKA_YADORARE_OFF;
		sp->psp[sp->attack_client].waza_kouka&=WAZAKOUKA_YADORIGI_OFF;
		SkillSequenceGosub(sp,ARC_SUB_SEQ,SUB_SEQ_YADORIGI_ESCAPE);
		return FALSE;
	}
	//܂т
	if(sp->scw[BattleWorkMineEnemyCheck(bw,sp->attack_client)].makibisi_count){
		sp->scw[BattleWorkMineEnemyCheck(bw,sp->attack_client)].makibisi_count=0;
		SkillSequenceGosub(sp,ARC_SUB_SEQ,SUB_SEQ_MAKIBISI_ESCAPE);
		return FALSE;
	}
	//ǂт
	if(sp->scw[BattleWorkMineEnemyCheck(bw,sp->attack_client)].dokubisi_count){
		sp->scw[BattleWorkMineEnemyCheck(bw,sp->attack_client)].dokubisi_count=0;
		SkillSequenceGosub(sp,ARC_SUB_SEQ,SUB_SEQ_DOKUBISI_ESCAPE);
		return FALSE;
	}

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_WEATHER_KAIFUKU(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//VωȂAV󖳌ɂ̃|P鎞́AMAX̔
	if((sp->field_condition==0)||
	   (ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ALL_HP,0,TOKUSYU_NOOTENKI))||
	   (ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ALL_HP,0,TOKUSYU_EAROKKU))){
		sp->hp_calc_work=sp->psp[sp->attack_client].hpmax/2;
	}
	//̎́AMAX2/3
	else if(sp->field_condition&FIELD_CONDITION_HARE_ALL){
		sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[sp->attack_client].hpmax*20,30);
	}
	//ȊO̓V́AMAX1/4
	else{
		sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[sp->attack_client].hpmax,4);
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_MEZAMERU_POWER(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	sp->damage_power=	((sp->psp[sp->attack_client].hp_rnd&2)		>>1)|
						((sp->psp[sp->attack_client].pow_rnd&2)		>>0)|
						((sp->psp[sp->attack_client].def_rnd&2)		<<1)|
						((sp->psp[sp->attack_client].agi_rnd&2)		<<2)|
						((sp->psp[sp->attack_client].spepow_rnd&2)	<<3)|
						((sp->psp[sp->attack_client].spedef_rnd&2)	<<4);
	sp->waza_type=		((sp->psp[sp->attack_client].hp_rnd&1)		>>0)|
						((sp->psp[sp->attack_client].pow_rnd&1)		<<1)|
						((sp->psp[sp->attack_client].def_rnd&1)		<<2)|
						((sp->psp[sp->attack_client].agi_rnd&1)		<<3)|
						((sp->psp[sp->attack_client].spepow_rnd&1)	<<4)|
						((sp->psp[sp->attack_client].spedef_rnd&1)	<<5);

	sp->damage_power=sp->damage_power*40/63+30;
	sp->waza_type=(sp->waza_type*15/63)+1;

	if(sp->waza_type>=HATE_TYPE){
		sp->waza_type++;
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_JIKOANJI(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	i;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	for(i=COND_HP;i<COND_MAX;i++){
		sp->psp[sp->attack_client].abiritycnt[i]=sp->psp[sp->defence_client].abiritycnt[i];
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_MIRAIYOCHI(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	adrs;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);
	
	//adrs[h
	adrs=SkillSeqDataRead(sp);

	if(sp->fcc.miraiyochi_count[sp->defence_client]==0){
		sp->fcc.miraiyochi_count[sp->defence_client]=3;
		sp->fcc.miraiyochi_wazano[sp->defence_client]=sp->waza_no_now;
		sp->fcc.miraiyochi_client_no[sp->defence_client]=sp->attack_client;
		sp->fcc.miraiyochi_damage[sp->defence_client]=
		WT_WazaDamageCalc(bw,sp,
						  sp->waza_no_now,
						  sp->side_condition[BattleWorkMineEnemyCheck(bw,sp->defence_client)],
						  sp->field_condition,
						  0,0,sp->attack_client,sp->defence_client,1)*-1;
		if(sp->otf[sp->attack_client].tedasuke_flag){
			sp->fcc.miraiyochi_damage[sp->defence_client]=
			sp->fcc.miraiyochi_damage[sp->defence_client]*15/10;
		}
	}
	else{
		SkillSeqInc(sp,adrs);
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_HITCHECK(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	side_a;
	int	side_d;
	int	waza;
	int	adrs;
	int	attack;
	int	defence;
	int	waza_no;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//side_a[h
	side_a=SkillSeqDataRead(sp);

	//side_d[h
	side_d=SkillSeqDataRead(sp);

	//waza[h
	waza=SkillSeqDataRead(sp);
	
	//adrs[h
	adrs=SkillSeqDataRead(sp);

	attack=SideClientNoGet(bw,sp,side_a);
	defence=SideClientNoGet(bw,sp,side_d);
	waza_no=MessageParamWazaGet(sp,waza);

	ServerHitCheckAct(bw,sp,attack,defence,waza_no);

	if(sp->waza_status_flag&WAZA_STATUS_FLAG_HAZURE){
		SkillSeqInc(sp,adrs);
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_TELEPORT(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	adrs;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	if(ST_EscapeNGCheck(bw,sp,sp->attack_client,NULL)){
		SkillSeqInc(sp,adrs);
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_HUKURODATAKI(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int				pos;
	int				poke_count;
	int				mons_no;
	int				level;
	POKEMON_PARAM	*pp;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	poke_count=BattleWorkPokeCountGet(bw,sp->attack_client);
	
	if(sp->renzoku_count_temp==0){
		sp->renzoku_count_temp=2;
		sp->loop_hit_check=RENZOKU_HIT_OFF;
		sp->hukurodataki_count=0;

		while(1){
			pp=BattleWorkPokemonParamGet(bw,sp->attack_client,sp->hukurodataki_count);
			if((sp->hukurodataki_count==sp->sel_mons_no[sp->attack_client])||
			  ((PokeParaGet(pp,ID_PARA_hp,NULL)!=0)&&
			   (PokeParaGet(pp,ID_PARA_monsno_egg,NULL)!=0)&&
			   (PokeParaGet(pp,ID_PARA_monsno_egg,NULL)!=MONSNO_TAMAGO)&&
			   (PokeParaGet(pp,ID_PARA_condition,NULL)==0))){
				break;
			}
			sp->hukurodataki_count++;
		}
	}

	pp=BattleWorkPokemonParamGet(bw,sp->attack_client,sp->hukurodataki_count);
	mons_no=PokeParaGet(pp,ID_PARA_monsno,NULL);
	level=PokeParaGet(pp,ID_PARA_level,NULL);
	sp->damage=PokePersonalParaGet(mons_no,ID_PER_basic_pow);
	sp->damage*=WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_damage);
	sp->damage*=((level*2/5)+2);

	sp->damage/=PokePersonalParaGet(sp->psp[sp->defence_client].monsno,ID_PER_basic_def);
	sp->damage/=50;
	sp->damage+=2;
	sp->damage*=sp->critical;
	if(sp->otf[sp->attack_client].tedasuke_flag){
		sp->damage=sp->damage*15/10;
	}
	sp->damage=WT_DamageLossCalc(sp->damage);
	sp->damage*=-1;

	sp->mp.msg_id=HukurodatakiMineMsg;
	sp->mp.msg_tag=TAG_NICK;
	sp->mp.msg_para[0]=(sp->attack_client|(sp->hukurodataki_count<<8));

	sp->hukurodataki_count++;
	sp->renzoku_count=2;

	if(sp->hukurodataki_count<poke_count){
		while(1){
			pp=BattleWorkPokemonParamGet(bw,sp->attack_client,sp->hukurodataki_count);
			if((sp->hukurodataki_count==sp->sel_mons_no[sp->attack_client])||
			  ((PokeParaGet(pp,ID_PARA_hp,NULL)!=0)&&
			   (PokeParaGet(pp,ID_PARA_monsno_egg,NULL)!=0)&&
			   (PokeParaGet(pp,ID_PARA_monsno_egg,NULL)!=MONSNO_TAMAGO)&&
			   (PokeParaGet(pp,ID_PARA_condition,NULL)==0))){
				break;
			}
			sp->hukurodataki_count++;
			if(sp->hukurodataki_count>=poke_count){
				sp->renzoku_count=1;
				break;
			}
		}
	}
	else{
		sp->renzoku_count=1;
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_KONOYUBITOMARE(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	dir;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	dir=BattleWorkMineEnemyCheck(bw,sp->attack_client);
	sp->scw[dir].konoyubitomare_flag=1;
	sp->scw[dir].konoyubitomare_client=sp->attack_client;

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_TEDASUKE(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	adrs;
	int	client_no;
	int	fight_type;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	fight_type=BattleWorkFightTypeGet(bw);
	
	if(fight_type&FIGHT_TYPE_2vs2){
		client_no=SideClientNoGet(bw,sp,SIDE_ATTACK_PAIR);
		if(((sp->no_reshuffle_client&No2Bit(client_no))==0)&&
			(sp->otf[sp->attack_client].tedasuke_flag==0)&&
			(sp->otf[client_no].tedasuke_flag==0)){
			sp->client_work=client_no;
			sp->otf[client_no].tedasuke_flag=1;
		}
		else{
			SkillSeqInc(sp,adrs);
		}
	}
	else{
		SkillSeqInc(sp,adrs);
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_TRICK(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	adrs;
	u32	fight_type;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	fight_type=BattleWorkFightTypeGet(bw);

	//G̃gbNŁAsFightType`FbN
	if((BattleWorkMineEnemyCheck(bw,sp->attack_client))&&((fight_type&FIGHT_TYPE_DOROBOU)==0)){
		SkillSeqInc(sp,adrs);
	}
	else if(((sp->psp[sp->attack_client].item==0)&&(sp->psp[sp->defence_client].item==0))||
			 (ST_ServerTrickItemCheck(sp,sp->attack_client)==FALSE)||
			 (ST_ServerTrickItemCheck(sp,sp->defence_client)==FALSE)){
		SkillSeqInc(sp,adrs);
	}
	else{
		if(ST_ServerKatayaburiTokuseiCheck(sp,sp->attack_client,sp->defence_client,TOKUSYU_NENTYAKU)==TRUE){
			sp->mp.msg_id=TokuseiNoWazaMineMsg;
			sp->mp.msg_tag=TAG_NICK_TOKU_WAZA;
			sp->mp.msg_para[0]=ST_ServerTagNickParaMake(sp,sp->defence_client);
			sp->mp.msg_para[1]=sp->psp[sp->defence_client].speabino;
			sp->mp.msg_para[2]=sp->waza_no_now;
		}
		else{
			{
				int	item;

				sp->mp.msg_id=TrickMineMsg;
				sp->mp.msg_tag=TAG_NICK;
				sp->mp.msg_para[0]=ST_ServerTagNickParaMake(sp,sp->attack_client);
				item=sp->psp[sp->attack_client].item;
				sp->psp[sp->attack_client].item=sp->psp[sp->defence_client].item;
				sp->psp[sp->defence_client].item=item;
				ST_PSPtoPPCopy(bw,sp,sp->attack_client);
				ST_PSPtoPPCopy(bw,sp,sp->defence_client);
			}
		}
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_NEGAIGOTO(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	adrs;
	u32	fight_type;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	if(sp->fcc.negaigoto_count[sp->attack_client]){
		SkillSeqInc(sp,adrs);
	}
	else{
		sp->fcc.negaigoto_count[sp->attack_client]=2;
		sp->fcc.negaigoto_sel_mons[sp->attack_client]=sp->sel_mons_no[sp->attack_client];
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_NEKONOTE(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int				adrs;
	u16				waza_no[POKEMON_TEMOTI_MAX*WAZA_TEMOTI_MAX];
	u16				waza;
	int				i,j;
	int				poke_count;
	int				waza_count;
	POKEMON_PARAM	*pp;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	waza_count=0;
	poke_count=BattleWorkPokeCountGet(bw,sp->attack_client);

	for(i=0;i<poke_count;i++){
		if(i!=sp->sel_mons_no[sp->attack_client]){
			pp=BattleWorkPokemonParamGet(bw,sp->attack_client,i);
			if((PokeParaGet(pp,ID_PARA_monsno_egg,NULL)!=0)&&
			   (PokeParaGet(pp,ID_PARA_monsno_egg,NULL)!=MONSNO_TAMAGO)){
				for(j=0;j<WAZA_TEMOTI_MAX;j++){
					waza=PokeParaGet(pp,ID_PARA_waza1+j,NULL);
					if((ST_RendouWazaCheck(waza)==FALSE)&&(WT_YubiwohuruNGCheck(waza)==TRUE)){
						waza_no[waza_count]=waza;
						waza_count++;
					}
				}
			}
		}
	}

	if(waza_count){
		sp->waza_work=waza_no[gf_rand()%waza_count];
	}
	else{
		SkillSeqInc(sp,adrs);
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_MAGIC_CORT(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	adrs;
	u32	client_set_max;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	client_set_max=BattleWorkClientSetMaxGet(bw);

	//̃^[ŏIAs
	if(sp->agi_cnt==client_set_max-1){
		SkillSeqInc(sp,adrs);
	}
	else{
		sp->otf[sp->attack_client].magic_cort_flag=1;
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_MAGIC_CORT_A_D(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	dir;
	int	client_no;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	dir=BattleWorkMineEnemyCheck(bw,sp->defence_client);
	client_no=sp->attack_client;
	sp->attack_client=sp->defence_client;

	if((sp->scw[dir].konoyubitomare_flag)&&(sp->psp[sp->scw[dir].konoyubitomare_client].hp)){
		sp->defence_client=sp->scw[dir].konoyubitomare_client;
	}
	else{
		sp->defence_client=client_no;
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_REVENGE(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	if( ((sp->otf[sp->attack_client].butsuri_otf_damage)&&
		 (sp->otf[sp->attack_client].butsuri_otf_client==sp->defence_client)) ||
		((sp->otf[sp->attack_client].tokusyu_otf_damage)&&
		 (sp->otf[sp->attack_client].tokusyu_otf_client==sp->defence_client)) ){
		sp->damage_value=20;
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_KAWARAWARI(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	adrs;
	int	dir;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	dir=BattleWorkMineEnemyCheck(bw,sp->attack_client)^1;

	if((sp->side_condition[dir]&SIDE_CONDITION_BUTSURIGUARD)||
	   (sp->side_condition[dir]&SIDE_CONDITION_TOKUSYUGUARD)){
		sp->side_condition[dir]&=SIDE_CONDITION_BUTSURIGUARD_OFF;
		sp->side_condition[dir]&=SIDE_CONDITION_TOKUSYUGUARD_OFF;
		sp->scw[dir].butsuri_guard_count=0;
		sp->scw[dir].tokusyu_guard_count=0;
	}
	else{
		SkillSeqInc(sp,adrs);
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_AKUBI(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	adrs;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	if(sp->psp[sp->defence_client].waza_kouka&WAZAKOUKA_AKUBI){
		SkillSeqInc(sp,adrs);
	}
	else{
		sp->psp[sp->defence_client].waza_kouka|=AKUBI_COUNT<<1;
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_HATAKIOTOSU(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	adrs;
	int	dir;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	dir=BattleWorkMineEnemyCheck(bw,sp->defence_client);

	if((sp->psp[sp->defence_client].item)&&
	   (ST_ServerKatayaburiTokuseiCheck(sp,sp->attack_client,sp->defence_client,TOKUSYU_NENTYAKU)==TRUE)){
		sp->mp.msg_id=TokuseiNoWazaMineMsg;
		sp->mp.msg_tag=TAG_NICK_TOKU_WAZA;
		sp->mp.msg_para[0]=ST_ServerTagNickParaMake(sp,sp->defence_client);
		sp->mp.msg_para[1]=sp->psp[sp->defence_client].speabino;
		sp->mp.msg_para[2]=sp->waza_no_now;
	}
	else if(sp->psp[sp->defence_client].item){
		sp->mp.msg_id=HatakiotosuM2MMsg;
		sp->mp.msg_tag=TAG_NICK_NICK_ITEM;
		sp->mp.msg_para[0]=ST_ServerTagNickParaMake(sp,sp->attack_client);
		sp->mp.msg_para[1]=ST_ServerTagNickParaMake(sp,sp->defence_client);
		sp->mp.msg_para[2]=sp->psp[sp->defence_client].item;
		sp->psp[sp->defence_client].item=0;
		sp->psp[sp->defence_client].recycle_item=0;
		sp->scw[dir].hatakiotosu_item|=No2Bit(sp->sel_mons_no[sp->defence_client]);
	}
	else{
		SkillSeqInc(sp,adrs);
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_HUNKA(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//2̂ɓZƁAHP2̖ڂōČvZꂽɈЗ͂̂ŁA2ڂ̓pX悤ɂ
	if(sp->damage_power==0){
		sp->damage_power=WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_damage)*
						 sp->psp[sp->attack_client].hp/sp->psp[sp->attack_client].hpmax;
		if(sp->damage_power==0){
			sp->damage_power=1;
		}
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_HUUIN(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	adrs;
	int	dir;
	int	pos_a;
	int	pos_d;
	int	client_no;
	int	client_set_max;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	if(sp->psp[sp->attack_client].waza_kouka&WAZAKOUKA_HUUIN){
		SkillSeqInc(sp,adrs);
	}
	else{
		dir=BattleWorkMineEnemyCheck(bw,sp->attack_client);
		client_set_max=BattleWorkClientSetMaxGet(bw);
		for(client_no=0;client_no<client_set_max;client_no++){
			if(dir!=BattleWorkMineEnemyCheck(bw,client_no)){
				for(pos_a=0;pos_a<WAZA_TEMOTI_MAX;pos_a++){
					for(pos_d=0;pos_d<WAZA_TEMOTI_MAX;pos_d++){
						if((sp->psp[sp->attack_client].waza[pos_a]==sp->psp[client_no].waza[pos_d])&&
						   (sp->psp[sp->attack_client].waza[pos_a])&&(sp->psp[client_no].waza[pos_d])){
							break;
						}
					}
					if(pos_d!=WAZA_TEMOTI_MAX){
						break;
					}
				}
				if(pos_d!=WAZA_TEMOTI_MAX){
					break;
				}
			}
		}
		if(client_no==client_set_max){
			SkillSeqInc(sp,adrs);
		}
		else{
			sp->psp[sp->attack_client].waza_kouka|=WAZAKOUKA_HUUIN;
		}
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_ONNEN(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	adrs;
	int	dir;
	int	pos;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	dir=BattleWorkMineEnemyCheck(bw,sp->defence_client);

	if((sp->psp[sp->kizetsu_client].waza_kouka&WAZAKOUKA_ONNEN)&&
	   (BattleWorkMineEnemyCheck(bw,sp->attack_client)!=BattleWorkMineEnemyCheck(bw,sp->kizetsu_client))&&
	   (sp->psp[sp->attack_client].hp)&&
	   (sp->waza_no_temp!=WAZANO_WARUAGAKI)){
		sp->waza_work=sp->waza_no_temp;
		pos=ST_ServerWazaPosGet(&sp->psp[sp->attack_client],sp->waza_no_temp);
		sp->psp[sp->attack_client].pp[pos]=0;
		ST_PSPtoPPCopy(bw,sp,sp->attack_client);
	}
	else{
		SkillSeqInc(sp,adrs);
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_YOKODORI(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	adrs;
	u32	client_set_max;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	client_set_max=BattleWorkClientSetMaxGet(bw);

	//̃^[ŏIAs
	if(sp->agi_cnt==client_set_max-1){
		SkillSeqInc(sp,adrs);
	}
	else{
		sp->otf[sp->attack_client].yokodori_flag=1;
	}

	return FALSE;
}

//============================================================================================
/**
 *	З̓e[u
 */
//============================================================================================

enum{
	KT_WEIGHT=0,
	KT_POWER,
	KT_MAX
};

static	const	u16	KetaguriTable[][KT_MAX]={
	{   100,    20},
	{   250,    40},
	{   500,    60},
	{  1000,    80},
	{  2000,   100},
	{0xffff,0xffff},
};

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_KETAGURI(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	cnt;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	cnt=0;

	while(KetaguriTable[cnt][KT_WEIGHT]!=0xffff){
	//ۂ͏dƂ邯ǌf[^Ȃ̂ŁAŌyƂ
		break;
	}

	if(KetaguriTable[cnt][KT_WEIGHT]!=0xffff){
		sp->damage_power=KetaguriTable[cnt][KT_POWER];
	}
	else{
		sp->damage_power=120;
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_WEATHER_BALL(BATTLE_WORK *bw,SERVER_PARAM *sp)
{

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	if((ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ALL_HP,0,TOKUSYU_NOOTENKI)==0)&&
	   (ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ALL_HP,0,TOKUSYU_EAROKKU)==0)){
		//VωĂ΁A_[W{
		if(sp->field_condition&FIELD_CONDITION_TENKI){
			sp->damage_value=20;
			if(sp->field_condition&FIELD_CONDITION_AME_ALL){
				sp->waza_type=WATER_TYPE;
			}
			if(sp->field_condition&FIELD_CONDITION_SUNAARASHI_ALL){
				sp->waza_type=IWA_TYPE;
			}
			if(sp->field_condition&FIELD_CONDITION_HARE_ALL){
				sp->waza_type=FIRE_TYPE;
			}
			if(sp->field_condition&FIELD_CONDITION_ARARE){
				sp->waza_type=KOORI_TYPE;
			}
		}
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_OIUCHI_CHECK(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	adrs;
	int	client_no;
	int	client_set_max;
	int	waza_no;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	client_set_max=BattleWorkClientSetMaxGet(bw);

	for(client_no=0;client_no<client_set_max;client_no++){
		if(sp->client_act_work[client_no][ACT_PARA_ACT_NO]!=SERVER_WAZA_END_NO){
			waza_no=ST_ServerSelectWazaGet(sp,client_no);
			if(waza_no){
				if(WT_WazaDataParaGet(waza_no,ID_WTD_battleeffect)==128){
					ST_ServerLoopInit(bw,sp);
					sp->attack_client=client_no;
					sp->defence_client=sp->reshuffle_client;
					sp->damage_value=20;
					sp->waza_no_temp=waza_no;
					sp->waza_no_now=waza_no;
					sp->waza_no_old[client_no]=waza_no;
					sp->client_act_work[client_no][ACT_PARA_ACT_NO]=SERVER_WAZA_END_NO;
					break;
				}
			}
		}
	}

	if(client_no==client_set_max){
		SkillSeqInc(sp,adrs);
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_TYPE_CHECK(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	ST_ServerTypeCheck(bw,sp,sp->waza_no_now,sp->attack_client,sp->defence_client,&sp->waza_status_flag);

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_OTF_SET(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	side;
	int	flag;
	int	client_no;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//side[h
	side=SkillSeqDataRead(sp);

	//flag[h
	flag=SkillSeqDataRead(sp);

	client_no=SideClientNoGet(bw,sp,side);

	switch(flag){
	case OTF_waruagaki_flag:	//邠tO
		sp->otf[client_no].waruagaki_flag=1;
		break;
	case OTF_pp_dec_flag:		//PP炵tO
		sp->otf[client_no].pp_dec_flag=1;
		break;
	case OTF_mamoru_flag:		//܂tO
		sp->otf[client_no].mamoru_flag=1;
		break;
	case OTF_koraeru_flag:		//炦tO
		sp->otf[client_no].koraeru_flag=1;
		break;
	case OTF_item_koraeru_flag:	//炦tOiʁj
		sp->otf[client_no].item_koraeru_flag=1;
		break;
	case OTF_tedasuke_flag:		//ĂtO
		sp->otf[client_no].tedasuke_flag=1;
		break;
	case OTF_magic_cort_flag:
		sp->otf[client_no].magic_cort_flag=1;
		break;
	case OTF_yokodori_flag:
		sp->otf[client_no].yokodori_flag=1;
		break;
	case OTF_haneyasume_flag:
		sp->otf[client_no].haneyasume_flag=1;
		break;
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_SIOMIZU(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	sp->damage_power=1+(150*(sp->psp[sp->defence_client].hpmax-sp->psp[sp->defence_client].hp)/
						sp->psp[sp->defence_client].hpmax);

	if((sp->psp[sp->defence_client].type1==METAL_TYPE)||(sp->psp[sp->defence_client].type2==METAL_TYPE)){
		sp->damage_power=sp->damage_power*15/10;
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_GIROBALL(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	sp->damage_power=1+25*(sp->psp_agi_point[sp->defence_client]/sp->psp_agi_point[sp->attack_client]);

	if(sp->damage_power>150){
		sp->damage_power=150;
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_METALMIRROR(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	adrs;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	if(sp->otf[sp->attack_client].last_otf_damage){
		sp->damage=sp->otf[sp->attack_client].last_otf_damage*15/10;
		sp->defence_client=sp->otf[sp->attack_client].last_otf_client;
	}
	else{
		SkillSeqInc(sp,adrs);
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_TAMEUCHI(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	if(sp->client_act_work[sp->defence_client][ACT_PARA_ACT_NO]==SERVER_WAZA_END_NO){
		sp->damage_value=20;
	}

	return FALSE;
}

//============================================================================================
/**
 *	ӂЗ̓e[u
 */
//============================================================================================
static	const	u8	KirihudaPowerTable[]={
	200,
	80,
	60,
	50,
	40,
};

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_KIRIHUDA(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	u8	pp;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	pp=sp->psp[sp->attack_client].pp[sp->client_act_work[sp->attack_client][ACT_PARA_WORK]-1];

	if(pp>4){
		pp=4;
	}

	sp->damage_power=KirihudaPowerTable[pp];

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_SIBORITORU(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	u8	pp;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	sp->damage_power=1+(150*(sp->psp[sp->defence_client].hp/sp->psp[sp->defence_client].hpmax));

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_SAKIDORI(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int				adrs;
	u16				waza;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	waza=ST_ServerSelectWazaGet(sp,sp->defence_client);

	if((sp->client_act_work[sp->defence_client][ACT_PARA_ACT_NO]!=SERVER_WAZA_END_NO)&&
	   (WT_WazaDataParaGet(waza,ID_WTD_damage))){
		sp->damage_value=15;
		sp->waza_work=waza;
	}
	else{
		SkillSeqInc(sp,adrs);
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_MANEKKO(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	adrs;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	if((ST_RendouWazaCheck(sp->waza_no_last)==FALSE)&&(WT_YubiwohuruNGCheck(sp->waza_no_last)==TRUE)){
		sp->waza_work=sp->waza_no_last;
	}
	else{
		SkillSeqInc(sp,adrs);
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_OSIOKI(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	para;
	int	cnt;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	cnt=1;

	for(para=COND_HP;para<COND_MAX;para++){
		if(sp->psp[sp->defence_client].abiritycnt[para]>6){
			cnt+=(sp->psp[sp->defence_client].abiritycnt[para]-6);
		}
	}

	sp->damage_power=20*cnt;
	
	if(sp->damage_power>200){
		sp->damage_power=200;
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_HUIUCHI(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	adrs;
	int	waza;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	waza=ST_ServerSelectWazaGet(sp,sp->defence_client);

	if((sp->client_act_work[sp->defence_client][ACT_PARA_ACT_NO]==SERVER_WAZA_END_NO)||
	   (WT_WazaDataParaGet(waza,ID_WTD_damage)==0)){
		SkillSeqInc(sp,adrs);
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_SIDE_CONDITION_CHECK(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	side;
	int	mode;
	int	flag;
	int	adrs;
	int	client_no;
	int	dir;
	int	count;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//side[h
	side=SkillSeqDataRead(sp);

	//mode[h
	mode=SkillSeqDataRead(sp);

	//flag[h
	flag=SkillSeqDataRead(sp);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	client_no=SideClientNoGet(bw,sp,side);
	dir=BattleWorkMineEnemyCheck(bw,client_no);

	switch(mode){
	case SCC_MODE_Z_CHECK:
	case SCC_MODE_NZ_CHECK:
		switch(flag){
		case SCC_butsuri_guard_count:
			count=sp->scw[dir].butsuri_guard_count;
			break;
		case SCC_tokusyu_guard_count:
			count=sp->scw[dir].tokusyu_guard_count;
			break;
		case SCC_shiroikiri_count:
			count=sp->scw[dir].shiroikiri_count;
			break;
		case SCC_shinpi_count:
			count=sp->scw[dir].shinpi_count;
			break;
		case SCC_makibisi_count:
			count=sp->scw[dir].makibisi_count;
			break;
		case SCC_dokubisi_count:
			count=sp->scw[dir].dokubisi_count;
			break;
		}
		break;
	case SCC_MODE_CLEAR:
		switch(flag){
		case SCC_butsuri_guard_count:
			sp->scw[dir].butsuri_guard_count=0;
			sp->side_condition[dir]&=SIDE_CONDITION_BUTSURIGUARD_OFF;
			break;
		case SCC_tokusyu_guard_count:
			sp->scw[dir].tokusyu_guard_count=0;
			sp->side_condition[dir]&=SIDE_CONDITION_TOKUSYUGUARD_OFF;
			break;
		case SCC_shiroikiri_count:
			sp->scw[dir].shiroikiri_count=0;
			sp->side_condition[dir]&=SIDE_CONDITION_SHIROIKIRI_OFF;
			break;
		case SCC_shinpi_count:
			sp->scw[dir].shinpi_count=0;
			sp->side_condition[dir]&=SIDE_CONDITION_SHINPI_OFF;
			break;
		case SCC_makibisi_count:
			sp->scw[dir].makibisi_count=0;
			break;
		case SCC_dokubisi_count:
			sp->scw[dir].dokubisi_count=0;
			break;
		}
		break;
	}

	if((mode==SCC_MODE_Z_CHECK)&&(count==0)){
		SkillSeqInc(sp,adrs);
	}
	if((mode==SCC_MODE_NZ_CHECK)&&(count)){
		SkillSeqInc(sp,adrs);
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_FEINT(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	adrs;
	int	waza;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	if(sp->otf[sp->defence_client].mamoru_flag){
		sp->otf[sp->defence_client].mamoru_flag=0;
	}
	else{
		SkillSeqInc(sp,adrs);
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_SURIKOMI(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	adrs;
	int	waza;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	if((sp->psp[sp->defence_client].condition)||
	   (sp->psp[sp->defence_client].condition2&CONDITION2_MIGAWARI)||
	   (sp->psp[sp->attack_client].condition==0)){
		SkillSeqInc(sp,adrs);
	}
	else{
		if(sp->psp[sp->attack_client].condition&CONDITION_NEMURI){
			sp->add_status_flag_direct=ADD_COND_NEMURI|ADD_STATUS_DEFENCE|ADD_STATUS_WAZAKOUKA_NOHIT;
		}
		else if(sp->psp[sp->attack_client].condition&CONDITION_DOKU){
			sp->add_status_flag_direct=ADD_COND_DOKU|ADD_STATUS_DEFENCE|ADD_STATUS_WAZAKOUKA_NOHIT;
		}
		else if(sp->psp[sp->attack_client].condition&CONDITION_YAKEDO){
			sp->add_status_flag_direct=ADD_COND_YAKEDO|ADD_STATUS_DEFENCE|ADD_STATUS_WAZAKOUKA_NOHIT;
		}
		else if(sp->psp[sp->attack_client].condition&CONDITION_MAHI){
			sp->add_status_flag_direct=ADD_COND_MAHI|ADD_STATUS_DEFENCE|ADD_STATUS_WAZAKOUKA_NOHIT;
		}
		else if(sp->psp[sp->attack_client].condition&CONDITION_DOKUDOKU){
			sp->add_status_flag_direct=ADD_COND_DOKUDOKU|ADD_STATUS_DEFENCE|ADD_STATUS_WAZAKOUKA_NOHIT;
		}
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_TOTTEOKI(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	adrs;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	if(sp->psp[sp->attack_client].wkw.totteoki_count!=ST_ServerWazaCountGet(bw,sp,sp->attack_client)){
		SkillSeqInc(sp,adrs);
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_DOKUBISI(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	adrs;
	int	dir;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	dir=BattleWorkMineEnemyCheck(bw,sp->attack_client)^1;

	if(sp->scw[dir].dokubisi_count==2){
		sp->ostf[sp->attack_client].no_pressure_flag=1;
		SkillSeqInc(sp,adrs);
	}
	else{
		sp->scw[dir].dokubisi_count++;
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_DOKUBISI_CHECK(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	side;
	int	adrs;
	int	client_no;
	int	dir;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//side[h
	side=SkillSeqDataRead(sp);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	client_no=SideClientNoGet(bw,sp,side);
	dir=BattleWorkMineEnemyCheck(bw,client_no);

	if(sp->scw[dir].dokubisi_count){
		sp->calc_work=sp->scw[dir].dokubisi_count;
		sp->tsuika_type=ADD_STATUS_WAZAKOUKA;
		sp->tsuika_client=client_no;
		if((sp->psp[sp->reshuffle_client].type1==POISON_TYPE)||(sp->psp[sp->reshuffle_client].type2==POISON_TYPE)){
			sp->scw[dir].dokubisi_count=0;
			sp->calc_work=0;
		}
	}
	else{
		SkillSeqInc(sp,adrs);
	}

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_KATAYABURI_TOKUSEI_CHECK(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	flag;
	int	side;
	int	tokusei;
	int	adrs;
	int	client_no;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//flag[h
	flag=SkillSeqDataRead(sp);

	//side[h
	side=SkillSeqDataRead(sp);

	//tokusei[h
	tokusei=SkillSeqDataRead(sp);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	//SIDE_ALL̎́AɂłĂ|PׂĂ`FbN
	if(side==SIDE_ALL){
		{
			int	client_set_max;

			client_set_max=BattleWorkClientSetMaxGet(bw);

			for(client_no=0;client_no<client_set_max;client_no++){
				if(flag==TOKUSEI_HAVE){
					if((ST_ServerKatayaburiTokuseiCheck(sp,sp->attack_client,client_no,tokusei)==TRUE)&&(sp->psp[client_no].hp)){
						SkillSeqInc(sp,adrs);
						sp->tokusei_client=client_no;
						break;
					}
				}
				else{
					//NĂȂƂ`FbN
					if((ST_ServerKatayaburiTokuseiCheck(sp,sp->attack_client,client_no,tokusei)==TRUE)&&(sp->psp[client_no].hp)){
						break;
					}
				}
			}
		}
	}
	else{
		client_no=SideClientNoGet(bw,sp,side);
	
		if(flag==TOKUSEI_HAVE){
			if((ST_ServerKatayaburiTokuseiCheck(sp,sp->attack_client,client_no,tokusei)==TRUE)&&(sp->psp[client_no].hp)){
				SkillSeqInc(sp,adrs);
				sp->tokusei_client=client_no;
			}
		}
		else{
			if((ST_ServerKatayaburiTokuseiCheck(sp,sp->attack_client,client_no,tokusei)==FALSE)&&(sp->psp[client_no].hp)){
				SkillSeqInc(sp,adrs);
				sp->tokusei_client=client_no;
			}
		}
	}

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_SIDE_CHECK(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	src;
	int	dest;
	int	adrs;
	int	client_s;
	int	client_d;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//src[h
	src=SkillSeqDataRead(sp);

	//dest[h
	dest=SkillSeqDataRead(sp);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	client_s=SideClientNoGet(bw,sp,src);
	client_d=SideClientNoGet(bw,sp,dest);

	if(BattleWorkMineEnemyCheck(bw,client_s)==BattleWorkMineEnemyCheck(bw,client_d)){
		SkillSeqInc(sp,adrs);
	}

	return	FALSE;
}

//============================================================================================
/**
 *	̂Ђ낢e[u
 */
//============================================================================================
static const u16 MonohiroiTable1[]={
	ITEM_KIZUGUSURI,
	ITEM_DOKUKESI,
	ITEM_IIKIZUGUSURI,
	ITEM_SUUPAABOORU,
	ITEM_MUSIYOKESUPUREE,
	ITEM_ANANUKENOHIMO,
	ITEM_PURASUPAWAA,
	ITEM_NANDEMONAOSI,
	ITEM_HAIPAABOORU,
	ITEM_SUGOIKIZUGUSURI,
	ITEM_HUSIGINAAME,
	ITEM_TAURIN,
	ITEM_GENKINOKAKERA,
	ITEM_MAKKUSUAPPU,
	ITEM_KAIHUKUNOKUSURI,
	ITEM_GENKINOKATAMARI,
	ITEM_POINTOAPPU,
	ITEM_PIIPIIMAKKUSU,
};

static const u16 MonohiroiTable2[]={
	ITEM_SUGOIKIZUGUSURI,
	ITEM_KINNOTAMA,
	ITEM_OUZYANOSIRUSI,
	ITEM_KAIHUKUNOKUSURI,
	ITEM_PIIPIIEIDO,
	ITEM_SIROIHAABU,
	ITEM_WAZAMASIN44,	//˂ނ
	ITEM_PIIPIIEIDAA,
	ITEM_WAZAMASIN01,	//p`
	ITEM_TABENOKOSI,
	ITEM_WAZAMASIN26,	//
};

static	const u8 ItemProb[] = {		//EACe̊m
	30,		// 30%
	40,		// 10%
	50,		// 10%
	60,		// 10%
	70,		// 10%
	80,		// 10%
	90,		// 10%
	94,		// 4%
	98,		// 4%
};//c2͕ʂŊǗ

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_MONOHIROI(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	rnd;
	int	i,j;
	u16 monsno;
	u16 itemno;
	u8	speabi;
	u8	LvOffset;
	POKEMON_PARAM	*pp;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	for(i=0;i<BattleWorkPokeCountGet(bw,CLIENT_NO_MINE);i++){
		pp=BattleWorkPokemonParamGet(bw,CLIENT_NO_MINE,i);
		monsno=PokeParaGet(pp,ID_PARA_monsno_egg,NULL);
		itemno=PokeParaGet(pp,ID_PARA_item,NULL);
		speabi=PokeParaGet(pp,ID_PARA_speabino,NULL);
		if((speabi==TOKUSYU_MONOHIROI)&&(monsno!=0)&&(monsno!=MONSNO_TAMAGO)&&(itemno==0)&&((gf_rand()%10)==0)){
			rnd=gf_rand()%100;
			LvOffset=(PokeParaGet(pp,ID_PARA_level,NULL)-1)/10;
			if(LvOffset>=10){
				LvOffset=9;//x100𒴂Ȃ΂肦ȂAÔ
			}
			for(j=0;j<9;j++){
				if(ItemProb[j]>rnd){
					PokeParaPut(pp,ID_PARA_item,(u8 *)&MonohiroiTable1[LvOffset+j]);
					break;
				}
				else if((rnd>=98)&&(rnd<=99)){
					PokeParaPut(pp,ID_PARA_item,(u8 *)&MonohiroiTable2[LvOffset+(99-rnd)]);
					break;
				}
			}
		}
	}

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_TRICKROOM(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	i,j;
	int	cl1;
	int	cl2;
	int	flag;
	int	client_set_max;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	client_set_max=BattleWorkClientSetMaxGet(bw);

	for(i=0;i<client_set_max-1;i++){
		for(j=i+1;j<client_set_max;j++){
			cl1=sp->client_agi_work[i];
			cl2=sp->client_agi_work[j];
			if(sp->client_act_work[cl1][ACT_PARA_SELECT_COMMAND]==sp->client_act_work[cl2][ACT_PARA_SELECT_COMMAND]){
				if(sp->client_act_work[cl1][ACT_PARA_SELECT_COMMAND]==SELECT_FIGHT_COMMAND){
					flag=0;
				}
				else{
					flag=1;
				}
				if(ST_ServerAgiCalc(bw,sp,cl1,cl2,flag)){
					sp->client_agi_work[i]=cl2;
					sp->client_agi_work[j]=cl1;
				}
			}
		}
	}

	sp->ostf[sp->attack_client].trickroom_flag=1;

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_WAZA_OUT_CHECK(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	client_no;
	int	side;
	int	adrs;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//side[h
	side=SkillSeqDataRead(sp);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	client_no=SideClientNoGet(bw,sp,side);

	if(ST_ServerWazaEndCheck(sp,client_no)==TRUE){
		SkillSeqInc(sp,adrs);
	}

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_SOUBI_CHECK(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	client_no;
	int	flag;
	int	side;
	int	adrs;
	u16	item_no;
	u8	eqp;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//flag[h
	flag=SkillSeqDataRead(sp);

	//side[h
	side=SkillSeqDataRead(sp);

	//eqp[h
	eqp=SkillSeqDataRead(sp);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	client_no=SideClientNoGet(bw,sp,side);

	if(flag==SOUBI_HAVE){
		if(ST_ServerSoubiEqpGet(sp,client_no)==eqp){
			SkillSeqInc(sp,adrs);
		}
	}
	else{
		if(ST_ServerSoubiEqpGet(sp,client_no)!=eqp){
			SkillSeqInc(sp,adrs);
		}
	}

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_SOUBI_PARA_GET(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	client_no;
	int	side;
	int	para;
	int	*data;
	u16	item_no;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//side[h
	side=SkillSeqDataRead(sp);

	//para[h
	para=SkillSeqDataRead(sp);

	data=WS_SrcPointerGet(bw,sp,para);

	client_no=SideClientNoGet(bw,sp,side);

	item_no=ST_ServerSoubiItemNoGet(sp,client_no);
	data[0]=ItemParamGet(item_no,ITEM_PRM_ATTACK,HEAPID_BATTLE);

	return	FALSE;
}

//============================================================================================
/**
 *	ق傭e[u
 */
//============================================================================================
static	const	u8	HogosyokuTypeTable[]={
	JIMEN_TYPE,		//
	JIMEN_TYPE,		//l
	KUSA_TYPE,		//Ő
	KUSA_TYPE,		//܂
	IWA_TYPE,		//┧
	IWA_TYPE,		//A
	KOORI_TYPE,		//ጴ
	WATER_TYPE,		//
	KOORI_TYPE,		//X
	NORMAL_TYPE,	//
	JIMEN_TYPE,		//n
	HIKOU_TYPE,		//݂苴
	NORMAL_TYPE,	//ȊOiꉞ`j
};

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_HOGOSYOKU(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	adrs;
	int	ground;
	int	type;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	ground=BattleWorkGroundIDGet(bw);
	type=HogosyokuTypeTable[ground];

	if((sp->psp[sp->attack_client].type1!=type)&&
	   (sp->psp[sp->attack_client].type2!=type)){
		sp->psp[sp->attack_client].type1=type;
		sp->psp[sp->attack_client].type2=type;
		sp->msg_work=type;
	}
	else{
		SkillSeqInc(sp,adrs);
	}

	return	FALSE;
}

//============================================================================================
/**
 *	̂e[u
 */
//============================================================================================
static	const	u16	ShizennochikaraWazaTable[]={
	WAZANO_ZISIN,			//
	WAZANO_ZISIN,			//l
	WAZANO_TANEBAKUDAN,		//Ő
	WAZANO_TANEBAKUDAN,		//܂
	WAZANO_IWANADARE,		//┧
	WAZANO_IWANADARE,		//A
	WAZANO_HUBUKI,			//ጴ
	WAZANO_HAIDOROPONPU,	//
	WAZANO_REITOUBIIMU,		//X
	WAZANO_TORAIATAKKU,		//
	WAZANO_DOROBAKUDAN,		//n
	WAZANO_EASURASSYU,		//݂苴
	WAZANO_TORAIATAKKU,		//ȊOiꉞ`j
};

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_SHIZENNOCHIKARA(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	ground;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	ground=BattleWorkGroundIDGet(bw);

	sp->waza_work=ShizennochikaraWazaTable[ground];

	return FALSE;
}

//============================================================================================
/**
 *	Ђ݂̂e[u
 */
//============================================================================================
static	const	u16	HimitsunochikaraAddTable[]={
	ADD_COND2_HITDOWN|	ADD_STATUS_DEFENCE,		//
	ADD_COND2_HITDOWN|	ADD_STATUS_DEFENCE,		//l
	ADD_COND_NEMURI|	ADD_STATUS_DEFENCE,		//Ő
	ADD_COND_NEMURI|	ADD_STATUS_DEFENCE,		//܂
	ADD_COND2_HIRUMU|	ADD_STATUS_DEFENCE,		//┧
	ADD_COND2_HIRUMU|	ADD_STATUS_DEFENCE,		//A
	ADD_COND_KOORI|		ADD_STATUS_DEFENCE,		//ጴ
	ADD_COND2_POWDOWN|	ADD_STATUS_DEFENCE,		//
	ADD_COND_KOORI|		ADD_STATUS_DEFENCE,		//X
	ADD_COND_MAHI|		ADD_STATUS_DEFENCE,		//
	ADD_COND2_AGIDOWN|	ADD_STATUS_DEFENCE,		//n
	ADD_COND2_AVOIDDOWN|ADD_STATUS_DEFENCE,		//݂苴
	ADD_COND_MAHI|		ADD_STATUS_DEFENCE,		//ȊOiꉞ`j
};

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_HIMITSUNOCHIKARA(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	ground;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	ground=BattleWorkGroundIDGet(bw);

	sp->add_status_flag_indirect=HimitsunochikaraAddTable[ground];

	return FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_SHIZENNOMEGUMI(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	adrs;
	int	atk;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	atk=ST_ServerShizennomegumiAtkGet(sp,sp->attack_client);

	if(atk){
		sp->damage_power=atk;
		sp->waza_type=ST_ServerShizennomegumiTypeGet(sp,sp->attack_client);
	}
	else{
		SkillSeqInc(sp,adrs);
	}

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_TSUIBAMU(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	adrs;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	if(ST_ServerTsuibamuCheck(bw,sp,sp->defence_client)!=TRUE){
		SkillSeqInc(sp,adrs);
	}

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_NAGETSUKERU(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	adrs;

	//߃R[hǂݔ΂
	SkillSeqInc(sp,1);

	//adrs[h
	adrs=SkillSeqDataRead(sp);

	if(ST_ServerNagetsukeruCheck(bw,sp,sp->attack_client)!=TRUE){
		SkillSeqInc(sp,adrs);
	}

	return	FALSE;
}

//============================================================================================
/**
 * @param[in]	bw	퓬p[N\
 * @param[in]	sp	T[opp[^[N\
 */
//============================================================================================
static	BOOL	WS_SEQ_END(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	return	ST_ServerSequencePushCheck(sp);
}

//============================================================================================
/**
 *	V[PXf[^[Nf[^[h
 *
 * @param[in]	sp	T[o[N\
 */
//============================================================================================
static	int		SkillSeqDataRead(SERVER_PARAM *sp)
{
	int	data;

	data=sp->SkillSeqWork[sp->skill_seq_no];
	sp->skill_seq_no++;

	return	data;
}

//============================================================================================
/**
 *	V[PXf[^CfbNXCNg
 *
 * @param[in]	sp	T[o[N\
 * @param[in]	cnt	CNg鐔
 */
//============================================================================================
static	void	SkillSeqInc(SERVER_PARAM *sp,int cnt)
{
	sp->skill_seq_no+=cnt;
}

//============================================================================================
/**
 *	ʂ̃V[PXɃWv
 *
 * @param[in]	sp			T[o[N\
 * @param[in]	arc_kind	V[PXf[^̃A[JCu̎
 * @param[in]	adrs		ѐV[PXINDEX
 */
//============================================================================================
static	void	SkillSequenceJump(SERVER_PARAM *sp,int arc_kind,int adrs)
{
	ST_ServerSequenceLoad(sp,arc_kind,adrs);
}

//============================================================================================
/**
 *	ʂ̃V[PXɃTu[`Wv
 *
 * @param[in]	sp			T[o[N\
 * @param[in]	arc_kind	V[PXf[^̃A[JCu̎
 * @param[in]	adrs		ѐV[PXINDEX
 */
//============================================================================================
static	void	SkillSequenceGosub(SERVER_PARAM *sp,int arc_kind,int adrs)
{
	ST_ServerSequenceLoadGosub(sp,arc_kind,adrs);
}

//============================================================================================
/**
 *	srcp[^Ɏw肳ꂽobt@̃|C^擾
 *
 * @param[in]	sp			T[o[N\
 * @param[in]	arc_kind	V[PXf[^̃A[JCu̎
 * @param[in]	adrs		ѐV[PXINDEX
 */
//============================================================================================
static	void	*WS_SrcPointerGet(BATTLE_WORK *bw,SERVER_PARAM *sp,int para)
{
	switch(para){
	case BUF_PARA_FIGHT_TYPE:
		return &bw->fight_type;
	case BUF_PARA_CRITICAL_COUNT:
		return &sp->critical_count;
	case BUF_PARA_ADD_STATUS_DIRECT:
		return &sp->add_status_flag_direct;
	case BUF_PARA_ADD_STATUS_INDIRECT:
		return &sp->add_status_flag_indirect;
	case BUF_PARA_ADD_STATUS_TOKUSEI:
		return &sp->add_status_flag_tokusei;
	case BUF_PARA_TSUIKA_TYPE:
		return &sp->tsuika_type;
	case BUF_PARA_SERVER_STATUS_FLAG:
		return &sp->server_status_flag;
	case BUF_PARA_FIELD_CONDITION:
		return &sp->field_condition;
	case BUF_PARA_DAMAGE_VALUE:
		return &sp->damage_value;
	case BUF_PARA_CALC_WORK:
		return &sp->calc_work;
	case BUF_PARA_WAZA_STATUS_FLAG:
		return &sp->waza_status_flag;
	case BUF_PARA_SIDE_CONDITION_ATTACK:
		return &sp->side_condition[BattleWorkMineEnemyCheck(bw,sp->attack_client)];
	case BUF_PARA_SIDE_CONDITION_DEFENCE:
		return &sp->side_condition[BattleWorkMineEnemyCheck(bw,sp->defence_client)];
	case BUF_PARA_SIDE_CONDITION_TSUIKA:
		return &sp->side_condition[BattleWorkMineEnemyCheck(bw,sp->tsuika_client)];
	case BUF_PARA_DAMAGE:
		return &sp->damage;
	case BUF_PARA_ATTACK_CLIENT:
		return &sp->attack_client;
	case BUF_PARA_DEFENCE_CLIENT:
		return &sp->defence_client;
	case BUF_PARA_TSUIKA_CLIENT:
		return &sp->tsuika_client;
	case BUF_PARA_KIZETSU_CLIENT:
		return &sp->kizetsu_client;
	case BUF_PARA_RESHUFFLE_CLIENT:
		return &sp->reshuffle_client;
	case BUF_PARA_CLIENT_WORK:
		return &sp->client_work;
	case BUF_PARA_STORE_DAMAGE_ATTACK:
		return &sp->store_damage[sp->attack_client];
	case BUF_PARA_MSG_WORK:
		return &sp->msg_work;
	case BUF_PARA_KOBAN_COUNTER:
		return &sp->koban_counter;
	case BUF_PARA_WAZA_NO_NOW:
		return &sp->waza_no_now;
	case BUF_PARA_TOTAL_TURN:
		return &sp->total_turn;
	case BUF_PARA_ATTACK_CLIENT_WORK:
		return &sp->attack_client_work;
	case BUF_PARA_DEFENCE_CLIENT_WORK:
		return &sp->defence_client_work;
	case BUF_PARA_WAZA_NO_TEMP:
		return &sp->waza_no_temp;
	case BUF_PARA_PUSH_CLIENT:
		return &sp->push_client;
	case BUF_PARA_DAMAGE_POWER:
		return &sp->damage_power;
	case BUF_PARA_SWOAM_TYPE:
		return &sp->swoam_type;
	case BUF_PARA_HP_CALC_WORK:
		return &sp->hp_calc_work;
	case BUF_PARA_WIN_LOSE_FLAG:
		return &sp->win_lose_flag;
	case BUF_PARA_TSUIKA_PARA:
		return &sp->tsuika_para;
	case BUF_PARA_WAZA_WORK:
		return &sp->waza_work;
	case BUF_PARA_ITEM_WORK:
		return &sp->item_work;
	case BUF_PARA_TOKUSEI_WORK:
		return &sp->tokusei_work;
	case BUF_PARA_WEATHER_COUNT:
		return &sp->fcc.weather_count;
	case BUF_PARA_CLIENT_NO_AGI:
		return &sp->client_no_agi;
	case BUF_PARA_LOOP_FLAG:
		return &sp->loop_flag;
	case BUF_PARA_BUTSURI_DAMAGE_ATTACK:
		return &sp->otf[sp->attack_client].butsuri_otf_damage;
	case BUF_PARA_TOKUSYU_DAMAGE_ATTACK:
		return &sp->otf[sp->attack_client].tokusyu_otf_damage;
	case BUF_PARA_TEMP_WORK:
		return &sp->temp_work;
	case BUF_PARA_CRITICAL:
		return &sp->critical;
	case BUF_PARA_LAST_DAMAGE_ATTACK:
		return &sp->otf[sp->attack_client].last_otf_damage;
	case BUF_PARA_LAST_DAMAGE_DEFENCE:
		return &sp->otf[sp->defence_client].last_otf_damage;
	case BUF_PARA_OSTF_STATUS_FLAG_ATTACK:
		return &sp->ostf[sp->attack_client].status_flag;
	case BUF_PARA_OSTF_STATUS_FLAG_DEFENCE:
		return &sp->ostf[sp->defence_client].status_flag;
	case BUF_PARA_OSTF_STATUS_FLAG_TSUIKA:
		return &sp->ostf[sp->tsuika_client].status_flag;
	case BUF_PARA_NAGETSUKERU_WORK:
		return &sp->nagetsukeru_work;
	case BUF_PARA_NAGETSUKERU_SEQ_NO:
		return &sp->nagetsukeru_seq_no;
	case BUF_PARA_BATTLE_STATUS_FLAG:
		return &bw->battle_status_flag;
	}
	OS_Printf("WS_SrcPointerGet:ɂ̂͊ԈႢI\n");
	return NULL;
}

//============================================================================================
/**
 *	TCB֘A
 */
//============================================================================================
//============================================================================================
/**
 *	GET_EXPpV[PX`
 */
//============================================================================================
enum{
	SEQ_GE_INIT=0,
	SEQ_GE_EXP_MESSAGE_INDEX_WAIT,
	SEQ_GE_EXP_MESSAGE_WAIT,
	SEQ_GE_EXP_GAUGE,
	SEQ_GE_EXP_GAUGE_WAIT,
	SEQ_GE_LEVELUP_CHECK,
	SEQ_GE_LEVELUP_MSG_INDEX_WAIT,
	SEQ_GE_LEVELUP_MSG_WAIT,
	SEQ_GE_WAZAOBOE_CHECK,
	SEQ_GE_WAZAOBOE_MSG_INDEX_WAIT,
	SEQ_GE_WAZAOBOE_MSG_WAIT,
	SEQ_GE_END
};

//============================================================================================
/**
 *	GET_EXPtsiw->work̓Y
 */
//============================================================================================
enum{
	GE_MSG_INDEX=0,
	GE_MSG_WAIT,
	GE_WAZA_CNT,
	GE_NOW_EXP
};

//============================================================================================
/**
 *	ollpTCB
 *
 * @param[in]	tcb		TCBVXe[N
 * @param[in]	work	[NGA|C^
 */
//============================================================================================
static	void	TCB_GetExp(TCB_PTR tcb,void *work)
{
	int					sel_mons_no;
	TCB_SKILL_INTP_WORK	*tsiw=work;
	POKEMON_PARAM		*pp;
	MESSAGE_PARAM		mp;
	int					client_no;
	int					exp_client_no;

	client_no=(tsiw->sp->kizetsu_client)>>1&1;

	for(sel_mons_no=0;sel_mons_no<6;sel_mons_no++){
		if(tsiw->sp->get_exp_right_flag[client_no]&No2Bit(sel_mons_no)){
			break;
		}
	}

	exp_client_no=CLIENT_NO_MINE;

	if(BattleWorkFightTypeGet(tsiw->bw)&FIGHT_TYPE_2vs2){
		if(tsiw->sp->sel_mons_no[CLIENT_NO_MINE2]==sel_mons_no){
			exp_client_no=CLIENT_NO_MINE2;
		}
	}

	pp=BattleWorkPokemonParamGet(tsiw->bw,exp_client_no,sel_mons_no);

	mp.msg_tag=TAG_NICK_NUM;
	mp.msg_para[0]=exp_client_no|(sel_mons_no<<8);

	switch(tsiw->seq_no){
	case SEQ_GE_INIT:
		{
			int				itemno;
			int				eqp;
			u32				get_exp_total;
			u32				exp;
			u32				fight_type;
			GF_BGL_BMPWIN	*win;
			MSGDATA_MANAGER	*msg_m;

			fight_type=BattleWorkFightTypeGet(tsiw->bw);
			win=BattleWorkGF_BGL_BMPWINGet(tsiw->bw);
			msg_m=BattleWorkFightMsgGet(tsiw->bw);
			itemno=PokeParaGet(pp,ID_PARA_item,NULL);
			eqp=ItemParamGet(itemno,ITEM_PRM_EQUIP,HEAPID_BATTLE);

			PokeExpCalc(BattleWorkPokePartyGet(tsiw->bw,exp_client_no),
						sel_mons_no,
						tsiw->sp->psp[tsiw->sp->kizetsu_client].monsno);

#warning FightEndME NoPlay
			//쐶|PƂ̐퓬ł
			//ol炦鎞_ŏy
//			if(((fight_type&FIGHT_TYPE_TRAINER)==0)&&(sp->psp[0].hp)&&(BattleWork_P[JINGLE_FLAG]==0)){
#if 1
			if(((fight_type&FIGHT_TYPE_TRAINER)==0)&&
			   ((fight_type&FIGHT_TYPE_MULTI)==0)){
				Snd_BgmPlay(SEQ_WINPOKE);
			}
#endif
			get_exp_total=0;

			if((PokeParaGet(pp,ID_PARA_hp,NULL))&&(PokeParaGet(pp,ID_PARA_level,NULL)!=100)){
				get_exp_total=tsiw->sp->get_exp;
	
				//wKuĂA̕ǉ
				if(eqp==SOUBI_KEIKENTIGET){
					get_exp_total+=tsiw->sp->gakusyuu_get_exp;
				}
				//olʂ̃ACeĂA1.5{
				if(eqp==SOUBI_KEIKENTIHUERU){
					get_exp_total=get_exp_total*150/100;
				}
				//g[i[킾A1.5{
				if(fight_type&FIGHT_TYPE_TRAINER){
					get_exp_total=get_exp_total*150/100;
				}
#warning GET_EXP NoCheck PokeOneSelf
				//l|PA1.5{
//				if(PokeOneSelfCheck(&PokeParaMine[BattleWork_P[GETEXP_SELMONS]])){
//					//AI}`퓬ŁAp[gi[̃|ṔAu߂ɁvvZȂ
//					if((fight_type&FIGHT_TYPE_AI_MULTI)&&(BattleWork_P[GETEXP_SELMONS]>=3)){
//						i=KEIKENTIGETNORMALMSGNO;
//					}
//					else{
//						get_exp_total=get_exp_total*150/100;
//						i=KEIKENTIGETOOMEMSGNO;
//					}
//				}
//				else{
//					i=KEIKENTIGETNORMALMSGNO;
//				}
				exp=PokeParaGet(pp,ID_PARA_exp,NULL);
				tsiw->work[GE_NOW_EXP]=exp-PokeParaLevelExpGet(pp);
				exp+=get_exp_total;
				if(sel_mons_no==tsiw->sp->sel_mons_no[exp_client_no]){
					tsiw->sp->psp[exp_client_no].exp=exp;
				}
				PokeParaPut(pp,ID_PARA_exp,(u8 *)&exp);
			}

			if(get_exp_total){
				mp.msg_id=KeikentiGetMsg;
				mp.msg_para[1]=get_exp_total;
				tsiw->work[GE_MSG_INDEX]=BattleMSG_Print(tsiw->bw,win,msg_m,&mp,1);
				tsiw->work[GE_MSG_WAIT]=40;
				tsiw->seq_no++;
			}
			else{
				tsiw->seq_no=SEQ_GE_END;
			}
		}
		break;
	case SEQ_GE_EXP_MESSAGE_INDEX_WAIT:
		if(GF_MSG_PrintEndCheck(tsiw->work[GE_MSG_INDEX])==0){
			tsiw->seq_no++;
		}
		break;
	case SEQ_GE_EXP_MESSAGE_WAIT:
		if(--tsiw->work[GE_MSG_WAIT]==0){
			tsiw->seq_no++;
		}
		break;
	case SEQ_GE_EXP_GAUGE:
		if(sel_mons_no==tsiw->sp->sel_mons_no[exp_client_no]){
			SCIO_EXPGaugeCalcSet(tsiw->bw,tsiw->sp,exp_client_no,tsiw->work[GE_NOW_EXP]);
			tsiw->work[GE_NOW_EXP]=0;
			tsiw->seq_no++;
		}
		else{
			tsiw->seq_no=SEQ_GE_LEVELUP_CHECK;
		}
		break;
	case SEQ_GE_EXP_GAUGE_WAIT:
		if(ST_ServerQueCheck(tsiw->sp)){
			tsiw->seq_no++;
		}
		break;
	case SEQ_GE_LEVELUP_CHECK:
		if(PokeLevelUpCheck(pp)){
			{
				int					level;
				GF_BGL_INI			*bgl;
				GF_BGL_BMPWIN		*win;
				MSGDATA_MANAGER		*msg_m;

				level=PokeParaGet(pp,ID_PARA_level,NULL);
				bgl=BattleWorkGF_BGL_INIGet(tsiw->bw);
				win=BattleWorkGF_BGL_BMPWINGet(tsiw->bw);
				msg_m=BattleWorkFightMsgGet(tsiw->bw);

				PokeParaCalcLevelUp(pp);
				ST_PokemonParamGet(tsiw->bw,tsiw->sp,exp_client_no,tsiw->sp->sel_mons_no[exp_client_no]);
				tsiw->sp->level_up_pokemon|=No2Bit(sel_mons_no);
				SCIO_HPGaugeRefreshSet(tsiw->bw,tsiw->sp,exp_client_no);

				mp.msg_id=LevelUpMsg;
				mp.msg_para[1]=level;
				tsiw->work[GE_MSG_INDEX]=BattleMSG_Print(tsiw->bw,win,msg_m,&mp,1);
				tsiw->work[GE_MSG_WAIT]=40;
				tsiw->seq_no=SEQ_GE_LEVELUP_MSG_INDEX_WAIT;
			}
		}
		else{
			tsiw->seq_no=SEQ_GE_END;
		}
		break;
	case SEQ_GE_LEVELUP_MSG_INDEX_WAIT:
		if(GF_MSG_PrintEndCheck(tsiw->work[GE_MSG_INDEX])==0){
			Snd_MePlay(SEQ_FANFA1);
			tsiw->seq_no++;
		}
		break;
	case SEQ_GE_LEVELUP_MSG_WAIT:
		if(Snd_MePlayCheckBgmPlay()==FALSE){
			if(--tsiw->work[GE_MSG_WAIT]==0){
				tsiw->seq_no=SEQ_GE_WAZAOBOE_CHECK;
				tsiw->work[GE_WAZA_CNT]=0;
			}
		}
		break;
	case SEQ_GE_WAZAOBOE_CHECK:
		{
			u16	wazano;
			GF_BGL_INI			*bgl=BattleWorkGF_BGL_INIGet(tsiw->bw);
			GF_BGL_BMPWIN		*win=BattleWorkGF_BGL_BMPWINGet(tsiw->bw);
			MSGDATA_MANAGER	*msg_m;

			msg_m=BattleWorkFightMsgGet(tsiw->bw);

			switch(PokeWazaOboeCheck(pp,&tsiw->work[GE_WAZA_CNT],&wazano)){
			case NO_WAZA_OBOE:
				tsiw->seq_no=SEQ_GE_EXP_GAUGE;
				break;
			case NO_WAZA_SET:
			//{͋ZYꂾAbŉoŊo
				PokeWazaOboeOshidashi(pp,wazano);
			default:
				ST_PokemonParamGet(tsiw->bw,tsiw->sp,exp_client_no,tsiw->sp->sel_mons_no[exp_client_no]);
				mp.msg_id=WazaOboeMsg;
				mp.msg_tag=TAG_NICK_WAZA;
				mp.msg_para[1]=wazano;
				tsiw->work[GE_MSG_INDEX]=BattleMSG_Print(tsiw->bw,win,msg_m,&mp,1);
				tsiw->work[GE_MSG_WAIT]=40;
				tsiw->seq_no=SEQ_GE_WAZAOBOE_MSG_INDEX_WAIT;
				break;
			}
		}
		break;
	case SEQ_GE_WAZAOBOE_MSG_INDEX_WAIT:
		if(GF_MSG_PrintEndCheck(tsiw->work[GE_MSG_INDEX])==0){
			Snd_MePlay(SEQ_FANFA1);
			tsiw->seq_no++;
		}
		break;
	case SEQ_GE_WAZAOBOE_MSG_WAIT:
		if(Snd_MePlayCheckBgmPlay()==FALSE){
			if(--tsiw->work[GE_MSG_WAIT]==0){
				tsiw->seq_no=SEQ_GE_WAZAOBOE_CHECK;
			}
		}
		break;
	case SEQ_GE_END:
		{
			tsiw->sp->get_exp_right_flag[client_no]&=(No2Bit(sel_mons_no)^0xffffffff);
			if(tsiw->sp->get_exp_right_flag[client_no]==0){
				tsiw->sp->tsiw=NULL;
				sys_FreeMemoryEz(work);
				TCB_Delete(tcb);
			}
			else{
				tsiw->seq_no=SEQ_GE_INIT;
			}
		}
		break;
	}
}

//============================================================================================
/**
 *	w͒lvZ
 *
 * @param[in]	pp		POKEMON_PARAM\̂̃|C^
 * @param[in]	mons_no	炦w͒lvŽƂȂ|Pio[
 */
//============================================================================================
static	void	PokeExpCalc(POKEPARTY *ppt,int pos,int mons_no)
{
	int	i;
	s16	work=0;
	u8	bai;
	u8	para[6];
	u16	totalpara;
	u16	item_no;
	u8	eqp;
	u8	atk;
	POKEMON_PARAM *pp;
	POKEMON_PERSONAL_DATA *ppd;

	ppd=PokePersonalPara_Open(mons_no,HEAPID_BATTLE);
	pp=PokeParty_GetMemberPointer(ppt,pos);

	item_no=PokeParaGet(pp,ID_PARA_item,NULL);
	eqp=ItemParamGet(item_no,ITEM_PRM_EQUIP,HEAPID_BATTLE);
	atk=ItemParamGet(item_no,ITEM_PRM_ATTACK,HEAPID_BATTLE);

	totalpara=0;

	for(i=0;i<6;i++){
		para[i]=PokeParaGet(pp,ID_PARA_hp_exp+i,NULL);
		totalpara+=para[i];
	}

	for(i=0;i<6;i++){
		if(totalpara>=PARA_EXP_TOTAL_MAX){
			break;
		}
		if(PokerusedCheck(ppt,No2Bit(pos))){
			bai=2;
		}
		else{
			bai=1;
		}
		switch(i){
			case 0:
				work=PokePersonalPara_Get(ppd,ID_PER_pains_hp)*bai;
				//ʂŁAHPw͒lAbv
				if(eqp==SOUBI_HPDORYOKUTIUP){
					work+=atk;
				}
				break;
			case 1:
				work=PokePersonalPara_Get(ppd,ID_PER_pains_pow)*bai;
				//ʂŁAUw͒lAbv
				if(eqp==SOUBI_KOUGEKIDORYOKUTIUP){
					work+=atk;
				}
				break;
			case 2:
				work=PokePersonalPara_Get(ppd,ID_PER_pains_def)*bai;
				//ʂŁAhw͒lAbv
				if(eqp==SOUBI_BOUGYODORYOKUTIUP){
					work+=atk;
				}
				break;
			case 3:
				work=PokePersonalPara_Get(ppd,ID_PER_pains_agi)*bai;
				//ʂŁAfw͒lAbv
				if(eqp==SOUBI_SUBAYASADORYOKUTIUP){
					work+=atk;
				}
				break;
			case 4:
				work=PokePersonalPara_Get(ppd,ID_PER_pains_spepow)*bai;
				//ʂŁAUw͒lAbv
				if(eqp==SOUBI_TOKUKOUDORYOKUTIUP){
					work+=atk;
				}
				break;
			case 5:
				work=PokePersonalPara_Get(ppd,ID_PER_pains_spedef)*bai;
				//ʂŁAhw͒lAbv
				if(eqp==SOUBI_TOKUBOUDORYOKUTIUP){
					work+=atk;
				}
				break;
		}
		//ACeœw͒l2{̌ʂ𑕔Ăꍇ2{
		if(eqp==SOUBI_DORYOKUTINIBAI){
			work=work*2;
		}
		if(totalpara+work>PARA_EXP_TOTAL_MAX){
			work-=((totalpara+work)-PARA_EXP_TOTAL_MAX);
		}
		if(para[i]+work>255){
			work-=((para[i]+work)-255);
		}
		para[i]+=work;
		totalpara+=work;
		PokeParaPut(pp,ID_PARA_hp_exp+i,(u8 *)&para[i]);
	}

	PokePersonalPara_Close(ppd);
}

//============================================================================================
/**
 *	GET_POKEMONpV[PX`
 */
//============================================================================================
enum{
	SEQ_GP_BALL_THROW=0,
	SEQ_GP_BALL_THROW_WAIT,
	SEQ_GP_BALL_SHAKE,
	SEQ_GP_BALL_SHAKE_WAIT,
	SEQ_GP_POKEMON_MESSAGE,
	SEQ_GP_POKEMON_MESSAGE_WAIT,
	SEQ_GP_POKEMON_GET,
	SEQ_GP_PASOCOM_MOVE_WAIT,
	SEQ_GP_TRAINER_POKE_ALERT1,
	SEQ_GP_TRAINER_POKE_ALERT2,
	SEQ_GP_TRAINER_POKE_ALERT_WAIT,
	SEQ_GP_END
};

//============================================================================================
/**
 *	GET_POKEMONtsiw->work̓Y
 */
//============================================================================================
enum{
	GP_MSG_INDEX=0,
	GP_MSG_WAIT,
};

//============================================================================================
/**
 *	|PߊlpTCB
 *
 * @param[in]	tcb		TCBVXe[N
 * @param[in]	work	[NGA|C^
 */
//============================================================================================
static	void	TCB_GetPokemon(TCB_PTR tcb,void *work)
{
	int					sel_mons_no;
	TCB_SKILL_INTP_WORK	*tsiw=work;
	POKEMON_PARAM		*pp;
	PALETTE_FADE_PTR	pfd;

	pfd=BattleWorkPfdGet(tsiw->bw);

	switch(tsiw->seq_no){
	case SEQ_GP_BALL_THROW:
		{
			TBALL_MOVE_DATA bmd;

			bmd.type=EBMT_THROW_E0;		///< Gɓ
			bmd.heap_id=HEAPID_BATTLE;
			bmd.mode=EBMM_THROW;
			bmd.id=CLIENT_NO_ENEMY;
			bmd.csp=BattleWorkCATS_SYS_PTRGet(tsiw->bw);
			bmd.pfd=BattleWorkPfdGet(tsiw->bw);
			
			tsiw->bms=BM_Init(&bmd);
			tsiw->seq_no=SEQ_GP_BALL_THROW_WAIT;
			Snd_SePlay(SEQ_SE_DP_NAGERU);
		}
		break;
	case SEQ_GP_BALL_THROW_WAIT:
		if(BM_EndCheck(tsiw->bms)==FALSE){
			Snd_SePlay(SEQ_SE_DP_KON);
			{
				u32	fight_type;

				fight_type=BattleWorkFightTypeGet(tsiw->bw);
				if(fight_type&FIGHT_TYPE_TRAINER){
					BM_Delete(tsiw->bms);
					tsiw->seq_no=SEQ_GP_TRAINER_POKE_ALERT1;
				}
				else{
					Snd_SePlay(SEQ_SE_DP_SUIKOMU);
					SCIO_PokemonReturnSet(tsiw->bw,CLIENT_NO_ENEMY);
					tsiw->seq_no=SEQ_GP_BALL_SHAKE;
				}
			}
		}
		break;
	case SEQ_GP_BALL_SHAKE:
		if(ST_ServerQueCheck(tsiw->sp)){
			//{͕ߊlvZ
			BM_ModeChange(tsiw->bms,EBMM_SHAKE);
			tsiw->seq_no=SEQ_GP_BALL_SHAKE_WAIT;
		}
		break;
	case SEQ_GP_BALL_SHAKE_WAIT:
		if(BM_EndCheck(tsiw->bms)==FALSE){
			tsiw->seq_no=SEQ_GP_POKEMON_MESSAGE;
		}
		break;
	case SEQ_GP_POKEMON_MESSAGE:
		if(ST_ServerQueCheck(tsiw->sp)){
			{
				GF_BGL_INI		*bgl;
				GF_BGL_BMPWIN	*win;
				MSGDATA_MANAGER	*msg_m;
				MESSAGE_PARAM	mp;
	
				bgl=BattleWorkGF_BGL_INIGet(tsiw->bw);
				win=BattleWorkGF_BGL_BMPWINGet(tsiw->bw);
				msg_m=BattleWorkFightMsgGet(tsiw->bw);
	
				mp.msg_id=GetSuccessMsg;
				mp.msg_tag=TAG_NICK|TAG_NO_DIR;
				mp.msg_para[0]=CLIENT_NO_ENEMY;
				tsiw->work[GP_MSG_INDEX]=BattleMSG_Print(tsiw->bw,win,msg_m,&mp,1);
				tsiw->work[GP_MSG_WAIT]=40;
				tsiw->seq_no=SEQ_GP_POKEMON_MESSAGE_WAIT;
			}
		}
		break;
	case SEQ_GP_POKEMON_MESSAGE_WAIT:
		if(GF_MSG_PrintEndCheck(tsiw->work[GP_MSG_INDEX])==0){
			if(--tsiw->work[GP_MSG_WAIT]==0){
				tsiw->seq_no=SEQ_GP_POKEMON_GET;
			}
		}
		break;
	case SEQ_GP_POKEMON_GET:
		{
			GF_BGL_INI			*bgl;
			GF_BGL_BMPWIN		*win;
			MSGDATA_MANAGER		*msg_m;
			MESSAGE_PARAM		mp;
			POKEPARTY			*poke_party;
			POKEMON_PARAM		*pp;
			SOFT_SPRITE_MANAGER	*ssm_p;

			bgl=BattleWorkGF_BGL_INIGet(tsiw->bw);
			win=BattleWorkGF_BGL_BMPWINGet(tsiw->bw);
			msg_m=BattleWorkFightMsgGet(tsiw->bw);
			poke_party=BattleWorkPokePartyGet(tsiw->bw,CLIENT_NO_MINE);
			pp=BattleWorkPokemonParamGet(tsiw->bw,CLIENT_NO_ENEMY,tsiw->sp->sel_mons_no[CLIENT_NO_ENEMY]);
			ssm_p=BattleWorkSoftSpriteManagerGet(tsiw->bw);

			FT_ZukanFlagSetGet(tsiw->bw,CLIENT_NO_ENEMY);

			if(PokeParty_Add(poke_party,pp)==TRUE){
				PaletteFadeReq(pfd,PF_BIT_NORMAL_ALL,0xffff,1,0,16,0x0000);
				SoftSpritePalFadeSetAll(ssm_p,0,16,0,0x0000);
				tsiw->seq_no=SEQ_GP_END;
			}
			else{
				BOXDAT_PutPokemon(BattleWorkBoxDataGet(tsiw->bw),PPPPointerGet(pp));
				mp.msg_id=PasoTensouDarekaMsg;
				mp.msg_tag=TAG_NICK|TAG_NO_DIR;
				mp.msg_para[0]=CLIENT_NO_ENEMY;
				tsiw->work[GP_MSG_INDEX]=BattleMSG_Print(tsiw->bw,win,msg_m,&mp,1);
				tsiw->work[GP_MSG_WAIT]=40;
				tsiw->seq_no=SEQ_GP_PASOCOM_MOVE_WAIT;
			}
		}
		break;
	case SEQ_GP_PASOCOM_MOVE_WAIT:
		if(GF_MSG_PrintEndCheck(tsiw->work[GP_MSG_INDEX])==0){
			if(--tsiw->work[GP_MSG_WAIT]==0){
				{
					SOFT_SPRITE_MANAGER	*ssm_p;

					ssm_p=BattleWorkSoftSpriteManagerGet(tsiw->bw);

					PaletteFadeReq(pfd,PF_BIT_NORMAL_ALL,0xffff,1,0,16,0x0000);
					SoftSpritePalFadeSetAll(ssm_p,0,16,0,0x0000);
					tsiw->seq_no=SEQ_GP_END;
				}
			}
		}
		break;
	case SEQ_GP_TRAINER_POKE_ALERT1:
		{
			GF_BGL_INI		*bgl;
			GF_BGL_BMPWIN	*win;
			MSGDATA_MANAGER	*msg_m;
			MESSAGE_PARAM	mp;

			bgl=BattleWorkGF_BGL_INIGet(tsiw->bw);
			win=BattleWorkGF_BGL_BMPWINGet(tsiw->bw);
			msg_m=BattleWorkFightMsgGet(tsiw->bw);

			mp.msg_id=TrainerMonsMsg1;
			mp.msg_tag=TAG_NONE;
			tsiw->work[GP_MSG_INDEX]=BattleMSG_Print(tsiw->bw,win,msg_m,&mp,1);
			tsiw->work[GP_MSG_WAIT]=40;
			tsiw->seq_no=SEQ_GP_TRAINER_POKE_ALERT2;
		}
		break;
	case SEQ_GP_TRAINER_POKE_ALERT2:
		if(GF_MSG_PrintEndCheck(tsiw->work[GP_MSG_INDEX])==0){
			if(--tsiw->work[GP_MSG_WAIT]==0){
				{
					GF_BGL_INI		*bgl;
					GF_BGL_BMPWIN	*win;
					MSGDATA_MANAGER	*msg_m;
					MESSAGE_PARAM	mp;

					bgl=BattleWorkGF_BGL_INIGet(tsiw->bw);
					win=BattleWorkGF_BGL_BMPWINGet(tsiw->bw);
					msg_m=BattleWorkFightMsgGet(tsiw->bw);

					mp.msg_id=TrainerMonsMsg2;
					mp.msg_tag=TAG_NONE;
					tsiw->work[GP_MSG_INDEX]=BattleMSG_Print(tsiw->bw,win,msg_m,&mp,1);
					tsiw->work[GP_MSG_WAIT]=40;
					tsiw->seq_no=SEQ_GP_TRAINER_POKE_ALERT_WAIT;
				}
			}
		}
		break;
	case SEQ_GP_TRAINER_POKE_ALERT_WAIT:
		if(GF_MSG_PrintEndCheck(tsiw->work[GP_MSG_INDEX])==0){
			if(--tsiw->work[GP_MSG_WAIT]==0){
				tsiw->sp->tsiw=NULL;
				sys_FreeMemoryEz(work);
				TCB_Delete(tcb);
			}
		}
		break;
	case SEQ_GP_END:
		if(PaletteFadeCheck(pfd)==0){
			BM_Delete(tsiw->bms);
			tsiw->sp->win_lose_flag=FIGHT_POKE_GET;
			tsiw->sp->tsiw=NULL;
			sys_FreeMemoryEz(work);
			TCB_Delete(tcb);
		}
		break;
	}
}

//============================================================================================
/**
 *	ClientNo擾֐
 *
 * @param[in]	sp		T[op[^\
 * @param[in]	side	擾鑤w
 */
//============================================================================================
static	int	SideClientNoGet(BATTLE_WORK *bw,SERVER_PARAM *sp,int side)
{
	int	client_no;

	switch(side){
	default:
		OS_Printf("SideClientNoGet:ɂ̂͂\n");
	case SIDE_ATTACK:
		client_no=sp->attack_client;
		break;
	case SIDE_DEFENCE:
		client_no=sp->defence_client;
		break;
	case SIDE_KIZETSU:
		client_no=sp->kizetsu_client;
		break;
	case SIDE_RESHUFFLE:
		client_no=sp->reshuffle_client;
		break;
	case SIDE_TSUIKA:
		client_no=sp->tsuika_client;
		break;
	case SIDE_TOKUSEI:
		client_no=sp->tokusei_client;
		break;
	case SIDE_ENEMY:
		{
			CLIENT_PARAM	*cp;
			int	client_set_max;

			client_set_max=BattleWorkClientSetMaxGet(bw);
			for(client_no=0;client_no<client_set_max;client_no++){
				cp=BattleWorkClientParamGet(bw,client_no);
				if(cp->client_type&CLIENT_ENEMY_FLAG){
					break;
				}
			}
		}
		break;
	case SIDE_ENEMY_1:
		{
			CLIENT_PARAM	*cp;
			int	client_set_max;

			client_set_max=BattleWorkClientSetMaxGet(bw);
			for(client_no=0;client_no<client_set_max;client_no++){
				cp=BattleWorkClientParamGet(bw,client_no);
				if((cp->client_type==CLIENT_TYPE_B)||(cp->client_type==CLIENT_TYPE_BB)){
					break;
				}
			}
		}
		break;
	case SIDE_ENEMY_2:
		{
			CLIENT_PARAM	*cp;
			int	client_set_max;

			client_set_max=BattleWorkClientSetMaxGet(bw);
			for(client_no=0;client_no<client_set_max;client_no++){
				cp=BattleWorkClientParamGet(bw,client_no);
				if(cp->client_type==CLIENT_TYPE_D){
					break;
				}
			}
		}
		break;
	case SIDE_MINE:
		{
			CLIENT_PARAM	*cp;
			int	client_set_max;

			client_set_max=BattleWorkClientSetMaxGet(bw);
			for(client_no=0;client_no<client_set_max;client_no++){
				cp=BattleWorkClientParamGet(bw,client_no);
				if((cp->client_type&CLIENT_ENEMY_FLAG)==0){
					break;
				}
			}
		}
		break;
	case SIDE_MINE_1:
		{
			CLIENT_PARAM	*cp;
			int	client_set_max;

			client_set_max=BattleWorkClientSetMaxGet(bw);
			for(client_no=0;client_no<client_set_max;client_no++){
				cp=BattleWorkClientParamGet(bw,client_no);
				if((cp->client_type==CLIENT_TYPE_A)||(cp->client_type==CLIENT_TYPE_AA)){
					break;
				}
			}
		}
		break;
	case SIDE_MINE_2:
		{
			CLIENT_PARAM	*cp;
			int	client_set_max;

			client_set_max=BattleWorkClientSetMaxGet(bw);
			for(client_no=0;client_no<client_set_max;client_no++){
				cp=BattleWorkClientParamGet(bw,client_no);
				if(cp->client_type==CLIENT_TYPE_C){
					break;
				}
			}
		}
		break;
	case SIDE_ATTACK_WORK:
		client_no=sp->attack_client_work;
		break;
	case SIDE_DEFENCE_WORK:
		client_no=sp->defence_client_work;
		break;
	case SIDE_ATTACK_PAIR:
		{
			int	client_set_max;

			client_set_max=BattleWorkClientSetMaxGet(bw);
			for(client_no=0;client_no<client_set_max;client_no++){
				if((client_no!=sp->attack_client)&&
				   (BattleWorkMineEnemyCheck(bw,client_no)==BattleWorkMineEnemyCheck(bw,sp->attack_client))){
					break;
				}
			}
			if(client_no==client_set_max){
				GF_ASSERT("p[gi[܂ł@SIDE_ATTACK_PAIRwł܂I\n");
				client_no=0;
			}
		}
		break;
	case SIDE_DEFENCE_PAIR:
		{
			int	client_set_max;

			client_set_max=BattleWorkClientSetMaxGet(bw);
			for(client_no=0;client_no<client_set_max;client_no++){
				if((client_no!=sp->defence_client)&&
				   (BattleWorkMineEnemyCheck(bw,client_no)==BattleWorkMineEnemyCheck(bw,sp->defence_client))){
					break;
				}
			}
			if(client_no==client_set_max){
				GF_ASSERT("p[gi[܂ł@SIDE_DEFENCE_PAIRwł܂I\n");
				client_no=0;
			}
		}
		break;
	case SIDE_ATTACK_ENEMY:
		{
			int	client_set_max;
			int	dir;

			client_set_max=BattleWorkClientSetMaxGet(bw);
			dir=BattleWorkMineEnemyCheck(bw,sp->attack_client);
			for(client_no=0;client_no<client_set_max;client_no++){
				if(dir!=BattleWorkMineEnemyCheck(bw,client_no)){
					break;
				}
			}
		}
		break;
	case SIDE_DEFENCE_ENEMY:
		{
			int	client_set_max;
			int	dir;

			client_set_max=BattleWorkClientSetMaxGet(bw);
			dir=BattleWorkMineEnemyCheck(bw,sp->defence_client);
			for(client_no=0;client_no<client_set_max;client_no++){
				if(dir!=BattleWorkMineEnemyCheck(bw,client_no)){
					break;
				}
			}
		}
		break;
	case SIDE_WORK:
	case SIDE_CLIENT_WORK:
		client_no=sp->client_work;
		break;
	}

	return client_no;
}

//============================================================================================
/**
 *	MessageParamMakep̃p[^\̃f[^֐
 *
 * @param[in]	sp		T[op[^\
 */
//============================================================================================
static	void	MessageParamDataMake(SERVER_PARAM *sp,MESSAGE_PARAM_DATA *mpd)
{
	int	i,max=0;

	mpd->msg_id=SkillSeqDataRead(sp);
	mpd->msg_tag=SkillSeqDataRead(sp);

	switch(mpd->msg_tag){
	case TAG_NONE:						//^OȂ
		max=0;
		break;
	case TAG_NONE_DIR:					//^OȂi݂AĔ肠j
	case TAG_NICK:						//nickname
	case TAG_WAZA:						//Z
	case TAG_NUM:						//l
	case TAG_TRNAME:					//trainer
		max=1;
		break;
	case TAG_NICK_NICK:					//nickname		nickname
	case TAG_NICK_WAZA:					//nickname		Z
	case TAG_NICK_TOKU:					//nickname		
	case TAG_NICK_STAT:					//nickname		Xe[^X
	case TAG_NICK_TYPE:					//nickname		^Cv
	case TAG_NICK_POKE:					//nickname		|P
	case TAG_NICK_ITEM:					//nickname		
	case TAG_NICK_PLOC:					//nickname		|bN
	case TAG_NICK_NUM:					//nickname		l
	case TAG_NICK_TRNAME:				//nickname		trainer
	case TAG_WAZA_NICK:					//Z			nickname
	case TAG_WAZA_WAZA:					//Z			Z
	case TAG_TOKU_NICK:					//		nickname
	case TAG_ITEM_WAZA:					//		Z
	case TAG_NUM_NUM:					//l			l
	case TAG_TRNAME_TRNAME:				//trainer		trainer
	case TAG_TRNAME_NICK:				//trainer		nickname
	case TAG_TRNAME_ITEM:				//trainer		
	case TAG_TRNAME_NUM:				//trainer		l
	case TAG_TRTYPE_TRNAME:				//trainer	trainer
		max=2;
		break;
	case TAG_NICK_NICK_WAZA:			//nickname		nickname		Z
	case TAG_NICK_NICK_TOKU:			//nickname		nickname		
	case TAG_NICK_NICK_ITEM:			//nickname		nickname		
	case TAG_NICK_WAZA_WAZA:			//nickname		Z			Z
	case TAG_NICK_WAZA_NUM:				//nickname		Z			l
	case TAG_NICK_TOKU_NICK:			//nickname					nickname
	case TAG_NICK_TOKU_WAZA:			//nickname					Z
	case TAG_NICK_TOKU_ITEM:			//nickname					
	case TAG_NICK_TOKU_STAT:			//nickname					Xe[^X
	case TAG_NICK_TOKU_TYPE:			//nickname					^Cv
	case TAG_NICK_TOKU_COND:			//nickname					Ԉُ햼
	case TAG_NICK_TOKU_NUM:				//nickname					l
	case TAG_NICK_ITEM_NICK:			//nickname					nickname
	case TAG_NICK_ITEM_WAZA:			//nickname					Z
	case TAG_NICK_ITEM_STAT:			//nickname					Xe[^X
	case TAG_NICK_ITEM_COND:			//nickname					Ԉُ햼
	case TAG_ITEM_NICK_TASTE:			//		nickname		؂̖̎
	case TAG_TRNAME_NICK_NICK:			//trainer		nickname		nickname
	case TAG_TRTYPE_TRNAME_NICK:		//trainer	trainer		nickname
	case TAG_TRTYPE_TRNAME_ITEM:		//trainer	trainer		
		max=3;
		break;
	case TAG_NICK_TOKU_NICK_WAZA:		//nickname					nickname		Z
	case TAG_NICK_TOKU_NICK_TOKU:		//nickname					nickname		
	case TAG_NICK_TOKU_NICK_STAT:		//nickname					nickname		Xe[^X
	case TAG_NICK_ITEM_NICK_ITEM:		//nickname					nickname		
	case TAG_TRNAME_NICK_TRNAME_NICK:	//trainer		nickname		trainer		nickname
	case TAG_TRTYPE_TRNAME_NICK_NICK:	//trainer	trainer		nickname		nickname
	case TAG_TRTYPE_TRNAME_NICK_TRNAME:	//trainer	trainer		nickname		trainer
		max=4;
		break;
	case TAG_TRTYPE_TRNAME_NICKx2:		//trainer	trainer		nickname Q
		max=6;
		break;
	default:
		GF_ASSERT("݂ȂTAGłI\n");
		break;
	}

	for(i=0;i<max;i++){
		mpd->msg_para[i]=SkillSeqDataRead(sp);
	}
}

//============================================================================================
/**
 *	MESSAGE_PARAM\̃f[^֐
 *
 * @param[in]	bw		BATTLE_WORK\̂ւ̃|C^
 * @param[in]	sp		T[op[^\
 * @param[in]	mpd		MESSAGE_PARAM_DATA\̃f[^ւ̃|C^
 * @param[in]	mp		MESSAGE_PARAM\̃f[^ւ̃|C^
 */
//============================================================================================
static	void	MessageParamMake(BATTLE_WORK *bw,SERVER_PARAM *sp,MESSAGE_PARAM_DATA *mpd,MESSAGE_PARAM *mp)
{
	mp->msg_id=mpd->msg_id;
	mp->msg_tag=mpd->msg_tag;

	switch(mp->msg_tag){
	case TAG_NONE:						//^OȂ
		break;
	case TAG_NONE_DIR:					//^OȂi݂AĔ肠j
		mp->msg_para[0]=SideClientNoGet(bw,sp,mpd->msg_para[0]);
		break;
	case TAG_NICK:						//nickname
		mp->msg_para[0]=MessageParamNicknameGet(bw,sp,mpd->msg_para[0]);
		break;
	case TAG_WAZA:						//Z
		mp->msg_para[0]=MessageParamWazaGet(sp,mpd->msg_para[0]);
		break;
	case TAG_NUM:						//l
		mp->msg_para[0]=MessageParamNumGet(sp,mpd->msg_para[0]);
		break;
	case TAG_TRNAME:					//trainer
		mp->msg_para[0]=MessageParamTRNameGet(bw,sp,mpd->msg_para[0]);
		break;
	case TAG_NICK_NICK:					//nickname		nickname
		mp->msg_para[0]=MessageParamNicknameGet(bw,sp,mpd->msg_para[0]);
		mp->msg_para[1]=MessageParamNicknameGet(bw,sp,mpd->msg_para[1]);
		break;
	case TAG_NICK_WAZA:					//nickname		Z
		mp->msg_para[0]=MessageParamNicknameGet(bw,sp,mpd->msg_para[0]);
		mp->msg_para[1]=MessageParamWazaGet(sp,mpd->msg_para[1]);
		break;
	case TAG_NICK_TOKU:					//nickname		
		mp->msg_para[0]=MessageParamNicknameGet(bw,sp,mpd->msg_para[0]);
		mp->msg_para[1]=MessageParamTokuseiGet(bw,sp,mpd->msg_para[1]);
		break;
	case TAG_NICK_STAT:					//nickname		Xe[^X
		mp->msg_para[0]=MessageParamNicknameGet(bw,sp,mpd->msg_para[0]);
		mp->msg_para[1]=MessageParamStatusGet(sp,mpd->msg_para[1]);
		break;
	case TAG_NICK_TYPE:					//nickname		^Cv
		mp->msg_para[0]=MessageParamNicknameGet(bw,sp,mpd->msg_para[0]);
		mp->msg_para[1]=MessageParamTypeGet(sp,mpd->msg_para[1]);
		break;
	case TAG_NICK_POKE:					//nickname		|P
		mp->msg_para[0]=MessageParamNicknameGet(bw,sp,mpd->msg_para[0]);
		mp->msg_para[1]=MessageParamPokenameGet(bw,sp,mpd->msg_para[1]);
		break;
	case TAG_NICK_ITEM:					//nickname		
		mp->msg_para[0]=MessageParamNicknameGet(bw,sp,mpd->msg_para[0]);
		mp->msg_para[1]=MessageParamItemGet(sp,mpd->msg_para[1]);
		break;
	case TAG_NICK_PLOC:					//nickname		|bN
		mp->msg_para[0]=MessageParamNicknameGet(bw,sp,mpd->msg_para[0]);
		mp->msg_para[1]=MessageParamPolockGet(sp,mpd->msg_para[1]);
		break;
	case TAG_NICK_NUM:					//nickname		l
		mp->msg_para[0]=MessageParamNicknameGet(bw,sp,mpd->msg_para[0]);
		mp->msg_para[1]=MessageParamNumGet(sp,mpd->msg_para[1]);
		break;
	case TAG_NICK_TRNAME:				//nickname		trainer
		mp->msg_para[0]=MessageParamNicknameGet(bw,sp,mpd->msg_para[0]);
		mp->msg_para[1]=MessageParamTRNameGet(bw,sp,mpd->msg_para[1]);
		break;
	case TAG_WAZA_NICK:					//Z			nickname
		mp->msg_para[0]=MessageParamWazaGet(sp,mpd->msg_para[0]);
		mp->msg_para[1]=MessageParamNicknameGet(bw,sp,mpd->msg_para[1]);
		break;
	case TAG_WAZA_WAZA:					//Z			Z
		mp->msg_para[0]=MessageParamWazaGet(sp,mpd->msg_para[0]);
		mp->msg_para[1]=MessageParamWazaGet(sp,mpd->msg_para[1]);
		break;
	case TAG_TOKU_NICK:					//		nickname
		mp->msg_para[0]=MessageParamTokuseiGet(bw,sp,mpd->msg_para[0]);
		mp->msg_para[1]=MessageParamNicknameGet(bw,sp,mpd->msg_para[1]);
		break;
	case TAG_ITEM_WAZA:					//		Z
		mp->msg_para[0]=MessageParamItemGet(sp,mpd->msg_para[0]);
		mp->msg_para[1]=MessageParamWazaGet(sp,mpd->msg_para[1]);
		break;
	case TAG_NUM_NUM:					//l			l
		mp->msg_para[0]=MessageParamNumGet(sp,mpd->msg_para[0]);
		mp->msg_para[1]=MessageParamNumGet(sp,mpd->msg_para[1]);
		break;
	case TAG_TRNAME_TRNAME:				//trainer		trainer
		mp->msg_para[0]=MessageParamTRNameGet(bw,sp,mpd->msg_para[0]);
		mp->msg_para[1]=MessageParamTRNameGet(bw,sp,mpd->msg_para[1]);
		break;
	case TAG_TRNAME_NICK:				//trainer		nickname
		mp->msg_para[0]=MessageParamTRNameGet(bw,sp,mpd->msg_para[0]);
		mp->msg_para[1]=MessageParamNicknameGet(bw,sp,mpd->msg_para[1]);
		break;
	case TAG_TRNAME_ITEM:				//trainer		
		mp->msg_para[0]=MessageParamTRNameGet(bw,sp,mpd->msg_para[0]);
		mp->msg_para[1]=MessageParamItemGet(sp,mpd->msg_para[1]);
		break;
	case TAG_TRNAME_NUM:				//trainer		l
		mp->msg_para[0]=MessageParamTRNameGet(bw,sp,mpd->msg_para[0]);
		mp->msg_para[1]=MessageParamNumGet(sp,mpd->msg_para[1]);
		break;
	case TAG_TRTYPE_TRNAME:				//trainer	trainer
		mp->msg_para[0]=MessageParamTRTypeGet(bw,sp,mpd->msg_para[0]);
		mp->msg_para[1]=MessageParamTRNameGet(bw,sp,mpd->msg_para[1]);
		break;
	case TAG_NICK_NICK_WAZA:			//nickname		nickname		Z
		mp->msg_para[0]=MessageParamNicknameGet(bw,sp,mpd->msg_para[0]);
		mp->msg_para[1]=MessageParamNicknameGet(bw,sp,mpd->msg_para[1]);
		mp->msg_para[2]=MessageParamWazaGet(sp,mpd->msg_para[2]);
		break;
	case TAG_NICK_NICK_TOKU:			//nickname		nickname		
		mp->msg_para[0]=MessageParamNicknameGet(bw,sp,mpd->msg_para[0]);
		mp->msg_para[1]=MessageParamNicknameGet(bw,sp,mpd->msg_para[1]);
		mp->msg_para[2]=MessageParamTokuseiGet(bw,sp,mpd->msg_para[2]);
		break;
	case TAG_NICK_NICK_ITEM:			//nickname		nickname		
		mp->msg_para[0]=MessageParamNicknameGet(bw,sp,mpd->msg_para[0]);
		mp->msg_para[1]=MessageParamNicknameGet(bw,sp,mpd->msg_para[1]);
		mp->msg_para[2]=MessageParamItemGet(sp,mpd->msg_para[2]);
		break;
	case TAG_NICK_WAZA_WAZA:			//nickname		Z			Z
		mp->msg_para[0]=MessageParamNicknameGet(bw,sp,mpd->msg_para[0]);
		mp->msg_para[1]=MessageParamWazaGet(sp,mpd->msg_para[1]);
		mp->msg_para[2]=MessageParamWazaGet(sp,mpd->msg_para[2]);
		break;
	case TAG_NICK_WAZA_NUM:				//nickname		Z			l
		mp->msg_para[0]=MessageParamNicknameGet(bw,sp,mpd->msg_para[0]);
		mp->msg_para[1]=MessageParamWazaGet(sp,mpd->msg_para[1]);
		mp->msg_para[2]=MessageParamNumGet(sp,mpd->msg_para[2]);
		break;
	case TAG_NICK_TOKU_NICK:			//nickname					nickname
		mp->msg_para[0]=MessageParamNicknameGet(bw,sp,mpd->msg_para[0]);
		mp->msg_para[1]=MessageParamTokuseiGet(bw,sp,mpd->msg_para[1]);
		mp->msg_para[2]=MessageParamNicknameGet(bw,sp,mpd->msg_para[2]);
		break;
	case TAG_NICK_TOKU_WAZA:			//nickname					Z
		mp->msg_para[0]=MessageParamNicknameGet(bw,sp,mpd->msg_para[0]);
		mp->msg_para[1]=MessageParamTokuseiGet(bw,sp,mpd->msg_para[1]);
		mp->msg_para[2]=MessageParamWazaGet(sp,mpd->msg_para[2]);
		break;
	case TAG_NICK_TOKU_ITEM:			//nickname					
		mp->msg_para[0]=MessageParamNicknameGet(bw,sp,mpd->msg_para[0]);
		mp->msg_para[1]=MessageParamTokuseiGet(bw,sp,mpd->msg_para[1]);
		mp->msg_para[2]=MessageParamItemGet(sp,mpd->msg_para[2]);
		break;
	case TAG_NICK_TOKU_STAT:			//nickname					Xe[^X
		mp->msg_para[0]=MessageParamNicknameGet(bw,sp,mpd->msg_para[0]);
		mp->msg_para[1]=MessageParamTokuseiGet(bw,sp,mpd->msg_para[1]);
		mp->msg_para[2]=MessageParamStatusGet(sp,mpd->msg_para[2]);
		break;
	case TAG_NICK_TOKU_TYPE:			//nickname					^Cv
		mp->msg_para[0]=MessageParamNicknameGet(bw,sp,mpd->msg_para[0]);
		mp->msg_para[1]=MessageParamTokuseiGet(bw,sp,mpd->msg_para[1]);
		mp->msg_para[2]=MessageParamTypeGet(sp,mpd->msg_para[2]);
		break;
	case TAG_NICK_TOKU_COND:			//nickname					Ԉُ햼
		mp->msg_para[0]=MessageParamNicknameGet(bw,sp,mpd->msg_para[0]);
		mp->msg_para[1]=MessageParamTokuseiGet(bw,sp,mpd->msg_para[1]);
		mp->msg_para[2]=MessageParamConditionGet(sp,mpd->msg_para[2]);
		break;
	case TAG_NICK_TOKU_NUM:				//nickname					l
		mp->msg_para[0]=MessageParamNicknameGet(bw,sp,mpd->msg_para[0]);
		mp->msg_para[1]=MessageParamTokuseiGet(bw,sp,mpd->msg_para[1]);
		mp->msg_para[2]=MessageParamNumGet(sp,mpd->msg_para[2]);
		break;
	case TAG_NICK_ITEM_NICK:			//nickname					nickname
		mp->msg_para[0]=MessageParamNicknameGet(bw,sp,mpd->msg_para[0]);
		mp->msg_para[1]=MessageParamItemGet(sp,mpd->msg_para[1]);
		mp->msg_para[2]=MessageParamNicknameGet(bw,sp,mpd->msg_para[2]);
		break;
	case TAG_NICK_ITEM_WAZA:			//nickname					Z
		mp->msg_para[0]=MessageParamNicknameGet(bw,sp,mpd->msg_para[0]);
		mp->msg_para[1]=MessageParamItemGet(sp,mpd->msg_para[1]);
		mp->msg_para[2]=MessageParamWazaGet(sp,mpd->msg_para[2]);
		break;
	case TAG_NICK_ITEM_STAT:			//nickname					Xe[^X
		mp->msg_para[0]=MessageParamNicknameGet(bw,sp,mpd->msg_para[0]);
		mp->msg_para[1]=MessageParamItemGet(sp,mpd->msg_para[1]);
		mp->msg_para[2]=MessageParamStatusGet(sp,mpd->msg_para[2]);
		break;
	case TAG_NICK_ITEM_COND:			//nickname					Ԉُ햼
		mp->msg_para[0]=MessageParamNicknameGet(bw,sp,mpd->msg_para[0]);
		mp->msg_para[1]=MessageParamItemGet(sp,mpd->msg_para[1]);
		mp->msg_para[2]=MessageParamConditionGet(sp,mpd->msg_para[2]);
		break;
	case TAG_ITEM_NICK_TASTE:			//		nickname		؂̖̎
		mp->msg_para[0]=MessageParamItemGet(sp,mpd->msg_para[0]);
		mp->msg_para[1]=MessageParamNicknameGet(bw,sp,mpd->msg_para[1]);
		mp->msg_para[2]=MessageParamTasteGet(sp,mpd->msg_para[2]);
		break;
	case TAG_TRNAME_NICK_NICK:			//trainer		nickname		nickname
		mp->msg_para[0]=MessageParamTRNameGet(bw,sp,mpd->msg_para[0]);
		mp->msg_para[1]=MessageParamNicknameGet(bw,sp,mpd->msg_para[1]);
		mp->msg_para[2]=MessageParamNicknameGet(bw,sp,mpd->msg_para[2]);
		break;
	case TAG_TRTYPE_TRNAME_NICK:		//trainer	trainer		nickname
		mp->msg_para[0]=MessageParamTRTypeGet(bw,sp,mpd->msg_para[0]);
		mp->msg_para[1]=MessageParamTRNameGet(bw,sp,mpd->msg_para[1]);
		mp->msg_para[2]=MessageParamNicknameGet(bw,sp,mpd->msg_para[2]);
		break;
	case TAG_TRTYPE_TRNAME_ITEM:		//trainer	trainer		
		mp->msg_para[0]=MessageParamTRTypeGet(bw,sp,mpd->msg_para[0]);
		mp->msg_para[1]=MessageParamTRNameGet(bw,sp,mpd->msg_para[1]);
		mp->msg_para[2]=MessageParamItemGet(sp,mpd->msg_para[2]);
		break;
	case TAG_NICK_TOKU_NICK_WAZA:		//nickname					nickname		Z
		mp->msg_para[0]=MessageParamNicknameGet(bw,sp,mpd->msg_para[0]);
		mp->msg_para[1]=MessageParamTokuseiGet(bw,sp,mpd->msg_para[1]);
		mp->msg_para[2]=MessageParamNicknameGet(bw,sp,mpd->msg_para[2]);
		mp->msg_para[3]=MessageParamWazaGet(sp,mpd->msg_para[3]);
		break;
	case TAG_NICK_TOKU_NICK_TOKU:		//nickname					nickname		
		mp->msg_para[0]=MessageParamNicknameGet(bw,sp,mpd->msg_para[0]);
		mp->msg_para[1]=MessageParamTokuseiGet(bw,sp,mpd->msg_para[1]);
		mp->msg_para[2]=MessageParamNicknameGet(bw,sp,mpd->msg_para[2]);
		mp->msg_para[3]=MessageParamTokuseiGet(bw,sp,mpd->msg_para[3]);
		break;
	case TAG_NICK_TOKU_NICK_STAT:		//nickname					nickname		Xe[^X
		mp->msg_para[0]=MessageParamNicknameGet(bw,sp,mpd->msg_para[0]);
		mp->msg_para[1]=MessageParamTokuseiGet(bw,sp,mpd->msg_para[1]);
		mp->msg_para[2]=MessageParamNicknameGet(bw,sp,mpd->msg_para[2]);
		mp->msg_para[3]=MessageParamStatusGet(sp,mpd->msg_para[3]);
		break;
	case TAG_NICK_ITEM_NICK_ITEM:		//nickname					nickname		
		mp->msg_para[0]=MessageParamNicknameGet(bw,sp,mpd->msg_para[0]);
		mp->msg_para[1]=MessageParamItemGet(sp,mpd->msg_para[1]);
		mp->msg_para[2]=MessageParamNicknameGet(bw,sp,mpd->msg_para[2]);
		mp->msg_para[3]=MessageParamItemGet(sp,mpd->msg_para[3]);
		break;
	case TAG_TRNAME_NICK_TRNAME_NICK:	//trainer		nickname		trainer		nickname
		mp->msg_para[0]=MessageParamTRNameGet(bw,sp,mpd->msg_para[0]);
		mp->msg_para[1]=MessageParamNicknameGet(bw,sp,mpd->msg_para[1]);
		mp->msg_para[2]=MessageParamTRNameGet(bw,sp,mpd->msg_para[2]);
		mp->msg_para[3]=MessageParamNicknameGet(bw,sp,mpd->msg_para[3]);
		break;
	case TAG_TRTYPE_TRNAME_NICK_NICK:	//trainer	trainer		nickname		nickname
		mp->msg_para[0]=MessageParamTRTypeGet(bw,sp,mpd->msg_para[0]);
		mp->msg_para[1]=MessageParamTRNameGet(bw,sp,mpd->msg_para[1]);
		mp->msg_para[2]=MessageParamNicknameGet(bw,sp,mpd->msg_para[2]);
		mp->msg_para[3]=MessageParamNicknameGet(bw,sp,mpd->msg_para[3]);
		break;
	case TAG_TRTYPE_TRNAME_NICK_TRNAME:	//trainer	trainer		nickname		trainer
		mp->msg_para[0]=MessageParamTRTypeGet(bw,sp,mpd->msg_para[0]);
		mp->msg_para[1]=MessageParamTRNameGet(bw,sp,mpd->msg_para[1]);
		mp->msg_para[2]=MessageParamNicknameGet(bw,sp,mpd->msg_para[2]);
		mp->msg_para[3]=MessageParamTRNameGet(bw,sp,mpd->msg_para[3]);
		break;
	case TAG_TRTYPE_TRNAME_NICKx2:		//trainer	trainer		nickname Q
		mp->msg_para[0]=MessageParamTRTypeGet(bw,sp,mpd->msg_para[0]);
		mp->msg_para[1]=MessageParamTRNameGet(bw,sp,mpd->msg_para[1]);
		mp->msg_para[2]=MessageParamNicknameGet(bw,sp,mpd->msg_para[2]);
		mp->msg_para[3]=MessageParamTRTypeGet(bw,sp,mpd->msg_para[3]);
		mp->msg_para[4]=MessageParamTRNameGet(bw,sp,mpd->msg_para[4]);
		mp->msg_para[5]=MessageParamNicknameGet(bw,sp,mpd->msg_para[5]);
		break;
	default:
		GF_ASSERT("݂ȂTAGłI\n");
		break;
	}
}

//============================================================================================
/**
 *	MESSAGE_PARAM\̃f[^֐ijbNl[j
 *
 * @param[in]	sp		T[op[^\
 * @param[in]	para	Ώۃp[^iSIDE_ATTACKASIDE_DEFENCEȂǁj
 */
//============================================================================================
static	int	MessageParamNicknameGet(BATTLE_WORK *bw,SERVER_PARAM *sp,int para)
{
	int ret;
	int	client_no;

	client_no=SideClientNoGet(bw,sp,para);

	ret=client_no;
	ret|=sp->sel_mons_no[client_no]<<8;

	return ret;
#if 0
	int ret;

	switch(para){
	case SIDE_ATTACK:
		ret=sp->attack_client;
		ret|=sp->sel_mons_no[sp->attack_client]<<8;
		break;
	case SIDE_DEFENCE:
		ret=sp->defence_client;
		ret|=sp->sel_mons_no[sp->defence_client]<<8;
		break;
	case SIDE_KIZETSU:
		ret=sp->kizetsu_client;
		ret|=sp->sel_mons_no[sp->kizetsu_client]<<8;
		break;
	case SIDE_RESHUFFLE:
		ret=sp->reshuffle_client;
		ret|=sp->sel_mons_no[sp->reshuffle_client]<<8;
		break;
	case SIDE_TSUIKA:
		ret=sp->tsuika_client;
		ret|=sp->sel_mons_no[sp->tsuika_client]<<8;
		break;
	case SIDE_TOKUSEI:
		ret=sp->tokusei_client;
		ret|=sp->sel_mons_no[sp->tokusei_client]<<8;
		break;
	case SIDE_ENEMY:
		{
			CLIENT_PARAM	*cp;
			int	client_set_max;
			int	fight_type;

			client_set_max=BattleWorkClientSetMaxGet(bw);
			fight_type=BattleWorkFightTypeGet(bw);
			for(ret=0;ret<client_set_max;ret++){
				if((fight_type&FIGHT_TYPE_2vs2)&&((fight_type&FIGHT_TYPE_MULTI)==0)){
					cp=BattleWorkClientParamGet(bw,ret&1);
				}
				else{
					cp=BattleWorkClientParamGet(bw,ret);
				}
				if((cp->client_type==CLIENT_TYPE_B)||(cp->client_type==CLIENT_TYPE_BB)){
					break;
				}
			}
			ret|=sp->sel_mons_no[ret]<<8;
		}
		break;
	case SIDE_ENEMY_1:
		{
			CLIENT_PARAM	*cp;
			int	client_set_max;
			int	fight_type;

			client_set_max=BattleWorkClientSetMaxGet(bw);
			fight_type=BattleWorkFightTypeGet(bw);
			for(ret=0;ret<client_set_max;ret++){
				if((fight_type&FIGHT_TYPE_2vs2)&&((fight_type&FIGHT_TYPE_MULTI)==0)){
					cp=BattleWorkClientParamGet(bw,ret&1);
				}
				else{
					cp=BattleWorkClientParamGet(bw,ret);
				}
				if(cp->client_type&CLIENT_ENEMY_FLAG){
					break;
				}
			}
			ret|=sp->sel_mons_no[ret]<<8;
		}
		break;
	case SIDE_MINE:
		{
			CLIENT_PARAM	*cp;
			int	client_set_max;
			int	fight_type;

			client_set_max=BattleWorkClientSetMaxGet(bw);
			fight_type=BattleWorkFightTypeGet(bw);
			for(ret=0;ret<client_set_max;ret++){
				if((fight_type&FIGHT_TYPE_2vs2)&&((fight_type&FIGHT_TYPE_MULTI)==0)){
					cp=BattleWorkClientParamGet(bw,ret&1);
				}
				else{
					cp=BattleWorkClientParamGet(bw,ret);
				}
				if((cp->client_type&CLIENT_ENEMY_FLAG)==0){
					break;
				}
			}
			ret|=sp->sel_mons_no[ret]<<8;
		}
		break;
	case SIDE_MINE_1:
		{
			CLIENT_PARAM	*cp;
			int	client_set_max;
			int	fight_type;

			client_set_max=BattleWorkClientSetMaxGet(bw);
			fight_type=BattleWorkFightTypeGet(bw);
			for(ret=0;ret<client_set_max;ret++){
				if((fight_type&FIGHT_TYPE_2vs2)&&((fight_type&FIGHT_TYPE_MULTI)==0)){
					cp=BattleWorkClientParamGet(bw,ret&1);
				}
				else{
					cp=BattleWorkClientParamGet(bw,ret);
				}
				if((cp->client_type==CLIENT_TYPE_A)||(cp->client_type==CLIENT_TYPE_AA)){
					break;
				}
			}
			ret|=sp->sel_mons_no[ret]<<8;
		}
		break;
	case SIDE_ENEMY_2:
		{
			CLIENT_PARAM	*cp;
			int	client_set_max;

			client_set_max=BattleWorkClientSetMaxGet(bw);
			for(ret=0;ret<client_set_max;ret++){
				cp=BattleWorkClientParamGet(bw,ret);
				if(cp->client_type==CLIENT_TYPE_D){
					break;
				}
			}
			ret|=sp->sel_mons_no[ret]<<8;
		}
		break;
	case SIDE_MINE_2:
		{
			CLIENT_PARAM	*cp;
			int	client_set_max;

			client_set_max=BattleWorkClientSetMaxGet(bw);
			for(ret=0;ret<client_set_max;ret++){
				cp=BattleWorkClientParamGet(bw,ret);
				if(cp->client_type==CLIENT_TYPE_C){
					break;
				}
			}
			ret|=sp->sel_mons_no[ret]<<8;
		}
		break;
	case SIDE_WORK:
		ret=sp->client_work;
		ret|=sp->sel_mons_no[sp->client_work]<<8;
		break;
	default:
		OS_Printf("MessageParamNicknameGet:ɂ̂͂\n");
		break;
	}
	return ret;
#endif
}

//============================================================================================
/**
 *	MESSAGE_PARAM\̃f[^֐iZio[j
 *
 * @param[in]	sp		T[op[^\
 * @param[in]	para	Ώۃp[^iSIDE_ATTACKASIDE_DEFENCEȂǁj
 */
//============================================================================================
static	int	MessageParamWazaGet(SERVER_PARAM *sp,int para)
{
	int ret;

	switch(para){
	case SIDE_ATTACK:
		ret=sp->waza_no_now;
		break;
	case SIDE_WORK:
		ret=sp->waza_work;
		break;
	default:
		OS_Printf("MessageParamWazaGet:ɂ̂͂\n");
		break;
	}
	return ret;
}

//============================================================================================
/**
 *	MESSAGE_PARAM\̃f[^֐iio[j
 *
 * @param[in]	sp		T[op[^\
 * @param[in]	para	Ώۃp[^iSIDE_ATTACKASIDE_DEFENCEȂǁj
 */
//============================================================================================
static	int	MessageParamItemGet(SERVER_PARAM *sp,int para)
{
	int ret;

	switch(para){
	case SIDE_ATTACK:
		ret=sp->psp[sp->attack_client].item;
		break;
	case SIDE_DEFENCE:
		ret=sp->psp[sp->defence_client].item;
		break;
	case SIDE_CLIENT_WORK:
		ret=sp->psp[sp->client_work].item;
		break;
	case SIDE_WORK:
		ret=sp->item_work;
		break;
	default:
		OS_Printf("MessageParamItemGet:ɂ̂͂\n");
		break;
	}
	return ret;
}

//============================================================================================
/**
 *	MESSAGE_PARAM\̃f[^֐ilj
 *
 * @param[in]	sp		T[op[^\
 * @param[in]	para	Ώۃp[^iSIDE_ATTACKASIDE_DEFENCEȂǁj
 */
//============================================================================================
static	int	MessageParamNumGet(SERVER_PARAM *sp,int para)
{
	int ret;

	switch(para){
	case SIDE_WORK:
		ret=sp->msg_work;
		break;
	default:
		OS_Printf("MessageParamNumGet:ɂ̂͂\n");
		break;
	}
	return ret;
}

//============================================================================================
/**
 *	MESSAGE_PARAM\̃f[^֐i^Cvj
 *
 * @param[in]	sp		T[op[^\
 * @param[in]	para	Ώۃp[^iSIDE_ATTACKASIDE_DEFENCEȂǁj
 */
//============================================================================================
static	int	MessageParamTypeGet(SERVER_PARAM *sp,int para)
{
	int ret;

	switch(para){
	case SIDE_WORK:
		ret=sp->msg_work;
		break;
	default:
		OS_Printf("MessageParamTypeGet:ɂ̂͂\n");
		break;
	}
	return ret;
}

//============================================================================================
/**
 *	MESSAGE_PARAM\̃f[^֐ij
 *
 * @param[in]	sp		T[op[^\
 * @param[in]	para	Ώۃp[^iSIDE_ATTACKASIDE_DEFENCEȂǁj
 */
//============================================================================================
static	int	MessageParamTokuseiGet(BATTLE_WORK *bw,SERVER_PARAM *sp,int para)
{
	int ret;
	int	client_no;

	switch(para){
	case SIDE_WORK:
		ret=sp->tokusei_work;
		break;
	default:
		client_no=SideClientNoGet(bw,sp,para);
		ret=sp->psp[client_no].speabino;
		break;
	}
	return ret;
}

//============================================================================================
/**
 *	MESSAGE_PARAM\̃f[^֐iXe[^Xj
 *
 * @param[in]	sp		T[op[^\
 * @param[in]	para	Ώۃp[^iSIDE_ATTACKASIDE_DEFENCEȂǁj
 */
//============================================================================================
static	int	MessageParamStatusGet(SERVER_PARAM *sp,int para)
{
	int ret;

	switch(para){
	case SIDE_WORK:
		ret=sp->msg_work;
		break;
	default:
		OS_Printf("MessageParamStatusGet:ɂ̂͂\n");
		break;
	}
	return ret;
}

//============================================================================================
/**
 *	MESSAGE_PARAM\̃f[^֐iԈُ햼j
 *
 * @param[in]	sp		T[op[^\
 * @param[in]	para	Ώۃp[^iSIDE_ATTACKASIDE_DEFENCEȂǁj
 */
//============================================================================================
static	int	MessageParamConditionGet(SERVER_PARAM *sp,int para)
{
	int ret;

	switch(para){
	case SIDE_WORK:
		ret=sp->msg_work;
		break;
	default:
		OS_Printf("MessageParamConditionGet:ɂ̂͂\n");
		break;
	}
	return ret;
}

//============================================================================================
/**
 *	MESSAGE_PARAM\̃f[^֐i|Pj
 *
 * @param[in]	sp		T[op[^\
 * @param[in]	para	Ώۃp[^iSIDE_ATTACKASIDE_DEFENCEȂǁj
 */
//============================================================================================
static	int	MessageParamPokenameGet(BATTLE_WORK *bw,SERVER_PARAM *sp,int para)
{
	int ret;
	int	client_no;

	client_no=SideClientNoGet(bw,sp,para);

	ret=client_no;
	ret|=sp->sel_mons_no[client_no]<<8;

	return ret;
#if 0
	int ret;

	switch(para){
	case SIDE_ATTACK:
		ret=sp->attack_client;
		ret|=sp->sel_mons_no[sp->attack_client]<<8;
		break;
	case SIDE_DEFENCE:
		ret=sp->defence_client;
		ret|=sp->sel_mons_no[sp->defence_client]<<8;
		break;
	case SIDE_KIZETSU:
		ret=sp->kizetsu_client;
		ret|=sp->sel_mons_no[sp->kizetsu_client]<<8;
		break;
	case SIDE_RESHUFFLE:
		ret=sp->reshuffle_client;
		ret|=sp->sel_mons_no[sp->reshuffle_client]<<8;
		break;
	case SIDE_TSUIKA:
		ret=sp->tsuika_client;
		ret|=sp->sel_mons_no[sp->tsuika_client]<<8;
		break;
	case SIDE_ENEMY:
	case SIDE_ENEMY_1:
		{
			CLIENT_PARAM	*cp;
			int	client_set_max;

			client_set_max=BattleWorkClientSetMaxGet(bw);
			for(ret=0;ret<client_set_max;ret++){
				cp=BattleWorkClientParamGet(bw,ret);
				if(cp->client_type&CLIENT_ENEMY_FLAG){
					break;
				}
			}
			ret|=sp->sel_mons_no[ret]<<8;
		}
		break;
	case SIDE_MINE:
	case SIDE_MINE_1:
		{
			CLIENT_PARAM	*cp;
			int	client_set_max;

			client_set_max=BattleWorkClientSetMaxGet(bw);
			for(ret=0;ret<client_set_max;ret++){
				cp=BattleWorkClientParamGet(bw,ret);
				if((cp->client_type&CLIENT_ENEMY_FLAG)==0){
					break;
				}
			}
			ret|=sp->sel_mons_no[ret]<<8;
		}
		break;
	default:
		OS_Printf("MessageParamPokenameGet:ɂ̂͂\n");
		break;
	}
	return ret;
#endif
}

//============================================================================================
/**
 *	MESSAGE_PARAM\̃f[^֐i|bNj
 *
 * @param[in]	sp		T[op[^\
 * @param[in]	para	Ώۃp[^iSIDE_ATTACKASIDE_DEFENCEȂǁj
 */
//============================================================================================
static	int	MessageParamPolockGet(SERVER_PARAM *sp,int para)
{
	int ret;

	switch(para){
	case SIDE_WORK:
		ret=sp->msg_work;
		break;
	default:
		OS_Printf("MessageParamPolockGet:ɂ̂͂\n");
		break;
	}
	return ret;
}

//============================================================================================
/**
 *	MESSAGE_PARAM\̃f[^֐i؂̖̎j
 *
 * @param[in]	sp		T[op[^\
 * @param[in]	para	Ώۃp[^iSIDE_ATTACKASIDE_DEFENCEȂǁj
 */
//============================================================================================
static	int	MessageParamTasteGet(SERVER_PARAM *sp,int para)
{
	int ret;

	switch(para){
	case SIDE_WORK:
		ret=sp->msg_work;
		break;
	default:
		OS_Printf("MessageParamTasteGet:ɂ̂͂\n");
		break;
	}
	return ret;
}

//============================================================================================
/**
 *	MESSAGE_PARAM\̃f[^֐ig[i[ʁj
 *
 * @param[in]	sp		T[op[^\
 * @param[in]	para	Ώۃp[^iSIDE_ATTACKASIDE_DEFENCEȂǁj
 */
//============================================================================================
static	int	MessageParamTRTypeGet(BATTLE_WORK *bw,SERVER_PARAM *sp,int para)
{
	int ret;
	int	client_no;

	client_no=SideClientNoGet(bw,sp,para);

	ret=BattleWorkTrainerIDGet(bw,client_no);
	ret=TT_TrainerDataParaGet(ret,ID_TD_tr_type);

	return ret;
}

//============================================================================================
/**
 *	MESSAGE_PARAM\̃f[^֐ig[i[j
 *
 * @param[in]	sp		T[op[^\
 * @param[in]	para	Ώۃp[^iSIDE_ATTACKASIDE_DEFENCEȂǁj
 */
//============================================================================================
static	int	MessageParamTRNameGet(BATTLE_WORK *bw,SERVER_PARAM *sp,int para)
{
	int ret;
	int	client_no;

	client_no=SideClientNoGet(bw,sp,para);

	ret=BattleWorkTrainerIDGet(bw,client_no);

	return (ret|client_no<<16);
}


