//==============================================================================
/**
 * @file	wazatype_panel.c
 * @brief	Z^Cṽplf[^̎oȂ
 * @author	matsuda
 * @date	2005.12.02()
 */
//==============================================================================
#include "common.h"
#include "system/arc_tool.h"
#include "system/arc_util.h"
#include "system/palanm.h"
#include "battle/wazatype_panel.h"
#include "graphic\batt_bg_def.h"

//==============================================================================
//	萔`
//==============================================================================
///Z^CvCGRf[^Xɂ邩
#define WAZATYPE_CGR_X_LEN	(18)
///Z^CvCGRf[^ɓĂAj
#define WAZATYPE_CGR_ANM_NUM	(3)
///Z^CvCGRf[^1̃AjXTCY
#define WAZATYPE_CGR_X_ONE	(WAZATYPE_CGR_X_LEN / WAZATYPE_CGR_ANM_NUM)
///Z^CvCGRf[^iɓnăf[^݂Ă邩
#define WAZATYPE_CGR_Y_LEN	(9)


//==============================================================================
//	f[^
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   Z^CvCGRf[^
 */
//--------------------------------------------------------------
ALIGN4 static const u16 WazaTypeCgrID[] = {
	BATTLE_W_TYPE01_NCGR_BIN,
	BATTLE_W_TYPE01_NCGR_BIN,
	BATTLE_W_TYPE01_NCGR_BIN,
	BATTLE_W_TYPE01_NCGR_BIN,
	BATTLE_W_TYPE01_NCGR_BIN,
	BATTLE_W_TYPE01_NCGR_BIN,
	BATTLE_W_TYPE01_NCGR_BIN,
	BATTLE_W_TYPE01_NCGR_BIN,
	BATTLE_W_TYPE01_NCGR_BIN,
	BATTLE_W_TYPE01_NCGR_BIN,
	BATTLE_W_TYPE01_NCGR_BIN,
	BATTLE_W_TYPE01_NCGR_BIN,
	BATTLE_W_TYPE01_NCGR_BIN,
	BATTLE_W_TYPE01_NCGR_BIN,
	BATTLE_W_TYPE01_NCGR_BIN,
	BATTLE_W_TYPE01_NCGR_BIN,
	BATTLE_W_TYPE01_NCGR_BIN,
	BATTLE_W_TYPE01_NCGR_BIN,
};

//--------------------------------------------------------------
/**
 * @brief   Z^Cṽpbgf[^
 */
//--------------------------------------------------------------
ALIGN4 static const u16 WazaTypePlttID[] = {
	BATTLE_W_TYPE12_NCLR,
	BATTLE_W_TYPE04_NCLR,
	BATTLE_W_TYPE14_NCLR,
	BATTLE_W_TYPE10_NCLR,
	BATTLE_W_TYPE08_NCLR,
	BATTLE_W_TYPE02_NCLR,
	BATTLE_W_TYPE17_NCLR,
	BATTLE_W_TYPE06_NCLR,
	BATTLE_W_TYPE13_NCLR,
	BATTLE_W_TYPE18_NCLR,
	BATTLE_W_TYPE15_NCLR,
	BATTLE_W_TYPE16_NCLR,
	BATTLE_W_TYPE05_NCLR,
	BATTLE_W_TYPE09_NCLR,
	BATTLE_W_TYPE03_NCLR,
	BATTLE_W_TYPE07_NCLR,
	BATTLE_W_TYPE11_NCLR,
	BATTLE_W_TYPE01_NCLR,
};




//--------------------------------------------------------------
/**
 * @brief   Zpl̃OtBbNĂArcID擾
 * @retval  ARC_ID
 */
//--------------------------------------------------------------
int WazaPanel_ArcIDGet(void)
{
	return ARC_BATT_BG;
}

//--------------------------------------------------------------
/**
 * @brief   Zpl̃LN^INDEX擾
 * @param   waza_type		Z^Cv(莝̏ꍇ-1)
 * @retval  w肵Z^CṽLN^INDEX
 */
//--------------------------------------------------------------
u32 WazaPanel_CharIndexGet(int waza_type)
{
	u32 char_index;
	
	if(waza_type != -1){
		char_index = WazaTypeCgrID[waza_type];
	}
	else{
		char_index = BATTLE_W_TYPE00_NCGR_BIN;
	}
	return char_index;
}

//--------------------------------------------------------------
/**
 * @brief   Zpl̃pbgINDEX擾
 * @param   waza_type		Z^Cv(莝̏ꍇ-1)
 * @retval  w肵Z^CṽpbgINDEX
 */
//--------------------------------------------------------------
u32 WazaPanel_PalIndexGet(int waza_type)
{
	u32 pal_index;
	
	if(waza_type != -1){
		pal_index = WazaTypePlttID[waza_type];
	}
	else{
		pal_index = BATTLE_W_TYPE00_NCLR;
	}
	return pal_index;
}

//--------------------------------------------------------------
/**
 * @brief   Z^Cvpl̃OtBbN[h
 *
 * @param   bgl				BGLւ̃|C^
 * @param   heap_id			e|Ŏgpq[vID
 * @param   frame_no		[h̃t[
 * @param   trans_pos		[h̓]ʒu(`̍̃LN^ԍ)
 * @param   screen_type		GF_BGL_SCRSIZ_256x256 
 * @param   arc_id			WazaPanel_ArcIDGetŎlłB
 * @param   char_index		WazaPanel_CharIndexGetŎlłB
 *
 * ]͋Z^CvplƓ`̗̈悪`ŎĂ鎖OłB
 * trans_pos͂̃[hA`̍̃LN^ʒuw肵܂B
 */
//--------------------------------------------------------------
void WazaPanel_CharLoad(GF_BGL_INI *bgl, int heap_id, int frame_no, u32 trans_pos, 
	int screen_type, int arc_id, int char_index)
{
	void *arc_data;
	NNSG2dCharacterData *char_data;
	u8 *charcter;
	u32 y_len;
	int y;
	
	switch(screen_type){
	case GF_BGL_SCRSIZ_256x256:
	case GF_BGL_SCRSIZ_256x512:
		y_len = 32;
		break;
	case GF_BGL_SCRSIZ_512x256:
	case GF_BGL_SCRSIZ_512x512:
		y_len = 64;
		break;
	default:
		GF_ASSERT(0 && "ΉĂȂXN[^Cvł\n");
		return;
	}
	
	//L]
	arc_data = ArcUtil_CharDataGet(arc_id, char_index, 1, &char_data, heap_id);
	charcter = char_data->pRawData;
	for(y = 0; y < WAZATYPE_CGR_Y_LEN; y++){
		GF_BGL_LoadCharacter(bgl, frame_no, 
			&charcter[WAZATYPE_CGR_X_LEN * 0x20 * y], 
			WAZATYPE_CGR_X_ONE * 0x20, trans_pos + (y_len*y));
	}
	sys_FreeMemoryEz(arc_data);
}

//--------------------------------------------------------------
/**
 * @brief   Z^Cvpl̃L]g₷悤ɂ܂Ƃ߂
 *
 * @param   bgl				BGLւ̃|C^
 * @param   waza_type		Z^Cv(莝̏ꍇ-1)
 * @param   heap_id		e|Ŏgpq[vID
 * @param   frame_no		[h̃t[
 * @param   trans_pos		[h̓]ʒu(`̍̃LN^ԍ)
 * @param   screen_type		GF_BGL_SCRSIZ_256x256 
 */
//--------------------------------------------------------------
void WazaPanel_EasyCharLoad(GF_BGL_INI *bgl, int waza_type, int heap_id, int frame_no, 
	u32 trans_pos, int screen_type)
{
	u32 arc_id, char_index;
	
	arc_id = WazaPanel_ArcIDGet();
	char_index = WazaPanel_CharIndexGet(waza_type);
	WazaPanel_CharLoad(bgl, heap_id, frame_no, trans_pos, screen_type, arc_id, char_index);
}

//--------------------------------------------------------------
/**
 * @brief   Z^Cvpl̃pbg]g₷悤ɂ܂Ƃ߂
 *
 * @param   pfd				pbgtF[hVXeւ̃|C^
 * @param   waza_type		Z^Cv(莝̏ꍇ-1)
 * @param   heap_id			e|Ŏgpq[vID
 * @param   req				NGXgf[^ԍ
 * @param   palette_pos		pbg]ʒu(pbgԍŎw)
 */
//--------------------------------------------------------------
void WazaPanel_EasyPalLoad(PALETTE_FADE_PTR pfd, int waza_type, int heap_id, 
	FADEREQ req, int palette_pos)
{
	u32 arc_id, pal_index;
	
	arc_id = WazaPanel_ArcIDGet();
	pal_index = WazaPanel_PalIndexGet(waza_type);
	PaletteWorkSet_Arc(pfd, arc_id, pal_index, heap_id, req, 0x20, palette_pos * 16);
}

