//=============================================================================
/**
 * @file	comm_command.c
 * @brief	f[^𑗂邽߂̃R}he[uĂ܂
 *          MeꍇAɒǉĂƂɂȂ܂
 *          comm_command.h  enum ƓтłKv܂
 * @author	Katsumi Ohno
 * @date    2005.07.26
 */
//=============================================================================

#include "common.h"
#include "communication/communication.h"
#include "communication/comm_state.h"
#include "comm_local.h"

#include "system/mystatus.h"

//==============================================================================
//  static`
//==============================================================================
static int _getVariable(void);
static int _getZero(void);
static int _getOne(void);
static void _commCommandRecvThrowOut(int netID, int size, void* pData, void* pWork);
static void _commCommandRecvThrowOutReq(int netID, int size, void* pData, void* pWork);
static void _commCommandRecvThrowOutEnd(int netID, int size, void* pData, void* pWork);




//==============================================================================
//	e[u錾
//  comm_shar.h  enum ƓȂтɂĂ
//  CALLBACKĂ΂ꂽȂꍇNULLĂ
//  R}h̃TCYԂ֐Ă炦ƒʐMyȂ܂
//  _getZero̓TCYȂԂ܂B_getVariable͉σf[^gpɎg܂
//==============================================================================
static const CommPacketTbl _CommPacketTbl[] = {
    _SET(NULL, _getZero, "CS_NONE")
    _SET(NULL, _getZero, "CS_EXIT")
    _SET(CommRecvAutoExit, _getZero, "CS_AUTO_EXIT")
    _SET(CommInfoRecvPlayerData, CommInfoGetPlayerDataSize, "CS_COMM_INFO")
    _SET(CommInfoRecvMyStatusData, MyStatus_GetWorkSize, "CS_COMM_MYSTATUS")
    _SET(CommInfoRecvArrayPlayerData, CommInfoGetPlayerDataSize, "CS_COMM_INFO_ARRAY")
    _SET(CommInfoRecvMyStatusArrayData, MyStatus_GetWorkSize, "CS_COMM_MYSTATUS_ARRAY")
    _SET(CommInfoRecvEnd, _getZero, "CS_COMM_INFO_END")
    _SET(CommRecvNegotiation, CommRecvGetNegotiationSize, "CS_COMM_NEGOTIATION")
    _SET(CommRecvNegotiationReturn, CommRecvGetNegotiationSize, "CS_COMM_NEGOTIATION_RETURN")
    _SET(NULL, _getVariable, "CS_DEBUG_VARIABLE")
    _SET(CommStateRecvDebugStart, _getZero, "CS_DEBUG_START")
    _SET(CommRecvDSMPChange, _getOne, "CS_DSMP_CHANGE")
    _SET(CommRecvDSMPChangeReq, _getOne, "CS_DSMP_CHANGE_REQ")
    _SET(CommRecvDSMPChangeEnd, _getOne, "CS_DSMP_CHANGE_END")
    _SET(_commCommandRecvThrowOut, _getZero, "CS_COMMAND_THROWOUT")
    _SET(_commCommandRecvThrowOutReq, _getZero, "CS_COMMAND_THROWOUT_REQ")
    _SET(_commCommandRecvThrowOutEnd, _getZero, "CS_COMMAND_THROWOUT_END")
    _SET(CommRecvTimingSync, _getOne, "CS_TIMING_SYNC")
    _SET(CommRecvTimingSyncEnd, _getOne, "CS_TIMING_SYNC_END")
    _SET(CommRecvSpritData, CommGetSpritDataPacketSize, "CS_SPRIT_DATA")
    _SET(CommRecvListNo, CommGetListNoSize, "CS_LIST_NO")
};

typedef struct{
    const CommPacketTbl* pCommPacket;  ///< fieldbattlẽR}h̃e[u
    int listNum;                       ///< _pCommPacketlist
    void* pWork;                       ///< fieldbattlẽCɂȂ郏[N
    u8 bThrowOutReq[COMM_MACHINE_MAX];        ///< R}htO
    u8 bThrowOuted;    ///< R}hւITRUE
} _COMM_COMMAND_WORK;

static _COMM_COMMAND_WORK* _pCommandWork = NULL;


//--------------------------------------------------------------
/**
 * @brief   R}he[ȕ
 * @param   pCommPacketLocal ĂяoW[p̃R}ȟn
 * @param   listNum          R}h
 * @param   pWork            ĂяoW[p̃[NGA
 * @retval  none
 */
//--------------------------------------------------------------

void CommCommandInitialize(const CommPacketTbl* pCommPacketLocal,int listNum,void* pWork)
{
    int i;
    
    if(!_pCommandWork){
        _pCommandWork = sys_AllocMemory(HEAPID_COMMUNICATION, sizeof(_COMM_COMMAND_WORK));
    }
    _pCommandWork->pCommPacket = pCommPacketLocal;
    _pCommandWork->listNum = listNum;
    _pCommandWork->pWork = pWork;


    for(i = 0 ; i < COMM_MACHINE_MAX; i++){
        _pCommandWork->bThrowOutReq[i] = FALSE;
    }
    _pCommandWork->bThrowOuted = FALSE;


}

//--------------------------------------------------------------
/**
 * @brief   R}he[ȕI
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------

void CommCommandFinalize( void )
{
    if(_pCommandWork){
        sys_FreeMemoryEz(_pCommandWork);
        _pCommandWork = NULL;
    }
}

//--------------------------------------------------------------
/**
 * @brief   e[uɏ] MR[obNĂяo܂
 * @param   command         MR}h
 * @param   netID           lbg[NID
 * @param   size            Mf[^TCY
 * @param   pData           Mf[^
 * @retval  none
 */
//--------------------------------------------------------------

void CommCommandCallBack(int netID, int command, int size, void* pData)
{
    PTRCommRecvFunc func;

    if( command < CS_COMMAND_MAX ){
#if _COMMANDNAME_DEBUG
        OHNO_PRINT("%s %d call\n",_CommPacketTbl[command].pCommandName,CommCommandGetPacketSize(command));
#endif
        func = _CommPacketTbl[command].callbackFunc;
    }
    else{
        GF_ASSERT_RETURN(_pCommandWork,);
        if(command > (_pCommandWork->listNum + CS_COMMAND_MAX)){
            OHNO_PRINT("command %d \n", command);
            GF_ASSERT(0 && "݂ȂʐMR}h");
            return;  // {Ԃł̓R}hȂ
        }
#if _COMMANDNAME_DEBUG
        if(_pCommandWork->pCommPacket[command - CS_COMMAND_MAX].pCommandName!=NULL){
            OHNO_PRINT("%s call\n",_pCommandWork->pCommPacket[command - CS_COMMAND_MAX].pCommandName);
        }
#endif
        func = _pCommandWork->pCommPacket[command - CS_COMMAND_MAX].callbackFunc;
    }
    if(func != NULL){
        if(_pCommandWork){
            func(netID, size, pData, _pCommandWork->pWork);
        }
        else{
            func(netID, size, pData, NULL);
        }
    }
}


//--------------------------------------------------------------
/**
 * @brief   `R}h̃TCYԂ܂
 * @param   command         R}h
 * @retval  f[^̃TCY   ςȂ COMM_VARIABLE_SIZEԂ܂
 */
//--------------------------------------------------------------

int CommCommandGetPacketSize(int command)
{
    int size = 0;
    PTRCommRecvSizeFunc func;
    
    if( command < CS_COMMAND_MAX ){
        func = _CommPacketTbl[command].getSizeFunc;
    }
    else{
        GF_ASSERT_RETURN(_pCommandWork, size);
        if(command > (_pCommandWork->listNum + CS_COMMAND_MAX)){
            OHNO_PRINT("command %d \n", command);
            GF_ASSERT(0 && "݂ȂʐMR}h");
            return size;  // {Ԃł̓R}hȂ
        }
        func = _pCommandWork->pCommPacket[command - CS_COMMAND_MAX].getSizeFunc;
    }
    if(func != NULL){
        size = func();
    }
    return size;
}


//--------------------------------------------------------------
/**
 * @brief   RƂTCYԂ܂
 * @param   command         R}h
 * @retval  TCY   ςȂ COMM_VARIABLE_SIZE Zero͂OԂ
 */
//--------------------------------------------------------------
static int _getVariable(void)
{
    return COMM_VARIABLE_SIZE;
}

static int _getZero(void)
{
    return 0;
}

static int _getOne(void)
{
    return 1;
}


//--------------------------------------------------------------
/**
 * @brief   R}he[u̔p
 * @param   none
 * @retval  tTRUE
 */
//--------------------------------------------------------------

BOOL CommCommandThrowOut(void)
{
    GF_ASSERT_RETURN(_pCommandWork, );

    _pCommandWork->bThrowOuted = FALSE;
    return CommSendFixData(CS_COMMAND_THROWOUT);
}


//==============================================================================
/**
 * R}hpR[obN
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _commCommandRecvThrowOut(int netID, int size, void* pData, void* pWork)
{
    u8* pBuff = pData;
    int i;

    if(CommGetCurrentID() != COMM_PARENT_ID){
        return;
    }
//    OHNO_PRINT("CommRecvDSMPChange M\n");
    // Sɐ؂ւM𑗂
    _pCommandWork->bThrowOutReq[netID] = TRUE;
    for(i = 0 ; i < COMM_MACHINE_MAX; i++){
        if(!CommIsConnect(i)){
            continue;
        }
        if(!_pCommandWork->bThrowOutReq[i]){
            return;
        }
    }
    CommSendData_ServerSide(CS_COMMAND_THROWOUT_REQ, NULL, 0);
}

//==============================================================================
/**
 * R}hpsR[obN
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _commCommandRecvThrowOutReq(int netID, int size, void* pData, void* pWork)
{
    u8* pBuff = pData;
    int i;

    _pCommandWork->pCommPacket = NULL;
    _pCommandWork->listNum = 0;
    _pCommandWork->pWork = NULL;
    _pCommandWork->bThrowOuted = TRUE;

    CommSendFixSizeData(CS_COMMAND_THROWOUT_END,pData);
}

//==============================================================================
/**
 * R}hpR[obN
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _commCommandRecvThrowOutEnd(int netID, int size, void* pData, void* pWork)
{
    u8* pBuff = pData;
    int i;

    if(CommGetCurrentID() != COMM_PARENT_ID){
        return;
    }
    _pCommandWork->bThrowOutReq[netID] = FALSE;
}

//==============================================================================
/**
 * R}hłǂmF
 * @param   none
 * @retval  TRUE
 */
//==============================================================================

BOOL CommCommandIsThrowOuted(void)
{
    if(_pCommandWork){
        return _pCommandWork->bThrowOuted;
    }
    return FALSE;
}

//==============================================================================
/**
 * fobOpɃR}h\
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommCommandDebugPrint(int command)
{
#if _COMMANDNAME_DEBUG
    if( command < CS_COMMAND_MAX ){
        OHNO_PRINT(" %s \n",_CommPacketTbl[command].pCommandName);
    }
    else{
        if(_pCommandWork->pCommPacket[command - CS_COMMAND_MAX].pCommandName!=NULL){
            OHNO_PRINT("%s call\n",_pCommandWork->pCommPacket[command - CS_COMMAND_MAX].pCommandName);
        }
    }
#endif
}

//==============================================================================
/**
 * ʐMԏ𑗂
 * @param   none
 * @retval  none
 */
//==============================================================================
#if 0   //  ʐMԂ̓R}hƂđ @@OO
static void _packSendData(void)
{
    ShareData *senddata;

    senddata = CommSharGetSendData();
    senddata->param = (u8)WM_GetLinkLevel();
    senddata->huge = 0;

    if (_pCommShare->sBeaconCount != 0) {
        if (_pCommShare->sBeaconCount > 0) {
            _pCommShare->sBeaconCount = -_pCommShare->sBeaconCount + 1;
        }
        else {
            _pCommShare->sBeaconCount = -_pCommShare->sBeaconCount - 1;
        }
    }
}
#endif

