//=============================================================================
/**
 * @file	comm_info.c
 * @brief	ʐMœeJZbg̊{~ĂNX
 * @author	Katsumi Ohno
 * @date    2005.08.22
 */
//=============================================================================

#include "common.h"
#include "communication/communication.h"
#include "comm_local.h"

#include "system/gamedata.h"
#include "system/pm_str.h"

#include "communication/comm_info.h"
#include "system/savedata.h"

//==============================================================================
// [N
//==============================================================================

enum _info_e {
    _INFO_EMPTY,      // 
    _INFO_NEW_ENTRY,  // MĉΉĂȂ[U[
    _INFO_ENTRY,      // t o[ɂȂ
    _INFO_ENTRY_MSGSENDED,      // bZ[WI
    _INFO_MAX
};

// MYSTATUSɂȂvf\
typedef struct{
    u8 netID;     /// ID
    u8 mac[WM_SIZE_BSSID];  ///mac
} PlayerInfo;

typedef struct{
    PlayerInfo sPlayerData[COMM_MACHINE_MAX];  // ʐMp info
    MYSTATUS* pMyStatus[COMM_MACHINE_MAX];     // myStatus
    u8 info[COMM_MACHINE_MAX];    /// 
    u8 _infoEnd;
    u8 bNewInfoData;
    u8 nowNetID;
} _COMM_INFO_WORK;

static _COMM_INFO_WORK* _pCommInfo;

#define _INVALID_POKEID (-1)  /// ȃ|PID
#define _ID_STR_LENGTH  (5)  /// IĎ

//--------------------------------------------------------------
/**
 * @brief   ʐMǗ̏
 * @param   pWork       Ŏgp郏[NGA
 * @retval  none
 */
//--------------------------------------------------------------

void CommInfoInitialize(MYSTATUS* pMyStatus)
{
    int i;

    if(_pCommInfo){
        return;
    }
    _pCommInfo = sys_AllocMemory(HEAPID_COMMUNICATION, sizeof(_COMM_INFO_WORK));
    for(i = 0; i < COMM_MACHINE_MAX ; i++){
        _pCommInfo->pMyStatus[i] = MyStatus_AllocWork(HEAPID_COMMUNICATION);
        CommInfoDeletePlayer( i );
    }
    _pCommInfo->_infoEnd = FALSE;
    _pCommInfo->bNewInfoData = FALSE;
    _pCommInfo->nowNetID = 0;
    
    // MYSTATUSRs[
    MyStatus_Copy( pMyStatus, _pCommInfo->pMyStatus[0]);
}

//--------------------------------------------------------------
/**
 * @brief   ʐMǗ̊J
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------

void CommInfoFinalize(void)
{
    int i;

    if(_pCommInfo){
        for(i = 0; i < COMM_MACHINE_MAX ; i++){
            sys_FreeMemoryEz(_pCommInfo->pMyStatus[i]);
        }
        if(_pCommInfo){
            sys_FreeMemoryEz(_pCommInfo);
        }
        _pCommInfo = NULL;
    }
}

//--------------------------------------------------------------
/**
 * @brief   ł邩ǂԂ
 * @param   none
 * @retval  ̏ꍇTRUE
 */
//--------------------------------------------------------------

BOOL CommInfoIsInitialize(void)
{
    return (_pCommInfo != NULL);
}



//--------------------------------------------------------------
/**
 * @brief   ID,nameȂǂ𑗐M܂
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------


void CommInfoSendPokeData(void)
{
    u16 netID = CommGetCurrentID();
    MYSTATUS* pMyStatus;

    pMyStatus = CommMPGetMyStatus();
    OS_GetMacAddress(&_pCommInfo->sPlayerData[netID].mac[0]);
    CommSendData(CS_COMM_INFO, &_pCommInfo->sPlayerData[netID], sizeof(PlayerInfo));
    CommSendData(CS_COMM_MYSTATUS, pMyStatus, MyStatus_GetWorkSize());
}

//--------------------------------------------------------------
/**
 * @brief   v[[̃TCYԂ܂
 * @param   netID           lbg[NID
 * @param   size            Mf[^TCY
 * @param   pData           Mf[^
 * @retval  none
 */
//--------------------------------------------------------------
int CommInfoGetPlayerDataSize(void)
{
    return sizeof(PlayerInfo);
}

//--------------------------------------------------------------
/**
 * @brief   infof[^ׂĂƂR}h̎M
 * @param   netID           lbg[NID
 * @param   size            Mf[^TCY
 * @param   pData           Mf[^
 * @retval  none
 */
//--------------------------------------------------------------

void CommInfoRecvEnd( int netID, int size, void* pData, void* pWork)
{
    if(_pCommInfo){
        _pCommInfo->_infoEnd = TRUE;
    }
    else{
        OHNO_PRINT("comminfoĂȂ\n");
    }
}


//--------------------------------------------------------------
/**
 * @brief   T[o[݂Ȃ̏񂪑ĂǂmF
 * @param   none
 * @retval  ĂTRUE
 */
//--------------------------------------------------------------
BOOL CommInfoIsInfoCollected(void)
{
    return _pCommInfo->_infoEnd;
}

//--------------------------------------------------------------
/**
 * @brief   MR[obNĂяo܂
 * @param   netID           lbg[NID
 * @param   size            Mf[^TCY
 * @param   pData           Mf[^
 * @retval  none
 */
//--------------------------------------------------------------

void CommInfoRecvArrayPlayerData( int netID, int size, void* pData, void* pWork)
{
    PlayerInfo* pPlayer = (PlayerInfo*)pData;
    if(!_pCommInfo){
        OHNO_PRINT("comminfoĂȂ\n");
        return;
    }
    MI_CpuCopy8( pData, &_pCommInfo->sPlayerData[pPlayer->netID], sizeof(PlayerInfo));
    _pCommInfo->nowNetID = pPlayer->netID;
}

//--------------------------------------------------------------
/**
 * @brief   MR[obNĂяo܂ CS_COMM_INFO
 * @param   netID           lbg[NID
 * @param   size            Mf[^TCY
 * @param   pData           Mf[^
 * @retval  none
 */
//--------------------------------------------------------------

void CommInfoRecvPlayerData( int netID, int size, void* pData, void* pWork)
{
    int i;

    if(!_pCommInfo){
        OHNO_PRINT("comminfoĂȂ\n");
        return;
    }
    OHNO_PRINT("CommInfoServer VȃGg[ %d\n", netID);

    MI_CpuCopy8( pData, &_pCommInfo->sPlayerData[netID], sizeof(PlayerInfo));
    CommMPSetBackupMacAddress(&_pCommInfo->sPlayerData[netID].mac[0], netID);
}

//--------------------------------------------------------------
/**
 * @brief   MyXe[^XM  CS_COMM_MYSTATUS
 * @param   netID           lbg[NID
 * @param   size            Mf[^TCY
 * @param   pData           Mf[^
 * @retval  none
 */
//--------------------------------------------------------------

void CommInfoRecvMyStatusData( int netID, int size, void* pData, void* pWork)
{
    if(!_pCommInfo){
        OHNO_PRINT("comminfoĂȂ\n");
        return;
    }
    OHNO_PRINT("CommInfoServer VȃGg[ %d\n", netID);
    OHNO_PRINT("CommInfo mystatusGET %d\n", netID);
    MI_CpuCopy8( pData, _pCommInfo->pMyStatus[netID], MyStatus_GetWorkSize());
    _pCommInfo->info[netID] = _INFO_NEW_ENTRY;  // VȃGg[
    if(CommGetCurrentID() == netID){  // g͂łɎtԂɂ
        _pCommInfo->info[netID] = _INFO_ENTRY_MSGSENDED;
    }
    else{
        _pCommInfo->bNewInfoData = TRUE;
    }
}

//--------------------------------------------------------------
/**
 * @brief   MyXe[^XM  CS_COMM_MYSTATUS_ARRAY
 * @param   netID           lbg[NID
 * @param   size            Mf[^TCY
 * @param   pData           Mf[^
 * @retval  none
 */
//--------------------------------------------------------------

void CommInfoRecvMyStatusArrayData( int netID, int size, void* pData, void* pWork)
{
    if(!_pCommInfo){
        OHNO_PRINT("comminfoĂȂ\n");
        return;
    }
    OHNO_PRINT("CommInfo mystatusArrayGET %d\n", _pCommInfo->nowNetID);
    MI_CpuCopy8(pData, _pCommInfo->pMyStatus[_pCommInfo->nowNetID],
                MyStatus_GetWorkSize());
#if PM_DEBUG
    {
        const STRCODE* pN = MyStatus_GetMyName(_pCommInfo->pMyStatus[_pCommInfo->nowNetID]);
        OHNO_PRINT("%d %d %d %d\n",pN[0],pN[1],pN[2],pN[3]);
    }
#endif
    if(_pCommInfo->info[_pCommInfo->nowNetID] < _INFO_ENTRY){
        OHNO_PRINT("CommInfo VȃGg[ %d\n", _pCommInfo->nowNetID);
        _pCommInfo->info[_pCommInfo->nowNetID] = _INFO_NEW_ENTRY;  // VȃGg[
        if(CommGetCurrentID() == _pCommInfo->nowNetID){  // g͂łɎtԂɂ
            _pCommInfo->info[_pCommInfo->nowNetID] = _INFO_ENTRY_MSGSENDED;
        }
    }

}

//--------------------------------------------------------------
/**
 * @brief   T[o[q@ɑS̃\[X𑗐M܂
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------

void CommInfoSendArray_ServerSide(void)
{
    int i;
    if(!_pCommInfo->bNewInfoData){
        return;
    }

    if(!CommIsSendCommand_ServerSize(CS_COMM_INFO_END)){
        OHNO_PRINT("comminfoarray-------q@ɑM\n");
        for(i=0;i<COMM_MACHINE_MAX;i++){
            if(_pCommInfo->info[i] != _INFO_EMPTY){
                OHNO_PRINT("%d 𑗐M\n", i);
                _pCommInfo->sPlayerData[i].netID = i;
                CommSetSendQueue_ServerSide(CS_COMM_INFO_ARRAY,
                                            &_pCommInfo->sPlayerData[i],
                                            sizeof(PlayerInfo));
                CommSetSendQueue_ServerSide(CS_COMM_MYSTATUS_ARRAY,
                                            _pCommInfo->pMyStatus[i],
                                            MyStatus_GetWorkSize());
            }
        }
        // INFOf[^SđI𑗐M ID̃NGXgŏI
        CommSetSendQueue_ServerSide(CS_COMM_INFO_END, NULL,0);
        _pCommInfo->bNewInfoData = FALSE;
    }
}

//--------------------------------------------------------------
/**
 * @brief   Vinfof[^ǂ
 * @param   none
 * @retval  Vinfof[^ꍇTRUE
 */
//--------------------------------------------------------------

BOOL CommInfoIsNewInfoData(void)
{
    return _pCommInfo->bNewInfoData;
}

//--------------------------------------------------------------
/**
 * @brief   [Nɂ閼O𓾂܂
 * @param   index       lindexԍ
 * @param   name        l̖Oobt@̃|C^
 * @retval  OTRUE
 */
//--------------------------------------------------------------

BOOL CommInfoGetName(int index,u16* name)
{
    return FALSE;
}

//--------------------------------------------------------------
/**
 * @brief   [NɂlID𕶎œ܂
 * @param   index       lindexԍ
 * @param   idStr       lIDobt@̃|C^
 * @retval  IDTRUE
 */
//--------------------------------------------------------------

BOOL CommInfoGetIDString(int netID, u16* idStr)
{
    return FALSE;
}

//--------------------------------------------------------------
/**
 * @brief   
 * @param   netID           lbg[NID
 * @retval  none
 */
//--------------------------------------------------------------

void CommInfoDeletePlayer(int netID)
{
//    _pCommInfo->sPlayerData[netID].pokeNickName[0] = 0;
//    _pCommInfo->sPlayerData[netID].pokeID = _INVALID_POKEID;
    MyStatus_Init(_pCommInfo->pMyStatus[ netID ]);
    _pCommInfo->info[ netID ] = _INFO_EMPTY;

}

//--------------------------------------------------------------
/**
 * @brief   VOǂׂ
 * @param   netID           lbg[NID
 * @retval  VȌꍇTRUEԂ
 */
//--------------------------------------------------------------

BOOL CommInfoIsNewName(int netID)
{
    return (_pCommInfo->info[netID] == _INFO_ENTRY) || (_pCommInfo->info[netID] == _INFO_NEW_ENTRY);
}

//--------------------------------------------------------------
/**
 * @brief   VԒԂƂĔF؂
 * @param   netID           lbg[NID
 * @retval  none
 */
//--------------------------------------------------------------

void CommInfoSetEntry(int netID)
{
    _pCommInfo->info[netID] = _INFO_ENTRY;
}

//--------------------------------------------------------------
/**
 * @brief   󂯎ƂbZ[W\IƂi[
 * @param   netID           lbg[NID
 * @retval  none
 */
//--------------------------------------------------------------

void CommInfoSetMessageEnd(int netID)
{
    _pCommInfo->info[netID] = _INFO_ENTRY_MSGSENDED;
}


//--------------------------------------------------------------
/**
 * @brief   VOǂׂ
 * @param   netID           lbg[NID
 * @retval  VȌꍇ0ȏԂ
 */
//--------------------------------------------------------------

int CommInfoGetNewNameID(void)
{
    int i;
    
    for(i = 0; i < COMM_MACHINE_MAX ; i++){
        if(_pCommInfo->info[i] == _INFO_NEW_ENTRY){
            return i;
        }
    }
    return INVALID_NETID;
}

//--------------------------------------------------------------
/**
 * @brief   Gg[lA
 * @param   none
 * @retval  num
 */
//--------------------------------------------------------------

int CommInfoGetEntryNum(void)
{
    int i;
    int j = 0;

    for(i = 0; i < COMM_MACHINE_MAX ; i++){
        switch(_pCommInfo->info[i]){
          case _INFO_ENTRY:
          case _INFO_ENTRY_MSGSENDED:
            j++;
            break;
        }
    }
    return j;
}

//--------------------------------------------------------------
/**
 * @brief   ڑɉăf[^
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------

void CommInfoFunc(void)
{
    int i;

    if(_pCommInfo){
        if(CommGetConnectNum()==0){
            return;
        }
        for(i = 0; i < COMM_MACHINE_MAX ; i++){
            if( !CommIsConnect(i) && !( (i == COMM_PARENT_ID) && CommGetAloneMode())  ){
                if(_pCommInfo->info[i] != _INFO_EMPTY){
                    CommInfoDeletePlayer(i);
                }
            }
        }
    }
}


//==============================================================================
/**
 *  MyStatusԂ
 * @param   netID   id
 * @retval  MYSTATUS*
 */
//==============================================================================

MYSTATUS* CommInfoGetMyStatus(int netID)
{
    if(!_pCommInfo){
        return NULL;
    }
    switch(_pCommInfo->info[netID]){
      case _INFO_NEW_ENTRY:
      case _INFO_ENTRY:
      case _INFO_ENTRY_MSGSENDED:
//        OHNO_PRINT("f[^݂? %d\n",netID);
  //      {
//            const STRCODE* pName = MyStatus_GetMyName(_pCommInfo->pMyStatus[netID]);
  //          OHNO_PRINT(" %d %d %d %d \n",pName[0],pName[1],pName[2],pName[3]);
    //    }
        return _pCommInfo->pMyStatus[netID];
    }
    return NULL;
}

//==============================================================================
/**
 *  MacAddressԂ
 * @param   netID   id
 * @retval  MYSTATUS*
 */
//==============================================================================

u8* CommInfoGetMacAddress(int netID)
{
    if(_pCommInfo->info[netID] == _INFO_EMPTY){
        return &_pCommInfo->sPlayerData[netID].mac[0];
    }
    return NULL;
}

