//=============================================================================
/**
 * @file	comm_local.c
 * @brief	ʐM̒჌xȔėp֐W߂
 * @author	Katsumi Ohno
 * @date    2005.09.12
 */
//=============================================================================


#include "common.h"
#include "wh.h"
#include "communication/communication.h"
#include "comm_local.h"
#include "comm_ring_buff.h"

//==============================================================================
/**
 * T[rXԍɑΉq@ڑMAXl擾
 * T[rXԍ include/communication/comm_def.hɂ܂
 * @param   serviceNo T[rXԍ
 * @retval  q@䐔
 */
//==============================================================================

u16 CommLocalGetServiceMaxEntry(u16 serviceNo)
{
    u8 maxBuff[]={
        COMM_MODE_TRADE_NUM_MAX,
        COMM_MODE_BATTLE_SINGLE_NUM_MAX,
        COMM_MODE_BATTLE_DOUBLE_NUM_MAX,
        COMM_MODE_BATTLE_MIX_1ON1_NUM_MAX,
        COMM_MODE_BATTLE_MULTI_NUM_MAX,
        COMM_MODE_BATTLE_MIX_2ON2_NUM_MAX,
        COMM_MODE_NUT_CRASH_NUM_MAX,
        COMM_MODE_RECORD_NUM_MAX,
        COMM_MODE_CONTEST_NUM_MAX,
        COMM_MODE_UNION_NUM_MAX,
        COMM_MODE_UNDERGROUND_NUM_MAX,
        COMM_MODE_POLLOCK4_NUM_MAX,
        COMM_MODE_POLLOCK16_NUM_MAX,
        COMM_MODE_PICTURE_NUM_MAX,
        COMM_MODE_POKETCH_NUM_MAX,
    };
    GF_ASSERT_RETURN(serviceNo < sizeof(maxBuff), COMM_MODE_TRADE_NUM_MAX);
    return maxBuff[serviceNo];
}


//==============================================================================
/**
 * T[rXԍɑΉq@ڑMAXl擾
 * T[rXԍ include/communication/comm_def.hɂ܂
 * @param   serviceNo T[rXԍ
 * @retval  q@䐔
 */
//==============================================================================

u16 CommLocalGetServiceMinEntry(u16 serviceNo)
{
    u8 minBuff[]={
        COMM_MODE_TRADE_NUM_MIN,
        COMM_MODE_BATTLE_SINGLE_NUM_MIN,
        COMM_MODE_BATTLE_DOUBLE_NUM_MIN,
        COMM_MODE_BATTLE_MIX_1ON1_NUM_MIN,
        COMM_MODE_BATTLE_MULTI_NUM_MIN,
        COMM_MODE_BATTLE_MIX_2ON2_NUM_MIN,
        COMM_MODE_NUT_CRASH_NUM_MIN,
        COMM_MODE_RECORD_NUM_MIN,
        COMM_MODE_CONTEST_NUM_MIN,
        COMM_MODE_UNION_NUM_MIN,
        COMM_MODE_UNDERGROUND_NUM_MIN,
        COMM_MODE_POLLOCK4_NUM_MIN,
        COMM_MODE_POLLOCK16_NUM_MIN,
        COMM_MODE_PICTURE_NUM_MIN,
        COMM_MODE_POKETCH_NUM_MIN,
    };
    GF_ASSERT_RETURN(serviceNo < sizeof(minBuff), COMM_MODE_TRADE_NUM_MIN);
    return minBuff[serviceNo];
}

