//=============================================================================
/**
 * @file	comm_message.c
 * @brief	ʐMp bZ[WȒPɈ߂̃NX
 * @author	k.ohno
 * @date    2006.02.05
 */
//=============================================================================


//---------------------------------------------------------
// include 
//---------------------------------------------------------
#include "common.h"
#include "communication/comm_message.h"
#include "system/window.h"      //TalkWinGraphicSet
#include "system/wordset.h"				//WORDSET_ExpandStr
#include "system/fontproc.h"  // FONT_TALK
#include "system/arc_util.h"

#include "msgdata/msg_communication.h"
#include "msgdata/msg.naix"

extern u8 MsgSpeedGet(void);
extern u8 TalkWinNumGet(void);

//---------------------------------------------------------
// typedef
//---------------------------------------------------------
typedef struct _COMM_MESSAGE{
    STRBUF* pStrBuf;
    STRBUF* pExpStrBuf;
    GF_BGL_BMPWIN win;		// BMPEBhE[N

    GF_BGL_INI* bgl;
    PTRCommMsgCallback pCallBackFunc;
    TCB_PTR pWinTask;
    MSGDATA_MANAGER* msg_man;
    WORDSET* pWordSet;
    int msgManagerNo;
    int msgIndex;
    int heapID;
    int speed;
    int type;
    int callbackNum;
    BOOL bTalkMenuDisp;
    BOOL bExpand;
};

#define _MSG_BUF_SIZE   (120)
#define _TALK_WINDOW_PRI (100)


#define _TALK_TARGET_INDEX_WORK (0)  ///< bf[^@bID̈ʒu
#define _TALK_MY_INDEX_WORK     (1)  ///< bf[^@bĂID̈ʒu
#define _UGITEM_INDEX_WORK      (2)   ///< ACe
#define _UGTRAP_INDEX_WORK      (3)   ///< trap
#define _SECRET_QUESTION_WORK   (5)  ///< 閧̎
#define _SECRET_ANSWER_WORK   (5)  ///< 閧̓
#define _UNDER_GOODS_WORK   (2)    /// ObY

static void _talkWindowEnd(COMM_MESSAGE* pComm, BOOL bClear);

///Ij[̃Xgx[X
static const BMPLIST_HEADER MenuListHeader = {
    NULL,			// \f[^|C^
    NULL,					// J[\ړƂ̃R[obN֐
    NULL,					// \Ƃ̃R[obN֐
    NULL,					// 
    0,	// Xgڐ
    0,	// \ő區ڐ
    0,						// x\wW
    8,						// ڕ\wW
    0,						// J[\\wW
    0,						// \xW
    FBMP_COL_BLACK,			// F
    FBMP_COL_WHITE,			// wiF
    FBMP_COL_BLK_SDW,		// eF
    0,						// Ԋuw
    16,						// Ԋux
    BMPLIST_LRKEY_SKIP,		// y[WXLbv^Cv
    FONT_SYSTEM,				// w
    0,						// afJ[\(allow)\tO(0:ON,1:OFF)
    NULL,                   // [N
};

const BMPLIST_HEADER* CommMsgGetNormalBmpListHeader(void)
{
    return &MenuListHeader;
}

//---------------------------------------------------------
// function
//---------------------------------------------------------

//--------------------------------------------------------------
/**
 * @brief   
 * @param   msgManagerNo bZ[Wf[^ԍ
 * @param   heapID gpHEAP
 * @param   GF_BGL_INI* bgl  bgl|C^
 * @param   speed
 * @param   type
 * @retval  COMM_MESSAGE|C^
 */
//--------------------------------------------------------------

COMM_MESSAGE* CommMsgInitialize(int msgManagerNo,int heapID, GF_BGL_INI* bgl,int speed, int type)
{
    COMM_MESSAGE* pComm = sys_AllocMemory( heapID,sizeof(COMM_MESSAGE));

//    MSG_PrintInit();

    pComm->pStrBuf = STRBUF_Create( _MSG_BUF_SIZE, heapID );
    pComm->pExpStrBuf = STRBUF_Create( _MSG_BUF_SIZE, heapID );
    pComm->pWordSet = WORDSET_Create(heapID);

	// bZ[W}l[W쐬
    pComm->msgManagerNo = msgManagerNo;
	pComm->msg_man = MSGMAN_Create(
        MSGMAN_TYPE_DIRECT, ARC_MSG, msgManagerNo, heapID );
    pComm->heapID = heapID;
    pComm->bgl = bgl;
//    pComm->win = win;
    GF_BGL_BmpWinInit( &pComm->win );		// BMPEBhE[N
    pComm->bTalkMenuDisp = FALSE;
    pComm->bExpand = FALSE;
    pComm->pWinTask = NULL;
    pComm->speed = speed;
    pComm->type = type;
    
    return pComm;
}

//--------------------------------------------------------------
/**
 * @brief   J
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------

void CommMsgFinalize(COMM_MESSAGE* pComm)
{
    STRBUF_Delete(pComm->pStrBuf);
    STRBUF_Delete(pComm->pExpStrBuf);
    WORDSET_Delete(pComm->pWordSet);
	MSGMAN_Delete(pComm->msg_man);
    sys_FreeMemoryEz(pComm);
}

//--------------------------------------------------------------
/**
 * @brief   MSGMANAGERύX
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------

void CommMsgChangeMSGMAN(COMM_MESSAGE* pComm, int msgManagerNo)
{
    if(pComm->msgManagerNo != msgManagerNo){
        pComm->msgManagerNo = msgManagerNo;
        MSGMAN_Delete(pComm->msg_man);
        pComm->msg_man = MSGMAN_Create(
            MSGMAN_TYPE_DIRECT, ARC_MSG, msgManagerNo, pComm->heapID );
    }
}

//--------------------------------------------------------------
/**
 * @brief   bglύX
 * @param   void
 * @retval  MSGDATA_MANAGER*
 */
//--------------------------------------------------------------

void CommMsgSetBgl(COMM_MESSAGE* pComm,GF_BGL_INI* bgl)
{
    pComm->bgl = bgl;
}



//--------------------------------------------------------------
/**
 * @brief   bZ[W}l[W[𓾂
 * @param   void
 * @retval  MSGDATA_MANAGER*
 */
//--------------------------------------------------------------

MSGDATA_MANAGER* CommMsgGetMsgManager(COMM_MESSAGE* pComm)
{
    return pComm->msg_man;
}

//--------------------------------------------------------------
/**
 * @brief   bEChE\
 * @param   tcb			TCBւ̃|C^
 * @param   pTalk		b\̂̃|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _talkWindowFunc(TCB_PTR tcb, void* work)
{
    COMM_MESSAGE* pComm = work;
    
    if( GF_MSG_PrintEndCheck( pComm->msgIndex ) == 0 ){
        if( sys.trg & PAD_BUTTON_DECIDE ){
            CommMsgTalkWindowEnd(pComm);
        }
    }
}

//--------------------------------------------------------------
/**
 * @brief   bobt@ɓꂻ̃obt@RETURN
 * @param   pComm  COMM_MESSAGE
 * @param   msgNo  bԍ
 * @retval  none
 */
//--------------------------------------------------------------

static STRBUF* _expandStrBuf(COMM_MESSAGE* pComm)
{
    STRBUF* pStr = pComm->pStrBuf;

    if(pComm->bExpand){
        WORDSET_ExpandStr( pComm->pWordSet, pComm->pExpStrBuf, pComm->pStrBuf );
        pStr = pComm->pExpStrBuf;
        pComm->bExpand = FALSE;
    }
    return pStr;
}

//--------------------------------------------------------------
/**
 * @brief   bEChE\
 * @param   pComm  COMM_MESSAGE|C^
 * @param   bTask  ^XNŏIǗꍇTRUE
 * @param   pEndCallBack IɌĂԃR[obN
 * @retval  EChECfbNX
 */
//--------------------------------------------------------------

static int _talkStart(COMM_MESSAGE* pComm, BOOL bTask, PTRCommMsgCallback pEndCallBack, int callbackNum)
{
    STRBUF* pStr;

    _talkWindowEnd(pComm, FALSE);
    //BMPEBhE
    if(!GF_BGL_BmpWinAddCheck(&pComm->win)){
        GF_BGL_BmpWinAdd(pComm->bgl, &pComm->win,
                         GF_BGL_FRAME3_M,
                         COMM_MSG_WIN_PX, COMM_MSG_WIN_PY,
                         COMM_MSG_WIN_SX, COMM_MSG_WIN_SY,
                         COMM_MESFONT_PAL, COMM_MSG_WIN_CGX);
    }
	TalkWinGraphicSet(
        pComm->bgl, GF_BGL_BmpWinGet_Frame(&pComm->win), COMM_TALK_WIN_CGX_NUM,
        COMM_MESFRAME_PAL, pComm->type, pComm->heapID );
    GF_BGL_BmpWinDataFill(&pComm->win, 15 );
    BmpTalkWinWrite(&pComm->win, WINDOW_TRANS_OFF,COMM_TALK_WIN_CGX_NUM, COMM_MESFRAME_PAL );

  //  GF_BGL_BmpWinOn(&pComm->win);
    if(bTask){
        pComm->pWinTask = TCB_Add(_talkWindowFunc, pComm, _TALK_WINDOW_PRI);
    }
    pComm->bTalkMenuDisp = TRUE;

    pStr = _expandStrBuf(pComm);

    pComm->msgIndex = GF_STR_PrintSimple(&pComm->win, FONT_TALK,
                                         pStr, 0, 0, pComm->speed, NULL);
    pComm->pCallBackFunc = pEndCallBack;
    pComm->callbackNum = callbackNum;
    return pComm->msgIndex;
}


//--------------------------------------------------------------
/**
 * @brief   bobt@ɓꂻ̃obt@RETURN
 * @param   pComm  COMM_MESSAGE
 * @param   msgNo  bԍ
 * @retval  none
 */
//--------------------------------------------------------------

STRBUF* CommMsgGetExpandStrBuf(COMM_MESSAGE* pComm, int msgNo)
{
    MSGMAN_GetString( pComm->msg_man, msgNo, pComm->pStrBuf );
    return _expandStrBuf(pComm);
}

//--------------------------------------------------------------
/**
 * @brief   bEChE\
 * @param   msgNo  bԍ
 * @param   bgl  GF_BGL_INI* 
 * @param   bTask  L[^XNɔCĎI邩ǂ
 * @param   pEndCallBack  IɃR[obNĂԂǂ
 * @retval  none
 */
//--------------------------------------------------------------
int CommMsgTalkWindowStart(COMM_MESSAGE* pComm, int msgNo, BOOL bTask, PTRCommMsgCallback pEndCallBack)
{
    MSGMAN_GetString( pComm->msg_man, msgNo, pComm->pStrBuf );
    return _talkStart(pComm, bTask,  pEndCallBack, 0);
}

//--------------------------------------------------------------
/**
 * @brief   bEChEꊇ\
 * @param   msgNo  bԍ
 * @param   bgl  GF_BGL_INI* 
 * @param   bTask  L[^XNɔCĎI邩ǂ
 * @param   pEndCallBack  IɃR[obNĂԂǂ
 * @retval  none
 */
//--------------------------------------------------------------
int CommMsgTalkWindowAllWrite(COMM_MESSAGE* pComm, int msgNo, BOOL bTask, PTRCommMsgCallback pEndCallBack)
{
    int ret,speed;
    speed = pComm->speed;
    pComm->speed = MSG_ALLPUT;
    ret = CommMsgTalkWindowStart(pComm, msgNo,  bTask, pEndCallBack);
    pComm->speed = speed;
    return ret;
}

//--------------------------------------------------------------
/**
 * @brief   bEChE\ R[obNɓn
 * @param   msgNo  bԍ
 * @param   bgl  GF_BGL_INI* 
 * @param   bTask  L[^XNɔCĎI邩ǂ
 * @param   pEndCallBack  IɃR[obNĂԂǂ
 * @param   callbackNum R[obNɓn
 * @retval  none
 */
//--------------------------------------------------------------
int CommMsgTalkWindowStartSendNum(COMM_MESSAGE* pComm, int msgNo, BOOL bTask, PTRCommMsgCallback pEndCallBack,
                           int callbackNum)
{
    MSGMAN_GetString( pComm->msg_man, msgNo, pComm->pStrBuf );
    return _talkStart(pComm, bTask,  pEndCallBack, callbackNum);
}

//--------------------------------------------------------------
/**
 * @brief   bEChE\ STRBUFF󂯎^
 * @param   pStrBuf  XgOobt@
 * @param   heapID   HEAPID
 * @retval  EChECfbNX
 */
//--------------------------------------------------------------

//int CommMsgTalkWindowStartBuff(COMM_MESSAGE* pComm, STRBUF* pStrBuf, BOOL bTask,  PTRCommMsgCallback pEndCallBack)
//{
//    STRBUF_Copy(pComm->pStrBuf,pStrBuf);
//    return _talkStart(pComm, bTask, pEndCallBack, 0);
//}

//--------------------------------------------------------------
/**
 * @brief   bEChE  p
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------

static void _talkWindowEnd(COMM_MESSAGE* pComm, BOOL bClear)
{
    if(pComm->bTalkMenuDisp){
        pComm->bTalkMenuDisp = FALSE;
        if(TRUE == bClear){
            BmpTalkWinClear(&pComm->win, WINDOW_TRANS_ON );
            GF_BGL_BmpWinOff(&pComm->win);
        }
        else{
            BmpTalkWinClear(&pComm->win, WINDOW_TRANS_OFF );
        }
        GF_BGL_BmpWinDel(&pComm->win);
        if(pComm->pWinTask != NULL){
            TCB_Delete(pComm->pWinTask);
            pComm->pWinTask = NULL;
        }
        if(pComm->pCallBackFunc){
            PTRCommMsgCallback func = pComm->pCallBackFunc;
            func(pComm->callbackNum);
        }
    }
}

//--------------------------------------------------------------
/**
 * @brief   bEChE
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------

void CommMsgTalkWindowEnd(COMM_MESSAGE* pComm)
{
    _talkWindowEnd(pComm, TRUE);
}


void CommMsgRegisterMyName(COMM_MESSAGE* pComm, MYSTATUS* pMy)
{
    WORDSET_RegisterPlayerName( pComm->pWordSet, _TALK_MY_INDEX_WORK, pMy);
    pComm->bExpand = TRUE;
}

void CommMsgRegisterTargetName(COMM_MESSAGE* pComm,MYSTATUS* pTarget)
{
    WORDSET_RegisterPlayerName( pComm->pWordSet, _TALK_TARGET_INDEX_WORK, pTarget);
    pComm->bExpand = TRUE;
}

void CommMsgRegisterUGItemName(COMM_MESSAGE* pComm,int type)
{
    WORDSET_RegisterUGItemName(pComm->pWordSet, _UGITEM_INDEX_WORK, type );
    pComm->bExpand = TRUE;
}

void CommMsgRegisterUGTrapName(COMM_MESSAGE* pComm,int type)
{
    WORDSET_RegisterUGTrapName(pComm->pWordSet, _UGTRAP_INDEX_WORK, type );
    pComm->bExpand = TRUE;
}

void CommMsgRegisterSecretQuestionName(COMM_MESSAGE* pComm,int type)
{
    WORDSET_RegisterSecretQuestion(pComm->pWordSet, _SECRET_QUESTION_WORK, type );
    pComm->bExpand = TRUE;
}

void CommMsgRegisterSecretAnswerName(COMM_MESSAGE* pComm,int type)
{
    WORDSET_RegisterSecretAnswer(pComm->pWordSet, _SECRET_ANSWER_WORK, type );
    pComm->bExpand = TRUE;
}

void CommMsgRegisterUGGoodsName(COMM_MESSAGE* pComm,int type)
{
    WORDSET_RegisterUGGoodsName(pComm->pWordSet, _UNDER_GOODS_WORK, type );
    pComm->bExpand = TRUE;
}

void CommMsgRegisterNumber1Index(COMM_MESSAGE* pComm,int index,int num)
{
    WORDSET_RegisterNumber(pComm->pWordSet, index, num, 1,
                           NUMBER_DISPTYPE_ZERO, NUMBER_CODETYPE_DEFAULT);
    pComm->bExpand = TRUE;
}

void CommMsgRegisterNumber2(COMM_MESSAGE* pComm,int num)
{
    WORDSET_RegisterNumber(pComm->pWordSet, 6, num, 2,
                           NUMBER_DISPTYPE_ZERO, NUMBER_CODETYPE_DEFAULT);
    pComm->bExpand = TRUE;
}

void CommMsgRegisterNumber2Index(COMM_MESSAGE* pComm,int index,int num)
{
    WORDSET_RegisterNumber(pComm->pWordSet, index, num, 2,
                           NUMBER_DISPTYPE_ZERO, NUMBER_CODETYPE_DEFAULT);
    pComm->bExpand = TRUE;
}

void CommMsgRegisterNumber5(COMM_MESSAGE* pComm,int num)
{
    WORDSET_RegisterNumber(pComm->pWordSet, 6, num, 5,
                           NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT);
    pComm->bExpand = TRUE;
}

void CommMsgRegisterUGItemNameIndex(COMM_MESSAGE* pComm,int index,int type)
{
    WORDSET_RegisterUGItemName(pComm->pWordSet, index, type );
    pComm->bExpand = TRUE;
}

void CommMsgRegisterUGTrapNameIndex(COMM_MESSAGE* pComm,int index,int type)
{
    WORDSET_RegisterUGTrapName(pComm->pWordSet, index, type );
    pComm->bExpand = TRUE;
}

void CommMsgRegisterUGGoodsNameIndex(COMM_MESSAGE* pComm,int index,int type)
{
    WORDSET_RegisterUGGoodsName(pComm->pWordSet, index, type );
    pComm->bExpand = TRUE;
}


//--------------------------------------------------------------
/**
 * @brief   ʐMG[pEChEo
 *          ǂŌĂяoĂȂ悤ɐ݌v鎖
 * @param   heapID    [mۂHEAPID
 * @param   bgl       GF_BGL_INI
 * @retval  COMM_MESSAGE[N|C^
 */
//--------------------------------------------------------------

COMM_MESSAGE* CommErrorMessageStart(int heapID, GF_BGL_INI* bgl)
{
    COMM_MESSAGE* pComm = CommMsgInitialize(NARC_msg_communication_dat, heapID,
                                            bgl, MsgSpeedGet(), TalkWinNumGet());  // bZ[WXs[h{gƂɉ @@OO
    CommMsgTalkWindowStart(pComm, Msg_CommError, FALSE, NULL);
    return pComm;
}


//--------------------------------------------------------------
/**
 * @brief   ʐMG[pEChE
 *          ǂŌĂяoĂȂ悤ɐ݌v鎖
 * @param   COMM_MESSAGE[N|C^
 * @retval  none
 */
//--------------------------------------------------------------

void CommErrorMessageEnd(COMM_MESSAGE* pComm)
{
    CommMsgTalkWindowEnd(pComm);
    CommMsgFinalize(pComm);
}

