//=============================================================================
/**
 * @file	comm_queue.h
 * @bfief	iMjL[̎dg݂Ǘ֐
 * @author	katsumi ohno
 * @date	06/01/29
 */
//=============================================================================

#ifndef __COMM_QUEUE_H__
#define __COMM_QUEUE_H__

#include "comm_ring_buff.h"

typedef struct _SEND_QUEUE SEND_QUEUE;

// L[\
struct _SEND_QUEUE{
    u8* pData;     ///< f[^AhX
    SEND_QUEUE* prev;      //
    SEND_QUEUE* next;
    u16 size;       ///< TCY
    u8 command;    ///< R}h
    u8 bHeadSet:1;  ///< wb_[𑗐MꍇP ܂̏ꍇO
    u8 bRing:1;     ///< Oobt@gp̏ꍇP
} ;

typedef struct{
    u8* pData;
    int size;
} SEND_BUFF_DATA;



typedef struct{
    SEND_QUEUE* pTop;     // ML[̏
    SEND_QUEUE* pLast;    // ML[̍Ō
} SEND_TERMINATOR;



typedef struct{
    SEND_TERMINATOR fast;     // 鑗ML[
    SEND_TERMINATOR stock;    // ő΂L[
    SEND_QUEUE* pNow;   // ĂŒ̃L[
    RingBuffWork* pSendRing;  // Oobt@[N|C^
    void* heapTop;   // L[HEAP
    int max;         // L[̐
} SEND_QUEUE_MANAGER;


// L[ɉĂ邩ǂmF
extern BOOL CommQueueIsEmpty(SEND_QUEUE_MANAGER* pQueueMgr);
// L[MANAGEȐ
extern void CommQueueManagerInitialize(SEND_QUEUE_MANAGER* pQueueMgr, int queueMax, RingBuffWork* pSendRing);
// L[̒gZbg
extern void CommQueueManagerReset(SEND_QUEUE_MANAGER* pQueueMgr);
// L[MANAGEȐI
extern void CommQueueManagerFinalize(SEND_QUEUE_MANAGER* pQueueMgr);
// L[Ƀf[^
extern BOOL CommQueuePut(SEND_QUEUE_MANAGER* pQueueMgr,int command, u8* pDataArea, int size, BOOL bFast, BOOL bSave);
// L[f[^zグ
extern BOOL CommQueueGetData(SEND_QUEUE_MANAGER* pQueueMgr, SEND_BUFF_DATA *pSendBuff, BOOL bNextPlus);
// R}h邩ǂׂ
extern BOOL CommQueueIsCommand(SEND_QUEUE_MANAGER* pQueueMgr, int command);

#if PM_DEBUG
extern void CommQueueDebugTest(void);
#endif

#endif// __COMM_QUEUE_H__

