//=============================================================================
/**
 * @file	comm_ring_buff.c
 * @bfief	Oobt@̎dg݂Ǘ֐
 * @author	katsumi ohno
 * @date	05/09/16
 */
//=============================================================================

#include "common.h"
#include "communication/communication.h"
#include "comm_local.h"
#include "comm_ring_buff.h"



static int _ringPos(RingBuffWork* pRing,int i);

//==============================================================================
/**
 * Oobt@Ǘ\̏
 * @param   pRing        Oobt@Ǘ|C^
 * @param   pDataArea    Oobt@[
 * @param   size         Oobt@[TCY
 * @retval  none
 */
//==============================================================================
void CommRingInitialize(RingBuffWork* pRing, u8* pDataArea, int size)
{
    pRing->pWork = pDataArea;
    pRing->size = size;
    pRing->startPos = 0;
    pRing->endPos = 0;
    pRing->backupStartPos = 0;
}

//==============================================================================
/**
 * Oobt@ɏ
 * @param   pRing        Oobt@Ǘ|C^
 * @param   pDataArea    ރf[^
 * @param   size         ݃TCY
 * @retval  none
 */
//==============================================================================
void CommRingPuts(RingBuffWork* pRing, u8* pDataArea, int size)
{
    int i,j;

    // ASSERTɈƂƂ
    // xĂ̂ɁAʐM͖synĉ
    // XgbNobt@܂łӂƁAŎ~܂܂B
    // ʐM̃obt@𑝂₷Ȁ̕𕪒f邩AΏKvłB
    // ŏIIɂ͂̃G[ƒʐMؒf܂B
    GF_ASSERT_RETURN((CommRingDataRestSize(pRing) > size) && "ݗeʃI[o[",);
    j = 0;
    for(i = pRing->endPos; i < pRing->endPos + size; i++,j++){
        pRing->pWork[_ringPos( pRing, i )] = pDataArea[j];
    }
    
    pRing->endPos = _ringPos( pRing, i );
//    OHNO_PRINT("------ obt@ɓꂽ %d %d \n", pRing->startPos, pRing->endPos);
}

//==============================================================================
/**
 * Oobt@f[^𓾂
 * @param   pRing        Oobt@Ǘ|C^
 * @param   pDataArea    ǂݍ݃obt@
 * @param   size         ǂݍ݃obt@TCY
 * @retval  ۂɓǂݍ񂾃f[^
 */
//==============================================================================
int CommRingGets(RingBuffWork* pRing, u8* pDataArea, int size)
{
    int i,j;

    i = CommRingChecks(pRing, pDataArea, size);
    pRing->startPos = _ringPos( pRing, pRing->startPos + i);
//    OHNO_PRINT("++++++ obt@炾 %d %d  %d byte\n", pRing->startPos, pRing->endPos, i);
    return i;
}

//==============================================================================
/**
 * Oobt@1bytef[^𓾂
 * @param   pRing        Oobt@Ǘ|C^
 * @retval  1bytẽf[^ OɃf[^ȂƂ0(s)
 */
//==============================================================================
u8 CommRingGetByte(RingBuffWork* pRing)
{
    u8 byte;

    CommRingGets(pRing, &byte, 1);
    return byte;
}

//==============================================================================
/**
 * Oobt@̃f[^  ǂݍނňʒui߂Ȃ
 * @param   pRing        Oobt@Ǘ|C^
 * @param   pDataArea    ǂݍ݃obt@
 * @param   size         ǂݍ݃obt@TCY
 * @retval  ۂɓǂݍ񂾃f[^
 */
//==============================================================================
int CommRingChecks(RingBuffWork* pRing, u8* pDataArea, int size)
{
    int i,j;

    j = 0;
    for(i = pRing->startPos; i < pRing->startPos + size; i++,j++){
        if(pRing->endPos == _ringPos( pRing,i )){
            return j;
        }
        pDataArea[j] = pRing->pWork[_ringPos( pRing,i )];
    }
    return j;
}

//==============================================================================
/**
 * Oobt@̃f[^Ă邩
 * @param   pRing        Oobt@Ǘ|C^
 * @retval  f[^TCY
 */
//==============================================================================
int CommRingDataSize(RingBuffWork* pRing)
{
    if(pRing->startPos > pRing->endPos){
        return (pRing->size + pRing->endPos - pRing->startPos);
    }
    return (pRing->endPos - pRing->startPos);
}

//==============================================================================
/**
 * Oobt@̃f[^ǂ̂炢܂Ă邩
 * @param   pRing        Oobt@Ǘ|C^
 * @retval  ۂɓǂݍ񂾃f[^
 */
//==============================================================================
int CommRingDataRestSize(RingBuffWork* pRing)
{
    return (pRing->size - CommRingDataSize(pRing));
}

//==============================================================================
/**
 * JE^[obNAbv
 * @param   pRing        Oobt@Ǘ|C^
 * @retval  nono
 */
//==============================================================================
void CommRingStartPush(RingBuffWork* pRing)
{
    pRing->backupStartPos = pRing->startPos;
}

//==============================================================================
/**
 * JE^[obNAbv
 * @param   pRing        Oobt@Ǘ|C^
 * @retval  nono
 */
//==============================================================================
void CommRingStartPop(RingBuffWork* pRing)
{
    pRing->startPos = pRing->backupStartPos;
}

//==============================================================================
/**
 * ringTCY̏ꏊ
 * @param   pRing        Oobt@Ǘ|C^
 * @retval  
 */
//==============================================================================
int _ringPos(RingBuffWork* pRing,int i)
{
    return i % pRing->size;

}


