//=============================================================================
/**
 * @file	comm_state.c
 * @brief	ʐMԂǗT[rX  ʐM̏ʂɂ
 *          XbĥЂƂƂēA̒ʐMԂ⑼̋@
 *          JnIǗ
 *          tB[hǗȂ񂱂Ɉz...2006.01.12
 * @author	k.ohno
 * @date    2006.01.12
 */
//=============================================================================

#include "communication/comm_state.h"

#include "common.h"
#include "communication/communication.h"
#include "comm_local.h"
#include "system/gamedata.h"
#include "system/pm_str.h"

//==============================================================================
//	^錾
//==============================================================================
// R[obN֐̏
typedef void (*PTRStateFunc)(void);

//==============================================================================
// [N
//==============================================================================

typedef struct{
    MATHRandContext32 sRand; ///< eq@lSVG[VpL[
    PTRStateFunc state;
    TCB_PTR pTcb;
    MYSTATUS* pMyStatus;
    u16 reConnectTime;  // ĐڑɎgp^C}[
    u16 timer;
#ifdef PM_DEBUG		// Debug ROM
    u16 debugTimer;
#endif
    u8 limitNum;      // tꍇLIMIT
    u8 negotiation;   // ڑF
    u8 connectIndex;   // q@ڑe@indexԍ
    u8 serviceNo;      // ʐMT[rXԍ
    u8 regulationNo;
#ifdef PM_DEBUG		// Debug ROM
    u8 soloDebugNo;
    u8 bDebugStart;
#endif
    u8 bFirstParent;
} _COMM_STATE_WORK;

static _COMM_STATE_WORK* _pCommState = NULL;  ///<@[N\̂̃|C^

//==============================================================================
// `
//==============================================================================

#define _HEAPSIZE_BATTLE          (0xA000)  // og@̈
#define _HEAPSIZE_UNDERGROUND     (0xD000)  // n̈
#define _HEAPSIZE_UNION           (0xA000)  // jI[̈
#define _HEAPSIZE_POKETCH          (0x8000)  // ۂ@̈

#define _PACKETSIZE_BATTLE         (1280)  // og@̈
#define _PACKETSIZE_UNDERGROUND     (200)  // n̈
#define _PACKETSIZE_UNION          (1280)  // jI[̈
#define _PACKETSIZE_POKETCH          (32)  // ۂ̈



#define _START_TIME (50)     // Jn
#define _CHILD_P_SEARCH_TIME (12) ///q@ƂĐeT
#define _PARENT_WAIT_TIME (40) ///eƂĂ̂т҂
#define _FINALIZE_TIME (2)
#define _EXIT_SENDING_TIME (5)
#define _PARENT_END_TIME (2)
#define _SEND_NAME_TIME (10)
#define _PARENTSCAN_PA (3)  // e@ƂČm1/3

#define _RETRY_COUNT_UNION  (4)  // jI[Ŏq@ڑɗv

#define _TCB_COMMCHECK_PRT   (10)    ///< tB[hʐM̊Ď[`PRI


#define _NEGOTIATION_OK (1)      // ڑmF
#define _NEGOTIATION_CHECK (0)   // ڑmF
#define _NEGOTIATION_NG (2)     // ڑs



//==============================================================================
// static錾
//==============================================================================

// Xe[g̏

static void _commStateInitialize(MYSTATUS* pMyStatus);  // 
static void _commCheckFunc(TCB_PTR tcb, void* work);  // Xe[gsĂ^XN
static void _changeStateDebug(PTRStateFunc state, int time, int line);  // Xe[gύX
static void _changeState(PTRStateFunc state, int time);  // Xe[gύX

#if 0
#define   _CHANGE_STATE(state, time)  _changeStateDebug(state, time, __LINE__)
#else
#define   _CHANGE_STATE(state, time)  _changeState(state, time)
#endif

// n֘AXe[g
static void _underStart(void);           // q@̏ + VXȅ
static void _underChildPInit(void);      // q@̏
static void _underChildFInit(void);
static void _underChildPSearching(void); // q@e@TĂ
static void _underChildForceConnect(void); // q@e@ɋɐڑ
static void _underChildConnecting(void);   // q@e@ɐڑ
static void _underChildConnect(void);    // q@ƂĐڑ
static void _underChildReset(void);
static void _underChildFinalize(void);   // q@ɂȂȂ̂ŏI
static void _underParentFinalize(void);  // e@ɂȂȂ̂ŏI
static void _underParentInit(void);      // e@Ƃď
static void _underParentWait(void);      // e@Ƃđҋ@
static void _underParentConnectInit(void); // ڑ̂ŏ
static void _underParentConnect(void);   // e@ƂĐڑ
static void _stateUnderGroundConnectEnd(void);  // nؒf
static void _underSBReset(void);


// og֘AXe[g
static void _battleParentInit(void);     // 퓬pe@Ƃď
static void _battleParentWaiting(void);  // 퓬pe@Ƃđҋ@
static void _battleParentMoveRoomEnter(void);  // 퓬O̕ɓđҋ@
static void _battleParentMoveRoom(void);  // 퓬O̕ɓđҋ@
static void _battleParentSendName(void);  // ̖O݂ȂɑM
static void _battleParentReTry(void);   // 퓬pe@𒆒f

static void _battleChildInit(void);     // 퓬pq@Ƃď
static void _battleChildBconScanning(void);  // 퓬pq@ƂĐe@I
static void _battleChildConnecting(void);  // ڑ炢
static void _battleChildSendName(void);  // ̖O݂ȂɑM
static void _battleChildWaiting(void);  // _CNgpq@ҋ@
static void _battleChildMoveRoomEnter(void); // 퓬O̕ɓđҋ@
static void _battleChildMoveRoom(void); // 퓬O̕ɓđҋ@
static void _battleChildReTry(void);   // q@𒆒f
static void _battleChildReInit(void);   // q@ċN
static void _battleChildReset(void);
static void _battleChildReConnect(void);
static void _underChildOnline(void);


// UNION[֘AXe[g
static void _unionStart(void);
static void _unionChildSearching(void);
static void _unionChildFinalize(void);
static void _unionParentInit(void);
static void _unionParentWait(void);
static void _unionChildRestart(void);
static void _unionChildNegotiation(void);

static void _unionForceConnectStart(void);
static void _unionForceConnectStart2(void);
static void _unionForceConnect(void);
static void _unionChildConnecting(void);
static void _unionChildConnectSuccess(void);
static void _unionChildConnectFailed(void);
static void _unionChildReset(void);
static void _unionParentConnect(void);


// ̑ʓIȃXe[g
static void _stateNone(void);            // Ȃ
static void _stateConnectError(void);    // ڑG[
static void _stateEnd(void);             // I
static void _stateConnectEnd(void);      // ؒfJn
static void _stateConnectAutoEnd(void);  // ؒfJn

// lSVG[VpmFKEY
static u8 _negotiationMsg[]={"FREAK"};
static u8 _negotiationMsgReturnOK[]={" GAME"};
static u8 _negotiationMsgReturnNG[]={" FULL"};



//==============================================================================
/**
 * ʐMǗXe[g̏
 * @param   MYSTATUS* pMyStatus
 * @retval  none
 */
//==============================================================================

static void _commStateInitialize(MYSTATUS* pMyStatus)
{
    void* pWork;

    if(_pCommState!=NULL){   // łɓ쒆̏ꍇKvȂ
        return;
    }
    CommVRAMDInitialize();
    // 
    _pCommState = (_COMM_STATE_WORK*)sys_AllocMemory(HEAPID_COMMUNICATION, sizeof(_COMM_STATE_WORK));
    _pCommState->state = NULL;   // Ȃ
    _pCommState->timer = _START_TIME;
    _pCommState->pTcb = TCB_Add(_commCheckFunc, NULL, _TCB_COMMCHECK_PRT);
    _pCommState->bFirstParent = TRUE;  // ȅ߂Ă̋N̏ꍇTRUE
    _pCommState->pMyStatus = pMyStatus;
    _pCommState->reConnectTime = 0;
    _pCommState->limitNum = COMM_MODE_UNION_NUM_MIN+1;   // l͍Œłڑ\
    _pCommState->negotiation = _NEGOTIATION_CHECK;
    CommRandSeedInitialize(&_pCommState->sRand);
}


//==============================================================================
/**
 * ʐMǗXe[g̏I
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _stateFinalize(void)
{
    if(_pCommState==NULL){  // łɏIĂ
        return;
    }
    TCB_Delete(_pCommState->pTcb);
    sys_FreeMemoryEz(_pCommState);
    sys_DeleteHeap(HEAPID_COMMUNICATION);
    _pCommState = NULL;
}

//==============================================================================
/**
 * nɂ͂̒ʐM
 * @param   MYSTATUS* pMyStatus
 * @retval  none
 */
//==============================================================================

void CommStateEnterUnderGround(MYSTATUS* pMyStatus)
{
    if(_pCommState!=NULL){ // ȂĂꍇ͏O
        return;
    }
    // ʐMq[v쐬
    sys_CreateHeap( HEAPID_BASE_APP, HEAPID_COMMUNICATION, _HEAPSIZE_UNDERGROUND );
    _commStateInitialize(pMyStatus);
    _pCommState->serviceNo = COMM_MODE_UNDERGROUND;
    _pCommState->regulationNo = 0;
#if PM_DEBUG
    _pCommState->soloDebugNo = SOLO_DEBUG_NO;
#endif
    // nXe[g̑Jڂ̂ߏ
    _CHANGE_STATE(_underStart, _START_TIME);
}

//==============================================================================
/**
 * noꍇ̒ʐM
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommStateExitUnderGround(void)
{
    if(_pCommState==NULL){  // łɏIĂ
        return;
    }
    // ؒfXe[gɈڍs  ɐ؂Ȃ
    _CHANGE_STATE(_stateUnderGroundConnectEnd, 0);
}

//==============================================================================
/**
 * r[RWĊJ
 * @param   MYSTATUS* pMyStatus
 * @retval  none
 */
//==============================================================================

void CommStateUnderRestart(void)
{
    CommSystemReset();   // ܂ł̒ʐMobt@N[ɂ
    // 邮܂킷
    _pCommState->reConnectTime = CommGetCurrentID();
    _CHANGE_STATE(_underChildReset, 0);  // G[ȈꍇRESET
}

//==============================================================================
/**
 * nɂĐڑSTATEȂ̂ǂԂ
 * @param   none
 * @retval  ڑȂTRUE
 */
//==============================================================================

BOOL CommIsUnderGroundConnectingState(void)
{
    int i;
    u32 funcTbl[]={
        (u32)_underChildConnect,
        (u32)_underParentConnect,
        0,
    };
    u32 stateAddr = (u32)_pCommState->state;

    if(_pCommState==NULL){  // łɏIĂ
        return FALSE;
    }
    for(i = 0; funcTbl[i] != 0; i++ ){
        if(stateAddr == funcTbl[i]){
            return TRUE;
        }
    }
    return FALSE;
}

//==============================================================================
/**
 * ʐM؂nɂ͂
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommStateUnderGroundOfflineSecretBase(void)
{
    _CHANGE_STATE(_underSBReset, 0);  // G[ȈꍇRESET
}


void CommStateUnderGroundOnlineSecretBase(void)
{
    CommVRAMDInitialize();
    _CHANGE_STATE(_underChildOnline, 0);  // G[ȈꍇRESET
}

//==============================================================================
/**
 * og̐eƂĂ̒ʐMJn
 * @param   pMyStatus  mystatus
 * @param   serviceNo  ʐMT[rXԍ
 * @param   regulationNo  ʐMT[rXԍ
 * @retval  none
 */
//==============================================================================

#if PM_DEBUG
void CommStateEnterBattleParent(MYSTATUS* pMyStatus, int serviceNo, int regulationNo, int soloDebugNo)
#else
void CommStateEnterBattleParent(MYSTATUS* pMyStatus, int serviceNo, int regulationNo)
#endif
{
    if(CommIsInitialize()){
        return;      // ȂĂꍇ͏O
    }
    // ʐMq[v쐬
    sys_CreateHeap( HEAPID_BASE_APP, HEAPID_COMMUNICATION, _HEAPSIZE_BATTLE );
    _commStateInitialize(pMyStatus);
    _pCommState->serviceNo = serviceNo;
    _pCommState->regulationNo = regulationNo;
#if PM_DEBUG
    _pCommState->soloDebugNo = soloDebugNo;
#endif
    _CHANGE_STATE(_battleParentInit, 0);
}

//==============================================================================
/**
 * og̎qƂĂ̒ʐMJn
 * @param   serviceNo  ʐMT[rXԍ
 * @retval  none
 */
//==============================================================================

#if PM_DEBUG
void CommStateEnterBattleChild(MYSTATUS* pMyStatus, int serviceNo, int regulationNo, int soloDebugNo)
#else
void CommStateEnterBattleChild(MYSTATUS* pMyStatus, int serviceNo, int regulationNo)
#endif
{
    if(CommIsInitialize()){
        return;      // ȂĂꍇ͏O
    }
    // ʐMq[v쐬
    sys_CreateHeap( HEAPID_BASE_APP, HEAPID_COMMUNICATION, _HEAPSIZE_BATTLE );
    _commStateInitialize(pMyStatus);
    _pCommState->serviceNo = serviceNo;
    _pCommState->regulationNo = regulationNo;
#if PM_DEBUG
    _pCommState->soloDebugNo = soloDebugNo;
#endif
    _CHANGE_STATE(_battleChildInit, 0);
}

//==============================================================================
/**
 * og̎qƂĂ̒ʐMJn
 * @param   connectIndex ڑe@Index
 * @retval  none
 */
//==============================================================================

void CommStateConnectBattleChild(int connectIndex)
{
    _pCommState->connectIndex = connectIndex;
    _CHANGE_STATE(_battleChildConnecting, 0);
}

//==============================================================================
/**
 * og̎qƂĂ̒ʐMċN
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommStateRebootBattleChild(void)
{
    _CHANGE_STATE(_battleChildReTry, 0);
}

//==============================================================================
/**
 * og̒ʐMI葱
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommStateExitBattle(void)
{
    if(_pCommState==NULL){
        return;      // łɏIĂꍇ͏O
    }
    _CHANGE_STATE(_stateConnectAutoEnd, _EXIT_SENDING_TIME);
}

//==============================================================================
/**
 * ogڑSTATEȂ̂ǂԂ
 * @param   none
 * @retval  ڑTRUE
 */
//==============================================================================

BOOL CommIsBattleConnectingState(void)
{
    int i;
    u32 funcTbl[]={
        (u32)_battleParentWaiting,
        (u32)_battleChildWaiting,
        0,
    };
    u32 stateAddr = (u32)_pCommState->state;

    if(_pCommState==NULL){  // łɏIĂ
        return FALSE;
    }
    for(i = 0; funcTbl[i] != 0; i++ ){
        if(stateAddr == funcTbl[i]){
            return TRUE;
        }
    }
    return FALSE;
}

//==============================================================================
/**
 * r[RWJn
 * @param   MYSTATUS* pMyStatus
 * @retval  none
 */
//==============================================================================

void CommStateUnionBconCollection(MYSTATUS* pMyStatus)
{
    if(_pCommState!=NULL){ // ȂĂꍇ͏O
        return;
    }
    // ʐMq[v쐬
    sys_CreateHeap( HEAPID_BASE_APP, HEAPID_COMMUNICATION, _HEAPSIZE_UNION );
    _commStateInitialize(pMyStatus);
    _pCommState->serviceNo = COMM_MODE_UNION;
    _pCommState->regulationNo = 0;
#if PM_DEBUG
    _pCommState->soloDebugNo = SOLO_DEBUG_NO;
#endif
    // nXe[g̑Jڂ̂ߏ
    _CHANGE_STATE(_unionStart, 0);
}


//==============================================================================
/**
 * bJn̂Ŏq@ڑ
 * @param   ڑe@index
 * @retval  none
 */
//==============================================================================

void CommStateUnionConnectStart(int index)
{
    _pCommState->connectIndex = index;
    _pCommState->reConnectTime = _RETRY_COUNT_UNION;
    _CHANGE_STATE(_unionForceConnectStart, 0);
}

//==============================================================================
/**
 * q@ڑɐǂ
 * @param   none
 * @retval  ڑO@P@s|P
 */
//==============================================================================

int CommStateIsUnionConnectSuccess(void)
{
    u32 stateAddr;

    if(_pCommState==NULL){  // łɏIĂ
        return -1;
    }
    stateAddr = (u32)_pCommState->state;
    if(stateAddr == (u32)_unionChildConnectSuccess){
        return 1;
    }
    if(stateAddr == (u32)_unionChildConnectFailed){
        return -1;
    }
    return 0;
}

//==============================================================================
/**
 * e@ڑɐǂ
 * @param   none
 * @retval  ڑȂTRUE
 */
//==============================================================================

BOOL CommStateIsUnionParentConnectSuccess(void)
{
    u32 stateAddr;

    if(_pCommState==NULL){  // łɏIĂ ͏܂
        return FALSE;
    }
    stateAddr = (u32)_pCommState->state;
    if(stateAddr == (u32)_unionParentConnect){
        return TRUE;
    }
    return FALSE;
}

//==============================================================================
/**
 * r[RWĊJ
 * @param   MYSTATUS* pMyStatus
 * @retval  none
 */
//==============================================================================

void CommStateUnionBconCollectionRestart(void)
{
    //
    OHNO_PRINT("r[RWĊJ\n");
    _CHANGE_STATE(_unionChildFinalize, 0);
}

//==============================================================================
/**
 * UNIONROOMoꍇ̒ʐM
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommStateExitUnion(void)
{
    if(_pCommState==NULL){  // łɏIĂ
        return;
    }
    OHNO_PRINT("ؒf\n");
    // ؒfXe[gɈڍs  ɐ؂Ȃ
    _CHANGE_STATE(_stateConnectEnd, _EXIT_SENDING_TIME);
}

//==============================================================================
/**
 * ʐMǗXe[g̏
 * @param
 * @retval  none
 */
//==============================================================================

void _commCheckFunc(TCB_PTR tcb, void* work)
{

    if(_pCommState==NULL){
        TCB_Delete(tcb);
    }
    else{
        if(_pCommState->state != NULL){
            PTRStateFunc state = _pCommState->state;
            state();
        }
    }
}

//==============================================================================
/**
 * ʐMǗXe[g̕ύX
 * @param   state  ςXe[g̊֐
 * @param   time   Xe[gێ
 * @retval  none
 */
//==============================================================================

static void _changeState(PTRStateFunc state, int time)
{
    _pCommState->state = state;
    _pCommState->timer = time;
//    state();  // ŏ̈ɍŝ͍ċAĂ܂̂ŒӂKv
}

//==============================================================================
/**
 * ʐMǗXe[g̕ύX
 * @param   state  ςXe[g̊֐
 * @param   time   Xe[gێ
 * @retval  none
 */
//==============================================================================
#if PM_DEBUG
static void _changeStateDebug(PTRStateFunc state, int time, int line)
{
    OHNO_PRINT("CS comm_state: %d\n",line);
    _changeState(state, time);
}
#endif

//==============================================================================
/**
 * nX^[g
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underStart(void)
{
    void* pWork;

    if(_pCommState->timer!=0){
        _pCommState->timer--;
        return;
    }
    if(!CommIsVRAMDInitialize()){
        return;  //
    }
    CommMPInitialize(_pCommState->pMyStatus);
    CommInfoInitialize(_pCommState->pMyStatus);
    CommSetAloneMode(TRUE);
    CommEnableSendMoveData(); //commsystemɂĂL[f[^̑M

    // ܂q@ɂȂĂ݂āAe@T  RFe@炷΂₭Ȃ邩
#if PM_DEBUG
    if(CommChildModeInit(TRUE, _pCommState->serviceNo, _pCommState->regulationNo, _pCommState->soloDebugNo, TRUE, _PACKETSIZE_UNDERGROUND)){
#else
    if(CommChildModeInit(TRUE, _pCommState->serviceNo, _pCommState->regulationNo, TRUE, _PACKETSIZE_UNDERGROUND)){
#endif
        _CHANGE_STATE(_underChildPSearching, _CHILD_P_SEARCH_TIME*2);
    }
}

//==============================================================================
/**
 * Zbg̍ăX^[g
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underChildFInit(void)
{
    BOOL bSuccess;

    if(!CommMPIsStateIdle()){  // IƏIĂ邱ƂmF
        return;
    }
    CommSetAloneMode(TRUE);  // ڑ
    CommEnableSendMoveData(); //commsystemɂĂL[f[^̑M
#if PM_DEBUG
    bSuccess = CommChildModeInit(FALSE, _pCommState->serviceNo,_pCommState->regulationNo,_pCommState->soloDebugNo, TRUE, _PACKETSIZE_UNDERGROUND);
#else
    bSuccess = CommChildModeInit(FALSE, _pCommState->serviceNo,_pCommState->regulationNo, TRUE, _PACKETSIZE_UNDERGROUND);
#endif
    if(bSuccess){
        u32 rand = MATH_Rand32(&_pCommState->sRand, _CHILD_P_SEARCH_TIME*2);
        if(_pCommState->reConnectTime > 0){
            //OHNO_PRINT("Đڑԍl %d \n", _pCommState->reConnectTime);
            // Đڑԍl
            rand = 2 * _CHILD_P_SEARCH_TIME * _pCommState->reConnectTime;
            _pCommState->reConnectTime = 0;
        }
        _CHANGE_STATE(_underChildPSearching, rand);
    }
}

//==============================================================================
/**
 * q@ăX^[g
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underChildPInit(void)
{
    BOOL bSuccess;
    
    if(!CommMPIsStateIdle()){  // IƏIĂ邱ƂmF
        return;
    }
#if PM_DEBUG
    bSuccess = CommChildModeInit(FALSE, _pCommState->serviceNo,_pCommState->regulationNo,_pCommState->soloDebugNo, FALSE, _PACKETSIZE_UNDERGROUND);
#else
    bSuccess = CommChildModeInit(FALSE, _pCommState->serviceNo,_pCommState->regulationNo, FALSE, _PACKETSIZE_UNDERGROUND);
#endif
    if(bSuccess){
        u32 rand = MATH_Rand32(&_pCommState->sRand, _CHILD_P_SEARCH_TIME);
        _CHANGE_STATE(_underChildPSearching, _CHILD_P_SEARCH_TIME/2 + rand);
    }
}

//==============================================================================
/**
 * q@ƂȂĐe@T
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underChildPSearching(void)
{
    int realParent;
    
    CommMPParentBconCheck();  // bcoň
    realParent = CommMPGetFastConnectIndex();  //ȂƂl
    if(realParent != -1){
        _pCommState->connectIndex = realParent;  // L
        _CHANGE_STATE(_underChildForceConnect, _CHILD_P_SEARCH_TIME);
        OHNO_PRINT("{eɐڑ\n");
        return;
    }
    if(_pCommState->timer != 0){
        _pCommState->timer--;
        return;
    }
    realParent = CommMPGetNextConnectIndex();  //ȂƂl
    if(realParent != -1){
        _pCommState->connectIndex = realParent;  // L
        _CHANGE_STATE(_underChildForceConnect, _CHILD_P_SEARCH_TIME);
        return;
    }
    // eȂꍇ eɂȂ
    _CHANGE_STATE(_underChildFinalize, 0);
}


//==============================================================================
/**
 * ڕWƂȂe@ɑ΂Đڑ
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underChildForceConnect(void)
{
    //OHNO_PRINT("_underChildForceConnect...\n");
    CommMPParentBconCheck();  // bcoň
    if(CommMPGetParentConnectionNum(_pCommState->connectIndex)!=0){ // eĂꍇ
        //OHNO_PRINT("ڑ\n");
        if(CommChildIndexConnect(_pCommState->connectIndex)){  // ڑ܂ŌĂё
            _CHANGE_STATE(_underChildConnecting, 100);
            return;
        }
    }
    if(CommIsError()){
        //OHNO_PRINT("G[̏ꍇ߂\n");
        _CHANGE_STATE(_underChildFinalize, 0);
    }
    else if(_pCommState->timer!=0){
        _pCommState->timer--;
    }
    else{
        OHNO_PRINT("ڑԐ؂̏ꍇ܂ǂ\n");
        _CHANGE_STATE(_underChildFinalize, 0);
    }
}



//==============================================================================
/**
 * q@ƂȂĐڑ
 * @param   none
 * @retval  none
 */
//==============================================================================
static void _underChildConnecting(void)
{
    if(CommIsConnect(CommGetCurrentID())){   // gڑĂ邱ƂmFł
        CommSystemReset();   // ܂ł̒ʐMobt@N[ɂ
        CommSetAloneMode(FALSE);
        CommEnableSendMoveData();
        //OHNO_PRINT("q@ڑ\n");
        _CHANGE_STATE(_underChildConnect, 0);
        return;
    }
    
    if(CommIsError()){
        OHNO_PRINT("G[̏ꍇchangeɂĂ݂\n");
        _CHANGE_STATE(_underChildFinalize, 0);
        return;
    }
    if(_pCommState->timer!=0){
        _pCommState->timer--;
        return;
    }
    // Ԑ؂
    _CHANGE_STATE(_underChildFinalize, 0);
}

//==============================================================================
/**
 * q@I eɕς
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underChildFinalize(void)
{
    if(!CommMPSwitchParentChild()){
        return;
    }
    _CHANGE_STATE(_underParentInit, 0);
    OHNO_PRINT("e@ɂȂҋ@ \n");
}

//==============================================================================
/**
 * e@I@mŐe@ɂȂ邩q@ɂȂ邩߂
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underParentFinalize(void)
{
    if(!CommMPSwitchParentChild()){
        return;
    }
    _CHANGE_STATE(_underChildPInit, 0);
//    OHNO_PRINT("q@ƂȂ茟 %d\n", rand);
}

//==============================================================================
/**
 * e@Jn
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underParentInit(void)
{
    MYSTATUS* pMyStatus;
    
    if(!CommMPIsStateIdle()){  // IƏIĂ邱ƂmF
        return;
    }
    // e@ɂȂĂ݂
    CommSetAloneMode(TRUE); // 
#if PM_DEBUG
    if(CommParentModeInit(FALSE, _pCommState->serviceNo,_pCommState->regulationNo, _pCommState->soloDebugNo, _pCommState->bFirstParent, _PACKETSIZE_UNDERGROUND))  {
#else
    if(CommParentModeInit(FALSE, _pCommState->serviceNo,_pCommState->regulationNo, _pCommState->bFirstParent, _PACKETSIZE_UNDERGROUND))  {
#endif
        u32 rand = MATH_Rand32(&_pCommState->sRand, _PARENT_WAIT_TIME/2);
        _pCommState->bFirstParent = FALSE;
        _CHANGE_STATE(_underParentWait, _PARENT_WAIT_TIME/2+rand);
    }
}

//==============================================================================
/**
 * e@ɂȂAq@ڑĂ̂҂
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underParentWait(void)
{
   if(CommIsChildsConnecting()){   // ȊOȂe@Œ
       OHNO_PRINT("ȊOȂe@Œ\n");
        _pCommState->bFirstParent = TRUE;  // e@ƂČq̂ŃtO߂Ă
        _CHANGE_STATE(_underParentConnectInit, 0);
        return;
    }
    if(_pCommState->timer!=0){
        _pCommState->timer--;
        return;
    }
    if( CommMPSwitchParentChild() ){
        _CHANGE_STATE(_underParentFinalize, _FINALIZE_TIME);
    }
}

//==============================================================================
/**
 * e@ƂĐڑ̂ŏs
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underParentConnectInit(void)
{
    CommSetAloneMode(FALSE);
    CommMPSetNoChildError(TRUE);  // q@ȂȂČ邽߂ERRɂ
    CommEnableSendMoveData();

    _CHANGE_STATE(_underParentConnect, 0);
}

//==============================================================================
/**
 * e@ƂĐڑ
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underParentConnect(void)
{
    if(CommIsError()){
        // eqɖ߂
//        CommMPSwitchParentChild();
        _CHANGE_STATE(_underChildFinalize, _FINALIZE_TIME);
    }
}

//==============================================================================
/**
 * q@ƂĐڑ
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underChildConnect(void)
{
    /*
    // e@ȂȂIĕʐeTɂ
    if(CommMPParentDisconnect() || CommIsError()){
        if(CommMPParentDisconnect()){
            OHNO_PRINT("e@ؒf ??  \n");
        }
        else{
            OHNO_PRINT("G[ؒf   \n");
        }
//        _stateUnderGroundConnectEnd();
        CommSystemReset();   // ܂ł̒ʐMobt@N[ɂ
        // 邮܂킷
        _pCommState->reConnectTime = CommGetCurrentID();
        _CHANGE_STATE(_underChildReset, 0);  // G[ȈꍇRESET
    }
       */
}


static void _underSBBoot(void)
{
    OHNO_PRINT("I̊mF \n");
    if(!CommMPIsStateIdle()){  // IƏIĂ邱ƂmF
        return;
    }
    CommSetAloneMode(TRUE);  // ڑ
    CommEnableSendMoveData(); //commsystemɂĂL[f[^̑M
    CommMPStealth(TRUE);  // 閧ɐؒf
    OHNO_PRINT("ʐM؂ꂽ͂ \n");
    _CHANGE_STATE(_stateNone, 0);
}

//==============================================================================
/**
 * 閧nOFFLINEpɃZbgs
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underSBReset(void)
{
    if(!CommMPSwitchParentChild()){
        return;
    }
    OHNO_PRINT("ċN    -- %d \n",CommGetCurrentID());
    CommSystemReset();         // ܂ł̒ʐMobt@N[ɂ
    _CHANGE_STATE(_underSBBoot, 0);
}


//==============================================================================
/**
 * CNj[ʐMN
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underChildOnline(void)
{
    if(!CommIsVRAMDInitialize()){
        return;  //
    }
    CommMPStealth(FALSE);
    OHNO_PRINT("ċN    -- %d \n",CommGetCurrentID());
    _CHANGE_STATE(_underChildFInit, 0);
}

//==============================================================================
/**
 * ZbgsAq@ƂčċN
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underChildReset(void)
{
    if(!CommMPSwitchParentChild()){
        return;
    }
    OHNO_PRINT("ċN    -- %d \n",CommGetCurrentID());
    _CHANGE_STATE(_underChildFInit, 0);
}

//==============================================================================
/**
 * e@Ƃďs
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleParentInit(void)
{
    MYSTATUS* pMyStatus;
    
    if(!CommIsVRAMDInitialize()){
        return;
    }
    CommMPInitialize(_pCommState->pMyStatus);
    CommInfoInitialize(_pCommState->pMyStatus);


#if PM_DEBUG
    if(CommParentModeInit(TRUE, _pCommState->serviceNo,_pCommState->regulationNo, _pCommState->soloDebugNo, TRUE, _PACKETSIZE_BATTLE)){
#else
    if(CommParentModeInit(TRUE, _pCommState->serviceNo,_pCommState->regulationNo, TRUE, _PACKETSIZE_BATTLE)){
#endif
        CommSetTransmissonTypeDS();
        _CHANGE_STATE(_battleParentSendName, 0);
    }
}


//==============================================================================
/**
 * q@ҋ@  e@I
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleParentSendName(void)
{
    if(!CommIsConnect(CommGetCurrentID())){
        return;
    }
    _CHANGE_STATE(_battleParentWaiting, 0);
}

//==============================================================================
/**
 * e@Ƃđҋ@
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleParentWaiting(void)
{
    if(!CommIsInitialize()){
        _CHANGE_STATE(_stateEnd,0);
    }
}

//==============================================================================
/**
 * q@̏
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleChildInit(void)
{
    if(!CommIsVRAMDInitialize()){
        return;
    }
    CommMPInitialize(_pCommState->pMyStatus);
    CommInfoInitialize(_pCommState->pMyStatus);
    
#if PM_DEBUG
    if(CommChildModeInit(TRUE, _pCommState->serviceNo,_pCommState->regulationNo, _pCommState->soloDebugNo, TRUE, _PACKETSIZE_BATTLE)){
#else
    if(CommChildModeInit(TRUE, _pCommState->serviceNo,_pCommState->regulationNo, TRUE, _PACKETSIZE_BATTLE)){
#endif
        CommSetTransmissonTypeDS();
        _CHANGE_STATE(_battleChildBconScanning, 0);
    }
}

//==============================================================================
/**
 * q@ҋ@  e@r[RW
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleChildBconScanning(void)
{
    CommMPParentBconCheck();
}

//==============================================================================
/**
 * q@ҋ@  e@ɋ炢
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleChildConnecting(void)
{
    CommMPParentBconCheck();
    if(CommChildIndexConnect(_pCommState->connectIndex)){  // ڑ
        _CHANGE_STATE(_battleChildSendName, _SEND_NAME_TIME);
    }

}

//==============================================================================
/**
 * q@ҋ@  e@ɏ𑗐M
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleChildSendName(void)
{

    if(CommIsError()){
        //OHNO_PRINT("G[̏ꍇ߂\n");
        _CHANGE_STATE(_battleChildReset, 0);
    }

    
    if(CommIsConnect(CommGetCurrentID()) && ( COMM_PARENT_ID != CommGetCurrentID())){
        _CHANGE_STATE(_battleChildWaiting, 0);
    }
}

//==============================================================================
/**
 * q@Zbg   
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleChildReset(void)
{
    CommMPSwitchParentChild();
    _CHANGE_STATE(_battleChildReConnect, _FINALIZE_TIME);
}

//==============================================================================
/**
 * q@IĐڑ
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleChildReConnect(void)
{
    MYSTATUS* pMyStatus;

    if(_pCommState->timer!=0){
        _pCommState->timer--;
        return;
    }
    if(!CommMPIsStateIdle()){  /// IƏIĂ邱ƂmF
        return;
    }
#if PM_DEBUG
    if(CommChildModeInit(FALSE, _pCommState->serviceNo,_pCommState->regulationNo, _pCommState->soloDebugNo, TRUE, _PACKETSIZE_BATTLE)){
#else
    if(CommChildModeInit(FALSE, _pCommState->serviceNo,_pCommState->regulationNo, TRUE, _PACKETSIZE_BATTLE)){
#endif
        CommSetTransmissonTypeDS();
        _CHANGE_STATE(_battleChildConnecting, _SEND_NAME_TIME);
    }
}


//==============================================================================
/**
 * q@ҋ@
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleChildWaiting(void)
{
    if(!CommIsInitialize()){
        _CHANGE_STATE(_stateEnd,0);
    }
}

//==============================================================================
/**
 * q@I
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleChildReTry(void)
{
    CommMPSwitchParentChild();
    _CHANGE_STATE(_battleChildReInit, _FINALIZE_TIME);
}

//==============================================================================
/**
 * q@IċN
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleChildReInit(void)
{
    MYSTATUS* pMyStatus;

    if(_pCommState->timer!=0){
        _pCommState->timer--;
        return;
    }
    if(!CommMPIsStateIdle()){  /// IƏIĂ邱ƂmF
        return;
    }
#if PM_DEBUG
    if(CommChildModeInit(FALSE, _pCommState->serviceNo,_pCommState->regulationNo, _pCommState->soloDebugNo, TRUE, _PACKETSIZE_BATTLE)){
#else
    if(CommChildModeInit(FALSE, _pCommState->serviceNo,_pCommState->regulationNo, TRUE, _PACKETSIZE_BATTLE)){
#endif
        CommSetTransmissonTypeDS();
        _CHANGE_STATE(_battleChildBconScanning, _SEND_NAME_TIME);
    }
}

//==============================================================================
/**
 * ȂXe[g
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _stateNone(void)
{
    // ȂɂĂȂ
}

//==============================================================================
/**
 * @brief G[
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _stateConnectError(void)
{
}

//==============================================================================
/**
 * @brief  I
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _stateEnd(void)
{
    if(CommIsInitialize()){
        return;
    }
    _stateFinalize();
}

//==============================================================================
/**
 * @brief  nEJn
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _stateUnderGroundConnectEnd(void)
{
    _CHANGE_STATE(_stateConnectEnd, _EXIT_SENDING_TIME);
}

//==============================================================================
/**
 * @brief  IJn
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _stateConnectAutoEnd(void)
{
    if(CommSendFixData(CS_AUTO_EXIT)){
        _CHANGE_STATE(_stateEnd, 0);
    }
}

//==============================================================================
/**
 * @brief  IJn
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _stateConnectEnd(void)
{
    if(_pCommState->timer != 0){
        _pCommState->timer--;
        return;
    }
    // ؒf
    CommFinalize();
    _CHANGE_STATE(_stateEnd, 0);
}



//==============================================================================
/**
 * UNIONX^[g
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _unionStart(void)
{
    void* pWork;

    if(!CommIsVRAMDInitialize()){
        return;  //
    }
    CommMPInitialize(_pCommState->pMyStatus);
    CommInfoInitialize(_pCommState->pMyStatus);
    
    // ܂q@ɂȂĂ݂āAe@T   邮񂵂bcon߂
#if PM_DEBUG
    if(CommChildModeInit(TRUE, _pCommState->serviceNo,_pCommState->regulationNo, _pCommState->soloDebugNo, TRUE, _PACKETSIZE_UNION)){
#else
    if(CommChildModeInit(TRUE, _pCommState->serviceNo,_pCommState->regulationNo, TRUE, _PACKETSIZE_UNION)){
#endif
        CommSetTransmissonTypeDS();
        _CHANGE_STATE(_unionChildSearching, _CHILD_P_SEARCH_TIME*2);
    }
}

//==============================================================================
/**
 * q@ƂȂĐe@T
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _unionChildSearching(void)
{
    int realParent;
    
    CommMPParentBconCheck();  // bcoň
    if(_pCommState->timer != 0){
        _pCommState->timer--;
        return;
    }
    // eɂȂĎ̏𑗐M
    _CHANGE_STATE(_unionChildFinalize, 0);
}

//==============================================================================
/**
 * q@I eɕς
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _unionChildFinalize(void)
{
    if(!CommMPSwitchParentChild()){
        return;
    }
    _CHANGE_STATE(_unionParentInit, 0);
    //OHNO_PRINT("e@ɂȂҋ@ \n");
}

//==============================================================================
/**
 * e@Jn
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _unionParentInit(void)
{
    if(!CommMPIsStateIdle()){  // IƏIĂ邱ƂmF
        return;
    }
    // e@ɂȂĂ݂
#if PM_DEBUG
    if(CommParentModeInit(FALSE, _pCommState->serviceNo,_pCommState->regulationNo, _pCommState->soloDebugNo, _pCommState->bFirstParent, _PACKETSIZE_UNION))  {
#else
    if(CommParentModeInit(FALSE, _pCommState->serviceNo,_pCommState->regulationNo, _pCommState->bFirstParent, _PACKETSIZE_UNION))  {
#endif
        u32 rand = MATH_Rand32(&_pCommState->sRand, _PARENT_WAIT_TIME*2);
        CommSetTransmissonTypeDS();
        _pCommState->bFirstParent = FALSE;
        _CHANGE_STATE(_unionParentWait, rand);
    }
}

//==============================================================================
/**
 * e@ɂȂbcono
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _unionParentWait(void)
{
    if(CommIsChildsConnecting()){   // ȊOȂe@Œ
        _pCommState->bFirstParent = TRUE;  // e@ƂČq̂ŃtO߂Ă
        _CHANGE_STATE(_unionParentConnect, 0);
        return;
    }
    if(_pCommState->timer!=0){
        _pCommState->timer--;
        return;
    }
    if( CommMPSwitchParentChild() ){
        _CHANGE_STATE(_unionChildRestart, 0);
    }
}

//==============================================================================
/**
 * q@ăX^[g
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _unionChildRestart(void)
{
    u32 rand;
    
    if(!CommMPIsStateIdle()){  // IƏIĂ邱ƂmF
        return;
    }
    // x̓r[Rc܂
#if PM_DEBUG
    if(CommChildModeInit(FALSE, _pCommState->serviceNo,_pCommState->regulationNo, _pCommState->soloDebugNo, FALSE, _PACKETSIZE_UNION)){
#else
    if(CommChildModeInit(FALSE, _pCommState->serviceNo,_pCommState->regulationNo, FALSE, _PACKETSIZE_UNION)){
#endif
        CommSetTransmissonTypeDS();
        rand = MATH_Rand32(&_pCommState->sRand, _CHILD_P_SEARCH_TIME);
        _CHANGE_STATE(_unionChildSearching, _CHILD_P_SEARCH_TIME/2 + rand);
    }
}

//==============================================================================
/**
 * bJnŁAq@ҋ@ԂɂȂ
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _unionForceConnectStart(void)
{
    if(!CommMPSwitchParentChild()){  // ̏ԂI
        return;
    }
    _CHANGE_STATE(_unionForceConnectStart2, 0);
}


static void _unionForceConnectStart2(void)
{
    if(!CommMPIsStateIdle()){  // IƏIĂ邱ƂmF
        return;
    }
    // q@ɂȂ
#if PM_DEBUG
    if(CommChildModeInit(FALSE, _pCommState->serviceNo,_pCommState->regulationNo, _pCommState->soloDebugNo, FALSE, _PACKETSIZE_UNION)){
#else
    if(CommChildModeInit(FALSE, _pCommState->serviceNo,_pCommState->regulationNo, FALSE, _PACKETSIZE_UNION)){
#endif
        CommSetTransmissonTypeDS();
        _CHANGE_STATE(_unionForceConnect, 100);
    }
}

//==============================================================================
/**
 * q@ƂȂċڑ
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _unionForceConnect(void)
{
    OHNO_PRINT("_unionForceConnect...\n");
    if(CommMPGetParentConnectionNum(_pCommState->connectIndex)!=0){ // eĂꍇ
        OHNO_PRINT("ڑ\n");
        if(CommChildIndexConnect(_pCommState->connectIndex)){  // ڑ܂ŌĂё
            _CHANGE_STATE(_unionChildConnecting, 100);
            return;
        }
    }
    if(CommIsError()){
        OHNO_PRINT("G[̏ꍇēxd؂Ȃ\n");
        _CHANGE_STATE(_unionChildReset, 0);
    }
    else if(_pCommState->timer!=0){
        _pCommState->timer--;
    }
    else{
        OHNO_PRINT("ڑԐ؂̏ꍇ܂ǂ\n");
        _CHANGE_STATE(_unionChildReset, 0);
    }
}

//==============================================================================
/**
 * q@ƂȂĐڑ
 * @param   none
 * @retval  none
 */
//==============================================================================
static void _unionChildConnecting(void)
{
    if(CommIsError()){
        OHNO_PRINT("------G[̏ꍇReset\n");
        _CHANGE_STATE(_unionChildReset, 0);
        return;
    }
    if(CommIsConnect(CommGetCurrentID())){   // gڑĂ邱ƂmFł
        OHNO_PRINT("q@ڑ  FؑM\n");
        CommSendFixSizeData(CS_COMM_NEGOTIATION, _negotiationMsg);
        _CHANGE_STATE(_unionChildNegotiation, 20);
        return;
    }
    
    if(_pCommState->timer!=0){
        _pCommState->timer--;
        return;
    }
    // Ԑ؂
    _CHANGE_STATE(_unionChildReset, 0);
}

//==============================================================================
/**
 * q@ƂȂĐڑ  e@Fؑ҂
 * @param   none
 * @retval  none
 */
//==============================================================================
static void _unionChildNegotiation(void)
{
    if(CommIsError()){
        OHNO_PRINT("------G[̏ꍇReset\n");
        _CHANGE_STATE(_unionChildReset, 0);
        return;
    }
    if(_pCommState->negotiation == _NEGOTIATION_NG){
        OHNO_PRINT("ڑs-----------------------\n");
        _CHANGE_STATE(_unionChildConnectFailed, 0);
        return;
    }
    if(_pCommState->negotiation == _NEGOTIATION_OK){
        OHNO_PRINT("q@ڑ  F؂\n");
        CommInfoSendPokeData();
        _CHANGE_STATE(_unionChildConnectSuccess, 0);
        return;
    }
    
    if(_pCommState->timer!=0){
        _pCommState->timer--;
        return;
    }
    OHNO_PRINT(" Ԑ؂ \n");
    _CHANGE_STATE(_unionChildReset, 0);
}



static void _unionChildConnectSuccess(void)
{
    if(CommIsError()){
        _CHANGE_STATE(_unionChildReset, 0);
        return;
    }
}

static void _unionChildConnectFailed(void)
{
}

static void _unionChildReset(void)
{
    _pCommState->negotiation = _NEGOTIATION_CHECK;
    if(!CommMPSwitchParentChild()){
        return;
    }

    if(_pCommState->reConnectTime != 0){
        _pCommState->reConnectTime--;
        _CHANGE_STATE(_unionForceConnectStart2, 0);
    }
    else{  // ȂȂ̂ŎsXe[g
        _CHANGE_STATE(_unionChildConnectFailed, 0);
    }
}

//==============================================================================
/**
 * eƂĐڑ
 * @param   none
 * @retval  none
 */
//==============================================================================
static void _unionParentConnect(void)
{
    if(CommGetCurrentID() == COMM_PARENT_ID){
        CommInfoSendArray_ServerSide();  // q@₢킹info𑗐M
    }
    if(CommIsError()){
        OHNO_PRINT("------G[̏ꍇReset\n");
        _CHANGE_STATE(_unionChildReset, 0);
        return;
    }
}


#ifdef PM_DEBUG
//==============================================================================
/**
 * fobOpʐMڑJn
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommStateRecvDebugStart(int netID, int size, void* pData, void* pWork)
{
    _pCommState->bDebugStart = TRUE;
    OHNO_PRINT("R}h\n");
}

BOOL CommStateDBattleIsReady(void)
{
    if(_pCommState){
        return _pCommState->bDebugStart;
    }
    return FALSE;
}

static void _commConnectChildDebug(TCB_PTR tcb, void* work)
{
    if(!CommIsVRAMDInitialize()){
        return;
    }
    if(CommMPGetGFBss(_pCommState->connectIndex)!=NULL){
        CommStateConnectBattleChild(_pCommState->connectIndex);  // ڑ
        TCB_Delete(tcb);
    }
}

static void _commConnectParentDebug(TCB_PTR tcb, void* work)
{
    if(!CommIsVRAMDInitialize()){
        return;
    }
    if(CommGetConnectNum() == (CommLocalGetServiceMaxEntry(CommMPGetServiceNo())+1) ){
        OHNO_PRINT("ڑlɒB\n");
        CommSendFixData(CS_DEBUG_START);  // SɃR}hM
        TCB_Delete(tcb);
    }
}

void CommStateDBattleConnect(BOOL bParent, int gameMode, MYSTATUS* pMyStatus)
{
    if(!bParent){
        CommStateEnterBattleChild(pMyStatus, gameMode, 0, SOLO_DEBUG_NO + COMMDIRECT_DEBUG_NO);
        _pCommState->connectIndex = 0;
        TCB_Add(_commConnectChildDebug, NULL, _TCB_COMMCHECK_PRT-1);
    }
    else{
        CommStateEnterBattleParent(pMyStatus, gameMode, 0, SOLO_DEBUG_NO + COMMDIRECT_DEBUG_NO);
        TCB_Add(_commConnectParentDebug, NULL, _TCB_COMMCHECK_PRT-1);
    }
    _pCommState->bDebugStart = FALSE;
}


#endif //PM_DEBUG


static void _pictureBoardChangeParent(void);
static void _pictureBoardInitParent(void);
static void _pictureBoardParentWait(void);

static void _pictureBoardChangeChild(void);
static void _pictureBoardInitChild(void);
static void _pictureBoardForceConnect(void);
static void _pictureBoardChildConnecting(void);

//==============================================================================
/**
 * G[hɌqȂ
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommStateUnionPictureBoardChange(void)
{

    if(CommGetCurrentID() == COMM_PARENT_ID){
        u8 bDSMode = FALSE;
        CommSendFixSizeData(CS_DSMP_CHANGE, &bDSMode);  //ړ[hɕύX
        _pCommState->limitNum = COMM_MODE_PICTURE_NUM_MAX+1;
    }
    else{
        u8 bDSMode = FALSE;
        CommSendFixSizeData(CS_DSMP_CHANGE, &bDSMode);  //ړ[hɕύX
    }
}

//==============================================================================
/**
 * G[hq@ƂČq
 * @param   ڑe@index
 * @retval  none
 */
//==============================================================================

void CommStateUnionPictureBoardChild(int index)
{
    _pCommState->connectIndex = index;
    _CHANGE_STATE(_pictureBoardChangeChild, 0);
    OHNO_PRINT("G{[hq@ڑ\n");
}

//==============================================================================
/**
 * GstateɈڍsǂ̊mF
 * @param   none
 * @retval  GstateɈڍsꍇTRUE
 */
//==============================================================================

BOOL CommStateIsUnionPictureBoardState(void)
{
    u32 stateAddr = (u32)_pCommState->state;

    if(CommIsTransmissonDSType()){
        return FALSE;
    }
    if(stateAddr == (u32)_unionParentConnect){
        return TRUE;
    }
    if(stateAddr == (u32)_unionChildConnectSuccess){
        return TRUE;
    }
    return FALSE;
}


static void _pictureBoardChangeParent(void)
{
    if( CommMPSwitchParentChild() ){
        _CHANGE_STATE(_pictureBoardInitParent, 0);
    }
}

static void _pictureBoardInitParent(void)
{
    if(!CommMPIsStateIdle()){  // IƏIĂ邱ƂmF
        return;
    }
    _pCommState->serviceNo = COMM_MODE_PICTURE;
#if PM_DEBUG
    if(CommParentModeInit(FALSE, _pCommState->serviceNo ,_pCommState->regulationNo,
                          _pCommState->soloDebugNo, FALSE, _PACKETSIZE_UNION)) {
#else
    if(CommParentModeInit(FALSE, _pCommState->serviceNo,_pCommState->regulationNo,
                          FALSE, _PACKETSIZE_UNION))  {
#endif
        CommSetTransmissonTypeMP();
        _CHANGE_STATE(_pictureBoardParentWait, 0);
    }
}


static void _pictureBoardParentWait(void)
{
    if(CommIsChildsConnecting()){   // ȊOȂe@Œ
        _pCommState->bFirstParent = TRUE;  // e@ƂČq̂ŃtO߂Ă
        CommInfoSendPokeData();
        _CHANGE_STATE(_unionParentConnect, 0);
    }
}


static void _pictureBoardChangeChild(void)
{
    if( CommMPSwitchParentChild() ){
        _CHANGE_STATE(_pictureBoardInitChild, 0);
    }
}

static void _pictureBoardInitChild(void)
{
    if(!CommMPIsStateIdle()){  // IƏIĂ邱ƂmF
        return;
    }
    _pCommState->serviceNo = COMM_MODE_PICTURE;
#if PM_DEBUG
    if(CommChildModeInit(FALSE, _pCommState->serviceNo,_pCommState->regulationNo, _pCommState->soloDebugNo, FALSE, _PACKETSIZE_UNION)){
#else
    if(CommChildModeInit(FALSE, _pCommState->serviceNo,_pCommState->regulationNo, FALSE, _PACKETSIZE_UNION)){
#endif
        CommSetTransmissonTypeMP();
        _CHANGE_STATE(_pictureBoardForceConnect, 100);
    }
}


//==============================================================================
/**
 * q@ƂȂċڑ
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _pictureBoardForceConnect(void)
{
    OHNO_PRINT("_pictureBoardForceConnect...\n");
    if(CommMPGetParentConnectionNum(_pCommState->connectIndex)!=0){ // eĂꍇ
        OHNO_PRINT("BOARDڑ\n");
        if(CommChildIndexConnect(_pCommState->connectIndex)){  // ڑ܂ŌĂё
            _CHANGE_STATE(_pictureBoardChildConnecting, 100);
            return;
        }
    }
    if(CommIsError()){
        OHNO_PRINT("G[̏ꍇēxd؂Ȃ\n");
        _CHANGE_STATE(_pictureBoardChangeChild, 0);
    }
    else if(_pCommState->timer!=0){
        _pCommState->timer--;
    }
    else{
        OHNO_PRINT("ڑԐ؂̏ꍇ܂ǂ\n");
        _CHANGE_STATE(_pictureBoardChangeChild, 0);
    }
}

//==============================================================================
/**
 * q@ƂȂĐڑ
 * @param   none
 * @retval  none
 */
//==============================================================================
static void _pictureBoardChildConnecting(void)
{
    if(CommIsConnect(CommGetCurrentID())){   // gڑĂ邱ƂmFł
        OHNO_PRINT("q@ڑ\n");
        _CHANGE_STATE(_unionChildConnectSuccess, 0);
        return;
    }
    
    if(CommIsError()){
        OHNO_PRINT("------G[̏ꍇReset\n");
        _CHANGE_STATE(_pictureBoardChangeChild, 0);
        return;
    }
    if(_pCommState->timer!=0){
        _pCommState->timer--;
        return;
    }
    // Ԑ؂
    _CHANGE_STATE(_pictureBoardChangeChild, 0);
}

//==============================================================================
/**
 * lSVG[VpR[obN CS_COMM_NEGOTIATION
 * @param   callbackp
 * @retval  none
 */
//==============================================================================

void CommRecvNegotiation(int netID, int size, void* pData, void* pWork)
{
    int i;
    u8* pMsg = pData;
    BOOL bMatch = TRUE;

    if(CommGetCurrentID() != COMM_PARENT_ID){  // e@̂ݔf\
        return;
    }
    bMatch = TRUE;
    for(i = 0; i < sizeof(_negotiationMsg); i++){
        if(pMsg[i] != _negotiationMsg[i]){
            bMatch = FALSE;
            break;
        }
    }
    if(bMatch){   // q@ڑmF
        if(netID < _pCommState->limitNum){  // wڑl艺邱
            _negotiationMsgReturnOK[0] = netID;
            CommSendFixSizeData_ServerSide(CS_COMM_NEGOTIATION_RETURN, _negotiationMsgReturnOK);
        }
        else{
            OHNO_PRINT("------s𑗐M\n");
            _negotiationMsgReturnNG[0] = netID;
            CommSendFixSizeData_ServerSide(CS_COMM_NEGOTIATION_RETURN, _negotiationMsgReturnNG);
        }
    }
}

//==============================================================================
/**
 * lSVG[VpR[obN CS_COMM_NEGOTIATION_RETURN
 * @param   callbackp
 * @retval  none
 */
//==============================================================================

void CommRecvNegotiationReturn(int netID, int size, void* pData, void* pWork)
{
    u8 id;
    int i;
    u8* pMsg = pData;
    BOOL bMatch = TRUE;

    for(i = 1; i < sizeof(_negotiationMsgReturnOK); i++){
        if(pMsg[i] != _negotiationMsgReturnOK[i]){
            bMatch = FALSE;
            break;
        }
    }
    if(bMatch){   // e@ڑF؂
        id = pMsg[0];
        if(id == CommGetCurrentID()){
            _pCommState->negotiation = _NEGOTIATION_OK;
        }
        return;
    }
    bMatch = TRUE;
    for(i = 1; i < sizeof(_negotiationMsgReturnNG); i++){
        if(pMsg[i] != _negotiationMsgReturnNG[i]){
            bMatch = FALSE;
            break;
        }
    }
    if(bMatch){   // e@ڑے肪
        id = pMsg[0];
        OHNO_PRINT("ڑۃR}h%d %d\n",id , CommGetCurrentID());
        if(id == (u8)CommGetCurrentID()){
            _pCommState->negotiation = _NEGOTIATION_NG;
        }
        return;
    }
}

//==============================================================================
/**
 * lSVG[VpR[obN
 * @param   callbackp
 * @retval  none
 */
//==============================================================================

int CommRecvGetNegotiationSize(void)
{
    return sizeof(_negotiationMsg);
}


//==============================================================================
/**
 * Ăl𐧌
 * @param   l
 * @retval  none
 */
//==============================================================================

void CommStateSetLimitNum(int num)
{
    if(_pCommState){
        _pCommState->limitNum = num;
    }
}


//==============================================================================
/**
 * q@ҋ@  e@r[RW
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _poketchBconScanning(void)
{
    CommMPParentBconCheck();
}

//==============================================================================
/**
 * q@̏
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _poketchChildInit(void)
{
    if(!CommIsVRAMDInitialize()){
        return;
    }
    CommMPInitialize(_pCommState->pMyStatus);
    CommInfoInitialize(_pCommState->pMyStatus);
    
#if PM_DEBUG
    if(CommChildModeInit(TRUE, _pCommState->serviceNo,_pCommState->regulationNo, _pCommState->soloDebugNo, TRUE, _PACKETSIZE_POKETCH)){
#else
    if(CommChildModeInit(TRUE, _pCommState->serviceNo,_pCommState->regulationNo, TRUE, _PACKETSIZE_POKETCH)){
#endif
        CommSetTransmissonTypeDS();
        _CHANGE_STATE(_poketchBconScanning, 0);
    }
}

//==============================================================================
/**
 * ۂƂĂ̒ʐMJniq@Ԃ̂݁j
 * @param   serviceNo  ʐMT[rXԍ
 * @retval  none
 */
//==============================================================================

void CommStateEnterPockchChild(MYSTATUS* pMyStatus)
{
    if(CommIsInitialize()){
        return;      // ȂĂꍇ͏O
    }
    // ʐMq[v쐬
    sys_CreateHeap( HEAPID_BASE_APP, HEAPID_COMMUNICATION, _HEAPSIZE_POKETCH );
    _commStateInitialize(pMyStatus);
    _pCommState->serviceNo = COMM_MODE_POKETCH;
    _pCommState->regulationNo = 0;
#if PM_DEBUG
    _pCommState->soloDebugNo = 0;
#endif
    _CHANGE_STATE(_poketchChildInit, 0);
}

//==============================================================================
/**
 * ۂƂĂ̏I
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommStateExitPoketch(void)
{
    if(_pCommState==NULL){  // łɏIĂ
        return;
    }
    OHNO_PRINT("ؒf\n");
    // ؒfXe[gɈڍs  ɐ؂Ȃ
    _CHANGE_STATE(_stateConnectEnd, _EXIT_SENDING_TIME);
}

//==============================================================================
/**
 * ʐMT[`[ɂďWSTATEȂ̂ǂԂ
 * @param   none
 * @retval  WȂTRUE
 */
//==============================================================================

BOOL CommIsPoketchSearchingState(void)
{
    int i;
    u32 funcTbl[]={
        (u32)_poketchBconScanning,
        0,
    };
    u32 stateAddr = (u32)_pCommState->state;

    if(_pCommState==NULL){  // łɏIĂ
        return FALSE;
    }
    for(i = 0; funcTbl[i] != 0; i++ ){
        if(stateAddr == funcTbl[i]){
            return TRUE;
        }
    }
    return FALSE;
}


//==============================================================================
/**
 * ZbgI
 * @param   none
 * @retval  none
 */
//==============================================================================

BOOL CommStateExitReset(void)
{
    if(_pCommState==NULL){  // łɏIĂ
        return TRUE;
    }
    _CHANGE_STATE(_underSBReset, 0);  // G[ȈꍇRESET
    return FALSE;
}


