//=============================================================================
/**
 * @file	comm_system.c
 * @brief	ʐMVXe
 * @author	Katsumi Ohno
 * @date    2005.09.08
 */
//=============================================================================


#include "common.h"
#include "wh_config.h"
#include "wh.h"
#include "communication/communication.h"
#include "comm_local.h"

#include "system/pm_str.h"
#include "system/gamedata.h"  //PERSON_NAME_SIZE

#include "comm_ring_buff.h"
#include "comm_queue.h"
#include "system/savedata.h"
#include "savedata/regulation.h"
#include "system/pm_rtc.h"  //GF_RTC


//==============================================================================
// extern錾
//==============================================================================

// RpCɃ[jOôŒ`Ă
#include "communication/comm_system.h"



//==============================================================================
// `
//==============================================================================

// NCAgMpL[̃obt@TCY    ANCAg㩂̐葽؂Ă
#define _SENDQUEUE_NUM_MAX  (20)
// T[o[MpL[̃obt@TCY    A㩂̐葽؂Ă
#define _SENDQUEUE_SERVER_NUM_MAX      (280)

//q@Mobt@̃TCY    PUȂꍇ̔CV̐oCg
#define _SEND_BUFF_SIZE_CHILD  WH_MP_CHILD_DATA_SIZE
//q@Mobt@̃TCY    Sȉڑ̑MoCg
#define _SEND_BUFF_SIZE_4CHILD  WH_MP_4CHILD_DATA_SIZE
// q@RINGMobt@TCY
#define _SEND_RINGBUFF_SIZE_CHILD  (_SEND_BUFF_SIZE_CHILD * 22)
//e@Mobt@̃TCY
#define _SEND_BUFF_SIZE_PARENT  WH_MP_PARENT_DATA_SIZE
// e@RINGMobt@TCY
#define _SEND_RINGBUFF_SIZE_PARENT  (_SEND_BUFF_SIZE_PARENT * 2)

// q@Mobt@̃TCY
#define _RECV_BUFF_SIZE_CHILD  (_SEND_BUFF_SIZE_PARENT-1)
// e@Mobt@TCY
#define _RECV_BUFF_SIZE_PARENT (_SEND_BUFF_SIZE_CHILD-1)



// ĂȂCe[^[̐
#define _NULL_ITERATE (-1)
// 肦ȂID
#define _INVALID_ID  (COMM_INVALID_ID)
// 肦ȂHEADER
#define _INVALID_HEADER  (0xff)
// Mf[^܂炦ĂȂ
#define _NODATA_SEND  (0xfe)

//VBlank̃^XÑvCIeB[
#define _PRIORITY_VBLANKFUNC (0)

// ʐM擪oCgBIT̈Ӗ
#define _SEND_NONE  (0x00)  // őꍇ
#define _SEND_NEXT  (0x01)  // őȂꍇ
#define _SEND_NO_DATA  (0x02)  // L[f[^[ȊO͖ꍇ
#define _MP_DATA_HEADER (0xa0)  // MPf[^̏ꍇ̔ԍ  DS̏ꍇ 0x00or0x01or0xfeor0xff


#define _PORT_DATA_RETRANSMISSION   (14)    // ؒf܂Ŗđs  gpĂ
#define _PORT_DATA_PARENT         _PORT_DATA_RETRANSMISSION
#define _PORT_DATA_CHILD              _PORT_DATA_RETRANSMISSION

typedef enum{   // M
    _SEND_CB_NONE,           // ȂɂĂȂ
    _SEND_CB_FIRST_SEND,     // ̒ł̍ŏ̑M
    _SEND_CB_FIRST_SENDEND,  // ŏ̑M̃R[obN
    _SEND_CB_SECOND_SEND,    // 荞݂ł̑M
    _SEND_CB_SECOND_SENDEND  // 荞݂ł̑MR[obN

};

typedef enum{   // M`
    _MP_MODE,    // eq^
    _DS_MODE,    // ^
    _CHANGE_MODE_DSMP,  // DSMPɐ؂ւ
    _CHANGE_MODE_MPDS,  // MPDSɐ؂ւ
};

typedef enum TrapKeyMode_e{
    _NONE_KEY,
    _RANDOM_KEY,
    _REVERSE_KEY,
};



//==============================================================================
// [N
//==============================================================================

typedef struct{
    u8* pData;     ///< f[^|C^
    u16 size;       ///< TCY
    u8 command;    ///< R}h
    u8 priority;   ///< D揇  ͑Mǂ
} _SEND_QUEUE;


typedef struct{
    /// ----------------------------q@pe@pBUFF
    u8 sSendBuf[2][_SEND_BUFF_SIZE_4CHILD];          ///<  q@̑Mpobt@
    u8 sSendBufRing[_SEND_RINGBUFF_SIZE_CHILD];  ///<  q@̑MOobt@
    u8 sSendServerBuf[2][_SEND_BUFF_SIZE_PARENT];          ///<  e@̑Mpobt@
    u8 sSendServerBufRing[_SEND_RINGBUFF_SIZE_PARENT];
    u8* pMidRecvBufRing;          ///< 󂯎obt@obNAbv DSp
    u8* pServerRecvBufRing;       ///< e@Mobt@
    u8* pRecvBufRing;             ///< q@󂯎obt@
    u8* pTmpBuff;                 ///< M󂯓n̂߂̈ꎞobt@|C^
    //----ring
    RingBuffWork sendRing;
    RingBuffWork recvRing;                      ///< q@̎MOobt@
    RingBuffWork recvRingUndo;                      ///< q@̎MOobt@
    RingBuffWork recvMidRing[COMM_MACHINE_MAX];
    RingBuffWork sendServerRing;
    RingBuffWork recvServerRing[COMM_MACHINE_MAX];
    RingBuffWork recvServerRingUndo[COMM_MACHINE_MAX];
    TCB_PTR pVBlankTCB;
    ///---que֘A
    SEND_QUEUE_MANAGER sendQueueMgr;
    SEND_QUEUE_MANAGER sendQueueMgrServer;
    
    ///------  pad֘A
    MATHRandContext32 sRand;                    ///< L[pL[
    u16 cont[COMM_MACHINE_MAX];            ///< ƎL[VFAO
    u16 contOld[COMM_MACHINE_MAX];         ///< ƎL[VFAO
    u16 trg[COMM_MACHINE_MAX];             ///< ƎL[VFAO
    u8 padGetSwitch[COMM_MACHINE_MAX];     ///< ƎL[VFAO
    u16 sendCont;
//    PTRRandKeyCallbackFunc pResultFunc;
    u8 randPadType;   ///< ړɎgp
    s8 randPadStep;   ///< ړɎgp
    u16 oldPad;        ///< ړɎgp
    //-------
    int packetSizeMax;
    u16 bitmap;   // ڑĂ@BITǗ
    //-------------------
    u8 recvDSCatchFlg[COMM_MACHINE_MAX];  // ʐMƂL DSp
    u8 bFirstCatch[COMM_MACHINE_MAX];  // R}h͂߂Ăp
#if PM_DEBUG
    u8 DebugAutoMove;
#endif
    u8 standNo[4];     // 퓬̂Ƃ̗ʒu
    u8 transmissionType;  // ʐM` DSMP̊Ǘ
    u8 changeService;    // ʐM`Ԃ̕ύX
    u8 bFirstCatchP2C;
    u8 bNextSendData;  ///
    u8 bNextSendDataServer;  ///
    u8 sendSwitch;   // Mobt@̃XCb`tO
    u8 sendServerSwitch;   // Mobt@̃XCb`tOiT[opj
    u8 bAlone;    // lŒʐMł悤ɂ郂[h̎TRUE
} _COMM_WORK;

static _COMM_WORK* _pComm = NULL;  ///<@[N\̂̃|C^
// e@ɂȂꍇTGID \̂ɓĂȂ̂
// ʐMCu[؂ƂĂCNg
static u16 _sTgid = 0;
// 荞݂Ńf[^邩ǂ̃tO
static volatile u8 _bVSAccess = FALSE;
// MƂmF邽߂̃tO
static volatile u8 _sendCallBackServer = _SEND_CB_SECOND_SENDEND;
// 
static volatile u8 _sendCallBack = _SEND_CB_SECOND_SENDEND;

#ifdef PM_DEBUG
// mF
static volatile u8 _delayCount = 0;
#endif

//==============================================================================
// static錾
//==============================================================================

static void _commCommandInit(void);
static void _commMpVBlankIntr(TCB_PTR pTCB, void* pWork);
static void _dataMpStep(void);
static void _updateMpDataServer(void);
static void _dataMpServerStep(void);
static void _sendCallbackFunc(BOOL result);
static void _sendServerCallback(BOOL result);

static void _keyRand(void);
static void _updateMpData(void);

static void _recvDataFunc(void);
static void _recvDataServerFunc(void);
static void _setSendData(u8* pSendBuff);
static void _setSendDataServer(u8* pSendBuff);

static BOOL _padDataRecv(u8* pRecvBuff, int netID);
static BOOL _padDataSend(u8* pSendBuff);

static BOOL _setSendQueue(_SEND_QUEUE* pSendQueue,
                          int command, const void* data, int size);
static int _getNowQueueDataSize(_SEND_QUEUE* pSendQueue);
static BOOL _sendQueueSet(void);
static BOOL _sendServerQueueSet(void);
static void _queueSet(int restSize);
static void _queueSetServer(int restSize);

#if PM_DEBUG
static void _debugAutoMove(void);
static void _debugDispRecvQuantity(void);
#endif

static void _spritDataSendFunc(void);

//==============================================================================
/**
 * eqʁAʐM̏܂Ƃ߂
 * @param   bAlloc          [mۂ邩ǂ
 * @param   packetSizeMax   mۂpPbgTCY
 * @retval  ɐTRUE
 */
//==============================================================================

static BOOL _commInit(BOOL bAlloc, int packetSizeMax)
{
    void* pWork;
    int i;
    // CNj[lbg[NCu̍ďKvȏꍇTRUE
    BOOL bReInit = FALSE;

    _bVSAccess = FALSE;  // 荞ݓł̏֎~

    if(bAlloc){
        int machineMax = CommLocalGetServiceMaxEntry(CommMPGetServiceNo())+1;
        if(_pComm!=NULL){  // łɏĂꍇreturn
            return TRUE;
        }
        CommToolInitialize(HEAPID_COMMUNICATION);
        OHNO_PRINT("_COMM_WORK size %d \n", sizeof(_COMM_WORK));
        _pComm = (_COMM_WORK*)sys_AllocMemory(HEAPID_COMMUNICATION, sizeof(_COMM_WORK));

        _pComm->packetSizeMax = packetSizeMax + 64;
        _pComm->transmissionType = _MP_MODE;
        _pComm->changeService = COMM_MODE_NONE;
        _pComm->bAlone = FALSE;
        
        _pComm->pRecvBufRing = sys_AllocMemory(HEAPID_COMMUNICATION, _pComm->packetSizeMax); ///< q@󂯎obt@
        _pComm->pTmpBuff = sys_AllocMemory(HEAPID_COMMUNICATION, _pComm->packetSizeMax);  ///< M󂯓n̂߂̈ꎞobt@
        _pComm->pServerRecvBufRing = sys_AllocMemory(HEAPID_COMMUNICATION, machineMax * _pComm->packetSizeMax);   ///< 󂯎obt@obNAbv
        _pComm->pMidRecvBufRing = sys_AllocMemory(HEAPID_COMMUNICATION, machineMax * _pComm->packetSizeMax);   ///< 󂯎obt@obNAbv DSp
        // L[̏
        CommQueueManagerInitialize(&_pComm->sendQueueMgr, _SENDQUEUE_NUM_MAX, &_pComm->sendRing);
        CommQueueManagerInitialize(&_pComm->sendQueueMgrServer, _SENDQUEUE_SERVER_NUM_MAX, &_pComm->sendServerRing);

#if PM_DEBUG
//        CommQueueDebugTest();  // L[̃vOeXg
#endif
    }
    else{
        bReInit = TRUE;
        GF_ASSERT((_pComm) && "؂ւ̎͂łɏς\n");
    }
    
#if PM_DEBUG
    _pComm->DebugAutoMove = 0;
#endif
    _pComm->bitmap = 0;
    for(i =0; i < 4;i++){
        _pComm->standNo[i] = 0xff;
    }

    if(!bReInit){   // R}h̏
        _commCommandInit();
    }
    CommRandSeedInitialize(&_pComm->sRand);

    //************************************

    if(!bReInit){   // vZX^XN̍쐬
        // VBLANK
        _pComm->pVBlankTCB = VIntrTCB_Add(_commMpVBlankIntr, NULL, _PRIORITY_VBLANKFUNC);

    }
    return TRUE;
}

//==============================================================================
/**
 * eqʁAʐM̃R}hǗ̏܂Ƃ߂
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _commCommandInit(void)
{
    void* pWork;
    int i;

    // [N̏
    OHNO_PRINT("R}hď\n");
    
    _pComm->randPadType = 0;
    _pComm->randPadStep = 0;
    _pComm->sendSwitch = 0;
    _pComm->sendServerSwitch = 0;
    
    // e@݂̂̑M
    {
        int machineMax = CommLocalGetServiceMaxEntry(CommMPGetServiceNo())+1;

        MI_CpuFill8(_pComm->pServerRecvBufRing, 0, _pComm->packetSizeMax * machineMax);
        for(i = 0; i< machineMax;i++){
            CommRingInitialize(&_pComm->recvServerRing[i],
                               &_pComm->pServerRecvBufRing[i*_pComm->packetSizeMax],
                               _pComm->packetSizeMax);
            CommRingInitialize(&_pComm->recvServerRingUndo[i],
                               &_pComm->pServerRecvBufRing[i*_pComm->packetSizeMax],
                               _pComm->packetSizeMax);
        }

        MI_CpuFill8(_pComm->pMidRecvBufRing, 0, _pComm->packetSizeMax * machineMax );
        for(i = 0; i < machineMax; i++){
            CommRingInitialize(&_pComm->recvMidRing[i],
                               &_pComm->pMidRecvBufRing[i * _pComm->packetSizeMax],
                               _pComm->packetSizeMax);
        }
    }
    MI_CpuFill8(_pComm->sSendServerBufRing, 0, _SEND_RINGBUFF_SIZE_PARENT);
    CommRingInitialize(&_pComm->sendServerRing, _pComm->sSendServerBufRing,
                       _SEND_RINGBUFF_SIZE_PARENT);
    for(i = 0; i < _SEND_BUFF_SIZE_PARENT; i++){
        _pComm->sSendServerBuf[0][i] = CS_NONE;
        _pComm->sSendServerBuf[1][i] = CS_NONE;
    }
    // q@̑M
    MI_CpuFill8(_pComm->sSendBufRing, 0, _SEND_RINGBUFF_SIZE_CHILD);
    CommRingInitialize(&_pComm->sendRing, _pComm->sSendBufRing, _SEND_RINGBUFF_SIZE_CHILD);

    _pComm->sSendBuf[0][0] = _INVALID_HEADER;
    _pComm->sSendBuf[1][0] = _INVALID_HEADER;
    for(i = 1;i < _SEND_BUFF_SIZE_4CHILD;i++){
        _pComm->sSendBuf[0][i] = CS_NONE;
        _pComm->sSendBuf[1][i] = CS_NONE;
    }
    MI_CpuFill8(_pComm->pRecvBufRing, 0, _pComm->packetSizeMax);
    CommRingInitialize(&_pComm->recvRing, _pComm->pRecvBufRing, _pComm->packetSizeMax);

    _pComm->bNextSendData = FALSE;
    _pComm->bNextSendDataServer = FALSE;
    for(i = 0; i< COMM_MACHINE_MAX;i++){
        _pComm->recvDSCatchFlg[i] = 0;  // ʐMƂL
        _pComm->bFirstCatch[i] = TRUE;
        _pComm->cont[i]=0;  ///< ƎL[VFAO
        _pComm->contOld[i]=0;  ///< ƎL[VFAO
        _pComm->trg[i]=0;   ///< ƎL[VFAO
    }
    _pComm->bFirstCatchP2C = TRUE;

    _sendCallBackServer = _SEND_CB_SECOND_SENDEND;
    _sendCallBack = _SEND_CB_SECOND_SENDEND;

        // L[̃Zbg
    CommQueueManagerReset(&_pComm->sendQueueMgr);
    CommQueueManagerReset(&_pComm->sendQueueMgrServer);

}

//==============================================================================
/**
 * ʐMobt@NA[
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommSystemReset(void)
{
    BOOL bAcc = _bVSAccess;
    
    _bVSAccess = FALSE;  // 荞ݓł̏֎~
    _commCommandInit();
    _bVSAccess = bAcc;
}

//==============================================================================
/**
 * w肳ꂽq@̗̈NA[
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _clearChildBuffers(int netID)
{
    _pComm->recvDSCatchFlg[netID] = 0;  // ʐMƂL DSp
    _pComm->bFirstCatch[netID] = TRUE;  // R}h͂߂Ăp
}


//==============================================================================
/**
 * e@̏s
 * @param   work_area @VXeŎg[̈
 *                      NULL̏ꍇłɏς݂Ƃē
 * @param   regulationNo  Q[̎
 * @param   bTGIDChange  VK̃Q[̏̏ꍇTRUE Âr[Rł̌듮hߗp
 * @retval  ɐTRUE
 */
//==============================================================================
#if PM_DEBUG
BOOL CommParentModeInit(BOOL bAlloc, int serviceNo, int regulationNo, int soloDebugNo, BOOL bTGIDChange, int packetSizeMax)
#else
BOOL CommParentModeInit(BOOL bAlloc, int serviceNo, int regulationNo, BOOL bTGIDChange, int packetSizeMax)
#endif
{
    int ret;
#if PM_DEBUG
    ret = CommMPParentInit(bAlloc, serviceNo, regulationNo, soloDebugNo, bTGIDChange);
#else
    ret = CommMPParentInit(bAlloc, serviceNo, regulationNo, bTGIDChange);
#endif
    _commInit(bAlloc, packetSizeMax);
    return ret;
}

//==============================================================================
/**
 * q@̏s
 * @param   work_area @VXeŎg[̈
 *                      NULL̏ꍇ͂łɏς݂ƂĈ
 * @param   regulationNo  Q[̎
 * @param   bBconInit  r[Rf[^̂ǂ
 * @retval  ɐTRUE
 */
//==============================================================================
#if PM_DEBUG
BOOL CommChildModeInit(BOOL bAlloc, int serviceNo, int regulationNo, int soloDebugNo, BOOL bBconInit, int packetSizeMax)
#else
BOOL CommChildModeInit(BOOL bAlloc, int serviceNo, int regulationNo, BOOL bBconInit, int packetSizeMax)
#endif
{
    int ret;
#if PM_DEBUG
    ret = CommMPChildInit(bAlloc, serviceNo, regulationNo, soloDebugNo, bBconInit);
#else
    ret = CommMPChildInit(bAlloc, serviceNo, regulationNo, bBconInit);
#endif
    _commInit(bAlloc, packetSizeMax);
    return ret;
}

//==============================================================================
/**
 * ʐM[hؑ
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _transmissonTypeChange(void)
{
    int i;
    BOOL bChange = FALSE;

    if(_pComm->transmissionType == _CHANGE_MODE_DSMP){
        _pComm->transmissionType = _MP_MODE;
        bChange=TRUE;
        OHNO_PRINT("MP[hɂȂ܂\n");
    }
    if(_pComm->transmissionType == _CHANGE_MODE_MPDS){
        _pComm->transmissionType = _DS_MODE;
        bChange=TRUE;
        OHNO_PRINT("DS[hɂȂ܂\n");
    }
    if(bChange){
        _commCommandInit(); // R}hS
        for(i = 0; i < COMM_MACHINE_MAX; i++){
            _pComm->bFirstCatch[i] = TRUE;
        }
        _pComm->bFirstCatchP2C = TRUE;
    }
}

//==============================================================================
/**
 * DS[hɐ؂ւ
 * @param   DS[hœꍇ_DS_MODE MPœꍇ_MP_MODE
 * @retval  none
 */
//==============================================================================


static void _commSetTransmissonType(int type)
{
    if((_pComm->transmissionType == _MP_MODE) && (type == _DS_MODE)){
        _pComm->transmissionType = _CHANGE_MODE_MPDS;
        return;
    }
    if((_pComm->transmissionType == _DS_MODE) && (type == _MP_MODE)){
        _pComm->transmissionType = _CHANGE_MODE_DSMP;
        return;
    }
    OHNO_PRINT("CommSetTransmissonTypeɎs\n");
}

void CommSetTransmissonTypeDS(void)
{
    _commSetTransmissonType(_DS_MODE);
}

void CommSetTransmissonTypeMP(void)
{
    _commSetTransmissonType(_MP_MODE);
}

//==============================================================================
/**
 * ݂̃[h̎擾
 * @param   none
 * @retval  _DS_MODE_MP_MODE
 */
//==============================================================================

static int _transmissonType(void)
{
    if(_pComm->transmissionType == _CHANGE_MODE_DSMP){
        return _DS_MODE;
    }
    if(_pComm->transmissionType == _CHANGE_MODE_MPDS){
        return _MP_MODE;
    }
    return _pComm->transmissionType;
}

//==============================================================================
/**
 *  DS[hǂ
 * @param   none
 * @retval  TRUEȂDS
 */
//==============================================================================

BOOL CommIsTransmissonDSType(void)
{
    if(_DS_MODE == _transmissonType()){
        return TRUE;
    }
    return FALSE;
}

//==============================================================================
/**
 * ʐMؒfs
 * @param   none
 * @retval  none
 */
//==============================================================================
void CommFinalize(void)
{
    if(CommMPFinalize()){
        CommInfoFinalize();
        // VBLANK^XN؂
        _bVSAccess = FALSE;  // 荞ݓł̏֎~
        OHNO_PRINT("VBLANK^XN؂\n");
        TCB_Delete(_pComm->pVBlankTCB);
        _pComm->pVBlankTCB = NULL;
        sys_FreeMemoryEz(_pComm->pRecvBufRing);
        sys_FreeMemoryEz(_pComm->pTmpBuff);
        sys_FreeMemoryEz(_pComm->pServerRecvBufRing);
        sys_FreeMemoryEz(_pComm->pMidRecvBufRing);
        CommQueueManagerFinalize(&_pComm->sendQueueMgrServer);
        CommQueueManagerFinalize(&_pComm->sendQueueMgr);
        sys_FreeMemoryEz(_pComm);
        _pComm = NULL;
        CommToolFinalize();
    }
}

//==============================================================================
/**
 * q@ OIDŐڑ
 * @param   pNameBuf   Ȃɍs[U[ 
 * @param   pokeID     ȂɍsID
 * @retval  e@񂪂Ȃꍇ  CC_NOT_FOUND_PARENT_INFO
 * @retval  ʐM̓ԂJڒŁAڑɂȂꍇ  CC_BUSY_STATE
 * @retval  ڑ֐Ăяo CC_CONNECT_STARTING
 */
//==============================================================================
int CommChildNameAndIDConnect(STRBUF* pNameBuf,u32 pokeID)
{
    return CommMPChildNameAndIDConnect(pNameBuf, pokeID);
}

//==============================================================================
/**
 * q@ indexڑ
 * @param   index   ẽXgindex
 * @retval  q@ڑe@ɑTRUE
 */
//==============================================================================
BOOL CommChildIndexConnect(u16 index)
{
    return CommMPChildIndexConnect(index);
}

//==============================================================================
/**
 * ʐM܂߂VBLANK荞ݏ
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _commMpVBlankIntr(TCB_PTR pTCB, void* pWork)
{
    if(_bVSAccess){
        _updateMpData();     // f[^M
        if(((CommGetCurrentID() == COMM_PARENT_ID) && (CommIsConnect(COMM_PARENT_ID))) || CommGetAloneMode()){
            _updateMpDataServer();   // MPʐMT[o[STEP
        }
        _bVSAccess = FALSE;  // 荞ݓł̏֎~
    }
#if PM_DEBUG
//    _debugDispRecvQuantity();
#endif
}

//==============================================================================
/**
 * ʐMf[^̍XV  f[^W
 *    main.c     vblankɂɌĂ΂
 * @param   none
 * @retval  f[^VFAOȂꍇFALSE
 */
//==============================================================================

//extern int  simple_3DVramTexSizeGet(void);

BOOL CommUpdateData(void)
{

#if PM_DEBUG
    _delayCount = 0;
#endif
    if(_pComm){
        _bVSAccess = FALSE;   // ŜVBlank荞݂ł̃ANZX֎~錾
        _transmissonTypeChange();  //ʐM؂ւ
        _pComm->sendCont |= (sys.cont & 0x7fff);  // L[f[^̎擾
#if PM_DEBUG
        _debugAutoMove();
#endif
        _keyRand();
        _dataMpStep();
        _pComm->sendCont &= 0x8000;
        if(_transmissonType() == _MP_MODE){
            _recvDataFunc();    // q@ƂĂ̎󂯎菈
        }
        if((CommGetCurrentID() == COMM_PARENT_ID) && (CommIsConnect(COMM_PARENT_ID)) || CommGetAloneMode() ){
            // T[o[ƂĂ̏
            _dataMpServerStep();
        }
        if((CommGetCurrentID() == COMM_PARENT_ID) || (_transmissonType() == _DS_MODE) || CommGetAloneMode() ){
            _recvDataServerFunc();  // T[o[̎M
        }
        _bVSAccess = TRUE;  // ̊荞ݎł̏
        CommSpritDataSendFunc();  // SPRITR}hIɑM
    }
    return TRUE;
}

//==============================================================================
/**
 * f[^M
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _dataMpStep(void)
{
    if(_pComm){
        if(((WH_GetSystemState() == WH_SYSSTATE_CONNECTED) &&
            (CommIsConnect(CommGetCurrentID())))
           || CommGetAloneMode()){
            if(_sendCallBack != _SEND_CB_SECOND_SENDEND){
                OHNO_PRINT("_sendCallBack != _SEND_CB_SECOND_SENDEND\n");
                return;
            }
            _setSendData(_pComm->sSendBuf[_pComm->sendSwitch]);  // f[^Oobt@獷ւ
            _setSendData(_pComm->sSendBuf[ 1 - _pComm->sendSwitch]);  // f[^Oobt@獷ւ
            _sendCallBack = _SEND_CB_NONE;
            _updateMpData();     // f[^M
        }
    }
}

//==============================================================================
/**
 * f[^M  T[o[
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _updateMpDataServer(void)
{
    int i;
    int debug=0;

    if(_pComm){
        int mcSize = CommGetServiceMaxChildSendByte(CommMPGetServiceNo());
        int machineMax = CommLocalGetServiceMaxEntry(CommMPGetServiceNo())+1;
        if((_sendCallBackServer == _SEND_CB_FIRST_SENDEND) ||
           (_sendCallBackServer == _SEND_CB_NONE)){
            _sendCallBackServer++;

            if(_transmissonType() == _DS_MODE){

                // 
                for(i = 0; i < machineMax; i++){
                    if(CommIsConnect(i) && (_pComm->recvDSCatchFlg[i] > 1) ){
                       // OHNO_PRINT("--------------ǂz %d\n",i);
//                        _pComm->sSendServerBuf[_pComm->sendServerSwitch][i*mcSize] = _NODATA_SEND;
                    }
                    if(CommIsConnect(i) && (_pComm->recvDSCatchFlg[i] == 0) ){
                       // OHNO_PRINT("--------------ǂʂ %d\n",i);
                        _pComm->sSendServerBuf[_pComm->sendServerSwitch][i * mcSize] = _NODATA_SEND;
                        _sendCallBackServer--;
                        return;
                    }
                    _pComm->recvDSCatchFlg[i] = 0;
                }
                /// RINGBUFFq@SɋtM邽buffɃRs[
                for(i = 0; i < machineMax; i++){
                    _pComm->sSendServerBuf[_pComm->sendServerSwitch][i * mcSize] = _NODATA_SEND;
                    CommRingGets(&_pComm->recvMidRing[i] ,
                                 &_pComm->sSendServerBuf[_pComm->sendServerSwitch][i*mcSize],
                                 mcSize);
                }
            }
            if( (WH_GetSystemState() == WH_SYSSTATE_CONNECTED)  && !CommGetAloneMode()){
//                u8* pAdr = &_pComm->sSendServerBuf[_pComm->sendServerSwitch][1 * mcSize];
//                OHNO_PRINT("M %d %d %d %d \n",pAdr[0], pAdr[1], pAdr[2], pAdr[3], pAdr[4]);
                if(!WH_SendData(_pComm->sSendServerBuf[_pComm->sendServerSwitch],
                                _SEND_BUFF_SIZE_PARENT,
                                _PORT_DATA_PARENT, _sendServerCallback)){
                    _sendCallBackServer--;
//                    return;   // ALONEpɂ͂Ă݂eXg
                }
            }

#if _COMMAND_TEST
            {
                u8* adr = &_pComm->sSendServerBuf[_pComm->sendServerSwitch][0];
                DEBUG_DUMP(adr,_SEND_BUFF_SIZE_PARENT,"e@M");
            }
#endif

            // M
            // e@gɎq@̓邽߂ŃR[obNĂ
            CommRecvCallback(COMM_PARENT_ID,
                          (u16*)_pComm->sSendServerBuf[ _pComm->sendServerSwitch ],
                          _SEND_BUFF_SIZE_PARENT);
            _pComm->sendServerSwitch = 1 - _pComm->sendServerSwitch;
            for(i = 0; i < machineMax; i++){
                if(!CommIsConnect(i)){
                    if(_transmissonType() == _DS_MODE){             // 
                        _pComm->sSendServerBuf[_pComm->sendServerSwitch][i*mcSize] = _INVALID_HEADER;
                    }
                    else{
//                        _clearChildBuffers(i);
                    }
                }
            }
            
            if( (WH_GetSystemState() != WH_SYSSTATE_CONNECTED)  || CommGetAloneMode() ){
                // 荞݂󋵂łׂŃJEg
                _sendCallBackServer++;
            }
        }
    }
}

//==============================================================================
/**
 * f[^M  T[o[
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _dataMpServerStep(void)
{
    if((_pComm && (WH_GetSystemState() == WH_SYSSTATE_CONNECTED)) || (CommGetAloneMode()) ){
        if(_sendCallBackServer != _SEND_CB_SECOND_SENDEND){
            return;
        }
        if(_transmissonType() == _MP_MODE){  // DSɂ͂łsSendServerBufɃf[^
            _setSendDataServer(_pComm->sSendServerBuf[ _pComm->sendServerSwitch ]);  // f[^Oobt@獷ւ
            _setSendDataServer(_pComm->sSendServerBuf[ 1 - _pComm->sendServerSwitch ]);  // f[^Oobt@獷ւ
        }
        _sendCallBackServer = _SEND_CB_NONE;
        // ŏ̑M
        _updateMpDataServer();
    }
}

//==============================================================================
/**
 * ʐMMɌĂ΂R[obN
 * @param   result  s
 * @retval  none
 */
//==============================================================================

// MR[obN^ q@̎M e@192bytê݂̎MƂȂ
void CommRecvCallback(u16 aid, u16 *data, u16 size)
{
    u8* adr = (u8*)data;
    int i;
    int recvSize = size;

    if(adr==NULL){
        return;
    }
    if(adr[0] == _MP_DATA_HEADER){   ///MPf[^̏ꍇ
        if(_transmissonType() == _DS_MODE){
            OHNO_PRINT("DSȂ̂MPf[^ \n");
            return;
        }
        adr++;
        recvSize--;
    }
    else if(_transmissonType() == _MP_MODE){  //DSf[^̏ꍇ
        OHNO_PRINT("MPȂ̂DEPf[^ \n");
        return;
    }
    if((_pComm->bFirstCatchP2C) && (adr[0] & _SEND_NEXT)){
        // ܂f[^ƂȂԂȂ̂ɘAf[^
        OHNO_PRINT("Af[^ child %d \n",aid);
        DEBUG_DUMP((u8*)data,24,"cr");
        return;
    }
#if 0
    DEBUG_DUMP(adr,24,"cr");
#endif
    _pComm->bFirstCatchP2C = FALSE;

    if(_transmissonType() == _DS_MODE){
        int mcSize = CommGetServiceMaxChildSendByte(CommMPGetServiceNo());
        int machineMax = CommLocalGetServiceMaxEntry(CommMPGetServiceNo())+1;
        for(i = 0; i < machineMax; i++){
#if 0
            if(i==1){
                DEBUG_DUMP(adr,12,"q@P̃f[^MRing");
            }
#endif
            if(adr[0] == _INVALID_HEADER){
                adr += mcSize;
                _pComm->bitmap = _pComm->bitmap & ~(1<<i);
            }
            else if(adr[0] == _NODATA_SEND){
                adr += mcSize;
//                OHNO_PRINT("--------------f[^Ȃ %d\n",i);
            }
            else if((_pComm->bFirstCatch[i]) && (adr[0] & _SEND_NEXT)){ // ܂f[^ƂȂԂȂ̂ɘAf[^
                OHNO_PRINT("Af[^ parent %d \n",aid);
                adr += mcSize;
            }
            else{
                adr++;
                CommRingPuts(&_pComm->recvServerRing[i], adr, mcSize-1);
                adr += (mcSize-1);
                _pComm->bitmap = _pComm->bitmap | (1<<i);
                _pComm->bFirstCatch[i]=FALSE;
            }
        }
    }
    else{   //MPf[^
#if _COMMAND_TEST
        DEBUG_DUMP(adr,recvSize,"q@f[^M");
#endif
        adr++;      // wb_[PoCgǂݔ΂
        _pComm->bitmap = adr[0];
        _pComm->bitmap *= 256;
        adr++;   // BitmapŁ[
        _pComm->bitmap += adr[0];
        adr++;   // BitmapŁ[
        recvSize -= 3;
        //    OHNO_PRINT("bitmap %x\n",_pComm->bitmap);
        recvSize = adr[0];  /// @@OO SDK3܂ł̉
        adr++;
        if(recvSize > CommRingDataRestSize(&_pComm->recvRing)){
            GF_ASSERT_RETURN("Error:MI[o[\n",);
        }
        CommRingPuts(&_pComm->recvRing , adr, recvSize);
    }
}


//==============================================================================
/**
 * ʐMMɌĂ΂R[obN
 * @param   result  s
 * @retval  none
 */
//==============================================================================

// MR[obN^  e@p
void CommRecvParentCallback(u16 aid, u16 *data, u16 size)
{
    u8* adr = (u8*)data;
    int i;

    if(adr==NULL){
        return;
    }
    if((_pComm->bFirstCatch[aid]) && (adr[0] & _SEND_NEXT)){
        // ܂f[^ƂȂԂȂ̂ɘAf[^
        OHNO_PRINT("Af[^ parent %d \n",aid);
        i = 0;
        DEBUG_DUMP(adr,12,"Af[^");
        return;
    }
    _pComm->bFirstCatch[aid] = FALSE;

    if(_transmissonType() == _DS_MODE){
        int mcSize = CommGetServiceMaxChildSendByte(CommMPGetServiceNo());
        int machineMax = CommLocalGetServiceMaxEntry(CommMPGetServiceNo())+1;

#if 0
        if(aid == 1){
            DEBUG_DUMP(adr,mcSize,"q@DS");
        }
        if(aid == 0){
            DEBUG_DUMP(adr,mcSize,"e@DS");
        }
#endif
        for(i = 1;i < mcSize; i++){
            if(adr[i] != CS_NONE){  //ĂĂ
                CommRingPuts(&_pComm->recvMidRing[aid] , adr, size);
//                OHNO_PRINT(" ܂܂ܒԃOɓ %d %d \n", aid, CommRingDataSize(&_pComm->recvMidRing[aid]));
                break;
            }
        }
        _pComm->recvDSCatchFlg[aid]++;  // ʐMƂL
#if _COMMAND_TEST
        if(aid == 1){
            u8* dr = &_pComm->sSendServerBuf[_pComm->sendServerSwitch][mcSize];
            DEBUG_DUMP(dr,mcSize,"DS 󂯎");
        }
#endif
    }else{   // MP[h
        _padDataRecv(adr, aid);
        if(adr[0] & _SEND_NO_DATA){   // f[^ۂ̏ꍇ󂯎Ȃ
            return;
        }
        adr++;
        if(_RECV_BUFF_SIZE_PARENT > CommRingDataRestSize(&_pComm->recvServerRing[aid])){
            OHNO_PRINT("Error Throw:MI[o[\n");
            return;
        }
//        if(aid==0)
//            DEBUG_DUMP(adr,_RECV_BUFF_SIZE_PARENT,"MP 󂯎");
        CommRingPuts(&_pComm->recvServerRing[aid] , adr, _RECV_BUFF_SIZE_PARENT);
    }
}

//==============================================================================
/**
 * ʐM𑗐MƂɌĂ΂R[obN
 * @param   result  s
 * @retval  none
 */
//==============================================================================

static void _sendCallbackFunc(BOOL result)
{
    _sendCallBack++;
}

//==============================================================================
/**
 * ʐM𑗐MƂɌĂ΂R[obN ͉gĂȂ
 * @param   result  s
 * @retval  none
 */
//==============================================================================

static void _sendServerCallback(BOOL result)
{
    //    OHNO_PRINT("e@̑MCALLBACK %d %d\n", result, _sendCallBackServer);
    _sendCallBackServer++;
}

//==============================================================================
/**
 * f[^̎W
 * @param   none
 * @retval  none
 */
//==============================================================================
static void _updateMpData(void)
{
    u16 i;
    u8 *adr;
    int size;

    if(!_pComm){
        return;
    }
    {
        int mcSize = CommGetServiceMaxChildSendByte(CommMPGetServiceNo());
        int machineMax = CommLocalGetServiceMaxEntry(CommMPGetServiceNo())+1;
        if(CommGetAloneMode()){   // alone[h̏ꍇ
            if((_sendCallBack == _SEND_CB_FIRST_SENDEND) || (_sendCallBack == _SEND_CB_NONE)){
                _sendCallBack++;
                _sendCallbackFunc(TRUE);
                // q@̂ӂ镔          // e@͎ŃR[obNĂ
                CommRecvParentCallback(COMM_PARENT_ID, (u16*)_pComm->sSendBuf[_pComm->sendSwitch],
                                    mcSize);
                _pComm->sendSwitch = 1 - _pComm->sendSwitch;
                return;
            }
        }
        if(WH_GetSystemState() == WH_SYSSTATE_CONNECTED ){
            if(!CommIsConnect(CommGetCurrentID())){
                if(CommGetCurrentID()==1){
                    OHNO_PRINT("g̐ڑ܂\n");
                }
                return;
            }
            if((_sendCallBack == _SEND_CB_FIRST_SENDEND) || (_sendCallBack == _SEND_CB_NONE)){
                _sendCallBack++;
                // q@f[^M
                if(CommGetCurrentID() != COMM_PARENT_ID){
                    // e͒ʐMȂBq@
                    //DEBUG_DUMP(_pComm->sSendBuf[_pComm->sendSwitch],mcSize,"q@M");
                    
                    if(!WH_SendData(_pComm->sSendBuf[_pComm->sendSwitch],
                                    mcSize, _PORT_DATA_CHILD, _sendCallbackFunc)){
                        _sendCallBack--;
                    }
                    else{
                        _pComm->sendSwitch = 1 - _pComm->sendSwitch;
                    }
                }
                else{         // T[o[ƂĂ̏
                    _sendCallbackFunc(TRUE);
                    // q@̂ӂ镔          // e@͎ŃR[obNĂ
                    CommRecvParentCallback(COMM_PARENT_ID, (u16*)_pComm->sSendBuf[_pComm->sendSwitch],
                                        mcSize);
                    _pComm->sendSwitch = 1 - _pComm->sendSwitch;
                }
            }
        }
    }
}

//==============================================================================
/**
 * L[̗𔭐 L[͂ꂽ
 * @param   none
 * @retval  G[̎TRUE
 */
//==============================================================================

static void _keyRand(void)
{
    u16 pad = 0;

    if(_pComm->randPadType == _NONE_KEY){
        return;
    }
    if(!(_pComm->sendCont &
         (PAD_KEY_LEFT|PAD_KEY_RIGHT|PAD_KEY_UP|PAD_KEY_DOWN))){
        return;  // L[ĂȂꍇ͂gpȂ
    }
    if(_pComm->randPadType == _REVERSE_KEY){   // o[X[h
        if(_pComm->sendCont & PAD_KEY_LEFT){
            pad |= PAD_KEY_RIGHT;
        }
        if(_pComm->sendCont & PAD_KEY_RIGHT){
            pad |= PAD_KEY_LEFT;
        }
        if(_pComm->sendCont & PAD_KEY_UP){
            pad |= PAD_KEY_DOWN;
        }
        if(_pComm->sendCont & PAD_KEY_DOWN){
            pad |= PAD_KEY_UP;
        }
    }
    else{
        if(_pComm->oldPad){   // _[h
            pad = _pComm->oldPad;
            _pComm->randPadStep--;
            if(_pComm->randPadStep < 0){
                _pComm->oldPad = 0;
            }
        }
        else{
            switch(MATH_Rand32(&_pComm->sRand, 4)){
              case 0:
                pad = PAD_KEY_LEFT;
                break;
              case 1:
                pad = PAD_KEY_RIGHT;
                break;
              case 2:
                pad = PAD_KEY_UP;
                break;
              case 3:
                pad = PAD_KEY_DOWN;
                break;
            }
            _pComm->randPadStep = MATH_Rand32(&_pComm->sRand, 16);
            _pComm->oldPad = pad;
        }
    }
    _pComm->sendCont &= ~(PAD_KEY_LEFT|PAD_KEY_RIGHT|PAD_KEY_UP|PAD_KEY_DOWN);
    _pComm->sendCont += pad;
}

//==============================================================================
/**
 * L[_[hɂ
 * @param   none
 * @retval  G[̎TRUE
 */
//==============================================================================

void CommSetKeyRandMode(void)
{
    _pComm->randPadType = _RANDOM_KEY;
}

void CommSetKeyReverseMode(void)
{
    _pComm->randPadType = _REVERSE_KEY;
}

void CommResetKeyRandMode(void)
{
    _pComm->randPadType = _NONE_KEY;
}


static u16 _sendPadBit[]={
    PAD_KEY_RIGHT,
    PAD_KEY_LEFT,
    PAD_KEY_UP,
    PAD_KEY_DOWN,
    PAD_BUTTON_Y,
    PAD_BUTTON_B,
    PAD_BUTTON_R,
};
static u8 _sendPattern[][2]={
    {0,0x04},
    {0,0x08},
    {0,0x10},
    {0,0x20},
    {0,0x40},
    {0,0x40},
    {0,0x80}
};

//==============================================================================
/**
 * @brief   sendBuff Ô܂BIT+1bytegp L[f[^M
 *          ړɕKvȕL[̂ݑĂ
 * @param   pRecvBuff  󂯎obt@
 * @param   netID      netID
 * @retval  FALSÊ
 */
//==============================================================================

static BOOL _padDataRecv(u8* pRecvBuff, int netID)
{
    int i;
    u8 keyBuff[2];

    // 1/60̒ʐM pad1/30KvȂ̂ŊԈ
    _pComm->padGetSwitch[netID] = _pComm->padGetSwitch[netID] ? FALSE : TRUE;
    if(_pComm->padGetSwitch[netID]){
        return FALSE;
    }
    
    _pComm->cont[netID] = 0;
    keyBuff[0] = *pRecvBuff;

    // BITi[
    for( i = 0; i < sizeof(_sendPadBit)/sizeof(u16); i++ ){
        if(keyBuff[ _sendPattern[i][0] ] & _sendPattern[i][1]){
            _pComm->cont[netID] |= _sendPadBit[i];
        }
    }
    _pComm->trg[netID] = _pComm->contOld[netID] ^ _pComm->cont[netID];
    _pComm->contOld[netID] = _pComm->cont[netID];
    return FALSE;
}


//==============================================================================
/**
 * @brief   sendBuff Ô܂BIT+1bytegp L[f[^𑗐M
 *          ړɕKvȕL[ + Y ̂ݑĂ  trg cont𑗐M̂
 *          L[ĂꍇɑMʂ1byteω
 * @param   sendSwitch  obt@̃XCb`
 * @retval  1oCgMꍇ1
 */
//==============================================================================

static BOOL _padDataSend(u8* pSendBuff)
{
    int i,k;

    if((_pComm->sendCont & 0x8000)==0){
        return FALSE;  // ̓pbhf[^͑MȂ
    }
    // BITi[
    for( i = 0; i < sizeof(_sendPadBit)/sizeof(u16); i++ ){
        if(_pComm->sendCont & _sendPadBit[i]){
            pSendBuff[ _sendPattern[i][0] ] |= _sendPattern[i][1];
        }
    }
    return FALSE;
}

//==============================================================================
/**
 * ML[ɂ̂𑗐Mobt@ɓ
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _setSendData(u8* pSendBuff)
{
    int i;
    int mcSize = CommGetServiceMaxChildSendByte(CommMPGetServiceNo());
    int machineMax = CommLocalGetServiceMaxEntry(CommMPGetServiceNo())+1;
    if(_pComm->bNextSendData == FALSE){  // őꍇ
        pSendBuff[0] = _SEND_NONE;
    }
    else{
        pSendBuff[0] = _SEND_NEXT;  // őȂꍇ
    }
    if(_transmissonType() == _MP_MODE){  // DS̓pbg𑗂BIT̂őȂ
        _padDataSend(pSendBuff);  // pbhf[^𑗐M
    }
    _pComm->bNextSendData = FALSE;
    if(CommQueueIsEmpty(&_pComm->sendQueueMgr) && (_transmissonType() == _MP_MODE)){
        pSendBuff[0] |= _SEND_NO_DATA;  // ۂȂ牽Ȃ
    }
    else{
        SEND_BUFF_DATA buffData;
        buffData.size = mcSize - 1;
        buffData.pData = &pSendBuff[1];
        if(!CommQueueGetData(&_pComm->sendQueueMgr, &buffData, TRUE)){
            _pComm->bNextSendData = TRUE;
        }
    }
#if 0
    if(CommGetCurrentID()==0){
        DEBUG_DUMP(pSendBuff,mcSize,"_setSendData");
    }
#endif
}

//==============================================================================
/**
 * ML[ɂ̂𑗐Mobt@ɓ T[o[MPʐMp
 * @param   pSendBuff 鑗Mobt@
 * @retval  none
 */
//==============================================================================

static void _setSendDataServer(u8* pSendBuff)
{
    int i;

    pSendBuff[0] = _MP_DATA_HEADER;
    if(_pComm->bNextSendDataServer == FALSE){  // őꍇ
        pSendBuff[1] = _SEND_NONE;
    }
    else{
        pSendBuff[1] = _SEND_NEXT;  // őȂꍇ
    }

    {
        u16 bitmap = WH_GetBitmap();
        pSendBuff[2] = bitmap >> 8;
        pSendBuff[3] = bitmap & 0xff;


        {
            SEND_BUFF_DATA buffData;
            buffData.size = _SEND_BUFF_SIZE_PARENT - 5;
            buffData.pData = &pSendBuff[5];
            if(CommQueueGetData(&_pComm->sendQueueMgrServer, &buffData, !_pComm->bNextSendDataServer)){
                _pComm->bNextSendDataServer = FALSE;
                pSendBuff[4] = (_SEND_BUFF_SIZE_PARENT - 5) - buffData.size;
            }
            else{
                _pComm->bNextSendDataServer = TRUE;
                pSendBuff[4] = _SEND_BUFF_SIZE_PARENT - 5;
            }
        }
    }
#if 0
    DEBUG_DUMP(pSendBuff, _SEND_BUFF_SIZE_PARENT, "MP SERVER SEND");
#endif
}


//==============================================================================
/**
 * q@M\bh  傫TCỸf[^𑗐M
 *     obNAbvȂ̂ data̒gƁA
 *     ̂𑗂Ă܂\
 * @param   command    comm_sharing.hɒ`x
 * @param   data       Mf[^ ȂNULL
 * @param   byte       M    R}h̏ꍇ0
 * @retval  ML[ɓǂ
 */
//==============================================================================

BOOL CommSendHugeData(int command, const void* data, int size)
{
    if(!CommIsConnect(CommGetCurrentID()) && !CommGetAloneMode()){
        //        OHNO_PRINT("ڑĂȂđȂ\n");
        return FALSE;   // ʐMԂꍇȂ
    }
    if(CommQueuePut(&_pComm->sendQueueMgr, command, (u8*)data, size, TRUE, FALSE)){
#if _COMMAND_TEST
        OHNO_PRINT("<<<M NetId=%d -- size%d ",CommGetCurrentID(), size);
        CommCommandDebugPrint(command);
#endif
        return TRUE;
    }
    return FALSE;
}

//==============================================================================
/**
 * q@M\bh
 * e@f[^q@SɑM͕̂ʊ֐
 * @param   command    comm_sharing.hɒ`x
 * @param   data       Mf[^ ȂNULL
 * @param   byte       M    R}h̏ꍇ0
 * @retval  ML[ɓǂ
 */
//==============================================================================

BOOL CommSendData(int command, const void* data, int size)
{
    if(!CommIsConnect(CommGetCurrentID()) && !CommGetAloneMode()){
        //        OHNO_PRINT("ڑĂȂđȂ\n");
        return FALSE;   // ʐMԂꍇȂ
    }
    if(CommQueuePut(&_pComm->sendQueueMgr, command, (u8*)data, size, TRUE, TRUE)){
#if _COMMAND_TEST
        OHNO_PRINT("<<<M NetId=%d -- size%d ",CommGetCurrentID(), size);
        CommCommandDebugPrint(command);
#endif
        return TRUE;
    }
    return FALSE;
}


//==============================================================================
/**
 * e@pT[o[M\bh
 * @param   command    comm_sharing.hɒ`x
 * @param   data       Mf[^ ȂNULL
 * @param   byte       M    R}h̏ꍇ0
 * @retval  ML[ɓǂ
 */
//==============================================================================

static BOOL _data_ServerSide(int command, const void* data, int size, BOOL bCopy)
{
    if(CommGetCurrentID() != COMM_PARENT_ID){  // e@ȊO͎gȂ
        GF_ASSERT(0 && "eȊO͎gps");
        return FALSE;
    }
    if(!CommIsConnect(COMM_PARENT_ID)  && !CommGetAloneMode()){
//        OHNO_PRINT("ڑĂȂđȂ\n");
        return FALSE;   // ʐMԂꍇȂ
    }
    if(_transmissonType() == _DS_MODE){
        OHNO_PRINT("WARRNING: DSʐMԂȂ̂ɃT[o[Mgꂽ\n");
        return CommSendData(command, data, size);
    }

    if(CommQueuePut(&_pComm->sendQueueMgrServer, command, (u8*)data, size, TRUE, bCopy)){
#if _COMMAND_TEST
        OHNO_PRINT("<<SM id=%d size=%d ",CommGetCurrentID(), size);
        CommCommandDebugPrint(command);
//        DEBUG_DUMP(pSend, size, "SM");
#endif
        return TRUE;
    }
    return FALSE;
}

//==============================================================================
/**
 * e@M\bh  傫TCỸf[^𑗐M  TCYŒ
 *     obNAbvȂ̂ data̒gƁA
 *     ̂𑗂Ă܂\
 * @param   command    comm_sharing.hɒ`x
 * @param   data       Mf[^ ȂNULL
 * @param   byte       M    R}h̏ꍇ0
 * @retval  ML[ɓǂ
 */
//==============================================================================

BOOL CommSendFixHugeSizeData_ServerSide(int command, const void* data)
{
    return CommSendHugeData_ServerSide(command, data, 0);
}

//==============================================================================
/**
 * e@M\bh  傫TCỸf[^𑗐M
 *     obNAbvȂ̂ data̒gƁA
 *     ̂𑗂Ă܂\
 * @param   command    comm_sharing.hɒ`x
 * @param   data       Mf[^ ȂNULL
 * @param   byte       M    R}h̏ꍇ0
 * @retval  ML[ɓǂ
 */
//==============================================================================

BOOL CommSendHugeData_ServerSide(int command, const void* data, int size)
{
    if(CommGetCurrentID() != COMM_PARENT_ID){  // e@ȊO͎gȂ
        GF_ASSERT(0 && "eȊO͎gps");
        return FALSE;
    }
    if(!CommIsConnect(COMM_PARENT_ID)  && !CommGetAloneMode()){
//        OHNO_PRINT("ڑĂȂđȂ\n");
        return FALSE;   // ʐMԂꍇȂ
    }
    if(_transmissonType() == _DS_MODE){
        OHNO_PRINT("WARRNING: DSʐMԂȂ̂ɃT[o[Mgꂽ\n");
        return CommSendHugeData(command, data, size);
    }

    if(CommQueuePut(&_pComm->sendQueueMgrServer, command, (u8*)data, size, TRUE, FALSE)){
#if 0
        OHNO_PRINT("<<SM id=%d size=%d ",CommGetCurrentID(), size);
        CommCommandDebugPrint(command);
//        DEBUG_DUMP(pSend, size, "SM");
#endif
        return TRUE;
    }
    return FALSE;
}

//==============================================================================
/**
 * e@pT[o[M\bh
 * @param   command    comm_sharing.hɒ`x
 * @param   data       Mf[^ ȂNULL
 * @param   byte       M    R}h̏ꍇ0
 * @retval  ML[ɓǂ
 */
//==============================================================================

BOOL CommSendData_ServerSide(int command, const void* data, int size)
{
    if(CommGetCurrentID() != COMM_PARENT_ID){  // e@ȊO͎gȂ
        GF_ASSERT(0 && "eȊO͎gps");
        return FALSE;
    }
    if(!CommIsConnect(COMM_PARENT_ID)  && !CommGetAloneMode()){
//        OHNO_PRINT("ڑĂȂđȂ\n");
        return FALSE;   // ʐMԂꍇȂ
    }
    if(_transmissonType() == _DS_MODE){
        OHNO_PRINT("WARRNING: DSʐMԂȂ̂ɃT[o[Mgꂽ\n");
        return CommSendData(command, data, size);
    }

    if(CommQueuePut(&_pComm->sendQueueMgrServer, command, (u8*)data, size, TRUE, TRUE)){
#if _COMMAND_TEST
        OHNO_PRINT("<<SM id=%d size=%d ",CommGetCurrentID(), size);
        CommCommandDebugPrint(command);
//        DEBUG_DUMP(pSend, size, "SM");
#endif
        return TRUE;
    }
    return FALSE;
}

//==============================================================================
/**
 * e@pT[o[M\bh TCYŒ
 * @param   command    comm_sharing.hɒ`x
 * @param   data       Mf[^ ȂNULL
 * @param   byte       M    R}h̏ꍇ0
 * @retval  ML[ɓǂ
 */
//==============================================================================

BOOL CommSendFixSizeData_ServerSide(int command, const void* data)
{
    return CommSendData_ServerSide(command, data, 0);
}

//==============================================================================
/**
 * Mobt@ce
 * @retval  TCY
 */
//==============================================================================

int CommGetSendRestSize(void)
{
    return CommRingDataRestSize(&_pComm->sendRing);
}

//==============================================================================
/**
 * T[ȏMobt@ce
 * @retval  TCY
 */
//==============================================================================

int CommGetSendRestSize_ServerSide(void)
{
    return CommRingDataRestSize(&_pComm->sendServerRing);
}

//==============================================================================
/**
 * Mf[^̒قR}hT
 * @param   pRing Oobt@
 * @param   chkCommand  R}h
 * @param   retSize   R}h̃TCYԂ߂̃|C^
 * @param   data      f[^邽߂̃|C^
 * @param   pTemp     ̂߂ɕKvȃe|[obt@
 * @retval  ꂽTRUE
 */
//==============================================================================

static BOOL _getRecvDataSingle(RingBuffWork* pRing,
                               int chkCommand, int* retSize, u8* data, u8* pTemp)
{
    BOOL ret = FALSE;
    int size;
    u8 command;

    CommRingStartPop(pRing);  // X^[gʒu߂
    while( CommRingDataSize(pRing) != 0 ){
        command = CommRingGetByte(pRing);
        if(command == CS_NONE){
            continue;
        }
        size = CommCommandGetPacketSize(command);
        if(COMM_VARIABLE_SIZE == size){
            if( CommRingDataSize(pRing) < 1 ){  // cf[^1
                break;
            }
            size = (int)CommRingGetByte(pRing) * 0x100;
            size += (int)CommRingGetByte(pRing);
            OHNO_PRINT("MTCY  %d\n",size);
        }
        if( CommRingDataSize(pRing) >= size ){
            CommRingGets(pRing, pTemp, size);
        }
        else{
            break;
        }
        if(chkCommand == command){
            if(retSize != NULL){
                *retSize = size;
            }
            if(data != NULL){
                MI_CpuCopy8(pTemp, data,  size);
            }
            ret = TRUE;
            break;
        }
    }
    return ret;
}



//==============================================================================
/**
 * Mf[^vZXɏ
 * @param   pRing  Oobt@̃|C^
 * @param   netID     ĂnetID
 * @param   pTemp    R}h邽߂tempobt@
 * @retval  none
 */
//==============================================================================

static void _recvDataFuncSingle(RingBuffWork* pRing, int netID, u8* pTemp, BOOL bDebug)
{
    int size;
    u8 command;
    int bkPos;
    int realbyte;

    while( CommRingDataSize(pRing) != 0 ){
        bkPos = pRing->startPos;
        command = CommRingGetByte(pRing);
        if(command == CS_NONE){
            continue;
        }
        if(bDebug){
            OHNO_PRINT(">>>MbkPOS %d %d %d\n", bkPos, CommRingDataSize(pRing), command);
        }
        size = CommCommandGetPacketSize(command);
        if(COMM_VARIABLE_SIZE == size){
            if( CommRingDataSize(pRing) < 1 ){  // cf[^1ȉ
                pRing->startPos = bkPos;
                break;
            }
            // TCYȂʐMf[^͂ɃTCYĂ
            size = CommRingGetByte(pRing)*0x100;
            size += CommRingGetByte(pRing);
            OHNO_PRINT("MTCY  %d\n",size);
        }
        if( CommRingDataSize(pRing) >= size ){
            if(bDebug){
                OHNO_PRINT(">>>M comm=%d id=%d -- size%d \n",command, netID, size);
            }
            CommRingGets(pRing, pTemp, size);
            CommCommandCallBack(netID, command, size, (void*)pTemp);
        }
        else{   // ܂͂ĂȂ傫f[^̏ꍇʂ
//            OHNO_PRINT("҂ command %d size %d\n",command,size);
            pRing->startPos = bkPos;
            break;
        }
    }
}

//==============================================================================
/**
 * Mf[^vZXɏ
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _recvDataFunc(void)
{
    int id = COMM_PARENT_ID;
    int size;
    u8 command;
    int bkPos;

    if(!_pComm){
        return;
    }

    if(CommRingDataSize(&_pComm->recvRing) > 0){
        // ÖʒuϐɕۑĂ
        MI_CpuCopy8( &_pComm->recvRing,&_pComm->recvRingUndo, sizeof(RingBuffWork));
        CommRingStartPush(&_pComm->recvRingUndo); //startʒuۑ
#if 0
        OHNO_PRINT("-͊Jn %d %d-%d\n",id,
                   _pComm->recvRing.startPos,_pComm->recvRing.endPos);
#endif
        _recvDataFuncSingle(&_pComm->recvRing, id, _pComm->pTmpBuff, FALSE);
#if 0
        OHNO_PRINT(" %d %d-%d\n",id,
                   _pComm->recvRing.startPos,_pComm->recvRing.endPos);
#endif
    }
}

//==============================================================================
/**
 * Mf[^vZXɏ
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _recvDataServerFunc(void)
{
    int id;
    int size;
    u8 command;
    int machineMax;

    if(!_pComm){
        return;
    }
    machineMax = CommLocalGetServiceMaxEntry(CommMPGetServiceNo())+1;
    for(id = 0; id < machineMax; id++){
        if(CommRingDataSize(&_pComm->recvServerRing[id]) > 0){
#if 0
            OHNO_PRINT("͊Jn %d %d-%d\n",id,
                       _pComm->recvServerRing[id].startPos,_pComm->recvServerRing[id].endPos);
#endif
#if 0
            OHNO_PRINT("e@q@%d\n",id);
#endif
#if _COMMAND_TEST
    //        OHNO_PRINT("DS %d\n",id);
#endif
            // ÖʒuϐɕۑĂ
            MI_CpuCopy8(&_pComm->recvServerRing[id],
                        &_pComm->recvServerRingUndo[id],
                        sizeof(RingBuffWork));
            CommRingStartPush(&_pComm->recvServerRingUndo[id]); //startʒuۑ
            _recvDataFuncSingle(&_pComm->recvServerRing[id], id, _pComm->pTmpBuff, FALSE);
        }
    }
}

//==============================================================================
/**
 * f[^ĂmFB
 * @param   netID       e@_PARENT_INDEX@͎q@
 * @param   command     ̃f[^Ă̂ǂח
 * @param   retSsize    Ăf[^̃TCY
 * @param   data        Ăf[^
 * @retval  R}h̃f[^݂TRUE
 */
//==============================================================================
BOOL CommRecvData(int netID,int chkCommand, int* retSize, u8* data)
{
    if(FALSE == CommIsConnect(netID)){
        return FALSE;
    }
    if(_transmissonType() == _DS_MODE){
        return CommGetRecvData_ServerSide(netID,chkCommand,retSize,data);
    }
    return _getRecvDataSingle(&_pComm->recvRingUndo,
                              chkCommand, retSize, data, _pComm->pTmpBuff);
}

//==============================================================================
/**
 * f[^ĂmFBT[o[p
 * @param   netID       machine index
 * @param   command     ̃f[^Ă̂ǂח
 * @param   retSsize    Ăf[^̃TCY
 * @param   data        Ăf[^
 * @retval  R}h̃f[^݂TRUE
 */
//==============================================================================
BOOL CommGetRecvData_ServerSide(int netID,int chkCommand, int* retSize, u8* data)
{
    if(FALSE == CommIsConnect(netID)){
        return FALSE;
    }
    return _getRecvDataSingle(&_pComm->recvServerRingUndo[netID],
                              chkCommand, retSize, data, _pComm->pTmpBuff);
}

//==============================================================================
/**
 * ʐM\ԂȂ̂ǂԂ R}hɂlSVG[V܂̏
 * @param   eq@netID
 * @retval  TRUE  ʐM\    FALSE ʐMؒf
 */
//==============================================================================
BOOL CommIsConnect(u16 netID)
{
    if(!CommIsInitialize()){
        return FALSE;
    }
    if (WH_GetSystemState() != WH_SYSSTATE_CONNECTED) {
        return FALSE;
    }
    if(CommGetCurrentID()==netID){// ONLINE
        return TRUE;
    }
    else if(CommGetCurrentID()==COMM_PARENT_ID){  // e@̂ݎq@LIBœ
        u16 bitmap = WH_GetBitmap();
        if( bitmap & (1<<netID)){
            return TRUE;
        }
    }
    else if(_pComm){
        if(_pComm->bitmap & (1<<netID)){
            return TRUE;
        }
    }
    return FALSE;
}

//==============================================================================
/**
 * ʐM\Ԃ̐lԂ
 * @param   none
 * @retval  ڑl
 */
//==============================================================================
int CommGetConnectNum(void)
{
    int num = 0,i;

    for(i = 0; i < COMM_MACHINE_MAX; i++){
        if(CommIsConnect(i)){
            num++;
        }
    }
    return num;
}

//==============================================================================
/**
 * Ă邩ǂԂ
 * @param   none
 * @retval  IĂTRUE
 */
//==============================================================================
BOOL CommIsInitialize(void)
{
    return CommMPIsInitialize();
}



//==============================================================================
/**
 * pbhgK[Ԃ
 * @param   netID     lbgID
 * @retval  key trg
 */
//==============================================================================
u16 CommGetPadTrg(int netID)
{
    if(!_pComm){
        return 0;
    }
    return _pComm->trg[netID];
}

//==============================================================================
/**
 * pbhRg[Ԃ
 * @param   netID     lbgID
 * @retval  key cond
 */
//==============================================================================
u16 CommGetPadCont(int netID)
{
    if(!_pComm){
        return 0;
    }
    return _pComm->cont[netID];
}

//==============================================================================
/**
 * pbh𑗐M\ɂ
 * @param   netID     lbgID
 * @retval  key cond
 */
//==============================================================================
void CommEnableSendMoveData(void)
{
    if(_pComm){
        _pComm->sendCont |= 0x8000;
    }
}

//==============================================================================
/**
 * pbh𑗐Msɂ
 * @param   netID     lbgID
 * @retval  key cond
 */
//==============================================================================
void CommDisableSendMoveData(void)
{
    if(_pComm){
        OHNO_PRINT("L[𑗐Ms\n");
        _pComm->sendCont = 0;
    }
}

//==============================================================================
/**
 * T[o[q@ɑꍇ ML[ւ̒ǉ
 * @param   command    comm_sharing.hɒ`x
 * @param   sendNetID
 * @param   data       Mf[^ ȂNULL
 *                     ̃f[^͐ÓIłȂ΂ȂȂ  obt@ɗ߂Ȃ
 * @param   byte       M    R}h̏ꍇ0
 * @retval  ML[ɓǂ
 */
//==============================================================================

BOOL CommSetSendQueue_ServerSide(int command, const void* data, int size)
{
    if(_transmissonType() == _DS_MODE){
        return CommQueuePut(&_pComm->sendQueueMgr, command, (u8*)data, size, FALSE, FALSE);
    }
    else{
        return CommQueuePut(&_pComm->sendQueueMgrServer, command, (u8*)data, size, FALSE, FALSE);
    }
}

//==============================================================================
/**
 * NCAge@ɑꍇ ML[ւ̒ǉ
 * @param   command    comm_sharing.hɒ`x
 * @param   data       Mf[^ ȂNULL
 *                     ̃f[^͐ÓIłȂ΂ȂȂ  obt@ɗ߂Ȃ
 * @param   byte       M    R}h̏ꍇ0
 * @retval  ML[ɓǂ
 */
//==============================================================================

BOOL CommSetSendQueue(int command, const void* data, int size)
{
    return CommQueuePut(&_pComm->sendQueueMgr, command, (u8*)data, size, FALSE, FALSE);
}


//==============================================================================
/**
 * T[o[̃L[̎c萔Ԃ
 * @param   none
 * @retval  c萔
 */
//==============================================================================

int CommGetRestQueueNum(void)
{
    u32 addr;

    return 300;
}

//==============================================================================
/**
 * DSʐMMPʐM̐؂ւ
 * @param   none
 * @retval  c萔
 */
//==============================================================================

void CommRecvDSMPChange(int netID, int size, void* pData, void* pWork)
{
    u8* pBuff = pData;
    int i;

    if(CommGetCurrentID() != COMM_PARENT_ID){
        return;
    }
    OHNO_PRINT("CommRecvDSMPChange M\n");
    // Sɐ؂ւM𑗂
    if(_transmissonType() == _DS_MODE){
        CommSendFixSizeData(CS_DSMP_CHANGE_REQ,pData);
    }
    else{
        CommSendData_ServerSide(CS_DSMP_CHANGE_REQ, pData, size);
    }
}

//==============================================================================
/**
 * DSʐMMPʐM̐؂ւ
 * @param   none
 * @retval  c萔
 */
//==============================================================================

void CommRecvDSMPChangeReq(int netID, int size, void* pData, void* pWork)
{
    u8* pBuff = pData;
    int i;

    OHNO_PRINT("CommRecvDSMPChangeReq M\n");
    _commSetTransmissonType(pBuff[0]);  // ؂ւ  e@͂Ő؂ւȂ
    CommSendFixSizeData(CS_DSMP_CHANGE_END,pData);
}

//==============================================================================
/**
 * DSʐMMPʐM̐؂ւ I
 * @param   none
 * @retval  c萔
 */
//==============================================================================

void CommRecvDSMPChangeEnd(int netID, int size, void* pData, void* pWork)
{
    u8* pBuff = pData;
    int i;

    if(CommGetCurrentID() != COMM_PARENT_ID){
        return;
    }
    OHNO_PRINT("CommRecvDSMPChangeEND M\n");
    _commSetTransmissonType(pBuff[0]);  // ؂ւ
}

//==============================================================================
/**
 * ̋@IDԂ
 * @param   
 * @retval  ̋@ID  ȂĂȂꍇCOMM_PARENT_ID
 */
//==============================================================================

u16 CommGetCurrentID(void)
{
    if(_pComm){
        if(CommGetAloneMode()){
            return COMM_PARENT_ID;
        }
        return WH_GetCurrentAid();
    }
    return COMM_PARENT_ID;
}

//==============================================================================
/**
 * ėpM\bh  MTCYŒł傫ꍇ
 * @param   command    comm_sharing.hɒ`x
 * @param   data       Mf[^ ȂNULL
 * @retval  ML[ɓǂ
 */
//==============================================================================

BOOL CommSendFixHugeSizeData(int command, const void* data)
{
    return CommSendHugeData(command, data, 0);
}

//==============================================================================
/**
 * ėpM\bh  MTCYŒ̏ꍇ
 * @param   command    comm_sharing.hɒ`x
 * @param   data       Mf[^ ȂNULL
 * @retval  ML[ɓǂ
 */
//==============================================================================

BOOL CommSendFixSizeData(int command, const void* data)
{
    return CommSendData(command, data, 0);
}

//==============================================================================
/**
 * ėpM\bh  R}hȊO݂Ȃꍇ
 * @param   command    comm_sharing.hɒ`x
 * @retval  ML[ɓǂ
 */
//==============================================================================

BOOL CommSendFixData(int command)
{
    return CommSendData(command, NULL, 0);
}

//==============================================================================
/**
 * WHCuŁ@ʐMԂBITmF
 * @param   none
 * @retval  ڑ킩BITz
 */
//==============================================================================

BOOL CommIsChildsConnecting(void)
{
    return CommMPIsChildsConnecting();
}

//==============================================================================
/**
 * G[Ԃǂ
 * @param   none
 * @retval  G[̎TRUE
 */
//==============================================================================

BOOL CommIsError(void)
{
    if(CommGetAloneMode()){  // l[h̏ꍇ̓G[ɂȂ
        return FALSE;
    }
    return CommMPIsError();
}

//==============================================================================
/**
 * T[rXԍɑΉq@Mbyte𓾂܂
 * T[rXԍ include/communication/comm_def.hɂ܂
 * @param   serviceNo T[rXԍ
 * @retval  q@䐔
 */
//==============================================================================

u16 CommGetServiceMaxChildSendByte(u16 serviceNo)
{
    if(CommLocalGetServiceMaxEntry(serviceNo) >= COMM_WIDE_BYTE_SEND_CHILDNUM){
        return _SEND_BUFF_SIZE_CHILD;
    }
    if(_transmissonType() == _MP_MODE){
        return _SEND_BUFF_SIZE_CHILD;
    }
    return _SEND_BUFF_SIZE_4CHILD;
}

//==============================================================================
/**
 * őڑl𓾂
 * @param   none
 * @retval  őڑl
 */
//==============================================================================

int CommGetMaxEntry(int service)
{
    return CommLocalGetServiceMaxEntry(service)+1;
}

//==============================================================================
/**
 * ŏڑl𓾂
 * @param   none
 * @retval  ŏڑl
 */
//==============================================================================

int CommGetMinEntry(int service)
{
    return CommLocalGetServiceMinEntry(service)+1;
}

//==============================================================================
/**
 * DSpMf[^̓Ce[^[ 
 * @param   netID   DS@BID
 * @retval  none
 */
//==============================================================================

void CommRecvDSIteratorInitialize(int netID)
{
    if(!CommIsConnect(netID)){
        return;
    }
    CommRingStartPop(&_pComm->recvServerRingUndo[netID]);

}

//==============================================================================
/**
 * DSpMf[^̓Ce[^[ f[^邩ǂ
 * @param   netID   DS@BID
 * @retval  TRUEȂ΃f[^݂
 */
//==============================================================================

BOOL CommRecvDSIteratorHasNext(int netID)
{
    return (CommRingDataSize(&_pComm->recvServerRingUndo[netID]) != 0);
}

//==============================================================================
/**
 * DSpMf[^̓Ce[^[ f[^oɐi
 * @param   netID   DS@BID
 * @param   *pCommand  ʐMR}h=enumtableԍԂĂ܂
 * @param   *pSize     TCYԂĂ܂
 * @param   *pData     Mf[^ԂĂ܂
 * @retval  TRUEȂ΃f[^݂ FALSȄꍇ̓f[^r܂łȂ
 */
//==============================================================================

BOOL CommRecvDSIteratorNext(int netID,int *pCommand, int* pSize, u8* pData)
{
    RingBuffWork* pRing = &_pComm->recvServerRingUndo[netID];

    *pCommand = CommRingGetByte(pRing);
    if(CS_NONE == *pCommand){
        return TRUE;
    }
    *pSize = CommCommandGetPacketSize(*pCommand);
    if(*pSize == 0){
        return TRUE;
    }
    else if(COMM_VARIABLE_SIZE == *pSize){
        if( CommRingDataSize(pRing) < 1 ){  // cf[^1ȉ
            return FALSE;
        }
        *pSize = (int)CommRingGetByte(pRing)*0x100;
        *pSize += (int)CommRingGetByte(pRing);
    }
    if( CommRingDataSize(pRing) >= *pSize ){
        CommRingGets(pRing, pData, *pSize);
        return TRUE;
    }
    return FALSE;
}

//==============================================================================
/**
 * lʐM[hݒ
 * @param   bAlone    lʐM[h
 * @retval  none
 */
//==============================================================================

void CommSetAloneMode(BOOL bAlone)
{
    if(_pComm){
        _pComm->bAlone = bAlone;
    }
}

//==============================================================================
/**
 * lʐM[hǂ擾
 * @param   none
 * @retval  lʐM[h̏ꍇTRUE
 */
//==============================================================================

BOOL CommGetAloneMode(void)
{
    if(_pComm){
        return _pComm->bAlone;
    }
    return FALSE;
}

//==============================================================================
/**
 * IR}hM
 * @param   callbackp
 * @retval  none
 */
//==============================================================================

void CommRecvAutoExit(int netID, int size, void* pData, void* pWork)
{
    u8 dummy;

    OHNO_PRINT("CommRecvAutoExit M \n");
    if(CommGetCurrentID() == COMM_PARENT_ID){   // ȅꍇ݂ȂɋtԐM
        CommSendFixSizeData_ServerSide(CS_AUTO_EXIT, &dummy);
    }
    CommMPSetAutoExit();
}

#if PM_DEBUG

//==============================================================================
/**
 * fobOpɃ_v\
 * @param   adr           \AhX
 * @param   length        
 * @param   pInfoStr      \bZ[W
 * @retval  T[rXԍ
 */
//==============================================================================

void CommDump_Debug(u8* adr, int length, char* pInfoStr)
{
    int i,j = 0;

    OHNO_PRINT("%s \n",pInfoStr);
    while(1){
        OHNO_PRINT(">> ");
        for(i = 0 ; i < 8 ; i++){
            OHNO_PRINT("%2x ",adr[j]);
            j++;
            if(j == length){
                OHNO_PRINT(" --end\n");
                return;
            }
        }
        OHNO_PRINT("\n");
    }
}

//==============================================================================
/**
 * fobOI[gړ؂ւ
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommSwitchAutoMove_Debug(void)
{
    _pComm->DebugAutoMove =
        (_pComm->DebugAutoMove) ? 0 : 1;
}

//==============================================================================
/**
 * fobOI[gړ
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _debugAutoMove(void)
{
    if(_pComm->DebugAutoMove){
        _pComm->DebugAutoMove++;
        if(_pComm->DebugAutoMove==0){
            _pComm->DebugAutoMove++;
        }
        if(_pComm->DebugAutoMove & 0x08){
            _pComm->sendCont |= (PAD_KEY_LEFT | PAD_BUTTON_Y); //_bVړ
        }
        else{
            _pComm->sendCont |= (PAD_KEY_RIGHT | PAD_BUTTON_Y); //_bVړ
        }
    }
}


//==============================================================================
/**
 * fobOʐMʕ\
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _debugDispRecvQuantity(void)
{
    int i;

    if(!_pComm){
        return;
    }
    _delayCount++;
    if(_delayCount <= 2){
        return;
    }
    if(CommGetCurrentID() == COMM_PARENT_ID){
        if(_DS_MODE == _transmissonType()){
            OHNO_PRINT("PDD %d >",_delayCount);
            for(i = 0;i < COMM_MACHINE_MAX;i++){
                OHNO_PRINT(" %d",CommRingDataSize(&_pComm->recvMidRing[i]));
            }
            OHNO_PRINT("\n");
        }
        else{
            OHNO_PRINT("PDM %d >",_delayCount);
            for(i = 0;i < COMM_MACHINE_MAX;i++){
                OHNO_PRINT(" %d",CommRingDataSize(&_pComm->recvServerRing[i]));
            }
            OHNO_PRINT("\n");
        }
    }
    else{
        if(_DS_MODE == _transmissonType()){
            OHNO_PRINT("CDD %d >",_delayCount);
            for(i = 0;i < COMM_MACHINE_MAX;i++){
                OHNO_PRINT(" %d",CommRingDataSize(&_pComm->recvServerRing[i]));
            }
            OHNO_PRINT("\n");
        }
        else{
            OHNO_PRINT("CDM %d >",_delayCount);
            OHNO_PRINT(" %d",CommRingDataSize(&_pComm->recvRing));
            OHNO_PRINT("\n");
        }
    }
}

#endif

//==============================================================================
/**
 * WEP Key ̎p̗@̏
 * @param   pRand  Ǘ\
 * @retval  none
 */
//==============================================================================

void CommRandSeedInitialize(MATHRandContext32* pRand)
{
    u64 randSeed = 0;
    RTCDate date;
    RTCTime time;
    
    GF_RTC_GetDateTime(&date, &time);
    randSeed = (((((((u64)date.year * 16ULL + date.month) * 32ULL)
                   + date.day) * 32ULL + time.hour) * 64ULL + time.minute)
                * 64ULL + (time.second + sys.vsync_counter));
    MATH_InitRand32(pRand, randSeed);
}


//==============================================================================
/**
 * ̃R}h𑗐MIǂ𒲂ׂ T[o
 * @param   command ׂR}h
 * @retval  R}h݂TRUE
 */
//==============================================================================


BOOL CommIsSendCommand_ServerSize(int command)
{
    return CommQueueIsCommand(&_pComm->sendQueueMgrServer, command);

}


//==============================================================================
/**
 * ̃R}h𑗐MIǂ𒲂ׂ NCAg
 * @param   command ׂR}h
 * @retval  R}h݂TRUE
 */
//==============================================================================


BOOL CommIsSendCommand(int command)
{
    return CommQueueIsCommand(&_pComm->sendQueueMgr, command);

}


//==============================================================================
/**
 * L[ۂǂ
 * @param   none
 * @retval  R}h݂FALSE
 */
//==============================================================================

BOOL CommIsEmptyQueue_ServerSize(void)
{
    return CommQueueIsEmpty(&_pComm->sendQueueMgrServer);

}

//==============================================================================
/**
 * L[ۂǂ
 * @param   none
 * @retval  R}h݂FALSE
 */
//==============================================================================

BOOL CommIsEmptyQueue(void)
{
    return CommQueueIsEmpty(&_pComm->sendQueueMgr);

}

//==============================================================================
/**
 * 퓬ɓO̓G̗ʒuݒ
 * @param   no   Ăʒu̔ԍɒ
 * @param   netID   ʐMID
 * @retval  none
 */
//==============================================================================
void CommSetStandNo(int no,int netID)
{
    if(_pComm){
        _pComm->standNo[netID] = no;
        OHNO_PRINT("ʒu %d\n",no);
    }
}

//==============================================================================
/**
 * 퓬ɓO̓G̗ʒu𓾂
 * @param   netID ʐMID
 * @retval  Ăʒu̔ԍɒ  0-3  0,2 vs 1,3
 */
//==============================================================================
int CommGetStandNo(int netID)
{
    if(_pComm){
        if(_pComm->standNo[netID] != 0xff){
            return _pComm->standNo[netID];
        }
    }
    return netID;
}

