//=============================================================================
/**
 * @file	comm_tool.c
 * @brief	ʐMgėp֐
 * @author	Katsumi Ohno
 * @date    2006.03.14
 */
//=============================================================================

#include "common.h"
#include "communication/communication.h"


//@f[^̂PpPbg
#define _SPRIT_COMM_PACKET_SIZE (250)

//==============================================================================
// static錾
//==============================================================================

typedef struct _COMM_TOOL_WORK_t COMM_TOOL_WORK;


typedef struct{
    u8 no;
    u8 listNo;
}_ListResult;

typedef struct _COMM_TOOL_WORK_t{
    // Xg
    _ListResult listNo[COMM_MACHINE_MAX];     // R}hp
    // 
    u8 timingSync[COMM_MACHINE_MAX];     // R}hp
    u8 timingSyncEnd;     // R}hp
    //------------------  f[^pobt@
    u8 spritTempBuff[_SPRIT_COMM_PACKET_SIZE+1];
    u8* pSpritRecvBuff[COMM_MACHINE_MAX];
    int spritDataRecvSize[COMM_MACHINE_MAX];
    u8* pSpritSendBuff;
    int spritDataSendCount;
};

static COMM_TOOL_WORK* _pCT = NULL;  ///<@[N\̂̃|C^


//==============================================================================
/**
 * 
 * @param   callbackp
 * @retval  none
 */
//==============================================================================

void CommToolInitialize(int heapID)
{
    int i;
    
    if(!_pCT){
        _pCT = sys_AllocMemory(heapID,sizeof(COMM_TOOL_WORK));
        MI_CpuFill8(_pCT,0,sizeof(COMM_TOOL_WORK));
    }


    for(i = 0; i< COMM_MACHINE_MAX;i++){
        _pCT->timingSync[i]=0xff;     // R}hp
    }
    _pCT->timingSyncEnd=0xff;     // R}hp

}

//==============================================================================
/**
 * J
 * @param   callbackp
 * @retval  none
 */
//==============================================================================

void CommToolFinalize(void)
{
    sys_FreeMemoryEz(_pCT);
    _pCT = NULL;
}


//==============================================================================
/**
 * ^C~OR}hM   CS_TIMING_SYNC
 * @param   callbackp
 * @retval  none
 */
//==============================================================================

void CommRecvTimingSync(int netID, int size, void* pData, void* pWork)
{
    u8* pBuff = pData;
    u8 syncNo = pBuff[0];
    int i;

    if(CommGetCurrentID() == COMM_PARENT_ID){
        _pCT->timingSync[netID] = syncNo;     // R}hp
        for(i = 0; i < COMM_MACHINE_MAX; i++){
            if(CommIsConnect(i)){
                if(syncNo != _pCT->timingSync[i]){
                    // ĂȂ
                    return;
                }
            }
        }
        
        CommSendFixSizeData_ServerSide(CS_TIMING_SYNC_END, &syncNo);
    }
}

//==============================================================================
/**
 * ^C~OR}hENDM   CS_TIMING_SYNC_END
 * @param   callbackp
 * @retval  none
 */
//==============================================================================

void CommRecvTimingSyncEnd(int netID, int size, void* pData, void* pWork)
{
    u8* pBuff = pData;
    u8 syncNo = pBuff[0];

    _pCT->timingSyncEnd = syncNo;     // R}hp
}

//==============================================================================
/**
 * ^C~OR}h𔭍s
 * @param   no   ^C~O肽ԍ
 * @retval  none
 */
//==============================================================================

void CommTimingSyncStart(u8 no)
{
    CommSendFixSizeData(CS_TIMING_SYNC, &no);
}

//==============================================================================
/**
 * ^C~OR}h͂ǂmF
 * @param   no   ͂ԍ
 * @retval  ͂ĂTRUE
 */
//==============================================================================

BOOL CommIsTimingSync(u8 no)
{
    if(_pCT->timingSyncEnd == no){
        return TRUE;
    }
    return FALSE;
}

//==============================================================================
/**
 * SPRITf[^M
 * @param   no   ͂ԍ
 * @retval  ͂ĂTRUE
 */
//==============================================================================

void CommSpritDataSendFunc(void)
{
    u8 buff[_SPRIT_COMM_PACKET_SIZE+1];

    if(_pCT->pSpritSendBuff==NULL){
        return;
    }
    if(!CommIsSendCommand(CS_SPRIT_DATA)){
        _pCT->spritDataSendCount--;
        MI_CpuCopy8(&_pCT->pSpritSendBuff[_SPRIT_COMM_PACKET_SIZE*_pCT->spritDataSendCount] ,
                    &_pCT->spritTempBuff[1],
                    _SPRIT_COMM_PACKET_SIZE);
        _pCT->spritTempBuff[0] = _pCT->spritDataSendCount;
        CommSendFixSizeData(CS_SPRIT_DATA,_pCT->spritTempBuff);
        if(_pCT->spritDataSendCount){
            _pCT->pSpritSendBuff = NULL;
        }
    }
}

//==============================================================================
/**
 * SPRITf[^̃R[obN
 * @param   no   ͂ԍ
 * @retval  ͂ĂTRUE
 */
//==============================================================================

void CommRecvSpritData(int netID, int size, void* pData, void* pWork)
{
    u8* pBuff = pData;
    u8 pos = pBuff[0];

    if(_pCT->pSpritRecvBuff[netID] != NULL){
        int csize,i = pos;
        i = i * _SPRIT_COMM_PACKET_SIZE;
        csize = _SPRIT_COMM_PACKET_SIZE;
        if((i+csize) > _pCT->spritDataRecvSize[netID]){
            csize = _pCT->spritDataRecvSize[netID] - i;
        }
        MI_CpuCopy8(&pBuff[1],_pCT->pSpritRecvBuff[i], csize);
        if(pos == 0){
            _pCT->spritDataRecvSize[netID] = 0;
        }
    }
}

//==============================================================================
/**
 * SPRITf[^̂PpPbgTCY
 * @param   no   ͂ԍ
 * @retval  ͂ĂTRUE
 */
//==============================================================================

int CommGetSpritDataPacketSize(void)
{
    return _SPRIT_COMM_PACKET_SIZE + 1;
}

//==============================================================================
/**
 * SPRITf[^󂯎ǂmF
 * @param   netID      󂯎\̐lID
 * @retval  󂯎TRUE
 */
//==============================================================================

BOOL CommIsSpritDataRecv(int netID)
{
    if(_pCT->spritDataRecvSize[netID]==0){
        return TRUE;
    }
    return FALSE;
}

//==============================================================================
/**
 * SPRITf[^󂯎obt@ZbgiMj
 * @param   recvNetID   ǂ̐l̃f[^҂󂯂̂
 * @param   pBuff       Mobt@
 * @retval  none
 */
//==============================================================================

void CommSetSpritDataRecvBuff(int recvNetID,void* pBuff,int size)
{
    GF_ASSERT((size > 1024) && "CommSendHugeDatag");
    _pCT->pSpritRecvBuff[recvNetID] = pBuff;
    _pCT->spritDataRecvSize[recvNetID] = size;
}

//==============================================================================
/**
 * HUGEf[^󂯎obt@ZbgiMj
 * @param   recvNetID   ǂ̐l̃f[^҂󂯂̂
 * @param   pBuff       Mobt@
 * @retval  none
 */
//==============================================================================

void CommSendSpritData(void* pBuff,int size)
{
    GF_ASSERT((size > 1024) && "CommSendHugeDatag");

    _pCT->pSpritSendBuff = pBuff;
    _pCT->spritDataSendCount = (size / _SPRIT_COMM_PACKET_SIZE);
    if(size % _SPRIT_COMM_PACKET_SIZE){
        _pCT->spritDataSendCount + 1;
    }
}

//------------------------------------------------------
/**
 * @brief   IʂM֐
 * @param   R[obN
 * @retval  none
 */
//------------------------------------------------------

void CommRecvListNo(int netID, int size, void* pData, void* pWork)
{
    _ListResult* pRet = pData;

    _pCT->listNo[netID].no = pRet->no;
    _pCT->listNo[netID].listNo = pRet->listNo;
}

//------------------------------------------------------
/**
 * @brief   IʂʐMR}hTCY
 * @param   no        Ij[Nԍ
 * @param   listNo    I  0-255
 * @retval  none
 */
//------------------------------------------------------

int CommGetListNoSize(void)
{
    return sizeof(_ListResult);
}

//------------------------------------------------------
/**
 * @brief   IʂʐM
 * @param   no        Ij[Nԍ
 * @param   listNo    I  0-255
 * @retval  none
 */
//------------------------------------------------------

void CommListSet(u8 no,u8 listNo)
{
    _ListResult ret;

    ret.no = no;
    ret.listNo = listNo;
    CommSendFixSizeData(CS_LIST_NO,&ret);
}

//------------------------------------------------------
/**
 * @brief   Iʂ󂯎
 * @param   recvNetID   ǂ̐l̃f[^҂󂯂̂
 * @param   pBuff       Mobt@
 * @retval  I  -1
 */
//------------------------------------------------------

int CommListGet(int netID, u8 no)
{
    if(_pCT->listNo[netID].no == no){
        return _pCT->listNo[netID].listNo;
    }
    return INVALID_LIST_NO;
}


//------------------------------------------------------
/**
 * @brief   Iʂ
 * @param   none
 * @retval  none
 */
//------------------------------------------------------

void CommListReset(void)
{
    int i;

    for(i = 0;i < COMM_MACHINE_MAX;i++){
        MI_CpuFill8(&_pCT->listNo[i],0,sizeof(_ListResult));
    }
}

