/*
  Project:  NitroSDK - wireless_shared - demos - wh
  File:     wh.c

  Copyright 2003-2005 Nintendo.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

  Revision 1.40  2005/06/27 11:10:11  yosizaki
  add comment about DC_WaitWriteBufferEmpty().

  Revision 1.39  2005/06/07 05:45:48  seiki_masashi
  Key Sharing Ɋւʏጸ邽߂̕ύX

  Revision 1.38  2005/04/26 02:35:02  terui
  Fix comment

  Revision 1.37  2005/03/25 03:05:23  seiki_masashi
  WEPKey ݒ֐ݒ肷 WH_Set{Parent,Child}WEPKeyGenerator ǉ

  Revision 1.36  2005/03/04 09:26:10  takano_makoto
  e@r[RMBtÕ`FbNǉ

  Revision 1.35  2005/03/04 09:18:56  takano_makoto
  WH_SetUserGameInfoǉ

  Revision 1.34  2005/02/28 05:26:35  yosizaki
  do-indent.

  Revision 1.33  2005/02/18 10:38:04  yosizaki
  fix around hidden warnings.

  Revision 1.32  2005/02/08 01:22:38  takano_makoto
  WH_SetReceiver̐۔̕sC

  Revision 1.31  2005/01/11 07:48:59  takano_makoto
  fix copyright header.

  Revision 1.30  2005/01/07 12:04:47  terui
  s\ȃG[ʒmMۂ̏ǉB

  Revision 1.29  2005/01/07 06:15:26  takano_makoto
  WM_StartConnect̃R[obNG[ǉ

  Revision 1.28  2004/12/22 02:48:43  terui
  sNg`bgT[`ɑΉ

  Revision 1.27  2004/12/20 08:31:27  takano_makoto
  WH_InitializegpďZk悤ɕύXB

  Revision 1.26  2004/12/20 07:17:20  takano_makoto
  WHReceiverWHReceiverFuncɕύXAOS_Allocgp̂rAAvɐݒ肷p[^wh_config.hƂĕ

  Revision 1.25  2004/12/09 08:14:00  takano_makoto
  dggp̍łႢ`lꍇɁAgp悤ɏC

  Revision 1.24  2004/11/26 02:38:09  takano_makoto
  ڑsɂWM_SYSSTATE_CONNECT_FAILɑJڂ悤ɏC

  Revision 1.23  2004/11/16 03:01:11  takano_makoto
  WH_GetCurrentAid֐ǉ

  Revision 1.22  2004/11/11 03:50:58  seiki_masashi
  q@ WM_StartDataSharing  aidBitmap C

  Revision 1.21  2004/11/10 06:13:38  takano_makoto
  WM_EndKeySharing̐WM_ERRCODE_OPERATINGɏC

  Revision 1.20  2004/11/08 02:46:17  takano_makoto
  WM_EndScan̑dĂіh~

  Revision 1.19  2004/11/05 04:27:40  sasakis
  r[ʁAe@Iʂ̒ǉƁAɕKvȉiscan֘AȂǁjB

  Revision 1.18  2004/11/02 19:36:19  takano_makoto
  WH_StartMeasureChannel, WH_EndScan̕ԂlBOOLɕύX

  Revision 1.17  2004/11/02 10:08:05  takano_makoto
  WH_FinalizȅԕύX^C~OύX

  Revision 1.16  2004/11/02 10:03:10  seiki_masashi
  XLɒfۂ̕sC

  Revision 1.15  2004/11/01 09:32:12  takano_makoto
  fobOo͂ύX

  Revision 1.14  2004/11/01 09:19:57  takano_makoto
  WHԑJڂ̌

  Revision 1.13  2004/11/01 06:28:10  seiki_masashi
  Rg̒

  Revision 1.12  2004/11/01 02:48:56  takano_makoto
  WH_StateInInitializeł̏ԕύXʒuړBWH_StateInParentMPWM_EndMPƂ΂V[PX폜B

  Revision 1.11  2004/10/29 07:27:56  takano_makoto
  ԕύXʒuύX

  Revision 1.10  2004/10/29 02:35:30  takano_makoto
  fobOo͏C
  
  Revision 1.9  2004/10/29 02:16:34  takano_makoto
  WH_StartScan̈ύX
  
  Revision 1.8  2004/10/29 02:05:28  takano_makoto
  e@Xg쐬ł悤ɁAScan֐O痘p\Ȃ悤ɕύX
  
  Revision 1.7  2004/10/28 10:38:31  terui
  e@ƂĂ̏ICB
  WM_StartConnectւ̃R[obNł̃G[`FbNCB

  Revision 1.6  2004/10/28 07:11:20  takano_makoto
  WH_Connect̊֐ύX

  Revision 1.5  2004/10/27 02:31:31  takano_makoto
  MeasureChanneln֐̓
  WM_ERRCODE_OPERATINGő҂ׂWM_ERRCODE_SUCCESSŔ肵ĂsC
  ̑s̏C

  Revision 1.4  2004/10/25 05:43:33  seiki_masashi
  WM_APIID_* ̕ϊ֐ŐV wm.h ɍ悤XV
  WM_GetAllowedChannel  0x8000 Ԃꍇ̏̒ǉ
  Rg̕ύX

  Revision 1.3  2004/10/25 02:18:17  seiki_masashi
  Mobt@TCY̎Zo̕sC
  eqő呗MTCY WH_{PARENT,CHILD}_MAX_SIZE ɓ
  WM_StartDataSharing  aidBitmap  WH_CHILD_MAX 𔽉f

  Revision 1.2  2004/10/22 07:36:55  sasakis
  G[\p̕񂪑Ȃ̂ŒǉB

  Revision 1.1  2004/10/21 00:41:50  yosizaki
  Initial upload.

 */

#include "common.h"
#include <nitro.h>
#include <nitro/wm.h>
#include <nitro/cht.h>

#include "wh.h"
#include "communication/communication.h"

/*
  wh.c : Wireless Manager ֘A Wrapper

  E [U

  WM API ŎĂ̂́Aꉻ̒xႢ

  - ʓI MP ʐM
  - f[^VFAO
  - L[VFAO

  3ʂ̒ʐMlłB
  ͊eXʂ̂̂Ƃ킯ł͂ȂAႦ΃L[VFAO
  f[^VFAO𗘗p@̈ŁAf[^VFAO
  P MP ʐMgf[^L̎dĝ݂ƂłAsケ
  3ɋʂĉĂ܂B

  uʓI MP ʐMvƂ̂ Multi Poll vgR̂܂܂̃xł
  ʐM[ĥƂwAȒPɂ܂Ƃ߂

  (1) e@SĂ̎q@փf[^̃u[hLXgs
  (2) eq@甽Ԃ
  (3) e@ʐMTCN̏Iu[hLXgōm

  ƂXebv̃TCNƂĒʐMsAƂ̂łB

  f[^VFAOƂ̂́Ae@ɐڑĂq@SĂ
  f[^zoiŌ(2)ł̏jA̕܂߈ɂ܂Ƃ߂
  Lf[^ƂĎq@SĂɔziŌ(1)ł̏jAƂ[h
  Ƃ܂B

  L[VFAOƂ̂́Af[^VFAOŋLf[^
  e@̃L[f[^̔zɂȂĂAƂ̂łB


  1) ʐM̊Tv

  Wireless LAN ŎĂ@\ɂāA̋̓IȍƂ
  ۂɍsĂ̂́A ARM7vZbTłB
  ] ARM9 ̑MvȂǂ͑S ARM7 ʂKvA
  ߂ ARM9 ̂قƂǂ WM ֌W API ͔񓯊ɂȂĂāA悻

  1. ARM7 ւ̗v FIFO ɏo֐Ă
  2. ARM7 Ԃʂ FIFO 󂯎VXei1.Ŏw肵j
  R[obN֐Ă

  Ƃꂪ{IȏƂȂ܂B

  ̃Tv̎ł́ȀɕKvȂQ̊֐PZbgƂ
  Wireless LAN @\́uԁv\Ă̂ƍlÁuԁv
  A邱ƂŒʐMsĂ܂iȌAɋʂ
  Ō Wireless LAN ́uԁvwꍇAuWHԁvƂ
  tgƂɂ܂jB

  ̃\[XŊY֐̖O͊eWHԂɑΉĂA

  WH_StateInXXXXXX   - WH XXXXXX ̊Jn֐
  WH_StateOutXXXXXX  - WH XXXXXX ̏Iʒm󂯎R[obN֐

  ̂悤ɂȂĂ܂B


  2) WHԊԂ̑J

  IɎWHԂɑJڂׂWHԂ̃R[obN֐ł́A
  ŌŎɈڍsׂWHԂ̊Jn֐Ăяo悤ɂĂ܂
  i{IɏԑJڂ̐is̓\[Xŏォ牺ւƐiނ悤ɂȂĂ܂jB

  SĂWHԖƂ瑊݂̃V[PXł̑Jڊ֌ẂAȉ̂悤
  Ȃ܂B

  - V[PX
  iWH_Initialize ֐j
  
  Initialize

  - e@ʐMV[PX
  iWH_Connect ֐j
  
  SetParentParam
  
  StartParent
  
  StartParentMP
  
  (**)
  
  StartParentKeyShare

  F WH_Connect  MP ڑ[hi܂ DS ڑ[hjw肵
  A(**) ŏIB

  - e@IV[PX
  iWH_Finalize ֐j
  
  iEndParentKeySharej
  
  EndParentMP
  
  EndParent

  - q@ʐMV[PX
  iWH_Connect ֐j
  
  StartScan
  
  EndScan
  
  StartChild
  
  StartChildMP
  
  (**)
  
  StartChildKeyShare

  F WH_Connect  MP ڑ[hi܂ DS ڑ[hjw肵
  A(**) ŏIB

  - q@IV[PX
  iWH_Finalize ֐j
  
  iEndChildKeySharej
  
  EndChildMP
  
  EndChild

  ŒӂKvȂ̂́AeWHԂ̃R[obN֐́AWHԂ̏I
  Ă΂邾Ƃ͌ȂAƂƂłB

  Ⴆ΁A WH StartParentMP ̃R[obNł WH_StateOutStartParentMP
  Ƃ֐́A StartMP ̏IłȂA MP V[PXʂ
  ȂǂɂĂ΂܂i֐{̂̃RgQƂĉjB


  3) ۂ̑M

  ̃\[Xł́AʓI MP ʐMAf[^VFAOAL[VFAO
  3ʂ̒ʐMlĂ܂Âꂪs邩ŁAf[^
  MEM̕@SĂ܂B

  ʓI MP ʐM̏ꍇAɈȉ̊֐ŃR[obNݒ肷Kv
  ܂B

  WH_SetReceiver(WHReceiverFunc proc);

  f[^MƁAM̃^C~OŎ󂯎eZbg
  R[obN֐ɓn܂B
  f[^̑M WH_SendData ōs܂B
  WH_SendData Őݒ肵 callback Ă΂܂ł
  Mf[^̃㏑Ȃ悤ɂĂB

  f[^VFAOł́A WH_StepDS ֐ĂŃf[^nƓ
  ̍XVsA WH_GetSharedDataAdr Ńf[^擾܂B

  L[VFAOʐMł́A WH_GetKeySet ֐ŃL[f[^擾܂
  iWH_StepDS ɑ鏈ōs܂BMׂL[f[^
  CuɑMĂ̂ŁAɉKv͂܂jB


  4) G[ƕAɂ

  ̎ł̕j́A

  - ʂ̊֐ł̃G[͕ԒlōsBTRUE ijA FALSE isj
    fB
  - ڍׂȃG[R[h́A sErrCode Ɋi[ĂB
  - ss\ȏԁiKvƂԂȂǁjɂȂ sSysState 
    WH_SYSSTATE_ERROR ɕω̂ŁAmB

  Ƃ̂łB
  AvP[VɂẮAG[̕񍐂ɃR[obN֐
  OS_SendMessage gKvƎv܂A̎ł͓ɑΉ
  ܂i\[X𗬗pȂA WH_SetError ֐̂ǂ
  ł傤jB

  ܂AؒfiAjɊւẮusV̗ǂvؒf̂߂ɁAȂׂԂ
  IsĂ疾I WM_Disconnect ȂǂĂԂƂ
  ܂B̎ł́ÁusV̗ǂIvsׂ WH_Finalize ֐
  pӂĂ܂B̊֐݂͌̏ԂɂāiȂƂꂪ\Ȏ́j
  eIւ̕悤ɂȂĂ܂B


  5) KChCɂ

  KChCɏŕKvȃR[hɂ́A̎|RgĂ܂
  iKChC̋KɑΉ邽߂̏͂̃t@CȊȌꏊɂ
  ̂ŒӂĉBYɂ `GUIDELINE' ̕tRg
  YĂ܂̂ŁAQljB
 */

/* ======================================================================
   static contents
   ====================================================================== */


/*  L̒l̓R[hŐݒ肳Ă܂B
static WMParentParam sParentParam ATTRIBUTE_ALIGN(32) =
{
    // beacon Ƀ[U`̃f[^ڂꍇ͂Ɏw肵܂B
    // q@̐e@IʂŐe@ Nickname \ꍇȂǂ
    // ɏZbgĐe@q@ɓ`邱ƂɂȂ܂B
    NULL,                         // userGameInfo
    0,                            // userGameInfoLength
    0,                            // padding
    // ggid ́AQ[O[v̎ʂɎgp܂B
    // ɂ́AQ[ɂĊ蓖Ăꂽlgp܂B
    0,
    // tgid ́Ae|O[v̎ʂɎgp܂B
    // e@ƂĂ̊Jn邽тɈႤlłKv܂B
    // ̃\[Xł́A WH_Initialize ֐̒Őݒ肵Ă܂B
    0x0001,                       // tgid
    // q@̐VKڑ󂯓邩ǂw肵܂B
    1,                            // entryFlag
    // ڑ\Ȏq@̍ő吔w肵܂B
    WH_CHILD_MAX,                 // maxEntry
    // }`u[gȂꍇ 0 ɂĂ܂B
    0,                            // multiBootFlag
    // KS_Flag  1 ɐݒ肷ƁAڑɎIɃL[VFAOp̕␳
    // parentMaxSize  childMaxSize ɓ悤ɂȂ܂B
    // L[VFAOgpꍇłAƌvZ
    // parentMaxSize  childMaxSize w肷ꍇɂ 0 ō\܂B
    0,                            // KS_Flag
    // ߋƂ̌݊̂߂ɗpӂꂽtB[hŁA݂͖܂B
    0,                            // CS_Flag
    // e@ beacon ̊ԊułB[ms]
    // ۂ̋Nɂ WM_GetDispersionBeaconPeriod() ɂ
    // KxɃol̗p܂A200[ms] OłB
    200,                          // beaconPeriod (millisec)
    // \̈łB
    {0},                           // rsv1
    {0},                           // rsv2
    // e@q@҂󂯂閳`lłB
    WH_DEFAULT_CHANNEL ,          // channel
    // ȉ̃oɂ͍őlƂēK؂Ȓlݒ肵Ă܂B
    // parentMaxSize - e@f[^̍őTCY
    WH_PARENT_MAX_SIZE,
    // childMaxSize - q@f[^̍őTCY
    WH_CHILD_MAX_SIZE,
};
*/




// q@ő吔ie@܂܂Ȃj
#define WH_CHILD_MAX              15

// VFAof[^̍őTCY
#define WH_DS_DATA_SIZE           12


// 1̒ʐMőf[^̍őTCY
// f[^VFAOɉĒʏ̒ʐMꍇ́A̕
// ̒l𑝂₵ĂB̍ۂ́ApPbgMɂǉ
// wb_tb^ZKv܂B
// ڂ docs/TechnicalNotes/WirelessManager.doc QƂĂB
// GUIDELINE : KChC|Cg(6.3.2)
// t@X̃CX}l[W(WM)}\E񁨖ʐMԌvZV[g
// ŌvZ MP ʐM1񕪂̏vԂ 5600 ʕbȉƂȂ邱Ƃ𐄏Ă܂B

#define WH_PARENT_DS_SIZE      (WH_DS_DATA_SIZE * (1 + WH_CHILD_MAX) + 4)
#define WH_CHILD_DS_SIZE       (WH_DS_DATA_SIZE)
#define WH_PARENT_MP_SIZE      (WH_MP_PARENT_DATA_SIZE)
#define WH_CHILD_MP_SIZE       (WH_MP_CHILD_DATA_SIZE)
#define WH_4CHILD_MP_SIZE       (WH_MP_4CHILD_DATA_SIZE)



#define WH_PARENT_MAX_SIZE      MATH_MAX((WH_DS_DATA_SIZE * (1 + WH_CHILD_MAX) + 4), WH_MP_PARENT_DATA_SIZE)
#define WH_CHILD_MAX_SIZE       MATH_MAX((WH_DS_DATA_SIZE), MATH_MAX(WH_MP_4CHILD_DATA_SIZE, WH_MP_CHILD_DATA_SIZE))
//#define WH_PARENT_MAX_SIZE      (WH_DS_DATA_SIZE * (1 + WH_CHILD_MAX) + 4)
//#define WH_CHILD_MAX_SIZE       (WH_DS_DATA_SIZE)


/* e@Mobt@̃TCY  DSʐMꍇ͍ČvZ */
#define WH_PARENT_RECV_BUFFER_SIZE  MATH_MAX(WM_SIZE_MP_PARENT_RECEIVE_BUFFER( WH_DS_DATA_SIZE, WH_CHILD_MAX, FALSE ) , MATH_MAX(WM_SIZE_MP_PARENT_RECEIVE_BUFFER( WH_MP_CHILD_DATA_SIZE, WH_CHILD_MAX, FALSE ),WM_SIZE_MP_PARENT_RECEIVE_BUFFER( WH_MP_4CHILD_DATA_SIZE, (COMM_WIDE_BYTE_SEND_CHILDNUM-1), FALSE )))
/* e@Mobt@̃TCY */
#define WH_PARENT_SEND_BUFFER_SIZE  WM_SIZE_MP_PARENT_SEND_BUFFER( WH_PARENT_MAX_SIZE, FALSE )

/* q@Mobt@̃TCY */
#define WH_CHILD_RECV_BUFFER_SIZE   WM_SIZE_MP_CHILD_RECEIVE_BUFFER( WH_PARENT_MAX_SIZE, FALSE )
/* q@Mobt@̃TCY */
#define WH_CHILD_SEND_BUFFER_SIZE   MATH_MAX(WM_SIZE_MP_CHILD_SEND_BUFFER( WH_DS_DATA_SIZE, FALSE ), MATH_MAX(WM_SIZE_MP_CHILD_SEND_BUFFER( WH_MP_CHILD_DATA_SIZE, FALSE ), WM_SIZE_MP_CHILD_SEND_BUFFER( WH_MP_4CHILD_DATA_SIZE, FALSE )))

typedef struct{
    WMParentParam sParentParam ATTRIBUTE_ALIGN(32);
    /* WM pVXe[N̈obt@ */
    u8 sWmBuffer[WM_SYSTEM_BUF_SIZE] ATTRIBUTE_ALIGN(32);
// gp鑗Mobt@Ƃ̃TCY
    u8 sSendBuffer[MATH_MAX(WH_PARENT_SEND_BUFFER_SIZE, WH_CHILD_SEND_BUFFER_SIZE)] ATTRIBUTE_ALIGN(32);
    u8 sRecvBuffer[MATH_MAX(WH_PARENT_RECV_BUFFER_SIZE, WH_CHILD_RECV_BUFFER_SIZE)] ATTRIBUTE_ALIGN(32);
/* WEP ݒp */
    u16 sWEPKey[20/sizeof(u16)] ATTRIBUTE_ALIGN(32);
/* f[^VFAOp */
    WMDataSharingInfo sDSInfo ATTRIBUTE_ALIGN(32);
    WMDataSet sDataSet ATTRIBUTE_ALIGN(32);
//    WMKeySetBuf sWMKeySetBuf ATTRIBUTE_ALIGN(32);

    
/* e@p */
    WMBssDesc sBssDesc ATTRIBUTE_ALIGN(32);
    WMScanParam sScanParam ATTRIBUTE_ALIGN(32);
    WHStartScanCallbackFunc sScanCallback;
    BOOL sPictoCatchFlag;

/* WEP ݒp */
    WHParentWEPKeyGeneratorFunc sParentWEPKeyGenerator;
    WHChildWEPKeyGeneratorFunc sChildWEPKeyGenerator;

    s32 sSendBufferSize;
    s32 sRecvBufferSize;

    u16 sChannelIndex;
    u16 sAutoConnectFlag;

// wh ̏ԁiWHԂƂ͕ʃmłBO͎QƂ̂݁j
    int sSysState;

// ڑ[hiOݒ肵Ã\[Xł͐G܂j
    int sConnectMode;

// MP ʐM[hł̃f[^M[U֐
    WHReceiverFunc sReceiverFunc;

// ڑp[U֐
    WHJudgeAcceptFunc sJudgeAcceptFunc;

//  aid ܂iq@͐ؒfEĐڑɕω\j
    u16 sMyAid;

// ڑԂ bitmap i[܂
    u16 sConnectBitmap;

// G[R[hi[p
    int sErrCode;

// p
    u32 sRand;

/* ʐMpp (WH_StartMeasureChannel, WH_GetMeasureChannel Ŏgp) */
    u16 sChannel;
    u16 sChannelBusyRatio;
    u16 sChannelBitmap;

    u8 bSetEntry;
    
} _WM_INFO_STRUCT;


static _WM_INFO_STRUCT* _pWmInfo;







/* fobOo̓tbN֐ */
static void (*wh_trace) (const char *, ...) =
#if !defined(SDK_FINALROM)
    OS_TPrintf;
#else
    NULL;
#endif


/* ======================================================================
   state functions
   ====================================================================== */

// }N
#define RAND()  ( _pWmInfo->sRand = _pWmInfo->sRand * 69069UL + 12345 )
#define RAND_INIT(x) ( _pWmInfo->sRand = (u32)(x) )

#define WH_MAX(a, b) ( ((a) > (b)) ? (a) : (b) )

/* sȒʒm󂯎֐ */
static void WH_IndicateHandler(void *arg);

/* (stateless) -> READY -> STOP -> IDLE */
static BOOL WH_StateInInitialize(void);

#ifndef WH_USE_DETAILED_INITIALIZE
static void WH_StateOutInitialize(void *arg);
#else
static BOOL WH_StateInEnable(void);
static void WH_StateOutEnable(void *arg);
static BOOL WH_StateInPowerOn(void);
static void WH_StateOutPowerOn(void *arg);
#endif

/* IDLE -> MEASURECHANNEL -> IDLE */
static u16 WH_StateInMeasureChannel(u16 channel);
static void WH_StateOutMeasureChannel(void *arg);
static WMErrCode WHi_MeasureChannel(WMCallbackFunc func, u16 channel);
static s16 SelectChannel(u16 bitmap);


/* IDLE -> PARENT -> MP-PARENT */
static BOOL WH_StateInSetParentParam(void);
static void WH_StateOutSetParentParam(void *arg);
static BOOL WH_StateInSetParentWEPKey(void);
static void WH_StateOutSetParentWEPKey(void *arg);
static BOOL WH_StateInStartParent(void);
static void WH_StateOutStartParent(void *arg);
static BOOL WH_StateInStartParentMP(void);
static void WH_StateOutStartParentMP(void *arg);

/* IDLE -> SCAN */
static BOOL WH_StateInStartScan(void);
static void WH_StateOutStartScan(void *arg);

/* SCAN -> IDLE */
static BOOL WH_StateInEndScan(void);
static void WH_StateOutEndScan(void *arg);

/* IDLE -> CHILD -> MP-CHILD */
static BOOL WH_StateInSetChildWEPKey(void);
static void WH_StateOutSetChildWEPKey(void *arg);
static BOOL WH_StateInStartChild(void);
static void WH_StateOutStartChild(void *arg);
static BOOL WH_StateInStartChildMP(void);
static void WH_StateOutStartChildMP(void *arg);

/* MP + key sharing */
#if 0
static BOOL WH_StateInStartParentKeyShare(void);
static BOOL WH_StateInEndParentKeyShare(void);
static BOOL WH_StateInStartChildKeyShare(void);
static BOOL WH_StateInEndChildKeyShare(void);
#endif

/* MP + SetMPData */
static BOOL WH_StateInSetMPData(void *data, u16 datasize, int port, WHSendCallbackFunc callback);
static void WH_StateOutSetMPData(void *arg);
static void WH_PortReceiveCallback(void *arg);

/* MP-PARENT -> IDLE */
static BOOL WH_StateInEndParentMP(void);
static void WH_StateOutEndParentMP(void *arg);
static BOOL WH_StateInEndParent(void);
static void WH_StateOutEndParent(void *arg);
static BOOL WH_StateInDisconnectChildren(u16 bitmap);
static void WH_StateOutDisconnectChildren(void *arg);

/* MP-CHILD -> IDLE */
static BOOL WH_StateInEndChildMP(void);
static void WH_StateOutEndChildMP(void *arg);
static BOOL WH_StateInEndChild(void);
static void WH_StateOutEndChild(void *arg);

/* IDLE -> STOP -> READY -> (stateless) */
static BOOL WH_StateInPowerOff(void);
static void WH_StateOutPowerOff(void *arg);
static BOOL WH_StateInDisable(void);
static void WH_StateOutDisable(void *arg);
static void WH_StateOutEnd(void *arg);

/* X -> IDLE */
static BOOL WH_StateInReset(void);
static void WH_StateOutReset(void *arg);


/* ======================================================================
   debug codes
   ====================================================================== */
#ifdef DEBUG_ONLY_FOR_ohno
//#define WMHIGH_DEBUG   //wh֘ÃfobOo
#endif
#ifdef PM_DEBUG
#define _DEBUG_LIFETIME  (0)    // fobOɃCt^C𖳌ɂɎgp
#else
#define _DEBUG_LIFETIME  (0)    // {Ԃł͂O
#endif



#if defined(WMHIGH_DEBUG)

#define WH_TRACE    if(wh_trace) wh_trace

#define WH_TRACE_STATE OS_TPrintf("%s _pWmInfo->sSysState = %d\n", __func__, _pWmInfo->sSysState)

#define WH_REPORT_FAILURE(result)                \
    do{ OS_TPrintf("Failed in %s, %s = %s\n",      \
                  __func__,                      \
                  #result,                       \
                  WH_GetWMErrCodeName(result));  \
        WH_SetError(result); }while(0)

#define WH_ASSERT(exp) \
    (void) ((exp) || (OSi_Panic(__FILE__, __LINE__, "Failed assertion " #exp), 0))

#else  /* defined(WMHIGH_DEBUG) */

#define WH_TRACE_STATE                 /* */
#define WH_TRACE(...)               ((void)0)
#define WH_REPORT_FAILURE(result)   WH_SetError(result)
#define WH_ASSERT(exp)              ((void) 0)

#endif



#if defined(WMHIGH_DEBUG)
static const char *sStateNames[] = {
    "WM_STATE_READY",
    "WM_STATE_STOP",
    "WM_STATE_IDLE",
    "WM_STATE_CLASS1",
    "WM_STATE_TESTMODE",
    "WM_STATE_SCAN",
    "WM_STATE_CONNECT",
    "WM_STATE_PARENT",
    "WM_STATE_CHILD",
    "WM_STATE_MP_PARENT",
    "WM_STATE_MP_CHILD",
    "WM_STATE_DCF_CHILD",
};

static const char *WH_GetWMErrCodeName(int result)
{
    static const char *errnames[] = {
        "WM_ERRCODE_SUCCESS",
        "WM_ERRCODE_FAILED",
        "WM_ERRCODE_OPERATING",
        "WM_ERRCODE_ILLEGAL_STATE",
        "WM_ERRCODE_WM_DISABLE",
        "WM_ERRCODE_NO_DATASET",
        "WM_ERRCODE_INVALID_PARAM",
        "WM_ERRCODE_NO_CHILD",
        "WM_ERRCODE_FIFO_ERROR",
        "WM_ERRCODE_TIMEOUT",
        "WM_ERRCODE_SEND_QUEUE_FULL",
        "WM_ERRCODE_NO_ENTRY",
        "WM_ERRCODE_OVER_MAX_ENTRY",
        "WM_ERRCODE_INVALID_POLLBITMAP",
        "WM_ERRCODE_NO_DATA",
        "WM_ERRCODE_SEND_FAILED",
        "WM_ERRCODE_DCF_TEST",
        "WM_ERRCODE_WL_INVALID_PARAM",
        "WM_ERRCODE_WL_LENGTH_ERR",
        "WM_ERRCODE_FLASH_ERROR",

        "WH_ERRCODE_DISCONNECTED",
        "WH_ERRCODE_PARENT_NOT_FOUND",
        "WH_ERRCODE_NO_RADIO",
    };

    if (0 <= result && result < sizeof(errnames) / sizeof(char *))
    {
        return errnames[result];
    }
    else
    {
        return "N/A";
    }
}

static const char *WH_GetWMStateCodeName(u16 code)
{
    static const char *statenames[] = {
        "WM_STATECODE_PARENT_START",
        "N/A",
        "WM_STATECODE_BEACON_SENT",
        "WM_STATECODE_SCAN_START",
        "WM_STATECODE_PARENT_NOT_FOUND",
        "WM_STATECODE_PARENT_FOUND",
        "WM_STATECODE_CONNECT_START",
        "WM_STATECODE_CONNECTED",
        "WM_STATECODE_BEACON_LOST",
        "WM_STATECODE_DISCONNECTED",
        "WM_STATECODE_MP_START",
        "WM_STATECODE_MPEND_IND",
        "WM_STATECODE_MP_IND",
        "WM_STATECODE_MPACK_IND",
        "WM_STATECODE_DCF_START",
        "WM_STATECODE_DCF_IND",
        "WM_STATECODE_BEACON_RECV",
        "WM_STATECODE_DISASSOCIATE",
        "WM_STATECODE_REASSOCIATE",
        "WM_STATECODE_AUTHENTICATE",
        "WM_STATECODE_PORT_SEND",
        "WM_STATECODE_PORT_RECV",
        "WM_STATECODE_FIFO_ERROR",
        "WM_STATECODE_INFORMATION",
        "WM_STATECODE_UNKNOWN",
        "WM_STATECODE_PORT_INIT",
        "WM_STATECODE_DISCONNECTED_FROM_MYSELF",
    };

    if (0 <= code && code < sizeof(statenames) / sizeof(char *))
    {
        return statenames[code];
    }
    else
    {
        return "N/A";
    }
}

static const char *WH_GetWMApiidName(u16 apiid)
{
    static const char *apinames[] = {
        "WM_APIID_INITIALIZE",
        "WM_APIID_RESET",
        "WM_APIID_END",

        "WM_APIID_ENABLE",
        "WM_APIID_DISABLE",
        "WM_APIID_POWER_ON",
        "WM_APIID_POWER_OFF",

        "WM_APIID_SET_P_PARAM",
        "WM_APIID_START_PARENT",
        "WM_APIID_END_PARENT",
        "WM_APIID_START_SCAN",
        "WM_APIID_END_SCAN",
        "WM_APIID_START_CONNECT",
        "WM_APIID_DISCONNECT",
        "WM_APIID_START_MP",
        "WM_APIID_SET_MP_DATA",
        "WM_APIID_END_MP",
        "WM_APIID_START_DCF",
        "WM_APIID_SET_DCF_DATA",
        "WM_APIID_END_DCF",
        "WM_APIID_SET_WEPKEY",
        "WM_APIID_START_KS",
        "WM_APIID_END_KS",
        "WM_APIID_GET_KEYSET",
        "WM_APIID_SET_GAMEINFO",
        "WM_APIID_SET_BEACON_IND",
        "WM_APIID_START_TESTMODE",
        "WM_APIID_STOP_TESTMODE",
        "WM_APIID_VALARM_MP",
        "WM_APIID_SET_LIFETIME",
        "WM_APIID_MEASURE_CHANNEL",
        "WM_APIID_INIT_W_COUNTER",
        "WM_APIID_GET_W_COUNTER",
        "WM_APIID_SET_ENTRY",
        "WM_APIID_AUTO_DEAUTH",
        "WM_APIID_SET_MP_PARAMETER",
        "WM_APIID_SET_BEACON_PERIOD",
        "WM_APIID_AUTO_DISCONNECT",

        "WM_APIID_KICK_MP_PARENT",
        "WM_APIID_KICK_MP_CHILD",
        "WM_APIID_KICK_MP_RESUME",
    };
    static const char *apinames_indicates[] = {
        "WM_APIID_INDICATION",
        "WM_APIID_PORT_SEND",
        "WM_APIID_PORT_RECV",
        "WM_APIID_READ_STATUS"
    };
    static const char *apiname_unknown = "WM_APIID_UNKNOWN";

    if (0 <= apiid && apiid < sizeof(apinames) / sizeof(char *))
    {
        return apinames[apiid];
    }
    else if (WM_APIID_INDICATION <= apiid &&
             apiid < WM_APIID_INDICATION + sizeof(apinames_indicates) / sizeof(char *))
    {
        return apinames_indicates[apiid - WM_APIID_INDICATION];
    }
    else if (apiid == WM_APIID_UNKNOWN)
    {
        return apiname_unknown;
    }
    else
    {
        return "N/A";
    }
}

static void WH_OutputWMState(void)
{
    WMStatus s;

    if (WM_ReadStatus(&s) == WM_ERRCODE_SUCCESS)
    {
        WH_TRACE("state = %s\n", WH_GetWMStateCodeName(s.state));
        WH_TRACE("apiid = %s\n", WH_GetWMApiidName(s.BusyApiid));
    }
    else
    {
        WH_TRACE("WM not Initialized\n");
    }
}

static void WH_OutputBitmap(u16 bitmap)
{
    u16 i;
    for (i = 15; i >= 0; --i)
    {
        if ((bitmap >> i) & 0x01)
        {
            OS_TPrintf("o");
        }
        else
        {
            OS_TPrintf("-");
        }
    }

    OS_TPrintf("\n");
}

static void WH_ChangeSysState(int state)
{
    static const char *statenames[] = {
        "WH_SYSSTATE_STOP",
        "WH_SYSSTATE_IDLE",
        "WH_SYSSTATE_SCANNING",
        "WH_SYSSTATE_BUSY",
        "WH_SYSSTATE_CONNECTED",
        "WH_SYSSTATE_DATASHARING",
        "WH_SYSSTATE_KEYSHARING",
        "WH_SYSSTATE_MEASURECHANNEL",
        "WH_SYSSTATE_CONNECT_FAIL",
        "WH_SYSSTATE_ERROR",
    };

    WH_TRACE("%s -> ", statenames[_pWmInfo->sSysState]);
    _pWmInfo->sSysState = state;
    WH_TRACE("%s\n", statenames[_pWmInfo->sSysState]);
}

#else

#define WH_GetWMErrCodeName(result)    ("")
#define WH_GetWMStateCodeName(result)  ("")
#define WH_GetWMApiidName(result)      ("")

static void WH_OutputWMState(void)
{;
}
static void WH_OutputBitmap(void)
{;
}

static void WH_ChangeSysState(int state)
{
    _pWmInfo->sSysState = state;
}

#endif

static void WH_SetError(int code)
{
    // ɃVXe ERROR ԂɂȂĂꍇ́A㏑ȂB
    if (_pWmInfo->sSysState == WH_SYSSTATE_ERROR || _pWmInfo->sSysState == WH_SYSSTATE_FATAL)
    {
        return;
    }
#ifdef DEBUG_ONLY_FOR_ohno
    OS_TPrintf("sErrCode ݒ %d\n",code);
#endif
    _pWmInfo->sErrCode = code;
}



/* ======================================================================
   state functions
   ====================================================================== */

/* ----------------------------------------------------------------------
   state : setparentparam
  ---------------------------------------------------------------------- */
static BOOL WH_StateInSetParentParam(void)
{
    // ̏Ԃł́Ae@̎ĂQ[ ARM7 ɓnĂ܂B
    WMErrCode result;
    WH_TRACE_STATE;

    WH_ChangeSysState(WH_SYSSTATE_BUSY);

    result = WM_SetParentParameter(WH_StateOutSetParentParam, &_pWmInfo->sParentParam);
    if (result != WM_ERRCODE_OPERATING)
    {
        WH_REPORT_FAILURE(result);
        WH_ChangeSysState(WH_SYSSTATE_ERROR);
        return FALSE;
    }

    return TRUE;
}

static void WH_StateOutSetParentParam(void *arg)
{
    WMCallback *cb = (WMCallback *)arg;
    WH_TRACE_STATE;

    if (cb->errcode != WM_ERRCODE_SUCCESS)
    {
        WH_REPORT_FAILURE(cb->errcode);
        WH_ChangeSysState(WH_SYSSTATE_ERROR);
        return;
    }

    if (_pWmInfo->sParentWEPKeyGenerator != NULL)
    {
        // WEP Key Generator ݒ肳Ă΁AWEP Key ̐ݒ
        if (!WH_StateInSetParentWEPKey())
        {
            WH_ChangeSysState(WH_SYSSTATE_ERROR);
        }
    }
    else
    {
        // ɐisĂΎ StartParent ԂցB
        if (!WH_StateInStartParent())
        {
            WH_ChangeSysState(WH_SYSSTATE_ERROR);
        }
    }
}

static BOOL WH_StateInSetParentWEPKey(void)
{
    u16 wepmode;
    WMErrCode result;
    WH_TRACE_STATE;

    WH_ChangeSysState(WH_SYSSTATE_BUSY);

    wepmode = (*_pWmInfo->sParentWEPKeyGenerator)(_pWmInfo->sWEPKey, &_pWmInfo->sParentParam);
    result = WM_SetWEPKey(WH_StateOutSetParentWEPKey, wepmode, _pWmInfo->sWEPKey);
    if (result != WM_ERRCODE_OPERATING)
    {
        WH_REPORT_FAILURE(result);
        WH_ChangeSysState(WH_SYSSTATE_ERROR);
        return FALSE;
    }

    return TRUE;
}

static void WH_StateOutSetParentWEPKey(void *arg)
{
    WMCallback *cb = (WMCallback *)arg;
    WH_TRACE_STATE;

    if (cb->errcode != WM_ERRCODE_SUCCESS)
    {
        WH_REPORT_FAILURE(cb->errcode);
        WH_ChangeSysState(WH_SYSSTATE_ERROR);
        return;
    }

    // ɐisĂΎ StartParent ԂցB
    if (!WH_StateInStartParent())
    {
        WH_ChangeSysState(WH_SYSSTATE_ERROR);
    }
}


/* ----------------------------------------------------------------------
   state : StartParent
  ---------------------------------------------------------------------- */
static BOOL WH_StateInStartParent(void)
{
    // ̏Ԃł StartParent ֐ĂсAe@ƂĂ̐ݒJn܂B

    WMErrCode result;
    WH_TRACE_STATE;

    if ( (_pWmInfo->sSysState == WH_SYSSTATE_CONNECTED)
         || (_pWmInfo->sSysState == WH_SYSSTATE_KEYSHARING) 
         || (_pWmInfo->sSysState == WH_SYSSTATE_DATASHARING) )
    {
        // ȏ̏ꍇɂ͊ɐeƂĂ̐ݒ͍ςł͂B
        return TRUE;
    }

    result = WM_StartParent(WH_StateOutStartParent);

    if (result != WM_ERRCODE_OPERATING)
    {
        WH_REPORT_FAILURE(result);
        return FALSE;
    }

    _pWmInfo->sMyAid = 0;
    _pWmInfo->sConnectBitmap = WH_BITMAP_EMPTY;

    return TRUE;
}

static void WH_StateOutStartParent(void *arg)
{
    // StartParent Őݒ肵R[obN֐́A
    // 1) r[RMꂽ
    // 2) Vq@ڑ
    // 3) StartParent I
    // 4) q@̐ؒfm
    // ƁAʂ肩̃P[XŌĂ΂̂ŁAʂKv܂B

    WMStartParentCallback *cb = (WMStartParentCallback *)arg;
    const u16 target_bitmap = (u16)(1 << cb->aid);

    if (cb->errcode != WM_ERRCODE_SUCCESS)
    {
        WH_REPORT_FAILURE(cb->errcode);
        WH_ChangeSysState(WH_SYSSTATE_ERROR);
        return;
    }

    switch (cb->state)
    {
        //-----------------------------------
        // r[RMʒm
    case WM_STATECODE_BEACON_SENT:
        // r[RMʒm͖܂B
        break;

        //-----------------------------------
        // q@̐ڑʒm
    case WM_STATECODE_CONNECTED:
        {
            // cb->macAddress ɐڑĂq@ MAC AhXĂ܂B
            // cb->ssid ͎q@ WM_StartConnect  ssid ɃZbgf[^łB
            WH_TRACE("StartParent - new child (aid %x) connected\n", cb->aid);
            // ڑĂq@ڑ𖞂Ă邩ǂ`FbN
            if (_pWmInfo->sJudgeAcceptFunc != NULL)
            {
                if (!_pWmInfo->sJudgeAcceptFunc(cb))
                {
                    WMErrCode result;
                    // ڑؒf܂B
                    result = WM_Disconnect(NULL, cb->aid);
                    if (result != WM_ERRCODE_OPERATING)
                    {
                        WH_REPORT_FAILURE(result);
                        WH_ChangeSysState(WH_SYSSTATE_ERROR);
                    }
                    break;
                }
            }
            _pWmInfo->sConnectBitmap |= target_bitmap;
        }
        break;

        //-----------------------------------
        // q@̐ؒfʒm
    case WM_STATECODE_DISCONNECTED:
        {
            WH_TRACE("StartParent - child (aid %x) disconnected\n", cb->aid);
            // cb->macAddress ɂ, ؒfꂽq@ MAC AhXĂ܂B
            _pWmInfo->sConnectBitmap &= ~target_bitmap;
        }
        break;

        //-----------------------------------
        // q@ؒf
    case WM_STATECODE_DISCONNECTED_FROM_MYSELF:
        {
            WH_TRACE("StartParent - child (aid 0x%x) disconnected from myself\n", cb->aid);
            // ؒfꍇ͏s܂
            // cb->macAddress ɂ, ؒfꂽq@ MAC AhXĂ܂B
        }
        break;

        //-----------------------------------
        // StartParent̏I
    case WM_STATECODE_PARENT_START:
        {
            // MP ʐMԂɈڍs܂B
            if (!WH_StateInStartParentMP())
            {
                WH_ChangeSysState(WH_SYSSTATE_ERROR);
            }
        }
        break;

        //-----------------------------------
    default:
        WH_TRACE("unknown indicate, state = %d\n", cb->state);
    }
}

/* ----------------------------------------------------------------------
   state : StartParentMP
  ---------------------------------------------------------------------- */
static BOOL WH_StateInStartParentMP(void)
{
    // WM_Start ֐ĂсA MP ʐMvgRɂڑJn܂B

    WMErrCode result;
    WH_TRACE_STATE;

    if ((_pWmInfo->sSysState == WH_SYSSTATE_CONNECTED)
        || (_pWmInfo->sSysState == WH_SYSSTATE_KEYSHARING) || (_pWmInfo->sSysState == WH_SYSSTATE_DATASHARING))
    {
        return TRUE;
    }

    WH_ChangeSysState(WH_SYSSTATE_CONNECTED);
/*    result = WM_StartMPEx(WH_StateOutStartParentMP,
                          (u16 *)_pWmInfo->sRecvBuffer,
                          (u16)_pWmInfo->sRecvBufferSize,
                          (u16 *)_pWmInfo->sSendBuffer,
                          (u16)_pWmInfo->sSendBufferSize,
                          1,
                          0,//        u16             defaultRetryCount ,
                          FALSE,//        BOOL            minPollBmpMode ,
                          FALSE,//        BOOL            singlePacketMode ,
                          FALSE,//        BOOL            fixFreqMode ,
                          FALSE//        BOOL            ignoreFatalError
                          );
*/
    result = WM_StartMP(WH_StateOutStartParentMP,
                          (u16 *)_pWmInfo->sRecvBuffer,
                          (u16)_pWmInfo->sRecvBufferSize,
                          (u16 *)_pWmInfo->sSendBuffer,
                          (u16)_pWmInfo->sSendBufferSize,
                          1
                          );
   
    if (result != WM_ERRCODE_OPERATING)
    {
        WH_REPORT_FAILURE(result);
        return FALSE;
    }

    return TRUE;
}

static void WH_StateOutStartParentMP(void *arg)
{
    // StartMP Ŏw肵R[obN֐́A
    // 1) StartMP ɂ郂[hJn
    // 2) MP V[PXie@̂݁j
    // 3) MP Miq@̂݁j
    // 4) MP V[PXʒm(ACKM)oiq@̂݁j
    // ̂Sʂ̃P[XŌĂ΂邽߁AʂKv܂B

    WMstartMPCallback *cb = (WMstartMPCallback *)arg;
    // WH_TRACE_STATE;

    if (cb->errcode != WM_ERRCODE_SUCCESS)
    {
        WH_REPORT_FAILURE(cb->errcode);
        WH_ChangeSysState(WH_SYSSTATE_ERROR);
        return;
    }

    switch (cb->state)
    {
    case WM_STATECODE_MP_START:
        // StartMP I̒ʒmB
        // ȍ~AM\ɂȂ܂B

        if (_pWmInfo->sConnectMode == WH_CONNECTMODE_KS_PARENT)
        {
            // L[VFAOw肾ꍇ́AX StartParentKeyShare 
            // ڍs܂B
            if (_pWmInfo->sSysState == WH_SYSSTATE_CONNECTED)
            {
#if 0
                // ʏ MP ڑB
                if (!WH_StateInStartParentKeyShare())
                {
                    WH_TRACE("WH_StateInStartParentKeyShare failed\n");
                    WH_ChangeSysState(WH_SYSSTATE_ERROR);
                }
                return;
#endif
            }
            else if (_pWmInfo->sSysState == WH_SYSSTATE_KEYSHARING)
            {
                // ɃL[VFAOԂɂȂĂ͗lB
                return;
            }
        }
        else if (_pWmInfo->sConnectMode == WH_CONNECTMODE_DS_PARENT)
        {
            // f[^VFAOw̏ꍇ́AStartDataSharing Ăт܂B
            // ̊֐͓֐Ȃ̂ŁAWHԂ̑Jڂ͂܂B
            WMErrCode result;
            u16 aidBitmap;

            aidBitmap = (u16)((1 << (WH_CHILD_MAX + 1)) - 1);   //  WH_CHILD_MAX+1 rbg1 bitmap
            result = WM_StartDataSharing(&_pWmInfo->sDSInfo, WH_DS_PORT, aidBitmap, WH_DS_DATA_SIZE, TRUE);

            if (result != WM_ERRCODE_SUCCESS)
            {
                WH_REPORT_FAILURE(result);
                WH_ChangeSysState(WH_SYSSTATE_ERROR);
                return;
            }
            // WH_TRACE("WM_StartDataSharing OK\n");
            WH_ChangeSysState(WH_SYSSTATE_DATASHARING);
            return;
        }

        WH_ChangeSysState(WH_SYSSTATE_CONNECTED);
        break;

    case WM_STATECODE_MPEND_IND:
        // e@̎MʒmB

        // cb->recvBuf Ŏq@Mf[^t[̓e󂯎܂A
        // ʏ̃f[^M WM_SetPortCallback ŃR[obNݒ肵ĂB
        // ܂Af[^VFAOEL[VFAOgꍇ́A
        // M͓Iɍs܂̂ŁAWM_SetPortCallback gKv܂B
        break;

    case WM_STATECODE_MP_IND:
    case WM_STATECODE_MPACK_IND:
        // e@Ȃ炱ւ͗Ȃ͂łB

    default:
        WH_TRACE("unknown indicate, state = %d\n", cb->state);
        break;
    }
}

/* ----------------------------------------------------------------------
   state : EndParentMP
  ---------------------------------------------------------------------- */
static BOOL WH_StateInEndParentMP(void)
{
    WMErrCode result;
    WH_TRACE_STATE;

    // ȍ~AMs\ɂȂ܂B
    WH_ChangeSysState(WH_SYSSTATE_BUSY);

    result = WM_EndMP(WH_StateOutEndParentMP);
    if (result != WM_ERRCODE_OPERATING)
    {
        WH_REPORT_FAILURE(result);
        return FALSE;
    }

    return TRUE;
}

static void WH_StateOutEndParentMP(void *arg)
{
    WMCallback *cb = (WMCallback *)arg;
    WH_TRACE_STATE;

    if (cb->errcode != WM_ERRCODE_SUCCESS)
    {
        WH_REPORT_FAILURE(cb->errcode);
        WH_Reset();
        return;
    }

    // IɁAIJn܂B
    if (!WH_StateInEndParent())
    {
        WH_TRACE("WH_StateInEndParent failed\n");
        WH_Reset();
        return;
    }
}

/* ----------------------------------------------------------------------
   state : EndParent
   ---------------------------------------------------------------------- */
static BOOL WH_StateInEndParent(void)
{
    WMErrCode result;
    WH_TRACE_STATE;

    // ŁAe@ƂĂ̓I܂B
    // ڑ̎q@ꍇ́AʂɔF؂ؒf
    // e@ƂĂ̊~܂B
    result = WM_EndParent(WH_StateOutEndParent);
    if (result != WM_ERRCODE_OPERATING)
    {
        WH_REPORT_FAILURE(result);
        return FALSE;
    }

    return TRUE;
}

static void WH_StateOutEndParent(void *arg)
{
    WMCallback *cb = (WMCallback *)arg;
    WH_TRACE_STATE;

    if (cb->errcode != WM_ERRCODE_SUCCESS)
    {
        WH_REPORT_FAILURE(cb->errcode);
        return;
    }

    // ŁAe@ƂĂ̐ؒf͊ AChOiҋ@jԂɖ߂܂B
    WH_ChangeSysState(WH_SYSSTATE_IDLE);
}

/* ----------------------------------------------------------------------
   Name:        WH_ChildConnectAuto
   Description: q@ڑV[PXJn܂B
                AWH_ParentConnect  WH_ChildConnect Ŏw肷
                eݒ̎ɔC܂B
   Arguments:   mode    - WH_CONNECTMODE_MP_CHILD ȂΎq@ƂMPJnB
                          WH_CONNECTMODE_DS_CHILD ȂΎq@ƂDataSharingJnB
                          WH_CONNECTMODE_KS_CHILD ȂΎq@ƂKeySharingJnB

                macAddr - ڑe@MACAhXw
                          0xFFFFFFȂ΂ׂĂ̐e@B
                          
                channel - e`lw
                          0Ȃ΂ׂẴ`lB
                          
   ---------------------------------------------------------------------- */
BOOL WH_ChildConnectAuto(int mode, const u8 *macAddr, u16 channel)
{
    WH_TRACE_STATE;

    // WM_StartMP() p̑Mobt@TCYvZ
    // OɐÓIɃobt@mۂꍇ WM_SIZE_MP_* ֐}NA
    // IɊmۂč\Ȃꍇ́Aeqڑ WM_StartMP() ĂяoO
    // WM_GetReceiveBufferSize() API p܂B
    // lɎOɐÓIɃobt@mۂꍇ WM_SIZE_MP_* ֐}NA
    // IɊmۂč\Ȃꍇ́Aeqڑ WM_StartMP() ĂяoO
    // WM_GetSendBufferSize() API p܂B
    _pWmInfo->sRecvBufferSize = WH_CHILD_RECV_BUFFER_SIZE;
    _pWmInfo->sSendBufferSize = WH_CHILD_SEND_BUFFER_SIZE;

    WH_TRACE("recv buffer size = %d\n", _pWmInfo->sRecvBufferSize);
    WH_TRACE("send buffer size = %d\n", _pWmInfo->sSendBufferSize);

    WH_ChangeSysState(WH_SYSSTATE_SCANNING);

    // q@[hŌJnB
    _pWmInfo->sBssDesc.channel = 1;
    *(u16 *)(&_pWmInfo->sScanParam.bssid[4]) = *(u16 *)(macAddr + 4);
    *(u16 *)(&_pWmInfo->sScanParam.bssid[2]) = *(u16 *)(macAddr + 2);
    *(u16 *)(&_pWmInfo->sScanParam.bssid[0]) = *(u16 *)(macAddr + 0);

    _pWmInfo->sConnectMode = mode;


    _pWmInfo->sScanCallback = NULL;
    _pWmInfo->sChannelIndex = channel;
    _pWmInfo->sScanParam.channel = 0;
    _pWmInfo->sAutoConnectFlag = TRUE;

    _pWmInfo->sParentWEPKeyGenerator = NULL;
    _pWmInfo->sChildWEPKeyGenerator = NULL;

    
    if (!WH_StateInStartScan())
    {
        WH_ChangeSysState(WH_SYSSTATE_ERROR);
        return FALSE;
    }

    return TRUE;
}


/*---------------------------------------------------------------------------*
  Name:         WH_TurnOnPictoCatch

  Description:  sNg`bgT[`@\LɂB
                WH_StartScanɂăXLɁAsNg`bg𔭌ꍇɂ
                R[obN֐Ă΂悤ɂȂB

  Arguments:    None.

  Returns:      None.
 *---------------------------------------------------------------------------*/
void WH_TurnOnPictoCatch(void)
{
    _pWmInfo->sPictoCatchFlag = TRUE;
}

/*---------------------------------------------------------------------------*
  Name:         WH_TurnOffPictoCatch

  Description:  sNg`bgT[`@\𖳌ɂB
                WH_StartScanɂăXLɁAsNg`bg𔭌ꍇł
                悤ɂȂB

  Arguments:    None.

  Returns:      None.
 *---------------------------------------------------------------------------*/
void WH_TurnOffPictoCatch(void)
{
    _pWmInfo->sPictoCatchFlag = FALSE;
}

/*---------------------------------------------------------------------------*
  Name:         WH_StartScan

  Description:  e@̃r[R擾֐

  Arguments:    callback - e@ɕԂR[obNݒ肷B
                
                macAddr  - ڑe@MACAhXw
                           0xFFFFFFȂ΂ׂĂ̐e@B
                           
                channel  - e`lw
                           0Ȃ΂ׂẴ`lB

  Returns:      None.
 *---------------------------------------------------------------------------*/
BOOL WH_StartScan(WHStartScanCallbackFunc callback, const u8 *macAddr, u16 channel)
{
    WH_TRACE_STATE;
    WH_ASSERT(_pWmInfo->sSysState != WH_SYSSTATE_CONNECTED);

    WH_ChangeSysState(WH_SYSSTATE_SCANNING);

    _pWmInfo->sScanCallback = callback;
    _pWmInfo->sChannelIndex = channel;
    _pWmInfo->sScanParam.channel = 0;
    _pWmInfo->sAutoConnectFlag = FALSE;          // ڑ͂Ȃ

    // MACAhX̏ݒ
    *(u16 *)(&_pWmInfo->sScanParam.bssid[4]) = *(u16 *)(macAddr + 4);
    *(u16 *)(&_pWmInfo->sScanParam.bssid[2]) = *(u16 *)(macAddr + 2);
    *(u16 *)(&_pWmInfo->sScanParam.bssid[0]) = *(u16 *)(macAddr);

    if (!WH_StateInStartScan())
    {
        WH_ChangeSysState(WH_SYSSTATE_ERROR);
        return FALSE;
    }

    return TRUE;
}

/* ----------------------------------------------------------------------
  state : StartScan
  ---------------------------------------------------------------------- */
static BOOL WH_StateInStartScan(void)
{
    // ̏Ԃ̎Ae@T܂B
    WMErrCode result;
    u16 chanpat;

    WH_ASSERT(_pWmInfo->sSysState == WH_SYSSTATE_SCANNING);

    chanpat = WM_GetAllowedChannel();

    // gp\ǂ`FbN
    if (chanpat == 0x8000)
    {
        // 0x8000 ԂĂꍇ́AĂȂȂ
        // CȕԈُ\Ă̂ŃG[ɂ܂B
        WH_REPORT_FAILURE(WM_ERRCODE_ILLEGAL_STATE);
        return FALSE;
    }
    if (chanpat == 0)
    {
        // gȂԁB
        WH_REPORT_FAILURE(WH_ERRCODE_NO_RADIO);
        return FALSE;
    }

    if (_pWmInfo->sChannelIndex == 0)
    {
        /* ݂̎w肩珸ɁA\ȃ`l܂ */
        while (TRUE)
        {
            _pWmInfo->sScanParam.channel++;
            if (_pWmInfo->sScanParam.channel > 16)
            {
                _pWmInfo->sScanParam.channel = 1;
            }

            if (chanpat & (0x0001 << (_pWmInfo->sScanParam.channel - 1)))
            {
                break;
            }
        }
    }
    else
    {
        _pWmInfo->sScanParam.channel = (u16)_pWmInfo->sChannelIndex;
    }

    _pWmInfo->sScanParam.maxChannelTime = WM_GetDispersionScanPeriod();
    _pWmInfo->sScanParam.scanBuf = &_pWmInfo->sBssDesc;
    result = WM_StartScan(WH_StateOutStartScan, &_pWmInfo->sScanParam);

    if (result != WM_ERRCODE_OPERATING)
    {
        WH_REPORT_FAILURE(result);
        return FALSE;
    }
    return TRUE;
}


static void WH_StateOutStartScan(void *arg)
{
    WMstartScanCallback *cb = (WMstartScanCallback *)arg;

    // XLR}hɎsꍇ
    if (cb->errcode != WM_ERRCODE_SUCCESS)
    {
        WH_REPORT_FAILURE(cb->errcode);
        WH_ChangeSysState(WH_SYSSTATE_ERROR);
        return;
    }

    if (_pWmInfo->sSysState != WH_SYSSTATE_SCANNING)
    {
        // ԂύXĂ΃XLI
        if (!WH_StateInEndScan())
        {
            WH_ChangeSysState(WH_SYSSTATE_ERROR);
        }
        return;
    }

    switch (cb->state)
    {
    case WM_STATECODE_SCAN_START:
        return;

    case WM_STATECODE_PARENT_NOT_FOUND:
        break;

    case WM_STATECODE_PARENT_FOUND:
        // e@ꍇ
        // GUIDELINE : KChC|Cg(6.3.5)
        // ggid rAĂ玸sƂ܂B
        // ܂AWMBssDesc.gameInfoLength mFA
        // ggid ɗLȒlĂ邱Ƃ璲ׂKv܂B

        WH_TRACE("WH_StateOutStartScan : MAC=%02x%02x%02x%02x%02x%02x ",
                 cb->macAddress[0],
                 cb->macAddress[1],
                 cb->macAddress[2], cb->macAddress[3], cb->macAddress[4], cb->macAddress[5]);

        // BssDesc̏ARM7珑܂Ă邽
        // obt@ɐݒ肳ꂽBssDesc̃LbVj
        DC_InvalidateRange(&_pWmInfo->sBssDesc, sizeof(WMbssDesc));

        // e@sNg`bgǂ
        if (_pWmInfo->sPictoCatchFlag)
        {
            if (CHT_IsPictochatParent(&_pWmInfo->sBssDesc))
            {
                // e@sNg`bgłꍇ
                WH_TRACE("pictochat parent find\n");
                if (_pWmInfo->sScanCallback != NULL)
                {
                    _pWmInfo->sScanCallback(&_pWmInfo->sBssDesc);
                }
                break;
            }
        }

        if (cb->gameInfoLength < 8 || cb->gameInfo.ggid != _pWmInfo->sParentParam.ggid)
        {
            // GGIDĂΖ
            WH_TRACE("not my parent ggid \n");
            break;
        }

        // Gg[tOĂȂΎq@tłȂ̂Ŗ
        // ܂}`u[gtOĂꍇ́ADS_E[he@ł̂ŖB
        if ( ( cb->gameInfo.gameNameCount_attribute & (WM_ATTR_FLAG_ENTRY | WM_ATTR_FLAG_MB) )
             != WM_ATTR_FLAG_ENTRY )
        {
            WH_TRACE("not recieve entry\n");
            break;
        }

        WH_TRACE("parent find\n");

        // R[obNKvȂΌĂяo
        if (_pWmInfo->sScanCallback != NULL)
        {
            _pWmInfo->sScanCallback(&_pWmInfo->sBssDesc);
        }

        // e@Ɏڑ̂߃XLI
        if (_pWmInfo->sAutoConnectFlag)
        {
            if (!WH_StateInEndScan())
            {
                WH_ChangeSysState(WH_SYSSTATE_ERROR);
            }
            return;
        }
        break;
    }

    // `lύXčăXLJn܂B
    if (!WH_StateInStartScan())
    {
        WH_ChangeSysState(WH_SYSSTATE_ERROR);
    }
}

/* ----------------------------------------------------------------------
   state : EndScan
  ---------------------------------------------------------------------- */

/*---------------------------------------------------------------------------*
  Name:         WH_EndScan

  Description:  e@̃r[R擾֐

  Arguments:    None.

  Returns:      None.
 *---------------------------------------------------------------------------*/
BOOL WH_EndScan(void)
{
    if (_pWmInfo->sSysState != WH_SYSSTATE_SCANNING)
    {
        return FALSE;
    }

    WH_ChangeSysState(WH_SYSSTATE_BUSY);
    return TRUE;
}


static BOOL WH_StateInEndScan(void)
{
    WMErrCode result;
    WH_TRACE_STATE;

    // ̏Ԃł́AXL̏Is܂B
    result = WM_EndScan(WH_StateOutEndScan);
    if (result != WM_ERRCODE_OPERATING)
    {
        WH_REPORT_FAILURE(result);
        return FALSE;
    }

    return TRUE;
}

static void WH_StateOutEndScan(void *arg)
{
    WMCallback *cb = (WMCallback *)arg;
    WH_TRACE_STATE;

    if (cb->errcode != WM_ERRCODE_SUCCESS)
    {
        WH_REPORT_FAILURE(cb->errcode);
        return;
    }

    WH_ChangeSysState(WH_SYSSTATE_IDLE);

    if (!_pWmInfo->sAutoConnectFlag)
    {
        return;
    }

    if (_pWmInfo->sChildWEPKeyGenerator != NULL)
    {
        // WEP Key Generator ݒ肳Ă΁AWEP Key ̐ݒ
        if (!WH_StateInSetChildWEPKey())
        {
            WH_ChangeSysState(WH_SYSSTATE_ERROR);
        }
    }
    else
    {
        // XLIÎŁÂ܂܎q@ƂĂ̊
        // Jn܂B
        if (!WH_StateInStartChild())
        {
            WH_TRACE("WH_StateOutEndScan : startchild failed\n");
            WH_ChangeSysState(WH_SYSSTATE_ERROR);
        }
    }
}

static BOOL WH_StateInSetChildWEPKey(void)
{
    u16 wepmode;
    WMErrCode result;
    WH_TRACE_STATE;

    WH_ChangeSysState(WH_SYSSTATE_BUSY);

    wepmode = (*_pWmInfo->sChildWEPKeyGenerator)(_pWmInfo->sWEPKey, &_pWmInfo->sBssDesc);
    result = WM_SetWEPKey(WH_StateOutSetChildWEPKey, wepmode, _pWmInfo->sWEPKey);
    if (result != WM_ERRCODE_OPERATING)
    {
        WH_REPORT_FAILURE(result);
        WH_ChangeSysState(WH_SYSSTATE_ERROR);
        return FALSE;
    }

    return TRUE;
}

static void WH_StateOutSetChildWEPKey(void *arg)
{
    WMCallback *cb = (WMCallback *)arg;
    WH_TRACE_STATE;

    if (cb->errcode != WM_ERRCODE_SUCCESS)
    {
        WH_REPORT_FAILURE(cb->errcode);
        WH_ChangeSysState(WH_SYSSTATE_ERROR);
        return;
    }

    // q@ƂĐe@ɐڑ܂
    if (!WH_StateInStartChild())
    {
        WH_TRACE("WH_StateOutSetChildWEPKey : startchild failed\n");
        WH_ChangeSysState(WH_SYSSTATE_ERROR);
    }
}


/* ----------------------------------------------------------------------
   state : StartChild
  ---------------------------------------------------------------------- */
static BOOL WH_StateInStartChild(void)
{
    WMErrCode result;
    WH_TRACE_STATE;

    if ((_pWmInfo->sSysState == WH_SYSSTATE_CONNECTED)
        || (_pWmInfo->sSysState == WH_SYSSTATE_KEYSHARING)
        || (_pWmInfo->sSysState == WH_SYSSTATE_DATASHARING))
    {
        // ɐڑς݁B
        WH_TRACE("WH_StateInStartChild : already connected?\n");
        return TRUE;
    }

    WH_ChangeSysState(WH_SYSSTATE_BUSY);

    result = WM_StartConnectEx(WH_StateOutStartChild, &_pWmInfo->sBssDesc, NULL, TRUE,
                               (u16)((_pWmInfo->sChildWEPKeyGenerator!=NULL) ? WM_AUTHMODE_SHARED_KEY : WM_AUTHMODE_OPEN_SYSTEM));
    if (result != WM_ERRCODE_OPERATING)
    {
        WH_REPORT_FAILURE(result);
        return FALSE;
    }

    return TRUE;
}

static void WH_StateOutStartChild(void *arg)
{
    // StartConnect Őݒ肳ꂽR[obŃA
    // 1) ڑ̊Jn
    // 2) F؏I
    // 3) ڑAe@ؒfꂽ
    // 4) ő䐔ȏ̐ڑ悤Ƃ
    // Ƃ̃P[XŌĂ΂̂ŁAeXʂKv܂B
    // ̊֐̏ꍇA֐iŗǂ̂ 2) ̂Ƃ݂̂łB

    WMStartConnectCallback *cb = (WMStartConnectCallback *)arg;
    WH_TRACE_STATE;

    if (cb->errcode != WM_ERRCODE_SUCCESS)
    {
        WH_REPORT_FAILURE(cb->errcode);

        if (cb->errcode == WM_ERRCODE_OVER_MAX_ENTRY)
        {
            // GUIDELINE : KChC|Cg(6.3.7)
            // iq@je@̑Ή䐔炠ӂĂ܂ĂꍇB
            // ł͒vIG[Ƃ܂B
            // ̎́ACŉ\Kv܂B
            // G[R[h WM_ERRCODE_OVER_MAX_ENTRY ǂ
            // WH_GetLastError ֐Ń`FbNo܂B
            WH_ChangeSysState(WH_SYSSTATE_ERROR);
            return;
        }
        else if (cb->errcode == WM_ERRCODE_NO_ENTRY)
        {
            // iq@jڑ悤Ǝ݂e@
            // Gg[󂯕tĂȂꍇB
            // ł͒vIG[Ƃ܂B
            // ̎́ACŉ\Kv܂B
            // G[R[h WM_ERRCODE_NO_ENTRY ǂ
            // WH_GetLastError ֐Ń`FbNo܂B
            WH_ChangeSysState(WH_SYSSTATE_ERROR);
            return;
        }
        else if (cb->errcode == WM_ERRCODE_FAILED)
        {
            // iq@jڑ悤Ǝ݂e@ȂȂĂ܂
            // RŁAڑv^CAEgꍇB
            // ł͒vIG[Ƃ܂B
            // ̎́ACŃZbgŐڑgC邩A
            // ͉\Kv܂B
            // G[R[h WM_ERRCODE_FAILED ǂ
            // WH_GetLastError ֐Ń`FbNo܂B
            WH_ChangeSysState(WH_SYSSTATE_CONNECT_FAIL);
            return;
        }
        else
        {
            // e@̃`lݒ肪sȏꍇɂWM_ERRCODE_INVALID_PARAM
            // Ԃ\B
            WH_ChangeSysState(WH_SYSSTATE_ERROR);
        }
        return;
    }

    if (cb->state == WM_STATECODE_BEACON_LOST)
    {
        // ڑ̐e@̃r[R 16 AŎMs܂B
        // r[RƁAV uNĂ܂\ƁA
        // e@̃ZbVJnĂ(TGID ς)Ƃ
        // CÂȂ\܂B

        // ̃fł͓ɉs܂B
        return;
    }

    if (cb->state == WM_STATECODE_CONNECTED)
    {
        // F؏IB
        // cb->aid ɎɊUꂽ AID Ă܂B
        WH_TRACE("Connect to Parent\n");
        WH_ChangeSysState(WH_SYSSTATE_CONNECTED);
        if (!WH_StateInStartChildMP())
        {
            /* FIXME :  BUSY ̂܂ܒuĂėǂ̂? */
            WH_TRACE("WH_StateInStartChildMP failed\n");
            WH_ChangeSysState(WH_SYSSTATE_BUSY);
            return;
        }

        //  aid ۑĂB
        _pWmInfo->sMyAid = cb->aid;
        return;

    }
    else if (cb->state == WM_STATECODE_CONNECT_START)
    {
        // ڑ̊JnB
        // e@ȂȂĂꍇȂǂ WM_ERRCODE_FAILED A
        // e@Gg[󂯕tĂȂꍇ WM_ERRCODE_NO_ENTRY A
        // e@̐ڑς̏ꍇ WM_ERRCODE_OVER_MAX_ENTRY A
        // ꂼ cb->errcode ɕԂĂ܂B
        // ł͉s킸AF؂̏I҂܂B
        return;

    }
    else if (cb->state == WM_STATECODE_DISCONNECTED)
    {
        // GUIDELINE : KChC|Cg(6.3.1)
        // e@ؒfĂ܂ꍇB
        // (6.3.7)Ɠl̏i\jKvłB
        // ̎̃G[R[h́A WH_ERRCODE_DISCONNECTED ł
        // i`WM_'ł͂ȂɒӁjB
        // Ȃꍇieؒfj́Aʂ̃Q[ɂ肦
        // ł傤Ał͂Ƃ肠G[̈ƂĂ
        // CőΉ܂B

        WH_TRACE("Disconnected from Parent\n");
        WH_SetError(WH_ERRCODE_DISCONNECTED);
        WH_ChangeSysState(WH_SYSSTATE_ERROR);
        return;
    }
    else if (cb->state == WM_STATECODE_DISCONNECTED_FROM_MYSELF)
    {
        // ؒfꍇ͏s܂
        return;
    }

    WH_TRACE("unknown state %d, %s\n", cb->state, WH_GetWMStateCodeName(cb->state));
    WH_ChangeSysState(WH_SYSSTATE_ERROR);
}

/* ----------------------------------------------------------------------
   state : StartChildMP
   ---------------------------------------------------------------------- */
static BOOL WH_StateInStartChildMP(void)
{
    WMErrCode result;
    WH_TRACE_STATE;

    result = WM_StartMP(WH_StateOutStartChildMP,
                        (u16 *)_pWmInfo->sRecvBuffer,
                        (u16)_pWmInfo->sRecvBufferSize, (u16 *)_pWmInfo->sSendBuffer,
                        (u16)_pWmInfo->sSendBufferSize, 1);

    if (result != WM_ERRCODE_OPERATING)
    {
        WH_REPORT_FAILURE(result);
        return FALSE;
    }

    return TRUE;
}

static void WH_StateOutStartChildMP(void *arg)
{
    WMstartMPCallback *cb = (WMstartMPCallback *)arg;
    // WH_TRACE_STATE;

    if (cb->errcode != WM_ERRCODE_SUCCESS)
    {

        if (cb->errcode == WM_ERRCODE_SEND_FAILED)
        {
            // WM_STATECODE_MPACK_IND ɂ
            // MPACK t[ɂe@̎MG[ʒmꂽꍇB
            // đȂǂ͕ʂ̏ꏊōsĂ邽߁A
            // ł͓ɉKv͂܂BfobOpłB
            return;

        }
        else if (cb->errcode == WM_ERRCODE_TIMEOUT)
        {
            // MP t[̎MA莞ԌoĂ MPACK t[
            // MłȂꍇB(cb->state == WM_STATECODE_MPACK_IND)
            // đȂǂ͕ʂ̏ꏊōsĂ邽߁A
            // ł͓ɉKv͂܂BfobOpłB
            return;

        }
        else if (cb->errcode == WM_ERRCODE_INVALID_POLLBITMAP)
        {
            // WM_STATECODE_MP_IND, WM_STATECODE_MPACK_IND ɂ
            // ĂłȂt[󂯎ꍇB
            // 3 ȏ̒ʐMł΂Δ邽߁A
            // vIG[ɂĂ͂܂B
            // ł͓ɉKv͂܂BfobOpłB
            return;
        }

        WH_REPORT_FAILURE(cb->errcode);
        WH_Reset();
        return;
    }

    switch (cb->state)
    {
    case WM_STATECODE_MP_START:
        // StartMP IʒmB
        // ȍ~AM\ƂȂ܂B

        if (_pWmInfo->sConnectMode == WH_CONNECTMODE_KS_CHILD)
        {
            // L[VFAOw肾ꍇB
            if (_pWmInfo->sSysState == WH_SYSSTATE_KEYSHARING)
            {
                // ɃL[VFAOԂɂ̂ŁA܂B
                return;
            }

            if (_pWmInfo->sSysState == WH_SYSSTATE_CONNECTED)
            {
#if 0
                // X StartChildKeyShare ֈڍs܂B
                if (!WH_StateInStartChildKeyShare())
                {
                    WH_TRACE("WH_StateInStartChildKeyShare failed\n");
                    (void)WH_Finalize();
                }
                return;
#endif
            }

        }
        else if (_pWmInfo->sConnectMode == WH_CONNECTMODE_DS_CHILD)
        {
            // f[^VFAOw肾ꍇ́A WM_StartDataSharing 
            // Ăт܂B̊֐͓֐Ȃ̂ŁAWHԂ̑Jڂ͂Ă܂B
            WMErrCode result;
            u16 aidBitmap;

            aidBitmap = (u16)((1 << (WH_CHILD_MAX + 1)) - 1);   //  WH_CHILD_MAX+1 rbg1 bitmap
            result = WM_StartDataSharing(&_pWmInfo->sDSInfo, WH_DS_PORT, aidBitmap, WH_DS_DATA_SIZE, TRUE);
            if (result != WM_ERRCODE_SUCCESS)
            {
                WH_REPORT_FAILURE(result);
                (void)WH_Finalize();
                return;
            }

            WH_TRACE("WH_StateOutStartChildMP : WM_StartDataSharing OK\n");
            WH_ChangeSysState(WH_SYSSTATE_DATASHARING);
            return;
        }

        WH_ChangeSysState(WH_SYSSTATE_CONNECTED);
        break;

    case WM_STATECODE_MP_IND:
        // q@̎MB

        // cb->recvBuf Őe@Mf[^t[̓e󂯎܂A
        // ʏ̃f[^M WM_SetPortCallback ŃR[obNݒ肵ĂB
        // ܂Af[^VFAOEL[VFAOgꍇ́A
        // M͓Iɍs܂̂ŁAWM_SetPortCallback gKv܂B

        break;

    case WM_STATECODE_MPACK_IND:
        // MPACK t[̎MʒmBfobOpłB
        break;

    case WM_STATECODE_MPEND_IND:
        // q@Ȃ炱ւ͗Ȃ͂łB

    default:
        WH_TRACE("unknown indicate, state = %d\n", cb->state);
        break;
    }
}

/* ----------------------------------------------------------------------
   state : StartChildKeyShare
  ---------------------------------------------------------------------- */
#if 0
static BOOL WH_StateInStartChildKeyShare(void)
{
    WMErrCode result;
    WH_TRACE_STATE;

    if (_pWmInfo->sSysState == WH_SYSSTATE_KEYSHARING)
    {
        // ɃL[VFAOĂ܂B
        return TRUE;
    }

    if (_pWmInfo->sSysState != WH_SYSSTATE_CONNECTED)
    {
        // ڑĂ܂B
        return FALSE;
    }

    WH_ChangeSysState(WH_SYSSTATE_KEYSHARING);
    result = WM_StartKeySharing(&_pWmInfo->sWMKeySetBuf, WH_DS_PORT);

    if (result != WM_ERRCODE_SUCCESS)
    {
        WH_REPORT_FAILURE(result);
        return FALSE;
    }

    return TRUE;
}

/* ----------------------------------------------------------------------
   state : EndChildKeyShare
   ---------------------------------------------------------------------- */
static BOOL WH_StateInEndChildKeyShare(void)
{
    // L[VFAOI܂B
    WMErrCode result;
    WH_TRACE_STATE;

    if (_pWmInfo->sSysState != WH_SYSSTATE_KEYSHARING)
    {
        return FALSE;
    }

    WH_ChangeSysState(WH_SYSSTATE_BUSY);
    result = WM_EndKeySharing(&_pWmInfo->sWMKeySetBuf);

    if (result != WM_ERRCODE_SUCCESS)
    {
        WH_REPORT_FAILURE(result);
        return FALSE;
    }

    if (!WH_StateInEndChildMP())
    {
        return FALSE;
    }

    return TRUE;
}
#endif

/* ----------------------------------------------------------------------
   state : EndChildMP
  ---------------------------------------------------------------------- */
static BOOL WH_StateInEndChildMP(void)
{
    // MP ʐMI܂B
    WMErrCode result;
    WH_TRACE_STATE;

    WH_ChangeSysState(WH_SYSSTATE_BUSY);
    result = WM_EndMP(WH_StateOutEndChildMP);
    if (result != WM_ERRCODE_OPERATING)
    {
        WH_REPORT_FAILURE(result);
        return FALSE;
    }
    return TRUE;
}

static void WH_StateOutEndChildMP(void *arg)
{
    WMCallback *cb = (WMCallback *)arg;
    WH_TRACE_STATE;

    if (cb->errcode != WM_ERRCODE_SUCCESS)
    {
        WH_REPORT_FAILURE(cb->errcode);
        (void)WH_Finalize();
        return;
    }

    if (!WH_StateInEndChild())
    {
        WH_ChangeSysState(WH_SYSSTATE_ERROR);
    }
}

/* ----------------------------------------------------------------------
  state : EndChild
  ---------------------------------------------------------------------- */
static BOOL WH_StateInEndChild(void)
{
    WMErrCode result;
    WH_TRACE_STATE;

    WH_ChangeSysState(WH_SYSSTATE_BUSY);

    // e@Ƃ̐ڑؒf܂B
    result = WM_Disconnect(WH_StateOutEndChild, 0);
    if (result != WM_ERRCODE_OPERATING)
    {
        WH_REPORT_FAILURE(result);
        WH_Reset();
        return FALSE;
    }

    return TRUE;
}

static void WH_StateOutEndChild(void *arg)
{
    WMCallback *cb = (WMCallback *)arg;
    WH_TRACE_STATE;
    if (cb->errcode != WM_ERRCODE_SUCCESS)
    {
        WH_REPORT_FAILURE(cb->errcode);
        return;
    }
    // ŁAq@ƂĂ̐ؒf͊ AChOiҋ@jԂɖ߂܂B
    WH_ChangeSysState(WH_SYSSTATE_IDLE);
}

/* ----------------------------------------------------------------------
  state : Reset
  ---------------------------------------------------------------------- */
static BOOL WH_StateInReset(void)
{
    // ̏Ԃ́Ae@q@ʂłB
    // VXeԂɖ߂܂B
    WMErrCode result;
    WH_TRACE_STATE;

    WH_ChangeSysState(WH_SYSSTATE_BUSY);
    result = WM_Reset(WH_StateOutReset);
    if (result != WM_ERRCODE_OPERATING)
    {
        WH_REPORT_FAILURE(result);
        return FALSE;
    }
    return TRUE;
}

static void WH_StateOutReset(void *arg)
{
    WMCallback *cb = (WMCallback *)arg;
    WH_TRACE_STATE;
    if (cb->errcode != WM_ERRCODE_SUCCESS)
    {
        WH_ChangeSysState(WH_SYSSTATE_ERROR);
        WH_REPORT_FAILURE(cb->errcode);
        OHNO_PRINT("WH_StateOutReset ŃG[o\n");
        return;
    }
    // Reset ͎̏ԂJnAAChOiҋ@jԂɂ܂B
    WH_ChangeSysState(WH_SYSSTATE_IDLE);
}

/* ----------------------------------------------------------------------
   disconnect
  ---------------------------------------------------------------------- */
static BOOL WH_StateInDisconnectChildren(u16 bitmap)
{
    // ̏Ԃł́AŎw肵q@Ƃ̐ڑؒf܂B
    WMErrCode result;
    WH_TRACE_STATE;

    result = WM_DisconnectChildren(WH_StateOutDisconnectChildren, bitmap);

    if (result == WM_ERRCODE_NO_CHILD)
    {
        return FALSE;
    }

    if (result != WM_ERRCODE_OPERATING)
    {
        WH_REPORT_FAILURE(result);
        return FALSE;
    }

    {
        OSIntrMode enabled = OS_DisableInterrupts();
        _pWmInfo->sConnectBitmap &= ~bitmap;
        (void)OS_RestoreInterrupts(enabled);
    }
    return TRUE;
}

static void WH_StateOutDisconnectChildren(void *arg)
{
    WMCallback *cb = (WMCallback *)arg;
    WH_TRACE_STATE;
    if (cb->errcode != WM_ERRCODE_SUCCESS)
    {
        WH_REPORT_FAILURE(cb->errcode);
        return;
    }
}

/* ----------------------------------------------------------------------
   power off
  ---------------------------------------------------------------------- */
static BOOL WH_StateInPowerOff(void)
{
    // n[hEFAւ̓d͋I܂B
    // ̏Ԃ́Ae@q@ʂłB
    WMErrCode result;
    WH_TRACE_STATE;

    result = WM_PowerOff(WH_StateOutPowerOff);
    if (result != WM_ERRCODE_OPERATING)
    {
        WH_REPORT_FAILURE(result);
        return FALSE;
    }
    return TRUE;
}

static void WH_StateOutPowerOff(void *arg)
{
    // dؒfԂłB
    WMCallback *cb = (WMCallback *)arg;
    WH_TRACE_STATE;

    if (cb->errcode != WM_ERRCODE_SUCCESS)
    {
        WH_REPORT_FAILURE(cb->errcode);
        return;
    }

    if (!WH_StateInDisable())
    {
        WH_ChangeSysState(WH_SYSSTATE_FATAL);
    }
}

/* ----------------------------------------------------------------------
   disable
  ---------------------------------------------------------------------- */
static BOOL WH_StateInDisable(void)
{
    // n[hEFA̎gpIʒm܂B
    // ̏Ԃ́Ae@q@ʂłB
    WMErrCode result;
    WH_TRACE_STATE;

    result = WM_Disable(WH_StateOutDisable);
    if (result != WM_ERRCODE_OPERATING)
    {
        WH_REPORT_FAILURE(result);
        return FALSE;
    }
    return TRUE;
}

static void WH_StateOutDisable(void *arg)
{
    // SďI܂B
    WMCallback *cb = (WMCallback *)arg;
    WH_TRACE_STATE;

    if (cb->errcode != WM_ERRCODE_SUCCESS)
    {
        WH_REPORT_FAILURE(cb->errcode);
    }
}

/* ----------------------------------------------------------------------
  state : SetMPData
  ---------------------------------------------------------------------- */
static BOOL WH_StateInSetMPData(void *data, u16 datasize, int port, WHSendCallbackFunc callback)
{
    // ̏Ԃ́Ae@q@ʂłB
    // f[^ZbgAM܂B
    WMErrCode result;
    // WH_TRACE_STATE;

    DC_FlushRange(_pWmInfo->sSendBuffer, (u32)_pWmInfo->sSendBufferSize);
    /* PXIIOWX^փANZX̂ŃLbV Wait ͕sv */
    // DC_WaitWriteBufferEmpty();
    result = WM_SetMPDataToPortEx(WH_StateOutSetMPData,
                                  (void *)callback,
                                  data, datasize, 0xffff, port, WH_DATA_PRIO);
    if (result != WM_ERRCODE_OPERATING)
    {
        WH_TRACE("WH_StateInSetMPData failed - %s\n", WH_GetWMErrCodeName(result));
        return FALSE;
    }
    return TRUE;
}

static void WH_StateOutSetMPData(void *arg)
{
    WMPortSendCallback *cb = (WMPortSendCallback *)arg;
    // WH_TRACE_STATE;

    //  callback Ă΂܂ł́ASetMPDataToPort 
    // ݒ肵Mf[^̃̈㏑Ă͂܂B

    // 0`7 port gꍇ́AMɎsꍇ
    // WM_ERRCODE_SEND_FAILED Ԃ܂B
    // ܂AML[tꍇɂ
    // WM_ERRCODE_SEND_QUEUE_FULL Ԃ܂B


    if (cb->errcode != WM_ERRCODE_SUCCESS && cb->errcode != WM_ERRCODE_SEND_FAILED)
    {
        WH_REPORT_FAILURE(cb->errcode);
        return;
    }

    if (cb->arg != NULL)
    {
        WHSendCallbackFunc callback = (WHSendCallbackFunc) cb->arg;
        // KvɉāAWHSendCallbackFunc ^ύXA
        // cb->aid  cb->data Ȃǂ󂯎悤ɂĂB
        (*callback) ((cb->errcode == WM_ERRCODE_SUCCESS));
    }
}

static void WH_PortReceiveCallback(void *arg)
{
    WMPortRecvCallback *cb = (WMPortRecvCallback *)arg;

    if (cb->errcode != WM_ERRCODE_SUCCESS)
    {
        WH_REPORT_FAILURE(cb->errcode);
    }
    else if (_pWmInfo->sReceiverFunc != NULL)
    {
        if (cb->state == WM_STATECODE_PORT_INIT)
        {
            // ɂ͉܂B
            // cb->aidBitmap ɏ_ŐڑĂ鑊 aid 
            // ݒ肳Ă܂B
        }
        else if (cb->state == WM_STATECODE_PORT_RECV)
        {
            // f[^M̂ŁAR[obNĂт܂B
            (*_pWmInfo->sReceiverFunc) (cb->aid, cb->data, cb->length);
        }
        else if (cb->state == WM_STATECODE_DISCONNECTED)
        {
            // ؒfꂽ| NULL MŒʒm܂B
            (*_pWmInfo->sReceiverFunc) (cb->aid, NULL, 0);
        }
        else if (cb->state == WM_STATECODE_DISCONNECTED_FROM_MYSELF)
        {
            // ߋƂ̌݊̂߁Aؒfꍇ͒ʒm܂B
        }
        else if (cb->state == WM_STATECODE_CONNECTED)
        {
            // ڑꂽꍇ͉܂B
            // cb->aid ɐڑĂ aid A
            // cb->macAddress ɑ MAC AhXA
            // ݒ肳Ă܂B
        }
    }
}


/* ----------------------------------------------------------------------
  state : End
  ---------------------------------------------------------------------- */

/* ----------------------------------------------------------------------
  state : WM_End
  ---------------------------------------------------------------------- */
static void WH_StateOutEnd(void *arg)
{
    WMCallback *cb = (WMCallback *)arg;
    if (cb->errcode != WM_ERRCODE_SUCCESS)
    {
        WH_ChangeSysState(WH_SYSSTATE_FATAL);
        return;
    }
    WVR_TerminateAsync(NULL,NULL);  // CNj[ؒf
    WH_ChangeSysState(WH_SYSSTATE_STOP);
}


/* ======================================================================
   Public Interfaces
   ====================================================================== */


/**************************************************************************
 * ȉ́AWH ̊eݒlύX֐łB
 **************************************************************************/

/*---------------------------------------------------------------------------*
  Name:         WH_SetGgid

  Description:  Q[O[vIDݒ肵܂B
                e@̐ڑOɌĂяo܂B

  Arguments:    ggid    ݒ肷Q[O[vID.

  Returns:      None.
 *---------------------------------------------------------------------------*/
void WH_SetGgid(u32 ggid)
{
    _pWmInfo->sParentParam.ggid = ggid;
}

/*---------------------------------------------------------------------------*
  Name:         WH_SetUserGameInfo

  Description:  [U`̐e@ݒ肵܂B
                e@̐ڑOɌĂяo܂B

  Arguments:    userGameInfo  [U`̐e@ւ̃|C^
                length        [U`̐e@̃TCY

  Returns:      None.
 *---------------------------------------------------------------------------*/
void WH_SetUserGameInfo( u16* userGameInfo, u16 length )
{
    SDK_ASSERT( length <= WM_SIZE_USER_GAMEINFO );
    SDK_ASSERT( (userGameInfo != NULL) || (length > 0) );
    SDK_ASSERT( _pWmInfo->sSysState == WH_SYSSTATE_IDLE );
    
    // beacon Ƀ[U`̃f[^ڂꍇ͂Ɏw肵܂B
    // q@̐e@IʂŐe@ Nickname \ꍇȂǂ
    // ɏZbgĐe@q@ɓ`邱ƂɂȂ܂B
    _pWmInfo->sParentParam.userGameInfo = userGameInfo;
    _pWmInfo->sParentParam.userGameInfoLength = length;
}

/*---------------------------------------------------------------------------*
  Name:         WH_SetDebugOutput

  Description:  fobOo͗p̊֐ݒ肵܂B

  Arguments:    func    ݒ肷fobOo͗p̊֐.

  Returns:      None.
 *---------------------------------------------------------------------------*/
void WH_SetDebugOutput(void (*func) (const char *, ...))
{
    OSIntrMode enabled = OS_DisableInterrupts();
    wh_trace = func;
    (void)OS_RestoreInterrupts(enabled);
}


/**************************************************************************
 * ȉ́AWM CȕԂ擾郉bp[֐łB
 **************************************************************************/

/* ----------------------------------------------------------------------
  Name:        WH_GetLinkLevel
  Description: dg̎Mx擾܂B
  Arguments:   none.
  Returns:     WMLinkLevel ̐lԂ܂B
  ---------------------------------------------------------------------- */
int WH_GetLinkLevel(void)
{
    return (int)WM_GetLinkLevel();
}

/* ----------------------------------------------------------------------
   Name:        WH_GetAllowedChannel
   Description: ڑɎgpo`l̃rbgp^[擾܂B
   Arguments:   none.
   Returns:     channel pattern
   ---------------------------------------------------------------------- */
u16 WH_GetAllowedChannel(void)
{
    return WM_GetAllowedChannel();
}


/**************************************************************************
 * ȉ́AWH ̏Ԃ擾֐łB
 **************************************************************************/

/* ----------------------------------------------------------------------
   Name:        WH_GetBitmap
   Description: ڑԂrbgp^[擾܂B
   Arguments:   none.
   Returns:     bitmap pattern
   ---------------------------------------------------------------------- */
u16 WH_GetBitmap(void)
{
    return _pWmInfo->sConnectBitmap;
}

/* ----------------------------------------------------------------------
   Name:        WH_GetSystemState
   Description: WH ̓Ԃ擾܂B
   Arguments:   none.
   Returns:     ԁiWH_SYSSTATE_XXXXjB
   ---------------------------------------------------------------------- */
int WH_GetSystemState(void)
{
    return _pWmInfo->sSysState;
}

/* ----------------------------------------------------------------------
   Name:        WH_GetConnectMode
   Description: ڑ擾܂B
   Arguments:   none.
   Returns:     ڑiWH_CONNECTMODE_XX_XXXXjB
   ---------------------------------------------------------------------- */
int WH_GetConnectMode(void)
{
    return _pWmInfo->sConnectMode;
}

/* ----------------------------------------------------------------------
   Name:        WH_GetLastError
   Description: łŋ߂ɋNG[̃R[h擾܂B
   Arguments:   none.
   Returns:     G[R[hB
   ---------------------------------------------------------------------- */
int WH_GetLastError(void)
{
    return _pWmInfo->sErrCode;
}

/*---------------------------------------------------------------------------*
  Name:         WH_PrintBssDesc

  Description:  WMBssDesc \̂̃ofobOo͂B

  Arguments:    info    fobOo͂BssDescւ̃|C^.

  Returns:      None.
 *---------------------------------------------------------------------------*/
void WH_PrintBssDesc(WMBssDesc *info)
{
#pragma unused( info )
    u16 i;

    OS_TPrintf("length = %04x\n", info->length);
    OS_TPrintf("rssi   = %04x\n", info->rssi);
    OS_TPrintf("bssid = %02x%02x%02x%02x%02x%02x\n", info->bssid[0], info->bssid[1], info->bssid[2],
               info->bssid[3], info->bssid[4], info->bssid[5]);
    OS_TPrintf("ssidLength = %04x\n", info->ssidLength);
    OS_TPrintf("ssid = ");
    for (i = 0; i < 32; i++)
    {
        OS_TPrintf("%02x", info->ssid[i]);
    }
    OS_TPrintf("\n");
    OS_TPrintf("capaInfo        = %04x\n", info->capaInfo);
    OS_TPrintf("rateSet.basic   = %04x\n", info->rateSet.basic);
    OS_TPrintf("rateSet.support = %04x\n", info->rateSet.support);
    OS_TPrintf("beaconPeriod    = %04x\n", info->beaconPeriod);
    OS_TPrintf("dtimPeriod      = %04x\n", info->dtimPeriod);
    OS_TPrintf("channel         = %04x\n", info->channel);
    OS_TPrintf("cfpPeriod       = %04x\n", info->cfpPeriod);
    OS_TPrintf("cfpMaxDuration  = %04x\n", info->cfpMaxDuration);
    OS_TPrintf("gameInfoLength  = %04x\n", info->gameInfoLength);
    OS_TPrintf("gameInfo.version = %04x\n", info->gameInfo.ver);
    OS_TPrintf("gameInfo.ggid   = %08x\n", info->gameInfo.ggid);
    OS_TPrintf("gameInfo.tgid   = %04x\n", info->gameInfo.tgid);
    OS_TPrintf("gameInfo.userGameInfoLength = %02x\n", info->gameInfo.userGameInfoLength);
    OS_TPrintf("gameInfo.gameNameCount_attribute = %02x\n", info->gameInfo.gameNameCount_attribute);
    OS_TPrintf("gameInfo.parentMaxSize   = %04x\n", info->gameInfo.parentMaxSize);
    OS_TPrintf("gameInfo.childMaxSize    = %04x\n", info->gameInfo.childMaxSize);
}


/**************************************************************************
 * ȉ́A`lɊւ鏈s֐łB
 **************************************************************************/

/*---------------------------------------------------------------------------*
  Name:         WH_StartMeasureChannel

  Description:  `ldggp̒Jn

  Arguments:    None.

  Returns:     V[PXJnɐΐ^B
 *---------------------------------------------------------------------------*/
BOOL WH_StartMeasureChannel(void)
{
#define MAX_RATIO 100                  // `lgp0`100͈̔
    u16 result;
    u8  macAddr[6];

    OS_GetMacAddress(macAddr);
    RAND_INIT(OS_GetVBlankCount() + *(u16 *)&macAddr[0] + *(u16 *)&macAddr[2] + *(u16 *)&macAddr[4]);   // 
    RAND();

    _pWmInfo->sChannel = 0;
    _pWmInfo->sChannelBusyRatio = MAX_RATIO + 1;

    WH_ChangeSysState(WH_SYSSTATE_BUSY);

    result = WH_StateInMeasureChannel(1);

    if (result == WH_ERRCODE_NOMORE_CHANNEL)
    {
        // gpł`l1Ȃ
        // dggȂȏ󋵂
        // ƂƂȂ̂ŁAł̓G[ŕԂĂ܂
        // i{͂ŉ\Kv܂jB
        WH_REPORT_FAILURE(WH_ERRCODE_NOMORE_CHANNEL);
        WH_ChangeSysState(WH_SYSSTATE_ERROR);
        return FALSE;
    }

    if (result != WM_ERRCODE_OPERATING)
    {
        // G[I
        WH_REPORT_FAILURE(result);
        WH_ChangeSysState(WH_SYSSTATE_ERROR);
        return FALSE;
    }
    return TRUE;
}

/*---------------------------------------------------------------------------*
  Name:         WH_StateInMeasureChannel

  Arguments:    channel     Jn`lԍ

  Returns:      WM_ERRCODE_SUCCESS        - 
                WM_ERRCODE_NOMORE_CHANNEL - `lȂ
                WM_ERRCODE_API_ERR        - WM_MeasureChannelAPIĂяos
 *---------------------------------------------------------------------------*/
static u16 WH_StateInMeasureChannel(u16 channel)
{
    u16 allowedChannel;
    u16 result;

    allowedChannel = WM_GetAllowedChannel();

    if (allowedChannel == 0x8000)
    {
        // 0x8000 ԂĂꍇ́AĂȂȂ
        // CȕԈُ\Ă̂ŃG[ɂ܂B
        WH_REPORT_FAILURE(WM_ERRCODE_ILLEGAL_STATE);
        WH_ChangeSysState(WH_SYSSTATE_ERROR);
        return WM_ERRCODE_ILLEGAL_STATE;
    }
    if (allowedChannel == 0)
    {
        // 0ԂĂꍇAdggȂȏ󋵂
        // ƂƂȂ̂ŁAgpł`lȂԂ܂B
        WH_REPORT_FAILURE(WH_ERRCODE_NO_RADIO);
        WH_ChangeSysState(WH_SYSSTATE_ERROR);
        return WH_ERRCODE_NOMORE_CHANNEL;
    }

    while (((1 << (channel - 1)) & allowedChannel) == 0)
    {
        channel++;
        if (channel > 16)
        {
            /* ꂽ`lׂĒ׏Iꍇ */
            return WH_ERRCODE_NOMORE_CHANNEL;
        }
    }

    result = WHi_MeasureChannel(WH_StateOutMeasureChannel, channel);
    if (result != WM_ERRCODE_OPERATING)
    {
        return result;
    }
    return result;
}

/*---------------------------------------------------------------------------*
  Name:         WH_StateOutMeasureChannel

  Arguments:    arg     ʂʒmWMMeasureChannelCallback\

  Returns:      None.
 *---------------------------------------------------------------------------*/
static void WH_StateOutMeasureChannel(void *arg)
{
    u16 result;
    u16 channel;
    WMMeasureChannelCallback *cb = (WMMeasureChannelCallback *)arg;
    WH_TRACE_STATE;

    if (cb->errcode != WM_ERRCODE_SUCCESS)
    {
        // ssꍇB
        // MeasureChannel Ŏs悤Ȃǂ݂̂dggȂA
        // l̂ŁAG[Ԃɂ܂B
        WH_REPORT_FAILURE(cb->errcode);
        WH_ChangeSysState(WH_SYSSTATE_ERROR);
        return;
    }

    WH_TRACE("channel %d bratio = %x\n", cb->channel, cb->ccaBusyRatio);

    channel = cb->channel;

    /* gp̒Ⴂ`l擾 (l 101% Ȃ̂Ő擪͕KI) */
    if (_pWmInfo->sChannelBusyRatio > cb->ccaBusyRatio)
    {
        _pWmInfo->sChannelBusyRatio = cb->ccaBusyRatio;
        _pWmInfo->sChannelBitmap = (u16)(1 << (channel - 1));
    }
    else if (_pWmInfo->sChannelBusyRatio == cb->ccaBusyRatio)
    {
        _pWmInfo->sChannelBitmap |= 1 << (channel - 1);
    }

    result = WH_StateInMeasureChannel(++channel);

    if (result == WH_ERRCODE_NOMORE_CHANNEL)
    {
        // `lI
        WH_ChangeSysState(WH_SYSSTATE_MEASURECHANNEL);
        return;
    }

    if (result != WM_ERRCODE_OPERATING)
    {
        // G[I
        WH_ChangeSysState(WH_SYSSTATE_ERROR);
        return;
    }
}

/* ----------------------------------------------------------------------
  dggp̃`FbN
  ---------------------------------------------------------------------- */
static WMErrCode WHi_MeasureChannel(WMCallbackFunc func, u16 channel)
{
#define WH_MEASURE_TIME         30     // 1t[ɈʐMĂdgE邾̊Ԋu(ms)
#define WH_MEASURE_CS_OR_ED     3      // LAZXEDl̘_a
#define WH_MEASURE_ED_THRESHOLD 17     // f[^ɂoIɗLƎv邨ED臒l

    /*
     * dggp擾p[^ƂāA
     * ɂoIɗLƎvlĂ܂B
     */
    return WM_MeasureChannel(func,     /* R[obNݒ */
                             WH_MEASURE_CS_OR_ED,       /* CS or ED */
                             WH_MEASURE_ED_THRESHOLD,   /* 2LAZX݂̂̏ꍇ͖ */
                             channel,  /* ̌`l */
                             WH_MEASURE_TIME);  /*P`l̒[ms] */
}


/*---------------------------------------------------------------------------*
  Name:         WH_GetMeasureChannel

  Description:  p\ȒԎgp̒Ⴂ`lԂ܂B
                WH_MeasureChannel̓삪WH_SYSSTATE_MEASURECHANNEL
                ɂȂĂKv܂B
                ̊֐R[ƈԎgp̒Ⴂ`lԂ
                WH_SYSSTATE_IDLEԂɑJڂ܂B
                
  Arguments:    None.

  Returns:      Ƃgp̒Ⴂp\ȃ`lԍ.
 *---------------------------------------------------------------------------*/
u16 WH_GetMeasureChannel(void)
{
    WH_ASSERT(_pWmInfo->sSysState == WH_SYSSTATE_MEASURECHANNEL);

    WH_ChangeSysState(WH_SYSSTATE_IDLE);
    _pWmInfo->sChannel = (u16)SelectChannel(_pWmInfo->sChannelBitmap);
    WH_TRACE("decided channel = %d\n", _pWmInfo->sChannel);
    return _pWmInfo->sChannel;
}


/*---------------------------------------------------------------------------*
  Name:         SelectChannel

  Description:  łdggp̒Ⴉ`l擾܂B
                łdggp̒Ⴂ`lꍇɂ́A
                gpB
                
  Arguments:    `lrbg}bv.

  Returns:      Ƃgp̒Ⴂp\ȃ`lԍ.
 *---------------------------------------------------------------------------*/
static s16 SelectChannel(u16 bitmap)
{
    s16 i;
    s16 channel = 0;
    u16 num = 0;
    u16 select;

    for (i = 0; i < 16; i++)
    {
        if (bitmap & (1 << i))
        {
            channel = (s16)(i + 1);
            num++;
        }
    }

    if (num <= 1)
    {
        return channel;
    }

    // dggp̃`l݂ꍇ
    select = (u16)(((RAND() & 0xFF) * num) / 0x100);

    channel = 1;

    for (i = 0; i < 16; i++)
    {
        if (bitmap & 1)
        {
            if (select == 0)
            {
                return (s16)(i + 1);
            }
            select--;
        }
        bitmap >>= 1;
    }

    return 0;
}


/**************************************************************************
 * ȉ́AĒʐM\Ԃ܂őJڂ֐łB
 **************************************************************************/

/* ----------------------------------------------------------------------
   Name:        WH_Initialize
   Description: ƂsAV[PXJn܂B
   Arguments:   Ɨ̈.
   Returns:     V[PXJnɐΐ^B
   ---------------------------------------------------------------------- */
BOOL WH_Initialize(void* pHeap)
{
    u32 addr = (u32)pHeap;
    // ACg낦
    if(addr % 32){
        addr += 32 - (addr % 32);
        OHNO_PRINT("ACg낦 0x%x\n",addr);
    }
    _pWmInfo = (_WM_INFO_STRUCT*)addr;
//    _pWmInfo = (_WM_INFO_STRUCT*)pHeap;

    _pWmInfo->sRecvBufferSize = 0;
    _pWmInfo->sSendBufferSize = 0;

    _pWmInfo->sReceiverFunc = NULL;
    _pWmInfo->sMyAid = 0;
    _pWmInfo->sConnectBitmap = WH_BITMAP_EMPTY;
    _pWmInfo->sErrCode = WM_ERRCODE_SUCCESS;

    _pWmInfo->sSysState = WH_SYSSTATE_STOP;
    _pWmInfo->sPictoCatchFlag = FALSE;

    _pWmInfo->sParentParam.userGameInfo = NULL;
    _pWmInfo->sParentParam.userGameInfoLength = 0;

    // ڑq@̃[U֐NULL (multiboot)
    _pWmInfo->sJudgeAcceptFunc = NULL;


    _pWmInfo->sParentWEPKeyGenerator = NULL;
    _pWmInfo->sChildWEPKeyGenerator = NULL;

    // V[PXJnB
    if (!WH_StateInInitialize())
    {
        return FALSE;
    }

    return TRUE;
}

/* ----------------------------------------------------------------------
   q[v̈TCYԂ
   ---------------------------------------------------------------------- */
int WH_GetHeapSize(void)
{
    return sizeof(_WM_INFO_STRUCT)+32;
}


/* ----------------------------------------------------------------------
   Indicate handler
   ---------------------------------------------------------------------- */
static void WH_IndicateHandler(void *arg)
{
    WMindCallback *cb = (WMindCallback *)arg;

    if (cb->errcode == WM_ERRCODE_FIFO_ERROR)
    {
        // s\ȃG[ꍇłB
        // vC[ɂ̎|ʒmʂȂǂ\A
        // vO~ĉB
        WH_ChangeSysState(WH_SYSSTATE_ERROR);
        OS_Panic("Wireless FATAL error occured.\n");
    }
}

/* ----------------------------------------------------------------------
   state : Initialize
   ---------------------------------------------------------------------- */
static BOOL WH_StateInInitialize(void)
{
    // V[PXJn܂B
    WMErrCode result;
    WH_TRACE_STATE;

#ifndef WH_USE_DETAILED_INITIALIZE
    WH_ChangeSysState(WH_SYSSTATE_BUSY);
    result = WM_Initialize(&_pWmInfo->sWmBuffer, WH_StateOutInitialize, WH_DMA_NO);
    if (result != WM_ERRCODE_OPERATING)
    {
        WH_REPORT_FAILURE(result);
        WH_ChangeSysState(WH_SYSSTATE_FATAL);
        return FALSE;
    }

#else
    // WM_Init ͓֐łB
    result = WM_Init(&_pWmInfo->sWmBuffer, WH_DMA_NO);
    if (result != WM_ERRCODE_SUCCESS)
    {
        WH_REPORT_FAILURE(result);
        return FALSE;
    }

    WH_ChangeSysState(WH_SYSSTATE_BUSY);

    if (!WH_StateInEnable())
    {
        WH_ChangeSysState(WH_SYSSTATE_FATAL);
        return FALSE;
    }
#endif

    return TRUE;
}


#ifndef WH_USE_DETAILED_INITIALIZE

static void WH_StateOutInitialize(void *arg)
{
    // dԂłB
    WMErrCode result;
    WMCallback *cb = (WMCallback *)arg;
    WH_TRACE_STATE;

    if (cb->errcode != WM_ERRCODE_SUCCESS)
    {
        WH_REPORT_FAILURE(cb->errcode);
        WH_ChangeSysState(WH_SYSSTATE_FATAL);
        return;
    }
    // sɔʒm󂯎R[obN֐ݒ肵܂B
    result = WM_SetIndCallback(WH_IndicateHandler);
    if (result != WM_ERRCODE_SUCCESS)
    {
        WH_REPORT_FAILURE(result);
        WH_ChangeSysState(WH_SYSSTATE_FATAL);
        return;
    }

    // VXeԂAChOiҋ@jɕύXB
    WH_ChangeSysState(WH_SYSSTATE_IDLE);

    // ̏ԂZbgȂ̂ŁAŃV[PX͂IłB
    // ̏Ԃ WH_Connect Ă΂ƐڑƂɈڍs܂B
}

#else

/* ----------------------------------------------------------------------
   enable
  ---------------------------------------------------------------------- */
static BOOL WH_StateInEnable(void)
{
    // n[hEFAgp\ɂ܂igp𓾂܂jB
    WMErrCode result;
    WH_TRACE_STATE;

    result = WM_Enable(WH_StateOutEnable);
    if (result != WM_ERRCODE_OPERATING)
    {
        WH_REPORT_FAILURE(result);
        WH_ChangeSysState(WH_SYSSTATE_FATAL);
        return FALSE;
    }
    return TRUE;
}

static void WH_StateOutEnable(void *arg)
{
    // n[hEFA̎gpꂽAdԂֈڍs܂B
    WMCallback *cb = (WMCallback *)arg;
    WH_TRACE_STATE;

    if (cb->errcode != WM_ERRCODE_SUCCESS)
    {
        WH_REPORT_FAILURE(cb->errcode);
        WH_ChangeSysState(WH_SYSSTATE_FATAL);
        return;
    }

    if (!WH_StateInPowerOn())
    {
        WH_ChangeSysState(WH_SYSSTATE_FATAL);
        return;
    }
}

/* ----------------------------------------------------------------------
   power on
  ---------------------------------------------------------------------- */
static BOOL WH_StateInPowerOn(void)
{
    // n[hEFAgp\ɂȂ̂ŁAd͋Jn܂B
    WMErrCode result;
    WH_TRACE_STATE;

    result = WM_PowerOn(WH_StateOutPowerOn);
    if (result != WM_ERRCODE_OPERATING)
    {
        WH_REPORT_FAILURE(result);
        WH_ChangeSysState(WH_SYSSTATE_FATAL);
        return FALSE;
    }

    return TRUE;
}

static void WH_StateOutPowerOn(void *arg)
{
    // dԂłB
    WMErrCode result;
    WMCallback *cb = (WMCallback *)arg;
    WH_TRACE_STATE;

    if (cb->errcode != WM_ERRCODE_SUCCESS)
    {
        WH_REPORT_FAILURE(cb->errcode);
        WH_ChangeSysState(WH_SYSSTATE_FATAL);
        return;
    }

    // sɔʒm󂯎R[obN֐ݒ肵܂B
    result = WM_SetIndCallback(WH_IndicateHandler);
    if (result != WM_ERRCODE_SUCCESS)
    {
        WH_REPORT_FAILURE(result);
        WH_ChangeSysState(WH_SYSSTATE_FATAL);
        return;
    }

    OHNO_PRINT(" VXeԂAChOiҋ@jɕύXB\n");
    WH_ChangeSysState(WH_SYSSTATE_IDLE);

    // ̏ԂZbgȂ̂ŁAŃV[PX͂IłB
    // ̏Ԃ WH_Connect Ă΂ƐڑƂɈڍs܂B
}

#endif // #ifdef WH_USE_DETAILED_INITIALIZE


static void _lifeTimeCallback(void* arg)
{
    WMCallback* pCallBack = (WMCallback*)arg;

    
    OS_TPrintf("lifetime ʉ %d \n",pCallBack->apiid);
    // WM_SetLifeTimeɐݒ肵R[obN
}


#define _LIFE_TIME (15)
/* ----------------------------------------------------------------------
  Name:        WH_ParentConnect
  Description: ڑV[PXJn܂B
  Arguments:   mode    - WH_CONNECTMODE_MP_PARENT Ȃΐe@ƂMPJnB
                         WH_CONNECTMODE_DS_PARENT Ȃΐe@ƂDataSharingJnB
                         WH_CONNECTMODE_KS_PARENT Ȃΐe@ƂKeySharingJnB
               tgid    - e@ʐMtgid
               channel - e@ʐMchannel
               maxEntry - q@ő吔 T[rXɂĕ
               beaconPeriod - r[RԊu T[rXɂĎw肷
  Returns:     ڑV[PXJnɐΐ^B
  ---------------------------------------------------------------------- */
BOOL WH_ParentConnect(int mode, u16 tgid, u16 channel,u16 maxEntry,u16 beaconPeriod)
{
    // ҋ@ԂɂȂΐڑV[PXJno܂B
    WH_ASSERT(_pWmInfo->sSysState == WH_SYSSTATE_IDLE);

    // Ct^C̐ݒ  ̐ݒuLɂ Ct^C𖳌ɂł
#if _DEBUG_LIFETIME
    WM_SetLifeTime(_lifeTimeCallback,0xffff,0xffff,0xffff,0xffff);
#endif  //_DEBUG_LIFETIME
    
    // WM_StartMP() p̑Mobt@TCYvZ
    // OɐÓIɃobt@mۂꍇ WM_SIZE_MP_* ֐}NA
    // IɊmۂč\Ȃꍇ́Aeqڑ WM_StartMP() ĂяoO
    // WM_GetReceiveBufferSize() API p܂B
    // lɎOɐÓIɃobt@mۂꍇ WM_SIZE_MP_* ֐}NA
    // IɊmۂč\Ȃꍇ́Aeqڑ WM_StartMP() ĂяoO
    // WM_GetSendBufferSize() API p܂B
    _pWmInfo->sRecvBufferSize = WH_PARENT_RECV_BUFFER_SIZE;
    _pWmInfo->sSendBufferSize = WH_PARENT_SEND_BUFFER_SIZE;
    
    WH_TRACE("recv buffer size = %d\n", _pWmInfo->sRecvBufferSize);
    WH_TRACE("send buffer size = %d\n", _pWmInfo->sSendBufferSize);
    
    _pWmInfo->sConnectMode = mode;
    WH_ChangeSysState(WH_SYSSTATE_BUSY);
    
    _pWmInfo->sParentParam.tgid = tgid;
    _pWmInfo->sParentParam.channel = channel;
    _pWmInfo->sParentParam.beaconPeriod = beaconPeriod;
    switch(mode){
      case WH_CONNECTMODE_MP_PARENT:
        _pWmInfo->sParentParam.parentMaxSize = WH_PARENT_MP_SIZE;
        if(maxEntry >= COMM_WIDE_BYTE_SEND_CHILDNUM){
            _pWmInfo->sParentParam.childMaxSize = WH_CHILD_MP_SIZE;
        }
        else{
            _pWmInfo->sParentParam.childMaxSize = WH_4CHILD_MP_SIZE;
        }
        break;
      case WH_CONNECTMODE_DS_PARENT:
        _pWmInfo->sParentParam.parentMaxSize = WH_PARENT_DS_SIZE;
        _pWmInfo->sParentParam.childMaxSize = WH_CHILD_DS_SIZE;
        break;
    }
    _pWmInfo->sParentParam.maxEntry = maxEntry;
    _pWmInfo->sParentParam.CS_Flag = 0;
    _pWmInfo->sParentParam.multiBootFlag = 0;
    _pWmInfo->sParentParam.entryFlag = 1;
    _pWmInfo->sParentParam.KS_Flag = (u16)((mode == WH_CONNECTMODE_KS_PARENT) ? 1 : 0);

    switch (mode)
    {
    case WH_CONNECTMODE_MP_PARENT:
    case WH_CONNECTMODE_KS_PARENT:
    case WH_CONNECTMODE_DS_PARENT:
        // e@[hŐڑJnB
        return WH_StateInSetParentParam();
    default:
        break;
    }

    WH_TRACE("unknown connect mode %d\n", mode);
    return FALSE;
}


/* ----------------------------------------------------------------------
  Name:        WH_ChildConnect
  Description: ڑV[PXJn܂B
  Arguments:   mode -    WH_CONNECTMODE_MP_CHILD ȂΎq@ƂMPJnB
                         WH_CONNECTMODE_DS_CHILD ȂΎq@ƂDataSharingJnB
                         WH_CONNECTMODE_KS_CHILD ȂΎq@ƂKeySharingJnB
               bssDesc - ڑe@bssDesc
                
  Returns:     ڑV[PXJnɐΐ^B
  ---------------------------------------------------------------------- */
BOOL WH_ChildConnect(int mode, WMBssDesc *bssDesc)
{
    // ҋ@ԂɂȂΐڑV[PXJno܂B
    WH_ASSERT(_pWmInfo->sSysState == WH_SYSSTATE_IDLE);

    // Ct^C̐ݒ
    //ɐݒ肵ȂƁAЂƂ̎q@SؒfĂ܂肷oOɂȂ k.ohno
#if _DEBUG_LIFETIME
    WM_SetLifeTime(_lifeTimeCallback,0xffff,0xffff,0xffff,0xffff);
#endif  //_DEBUG_LIFETIME

    // WM_StartMP() p̑Mobt@TCYvZ
    // OɐÓIɃobt@mۂꍇ WM_SIZE_MP_* ֐}NA
    // IɊmۂč\Ȃꍇ́Aeqڑ WM_StartMP() ĂяoO
    // WM_GetReceiveBufferSize() API p܂B
    // lɎOɐÓIɃobt@mۂꍇ WM_SIZE_MP_* ֐}NA
    // IɊmۂč\Ȃꍇ́Aeqڑ WM_StartMP() ĂяoO
    // WM_GetSendBufferSize() API p܂B
    _pWmInfo->sRecvBufferSize = WH_CHILD_RECV_BUFFER_SIZE;
    _pWmInfo->sSendBufferSize = WH_CHILD_SEND_BUFFER_SIZE;

    WH_TRACE("recv buffer size = %d\n", _pWmInfo->sRecvBufferSize);
    WH_TRACE("send buffer size = %d\n", _pWmInfo->sSendBufferSize);

    _pWmInfo->sConnectMode = mode;
    WH_ChangeSysState(WH_SYSSTATE_BUSY);

    switch (mode)
    {
    case WH_CONNECTMODE_MP_CHILD:
    case WH_CONNECTMODE_KS_CHILD:
    case WH_CONNECTMODE_DS_CHILD:
        // q@[hŐڑJnB
        // ۑĂe@BssDescgpăXLŐڑB
        MI_CpuCopy8(bssDesc, &_pWmInfo->sBssDesc,  sizeof(_pWmInfo->sBssDesc));
        DC_FlushRange(&_pWmInfo->sBssDesc, sizeof(_pWmInfo->sBssDesc));
        DC_WaitWriteBufferEmpty();
        if (_pWmInfo->sChildWEPKeyGenerator != NULL)
        {
            // WEP Key Generator ݒ肳Ă΁AWEP Key ̐ݒ
            return WH_StateInSetChildWEPKey();
        }
        else
        {
            return WH_StateInStartChild();
        }
    default:
        break;
    }

    WH_TRACE("unknown connect mode %d\n", mode);
    return FALSE;
}

/*---------------------------------------------------------------------------*
  Name:         WH_SetJudgeAcceptFunc

  Description:  q@̐ڑ󂯓𔻒肷邽߂̊֐Zbg܂B

  Arguments:    q@̐ڑ֐ݒ.

  Returns:      None.
 *---------------------------------------------------------------------------*/
void WH_SetJudgeAcceptFunc(WHJudgeAcceptFunc func)
{
    _pWmInfo->sJudgeAcceptFunc = func;
}


/**************************************************************************
 * ȉ́AWH_DATA_PORT |[ggp钼ړI MP ʐM̊֐łB
 **************************************************************************/

/* ----------------------------------------------------------------------
   Name:        WH_SetReceiver
   Description: WH_DATA_PORT |[gɃf[^MR[obNݒ肵܂B
   Arguments:   proc - f[^MR[obN
                port   f[^M|[g
   Returns:     none.
   ---------------------------------------------------------------------- */
void WH_SetReceiver(WHReceiverFunc proc, int port)
{
    _pWmInfo->sReceiverFunc = proc;
    if (WM_SetPortCallback(port, WH_PortReceiveCallback, NULL) != WM_ERRCODE_SUCCESS)
    {
        WH_ChangeSysState(WH_SYSSTATE_ERROR);
        WH_TRACE("WM not Initialized\n");
        while(1){}
    }
}

/* ----------------------------------------------------------------------
   Name:        WH_SendData
   Description: WH_DATA_PORT |[gɃf[^MJn܂B
               iMPʐMpBf[^VFAOȂǂɌĂԕKv͂܂j
   Arguments:   size - f[^TCY
   Returns:     MJnɐΐ^B
   ---------------------------------------------------------------------- */
BOOL WH_SendData(void *data, u16 size, int port, WHSendCallbackFunc callback)
{
    return WH_StateInSetMPData(data, size, port, callback);
}


/**************************************************************************
 * ȉ́Af[^VFAOʐM𐧌䂷֐łB
 **************************************************************************/

/* ----------------------------------------------------------------------
   Name:        WH_GetKeySet
   Description: LL[f[^ǂݏo܂B
   Arguments:   keyset - f[^i[w
   Returns:     ΐ^B
   ---------------------------------------------------------------------- */
BOOL WH_GetKeySet(WMKeySet *keyset)
{
#if 0
    WMErrCode result;

    if (_pWmInfo->sSysState != WH_SYSSTATE_KEYSHARING)
    {
        WH_TRACE("WH_GetKeySet failed (invalid system state)\n");
        return FALSE;
    }

    if ((_pWmInfo->sConnectMode != WH_CONNECTMODE_KS_CHILD)
        && (_pWmInfo->sConnectMode != WH_CONNECTMODE_KS_PARENT))
    {
        WH_TRACE("WH_GetKeySet failed (invalid connect mode)\n");
        return FALSE;
    }

    result = WM_GetKeySet(&_pWmInfo->sWMKeySetBuf, keyset);
    if (result != WM_ERRCODE_SUCCESS)
    {
        WH_REPORT_FAILURE(result);
        return FALSE;
    }
#endif
    return FALSE;
}

/* ----------------------------------------------------------------------
   Name:        WH_GetSharedDataAdr
  Description: w aid }V瓾f[^̃AhX
                Lf[^̃AhXvZ擾܂B
   Arguments:   aid - }V̎w
   Returns:     s NULL B
   ---------------------------------------------------------------------- */
u16 *WH_GetSharedDataAdr(u16 aid)
{
    return WM_GetSharedDataAddress(&_pWmInfo->sDSInfo, &_pWmInfo->sDataSet, aid);
}

/* ----------------------------------------------------------------------
   Name:        WH_StepDS
   Description: f[^VFAO̓1i߂܂B
                t[ʐMȂÅ֐t[ĂԕKv
                ܂B
   Arguments:   data - Mf[^
   Returns:     ΐ^B
   ---------------------------------------------------------------------- */
BOOL WH_StepDS(void *data)
{
    WMErrCode result;

    result = WM_StepDataSharing(&_pWmInfo->sDSInfo, (u16 *)data, &_pWmInfo->sDataSet);

    if (result == WM_ERRCODE_NO_CHILD)
    {
        // e@Ȃ̂Ɏq@ȂiG[Ƃ邩͎Rj
//        return TRUE;
        WH_SetError(result);
        return FALSE;
    }

    if (result == WM_ERRCODE_NO_DATASET)
    {
        WH_TRACE("WH_StepDataSharing - Warning No DataSet\n");  //@@OO 2005-08-29
        WH_SetError(result);
        return FALSE;
    }

    if (result != WM_ERRCODE_SUCCESS)
    {
        WH_REPORT_FAILURE(result);
        return FALSE;
    }

    return TRUE;
}


/**************************************************************************
 * ȉ́AʐMIďԂ܂őJڂ֐łB
 **************************************************************************/

/* ----------------------------------------------------------------------
   Name:        WH_Reset
   Description: ZbgV[PXJn܂B
                ̊֐ĂԂƁȀԂɍ\킸Zbg܂B
        G[̋ApłB
   Arguments:   none.
   Returns:     Jnɐΐ^B
   ---------------------------------------------------------------------- */
void WH_Reset(void)
{
    if(WH_SYSSTATE_SCANNING == _pWmInfo->sSysState){
        OS_TPrintf("~܂\n");
        while(1){}
    }
    
    if (!WH_StateInReset())
    {
        WH_ChangeSysState(WH_SYSSTATE_FATAL);
    }
}

/* ----------------------------------------------------------------------
   Name:        WH_Finalize
   Description: ㏈EIV[PXJn܂B
                ̊֐ĂԂƁȀԂēK؂ȏIV[PX
                s܂B
                ʏ̏Iɂ́iWH_Resetł͂Ȃj̊֐gp܂B
   Arguments:   None.
   Returns:     None.
   ---------------------------------------------------------------------- */
void WH_Finalize(void)
{
    if (_pWmInfo->sSysState == WH_SYSSTATE_IDLE)
    {
        WH_TRACE("already WH_SYSSTATE_IDLE\n");
        return;
    }

    WH_TRACE("WH_Finalize, state = %d\n", _pWmInfo->sSysState);


    if ((_pWmInfo->sSysState != WH_SYSSTATE_KEYSHARING)
        && (_pWmInfo->sSysState != WH_SYSSTATE_DATASHARING)
        && (_pWmInfo->sSysState != WH_SYSSTATE_CONNECTED))
    {
        // ڑĂȂEG[ԂȂǂ̏ꍇ̓ZbgĂB
        WH_ChangeSysState(WH_SYSSTATE_BUSY);
        WH_Reset();
        return;
    }

    WH_ChangeSysState(WH_SYSSTATE_BUSY);

    switch (_pWmInfo->sConnectMode)
    {
    case WH_CONNECTMODE_KS_CHILD:
#if 0
        if (!WH_StateInEndChildKeyShare())
        {
            WH_Reset();
        }
#endif
        break;

    case WH_CONNECTMODE_DS_CHILD:
    case WH_CONNECTMODE_MP_CHILD:
        if (!WH_StateInEndChildMP())
        {
            WH_Reset();
        }
        break;

    case WH_CONNECTMODE_KS_PARENT:
/*        if (!WH_StateInEndParentKeyShare())
        {
            WH_Reset();
        }*/
        break;

    case WH_CONNECTMODE_DS_PARENT:
    case WH_CONNECTMODE_MP_PARENT:
        if (!WH_StateInEndParentMP())
        {
            WH_Reset();
        }
    }
}

/*---------------------------------------------------------------------------*
  Name:         WH_End

  Description:  ʐMIB

  Arguments:    None.

  Returns:      ΐ^B
 *---------------------------------------------------------------------------*/
BOOL WH_End(void)
{
    int err;
    WH_ASSERT(_pWmInfo->sSysState == WH_SYSSTATE_IDLE);

    WH_ChangeSysState(WH_SYSSTATE_BUSY);
    err = WM_End(WH_StateOutEnd);
    if (err != WM_ERRCODE_OPERATING)
    {
        OHNO_PRINT(" WH_End G[%d\n",err);
        WH_ChangeSysState(WH_SYSSTATE_ERROR);

        return FALSE;
    }
    return TRUE;
}

/*---------------------------------------------------------------------------*
  Name:         WH_GetCurrentAid

  Description:  ݂̎AID擾܂B
                q@͐ڑEؒfɕω\܂B

  Arguments:    None.

  Returns:      AID̒l
 *---------------------------------------------------------------------------*/
u16 WH_GetCurrentAid(void)
{
    return _pWmInfo->sMyAid;
}

/*---------------------------------------------------------------------------*
  Name:         WH_SetParentWEPKeyGenerator

  Description:  WEP Key 𐶐֐ݒ肵܂B
                ̊֐ĂяoƁAڑ̔F؂ WEP g܂B
                Q[AvP[VƂ̃ASY
                ڑOɐeqœ̒lݒ肵܂B
                ̊֐͐e@płB

  Arguments:    func    WEP Key 𐶐֐ւ̃|C^
                        NULL w肷 WEP Key gpȂ

  Returns:      None.
 *---------------------------------------------------------------------------*/
void WH_SetParentWEPKeyGenerator(WHParentWEPKeyGeneratorFunc func)
{
    _pWmInfo->sParentWEPKeyGenerator = func;
}

/*---------------------------------------------------------------------------*
  Name:         WH_SetChildWEPKeyGenerator

  Description:  WEP Key 𐶐֐ݒ肵܂B
                ̊֐ĂяoƁAڑ̔F؂ WEP g܂B
                Q[AvP[VƂ̃ASY
                ڑOɐeqœ̒lݒ肵܂B
                ̊֐͎q@płB

  Arguments:    func    WEP Key 𐶐֐ւ̃|C^
                        NULL w肷 WEP Key gpȂ

  Returns:      None.
 *---------------------------------------------------------------------------*/
void WH_SetChildWEPKeyGenerator(WHChildWEPKeyGeneratorFunc func)
{
    _pWmInfo->sChildWEPKeyGenerator = func;
}

/*---------------------------------------------------------------------------*
  Name:         WH_IsSysStateIdle
  Description:  AChԂɂȂ̂mF
                ̏Ԃɐiނ̂ŁÅmF̂߂ɕKv  k.ohnoǉ
  Arguments:    none
  Returns:      WH_SYSSTATE_IDLEȂTRUE
 *---------------------------------------------------------------------------*/
BOOL WH_IsSysStateIdle(void)
{
   return (_pWmInfo->sSysState == WH_SYSSTATE_IDLE);
}

/*---------------------------------------------------------------------------*
  Name:         WH_IsSysStateBusy
  Description:  BUSYԂɂȂĂꍇRESETȂ̂
                ̏Ԃɐiނ̂ŁÅmF̂߂ɕKv  k.ohnoǉ
  Arguments:    none
  Returns:      WH_SYSSTATE_BUSYȂTRUE
 *---------------------------------------------------------------------------*/
BOOL WH_IsSysStateBusy(void)
{
   return (_pWmInfo->sSysState == WH_SYSSTATE_BUSY);
}

/*---------------------------------------------------------------------------*
  Name:         WH_IsSysStateScan
  Description:  q@̌Ԃ̎ǂmF
                eq@؂ւɁAq@XL̏ꍇAȃZbg
                G[ɂȂ
  Arguments:    none
  Returns:      WH_SYSSTATE_SCANNINGȂTRUE
 *---------------------------------------------------------------------------*/
BOOL WH_IsSysStateScan(void)
{
    return (_pWmInfo->sSysState == WH_SYSSTATE_SCANNING);
}


/*---------------------------------------------------------------------------*
  Name:         WHSetGameInfo
  Description:  r[R̒gύX
                ڑɂȂ
  Arguments:    
  Returns:      none
 *---------------------------------------------------------------------------*/

void WHSetGameInfo(void* pBuff, int size, int ggid, int tgid)
{
    if(_pWmInfo->sSysState == WH_SYSSTATE_CONNECTED){
        WM_SetGameInfo(NULL, pBuff, size,
                       ggid, tgid, WM_ATTR_FLAG_ENTRY);
    }
}

/*---------------------------------------------------------------------------*
  Name:         _callBackSetEntry
  Description:  WM_SetEntrỹR[obN
  Arguments:    none
  Returns:      none
 *---------------------------------------------------------------------------*/

static void _callBackSetEntry(void* arg)
{
    WMCallback* pWMCB = arg;
    
    if(pWMCB->errcode == WM_ERRCODE_SUCCESS){
        _pWmInfo->bSetEntry = TRUE;
    }
}

/*---------------------------------------------------------------------------*
  Name:         WHSetEntry
  Description:  q@ڑ󂯕t邩ǂ𐧌
  Arguments:    TRUE Ŏ󂯕t FALSEŎ󂯕tȂ
  Returns:      TRUE ۂWHIsSetEntryEnd҂˂΂ȂȂ
 *---------------------------------------------------------------------------*/

BOOL WHSetEntry(BOOL bEnable)
{
    _pWmInfo->bSetEntry = FALSE;
    if(_pWmInfo->sSysState == WH_SYSSTATE_CONNECTED){
        if(WM_ERRCODE_OPERATING == WM_SetEntry( _callBackSetEntry, bEnable)){
            return TRUE;
        }
    }
    return FALSE;
}

/*---------------------------------------------------------------------------*
  Name:         WHIsSetEntryEnd
  Description:  q@tԊ֐Iǂ
  Arguments:    none
  Returns:      none
 *---------------------------------------------------------------------------*/

BOOL WHIsSetEntryEnd(void)
{
    return _pWmInfo->bSetEntry;
}

/*---------------------------------------------------------------------------*
  Name:         WHSetLifeTime
  Description:  Ct^C ܂͌ɖ߂
  Arguments:    bMinimum ꍇTRUE
  Returns:      none
 *---------------------------------------------------------------------------*/

void WHSetLifeTime(BOOL bMinimum)
{
    if(!_pWmInfo){
        return;
    }
    if(bMinimum){
        WM_SetLifeTime(_lifeTimeCallback,0xffff,1,5,1);
    }
    else{
#if _DEBUG_LIFETIME
        WM_SetLifeTime(_lifeTimeCallback,0xffff,0xffff,0xffff,0xffff);
#else
        WM_SetLifeTime(_lifeTimeCallback,0xffff,40,5,40);
#endif  //_DEBUG_LIFETIME
    }
}

