//=============================================================================
/**
 * @file	wm_icon.c
 * @brief	ʐMɕ\ACRVBlank^XNŕ`悷
 * @author	Akito Mori
 * @date    2005.11.07
 */
//=============================================================================

#include "common.h"
#include "communication/wm_icon.h"

#define WM_ICON_PALFILE_SIZE	( 600 )
#define WM_ICON_CHARFILE_SIZE	( 600 )

#define WM_ICON_PAL_OFFSET	( 16*14*2 )
#define WM_ICON_PAL_SIZE	( 16* 2 )

#define WM_ICON_CHAR_OFFSET ( 496*32 )
#define WM_ICON_CHAR_SIZE   ( 4*4*32  )

#define WM_ICON_ANIME_MAX	( 4 )




static void WirelessIconAnimeFunc( TCB_PTR, void *);


//==============================================================================
/**
 * 
 *
 * @param   objVRAM		
 * @param   HeapId		
 *
 * @retval  VINTR_WIRELESS_ICON *		
 */
//==============================================================================
VINTR_WIRELESS_ICON *AddWirelessIconOAM(u32 objVRAM, u32 HeapId, int x, int y, const VOamAnm *tbl[])
{
	VINTR_WIRELESS_ICON *vwi;
	NNSG2dPaletteData   *ppPltData;
	NNSG2dCharacterData *ppCharData;
	void                *pal,*ncg;

	pal = sys_AllocMemoryLo(HeapId, WM_ICON_PALFILE_SIZE);
	ncg = sys_AllocMemoryLo(HeapId, WM_ICON_CHARFILE_SIZE);

	sys_LoadFileNoMem( "data/wm.NCLR", &pal );								    // pbgǂݍ
	DC_FlushRange( pal, WM_ICON_PALFILE_SIZE );
	NNS_G2dGetUnpackedPaletteData( pal, &ppPltData ); 						    // WJ
	GX_LoadOBJPltt( ppPltData->pRawData, WM_ICON_PAL_OFFSET, WM_ICON_PAL_SIZE );// pbgVRAM֓]


	sys_LoadFileNoMem( "data/wm.NCGR", &ncg );								    // 摜ǂݍ
	DC_FlushRange( ncg, WM_ICON_CHARFILE_SIZE );
	NNS_G2dGetUnpackedCharacterData( ncg, &ppCharData ); 				   	    // WJ
	GX_LoadOBJ( ppCharData->pRawData, WM_ICON_CHAR_OFFSET, WM_ICON_CHAR_SIZE ); // OBJLVRAM֓]

	sys_FreeMemoryEz( ncg );
	sys_FreeMemoryEz( pal );
	
	vwi        = (VINTR_WIRELESS_ICON*)sys_AllocMemoryLo(HeapId, sizeof(VINTR_WIRELESS_ICON));
	vwi->tcb   = VIntrTCB_Add( WirelessIconAnimeFunc, vwi, 5 );
	vwi->x     = x;
	vwi->y     = y;
	vwi->anime_seq = 0;
	vwi->table     = tbl;
	
	return vwi;
}

//------------------------------------------------------------------
/**
 * ACRTCBC
 *
 * @param   tcb		
 * @param   work		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void WirelessIconAnimeFunc( TCB_PTR tcb, void *work )
{
	VINTR_WIRELESS_ICON *vwi = (VINTR_WIRELESS_ICON *)work;

	G2_SetOBJAttr(
    	(GXOamAttr *)(HW_OAM + sizeof(GXOamAttr)*127),		//OAM
    	vwi->x,
    	vwi->y,
    	0,
    	GX_OAM_MODE_NORMAL,
    	0,
    	GX_OAM_EFFECT_NONE,
    	GX_OAM_SHAPE_16x16,
	    GX_OAM_COLORMODE_16,
	    512-16+4*vwi->anime,
	    14,
	    0
	);

	if(++vwi->wait>20){
		vwi->wait  = 0;
		vwi->anime++;
		if(vwi->anime>3){
			vwi->anime=0;
		}
	}
}


//==============================================================================
/**
 * Aj`FW
 *
 * @param   vwi		
 * @param   anime		
 *
 * @retval  none		
 */
//==============================================================================
void WirelessIconAnimeChange(VINTR_WIRELESS_ICON *vwi, int anime)
{
	if(anime<WM_ICON_ANIME_MAX){
		vwi->anime = anime;
		vwi->wait  = 0;
	}
}

//==============================================================================
/**
 * 
 *
 * @param   vwi		
 *
 * @retval  none		
 */
//==============================================================================
void WirelessIconEnd(VINTR_WIRELESS_ICON *vwi)
{
	TCB_Delete(vwi->tcb);
	sys_FreeMemoryEz( vwi );

	

	G2_SetOBJAttr(
    	(GXOamAttr *)(HW_OAM + sizeof(GXOamAttr)*127),		//OAM
    	0,
    	0,
    	0,
    	GX_OAM_MODE_NORMAL,
    	0,
    	GX_OAM_EFFECT_NODISPLAY,
    	GX_OAM_SHAPE_16x16,
	    GX_OAM_COLORMODE_16,
	    0,
	    0,
	    0
	);

}
