//==============================================================================
/**
 * @file	actin.c
 * @brief	Z͕
 * @author	matsuda
 * @date	2005.11.15()
 */
//==============================================================================
#include "common.h"
#include "contest/contest.h"
#include "actin.h"
#include "actin_tcb_pri.h"
#include "battle/battle_common.h"
#include "system/clact_tool.h"
#include "system/palanm.h"

#include "system/arc_tool.h"
#include "system/arc_util.h"

#include "system/softsprite.h"

#include "system/fontproc.h"
#include "system/msgdata.h"

#include "wazaeffect/battle_particle.h"
#include "system/particle.h"
#include "wazaeffect/we_mana.h"
#include "wazaeffect/we_sys.h"

#include "system/brightness.h"
#include "system/snd_tool.h"

#include "graphic/contest_bg_def.h"
#include "graphic/contest_obj_def.h"

#include "con_tool.h"
#include "actin_tool.h"
#include "actin_order.h"
#include "actin_id.h"
#include "actin_input.h"
#include "actin_calc.h"
#include "contest_order.h"

#include "msgdata/msg.naix"
#include "msgdata/msg_cmsg_acting.h"
#include "msgdata/msg_cmsg_wazaexplain.h"
#include "msgdata/msg_cmsg_wazakouka.h"

#include "system/pm_overlay.h"
FS_EXTERN_OVERLAY(bc_common);


//==============================================================================
//	萔`
//==============================================================================
///݂̓
enum{
	APW_PROC_MODE_INIT,		///<
	APW_PROC_MODE_MAIN,		///<C
	APW_PROC_MODE_ETC,		///<ȊO
};

///Vram]}l[W[^XN
#define ACTIN_VRAM_TRANSFER_TASK_NUM	(BATTLE_VRAM_TRANSFER_TASK_NUM)

///̂܂܂̍Ww肾ƁA256x256͈̔͂𒴂ɂ̓EBhE쐬oȂB
///̕W炷2ڂ̃XN[QƂ悤ɂȂB
#define CONTEST_ADD_BMP_Y		(32)

//--------------------------------------------------------------
//	BMPEBhE
//--------------------------------------------------------------
///BMPEBhECGXGAJnʒu(ItZbg)
#define BMPWIN_CGX_START			((0x8000 - 0x2000) / 32)

#define BMPWIN_TALK_COLOR			(0xa)
#define BMPWIN_TALK_CGX_OFFSET		(BMPWIN_CGX_START)
#define BMPWIN_TALK_CGX_SIZE		(29 * 4)	//(0x900 / 32)

#define BMPWIN_BREEDER0_COLOR		(0x7)
#define BMPWIN_BREEDER0_CGX_OFFSET	(BMPWIN_TALK_CGX_OFFSET + BMPWIN_TALK_CGX_SIZE)
#define BMPWIN_BREEDER0_CGX_SIZE	(0x400 / 32)

#define BMPWIN_BREEDER1_COLOR		(0x7)
#define BMPWIN_BREEDER1_CGX_OFFSET	(BMPWIN_BREEDER0_CGX_OFFSET + BMPWIN_BREEDER0_CGX_SIZE)
#define BMPWIN_BREEDER1_CGX_SIZE	(0x400 / 32)

#define BMPWIN_BREEDER2_COLOR		(0x7)
#define BMPWIN_BREEDER2_CGX_OFFSET	(BMPWIN_BREEDER1_CGX_OFFSET + BMPWIN_BREEDER1_CGX_SIZE)
#define BMPWIN_BREEDER2_CGX_SIZE	(0x400 / 32)

#define BMPWIN_BREEDER3_COLOR		(0x7)
#define BMPWIN_BREEDER3_CGX_OFFSET	(BMPWIN_BREEDER2_CGX_OFFSET + BMPWIN_BREEDER2_CGX_SIZE)
#define BMPWIN_BREEDER3_CGX_SIZE	(0x400 / 32)

//--------------------------------------------------------------
//	CL_ACTp̒萔`
//--------------------------------------------------------------
///C	OAMǗ̈EJn
#define ACTIN_OAM_START_MAIN			(BATTLE_OAM_START_MAIN)
///C	OAMǗ̈EI
#define ACTIN_OAM_END_MAIN				(BATTLE_OAM_END_MAIN)
///C	AtBǗ̈EJn
#define ACTIN_OAM_AFFINE_START_MAIN		(BATTLE_OAM_AFFINE_START_MAIN)
///C	AtBǗ̈EI
#define ACTIN_OAM_AFFINE_END_MAIN		(BATTLE_OAM_AFFINE_END_MAIN)
///Tu	OAMǗ̈EJn
#define ACTIN_OAM_START_SUB				(BATTLE_OAM_START_SUB)
///Tu	OAMǗ̈EI
#define ACTIN_OAM_END_SUB				(BATTLE_OAM_END_SUB)
///Tu AtBǗ̈EJn
#define ACTIN_OAM_AFFINE_START_SUB		(BATTLE_OAM_AFFINE_START_SUB)
///Tu	AtBǗ̈EI
#define ACTIN_OAM_AFFINE_END_SUB		(BATTLE_OAM_AFFINE_END_SUB)

///L}l[WFLN^IDǗ(ʁ{)
#define ACTIN_CHAR_MAX					(BATTLE_CHAR_MAX)
///L}l[WFCʃTCY(byteP)
#define ACTIN_CHAR_VRAMSIZE_MAIN		(BATTLE_CHAR_VRAMSIZE_MAIN)
///L}l[WFTuʃTCY(byteP)
#define ACTIN_CHAR_VRAMSIZE_SUB			(BATTLE_CHAR_VRAMSIZE_SUB)

///Cʁ{TuʂŎgpAN^[
#define ACTIN_ACTOR_MAX					(BATTLE_ACTOR_MAX)

///OBJŎgppbg{(ʁ{)
#define ACTIN_OAM_PLTT_MAX				(BATTLE_OAM_PLTT_MAX)

///][h 3D = 0 main = 1 sub = 2 main/sub = 3
#define ACTIN_OAM_VRAM_TRANS			(BATTLE_OAM_VRAM_TRANS)

///OAM\[XFLo^ő吔(C + Tu)
#define ACTIN_OAMRESOURCE_CHAR_MAX		(BATTLE_OAMRESOURCE_CHAR_MAX)
///OAM\[XFpbgo^ő吔(C + Tu)
#define ACTIN_OAMRESOURCE_PLTT_MAX		(BATTLE_OAMRESOURCE_PLTT_MAX)
///OAM\[XFZo^ő吔
#define ACTIN_OAMRESOURCE_CELL_MAX		(BATTLE_OAMRESOURCE_CELL_MAX)
///OAM\[XFZAjo^ő吔
#define ACTIN_OAMRESOURCE_CELLANM_MAX	(BATTLE_OAMRESOURCE_CELLANM_MAX)
///OAM\[XF}`Zo^ő吔
#define ACTIN_OAMRESOURCE_MCELL_MAX		(BATTLE_OAMRESOURCE_MCELL_MAX)
///OAM\[XF}`ZAjo^ő吔
#define ACTIN_OAMRESOURCE_MCELLANM_MAX	(BATTLE_OAMRESOURCE_MCELLANM_MAX)

//--------------------------------------------------------------
//	
//--------------------------------------------------------------
///TuBG̃XN[NAR[h
#define SUB_BG_CLEAR_CODE		(0)


//==============================================================================
//	vg^Cv錾
//==============================================================================
static void ActinSys_VramBankSet(GF_BGL_INI *bgl);
static void ActinSys_DefaultBmpWinAdd(ACTIN_PROC_WORK *apw);
static void ActinParticleInit(void);
static void ActinUpdate(TCB_PTR tcb, void *work);
static void ActinVBlank(void *work);
static void ActinSystemWorkInit(ACTIN_PROC_WORK *apw);
static int ActinSeq_Init(ACTIN_PROC_WORK *apw, ACTIN_LOCAL_WORK *local);
static int ActinSeq_FastTalk(ACTIN_PROC_WORK *apw, ACTIN_LOCAL_WORK *local);
static int ActinSeq_JudgeSelect(ACTIN_PROC_WORK *apw, ACTIN_LOCAL_WORK *local);
static int ActinSeq_WazaSelect(ACTIN_PROC_WORK *apw, ACTIN_LOCAL_WORK *local);
static int ActinSeq_SelectBreeder(ACTIN_PROC_WORK *apw, ACTIN_LOCAL_WORK *local);
static int ActinSeq_PokemonIn(ACTIN_PROC_WORK *apw, ACTIN_LOCAL_WORK *local);
static int ActinSeq_WazaEffectBefore(ACTIN_PROC_WORK *apw, ACTIN_LOCAL_WORK *local);
static int ActinSeq_WazaEffect(ACTIN_PROC_WORK *apw, ACTIN_LOCAL_WORK *local);
static int ActinSeq_AppealReview(ACTIN_PROC_WORK *apw, ACTIN_LOCAL_WORK *local);
static int ActinSeq_PokemonOut(ACTIN_PROC_WORK *apw, ACTIN_LOCAL_WORK *local);
static int ActinSeq_NextBreeder(ACTIN_PROC_WORK *apw, ACTIN_LOCAL_WORK *local);
static int ActinSeq_AllReviewAfter(ACTIN_PROC_WORK *apw, ACTIN_LOCAL_WORK *local);
static int ActinSeq_TurnStart(ACTIN_PROC_WORK *apw, ACTIN_LOCAL_WORK *local);
static int ActinSeq_JudgeComment(ACTIN_PROC_WORK *apw, ACTIN_LOCAL_WORK *local);
static int ActinSeq_TurnEnd(ACTIN_PROC_WORK *apw, ACTIN_LOCAL_WORK *local);
static int ActinSeq_End(ACTIN_PROC_WORK *apw, ACTIN_LOCAL_WORK *local);
static void ActinDefaultOBJSet(ACTIN_PROC_WORK *apw);
static void ActinDefaultOBJDel(ACTIN_PROC_WORK *apw);
static void ActinDefaultOBJSet_Sub(ACTIN_PROC_WORK *apw);
static void ActinDefaultOBJDel_Sub(ACTIN_PROC_WORK *apw);
static void ActinDefaultBGSet(ACTIN_PROC_WORK *apw);
static void ActinDefaultBGDel(ACTIN_PROC_WORK *apw);
static void ActinDefaultBGSet_Sub(ACTIN_PROC_WORK *apw);
static void ActinDefaultBGDel_Sub(ACTIN_PROC_WORK *apw);
void ActinBG_BrdPanelSet(ACTIN_PROC_WORK *apw, int eff_bg_type, int disp_set);


//==============================================================================
//	f[^
//==============================================================================

//==============================================================================
//	V[PXe[u
//==============================================================================
///ActinMainSeqTbl̖߂lƂĎgp
enum{
	ASRET_CONTINUE,		///<ێ
	ASRET_NEXT,			///<̃V[PX
	ASRET_SELECT_SEQ,	///<select_seq[NɓĂV[PX֐i
	ASRET_END,			///<I
};

///Z͕僁C֐̃V[PXe[u
static int (* const ActinMainSeqTbl[])(ACTIN_PROC_WORK *apw, ACTIN_LOCAL_WORK *local) = {
	ActinSeq_Init,
	ActinSeq_FastTalk,
	ActinSeq_TurnStart,
	ActinSeq_JudgeSelect,
	ActinSeq_WazaSelect,
	ActinSeq_SelectBreeder,
	ActinSeq_PokemonIn,
	ActinSeq_WazaEffectBefore,
	ActinSeq_WazaEffect,
	ActinSeq_AppealReview,
	ActinSeq_PokemonOut,
	ActinSeq_NextBreeder,
	ActinSeq_AllReviewAfter,
	ActinSeq_JudgeComment,
	ActinSeq_TurnEnd,
	ActinSeq_End,
};
///ActinMainSeqTbl̃V[PXԍ	ActinMainSeqTblƕт𓯂ɂĂƁII
enum{
	ASEQ_INIT,
	ASEQ_FAST_TALK,
	ASEQ_TURN_START,
	ASEQ_JUDGE_SELECT,
	ASEQ_WAZA_SELECT,
	ASEQ_SELECT_BREEDER,
	ASEQ_POKEMON_IN,
	ASEQ_WAZAEFFECT_BEFORE,
	ASEQ_WAZAEFFECT,
	ASEQ_APPEAL_REVIEW,
	ASEQ_POKEMON_OUT,
	ASEQ_NEXT_BREEDER,
	ASEQ_ALL_REVIEW_AFTER,
	ASEQ_JUDGE_COMMENT,
	ASEQ_TURN_END,
	ASEQ_END,
};

//==============================================================================
//	CLACTpf[^
//==============================================================================
static	const TCATS_OAM_INIT ActinTcats = {
	ACTIN_OAM_START_MAIN, ACTIN_OAM_END_MAIN,
	ACTIN_OAM_AFFINE_START_MAIN, ACTIN_OAM_AFFINE_END_MAIN,
	ACTIN_OAM_START_SUB, ACTIN_OAM_END_SUB,
	ACTIN_OAM_AFFINE_START_SUB, ACTIN_OAM_AFFINE_END_SUB,
};

static	const TCATS_CHAR_MANAGER_MAKE ActinCcmm = {
	ACTIN_CHAR_MAX,
	ACTIN_CHAR_VRAMSIZE_MAIN,
	ACTIN_CHAR_VRAMSIZE_SUB,
	GX_OBJVRAMMODE_CHAR_1D_64K,
	GX_OBJVRAMMODE_CHAR_1D_32K
};

static const TCATS_RESOURCE_NUM_LIST ActinResourceList = {
	ACTIN_OAMRESOURCE_CHAR_MAX,
	ACTIN_OAMRESOURCE_PLTT_MAX,
	ACTIN_OAMRESOURCE_CELL_MAX,
	ACTIN_OAMRESOURCE_CELLANM_MAX,
	ACTIN_OAMRESOURCE_MCELL_MAX,
	ACTIN_OAMRESOURCE_MCELLANM_MAX,
};



//--------------------------------------------------------------
/**
 * @brief   vZX֐F
 *
 * @param   proc		vZXf[^
 * @param   seq			V[PX
 *
 * @retval  
 */
//--------------------------------------------------------------
PROC_RESULT ActinProc_Init( PROC * proc, int * seq )
{
	ACTIN_PROC_WORK *apw;

	sys_VBlankFuncChange(NULL, NULL);	// VBlankZbg
	sys_HBlankIntrStop();	//HBlank荞ݒ~

	GF_Disp_GX_VisibleControlInit();
	GF_Disp_GXS_VisibleControlInit();
	GX_SetVisiblePlane(0);
	GXS_SetVisiblePlane(0);

	sys_CreateHeap(HEAPID_BASE_APP, HEAPID_ACTIN, ACTIN_ALLOC_SIZE);

	simple_3DBGInit(HEAPID_ACTIN);
	
	apw = PROC_AllocWork(proc, sizeof(ACTIN_PROC_WORK), HEAPID_ACTIN );
	MI_CpuClear8(apw, sizeof(ACTIN_PROC_WORK));

	apw->consys = PROC_GetParentWork(proc);
	apw->consys->class_proc = apw;
	apw->consys->class_flag = CON_CLASS_ACTIN;
	apw->sys.c_game = &apw->consys->c_game;
	ActinSystemWorkInit(apw);
	
	//pbgtF[hVXe쐬
	apw->sys.pfd = PaletteFadeInit(HEAPID_ACTIN);
	PaletteTrans_AutoSet(apw->sys.pfd, TRUE);
	PaletteFadeWorkAllocSet(apw->sys.pfd, FADE_MAIN_BG, 0x200, HEAPID_ACTIN);
	PaletteFadeWorkAllocSet(apw->sys.pfd, FADE_SUB_BG, 0x200, HEAPID_ACTIN);
	PaletteFadeWorkAllocSet(apw->sys.pfd, FADE_MAIN_OBJ, 0x200, HEAPID_ACTIN);
	PaletteFadeWorkAllocSet(apw->sys.pfd, FADE_SUB_OBJ, 0x200, HEAPID_ACTIN);
	
	apw->sys.bgl = GF_BGL_BglIniAlloc(HEAPID_ACTIN);

	initVramTransferManagerHeap(ACTIN_VRAM_TRANSFER_TASK_NUM, HEAPID_ACTIN);

	sys_KeyRepeatSpeedSet( 4, 8 );

	apw->aip = AINPUT_SystemInit(&apw->sys, &apw->a_game);

	//VRAM蓖Đݒ
	ActinSys_VramBankSet(apw->sys.bgl);

	// ^b`plVXe
	InitTPSystem();
	InitTPNoBuff(4);

	// {^ptHgǂݍ
	FontProc_LoadFont(FONT_BUTTON, HEAPID_ACTIN);

	// ۑ
//	SetActinWorkParameter(apw, (NAMEIN_PARAM*)PROC_GetParentWork(proc));

	//AN^[VXe쐬
	apw->sys.csp=CATS_AllocMemory(HEAPID_ACTIN);
	CATS_SystemInit(apw->sys.csp,&ActinTcats,&ActinCcmm,ACTIN_OAM_PLTT_MAX);
	apw->sys.crp=CATS_ResourceCreate(apw->sys.csp);
	CATS_ClactSetInit(apw->sys.csp, apw->sys.crp, ACTIN_ACTOR_MAX);
	CATS_ResourceManagerInit(apw->sys.csp,apw->sys.crp,&ActinResourceList);

	apw->sys.soft_sprite = SoftSpriteInit(HEAPID_ACTIN);
	ActinParticleInit();	//p[eBN
	apw->sys.wsp = WES_Create(HEAPID_ACTIN);	//ZGtFNgVXe쐬
	WES_ContestFlag_Set(apw->sys.wsp, TRUE);	//ReXgtOZbg

	//bZ[W}l[W쐬
	apw->sys.actin_msg = MSGMAN_Create(MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_cmsg_acting_dat, 
		HEAPID_ACTIN);
	apw->sys.breeder_msg = MSGMAN_Create(MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_cmsg_breeder_dat, 
		HEAPID_ACTIN);
	apw->sys.explain_msg = MSGMAN_Create(MSGMAN_TYPE_NORMAL, ARC_MSG, 
		NARC_msg_cmsg_wazaexplain_dat, HEAPID_ACTIN);
	apw->sys.wazakouka_msg = MSGMAN_Create(MSGMAN_TYPE_NORMAL, ARC_MSG, 
		NARC_msg_cmsg_wazakouka_dat, HEAPID_ACTIN);

	//tHgOAMVXe쐬
	apw->sys.fontoam_sys = FONTOAM_SysInit(ACTIN_FONTOAM_MAX_MAIN, HEAPID_ACTIN);

	apw->sys.wordset = WORDSET_Create(HEAPID_ACTIN);	//Pobt@쐬
	apw->sys.msg_buf = STRBUF_Create(ACTIN_MESSAGE_BUF_SIZE, HEAPID_ACTIN);	//obt@쐬
	
	//풓BGZbg
	ActinDefaultBGSet(apw);
	ActinDefaultBGSet_Sub(apw);

	//BMPEBhEǉ
	ActinSys_DefaultBmpWinAdd(apw);
	//BreederParamBmpWriteAll(apw);
	BreederPanelColorChangeAll(apw);

	//풓OBJZbg
	ActinDefaultOBJSet(apw);
	ActinDefaultOBJSet_Sub(apw);

	AINPUT_CreateBG(apw->aip, AINPUT_TYPE_WALL, TRUE, NULL);
	
	// PxύXZbg
	ChangeBrightnessRequest(
		8, 0, -16, PLANEMASK_ALL, MASK_DOUBLE_DISPLAY );

	apw->update_tcb = TCB_Add(ActinUpdate, apw, TCBPRI_ACTIN_UPDATE);
	apw->proc_mode = APW_PROC_MODE_MAIN;

	GF_Disp_DispOn();
	GF_Disp_GX_VisibleControl(GX_PLANEMASK_OBJ, VISIBLE_ON);
	GF_Disp_GXS_VisibleControl(GX_PLANEMASK_OBJ, VISIBLE_ON);

	//TEhf[^[h(ReXg)
	Snd_DataSetByScene( SND_SCENE_CONTEST, SEQ_DP_CONTEST, 0 );
	if(Snd_NowBgmNoGet() != SEQ_CO_TEST){
		Snd_Stop();
		Snd_BgmPlay(SEQ_CO_TEST);
	}

	sys_VBlankFuncChange(ActinVBlank, apw);
	return PROC_RES_FINISH;
}

//--------------------------------------------------------------
/**
 * @brief   vZX֐FC
 *
 * @param   proc		vZXf[^
 * @param   seq			V[PX
 *
 * @retval  
 */
//--------------------------------------------------------------
PROC_RESULT ActinProc_Main( PROC * proc, int * seq )
{
	ACTIN_PROC_WORK * apw  = PROC_GetWork( proc );
	int ret;
	enum{
		SEQ_IN,
		SEQ_MAIN,
		SEQ_OUT,
	};
	
	contest_rand(apw->consys);
	
	switch( *seq ){
	case SEQ_IN:
		if( IsFinishedBrightnessChg(MASK_DOUBLE_DISPLAY) ){
			*seq = SEQ_MAIN;
		}
		break;

	case SEQ_MAIN:
		if(ConTool_ServerMineCheck(apw->consys) == TRUE){
			ret = ActinMainSeqTbl[apw->tbl_seq_no](apw, &apw->local);
			if(ret == ASRET_NEXT || ret == ASRET_SELECT_SEQ){
				if(ret == ASRET_NEXT){
					apw->tbl_seq_no++;
				}
				else{
					apw->tbl_seq_no = apw->local.select_seq;
				}
				MI_CpuClear8(&apw->local, sizeof(ACTIN_LOCAL_WORK));
			}
			else if(ret == ASRET_END){
				*seq = SEQ_OUT;
				MI_CpuClear8(&apw->local, sizeof(ACTIN_LOCAL_WORK));
				break;
			}
		}
		
		CO_TransmitCheckExe(&apw->cow);
		CO_RecieveCheckExe(&apw->cow, apw);
		
		if(apw->main_end == TRUE){
			*seq = SEQ_OUT;
			MI_CpuClear8(&apw->local, sizeof(ACTIN_LOCAL_WORK));
		}
		break;

	case SEQ_OUT:
		if(IsFinishedBrightnessChg(MASK_DOUBLE_DISPLAY)){
			return PROC_RES_FINISH;
		}
		break;
	}

	return PROC_RES_CONTINUE;
}

//--------------------------------------------------------------
/**
 * @brief   vZX֐FI
 *
 * @param   proc		vZXf[^
 * @param   seq			V[PX
 *
 * @retval  
 */
//--------------------------------------------------------------
PROC_RESULT ActinProc_End( PROC * proc, int * seq )
{
	ACTIN_PROC_WORK * apw = PROC_GetWork( proc );
	int i;

	Particle_SystemExitAll();
	WES_Delete(apw->sys.wsp);

	//풓OBJ폜
	ActinDefaultOBJDel(apw);
	ActinDefaultOBJDel_Sub(apw);
	//풓BG폜
	ActinDefaultBGDel(apw);
	ActinDefaultBGDel_Sub(apw);

	//BMPJ
	for(i = 0; i < ACTIN_BMPWIN_MAX; i++){
		GF_BGL_BmpWinDel(&apw->sys.win[i]);
	}

	//CBG폜
	GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG0, VISIBLE_OFF );
	GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG1, VISIBLE_OFF );
	GF_BGL_BGControlExit(apw->sys.bgl, ACTIN_FRAME_WIN );
	GF_BGL_BGControlExit(apw->sys.bgl, ACTIN_FRAME_EFF );
	GF_BGL_BGControlExit(apw->sys.bgl, ACTIN_FRAME_AUDIENCE );
	//TuBG폜
	AINPUT_FrameExit(apw->sys.bgl);
	AINPUT_SystemFree(apw->aip);

	//AN^[VXe폜
	CATS_ResourceDestructor_S(apw->sys.csp,apw->sys.crp);
	CATS_FreeMemory(apw->sys.csp);

	//Vram]}l[W[폜
	DellVramTransferManager();

	//\tgEFAXvCg폜
	AT_SoftSpriteDelAll(&apw->sys);
	SoftSpriteEnd(apw->sys.soft_sprite);

	//tHg폜
	FontProc_UnloadFont(FONT_BUTTON);

	//tHgOAMVXe폜
	FONTOAM_SysDelete(apw->sys.fontoam_sys);

	//pbgtF[hVXe폜
	PaletteFadeWorkAllocFree(apw->sys.pfd, FADE_MAIN_BG);
	PaletteFadeWorkAllocFree(apw->sys.pfd, FADE_SUB_BG);
	PaletteFadeWorkAllocFree(apw->sys.pfd, FADE_MAIN_OBJ);
	PaletteFadeWorkAllocFree(apw->sys.pfd, FADE_SUB_OBJ);
	PaletteFadeFree(apw->sys.pfd);

	//bZ[W}l[W̍폜
	STRBUF_Delete(apw->sys.msg_buf);
	WORDSET_Delete(apw->sys.wordset);
	MSGMAN_Delete(apw->sys.actin_msg);
	MSGMAN_Delete(apw->sys.breeder_msg);
	MSGMAN_Delete(apw->sys.explain_msg);
	MSGMAN_Delete(apw->sys.wazakouka_msg);

	//BGLJ
	sys_FreeMemoryEz(apw->sys.bgl);

	TCB_Delete(apw->update_tcb);

	StopTP();		//^b`pl̏I

	PROC_FreeWork(proc);				// [NJ
	
	simple_3DBGExit();
	
	sys_VBlankFuncChange( NULL, NULL );		// VBlankZbg
	sys_HBlankIntrStop();	//HBlank荞ݒ~

	sys_DeleteHeap(HEAPID_ACTIN);

	Overlay_UnloadID(FS_OVERLAY_ID(bc_common));
	return PROC_RES_FINISH;
}

//--------------------------------------------------------------
/**
 * @brief	VBLANK֐
 *
 * @param	work	Z͕Ǘ[Nւ̃|C^
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
static void ActinVBlank(void *work)
{
	ACTIN_PROC_WORK *apw = work;
	
	SoftSpriteTextureTrans(apw->sys.soft_sprite);

	DoVramTransferManager();	// Vram]}l[W[s
	CATS_RenderOamTrans();
	PaletteFadeTrans(apw->sys.pfd);
	
	GF_BGL_VBlankFunc(apw->sys.bgl);
	
	OS_SetIrqCheckFlag( OS_IE_V_BLANK);
}

//--------------------------------------------------------------
/**
 * @brief   C[v̍ŌɍsVXe֘A̍XV
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		apw
 */
//--------------------------------------------------------------
static void ActinUpdate(TCB_PTR tcb, void *work)
{
	ACTIN_PROC_WORK *apw = work;
	
	if(apw->proc_mode == APW_PROC_MODE_MAIN){
		SoftSpriteMain(apw->sys.soft_sprite);
		BattleParticle_Main();
		CATS_Draw(apw->sys.crp);
		CATS_UpdateTransfer();
		G3_SwapBuffers(GX_SORTMODE_MANUAL, GX_BUFFERMODE_Z);
	}
}

//--------------------------------------------------------------
/**
 * @brief   VramoNݒs
 *
 * @param   bgl		BGLf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void ActinSys_VramBankSet(GF_BGL_INI *bgl)
{
	GF_Disp_GX_VisibleControlInit();

	//VRAMݒ
	{
		GF_BGL_DISPVRAM vramSetTable = {
			GX_VRAM_BG_128_C,				// C2DGWBG
			GX_VRAM_BGEXTPLTT_NONE,			// C2DGWBGgpbg
			GX_VRAM_SUB_BG_32_H,			// Tu2DGWBG
			GX_VRAM_SUB_BGEXTPLTT_NONE,		// Tu2DGWBGgpbg
			GX_VRAM_OBJ_64_E,				// C2DGWOBJ
			GX_VRAM_OBJEXTPLTT_NONE,		// C2DGWOBJgpbg
			GX_VRAM_SUB_OBJ_16_I,			// Tu2DGWOBJ
			GX_VRAM_SUB_OBJEXTPLTT_NONE,	// Tu2DGWOBJgpbg
			GX_VRAM_TEX_01_AB,				// eNX`C[WXbg
			GX_VRAM_TEXPLTT_01_FG			// eNX`pbgXbg
		};
		GF_Disp_SetBank( &vramSetTable );

		//VRAMNA
		MI_CpuClear32((void*)HW_BG_VRAM, HW_BG_VRAM_SIZE);
		MI_CpuClear32((void*)HW_DB_BG_VRAM, HW_DB_BG_VRAM_SIZE);
		MI_CpuClear32((void*)HW_OBJ_VRAM, HW_OBJ_VRAM_SIZE);
		MI_CpuClear32((void*)HW_DB_OBJ_VRAM, HW_DB_OBJ_VRAM_SIZE);
	}

	// BG SYSTEM
	{
		GF_BGL_SYS_HEADER BGsys_data = {
			GX_DISPMODE_GRAPHICS, GX_BGMODE_0, GX_BGMODE_0, GX_BG0_AS_3D,
		};
		GF_BGL_InitBG( &BGsys_data );
	}

	//Cʃt[ݒ
	{
		GF_BGL_BGCNT_HEADER TextBgCntDat[] = {
			///<FRAME1_M	EBhE
			{
				0, 0, 0x1000, 0, GF_BGL_SCRSIZ_512x256, GX_BG_COLORMODE_16,
//				0, 0, 0x0800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
				GX_BG_SCRBASE_0x0000, GX_BG_CHARBASE_0x04000, GX_BG_EXTPLTT_01,
				ACTIN_BGPRI_WINDOW, 0, 0, FALSE
			},
			///<FRAME2_M	GtFNg
			{
				0, 0, 0x2000, 0, GF_BGL_SCRSIZ_512x512, GX_BG_COLORMODE_16,
				GX_BG_SCRBASE_0x1000, GX_BG_CHARBASE_0x0c000, GX_BG_EXTPLTT_01,
				ACTIN_BGPRI_EFFECT, 0, 0, FALSE
			},
			///<FRAME3_M	wi
			{
				0, 0, 0x1000, 0, GF_BGL_SCRSIZ_512x256, GX_BG_COLORMODE_16,
				GX_BG_SCRBASE_0x3000, GX_BG_CHARBASE_0x10000, GX_BG_EXTPLTT_01,
				ACTIN_BGPRI_BACKGROUND, 0, 0, FALSE
			},
		};
		GF_BGL_BGControlSet(bgl, ACTIN_FRAME_WIN, &TextBgCntDat[0], GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear(bgl, ACTIN_FRAME_WIN );
		GF_BGL_ScrollSet(bgl, ACTIN_FRAME_WIN, GF_BGL_SCROLL_X_SET, FRAME_WIN_DEFAULT_X);
		GF_BGL_ScrollSet(bgl, ACTIN_FRAME_WIN, GF_BGL_SCROLL_Y_SET, FRAME_WIN_DEFAULT_Y);
		GF_BGL_BGControlSet(bgl, ACTIN_FRAME_EFF, &TextBgCntDat[1], GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear(bgl, ACTIN_FRAME_EFF );
		GF_BGL_ScrollSet(bgl, ACTIN_FRAME_EFF, GF_BGL_SCROLL_X_SET, 0);
		GF_BGL_ScrollSet(bgl, ACTIN_FRAME_EFF, GF_BGL_SCROLL_Y_SET, 0);
		GF_BGL_BGControlSet(bgl, ACTIN_FRAME_AUDIENCE, &TextBgCntDat[2], GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear(bgl, ACTIN_FRAME_AUDIENCE );
		GF_BGL_ScrollSet(bgl, ACTIN_FRAME_AUDIENCE, GF_BGL_SCROLL_X_SET, 0);
		GF_BGL_ScrollSet(bgl, ACTIN_FRAME_AUDIENCE, GF_BGL_SCROLL_Y_SET, 0);

		G2_SetBG0Priority(ACTIN_3DBG_PRIORITY);
		GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG0, VISIBLE_ON );
	}
	//Tuʃt[ݒ
	{
		AINPUT_DefaultFrameSet(bgl);
	}
}

//--------------------------------------------------------------
/**
 * @brief   BMPEBhEݒ肷
 *
 * @param   apw		Z͊Ǘ[Nւ̃|C^
 */
//--------------------------------------------------------------
static void ActinSys_DefaultBmpWinAdd(ACTIN_PROC_WORK *apw)
{
	GF_BGL_BmpWinAdd(apw->sys.bgl, &apw->sys.win[ACTIN_BMPWIN_TALK], ACTIN_FRAME_WIN, 
		11, 0x13, 20, 4, BMPWIN_TALK_COLOR, BMPWIN_TALK_CGX_OFFSET);

#if 0
	GF_BGL_BmpWinAdd(apw->sys.bgl, &apw->sys.win[ACTIN_BMPWIN_BREEDER_0], ACTIN_FRAME_WIN, 
		23, 0+CONTEST_ADD_BMP_Y, 8, 4, BMPWIN_BREEDER0_COLOR, BMPWIN_BREEDER0_CGX_OFFSET);
	GF_BGL_BmpWinAdd(apw->sys.bgl, &apw->sys.win[ACTIN_BMPWIN_BREEDER_1], ACTIN_FRAME_WIN, 
		23, 6+CONTEST_ADD_BMP_Y, 8, 4, BMPWIN_BREEDER1_COLOR, BMPWIN_BREEDER1_CGX_OFFSET);
	GF_BGL_BmpWinAdd(apw->sys.bgl, &apw->sys.win[ACTIN_BMPWIN_BREEDER_2], ACTIN_FRAME_WIN, 
		23, 12+CONTEST_ADD_BMP_Y, 8, 4, BMPWIN_BREEDER2_COLOR, BMPWIN_BREEDER2_CGX_OFFSET);
	GF_BGL_BmpWinAdd(apw->sys.bgl, &apw->sys.win[ACTIN_BMPWIN_BREEDER_3], ACTIN_FRAME_WIN, 
		23, 18+CONTEST_ADD_BMP_Y, 8, 4, BMPWIN_BREEDER3_COLOR, BMPWIN_BREEDER3_CGX_OFFSET);
#endif
}

//--------------------------------------------------------------
/**
 * @brief   Zpp[eBN
 */
//--------------------------------------------------------------
static void ActinParticleInit(void)
{
	//--------------------------------------------------------------
	//	
	//--------------------------------------------------------------
	// }l[WeNX`C[WXbgwXbgǗł悤ɂ
	// ftHg}l[WɂB
	NNS_GfdInitFrmTexVramManager(2, TRUE);
		
	// }l[Wpbg32KBǗł悤ɂ
	// ftHg}l[WɂB
	NNS_GfdInitFrmPlttVramManager(0x8000, TRUE);

	//|PŎgp镪m
	NNS_GfdAllocFrmTexVram(0x4000, 0, 0);
	NNS_GfdAllocFrmPlttVram(0x20 * 4, 0, NNS_GFD_ALLOC_FROM_LOW);

	//p[eBNVXe[N
	Particle_SystemWorkInit();
}

//--------------------------------------------------------------
/**
 * @brief   Z͕Ǘ[N̏p[^Zbg
 * @param   apw		Z͕Ǘ[Nւ̃|C^
 */
//--------------------------------------------------------------
static void ActinSystemWorkInit(ACTIN_PROC_WORK *apw)
{
	int i;
	
	GF_ASSERT(apw->consys != NULL);
	
	for(i = 0; i < BREEDER_MAX; i++){
		apw->a_game.breeder_sort[i] = i;
	}

	ActinOrder_WorkInit(apw);
}

//--------------------------------------------------------------
/**
 * @brief   Z͕Ŏgp{Iȏ풓OBJ̓o^s
 * @param   apw		Z͕Ǘ[Nւ̃|C^
 */
//--------------------------------------------------------------
static void ActinDefaultOBJSet(ACTIN_PROC_WORK *apw)
{
	//풓OBJpbg[h
	CATS_LoadResourcePlttWorkArc(apw->sys.pfd, FADE_MAIN_OBJ, apw->sys.csp, apw->sys.crp, 
		ARC_CONTEST_OBJ, CONTEST_OBJ_NCLR, 0, 
		ACTIN_COMMON_PAL_NUM, NNS_G2D_VRAM_TYPE_2DMAIN, PLTTID_OBJ_COMMON);
	//tHgOAMpbg[h
	CATS_LoadResourcePlttWorkArc(apw->sys.pfd, FADE_MAIN_OBJ, apw->sys.csp, apw->sys.crp, 
		ARC_CONTEST_OBJ, CONTEST_FONTOBJ_NCLR, 0, 
		1, NNS_G2D_VRAM_TYPE_2DMAIN, PLTTID_FONTACT);
	
	AT_NextIconResourceLoad(apw->sys.csp, apw->sys.crp);
	
	AT_BreederPanelFontOamCreateAll(apw);
	AT_JudgeAddAll(&apw->sys, apw->consys);
	AT_SpecialHeartSet(&apw->sys, apw->consys->c_game.special_judge_no);
	
	AT_JudgeReactionIconResourceLoad(apw->sys.pfd, apw->sys.csp, apw->sys.crp);
	AT_JudgeReactionIconActorAdd(&apw->sys);
}

//--------------------------------------------------------------
/**
 * @brief   Z͕Ŏgp{Iȏ풓OBJ̍폜s
 * @param   apw		Z͕Ǘ[Nւ̃|C^
 */
//--------------------------------------------------------------
static void ActinDefaultOBJDel(ACTIN_PROC_WORK *apw)
{
	AT_SpecialHeartDel(&apw->sys);
	AT_JudgeDelAll(&apw->sys);
	AT_BreederPanelFontOamDeleteAll(apw);
	AT_NextIconActorDelAll(&apw->sys);
	
	AT_NextIconResourceFree(apw->sys.crp);
	CATS_FreeResourcePltt(apw->sys.crp, PLTTID_OBJ_COMMON);
	CATS_FreeResourcePltt(apw->sys.crp, PLTTID_FONTACT);
	
	AT_JudgeReactionIconActorDel(&apw->sys);
	AT_JudgeReactionIconResourceDel(apw->sys.crp);
}

//--------------------------------------------------------------
/**
 * @brief   TuOBJFZ͕Ŏgp{Iȏ풓OBJ̓o^s
 * @param   apw		Z͕Ǘ[Nւ̃|C^
 */
//--------------------------------------------------------------
static void ActinDefaultOBJSet_Sub(ACTIN_PROC_WORK *apw)
{
	//풓OBJpbg[h
	CATS_LoadResourcePlttWorkArc(apw->sys.pfd, FADE_SUB_OBJ, apw->sys.csp, apw->sys.crp, 
		ARC_CONTEST_OBJ, CONTEST_SUB_OBJ_NCLR, 0, 
		ACTIN_SUB_COMMON_PAL_NUM, NNS_G2D_VRAM_TYPE_2DSUB, PLTTID_OBJ_COMMON_SUB);
	//tHgOAMpbg[h
	CATS_LoadResourcePlttWorkArc(apw->sys.pfd, FADE_SUB_OBJ, apw->sys.csp, apw->sys.crp, 
		ARC_CONTEST_OBJ, CONTEST_FONTOBJ_NCLR, 0, 
		1, NNS_G2D_VRAM_TYPE_2DSUB, PLTTID_SUB_FONTACT);
	
	AT_AppealPointResourceLoad(apw->sys.csp, apw->sys.crp);
	AT_VoltagePointResourceLoad(apw->sys.csp, apw->sys.crp);
}

//--------------------------------------------------------------
/**
 * @brief   TuOBJFZ͕Ŏgp{Iȏ풓OBJ̍폜s
 * @param   apw		Z͕Ǘ[Nւ̃|C^
 */
//--------------------------------------------------------------
static void ActinDefaultOBJDel_Sub(ACTIN_PROC_WORK *apw)
{
	CATS_FreeResourcePltt(apw->sys.crp, PLTTID_OBJ_COMMON_SUB);

	AT_AppealPointResourceFree(apw->sys.crp);
	AT_AppealPointActorDelAll(&apw->sys);
	AT_VoltagePointResourceFree(apw->sys.crp);
	AT_VoltagePointActorDelAll(&apw->sys);
}

//--------------------------------------------------------------
/**
 * @brief   GtFNgʂɃu[_[plBGWJ
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   eff_bg_type ZbgBG̃^Cv(EFF_BG_TYPE_???)
 * @param   disp_set	TRUE:DISPCNTŃGtFNgʂONɂ
 */
//--------------------------------------------------------------
void ActinBG_BrdPanelSet(ACTIN_PROC_WORK *apw, int eff_bg_type, int disp_set)
{
	if(eff_bg_type == EFF_BG_TYPE_BRDPANEL){
		//LN^FƂ肠EBhELƓ̂WJ
		ArcUtil_BgCharSet(ARC_CONTEST_BG, PANEL_NCGR_BIN, apw->sys.bgl, 
			ACTIN_FRAME_BRDPANEL, 0, 0x4000, 1, HEAPID_ACTIN);
		//XN[
		ArcUtil_ScrnSet(ARC_CONTEST_BG, BRDPANEL_NSCR_BIN, apw->sys.bgl, 
			ACTIN_FRAME_BRDPANEL, 0, 0, 1, HEAPID_ACTIN);
		//BGvCIeB
		GF_BGL_PrioritySet(ACTIN_FRAME_WIN, ACTIN_BGPRI_EFFECT);
		GF_BGL_PrioritySet(ACTIN_FRAME_BRDPANEL, ACTIN_BGPRI_WINDOW);
		
		BreederPanelColorChangeAll(apw);
	
		if(disp_set == TRUE){
			GF_Disp_GX_VisibleControl(GX_PLANEMASK_BG2, VISIBLE_ON);
		}
	}
	else{
		GF_BGL_ClearCharSet(ACTIN_FRAME_BRDPANEL, 0x4000, 0, HEAPID_ACTIN);
		GF_BGL_ScrClear(apw->sys.bgl, ACTIN_FRAME_BRDPANEL);
		//BGvCIeB
		GF_BGL_PrioritySet(ACTIN_FRAME_WIN, ACTIN_BGPRI_WINDOW);
		GF_BGL_PrioritySet(ACTIN_FRAME_BRDPANEL, ACTIN_BGPRI_EFFECT);
	}
}

//--------------------------------------------------------------
/**
 * @brief   CBGFZ͕Ŏgp{BGf[^̃Zbgs
 * @param   apw		Z͕Ǘ[Nւ̃|C^
 */
//--------------------------------------------------------------
static void ActinDefaultBGSet(ACTIN_PROC_WORK *apw)
{
	//ϋq
	ArcUtil_BgCharSet(ARC_CONTEST_BG, CON_BG_NCGR_BIN, apw->sys.bgl, 
		ACTIN_FRAME_AUDIENCE, 0, 0, 1, HEAPID_ACTIN);
	ArcUtil_ScrnSet(ARC_CONTEST_BG, CON_BG_NSCR_BIN, apw->sys.bgl, 
		ACTIN_FRAME_AUDIENCE, 0, 0, 1, HEAPID_ACTIN);
	
	//EBhE
	ArcUtil_BgCharSet(ARC_CONTEST_BG, PANEL_NCGR_BIN, apw->sys.bgl, 
		ACTIN_FRAME_WIN, 0, 0, 1, HEAPID_ACTIN);
	ArcUtil_ScrnSet(ARC_CONTEST_BG, PANEL_NSCR_BIN, apw->sys.bgl, 
		ACTIN_FRAME_WIN, 0, 0, 1, HEAPID_ACTIN);
	
	//GtFNg
//	GF_BGL_ScrClear(apw->sys.bgl, ACTIN_FRAME_EFF);
	ActinBG_BrdPanelSet(apw, EFF_BG_TYPE_BRDPANEL, FALSE);
	
	//pbg
	PaletteWorkSet_Arc(apw->sys.pfd, ARC_CONTEST_BG, CONTEST_BG_NCLR, 
		HEAPID_ACTIN, FADE_MAIN_BG, 0, 0);
}

//--------------------------------------------------------------
/**
 * @brief   CBGFZ͕Ŏgp{BGf[^̍폜s
 * @param   apw		Z͕Ǘ[Nւ̃|C^
 */
//--------------------------------------------------------------
static void ActinDefaultBGDel(ACTIN_PROC_WORK *apw)
{
	return;
}

//--------------------------------------------------------------
/**
 * @brief   TuBGFZ͕Ŏgp{BGf[^̃Zbgs
 * @param   apw		Z͕Ǘ[Nւ̃|C^
 */
//--------------------------------------------------------------
static void ActinDefaultBGSet_Sub(ACTIN_PROC_WORK *apw)
{
	//pbg
//	PaletteWorkSet_Arc(apw->sys.pfd, ARC_CONTEST_BG, CONTEST_SUB_NCLR, 
//		HEAPID_ACTIN, FADE_SUB_BG, 0, 0);
}

//--------------------------------------------------------------
/**
 * @brief   TuBGFZ͕Ŏgp{BGf[^̍폜s
 * @param   apw		Z͕Ǘ[Nւ̃|C^
 */
//--------------------------------------------------------------
static void ActinDefaultBGDel_Sub(ACTIN_PROC_WORK *apw)
{
	return;
}




//==============================================================================
//
//	V[PX
//
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   Z̓V[PXF
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   local		[J[Nւ̃|C^
 *
 * @retval  ptO
 */
//--------------------------------------------------------------
static int ActinSeq_Init(ACTIN_PROC_WORK *apw, ACTIN_LOCAL_WORK *local)
{
	switch(local->seq){
	case 0:
		//AT_SoftSpriteAddAll(&apw->sys);
		if(CO_OrderSet(&apw->cow, apw, AORDER_NO_POKEMON_SPRITE_ADD_ALL, NULL) == TRUE){
			local->seq++;
		}
		break;
	default:
		//if(CO_RequestBitNumCheck(&apw->cow) == 0){
		if(CO_AnswerCountCheck(&apw->cow, apw->consys->c_game.player_num, 
				apw->consys->c_game.my_breeder_no, apw->consys->c_game.server_no) == TRUE){
			return ASRET_NEXT;
		}
		break;
	}
	return ASRET_CONTINUE;
}

//--------------------------------------------------------------
/**
 * @brief   Z̓V[PXFŏ̃bZ[W\
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   local		[J[Nւ̃|C^
 *
 * @retval  ptO
 */
//--------------------------------------------------------------
static int ActinSeq_FastTalk(ACTIN_PROC_WORK *apw, ACTIN_LOCAL_WORK *local)
{
	switch(local->seq){
	case 0:
		if(apw->consys->c_game.mode == CONMODE_CHARM){
			apw->advance.nt.a_talk_id = A_TALK_ACT_HOST_02;
		}
		else{
			apw->advance.nt.a_talk_id = A_TALK_ACT_HOST_01;
		}
		apw->advance.nt.a_talk_bmpwin_close_wait = CONTEST_MESSAGE_END_WAIT;
		apw->advance.nt.a_talk_bmpwin_not_close = 0;
		if(CO_OrderSet(&apw->cow, apw, AORDER_NO_TALK, &apw->advance) == TRUE){
			local->seq++;
		}
		break;
	default:
		//if(CO_RequestBitNumCheck(&apw->cow) == 0){
		if(CO_AnswerCountCheck(&apw->cow, apw->consys->c_game.player_num, 
				apw->consys->c_game.my_breeder_no, apw->consys->c_game.server_no) == TRUE){
			return ASRET_NEXT;
		}
		break;
	}
	return ASRET_CONTINUE;
}

//--------------------------------------------------------------
/**
 * @brief   Z̓V[PXF^[Jn
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   local		[J[Nւ̃|C^
 *
 * @retval  ptO
 */
//--------------------------------------------------------------
static int ActinSeq_TurnStart(ACTIN_PROC_WORK *apw, ACTIN_LOCAL_WORK *local)
{
//	int i;
	
	switch(local->seq){
	case 0:
	default:
//		for(i = 0; i < BREEDER_MAX; i++){
//			apw->advance.now_sort[i] = apw->a_game.breeder_sort[i];
//		}
		return ASRET_NEXT;
	}
	return ASRET_CONTINUE;
}

//--------------------------------------------------------------
/**
 * @brief   Z̓V[PXFRI
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   local		[J[Nւ̃|C^
 *
 * @retval  ptO
 */
//--------------------------------------------------------------
static int ActinSeq_JudgeSelect(ACTIN_PROC_WORK *apw, ACTIN_LOCAL_WORK *local)
{
	switch(local->seq){
	case 0:
		if(CO_OrderSet(&apw->cow, apw, AORDER_NO_JUDGE_SELECT, NULL) == TRUE){
			local->seq++;
		}
		break;
	case 1:
//		if(CO_RequestBitNumCheck(&apw->cow) == 0){
		if(CO_AnswerCountCheck(&apw->cow, apw->consys->c_game.player_num, 
				apw->consys->c_game.my_breeder_no, apw->consys->c_game.server_no) == TRUE){
			local->seq++;
		}
		break;
	case 2:
		//CPUAIvZ
		{
			int i;
			
			for(i = apw->consys->c_game.player_num; i < BREEDER_MAX; i++){
				apw->a_game.judge_no[i] = contest_rand(apw->consys) % JUDGE_MAX;
			}
		}
		local->seq++;
		break;
	default:
		return ASRET_NEXT;
	}
	return ASRET_CONTINUE;
}

//--------------------------------------------------------------
/**
 * @brief   Z̓V[PXFZI
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   local		[J[Nւ̃|C^
 *
 * @retval  ptO
 */
//--------------------------------------------------------------
static int ActinSeq_WazaSelect(ACTIN_PROC_WORK *apw, ACTIN_LOCAL_WORK *local)
{
	switch(local->seq){
	case 0:
		if(CO_OrderSet(&apw->cow, apw, AORDER_NO_WAZA_SELECT, NULL) == TRUE){
			local->seq++;
		}
		break;
	case 1:
//		if(CO_RequestBitNumCheck(&apw->cow) == 0){
		if(CO_AnswerCountCheck(&apw->cow, apw->consys->c_game.player_num, 
				apw->consys->c_game.my_breeder_no, apw->consys->c_game.server_no) == TRUE){
			local->seq++;
		}
		break;
	case 2:
		//CPUAIvZ
		{
			int i;
			
			for(i = apw->consys->c_game.player_num; i < BREEDER_MAX; i++){
				apw->a_game.waza_no[i] = 
					apw->consys->c_game.bd[i].waza[contest_rand(apw->consys) % WAZA_TEMOTI_MAX];
			}
		}
		local->seq++;
		break;
	default:
	#if 0
		//ZʌvZ
		{
			int i;
			
			//AWAZA_Calc(apw, &apw->advance.wazapara);
			//vAPlɉZ
			for(i = 0; i < BREEDER_MAX; i++){
				apw->a_game.app_total[i] += apw->advance.wazapara.personal[i].app_total;
			}
		}
	#endif
		AWAZA_WazaParaTurnInit(apw, &apw->advance.wazapara);
		return ASRET_NEXT;
	}
	return ASRET_CONTINUE;
}

//--------------------------------------------------------------
/**
 * @brief   Z̓V[PXFɏou[_[I(eu[_[Zn߂Oɍs)
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   local		[J[Nւ̃|C^
 *
 * @retval  ptO
 */
//--------------------------------------------------------------
static int ActinSeq_SelectBreeder(ACTIN_PROC_WORK *apw, ACTIN_LOCAL_WORK *local)
{
	int now_breeder, i, check_breeder;
	
	now_breeder = apw->a_game.breeder_sort[apw->a_game.breeder_end_count];
	
	apw->advance.now_breeder = now_breeder;
	apw->advance.now_pos = apw->a_game.breeder_end_count;
//	apw->advance.waza_no = apw->a_game.waza_no[now_breeder];
	apw->advance.judge_no = apw->a_game.judge_no[now_breeder];
	
	apw->advance.judge_reaction_type = JUDGE_REACTION_ICON_NOMINATION;
	for(i = 0; i < apw->a_game.breeder_end_count; i++){
		check_breeder = apw->a_game.breeder_sort[i];
		if(apw->a_game.judge_no[check_breeder] == apw->a_game.judge_no[now_breeder]){
			apw->advance.judge_reaction_type = JUDGE_REACTION_ICON_WEAR;
		}
	}
	
	AT_MsgTagParaInitDataSet(apw, &apw->advance.nt.a_talk_tagpara, now_breeder);
	AT_MsgTagParaInitDataSet(apw, &apw->advance.nt.after_a_talk_tagpara, now_breeder);

#if 0
	//-- ZʌvZ --//
	apw->advance.waza_personal = apw->advance.wazapara.personal[now_breeder];
	//ZʌvZʂq@łKvȂ̂
	for(i = 0; i < BREEDER_MAX; i++){
		apw->advance.next_sort[i] = apw->advance.wazapara.personal[i].next_sort;
		apw->advance.next_pos[i] = apw->advance.wazapara.personal[i].next_pos;
	}
#endif

#if 0
	{
		int ap_point, ap_point_calc, judge_suffer, voltage_addsub, voltage_calc, voltage_now;
		int voltage_add_ap;

		//{AP擾
		ap_point = ACALC_BaseAppealGet(apw->advance.waza_no);
		//R`FbN
		judge_suffer = ACALC_JudgeSufferCheck(&apw->a_game, apw->advance.now_breeder);
		//{e[W`FbN
		voltage_addsub = ACALC_VoltageUpDownCheck(apw->consys->c_game.type, apw->advance.waza_no,
			apw->advance.judge_no, apw->consys->c_game.special_judge_no);
		//{e[WZ
		voltage_now = apw->a_game.voltage_total[apw->advance.judge_no];
		voltage_calc = ACALC_VoltageAdd(&apw->a_game, apw->advance.judge_no, voltage_addsub);
		voltage_add_ap = 0;
		if(voltage_calc == VOLTAGE_POINT_FULL){
			if(apw->advance.judge_no == apw->consys->c_game.special_judge_no){
				voltage_add_ap = VOLTAGE_FULL_ADD_AP_SPECIAL;
			}
			else{
				voltage_add_ap = VOLTAGE_FULL_ADD_AP;
			}
		}
		
		//vvZ
		ap_point_calc = ap_point - (judge_suffer * APPEAL_ICON_ONE_POINT);
		if(ap_point_calc < 0){
			ap_point_calc = 0;
		}
		
		apw->advance.ap_point = ap_point;
		apw->advance.judge_suffer = judge_suffer;
		apw->advance.voltage_now = voltage_now;
		apw->advance.voltage_calc = voltage_calc;
		apw->advance.voltage_add_ap = voltage_add_ap;
		apw->advance.ap_point_calc = ap_point_calc;
		//vAPlɉZ
		apw->a_game.app_total[apw->advance.now_breeder] += ap_point_calc + voltage_add_ap;
	}
#endif

	return ASRET_NEXT;
}

//--------------------------------------------------------------
/**
 * @brief   Z̓V[PXF|Po
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   local		[J[Nւ̃|C^
 *
 * @retval  ptO
 */
//--------------------------------------------------------------
static int ActinSeq_PokemonIn(ACTIN_PROC_WORK *apw, ACTIN_LOCAL_WORK *local)
{
	switch(local->seq){
	case 0:
		if(CO_OrderSet(&apw->cow, apw, AORDER_NO_POKEMON_IN, &apw->advance) == TRUE){
			local->seq++;
		}
		break;
	default:
//		if(CO_RequestBitNumCheck(&apw->cow) == 0){
		if(CO_AnswerCountCheck(&apw->cow, apw->consys->c_game.player_num, 
				apw->consys->c_game.my_breeder_no, apw->consys->c_game.server_no) == TRUE){
			return ASRET_NEXT;
		}
		break;
	}
	return ASRET_CONTINUE;
}

//--------------------------------------------------------------
/**
 * @brief   Z̓V[PXFZGtFNgoȌ
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   local		[J[Nւ̃|C^
 *
 * @retval  ptO
 */
//--------------------------------------------------------------
static int ActinSeq_WazaEffectBefore(ACTIN_PROC_WORK *apw, ACTIN_LOCAL_WORK *local)
{
	switch(local->seq){
	case 0:
		apw->advance.nt.a_talk_id = A_TALK_NULL;
		if(CO_OrderSet(&apw->cow, apw, AORDER_NO_WAZAEFFECT_BEFORE, &apw->advance) == TRUE){
			local->seq++;
		}
		break;
	default:
//		if(CO_RequestBitNumCheck(&apw->cow) == 0){
		if(CO_AnswerCountCheck(&apw->cow, apw->consys->c_game.player_num, 
				apw->consys->c_game.my_breeder_no, apw->consys->c_game.server_no) == TRUE){
			apw->advance.nt.a_talk_id = A_TALK_NULL;
			return ASRET_NEXT;
		}
		break;
	}
	return ASRET_CONTINUE;
}

//--------------------------------------------------------------
/**
 * @brief   Z̓V[PXFZGtFNgo
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   local		[J[Nւ̃|C^
 *
 * @retval  ptO
 */
//--------------------------------------------------------------
static int ActinSeq_WazaEffect(ACTIN_PROC_WORK *apw, ACTIN_LOCAL_WORK *local)
{
	switch(local->seq){
	case 0:
		apw->advance.nt.a_talk_id = A_TALK_WAZA_APPEAL;
		if(CO_OrderSet(&apw->cow, apw, AORDER_NO_WAZAEFFECT, &apw->advance) == TRUE){
			local->seq++;
		}
		break;
	default:
//		if(CO_RequestBitNumCheck(&apw->cow) == 0){
		if(CO_AnswerCountCheck(&apw->cow, apw->consys->c_game.player_num, 
				apw->consys->c_game.my_breeder_no, apw->consys->c_game.server_no) == TRUE){
			apw->advance.nt.a_talk_id = A_TALK_NULL;
			return ASRET_NEXT;
		}
		break;
	}
	return ASRET_CONTINUE;
}

//--------------------------------------------------------------
/**
 * @brief   Z̓V[PXFoZ̕]s(o)
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   local		[J[Nւ̃|C^
 *
 * @retval  ptO
 */
//--------------------------------------------------------------
static int ActinSeq_AppealReview(ACTIN_PROC_WORK *apw, ACTIN_LOCAL_WORK *local)
{
#if 0
	switch(local->seq){
	case 0:		//ʂ𑗐M
		if(CO_OrderSet(&apw->cow, apw, AORDER_NO_APPEAL_REVIEW, &apw->advance) == TRUE){
			local->seq++;
		}
		break;
	default:
//		if(CO_RequestBitNumCheck(&apw->cow) == 0){
		if(CO_AnswerCountCheck(&apw->cow, apw->consys->c_game.player_num, 
				apw->consys->c_game.my_breeder_no, apw->consys->c_game.server_no) == TRUE){
			return ASRET_NEXT;
		}
		break;
	}
#else
	enum{
		AR_INIT,
		AR_WAZA_CALC,
		AR_WAZA_REQ,
		AR_WAZA_WAIT,
		AR_KOUKA_CALC,
		AR_KOUKA_REQ,
		AR_KOUKA_WAIT,
		AR_SP_KOUKA_CALC,
		AR_SP_KOUKA_REQ,
		AR_SP_KOUKA_WAIT,
		AR_VOLTAGE_CALC,
		AR_VOLTAGE_REQ,
		AR_VOLTAGE_WAIT,
	};
	
	switch(local->seq){
	case AR_INIT:
		AWAZA_WazaParaBreederInit(apw, &apw->advance.wazapara, apw->advance.now_breeder);
		local->seq++;
		break;
	
	case AR_WAZA_CALC:
		AWAZA_BaseAP(apw, &apw->advance.wazapara, apw->advance.now_breeder);
		local->seq++;
		//break;
	case AR_WAZA_REQ:
		if(CO_OrderSet(&apw->cow, apw, AORDER_NO_APPEAL_FIRST, &apw->advance) == TRUE){
			local->seq++;
		}
		break;
	case AR_WAZA_WAIT:
//		if(CO_RequestBitNumCheck(&apw->cow) == 0){
		if(CO_AnswerCountCheck(&apw->cow, apw->consys->c_game.player_num, 
				apw->consys->c_game.my_breeder_no, apw->consys->c_game.server_no) == TRUE){
			local->seq++;
		}
		break;

	case AR_KOUKA_CALC:
		AWAZA_Kouka(apw, &apw->advance.wazapara, apw->advance.now_breeder, apw->advance.now_pos);
		local->seq++;
		//break;
	case AR_KOUKA_REQ:
		if(CO_OrderSet(&apw->cow, apw, AORDER_NO_APPEAL_KOUKA, &apw->advance) == TRUE){
			local->seq++;
		}
		break;
	case AR_KOUKA_WAIT:
//		if(CO_RequestBitNumCheck(&apw->cow) == 0){
		if(CO_AnswerCountCheck(&apw->cow, apw->consys->c_game.player_num, 
				apw->consys->c_game.my_breeder_no, apw->consys->c_game.server_no) == TRUE){
			local->seq++;
		}
		break;

	case AR_SP_KOUKA_CALC:
		AWAZA_KoukaSpecial(apw, &apw->advance.wazapara, apw->advance.now_breeder, apw->advance.now_pos);
		local->seq++;
		//break;
	case AR_SP_KOUKA_REQ:
		if(CO_OrderSet(&apw->cow, apw, AORDER_NO_APPEAL_SPECIAL_KOUKA, &apw->advance) == TRUE){
			local->seq++;
		}
		break;
	case AR_SP_KOUKA_WAIT:
//		if(CO_RequestBitNumCheck(&apw->cow) == 0){
		if(CO_AnswerCountCheck(&apw->cow, apw->consys->c_game.player_num, 
				apw->consys->c_game.my_breeder_no, apw->consys->c_game.server_no) == TRUE){
			local->seq++;
		}
		break;

	case AR_VOLTAGE_CALC:
		AWAZA_Voltage(apw, &apw->advance.wazapara, apw->advance.now_breeder, &apw->advance.nt);
		local->seq++;
		//break;
	case AR_VOLTAGE_REQ:
		if(CO_OrderSet(&apw->cow, apw, AORDER_NO_APPEAL_VOLTAGE, &apw->advance) == TRUE){
			local->seq++;
		}
		break;
	case AR_VOLTAGE_WAIT:
//		if(CO_RequestBitNumCheck(&apw->cow) == 0){
		if(CO_AnswerCountCheck(&apw->cow, apw->consys->c_game.player_num, 
				apw->consys->c_game.my_breeder_no, apw->consys->c_game.server_no) == TRUE){
			local->seq++;
		}
		break;
	
	default:
		AWAZA_WazaParaBreederGameUpdate(apw, &apw->advance.wazapara, apw->advance.now_breeder);
		return ASRET_NEXT;
	}
#endif
	return ASRET_CONTINUE;
}

//--------------------------------------------------------------
/**
 * @brief   Z̓V[PXF|Pޏ
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   local		[J[Nւ̃|C^
 *
 * @retval  ptO
 */
//--------------------------------------------------------------
static int ActinSeq_PokemonOut(ACTIN_PROC_WORK *apw, ACTIN_LOCAL_WORK *local)
{
	int now;
	
	switch(local->seq){
	case 0:
		if(CO_OrderSet(&apw->cow, apw, AORDER_NO_POKEMON_OUT, &apw->advance) == TRUE){
			local->seq++;
		}
		break;
	default:
//		if(CO_RequestBitNumCheck(&apw->cow) == 0){
		if(CO_AnswerCountCheck(&apw->cow, apw->consys->c_game.player_num, 
				apw->consys->c_game.my_breeder_no, apw->consys->c_game.server_no) == TRUE){
			return ASRET_NEXT;
		}
		break;
	}
	return ASRET_CONTINUE;
}

//--------------------------------------------------------------
/**
 * @brief   Z̓V[PXF̃u[_[֐iޑǑ㏈
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   local		[J[Nւ̃|C^
 *
 * @retval  ptO
 */
//--------------------------------------------------------------
static int ActinSeq_NextBreeder(ACTIN_PROC_WORK *apw, ACTIN_LOCAL_WORK *local)
{
//	if(apw->advance.voltage_calc >= VOLTAGE_POINT_FULL){
//		apw->a_game.voltage_total[apw->advance.judge_no] = 0;
//	}

	apw->a_game.breeder_end_count++;
	if(apw->a_game.breeder_end_count >= BREEDER_MAX){
		return ASRET_NEXT;
	}
	else{
		local->select_seq = ASEQ_SELECT_BREEDER;
		return ASRET_SELECT_SEQ;
	}
}

//--------------------------------------------------------------
/**
 * @brief   Z̓V[PXFS̉ZIɔ鉉Z
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   local		[J[Nւ̃|C^
 *
 * @retval  ptO
 */
//--------------------------------------------------------------
static int ActinSeq_AllReviewAfter(ACTIN_PROC_WORK *apw, ACTIN_LOCAL_WORK *local)
{
	enum{
		ARF_INIT,

		ARF_AFTERREVIEW_INIT,
		ARF_AFTERREVIEW_CALC,
		ARF_AFTERREVIEW_REQ,
		ARF_AFTERREVIEW_WAIT,
		ARF_AFTERREVIEW_END,

		ARF_JUDGESUFFER_INIT,
		ARF_JUDGESUFFER_CALC,
		ARF_JUDGESUFFER_REQ,
		ARF_JUDGESUFFER_WAIT,
		ARF_JUDGESUFFER_END,

		ARF_ENDREVIEW_INIT,
		ARF_ENDREVIEW_CALC,
		ARF_ENDREVIEW_REQ,
		ARF_ENDREVIEW_WAIT,
		ARF_ENDREVIEW_END,
	};
	BOOL ret;
	
	switch(local->seq){
	case ARF_INIT:
		local->seq++;
		break;
	
	case ARF_AFTERREVIEW_INIT:
		apw->advance.now_breeder = apw->a_game.breeder_sort[local->work];
		apw->advance.now_pos = local->work;
		//break;
	case ARF_AFTERREVIEW_CALC:
		ret = AWAZA_KoukaAfterTiming(apw, &apw->advance.wazapara, 
			apw->advance.now_breeder, apw->advance.now_pos);
		if(ret == TRUE){
			local->seq++;
		}
		else{
			local->seq = ARF_AFTERREVIEW_END;
		}
		break;
	case ARF_AFTERREVIEW_REQ:
		if(CO_OrderSet(&apw->cow, apw, AORDER_NO_REVIEW_AFTER, &apw->advance) == TRUE){
			local->seq++;
		}
		break;
	case ARF_AFTERREVIEW_WAIT:
//		if(CO_RequestBitNumCheck(&apw->cow) == 0){
		if(CO_AnswerCountCheck(&apw->cow, apw->consys->c_game.player_num, 
				apw->consys->c_game.my_breeder_no, apw->consys->c_game.server_no) == TRUE){
			local->seq++;
		}
		break;
	case ARF_AFTERREVIEW_END:
		local->work++;
		if(local->work >= BREEDER_MAX){
			local->work = 0;
			local->seq++;
		}
		else{
			local->seq = ARF_AFTERREVIEW_INIT;
		}
		break;

	case ARF_JUDGESUFFER_INIT:
		apw->advance.now_breeder = apw->a_game.breeder_sort[local->work];
		apw->advance.now_pos = local->work;
		apw->advance.nt.a_talk_id = A_TALK_JUDGE_LOOK;
		apw->advance.nt.after_a_talk_id = A_TALK_NULL;
		AT_MsgTagParaInitDataSet(apw, &apw->advance.nt.a_talk_tagpara, apw->advance.now_breeder);
		AT_MsgTagParaInitDataSet(apw, &apw->advance.nt.after_a_talk_tagpara, 
			apw->advance.now_breeder);
		
		local->seq++;
		//break;
	case ARF_JUDGESUFFER_CALC:
		ret = AWAZA_KoukaJudgeSufferTiming(apw, &apw->advance.wazapara, 
			apw->advance.now_breeder, apw->advance.now_pos);
		if(ret == FALSE){
			AWAZA_JudgeSuffer(apw, &apw->advance.wazapara, apw->advance.now_breeder, 
				&apw->advance.nt);
		}
		local->seq++;
		break;
	case ARF_JUDGESUFFER_REQ:
		if(CO_OrderSet(&apw->cow, apw, AORDER_NO_JUDGE_SUFFER, &apw->advance) == TRUE){
			local->seq++;
		}
		break;
	case ARF_JUDGESUFFER_WAIT:
//		if(CO_RequestBitNumCheck(&apw->cow) == 0){
		if(CO_AnswerCountCheck(&apw->cow, apw->consys->c_game.player_num, 
				apw->consys->c_game.my_breeder_no, apw->consys->c_game.server_no) == TRUE){
			apw->advance.nt.a_talk_id = A_TALK_NULL;
			apw->advance.nt.after_a_talk_id = A_TALK_NULL;
			local->seq++;
		}
		break;
	case ARF_JUDGESUFFER_END:
		local->work++;
		if(local->work >= BREEDER_MAX){
			local->work = 0;
			local->seq++;
		}
		else{
			local->seq = ARF_JUDGESUFFER_INIT;
		}
		break;

	case ARF_ENDREVIEW_INIT:
		apw->advance.now_breeder = apw->a_game.breeder_sort[local->work];
		apw->advance.now_pos = local->work;
		//break;
	case ARF_ENDREVIEW_CALC:
		ret = AWAZA_KoukaAfterTiming(apw, &apw->advance.wazapara, 
			apw->advance.now_breeder, apw->advance.now_pos);
		if(ret == TRUE){
			local->seq++;
		}
		else{
			local->seq = ARF_ENDREVIEW_END;
		}
		break;
	case ARF_ENDREVIEW_REQ:
		if(CO_OrderSet(&apw->cow, apw, AORDER_NO_REVIEW_END, &apw->advance) == TRUE){
			local->seq++;
		}
		break;
	case ARF_ENDREVIEW_WAIT:
//		if(CO_RequestBitNumCheck(&apw->cow) == 0){
		if(CO_AnswerCountCheck(&apw->cow, apw->consys->c_game.player_num, 
				apw->consys->c_game.my_breeder_no, apw->consys->c_game.server_no) == TRUE){
			local->seq++;
		}
		break;
	case ARF_ENDREVIEW_END:
		local->work++;
		if(local->work >= BREEDER_MAX){
			local->work = 0;
			local->seq++;
		}
		else{
			local->seq = ARF_ENDREVIEW_INIT;
		}
		break;
	
	default:
		return ASRET_NEXT;
	}
	
	return ASRET_CONTINUE;
}

//--------------------------------------------------------------
/**
 * @brief   Z̓V[PXFZI̐RRg
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   local		[J[Nւ̃|C^
 *
 * @retval  ptO
 */
//--------------------------------------------------------------
static int ActinSeq_JudgeComment(ACTIN_PROC_WORK *apw, ACTIN_LOCAL_WORK *local)
{
	switch(local->seq){
	case 0:
		local->seq++;
		break;
	case 1:
		if(CO_OrderSet(&apw->cow, apw, AORDER_NO_JUDGE_COMMENT, &apw->advance) == TRUE){
			local->seq++;
		}
		break;
	case 2:
//		if(CO_RequestBitNumCheck(&apw->cow) == 0){
		if(CO_AnswerCountCheck(&apw->cow, apw->consys->c_game.player_num, 
				apw->consys->c_game.my_breeder_no, apw->consys->c_game.server_no) == TRUE){
			local->seq++;
		}
		break;
	default:
		return ASRET_NEXT;
	}
	
	return ASRET_CONTINUE;
}

//--------------------------------------------------------------
/**
 * @brief   Z̓V[PXF݂̃^[I
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   local		[J[Nւ̃|C^
 *
 * @retval  ptO
 */
//--------------------------------------------------------------
static int ActinSeq_TurnEnd(ACTIN_PROC_WORK *apw, ACTIN_LOCAL_WORK *local)
{
	int i;
	
	switch(local->seq){
	case 0:		//p[^XV
		AWAZA_WazaParaTurnGameUpdate(apw, &apw->advance.wazapara);
		
		//u[_[\[g
		ACALC_BreederSort(&apw->a_game);
		
		//ZXV
		for(i = 0; i < BREEDER_MAX; i++){
			apw->a_game.waza_history[i] = apw->a_game.waza_no[i];
		}
		
		apw->a_game.turn++;

		local->seq++;
		break;
	case 1:		//XVp[^SɑM
		//Ƃ肠a_gameSđMBŕKvȂ̂ɕς邩 2005.12.22() check
		if(CO_OrderSet(&apw->cow, apw, AORDER_NO_TURN_PARAM_UPDATE, &apw->a_game) == TRUE){
			local->seq++;
		}
		break;
	case 2:
//		if(CO_RequestBitNumCheck(&apw->cow) == 0){
		if(CO_AnswerCountCheck(&apw->cow, apw->consys->c_game.player_num, 
				apw->consys->c_game.my_breeder_no, apw->consys->c_game.server_no) == TRUE){
			local->seq++;
		}
		break;
	default:
		//ŏI^[mF
		if(apw->a_game.turn >= ACTIN_END_TURN){
			local->select_seq = ASEQ_END;
			return ASRET_SELECT_SEQ;
		}
		else{
			apw->a_game.breeder_end_count = 0;
			local->select_seq = ASEQ_TURN_START;
			return ASRET_SELECT_SEQ;
		}
		break;
	}
	return ASRET_CONTINUE;
}

//--------------------------------------------------------------
/**
 * @brief   Z̓V[PXFI
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   local		[J[Nւ̃|C^
 *
 * @retval  ptO
 */
//--------------------------------------------------------------
static int ActinSeq_End(ACTIN_PROC_WORK *apw, ACTIN_LOCAL_WORK *local)
{
	switch(local->seq){
	case 0:
		if(CO_OrderSet(&apw->cow, apw, AORDER_NO_ACTIN_EXIT, NULL) == TRUE){
			local->seq++;
		}
		break;
	default:
//		if(CO_RequestBitNumCheck(&apw->cow) == 0){
		if(CO_AnswerCountCheck(&apw->cow, apw->consys->c_game.player_num, 
				apw->consys->c_game.my_breeder_no, apw->consys->c_game.server_no) == TRUE){
			return ASRET_END;
		}
		break;
	}
	return ASRET_CONTINUE;
}

