//==============================================================================
/**
 * @file	actin_calc.c
 * @brief	Z͕FZʌvZȂ
 * @author	matsuda
 * @date	2005.12.07()
 */
//==============================================================================
#include "common.h"
#include "contest/contest.h"
#include "actin.h"
#include "actin_tcb_pri.h"
#include "battle/battle_common.h"
#include "system/clact_tool.h"
#include "system/palanm.h"

#include "system/arc_tool.h"
#include "system/arc_util.h"

#include "wazaeffect/battle_particle.h"
#include "system/particle.h"
#include "wazaeffect/we_mana.h"
#include "wazaeffect/we_sys.h"

#include "system/brightness.h"

#include "graphic/contest_bg_def.h"
#include "graphic/contest_obj_def.h"

#include "actin_tool.h"
#include "actin_order.h"
#include "actin_id.h"
#include "actin_input.h"
#include "actin_calc.h"
#include "con_tool.h"

#include "poketool/waza_tool.h"



//==============================================================================
//	f[^
//==============================================================================
///ReXg^CvɂoZ̃^CvƂ̃{e[WQ[W̏㉺
ALIGN4 static const s8 ConTypeVoltageTbl[][5] = {
//AA킢AA܂
	{VOLTAGE_ONE_POINT, 0, -VOLTAGE_ONE_POINT, -VOLTAGE_ONE_POINT, 0},	//
	{0, VOLTAGE_ONE_POINT, 0, -VOLTAGE_ONE_POINT, -VOLTAGE_ONE_POINT},	//
	{-VOLTAGE_ONE_POINT, 0, VOLTAGE_ONE_POINT, 0, -VOLTAGE_ONE_POINT},	//킢
	{-VOLTAGE_ONE_POINT, -VOLTAGE_ONE_POINT, 0, VOLTAGE_ONE_POINT, 0},	//
	{0, -VOLTAGE_ONE_POINT, -VOLTAGE_ONE_POINT, 0, VOLTAGE_ONE_POINT},	//܂
};



//--------------------------------------------------------------
/**
 * @brief   Zԍ{As[|Cg擾
 * @param   wazano		Zԍ
 * @retval  {As[|Cg
 */
//--------------------------------------------------------------
int ACALC_BaseAppealGet(int wazano)
{
	int appeal_no, ap_point;
	
	appeal_no = WT_WazaDataParaGet(wazano, ID_WTD_ap_no);
	ap_point = ConTool_GetAPWaza_App(appeal_no);
	return ap_point;
}

//--------------------------------------------------------------
/**
 * @brief   w肵u[_[I񂾐RAɉlwĂ邩ׂ
 *
 * @param   a_game				Z̓Q[isp[^ւ̃|C^
 * @param   check_breeder		ׂu[_[No
 *
 * @retval  wl(Ȃꍇ0)
 */
//--------------------------------------------------------------
int ACALC_JudgeSufferCheck(ACTIN_GAME_PARAM *a_game, int check_breeder)
{
	int i, count;
	
	count = 0;
	for(i = 0; i < BREEDER_MAX; i++){
		if(a_game->judge_no[i] == a_game->judge_no[check_breeder]){
			count++;
		}
	}
	count--;	//̕
	return count;
}

//--------------------------------------------------------------
/**
 * @brief   RwlɂĔAs[|Cg擾
 * @param   suffer_num		l
 * @retval  擾oAs[|Cg
 */
//--------------------------------------------------------------
int ACALC_JudgeSufferPointCheck(int suffer_num)
{
	static const u8 JudgeSufferAddPoint[] = {
		3 * APPEAL_ICON_ONE_POINT,
		2 * APPEAL_ICON_ONE_POINT,
		1 * APPEAL_ICON_ONE_POINT,
		0 * APPEAL_ICON_ONE_POINT,
	};
	
	return JudgeSufferAddPoint[suffer_num];
}

//--------------------------------------------------------------
/**
 * @brief   oZɂă{e[W邩擾
 *
 * @param   contest_type		ݎQ̃ReXg^Cv
 * @param   wazano				Zԍ
 * @param   judge_no			I񂾐R̔ԍ
 * @param   special_judge_no	R̔ԍ
 *
 * @retval  {e[Wl
 */
//--------------------------------------------------------------
int ACALC_VoltageUpDownCheck(int contest_type, int wazano, int judge_no, int special_judge_no)
{
	int waza_con_type;
	int point;
	
	waza_con_type = WT_WazaDataParaGet(wazano, ID_WTD_contype);
	point = ConTypeVoltageTbl[contest_type][waza_con_type];
#if 0	//Rł{P̂܂܂ɂȂ 2006.03.11(y)
	if(judge_no == special_judge_no){
		point *= 2;
	}
#endif
	return point;
}

//--------------------------------------------------------------
/**
 * @brief   u[_[\[gs
 *
 * @param   a_game		Z̓Q[isp[^ւ̃|C^
 */
//--------------------------------------------------------------
//ԑUw肵ꍇɃ\[gpɓ鉼AP
//(ʏł͎擾Ȃ̒l鎖őOɗ悤ɂĂ)
ALIGN4 static const s16 NextSortSpecifyFirstAP[] = {30000, 29990, 29980, 29970};
//ԑUw肵ꍇɃ\[gpɓ鉼AP
//(ʏł͎擾Ȃ̒l鎖Ōɍs悤ɂĂ)
ALIGN4 static const s16 NextSortSpecifyEndAP[] = {-29970, -29980, -29990, -30000};
//ԑ색_w肵ꍇɃ\[gpɓ鉼AP
//(ʏł͎擾Ȃ̒lŁAFirstEnd̒Ԃw肷鎖ŁAUAU
//eȂ͈͂̏ꏊŃ_)
ALIGN4 static const s16 NextSortRandomAP[] = {10000, 500, -500, -10000};

void ACALC_BreederSort(ACTIN_GAME_PARAM *a_game)
{
	int i, j, t;
	s16 a[BREEDER_MAX];
	u8 b[BREEDER_MAX];
	
	//\[gpɃe|̈APlƃu[_[ԍ
	for(i = 0; i < BREEDER_MAX; i++){
		a[i] = a_game->app_total[i];
		b[i] = i;
	}
	
	//ԑ삪sĂꍇ́ACӂ̏ꏊɂ܂\[g悤APlύX
	{
		for(i = 0; i < BREEDER_MAX; i++){
			switch(a_game->wazapara.personal[i].next_sort){
			case AWK_SORT_NONE:
			default:
				break;
			case AWK_SORT_SPECIFY_FIRST:
				a[i] = NextSortSpecifyFirstAP[a_game->wazapara.personal[i].next_pos];
				OS_TPrintf("u[_[ԍ%dAԑ(U)^[%dԖڂ̃As[\n", i, 
					a_game->wazapara.personal[i].next_pos);
				break;
			case AWK_SORT_SPECIFY_END:
				a[i] = NextSortSpecifyEndAP[a_game->wazapara.personal[i].next_pos];
				OS_TPrintf("u[_[ԍ%dAԑ(U)^[%dԖڂ̃As[\n", i, 
					a_game->wazapara.personal[i].next_pos);
				break;
			case AWK_SORT_RANDOM:
				a[i] = NextSortRandomAP[a_game->wazapara.personal[i].next_pos];
				OS_TPrintf("u[_[ԍ%dAԑ(_)^[%dԖڂ̃As[\n", i, 
					a_game->wazapara.personal[i].next_pos);
				break;
			}
		}
	}
	
	//APlɃ\[gs
	for(i = 0; i < BREEDER_MAX - 1; i++){
		for(j = BREEDER_MAX - 1; j > i; j--){
			if(a[j-1] < a[j]){
				//APlւ
				t = a[j];
				a[j] = a[j-1];
				a[j-1] = t;
				//u[_[ԍꂩ
				t = b[j];
				b[j] = b[j-1];
				b[j-1] = t;
			}
		}
	}
	
	//ёւʂZbg
	for(i = 0; i < BREEDER_MAX; i++){
		a_game->breeder_sort[i] = b[i];
		OS_TPrintf("%dFu[_[ԍ%d, ܂ł̍vAPl=%d\n", 
			i, b[i], a_game->app_total[b[i]]);
	}
}

