//==============================================================================
/**
 * @file	actin_input.c
 * @brief	Z͕͉ʏ
 * @author	matsuda
 * @date	2005.12.02()
 */
//==============================================================================
#include "common.h"
#include "contest/contest.h"
#include "actin.h"
#include "actin_tcb_pri.h"
#include "battle/battle_common.h"
#include "system/clact_tool.h"
#include "system/palanm.h"

#include "system/arc_tool.h"
#include "system/arc_util.h"

#include "system/softsprite.h"

#include "system/fontproc.h"
#include "system/msgdata.h"

#include "wazaeffect/battle_particle.h"
#include "system/particle.h"
#include "wazaeffect/we_mana.h"
#include "wazaeffect/we_sys.h"

#include "system/brightness.h"

#include "graphic/contest_bg_def.h"
#include "graphic/contest_obj_def.h"

#include "actin_tool.h"
#include "con_tool.h"
#include "actin_id.h"
#include "actin_input.h"
#include "battle/wazatype_panel.h"
#include "gflib/touchpanel.h"
#include "contype_icon.h"
#include "poketool/waza_tool.h"
#include "aci_tool.h"

#include "system/msgdata_util.h"
#include "system/wordset.h"
#include "system/fontoam.h"
#include "msgdata/msg_cmsg_acting.h"



//==============================================================================
//	萔`
//==============================================================================
//fobOp`FPS_MSGgpȌ`BOS_MSGΉExpandpӂ܂ł̎b菈
#define S_MSG_DEBUG		(0)

//--------------------------------------------------------------
//	bZ[W֌W
//--------------------------------------------------------------
///S_MSGŎgpԍF|PI(Z͈)̎̃|P
#define S_MSG_POKESELE_NAME		(0)


//--------------------------------------------------------------
//	[JTCBvCIeB
//--------------------------------------------------------------
#define VWAIT_TCBPRI_FRAMEVISIBLE		(10)
#define VWAIT_TCBPRI_BACKSCRN_VISIBLE	(10)
#define VWAIT_TCBPRI_CGRPARAM_TRANS		(20)

//--------------------------------------------------------------
//	
//--------------------------------------------------------------
///AZgpׁ̈AIoȂȂĂ鎞̃pltF[hEVY
#define NOT_TOUCH_WAZA_EVY		(8)
///AZgpׁ̈AIoȂȂĂ鎞̃pltF[hJ[
#define NOT_TOUCH_WAZA_COLOR	(0x0000)
///AZgpׁ̈AIoȂȂĂZ1Ȃꍇ̏p[^
#define NOT_TOUCH_WAZA_POS_NULL	(0xff)

//--------------------------------------------------------------
//	
//--------------------------------------------------------------
///BGwȂ
#define NONE_ID			(0xffff)

///BGgpʐ
#define ACI_BG_NUM		(4)

///Wpbgf[^gp{
#define BASE_PLTT_NUM	(16)

///makedata_nol(gp)
#define MAKEDATA_NO_INIT	(-1)

///ReXg͉ʂŎgpoBGCGRTCY
#define ACI_BG_CGR_SIZE			(0x6000)

///BGXN[̃NAR[h
#define BG_CLEAR_CODE			(0)

///1Ώۖ
#define BLD_PLANE_1		(GX_BLEND_PLANEMASK_BG0)
///2Ώۖ
#define BLD_PLANE_2		(GX_BLEND_BGALL)
///1Ώۖʂɑ΂郿ufBOW
#define BLD_ALPHA_1		(9)
///2Ώۖʂɑ΂郿ufBOW
#define BLD_ALPHA_2		(8)

//--------------------------------------------------------------
//	XN[XN[l
//--------------------------------------------------------------
///TYPE_ABG\Ƀ^b`plꂽYɃXN[l(GtFNg)
#define SCRN_SCROLL_A_EFF_Y				(-2)
///TYPE_ABG\Ƀ^b`plꂽYɃXN[l(GtFNg)
#define SCRN_SCROLL_BACK_A_EFF_Y		(1)

//--------------------------------------------------------------
//	tHgOBJ
//--------------------------------------------------------------
///tHgOBJ̕ԊuX
#define PANEL_MSG_MARGIN		(0)
///tHgOBJ̍őgpOAM
#define PANEL_MSG_MAXOAM		(8)
///tHgOBJ̃AN^[\tgvCIeB
#define PANEL_MSG_SOFTPRI		(100)
///tHgOBJBGvCIeB
#define PANEL_MSG_BGPRI			(0)

enum{
	FONTOAM_LEFT,		///<X[W
	FONTOAM_CENTER,		///<XSW
};

///tHgOBJAN^[[NŎgpŸʒu
enum{
	//WALL
	FA_NO_CONRANK = 0,				///<ReXgN
	FA_NO_CONTYPE,				///<ReXg^Cv
	
	//WAZA
	FA_NO_WAZA_1 = 0,			///<莝Z1
	FA_NO_WAZA_2,				///<莝Z2
	FA_NO_WAZA_3,				///<莝Z3
	FA_NO_WAZA_4,				///<莝Z4
	FA_NO_SETUMEI_1_U,			///<Z1̐i
	FA_NO_SETUMEI_2_U,			///<Z1̐i
	FA_NO_SETUMEI_3_U,			///<Z1̐i
	FA_NO_SETUMEI_4_U,			///<Z1̐i
	FA_NO_SETUMEI_1_D,			///<Z2̐i
	FA_NO_SETUMEI_2_D,			///<Z2̐i
	FA_NO_SETUMEI_3_D,			///<Z2̐i
	FA_NO_SETUMEI_4_D,			///<Z2̐i
	
	//JUDGE
	FA_NO_JUDGE_1 = 0,
	FA_NO_JUDGE_2,
	FA_NO_JUDGE_3,
	
	
	FA_NO_MAX = FA_NO_SETUMEI_4_D + 1,		///<tHgOBJxɏoő吔
};

///ZtHgOBJ̕\W
ALIGN4 static const u16 FontWazaPos[][2] = {	//0:X, 1:Y
	{2 * 8, 3 * 8},		//X͍[W
	{0x12 * 8, 3 * 8},
	{2 * 8, 0xf * 8},
	{0x12 * 8, 0xf * 8},
};

///ZtHgOBJ̕\W
ALIGN4 static const u16 FontSetumeiPos[][2][2] = {	//[no][UP,DOWN][X,Y]
	{
		{2 * 8, 7 * 8},		//X͍[W
		{2 * 8, 9 * 8},		//X͍[W
	},
	{
		{0x12 * 8, 7 * 8},
		{0x12 * 8, 9 * 8},
	},
	{
		{2 * 8, 0x13 * 8},
		{2 * 8, 0x15 * 8},
	},
	{
		{0x12 * 8, 0x13 * 8},
		{0x12 * 8, 0x15 * 8},
	},
};

///RtHgOBJ̕\W
ALIGN4 static const u16 FontJudgePos[][2] = {	//X,Y
	{5 * 8, 12 * 8},		//X̓Z^[W
	{16 * 8, 12 * 8},
	{0x1b * 8, 12 * 8},
};

///ReXgNtHgOBJ̕\WX
#define FONT_CONRANK_POS_X		(128)
///ReXgNtHgOBJ̕\WY
#define FONT_CONRANK_POS_Y		(96 - 16)
///ReXg^CvtHgOBJ̕\WX
#define FONT_CONTYPE_POS_X		(128)
///ReXg^CvtHgOBJ̕\WY
#define FONT_CONTYPE_POS_Y		(96 + 16)

//--------------------------------------------------------------
//	pbg֘A`
//--------------------------------------------------------------
///tHgOBJ̃pbgԍItZbg
enum{
	PALOFS_CONRANK = 0,
	PALOFS_WAZA = 0,
	PALOFS_SETUMEI = 0,
	PALOFS_JUDGE = 0,
};

#define MSGCOLOR_CONRANK		(GF_PRINTCOLOR_MAKE(1, 2, 0))	//FONT_SYSTEMȂ̂ŔwiFw
#define MSGCOLOR_WAZA			(GF_PRINTCOLOR_MAKE(1, 2, 0xb))
#define MSGCOLOR_SETUMEI		(GF_PRINTCOLOR_MAKE(1, 2, 0))	//FONT_SYSTEMȂ̂ŔwiFw
#define MSGCOLOR_JUDGE			(GF_PRINTCOLOR_MAKE(1, 2, 0xb))

//--------------------------------------------------------------
//	GtFNgTCB
//--------------------------------------------------------------
///pl^b`AGtFNgő҂t[
#define SCRN_TOUCH_WAIT	(2)
///pl^b`AGtFNgő҂t[
#define SCRN_TOUCH_ANM_WAIT	(2)

//--------------------------------------------------------------
//	Z^Cv
//--------------------------------------------------------------
///Z^CṽpbgJnʒu
#define WAZATYPE_START_PALPOS	(11)

//--------------------------------------------------------------
//	APl
//--------------------------------------------------------------
///APln[gAN^[̍ő吔
#define APP_HEART_MAX				(6)
///APl̃n[g1ŎĂ|Cg
#define APP_APPEAL_ICON_ONE_POINT		(10)

///APln[g̕\W
ALIGN4 static const AppHeartPos[][2] = {	//X, Y
	{7*8 + 4, 5*8 + 4},
	{0x17*8 + 4, 5*8 + 4},
	{7*8 + 4, 0x11*8 + 4},
	{0x17*8 + 4, 0x11*8 + 4},
};
///APln[gׂ̗̃n[gԂ̃Xy[X
#define APP_HEART_SPACE_X		(8)


//==============================================================================
//	\̒`
//==============================================================================
///XN[͈͎̔w\
typedef struct{
	s32 top;
	s32 bottom;
	s32 left;
	s32 right;
}REWRITE_SCRN_RECT;

///CGR]Ajs͈̔̓f[^
typedef struct{
	u16 dest_x;			///<]XJnʒu(LP)
	u16 dest_y;			///<]YJnʒu(LP)
	u16 src_x;			///<]XJnʒu(LP)
	u16 src_y;			///<]YJnʒu(LP)
	u16 size_x;			///<X]TCY(LP)
	u16 size_y;			///<Y]TCY(LP)
}CGR_TRANS_RECTDATA;

///CGR]Ajs̃p[^
typedef struct{
	TCB_PTR v_tcb;		///<VuN]sTCB̃|C^
	u8 *dest_vram;		///<VRAM]AhX
	void *arc_data;		///<A[JCuLt@C̃|C^
	u8 *raw_data;		///<A[JCuLt@C̃Lf[^擪AhX
	CGR_TRANS_RECTDATA rd;	///<CGR]Ajs͈̔̓f[^
	u16 x_len;			///<Lt@CX(oCgP)
}CGR_TRANS_PARAM;

///paracgr\̂ŎgpAN^[|C^̐
#define PARACGR_CAP_MAX			(3)
///{^̃Ajp^[
#define BUTTON_ANM_NUM			(2)

///GtFNgTCBp̃[N
typedef struct{
	s16 seq;
	s16 wait;
	union{
		struct{		//CGR]p(ėp)
			CGR_TRANS_PARAM *ctp;
			const CGR_TRANS_RECTDATA *ctp_rd_ptr[BUTTON_ANM_NUM];
			CATS_ACT_PTR cap[PARACGR_CAP_MAX];	///<ꏏɃXN[AN^[ւ̃|C^
			u32 transcgr_id[BUTTON_ANM_NUM];
			int tp_ret;
			u16 arc_id;
			u8 fa_no;						///<ΏۃtHgOBJAN^[[N̓Y
		}paracgr;
	};
}ACI_EFFECT_WORK;

///GtFNgBGp[^
typedef struct{
	const REWRITE_SCRN_RECT *rsr;	///<XN[͈̓f[^ւ̃|C^
	u8 rsr_num;						///<rsrf[^
	s8 add_charname;				///<LN^l[ɑރItZbgl
}EFFBG_WRITE_PARAM;

///tHgAN^[[N
typedef struct{
	FONTOAM_OBJ_PTR fontoam;
	CHAR_MANAGER_ALLOCDATA cma;
	u16 font_len;
}FONT_ACTOR;

///ReXg͉ʐ䃏[N
typedef struct _ACI_PARAM{
	ACTIN_SYSTEM_PARAM *sys;
	ACTIN_GAME_PARAM *a_game;
	void *scene_work;	///<V[ɈقȂKvƂȂf[^ނւ̃|C^
	TCB_PTR effect_tcb;	///<GtFNgTCBւ̃|C^
	EFFBG_WRITE_PARAM ewp;	///<GtFNgBGp[^

	//tHgOAM
	FONTOAM_SYS_PTR fontoam_sys;	///<tHgVXeւ̃|C^
	FONT_ACTOR font_actor[FA_NO_MAX];	///<tHgAN^[[N
	
	//ReXg^CvACR
	CATS_ACT_PTR icon_cap[WAZA_TEMOTI_MAX];		///<ReXg^CvACRAN^[|C^
	//Rn[g
	CATS_ACT_PTR special_heart_cap;			///<Rn[g̃AN^[|C^
	//APlEWQln[g
	CATS_ACT_PTR app_heart_cap[WAZA_TEMOTI_MAX][APP_HEART_MAX];	///<APln[g̃AN^[|C^
	
	s8 makedata_no;		///<ݎgpĂBgMakeData̔ԍ
	u8 not_touch_pos;	///<AgpsZ̎莝ʒu(sZȂꍇNOT_TOUCH_WAZA_POS_NULL)
	
	ACI_EFFECT_WORK effect_work;	///<GtFNgTCBp[N
}ACI_PARAM;

///BG쐬f[^\
typedef struct{
	u16 cgr_id;			///<gpCGR̃A[JCuID
	u16 pal_id;			///<gppbg̃A[JCuID
	union{
		struct{
			u16 scr0_id;
			u16 scr1_id;
			u16 scr2_id;
			u16 scr3_id;
		};
		u16 scr_id[ACI_BG_NUM];		///<gpXN[̃A[JCuID
	};
	union{
		struct{
			u16 pri0;		///<BG0ʂ̃vCIeB
			u16 pri1;		///<BG1ʂ̃vCIeB
			u16 pri2;
			u16 pri3;
		};
		u16 pri[ACI_BG_NUM];		///<BG̃vCIeB
	};
	
	//^b`pl
	const RECT_HIT_TBL *tpd;	///<gp^b`plf[^ւ̃|C^
	const int *tpd_ret;			///<^b`pľ
	
	//֐|C^
	void (*callback_bg)(ACI_PARAM_PTR, int, int);	///<BGCreateɌĂяo֐
	int (*callback_tp)(ACI_PARAM_PTR, int);			///<^b`plɌĂяo֐
}BG_MAKE_DATA;


//==============================================================================
//	vg^Cv錾
//==============================================================================
static void * AINPUT_WorkInit(void);
static void BGCallback_Wall(ACI_PARAM_PTR aci, int select_bg, int force_put);
static void BGCallback_WazaSelect(ACI_PARAM_PTR aci, int select_bg, int force_put);
static void BGCallback_JudgeSelect(ACI_PARAM_PTR aci, int select_bg, int force_put);
static int TPCallback_WazaSelect(ACI_PARAM_PTR aci, int tp_ret);
static int TPCallback_JudgeSelect(ACI_PARAM_PTR aci, int tp_ret);
static BOOL Sub_CgrTransEndCheck(CGR_TRANS_PARAM *ctp);
static void Sub_CgrTransNowCopy(int frame_no, u16 arc_id, u32 cgr_id,
	const CGR_TRANS_RECTDATA *rd);
static void Sub_CgrParamTrans(CGR_TRANS_PARAM *ctp);
static void Sub_SubHeartJudgeDeleteAll(ACI_PARAM_PTR aci);
static void Sub_AppHeartDeleteAll(ACI_PARAM_PTR aci);
static void Sub_SceneOBJDelete(ACI_PARAM_PTR aci);
static void Sub_ConTypeIconCreateAll(ACI_PARAM_PTR aci, u16 wazano[]);
static void Sub_ConTypeIconDeleteAll(ACI_PARAM_PTR aci);
static void Sub_WazaTypeCGRTrans(ACI_PARAM_PTR aci, int waza_type, int waza_pos);
static void Sub_BackScrnOnlyVisible(void);
static void Sub_TouchEndDelete(ACI_PARAM_PTR aci);
static void EffectTCB_Add(TCB_FUNC func, ACI_PARAM_PTR aci);
static void EffectTCB_Delete(ACI_PARAM_PTR aci);
static void Effect_ButtonDown(TCB_PTR tcb, void *work);
static void Effect_WazaButtonDown(TCB_PTR tcb, void *work);
static void VWait_FrameVisibleUpdate(TCB_PTR tcb, void *work);
static void VWait_BackScrnOnlyVisible(TCB_PTR tcb, void *work);
static void VWait_CgrParamTrans(TCB_PTR tcb, void *work);
static void Sub_ScrnErase(const REWRITE_SCRN_RECT rsr[], int rsr_num, GF_BGL_INI *bgl, 
	int frame_no, u16 clear_code);
static CGR_TRANS_PARAM * Sub_CgrTransParamSet(int frame_no, u16 arc_id, u32 cgr_id,
	const CGR_TRANS_RECTDATA *rd);
static CGR_TRANS_PARAM * Sub_CgrTransTaskSet(int frame_no, u16 arc_id, u32 cgr_id, 
	const CGR_TRANS_RECTDATA *rd);
static void Sub_FontOamCreate(ACI_PARAM_PTR aci, FONT_ACTOR *font_actor, const STRBUF *str, 
	FONT_TYPE font_type, GF_PRINTCOLOR color, int pal_offset, int pal_id, 
	int x, int y, int pos_center);
static void Sub_FontOamDeleteAll(ACI_PARAM_PTR aci);
void AINPUT_DefaultFrameSet(GF_BGL_INI *bgl);
void AINPUT_FrameExit(GF_BGL_INI *bgl);
void * AINPUT_SystemInit(ACTIN_SYSTEM_PARAM *sys, ACTIN_GAME_PARAM *a_game);
void AINPUT_SystemFree(ACI_PARAM_PTR aci);
void AINPUT_CreateBG(ACI_PARAM_PTR aci, int select_bg, int force_put, void *scene_work);
int AINPUT_TouchCheck(ACI_PARAM_PTR aci);
BOOL AINPUT_EffectEndCheck(ACI_PARAM_PTR aci);

//==============================================================================
//	f[^
//==============================================================================
///ReXg͉ʗpBGt[\
static const GF_BGL_BGCNT_HEADER AciBgCntDat[] = {
	{//GF_BGL_FRAME0_S
		0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
		GX_BG_SCRBASE_0x6000, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_01,
		0, 0, 0, FALSE
	},
	{//GF_BGL_FRAME1_S
		0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
		GX_BG_SCRBASE_0x6800, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_01,
		0, 0, 0, FALSE
	},
	{//GF_BGL_FRAME2_S
		0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
		GX_BG_SCRBASE_0x7000, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_01,
		0, 0, 0, FALSE
	},
	{//GF_BGL_FRAME3_S
		0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
		GX_BG_SCRBASE_0x7800, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_01,
		0, 0, 0, FALSE
	},
};

//==============================================================================
//	BGLւf[^
//==============================================================================
///uZPvplBGւ
static const REWRITE_SCRN_RECT Skill1Rsr[] = {
	{1, 9, 1, 0xe},
};
///uZQvplBGւ
static const REWRITE_SCRN_RECT Skill2Rsr[] = {
	{1, 9, 0x11, 0x1e},
};
///uZRvplBGւ
static const REWRITE_SCRN_RECT Skill3Rsr[] = {
	{10, 0x12, 1, 0xe},
};
///uZSvplBGւ
static const REWRITE_SCRN_RECT Skill4Rsr[] = {
	{10, 0x12, 0x11, 0x1e},
};


//============================================================================================
//	^b`pl̈ݒ
//============================================================================================
//--------------------------------------------------------------
//	
//--------------------------------------------------------------
///ZI^b`pl̈ݒ
static const RECT_HIT_TBL WazaSelectTouchData[] = {
	//UP DOWN LEFT RIGHT
	{1*8, 12*8, 1*8, 0xf*8},		//ZP
	{1*8, 12*8, 0x11*8, 0x1f*8},	//ZQ
	{13*8, 0x18*8, 1*8, 0xf*8},		//ZR
	{13*8, 0x18*8, 0x11*8, 0x1f*8},	//ZS
	{ RECT_HIT_END, 0, 0, 0 }
};
///ZI^b`pl̃^b`ʕԎ
static const int WazaSelectTouchRet[NELEMS(WazaSelectTouchData) - 1] = {
	ACTIN_TP_WAZA_1,			//Z1
	ACTIN_TP_WAZA_2,			//Z2
	ACTIN_TP_WAZA_3,			//Z3
	ACTIN_TP_WAZA_4,			//Z4
};

//--------------------------------------------------------------
//	
//--------------------------------------------------------------
///RI^b`pl̈ݒ
static const RECT_HIT_TBL JudgeSelectTouchData[] = {
	//UP DOWN LEFT RIGHT
	{2*8, 0x17*8, 2*8, 10*8},		//RP
	{2*8, 0x17*8, 12*8, 0x14*8},		//RQ
	{2*8, 0x17*8, 0x16*8, 0x1e*8},		//RR
	{ RECT_HIT_END, 0, 0, 0 }
};
///RI^b`pl̃^b`ʕԎ
static const int JudgeSelectTouchRet[NELEMS(JudgeSelectTouchData) - 1] = {
	ACTIN_TP_JUDGE_1,		//RP
	ACTIN_TP_JUDGE_2,		//RQ
	ACTIN_TP_JUDGE_3,		//RR
};


//==============================================================================
//	
//==============================================================================
///BG쐬f[^(̕тǉAύXAINPUT_TYPE_???̒`ύX邱ƁII)
static const BG_MAKE_DATA BgMakeData[] = {
	{//WALL
		CON_SUB_NCGR_BIN,
		CONTEST_SUB_NCLR,
		{
			CON_TIT_NSCR_BIN,		//pl
			NONE_ID,		//g
			CON_SUB_BG_NSCR_BIN,		//wi
			NONE_ID,							//gXChp
		},
		{2, 1, 3, 0},
		NULL,				//^b`plf[^
		NULL,				//^b`pl
		BGCallback_Wall,				//BG쐬̃R[obN֐
		NULL,				//^b`pl̃R[obN֐
	},
	{//WAZA
		CON_BUT_NCGR_BIN,
		CONTEST_SUB_NCLR,
		{
			CON_WAZA_BUT_NSCR_BIN,		//pl
			NONE_ID,		//g
			NONE_ID,		//wi
			NONE_ID,							//gXChp
		},
		{2, 1, 3, 0},
		WazaSelectTouchData,				//^b`plf[^
		WazaSelectTouchRet,					//^b`pl
		BGCallback_WazaSelect,				//BG쐬̃R[obN֐
		TPCallback_WazaSelect,				//^b`pl̃R[obN֐
	},
	{//JUDGE
		CON_BUT_NCGR_BIN,
		CONTEST_SUB_NCLR,
		{
			CON_SINSA_BUT_NSCR_BIN,		//pl
			NONE_ID,		//g
			NONE_ID,		//wi
			NONE_ID,							//gXChp
		},
		{2, 1, 3, 0},
		JudgeSelectTouchData,				//^b`plf[^
		JudgeSelectTouchRet,				//^b`pl
		BGCallback_JudgeSelect,				//BG쐬̃R[obN֐
		TPCallback_JudgeSelect,				//^b`pl̃R[obN֐
	},
};


//==============================================================================
//
//	AN^[wb_
//
//==============================================================================
///ReXg^CvACRFAN^[wb_
static const TCATS_OBJECT_ADD_PARAM_S ConTypeIconObjParam = {
	0, 0, 0,		//x, y, z
	0, 100, 0,		//AjԍAD揇ʁApbgԍ
	NNS_G2D_VRAM_TYPE_2DSUB,		//`GA
	{	//gp\[XIDe[u
		CHARID_CONTYPE_ICON_1,	//L
		PLTTID_OBJ_COMMON_SUB,	//pbg
		CELLID_CONTYPE_ICON,	//Z
		CELLANMID_CONTYPE_ICON,	//ZAj
		CLACT_U_HEADER_DATA_NONE,		//}`Z
		CLACT_U_HEADER_DATA_NONE,		//}`ZAj
	},
	1,			//BGvCIeB
	0,			//Vram]tO
};


//==============================================================================
//
//	Z^Cv
//
//==============================================================================
///Z̋Z^CvL]ʒu(LN^P)
ALIGN4 static const u16 WazaTypeCgrPos[] = {0+1, 6+1, 12+1, 18+1};

///ReXg^CvACR̍W
ALIGN4 static const u16 WazaIconPos[][2] = {	//X, Y
	{4*8 + 4, 5*8},
	{0x14*8 + 4, 5*8},
	{4*8 + 4, 0x11*8},
	{0x14*8 + 4, 0x11*8},
};

//==============================================================================
//
//	
//
//==============================================================================
///ZIplCGRAj]͈
static const CGR_TRANS_RECTDATA WazaSelectCgrTransRect[][WAZA_TEMOTI_MAX] = {
	{
		{0+1, 0, 12, 0, 6, 9},			//SELECT_SKILL_1
		{6+1, 0, 12, 0, 6, 9},			//SELECT_SKILL_2
		{12+1, 0, 12, 0, 6, 9},		//SELECT_SKILL_3
		{18+1, 0, 12, 0, 6, 9},		//SELECT_SKILL_4
	},
	{
		{0+1, 0, 6, 0, 6, 9},			//SELECT_SKILL_1
		{6+1, 0, 6, 0, 6, 9},			//SELECT_SKILL_2
		{12+1, 0, 6, 0, 6, 9},		//SELECT_SKILL_3
		{18+1, 0, 6, 0, 6, 9},		//SELECT_SKILL_4
	},
};

///RIplCGRAj]͈
static const CGR_TRANS_RECTDATA JudgeSelectCgrTransRect[][JUDGE_MAX] = {
	{
		{0+1, 0, 6, 0, 6, 9},		//ACTIN_TP_JUDGE_1
		{6+1, 0, 6, 0, 6, 9},		//ACTIN_TP_JUDGE_2
		{12+1, 0, 6, 0, 6, 9},		//ACTIN_TP_JUDGE_3
	},
	{
		{0+1, 0, 12, 0, 6, 9},		//ACTIN_TP_JUDGE_1
		{6+1, 0, 12, 0, 6, 9},		//ACTIN_TP_JUDGE_2
		{12+1, 0, 12, 0, 6, 9},		//ACTIN_TP_JUDGE_3
	},
};



//==============================================================================
//
//	
//
//==============================================================================

//--------------------------------------------------------------
/**
 * @brief   BIVXe[N̊mۂƏ
 *
 * @retval  mۂBIVXe[Ñ|C^
 */
//--------------------------------------------------------------
static void * AINPUT_WorkInit(void)
{
	ACI_PARAM *aci;

	aci = sys_AllocMemory(HEAPID_ACTIN, sizeof(ACI_PARAM));
	MI_CpuClear8(aci, sizeof(ACI_PARAM));
	
	aci->makedata_no = MAKEDATA_NO_INIT;
	
	return aci;
}

//--------------------------------------------------------------
/**
 * @brief   BG\Wt[\Őݒ肷
 * @param   bgl		BGLf[^
 */
//--------------------------------------------------------------
void AINPUT_DefaultFrameSet(GF_BGL_INI *bgl)
{
	int i;
	
	for(i = 0; i < NELEMS(AciBgCntDat); i++){
		GF_BGL_BGControlSet(bgl, GF_BGL_FRAME0_S + i, &AciBgCntDat[i], GF_BGL_MODE_TEXT);
		GF_BGL_ScrClearCode(bgl, GF_BGL_FRAME0_S + i, BG_CLEAR_CODE);
		GF_BGL_ScrollSet(bgl, GF_BGL_FRAME0_S + i, GF_BGL_SCROLL_X_SET, 0);
		GF_BGL_ScrollSet(bgl, GF_BGL_FRAME0_S + i, GF_BGL_SCROLL_Y_SET, 0);
	}
}

//--------------------------------------------------------------
/**
 * @brief   BGt[I
 * @param   bgl		BGLf[^
 */
//--------------------------------------------------------------
void AINPUT_FrameExit(GF_BGL_INI *bgl)
{
	int i;
	
	for(i = 0; i < NELEMS(AciBgCntDat); i++){
		GF_BGL_VisibleSet(GF_BGL_FRAME0_S + i, VISIBLE_OFF);
		GF_BGL_BGControlExit(bgl, GF_BGL_FRAME0_S + i);
	}
}

//--------------------------------------------------------------
/**
 * @brief   ReXg͉ʂ̃VXe
 * @param   bgl		BGLf[^
 * @retval  AllocReXg͉ʂ̃VXe[Ñ|C^
 */
//--------------------------------------------------------------
void * AINPUT_SystemInit(ACTIN_SYSTEM_PARAM *sys, ACTIN_GAME_PARAM *a_game)
{
	ACI_PARAM *aci;
	
	//[Nm
	aci = AINPUT_WorkInit();
	aci->sys = sys;
	aci->a_game = a_game;
	
	//t[\ݒ	ł邩͔H
//	AINPUT_DefaultFrameSet(bgl);

	//tHgOAMVXe쐬
	aci->fontoam_sys = FONTOAM_SysInit(FA_NO_MAX, HEAPID_ACTIN);
	
	return aci;
}

//--------------------------------------------------------------
/**
 * @brief   ReXg͉ʂ̃VXe
 * @param   aci		BIVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
void AINPUT_SystemFree(ACI_PARAM_PTR aci)
{
	Sub_SceneOBJDelete(aci);
	FONTOAM_SysDelete(aci->fontoam_sys);
	sys_FreeMemoryEz(aci);
}

//--------------------------------------------------------------
/**
 * @brief   w^CvBGʂ`
 *
 * @param   aci				BIVXe[Nւ̃|C^
 * @param   select_bg		\BG^Cv(AINPUT_TYPE_???)
 * @param   force_put		TRUE:]AFALSE:ɓf[^]ĂȂē]͂Ȃ
 * @param   work			V[ɈقȂKvȃf[^ւ̃|C^
 */
//--------------------------------------------------------------
void AINPUT_CreateBG(ACI_PARAM_PTR aci, int select_bg, int force_put, void *scene_work)
{
	const BG_MAKE_DATA *bmd, *old_bmd;
	int i;
	GF_BGL_INI *bgl;
	CATS_SYS_PTR csp;
	CATS_RES_PTR crp;
	
	aci->scene_work = scene_work;
	bgl = aci->sys->bgl;
	csp = aci->sys->csp;
	crp = aci->sys->crp;
	
	if(aci->makedata_no == MAKEDATA_NO_INIT){
		force_put = TRUE;
		old_bmd = NULL;
	}
	else{
		old_bmd = &BgMakeData[aci->makedata_no];
	}
	bmd = &BgMakeData[select_bg];

	//wiȊO͑SĔ\
	Sub_BackScrnOnlyVisible();
	
	//eBGʂBGvCIeBXV
	{
		for(i = 0; i < ACI_BG_NUM; i++){
			GF_BGL_PrioritySet(GF_BGL_FRAME0_S + i, bmd->pri[i]);
		}
	}
	
	//CGR
	if(1){	//CGR]AjsȂLIDłK]ĂȂƃAj߂Ȃ
//	if(bmd->cgr_id != NONE_ID && (force_put == TRUE || bmd->cgr_id != old_bmd->cgr_id)){
		ArcUtil_BgCharSet(ARC_CONTEST_BG, bmd->cgr_id, bgl, GF_BGL_FRAME0_S, 
			0, ACI_BG_CGR_SIZE, 1, HEAPID_ACTIN);
	}
	//PALETTE
	if(bmd->pal_id != NONE_ID && (force_put == TRUE || bmd->pal_id != old_bmd->pal_id)){
		PaletteWorkSet_Arc(aci->sys->pfd, ARC_CONTEST_BG, bmd->pal_id, HEAPID_ACTIN, 
			FADE_SUB_BG, 0, 0);

	}
	//SCREEN
	for(i = 0; i < ACI_BG_NUM; i++){
		if(bmd->scr_id[i] != NONE_ID 
				&& (force_put == TRUE || bmd->scr_id[i] != old_bmd->scr_id[i])){
			ArcUtil_ScrnSet(ARC_CONTEST_BG, bmd->scr_id[i], bgl, 
				GF_BGL_FRAME0_S + i, 0, 0, 1, HEAPID_ACTIN);
		}
	}
	
	aci->makedata_no = select_bg;

	G2S_SetBlendAlpha(BLD_PLANE_1, BLD_PLANE_2, BLD_ALPHA_1, BLD_ALPHA_2);

	Sub_SceneOBJDelete(aci);
	//R[obN֐Ăяo
	if(bmd->callback_bg != NULL){
		bmd->callback_bg(aci, select_bg, force_put);
	}

	VWaitTCB_Add(VWait_FrameVisibleUpdate, aci, VWAIT_TCBPRI_FRAMEVISIBLE);
}

//--------------------------------------------------------------
/**
 * @brief   ^b`plԂ𒲂ׂ
 * @param   aci		BIVXe[Nւ̃|C^
 * @retval  (Ȃ̏ꍇRECT_HIT_NONE)
 */
//--------------------------------------------------------------
int AINPUT_TouchCheck(ACI_PARAM_PTR aci)
{
	int tp_ret, hit, ret;
	const BG_MAKE_DATA *bmd;
	
	GF_ASSERT(aci->makedata_no != MAKEDATA_NO_INIT);
	
	bmd = &BgMakeData[aci->makedata_no];
	if(bmd->tpd == NULL){
		return RECT_HIT_NONE;
	}
	
	GF_ASSERT(bmd->tpd_ret != NULL);
	
	hit = GF_TP_RectHitTrg(bmd->tpd);
	if(hit == RECT_HIT_NONE){
		tp_ret = RECT_HIT_NONE;
	}
	else{
		tp_ret = bmd->tpd_ret[hit];
	}
	
	//R[obN֐Ăяo
	if(bmd->callback_tp != NULL){
		tp_ret = bmd->callback_tp(aci, tp_ret);
	}
	
	return tp_ret;
}

//--------------------------------------------------------------
/**
 * @brief   GtFNgTCBIĂ邩`FbN
 * @param   aci		BIVXe[Nւ̃|C^
 * @retval  TRUE:IĂB@FALSE:IĂȂ
 */
//--------------------------------------------------------------
BOOL AINPUT_EffectEndCheck(ACI_PARAM_PTR aci)
{
	if(aci->effect_tcb == NULL){
		return TRUE;
	}
	return FALSE;
}



//==============================================================================
//
//	BG쐬ɌĂ΂R[obN֐
//
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   AINPUT_TYPE_WALLBGCreateɌĂ΂R[obN֐
 *
 * @param   aci				BIVXe[Nւ̃|C^
 * @param   select_bg		\BG^Cv(AINPUT_TYPE_???)
 * @param   force_put		TRUE:]AFALSE:ɓf[^]ĂȂē]͂Ȃ
 */
//--------------------------------------------------------------
static void BGCallback_Wall(ACI_PARAM_PTR aci, int select_bg, int force_put)
{
	GF_BGL_INI *bgl;
	STRBUF *rank_src, *type_src;
	u32 rank_id, type_id;
	
	bgl = aci->sys->bgl;

	rank_id = ConTool_GetRankMsgID(aci->sys->c_game->rank);
	type_id = ConTool_GetTypeMsgID(aci->sys->c_game->type);
	
	rank_src = MSGMAN_AllocString(aci->sys->actin_msg, rank_id);
	type_src = MSGMAN_AllocString(aci->sys->actin_msg, type_id);
	
	Sub_FontOamCreate(aci, &aci->font_actor[FA_NO_CONRANK], 
		rank_src, FONT_SYSTEM, 
		MSGCOLOR_CONRANK, PALOFS_CONRANK,
		PLTTID_SUB_FONTACT, FONT_CONRANK_POS_X, FONT_CONRANK_POS_Y, FONTOAM_CENTER);
	Sub_FontOamCreate(aci, &aci->font_actor[FA_NO_CONTYPE], 
		type_src, FONT_SYSTEM, 
		MSGCOLOR_CONRANK, PALOFS_CONRANK,
		PLTTID_SUB_FONTACT, FONT_CONTYPE_POS_X, FONT_CONTYPE_POS_Y, FONTOAM_CENTER);
	
	STRBUF_Delete(rank_src);
	STRBUF_Delete(type_src);
}

//--------------------------------------------------------------
/**
 * @brief   AINPUT_TYPE_ABGCreateɌĂ΂R[obN֐
 *
 * @param   aci				BIVXe[Nւ̃|C^
 * @param   select_bg		\BG^Cv(AINPUT_TYPE_???)
 * @param   force_put		TRUE:]AFALSE:ɓf[^]ĂȂē]͂Ȃ
 */
//--------------------------------------------------------------
static void BGCallback_WazaSelect(ACI_PARAM_PTR aci, int select_bg, int force_put)
{
	u16 wazano[WAZA_TEMOTI_MAX];
	u16 appeal_no[WAZA_TEMOTI_MAX];
	int i;
	STRBUF *waza_src;
	STRBUF *setumei_u_src, *setumei_d_src;
	u32 u_id, d_id;
	
	aci->not_touch_pos = NOT_TOUCH_WAZA_POS_NULL;
	
	for(i = 0; i < WAZA_TEMOTI_MAX; i++){
		wazano[i] = PokeParaGet(aci->sys->c_game->pp[aci->sys->c_game->my_breeder_no], 
			ID_PARA_waza1 + i, NULL);
		appeal_no[i] = WT_WazaDataParaGet(wazano[i], ID_WTD_ap_no);
		
		//Z
		waza_src = MSGDAT_UTIL_GetWazaName(wazano[i], HEAPID_ACTIN);
		Sub_FontOamCreate(aci, &aci->font_actor[FA_NO_WAZA_1 + i], waza_src, FONT_BUTTON, 
			MSGCOLOR_WAZA, PALOFS_WAZA,
			PLTTID_SUB_FONTACT, FontWazaPos[i][0], FontWazaPos[i][1], FONTOAM_LEFT);
		STRBUF_Delete(waza_src);
		
		//ZFi
		ConTool_GetAPSetumeiMsgID(appeal_no[i], &u_id, &d_id);
		OS_TPrintf("ԍ%d\n", appeal_no[i]);
		setumei_u_src = MSGMAN_AllocString(aci->sys->explain_msg, u_id);
		setumei_d_src = MSGMAN_AllocString(aci->sys->explain_msg, d_id);
		
		Sub_FontOamCreate(aci, &aci->font_actor[FA_NO_SETUMEI_1_U + i], 
			setumei_u_src, FONT_SYSTEM, 
			MSGCOLOR_SETUMEI, PALOFS_SETUMEI,
			PLTTID_SUB_FONTACT, FontSetumeiPos[i][0][0], FontSetumeiPos[i][0][1], FONTOAM_LEFT);
		
		//ZFi
		Sub_FontOamCreate(aci, &aci->font_actor[FA_NO_SETUMEI_1_D + i], 
			setumei_d_src, FONT_SYSTEM, 
			MSGCOLOR_SETUMEI, PALOFS_SETUMEI,
			PLTTID_SUB_FONTACT, FontSetumeiPos[i][1][0], FontSetumeiPos[i][1][1], FONTOAM_LEFT);
		
		STRBUF_Delete(setumei_u_src);
		STRBUF_Delete(setumei_d_src);
		
		//莝ZȂȂAtHgOBJojbVg
		if(wazano[i] == 0){
		#if 0	//gȂ̂ 2005.12.02()
			Sub_ScrnErase(Skill1Rsr, NELEMS(Skill1Rsr), bgl, ACTINSUB_FRAME_BF, BG_CLEAR_CODE);
			GF_BGL_LoadScreenReq(bgl, ACTINSUB_FRAME_BF);
		#endif
			FONTOAM_SetDrawFlag(aci->font_actor[FA_NO_WAZA_1 + i].fontoam, FALSE);
			FONTOAM_SetDrawFlag(aci->font_actor[FA_NO_SETUMEI_1_U + i].fontoam, FALSE);
			FONTOAM_SetDrawFlag(aci->font_actor[FA_NO_SETUMEI_1_D + i].fontoam, FALSE);
		}
	}

	//-- Z^CvCGR] --//
	{
		for(i = 0; i < WAZA_TEMOTI_MAX; i++){
			if(wazano[i] != 0){
				Sub_WazaTypeCGRTrans(aci, i, i);
			}
			else{
				Sub_WazaTypeCGRTrans(aci, -1, i);
			}
		}
	}

	//-- 2xAgpZ`FbN --//
	for(i = 0; i < WAZA_TEMOTI_MAX; i++){
		if(wazano[i] != 0 && 
				(wazano[i] == aci->a_game->waza_history[aci->sys->c_game->my_breeder_no])
				&& (aci->a_game->wazapara.save[aci->sys->c_game->my_breeder_no].waza_repeat
				!= wazano[i])){
			//2xAgpŘAZłȂ̂ȂAÂă^b`oȂ悤ɂ
			SoftFadePfd(aci->sys->pfd, FADE_SUB_BG, (WAZATYPE_START_PALPOS + i) * 16, 16, 
				NOT_TOUCH_WAZA_EVY, NOT_TOUCH_WAZA_COLOR);
			
			GF_ASSERT(aci->not_touch_pos == NOT_TOUCH_WAZA_POS_NULL && "2ȏ̋ZAgpsԂɂȂĂ܂");
			aci->not_touch_pos = i;
		}
	}

	//ReXg^CvACR
	Sub_ConTypeIconCreateAll(aci, wazano);
	
	//APlEWQl
	{
		int ap_point;
		int heart_num, loop;
		
		//\[X[h
		ACIT_AppHeartResourceLoad(aci->sys->csp, aci->sys->crp);
		
		//AN^[Zbg
		for(i = 0; i < WAZA_TEMOTI_MAX; i++){
			if(wazano[i] == 0){
				continue;
			}
			ap_point = ConTool_GetAPWaza_App(appeal_no[i]);
			heart_num = MATH_IAbs(ap_point) / APP_APPEAL_ICON_ONE_POINT;
			GF_ASSERT(heart_num <= APP_HEART_MAX);
			for(loop = 0; loop < heart_num; loop++){
				GF_ASSERT(aci->app_heart_cap[i][loop] == NULL);
				aci->app_heart_cap[i][loop] = ACIT_AppHeartActorSet(
					aci->sys->csp, aci->sys->crp, 
					AppHeartPos[i][0] + APP_HEART_SPACE_X * loop, 
					AppHeartPos[i][1], ap_point);
			}
		}
	}
}

//--------------------------------------------------------------
/**
 * @brief   AINPUT_TYPE_BBGCreateɌĂ΂R[obN֐
 *
 * @param   aci				BIVXe[Nւ̃|C^
 * @param   select_bg		\BG^Cv(AINPUT_TYPE_???)
 * @param   force_put		TRUE:]AFALSE:ɓf[^]ĂȂē]͂Ȃ
 */
//--------------------------------------------------------------
static void BGCallback_JudgeSelect(ACI_PARAM_PTR aci, int select_bg, int force_put)
{
	int i;
	GF_BGL_INI *bgl;
	STRBUF *judge_src;
	
	bgl = aci->sys->bgl;

	for(i = 0; i < JUDGE_MAX; i++){
		judge_src = ADV_MSGDAT_GetJudgeName(aci->sys->c_game->jd[i].name_id, HEAPID_ACTIN);
		//judge_src = MSGMAN_AllocString(aci->sys->judge_msg, aci->sys->c_game->jd[i].name_id);
		
		Sub_FontOamCreate(aci, &aci->font_actor[FA_NO_JUDGE_1 + i], 
			judge_src, FONT_BUTTON, 
			MSGCOLOR_JUDGE, PALOFS_JUDGE,
			PLTTID_SUB_FONTACT, FontJudgePos[i][0], FontJudgePos[i][1], FONTOAM_CENTER);
		
		STRBUF_Delete(judge_src);
	}
	
	//R̈̃n[gACR
	aci->special_heart_cap = ACIT_SubHeartJudgeAdd(aci->sys->csp, 
		aci->sys->crp, aci->sys->c_game->special_judge_no);
}



//==============================================================================
//
//	^b`plɌĂ΂R[obN֐
//
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   AINPUT_TYPE_AŃ^b`plɌĂяoR[obN֐
 *
 * @param   aci			BIVXe[Nւ̃|C^
 * @param   tp_ret		^b`pl(bmd->tpd_ret̒lRECT_HIT_NONE)
 * 
 * @retval  tp_retԂ(̒ŕύXKvȂȂAœnꂽl̂܂ܕԂ)
 */
//--------------------------------------------------------------
static int TPCallback_WazaSelect(ACI_PARAM_PTR aci, int tp_ret)
{
	u32 transcgr_id, arc_id;
	u32 rd_no;
	int wazano;
	
	rd_no = tp_ret;
	switch(tp_ret){
	case RECT_HIT_NONE:
	default:
		return RECT_HIT_NONE;
	case ACTIN_TP_WAZA_1:
	case ACTIN_TP_WAZA_2:
	case ACTIN_TP_WAZA_3:
	case ACTIN_TP_WAZA_4:
		wazano = PokeParaGet(aci->sys->c_game->pp[aci->sys->c_game->my_breeder_no], 
			ID_PARA_waza1 + tp_ret, NULL);
		if(wazano == 0 || aci->not_touch_pos == (tp_ret - ACTIN_TP_WAZA_1)){
			return RECT_HIT_NONE;	//ꂽꏊ̎莝ZȂ
		}
		
		transcgr_id = WazaPanel_CharIndexGet(tp_ret);
		arc_id = WazaPanel_ArcIDGet();
		break;
	
#if 0	//̏LZ͂Ȃ 2005.12.02()
	case SELECT_CANCEL:
		transcgr_id = NARC_batt_bg_battle_w2_ani1_NCGR;
		arc_id = ARC_CONTEST_BG;
		rd_no = NELEMS(WazaSelectCgrTransRect) - 1;
		break;
#endif
	}

	EffectTCB_Add(Effect_WazaButtonDown, aci);
	aci->effect_work.paracgr.transcgr_id[0] = transcgr_id;
	aci->effect_work.paracgr.transcgr_id[1] = transcgr_id;
	aci->effect_work.paracgr.arc_id = arc_id;
	aci->effect_work.paracgr.ctp_rd_ptr[0] = &WazaSelectCgrTransRect[0][rd_no];
	aci->effect_work.paracgr.ctp_rd_ptr[1] = &WazaSelectCgrTransRect[1][rd_no];
	aci->effect_work.paracgr.tp_ret = tp_ret;
//	aci->effect_work.paracgr.fa_no = fa_no;
	aci->effect_work.paracgr.tp_ret = tp_ret;
	return tp_ret;
}

//--------------------------------------------------------------
/**
 * @brief   AINPUT_TYPE_BŃ^b`plɌĂяoR[obN֐
 *
 * @param   aci			BIVXe[Nւ̃|C^
 * @param   tp_ret		^b`pl(bmd->tpd_ret̒lRECT_HIT_NONE)
 * 
 * @retval  tp_retԂ(̒ŕύXKvȂȂAœnꂽl̂܂ܕԂ)
 */
//--------------------------------------------------------------
static int TPCallback_JudgeSelect(ACI_PARAM_PTR aci, int tp_ret)
{
	int fa_no;
	int special;
	
	switch(tp_ret){
	case RECT_HIT_NONE:
	default:
		return tp_ret;
	case ACTIN_TP_JUDGE_1:
		fa_no = FA_NO_JUDGE_1;
		break;
	case ACTIN_TP_JUDGE_2:
		fa_no = FA_NO_JUDGE_2;
		break;
	case ACTIN_TP_JUDGE_3:
		fa_no = FA_NO_JUDGE_3;
		break;
	}
	
	//RI`FbN
	special = (tp_ret == aci->sys->c_game->special_judge_no) ? TRUE:FALSE;
	
	EffectTCB_Add(Effect_ButtonDown, aci);
	aci->effect_work.paracgr.transcgr_id[0] = CON_BUT_ANIM_NCGR_BIN;//WazaPanel_CharIndexGet(0);
	aci->effect_work.paracgr.transcgr_id[1] = CON_BUT_ANIM_NCGR_BIN;//WazaPanel_CharIndexGet(0);
	aci->effect_work.paracgr.arc_id = ARC_CONTEST_BG;//WazaPanel_ArcIDGet();
	aci->effect_work.paracgr.ctp_rd_ptr[0] = &JudgeSelectCgrTransRect[0][tp_ret];
	aci->effect_work.paracgr.ctp_rd_ptr[1] = &JudgeSelectCgrTransRect[1][tp_ret];
	aci->effect_work.paracgr.tp_ret = tp_ret;
	aci->effect_work.paracgr.fa_no = fa_no;
	if(special == TRUE){
		aci->effect_work.paracgr.cap[0] = aci->special_heart_cap;
	}
	return tp_ret;
}




//==============================================================================
//
//	Tu֐
//
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   w͈͂̃XN[obt@wR[hŃNA
 *
 * @param   rsr[]			NA͈
 * @param   rsr_num			rsrf[^
 * @param   bgl				BGLf[^
 * @param   frame_no		t[ԍ
 * @param   clear_code		NA[R[h
 */
//--------------------------------------------------------------
static void Sub_ScrnErase(const REWRITE_SCRN_RECT rsr[], int rsr_num, GF_BGL_INI *bgl, 
	int frame_no, u16 clear_code)
{
	u16 *buf;
	int i, y;
	
	buf = GF_BGL_ScreenAdrsGet(bgl, frame_no);
	GF_ASSERT(buf != NULL);

	for(i = 0; i < rsr_num; i++){
		for(y = rsr[i].top; y <= rsr[i].bottom; y++){
			MI_CpuFill16(&buf[0x20*y + rsr[i].left], clear_code, 
				(rsr[i].right - rsr[i].left + 1) * 2);
		}
	}
}

//--------------------------------------------------------------
/**
 * @brief   CGR]Ajs߂̃p[^Zbg܂
 *
 * @param   frame_no		t[NO
 * @param   arc_id			ARCCfbNX
 * @param   cgr_id			]OtBbNCGRID(0xffffffff̏ꍇ̓NA܂)
 * @param   rd				]͈̓f[^̃|C^(cgr_id0xffffffff̏ꍇsrc̒l͓KOK)
 *
 * @retval  CGR]Ajp[^[Nւ̃|C^
 */
//--------------------------------------------------------------
static CGR_TRANS_PARAM * Sub_CgrTransParamSet(int frame_no, u16 arc_id, u32 cgr_id,
	const CGR_TRANS_RECTDATA *rd)
{
	void *arc_data;
	NNSG2dCharacterData *char_data;
	CGR_TRANS_PARAM *ctp;
	
	ctp = sys_AllocMemory(HEAPID_ACTIN, sizeof(CGR_TRANS_PARAM));
	MI_CpuClear8(ctp, sizeof(CGR_TRANS_PARAM));
	
	if(cgr_id != 0xffffffff){
		ctp->arc_data = ArcUtil_CharDataGet(arc_id, cgr_id, 1, &char_data, HEAPID_ACTIN);
		ctp->raw_data = char_data->pRawData;
	}
	ctp->x_len = char_data->W * 0x20;
	
	ctp->rd = *rd;
	ctp->dest_vram = GF_BGL_CgxGet(frame_no);
	
	return ctp;
}

//--------------------------------------------------------------
/**
 * @brief   CGR]Ajs^XN𐶐܂
 *
 * @param   frame_no		t[NO
 * @param   arc_id			ARCCfbNX
 * @param   cgr_id			]OtBbNCGRID(0xffffffff̏ꍇ̓NA܂)
 * @param   rd				]͈̓f[^̃|C^(cgr_id0xffffffff̏ꍇsrc̒l͓KOK)
 *
 * @retval  CGR]Ajp[^[Nւ̃|C^
 *
 * ̊֐gpAKSub_CgrTransEndCheck֐gpAImFsĂB
 * Sub_CgrTransEndCheck֐Ń[N̉ȂǂsĂ܂B
 */
//--------------------------------------------------------------
static CGR_TRANS_PARAM * Sub_CgrTransTaskSet(int frame_no, u16 arc_id, u32 cgr_id,
	const CGR_TRANS_RECTDATA *rd)
{
	CGR_TRANS_PARAM *ctp;

	ctp = Sub_CgrTransParamSet(frame_no, arc_id, cgr_id, rd);
	ctp->v_tcb = VWaitTCB_Add(VWait_CgrParamTrans, ctp, VWAIT_TCBPRI_CGRPARAM_TRANS);
	return ctp;
}

//--------------------------------------------------------------
/**
 * @brief   CGR]Aj^XNIĂ邩mF
 * @param   ctp		CGR]Ajp[^[Nւ̃|C^
 * @retval  TRUE:IB@FALSE:s
 *
 * TRUEԂACGR]Ajp[^[N̉s܂B
 */
//--------------------------------------------------------------
static BOOL Sub_CgrTransEndCheck(CGR_TRANS_PARAM *ctp)
{
	if(ctp->v_tcb == NULL){
		if(ctp->arc_data != NULL){
			sys_FreeMemoryEz(ctp->arc_data);
		}
		sys_FreeMemoryEz(ctp);
		return TRUE;
	}
	return FALSE;
}

//--------------------------------------------------------------
/**
 * @brief   CGR]AjVuN^XN𗘗pɂs܂
 *
 * @param   frame_no		t[NO
 * @param   arc_id			ARCCfbNX
 * @param   cgr_id			]OtBbNCGRID(0xffffffff̏ꍇ̓NA܂)
 * @param   rd				]͈̓f[^̃|C^(cgr_id0xffffffff̏ꍇsrc̒l͓KOK)
 *
 * @retval  CGR]Ajp[^[Nւ̃|C^
 *
 * ̊֐gpAKSub_CgrTransEndCheck֐gpAImFsĂB
 * Sub_CgrTransEndCheck֐Ń[N̉ȂǂsĂ܂B
 */
//--------------------------------------------------------------
static void Sub_CgrTransNowCopy(int frame_no, u16 arc_id, u32 cgr_id, const CGR_TRANS_RECTDATA *rd)
{
	CGR_TRANS_PARAM *ctp;
	
	ctp = Sub_CgrTransParamSet(frame_no, arc_id, cgr_id, rd);
	Sub_CgrParamTrans(ctp);
	if(ctp->arc_data != NULL){
		sys_FreeMemoryEz(ctp->arc_data);
	}
	sys_FreeMemoryEz(ctp);
}

//--------------------------------------------------------------
/**
 * @brief   CGR]Ajs܂
 * @param   ctp		CGR]Ajp[^[Nւ̃|C^
 */
//--------------------------------------------------------------
static void Sub_CgrParamTrans(CGR_TRANS_PARAM *ctp)
{
	int x, y, dest_x_len;
	u32 src_y, dest_y;
	
	dest_x_len = 32*32;
	
	src_y = ctp->rd.src_y * ctp->x_len;
	dest_y = ctp->rd.dest_y * dest_x_len;
	
	for(y = 0; y < ctp->rd.size_y; y++){
		if(ctp->arc_data != NULL){
			MI_CpuCopy16(&ctp->raw_data[ctp->x_len * y + src_y + ctp->rd.src_x*0x20], 
				&ctp->dest_vram[dest_x_len * y + dest_y + ctp->rd.dest_x*0x20],
				ctp->rd.size_x * 0x20);
		}
		else{
			MI_CpuClear16(&ctp->dest_vram[dest_x_len * y + dest_y + ctp->rd.dest_x*0x20],
				ctp->rd.size_x * 0x20);
		}
	}
}

//--------------------------------------------------------------
/**
 * @brief   tHgOAM쐬
 *
 * @param   aci			BIVXe[Nւ̃|C^
 * @param   font_actor	tHgOAM֘Ã[N
 * @param   str			
 * @param   font_type	tHg^Cv(FONT_SYSTEM)
 * @param   color		tHgJ[\
 * @param   pal_offset	pbgԍItZbg
 * @param   pal_id		o^JnpbgID
 * @param   x			WX
 * @param   y			WY
 * @param   pos_center  FONTOAM_LEFT(X[W) or FONTOAM_CENTER(XSW)
 */
//--------------------------------------------------------------
static void Sub_FontOamCreate(ACI_PARAM_PTR aci, FONT_ACTOR *font_actor, const STRBUF *str, 
	FONT_TYPE font_type, GF_PRINTCOLOR color, int pal_offset, int pal_id, 
	int x, int y, int pos_center)
{
	FONTOAM_INIT finit;
	GF_BGL_BMPWIN bmpwin;
	CHAR_MANAGER_ALLOCDATA cma;
	int vram_size;
	FONTOAM_OBJ_PTR fontoam;
	GF_BGL_INI *bgl;
	CATS_RES_PTR crp;
	int font_len, char_len;
	
	GF_ASSERT(font_actor->fontoam == NULL);
	
	bgl = aci->sys->bgl;
	crp = aci->sys->crp;
	
	//̃hbgAgpLZo
	{
		font_len = FontProc_GetPrintStrWidth(font_type, str, PANEL_MSG_MARGIN);
		char_len = font_len / 8;
		if(FX_ModS32(font_len, 8) != 0){
			char_len++;
		}
	}

	//BMP쐬
	{
		GF_BGL_BmpWinInit(&bmpwin);
		GF_BGL_BmpWinObjAdd(bgl, &bmpwin, char_len, 16 / 8, 0, 0);
		GF_STR_PrintExpand(&bmpwin, font_type, str, 0, 0, MSG_NO_PUT, color, 
			PANEL_MSG_MARGIN, 0, NULL);
//		GF_STR_PrintColor(&bmpwin, font_type, str, 0, 0, MSG_NO_PUT, color, NULL );
	}

	vram_size = FONTOAM_NeedCharSize(&bmpwin, NNS_G2D_VRAM_TYPE_2DSUB,  HEAPID_ACTIN);
	CharVramAreaAlloc(vram_size, CHARM_CONT_AREACONT, NNS_G2D_VRAM_TYPE_2DSUB, &cma);
	
	//WʒuC
	if(pos_center == FONTOAM_CENTER){
		x -= font_len / 2;
	}
	y += SUB_SURFACE_Y_INTEGER - 8;
	
	finit.fontoam_sys = aci->fontoam_sys;
	finit.bmp = &bmpwin;
	finit.clact_set = CATS_GetClactSetPtr(crp);
	finit.pltt = CATS_PlttProxy(crp, pal_id);
	finit.parent = NULL;
	finit.char_ofs = cma.alloc_ofs;
	finit.x = x;
	finit.y = y;
	finit.bg_pri = PANEL_MSG_BGPRI;
	finit.soft_pri = PANEL_MSG_SOFTPRI;
	finit.draw_area = NNS_G2D_VRAM_TYPE_2DSUB;
	finit.heap = HEAPID_ACTIN;
	
	fontoam = FONTOAM_Init(&finit);
//	FONTOAM_SetPaletteOffset(fontoam, pal_offset);
	FONTOAM_SetPaletteOffsetAddTransPlttNo(fontoam, pal_offset);
	FONTOAM_SetMat(fontoam, x, y);
	
	//
	GF_BGL_BmpWinDel(&bmpwin);
	
	font_actor->fontoam = fontoam;
	font_actor->cma = cma;
	font_actor->font_len = font_len;
}

//--------------------------------------------------------------
/**
 * @brief   ĂtHgOAMSč폜
 * @param   aci		BIVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
static void Sub_FontOamDeleteAll(ACI_PARAM_PTR aci)
{
	int i;
	
	for(i = 0; i < FA_NO_MAX; i++){
		if(aci->font_actor[i].fontoam != NULL){
			FONTOAM_Delete(aci->font_actor[i].fontoam);
			CharVramAreaFree(&aci->font_actor[i].cma);
			aci->font_actor[i].fontoam = NULL;
		}
	}
}

//--------------------------------------------------------------
/**
 * @brief   Rn[gSč폜
 * @param   aci		BIVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
static void Sub_SubHeartJudgeDeleteAll(ACI_PARAM_PTR aci)
{
	if(aci->special_heart_cap != NULL){
		ACIT_SubHeartJudgeDel(aci->sys->crp, aci->special_heart_cap);
		aci->special_heart_cap = NULL;
	}
}

//--------------------------------------------------------------
/**
 * @brief   APln[gSč폜
 * @param   aci			BIVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
static void Sub_AppHeartDeleteAll(ACI_PARAM_PTR aci)
{
	int i, k;
	
	for(k = 0; k < WAZA_TEMOTI_MAX; k++){
		for(i = 0; i < APP_HEART_MAX; i++){
			if(aci->app_heart_cap[k][i] != NULL){
				ACIT_AppHeartActorDel(aci->app_heart_cap[k][i]);
				aci->app_heart_cap[k][i] = NULL;
			}
		}
	}
	ACIT_AppHeartResourceFree(aci->sys->crp);
}

//--------------------------------------------------------------
/**
 * @brief   ReXg^CvACRSĐ
 *
 * @param   aci		BIVXe[Nւ̃|C^
 * @param   wazano[]	莝̋Zԍzւ̃|C^(WAZA_TEMOTI_MAX鎖!)
 */
//--------------------------------------------------------------
static void Sub_ConTypeIconCreateAll(ACI_PARAM_PTR aci, u16 wazano[])
{
	int i;
	CATS_SYS_PTR csp;
	CATS_RES_PTR crp;
	TCATS_OBJECT_ADD_PARAM_S obj_param;
	int con_type;

	csp = aci->sys->csp;
	crp = aci->sys->crp;

	obj_param = ConTypeIconObjParam;
	//풓pbggpĂ̂Ńpbg[h͂Ȃ
//	ConTypeIcon_PlttWorkResourceLoad(BattleWorkPfdGet(aci->bw), FADE_SUB_OBJ, csp, crp, 
//		NNS_G2D_VRAM_TYPE_2DSUB, PLTTID_CONTYPE_ICON);
	ConTypeIcon_CellAnmResourceLoad(csp, crp, CELLID_CONTYPE_ICON, CELLANMID_CONTYPE_ICON);
	for(i = 0; i < WAZA_TEMOTI_MAX; i++){
		GF_ASSERT(aci->icon_cap[i] == NULL);
		if(wazano[i] != 0){
			con_type = WT_WazaDataParaGet(wazano[i], ID_WTD_contype);
			ConTypeIcon_CharResourceLoad(csp, crp, NNS_G2D_VRAM_TYPE_2DSUB, 
				con_type, CHARID_CONTYPE_ICON_1 + i);
			
			obj_param.id[CLACT_U_CHAR_RES] = CHARID_CONTYPE_ICON_1 + i;
			obj_param.x = WazaIconPos[i][0];
			obj_param.y = WazaIconPos[i][1];
			aci->icon_cap[i] = ConTypeIcon_ActorCreate(csp, crp, 
				con_type, &obj_param);
		}
	}
}

//--------------------------------------------------------------
/**
 * @brief   ReXg^CvACRSč폜
 * @param   aci		BIVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
static void Sub_ConTypeIconDeleteAll(ACI_PARAM_PTR aci)
{
	int i;
	CATS_SYS_PTR csp;
	CATS_RES_PTR crp;

	csp = aci->sys->csp;
	crp = aci->sys->crp;

	for(i = 0; i < WAZA_TEMOTI_MAX; i++){
		if(aci->icon_cap[i] != NULL){
			ConTypeIcon_ActorDelete(aci->icon_cap[i]);
			ConTypeIcon_CharResourceFree(crp, CHARID_CONTYPE_ICON_1 + i);
			aci->icon_cap[i] = NULL;
		}
	}
	ConTypeIcon_CellAnmResourceFree(crp, CELLID_CONTYPE_ICON, CELLANMID_CONTYPE_ICON);
	//풓pbggpĂ̂ŉ͂Ȃ
	//ConTypeIcon_PlttResourceFree(crp, PLTTID_CONTYPE_ICON);
}

//--------------------------------------------------------------
/**
 * @brief   Z^CvCGRf[^
 *
 * @param   aci				BIVXe[Nւ̃|C^
 * @param   waza_type		Z^Cv(莝̏ꍇ-1)
 * @param   waza_pos		莝̋Z̈ʒu(0`3)
 */
//--------------------------------------------------------------
static void Sub_WazaTypeCGRTrans(ACI_PARAM_PTR aci, int waza_type, int waza_pos)
{
	GF_BGL_INI *bgl;
	u32 screen_type;
	
	bgl = aci->sys->bgl;
	screen_type = GF_BGL_ScreenTypeGet(bgl, ACTINSUB_FRAME_PANEL);
	
	WazaPanel_EasyCharLoad(bgl, waza_type, HEAPID_ACTIN, ACTINSUB_FRAME_PANEL, 
		WazaTypeCgrPos[waza_pos], screen_type);
	WazaPanel_EasyPalLoad(aci->sys->pfd, waza_type, HEAPID_ACTIN, FADE_SUB_BG, 
		WAZATYPE_START_PALPOS + waza_pos);
}

//--------------------------------------------------------------
/**
 * @brief   wiȊÕt[SĔ\ɂ
 */
//--------------------------------------------------------------
static void Sub_BackScrnOnlyVisible(void)
{
	int i;
	
	for(i = 0; i < ACI_BG_NUM; i++){
		if(GF_BGL_FRAME0_S + i != ACTINSUB_FRAME_BACK){
			GF_BGL_VisibleSet(GF_BGL_FRAME0_S + i, VISIBLE_OFF);
		}
		else{
			GF_BGL_VisibleSet(GF_BGL_FRAME0_S + i, VISIBLE_ON);
		}
	}
}

//--------------------------------------------------------------
/**
 * @brief   pl^b`GtFNgIAwî݂ɂ邽߂̏FX(tHgOBJ̍폜Ƃ)
 * @param   none		BIVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
static void Sub_TouchEndDelete(ACI_PARAM_PTR aci)
{
	Sub_SceneOBJDelete(aci);
	VWaitTCB_Add(VWait_BackScrnOnlyVisible, aci, VWAIT_TCBPRI_BACKSCRN_VISIBLE);
}

//--------------------------------------------------------------
/**
 * @brief   BG^Cv؂ւ閈ɍ폜Kv̂OBJDelete
 * @param   aci		BIVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
static void Sub_SceneOBJDelete(ACI_PARAM_PTR aci)
{
	Sub_SubHeartJudgeDeleteAll(aci);
	Sub_AppHeartDeleteAll(aci);
	Sub_ConTypeIconDeleteAll(aci);
	Sub_FontOamDeleteAll(aci);
}



//==============================================================================
//
//	GtFNgTCB
//
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   GtFNgTCB𐶐
 *
 * @param   func		TCBɃZbg֐|C^
 * @param   aci			BIVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
static void EffectTCB_Add(TCB_FUNC func, ACI_PARAM_PTR aci)
{
	GF_ASSERT(aci->effect_tcb == NULL);
	
	MI_CpuClear8(&aci->effect_work, sizeof(ACI_EFFECT_WORK));
	aci->effect_tcb = TCB_Add(func, aci, TCBPRI_AINPUT_EFFECT);
}

//--------------------------------------------------------------
/**
 * @brief   GtFNgTCB폜
 * @param   aci		BIVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
static void EffectTCB_Delete(ACI_PARAM_PTR aci)
{
	if(aci->effect_tcb != NULL){
		TCB_Delete(aci->effect_tcb);
		aci->effect_tcb = NULL;
		MI_CpuClear8(&aci->effect_work, sizeof(ACI_EFFECT_WORK));
	}
}


//--------------------------------------------------------------
/**
 * @brief   plL]Ajsď܂B
 *          1̃plɑ΂1̃tHgOBJZbgɂȂĂ̗p̔ėp^XNł
 *
 * @param   tcb		TCBւ̃|C^
 * @param   work	BIVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
static void Effect_ButtonDown(TCB_PTR tcb, void *work)
{
	ACI_PARAM_PTR aci = work;
	GF_BGL_INI *bgl;
	int x, y;
	int i;
	
	bgl = aci->sys->bgl;
	
	switch(aci->effect_work.seq){
	case 0:
		aci->effect_work.paracgr.ctp = Sub_CgrTransTaskSet(ACTINSUB_FRAME_PANEL, 
			aci->effect_work.paracgr.arc_id,
			aci->effect_work.paracgr.transcgr_id[0], aci->effect_work.paracgr.ctp_rd_ptr[0]);
		
		FONTOAM_GetMat(aci->font_actor[aci->effect_work.paracgr.fa_no].fontoam, &x, &y);
		FONTOAM_SetMat(aci->font_actor[aci->effect_work.paracgr.fa_no].fontoam, 
			x, y + SCRN_SCROLL_A_EFF_Y);
		
		for(i = 0; i < PARACGR_CAP_MAX; i++){
			if(aci->effect_work.paracgr.cap[i] != NULL){
				CATS_ObjectPosMove(aci->effect_work.paracgr.cap[i]->act, 0, SCRN_SCROLL_A_EFF_Y);
			}
		}
		
		aci->effect_work.seq++;
		break;
	case 1:
		if(Sub_CgrTransEndCheck(aci->effect_work.paracgr.ctp) == FALSE){
			break;
		}
		aci->effect_work.seq++;
		//break;
	case 2:
		aci->effect_work.wait++;
		if(aci->effect_work.wait > SCRN_TOUCH_ANM_WAIT){
			aci->effect_work.wait = 0;
			aci->effect_work.seq++;
		}
		break;

	case 3:
		aci->effect_work.paracgr.ctp = Sub_CgrTransTaskSet(ACTINSUB_FRAME_PANEL, 
			aci->effect_work.paracgr.arc_id,
			aci->effect_work.paracgr.transcgr_id[1], aci->effect_work.paracgr.ctp_rd_ptr[1]);
		
		FONTOAM_GetMat(aci->font_actor[aci->effect_work.paracgr.fa_no].fontoam, &x, &y);
		FONTOAM_SetMat(aci->font_actor[aci->effect_work.paracgr.fa_no].fontoam, 
			x, y + SCRN_SCROLL_BACK_A_EFF_Y);
		
		for(i = 0; i < PARACGR_CAP_MAX; i++){
			if(aci->effect_work.paracgr.cap[i] != NULL){
				CATS_ObjectPosMove(aci->effect_work.paracgr.cap[i]->act, 
					0, SCRN_SCROLL_BACK_A_EFF_Y);
			}
		}
		
		aci->effect_work.seq++;
		break;
	case 4:
		if(Sub_CgrTransEndCheck(aci->effect_work.paracgr.ctp) == FALSE){
			break;
		}
		aci->effect_work.seq++;
		//break;
	case 5:
		aci->effect_work.wait++;
		if(aci->effect_work.wait > SCRN_TOUCH_WAIT){
			aci->effect_work.wait = 0;
			aci->effect_work.seq++;
		}
		break;

	default:
		Sub_TouchEndDelete(aci);
		EffectTCB_Delete(aci);
		return;
	}
}

//--------------------------------------------------------------
/**
 * @brief   plL]Ajsď܂B
 *          ZIpłB
 *
 * @param   tcb		TCBւ̃|C^
 * @param   work	BIVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
static void Effect_WazaButtonDown(TCB_PTR tcb, void *work)
{
	ACI_PARAM_PTR aci = work;
	GF_BGL_INI *bgl;
	int x, y;
	int fa_waza, fa_up, fa_down;
	int cap_icon, wazano;
	u16 wazano_array[WAZA_TEMOTI_MAX];
	int i, wazapos;
	
	bgl = aci->sys->bgl;
	
	for(i = 0; i < WAZA_TEMOTI_MAX; i++){
		wazano_array[i] = PokeParaGet(aci->sys->c_game->pp[aci->sys->c_game->my_breeder_no], 
			ID_PARA_waza1 + i, NULL);
	}

	switch(aci->effect_work.paracgr.tp_ret){
	case ACTIN_TP_WAZA_1:
		fa_waza = FA_NO_WAZA_1;
		fa_up = FA_NO_SETUMEI_1_U;
		fa_down = FA_NO_SETUMEI_1_D;
		cap_icon = 0;
		wazano = wazano_array[0];
		wazapos = 0;
		break;
	case ACTIN_TP_WAZA_2:
		fa_waza = FA_NO_WAZA_2;
		fa_up = FA_NO_SETUMEI_2_U;
		fa_down = FA_NO_SETUMEI_2_D;
		cap_icon = 1;
		wazano = wazano_array[1];
		wazapos = 1;
		break;
	case ACTIN_TP_WAZA_3:
		fa_waza = FA_NO_WAZA_3;
		fa_up = FA_NO_SETUMEI_3_U;
		fa_down = FA_NO_SETUMEI_3_D;
		cap_icon = 2;
		wazano = wazano_array[2];
		wazapos = 2;
		break;
	case ACTIN_TP_WAZA_4:
		fa_waza = FA_NO_WAZA_4;
		fa_up = FA_NO_SETUMEI_4_U;
		fa_down = FA_NO_SETUMEI_4_D;
		cap_icon = 3;
		wazano = wazano_array[3];
		wazapos = 3;
		break;
//	case SELECT_CANCEL:		̏LZ͂Ȃ@2005.12.03(y)
	default:
		fa_waza = 0;
		fa_up = 0;
		fa_down = 0;
		cap_icon = 0;
		wazano = 0;
		break;
	}
	
	switch(aci->effect_work.seq){
	case 0:
		aci->effect_work.paracgr.ctp = Sub_CgrTransTaskSet(ACTINSUB_FRAME_PANEL, 
			aci->effect_work.paracgr.arc_id,
			aci->effect_work.paracgr.transcgr_id[0], aci->effect_work.paracgr.ctp_rd_ptr[0]);
		
		if(1){	//aci->effect_work.paracgr.tp_ret != SELECT_CANCEL){
			FONTOAM_GetMat(aci->font_actor[fa_waza].fontoam, &x, &y);
			FONTOAM_SetMat(aci->font_actor[fa_waza].fontoam, x, y + SCRN_SCROLL_A_EFF_Y);
			FONTOAM_GetMat(aci->font_actor[fa_up].fontoam, &x, &y);
			FONTOAM_SetMat(aci->font_actor[fa_up].fontoam, x, y + SCRN_SCROLL_A_EFF_Y);
			FONTOAM_GetMat(aci->font_actor[fa_down].fontoam, &x, &y);
			FONTOAM_SetMat(aci->font_actor[fa_down].fontoam, x, y + SCRN_SCROLL_A_EFF_Y);
			if(wazano != 0){
				CATS_ObjectPosMove(aci->icon_cap[cap_icon]->act, 0, SCRN_SCROLL_A_EFF_Y);
				for(i = 0; i < APP_HEART_MAX; i++){
					if(aci->app_heart_cap[wazapos][i] != NULL){
						CATS_ObjectPosMove(aci->app_heart_cap[wazapos][i]->act, 0, 
							SCRN_SCROLL_A_EFF_Y);
					}
				}
			}
		}
		else{
		#if 0	//̂ƂLZȂ 2005.12.02()
			FontOBJ_PosGet(&aci->font_actor[FA_NO_WAZA_MODORU], FONTOBJ_POS_LEFT, &x, &y);
			FontOBJ_PosSet(&aci->font_actor[FA_NO_WAZA_MODORU], FONTOBJ_POS_LEFT, 
				x, y + SCRN_SCROLL_A_EFF_Y);
		#endif
		}
		
		aci->effect_work.seq++;
		break;
	case 1:
		if(Sub_CgrTransEndCheck(aci->effect_work.paracgr.ctp) == FALSE){
			break;
		}
		aci->effect_work.seq++;
		//break;
	case 2:
		aci->effect_work.wait++;
		if(aci->effect_work.wait > SCRN_TOUCH_ANM_WAIT){
			aci->effect_work.wait = 0;
			aci->effect_work.seq++;
		}
		break;

	case 3:
		aci->effect_work.paracgr.ctp = Sub_CgrTransTaskSet(ACTINSUB_FRAME_PANEL, 
			aci->effect_work.paracgr.arc_id,
			aci->effect_work.paracgr.transcgr_id[1], aci->effect_work.paracgr.ctp_rd_ptr[1]);
		
		if(1){	//aci->effect_work.paracgr.tp_ret != SELECT_CANCEL){
			FONTOAM_GetMat(aci->font_actor[fa_waza].fontoam, &x, &y);
			FONTOAM_SetMat(aci->font_actor[fa_waza].fontoam, x, y + SCRN_SCROLL_BACK_A_EFF_Y);
			FONTOAM_GetMat(aci->font_actor[fa_up].fontoam, &x, &y);
			FONTOAM_SetMat(aci->font_actor[fa_up].fontoam, x, y + SCRN_SCROLL_BACK_A_EFF_Y);
			FONTOAM_GetMat(aci->font_actor[fa_down].fontoam, &x, &y);
			FONTOAM_SetMat(aci->font_actor[fa_down].fontoam, x, y + SCRN_SCROLL_BACK_A_EFF_Y);
			if(wazano != 0){
				CATS_ObjectPosMove(aci->icon_cap[cap_icon]->act, 0, SCRN_SCROLL_BACK_A_EFF_Y);
				for(i = 0; i < APP_HEART_MAX; i++){
					if(aci->app_heart_cap[wazapos][i] != NULL){
						CATS_ObjectPosMove(aci->app_heart_cap[wazapos][i]->act, 0, 
							SCRN_SCROLL_BACK_A_EFF_Y);
					}
				}
			}
		}
		else{
		#if 0	//̂ƂLZȂ 2005.12.02()
			FontOBJ_PosGet(&aci->font_actor[FA_NO_WAZA_MODORU], FONTOBJ_POS_LEFT, &x, &y);
			FontOBJ_PosSet(&aci->font_actor[FA_NO_WAZA_MODORU], FONTOBJ_POS_LEFT, 
				x, y + SCRN_SCROLL_BACK_A_EFF_Y);
		#endif
		}
		
		aci->effect_work.seq++;
		break;
	case 4:
		if(Sub_CgrTransEndCheck(aci->effect_work.paracgr.ctp) == FALSE){
			break;
		}
		aci->effect_work.seq++;
		//break;
	case 5:
		aci->effect_work.wait++;
		if(aci->effect_work.wait > SCRN_TOUCH_WAIT){
			aci->effect_work.wait = 0;
			aci->effect_work.seq++;
		}
		break;

	default:
		Sub_TouchEndDelete(aci);
		EffectTCB_Delete(aci);
		return;
	}
}









//==============================================================================
//
//	VuN
//
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   et[Visibleݒs
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		BIVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
static void VWait_FrameVisibleUpdate(TCB_PTR tcb, void *work)
{
	ACI_PARAM_PTR aci = work;
	const BG_MAKE_DATA *bmd;
	int i;

	bmd = &BgMakeData[aci->makedata_no];
	
	//eBGʂ̕\E\ݒ
	for(i = 0; i < ACI_BG_NUM; i++){
		if(bmd->scr_id[i] == NONE_ID){
			GF_BGL_VisibleSet(GF_BGL_FRAME0_S + i, VISIBLE_OFF);
		}
		else{
			GF_BGL_VisibleSet(GF_BGL_FRAME0_S + i, VISIBLE_ON);
		}
	}
	
	TCB_Delete(tcb);
}

//--------------------------------------------------------------
/**
 * @brief   wiȊÕt[SĂ\ɂ
 *
 * @param   tcb		TCBւ̃|C^
 * @param   work	BIVXe[Nւ̃|C^
 *
 * @retval  
 *
 *
 */
//--------------------------------------------------------------
static void VWait_BackScrnOnlyVisible(TCB_PTR tcb, void *work)
{
	ACI_PARAM_PTR aci = work;

	Sub_BackScrnOnlyVisible();
	TCB_Delete(tcb);
}

//--------------------------------------------------------------
/**
 * @brief   VuNCGR]Ajs܂
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		CGR]Ajp[^[Nւ̃|C^
 */
//--------------------------------------------------------------
static void VWait_CgrParamTrans(TCB_PTR tcb, void *work)
{
	CGR_TRANS_PARAM *ctp = work;
	
	Sub_CgrParamTrans(ctp);
	ctp->v_tcb = NULL;
	TCB_Delete(tcb);
}


