//==============================================================================
/**
 * @file	actin_order.c
 * @brief	Z͕F߂eX^btɑM
 * @author	matsuda
 * @date	2005.11.25()
 */
//==============================================================================
#include "common.h"
#include "contest/contest.h"
#include "actin.h"
#include "actin_tcb_pri.h"
#include "battle/battle_common.h"
#include "system/clact_tool.h"
#include "system/palanm.h"

#include "system/arc_tool.h"
#include "system/arc_util.h"

#include "system/softsprite.h"

#include "system/fontproc.h"
#include "system/msgdata.h"

#include "wazaeffect/battle_particle.h"
#include "system/particle.h"
#include "wazaeffect/we_mana.h"
#include "wazaeffect/we_sys.h"

#include "system/brightness.h"

#include "graphic/contest_bg_def.h"
#include "graphic/contest_obj_def.h"

#include "actin_tool.h"
#include "actin_order.h"
#include "actin_input.h"
#include "poketool/poke_tool.h"
#include "gflib/touchpanel.h"
#include "system/snd_tool.h"
#include "contest_order.h"


//==============================================================================
//	萔`
//==============================================================================
///As[ACR1_閈ɑ҂EFCg
#define APPEAL_ICON_LIGHT_WAIT		(4)
///{e[WACR1_閈ɑ҂EFCg
#define VOLTAGE_ICON_LIGHT_WAIT		(APPEAL_ICON_LIGHT_WAIT)
///ϋqAjJn܂ł̃EFCg
#define AUDIENCE_ANM_START_WAIT		(0)
///ϋqAjZbgĂ玟̃V[PX֐i߂܂ł̃EFCg
#define AUDIENCE_ANM_NEXT_WAIT		(8)

///ZGtFNgoO̐RANVŁAGtFNgȊ҂
#define WAZABEFORE_JUDGE_REACTION_END_WAIT		(5)


//==============================================================================
//	vg^Cv錾
//==============================================================================
static int Request_Sample(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work);
static void Recieve_Sample(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data);
static void Answer_Sample(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *answer_head, CO_ANSDAT *data, int net_id);
static int Request_PokemonSpriteAddAll(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work);
static void Recieve_PokemonSpriteAddAll(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data);
static int Request_PokemonIn(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work);
static void Recieve_PokemonIn(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data);
static void AOTCB_PokemonIn(TCB_PTR tcb, void *work);
static int Request_PokemonOut(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work);
static void Recieve_PokemonOut(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data);
static void AOTCB_PokemonOut(TCB_PTR tcb, void *work);
static int Request_WazaEffectBefore(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work);
static void Recieve_WazaEffectBefore(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data);
static void AOTCB_WazaEffectBefore(TCB_PTR tcb, void *work);
static int Request_WazaEffect(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work);
static void Recieve_WazaEffect(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data);
static void AOTCB_WazaEffect(TCB_PTR tcb, void *work);
static int Request_WazaSelect(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work);
static void Recieve_WazaSelect(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data);
static void Answer_WazaSelect(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *answer_head, CO_ANSDAT *ansdat, int net_id);
static void AOTCB_WazaSelect(TCB_PTR tcb, void *work);
static int Request_JudgeSelect(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work);
static void Recieve_JudgeSelect(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data);
static void AOTCB_JudgeSelect(TCB_PTR tcb, void *work);
static void Answer_JudgeSelect(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *answer_head, 
	CO_ANSDAT *ansdat, int net_id);
static int Request_AppealReview(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work);
static void Recieve_AppealReview(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data);
static void AOTCB_AppealReview(TCB_PTR tcb, void *work);
static int Request_AppealFirst(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work);
static void Recieve_AppealFirst(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data);
static void AOTCB_AppealFirst(TCB_PTR tcb, void *work);
static int Request_ActinExit(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work);
static void Recieve_ActinExit(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data);
static int Request_TurnParamUpdate(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work);
static void Recieve_TurnParamUpdate(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data);
static int Request_AppealKouka(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work);
static void Recieve_AppealKouka(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data);
static void AOTCB_AppealKouka(TCB_PTR tcb, void *work);
static int Request_AppealSpecialKouka(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work);
static void Recieve_AppealSpecialKouka(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data);
static void AOTCB_AppealSpecialKouka(TCB_PTR tcb, void *work);
static int Request_AppealVoltage(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, 
	void *work);
static void Recieve_AppealVoltage(CONTEST_ORDER_WORK *cow, void *syswork, 
	const CORDER_HEAD *req_head, void *data);
static void AOTCB_AppealVoltage(TCB_PTR tcb, void *work);
static int Request_ReviewAfterKouka(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, 
	void *work);
static void Recieve_ReviewAfterKouka(CONTEST_ORDER_WORK *cow, void *syswork, 
	const CORDER_HEAD *req_head, void *data);
static void AOTCB_ReviewAfterKouka(TCB_PTR tcb, void *work);
static int Request_JudgeSuffer(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, 
	void *work);
static void Recieve_JudgeSuffer(CONTEST_ORDER_WORK *cow, void *syswork, 
	const CORDER_HEAD *req_head, void *data);
static void AOTCB_JudgeSuffer(TCB_PTR tcb, void *work);
static int Request_JudgeComment(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work);
static void Recieve_JudgeComment(CONTEST_ORDER_WORK *cow, void *syswork, 
	const CORDER_HEAD *req_head, void *data);
static void AOTCB_JudgeComment(TCB_PTR tcb, void *work);
static int Request_Talk(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work);
static void Recieve_Talk(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data);
static void AOTCB_TalkPut(TCB_PTR tcb, void *work);



//==============================================================================
//	f[^
//==============================================================================
///ߑMp֐|C^\̃e[u	ɒǉK.henumɂǉ鎖!!
static const CON_ORDER_FUNC OrderFuncTbl[] = {
	{//AORDER_NO_SAMPLE		Tv
		Request_Sample, 
		Recieve_Sample, 
		Answer_Sample, 
	},
	{//AORDER_NO_ACTIN_EXIT
		Request_ActinExit,
		Recieve_ActinExit,
		NULL,
	},
	{//AORDER_NO_POKEMON_SPRITE_ADD_ALL
		Request_PokemonSpriteAddAll,
		Recieve_PokemonSpriteAddAll,
		NULL,
	},
	{//AORDER_NO_POKEMON_IN
		Request_PokemonIn,
		Recieve_PokemonIn,
		NULL,
	},
	{//AORDER_NO_POKEMON_OUT
		Request_PokemonOut,
		Recieve_PokemonOut,
		NULL,
	},
	{//AORDER_NO_WAZAEFFECT_BEFORE
		Request_WazaEffectBefore,
		Recieve_WazaEffectBefore,
		NULL,
	},
	{//AORDER_NO_WAZAEFFECT
		Request_WazaEffect,
		Recieve_WazaEffect,
		NULL,
	},
	{//AORDER_NO_WAZA_SELECT
		Request_WazaSelect,
		Recieve_WazaSelect,
		Answer_WazaSelect,
	},
	{//AORDER_NO_JUDGE_SELECT
		Request_JudgeSelect,
		Recieve_JudgeSelect,
		Answer_JudgeSelect,
	},
	{//AORDER_NO_APPEAL_REVIEW
		Request_AppealReview,
		Recieve_AppealReview,
		NULL,
	},
	{//AORDER_NO_APPEAL_FIRST
		Request_AppealFirst,
		Recieve_AppealFirst,
		NULL,
	},
	{//AORDER_NO_APPEAL_KOUKA
		Request_AppealKouka,
		Recieve_AppealKouka,
		NULL,
	},
	{//AORDER_NO_APPEAL_SPECIAL_KOUKA
		Request_AppealSpecialKouka,
		Recieve_AppealSpecialKouka,
		NULL,
	},
	{//AORDER_NO_APPEAL_VOLTAGE
		Request_AppealVoltage,
		Recieve_AppealVoltage,
		NULL,
	},
	{//AORDER_NO_REVIEW_AFTER
		Request_ReviewAfterKouka,
		Recieve_ReviewAfterKouka,
		NULL,
	},
	{//AORDER_NO_REVIEW_END
		Request_ReviewAfterKouka,
		Recieve_ReviewAfterKouka,
		NULL,
	},
	{//AORDER_NO_JUDGE_SUFFER
		Request_JudgeSuffer,
		Recieve_JudgeSuffer,
		NULL,
	},
	{//AORDER_NO_JUDGE_COMMENT
		Request_JudgeComment,
		Recieve_JudgeComment,
		NULL,
	},
	{//AORDER_NO_TURN_PARAM_UPDATE
		Request_TurnParamUpdate,
		Recieve_TurnParamUpdate,
		NULL,
	},
	{//AORDER_NO_TALK
		Request_Talk,
		Recieve_Talk,
		NULL,
	},
};



//--------------------------------------------------------------
/**
 * @brief   _XFReXgM[N
 * @param   dpw		_XǗ[Nւ̃|C^
 */
//--------------------------------------------------------------
void ActinOrder_WorkInit(ACTIN_PROC_WORK *apw)
{
	CO_INIT_DATA initdata;
	
	initdata.func_tbl = OrderFuncTbl;
	initdata.func_tbl_max = NELEMS(OrderFuncTbl);
	initdata.my_breeder_no = apw->consys->c_game.my_breeder_no;
	initdata.server_no = apw->consys->c_game.server_no;
	initdata.sio_flag = apw->consys->sio_flag;
	
	CO_WorkInit(&apw->cow, &initdata);
}


//==============================================================================
//
//	
//
//==============================================================================

//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   ߑM(M)FTv
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   work		Cӂ̃|C^
 *
 * @retval  o^ꂽNGXgrbgԍ
 */
//--------------------------------------------------------------
static int Request_Sample(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work)
{
	ACTIN_PROC_WORK *apw = syswork;
	int bit_no;
	
	bit_no = CO_REQUEST_TransmitBufferSet(&apw->cow, CSELECT_ALL, order_no, NULL, 0);
	return bit_no;
}

//--------------------------------------------------------------
/**
 * @brief   ߎM(M)FTv
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   req_head	NGXgwb_̃|C^
 * @param   data		Mf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void Recieve_Sample(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data)
{
	ACTIN_PROC_WORK *apw = syswork;
	//ԎԂ	obt@͓ɓn̂Ȃ̂NULLw
	CO_ANSWER_TransmitBufferSet(&apw->cow, req_head, NULL, 0);
}

//--------------------------------------------------------------
/**
 * @brief   ԎM(M)FTv
 *
 * @param   apw				Z͕Ǘ[Nւ̃|C^
 * @param   answer_head		Ԏwb_̃|C^
 * @param   ansdat			Mf[^ւ̃|C^
 * @param   net_id			ԎM҂̃lbgID
 */
//--------------------------------------------------------------
static void Answer_Sample(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *answer_head, CO_ANSDAT *ansdat, int net_id)
{
	ACTIN_PROC_WORK *apw = syswork;
	//Ԏ󂯎邾Ȃ̂œɂ鎖Ȃ
	return;
}

//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   ߑM(M)FZ͕I
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   work		Cӂ̃|C^
 *
 * @retval  o^ꂽNGXgrbgԍ
 */
//--------------------------------------------------------------
static int Request_ActinExit(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work)
{
	ACTIN_PROC_WORK *apw = syswork;
	int bit_no;
	
	bit_no = CO_REQUEST_TransmitBufferSet(&apw->cow, CSELECT_ALL, order_no, NULL, 0);
	return bit_no;
}

//--------------------------------------------------------------
/**
 * @brief   ߎM(M)FZ͕I
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   req_head	NGXgwb_̃|C^
 * @param   data		Mf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void Recieve_ActinExit(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data)
{
	ACTIN_PROC_WORK *apw = syswork;
	
	apw->main_end = TRUE;
	
	//ԎԂ	obt@͓ɓn̂Ȃ̂NULLw
	CO_ANSWER_TransmitBufferSet(&apw->cow, req_head, NULL, 0);
}


//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   ߑM(M)F|P(\tgEFAXvCg)SĂ𐶐
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   work		Cӂ̃|C^
 *
 * @retval  o^ꂽNGXgrbgԍ
 */
//--------------------------------------------------------------
static int Request_PokemonSpriteAddAll(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work)
{
	ACTIN_PROC_WORK *apw = syswork;
	int bit_no;
	
	bit_no = CO_REQUEST_TransmitBufferSet(&apw->cow, CSELECT_ALL, order_no, NULL, 0);
	return bit_no;
}

//--------------------------------------------------------------
/**
 * @brief   ߎM(M)F|P(\tgEFAXvCg)SĂ𐶐
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   req_head	NGXgwb_̃|C^
 * @param   data		Mf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void Recieve_PokemonSpriteAddAll(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data)
{
	ACTIN_PROC_WORK *apw = syswork;

	AT_SoftSpriteAddAll(&apw->sys);
	
	//ԎԂ	obt@͓ɓn̂Ȃ̂NULLw
	CO_ANSWER_TransmitBufferSet(&apw->cow, req_head, NULL, 0);
}



//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   ߑM(M)F|Po
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   work		isp[^
 *
 * @retval  o^ꂽNGXgrbgԍ
 */
//--------------------------------------------------------------
static int Request_PokemonIn(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work)
{
	ACTIN_PROC_WORK *apw = syswork;
	int bit_no;
	
	bit_no = CO_REQUEST_TransmitBufferSet(
		&apw->cow, CSELECT_ALL, order_no, work, sizeof(ACTIN_ADVANCE_PARAM));
	return bit_no;
}

//--------------------------------------------------------------
/**
 * @brief   ߎM(M)F|Po
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   req_head	NGXgwb_̃|C^
 * @param   data		Mf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void Recieve_PokemonIn(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data)
{
	ACTIN_PROC_WORK *apw = syswork;
	AOLOCAL_POKE_INOUT *pi;
	ACTIN_ADVANCE_PARAM *aap;
	int height, now;
	
	aap = data;
	
	pi = sys_AllocMemory(HEAPID_ACTIN, sizeof(AOLOCAL_POKE_INOUT));
	MI_CpuClear8(pi, sizeof(AOLOCAL_POKE_INOUT));
	
	pi->apw = apw;
	pi->req_head = *req_head;
	pi->breeder_no = aap->now_breeder;

	now = pi->breeder_no;
	height = PokeParaHeightGet(apw->sys.c_game->pp[now], PARA_BACK);
	
	SoftSpriteParaSet(apw->sys.ss[now], SS_PARA_DRAW_STOP, FALSE);
	SoftSpriteParaSet(apw->sys.ss[now], SS_PARA_VANISH, FALSE);
	SoftSpriteParaSet(apw->sys.ss[now], SS_PARA_POS_X, ACTIN_POKEPOS_APPEAR_X);
	SoftSpriteParaSet(apw->sys.ss[now], SS_PARA_POS_Y, ACTIN_POKEPOS_APPEAR_Y + height);
	
	pi->x = ACTIN_POKEPOS_APPEAR_X << 8;
	pi->y = ACTIN_POKEPOS_APPEAR_Y << 8;
	
	//AT_TalkWinSlideTaskSet(&apw->sys, TALKWIN_SLIDE_DIR_OUT, &pi->slide_end);
	AT_BrdPanelAlphaEffectSet(apw, BRDPANEL_ALPHA_TYPE_RETIRE, &pi->slide_end);
	TCB_Add(AOTCB_PokemonIn, pi, TCBPRI_ACTIN_ORDERSUB);
}

//--------------------------------------------------------------
/**
 * @brief   |Po
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		AOLOCAL_POKE_INOUT\
 */
//--------------------------------------------------------------
static void AOTCB_PokemonIn(TCB_PTR tcb, void *work)
{
	AOLOCAL_POKE_INOUT *pi = work;
	int now, height;
	
	now = pi->breeder_no;
	height = PokeParaHeightGet(pi->apw->sys.c_game->pp[now], PARA_BACK);
	
	switch(pi->seq){
	case 0:
		pi->x -= ACTIN_POKEMOVE_IN_X;
		pi->y -= ACTIN_POKEMOVE_IN_Y;
		if((pi->x >> 8) <= ACTIN_POKEPOS_X || (pi->y >> 8) <= ACTIN_POKEPOS_Y){
			pi->x = ACTIN_POKEPOS_X << 8;
			pi->y = ACTIN_POKEPOS_Y << 8;
			pi->seq++;
		}
		SoftSpriteParaSet(pi->apw->sys.ss[pi->breeder_no], SS_PARA_POS_X, pi->x >> 8);
		SoftSpriteParaSet(pi->apw->sys.ss[pi->breeder_no], SS_PARA_POS_Y, 
			(pi->y >> 8) + height);
		break;
	default:
		if(pi->slide_end == TRUE){
			CO_ANSWER_TransmitBufferSet(&pi->apw->cow, &pi->req_head, NULL, 0);
			
			sys_FreeMemoryEz(pi);
			TCB_Delete(tcb);
			return;
		}
		break;
	}
}

//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   ߑM(M)F|Pޏ
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   work		isp[^
 *
 * @retval  o^ꂽNGXgrbgԍ
 */
//--------------------------------------------------------------
static int Request_PokemonOut(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work)
{
	ACTIN_PROC_WORK *apw = syswork;
	int bit_no;
	
	bit_no = CO_REQUEST_TransmitBufferSet(
		&apw->cow, CSELECT_ALL, order_no, work, sizeof(ACTIN_ADVANCE_PARAM));
	return bit_no;
}

//--------------------------------------------------------------
/**
 * @brief   ߎM(M)F|Pޏ
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   req_head	NGXgwb_̃|C^
 * @param   data		Mf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void Recieve_PokemonOut(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data)
{
	ACTIN_PROC_WORK *apw = syswork;
	AOLOCAL_POKE_INOUT *pi;
	ACTIN_ADVANCE_PARAM *aap;
	int height, now;
	
	aap = data;
	
	pi = sys_AllocMemory(HEAPID_ACTIN, sizeof(AOLOCAL_POKE_INOUT));
	MI_CpuClear8(pi, sizeof(AOLOCAL_POKE_INOUT));
	
	pi->apw = apw;
	pi->req_head = *req_head;
	pi->breeder_no = aap->now_breeder;

	now = pi->breeder_no;
	height = PokeParaHeightGet(apw->sys.c_game->pp[now], PARA_BACK);

	pi->x = ACTIN_POKEPOS_X << 8;
	pi->y = ACTIN_POKEPOS_Y << 8;
	
	//AT_TalkWinSlideTaskSet(&apw->sys, TALKWIN_SLIDE_DIR_IN, &pi->slide_end);
	TCB_Add(AOTCB_PokemonOut, pi, TCBPRI_ACTIN_ORDERSUB);
}

//--------------------------------------------------------------
/**
 * @brief   |Pޏ
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		AOLOCAL_POKE_INOUT\
 */
//--------------------------------------------------------------
static void AOTCB_PokemonOut(TCB_PTR tcb, void *work)
{
	AOLOCAL_POKE_INOUT *pi = work;
	int now, height;
	
	now = pi->breeder_no;
	height = PokeParaHeightGet(pi->apw->sys.c_game->pp[now], PARA_BACK);
	
	switch(pi->seq){
	case 0:
		pi->x += ACTIN_POKEMOVE_OUT_X;
		pi->y += ACTIN_POKEMOVE_OUT_Y;
		if((pi->x >> 8) >= ACTIN_POKEPOS_APPEAR_X || (pi->y >> 8) >= ACTIN_POKEPOS_APPEAR_Y){
			SoftSpriteParaSet(pi->apw->sys.ss[now], SS_PARA_DRAW_STOP, TRUE);
			SoftSpriteParaSet(pi->apw->sys.ss[now], SS_PARA_VANISH, TRUE);
			pi->seq++;
		}
		SoftSpriteParaSet(pi->apw->sys.ss[pi->breeder_no], SS_PARA_POS_X, pi->x >> 8);
		SoftSpriteParaSet(pi->apw->sys.ss[pi->breeder_no], SS_PARA_POS_Y, 
			(pi->y >> 8) + height);
		break;
	default:
		CO_ANSWER_TransmitBufferSet(&pi->apw->cow, &pi->req_head, NULL, 0);
		
		sys_FreeMemoryEz(pi);
		TCB_Delete(tcb);
		return;
	}
}

//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   ߑM(M)FZGtFNgoOɍs
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   work		Cӂ̃|C^
 *
 * @retval  o^ꂽNGXgrbgԍ
 */
//--------------------------------------------------------------
static int Request_WazaEffectBefore(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work)
{
	ACTIN_PROC_WORK *apw = syswork;
	int bit_no;
	
	bit_no = CO_REQUEST_TransmitBufferSet(&apw->cow, CSELECT_ALL, order_no, 
		work, sizeof(ACTIN_ADVANCE_PARAM));
	return bit_no;
}

//--------------------------------------------------------------
/**
 * @brief   ߎM(M)FZGtFNgoOɍs
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   req_head	NGXgwb_̃|C^
 * @param   data		Mf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void Recieve_WazaEffectBefore(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data)
{
	ACTIN_PROC_WORK *apw = syswork;
	AOLOCAL_WAZAEFF_BEFORE *wb;
	ACTIN_ADVANCE_PARAM *aap = data;
	
	wb = sys_AllocMemory(HEAPID_ACTIN, sizeof(AOLOCAL_WAZAEFF_BEFORE));
	MI_CpuClear8(wb, sizeof(AOLOCAL_WAZAEFF_BEFORE));
	
	wb->apw = apw;
	wb->req_head = *req_head;
	wb->breeder_no = aap->now_breeder;
	wb->judge_no = aap->judge_no;
	wb->a_talk_id = aap->nt.a_talk_id;
	wb->a_talk_tagpara = aap->nt.a_talk_tagpara;
	wb->judge_reaction_type = aap->judge_reaction_type;
	
	TCB_Add(AOTCB_WazaEffectBefore, wb, TCBPRI_ACTIN_ORDERSUB);
}

//--------------------------------------------------------------
/**
 * @brief   ZGtFNgoOɍs
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		AOLOCAL_WAZAEFF_BEFORE\
 */
//--------------------------------------------------------------
static void AOTCB_WazaEffectBefore(TCB_PTR tcb, void *work)
{
	AOLOCAL_WAZAEFF_BEFORE *wb = work;
	int transparent_no;
	enum{
		WBSEQ_MSG_INIT,
		WBSEQ_MSG_WAIT,
		WBSEQ_MSG_END,
		WBSEQ_JUDGE_REACTION_INIT,
		WBSEQ_JUDGE_REACTION_WAIT,
		WBSEQ_JUDGE_REACTION_END,
	};
	
	switch(wb->seq){
	case WBSEQ_MSG_INIT:
		if(wb->a_talk_id != A_TALK_NULL){
			AT_A_TalkMessageSet(wb->apw, wb->a_talk_id, &wb->a_talk_tagpara);
			wb->seq++;
		}
		else{
			wb->seq = WBSEQ_MSG_END;
		}
		break;
	case WBSEQ_MSG_WAIT:
		if(AT_TalkMessageEndCheck(wb->apw) == 0){
			wb->seq++;
		}
		break;
	case WBSEQ_MSG_END:
		wb->seq++;
		break;

	case WBSEQ_JUDGE_REACTION_INIT:
		AT_JudgeReactionIconON(&wb->apw->sys, wb->judge_no, wb->judge_reaction_type);
		AT_JudgeReactionMoveTaskSet(wb->apw, wb->judge_no, wb->judge_reaction_type, 
			&wb->reaction_end);
		wb->seq++;
		break;
	case WBSEQ_JUDGE_REACTION_WAIT:
		if(wb->reaction_end == TRUE){
			wb->seq++;
		}
		break;
	case WBSEQ_JUDGE_REACTION_END:
		wb->wait++;
		if(wb->wait > WAZABEFORE_JUDGE_REACTION_END_WAIT){
			AT_JudgeReactionIconOFF(&wb->apw->sys);
			wb->seq++;
		}
		break;
	
	default:
		CO_ANSWER_TransmitBufferSet(&wb->apw->cow, &wb->req_head, NULL, 0);

		sys_FreeMemoryEz(wb);
		TCB_Delete(tcb);
		return;
	}
}

//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   ߑM(M)FZGtFNgo
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   work		Cӂ̃|C^
 *
 * @retval  o^ꂽNGXgrbgԍ
 */
//--------------------------------------------------------------
static int Request_WazaEffect(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work)
{
	ACTIN_PROC_WORK *apw = syswork;
	int bit_no;
	
	bit_no = CO_REQUEST_TransmitBufferSet(&apw->cow, CSELECT_ALL, order_no, 
		work, sizeof(ACTIN_ADVANCE_PARAM));
	return bit_no;
}

//--------------------------------------------------------------
/**
 * @brief   ߎM(M)FZGtFNgo
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   req_head	NGXgwb_̃|C^
 * @param   data		Mf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void Recieve_WazaEffect(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data)
{
	ACTIN_PROC_WORK *apw = syswork;
	AOLOCAL_WAZAEFF *we;
	ACTIN_ADVANCE_PARAM *aap = data;
	
	we = sys_AllocMemory(HEAPID_ACTIN, sizeof(AOLOCAL_WAZAEFF));
	MI_CpuClear8(we, sizeof(AOLOCAL_WAZAEFF));
	
	we->apw = apw;
	we->req_head = *req_head;
	we->breeder_no = aap->now_breeder;
	we->waza_no = aap->wazapara.personal[aap->now_breeder].wazano;//aap->waza_no;
	we->a_talk_id = aap->nt.a_talk_id;
	we->a_talk_tagpara = aap->nt.a_talk_tagpara;
	
	TCB_Add(AOTCB_WazaEffect, we, TCBPRI_ACTIN_WAZAEFF);
}

//--------------------------------------------------------------
/**
 * @brief   ZGtFNgs
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		AOLOCAL_WAZAEFF\
 */
//--------------------------------------------------------------
static void AOTCB_WazaEffect(TCB_PTR tcb, void *work)
{
	AOLOCAL_WAZAEFF *we = work;
	int transparent_no;
	enum{
		WESEQ_MSG_INIT,
		WESEQ_MSG_WAIT,
		WESEQ_MSG_END,
		WESEQ_EFF_INIT,
		WESEQ_EFF_WAIT,
		WESEQ_PANEL_IN,
		WESEQ_PANEL_WAIT,
	};
	
	switch(we->seq){
	case WESEQ_MSG_INIT:
		if(we->a_talk_id != A_TALK_NULL){
			AT_A_TalkMessageSet(we->apw, we->a_talk_id, &we->a_talk_tagpara);
			we->seq++;
		}
		else{
			we->seq = WESEQ_MSG_END;
		}
		break;
	case WESEQ_MSG_WAIT:
		if(AT_TalkMessageEndCheck(we->apw) == 0){
			we->seq++;
		}
		break;
	case WESEQ_MSG_END:
		we->seq++;
		break;

	case WESEQ_EFF_INIT:
		{
			WAZA_EFFECT_PARAM eff;
			WES_CALL_BTL_EX_PARAM exparam;
			int i, monsno;
			
			MI_CpuClear8(&eff, sizeof(WAZA_EFFECT_PARAM));
			MI_CpuClear8(&exparam, sizeof(WES_CALL_BTL_EX_PARAM));
			
			monsno = PokeParaGet(we->apw->sys.c_game->pp[we->breeder_no], ID_PARA_monsno, NULL);
			
			//WAZA_EFFECT_PARAMf[^쐬
		#if WAIT_FIX	//powerȂxȂǂ̎擾܂m 2005.11.29()
			eff.command_code = 0;
			eff.mode = 0;
			eff.waza_no = we->waza_no;
			eff.waza_eff_damage = 1;
			eff.waza_eff_power = 10;
			eff.waza_eff_cnt = 0;
			eff.waza_eff_natuki = 100;
			eff.waza_eff_weather = 0;
			eff.at_client_no = 0;
			eff.df_client_no = 1;
			eff.csp = we->apw->sys.csp;
		#else
			eff.command_code = 0;
			eff.mode = 0;
			eff.waza_no = we->waza_no;
			eff.waza_eff_damage = 1;
			eff.waza_eff_power = 10;
			eff.waza_eff_cnt = 0;
			eff.waza_eff_natuki = 100;
			eff.waza_eff_weather = 0;
			eff.at_client_no = 0;
			eff.df_client_no = 1;
			eff.csp = we->apw->sys.csp;
		#endif
			for(i = 0; i < CLIENT_MAX; i++){
				eff.mons_no[i] = monsno;
			}
			
			//WES_CALL_BTL_EX_PARAMf[^쐬
//			we->exchr_tbl[0] = &we->apw->sys.exchr_param[we->breeder_no];
//			we->exchr_tbl[1] = &we->apw->sys.transparent_exchr_param;
			exparam.bgl = we->apw->sys.bgl;
			exparam.pfd = we->apw->sys.pfd;
			exparam.excp[0] = &we->apw->sys.exchr_param[we->breeder_no];
			exparam.excp[1] = &we->apw->sys.transparent_exchr_param;
			for(i = 0; i < CLIENT_MAX; i++){
				exparam.client_type[i] = 0xff;
			}
			exparam.client_type[0] = CLIENT_TYPE_AA;
			exparam.client_type[1] = CLIENT_TYPE_BB;
			exparam.ss[0] = we->apw->sys.ss[we->breeder_no];
			transparent_no = (we->breeder_no == 0) ? 1 : 0;
			exparam.ss[1] = we->apw->sys.ss[transparent_no];
			exparam.fight_type = 0;
			exparam.eff_arc_id = ARC_WAZA_EFF;
			exparam.haikei_data.arc_index = ARC_CONTEST_BG;
			exparam.haikei_data.chr_id = CON_BG_NCGR_BIN;
			exparam.haikei_data.pal_id = CONTEST_BG_NCLR;
			exparam.haikei_data.scr_id = CON_BG_NSCR_BIN;
			exparam.haikei_data.pal_start = 0;
			exparam.haikei_data.pal_num = 16;
			//ZGtFNgZbg
			WES_Call_Ex(we->apw->sys.wsp, &eff, we->waza_no, &exparam);
		}
		
		//\tgEFAXvCg̐ݒ
		{
			int height;
			
			height = PokeParaHeightGet(we->apw->sys.c_game->pp[we->breeder_no], PARA_BACK);
			
			SoftSpriteParaSet(we->apw->sys.ss[we->breeder_no], SS_PARA_VANISH, FALSE);
			SoftSpriteParaSet(we->apw->sys.ss[we->breeder_no], SS_PARA_DRAW_STOP, FALSE);
			SoftSpriteParaSet(we->apw->sys.ss[we->breeder_no], 
				SS_PARA_POS_X, CONTEST_ATTACK_POKE_X);
			SoftSpriteParaSet(we->apw->sys.ss[we->breeder_no], 
				SS_PARA_POS_Y, CONTEST_ATTACK_POKE_Y + height);
			
			SoftSpriteParaSet(we->apw->sys.ss[transparent_no], SS_PARA_DRAW_STOP, TRUE);
			SoftSpriteParaSet(we->apw->sys.ss[transparent_no], 
				SS_PARA_POS_X, CONTEST_DEFENCE_POKE_X);
			SoftSpriteParaSet(we->apw->sys.ss[transparent_no], 
				SS_PARA_POS_Y, CONTEST_DEFENCE_POKE_Y);
		}
		
		we->seq++;
		break;
	case WESEQ_EFF_WAIT:	//ZGtFNgs
		WES_Executed(we->apw->sys.wsp);
		if(IsWES_Executed(we->apw->sys.wsp) == FALSE){
			WES_Reset(we->apw->sys.wsp);
			we->seq++;
		}
		break;
	
	case WESEQ_PANEL_IN:
		AT_BrdPanelAlphaEffectSet(we->apw, BRDPANEL_ALPHA_TYPE_RETURN, &we->panel_end);
		we->seq++;
		break;
	case WESEQ_PANEL_WAIT:
		if(we->panel_end == TRUE){
			we->seq++;
		}
		break;
	
	default:
		CO_ANSWER_TransmitBufferSet(&we->apw->cow, &we->req_head, NULL, 0);

		sys_FreeMemoryEz(we);
		TCB_Delete(tcb);
		return;
	}
}


//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   ߑM(M)FZI
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   work		Cӂ̃|C^
 *
 * @retval  o^ꂽNGXgrbgԍ
 */
//--------------------------------------------------------------
static int Request_WazaSelect(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work)
{
	ACTIN_PROC_WORK *apw = syswork;
	int bit_no;
	
	bit_no = CO_REQUEST_TransmitBufferSet(&apw->cow, CSELECT_ALL, order_no, NULL, 0);
	return bit_no;
}

//--------------------------------------------------------------
/**
 * @brief   ߎM(M)FZI
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   req_head	NGXgwb_̃|C^
 * @param   data		Mf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void Recieve_WazaSelect(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data)
{
	ACTIN_PROC_WORK *apw = syswork;
	AOLOCAL_WAZASELECT *ws;
	ACTIN_ADVANCE_PARAM *aap = data;
	
	ws = sys_AllocMemory(HEAPID_ACTIN, sizeof(AOLOCAL_WAZASELECT));
	MI_CpuClear8(ws, sizeof(AOLOCAL_WAZASELECT));
	
	ws->apw = apw;
	ws->req_head = *req_head;
	ws->breeder_no = apw->sys.c_game->my_breeder_no;	//aap->now_breeder;

	TCB_Add(AOTCB_WazaSelect, ws, TCBPRI_ACTIN_WAZASELECT);

//	CO_ANSWER_TransmitBufferSet(&apw->cow, req_head, &waza_no, sizeof(waza_no));
}

//--------------------------------------------------------------
/**
 * @brief   ZIs
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		AOLOCAL_WAZASELECT\
 */
//--------------------------------------------------------------
static void AOTCB_WazaSelect(TCB_PTR tcb, void *work)
{
	AOLOCAL_WAZASELECT *ws = work;
	int tp_ret;
	
	switch(ws->seq){
	case 0:
		AINPUT_CreateBG(ws->apw->aip, AINPUT_TYPE_WAZA, TRUE, NULL);
		{
			u32 a_talk_id;
			ATAG_PARAM tagpara;
			
			a_talk_id = A_TALK_SELECT_WAZA;
			AT_A_TalkMessageSet(ws->apw, a_talk_id, &tagpara);
		}
		ws->seq++;
		break;
	case 1:
		if(AT_TalkMessageEndCheck(ws->apw) == 0){
			ws->seq++;
		}
		break;
	case 2:
		tp_ret = AINPUT_TouchCheck(ws->apw->aip);
		if(tp_ret != RECT_HIT_NONE){
			ws->waza_no = PokeParaGet(ws->apw->sys.c_game->pp[ws->breeder_no], 
				ID_PARA_waza1 + tp_ret, NULL);
			Snd_SePlay(ASE_DECIDE);
			ws->seq++;
		}
		break;
	case 3:
		if(AINPUT_EffectEndCheck(ws->apw->aip) == TRUE){
			ws->seq++;
		}
		break;
	default:
		CO_ANSWER_TransmitBufferSet(&ws->apw->cow, &ws->req_head, &ws->waza_no, sizeof(u16));

		AINPUT_CreateBG(ws->apw->aip, AINPUT_TYPE_WALL, TRUE, NULL);
		
		sys_FreeMemoryEz(ws);
		TCB_Delete(tcb);
		return;
	}
}

//--------------------------------------------------------------
/**
 * @brief   ԎM(M)FZI
 *
 * @param   apw				Z͕Ǘ[Nւ̃|C^
 * @param   answer_head		Ԏwb_̃|C^
 * @param   data			Mf[^ւ̃|C^
 * @param   net_id			ԎM҂̃lbgID
 */
//--------------------------------------------------------------
static void Answer_WazaSelect(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *answer_head, CO_ANSDAT *ansdat, int net_id)
{
	ACTIN_PROC_WORK *apw = syswork;
	u16 *waza_data;
	
#if 0
	for(i = 0; i < apw->consys->c_game.player_num; i++){
		GF_ASSERT(ansdat[i].data != NULL);
		waza_data = ansdat->data[i];
		apw->a_game.waza_no[i] = *waza_data;
	}
#else
	waza_data = ansdat->data[net_id];
	apw->a_game.waza_no[net_id] = *waza_data;
#endif
}

//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   ߑM(M)FRI
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   work		Cӂ̃|C^
 *
 * @retval  o^ꂽNGXgrbgԍ
 */
//--------------------------------------------------------------
static int Request_JudgeSelect(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work)
{
	ACTIN_PROC_WORK *apw = syswork;
	int bit_no;
	
	bit_no = CO_REQUEST_TransmitBufferSet(&apw->cow, CSELECT_ALL, order_no, NULL, 0);
	return bit_no;
}

//--------------------------------------------------------------
/**
 * @brief   ߎM(M)FRI
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   req_head	NGXgwb_̃|C^
 * @param   data		Mf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void Recieve_JudgeSelect(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data)
{
	ACTIN_PROC_WORK *apw = syswork;
	AOLOCAL_JUDGESELECT *js;
	ACTIN_ADVANCE_PARAM *aap = data;
	
	js = sys_AllocMemory(HEAPID_ACTIN, sizeof(AOLOCAL_WAZASELECT));
	MI_CpuClear8(js, sizeof(AOLOCAL_WAZASELECT));
	
	js->apw = apw;
	js->req_head = *req_head;
	js->breeder_no = apw->sys.c_game->my_breeder_no;	//aap->now_breeder;

	TCB_Add(AOTCB_JudgeSelect, js, TCBPRI_ACTIN_WAZASELECT);
}

//--------------------------------------------------------------
/**
 * @brief   RIs
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		AOLOCAL_WAZASELECT\
 */
//--------------------------------------------------------------
static void AOTCB_JudgeSelect(TCB_PTR tcb, void *work)
{
	AOLOCAL_JUDGESELECT *js = work;
	int tp_ret;
	
	switch(js->seq){
	case 0:
		AINPUT_CreateBG(js->apw->aip, AINPUT_TYPE_JUDGE, TRUE, NULL);

		{
			u32 a_talk_id;
			ATAG_PARAM tagpara;
			
			a_talk_id = A_TALK_SELECT_JUDGE;
			tagpara.num = js->apw->a_game.turn + 1;
			AT_A_TalkMessageSet(js->apw, a_talk_id, &tagpara);
		}
		js->seq++;
		break;
	case 1:
		if(AT_TalkMessageEndCheck(js->apw) == 0){
			js->seq++;
		}
		break;
	case 2:
		tp_ret = AINPUT_TouchCheck(js->apw->aip);
		if(tp_ret != RECT_HIT_NONE){
			js->judge_no = tp_ret;
			Snd_SePlay(ASE_DECIDE);
			js->seq++;
		}
		break;
	case 3:
		if(AINPUT_EffectEndCheck(js->apw->aip) == TRUE){
			js->seq++;
		}
		break;
	default:
		CO_ANSWER_TransmitBufferSet(&js->apw->cow, &js->req_head, &js->judge_no, sizeof(u8));

		AINPUT_CreateBG(js->apw->aip, AINPUT_TYPE_WALL, TRUE, NULL);
		
		sys_FreeMemoryEz(js);
		TCB_Delete(tcb);
		return;
	}
}

//--------------------------------------------------------------
/**
 * @brief   ԎM(M)FRI
 *
 * @param   apw				Z͕Ǘ[Nւ̃|C^
 * @param   answer_head		Ԏwb_̃|C^
 * @param   data			Mf[^ւ̃|C^
 * @param   net_id			ԎM҂̃lbgID
 */
//--------------------------------------------------------------
static void Answer_JudgeSelect(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *answer_head, 
	CO_ANSDAT *ansdat, int net_id)
{
	ACTIN_PROC_WORK *apw = syswork;
	u8 *judge_data;
	
#if 0
	for(i = 0; i < apw->consys->c_game.player_num; i++){
		GF_ASSERT(ansdat[i].data != NULL);
		judge_data = ansdat->data[i];
		apw->a_game.judge_no[i] = *judge_data;
	}
#else
	judge_data = ansdat->data[net_id];
	apw->a_game.judge_no[net_id] = *judge_data;
#endif
}


//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   ߑM(M)FZ̕]s(o)
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   work		Cӂ̃|C^
 *
 * @retval  o^ꂽNGXgrbgԍ
 */
//--------------------------------------------------------------
static int Request_AppealReview(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work)
{
	ACTIN_PROC_WORK *apw = syswork;
	int bit_no;
	
	bit_no = CO_REQUEST_TransmitBufferSet(&apw->cow, CSELECT_ALL, order_no, 
		work, sizeof(ACTIN_ADVANCE_PARAM));
	return bit_no;
}

//--------------------------------------------------------------
/**
 * @brief   ߎM(M)FZ̕]s(o)
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   req_head	NGXgwb_̃|C^
 * @param   data		Mf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void Recieve_AppealReview(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data)
{
#if 0
	ACTIN_PROC_WORK *apw = syswork;
	AOLOCAL_APPEALREVIEW *ae;
	ACTIN_ADVANCE_PARAM *aap = data;
	
	ae = sys_AllocMemory(HEAPID_ACTIN, sizeof(AOLOCAL_APPEALREVIEW));
	MI_CpuClear8(ae, sizeof(AOLOCAL_APPEALREVIEW));
	
	ae->apw = apw;
	ae->req_head = *req_head;
	ae->breeder_no = aap->now_breeder;
	ae->breeder_pos = aap->now_pos;
	ae->judge_no = aap->judge_no;
	ae->aap = *aap;

	ae->voltage = ae->aap.waza_personal.voltage_before[aap->judge_no];
	
	TCB_Add(AOTCB_AppealReview, ae, TCBPRI_ACTIN_ORDERSUB);
#endif
}

//--------------------------------------------------------------
/**
 * @brief   ZGtFNgs
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		AOLOCAL_WAZAEFF\
 */
//--------------------------------------------------------------
static void AOTCB_AppealReview(TCB_PTR tcb, void *work)
{
#if 0
	AOLOCAL_APPEALREVIEW *ae = work;
	int voltage_ofs;
	enum{
		AR_INIT,
		AR_AP_INIT,
		AR_AP_MAIN,
		AR_AP_WAIT,
		AR_VOL_INIT,
		AR_VOL_MAIN,
		AR_VOL_WAIT,
		AR_VOL_AP_ADD_INIT,
		AR_VOL_AP_ADD_MAIN,
		AR_VOL_AP_ADD_WAIT,
		AR_END,
	};
	
	switch(ae->seq){
	case AR_INIT:
		OS_TPrintf("u[_[ԍ=%d\n", ae->breeder_no);
		OS_TPrintf("{AP=%d\nR̐=%d\n{e[W=%d\nŏIAPl=%d\n\n", 
			ae->aap.waza_personal.base_app, ae->aap.waza_personal.judge_suffer, 
			ae->aap.waza_personal.voltage_after[ae->aap.waza_personal.judge_no] 
			- ae->aap.waza_personal.voltage_before[ae->aap.waza_personal.judge_no], 
			ae->aap.waza_personal.app_total);
		
		ae->seq++;
		break;
	
	case AR_AP_INIT:
		ae->seq++;
		break;
	case AR_AP_MAIN:		//As[|Cg
		if(ae->point < ae->aap.waza_personal.app_total - ae->aap.waza_personal.voltage_add_ap){
			ae->point += APPEAL_ICON_ONE_POINT;
			AT_AppealPointActorMadeOver(&ae->apw->sys, ae->breeder_no, ae->breeder_pos, ae->point);
			Snd_SePlay( SEQ_SE_DP_BAG_004 );
		}
		ae->seq++;
		break;
	case AR_AP_WAIT:
		ae->wait++;
		if(ae->wait > APPEAL_ICON_LIGHT_WAIT){
			ae->wait = 0;
			if(ae->point >= ae->aap.waza_personal.app_total- ae->aap.waza_personal.voltage_add_ap){
				ae->seq++;
			}
			else{
				ae->seq--;
			}
		}
		break;
	
	case AR_VOL_INIT:
		ae->seq++;
		break;
	case AR_VOL_MAIN:		//{e[W
		if(ae->voltage != ae->aap.waza_personal.voltage_after[ae->judge_no]){
			voltage_ofs = ae->aap.waza_personal.voltage_after[ae->judge_no] 
				- ae->aap.waza_personal.voltage_before[ae->judge_no];
			if(voltage_ofs > 0){
				ae->voltage += VOLTAGE_ONE_POINT;
				AT_VoltagePointActorMadeOver(&ae->apw->sys, ae->judge_no, ae->voltage);
				Snd_SePlay( SEQ_SE_DP_BAG_011 );
			}
			else{
				ae->voltage -= VOLTAGE_ONE_POINT;
				AT_VoltagePointActorMadeOver(&ae->apw->sys, ae->judge_no, ae->voltage);
				Snd_SePlay( SEQ_SE_DP_BAG_006 );
			}
		}
		ae->seq++;
		break;
	case AR_VOL_WAIT:
		ae->wait++;
		if(ae->wait > VOLTAGE_ICON_LIGHT_WAIT){
			ae->wait = 0;
			if(ae->voltage == ae->aap.waza_personal.voltage_after[ae->judge_no]){
				ae->seq++;
			}
			else{
				ae->seq--;
			}
		}
		break;
	
	case AR_VOL_AP_ADD_INIT:
		if(ae->aap.waza_personal.voltage_after[ae->judge_no] < VOLTAGE_POINT_FULL){
			ae->seq = AR_END;
			break;
		}
		ae->seq++;
		break;
	case AR_VOL_AP_ADD_MAIN:
		if(ae->point < ae->aap.waza_personal.app_total){
			ae->point += APPEAL_ICON_ONE_POINT;
			AT_AppealPointActorMadeOver(&ae->apw->sys, ae->breeder_no, ae->breeder_pos, ae->point);
			Snd_SePlay( SEQ_SE_DP_BAG_004 );
		}
		ae->seq++;
		break;
	case AR_VOL_AP_ADD_WAIT:
		ae->wait++;
		if(ae->wait > APPEAL_ICON_LIGHT_WAIT){
			ae->wait = 0;
			if(ae->point >= ae->aap.waza_personal.app_total){
				//{e[W̕\B([N̕NextBreederŐeNAsĂ)
				AT_VoltagePointActorMadeOver(&ae->apw->sys, ae->judge_no, 0);
				ae->seq++;
			}
			else{
				ae->seq--;
			}
		}
		break;
		
	case AR_END:
	default:
		CO_ANSWER_TransmitBufferSet(&ae->apw->cow, &ae->req_head, NULL, 0);

		sys_FreeMemoryEz(ae);
		TCB_Delete(tcb);
		return;
	}
#endif
}

//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   ߑM(M)FZ̕]s(o)
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   work		Cӂ̃|C^
 *
 * @retval  o^ꂽNGXgrbgԍ
 */
//--------------------------------------------------------------
static int Request_AppealFirst(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work)
{
	ACTIN_PROC_WORK *apw = syswork;
	int bit_no;
	
	bit_no = CO_REQUEST_TransmitBufferSet(&apw->cow, CSELECT_ALL, order_no, 
		work, sizeof(ACTIN_ADVANCE_PARAM));
	return bit_no;
}

//--------------------------------------------------------------
/**
 * @brief   ߎM(M)FZ̕]s(o)
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   req_head	NGXgwb_̃|C^
 * @param   data		Mf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void Recieve_AppealFirst(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data)
{
	ACTIN_PROC_WORK *apw = syswork;
	AOLOCAL_APPEALREVIEW *ae;
	ACTIN_ADVANCE_PARAM *aap = data;
	
	ae = sys_AllocMemory(HEAPID_ACTIN, sizeof(AOLOCAL_APPEALREVIEW));
	MI_CpuClear8(ae, sizeof(AOLOCAL_APPEALREVIEW));
	
	ae->apw = apw;
	ae->req_head = *req_head;
	ae->breeder_no = aap->now_breeder;
	ae->breeder_pos = aap->now_pos;
	//ae->judge_no = aap->judge_no;
	ae->aap = *aap;

//	ae->voltage = ae->aap.waza_personal.voltage_before[aap->judge_no];
	
	TCB_Add(AOTCB_AppealFirst, ae, TCBPRI_ACTIN_ORDERSUB);
}

//--------------------------------------------------------------
/**
 * @brief   Z]s
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		AOLOCAL_WAZAEFF\
 */
//--------------------------------------------------------------
static void AOTCB_AppealFirst(TCB_PTR tcb, void *work)
{
	AOLOCAL_APPEALREVIEW *ae = work;
	AWAZA_PERSONAL *my_personal;
	enum{
		AR_INIT,
		AR_AP_INIT,
		AR_AP_MAIN,
		AR_AP_WAIT,
		AR_AP_END,
	};
	
	my_personal = &ae->aap.wazapara.personal[ae->breeder_no];
	switch(ae->seq){
	case AR_INIT:
	#if 0
		OS_TPrintf("u[_[ԍ=%d\n", ae->breeder_no);
		OS_TPrintf("{AP=%d\nR̐=%d\n{e[W=%d\nŏIAPl=%d\n\n", 
			ae->aap.waza_personal.base_app, ae->aap.waza_personal.judge_suffer, 
			ae->aap.waza_personal.voltage_after[ae->aap.waza_personal.judge_no] 
			- ae->aap.waza_personal.voltage_before[ae->aap.waza_personal.judge_no], 
			ae->aap.waza_personal.app_total);
	#endif
		OS_TPrintf("\nMf[^F{l(u[_[No%d, wazano=%d, apno=%d)\n",
			ae->breeder_no, my_personal->wazano, my_personal->apno);
		OS_TPrintf("app_total_before=%d\napp_total=%d\nmsg_apno=%d\n", 
			my_personal->app_total_before, my_personal->app_total, my_personal->msg_apno);
		
		ae->point = my_personal->app_total_before;
		ae->seq++;
		break;
	
	case AR_AP_INIT:
		ae->seq++;
		break;
	case AR_AP_MAIN:		//As[|Cg
		if(ae->point < my_personal->app_total){
			ae->point += APPEAL_ICON_ONE_POINT;
			AT_AppealPointActorMadeOver(&ae->apw->sys, ae->breeder_no, ae->breeder_pos, ae->point);
			Snd_SePlay(ASE_AP_UP);
		}
		else{
			ae->seq = AR_AP_END;
		}
		ae->seq++;
		break;
	case AR_AP_WAIT:
		ae->wait++;
		if(ae->wait > APPEAL_ICON_LIGHT_WAIT){
			ae->wait = 0;
			ae->seq--;
		}
		break;
	
	case AR_AP_END:
	default:
		CO_ANSWER_TransmitBufferSet(&ae->apw->cow, &ae->req_head, NULL, 0);

		sys_FreeMemoryEz(ae);
		TCB_Delete(tcb);
		return;
	}
}

//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   ߑM(M)FŽʂs(o)
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   work		Cӂ̃|C^
 *
 * @retval  o^ꂽNGXgrbgԍ
 */
//--------------------------------------------------------------
static int Request_AppealKouka(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work)
{
	ACTIN_PROC_WORK *apw = syswork;
	int bit_no;
	
	bit_no = CO_REQUEST_TransmitBufferSet(&apw->cow, CSELECT_ALL, order_no, 
		work, sizeof(ACTIN_ADVANCE_PARAM));
	return bit_no;
}

//--------------------------------------------------------------
/**
 * @brief   ߎM(M)FŽʂs(o)
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   req_head	NGXgwb_̃|C^
 * @param   data		Mf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void Recieve_AppealKouka(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data)
{
	ACTIN_PROC_WORK *apw = syswork;
	AOLOCAL_APPEALREVIEW *ae;
	ACTIN_ADVANCE_PARAM *aap = data;
	
	ae = sys_AllocMemory(HEAPID_ACTIN, sizeof(AOLOCAL_APPEALREVIEW));
	MI_CpuClear8(ae, sizeof(AOLOCAL_APPEALREVIEW));
	
	ae->apw = apw;
	ae->req_head = *req_head;
	ae->breeder_no = aap->now_breeder;
	ae->breeder_pos = aap->now_pos;
	//ae->judge_no = aap->judge_no;
	ae->aap = *aap;

	TCB_Add(AOTCB_AppealKouka, ae, TCBPRI_ACTIN_ORDERSUB);
}

//--------------------------------------------------------------
/**
 * @brief   Zʎs
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		AOLOCAL_WAZAEFF\
 */
//--------------------------------------------------------------
static void AOTCB_AppealKouka(TCB_PTR tcb, void *work)
{
	AOLOCAL_APPEALREVIEW *ae = work;
	AWAZA_PERSONAL *my_personal;
	enum{
		AR_INIT,
		AR_MSG_INIT,
		AR_MSG_WAIT,
		AR_MSG_END,
		AR_AP_INIT,
		AR_AP_MAIN,
		AR_AP_WAIT,
		AR_AP_END,
		AR_VOLALLDOWN_INIT,
		AR_VOLALLDOWN_MAIN,
		AR_VOLALLDOWN_WAIT,
		AR_VOLALLDOWN_END,
		AR_SORT_INIT,
		AR_SORT_MAIN,
		AR_SORT_WAIT,
		AR_SORT_END,
		AR_END,
	};
	
	my_personal = &ae->aap.wazapara.personal[ae->breeder_no];
	switch(ae->seq){
	case AR_INIT:
		OS_TPrintf("Mf[^Fʁ(u[_[No%d, wazano=%d, apno=%d)\n",
			ae->breeder_no, my_personal->wazano, my_personal->apno);
		OS_TPrintf("app_total_before=%d\napp_total=%d\nmsg_apno=%d\n", 
			my_personal->app_total_before, my_personal->app_total, my_personal->msg_apno);
		
		ae->point = my_personal->app_total_before;
		ae->seq++;
		break;
	
	case AR_MSG_INIT:
		if(my_personal->msg_apno != 0){
			AT_WazaKoukaTalkMessageSet(ae->apw, my_personal->msg_apno, my_personal->msg_type, 
				&my_personal->tagpara);
			ae->seq++;
		}
		else{
			ae->seq = AR_MSG_END;
		}
		break;
	case AR_MSG_WAIT:
		if(AT_TalkMessageEndCheck(ae->apw) == 0){
			ae->seq++;
		}
		break;
	case AR_MSG_END:
		ae->seq++;
		break;
	
	case AR_AP_INIT:
		ae->seq++;
		break;
	case AR_AP_MAIN:		//As[|Cg
		if(ae->point < my_personal->app_total){
			ae->point += APPEAL_ICON_ONE_POINT;
			AT_AppealPointActorMadeOver(&ae->apw->sys, ae->breeder_no, ae->breeder_pos, ae->point);
			Snd_SePlay(ASE_AP_UP);
		}
		else{
			ae->seq = AR_AP_END;
		}
		ae->seq++;
		break;
	case AR_AP_WAIT:
		ae->wait++;
		if(ae->wait > APPEAL_ICON_LIGHT_WAIT){
			ae->wait = 0;
			ae->seq--;
		}
		break;
	case AR_AP_END:
		ae->seq++;
		break;
	
	case AR_VOLALLDOWN_INIT:
		if(my_personal->voltage_all_down == 1){
			ae->voltage = ae->aap.wazapara.voltage_before[my_personal->judge_no];
			ae->work = 0;
			ae->seq++;
		}
		else{
			ae->seq = AR_VOLALLDOWN_END;
		}
		break;
	case AR_VOLALLDOWN_MAIN:		//{e[W|Cg
		{
			int down_num = 0, voltage, judge_no;
			
			ae->work++;
			for(judge_no = 0; judge_no < JUDGE_MAX; judge_no++){
				voltage = ae->aap.wazapara.voltage_before[judge_no] - ae->work * VOLTAGE_ONE_POINT;
				if(ae->aap.wazapara.voltage_after[judge_no] <= voltage){
					down_num++;
					AT_VoltagePointActorMadeOver(&ae->apw->sys, judge_no, voltage);
					Snd_SePlay(ASE_VOLTAGE_DOWN);
				}
			}
			if(down_num > 0){
				ae->seq++;
			}
			else{
				ae->seq = AR_VOLALLDOWN_END;
			}
		}
		break;
	case AR_VOLALLDOWN_WAIT:
		ae->wait++;
		if(ae->wait > VOLTAGE_ICON_LIGHT_WAIT){
			ae->wait = 0;
			ae->seq--;
		}
		break;
	case AR_VOLALLDOWN_END:
		ae->seq++;
		break;

	case AR_SORT_INIT:
		ae->seq++;
		break;
	case AR_SORT_MAIN:
		{
			int i, breeder_no;
			
			for(i = 0; i < BREEDER_MAX; i++){
				breeder_no = ae->apw->a_game.breeder_sort[i];
				if(ae->aap.wazapara.personal[breeder_no].next_sort 
						!= ae->aap.wazapara.personal[breeder_no].before_next_sort
						|| ae->aap.wazapara.personal[breeder_no].next_pos
						!= ae->aap.wazapara.personal[breeder_no].before_next_pos){
					AT_NextIconActorAnimeSet(&ae->apw->sys, i, 
						ae->aap.wazapara.personal[breeder_no].next_pos);
					Snd_SePlay(ASE_NEXTICON);
				}
			}
		}
		ae->seq++;
		break;
	case AR_SORT_WAIT:
		ae->seq++;
		break;
	case AR_SORT_END:
		ae->seq++;
		break;
	
	case AR_END:
	default:
		CO_ANSWER_TransmitBufferSet(&ae->apw->cow, &ae->req_head, NULL, 0);

		sys_FreeMemoryEz(ae);
		TCB_Delete(tcb);
		return;
	}
}

//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   ߑM(M)FŽʂs(o)
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   work		Cӂ̃|C^
 *
 * @retval  o^ꂽNGXgrbgԍ
 */
//--------------------------------------------------------------
static int Request_AppealSpecialKouka(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work)
{
	ACTIN_PROC_WORK *apw = syswork;
	int bit_no;
	
	bit_no = CO_REQUEST_TransmitBufferSet(&apw->cow, CSELECT_ALL, order_no, 
		work, sizeof(ACTIN_ADVANCE_PARAM));
	return bit_no;
}

//--------------------------------------------------------------
/**
 * @brief   ߎM(M)FŽʂs(o)
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   req_head	NGXgwb_̃|C^
 * @param   data		Mf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void Recieve_AppealSpecialKouka(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data)
{
	ACTIN_PROC_WORK *apw = syswork;
	AOLOCAL_APPEALREVIEW *ae;
	ACTIN_ADVANCE_PARAM *aap = data;
	
	ae = sys_AllocMemory(HEAPID_ACTIN, sizeof(AOLOCAL_APPEALREVIEW));
	MI_CpuClear8(ae, sizeof(AOLOCAL_APPEALREVIEW));
	
	ae->apw = apw;
	ae->req_head = *req_head;
	ae->breeder_no = aap->now_breeder;
	ae->breeder_pos = aap->now_pos;
	//ae->judge_no = aap->judge_no;
	ae->aap = *aap;

	TCB_Add(AOTCB_AppealSpecialKouka, ae, TCBPRI_ACTIN_ORDERSUB);
}

//--------------------------------------------------------------
/**
 * @brief   Zʎs
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		AOLOCAL_WAZAEFF\
 */
//--------------------------------------------------------------
static void AOTCB_AppealSpecialKouka(TCB_PTR tcb, void *work)
{
	AOLOCAL_APPEALREVIEW *ae = work;
	AWAZA_PERSONAL *my_personal;
	enum{
		AR_INIT,
		AR_MSG_INIT,
		AR_MSG_WAIT,
		AR_MSG_END,
		AR_AP_INIT,
		AR_AP_MAIN,
		AR_AP_WAIT,
		AR_AP_END,
		AR_END,
	};
	
	my_personal = &ae->aap.wazapara.personal[ae->breeder_no];
	switch(ae->seq){
	case AR_INIT:
		OS_TPrintf("Mf[^Fʁ(u[_[No%d, wazano=%d, apno=%d)\n",
			ae->breeder_no, my_personal->wazano, my_personal->apno);
		OS_TPrintf("app_total_before=%d\napp_total=%d\nmsg_apno=%d\n", 
			my_personal->app_total_before, my_personal->app_total, my_personal->msg_apno);
		
		ae->point = my_personal->app_total_before;
		ae->seq++;
		break;
	
	case AR_MSG_INIT:
		if(my_personal->msg_apno != 0){
			AT_WazaKoukaTalkMessageSet(ae->apw, my_personal->msg_apno, my_personal->msg_type, 
				&my_personal->tagpara);
			ae->seq++;
		}
		else{
			ae->seq = AR_MSG_END;
		}
		break;
	case AR_MSG_WAIT:
		if(AT_TalkMessageEndCheck(ae->apw) == 0){
			ae->seq++;
		}
		break;
	case AR_MSG_END:
		ae->seq++;
		break;
	
	case AR_AP_INIT:
		ae->seq++;
		break;
	case AR_AP_MAIN:		//As[|Cg
		if(ae->point < my_personal->app_total){
			ae->point += APPEAL_ICON_ONE_POINT;
			AT_AppealPointActorMadeOver(&ae->apw->sys, ae->breeder_no, ae->breeder_pos, ae->point);
			Snd_SePlay(ASE_AP_UP);
		}
		else{
			ae->seq = AR_AP_END;
		}
		ae->seq++;
		break;
	case AR_AP_WAIT:
		ae->wait++;
		if(ae->wait > APPEAL_ICON_LIGHT_WAIT){
			ae->wait = 0;
			ae->seq--;
		}
		break;
	case AR_AP_END:
		ae->seq++;
		break;
	
	case AR_END:
	default:
		CO_ANSWER_TransmitBufferSet(&ae->apw->cow, &ae->req_head, NULL, 0);

		sys_FreeMemoryEz(ae);
		TCB_Delete(tcb);
		return;
	}
}

//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   ߑM(M)F{e[Ws(o)
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   work		Cӂ̃|C^
 *
 * @retval  o^ꂽNGXgrbgԍ
 */
//--------------------------------------------------------------
static int Request_AppealVoltage(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work)
{
	ACTIN_PROC_WORK *apw = syswork;
	int bit_no;
	
	bit_no = CO_REQUEST_TransmitBufferSet(&apw->cow, CSELECT_ALL, order_no, 
		work, sizeof(ACTIN_ADVANCE_PARAM));
	return bit_no;
}

//--------------------------------------------------------------
/**
 * @brief   ߎM(M)F{e[Ws(o)
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   req_head	NGXgwb_̃|C^
 * @param   data		Mf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void Recieve_AppealVoltage(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data)
{
	ACTIN_PROC_WORK *apw = syswork;
	AOLOCAL_APPEALREVIEW *ae;
	ACTIN_ADVANCE_PARAM *aap = data;
	
	ae = sys_AllocMemory(HEAPID_ACTIN, sizeof(AOLOCAL_APPEALREVIEW));
	MI_CpuClear8(ae, sizeof(AOLOCAL_APPEALREVIEW));
	
	ae->apw = apw;
	ae->req_head = *req_head;
	ae->breeder_no = aap->now_breeder;
	ae->breeder_pos = aap->now_pos;
	//ae->judge_no = aap->judge_no;
	ae->aap = *aap;

	TCB_Add(AOTCB_AppealVoltage, ae, TCBPRI_ACTIN_ORDERSUB);
}

//--------------------------------------------------------------
/**
 * @brief   {e[Ws
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		AOLOCAL_WAZAEFF\
 */
//--------------------------------------------------------------
static void AOTCB_AppealVoltage(TCB_PTR tcb, void *work)
{
	AOLOCAL_APPEALREVIEW *ae = work;
	AWAZA_PERSONAL *my_personal;
	enum{
		AR_INIT,
		AR_JUDGE_REACTION_INIT,
		AR_JUDGE_REACTION_WAIT,
		AR_JUDGE_REACTION_END,
		AR_MSG_INIT,
		AR_MSG_WAIT,
		AR_MSG_END,
		AR_AUDIENCE_INIT,
		AR_AUDIENCE_WAIT,
		AR_AUDIENCE_END,
		AR_VOL_INIT,
		AR_VOL_MAIN,
		AR_VOL_MOVEEFF_WAIT,
		AR_VOL_WAIT,
		AR_VOL_END,
		AR_AFTER_MSG_INIT,
		AR_AFTER_MSG_WAIT,
		AR_AFTER_MSG_END,
		AR_AP_INIT,
		AR_AP_MAIN,
		AR_AP_WAIT,
		AR_AP_END,
		AR_END,
	};
	
	my_personal = &ae->aap.wazapara.personal[ae->breeder_no];
	switch(ae->seq){
	case AR_INIT:
		OS_TPrintf("Mf[^F{e[W(u[_[No%d, wazano=%d, apno=%d)\n",
			ae->breeder_no, my_personal->wazano, my_personal->apno);
		OS_TPrintf("votage_before=%d\nvoltage_after=%d\na_talk_id=%d\nafter_a_talk_id=%d\n", 
			ae->aap.wazapara.voltage_before[my_personal->judge_no], 
			ae->aap.wazapara.voltage_after[my_personal->judge_no], 
			ae->aap.nt.a_talk_id, ae->aap.nt.after_a_talk_id);
		
		ae->voltage = ae->aap.wazapara.voltage_before[my_personal->judge_no];
		ae->seq++;
		break;
	
	case AR_JUDGE_REACTION_INIT:
		if(ae->aap.wazapara.voltage_after[my_personal->judge_no] >
				ae->aap.wazapara.voltage_before[my_personal->judge_no]){
			int reaction_type;
			
			if(ae->aap.wazapara.voltage_after[my_personal->judge_no] >= VOLTAGE_POINT_FULL){
				reaction_type = JUDGE_REACTION_ICON_VOLTAGE_MAX;
			}
			else{
				reaction_type = JUDGE_REACTION_ICON_VOLTAGE;
			}
			AT_JudgeReactionIconON(&ae->apw->sys, my_personal->judge_no, reaction_type);
			AT_JudgeReactionMoveTaskSet(ae->apw, my_personal->judge_no, reaction_type, 
				&ae->reaction_end);
			ae->seq++;
		}
		else{
			ae->seq = AR_JUDGE_REACTION_END;
		}
		break;
	case AR_JUDGE_REACTION_WAIT:
		if(ae->reaction_end == TRUE){
			ae->seq++;
		}
		break;
	case AR_JUDGE_REACTION_END:
		ae->seq++;
		break;
		
	case AR_MSG_INIT:
		if(ae->aap.nt.a_talk_id != A_TALK_NULL){
			AT_A_TalkMessageSet(ae->apw, ae->aap.nt.a_talk_id, &ae->aap.nt.a_talk_tagpara);
			ae->seq++;
		}
		else{
			ae->seq = AR_MSG_END;
		}
		break;
	case AR_MSG_WAIT:
		if(AT_TalkMessageEndCheck(ae->apw) == 0){
			ae->seq++;
		}
		break;
	case AR_MSG_END:
		ae->seq++;
		break;
	
	case AR_AUDIENCE_INIT:	//ϋqAjZbg
		if(ae->aap.wazapara.voltage_after[my_personal->judge_no] >
				ae->aap.wazapara.voltage_before[my_personal->judge_no]){
			AT_AudienceAnimeSet(ae->apw, ae->aap.wazapara.voltage_after[my_personal->judge_no], 
				AUDIENCE_ANM_START_WAIT, &ae->audience_anm_end);
		}
		else{
			ae->audience_anm_end = TRUE;
		}
		ae->seq++;
		break;
	case AR_AUDIENCE_WAIT:
		ae->wait++;
		if(ae->wait > AUDIENCE_ANM_NEXT_WAIT){
			ae->wait = 0;
			ae->seq++;
		}
		break;
	case AR_AUDIENCE_END:
		ae->seq++;
		break;

	case AR_VOL_INIT:
		ae->seq++;
		break;
	case AR_VOL_MAIN:		//{e[W|Cg
		if(ae->voltage != ae->aap.wazapara.voltage_after[my_personal->judge_no]){
			if(ae->aap.wazapara.voltage_after[my_personal->judge_no] 
					- ae->aap.wazapara.voltage_before[my_personal->judge_no] > 0){
				ae->voltage += VOLTAGE_ONE_POINT;
				AT_VoltagePointActorMadeOver(&ae->apw->sys, my_personal->judge_no, ae->voltage);
//				Snd_SePlay(ASE_VOLTAGE_UP);
			}
			else{
				ae->voltage -= VOLTAGE_ONE_POINT;
				AT_VoltagePointActorMadeOver(&ae->apw->sys, my_personal->judge_no, ae->voltage);
				Snd_SePlay(ASE_VOLTAGE_DOWN);
			}
			ae->seq++;
		}
		else{
			ae->seq = AR_VOL_END;
		}
		break;
	case AR_VOL_MOVEEFF_WAIT:
		if(AT_VoltageMoveEffectEndCheck(&ae->apw->sys, my_personal->judge_no) == TRUE){
			ae->seq++;
		}
		break;
	case AR_VOL_WAIT:
		ae->wait++;
		if(ae->wait > VOLTAGE_ICON_LIGHT_WAIT){
			ae->wait = 0;
			ae->seq = AR_VOL_MAIN;
		}
		break;
	case AR_VOL_END:
		ae->seq++;
		break;

	case AR_AFTER_MSG_INIT:
		if(ae->aap.nt.after_a_talk_id != A_TALK_NULL){
			AT_A_TalkMessageSet(ae->apw, ae->aap.nt.after_a_talk_id, 
				&ae->aap.nt.after_a_talk_tagpara);
			ae->seq++;
		}
		else{
			ae->seq = AR_AFTER_MSG_END;
		}
		break;
	case AR_AFTER_MSG_WAIT:
		if(AT_TalkMessageEndCheck(ae->apw) == 0){
			ae->seq++;
		}
		break;
	case AR_AFTER_MSG_END:
		ae->seq++;
		break;

	case AR_AP_INIT:
		ae->point = my_personal->app_total_before;
		ae->seq++;
		break;
	case AR_AP_MAIN:		//As[|Cg
		if(ae->point < my_personal->app_total){
			ae->point += APPEAL_ICON_ONE_POINT;
			AT_AppealPointActorMadeOver(&ae->apw->sys, ae->breeder_no, ae->breeder_pos, ae->point);
			Snd_SePlay(ASE_AP_UP);
			ae->seq++;
		}
		else{
			AT_JudgeReactionIconOFF(&ae->apw->sys);
			ae->seq = AR_AP_END;
		}
		break;
	case AR_AP_WAIT:
		ae->wait++;
		if(ae->wait > APPEAL_ICON_LIGHT_WAIT){
			ae->wait = 0;
			ae->seq--;
		}
		break;
	case AR_AP_END:
		if(ae->voltage >= VOLTAGE_POINT_FULL){	//{e[WMAXȂ\NA
			AT_VoltagePointActorMadeOver(&ae->apw->sys, my_personal->judge_no, 0);
		}
		ae->seq++;
		break;

	case AR_END:
	default:
		if(ae->audience_anm_end == TRUE){
			CO_ANSWER_TransmitBufferSet(&ae->apw->cow, &ae->req_head, NULL, 0);

			sys_FreeMemoryEz(ae);
			TCB_Delete(tcb);
			return;
		}
		break;
	}
}

//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   ߑM(M)FSAs[̋Zʂs(o)
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   work		Cӂ̃|C^
 *
 * @retval  o^ꂽNGXgrbgԍ
 */
//--------------------------------------------------------------
static int Request_ReviewAfterKouka(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work)
{
	ACTIN_PROC_WORK *apw = syswork;
	int bit_no;
	
	bit_no = CO_REQUEST_TransmitBufferSet(&apw->cow, CSELECT_ALL, order_no, 
		work, sizeof(ACTIN_ADVANCE_PARAM));
	return bit_no;
}

//--------------------------------------------------------------
/**
 * @brief   ߎM(M)FSAs[̋Zʂs(o)
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   req_head	NGXgwb_̃|C^
 * @param   data		Mf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void Recieve_ReviewAfterKouka(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data)
{
	ACTIN_PROC_WORK *apw = syswork;
	AOLOCAL_APPEALREVIEW *ae;
	ACTIN_ADVANCE_PARAM *aap = data;
	
	ae = sys_AllocMemory(HEAPID_ACTIN, sizeof(AOLOCAL_APPEALREVIEW));
	MI_CpuClear8(ae, sizeof(AOLOCAL_APPEALREVIEW));
	
	ae->apw = apw;
	ae->req_head = *req_head;
	ae->breeder_no = aap->now_breeder;
	ae->breeder_pos = aap->now_pos;
	//ae->judge_no = aap->judge_no;
	ae->aap = *aap;

	TCB_Add(AOTCB_ReviewAfterKouka, ae, TCBPRI_ACTIN_ORDERSUB);
}

//--------------------------------------------------------------
/**
 * @brief   SAs[̋Zʎs
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		AOLOCAL_WAZAEFF\
 */
//--------------------------------------------------------------
static void AOTCB_ReviewAfterKouka(TCB_PTR tcb, void *work)
{
	AOLOCAL_APPEALREVIEW *ae = work;
	AWAZA_PERSONAL *my_personal;
	enum{
		AR_INIT,
		AR_MSG_INIT,
		AR_MSG_WAIT,
		AR_MSG_END,
		AR_AP_INIT,
		AR_AP_MAIN,
		AR_AP_WAIT,
		AR_AP_END,
		AR_END,
	};
	
	my_personal = &ae->aap.wazapara.personal[ae->breeder_no];
	switch(ae->seq){
	case AR_INIT:
		OS_TPrintf("Mf[^FSAs[̋Zʁ(u[_[No%d, wazano=%d, apno=%d)\n",
			ae->breeder_no, my_personal->wazano, my_personal->apno);
		OS_TPrintf("app_total_before=%d\napp_total=%d\nmsg_apno=%d\n", 
			my_personal->app_total_before, my_personal->app_total, my_personal->msg_apno);
		
		ae->point = my_personal->app_total_before;
		ae->seq++;
		break;
	
	case AR_MSG_INIT:
		if(my_personal->msg_apno != 0){
			AT_WazaKoukaTalkMessageSet(ae->apw, my_personal->msg_apno, my_personal->msg_type, 
				&my_personal->tagpara);
			ae->seq++;
		}
		else{
			ae->seq = AR_MSG_END;
		}
		break;
	case AR_MSG_WAIT:
		if(AT_TalkMessageEndCheck(ae->apw) == 0){
			ae->seq++;
		}
		break;
	case AR_MSG_END:
		ae->seq++;
		break;
	
	case AR_AP_INIT:
		ae->seq++;
		break;
	case AR_AP_MAIN:		//As[|Cg
		if(ae->point < my_personal->app_total){
			ae->point += APPEAL_ICON_ONE_POINT;
			AT_AppealPointActorMadeOver(&ae->apw->sys, ae->breeder_no, ae->breeder_pos, ae->point);
			Snd_SePlay(ASE_AP_UP);
		}
		else{
			ae->seq = AR_AP_END;
		}
		ae->seq++;
		break;
	case AR_AP_WAIT:
		ae->wait++;
		if(ae->wait > APPEAL_ICON_LIGHT_WAIT){
			ae->wait = 0;
			ae->seq--;
		}
		break;
	case AR_AP_END:
		ae->seq++;
		break;
	
	case AR_END:
	default:
		CO_ANSWER_TransmitBufferSet(&ae->apw->cow, &ae->req_head, NULL, 0);

		sys_FreeMemoryEz(ae);
		TCB_Delete(tcb);
		return;
	}
}

//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   ߑM(M)FRs(o)
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   work		Cӂ̃|C^
 *
 * @retval  o^ꂽNGXgrbgԍ
 */
//--------------------------------------------------------------
static int Request_JudgeSuffer(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work)
{
	ACTIN_PROC_WORK *apw = syswork;
	int bit_no;
	
	bit_no = CO_REQUEST_TransmitBufferSet(&apw->cow, CSELECT_ALL, order_no, 
		work, sizeof(ACTIN_ADVANCE_PARAM));
	return bit_no;
}

//--------------------------------------------------------------
/**
 * @brief   ߎM(M)FRs(o)
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   req_head	NGXgwb_̃|C^
 * @param   data		Mf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void Recieve_JudgeSuffer(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data)
{
	ACTIN_PROC_WORK *apw = syswork;
	AOLOCAL_APPEALREVIEW *ae;
	ACTIN_ADVANCE_PARAM *aap = data;
	
	ae = sys_AllocMemory(HEAPID_ACTIN, sizeof(AOLOCAL_APPEALREVIEW));
	MI_CpuClear8(ae, sizeof(AOLOCAL_APPEALREVIEW));
	
	ae->apw = apw;
	ae->req_head = *req_head;
	ae->breeder_no = aap->now_breeder;
	ae->breeder_pos = aap->now_pos;
	//ae->judge_no = aap->judge_no;
	ae->aap = *aap;

	TCB_Add(AOTCB_JudgeSuffer, ae, TCBPRI_ACTIN_ORDERSUB);
}

//--------------------------------------------------------------
/**
 * @brief   Rs
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		AOLOCAL_WAZAEFF\
 */
//--------------------------------------------------------------
static void AOTCB_JudgeSuffer(TCB_PTR tcb, void *work)
{
	AOLOCAL_APPEALREVIEW *ae = work;
	AWAZA_PERSONAL *my_personal;
	enum{
		AR_INIT,
		AR_MSG_INIT,
		AR_MSG_WAIT,
		AR_MSG_END,
		AR_A_TALK_INIT,
		AR_A_TALK_WAIT,
		AR_A_TALK_END,
		AR_AFTER_A_TALK_INIT,
		AR_AFTER_A_TALK_WAIT,
		AR_AFTER_A_TALK_END,
		AR_AP_INIT,
		AR_AP_MAIN,
		AR_AP_WAIT,
		AR_AP_END,
		AR_END,
	};
	
	my_personal = &ae->aap.wazapara.personal[ae->breeder_no];
	switch(ae->seq){
	case AR_INIT:
		OS_TPrintf("Mf[^FR聁(u[_[No%d, wazano=%d, apno=%d)\n",
			ae->breeder_no, my_personal->wazano, my_personal->apno);
		OS_TPrintf("app_total_before=%d\napp_total=%d\nmsg_apno=%d\na_talk_id=%d\n", 
			my_personal->app_total_before, my_personal->app_total, my_personal->msg_apno,
			ae->aap.nt.a_talk_id);
		
		ae->point = my_personal->app_total_before;
		ae->seq++;
		break;
	
	case AR_MSG_INIT:
		if(my_personal->msg_apno != 0){
			AT_WazaKoukaTalkMessageSet(ae->apw, my_personal->msg_apno, my_personal->msg_type, 
				&my_personal->tagpara);
			ae->seq++;
		}
		else{
			ae->seq = AR_MSG_END;
		}
		break;
	case AR_MSG_WAIT:
		if(AT_TalkMessageEndCheck(ae->apw) == 0){
			ae->seq++;
		}
		break;
	case AR_MSG_END:
		ae->seq++;
		break;
	
	case AR_A_TALK_INIT:
		if(ae->aap.nt.a_talk_id != A_TALK_NULL){
			AT_A_TalkMessageSet(ae->apw, ae->aap.nt.a_talk_id, &ae->aap.nt.a_talk_tagpara);
			ae->seq++;
		}
		else{
			ae->seq = AR_A_TALK_END;
		}
		break;
	case AR_A_TALK_WAIT:
		if(AT_TalkMessageEndCheck(ae->apw) == 0){
			ae->seq++;
		}
		break;
	case AR_A_TALK_END:
		ae->seq++;
		break;

	case AR_AFTER_A_TALK_INIT:
		if(ae->aap.nt.after_a_talk_id != A_TALK_NULL){
			AT_A_TalkMessageSet(ae->apw, ae->aap.nt.after_a_talk_id, 
				&ae->aap.nt.after_a_talk_tagpara);
			ae->seq++;
		}
		else{
			ae->seq = AR_AFTER_A_TALK_END;
		}
		break;
	case AR_AFTER_A_TALK_WAIT:
		if(AT_TalkMessageEndCheck(ae->apw) == 0){
			ae->seq++;
		}
		break;
	case AR_AFTER_A_TALK_END:
		ae->seq++;
		break;
	
	case AR_AP_INIT:
		ae->seq++;
		break;
	case AR_AP_MAIN:		//As[|Cg
		if(ae->point < my_personal->app_total){
			ae->point += APPEAL_ICON_ONE_POINT;
			AT_AppealPointActorMadeOver(&ae->apw->sys, ae->breeder_no, ae->breeder_pos, ae->point);
			Snd_SePlay(ASE_AP_UP);
		}
		else{
			ae->seq = AR_AP_END;
		}
		ae->seq++;
		break;
	case AR_AP_WAIT:
		ae->wait++;
		if(ae->wait > APPEAL_ICON_LIGHT_WAIT){
			ae->wait = 0;
			ae->seq--;
		}
		break;
	case AR_AP_END:
		ae->seq++;
		break;
	
	case AR_END:
	default:
		CO_ANSWER_TransmitBufferSet(&ae->apw->cow, &ae->req_head, NULL, 0);

		sys_FreeMemoryEz(ae);
		TCB_Delete(tcb);
		return;
	}
}

//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   ߑM(M)FRRgs(o)
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   work		Cӂ̃|C^
 *
 * @retval  o^ꂽNGXgrbgԍ
 */
//--------------------------------------------------------------
static int Request_JudgeComment(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work)
{
	ACTIN_PROC_WORK *apw = syswork;
	int bit_no;
	
	bit_no = CO_REQUEST_TransmitBufferSet(&apw->cow, CSELECT_ALL, order_no, 
		work, sizeof(ACTIN_ADVANCE_PARAM));
	return bit_no;
}

//--------------------------------------------------------------
/**
 * @brief   ߎM(M)FRRgs(o)
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   req_head	NGXgwb_̃|C^
 * @param   data		Mf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void Recieve_JudgeComment(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data)
{
	ACTIN_PROC_WORK *apw = syswork;
	AOLOCAL_APPEALREVIEW *ae;
	ACTIN_ADVANCE_PARAM *aap = data;
	
	ae = sys_AllocMemory(HEAPID_ACTIN, sizeof(AOLOCAL_APPEALREVIEW));
	MI_CpuClear8(ae, sizeof(AOLOCAL_APPEALREVIEW));
	
	ae->apw = apw;
	ae->req_head = *req_head;
	ae->breeder_no = apw->sys.c_game->my_breeder_no;//aap->now_breeder;
	ae->breeder_pos = aap->now_pos;
	//ae->judge_no = aap->judge_no;
	ae->aap = *aap;

	TCB_Add(AOTCB_JudgeComment, ae, TCBPRI_ACTIN_ORDERSUB);
}

//--------------------------------------------------------------
/**
 * @brief   RRgs
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		AOLOCAL_WAZAEFF\
 */
//--------------------------------------------------------------
static void AOTCB_JudgeComment(TCB_PTR tcb, void *work)
{
	AOLOCAL_APPEALREVIEW *ae = work;
	AWAZA_PERSONAL *my_personal;
	
	my_personal = &ae->aap.wazapara.personal[ae->breeder_no];
	switch(ae->seq){
	case 0:
		{
			u32 a_talk_id;
			ATAG_PARAM tagpara;
			
			a_talk_id = AT_MsgTagJudgeCommentCreate(ae->breeder_no, 
				my_personal[ae->breeder_no].app_total, &tagpara);
			AT_A_TalkMessageSet(ae->apw, a_talk_id, &tagpara);
			ae->seq++;
		}
		break;
	case 1:
		if(AT_TalkMessageEndCheck(ae->apw) == 0){
			ae->seq++;
		}
		break;
	case 2:
		ae->seq++;
		break;

	default:
		CO_ANSWER_TransmitBufferSet(&ae->apw->cow, &ae->req_head, NULL, 0);

		sys_FreeMemoryEz(ae);
		TCB_Delete(tcb);
		return;
	}
}

//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   ߑM(M)F^[Ĩp[^XV
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   work		Cӂ̃|C^
 *
 * @retval  o^ꂽNGXgrbgԍ
 */
//--------------------------------------------------------------
static int Request_TurnParamUpdate(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work)
{
	ACTIN_PROC_WORK *apw = syswork;
	int bit_no;
	
	bit_no = CO_REQUEST_TransmitBufferSet(&apw->cow, CSELECT_ALL, order_no, 
		work, sizeof(ACTIN_GAME_PARAM));
	OS_TPrintf("^[Ĩp[^f[^SMBTCY%dbyte\n", sizeof(ACTIN_GAME_PARAM));
	return bit_no;
}

//--------------------------------------------------------------
/**
 * @brief   ߎM(M)F^[Ĩp[^XV
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   req_head	NGXgwb_̃|C^
 * @param   data		Mf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void Recieve_TurnParamUpdate(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data)
{
	ACTIN_PROC_WORK *apw = syswork;
	ACTIN_GAME_PARAM *a_game;
	
	a_game = data;
	apw->a_game = *a_game;

	
	//-- Mf[^ɏ]ď --//
	//As[|CgACR폜
	AT_AppealPointActorDelAll(&apw->sys);
	//ACR폜
	AT_NextIconActorDelAll(&apw->sys);
	//pl
	//BreederParamBmpWriteAll(apw);
	AT_BreederPanelFontOamPosUpdate(apw);
	BreederPanelColorChangeAll(apw);
	
	//ԎԂ	obt@͓ɓn̂Ȃ̂NULLw
	CO_ANSWER_TransmitBufferSet(&apw->cow, req_head, NULL, 0);
}


//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   ߑM(M)FbbZ[W̕\
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   work		Cӂ̃|C^
 *
 * @retval  o^ꂽNGXgrbgԍ
 */
//--------------------------------------------------------------
static int Request_Talk(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work)
{
	ACTIN_PROC_WORK *apw = syswork;
	int bit_no;
	
	bit_no = CO_REQUEST_TransmitBufferSet(cow, CSELECT_ALL, order_no, 
		work, sizeof(ACTIN_ADVANCE_PARAM));
	return bit_no;
}

//--------------------------------------------------------------
/**
 * @brief   ߎM(M)FbbZ[W̕\
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   req_head	NGXgwb_̃|C^
 * @param   data		Mf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void Recieve_Talk(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data)
{
	ACTIN_PROC_WORK *apw = syswork;
	ACTIN_ADVANCE_PARAM *aap = data;
	AOLOCAL_TALK_PUT *talk;
	
	talk = sys_AllocMemory(HEAPID_ACTIN, sizeof(AOLOCAL_TALK_PUT));
	MI_CpuClear8(talk, sizeof(AOLOCAL_TALK_PUT));
	
	talk->apw = apw;
	talk->req_head = *req_head;
	talk->cow = cow;
	talk->breeder_no = aap->now_breeder;
	
	talk->a_talk_tagpara = aap->nt.a_talk_tagpara;
	talk->a_talk_id = aap->nt.a_talk_id;
	talk->a_talk_bmpwin_not_close = aap->nt.a_talk_bmpwin_not_close;
	talk->a_talk_bmpwin_close_wait = aap->nt.a_talk_bmpwin_close_wait;
	
	TCB_Add(AOTCB_TalkPut, talk, TCBPRI_ACTIN_ORDERSUB);
}

//--------------------------------------------------------------
/**
 * @brief   bbZ[W̕\
 * @param   tcb			TCBւ̃|C^
 * @param   work		AOLOCAL_TALK_PUT\
 */
//--------------------------------------------------------------
static void AOTCB_TalkPut(TCB_PTR tcb, void *work)
{
	AOLOCAL_TALK_PUT *talk = work;
	
	switch(talk->seq){
	case 0:
		if(talk->a_talk_id != A_TALK_NULL){
//			BmpTalkWinWrite(&talk->vpw->sys.win[ACTIN_BMPWIN_TALK], WINDOW_TRANS_OFF,
//				ACTIN_TALKWIN_CGX_OFFSET, ACTIN_TALKWIN_PALNO);
//			GF_BGL_LoadScreenV_Req(talk->apw->sys.bgl, ACTIN_FRAME_WIN);
			
			AT_A_TalkMessageSet(talk->apw, talk->a_talk_id, &talk->a_talk_tagpara);
			talk->seq++;
		}
		else{
			talk->seq = 100;
		}
		break;
	case 1:
		if(AT_TalkMessageEndCheck(talk->apw) == 0){
			talk->seq++;
		}
		break;
	case 2:
		talk->close_wait++;
		if(talk->a_talk_bmpwin_not_close == TRUE){
			talk->seq++;
		}
		else if(talk->close_wait >= talk->a_talk_bmpwin_close_wait){
//			BmpTalkWinClear(&talk->apw->sys.win[ACTIN_BMPWIN_TALK], WINDOW_TRANS_OFF);
//			GF_BGL_LoadScreenV_Req(talk->apw->sys.bgl, ACTIN_FRAME_WIN);
			talk->seq++;
		}
		break;
	default:
		CO_ANSWER_TransmitBufferSet(talk->cow, &talk->req_head, NULL, 0);

		sys_FreeMemoryEz(talk);
		TCB_Delete(tcb);
		return;
	}
}

