//==============================================================================
/**
 * @file	actin_tool.c
 * @brief	Z͕Ŏgpc[
 * @author	matsuda
 * @date	2005.11.24()
 */
//==============================================================================
#include "common.h"
#include "contest/contest.h"
#include "actin.h"
#include "actin_tcb_pri.h"
#include "battle/battle_common.h"
#include "system/clact_tool.h"
#include "system/palanm.h"

#include "system/arc_tool.h"
#include "system/arc_util.h"

#include "system/softsprite.h"

#include "system/fontproc.h"
#include "system/msgdata.h"

#include "wazaeffect/battle_particle.h"
#include "system/particle.h"
#include "wazaeffect/we_mana.h"
#include "wazaeffect/we_sys.h"

#include "system/brightness.h"

#include "graphic/contest_bg_def.h"
#include "graphic/contest_obj_def.h"

#include "actin_tool.h"
#include "con_tool.h"
#include "actin_id.h"

#include "msgdata/msg.naix"
#include "msgdata/msg_cmsg_acting.h"

#include "system/snd_tool.h"



//==============================================================================
//	萔`
//==============================================================================
//--------------------------------------------------------------
//	BMPEBhE
//--------------------------------------------------------------
///plBMPGA𖄂ߐsꍇɎgpJ[ԍ
#define BMPWIN_PANEL_FILL_COLOR			(2)

///bEBhEJo[̃XN[ʒu(XN[O)
#define WINSLIDE_SCRN_POS_BEFORE		(32 * 0x12 + 0x15)
///bEBhEJo[̃XN[ʒu(XN[)
#define WINSLIDE_SCRN_POS_AFTER			(32 * 0x12 + 0x1e)
///bEBhEXChx(8rbg)
#define TALKWIN_SLIDE_SPEED		(0x0400)
///bEBhẼXCh(hbgP)
#define TALKWIN_SLIDE_DOT_LEN	(9 * 8 + FRAME_WIN_DEFAULT_X)

///u[_[pl̃Xs[h(8rbg)
#define BRDPANEL_ALPHA_SP		(0x0300)

///ϋqAj̃EFCg
#define AUDIENCE_ANIME_WAIT		(2)
///ϋqAǰJԂ
#define AUDIENCE_ANIME_LOOP		(8)

///As[ACRGtFNgFgk̏l
#define APICON_EFF_INIT_SCALE		(0.1f)
///As[ACRGtFNgFgk̍ől
#define APICON_EFF_MAX_SCALE		(1.5f)
///As[ACRGtFNgFʏ̊gk
#define APICON_EFF_NORMAL_SCALE		(1.0f)
///As[ACRGtFNgFZgk
#define APICON_EFF_ADD_SCALE		(0.3f)
///As[ACRGtFNgF]x
#define APICON_EFF_ADD_ROTATION		(0)//(0x2000)

///RAwFړ(8rbg)
#define JUDGE_NOMINATION_ADD_Y		(0x0180)
///RAwFړJԂ
#define JUDGE_NOMINATION_LOOP		(2)

///RAFړX(8rbg)
#define JUDGE_WEAR_ADD_X			(0x0200)
///RAFړJԂ
#define JUDGE_WEAR_LOOP				(4)

///RAWvFw̃Wv
#define JUDGE_JUMP_NOMINATION_POWER			(0x0200)
///RAWvF{e[W̃Wv
#define JUDGE_JUMP_VOLTAGE_UP_POWER			(0x0300)
///RAWvF{e[WMAX̃Wv
#define JUDGE_JUMP_VOLTAGE_MAX_UP_POWER		(0x0400)
///RAWvFd
#define JUDGE_JUMP_GRAVITY			(0x0100 / 2)

///{e[WړFŏ̈ړɂt[
#define VOLTAGE_MOVE_FIRST_FRAME		(15)
///{e[WړFŌ̈ړɂt[
#define VOLTAGE_MOVE_END_FRAME			(10)
///{e[WړFŏ̈ړIɔEFCg
#define VOLTAGE_MOVE_FIRST_WAIT			(4)
///{e[WړFŌ̈ړIɔEFCg
#define VOLTAGE_MOVE_END_WAIT			(4)
///{e[WړFAN^[Aj̉]pZl
#define VOLTAGE_MOVE_ADD_ROTATION		(0x2000)

//==============================================================================
//	\̒`
//==============================================================================
///bEBhEXCh^XNŎgp郏[N
typedef struct{
	ACTIN_SYSTEM_PARAM *sys;
	u8 *end_flag;	///<ItOZbg郏[Nւ̃|C^
	
	s32 x;		///<8rbg
	u8 seq;
	u8 slide_dir;	///<XCh
}TALKWIN_SLIDE_WORK;

///u[_[plGtFNg^XNŎgp郏[N
typedef struct{
	ACTIN_PROC_WORK *apw;
	u8 *end_flag;	///<ItOZbg郏[Nւ̃|C^
	
	s16 eva;
	s16 evb;
	u8 seq;
	u8 eff_type;
}BRDPANEL_ALPHA_WORK;

///ϋqAj[N
typedef struct{
	ACTIN_PROC_WORK *apw;
	u8 seq;				///<V[PX
	u8 anm_no;			///<ݎs̃Ajp^[
	u8 loop;			///<AjJԂ񐔃JEg
	u8 voltage;			///<{e[Wl
	u8 wait;			///<AjEFCg
	u8 start_wait;		///<Jn܂ł̃EFCg
	u8 *end_flag;		///<IAɏItO(TRUE)Zbg
}AUDIENCE_ANIME_WORK;

///As[|CgACRoGtFNgp̃[N
typedef struct{
	CATS_ACT_PTR cap;
	f32 sx;
	f32 sy;
	u8 seq;
	u8 wait;
}APPEAL_POINT_APPEAR_WORK;

///RANVp[N
typedef struct{
	ACTIN_PROC_WORK *apw;		///<Z͕Ǘ[Nւ̃|C^
	u8 *end_flag;				///<GtFNgIɂɏI̕ԎƂTRUE
	u8 judge_no;				///<RNo
	s8 wait;					///<ėpEFCg
	u8 seq;						///<V[PXNo
	
	s16 start_x;				///<RWX
	s16 start_y;				///<RWY
	s32 x;						///<ݍWX(8rbg)
	s32 y;						///<ݍWY(8rbg)
	u8 loop;
	union{
		struct{
			u8 dummy;
		}nom;
		struct{
			u8 dummy;
		}wear;
		struct{
			s32 x;
			s32 y;
			s16 up_power;		///<Wv
			s16 backup_up_power;		///<Wv
		}jump;
	};
}JUDGE_REACTION_MOVE_WORK;

///{e[WړGtFNgp[N
typedef struct{
	ACTIN_SYSTEM_PARAM *sys;
	CATS_ACT_PTR cap;				///<{e[WõAN^[|C^
	CATS_ACT_PTR voltage_cap;		///<{e[W|Cg̃AN^[|C^
	fx32 theta;			///<px(8rbg)
	s32 x;				///<ݍWX(8rbg)
	s32 y;				///<ݍWY(8rbg)
	s32 temp_x;
	s32 temp_y;
	s32 move_end_x;		///<ړp̓r~|CgX
	s32 move_end_y;		///<ړp̓r~|CgY
	s16 add_x;			///<XZl(8rbg)
	s16 add_y;			///<YZl(8rbg)
	
	u8 end_x;			///<I_WX
	u8 end_y;			///<I_WY
	
	u8 seq;				///<V[PXԍ
	u8 wait;			///<EFCgJEg
	
	//ȂAȃf[^
	u8 judge_no;		///<RNO
	u8 point;			///<{e[W|Cg
}VOLTAGE_MOVE_WORK;

//==============================================================================
//	f[^
//==============================================================================
///RAN^[wb_
static const TCATS_OBJECT_ADD_PARAM_S JudgeObjParam = {
	JUDGE_POS_X_0, JUDGE_POS_Y_0, 0,		//x, y, z
	0, ACTIN_SOFTPRI_JUDGE, 0,		//AjԍAD揇ʁApbgԍ
	NNS_G2D_VRAM_TYPE_2DMAIN,		//`GA
	{	//gp\[XIDe[u
		0,	//L
		0,	//pbg
		0,	//Z
		0,	//ZAj
		CLACT_U_HEADER_DATA_NONE,		//}`Z
		CLACT_U_HEADER_DATA_NONE,		//}`ZAj
	},
	ACTIN_BGPRI_JUDGE,			//BGvCIeB
	0,			//Vram]tO
};

///R{bNXAN^[wb_
static const TCATS_OBJECT_ADD_PARAM_S JudgeBoxObjParam = {
	JUDGE_BOX_POS_X_0, JUDGE_BOX_POS_Y_0, 0,		//x, y, z
	0, ACTIN_SOFTPRI_JUDGE_BOX, PALOFS_JUDGE_BOX,		//AjԍAD揇ʁApbgԍ
	NNS_G2D_VRAM_TYPE_2DMAIN,		//`GA
	{	//gp\[XIDe[u
		CHARID_JUDGE_BOX,	//L
		PLTTID_OBJ_COMMON,	//pbg
		CELLID_JUDGE_BOX,	//Z
		CELLANMID_JUDGE_BOX,	//ZAj
		CLACT_U_HEADER_DATA_NONE,		//}`Z
		CLACT_U_HEADER_DATA_NONE,		//}`ZAj
	},
	ACTIN_BGPRI_JUDGE,			//BGvCIeB
	0,			//Vram]tO
};

///ʐRɂn[g̃AN^[wb_
static const TCATS_OBJECT_ADD_PARAM_S SpecialHeartObjParam = {
	0, 0, 0,		//x, y, z
	0, ACTIN_SOFTPRI_SPECIAL_HEART, PALOFS_SPECIAL_HEART,	//AjԍAD揇ʁApbgԍ
	NNS_G2D_VRAM_TYPE_2DMAIN,		//`GA
	{	//gp\[XIDe[u
		CHARID_SPECIAL_HEART,	//L
		PLTTID_OBJ_COMMON,	//pbg
		CELLID_SPECIAL_HEART,	//Z
		CELLANMID_SPECIAL_HEART,	//ZAj
		CLACT_U_HEADER_DATA_NONE,		//}`Z
		CLACT_U_HEADER_DATA_NONE,		//}`ZAj
	},
	ACTIN_BGPRI_JUDGE,			//BGvCIeB
	0,			//Vram]tO
};

///As[|Cgn[g̃AN^[wb_
static const TCATS_OBJECT_ADD_PARAM_S AppealPointObjParam = {
	0, 0, 0,		//x, y, z
	0, ACTIN_SOFTPRI_APPEAL_POINT, PALOFS_APPEAL_POINT,	//AjԍAD揇ʁApbgԍ
	NNS_G2D_VRAM_TYPE_2DMAIN,		//`GA
	{	//gp\[XIDe[u
		CHARID_APPEAL_POINT,	//L
		PLTTID_OBJ_COMMON,	//pbg
		CELLID_APPEAL_POINT,	//Z
		CELLANMID_APPEAL_POINT,	//ZAj
		CLACT_U_HEADER_DATA_NONE,		//}`Z
		CLACT_U_HEADER_DATA_NONE,		//}`ZAj
	},
	ACTINSUB_BGPRI_APPEAL_POINT,			//BGvCIeB
	0,			//Vram]tO
};

///{e[W|Cgn[g̃AN^[wb_
static const TCATS_OBJECT_ADD_PARAM_S VoltagePointObjParam = {
	0, 0, 0,		//x, y, z
	0, ACTIN_SOFTPRI_VOLTAGE_POINT, PALOFS_VOLTAGE_POINT,	//AjԍAD揇ʁApbgԍ
	NNS_G2D_VRAM_TYPE_2DMAIN,		//`GA
	{	//gp\[XIDe[u
		CHARID_VOLTAGE_POINT,	//L
		PLTTID_OBJ_COMMON,	//pbg
		CELLID_VOLTAGE_POINT,	//Z
		CELLANMID_VOLTAGE_POINT,	//ZAj
		CLACT_U_HEADER_DATA_NONE,		//}`Z
		CLACT_U_HEADER_DATA_NONE,		//}`ZAj
	},
	ACTINSUB_BGPRI_VOLTAGE_POINT,			//BGvCIeB
	0,			//Vram]tO
};

///{e[WõAN^[wb_
static const TCATS_OBJECT_ADD_PARAM_S VoltageEffectObjParam = {
	0, 0, 0,		//x, y, z
	0, ACTIN_SOFTPRI_VOLTAGE_EFF, PALOFS_VOLTAGE_EFF,	//AjԍAD揇ʁApbgԍ
	NNS_G2D_VRAM_TYPE_2DMAIN,		//`GA
	{	//gp\[XIDe[u
		CHARID_VOLTAGE_EFF,	//L
		PLTTID_OBJ_COMMON,	//pbg
		CELLID_VOLTAGE_EFF,	//Z
		CELLANMID_VOLTAGE_EFF,	//ZAj
		CLACT_U_HEADER_DATA_NONE,		//}`Z
		CLACT_U_HEADER_DATA_NONE,		//}`ZAj
	},
	ACTIN_BGPRI_VOLTAGE_EFF,			//BGvCIeB
	0,			//Vram]tO
};

///ACR̃AN^[wb_
static const TCATS_OBJECT_ADD_PARAM_S NextIconObjParam = {
	0, 0, 0,		//x, y, z
	0, ACTIN_SOFTPRI_NEXT_ICON, PALOFS_NEXT_ICON,	//AjԍAD揇ʁApbgԍ
	NNS_G2D_VRAM_TYPE_2DMAIN,		//`GA
	{	//gp\[XIDe[u
		CHARID_NEXT_ICON,	//L
		PLTTID_OBJ_COMMON,	//pbg
		CELLID_NEXT_ICON,	//Z
		CELLANMID_NEXT_ICON,	//ZAj
		CLACT_U_HEADER_DATA_NONE,		//}`Z
		CLACT_U_HEADER_DATA_NONE,		//}`ZAj
	},
	ACTINSUB_BGPRI_NEXT_ICON,			//BGvCIeB
	0,			//Vram]tO
};

///bEBhEJo[̃AN^[wb_
static const TCATS_OBJECT_ADD_PARAM_S WinCoverObjParam = {
	0, 0, 0,		//x, y, z
	0, 10, 0,		//AjԍAD揇ʁApbgԍ
	NNS_G2D_VRAM_TYPE_2DMAIN,		//`GA
	{	//gp\[XIDe[u
		CHARID_WIN_COVER_0,	//L
		PLTTID_WIN_COVER,	//pbg
		CELLID_WIN_COVER,	//Z
		CELLANMID_WIN_COVER,	//ZAj
		CLACT_U_HEADER_DATA_NONE,		//}`Z
		CLACT_U_HEADER_DATA_NONE,		//}`ZAj
	},
	0,			//BGvCIeB
	0,			//Vram]tO
};

///RANVACR̃AN^[wb_
static const TCATS_OBJECT_ADD_PARAM_S JudgeReactionObjParam = {
	0, 0, 0,		//x, y, z
	0, ACTIN_SOFTPRI_JUDGE_REACTION, PALOFS_JUDGE_REACTION,	//AjԍAD揇ʁApbgԍ
	NNS_G2D_VRAM_TYPE_2DMAIN,		//`GA
	{	//gp\[XIDe[u
		CHARID_JUDGE_REACTION,	//L
		PLTTID_OBJ_COMMON,	//pbg
		CELLID_JUDGE_REACTION,	//Z
		CELLANMID_JUDGE_REACTION,	//ZAj
		CLACT_U_HEADER_DATA_NONE,		//}`Z
		CLACT_U_HEADER_DATA_NONE,		//}`ZAj
	},
	ACTIN_BGPRI_JUDGE_REACTION,			//BGvCIeB
	0,			//Vram]tO
};


//--------------------------------------------------------------
//	
//--------------------------------------------------------------
///As[|CgACRoW(ԍ̍W)
ALIGN4 static const s16 AppealPointPos[BREEDER_MAX][2] = {	//X, Y
	{5, 5*8 + 3},
	{5, 11*8 + 3},
	{5, 17*8 + 3},
	{5, 23*8 + 3},
};

///{e[W|CgACRoW(ԍ̍W)
ALIGN4 static const s16 VoltagePointPos[JUDGE_MAX][2] = {	//X, Y
	{10*8 + 8 + 32*0, 1*8 + 4},
	{10*8 + 8 + 32*1, 1*8 + 4},
	{10*8 + 8 + 32*2, 1*8 + 4},
};
///{e[WƗׂ̃{e[W̌X
#define VOLTAGE_SPACE_X		(5)

///RANVACR̕\W
static const struct{
	s16 x;
	s16 y;
}JudgeReactionIconPos[] = {
	{JUDGE_BOX_POS_X_0 + JUDGE_BOX_POS_X_SPACE * 0, JUDGE_BOX_POS_Y_0 - 12},
	{JUDGE_BOX_POS_X_0 + JUDGE_BOX_POS_X_SPACE * 1, JUDGE_BOX_POS_Y_0 - 12},
	{JUDGE_BOX_POS_X_0 + JUDGE_BOX_POS_X_SPACE * 2, JUDGE_BOX_POS_Y_0 - 12},
};

//--------------------------------------------------------------
//	
//--------------------------------------------------------------
///Z͕m[}bbZ[Wf[^	A_TALK_???̒`ƕт𓯂ɂĂII
static const ACTIN_MESSAGE_PARAM ActinTalkMsgData[] = {
	{0,									ATAG_NONE},	//_~[

	{CAMSG_TALK_SELECT_JUDGE,			ATAG_NUM},
	{CAMSG_TALK_SELECT_WAZA,			ATAG_NONE},
	{CAMSG_TALK_WAZA_APPEAL,			ATAG_WAZA},
	{CAMSG_TALK_JUDGE_LOOK,				ATAG_MINE_JUDGE},
	{CAMSG_TALK_JUDGE_SUFFER,			ATAG_JUDGE},
	{CAMSG_TALK_NO_JUDGE_SUFFER,		ATAG_JUDGE},
	{CAMSG_TALK_VOLTAGE_UP_1,			ATAG_JUDGE},
	{CAMSG_TALK_VOLTAGE_UP_2,			ATAG_JUDGE},
	{CAMSG_TALK_VOLTAGE_SUB_1,			ATAG_JUDGE},
	{CAMSG_TALK_VOLTAGE_STATE_UP_2,		ATAG_NONE},
	{CAMSG_TALK_VOLTAGE_STATE_UP_3,		ATAG_NONE},
	{CAMSG_TALK_VOLTAGE_STATE_UP_4,		ATAG_NONE},
	{CAMSG_TALK_VOLTAGE_STATE_UP_5,		ATAG_NONE},
	{CAMSG_TALK_VOLTAGE_STATE_SUB_3,	ATAG_NONE},
	{CAMSG_TALK_VOLTAGE_STATE_SUB_2,	ATAG_NONE},
	{CAMSG_TALK_VOLTAGE_STATE_SUB_1,	ATAG_NONE},
	{CAMSG_TALK_VOLTAGE_STATE_SUB_0,	ATAG_NONE},
	{CAMSG_TALK_TURN_RESULT_0,			ATAG_MINE},
	{CAMSG_TALK_TURN_RESULT_1,			ATAG_MINE},
	{CAMSG_TALK_TURN_RESULT_2,			ATAG_MINE},
	{CAMSG_TALK_TURN_RESULT_3,			ATAG_MINE},
	{CAMSG_TALK_TURN_RESULT_4,			ATAG_MINE},
	{msg_con_act_host_01,				ATAG_NONE},
	{msg_con_act_host_02,				ATAG_NONE},
};


//==============================================================================
//	vg^Cv錾
//==============================================================================
static void TalkWinSlideInOutMain(TCB_PTR tcb, void *work);
void AT_BreederPanelFontOamCreate(ACTIN_PROC_WORK *apw, int breeder_no);
void AT_BreederPanelFontOamCreateAll(ACTIN_PROC_WORK *apw);
void AT_BreederPanelFontOamDeleteAll(ACTIN_PROC_WORK *apw);
void AT_BreederPanelFontOamPosUpdate(ACTIN_PROC_WORK *apw);
void AT_BrdPanelAlphaEffectSet(ACTIN_PROC_WORK *apw, int eff_type, u8 *end_flag);
static void BrdPanelAlphaEffMain(TCB_PTR tcb, void *work);
static void BrdPanelAlphaSet_VTask(TCB_PTR tcb, void *work);
static void AudienceAnimeMain(TCB_PTR tcb, void *work);
static void AppealPointAppearEffectSet(CATS_ACT_PTR cap);
static void AppealPointAppear(TCB_PTR tcb, void *work);
static void JudgeReactionMove_Nomination(TCB_PTR tcb, void *work);
static void JudgeReactionMove_Wear(TCB_PTR tcb, void *work);
static void JudgeReactionMove_Jump(TCB_PTR tcb, void *work);



//--------------------------------------------------------------
/**
 * @brief   Z͉ʂ̃ftHguhݒs
 *
 * ZGtFNgĂ΂֐ł
 */
//--------------------------------------------------------------
void ActinExTool_DefaultBlendSet(void)
{
	G2_BlendNone();
}

#if 0	//u[_[OBJŕ\悤ɂȂ
//--------------------------------------------------------------
/**
 * @brief   u[_[plɕ`悷
 *
 * @param   apw				Z͊Ǘ[Nւ̃|C^
 * @param   breeder_no		Ώۂ̃u[_[ԍ
 * @param   put_pos			`悷pl̈ʒu
 * @param   bmp_pal			BMP̃pbgԍ
 */
//--------------------------------------------------------------
void BreederParamBmpWrite(ACTIN_PROC_WORK *apw, int breeder_no, int put_pos, int bmp_pal)
{
	STRBUF *oyaname_buf, *nickname_buf;
	
	nickname_buf = STRBUF_Create(BUFLEN_POKEMON_NAME, HEAPID_ACTIN);
	oyaname_buf = STRBUF_Create(BUFLEN_PERSON_NAME, HEAPID_ACTIN);

	PokeParaGet(apw->sys.c_game->pp[breeder_no], ID_PARA_nickname_buf, nickname_buf);
	PokeParaGet(apw->sys.c_game->pp[breeder_no], ID_PARA_oyaname_buf, oyaname_buf);

	GF_BGL_BmpWinSet_Pal(&apw->sys.win[ACTIN_BMPWIN_BREEDER_0 + put_pos], bmp_pal);
	GF_BGL_BmpWinDataFill(&apw->sys.win[ACTIN_BMPWIN_BREEDER_0 + put_pos], 
		BMPWIN_PANEL_FILL_COLOR);
	
	GF_STR_PrintColor(&apw->sys.win[ACTIN_BMPWIN_BREEDER_0 + put_pos], FONT_SYSTEM, 
		nickname_buf, 0, 0, 
		MSG_NO_PUT, MSGCOLOR_BREEDERPARAM, NULL);
	GF_STR_PrintColor(&apw->sys.win[ACTIN_BMPWIN_BREEDER_0 + put_pos], FONT_SYSTEM, 
		oyaname_buf, 0, 16, 
		MSG_NO_PUT, MSGCOLOR_BREEDERPARAM, NULL);

	STRBUF_Delete(oyaname_buf);
	STRBUF_Delete(nickname_buf);
}

//--------------------------------------------------------------
/**
 * @brief   SẴu[_[̏plɕ`悷
 * @param   apw				Z͊Ǘ[Nւ̃|C^
 */
//--------------------------------------------------------------
void BreederParamBmpWriteAll(ACTIN_PROC_WORK *apw)
{
	int i, pal;
	
	for(i = 0; i < BREEDER_MAX; i++){
		if(apw->a_game.breeder_sort[i] == apw->consys->c_game.my_breeder_no){
			pal = MYBREEDER_PANEL_SCREEN_PAL;
		}
		else{
			pal = BREEDER_PANEL_SCREEN_PAL;
		}
		BreederParamBmpWrite(apw, apw->a_game.breeder_sort[i], i, pal);
	}
	//Sĕ`悵ĂEBhEON
	for(i = 0; i < BREEDER_MAX; i++){
		GF_BGL_BmpWinOn(&apw->sys.win[ACTIN_BMPWIN_BREEDER_0 + i]);
	}
}
#endif

//--------------------------------------------------------------
/**
 * @brief   u[_[pl̃J[(XN[)ύX
 *
 * @param   apw				Z͊Ǘ[Nւ̃|C^
 * @param   breeder_pos		pl̈ʒu
 * @param   pal_no			VɃZbgpbgԍ
 */
//--------------------------------------------------------------
void BreederPanelColorChange(ACTIN_PROC_WORK *apw, int breeder_pos, int pal_no)
{
	u16 *scrbuf;
	int x, y;
	
	scrbuf = GF_BGL_ScreenAdrsGet(apw->sys.bgl, ACTIN_FRAME_BRDPANEL);
	scrbuf = &scrbuf[32 * (breeder_pos * BREEDER_PANEL_Y_LEN) + BREEDER_PANEL_SCREEN_START_POS];
	for(y = 0; y < BREEDER_PANEL_Y_LEN; y++){
		for(x = 0; x < BREEDER_PANEL_X_LEN; x++){
			scrbuf[y * 32 + x] = (scrbuf[y * 32 + x] & 0x0fff) | (pal_no << 12);
		}
	}
}

//--------------------------------------------------------------
/**
 * @brief   Su[_[pl̃J[(XN[)ύX
 * @param   apw		Z͊Ǘ[Nւ̃|C^
 *
 * breeder_sortɏ]ďs܂
 */
//--------------------------------------------------------------
void BreederPanelColorChangeAll(ACTIN_PROC_WORK *apw)
{
	int i;
	
	for(i = 0; i < BREEDER_MAX; i++){
		if(apw->a_game.breeder_sort[i] == apw->consys->c_game.my_breeder_no){
			BreederPanelColorChange(apw, i, MYBREEDER_PANEL_SCREEN_PAL);
		}
		else{
			BreederPanelColorChange(apw, i, BREEDER_PANEL_SCREEN_PAL);
		}
	}
	GF_BGL_LoadScreenV_Req(apw->sys.bgl, ACTIN_FRAME_BRDPANEL);
}

//--------------------------------------------------------------
/**
 * @brief   SẴu[_[̃\tgEFAXvCg(|P)𐶐
 *
 * @param   sys		Z̓VXe[Nւ̃|C^
 * @param   pp		Su[_[̃|Pp[^Ăzւ̃|C^
 */
//--------------------------------------------------------------
void AT_SoftSpriteAddAll(ACTIN_SYSTEM_PARAM *sys)
{
	int i;
	
	for(i = 0; i < BREEDER_MAX; i++){
		GF_ASSERT(sys->exchr_param[i].exchr_buffer == NULL);
		sys->exchr_param[i].exchr_buffer = sys_AllocMemory(HEAPID_ACTIN, EXCHR_BUFFER_SIZE);
		
		sys->ss[i] = ConTool_BreederPokemonAdd(sys->soft_sprite, i, sys->c_game->pp[i], 
			PARA_BACK, &sys->exchr_param[i], HEAPID_ACTIN, 
			ACTIN_POKEPOS_X-32*i, ACTIN_POKEPOS_Y-32*i, ACTIN_POKEPOS_Z);
		//\OFF
		SoftSpriteParaSet(sys->ss[i], SS_PARA_VANISH, TRUE);
		SoftSpriteParaSet(sys->ss[i], SS_PARA_DRAW_STOP, TRUE);
		//]Zbg
		SoftSpriteParaSet(sys->ss[i], SS_PARA_H_FLIP, TRUE);
	}
	
	GF_ASSERT(sys->transparent_exchr_param.exchr_buffer == NULL);
	sys->transparent_exchr_param.exchr_buffer = sys_AllocMemory(HEAPID_ACTIN, EXCHR_BUFFER_SIZE);
	sys->transparent_exchr_param.pal_index = sys->exchr_param[0].pal_index;	//_~[
	//obt@NA
	MI_CpuClear32(sys->transparent_exchr_param.exchr_buffer, EXCHR_BUFFER_SIZE);
}

//--------------------------------------------------------------
/**
 * @brief   SẴu[_[̃\tgEFAXvCg(|P)폜
 * @param   sys		Z̓VXe[Nւ̃|C^
 */
//--------------------------------------------------------------
void AT_SoftSpriteDelAll(ACTIN_SYSTEM_PARAM *sys)
{
	int i;
	
	for(i = 0; i < BREEDER_MAX; i++){
		SoftSpriteDel(sys->ss[i]);
		sys_FreeMemoryEz(sys->exchr_param[i].exchr_buffer);
		sys->exchr_param[i].exchr_buffer = NULL;
	}
	sys_FreeMemoryEz(sys->transparent_exchr_param.exchr_buffer);
	sys->transparent_exchr_param.exchr_buffer = NULL;
}

//--------------------------------------------------------------
/**
 * @brief   RAN^[̐ƃ\[Xo^
 *
 * @param   pfd			pbgtF[hVXeւ̃|C^
 * @param   csp			csp
 * @param   crp			crp
 * @param   judge		Rf[^ւ̃|C^
 * @param   judge_no	RNO
 *
 * @retval  RAN^[̃|C^
 */
//--------------------------------------------------------------
static CATS_ACT_PTR AT_JudgeAdd(PALETTE_FADE_PTR pfd, CATS_SYS_PTR csp, CATS_RES_PTR crp, 
	const JUDGE_DATA *judge, int judge_no)
{
	CATS_ACT_PTR judge_cap;
	TCATS_OBJECT_ADD_PARAM_S judge_head;
	
#if WAIT_FIX	//OBJR[hɂĎgpGύXH
	switch(judge->obj_code){
	case 0:
		break;
	default:
		break;
	}
#else
	u32 char_id, pal_id, cell_id, anm_id;
	
	switch(judge_no){
	case 0:
		char_id = BIGMAN_NCGR_BIN;
		pal_id = BIGMAN_NCLR;
		cell_id = BIGMAN_NCER_BIN;
		anm_id = BIGMAN_NANR_BIN;
		break;
	case 1:
		char_id = GIRL1_NCGR_BIN;
		pal_id = GIRL1_NCLR;
		cell_id = GIRL1_NCER_BIN;
		anm_id = GIRL1_NANR_BIN;
		break;
	default:
		char_id = BOYGIRL_NCGR_BIN;
		pal_id = BOYGIRL_NCLR;
		cell_id = BOYGIRL_NCER_BIN;
		anm_id = BOYGIRL_NANR_BIN;
		break;
	}
	
	//-- \[X[h --//
	CATS_LoadResourceCharArc(csp, crp, ARC_CONTEST_OBJ, char_id, 1, 
		NNS_G2D_VRAM_TYPE_2DMAIN, CHARID_JUDGE_0 + judge_no);
	CATS_LoadResourcePlttWorkArc(pfd, FADE_MAIN_OBJ, csp, crp, 
		ARC_CONTEST_OBJ, pal_id, 0, 
		1, NNS_G2D_VRAM_TYPE_2DMAIN, PLTTID_JUDGE_0 + judge_no);
	CATS_LoadResourceCellArc(csp, crp, ARC_CONTEST_OBJ, cell_id, 1, 
		CELLID_JUDGE_0 + judge_no);
	CATS_LoadResourceCellAnmArc(csp, crp, ARC_CONTEST_OBJ, 
		anm_id, 1, CELLANMID_JUDGE_0 + judge_no);
	
	//-- AN^[ --//
	judge_head = JudgeObjParam;
	judge_head.id[CLACT_U_CHAR_RES] = CHARID_JUDGE_0 + judge_no;
	judge_head.id[CLACT_U_PLTT_RES] = PLTTID_JUDGE_0 + judge_no;
	judge_head.id[CLACT_U_CELL_RES] = CELLID_JUDGE_0 + judge_no;
	judge_head.id[CLACT_U_CELLANM_RES] = CELLANMID_JUDGE_0 + judge_no;
	judge_head.x = JUDGE_POS_X_0 + JUDGE_POS_X_SPACE * judge_no;
	judge_head.y = JUDGE_POS_Y_0 + JUDGE_POS_Y_SPACE * judge_no;
	judge_cap = CATS_ObjectAdd_S(csp, crp, &judge_head);
	CATS_ObjectUpdate(judge_cap->act);
#endif

	return judge_cap;
}

//--------------------------------------------------------------
/**
 * @brief   RAN^[\[X폜
 *
 * @param   crp				crp
 * @param   judge_cap		RAN^[ւ̃|C^
 * @param   judge_no		RNo
 */
//--------------------------------------------------------------
static void AT_JudgeDel(CATS_RES_PTR crp, CATS_ACT_PTR judge_cap, int judge_no)
{
#if WAIT_FIX	//KADD@܂킩Ȃ̂ŁA폜킩Ȃ
	;
#else
	//-- AN^[폜 --//
	CATS_ActorPointerDelete_S(judge_cap);

	//-- \[X폜 --//
	CATS_FreeResourceChar(crp, CHARID_JUDGE_0 + judge_no);
	CATS_FreeResourcePltt(crp, PLTTID_JUDGE_0 + judge_no);
	CATS_FreeResourceCell(crp, CELLID_JUDGE_0 + judge_no);
	CATS_FreeResourceCellAnm(crp, CELLANMID_JUDGE_0 + judge_no);
#endif
}

//--------------------------------------------------------------
/**
 * @brief   R{bNX̃\[Xo^
 *
 * @param   pfd			pbgtF[hVXeւ̃|C^
 * @param   csp			csp
 * @param   crp			crp
 *
 * SĂ̐R{bNXœ\[Xg܂킷悤ɂȂĂ܂B
 */
//--------------------------------------------------------------
static void AT_JudgeBoxResourceLoad(PALETTE_FADE_PTR pfd, CATS_SYS_PTR csp, CATS_RES_PTR crp)
{
	u32 char_id, cell_id, anm_id;
	
	char_id = JUDGE_BOX_NCGR_BIN;
	cell_id = JUDGE_BOX_NCER_BIN;
	anm_id = JUDGE_BOX_NANR_BIN;
	
	//-- \[X[h --//
	//pbg͏풓pbggp̂Ń[hȂ
	CATS_LoadResourceCharArc(csp, crp, ARC_CONTEST_OBJ, char_id, 1, 
		NNS_G2D_VRAM_TYPE_2DMAIN, CHARID_JUDGE_BOX);
	CATS_LoadResourceCellArc(csp, crp, ARC_CONTEST_OBJ, cell_id, 1, 
		CELLID_JUDGE_BOX);
	CATS_LoadResourceCellAnmArc(csp, crp, ARC_CONTEST_OBJ, 
		anm_id, 1, CELLANMID_JUDGE_BOX);
}

//--------------------------------------------------------------
/**
 * @brief   R{bNXAN^[̐
 *
 * @param   csp			csp
 * @param   crp			crp
 * @param   judge_no	RNO
 *
 * @retval  R{bNXAN^[̃|C^
 */
//--------------------------------------------------------------
static CATS_ACT_PTR AT_JudgeBoxActorAdd(CATS_SYS_PTR csp, CATS_RES_PTR crp, int judge_no)
{
	CATS_ACT_PTR box_cap;
	TCATS_OBJECT_ADD_PARAM_S box_head;
	
	//-- AN^[ --//
	box_head = JudgeBoxObjParam;
	box_head.x = JUDGE_BOX_POS_X_0 + JUDGE_BOX_POS_X_SPACE * judge_no;
	box_head.y = JUDGE_BOX_POS_Y_0 + JUDGE_BOX_POS_Y_SPACE * judge_no;
	box_cap = CATS_ObjectAdd_S(csp, crp, &box_head);
	CATS_ObjectUpdate(box_cap->act);

	return box_cap;
}

//--------------------------------------------------------------
/**
 * @brief   R{bNXAN^[폜
 *
 * @param   box_cap			R{bNXAN^[ւ̃|C^
 */
//--------------------------------------------------------------
static void AT_JudgeBoxActorDel(CATS_ACT_PTR box_cap)
{
	CATS_ActorPointerDelete_S(box_cap);
}

//--------------------------------------------------------------
/**
 * @brief   R{bNX\[X폜
 *
 * @param   crp				crp
 */
//--------------------------------------------------------------
static void AT_JudgeBoxResourceDel(CATS_RES_PTR crp)
{
	//-- \[X폜 --//
	//pbg͏풓pbgȂ̂ō폜Ȃ
	CATS_FreeResourceChar(crp, CHARID_JUDGE_BOX);
	CATS_FreeResourceCell(crp, CELLID_JUDGE_BOX);
	CATS_FreeResourceCellAnm(crp, CELLANMID_JUDGE_BOX);
}

//--------------------------------------------------------------
/**
 * @brief   SĂ̐RƐR{bNX̃AN^[ƃ\[Xo^
 * @param   sys		Z̓VXe\̂ւ̃|C^
 */
//--------------------------------------------------------------
void AT_JudgeAddAll(ACTIN_SYSTEM_PARAM *sys, CONTEST_SYSTEM *consys)
{
	int i;
	
	//R{bNX̃\[Xǂݍ
	AT_JudgeBoxResourceLoad(sys->pfd, sys->csp, sys->crp);

	for(i = 0; i < JUDGE_MAX; i++){
		sys->judge_box_cap[i] = AT_JudgeBoxActorAdd(sys->csp, sys->crp, i);
		sys->judge_cap[i] = 
			AT_JudgeAdd(sys->pfd, sys->csp, sys->crp, &consys->c_game.jd[i], i);
	}
}

//--------------------------------------------------------------
/**
 * @brief   SĂ̐RƐR{bNX̃AN^[ƃ\[X̍폜s
 * @param   sys		Z̓VXe\̂ւ̃|C^
 */
//--------------------------------------------------------------
void AT_JudgeDelAll(ACTIN_SYSTEM_PARAM *sys)
{
	int i;
	
	for(i = 0; i < JUDGE_MAX; i++){
		AT_JudgeDel(sys->crp, sys->judge_cap[i], i);
		AT_JudgeBoxActorDel(sys->judge_box_cap[i]);
	}
	AT_JudgeBoxResourceDel(sys->crp);
}

//--------------------------------------------------------------
/**
 * @brief   RANVACR̃\[Xo^
 *
 * @param   pfd			pbgtF[hVXeւ̃|C^
 * @param   csp			csp
 * @param   crp			crp
 */
//--------------------------------------------------------------
void AT_JudgeReactionIconResourceLoad(PALETTE_FADE_PTR pfd, CATS_SYS_PTR csp, CATS_RES_PTR crp)
{
	u32 char_id, cell_id, anm_id;
	
	char_id = EXCLAMATION_NCGR_BIN;
	cell_id = EXCLAMATION_NCER_BIN;
	anm_id = EXCLAMATION_NANR_BIN;
	
	//-- \[X[h --//
	//pbg͏풓pbggp̂Ń[hȂ
	CATS_LoadResourceCharArc(csp, crp, ARC_CONTEST_OBJ, char_id, 1, 
		NNS_G2D_VRAM_TYPE_2DMAIN, CHARID_JUDGE_REACTION);
	CATS_LoadResourceCellArc(csp, crp, ARC_CONTEST_OBJ, cell_id, 1, 
		CELLID_JUDGE_REACTION);
	CATS_LoadResourceCellAnmArc(csp, crp, ARC_CONTEST_OBJ, 
		anm_id, 1, CELLANMID_JUDGE_REACTION);
}

//--------------------------------------------------------------
/**
 * @brief   RANVACR\[X폜
 *
 * @param   crp				crp
 */
//--------------------------------------------------------------
void AT_JudgeReactionIconResourceDel(CATS_RES_PTR crp)
{
	//-- \[X폜 --//
	//pbg͏풓pbgȂ̂ō폜Ȃ
	CATS_FreeResourceChar(crp, CHARID_JUDGE_REACTION);
	CATS_FreeResourceCell(crp, CELLID_JUDGE_REACTION);
	CATS_FreeResourceCellAnm(crp, CELLANMID_JUDGE_REACTION);
}

//--------------------------------------------------------------
/**
 * @brief   RANVACRAN^[̐
 * @param   sys			Z̓VXe[Nւ̃|C^
 */
//--------------------------------------------------------------
void AT_JudgeReactionIconActorAdd(ACTIN_SYSTEM_PARAM *sys)
{
	CATS_ACT_PTR cap;
	TCATS_OBJECT_ADD_PARAM_S act_head;
	
	//-- AN^[ --//
	act_head = JudgeReactionObjParam;
	cap = CATS_ObjectAdd_S(sys->csp, sys->crp, &act_head);
	
	CATS_ObjectEnableCap(cap, CATS_ENABLE_FALSE);

	CATS_ObjectUpdate(cap->act);
	
	sys->judge_reaction_icon_cap = cap;
}

//--------------------------------------------------------------
/**
 * @brief   RANVACRAN^[폜
 *
 * @param   box_cap			RANVACRAN^[ւ̃|C^
 */
//--------------------------------------------------------------
void AT_JudgeReactionIconActorDel(ACTIN_SYSTEM_PARAM *sys)
{
	GF_ASSERT(sys->judge_reaction_icon_cap != NULL);
	
	CATS_ActorPointerDelete_S(sys->judge_reaction_icon_cap);
	sys->judge_reaction_icon_cap = NULL;
}

//--------------------------------------------------------------
/**
 * @brief   RANVACR\ON
 *
 * @param   sys				Z̓VXe[Nւ̃|C^
 * @param   judge_no		RNo
 * @param   reaction_type	ANV^Cv(JUDGE_REACTION_ICON_???)
 */
//--------------------------------------------------------------
void AT_JudgeReactionIconON(ACTIN_SYSTEM_PARAM *sys, int judge_no, int reaction_type)
{
	GF_ASSERT(sys->judge_reaction_icon_cap != NULL);

	CATS_ObjectPosSetCap(sys->judge_reaction_icon_cap, 
		JudgeReactionIconPos[judge_no].x, JudgeReactionIconPos[judge_no].y);
	CATS_ObjectAnimeSeqSetCap(sys->judge_reaction_icon_cap, reaction_type);
	CATS_ObjectEnableCap(sys->judge_reaction_icon_cap, CATS_ENABLE_TRUE);
	
	switch(reaction_type){
	case JUDGE_REACTION_ICON_NOMINATION:
		Snd_SePlay(ASE_ICON_NOMINATION);
		break;
	case JUDGE_REACTION_ICON_WEAR:
		Snd_SePlay(ASE_ICON_WEAR);
		break;
	case JUDGE_REACTION_ICON_VOLTAGE:
		Snd_SePlay(ASE_ICON_VOLTAGE);
		break;
	case JUDGE_REACTION_ICON_VOLTAGE_MAX:
		Snd_SePlay(ASE_ICON_VOLTAGE_MAX);
		break;
	}
}

//--------------------------------------------------------------
/**
 * @brief   RANVACR\OFF
 * @param   sys		Z̓VXe[Nւ̃|C^
 */
//--------------------------------------------------------------
void AT_JudgeReactionIconOFF(ACTIN_SYSTEM_PARAM *sys)
{
	GF_ASSERT(sys->judge_reaction_icon_cap != NULL);

	CATS_ObjectEnableCap(sys->judge_reaction_icon_cap, CATS_ENABLE_FALSE);
}

//--------------------------------------------------------------
/**
 * @brief   RANV삳
 *
 * @param   apw				Z͕Ǘ[Nւ̃|C^
 * @param   judge_no		RNo
 * @param   reaction_type	ANV^Cv(JUDGE_REACTION_ICON_???)
 * @param   end_flag		ITRUE
 */
//--------------------------------------------------------------
void AT_JudgeReactionMoveTaskSet(ACTIN_PROC_WORK *apw, int judge_no, 
	int reaction_type, u8 *end_flag)
{
	JUDGE_REACTION_MOVE_WORK *jrmw;
	
	jrmw = sys_AllocMemory(HEAPID_ACTIN, sizeof(JUDGE_REACTION_MOVE_WORK));
	MI_CpuClear8(jrmw, sizeof(JUDGE_REACTION_MOVE_WORK));
	
	*end_flag = FALSE;
	jrmw->end_flag = end_flag;
	jrmw->apw = apw;
	jrmw->judge_no = judge_no;
	
	CATS_ObjectPosGetCap(apw->sys.judge_cap[judge_no], &jrmw->start_x, &jrmw->start_y);
	
	switch(reaction_type){
	case JUDGE_REACTION_ICON_NOMINATION:
		//TCB_Add(JudgeReactionMove_Nomination, jrmw, TCBPRI_ACTIN_EFFECT);
		jrmw->loop = 1;
		jrmw->jump.up_power = -JUDGE_JUMP_NOMINATION_POWER;
		jrmw->jump.backup_up_power = -JUDGE_JUMP_NOMINATION_POWER;
		TCB_Add(JudgeReactionMove_Jump, jrmw, TCBPRI_ACTIN_EFFECT);
		break;
	case JUDGE_REACTION_ICON_WEAR:
		TCB_Add(JudgeReactionMove_Wear, jrmw, TCBPRI_ACTIN_EFFECT);
		break;
	case JUDGE_REACTION_ICON_VOLTAGE:
		jrmw->jump.up_power = -JUDGE_JUMP_VOLTAGE_UP_POWER;
		TCB_Add(JudgeReactionMove_Jump, jrmw, TCBPRI_ACTIN_EFFECT);
		break;
	case JUDGE_REACTION_ICON_VOLTAGE_MAX:
	default:
		jrmw->jump.up_power = -JUDGE_JUMP_VOLTAGE_MAX_UP_POWER;
		TCB_Add(JudgeReactionMove_Jump, jrmw, TCBPRI_ACTIN_EFFECT);
		break;
	}
}

//--------------------------------------------------------------
/**
 * @brief   RANVFw
 * @param   tcb			TCBւ̃|C^
 * @param   work		RANV샏[Nւ̃|C^
 */
//--------------------------------------------------------------
static void JudgeReactionMove_Nomination(TCB_PTR tcb, void *work)
{
	JUDGE_REACTION_MOVE_WORK *jrmw = work;
	
	switch(jrmw->seq){
	case 0:
		jrmw->x = jrmw->start_x * 0x0100;
		jrmw->y = jrmw->start_y * 0x0100;
		jrmw->seq++;
		//break;
	case 1:
	case 3:
		jrmw->y -= JUDGE_NOMINATION_ADD_Y;
		jrmw->loop++;
		if(jrmw->loop > JUDGE_NOMINATION_LOOP){
			jrmw->loop = 0;
			jrmw->seq++;
		}
		break;
	case 2:
	case 4:
		jrmw->y += JUDGE_NOMINATION_ADD_Y;
		jrmw->loop++;
		if(jrmw->loop > JUDGE_NOMINATION_LOOP){
			jrmw->loop = 0;
			jrmw->y = jrmw->start_y * 0x0100;
			jrmw->seq++;
		}
		break;
	default:
		*(jrmw->end_flag) = TRUE;
		sys_FreeMemoryEz(work);
		TCB_Delete(tcb);
		return;
	}
	CATS_ObjectPosSetCap(jrmw->apw->sys.judge_cap[jrmw->judge_no], 
		jrmw->x / 0x0100, jrmw->y / 0x0100);
}

//--------------------------------------------------------------
/**
 * @brief   RANVF
 * @param   tcb			TCBւ̃|C^
 * @param   work		RANV샏[Nւ̃|C^
 */
//--------------------------------------------------------------
static void JudgeReactionMove_Wear(TCB_PTR tcb, void *work)
{
	JUDGE_REACTION_MOVE_WORK *jrmw = work;
	
	switch(jrmw->seq){
	case 0:
		jrmw->x = jrmw->start_x * 0x0100;
		jrmw->y = jrmw->start_y * 0x0100;
		jrmw->seq++;
		//break;
	case 1:
		if(jrmw->loop & 1){
			jrmw->x = jrmw->start_x * 0x0100 + JUDGE_WEAR_ADD_X;
		}
		else{
			jrmw->x = jrmw->start_x * 0x0100 - JUDGE_WEAR_ADD_X;
		}

		jrmw->loop++;
		if(jrmw->loop > JUDGE_WEAR_LOOP){
			jrmw->x = jrmw->start_x * 0x0100;
			jrmw->loop = 0;
			jrmw->seq++;
		}
		break;
	case 2:
		jrmw->wait++;
		if(jrmw->wait > 15){
			jrmw->wait = 0;
			jrmw->seq++;
		}
		break;
	default:
		*(jrmw->end_flag) = TRUE;
		sys_FreeMemoryEz(work);
		TCB_Delete(tcb);
		return;
	}
	CATS_ObjectPosSetCap(jrmw->apw->sys.judge_cap[jrmw->judge_no], 
		jrmw->x / 0x0100, jrmw->y / 0x0100);
}

//--------------------------------------------------------------
/**
 * @brief   RANVFWv({e[WA{e[WMAX)
 * @param   tcb			TCBւ̃|C^
 * @param   work		RANV샏[Nւ̃|C^
 */
//--------------------------------------------------------------
static void JudgeReactionMove_Jump(TCB_PTR tcb, void *work)
{
	JUDGE_REACTION_MOVE_WORK *jrmw = work;
	
	switch(jrmw->seq){
	case 0:
		jrmw->x = jrmw->start_x * 0x0100;
		jrmw->y = jrmw->start_y * 0x0100;
		jrmw->seq++;
		//break;
	case 1:
		jrmw->y += jrmw->jump.up_power;
		jrmw->jump.up_power += JUDGE_JUMP_GRAVITY;
		if(jrmw->y >= jrmw->start_y * 0x0100){
			jrmw->y = jrmw->start_y * 0x0100;
			if(jrmw->loop > 0){
				jrmw->jump.up_power = jrmw->jump.backup_up_power;
				jrmw->loop--;
				jrmw->seq--;
			}
			else{
				jrmw->seq++;
			}
		}
		CATS_ObjectPosSetCap(jrmw->apw->sys.judge_cap[jrmw->judge_no], 
			jrmw->x / 0x0100, jrmw->y / 0x0100);
		break;
	default:
		*(jrmw->end_flag) = TRUE;
		sys_FreeMemoryEz(work);
		TCB_Delete(tcb);
		return;
	}
}

//--------------------------------------------------------------
/**
 * @brief   ʐRɂn[gAN^[𐶐
 *
 * @param   sys				Z̓VXe\̂ւ̃|C^
 * @param   judge_no		RNO
 */
//--------------------------------------------------------------
void AT_SpecialHeartSet(ACTIN_SYSTEM_PARAM *sys, int judge_no)
{
	GF_ASSERT(sys->special_heart_cap == NULL);
	
	//\[Xǂݍ
	//pbg͏풓pbggp̂Ń[hȂ
	CATS_LoadResourceCharArc(sys->csp, sys->crp, ARC_CONTEST_OBJ, 
		HEART16_NCGR_BIN, 1, 
		NNS_G2D_VRAM_TYPE_2DMAIN, CHARID_SPECIAL_HEART);
	CATS_LoadResourceCellArc(sys->csp, sys->crp, ARC_CONTEST_OBJ, 
		HEART16_NCER_BIN, 1, 
		CELLID_SPECIAL_HEART);
	CATS_LoadResourceCellAnmArc(sys->csp, sys->crp, ARC_CONTEST_OBJ, 
		HEART16_NANR_BIN, 1, CELLANMID_SPECIAL_HEART);
	
	//AN^[
	sys->special_heart_cap = CATS_ObjectAdd_S(sys->csp, sys->crp, &SpecialHeartObjParam);
	CATS_ObjectUpdate(sys->special_heart_cap->act);
	CATS_ObjectPosSetCap(sys->special_heart_cap, 
		SPECIAL_HEART_POS_X + SPECIAL_HEART_POS_X_SPACE * judge_no, SPECIAL_HEART_POS_Y);
}

//--------------------------------------------------------------
/**
 * @brief   ʐRɂn[g폜
 *
 * @param   sys		Z̓VXe\̂ւ̃|C^
 */
//--------------------------------------------------------------
void AT_SpecialHeartDel(ACTIN_SYSTEM_PARAM *sys)
{
	//-- \[X폜 --//
	//pbg͏풓pbgȂ̂ō폜Ȃ
	CATS_FreeResourceChar(sys->crp, CHARID_SPECIAL_HEART);
	CATS_FreeResourceCell(sys->crp, CELLID_SPECIAL_HEART);
	CATS_FreeResourceCellAnm(sys->crp, CELLANMID_SPECIAL_HEART);
	
	//-- AN^[폜 --//
	CATS_ActorPointerDelete_S(sys->special_heart_cap);
	sys->special_heart_cap = NULL;
}

//--------------------------------------------------------------
/**
 * @brief   As[|Cg̃\[X[h
 *
 * @param   csp
 * @param   crp
 */
//--------------------------------------------------------------
void AT_AppealPointResourceLoad(CATS_SYS_PTR csp, CATS_RES_PTR crp)
{
	//pbg͏풓pbggp̂Ń[hȂ
	CATS_LoadResourceCharArc(csp, crp, ARC_CONTEST_OBJ, 
		HEART8_NCGR_BIN, 1, 
		NNS_G2D_VRAM_TYPE_2DMAIN, CHARID_APPEAL_POINT);
	CATS_LoadResourceCellArc(csp, crp, ARC_CONTEST_OBJ, 
		HEART8_NCER_BIN, 1, 
		CELLID_APPEAL_POINT);
	CATS_LoadResourceCellAnmArc(csp, crp, ARC_CONTEST_OBJ, 
		HEART8_NANR_BIN, 1, CELLANMID_APPEAL_POINT);
}

//--------------------------------------------------------------
/**
 * @brief   As[|Cg̃\[X
 *
 * @param   crp		
 */
//--------------------------------------------------------------
void AT_AppealPointResourceFree(CATS_RES_PTR crp)
{
	//pbg͏풓pbgȂ̂ō폜Ȃ
	CATS_FreeResourceChar(crp, CHARID_APPEAL_POINT);
	CATS_FreeResourceCell(crp, CELLID_APPEAL_POINT);
	CATS_FreeResourceCellAnm(crp, CELLANMID_APPEAL_POINT);
}

//--------------------------------------------------------------
/**
 * @brief   As[ACR폜
 *
 * @param   sys				Z̓VXe\̂ւ̃|C^
 * @param   breeder_no		u[_[No
 * @param   act_pos			AN^[[Nʒu
 */
//--------------------------------------------------------------
static inline void AppealPointActorDel(ACTIN_SYSTEM_PARAM *sys, int breeder_no, int act_pos)
{
	if(sys->appeal_point_cap[breeder_no][act_pos] != NULL){
		CATS_ActorPointerDelete_S(sys->appeal_point_cap[breeder_no][act_pos]);
		sys->appeal_point_cap[breeder_no][act_pos] = NULL;
	}
}

//--------------------------------------------------------------
/**
 * @brief   w肵u[_[As[|CgACRSč폜
 *
 * @param   sys				Z̓VXe\̂ւ̃|C^
 * @param   breeder_no		u[_[NO
 */
//--------------------------------------------------------------
static void AT_AppealPointActorBreederDel(ACTIN_SYSTEM_PARAM *sys, int breeder_no)
{
	int i;
	
	for(i = 0; i < APPEAL_POINT_ICON_MAX; i++){
		AppealPointActorDel(sys, breeder_no, i);
	}
}

//--------------------------------------------------------------
/**
 * @brief   SẴAs[|CgACR폜
 * @param   sys		Z̓VXe\̂ւ̃|C^
 */
//--------------------------------------------------------------
void AT_AppealPointActorDelAll(ACTIN_SYSTEM_PARAM *sys)
{
	int breeder;
	
	for(breeder = 0; breeder < BREEDER_MAX; breeder++){
		AT_AppealPointActorBreederDel(sys, breeder);
	}
}

//--------------------------------------------------------------
/**
 * @brief   As[|CgACR𐶐
 *
 * @param   csp		
 * @param   crp		
 * @param   x		\WX
 * @param   y		\WY
 *
 * @retval  AN^[ւ̃|C^
 */
//--------------------------------------------------------------
static CATS_ACT_PTR AT_AppealPointActorSet(CATS_SYS_PTR csp, CATS_RES_PTR crp, int x, int y)
{
	CATS_ACT_PTR app_cap;
	
	//AN^[
	app_cap = CATS_ObjectAdd_S(csp, crp, &AppealPointObjParam);
	CATS_ObjectUpdate(app_cap->act);
	CATS_ObjectPosSetCap(app_cap, x, y);
	
	return app_cap;
}

//--------------------------------------------------------------
/**
 * @brief   ̃u[_[As[|CgACRSč폜A
 *          |CgACR蒼
 *
 * @param   sys				Z̓VXe\̂ւ̃|C^
 * @param   breeder_no		u[_[ԍ
 * @param   breeder_pos		u[_[ʒu
 * @param   point			\As[|Cg
 */
//--------------------------------------------------------------
void AT_AppealPointActorMadeOver(ACTIN_SYSTEM_PARAM *sys, int breeder_no, 
	int breeder_pos, int point)
{
	int icon_num, i, icon_pos;
	
	icon_num = point / APPEAL_ICON_ONE_POINT;
//	GF_ASSERT(icon_num <= APPEAL_POINT_ICON_MAX);
	if(icon_num > APPEAL_POINT_ICON_MAX * APPEAL_POINT_ICON_LOOP){
		icon_num = APPEAL_POINT_ICON_MAX * APPEAL_POINT_ICON_LOOP;
		OS_TPrintf("---As[|CgACR̕\ő吔𒴂Ă܂II---\n");
	}
	
	//KvȃACR̐ȏ̃ACRoĂꍇ͂폜
	for(i = icon_num; i < APPEAL_POINT_ICON_MAX; i++){
		AppealPointActorDel(sys, breeder_no, i);
	}
	//KvȏԈُ2TڃAjsĂꍇ̓Aj؂ւ
	for(i = icon_num; i < APPEAL_POINT_ICON_MAX * APPEAL_POINT_ICON_LOOP; i++){
		if(i < APPEAL_POINT_ICON_MAX){
			continue;
		}
		icon_pos = i - APPEAL_POINT_ICON_MAX;
		if(sys->appeal_point_cap[breeder_no][icon_pos] != NULL){
			if(CATS_ObjectAnimeSeqGetCap(sys->appeal_point_cap[breeder_no][icon_pos]) > 0){
				CATS_ObjectAnimeSeqSetCap(sys->appeal_point_cap[breeder_no][icon_pos], 0);
			}
		}
	}
	
	//|Cg܂ł̃ACR
	for(i = 0; i < icon_num; i++){
		if(i < APPEAL_POINT_ICON_MAX){
			icon_pos = i;
			if(sys->appeal_point_cap[breeder_no][icon_pos] == NULL){
				sys->appeal_point_cap[breeder_no][icon_pos] = AT_AppealPointActorSet(sys->csp, 
					sys->crp, AppealPointPos[breeder_pos][0] + icon_pos*8, 
					AppealPointPos[breeder_pos][1]);
				AppealPointAppearEffectSet(sys->appeal_point_cap[breeder_no][icon_pos]);
			}
		}
		else{
			icon_pos = i - APPEAL_POINT_ICON_MAX;
			if(sys->appeal_point_cap[breeder_no][icon_pos] == NULL){
				sys->appeal_point_cap[breeder_no][icon_pos] = AT_AppealPointActorSet(sys->csp, 
					sys->crp, AppealPointPos[breeder_pos][0] + icon_pos*8, 
					AppealPointPos[breeder_pos][1]);
			}
			if(CATS_ObjectAnimeSeqGetCap(sys->appeal_point_cap[breeder_no][icon_pos]) == 0){
				CATS_ObjectAnimeSeqSetCap(sys->appeal_point_cap[breeder_no][icon_pos], 1);
				AppealPointAppearEffectSet(sys->appeal_point_cap[breeder_no][icon_pos]);
			}
		}
	}
}

//--------------------------------------------------------------
/**
 * @brief   As[ACRoGtFNg^XN𐶐
 * @param   cap		As[ACR̃|C^
 */
//--------------------------------------------------------------
static void AppealPointAppearEffectSet(CATS_ACT_PTR cap)
{
	APPEAL_POINT_APPEAR_WORK *apaw;
	
	apaw = sys_AllocMemory(HEAPID_ACTIN, sizeof(APPEAL_POINT_APPEAR_WORK));
	MI_CpuClear8(apaw, sizeof(APPEAL_POINT_APPEAR_WORK));
	apaw->cap = cap;
	CATS_ObjectEnableCap(cap, CATS_ENABLE_FALSE);
	TCB_Add(AppealPointAppear, apaw, TCBPRI_ACTIN_EFFECT);
}

//--------------------------------------------------------------
/**
 * @brief   As[ACRoGtFNgC^XN
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		APPEAL_POINT_APPEAR_WORK\
 */
//--------------------------------------------------------------
static void AppealPointAppear(TCB_PTR tcb, void *work)
{
	APPEAL_POINT_APPEAR_WORK *apaw = work;
	
	switch(apaw->seq){
	case 0:
		CATS_ObjectAffineSetCap(apaw->cap, CLACT_AFFINE_DOUBLE);
		apaw->sx = APICON_EFF_INIT_SCALE;
		apaw->sy = APICON_EFF_INIT_SCALE;
		CATS_ObjectEnableCap(apaw->cap, CATS_ENABLE_TRUE);
//		CATS_ObjectScaleSetCap(apaw->cap, 1.4f, 1.4f);
		apaw->seq++;
		//break;
	case 1:
		apaw->sx += APICON_EFF_ADD_SCALE;
		apaw->sy += APICON_EFF_ADD_SCALE;
		CATS_ObjectScaleSetCap(apaw->cap, apaw->sx, apaw->sy);
		CATS_ObjectRotationAddCap(apaw->cap, APICON_EFF_ADD_ROTATION);
		if(apaw->sx >= APICON_EFF_MAX_SCALE){
			apaw->seq++;
		}
		break;
	case 2:
		apaw->sx -= APICON_EFF_ADD_SCALE;
		apaw->sy -= APICON_EFF_ADD_SCALE;
		CATS_ObjectScaleSetCap(apaw->cap, apaw->sx, apaw->sy);
		CATS_ObjectRotationAddCap(apaw->cap, APICON_EFF_ADD_ROTATION);
		if(apaw->sx <= APICON_EFF_NORMAL_SCALE){
			CATS_ObjectScaleSetCap(apaw->cap, APICON_EFF_NORMAL_SCALE, APICON_EFF_NORMAL_SCALE);
			CATS_ObjectRotationSetCap(apaw->cap, 0);
			apaw->seq++;
		}
		break;
	default:
		CATS_ObjectAffineSetCap(apaw->cap, CLACT_AFFINE_NONE);
		sys_FreeMemoryEz(work);
		TCB_Delete(tcb);
		return;
	}
}

//--------------------------------------------------------------
/**
 * @brief   {e[W|Cg̃\[X[h
 *
 * @param   csp
 * @param   crp
 */
//--------------------------------------------------------------
void AT_VoltagePointResourceLoad(CATS_SYS_PTR csp, CATS_RES_PTR crp)
{
	//pbg͏풓pbggp̂Ń[hȂ
	CATS_LoadResourceCharArc(csp, crp, ARC_CONTEST_OBJ, 
		VOLTAGE8_NCGR_BIN, 1, 
		NNS_G2D_VRAM_TYPE_2DMAIN, CHARID_VOLTAGE_POINT);
	CATS_LoadResourceCellArc(csp, crp, ARC_CONTEST_OBJ, 
		VOLTAGE8_NCER_BIN, 1, 
		CELLID_VOLTAGE_POINT);
	CATS_LoadResourceCellAnmArc(csp, crp, ARC_CONTEST_OBJ, 
		VOLTAGE8_NANR_BIN, 1, CELLANMID_VOLTAGE_POINT);

	//{e[Wo
	CATS_LoadResourceCharArc(csp, crp, ARC_CONTEST_OBJ, 
		STAR16_NCGR_BIN, 1, 
		NNS_G2D_VRAM_TYPE_2DMAIN, CHARID_VOLTAGE_EFF);
	CATS_LoadResourceCellArc(csp, crp, ARC_CONTEST_OBJ, 
		STAR16_NCER_BIN, 1, 
		CELLID_VOLTAGE_EFF);
	CATS_LoadResourceCellAnmArc(csp, crp, ARC_CONTEST_OBJ, 
		STAR16_NANR_BIN, 1, CELLANMID_VOLTAGE_EFF);
}

//--------------------------------------------------------------
/**
 * @brief   {e[W|Cg̃\[X
 *
 * @param   crp		
 */
//--------------------------------------------------------------
void AT_VoltagePointResourceFree(CATS_RES_PTR crp)
{
	//pbg͏풓pbgȂ̂ō폜Ȃ
	CATS_FreeResourceChar(crp, CHARID_VOLTAGE_POINT);
	CATS_FreeResourceCell(crp, CELLID_VOLTAGE_POINT);
	CATS_FreeResourceCellAnm(crp, CELLANMID_VOLTAGE_POINT);

	//{e[Wo
	CATS_FreeResourceChar(crp, CHARID_VOLTAGE_EFF);
	CATS_FreeResourceCell(crp, CELLID_VOLTAGE_EFF);
	CATS_FreeResourceCellAnm(crp, CELLANMID_VOLTAGE_EFF);
}

//--------------------------------------------------------------
/**
 * @brief   {e[WACR̒Pƍ폜
 *
 * @param   sys				Z̓VXe\̂ւ̃|C^
 * @param   judge_no		RNo
 * @param   icon_pos		ACR̈ʒu
 */
//--------------------------------------------------------------
static inline void AT_VoltagePointActorDel(ACTIN_SYSTEM_PARAM *sys, int judge_no, int icon_pos)
{
	CATS_ActorPointerDelete_S(sys->voltage_point_cap[judge_no][icon_pos]);
	sys->voltage_point_cap[judge_no][icon_pos] = NULL;
}

//--------------------------------------------------------------
/**
 * @brief   w肵R{e[W|CgACRSč폜
 *
 * @param   sys				Z̓VXe\̂ւ̃|C^
 * @param   judge_no		RNo
 */
//--------------------------------------------------------------
static void AT_VoltagePointActorJudgeDel(ACTIN_SYSTEM_PARAM *sys, int judge_no)
{
	int i;
	
	for(i = 0; i < VOLTAGE_MAX; i++){
		if(sys->voltage_point_cap[judge_no][i] != NULL){
			AT_VoltagePointActorDel(sys, judge_no, i);
		}
	}
}

//--------------------------------------------------------------
/**
 * @brief   SẴ{e[W|CgACR폜
 * @param   sys		Z̓VXe\̂ւ̃|C^
 */
//--------------------------------------------------------------
void AT_VoltagePointActorDelAll(ACTIN_SYSTEM_PARAM *sys)
{
	int judge;
	
	for(judge = 0; judge < JUDGE_MAX; judge++){
		AT_VoltagePointActorJudgeDel(sys, judge);
	}
}

//--------------------------------------------------------------
/**
 * @brief   {e[W|CgACR𐶐
 *
 * @param   csp		
 * @param   crp		
 * @param   x		\WX
 * @param   y		\WY
 *
 * @retval  AN^[ւ̃|C^
 */
//--------------------------------------------------------------
static CATS_ACT_PTR AT_VoltagePointActorSet(CATS_SYS_PTR csp, CATS_RES_PTR crp, int x, int y)
{
	CATS_ACT_PTR app_cap;
	
	//AN^[
	app_cap = CATS_ObjectAdd_S(csp, crp, &VoltagePointObjParam);
	CATS_ObjectUpdate(app_cap->act);
	CATS_ObjectPosSetCap(app_cap, x, y);
	
	return app_cap;
}

//--------------------------------------------------------------
/**
 * @brief   {e[WoACR𐶐
 *
 * @param   csp		
 * @param   crp		
 * @param   x		\WX
 * @param   y		\WY
 *
 * @retval  AN^[ւ̃|C^
 */
//--------------------------------------------------------------
static CATS_ACT_PTR AT_VoltageEffectActorSet(CATS_SYS_PTR csp, CATS_RES_PTR crp, int x, int y)
{
	CATS_ACT_PTR cap;
	
	//AN^[
	cap = CATS_ObjectAdd_S(csp, crp, &VoltageEffectObjParam);
	CATS_ObjectUpdate(cap->act);
	CATS_ObjectPosSetCap(cap, x, y);
	
	return cap;
}

//--------------------------------------------------------------
/**
 * @brief   {e[WoFC^XN
 * @param   tcb			TCBւ̃|C^
 * @param   work		VOLTAGE_MOVE_WORK\
 */
//--------------------------------------------------------------
static void VoltagePointActorMove(TCB_PTR tcb, void *work)
{
	VOLTAGE_MOVE_WORK *vmw = work;
	
	switch(vmw->seq){
	case 0:
		CATS_ObjectAffineSetCap(vmw->cap, CLACT_AFFINE_NORMAL);
		
		vmw->move_end_x = vmw->x + (32<<8);
		vmw->move_end_y = vmw->y + (72<<8);
		vmw->add_x = (vmw->move_end_x - vmw->x) / VOLTAGE_MOVE_FIRST_FRAME;
		vmw->add_y = (vmw->move_end_y - vmw->y) / VOLTAGE_MOVE_FIRST_FRAME;
		vmw->seq++;
		//break;
	case 1:
		vmw->x += vmw->add_x;
		vmw->y += vmw->add_y;
		if((vmw->add_x > 0 && vmw->x >= vmw->move_end_x)
				|| (vmw->add_x < 0 && vmw->x <= vmw->move_end_x)){
			vmw->seq++;
		}
		break;
	case 2:
		vmw->wait++;
		if(vmw->wait > VOLTAGE_MOVE_FIRST_WAIT){
			vmw->wait = 0;
			vmw->seq++;
		}
		break;
	case 3:
		vmw->move_end_x = vmw->end_x << 8;
		vmw->move_end_y = vmw->end_y << 8;
		vmw->add_x = (vmw->move_end_x - vmw->x) / VOLTAGE_MOVE_END_FRAME;
		vmw->add_y = (vmw->move_end_y - vmw->y) / VOLTAGE_MOVE_END_FRAME;
		vmw->seq++;
		//break;
	case 4:
		vmw->x += vmw->add_x;
		vmw->y += vmw->add_y;
		if((vmw->add_x > 0 && vmw->x >= vmw->move_end_x)
				|| (vmw->add_x < 0 && vmw->x <= vmw->move_end_x)){
			vmw->x = vmw->end_x << 8;
			vmw->y = vmw->end_y << 8;
			vmw->seq++;
		}
		break;
	case 5:
		vmw->wait++;
		if(vmw->wait > VOLTAGE_MOVE_END_WAIT){
			vmw->wait = 0;
			vmw->seq++;
		}
		break;
	default:
		CATS_ActorPointerDelete_S(vmw->cap);

		CATS_ObjectEnableCap(vmw->voltage_cap, CATS_ENABLE_TRUE);
		
		Snd_SePlay(ASE_VOLTAGE_UP);

		sys_FreeMemoryEz(work);
		TCB_Delete(tcb);
		return;
	}
	
	CATS_ObjectRotationAddCap(vmw->cap, VOLTAGE_MOVE_ADD_ROTATION);
	CATS_ObjectPosSetCap(vmw->cap, vmw->x / 0x0100, vmw->y / 0x0100);
}

//--------------------------------------------------------------
/**
 * @brief   {e[WړGtFNgIĂ邩mF
 *
 * @param   sys				Z̓VXe[Nւ̃|C^
 * @param   judge_no		Rԍ
 *
 * @retval  TRUE:IB@FALSE:쒆̃GtFNg
 */
//--------------------------------------------------------------
BOOL AT_VoltageMoveEffectEndCheck(ACTIN_SYSTEM_PARAM *sys, int judge_no)
{
	int i;
	
	for(i = 0; i < VOLTAGE_MAX; i++){
		if(sys->voltage_point_cap[judge_no][i] != NULL){
			if(CATS_ObjectEnableGetCap(sys->voltage_point_cap[judge_no][i]) == CATS_ENABLE_FALSE){
				return FALSE;
			}
		}
	}
	return TRUE;
}

//--------------------------------------------------------------
/**
 * @brief   |Cg܂ł̃{e[WACR쐬
 * 			ɐĂACR|CgɒBĂȂΒǉōA
 *          tɑĂȂ΁A͍̕폜
 *
 * @param   sys				Z̓VXe\̂ւ̃|C^
 * @param   judge_no		Rԍ
 * @param   point			\{e[W|Cg
 */
//--------------------------------------------------------------
void AT_VoltagePointActorMadeOver(ACTIN_SYSTEM_PARAM *sys, int judge_no, int point)
{
	int icon_num, i;
	VOLTAGE_MOVE_WORK *vmw;
	
	icon_num = point / VOLTAGE_ONE_POINT;
	GF_ASSERT(icon_num <= VOLTAGE_MAX);
	
	//|Cg̃ACR
	for(i = 0; i < icon_num; i++){
		if(sys->voltage_point_cap[judge_no][i] == NULL){
			sys->voltage_point_cap[judge_no][i] = AT_VoltagePointActorSet(sys->csp, sys->crp, 
				VoltagePointPos[judge_no][0] + i*VOLTAGE_SPACE_X, 
				VoltagePointPos[judge_no][1]);
			CATS_ObjectEnableCap(sys->voltage_point_cap[judge_no][i], CATS_ENABLE_FALSE);

			//ڂe[Wo
			vmw = sys_AllocMemory(HEAPID_ACTIN, sizeof(VOLTAGE_MOVE_WORK));
			MI_CpuClear8(vmw, sizeof(VOLTAGE_MOVE_WORK));
			vmw->sys = sys;
			vmw->voltage_cap = sys->voltage_point_cap[judge_no][i];
			vmw->cap = AT_VoltageEffectActorSet(sys->csp, sys->crp, 
				JudgeReactionIconPos[judge_no].x, JudgeReactionIconPos[judge_no].y);
			vmw->x = JudgeReactionIconPos[judge_no].x << 8;
			vmw->y = JudgeReactionIconPos[judge_no].y << 8;
			vmw->end_x = VoltagePointPos[judge_no][0] + i*VOLTAGE_SPACE_X;
			vmw->end_y = VoltagePointPos[judge_no][1];
			vmw->judge_no = judge_no;
			vmw->point = point;
			TCB_Add(VoltagePointActorMove, vmw, TCBPRI_ACTIN_EFFECT);
		}
	}
	//|Cg葽ACRĂꍇ͍폜
	for( ; i < VOLTAGE_MAX; i++){
		if(sys->voltage_point_cap[judge_no][i] != NULL){
			AT_VoltagePointActorDel(sys, judge_no, i);
		}
	}
}

//--------------------------------------------------------------
/**
 * @brief   bEBhEAXCh̃Jo[OBJ𐶐
 * @param   sys		Z̓VXe\̂ւ̃|C^
 */
//--------------------------------------------------------------
void AT_TalkWinSlideCoverOBJSet(ACTIN_SYSTEM_PARAM *sys)
{
	int scr_x;
	u16 *scrnbuf;
	int i, obj_palno;
	CATS_SYS_PTR csp;
	CATS_RES_PTR crp;
	
	csp = sys->csp;
	crp = sys->crp;
	
	scr_x = GF_BGL_ScrollGetX(sys->bgl, ACTIN_FRAME_WIN);
	scrnbuf = GF_BGL_ScreenAdrsGet(sys->bgl, ACTIN_FRAME_WIN);
	if(scr_x == 0){
		scrnbuf = &scrnbuf[WINSLIDE_SCRN_POS_BEFORE];
	}
	else{
		scrnbuf = &scrnbuf[WINSLIDE_SCRN_POS_AFTER];
	}
	
	//\[Xo^
	CATS_LoadResourceCharArc(csp, crp, ARC_CONTEST_OBJ, SPACE_64K_8X16_NCGR_BIN, 1, 
		NNS_G2D_VRAM_TYPE_2DMAIN, CHARID_WIN_COVER_0);
	CATS_LoadResourceCharArc(csp, crp, ARC_CONTEST_OBJ, SPACE_64K_8X16_NCGR_BIN, 1, 
		NNS_G2D_VRAM_TYPE_2DMAIN, CHARID_WIN_COVER_1);
	CATS_LoadResourceCharArc(csp, crp, ARC_CONTEST_OBJ, SPACE_64K_8X16_NCGR_BIN, 1, 
		NNS_G2D_VRAM_TYPE_2DMAIN, CHARID_WIN_COVER_2);
	obj_palno = CATS_LoadResourcePlttWorkArc(sys->pfd, FADE_MAIN_OBJ, csp, crp, 
		ARC_CONTEST_OBJ, CONTEST_OBJ_NCLR, 0, 
		1, NNS_G2D_VRAM_TYPE_2DMAIN, PLTTID_WIN_COVER);
	CATS_LoadResourceCellArc(csp, crp, ARC_CONTEST_OBJ, SPACE_64K_8X16_NCER_BIN, 1, 
		CELLID_WIN_COVER);
	CATS_LoadResourceCellAnmArc(csp, crp, ARC_CONTEST_OBJ, 
		SPACE_64K_8X16_NANR_BIN, 1, CELLANMID_WIN_COVER);

	//AN^[
	{
		TCATS_OBJECT_ADD_PARAM_S head;
		
		head = WinCoverObjParam;
		for(i = 0; i < WINCOVER_ACT_MAX; i++){
			GF_ASSERT(sys->wincover_cap[i] == NULL);
			sys->wincover_cap[i] = CATS_ObjectAdd_S(csp, crp, &head);
			CATS_ObjectPosSetCap(sys->wincover_cap[i], 0x1f * 8 + 4, 0x13 * 8 + i * 16);
			head.id[CLACT_U_CHAR_RES]++;
		}
	}
	
	//XN[ŎgpĂLN^ǂݎOBJVRAMփRs[
	{
		void *obj_vram;
		NNSG2dImageProxy * image;
		u8 *bgchar;
		u8 *bgchar_vram;
		int k = 0;
		
		obj_vram = G2_GetOBJCharPtr();
		bgchar_vram = GF_BGL_CgxGet(ACTIN_FRAME_WIN);
		for(i = 0; i < WINCOVER_ACT_MAX; i++){
			image = CLACT_ImageProxyGet(sys->wincover_cap[i]->act);
			
			bgchar = &bgchar_vram[32 * (scrnbuf[k * 32] & 1023)];
			MI_CpuCopy16(bgchar, (void*)((u32)obj_vram 
				+ image->vramLocation.baseAddrOfVram[NNS_G2D_VRAM_TYPE_2DMAIN]), 0x20);
			k++;

			bgchar = &bgchar_vram[32 * (scrnbuf[k * 32] & 1023)];
			MI_CpuCopy16(bgchar, (void*)((u32)obj_vram 
				+ image->vramLocation.baseAddrOfVram[NNS_G2D_VRAM_TYPE_2DMAIN] + 0x20), 0x20);
			k++;
		}
	}
	
	//XN[ŎgpĂpbgǂݎOBJpbgփRs[
	{
		int palno;
		
		palno = (*scrnbuf) >> 12;
		PaletteWorkCopy(sys->pfd, FADE_MAIN_BG, palno * 16, 
			FADE_MAIN_OBJ, obj_palno * 16, 0x20);
	}
}

//--------------------------------------------------------------
/**
 * @brief   bEBhEAXCh̃Jo[OBJ폜
 * @param   sys		Z̓VXe\̂ւ̃|C^
 */
//--------------------------------------------------------------
void AT_TalkWinSlideCoverOBJDelete(ACTIN_SYSTEM_PARAM *sys)
{
	int i;
	CATS_RES_PTR crp;
	
	crp = sys->crp;
	
	//AN^[폜
	for(i = 0; i < WINCOVER_ACT_MAX; i++){
		CATS_ActorPointerDelete_S(sys->wincover_cap[i]);
		sys->wincover_cap[i] = NULL;
	}
	
	//\[X폜
	CATS_FreeResourceChar(crp, CHARID_WIN_COVER_0);
	CATS_FreeResourceChar(crp, CHARID_WIN_COVER_1);
	CATS_FreeResourceChar(crp, CHARID_WIN_COVER_2);
	CATS_FreeResourcePltt(crp, PLTTID_WIN_COVER);
	CATS_FreeResourceCell(crp, CELLID_WIN_COVER);
	CATS_FreeResourceCellAnm(crp, CELLANMID_WIN_COVER);
}

//--------------------------------------------------------------
/**
 * @brief   bEBhẼXN[XChpɕ`
 *
 * @param   sys				Z̓VXe\̂ւ̃|C^
 * @param   write_type		TALKWIN_SCREEN_WRITE_???
 */
//--------------------------------------------------------------
void AT_TalkWinScreenWrite(ACTIN_SYSTEM_PARAM *sys, int write_type)
{
	u16 *scrnbuf_before, *scrnbuf_after, *scrnbuf;
	int i;
	
	scrnbuf = GF_BGL_ScreenAdrsGet(sys->bgl, ACTIN_FRAME_WIN);
	scrnbuf_before = &scrnbuf[WINSLIDE_SCRN_POS_BEFORE];
	scrnbuf_after = &scrnbuf[WINSLIDE_SCRN_POS_AFTER];
	
	if(write_type == TALKWIN_SCREEN_WRITE_BEFORE){
		for(i = 0; i < 6; i++){
			scrnbuf_before[i * 32] = scrnbuf_before[i * 32 - 1];
		}
	}
	else{
		for(i = 0; i < 6; i++){
			scrnbuf_before[i * 32] = scrnbuf_after[i * 32];
		}
	}
	
	GF_BGL_LoadScreenV_Req(sys->bgl, ACTIN_FRAME_WIN);
}

//--------------------------------------------------------------
/**
 * @brief   bEBhEXCh^XN𐶐
 *
 * @param   sys				Z̓VXe\̂ւ̃|C^
 * @param   slide_dir		XCh(TALKWIN_SLIDE_DIR_???)
 * @param   end_flag		XCh̏Im点郏[Nւ̃|C^(ITRUEZbg܂)
 */
//--------------------------------------------------------------
void AT_TalkWinSlideTaskSet(ACTIN_SYSTEM_PARAM *sys, u8 slide_dir, u8 *end_flag)
{
	TALKWIN_SLIDE_WORK *tsw;
	
	*end_flag = FALSE;

	tsw = sys_AllocMemory(HEAPID_ACTIN, sizeof(TALKWIN_SLIDE_WORK));
	MI_CpuClear8(tsw, sizeof(TALKWIN_SLIDE_WORK));
	
	tsw->sys = sys;
	tsw->slide_dir = slide_dir;
	tsw->end_flag = end_flag;
	
	tsw->x = GF_BGL_ScrollGetX(sys->bgl, ACTIN_FRAME_WIN) << 8;
	
	AT_TalkWinSlideCoverOBJSet(sys);
	
	if(slide_dir == TALKWIN_SLIDE_DIR_OUT){
		AT_TalkWinScreenWrite(sys, TALKWIN_SCREEN_WRITE_BEFORE);
	}
	
	TCB_Add(TalkWinSlideInOutMain, tsw, TCBPRI_ACTIN_TALKWIN_SLIDE);
}

//--------------------------------------------------------------
/**
 * @brief   bEBhEXCh^XN
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		TALKWIN_SLIDE_WORK\
 */
//--------------------------------------------------------------
static void TalkWinSlideInOutMain(TCB_PTR tcb, void *work)
{
	TALKWIN_SLIDE_WORK *tsw = work;
	
	switch(tsw->seq){
	case 0:
		if(tsw->slide_dir == TALKWIN_SLIDE_DIR_OUT){
			tsw->x += TALKWIN_SLIDE_SPEED;
			if((tsw->x >> 8) >= TALKWIN_SLIDE_DOT_LEN){
				tsw->x = TALKWIN_SLIDE_DOT_LEN << 8;
				tsw->seq++;
			}
		}
		else{
			tsw->x -= TALKWIN_SLIDE_SPEED;
			if(tsw->x <= (FRAME_WIN_DEFAULT_X << 8)){
				tsw->x = FRAME_WIN_DEFAULT_X << 8;
				tsw->seq++;
			}
		}
		GF_BGL_ScrollReq(tsw->sys->bgl, ACTIN_FRAME_WIN, GF_BGL_SCROLL_X_SET, tsw->x >> 8);
		break;
	default:
		if(tsw->slide_dir == TALKWIN_SLIDE_DIR_IN){
			AT_TalkWinScreenWrite(tsw->sys, TALKWIN_SCREEN_WRITE_AFTER);
		}
		AT_TalkWinSlideCoverOBJDelete(tsw->sys);
		*(tsw->end_flag) = TRUE;
		sys_FreeMemoryEz(work);
		TCB_Delete(tcb);
		return;
	}
}

//--------------------------------------------------------------
/**
 * @brief   u[_[pl̏ɏĂOBJɑ΂āAOBJ[hZbg
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   on_off		m[}FGX_OAM_MODE_NORMALAFGX_OAM_MODE_XLU
 * @param   enable		TRUE:\B@FALSE:\
 */
//--------------------------------------------------------------
static void AT_PanelObjBrdModeSet(ACTIN_PROC_WORK *apw, GXOamMode obj_mode, int enable)
{
	int i, k;
	int cap_enable, fontoam_enable;
	
	if(enable == TRUE){
		cap_enable = CATS_ENABLE_TRUE;
		fontoam_enable = TRUE;
	}
	else{
		cap_enable = CATS_ENABLE_FALSE;
		fontoam_enable = FALSE;
	}
	
	for(i = 0; i < BREEDER_MAX; i++){
		//As[|Cg
		for(k = 0; k < APPEAL_POINT_ICON_MAX; k++){
			if(apw->sys.appeal_point_cap[i][k] != NULL){
				CATS_ObjectObjModeSetCap(apw->sys.appeal_point_cap[i][k], obj_mode);
				CATS_ObjectEnableCap(apw->sys.appeal_point_cap[i][k], cap_enable);
			}
		}
		//ACR
		if(apw->sys.nexticon_cap[i] != NULL){
			CATS_ObjectObjModeSetCap(apw->sys.nexticon_cap[i], obj_mode);
			CATS_ObjectEnableCap(apw->sys.nexticon_cap[i], cap_enable);
		}
		//jbNl[ƃu[_[
		FONTOAM_ObjModeSet(apw->sys.fontact_oya[i].fontoam, obj_mode);
		FONTOAM_ObjModeSet(apw->sys.fontact_nickname[i].fontoam, obj_mode);
		FONTOAM_SetDrawFlag(apw->sys.fontact_oya[i].fontoam, fontoam_enable);
		FONTOAM_SetDrawFlag(apw->sys.fontact_nickname[i].fontoam, fontoam_enable);
	}
}

//--------------------------------------------------------------
/**
 * @brief   u[_[plGtFNgs
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   eff_type	GtFNg^Cv(BRDPANEL_ALPHA_TYPE_???)
 * @param   end_flag	GtFNg̏Im点郏[Nւ̃|C^(ITRUEZbg܂)
 */
//--------------------------------------------------------------
void AT_BrdPanelAlphaEffectSet(ACTIN_PROC_WORK *apw, int eff_type, u8 *end_flag)
{
	BRDPANEL_ALPHA_WORK *baw;
	
	*end_flag = FALSE;
	
	baw = sys_AllocMemory(HEAPID_ACTIN, sizeof(BRDPANEL_ALPHA_WORK));
	MI_CpuClear8(baw, sizeof(BRDPANEL_ALPHA_WORK));
	
	baw->apw = apw;
	baw->eff_type = eff_type;
	baw->end_flag = end_flag;
	
	TCB_Add(BrdPanelAlphaEffMain, baw, TCBPRI_ACTIN_BRDPANEL_ALPHA);
}

//--------------------------------------------------------------
/**
 * @brief   u[_[plGtFNgC^XN
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		BRDPANEL_ALPHA_WORK\
 */
//--------------------------------------------------------------
static void BrdPanelAlphaEffMain(TCB_PTR tcb, void *work)
{
	BRDPANEL_ALPHA_WORK *baw = work;
	
	switch(baw->seq){
	case 0:	//OBJ̒オΏۂ̃u[_[plʂȂ̂ŁAɔ
			//OBJ̕ςȈׁAʁXɔŏĂ
		if(baw->eff_type == BRDPANEL_ALPHA_TYPE_RETIRE){
			baw->eva = 16 << 8;
			baw->evb = 0;
			G2_SetBlendAlpha(0, 
				GX_BLEND_PLANEMASK_BG2 | GX_BLEND_PLANEMASK_BG3 | GX_BLEND_PLANEMASK_BG1, 16, 0);
			AT_PanelObjBrdModeSet(baw->apw, GX_OAM_MODE_XLU, TRUE);
		}
		else{
			baw->eva = 0;
			baw->evb = 16 << 8;
			G2_SetBlendAlpha(GX_BLEND_PLANEMASK_BG2, 
				GX_BLEND_PLANEMASK_BG2 | GX_BLEND_PLANEMASK_BG3 | GX_BLEND_PLANEMASK_BG1, 0, 16);
			
			ActinBG_BrdPanelSet(baw->apw, EFF_BG_TYPE_BRDPANEL, TRUE);
		}
		
		VWaitTCB_Add(BrdPanelAlphaSet_VTask, baw, TCBPRI_ACTIN_BRDPANEL_ALPHA_VTASK);
		baw->seq++;
		break;
	case 1:
		if(baw->eff_type == BRDPANEL_ALPHA_TYPE_RETIRE && baw->eva == 0){
			AT_PanelObjBrdModeSet(baw->apw, GX_OAM_MODE_NORMAL, FALSE);
			baw->seq++;
		}
		else if(baw->eff_type == BRDPANEL_ALPHA_TYPE_RETURN && baw->evb == 0){
			baw->seq++;
		}
		break;

	case 2:	//2iK
		if(baw->eff_type == BRDPANEL_ALPHA_TYPE_RETIRE){
			baw->eva = 16 << 8;
			baw->evb = 0;
			G2_SetBlendAlpha(GX_BLEND_PLANEMASK_BG2, 
				GX_BLEND_PLANEMASK_BG2 | GX_BLEND_PLANEMASK_BG3 | GX_BLEND_PLANEMASK_BG1, 16, 0);
		}
		else{
			baw->eva = 0;
			baw->evb = 16 << 8;
			G2_SetBlendAlpha(0, 
				GX_BLEND_PLANEMASK_BG2 | GX_BLEND_PLANEMASK_BG1 | GX_BLEND_PLANEMASK_BG3, 0, 16);
			
			AT_PanelObjBrdModeSet(baw->apw, GX_OAM_MODE_XLU, TRUE);
		}
		
		VWaitTCB_Add(BrdPanelAlphaSet_VTask, baw, TCBPRI_ACTIN_BRDPANEL_ALPHA_VTASK);
		baw->seq++;
		break;
	case 3:
		if(baw->eff_type == BRDPANEL_ALPHA_TYPE_RETIRE && baw->eva == 0){
			ActinBG_BrdPanelSet(baw->apw, EFF_BG_TYPE_EFFECT, TRUE);
			baw->seq++;
		}
		else if(baw->eff_type == BRDPANEL_ALPHA_TYPE_RETURN && baw->evb == 0){
			AT_PanelObjBrdModeSet(baw->apw, GX_OAM_MODE_NORMAL, TRUE);
			baw->seq++;
		}
		break;

	default:
		ActinExTool_DefaultBlendSet();
		
		*(baw->end_flag) = TRUE;
		sys_FreeMemoryEz(work);
		TCB_Delete(tcb);
		return;
	}
}

//--------------------------------------------------------------
/**
 * @brief   u[_[plGtFNgVblank]^XN
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		BRDPANEL_ALPHA_WORK\
 */
//--------------------------------------------------------------
static void BrdPanelAlphaSet_VTask(TCB_PTR tcb, void *work)
{
	BRDPANEL_ALPHA_WORK *baw = work;
	int end = 0;
	
	if(baw->eff_type == BRDPANEL_ALPHA_TYPE_RETIRE){
		baw->eva -= BRDPANEL_ALPHA_SP;
		baw->evb += BRDPANEL_ALPHA_SP;
		if(baw->eva <= 0){
			baw->eva = 0;
			end++;
		}
		if(baw->evb >= (16 << 8)){
			baw->evb = 16 << 8;
		}
	}
	else{
		baw->eva += BRDPANEL_ALPHA_SP;
		baw->evb -= BRDPANEL_ALPHA_SP;
		if(baw->eva >= (16 << 8)){
			baw->eva = 16 << 8;
			end++;
		}
		if(baw->evb <= 0){
			baw->evb = 0;
		}
	}
	
	G2_ChangeBlendAlpha(baw->eva >> 8, baw->evb >> 8);
	if(end > 0){
		TCB_Delete(tcb);
		return;
	}
}


//--------------------------------------------------------------
/**
 * @brief   bZ[W^OWJ
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   msg_tag		^OR[h
 * @param   tagpara		^OWJꍇAQƂp[^
 *                      (^OɂĂ͕KvȂ̂ŁȀꍇANULLłOK)
 */
//--------------------------------------------------------------
static void AT_MessageTagExpand(ACTIN_PROC_WORK *apw, int msg_tag, const ATAG_PARAM *tagpara)
{
	GF_ASSERT(msg_tag < ATAG_MINE || tagpara != NULL);	//ATAG_MINEȏ̏ꍇtagparaK{
	
	if(tagpara != NULL){
		OS_TPrintf("mine=%d, enemy=%d, wazano=%d, num=%d, judge_no=%d\n",
			tagpara->mine_brd, tagpara->enemy_brd, tagpara->wazano, tagpara->num, 
			tagpara->judge_no);
	}

	switch(msg_tag){
	case ATAG_NONE:
		break;
	case ATAG_NOW:
		WORDSET_RegisterPokeNickName(apw->sys.wordset, 0, 
			PPPPointerGet(apw->sys.c_game->pp[apw->advance.now_breeder]));
		break;

	case ATAG_MINE:
		WORDSET_RegisterPokeNickName(apw->sys.wordset, 0, 
			PPPPointerGet(apw->sys.c_game->pp[tagpara->mine_brd]));
		break;
	case ATAG_ENEMY:
		WORDSET_RegisterPokeNickName(apw->sys.wordset, 0, 
			PPPPointerGet(apw->sys.c_game->pp[tagpara->enemy_brd]));
		break;
	case ATAG_WAZA:
		WORDSET_RegisterWazaName(apw->sys.wordset, 0, tagpara->wazano);
		break;
	case ATAG_NUM:
		WORDSET_RegisterNumber(apw->sys.wordset, 0, tagpara->num, 1, 
			NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT);
		break;
	case ATAG_JUDGE:
		WORDSET_RegisterJudgeName(apw->sys.wordset, 0, 
			apw->sys.c_game->jd[tagpara->judge_no].name_id);
		break;
	case ATAG_MINE_ENEMY:
		WORDSET_RegisterPokeNickName(apw->sys.wordset, 0, 
			PPPPointerGet(apw->sys.c_game->pp[tagpara->mine_brd]));
		WORDSET_RegisterPokeNickName(apw->sys.wordset, 1, 
			PPPPointerGet(apw->sys.c_game->pp[tagpara->enemy_brd]));
		break;
	case ATAG_MINE_WAZA:
		WORDSET_RegisterPokeNickName(apw->sys.wordset, 0, 
			PPPPointerGet(apw->sys.c_game->pp[tagpara->mine_brd]));
		WORDSET_RegisterWazaName(apw->sys.wordset, 1, tagpara->wazano);
		break;
	case ATAG_MINE_NUM:
		WORDSET_RegisterPokeNickName(apw->sys.wordset, 0, 
			PPPPointerGet(apw->sys.c_game->pp[tagpara->mine_brd]));
		WORDSET_RegisterNumber(apw->sys.wordset, 1, tagpara->num, 1, 
			NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT);
		break;
	case ATAG_MINE_JUDGE:
		WORDSET_RegisterPokeNickName(apw->sys.wordset, 0, 
			PPPPointerGet(apw->sys.c_game->pp[tagpara->mine_brd]));
		WORDSET_RegisterJudgeName(apw->sys.wordset, 1, 
			apw->sys.c_game->jd[tagpara->judge_no].name_id);
		break;

	case ATAG_ENEMY_MINE:
		WORDSET_RegisterPokeNickName(apw->sys.wordset, 0, 
			PPPPointerGet(apw->sys.c_game->pp[tagpara->enemy_brd]));
		WORDSET_RegisterPokeNickName(apw->sys.wordset, 1, 
			PPPPointerGet(apw->sys.c_game->pp[tagpara->mine_brd]));
		break;
	case ATAG_ENEMY_WAZA:
		WORDSET_RegisterPokeNickName(apw->sys.wordset, 0, 
			PPPPointerGet(apw->sys.c_game->pp[tagpara->enemy_brd]));
		WORDSET_RegisterWazaName(apw->sys.wordset, 1, tagpara->wazano);
		break;
	case ATAG_ENEMY_NUM:
		WORDSET_RegisterPokeNickName(apw->sys.wordset, 0, 
			PPPPointerGet(apw->sys.c_game->pp[tagpara->enemy_brd]));
		WORDSET_RegisterNumber(apw->sys.wordset, 1, tagpara->num, 1, 
			NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT);
		break;
	case ATAG_ENEMY_JUDGE:
		WORDSET_RegisterPokeNickName(apw->sys.wordset, 0, 
			PPPPointerGet(apw->sys.c_game->pp[tagpara->enemy_brd]));
		WORDSET_RegisterPokeNickName(apw->sys.wordset, 1, 
			PPPPointerGet(apw->sys.c_game->pp[tagpara->mine_brd]));
		break;

	case ATAG_WAZA_MINE:
		WORDSET_RegisterWazaName(apw->sys.wordset, 0, tagpara->wazano);
		WORDSET_RegisterPokeNickName(apw->sys.wordset, 1, 
			PPPPointerGet(apw->sys.c_game->pp[tagpara->mine_brd]));
		break;
	case ATAG_WAZA_ENEMY:
		WORDSET_RegisterWazaName(apw->sys.wordset, 0, tagpara->wazano);
		WORDSET_RegisterPokeNickName(apw->sys.wordset, 1, 
			PPPPointerGet(apw->sys.c_game->pp[tagpara->enemy_brd]));
		break;
	case ATAG_WAZA_NUM:
		WORDSET_RegisterWazaName(apw->sys.wordset, 0, tagpara->wazano);
		WORDSET_RegisterNumber(apw->sys.wordset, 1, tagpara->num, 1, 
			NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT);
		break;
	case ATAG_WAZA_JUDGE:
		WORDSET_RegisterWazaName(apw->sys.wordset, 0, tagpara->wazano);
		WORDSET_RegisterPokeNickName(apw->sys.wordset, 1, 
			PPPPointerGet(apw->sys.c_game->pp[tagpara->mine_brd]));
		break;

	case ATAG_NUM_MINE:
		WORDSET_RegisterNumber(apw->sys.wordset, 0, tagpara->num, 1, 
			NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT);
		WORDSET_RegisterPokeNickName(apw->sys.wordset, 1, 
			PPPPointerGet(apw->sys.c_game->pp[tagpara->mine_brd]));
		break;
	case ATAG_NUM_ENEMY:
		WORDSET_RegisterNumber(apw->sys.wordset, 0, tagpara->num, 1, 
			NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT);
		WORDSET_RegisterPokeNickName(apw->sys.wordset, 1, 
			PPPPointerGet(apw->sys.c_game->pp[tagpara->enemy_brd]));
		break;
	case ATAG_NUM_WAZA:
		WORDSET_RegisterNumber(apw->sys.wordset, 0, tagpara->num, 1, 
			NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT);
		WORDSET_RegisterWazaName(apw->sys.wordset, 1, tagpara->wazano);
		break;
	case ATAG_NUM_JUDGE:
		WORDSET_RegisterNumber(apw->sys.wordset, 0, tagpara->num, 1, 
			NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT);
		WORDSET_RegisterPokeNickName(apw->sys.wordset, 1, 
			PPPPointerGet(apw->sys.c_game->pp[tagpara->mine_brd]));
		break;

	case ATAG_JUDGE_MINE:
		WORDSET_RegisterPokeNickName(apw->sys.wordset, 0, 
			PPPPointerGet(apw->sys.c_game->pp[tagpara->mine_brd]));
		WORDSET_RegisterPokeNickName(apw->sys.wordset, 1, 
			PPPPointerGet(apw->sys.c_game->pp[tagpara->mine_brd]));
		break;
	case ATAG_JUDGE_ENEMY:
		WORDSET_RegisterPokeNickName(apw->sys.wordset, 0, 
			PPPPointerGet(apw->sys.c_game->pp[tagpara->mine_brd]));
		WORDSET_RegisterPokeNickName(apw->sys.wordset, 1, 
			PPPPointerGet(apw->sys.c_game->pp[tagpara->enemy_brd]));
		break;
	case ATAG_JUDGE_WAZA:
		WORDSET_RegisterPokeNickName(apw->sys.wordset, 0, 
			PPPPointerGet(apw->sys.c_game->pp[tagpara->mine_brd]));
		WORDSET_RegisterWazaName(apw->sys.wordset, 1, tagpara->wazano);
		break;
	case ATAG_JUDGE_NUM:
		WORDSET_RegisterPokeNickName(apw->sys.wordset, 0, 
			PPPPointerGet(apw->sys.c_game->pp[tagpara->mine_brd]));
		WORDSET_RegisterNumber(apw->sys.wordset, 1, tagpara->num, 1, 
			NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT);
		break;

	default:
		GF_ASSERT(0 && "FłȂ^Oł\n");
		break;
	}
}

//--------------------------------------------------------------
/**
 * @brief   bbZ[WZbg
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   msg_id		bZ[WID
 * @param   msg_tag		^OR[h
 * @param   tagpara		^OWJꍇAQƂp[^
 *                      (^OɂĂ͕KvȂ̂ŁȀꍇANULLłOK)
 */
//--------------------------------------------------------------
static void AT_TalkMessageSet(ACTIN_PROC_WORK *apw, MSGDATA_MANAGER *msg_man, 
	u32 msg_id, int msg_tag, const ATAG_PARAM *tagpara)
{
	STRBUF *message_src;
	
//	BattleMSG_TagExpand(bw,mp);
//	BattleMSG_MsgExpand(bw,msg_m,mp);

	message_src = MSGMAN_AllocString(msg_man, msg_id);
	AT_MessageTagExpand(apw, msg_tag, tagpara);
	WORDSET_ExpandStr(apw->sys.wordset, apw->sys.msg_buf, message_src);

	GF_BGL_BmpWinDataFill(&apw->sys.win[ACTIN_BMPWIN_TALK], 0xff);
	apw->sys.talk_msg_index = GF_STR_PrintSimple(&apw->sys.win[ACTIN_BMPWIN_TALK], 
		FONT_TALK, apw->sys.msg_buf, 0, 0, CONTEST_MESSAGE_WAIT, NULL);

	if(GF_BGL_ScrollGetX(apw->sys.bgl, ACTIN_FRAME_WIN) == FRAME_WIN_DEFAULT_X){
		//GF_BGL_BmpWinDataFillŘg܂œhԂ̂ōĕ`
//		AT_TalkWinScreenWrite(&apw->sys, TALKWIN_SCREEN_WRITE_AFTER);
	}
	
	STRBUF_Delete(message_src);
}

//--------------------------------------------------------------
/**
 * @brief   m[}bp̃bZ[WZbg
 *
 * @param   apw				Z͕Ǘ[Nւ̃|C^
 * @param   a_talk_id		A_TALK_???
 * @param   tagpara		^OWJꍇAQƂp[^
 *                      (^OɂĂ͕KvȂ̂ŁȀꍇANULLłOK)
 */
//--------------------------------------------------------------
void AT_A_TalkMessageSet(ACTIN_PROC_WORK *apw, u32 a_talk_id, const ATAG_PARAM *tagpara)
{
	u32 msg_id, msg_tag;
	
	GF_ASSERT(a_talk_id < NELEMS(ActinTalkMsgData));
	
	msg_id = ActinTalkMsgData[a_talk_id].msg_id;
	msg_tag = ActinTalkMsgData[a_talk_id].msg_tag;
	AT_TalkMessageSet(apw, apw->sys.actin_msg, msg_id, msg_tag, tagpara);
}

//--------------------------------------------------------------
/**
 * @brief   Zʗp̉bbZ[WZbg
 *
 * @param   apw			Z͕Ǘ[Nւ̃|C^
 * @param   apno		As[ԍ
 * @param   msg_type	bZ[W^Cv(KOUKA_MSGID_???)
 * @param   tagpara		^OWJꍇAQƂp[^
 *                      (^OɂĂ͕KvȂ̂ŁȀꍇANULLłOK)
 */
//--------------------------------------------------------------
void AT_WazaKoukaTalkMessageSet(ACTIN_PROC_WORK *apw, int apno, int msg_type, 
	const ATAG_PARAM *tagpara)
{
	u32 msg_id, msg_tag;
	
	ConTool_GetKoukaMsgID(apno, msg_type, &msg_id, &msg_tag);
	AT_TalkMessageSet(apw, apw->sys.wazakouka_msg, msg_id, msg_tag, tagpara);
}

//--------------------------------------------------------------
/**
 * @brief   bbZ[WtHg\Ă邩`FbN
 * @param   apw		Z͕Ǘ[Nւ̃|C^
 * @retval  0=I
 */
//--------------------------------------------------------------
int AT_TalkMessageEndCheck(ACTIN_PROC_WORK *apw)
{
	return GF_MSG_PrintEndCheck(apw->sys.talk_msg_index);
}

//--------------------------------------------------------------
/**
 * @brief   u[_[̃tHgOAM𐶐
 * @param   apw				Z͕Ǘ[Nւ̃|C^
 * @param   breeder_no		u[_[ԍ
 */
//--------------------------------------------------------------
void AT_BreederPanelFontOamCreate(ACTIN_PROC_WORK *apw, int breeder_no)
{
//	STRBUF *oyaname_buf;
	STRBUF *nickname_buf;
	
	nickname_buf = STRBUF_Create(BUFLEN_POKEMON_NAME, HEAPID_ACTIN);
//	oyaname_buf = STRBUF_Create(BUFLEN_PERSON_NAME, HEAPID_ACTIN);

	PokeParaGet(apw->sys.c_game->pp[breeder_no], ID_PARA_nickname_buf, nickname_buf);
//	PokeParaGet(apw->sys.c_game->pp[breeder_no], ID_PARA_oyaname_buf, oyaname_buf);

	ADV_FontOamCreate(HEAPID_ACTIN, apw->sys.bgl, apw->sys.crp, apw->sys.fontoam_sys,
		&apw->sys.fontact_nickname[breeder_no], nickname_buf, 
		FONT_SYSTEM, MSGCOLOR_BREEDERPARAM, 0, PLTTID_FONTACT, 
		0, 0, FALSE, ACTIN_BGPRI_BREEDER_PARAM, ACTIN_SOFTPRI_BREEDER_PARAM);
	ADV_FontOamCreate(HEAPID_ACTIN, apw->sys.bgl, apw->sys.crp, apw->sys.fontoam_sys,
		&apw->sys.fontact_oya[breeder_no], 
		apw->consys->c_game.breeder_name_str[breeder_no],//oyaname_buf, 
		FONT_SYSTEM, MSGCOLOR_BREEDERPARAM, 0, PLTTID_FONTACT, 
		0, 0, FALSE, ACTIN_BGPRI_BREEDER_PARAM, ACTIN_SOFTPRI_BREEDER_PARAM);

	STRBUF_Delete(nickname_buf);
//	STRBUF_Delete(oyaname_buf);
}

//--------------------------------------------------------------
/**
 * @brief   u[_[̃tHgOAMSĐ
 * @param   apw		Z͕Ǘ[Nւ̃|C^
 */
//--------------------------------------------------------------
void AT_BreederPanelFontOamCreateAll(ACTIN_PROC_WORK *apw)
{
	int i;
	
	for(i = 0; i < BREEDER_MAX; i++){
		AT_BreederPanelFontOamCreate(apw, i);
	}
	AT_BreederPanelFontOamPosUpdate(apw);
}

//--------------------------------------------------------------
/**
 * @brief   u[_[̃tHgOAMSč폜
 * @param   sys		_XVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
void AT_BreederPanelFontOamDeleteAll(ACTIN_PROC_WORK *apw)
{
	int i;
	
	for(i = 0; i < BREEDER_MAX; i++){
		ADV_FontOamDelete(&apw->sys.fontact_nickname[i]);
		ADV_FontOamDelete(&apw->sys.fontact_oya[i]);
	}
}

//--------------------------------------------------------------
/**
 * @brief   u[_[̃tHgOAM̍Wu[_[\[gɍ킹čXV
 * @param   apw		Z͕Ǘ[Nւ̃|C^
 */
//--------------------------------------------------------------
void AT_BreederPanelFontOamPosUpdate(ACTIN_PROC_WORK *apw)
{
	int pos, breeder_no;
	
	for(pos = 0; pos < BREEDER_MAX; pos++){
		breeder_no = apw->a_game.breeder_sort[pos];
		ADV_FontOamPosSet(&apw->sys.fontact_nickname[breeder_no], 
			BREEDER_PANEL_NICK_X, BREEDER_PANEL_NICK_Y + BREEDER_PANEL_NICK_Y_SPACE * pos,
			FALSE);
		ADV_FontOamPosSet(&apw->sys.fontact_oya[breeder_no], 
			BREEDER_PANEL_OYA_X, BREEDER_PANEL_OYA_Y + BREEDER_PANEL_OYA_Y_SPACE * pos, 
			FALSE);
	}
}


//--------------------------------------------------------------
/**
 * @brief   ACR̃\[X[h
 *
 * @param   csp
 * @param   crp
 */
//--------------------------------------------------------------
void AT_NextIconResourceLoad(CATS_SYS_PTR csp, CATS_RES_PTR crp)
{
	//pbg͏풓pbggp̂Ń[hȂ

	CATS_LoadResourceCharArc(csp, crp, ARC_CONTEST_OBJ, 
		NEXT_ICON_NCGR_BIN, 1, NNS_G2D_VRAM_TYPE_2DMAIN, CHARID_NEXT_ICON);
	CATS_LoadResourceCellArc(csp, crp, ARC_CONTEST_OBJ, NEXT_ICON_NCER_BIN, 1, CELLID_NEXT_ICON);
	CATS_LoadResourceCellAnmArc(csp, crp, ARC_CONTEST_OBJ, NEXT_ICON_NANR_BIN, 
		1, CELLANMID_NEXT_ICON);
}

//--------------------------------------------------------------
/**
 * @brief   ACR̃\[X
 *
 * @param   crp		
 */
//--------------------------------------------------------------
void AT_NextIconResourceFree(CATS_RES_PTR crp)
{
	//pbg͏풓pbgȂ̂ō폜Ȃ
	CATS_FreeResourceChar(crp, CHARID_NEXT_ICON);
	CATS_FreeResourceCell(crp, CELLID_NEXT_ICON);
	CATS_FreeResourceCellAnm(crp, CELLANMID_NEXT_ICON);
}

//--------------------------------------------------------------
/**
 * @brief   ACR̃AN^[ƃAjݒs
 *
 * @param   sys				Z̓VXe[Nւ̃|C^
 * @param   breeder_pos		\u[_[ʒu
 * @param   next_pos		̃^[ԖځAƕ\邩
 *
 * breeder_pos̈ʒuɃAN^[Ăꍇ̓Aj̐ݒ肾s܂
 */
//--------------------------------------------------------------
void AT_NextIconActorAnimeSet(ACTIN_SYSTEM_PARAM *sys, int breeder_pos, int next_pos)
{
	//AN^[ĂȂꍇ͐
	if(sys->nexticon_cap[breeder_pos] == NULL){
		sys->nexticon_cap[breeder_pos] = CATS_ObjectAdd_S(sys->csp, sys->crp, &NextIconObjParam);
	}
	
	//Ajݒ
	CATS_ObjectAnimeSeqSetCap(sys->nexticon_cap[breeder_pos], next_pos);
	
	//Wݒ
	CATS_ObjectPosSetCap(sys->nexticon_cap[breeder_pos], 
		NEXT_ICON_POS_X, NEXT_ICON_POS_Y + breeder_pos * NEXT_ICON_POS_Y_SPACE);

	CATS_ObjectUpdate(sys->nexticon_cap[breeder_pos]->act);
}

//--------------------------------------------------------------
/**
 * @brief   ݏɏoĂ鎟ACRAN^[Sč폜
 *
 * @param   sys				Z̓VXe\̂ւ̃|C^
 */
//--------------------------------------------------------------
void AT_NextIconActorDelAll(ACTIN_SYSTEM_PARAM *sys)
{
	int i;
	
	for(i = 0; i < BREEDER_MAX; i++){
		if(sys->nexticon_cap[i] != NULL){
			CATS_ActorPointerDelete_S(sys->nexticon_cap[i]);
			sys->nexticon_cap[i] = NULL;
		}
	}
}

//--------------------------------------------------------------
/**
 * @brief   bZ[W^OWJp[^Ɋeu[_[̏lf[^Zbg
 *
 * @param   apw				Z͕Ǘ[Nւ̃|C^
 * @param   tagpara			^Op[^
 * @param   breeder_no		u[_[ԍ
 */
//--------------------------------------------------------------
void AT_MsgTagParaInitDataSet(ACTIN_PROC_WORK *apw, ATAG_PARAM *tagpara, int breeder_no)
{
	MI_CpuClear8(tagpara, sizeof(ATAG_PARAM));
	tagpara->mine_brd = breeder_no;
	tagpara->wazano = apw->a_game.waza_no[breeder_no];
	tagpara->judge_no = apw->a_game.judge_no[breeder_no];
}

//--------------------------------------------------------------
/**
 * @brief   vAPlR̃Rgx̃bZ[WIDƃ^O擾
 *
 * @param   breeder_no		u[_[ԍ
 * @param   app_total		vAP
 * @param   tagpara			^O
 *
 * @retval  A_TALK_???
 */
//--------------------------------------------------------------
u32 AT_MsgTagJudgeCommentCreate(int breeder_no, int app_total, ATAG_PARAM *tagpara)
{
	int a_talk_id;
	
	tagpara->mine_brd = breeder_no;
	if(app_total <= JUDGE_COMMENT_LEVEL_0){
		a_talk_id = A_TALK_TURN_RESULT_0;
	}
	else if(app_total <= JUDGE_COMMENT_LEVEL_1){
		a_talk_id = A_TALK_TURN_RESULT_1;
	}
	else if(app_total <= JUDGE_COMMENT_LEVEL_2){
		a_talk_id = A_TALK_TURN_RESULT_2;
	}
	else if(app_total <= JUDGE_COMMENT_LEVEL_3){
		a_talk_id = A_TALK_TURN_RESULT_3;
	}
	else{
		a_talk_id = A_TALK_TURN_RESULT_4;
	}
	return a_talk_id;
}

//--------------------------------------------------------------
/**
 * @brief   ϋqAjs
 *
 * @param   apw				Z͕Ǘ[Nւ̃|C^
 * @param   voltage			{e[Wl
 * @param   start_wait		JnEFCg
 * @param   end_flag		GtFNgIɁAItOZbg郏[Nւ̃|C^
 */
//--------------------------------------------------------------
void AT_AudienceAnimeSet(ACTIN_PROC_WORK *apw, int voltage, u8 start_wait, u8 *end_flag)
{
	AUDIENCE_ANIME_WORK *aaw;
	
	*end_flag = FALSE;
	
	aaw = sys_AllocMemory(HEAPID_ACTIN, sizeof(AUDIENCE_ANIME_WORK));
	MI_CpuClear8(aaw, sizeof(AUDIENCE_ANIME_WORK));
	aaw->apw = apw;
	aaw->end_flag = end_flag;
	aaw->start_wait = start_wait;
	TCB_Add(AudienceAnimeMain, aaw, TCBPRI_ACTIN_AUDIENCE_ANIME);
}

//--------------------------------------------------------------
/**
 * @brief   ϋqAjs^XN
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		AUDIENCE_ANIME_WORK\
 */
//--------------------------------------------------------------
static void AudienceAnimeMain(TCB_PTR tcb, void *work)
{
	AUDIENCE_ANIME_WORK *aaw = work;
	
	switch(aaw->seq){
	case 0:
		if(aaw->start_wait > 0){
			aaw->start_wait--;
			break;
		}
		Snd_SePlay(ASE_AUDIENCE);
		aaw->seq++;
		//break;
	case 1:
		{
			u32 scr_id;
			
			if(aaw->anm_no == 0){
				scr_id = CON_BG2_NSCR_BIN;
			}
			else{
				scr_id = CON_BG_NSCR_BIN;
			}
			ArcUtil_ScrnSet(ARC_CONTEST_BG, scr_id, aaw->apw->sys.bgl, 
				ACTIN_FRAME_AUDIENCE, 0, 0, 1, HEAPID_ACTIN);
		}
		aaw->seq++;
		break;
	case 2:
		aaw->wait++;
		if(aaw->wait > AUDIENCE_ANIME_WAIT){
			aaw->wait = 0;
			aaw->anm_no ^= 1;
			aaw->seq--;
			
			if(aaw->anm_no == 0){
				aaw->loop++;
				if(aaw->loop > AUDIENCE_ANIME_LOOP){
					aaw->seq = 0xff;
					break;
				}
			}
		}
		break;
	default:
		*(aaw->end_flag) = TRUE;
		
		sys_FreeMemoryEz(work);
		TCB_Delete(tcb);
		return;
	}
}

