//==============================================================================
/**
 * @file	adv_tool.c
 * @brief	ReXgS勤ʃc[
 * @author	matsuda
 * @date	2006.02.02()
 */
//==============================================================================
#include "common.h"
#include "contest/contest.h"
#include "con_tool.h"
#include "actin.h"
#include "visual.h"
#include "dance.h"

#include "system/arc_tool.h"
#include "system/arc_util.h"

#include "system/fontproc.h"
#include "system/msgdata.h"
#include "system/msgdata_util.h"
#include "system/wordset.h"
#include "system/fontoam.h"

#include "adv_tool.h"

#include "msgdata/msg.naix"

#include <nitro/sinit.h>
#include "system/pm_overlay.h"
FS_EXTERN_OVERLAY(bc_common);


//--------------------------------------------------------------
/**
 * @brief   
 *
 * ProcDataŎw肵ȊÕI[o[C̃[hs
 *
 */
//--------------------------------------------------------------
static void NitroStaticInit(void)
{
	Overlay_Load(FS_OVERLAY_ID(bc_common), OVERLAY_LOAD_NOT_SYNCHRONIZE);
}


//--------------------------------------------------------------
/**
 * @brief   Cʂ̃tHgOAM쐬
 *
 * @param   heap_id			q[vID
 * @param   bgl				BGLւ̃|C^
 * @param   crp				crpւ̃|C^
 * @param   fontoam_sys		tHgVXeւ̃|C^
 * @param   ret_fontoam		tHgOAM
 * @param   ret_cma			tHgOAM̃L̈
 * @param   str				
 * @param   font_type		tHg^Cv(FONT_SYSTEM)
 * @param   color			tHgJ[\
 * @param   pal_offset		pbgԍItZbg
 * @param   pal_id			o^JnpbgID
 * @param   x				WX
 * @param   y				WY
 * @param   pos_center  	FALSE(X[W) or TRUE(XSW)
 * @param   bg_pri			BGvCIeB
 * @param   soft_pri		\tgvCIeB
 */
//--------------------------------------------------------------
void ADV_FontOamCreate(int heap_id, GF_BGL_INI *bgl, CATS_RES_PTR crp, 
	FONTOAM_SYS_PTR fontoam_sys, ADV_FONTACT *fontact, const STRBUF *str, 
	FONT_TYPE font_type, GF_PRINTCOLOR color, int pal_offset, int pal_id, 
	int x, int y, int pos_center, int bg_pri, int soft_pri)
{
	FONTOAM_INIT finit;
	GF_BGL_BMPWIN bmpwin;
	CHAR_MANAGER_ALLOCDATA cma;
	int vram_size;
	FONTOAM_OBJ_PTR fontoam;
	int font_len, char_len;
	int margin = 0;
	
	//̃hbgAgpLZo
	{
		font_len = FontProc_GetPrintStrWidth(font_type, str, margin);
		char_len = font_len / 8;
		if(FX_ModS32(font_len, 8) != 0){
			char_len++;
		}
	}

	//BMP쐬
	{
		GF_BGL_BmpWinInit(&bmpwin);
		GF_BGL_BmpWinObjAdd(bgl, &bmpwin, char_len, 16 / 8, 0, 0);
		GF_STR_PrintExpand(&bmpwin, font_type, str, 0, 0, MSG_NO_PUT, color, 
			margin, 0, NULL);
//		GF_STR_PrintColor(&bmpwin, font_type, str, 0, 0, MSG_NO_PUT, color, NULL );
	}

	vram_size = FONTOAM_NeedCharSize(&bmpwin, NNS_G2D_VRAM_TYPE_2DMAIN,  heap_id);
	CharVramAreaAlloc(vram_size, CHARM_CONT_AREACONT, NNS_G2D_VRAM_TYPE_2DMAIN, &cma);
	
	//WʒuC
	if(pos_center == TRUE){
		x -= font_len / 2;
	}
	y += MAIN_SURFACE_Y_INTEGER - 8;
	
	finit.fontoam_sys = fontoam_sys;
	finit.bmp = &bmpwin;
	finit.clact_set = CATS_GetClactSetPtr(crp);
	finit.pltt = CATS_PlttProxy(crp, pal_id);
	finit.parent = NULL;
	finit.char_ofs = cma.alloc_ofs;
	finit.x = x;
	finit.y = y;
	finit.bg_pri = bg_pri;
	finit.soft_pri = soft_pri;
	finit.draw_area = NNS_G2D_VRAM_TYPE_2DMAIN;
	finit.heap = heap_id;
	
	fontoam = FONTOAM_Init(&finit);
	if(pal_offset != 0){
		FONTOAM_SetPaletteOffset(fontoam, pal_offset);
	}
	FONTOAM_SetMat(fontoam, x, y);
	
	//
	GF_BGL_BmpWinDel(&bmpwin);
	
	fontact->fontoam = fontoam;
	fontact->cma = cma;
	fontact->len = font_len;
}

//--------------------------------------------------------------
/**
 * @brief   tHgOAM폜
 * @param   fontact		tHgAN^[ւ̃|C^
 */
//--------------------------------------------------------------
void ADV_FontOamDelete(ADV_FONTACT *fontact)
{
	FONTOAM_Delete(fontact->fontoam);
	CharVramAreaFree(&fontact->cma);
}

//--------------------------------------------------------------
/**
 * @brief   tHgOAM̍WZbg
 *
 * @param   fontact			tHgAN^[ւ̃|C^
 * @param   x				WX
 * @param   y				WY
 * @param   pos_center		FALSE(X[W) or TRUE(XSW)
 */
//--------------------------------------------------------------
void ADV_FontOamPosSet(ADV_FONTACT *fontact, int x, int y, int pos_center)
{
	//WʒuC
	if(pos_center == TRUE){
		x -= fontact->len / 2;
	}
	y += MAIN_SURFACE_Y_INTEGER - 8;
	FONTOAM_SetMat(fontact->fontoam, x, y);
}


//--------------------------------------------------------------
/**
 * @brief   RSTRBUF̌`Ŏ擾
 *
 * @param   judge_name_id		RID
 * @param   heap_id				q[vID
 *
 * @retval  RSTRBUF̃|C^
 *
 * ߂lSTRBUF͌ĂяoŉĂ鎖I(STRBUF_Delete)
 */
//--------------------------------------------------------------
STRBUF * ADV_MSGDAT_GetJudgeName(u32 judge_name_id, u32 heap_id)
{
	MSGDATA_MANAGER *man;
	STRBUF *str_buf;
	
	man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_cmsg_judge_dat, heap_id);
	str_buf = MSGMAN_AllocString(man, judge_name_id);
	
	MSGMAN_Delete(man);
	return str_buf;
}

