//=============================================================================
/**
 * @file	comm_command_contest.c
 * @brief	f[^𑗂邽߂̃R}he[uĂ܂
 *          ReXgpł
 *          comm_command_contest.h  enum ƓтłKv܂
 * @author	matsuda
 * @date    2005.12.15()
 */
//=============================================================================

#include "common.h"
#include "communication/communication.h"

#include "contest/contest.h"
#include "comm_command_contest.h"
#include "actin.h"
#include "visual.h"
#include "dance.h"
#include "con_result.h"
#include "contest_order.h"
#include "dance_tool.h"
#include "gflib/strbuf_family.h"


//==============================================================================
//	\̒`
//==============================================================================
typedef struct{
	u8 my_version;					///<̃ReXgo[W
	u8 my_breeder_no;				///<̃u[_[ԍ
	
	u16 dummy;
}CCSEND_FASTPARAM;


//==============================================================================
//  e[uɏ֐̒`
//==============================================================================
static	void CommContestRecvTiming(int id_no,int size,void *pData,void *work);
static	void CommContestRecvNormal(int id_no,int size,void *pData,void *work);
static	void CommContestRecvDance(int id_no,int size,void *pData,void *work);
static	void CommContestRecvFastParam(int id_no,int size,void *pData,void *work);
static	void CommContestRecvPokemonParam(int id_no,int size,void *pData,void *work);
static	void CommContestRecvPokemonParamAll(int id_no,int size,void *pData,void *work);
static	void CommContestRecvBreederData(int id_no,int size,void *pData,void *work);
static	void CommContestRecvJudgeData(int id_no,int size,void *pData,void *work);
static	void CommContestRecvNameData(int id_no,int size,void *pData,void *work);

//==============================================================================
//  static`
//==============================================================================
static int _getVariable(void);
static int _getZero(void);
static int _getOne(void);
static int _getDancingSize(void);
static int ServerNoCheck(CCSEND_FASTPARAM *ccfp[CC_NETID_MAX], int player_num, u8 *version);

//==============================================================================
//	e[u錾
//  comm_shar.h  enum ƓȂтɂĂ
//  CALLBACKĂ΂ꂽȂꍇNULLĂ
//  R}h̃TCYԂ֐Ă炦ƒʐMyȂ܂
//  _getZero̓TCYȂԂ܂B_getVariable͉σf[^gpɎg܂
//==============================================================================
static const CommPacketTbl _CommPacketTbl[] = {
    {NULL,                      _getZero},		// CC_EXIT_CONTEST
	{CommContestRecvTiming, _getZero},			// CC_TIMING_DATA
	{CommContestRecvNormal, _getVariable},		// CC_NORMAL_DATA
	{CommContestRecvDance, _getDancingSize},		// CC_DANCE_DATA
	{CommContestRecvFastParam, _getVariable},	// CC_FAST_PARAM
	{CommContestRecvPokemonParam, _getVariable},	// CC_POKEPARA_DATA
	{CommContestRecvPokemonParamAll, _getVariable},	// CC_POKEPARA_ALL_DATA
	{CommContestRecvBreederData, _getVariable},	// CC_BREEDER_DATA
	{CommContestRecvJudgeData, _getVariable},	// CC_JUDGE_DATA
	{CommContestRecvNameData, _getVariable},	// CC_NAME_DATA
};


//--------------------------------------------------------------
/**
 * @brief   ReXgp̃R}ȟnɏ܂
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------
void CommCommandContestInitialize(void* pWork)
{
    int length = sizeof(_CommPacketTbl)/sizeof(CommPacketTbl);
    CommCommandInitialize(_CommPacketTbl, length, pWork);
}

//--------------------------------------------------------------
/**
 * @brief   RƂTCYԂ܂
 * @param   command         R}h
 * @retval  TCY   ςȂ COMM_VARIABLE_SIZE Zero͂OԂ
 */
//--------------------------------------------------------------
static int _getVariable(void)
{
    return COMM_VARIABLE_SIZE;
}

static int _getZero(void)
{
    return 0;
}

static int _getOne(void)
{
    return 1;
}

static int _getDancingSize(void)
{
	return sizeof(DANCING_PARAM);
}





//==============================================================================
//
//	
//
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   ʐMM
 *
 * @param   id_no		M҂̃lbgID
 * @param   size		Mf[^TCY
 * @param   pData		Mf[^
 * @param   work		
 */
//--------------------------------------------------------------
static	void CommContestRecvTiming(int id_no,int size,void *pData,void *work)
{
	;
}

//--------------------------------------------------------------
/**
 * @brief   m[}f[^ʐMM
 *
 * @param   id_no		M҂̃lbgID
 * @param   size		Mf[^TCY
 * @param   pData		Mf[^
 * @param   work		
 */
//--------------------------------------------------------------
static	void CommContestRecvNormal(int id_no,int size,void *pData,void *work)
{
	CONTEST_SYSTEM *consys = work;
	CONTEST_ORDER_WORK *cow;
	
	if(consys->class_flag == CON_CLASS_VISUAL){
		VISUAL_PROC_WORK *vpw;
		vpw = consys->class_proc;
		cow = &vpw->cow;
		OS_TPrintf("rWAf[^MBid_no=%d, size=%d\n", id_no, size);
	}
	else if(consys->class_flag == CON_CLASS_DANCE){
		DANCE_PROC_WORK *dpw;
		dpw = consys->class_proc;
		cow = &dpw->cow;
		OS_TPrintf("_Xf[^MBid_no=%d, size=%d\n", id_no, size);
	}
	else if(consys->class_flag == CON_CLASS_ACTIN){
		ACTIN_PROC_WORK *apw;
		apw = consys->class_proc;
		cow = &apw->cow;
		OS_TPrintf("Z͕f[^MBid_no=%d, size=%d\n", id_no, size);
	}
	else if(consys->class_flag == CON_CLASS_RESULT){
		CONRES_PROC_WORK *rpw;
		rpw = consys->class_proc;
		cow = &rpw->cow;
		OS_TPrintf("ʔ\f[^MBid_no=%d, size=%d\n", id_no, size);
	}
	else{
		GF_ASSERT(0 && "sȃNXł");
		return;
	}

	GF_ASSERT(size <= CO_TRANSMIT_BUF_SIZE);
	GF_ASSERT(cow->receive_flag[id_no] == FALSE);
	MI_CpuCopy8(pData, cow->receive_buf[id_no], size);
	cow->receive_flag[id_no] = TRUE;
}

//--------------------------------------------------------------
/**
 * @brief   _Xf[^ʐMM
 *
 * @param   id_no		M҂̃lbgID
 * @param   size		Mf[^TCY
 * @param   pData		Mf[^
 * @param   work		
 */
//--------------------------------------------------------------
static	void CommContestRecvDance(int id_no,int size,void *pData,void *work)
{
	CONTEST_SYSTEM *consys = work;
	DANCE_PROC_WORK *dpw;
	DANCING_PARAM *dancing_param;
	
	dpw = consys->class_proc;
	dancing_param = pData;
	
	DT_DancingParamRecieve(dpw, dancing_param);
}

//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   ŏɌf[^ʐMM
 *
 * @param   id_no		M҂̃lbgID
 * @param   size		Mf[^TCY
 * @param   pData		Mf[^
 * @param   work		CONTEST_SYSTEMւ̃|C^
 */
//--------------------------------------------------------------
static	void CommContestRecvFastParam(int id_no,int size,void *pData,void *work)
{
	CONTEST_SYSTEM *consys = work;
	
	MI_CpuCopy8(pData, consys->recieve_buf[id_no], size);
	consys->recieve_count++;
	OS_TPrintf("net_id = %d, server_versin = %d\n", id_no, ((CCSEND_FASTPARAM*)pData)->my_version);
	
	if(consys->recieve_count >= consys->c_game.player_num){
		CCSEND_FASTPARAM *ccfp[CC_NETID_MAX];
		int i;
		u8 version;
		
		for(i = 0; i < consys->c_game.player_num; i++){
			ccfp[i] = (void*)consys->recieve_buf[id_no];
		}
		consys->c_game.server_no = ServerNoCheck(ccfp, consys->c_game.player_num, &version);
		consys->c_game.server_version = version;
		OS_TPrintf("enetID%d\n", consys->c_game.server_no);
	}
}

//--------------------------------------------------------------
/**
 * @brief   ŏɌf[^M
 * @param   consys		ReXgVXe[Nւ̃|C^
 * @retval  TRUE:MB@FALSE:Ms
 */
//--------------------------------------------------------------
BOOL CommContestSendFastParam(CONTEST_SYSTEM *consys)
{
	CCSEND_FASTPARAM ccfp;
	
	ccfp.my_version = consys->c_game.my_version;
	ccfp.my_breeder_no = consys->c_game.my_breeder_no;
	
	if(CommSendData(CC_FAST_PARAM, &ccfp, sizeof(CCSEND_FASTPARAM)) == TRUE){
		consys->recieve_count = 0;
		return TRUE;
	}
	return FALSE;
}

//--------------------------------------------------------------
/**
 * @brief   T[o[ƂȂNetID擾
 *
 * @param   ccfp[CC_NETID_MAX]		
 * @param   player_num				vC[l
 *
 * @retval  T[o[ƂȂ̃lbgID
 */
//--------------------------------------------------------------
static int ServerNoCheck(CCSEND_FASTPARAM *ccfp[CC_NETID_MAX], int player_num, u8 *version)
{
	int i, server_no;
	
	server_no = 0;
	for(i = 0; i < player_num; i++){
		if(ccfp[server_no]->my_version < ccfp[i]->my_version){
			server_no = i;
		}
	}
	*version = ccfp[server_no]->my_version;
	return server_no;
}

//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   |Pp[^ʐMM
 *
 * @param   id_no		M҂̃lbgID
 * @param   size		Mf[^TCY
 * @param   pData		Mf[^
 * @param   work		CONTEST_SYSTEMւ̃|C^
 */
//--------------------------------------------------------------
static	void CommContestRecvPokemonParam(int id_no,int size,void *pData,void *work)
{
	CONTEST_SYSTEM *consys = work;
	int pp_size;
	int breeder_no;
	u8 *pp_buf;
	
	pp_size = PokemonParam_GetWorkSize();
//	breeder_no = ((u8*)pData)[pp_size];
	pp_buf = pData;
	breeder_no = pp_buf[pp_size];

	OS_TPrintf("pp_size = %d, size = %d\n", pp_size, size);
	OS_TPrintf("pData[0] = %d\n", ((u8*)pData)[0]);
	OS_TPrintf("ppbreeder_no = %d\n", breeder_no);
	OS_TPrintf("pp̍Ōf[^ = %d\n", pp_buf[pp_size - 1]);

	MI_CpuCopy8(pData, consys->c_game.pp[breeder_no], pp_size);
	
	consys->recieve_count++;
}

//--------------------------------------------------------------
/**
 * @brief   |Pp[^M
 *
 * @param   consys			ReXgVXe[Nւ̃|C^
 * @param   breeder_no		瑗|PĂu[_[̔ԍ
 * @param   pp				|Pp[^
 *
 * @retval  TRUE:MB@FALSE:Ms
 */
//--------------------------------------------------------------
BOOL CommContestSendPokePara(CONTEST_SYSTEM *consys, int breeder_no, const POKEMON_PARAM *pp)
{
	u8 *pp_buf;
	int pp_size;
	int ret;
	
	pp_size = PokemonParam_GetWorkSize();
	pp_buf = sys_AllocMemory(HEAPID_CONTEST, pp_size + 1);
	MI_CpuCopy8(pp, pp_buf, pp_size);
	pp_buf[pp_size] = breeder_no;
	
	OS_TPrintf("pp_size = %d\n", pp_size);
	OS_TPrintf("breeder_no = %d\n", pp_buf[pp_size]);
	OS_TPrintf("Mpp̍Ōf[^ = %d\n", pp_buf[pp_size - 1]);
	if(CommSendData(CC_POKEPARA_DATA, pp_buf, pp_size + 1) == TRUE){
		consys->recieve_count = 0;
		ret = TRUE;
	}
	else{
		ret = FALSE;
	}
	sys_FreeMemoryEz(pp_buf);
	return ret;
}

//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   |Pp[^(S)ʐMM
 *
 * @param   id_no		M҂̃lbgID
 * @param   size		Mf[^TCY
 * @param   pData		Mf[^
 * @param   work		CONTEST_SYSTEMւ̃|C^
 */
//--------------------------------------------------------------
static	void CommContestRecvPokemonParamAll(int id_no,int size,void *pData,void *work)
{
	CONTEST_SYSTEM *consys = work;
	int pp_size, all_size;
	u8 *pp_buf;
	int i;
	
	pp_size = PokemonParam_GetWorkSize();
	all_size = pp_size * BREEDER_MAX;
//	breeder_no = ((u8*)pData)[pp_size];
	pp_buf = pData;

	OS_TPrintf("all_size = %d, size = %d\n", all_size, size);
	OS_TPrintf("pData[0] = %d\n", ((u8*)pData)[0]);
	OS_TPrintf("pp̍Ōf[^ = %d\n", pp_buf[all_size - 1]);

	for(i = 0; i < BREEDER_MAX; i++){
		MI_CpuCopy8(&pp_buf[pp_size * i], consys->c_game.pp[i], pp_size);
	}
	
	consys->recieve_count++;
}

//--------------------------------------------------------------
/**
 * @brief   |Pp[^(S)M
 *
 * @param   consys			ReXgVXe[Nւ̃|C^
 * @param   pp				|Pp[^
 *
 * @retval  TRUE:MB@FALSE:Ms
 *
 * ep߂łB
 */
//--------------------------------------------------------------
BOOL CommContestSendPokeParaAll(CONTEST_SYSTEM *consys, POKEMON_PARAM **pp)
{
	u8 *pp_buf;
	int pp_size, all_size;
	int ret;
	int i;
	
	pp_size = PokemonParam_GetWorkSize();
	all_size = pp_size * BREEDER_MAX;
//	pp_buf = sys_AllocMemory(HEAPID_CONTEST, all_size);
	pp_buf = consys->huge_buf;
	for(i = 0; i < BREEDER_MAX; i++){
		MI_CpuCopy8(pp[i], &pp_buf[pp_size * i], pp_size);
	}
	
	OS_TPrintf("all_size = %d\n", all_size);
	OS_TPrintf("breeder_no = %d\n", pp_buf[all_size]);
	OS_TPrintf("Mpp̍Ōf[^ = %d\n", pp_buf[all_size - 1]);
	if(CommSendHugeData(CC_POKEPARA_ALL_DATA, pp_buf, all_size) == TRUE){
		consys->recieve_count = 0;
		ret = TRUE;
	}
	else{
		ret = FALSE;
	}
//	sys_FreeMemoryEz(pp_buf);
	return ret;
}


//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   u[_[f[^ʐMM
 *
 * @param   id_no		M҂̃lbgID
 * @param   size		Mf[^TCY
 * @param   pData		Mf[^
 * @param   work		CONTEST_SYSTEMւ̃|C^
 */
//--------------------------------------------------------------
static	void CommContestRecvBreederData(int id_no,int size,void *pData,void *work)
{
	CONTEST_SYSTEM *consys = work;
	int bd_size;
	int breeder_no;
	u8 *bd_buf;
	
	bd_size = sizeof(BREEDER_DATA);
//	breeder_no = ((u8*)pData)[bd_size];
	bd_buf = pData;
	breeder_no = bd_buf[bd_size];

	OS_TPrintf("bd_size = %d, size = %d\n", bd_size, size);
	OS_TPrintf("pData[0] = %d\n", ((u8*)pData)[0]);
	OS_TPrintf("ppbreeder_no = %d\n", breeder_no);
	OS_TPrintf("pp̍Ōf[^ = %d\n", bd_buf[bd_size - 1]);

	MI_CpuCopy8(pData, &consys->c_game.bd[breeder_no], bd_size);
	
	consys->recieve_count++;
}

//--------------------------------------------------------------
/**
 * @brief   u[_[f[^M
 *
 * @param   consys			ReXgVXe[Nւ̃|C^
 * @param   breeder_no		瑗|PĂu[_[̔ԍ
 * @param   bd				Mu[_[f[^ւ̃|C^
 *
 * @retval  TRUE:MB@FALSE:Ms
 */
//--------------------------------------------------------------
BOOL CommContestSendBreederData(CONTEST_SYSTEM *consys, int breeder_no, const BREEDER_DATA *bd)
{
	u8 *bd_buf;
	int bd_size;
	int ret;
	
	bd_size = sizeof(BREEDER_DATA);
	bd_buf = sys_AllocMemory(HEAPID_CONTEST, bd_size + 1);
	MI_CpuCopy8(bd, bd_buf, bd_size);
	bd_buf[bd_size] = breeder_no;
	
	OS_TPrintf("bd_size = %d\n", bd_size);
	OS_TPrintf("breeder_no = %d\n", bd_buf[bd_size]);
	OS_TPrintf("Mbd̍Ōf[^ = %d\n", bd_buf[bd_size - 1]);
	if(CommSendData(CC_BREEDER_DATA, bd_buf, bd_size + 1) == TRUE){
		consys->recieve_count = 0;
		ret = TRUE;
	}
	else{
		ret = FALSE;
	}
	sys_FreeMemoryEz(bd_buf);
	return ret;
}


//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   Rf[^ʐMM
 *
 * @param   id_no		M҂̃lbgID
 * @param   size		Mf[^TCY
 * @param   pData		Mf[^
 * @param   work		CONTEST_SYSTEMւ̃|C^
 */
//--------------------------------------------------------------
static	void CommContestRecvJudgeData(int id_no,int size,void *pData,void *work)
{
	CONTEST_SYSTEM *consys = work;
	int jd_all_size;
	u8 *jd_buf;
	int i;
	
	jd_all_size = sizeof(JUDGE_DATA) * JUDGE_MAX + 1;
	jd_buf = pData;

	OS_TPrintf("jd_all_size = %d, size = %d\n", jd_all_size, size);
	OS_TPrintf("pData[0] = %d\n", ((u8*)pData)[0]);
	OS_TPrintf("jd̍Ōf[^ = %d\n", jd_buf[jd_all_size - 1]);

	for(i = 0; i < JUDGE_MAX; i++){
		MI_CpuCopy8(&jd_buf[sizeof(JUDGE_DATA) * i], &consys->c_game.jd[i], sizeof(JUDGE_DATA));
	}
	consys->c_game.special_judge_no = jd_buf[jd_all_size - 1];
	
	consys->recieve_count++;
}

//--------------------------------------------------------------
/**
 * @brief   Rf[^M
 *
 * @param   consys			ReXgVXe[Nւ̃|C^
 * @param   breeder_no		瑗|PĂu[_[̔ԍ
 * @param   jd				Rf[^
 *
 * @retval  TRUE:MB@FALSE:Ms
 */
//--------------------------------------------------------------
BOOL CommContestSendJudgeData(CONTEST_SYSTEM *consys, int breeder_no, const JUDGE_DATA *jd)
{
	u8 *jd_buf;
	int jd_all_size;
	int ret;
	int i;
	const JUDGE_DATA *jd_src;
	
	jd_src = jd;
	jd_all_size = sizeof(JUDGE_DATA) * JUDGE_MAX + 1;
	jd_buf = sys_AllocMemory(HEAPID_CONTEST, jd_all_size);
	for(i = 0; i < JUDGE_MAX; i++){
		MI_CpuCopy8(jd_src, &jd_buf[sizeof(JUDGE_DATA) * i], sizeof(JUDGE_DATA));
		jd_src++;
	}
	jd_buf[jd_all_size - 1] = consys->c_game.special_judge_no;
	
	OS_TPrintf("jd_all_size = %d\n", jd_all_size);
	OS_TPrintf("Mjd̍Ōf[^ = %d\n", jd_buf[jd_all_size - 1]);
	if(CommSendData(CC_JUDGE_DATA, jd_buf, jd_all_size) == TRUE){
		consys->recieve_count = 0;
		ret = TRUE;
	}
	else{
		ret = FALSE;
	}
	sys_FreeMemoryEz(jd_buf);
	return ret;
}


//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   u[_[ʐMM
 *
 * @param   id_no		M҂̃lbgID
 * @param   size		Mf[^TCY
 * @param   pData		Mf[^
 * @param   work		CONTEST_SYSTEMւ̃|C^
 */
//--------------------------------------------------------------
static	void CommContestRecvNameData(int id_no,int size,void *pData,void *work)
{
	CONTEST_SYSTEM *consys = work;
	int breeder_no, name_size, head_size;
	u8 *recieve_buf;
	STRCODE *name_code;
	
	head_size = 4;
	recieve_buf = pData;
	breeder_no = recieve_buf[0];
	name_size = recieve_buf[1];
	name_code = (STRCODE *)(&recieve_buf[head_size]);
	
	OS_TPrintf("OMFu[_[No=%dAOTCY=%d\n", breeder_no, name_size);
	STRBUF_Clear(consys->c_game.breeder_name_str[breeder_no]);
	STRBUF_SetStringCode(consys->c_game.breeder_name_str[breeder_no], name_code);
	
	consys->recieve_count++;
}

//--------------------------------------------------------------
/**
 * @brief   u[_[M
 *
 * @param   consys			ReXgVXe[Nւ̃|C^
 * @param   breeder_no		瑗閼OĂu[_[NO
 * @param   name			Mu[_[
 *
 * @retval  TRUE:MB@FALSE:Ms
 */
//--------------------------------------------------------------
BOOL CommContestSendNameData(CONTEST_SYSTEM *consys, int breeder_no, const STRBUF *name)
{
	int name_size, head_size;
	u8 *trans_buf;
	BOOL ret;
	STRCODE name_code[BUFLEN_PERSON_NAME];
	
	name_size = BUFLEN_PERSON_NAME * sizeof(STRCODE);
	head_size = 4;
	
	STRBUF_GetStringCode(name, name_code, BUFLEN_PERSON_NAME);
	
	trans_buf = sys_AllocMemory(HEAPID_CONTEST, name_size + head_size);
	MI_CpuCopy8(name_code, &trans_buf[head_size], name_size);
	trans_buf[0] = breeder_no;
	trans_buf[1] = name_size;
	trans_buf[2] = 0;	//ꉞ4oCgE_~[
	trans_buf[3] = 0;	//ꉞ4oCgE_~[
	
	OS_TPrintf("OMFu[_[No=%d, OTCY=%d\n", breeder_no, name_size);
	if(CommSendData(CC_NAME_DATA, trans_buf, name_size + head_size) == TRUE){
		consys->recieve_count = 0;
		ret = TRUE;
	}
	else{
		ret = FALSE;
	}
	
	sys_FreeMemoryEz(trans_buf);
	return ret;
}

