//==============================================================================
/**
 * @file	con_result.h
 * @brief	ReXgʔ\ʂ̃wb_
 * @author	matsuda
 * @date	2006.03.17()
 */
//==============================================================================
#ifndef __CON_RESULT_H__
#define __CON_RESULT_H__

#include "system/procsys.h"
#include "battle/battle_common.h"
#include "system/buflen.h"
#include "contest/contest.h"
#include "system/softsprite.h"
#include "system/fontproc.h"
#include "system/msgdata.h"
#include "system/gra_tool.h"
#include "system/wordset.h"
#include "system/clact_tool.h"
#include "contest_order.h"
#include "system/fontoam.h"

#include "adv_tool.h"
#include "res_snd_def.h"



//==============================================================================
//	萔`
//==============================================================================
//--------------------------------------------------------------
//	
//--------------------------------------------------------------
///|PʒuZ(C_T[)
#define CONRES_POKEPOS_Z_MAIN		(APPEAR_Z_TYPE_AA)
///|PʒuZ(obN_T[)
#define CONRES_POKEPOS_Z_SUB			(CONRES_POKEPOS_Z_MAIN - 0x80)

///C_T[̃|Pgk(XY)
#define CONRES_POKEAFF_MAIN		(0x0100)
///obN_T[̃|Pgk(XY)
#define CONRES_POKEAFF_BACK		(0x00c0)	//(0x0080)

///_X僁CʂŎgptHgOAM̍ő吔
#define CONRES_FONTOAM_MAX_MAIN	(10)	// 10 = Ƃ肠K

//--------------------------------------------------------------
//	obt@
//--------------------------------------------------------------
///obt@̃TCY
#define CONRES_MESSAGE_BUF_SIZE	(2*160)		///<błPUO

//--------------------------------------------------------------
//	t[ԍ
//--------------------------------------------------------------
///EBhEEbZ[Wʂ̃t[
#define CONRES_FRAME_WIN				(GF_BGL_FRAME1_M)
///GtFNgʂ̃t[
#define CONRES_FRAME_EFF				(GF_BGL_FRAME2_M)
///wiʂ̃t[
#define CONRES_FRAME_BACKGROUND			(GF_BGL_FRAME3_M)

///<BGԍFEBhE
#define CONRES_BGNO_WIN			(1)
///<BGԍFGtFNg
#define CONRES_BGNO_EFF			(2)
///<BGԍFwi
#define CONRES_BGNO_BACKGROUND	(3)

///<3DʂBGvCIeB
#define CONRES_3DBG_PRIORITY		(2)
///EBhEʂBGvCIeB
#define CONRES_BGPRI_WIN			(0)
///GtFNgʂBGvCIeB
#define CONRES_BGPRI_EFF			(0)
///wiʂBGvCIeB
#define CONRES_BGPRI_BACKGROUND		(3)


//--------------------------------------------------------------
//	BMPEBhE
//--------------------------------------------------------------
enum{
	CONRES_BMPWIN_TALK,		///<bEBhE
	
	CONRES_BMPWIN_MAX,
};

//--------------------------------------------------------------
//	bEBhE
//--------------------------------------------------------------
///bEBhẼLN^]ItZbg(LN^P)
#define CONRES_TALKWIN_CGX_OFFSET	(1)
///bEBhEwiF
#define CONRES_TALKWIN_BACK_COLOR	(15)
///bEBhEŎgpEBhELN^p^[
#define CONRES_TALKWIN_WIN_NO		(0)
///bEBhẼpbgԍ
#define CONRES_TALKWIN_PALNO		(14)


//--------------------------------------------------------------
//	bZ[W
//--------------------------------------------------------------
///bZ[W^O
enum{
	CRTAG_NONE,		///<^OȂ
	
	CRTAG_RANK,		///<ReXgN
	CRTAG_OYA_NICK,	///<eAjbNl[
	
	CRTAG_MAX,
};

//==============================================================================
//	\̒`
//==============================================================================
//--------------------------------------------------------------
//	bZ[W
//--------------------------------------------------------------
///Z僁bZ[Wf[^
typedef struct{
	u16 msg_id;				///<bZ[WID
	u8 msg_tag;				///<^OR[h
}CONRES_MESSAGE_PARAM;

///bZ[W^OWJꍇAQƂp[^
typedef struct{
	u8 mine_brd;		///<MINEw肳ĂɎQƂu[_[̔ԍ
	u8 enemy_brd;		///<ENEMYw肳ĂɎQƂu[_[̔ԍ
	u16 wazano;			///<WAZAw肳ĂɎQƂZԍ
	u8 num;				///<NUMw肳Ăɕ\鐔l
	u8 judge_no;		///<JUDGEw肳ĂɎQƂR̔ԍ
}CRTAG_PARAM;

//--------------------------------------------------------------
//	
//--------------------------------------------------------------

///CV[PXŎgp郍[J[N
typedef struct{
	u16 seq;
	u16 select_seq;
	s32 work;
}CONRES_LOCAL_WORK;

//--------------------------------------------------------------
/**
 * @brief   _Xisp[^(݋ZoĂ|P̐isp[^)
 */
//--------------------------------------------------------------
typedef struct{
	u8 now_breeder;					///<ݏɏoĂu[_[̔ԍ
	u8 now_pos;						///<ݏɏoĂu[_[ԖڂɃAs[Ă邩
	
	CRTAG_PARAM a_talk_tagpara;		///<m[}bF^OWJpp[^
	u8 a_talk_id;					///<m[}bID(A_TALK_CONRES_???)
	u8 a_talk_bmpwin_close_wait;	///<bZ[W\ĂEBhE܂łwait
	u8 a_talk_bmpwin_not_close;		///<TRUE:EBhEɏI
}CONRES_ADVANCE_PARAM;

//--------------------------------------------------------------
/**
 * @brief   _XQ[isp[^
 *
 * ̃p[^ΑSʂč\zo邾̏񂪓Ă܂B
 * ʐM̓T[o[q@̓f[^󂯎鎖ɂȂ܂B
 * {IɃj[ʂ̉ʕÂ悤ȎȂA
 * X̎q@ŒlQƂ鎖͂Ȃ͂łB
 */
//--------------------------------------------------------------
typedef struct{
	u8 breeder_sort[BREEDER_MAX];	///<Zo(o鏇Ƀu[_[ԍĂ܂)
	u8 breeder_end_count;			///<sIu[_[̐JEg

	u16 dummy;	//4oCgEItZbg
}CONRES_GAME_PARAM;

//--------------------------------------------------------------
/**
 * @brief   ߑMpp[^
 * 
 * T[o[Ƃ̖߂̑MɎgp܂
 */
//--------------------------------------------------------------
typedef struct{
	u8 breeder_no;
	
	u8 buffer[255];					///<e߂Ōʂɓnf[^ςꍇAgp
}CONRES_ORDER_PARAM;

//--------------------------------------------------------------
/**
 * @brief   Q[ʂ\邽߂ɕKvȃVXef[^ނ\
 *
 * ʐMłSẴ}VŌʂɍ쐬܂
 * eX^btߎMÃ}VXŐ̃[Nobt@nɂȂ܂
 */
//--------------------------------------------------------------
typedef struct{
	CONTEST_GAME_PARAM *c_game;		///<ReXgisp[^(tŊɒʐMς݂̃f[^ւ̃|C^BQƗp)
	
	SOFT_SPRITE_MANAGER	*soft_sprite;
	SOFT_SPRITE *ss[BREEDER_MAX];
	CATS_SYS_PTR		csp;
	CATS_RES_PTR		crp;
	GF_BGL_INI *bgl;
	GF_BGL_BMPWIN win[CONRES_BMPWIN_MAX];
	MSGDATA_MANAGER *conres_msg;	///<_X僁bZ[WpbZ[W}l[W̃|C^
	WORDSET *wordset;
	STRBUF *msg_buf;				///<Allocobt@ւ̃|C^
	PALETTE_FADE_PTR pfd;			///<pbgtF[hVXeւ̃|C^
	FONTOAM_SYS_PTR fontoam_sys;	///<tHgOAMVXeւ̃|C^
	
	EXCHR_PARAM exchr_param[BREEDER_MAX];		///<ZGtFNgpLWJobt@

	u8 talk_msg_index;				///<`惋[`̃CfbNX
}CONRES_SYSTEM_PARAM;

//--------------------------------------------------------------
/**
 * @brief   _XǗ[N
 *
 * _XŜǗ匳̃[NɂȂ܂B
 * ʐMłSẴ}VŌʂɍ쐬܂
 */
//--------------------------------------------------------------
typedef struct _CONRES_PROC_WORK{
	CONTEST_SYSTEM *consys;			///<ReXgVXe[Nւ̃|C^
	TCB_PTR update_tcb;				///<VXeXV
	
	CONRES_SYSTEM_PARAM sys;			///<_XVXef[^p[^
	CONRES_GAME_PARAM r_game;			///<Q[isp[^
	CONRES_ADVANCE_PARAM advance;		///<isp[^
	CONRES_ORDER_PARAM order[BREEDER_MAX];	///<߃p[^
	
	u16 seq;
	u16 tbl_seq_no;					///<CV[PXe[u̔ԍ
	u8 proc_mode;					///<݂̓

	CONTEST_ORDER_WORK cow;			///<M[N

	CONRES_LOCAL_WORK local;			///<[J[N
	u8 main_end;					///<TRUE:CI
}CONRES_PROC_WORK;


//==============================================================================
//	O֐錾
//==============================================================================
extern PROC_RESULT ConresProc_Init( PROC * proc, int * seq );
extern PROC_RESULT ConresProc_Main( PROC * proc, int * seq );
extern PROC_RESULT ConresProc_End( PROC * proc, int * seq );

//==============================================================================
//	Of[^錾
//==============================================================================
extern const PROC_DATA ContestResultProcData;



#endif	//__CON_RESULT_H__

