//==============================================================================
/**
 * @file	con_tool.c
 * @brief	ReXgŜŎgpėpIȃc[
 * @author	matsuda
 * @date	2005.11.22()
 */
//==============================================================================
#include "common.h"
#include "contest/contest.h"
#include "con_tool.h"
#include "actin.h"

#include "field/fieldobj_code.h"

#include "battle\chr_def.h"
#include "system/gra_tool.h"
#include "poketool/monsno.h"

#include "msgdata/msg_cmsg_acting.h"
#include "msgdata/msg_cmsg_judge.h"
#include "msgdata/msg_cmsg_breeder.h"
#include "msgdata/msg_cmsg_wazaexplain.h"
#include "msgdata/msg_cmsg_wazakouka.h"
#include "msgdata/msg.naix"

#include "battle/trtype_def.h"


//==============================================================================
//	f[^
//==============================================================================
#include "breeder.dat"
#include "judge.dat"
#include "ap_waza.dat"

///CPUu[_[̐
#define BREEDER_CPU_DATA_MAX	(NELEMS(BreederDataTbl))
///Rf[^̐
#define JUDGE_DATA_MAX			(NELEMS(JudgeDataTbl))
///Zʃf[^̐
#define APPEAL_WAZA_DATA_MAX	(NELEMS(AppealWazaData))


//--------------------------------------------------------------
/**
 * @brief   T[o[`FbN
 *
 * @param   consys		ReXgVXe[Nւ̃|C^
 *
 * @retval  TRUE:T[o[
 */
//--------------------------------------------------------------
int ConTool_ServerMineCheck(CONTEST_SYSTEM *consys)
{
	if(consys->sio_flag == FALSE 
			|| (consys->sio_flag == TRUE 
			&& consys->c_game.server_no == consys->c_game.my_breeder_no)){
		return TRUE;
	}
	return FALSE;
}

//--------------------------------------------------------------
/**
 * @brief   ʐMtOĂ邩擾
 *
 * @param   consys		ReXgVXe[Nւ̃|C^
 *
 * @retval  TRUE:ʐMtOĂB
 * @retval  FALSE:ʐMtOĂȂB
 */
//--------------------------------------------------------------
int ConTool_ContestSioFlagCheck(CONTEST_SYSTEM *consys)
{
	return consys->sio_flag;
}

//--------------------------------------------------------------
/**
 * @brief   ReXgɎQCPUu[_[̃f[^Zbg
 *
 * @param   entry_num	QCPU̐
 * @param   type		QReXg̎
 * @param   rank		ReXg̃N
 */
//--------------------------------------------------------------
void ConTool_CpuBreederEntry(CONTEST_SYSTEM *consys, int entry_num, int type, int rank)
{
	int i, t;
	u8 putbrd[BREEDER_CPU_DATA_MAX+1];
	u8 count = 0;
	u16 no;
	int palace = FALSE;
	
#if WAIT_FIX
	if(EventFlagCheck( SYS_GAME_CLEAR ) != 0 && (ContestTuusin & C_TUUSIN_FLG) == 0){
		palace = TRUE;		//a肵ĂāAʐMΐłȂ
	}
#endif

	for(i = 0; i < BREEDER_CPU_DATA_MAX; i++){
		
		if(rank != BreederDataTbl[i].rank)
			continue;
		//oo^C~O`FbN
		if(palace == TRUE){
			if(BreederDataTbl[i].appear == PALACE_BEFORE){
				continue;
			}
		}
		else{
			if(BreederDataTbl[i].appear == PALACE_AFTER){
				continue;
			}
		}
		
		if((type == CONTYPE_STYLE && BreederDataTbl[i].part_style)
				|| (type == CONTYPE_BEAUTIFUL && BreederDataTbl[i].part_beautiful)
				|| (type == CONTYPE_CUTE && BreederDataTbl[i].part_cute)
				|| (type == CONTYPE_CLEVER && BreederDataTbl[i].part_clever)
				|| (type == CONTYPE_STRONG && BreederDataTbl[i].part_strong)){
			putbrd[count++] = i;
		}
	}
	putbrd[count] = 0xff;	//ԕ
	
	GF_ASSERT(count >= entry_num);
	for(i = BREEDER_MAX - entry_num; i < BREEDER_MAX; i++){
		no = contest_rand(consys) % count;
		consys->c_game.bd[i] = BreederDataTbl[putbrd[no]];
		for(t = no; putbrd[t] != 0xff; t++)
			putbrd[t] = putbrd[t+1];
		count--;
	}
}

//--------------------------------------------------------------
/**
 * @brief   u[_[[NɎ̃u[_[f[^Zbg
 * @param   temotino		莝̉Ԗڂ̃|P̃f[^Zbg邩
 */
//--------------------------------------------------------------
void SetMyBreederData(CONTEST_SYSTEM *consys, u8 temotino)
{
#if WAIT_FIX
	u16 itemno;
	u8 buff[20];
	s16 style, beautiful, cute, clever, strong;
	
	PM_strcpy(buff, myd->my_name);
#if	( PM_LANG== LANG_JAPAN )
	buff[5] = EOM_;		//[JCYΉ̂5Ő؂
#endif
	PM_strcpy(BreederParam[MyBreederNo].name, buff);
	if(myd->my_sex == MALE)
		BreederParam[MyBreederNo].pattern = CTHERO;	//HERO;
	else
		BreederParam[MyBreederNo].pattern = CTHINE;	//HEROINE;
	BreederParam[MyBreederNo].ai = 0;
	BreederParam[MyBreederNo].msg[0] = 0;//EOM_;
	BreederParam[MyBreederNo].monsno = PokeParaGet(&PokeParaMine[temotino], ID_monsno);
	PokeParaGet(&PokeParaMine[temotino], ID_nickname, buff);
	NickNameCutOff(buff);
	PM_strcpy(BreederParam[MyBreederNo].nickname, buff);
	BreederParam[MyBreederNo].style = PokeParaGet(&PokeParaMine[temotino], ID_style);
	BreederParam[MyBreederNo].beautiful
			 = PokeParaGet(&PokeParaMine[temotino], ID_beautiful);
	BreederParam[MyBreederNo].cute = PokeParaGet(&PokeParaMine[temotino], ID_cute);
	BreederParam[MyBreederNo].clever = PokeParaGet(&PokeParaMine[temotino], ID_clever);
	BreederParam[MyBreederNo].strong = PokeParaGet(&PokeParaMine[temotino], ID_strong);
	BreederParam[MyBreederNo].fur = PokeParaGet(&PokeParaMine[temotino], ID_fur);
	BreederParam[MyBreederNo].waza[0] = PokeParaGet(&PokeParaMine[temotino], ID_waza1);
	BreederParam[MyBreederNo].waza[1] = PokeParaGet(&PokeParaMine[temotino], ID_waza2);
	BreederParam[MyBreederNo].waza[2] = PokeParaGet(&PokeParaMine[temotino], ID_waza3);
	BreederParam[MyBreederNo].waza[3] = PokeParaGet(&PokeParaMine[temotino], ID_waza4);
	BreederParam[MyBreederNo].personal_rnd = PokeParaGet(&PokeParaMine[temotino], ID_personal_rnd);
	BreederParam[MyBreederNo].id_no = PokeParaGet(&PokeParaMine[temotino], ID_id_no);
	
	itemno = PokeParaGet(&PokeParaMine[temotino], ID_item);

	style = BreederParam[MyBreederNo].style;
	beautiful = BreederParam[MyBreederNo].beautiful;
	cute = BreederParam[MyBreederNo].cute;
	clever = BreederParam[MyBreederNo].clever;
	strong = BreederParam[MyBreederNo].strong;
	if(itemno == ITEM_AKAIBANDANA)
		style += 20;
	else if(itemno == ITEM_AOIBANDANA)
		beautiful += 20;
	else if(itemno == ITEM_PINKUNOBANDANA)
		cute += 20;
	else if(itemno == ITEM_MIDORINOBANDANA)
		clever += 20;
	else if(itemno == ITEM_KIIRONOBANDANA)
		strong += 20;
	
	if(style > 255)
		style = 255;
	if(beautiful > 255)
		beautiful = 255;
	if(cute > 255)
		cute = 255;
	if(clever > 255)
		clever = 255;
	if(strong > 255)
		strong = 255;
	BreederParam[MyBreederNo].style = style;
	BreederParam[MyBreederNo].beautiful = beautiful;
	BreederParam[MyBreederNo].cute = cute;
	BreederParam[MyBreederNo].clever = clever;
	BreederParam[MyBreederNo].strong = strong;

#if CONTEST_SIO_CORRECTION
#if ( PM_LANG != LANG_JAPAN )	//{Ƃ̒ʐMpɑMް̖OĂ
	ContestJapanSioNameCut();
#endif
#endif

#else
	consys->c_game.bd[3] = BreederDataTbl[0];
#endif
}

//--------------------------------------------------------------
/**
 * @brief   u[_[f[^POKEMON_PARAM쐬
 *
 * @param   bd		u[_[f[^
 * @param   pp		|Pp
 * @param   heap_id	q[vID
 * 
 * @retval  pp		쐬POKEMON_PARAMւ̃|C^
 */
//--------------------------------------------------------------
void ConTool_BreederPokeParaCreate(const BREEDER_DATA *bd, POKEMON_PARAM *pp, int heap_id)
{
	int i;
	u16 waza_no;
	
	PokeParaSetSexChr(pp, bd->monsno, 10, POW_RND, bd->sex, CHR_GANBARIYA, 0);
	//莝ZZbg
	for(i = 0; i < WAZA_TEMOTI_MAX; i++){
		waza_no = bd->waza[i];
		PokeParaPut(pp, ID_PARA_waza1 + i, &waza_no);
	}

	//jbNl[Ɛe
	{
		STRBUF *nickname_src, *oyaname_src;
		MSGDATA_MANAGER *man;
		
		man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, 
			NARC_msg_cmsg_breeder_dat, HEAPID_CONTEST);
		nickname_src = MSGMAN_AllocString(man, bd->nickname_id);
		oyaname_src = MSGMAN_AllocString(man, bd->name_id);
		
		PokeParaPut(pp, ID_PARA_nickname_buf, nickname_src);
		PokeParaPut(pp, ID_PARA_oyaname_buf, oyaname_src);
		
		STRBUF_Delete(nickname_src);
		STRBUF_Delete(oyaname_src);
		MSGMAN_Delete(man);
	}
}

//--------------------------------------------------------------
/**
 * @brief   ReXgp̃|P\tgEFAXvCg֐
 *
 * @param   ssm_p		\tgEFAXvCg}l[Wւ̃|C^
 * @param   poly_id		|SID
 * @param   pp			POKEMON_PARAMւ̃|C^
 * @param   dir			|P̌(PARA_FRONT or PARA_BACK)
 * @param   ep			OAMւ̓WJpobt@ւ̃|C^(gpȂꍇNULL)
 * @param   heap_id		q[vID(ꎞgp)
 * @param   x			\WX
 * @param   y			\WY
 * @param   z			\WZ
 *
 * @retval  \tgEFAXvCg̃|C^
 *
 * SŎg悤ɔėpIɗpӂĂłB
 * ep͋ZGtFNgoȂ̂łNULLwővłB
 */
//--------------------------------------------------------------
SOFT_SPRITE * ConTool_BreederPokemonAdd(SOFT_SPRITE_MANAGER *ssm_p, int poly_id, 
	POKEMON_PARAM *pp, int dir, EXCHR_PARAM *ep, int heap_id, int x, int y, int z)
{
	SOFT_SPRITE_ARC ssa;
	SOFT_SPRITE	*ss;
	int height, sex, monsno;
	
	PokeGraArcDataGetPP(&ssa, pp, dir);
	sex = PokeSexGet(pp);
	monsno = PokeParaGet(pp, ID_PARA_monsno, NULL);
	height = PokeHeightGet(monsno, sex, dir);

	if(ep != NULL){
		GF_ASSERT(ep->exchr_buffer != NULL);
		ChangesInto_BattlePokeData(ssa.arc_no, ssa.index_chr, heap_id, ep->exchr_buffer);
		ep->pal_index = ssa.index_pal;
	}
	ss = SoftSpriteAdd(ssm_p, &ssa, x, y + height, z, poly_id, NULL, NULL);
	return ss;
}

//--------------------------------------------------------------
/**
 * @brief   ReXgRR̃f[^Zbg
 *
 * @param   sp_no		RNo
 * @param   type		ReXg̎
 * @param   rank		ReXg̃N
 */
//--------------------------------------------------------------
void ConTool_JudgeEntry(CONTEST_SYSTEM *consys, int sp_no, int type, int rank)
{
	int i, t;
	u8 putjudge[JUDGE_DATA_MAX+1], sp_putjudge[JUDGE_DATA_MAX+1];
	u8 count = 0, sp_count = 0;
	u16 no;
	
	for(i = 0; i < JUDGE_DATA_MAX; i++){
		if(rank != JudgeDataTbl[i].rank)
			continue;
		
		if(type == CONTYPE_STYLE && JudgeDataTbl[i].condition_style){
			if(JudgeDataTbl[i].condition_style > 1){
				sp_putjudge[sp_count++] = i;
			}
			else{
				putjudge[count++] = i;
			}
		}
		else if(type == CONTYPE_BEAUTIFUL && JudgeDataTbl[i].condition_beautiful){
			if(JudgeDataTbl[i].condition_beautiful > 1){
				sp_putjudge[sp_count++] = i;
			}
			else{
				putjudge[count++] = i;
			}
		}
		else if(type == CONTYPE_CUTE && JudgeDataTbl[i].condition_cute){
			if(JudgeDataTbl[i].condition_cute > 1){
				sp_putjudge[sp_count++] = i;
			}
			else{
				putjudge[count++] = i;
			}
		}
		else if(type == CONTYPE_CLEVER && JudgeDataTbl[i].condition_clever){
			if(JudgeDataTbl[i].condition_clever > 1){
				sp_putjudge[sp_count++] = i;
			}
			else{
				putjudge[count++] = i;
			}
		}
		else if(type == CONTYPE_STRONG && JudgeDataTbl[i].condition_strong){
			if(JudgeDataTbl[i].condition_strong > 1){
				sp_putjudge[sp_count++] = i;
			}
			else{
				putjudge[count++] = i;
			}
		}
	}
	putjudge[count] = 0xff;	//ԕ
	sp_putjudge[sp_count] = 0xff;	//ԕ
	
	//m[}R
	GF_ASSERT(count >= NORMAL_JUDGE_MAX);
	for(i = 0; i < NORMAL_JUDGE_MAX; i++){
		no = contest_rand(consys) % count;
		consys->c_game.jd[i] = JudgeDataTbl[putjudge[no]];
		for(t = no; putjudge[t] != 0xff; t++)
			putjudge[t] = putjudge[t+1];
		count--;
	}
	
	//R
	GF_ASSERT(sp_count >= GUEST_JUDGE_MAX);
	no = contest_rand(consys) % sp_count;
	consys->c_game.jd[NORMAL_JUDGE_MAX] = JudgeDataTbl[sp_putjudge[no]];
	
	//R̈ʒu肵ARf[^ёւ
	{
		JUDGE_DATA swap_jd;
		
		consys->c_game.special_judge_no = sp_no;
		swap_jd = consys->c_game.jd[sp_no];
		consys->c_game.jd[sp_no] = consys->c_game.jd[NORMAL_JUDGE_MAX];
		consys->c_game.jd[NORMAL_JUDGE_MAX] = swap_jd;
		OS_TPrintf("sp_no = %d\n", sp_no);
	}
}

//--------------------------------------------------------------
/**
 * @brief   APl擾
 * @param   appeal_no		As[Zԍ
 * @retval  APl(WQl̏ꍇ̓}CiX)
 */
//--------------------------------------------------------------
s8 ConTool_GetAPWaza_App(int appeal_no)
{
	GF_ASSERT(appeal_no < APPEAL_WAZA_DATA_MAX);
	return AppealWazaData[appeal_no].ap_point;
}

//--------------------------------------------------------------
/**
 * @brief   ZbZ[WID擾
 *
 * @param   appeal_no		As[Zԍ
 * @param   u_id			bZ[WĩbZ[WID
 * @param   d_id			bZ[WĩbZ[WID
 */
//--------------------------------------------------------------
void ConTool_GetAPSetumeiMsgID(int appeal_no, u32 *u_id, u32 *d_id)
{
	GF_ASSERT(appeal_no < APPEAL_WAZA_DATA_MAX);
	*u_id = AppealWazaData[appeal_no].setumei_u_id;
	*d_id = AppealWazaData[appeal_no].setumei_d_id;
}

//--------------------------------------------------------------
/**
 * @brief   ZʃbZ[WIDƃ^OR[h擾
 *
 * @param   appeal_no		As[Zԍ
 * @param   msg_type		擾郁bZ[W^Cv(KOUKA_MSGID_???)
 * @param   msg_id			bZ[WID
 * @param   msg_tag			bZ[W^O
 */
//--------------------------------------------------------------
void ConTool_GetKoukaMsgID(int appeal_no, int msg_type, u32 *msg_id, u32 *msg_tag)
{
	GF_ASSERT(appeal_no < APPEAL_WAZA_DATA_MAX);
	switch(msg_type){
	case KOUKA_MSGID_A:
		*msg_id = AppealWazaData[appeal_no].kouka_msgid_a;
		*msg_tag = AppealWazaData[appeal_no].kouka_msgtag_a;
		break;
	case KOUKA_MSGID_B:
		*msg_id = AppealWazaData[appeal_no].kouka_msgid_b;
		*msg_tag = AppealWazaData[appeal_no].kouka_msgtag_b;
		break;
	case KOUKA_MSGID_C:
		*msg_id = AppealWazaData[appeal_no].kouka_msgid_c;
		*msg_tag = AppealWazaData[appeal_no].kouka_msgtag_c;
		break;
	case KOUKA_MSGID_D:
	default:
		*msg_id = AppealWazaData[appeal_no].kouka_msgid_d;
		*msg_tag = AppealWazaData[appeal_no].kouka_msgtag_d;
		break;
	}
}

//--------------------------------------------------------------
/**
 * @brief   ReXgNÃÑbZ[WID擾
 * @param   con_rank		ReXgN(CONRANK_???)
 * @retval  bZ[WID
 */
//--------------------------------------------------------------
u32 ConTool_GetRankMsgID(int con_rank)
{
	u32 str_id;
	
	switch(con_rank){
	case CONRANK_NORMAL:
		str_id = CAMSG_CONRANK_NORMAL;
		break;
	case CONRANK_SUPER:
		str_id = CAMSG_CONRANK_SUPER;
		break;
	case CONRANK_HYPER:
		str_id = CAMSG_CONRANK_HYPER;
		break;
	case CONRANK_MASTER:
	default:
		str_id = CAMSG_CONRANK_MASTER;
		break;
	}
	return str_id;
}

//--------------------------------------------------------------
/**
 * @brief   ReXg^CvÃ^CṽbZ[WID擾
 * @param   con_rank		ReXg^Cv(CONTYPE_???)
 * @retval  bZ[WID
 */
//--------------------------------------------------------------
u32 ConTool_GetTypeMsgID(int con_type)
{
	u32 str_id;
	
	switch(con_type){
	case CONTYPE_STYLE:
		str_id = CAMSG_CONTYPE_STYLE;
		break;
	case CONTYPE_BEAUTIFUL:
		str_id = CAMSG_CONTYPE_BEAUTIFUL;
		break;
	case CONTYPE_CUTE:
		str_id = CAMSG_CONTYPE_CUTE;
		break;
	case CONTYPE_CLEVER:
		str_id = CAMSG_CONTYPE_CLEVER;
		break;
	case CONTYPE_STRONG:
	default:
		str_id = CAMSG_CONTYPE_STRONG;
		break;
	}
	return str_id;
}

