//==============================================================================
/**
 * @file	contest.c
 * @brief	ReXg
 * @author	matsuda
 * @date	2005.11.15()
 *
 * tB[hƂ̐ڑȂǂɂ
 */
//==============================================================================
#include "common.h"
#include "contest/contest.h"
#include "con_tool.h"
#include "actin.h"
#include "visual.h"
#include "dance.h"
#include "con_result.h"

#include "field/field_common.h"
#include "field/field_event.h"
#include "field/fieldsys.h"
#include "field/ev_mapchange.h"

#include "poketool/pokeparty.h"
#include "system/pm_rtc.h"
#include "communication/communication.h"
#include "comm_command_contest.h"
#include "field/comm_field_state.h"
#include "msgdata/msg_cmsg_acting.h"


//==============================================================================
//
//	tB[h牉Z͕ւ̐ڑ
//
//==============================================================================

//==============================================================================
//	\̒`
//==============================================================================
typedef struct{
	int seq;
}EV_ACTING_WORK;

typedef struct{
	CONTEST_SYSTEM *consys;		///<check@ȓEo܂܂ł̎b
	EV_ACTING_WORK *eaw;
	int seq;
}EV_SUB_ACTING_WORK;


typedef struct{
	int seq;
}EV_VISUAL_WORK;

typedef struct{
	CONTEST_SYSTEM *consys;		///<check@ȓEo܂܂ł̎b
	int seq;
}EV_SUB_VISUAL_WORK;

typedef struct{
	CONTEST_SYSTEM *consys;		///<check@ȓEo܂܂ł̎b
	int seq;
}EV_SIO_CONTEST_WORK;



//==============================================================================
//	vg^Cv錾
//==============================================================================
void ContestActin_FieldConnectStart(FIELDSYS_WORK *fsys);
static BOOL GMEVENT_ContestActing(GMEVENT_CONTROL * event);
static BOOL GMEVENT_Sub_ContestActing(GMEVENT_CONTROL * event);
void EventCmd_ContestActingProc(GMEVENT_CONTROL * event);
static CONTEST_SYSTEM * Contest_SystemWorkAlloc(void);
static void Contest_SystemWorkFree(CONTEST_SYSTEM *consys);
static void contest_srand(CONTEST_SYSTEM *consys);
u16 contest_rand(CONTEST_SYSTEM *consys);
static BOOL GMEVENT_ContestVisual(GMEVENT_CONTROL * event);
void EventCmd_ContestVisualProc(GMEVENT_CONTROL * event);
static BOOL GMEVENT_Sub_ContestVisual(GMEVENT_CONTROL * event);
static BOOL GMEVENT_ContestDance(GMEVENT_CONTROL * event);
void EventCmd_ContestDanceProc(GMEVENT_CONTROL * event);
static BOOL GMEVENT_Sub_ContestDance(GMEVENT_CONTROL * event);
void EventCmd_ContestSioProc(GMEVENT_CONTROL * event);
static BOOL GMEVENT_Sub_ContestSio(GMEVENT_CONTROL * event);
BOOL Contest_SioParamInitSet(CONTEST_SYSTEM *consys);
BOOL Contest_SioFastDataEndCheck(CONTEST_SYSTEM *consys);
static void ContestComm_SioFastDate(TCB_PTR tcb, void *work);
CONTEST_SYSTEM * Contest_SystemCreate(int contest_type, int contest_rank, int contest_mode, 
	POKEMON_PARAM *my_pp, const STRBUF *player_name_str, const MYSTATUS *my_status);
void Contest_SystemExit(CONTEST_SYSTEM *consys);
void ConScr_JudgeNameGet(CONTEST_SYSTEM *consys, int judge_no, WORDSET *wordset, u32 buf_id);
void ConScr_BreederNameGet(CONTEST_SYSTEM *consys, int breeder_no, WORDSET *wordset, u32 buf_id);
void ConScr_NickNameGet(CONTEST_SYSTEM *consys, int breeder_no, WORDSET *wordset, u32 buf_id);
static BOOL GMEVENT_Sub_Contest(GMEVENT_CONTROL * event);
void ContestResult_FieldConnectStart(FIELDSYS_WORK *fsys);
static BOOL GMEVENT_ContestResult(GMEVENT_CONTROL * event);
void EventCmd_ContestResultProc(GMEVENT_CONTROL * event);
static BOOL GMEVENT_Sub_ContestResult(GMEVENT_CONTROL * event);


//==============================================================================
//	PROCf[^
//==============================================================================
FS_EXTERN_OVERLAY(contest);

/// Z͕vZX`f[^
const PROC_DATA ContestActinProcData = {
	ActinProc_Init,
	ActinProc_Main,
	ActinProc_End,
	FS_OVERLAY_ID(contest),
};

/// _XvZX`f[^
const PROC_DATA ContestDanceProcData = {
	DanceProc_Init,
	DanceProc_Main,
	DanceProc_End,
	FS_OVERLAY_ID(contest),
};

/// rWAvZX`f[^
const PROC_DATA ContestVisualProcData = {
	VisualProc_Init,
	VisualProc_Main,
	VisualProc_End,
	FS_OVERLAY_ID(contest),
};

/// ReXgʔ\ʃvZX`f[^
const PROC_DATA ContestResultProcData = {
	ConresProc_Init,
	ConresProc_Main,
	ConresProc_End,
	FS_OVERLAY_ID(contest),
};



//--------------------------------------------------------------
/**
 * @brief   
 *
 * @param   fsys		
 *
 * @retval  
 *
 *
 */
//--------------------------------------------------------------
void ContestActin_FieldConnectStart(FIELDSYS_WORK *fsys)
{
	EV_ACTING_WORK *eaw;
	
	eaw = sys_AllocMemoryLo(HEAPID_WORLD, sizeof(EV_ACTING_WORK));
	MI_CpuClear8(eaw, sizeof(EV_ACTING_WORK));
	FieldEvent_Set(fsys, GMEVENT_ContestActing, eaw);
}

//-----------------------------------------------------------------------------
/**
 * @brief	ReXgFZ͕CxgV[PX
 * @param	event		Cxg䃏[Nւ̃|C^
 * @retval	TRUE		CxgI
 * @retval	FALSE		Cxgp
 *
 * GJEgGtFNgtB[hAsB
 * Q[I[o[ւ̕i\j
 */
//-----------------------------------------------------------------------------
static BOOL GMEVENT_ContestActing(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys;
	EV_ACTING_WORK *eaw;
	
	fsys = FieldEvent_GetFieldSysWork(event);
	eaw = FieldEvent_GetSpecialWork(event);

	switch (eaw->seq) {
	case 0:
		EventCmd_FieldFadeOut(event);
		eaw->seq++;
		break;
	case 1:
		EventCmd_ContestActingProc(event);
		eaw->seq++;
		break;
	case 2:
		EventCmd_FieldFadeIn(event);
		eaw->seq++;
		break;
	case 3:
		sys_FreeMemoryEz(eaw);
		return TRUE;
	}
	return FALSE;
}

void EventCmd_ContestActingProc(GMEVENT_CONTROL * event)
{
	EV_SUB_ACTING_WORK *esaw = sys_AllocMemoryLo(HEAPID_WORLD, sizeof(EV_SUB_ACTING_WORK));
	MI_CpuClear8(esaw, sizeof(EV_SUB_ACTING_WORK));
	FieldEvent_Call(event, GMEVENT_Sub_ContestActing, esaw);
}

static BOOL GMEVENT_Sub_ContestActing(GMEVENT_CONTROL * event)
{
	int len;
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EV_SUB_ACTING_WORK *esaw = FieldEvent_GetSpecialWork(event);

	switch (esaw->seq) {
	case 0:
		EventCmd_FinishFieldMap(event);
		esaw->seq ++;
		break;
	case 1:
		//check	Ȃ̂ŁAƂ肠ŃReXgS̃q[v쐬
		{
			POKEMON_PARAM * poke;
			STRBUF *myname;
			const MYSTATUS *my_status;
			poke = PokeParty_GetMemberPointer( SaveData_GetTemotiPokemon(fsys->savedata), 0);
			my_status = SaveData_GetMyStatus(GameSystem_GetSaveData(fsys));
			myname = MyStatus_CreateNameString(my_status, HEAPID_WORLD);
			
			esaw->consys = Contest_SystemCreate(CONTYPE_STYLE, CONRANK_NORMAL, CONMODE_GRAND, poke, myname, my_status);
			
			STRBUF_Delete(myname);
		}
		
		EventCmd_CallSubProc(event, &ContestActinProcData, esaw->consys);
		esaw->seq ++;
		break;
	case 2:
		//check@oȂ̂ŁAƂ肠ŃReXgS̃q[v
		Contest_SystemExit(esaw->consys);
		
		EventCmd_StartFieldMap(event);
		esaw->seq ++;
		break;
	case 3:
		sys_FreeMemoryEz(esaw);
		return TRUE;
	}
	return FALSE;
}



//==============================================================================
//	rWA
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   
 *
 * @param   fsys		
 *
 * @retval  
 *
 *
 */
//--------------------------------------------------------------
void ContestVisual_FieldConnectStart(FIELDSYS_WORK *fsys)
{
	EV_VISUAL_WORK *eaw;
	
	eaw = sys_AllocMemoryLo(HEAPID_WORLD, sizeof(EV_VISUAL_WORK));
	MI_CpuClear8(eaw, sizeof(EV_VISUAL_WORK));
	FieldEvent_Set(fsys, GMEVENT_ContestVisual, eaw);
}

//-----------------------------------------------------------------------------
/**
 * @brief	ReXgFZ͕CxgV[PX
 * @param	event		Cxg䃏[Nւ̃|C^
 * @retval	TRUE		CxgI
 * @retval	FALSE		Cxgp
 *
 * GJEgGtFNgtB[hAsB
 * Q[I[o[ւ̕i\j
 */
//-----------------------------------------------------------------------------
static BOOL GMEVENT_ContestVisual(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys;
	EV_VISUAL_WORK *eaw;
	
	fsys = FieldEvent_GetFieldSysWork(event);
	eaw = FieldEvent_GetSpecialWork(event);

	switch (eaw->seq) {
	case 0:
		EventCmd_FieldFadeOut(event);
		eaw->seq++;
		break;
	case 1:
		EventCmd_ContestVisualProc(event);
		eaw->seq++;
		break;
	case 2:
		EventCmd_FieldFadeIn(event);
		eaw->seq++;
		break;
	case 3:
		sys_FreeMemoryEz(eaw);
		return TRUE;
	}
	return FALSE;
}

void EventCmd_ContestVisualProc(GMEVENT_CONTROL * event)
{
	EV_SUB_VISUAL_WORK *esaw = sys_AllocMemoryLo(HEAPID_WORLD, sizeof(EV_SUB_VISUAL_WORK));
	MI_CpuClear8(esaw, sizeof(EV_SUB_VISUAL_WORK));
	FieldEvent_Call(event, GMEVENT_Sub_ContestVisual, esaw);
}

static BOOL GMEVENT_Sub_ContestVisual(GMEVENT_CONTROL * event)
{
	int len;
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EV_SUB_VISUAL_WORK *esaw = FieldEvent_GetSpecialWork(event);

	switch (esaw->seq) {
	case 0:
		EventCmd_FinishFieldMap(event);
		esaw->seq ++;
		break;
	case 1:
		//check	Ȃ̂ŁAƂ肠ŃReXgS̃q[v쐬
		{
			POKEMON_PARAM * poke;
			STRBUF *myname;
			const MYSTATUS *my_status;
			poke = PokeParty_GetMemberPointer( SaveData_GetTemotiPokemon(fsys->savedata), 0);
			my_status = SaveData_GetMyStatus(GameSystem_GetSaveData(fsys));
			myname = MyStatus_CreateNameString(my_status, HEAPID_WORLD);

			esaw->consys = Contest_SystemCreate(CONTYPE_STYLE, CONRANK_NORMAL, CONMODE_GRAND, poke, myname, my_status);

			STRBUF_Delete(myname);
		}
		
		EventCmd_CallSubProc(event, &ContestVisualProcData, esaw->consys);
		esaw->seq ++;
		break;
	case 2:
		//check@oȂ̂ŁAƂ肠ŃReXgS̃q[v
		Contest_SystemExit(esaw->consys);
		
		EventCmd_StartFieldMap(event);
		esaw->seq ++;
		break;
	default:
		sys_FreeMemoryEz(esaw);
		return TRUE;
	}
	return FALSE;
}



//==============================================================================
//	_X
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   
 *
 * @param   fsys		
 *
 * @retval  
 *
 *
 */
//--------------------------------------------------------------
void ContestDance_FieldConnectStart(FIELDSYS_WORK *fsys)
{
	EV_VISUAL_WORK *eaw;
	
	eaw = sys_AllocMemoryLo(HEAPID_WORLD, sizeof(EV_VISUAL_WORK));
	MI_CpuClear8(eaw, sizeof(EV_VISUAL_WORK));
	FieldEvent_Set(fsys, GMEVENT_ContestDance, eaw);
}

//-----------------------------------------------------------------------------
/**
 * @brief	ReXgFZ͕CxgV[PX
 * @param	event		Cxg䃏[Nւ̃|C^
 * @retval	TRUE		CxgI
 * @retval	FALSE		Cxgp
 *
 * GJEgGtFNgtB[hAsB
 * Q[I[o[ւ̕i\j
 */
//-----------------------------------------------------------------------------
static BOOL GMEVENT_ContestDance(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys;
	EV_VISUAL_WORK *eaw;
	
	fsys = FieldEvent_GetFieldSysWork(event);
	eaw = FieldEvent_GetSpecialWork(event);

	switch (eaw->seq) {
	case 0:
		EventCmd_FieldFadeOut(event);
		eaw->seq++;
		break;
	case 1:
		EventCmd_ContestDanceProc(event);
		eaw->seq++;
		break;
	case 2:
		EventCmd_FieldFadeIn(event);
		eaw->seq++;
		break;
	case 3:
		sys_FreeMemoryEz(eaw);
		return TRUE;
	}
	return FALSE;
}

void EventCmd_ContestDanceProc(GMEVENT_CONTROL * event)
{
	EV_SUB_VISUAL_WORK *esaw = sys_AllocMemoryLo(HEAPID_WORLD, sizeof(EV_SUB_VISUAL_WORK));
	MI_CpuClear8(esaw, sizeof(EV_SUB_VISUAL_WORK));
	FieldEvent_Call(event, GMEVENT_Sub_ContestDance, esaw);
}

static BOOL GMEVENT_Sub_ContestDance(GMEVENT_CONTROL * event)
{
	int len;
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EV_SUB_VISUAL_WORK *esaw = FieldEvent_GetSpecialWork(event);

	switch (esaw->seq) {
	case 0:
		EventCmd_FinishFieldMap(event);
		esaw->seq ++;
		break;
	case 1:
		//check	Ȃ̂ŁAƂ肠ŃReXgS̃q[v쐬
		{
			POKEMON_PARAM * poke;
			STRBUF *myname;
			const MYSTATUS *my_status;
			poke = PokeParty_GetMemberPointer( SaveData_GetTemotiPokemon(fsys->savedata), 0);
			my_status = SaveData_GetMyStatus(GameSystem_GetSaveData(fsys));
			myname = MyStatus_CreateNameString(my_status, HEAPID_WORLD);
			
			esaw->consys = Contest_SystemCreate(CONTYPE_STYLE, CONRANK_NORMAL, CONMODE_GRAND, poke, myname, my_status);
			
			STRBUF_Delete(myname);
		}
		
		EventCmd_CallSubProc(event, &ContestDanceProcData, esaw->consys);
		esaw->seq ++;
		break;
	case 2:
		//check@oȂ̂ŁAƂ肠ŃReXgS̃q[v
		Contest_SystemExit(esaw->consys);
		
		EventCmd_StartFieldMap(event);
		esaw->seq ++;
		break;
	case 3:
		sys_FreeMemoryEz(esaw);
		return TRUE;
	}
	return FALSE;
}



//==============================================================================
//	ʐMReXg
//==============================================================================
void EventCmd_ContestSioProc(GMEVENT_CONTROL * event)
{
	EV_SIO_CONTEST_WORK *escw = sys_AllocMemoryLo(HEAPID_WORLD, sizeof(EV_SIO_CONTEST_WORK));
	MI_CpuClear8(escw, sizeof(EV_SIO_CONTEST_WORK));
	FieldEvent_Call(event, GMEVENT_Sub_ContestSio, escw);
}

static BOOL GMEVENT_Sub_ContestSio(GMEVENT_CONTROL * event)
{
	int len;
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EV_SIO_CONTEST_WORK *escw = FieldEvent_GetSpecialWork(event);

	switch (escw->seq) {
	case 0:
		EventCmd_FinishFieldMap(event);
		escw->seq ++;
		break;
	case 1:
		//check	Ȃ̂ŁAƂ肠ŃReXgS̃q[v쐬
		{
			POKEMON_PARAM * poke;
			STRBUF *myname;
			const MYSTATUS *my_status;
			poke = PokeParty_GetMemberPointer( SaveData_GetTemotiPokemon(fsys->savedata), 0);
			my_status = SaveData_GetMyStatus(GameSystem_GetSaveData(fsys));
			myname = MyStatus_CreateNameString(my_status, HEAPID_WORLD);

			escw->consys = Contest_SystemCreate(CONTYPE_STYLE, CONRANK_NORMAL, CONMODE_GRAND, poke, myname, my_status);
			
			STRBUF_Delete(myname);
		}
		
		//ʐMf[^Zbg^XNo^ŏʐMJn
		Contest_SioParamInitSet(escw->consys);
		
		escw->seq++;
		break;
	case 2:
		if(Contest_SioFastDataEndCheck(escw->consys) == TRUE){
			escw->seq ++;
		}
		break;
	case 3:
		EventCmd_CallSubProc(event, &ContestVisualProcData, escw->consys);
		escw->seq ++;
		break;
	case 4:
		EventCmd_CallSubProc(event, &ContestDanceProcData, escw->consys);
		escw->seq ++;
		break;
	case 5:
		EventCmd_CallSubProc(event, &ContestActinProcData, escw->consys);
		escw->seq ++;
		break;
	case 6:
		//check@oȂ̂ŁAƂ肠ŃReXgS̃q[v
		Contest_SystemExit(escw->consys);
		escw->seq++;
		break;
	case 7:
//		CommStateExitBattle();  // ʐMIړ܂ 2006.01.05 k.ohno
		escw->seq++;
		break;
	case 8:
		EventCmd_StartFieldMap(event);
		escw->seq ++;
		break;
	default:
		sys_FreeMemoryEz(escw);
		return TRUE;
	}
	return FALSE;
}



//==============================================================================
//	ʔ\
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   
 *
 * @param   fsys		
 *
 * @retval  
 *
 *
 */
//--------------------------------------------------------------
void ContestResult_FieldConnectStart(FIELDSYS_WORK *fsys)
{
	EV_VISUAL_WORK *eaw;
	
	eaw = sys_AllocMemoryLo(HEAPID_WORLD, sizeof(EV_VISUAL_WORK));
	MI_CpuClear8(eaw, sizeof(EV_VISUAL_WORK));
	FieldEvent_Set(fsys, GMEVENT_ContestResult, eaw);
}

//-----------------------------------------------------------------------------
/**
 * @brief	ReXgFZ͕CxgV[PX
 * @param	event		Cxg䃏[Nւ̃|C^
 * @retval	TRUE		CxgI
 * @retval	FALSE		Cxgp
 *
 * GJEgGtFNgtB[hAsB
 * Q[I[o[ւ̕i\j
 */
//-----------------------------------------------------------------------------
static BOOL GMEVENT_ContestResult(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys;
	EV_VISUAL_WORK *eaw;
	
	fsys = FieldEvent_GetFieldSysWork(event);
	eaw = FieldEvent_GetSpecialWork(event);

	switch (eaw->seq) {
	case 0:
		EventCmd_FieldFadeOut(event);
		eaw->seq++;
		break;
	case 1:
		EventCmd_ContestResultProc(event);
		eaw->seq++;
		break;
	case 2:
		EventCmd_FieldFadeIn(event);
		eaw->seq++;
		break;
	case 3:
		sys_FreeMemoryEz(eaw);
		return TRUE;
	}
	return FALSE;
}

void EventCmd_ContestResultProc(GMEVENT_CONTROL * event)
{
	EV_SUB_VISUAL_WORK *esaw = sys_AllocMemoryLo(HEAPID_WORLD, sizeof(EV_SUB_VISUAL_WORK));
	MI_CpuClear8(esaw, sizeof(EV_SUB_VISUAL_WORK));
	FieldEvent_Call(event, GMEVENT_Sub_ContestResult, esaw);
}

static BOOL GMEVENT_Sub_ContestResult(GMEVENT_CONTROL * event)
{
	int len;
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EV_SUB_VISUAL_WORK *esaw = FieldEvent_GetSpecialWork(event);

	switch (esaw->seq) {
	case 0:
		EventCmd_FinishFieldMap(event);
		esaw->seq ++;
		break;
	case 1:
		//check	Ȃ̂ŁAƂ肠ŃReXgS̃q[v쐬
		{
			POKEMON_PARAM * poke;
			STRBUF *myname;
			const MYSTATUS *my_status;
			poke = PokeParty_GetMemberPointer( SaveData_GetTemotiPokemon(fsys->savedata), 0);
			my_status = SaveData_GetMyStatus(GameSystem_GetSaveData(fsys));
			myname = MyStatus_CreateNameString(my_status, HEAPID_WORLD);

			esaw->consys = Contest_SystemCreate(CONTYPE_STYLE, CONRANK_NORMAL, CONMODE_GRAND, poke, myname, my_status);

			STRBUF_Delete(myname);
		}
		
		EventCmd_CallSubProc(event, &ContestResultProcData, esaw->consys);
		esaw->seq ++;
		break;
	case 2:
		//check@oȂ̂ŁAƂ肠ŃReXgS̃q[v
		Contest_SystemExit(esaw->consys);
		
		EventCmd_StartFieldMap(event);
		esaw->seq ++;
		break;
	default:
		sys_FreeMemoryEz(esaw);
		return TRUE;
	}
	return FALSE;
}




//==============================================================================
//	XNvg 
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   XNvg̃ReXgĂяo
 *
 * @param   event		
 * @param   consys		
 */
//--------------------------------------------------------------
void EventCmd_ContestProc(GMEVENT_CONTROL * event, CONTEST_SYSTEM *consys)
{
	EV_SIO_CONTEST_WORK *escw = sys_AllocMemoryLo(HEAPID_WORLD, sizeof(EV_SIO_CONTEST_WORK));
	MI_CpuClear8(escw, sizeof(EV_SIO_CONTEST_WORK));
	escw->consys = consys;
	FieldEvent_Call(event, GMEVENT_Sub_Contest, escw);
}

//--------------------------------------------------------------
/**
 * @brief   XNvg̃ReXgĂяoC^XN
 *
 * @param   event		
 */
//--------------------------------------------------------------
static BOOL GMEVENT_Sub_Contest(GMEVENT_CONTROL * event)
{
	int len;
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EV_SIO_CONTEST_WORK *escw = FieldEvent_GetSpecialWork(event);

	switch (escw->seq) {
	case 0:
		EventCmd_FinishFieldMap(event);
		escw->seq ++;
		break;
	case 1:
		if(escw->consys->sio_flag == FALSE || Contest_SioFastDataEndCheck(escw->consys) == TRUE){
			escw->seq ++;
		}
		break;
	case 2:
		if(escw->consys->c_game.mode == CONMODE_CHARM || 
				escw->consys->c_game.mode == CONMODE_GRAND){
			EventCmd_CallSubProc(event, &ContestVisualProcData, escw->consys);
		}
		escw->seq ++;
		break;
	case 3:
		if(escw->consys->c_game.mode == CONMODE_ACTIVE || 
				escw->consys->c_game.mode == CONMODE_GRAND){
			EventCmd_CallSubProc(event, &ContestDanceProcData, escw->consys);
		}
		escw->seq ++;
		break;
	case 4:
		EventCmd_CallSubProc(event, &ContestActinProcData, escw->consys);
		escw->seq ++;
		break;
	case 5:
		EventCmd_CallSubProc(event, &ContestResultProcData, escw->consys);
		escw->seq ++;
		break;
	case 6:
//		CommStateExitBattle();  // ʐMIړ܂ 2006.01.05 k.ohno
		escw->seq++;
		break;
	case 7:
		EventCmd_StartFieldMap(event);
		escw->seq ++;
		break;
	default:
		sys_FreeMemoryEz(escw);
		return TRUE;
	}
	return FALSE;
}



//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   ReXgVXe[NAlloc
 *
 * @retval  ReXgVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
static CONTEST_SYSTEM * Contest_SystemWorkAlloc(void)
{
	CONTEST_SYSTEM *consys;
	int i;
	
	consys = sys_AllocMemory(HEAPID_CONTEST, sizeof(CONTEST_SYSTEM));
	MI_CpuClear8(consys, sizeof(CONTEST_SYSTEM));
	consys->c_game.my_breeder_no = 0;
	consys->c_game.player_num = 1;
	consys->c_game.cpu_num = BREEDER_MAX - 1;
	return consys;
}

//--------------------------------------------------------------
/**
 * @brief   ReXgVXe[N
 *
 * @param   consys		ReXgVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
static void Contest_SystemWorkFree(CONTEST_SYSTEM *consys)
{
	sys_FreeMemoryEz(consys);
}


//--------------------------------------------------------------
/**
 * @brief   ReXgVXe[N쐬
 *
 * @param   contest_type		ReXg^Cv(CONTYPE_???)
 * @param   contest_rank		ReXgN(CONRANK_???)
 * @param   contest_mode		ReXg[h(CONMODE_???)
 * @param   my_pp				oꂳ鎩̎莝|Pւ̃|C^
 * @param   player_name_str		vC[ւ̃|C^
 * @param   my_status			}CXe[^Xւ̃|C^
 *
 * @retval  쐬ReXgVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
CONTEST_SYSTEM * Contest_SystemCreate(int contest_type, int contest_rank, int contest_mode, 
	POKEMON_PARAM *my_pp, const STRBUF *player_name_str, const MYSTATUS *my_status)
{
	CONTEST_SYSTEM *consys;
	int cpu_num = BREEDER_MAX - 1;
	int i;
	
	sys_CreateHeap(HEAPID_BASE_APP, HEAPID_CONTEST, CONTEST_ALLOC_SIZE);
	consys = Contest_SystemWorkAlloc();
	
	contest_srand(consys);

	consys->c_game.type = contest_type;
	consys->c_game.rank = contest_rank;
	consys->c_game.mode = contest_mode;
	consys->c_game.server_no = consys->c_game.my_breeder_no;
	consys->c_game.my_version = CONTEST_VERSION;
	consys->c_game.server_version = consys->c_game.my_version;
	consys->c_game.special_judge_no = 1;//contest_rand(consys) % JUDGE_MAX;

	//Rf[^Zbg
	ConTool_JudgeEntry(consys, consys->c_game.special_judge_no, 
		consys->c_game.type, consys->c_game.rank);
	//CPUu[_[Zbg
	ConTool_CpuBreederEntry(consys, cpu_num, consys->c_game.type, consys->c_game.rank);
	
	//PokeParty쐬
	consys->poke_party = PokeParty_AllocPartyWork(HEAPID_CONTEST);
	//PokePara쐬
	for(i = 0; i < BREEDER_MAX; i++){
		consys->c_game.pp[i] = PokemonParam_AllocWork(HEAPID_CONTEST);
	}

	//CPŨ|Pp[^쐬
	for(i = BREEDER_MAX - cpu_num; i < BREEDER_MAX; i++){
		ConTool_BreederPokeParaCreate(&consys->c_game.bd[i], consys->c_game.pp[i], HEAPID_CONTEST);
	}

	//̃|PZbg
//	consys->c_game.bd[0] = consys->c_game.bd[3];
//	ConTool_BreederPokeParaCreate(&consys->c_game.bd[0], consys->c_game.pp[0], HEAPID_CONTEST);
	PokeCopyPPtoPP(my_pp, consys->c_game.pp[0]);
	
	//u[_[Zbg(eu[_[ł͂Ȃ̂)
	consys->c_game.breeder_name_str[0] = STRBUF_Create(BUFLEN_PERSON_NAME, HEAPID_CONTEST);
	STRBUF_Copy(consys->c_game.breeder_name_str[0], player_name_str);
	for(i = 1; i < BREEDER_MAX; i++){
		consys->c_game.breeder_name_str[i] = STRBUF_Create(BUFLEN_PERSON_NAME, HEAPID_CONTEST);
		PokeParaGet(consys->c_game.pp[i], ID_PARA_oyaname_buf, consys->c_game.breeder_name_str[i]);
	}

	//ʃZbg
	consys->c_game.player_sex[0] = MyStatus_GetMySex(my_status);
	for(i = 1; i < BREEDER_MAX; i++){
		consys->c_game.player_sex[i] = consys->c_game.bd[i].sex;
	}
	
	return consys;
}

//--------------------------------------------------------------
/**
 * @brief   Contest_SystemCreategpčReXgVXe[N
 *
 * @param   consys		ReXgVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
void Contest_SystemExit(CONTEST_SYSTEM *consys)
{
	int i;
	
	sys_FreeMemoryEz(consys->poke_party);
	for(i = 0; i < BREEDER_MAX; i++){
		sys_FreeMemoryEz(consys->c_game.pp[i]);
		STRBUF_Delete(consys->c_game.breeder_name_str[i]);
	}
	Contest_SystemWorkFree(consys);
	sys_DeleteHeap(HEAPID_CONTEST);
}

//--------------------------------------------------------------
/**
 * @brief   ReXg̍ŏ̒ʐM
 * @param   tcb			TCBւ̃|C^
 * @param   work		ReXgVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
static void ContestComm_SioFastDate(TCB_PTR tcb, void *work)
{
	CONTEST_SYSTEM *consys = work;
	enum{
		FASTSEQ_FAST_SEND,
		FASTSEQ_FAST_WAIT,
		FASTSEQ_POKE_SEND,
		FASTSEQ_POKE_WAIT,
		FASTSEQ_POKE_RESEND,
		FASTSEQ_POKE_RESEND_WAIT,
		FASTSEQ_BD_SEND,
		FASTSEQ_BD_WAIT,
		FASTSEQ_BD_RESEND,
		FASTSEQ_BD_RESEND_WAIT,
		FASTSEQ_NAME_SEND,
		FASTSEQ_NAME_WAIT,
		FASTSEQ_NAME_RESEND,
		FASTSEQ_NAME_RESEND_WAIT,
		FASTSEQ_JUDGE_SEND,
		FASTSEQ_JUDGE_WAIT,
	};
	
	switch(consys->seq){
	case FASTSEQ_FAST_SEND:
		if(CommContestSendFastParam(consys) == TRUE){
			consys->seq++;
		}
		break;
	case FASTSEQ_FAST_WAIT:
		if(consys->recieve_count >= consys->c_game.player_num){
			consys->recieve_count = 0;
			consys->seq++;
		}
		break;
		
	case FASTSEQ_POKE_SEND:
		//eu[_[̃|Pp[^𑗐M
		//̖O͍͂܂0ԃu[_[̈ʒuɂ̂ŁAS0ԃu[_[̖O𑗐M
		if(CommContestSendPokePara(consys, consys->c_game.my_breeder_no, 
				consys->c_game.pp[0]) == TRUE){
			consys->seq++;
		}
		break;
	case FASTSEQ_POKE_WAIT:
		if(consys->recieve_count >= consys->c_game.player_num){
			consys->recieve_count = 0;
			consys->seq++;
		}
		break;
	case FASTSEQ_POKE_RESEND:
		//eu[_[̃|Pp[^󂯎eACPU̕܂߂čđM
		if(consys->c_game.my_breeder_no == consys->c_game.server_no){
		#if 0	//S܂Ƃ߂đM悤ɕύX
			if(CommContestSendPokePara(consys, consys->work, 
					consys->c_game.pp[consys->work]) == TRUE){
				consys->seq++;
			}
		#else
			if(CommContestSendPokeParaAll(consys, consys->c_game.pp) == TRUE){
				consys->seq++;
			}
		#endif
		}
		else{
			consys->seq++;
		}
		break;
	case FASTSEQ_POKE_RESEND_WAIT:
		if(consys->recieve_count > 0){
			consys->recieve_count = 0;
		#if 0	//S܂Ƃ߂đM悤ɕύX
			consys->work++;
			if(consys->work < BREEDER_MAX){
				consys->seq--;
			}
			else{
				consys->work = 0;
				consys->seq++;
			}
		#else
			consys->seq++;
		#endif
		}
		break;
	
	case FASTSEQ_BD_SEND:
		//eu[_[̃u[_[f[^𑗐M
		//̖O͍͂܂0ԃu[_[̈ʒuɂ̂ŁAS0ԃu[_[̖O𑗐M
		if(CommContestSendBreederData(consys, consys->c_game.my_breeder_no, 
				&consys->c_game.bd[0]) == TRUE){
			consys->seq++;
		}
		break;
	case FASTSEQ_BD_WAIT:
		if(consys->recieve_count >= consys->c_game.player_num){
			consys->recieve_count = 0;
			consys->seq++;
		}
		break;
	case FASTSEQ_BD_RESEND:
		//eu[_[̃u[_[f[^󂯎eACPU̕܂߂čđM
		if(consys->c_game.my_breeder_no == consys->c_game.server_no){
			if(CommContestSendBreederData(consys, consys->work, 
					&consys->c_game.bd[consys->work]) == TRUE){
				consys->seq++;
			}
		}
		else{
			consys->seq++;
		}
		break;
	case FASTSEQ_BD_RESEND_WAIT:
		if(consys->recieve_count > 0){
			consys->recieve_count = 0;
			consys->work++;
			if(consys->work < BREEDER_MAX){
				consys->seq--;
			}
			else{
				consys->work = 0;
				consys->seq++;
			}
		}
		break;

	case FASTSEQ_NAME_SEND:
		//eu[_[̖O𑗐M
		//̖O͍͂܂0ԃu[_[̈ʒuɂ̂ŁAS0ԃu[_[̖O𑗐M
		if(CommContestSendNameData(consys, consys->c_game.my_breeder_no,
				consys->c_game.breeder_name_str[0]) == TRUE){
			consys->seq++;
		}
		break;
	case FASTSEQ_NAME_WAIT:
		if(consys->recieve_count >= consys->c_game.player_num){
			consys->recieve_count = 0;
			consys->seq++;
		}
		break;
	case FASTSEQ_NAME_RESEND:
		//eu[_[̖O󂯎eACPU̕܂߂čđM
		if(consys->c_game.my_breeder_no == consys->c_game.server_no){
			if(CommContestSendNameData(consys, consys->work,
					consys->c_game.breeder_name_str[consys->work]) == TRUE){
				consys->seq++;
			}
		}
		else{
			consys->seq++;
		}
		break;
	case FASTSEQ_NAME_RESEND_WAIT:
		if(consys->recieve_count > 0){
			consys->recieve_count = 0;
			consys->work++;
			if(consys->work < BREEDER_MAX){
				consys->seq--;
			}
			else{
				consys->work = 0;
				consys->seq++;
			}
		}
		break;

	case FASTSEQ_JUDGE_SEND:
		//eĂRf[^SĂđM
		if(CommContestSendJudgeData(consys, consys->c_game.my_breeder_no, 
				consys->c_game.jd) == TRUE){
			consys->seq++;
		}
		break;
	case FASTSEQ_JUDGE_WAIT:
		if(consys->recieve_count >= consys->c_game.player_num){
			consys->recieve_count = 0;
			consys->seq++;
		}
		break;
	
	default:
		{//check@ŕς(vC[̐ʂ͂ǁACPU̐ʂ̓u[_[f[^
		 //MĂ鏊Đʂ𑗂悤ɂ)
			//ʃZbg
			int i;
			const MYSTATUS *my_status;
			for(i = 0; i < consys->c_game.player_num; i++){
				my_status = CommInfoGetMyStatus(i);
				consys->c_game.player_sex[i] = MyStatus_GetMySex(my_status);
			}
			for( ; i < BREEDER_MAX; i++){
				consys->c_game.player_sex[i] = consys->c_game.bd[i].sex;
			}
		}
		
		consys->sio_tcb = NULL;
		TCB_Delete(tcb);
		return;
	}
}

//--------------------------------------------------------------
/**
 * @brief   ʐM̏ꍇ̃[Np[^ݒsB
 * @param   consys		
 * @retval  TRUE:ݒ萬B@FALSE:s
 */
//--------------------------------------------------------------
BOOL Contest_SioParamInitSet(CONTEST_SYSTEM *consys)
{
	int connect_num, net_id;

	if(CommIsInitialize() == FALSE){
		return FALSE;
	}
	
	consys->sio_flag = TRUE;
	
	connect_num = CommGetConnectNum();
	net_id = CommGetCurrentID();
	
	consys->c_game.my_net_id = net_id;
	consys->c_game.cpu_num = BREEDER_MAX - connect_num;
	consys->c_game.player_num = connect_num;
	consys->c_game.my_breeder_no = net_id;
	consys->c_game.my_version = CONTEST_VERSION;
	
	OS_TPrintf("ڑl%d\n", connect_num);
	OS_TPrintf("netID%d\n", consys->c_game.my_net_id);
	OS_TPrintf("CPU̐l%d\n", consys->c_game.cpu_num);
	
	//ʐM[hReXg
	CommCommandContestInitialize(consys);
	
	//ŏ̒ʐMs^XN𐶐
	consys->sio_tcb = TCB_Add(ContestComm_SioFastDate, consys, 10);
	
	return TRUE;
}

//--------------------------------------------------------------
/**
 * @brief   ReXgʐM̍ŏ̃f[^ImF
 * @param   consys		ReXgVXe[Nւ̃|C^
 * @retval  TRUE:IB@FALSE:s
 */
//--------------------------------------------------------------
BOOL Contest_SioFastDataEndCheck(CONTEST_SYSTEM *consys)
{
	if(consys->sio_tcb == NULL){
		return TRUE;
	}
	return FALSE;
}


//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   XNvgp߁FR擾
 *
 * @param   consys		ReXgVXe[Nւ̃|C^
 * @param   judge_no	Rԍ
 * @param   wordset		[hZbgIuWFNg
 * @param   buf_id		Ԃ̃obt@ɓo^邩
 */
//--------------------------------------------------------------
void ConScr_JudgeNameGet(CONTEST_SYSTEM *consys, int judge_no, WORDSET *wordset, u32 buf_id)
{
	WORDSET_RegisterJudgeName(wordset, buf_id, consys->c_game.jd[judge_no].name_id);
}

//--------------------------------------------------------------
/**
 * @brief   XNvgp߁Fu[_[擾
 *
 * @param   consys		ReXgVXe[Nւ̃|C^
 * @param   breeder_no	u[_[ԍ
 * @param   wordset		[hZbgIuWFNg
 * @param   buf_id		Ԃ̃obt@ɓo^邩
 */
//--------------------------------------------------------------
void ConScr_BreederNameGet(CONTEST_SYSTEM *consys, int breeder_no, WORDSET *wordset, u32 buf_id)
{
	int sex;
	
	WORDSET_RegisterWord(wordset, buf_id, consys->c_game.breeder_name_str[breeder_no], 
		consys->c_game.player_sex[breeder_no], TRUE, PM_LANG);
	//RegisterWord(wordset, buf_id, consys->c_game.breeder_name_str[breeder_no], NULL);
}

//--------------------------------------------------------------
/**
 * @brief   XNvgp߁F|P̃jbNl[擾
 *
 * @param   consys		ReXgVXe[Nւ̃|C^
 * @param   breeder_no	u[_[ԍ
 * @param   wordset		[hZbgIuWFNg
 * @param   buf_id		Ԃ̃obt@ɓo^邩
 */
//--------------------------------------------------------------
void ConScr_NickNameGet(CONTEST_SYSTEM *consys, int breeder_no, WORDSET *wordset, u32 buf_id)
{
	POKEMON_PASO_PARAM * ppp;
	
	ppp = PPPPointerGet(consys->c_game.pp[breeder_no]);
	WORDSET_RegisterPokeNickName(wordset, buf_id, ppp);
}

//--------------------------------------------------------------
/**
 * @brief   XNvgp߁FReXgN擾
 *
 * @param   consys		ReXgVXe[Nւ̃|C^
 * @param   wordset		[hZbgIuWFNg
 * @param   buf_id		Ԃ̃obt@ɓo^邩
 */
//--------------------------------------------------------------
void ConScr_RankNameGet(CONTEST_SYSTEM *consys, WORDSET *wordset, u32 buf_id)
{
	u32 str_id;
	
	str_id = ConTool_GetRankMsgID(consys->c_game.rank);
	WORDSET_RegisterContestRank(wordset, buf_id, str_id);
}

//--------------------------------------------------------------
/**
 * @brief   XNvgp߁FReXg^Cv(ReXg)擾
 *
 * @param   consys		ReXgVXe[Nւ̃|C^
 * @param   wordset		[hZbgIuWFNg
 * @param   buf_id		Ԃ̃obt@ɓo^邩
 */
//--------------------------------------------------------------
void ConScr_TypeNameGet(CONTEST_SYSTEM *consys, WORDSET *wordset, u32 buf_id)
{
	u32 str_id;
	
	str_id = ConTool_GetTypeMsgID(consys->c_game.type);
	WORDSET_RegisterContestType(wordset, buf_id, str_id);
}

//--------------------------------------------------------------
/**
 * @brief   XNvgp߁FDu[_[̖O擾
 *
 * @param   consys		ReXgVXe[Nւ̃|C^
 * @param   wordset		[hZbgIuWFNg
 * @param   buf_id		Ԃ̃obt@ɓo^邩
 */
//--------------------------------------------------------------
void ConScr_VictoryBreederNameGet(CONTEST_SYSTEM *consys, WORDSET *wordset, u32 buf_id)
{
	int victory_breeder;
	
	victory_breeder = 0;
	ConScr_BreederNameGet(consys, victory_breeder, wordset, buf_id);
}

//--------------------------------------------------------------
/**
 * @brief   XNvgp߁FDɖႦACeԍ擾
 *
 * @param   consys		ReXgVXe[Nւ̃|C^
 * @param   wordset		[hZbgIuWFNg
 *
 * @retval  ACeԍ
 */
//--------------------------------------------------------------
u32 ConScr_VictoryItemNoGet(CONTEST_SYSTEM *consys)
{
	return 1;
}



//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   ReXgp̃_̎평
 * @param   consys		ReXgVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
static void contest_srand(CONTEST_SYSTEM *consys)
{
	RTCTime	rtc;

	GF_RTC_GetTime(&rtc);
	gf_srand(rtc.second);
}

//--------------------------------------------------------------
/**
 * @brief   ReXgp̃_擾֐
 * @param   consys		ReXgVXe[Nւ̃|C^
 * @retval  _l
 */
//--------------------------------------------------------------
u16 contest_rand(CONTEST_SYSTEM *consys)
{
	return gf_rand();
}

