//==============================================================================
/**
 * @file	contest_order.c
 * @brief	ReXgʐMM
 * @author	matsuda
 * @date	2005.12.13()
 */
//==============================================================================
#include "common.h"
#include "contest/contest.h"
#include "battle/battle_common.h"
#include "contest_order.h"
#include "communication/communication.h"
#include "comm_command_contest.h"


//==============================================================================
//	萔`
//==============================================================================
///ɖ߂o鐔(t[ɏo閽߂1)
#define CONTEST_ORDER_SAME_MAX		(32)

///M^Cv
enum{
	TRANSMIT_TYPE_REQUEST,		///<
	TRANSMIT_TYPE_ANSWER,		///<Ԏ
};



//--------------------------------------------------------------
/**
 * @brief   ReXgM[N
 *
 * @param   cow				ReXgM[Nւ̃|C^
 * @param   initdata		f[^
 */
//--------------------------------------------------------------
void CO_WorkInit(CONTEST_ORDER_WORK *cow, const CO_INIT_DATA *initdata)
{
	MI_CpuClear8(cow, sizeof(CONTEST_ORDER_WORK));
	cow->func_tbl = initdata->func_tbl;
	cow->func_tbl_max = initdata->func_tbl_max;
	cow->my_breeder_no = initdata->my_breeder_no;
	cow->sio_flag = initdata->sio_flag;
	cow->server_no = initdata->server_no;
}


//--------------------------------------------------------------
/**
 * @brief   NGXgrbgZbg
 * @param   apw		Z͕Ǘ[Nւ̃|C^
 */
//--------------------------------------------------------------
static int CO_RequestBitSet(CONTEST_ORDER_WORK *cow)
{
	int bit_no;

	for(bit_no = 0; bit_no < CONTEST_ORDER_SAME_MAX; bit_no++){
		if((cow->request_bit & (1 << bit_no)) == 0){
			cow->request_bit |= 1 << bit_no;
			return bit_no;
		}
	}
	
	GF_ASSERT(0 && "ő哯Mߐ𒴂Ă܂\n");
	return 0;
}

//--------------------------------------------------------------
/**
 * @brief   w̃NGXgrbgZbg
 *
 * @param   syswork		eǗ[Nւ̃|C^
 * @param   bit_no		rbgԍ
 */
//--------------------------------------------------------------
static void CO_RequestBitReset(CONTEST_ORDER_WORK *cow, int bit_no)
{
	cow->request_bit &= 0xffffffff ^ (1 << bit_no);
}

//--------------------------------------------------------------
/**
 * @brief   NGXgrbgĂ邩`FbN
 * @param   apw		Z͕Ǘ[Nւ̃|C^
 * @retval  Ărbg
 */
//--------------------------------------------------------------
u8 CO_RequestBitNumCheck(CONTEST_ORDER_WORK *cow)
{
	return MATH_CountPopulation(cow->request_bit);
}

//--------------------------------------------------------------
/**
 * @brief   wrbgԍ̃NGXgrbgĂ邩mF
 *
 * @param   syswork		eǗ[Nւ̃|C^
 * @param   bit_no		rbgԍ
 *
 * @retval  TRUE:rbgĂB@FALSE:rbgĂ
 */
//--------------------------------------------------------------
BOOL CO_RequestBitCheck(CONTEST_ORDER_WORK *cow, int bit_no)
{
	if(cow->request_bit & (1 << bit_no)){
		return TRUE;
	}
	return FALSE;
}

//--------------------------------------------------------------
/**
 * @brief   Mobt@ɑMf[^Zbg
 *
 * @param   apw					Z͕Ǘ[Nւ̃|C^
 * @param   select_breeder		Ώۃu[_[
 * @param   order_no			ߔԍ
 * @param   data				Mf[^̃|C^(ȂꍇNULL)
 * @param   data_size			Mf[^TCY
 * 
 * @retval	o^ꂽNGXgrbgԍ
 */
//--------------------------------------------------------------
int CO_REQUEST_TransmitBufferSet(CONTEST_ORDER_WORK *cow, u8 select_breeder, u16 order_no, void *data, int data_size)
{
	CORDER_HEAD trans_head;
	
//	OS_TPrintf("Mobt@ɃZbgf[^̃TCY%d\n", data_size);
	GF_ASSERT(sizeof(CORDER_HEAD) + data_size <= CO_TRANSMIT_BUF_SIZE);
	
	//Mobt@NA
	MI_CpuClear8(cow->transmit_buf, CO_TRANSMIT_BUF_SIZE);

	//wb_쐬
	trans_head.select_breeder = select_breeder;
	trans_head.order_no = order_no;
	trans_head.bit_no = CO_RequestBitSet(cow);
	trans_head.type = TRANSMIT_TYPE_REQUEST;
	trans_head.data_size = data_size + sizeof(CORDER_HEAD);
	
	//f[^Zbg
	MI_CpuCopy32(&trans_head, cow->transmit_buf, sizeof(CORDER_HEAD));
	MI_CpuCopy8(data, &cow->transmit_buf[sizeof(CORDER_HEAD)], data_size);
	
	cow->answer_count = 0;
	cow->transmit_flag = TRUE;
	
	return trans_head.bit_no;
}

//--------------------------------------------------------------
/**
 * @brief   Mobt@ɕԎf[^Zbg
 *
 * @param   apw				Z͕Ǘ[Nւ̃|C^
 * @param   req_head		NGXgwb_̃|C^
 * @param   data			Mf[^̃|C^(ȂꍇNULL)
 * @param   data_size		Mf[^TCY
 */
//--------------------------------------------------------------
void CO_ANSWER_TransmitBufferSet(CONTEST_ORDER_WORK *cow, const CORDER_HEAD *req_head, void *data, int data_size)
{
	CORDER_HEAD answer_head;
	
	GF_ASSERT(sizeof(CORDER_HEAD) + data_size <= CO_TRANSMIT_BUF_SIZE);
	
	//Mobt@NA
	MI_CpuClear8(cow->transmit_buf, CO_TRANSMIT_BUF_SIZE);

	//wb_쐬
	answer_head = *req_head;
	answer_head.select_breeder = CSELECT_SERVER;
	answer_head.type = TRANSMIT_TYPE_ANSWER;
	answer_head.data_size = data_size + sizeof(CORDER_HEAD);
	
	//f[^Zbg
	MI_CpuCopy32(&answer_head, cow->transmit_buf, sizeof(CORDER_HEAD));
	if(data != NULL){
		MI_CpuCopy8(data, &cow->transmit_buf[sizeof(CORDER_HEAD)], data_size);
	}
	
	cow->transmit_flag = TRUE;
}

//--------------------------------------------------------------
/**
 * @brief   Mobt@wb_f[^̃AhXƁAf[^obt@̃AhXo
 *
 * @param   syswork		eǗ[Nւ̃|C^
 * @param   net_id		擾obt@̃lbgID
 * @param   req_head	Mwb_̃|C^|C^
 * @param   data		Mf[^ւ̃|C^|C^
 */
//--------------------------------------------------------------
static void CO_RECIEVE_BufferDataGet(CONTEST_ORDER_WORK *cow, int net_id, CORDER_HEAD **req_head, void **data)
{
	*req_head = (void*)cow->receive_buf[net_id];
	*data = &cow->receive_buf[net_id][sizeof(CORDER_HEAD)];
}

//--------------------------------------------------------------
/**
 * @brief   ߑMoԂ`FbN
 *
 * @param   apw		Z͕Ǘ[Nւ̃|C^
 *
 * @retval  TRUE:oB@FALSE:oȂ
 */
//--------------------------------------------------------------
static BOOL COSub_OrderPossibleCheck(CONTEST_ORDER_WORK *cow)
{
	if(cow->transmit_flag == TRUE){
		return FALSE;
	}
	
	if(cow->sio_flag == FALSE){
		return TRUE;
	}
	return TRUE;
}

//--------------------------------------------------------------
/**
 * @brief   ߑMR}hs
 *
 * @param   syswork		eǗ[Nւ̃|C^
 * @param   order_no	ߔԍ(AORDER_NO_???)
 * @param   work		Cӂ̃|C^
 *
 * @retval  TRUE:MB@FALSE:M҂
 */
//--------------------------------------------------------------
int CO_OrderSet(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work)
{
	if(COSub_OrderPossibleCheck(cow) == FALSE){
		return FALSE;
	}
	
	GF_ASSERT(order_no < cow->func_tbl_max);
	cow->func_tbl[order_no].request_func(cow, syswork, order_no, work);
	return TRUE;
}

//--------------------------------------------------------------
/**
 * @brief   select_breederŎw肳Ă̂Ȃ̂`FbN
 *
 * @param   my_breeder_no		̃u[_[ԍ
 * @param   server_no			T[o[̃u[_[ԍ
 * @param   select_breeder		Iu[_[
 *
 * @retval  TRUE:B@FALSE:ł͂Ȃ
 */
//--------------------------------------------------------------
static BOOL COSub_SelectBreederCheck(int my_breeder_no, int server_no, int select_breeder)
{
	if(my_breeder_no == select_breeder || select_breeder == CSELECT_ALL
			|| (select_breeder == CSELECT_SERVER && server_no == my_breeder_no)){
		return TRUE;
	}
	return FALSE;
}

//--------------------------------------------------------------
/**
 * @brief   Mobt@Ƀf[^i[ĂΑMs
 *
 * @param   apw		Z͕Ǘ[Nւ̃|C^
 *
 * @retval  TRUE:MB@FALSE:MĂȂ
 */
//--------------------------------------------------------------
BOOL CO_TransmitCheckExe(CONTEST_ORDER_WORK *cow)
{
	if(cow->transmit_flag == FALSE){
		return FALSE;
	}
	
	if(cow->sio_flag == FALSE){
		//M
		MI_CpuCopy8(cow->transmit_buf, cow->receive_buf[cow->my_breeder_no], CO_TRANSMIT_BUF_SIZE);
		cow->receive_flag[cow->my_breeder_no] = TRUE;

		MI_CpuClear8(cow->transmit_buf, CO_TRANSMIT_BUF_SIZE);
		cow->transmit_flag = FALSE;
		return TRUE;
	}
	else{
		CORDER_HEAD *chead;
		
		chead = (void*)cow->transmit_buf;
	#if DEBUG_SIO_WAIT
		if((gf_rand() % 10) != 0){
			return FALSE;
		}
	#endif
//		if(CommSendData(CC_NORMAL_DATA, cow->transmit_buf, chead->data_size) == TRUE){
		if(CommSendHugeData(CC_NORMAL_DATA, cow->transmit_buf, chead->data_size) == TRUE){
			OS_TPrintf("f[^M\n");
			//HugeDataőMꍇ͑MI܂ŕێKv̂ŃNAȂ
			//MI_CpuClear8(cow->transmit_buf, CO_TRANSMIT_BUF_SIZE);
			cow->transmit_flag = FALSE;
			return TRUE;
		}
	}
	return FALSE;
}

//--------------------------------------------------------------
/**
 * @brief   ߃R}hMmFAMĂΎs
 *
 * @param   apw		Z͕Ǘ[Nւ̃|C^
 *
 * @retval  TRUE:ߎsB@FALSE:MȂ
 */
//--------------------------------------------------------------
int CO_RecieveCheckExe(CONTEST_ORDER_WORK *cow, void *syswork)
{
	CORDER_HEAD *req_head;
	void *data;
	CO_ANSDAT ansdat;
	int i;
	
	MI_CpuClear8(&ansdat, sizeof(CO_ANSDAT));
	
	if(1){	//cow->sio_flag == FALSE){
		for(i = 0; i < CC_NETID_MAX; i++){
			if(cow->receive_flag[i] == TRUE){
				//Mf[^擾
				CO_RECIEVE_BufferDataGet(cow, i, &req_head, &data);
				//ΏۂɊ܂܂Ă邩mF
				if(COSub_SelectBreederCheck(cow->my_breeder_no, 
						cow->server_no, req_head->select_breeder) == TRUE){
					//߃R}hpӂĂ邩mF
					if(req_head->order_no < cow->func_tbl_max){
						//Mߎs
						if(req_head->type == TRANSMIT_TYPE_REQUEST){
							cow->func_tbl[req_head->order_no].receive_func(cow, syswork, req_head, data);
						}
						else{
							if(cow->func_tbl[req_head->order_no].answer_func != NULL){
								ansdat.data[i] = data;
								cow->func_tbl[req_head->order_no].answer_func(cow, syswork, req_head, &ansdat, i);
							}
							//Ԏ̂ŃrbgƂ
							CO_RequestBitReset(cow, req_head->bit_no);
							//Ԏ̂ŃJEgCNg
							cow->answer_count++;
						}
					}
					else{
						OS_TPrintf("pӂĂȂߔԍM̂ŉɖ܂\n");
					}
				}
				
				//Mobt@NA
				cow->receive_flag[i] = FALSE;
				MI_CpuClear8(cow->receive_buf[i], CO_RECEIVE_BUF_SIZE);
				return TRUE;
			}
		}
	}
	return FALSE;
}

//--------------------------------------------------------------
/**
 * @brief   ԎMJEgw萔ɒBĂ邩`FbN
 *
 * @param   cow				ReXgM[Nւ̃|C^
 * @param   answer_num		wMl
 * @param   my_breeder		̃u[_[ԍ
 * @param   server_breeder	T[o[̃u[_[ԍ
 *
 * @retval  TRUE:MĂB@FALSEFw萔ɒBĂȂ
 *
 * T[o[p߂łBq@Ă񂾏ꍇ͏TRUEԂ܂B
 */
//--------------------------------------------------------------
BOOL CO_AnswerCountCheck(CONTEST_ORDER_WORK *cow, int answer_num, int my_breeder, int server_breeder)
{
	if(my_breeder != server_breeder){
		return TRUE;	//T[o[p߂Ȃ̂ŁAT[o[łȂ͏ɌʂTRUE
	}
	
	if(cow->answer_count >= answer_num){
		return TRUE;
	}
	return FALSE;
}
