//==============================================================================
/**
 * @file	dance.h
 * @brief	_X̃wb_
 * @author	matsuda
 * @date	2005.12.10(y)
 */
//==============================================================================
#ifndef __DANCE_H__
#define __DANCE_H__

#include "system/procsys.h"
#include "battle/battle_common.h"
#include "system/buflen.h"
#include "contest/contest.h"
#include "system/softsprite.h"
#include "system/fontproc.h"
#include "system/msgdata.h"
#include "system/gra_tool.h"
#include "system/wordset.h"
#include "system/clact_tool.h"
#include "contest_order.h"
#include "system/fontoam.h"

#include "adv_tool.h"
#include "dance_snd_def.h"



//==============================================================================
//	萔`
//==============================================================================
//--------------------------------------------------------------
//	Q[oXp[^
//--------------------------------------------------------------
///1Ԃɂt[
#define ONE_MIN_FRAME		(60 * 30)
///ĂȂ̃C̏ߐ
#define TEMPO_BASE_ONPU		(16)
///1߂ɂt[߂鎞ɍsŒ菬̂߂̏Z
#define ONE_TEMPO_CALC_DECIMAL		(10000)
///_X̏ߐ(܂)
#define DANCE_BEAT			(TEMPO_BASE_ONPU * 2)

///1x̃_XŎsoő_X
#define DANCING_MAX				(8)
///C_T[̗鐔
#define DANCING_RECORD_MAX		(DANCING_MAX)
///_XAj[V̗\obt@
#define DANCE_STEP_REQUEST_MAX	(DANCE_BEAT)

///]pl̈ړxY
#define REVIEW_PANEL_SPEED_Y		(-4)

//--------------------------------------------------------------
//	
//--------------------------------------------------------------
///|PʒuZ(C_T[)
#define DANCE_POKEPOS_Z_MAIN		(APPEAR_Z_TYPE_AA)
///|PʒuZ(obN_T[)
#define DANCE_POKEPOS_Z_SUB			(DANCE_POKEPOS_Z_MAIN - 0x80)

///C_T[̃|Pgk(XY)
#define DANCE_POKEAFF_MAIN		(0x0100)
///obN_T[̃|Pgk(XY)
#define DANCE_POKEAFF_BACK		(0x00c0)	//(0x0080)

///Ȑiso[̉(LN^P)
#define MUSIC_BAR_NUM		(32)
///Ȑiso[1hbg
#define MUSIC_BAR_ONE_LEN	(8)
///Ȑiso[1hbg
#define MUSIC_BAR_LEN		(MUSIC_BAR_ONE_LEN * MUSIC_BAR_NUM)

///AN^[𓯎ɏoő吔(C_T[{obN_T[)
#define ONPU_ACTOR_MAX		((DANCE_BEAT / 2) * BREEDER_MAX + 4)	//+4͕یő߂

///]plAN^[𓯎ɏoő吔
#define REVIEW_ACTOR_MAX		(3)

///]^Cv
enum{
	REVIEW_TYPE_EXCELLENT,
	REVIEW_TYPE_GOOD,
	REVIEW_TYPE_FAILED,
	
	REVIEW_TYPE_MAX,
};

///_X僁CʂŎgptHgOAM̍ő吔
#define DANCE_FONTOAM_MAX_MAIN	(REVIEW_TYPE_MAX * REVIEW_ACTOR_MAX)

//--------------------------------------------------------------
//	[e[Vʒu
//--------------------------------------------------------------
///[e[Vʒu
enum{
	DANCE_ROTATION_POS_A,		///<C
	DANCE_ROTATION_POS_B,		///<ɗx|P
	DANCE_ROTATION_POS_C,
	DANCE_ROTATION_POS_D,
};

//--------------------------------------------------------------
//	obt@
//--------------------------------------------------------------
///obt@̃TCY
#define DANCE_MESSAGE_BUF_SIZE	(2*160)		///<błPUO

//--------------------------------------------------------------
//	t[ԍ
//--------------------------------------------------------------
///EBhEEbZ[Wʂ̃t[
#define DANCE_FRAME_WIN				(GF_BGL_FRAME1_M)
///GtFNgʂ̃t[
#define DANCE_FRAME_EFF				(GF_BGL_FRAME2_M)
///wiʂ̃t[
#define DANCE_FRAME_BACKGROUND		(GF_BGL_FRAME3_M)

///<BGԍFEBhE
#define DANCE_BGNO_WIN			(1)
///<BGԍFGtFNg
#define DANCE_BGNO_EFF			(2)
///<BGԍFwi
#define DANCE_BGNO_BACKGROUND	(3)

///<3DʂBGvCIeB
#define DANCE_3DBG_PRIORITY		(2)
///EBhEʂBGvCIeB
#define DANCE_BGPRI_WIN			(0)
///GtFNgʂBGvCIeB
#define DANCE_BGPRI_EFF			(0)
///wiʂBGvCIeB
#define DANCE_BGPRI_BACKGROUND	(3)


//--------------------------------------------------------------
//	BMPEBhE
//--------------------------------------------------------------
enum{
	DANCE_BMPWIN_TALK,		///<bEBhE
	
	DANCE_BMPWIN_MAX,
};

//--------------------------------------------------------------
//	bEBhE
//--------------------------------------------------------------
///bEBhẼLN^]ItZbg(LN^P)
#define DANCE_TALKWIN_CGX_OFFSET	(1)
///bEBhEwiF
#define DANCE_TALKWIN_BACK_COLOR	(15)
///bEBhEŎgpEBhELN^p^[
#define DANCE_TALKWIN_WIN_NO		(0)
///bEBhẼpbgԍ
#define DANCE_TALKWIN_PALNO		(14)

//--------------------------------------------------------------
//	AN^[BGvCIeB
//--------------------------------------------------------------
///Ȑiso[AN^[BGvCIeB
#define DANCE_BGPRI_MUSIC_BAR	(1)
///AN^[BGvCIeB
#define DANCE_BGPRI_ONPU		(1)
///]plAN^[BGvCIeB
#define DANCE_BGPRI_REVIEW		(1)
///J[\AN^[BGvCIeB
#define DANCE_BGPRI_MY_CURSOR		(1)

//--------------------------------------------------------------
//	AN^[\tgvCIeB
//--------------------------------------------------------------
enum{
	DANCE_SOFTPRI_START = 10,
	
	DANCE_SOFTPRI_REVIEW_FONT,		///<]plAN^[̏ɏtHgOAM
	DANCE_SOFTPRI_REVIEW,			///<]plAN^[
	
	DANCE_SOFTPRI_MUSIC_BAR,		///<Ȑiso[AN^[
	DANCE_SOFTPRI_ONPU,				///<AN^[
	DANCE_SOFTPRI_MY_CURSOR,		///<J[\AN^[
};

///^Cv
enum{
	ONPU_TYPE_A,
	ONPU_TYPE_B,
	
	ONPU_TYPE_MAX,
};

///_X^Cv
enum{
	DANCE_STEP_NONE,
	
	DANCE_STEP_JUMP,
	DANCE_STEP_ADVANCE,
	DANCE_STEP_LEFT,
	DANCE_STEP_RIGHT,
};

///_T[^Cv
enum{
	DANCER_MAIN,	///<C_T[
	DANCER_BACK,	///<obN_T[
};

///_X̃O
enum{
	DANCE_LAG_EXCELLENT_A,
	DANCE_LAG_EXCELLENT_B,
	DANCE_LAG_GOOD_A,
	DANCE_LAG_GOOD_B,
	
	DANCE_LAG_FAILED,
	DANCE_LAG_MAX = DANCE_LAG_FAILED,
};

///_X̃O̓_
enum{
	DANCE_POINT_EXCELLENT_A = 4,
	DANCE_POINT_EXCELLENT_B = 3,
	DANCE_POINT_GOOD_A = 2,
	DANCE_POINT_GOOD_B = 1,
};

//--------------------------------------------------------------
//	XN[R[h
//--------------------------------------------------------------
///Ȑiso[̐擪XN[R[h
#define MUSIC_BAR_FAST_SCRN_CODE_BASE		(0x200c)
///Ȑiso[̃[^[^̃XN[R[h
#define MUSIC_BAR_FAST_SCRN_CODE_FULL		(MUSIC_BAR_FAST_SCRN_CODE_BASE + 8)
///Ȑiso[̐擪XN[R[h
#define MUSIC_BAR_SECOND_SCRN_CODE_BASE		(0x202c)
///Ȑiso[̃[^[^̃XN[R[h
#define MUSIC_BAR_SECOND_SCRN_CODE_FULL		(MUSIC_BAR_SECOND_SCRN_CODE_BASE + 8)

//--------------------------------------------------------------
//	
//--------------------------------------------------------------
///ʂ̐F^Cv
typedef enum{
	FUMENCOLOR_MAIN,		///<C_T[̕ʐF
	FUMENCOLOR_BACK,		///<obN_T[̕ʐF
	FUMENCOLOR_NULL,		///<wȂ
}FUMENCOLOR_TYPE;

///C_T[̕ʂ̃J[ʒu
#define FUMEN_MAIN_COLOR_POS		(2 * 16 + 9)
///C_T[̕ʂŎgpĂJ[
#define FUMEN_MAIN_COLOR_NUM		(2)


///bZ[W^O
enum{
	DTAG_NONE,		///<^OȂ
	
	DTAG_RANK,		///<ReXgN
	DTAG_OYA_NICK,	///<eAjbNl[
	DTAG_RANK_NUM_OYA_NICK,
	
	DTAG_MAX,
};

//==============================================================================
//	\̒`
//==============================================================================
//--------------------------------------------------------------
//	bZ[W
//--------------------------------------------------------------
///Z僁bZ[Wf[^
typedef struct{
	u16 msg_id;				///<bZ[WID
	u8 msg_tag;				///<^OR[h
}DANCE_MESSAGE_PARAM;

///bZ[W^OWJꍇAQƂp[^
typedef struct{
	u8 mine_brd;		///<MINEw肳ĂɎQƂu[_[̔ԍ
	u8 enemy_brd;		///<ENEMYw肳ĂɎQƂu[_[̔ԍ
	u16 wazano;			///<WAZAw肳ĂɎQƂZԍ
	u8 num;				///<NUMw肳Ăɕ\鐔l
	u8 judge_no;		///<JUDGEw肳ĂɎQƂR̔ԍ
}DTAG_PARAM;

//--------------------------------------------------------------
//	
//--------------------------------------------------------------
///]plGtFNg^XN
typedef struct{
	CATS_ACT_PTR cap;
	ADV_FONTACT *fontact;
	TCB_PTR tcb;			///<^XNւ̃|C^
	
	s32 work;
	u8 seq;
}REVIEW_PANEL_TASK_WORK;

///|P풓Ajp[N
typedef struct{
	TCB_PTR tcb;			///<Ajs^XNւ̃|C^
	SOFT_SPRITE *ss;		///<Ώۂ̃|P\tgEFAXvCgւ̃|C^

	s32 aff_z;				///<gkׂ̈ZW(8rbg)
	s32 move_sin;			///<ړAǰ݂Sinl
	
	u8 aff_loop;			///<gkAjJԂ
	u8 rotation_pos;		///<[e[Vʒu
	u8 breeder_no;			///<u[_[ԍ
	u8 aff_seq;
	u8 move_seq;
	
	u8 aff_stop_req:1;		///<1:gkAj~NGXg(ʏAffineTCYɖ߂~)
	u8 aff_stop:1;			///<1:gkAj~
	u8 move_stop_req:1;		///<1:ړAj~NGXg(ʏʒuɖ߂~)
	u8 move_stop:1;			///<1:ړAj~(~)
	u8 aff_dir:1;			///<gkAj̕(0:OցA1:)
}POKE_DEF_ANM_WORK;

///_Xs̃p[^(1frame̒ʐMőSđMo悤20oCgȓɎ߂鎖!!)
typedef struct{
	u16 frame;			///<_X̃t[
	u8 breeder_no;		///<u[_[ԍ(̃_Xu[_[)
	u8 dance_step;		///<_X̎(㉺E)
	u8 review_type;		///<]^Cv(REVIEW_TYPE_EXCELLENT)
	u8 lag_type;		///<O^Cv
	u8 hit_beat;		///<ߖڂ]Ώۂɂ
	u8 rotation_pos;	///<[e[Vʒu
	
	u8 occ:1;			///<LtO(TRUE:f[^L)
	u8 :7;
}DANCING_PARAM;

///<_X̂ꋖe͈(EXCELLENT_A,B,GOOD_A,B)
typedef struct{
	u8 excellent_a;
	u8 excellent_b;
	u8 good_a;
	u8 good_b;
}DANCE_LAG_DATA;

///_Xyisf[^
typedef struct{
	u16 music_id;				///<ID
	u16 tempo;					///<Ȃ̃e|
	u8 loop;					///<JԂ
	u8 touch_count;				///<^b`(_X)o
	DANCE_LAG_DATA lag;			///<_X̂ꋖe͈(EXCELLENT_A,B,GOOD_A,B)
}DANCE_MUSIC_DATA;

///_XAj[V[ÑGtFNgŎgp郏[N
typedef struct{
	//ǂ̃XebvłʂŎgpł낤[N
	s32 start_x;		///<AjJnOXW
	s32 start_y;		///<AjJnOYW
	s32 x;				///<ݍWX
	s32 y;				///<ݍWY
	u8 seq;
	
	//eXebvɓƎŎ[N
	union{
		struct{
			s16 up_power;
		}jump;
		
		struct{
			u8 work;
		}advance;
		
		struct{
			fx32 theta;
		}lr;
	};
}MOVE_EFF_WORK;

///_XAj[V[N
typedef struct{
	u8 dance_step[DANCE_STEP_REQUEST_MAX];	///<_X̎(DANCE_STEP_???)
	u8 work_pos;							///<ݎwĂdance_step[N̔zʒu
	u8 rotation_pos;
	
	MOVE_EFF_WORK eff;						///<GtFNgp̃[N
}DANCE_MOVE_WORK;

///_XpAI[N
typedef struct{
	u8 breeder_no;						///<AIg̃u[_[ԍ
	u8 rotation_pos;					///<[e[Vʒu
	u8 ai_no;							///<AIԍ
	u8 touch_count;						///<_X
	u32 ai_random_seed;					///<AIvZp̃_̎
	
	u32 hit_frame[DANCING_MAX];			///<_Xst[
}DANCE_AI_WORK;

///CV[PXŎgp郍[J[N
typedef struct{
	u16 seq;
	u16 select_seq;
	s32 work;
}DANCE_LOCAL_WORK;

//--------------------------------------------------------------
/**
 * @brief   _Xisp[^(݋ZoĂ|P̐isp[^)
 */
//--------------------------------------------------------------
typedef struct{
	u8 now_breeder;					///<ݏɏoĂu[_[̔ԍ
	u8 now_pos;						///<ݏɏoĂu[_[ԖڂɃAs[Ă邩
	
	u8 breeder_rotation[BREEDER_MAX];	///<݂̃u[_[̃[e[V
										///<C_T[珇XɃu[_[ԍĂ܂

	u32 one_tempo_frame;			///<1ߐiނ̂ɕKvȃt[
									///<(FONE_TEMPO_CALC_DECIMALZAȉ)
	u32 all_tempo_frame;			///<ʒ[[܂Őiނ̂ɕKvȃt[()
	u16 tempo;						///<_XȂ̃e|

	u8 ai_no[BREEDER_MAX];			///<AIԍ
	u16 ai_random_seed[BREEDER_MAX];	///<AIp̃_̎
	
	DANCE_MUSIC_DATA musicdata;		///<yisf[^

	DTAG_PARAM a_talk_tagpara;		///<m[}bF^OWJpp[^
	u8 a_talk_id;					///<m[}bID(A_TALK_DANCE_???)
	u8 a_talk_bmpwin_close_wait;	///<bZ[W\ĂEBhE܂łwait
	u8 a_talk_bmpwin_not_close;		///<TRUE:EBhEɏI
}DANCE_ADVANCE_PARAM;

//--------------------------------------------------------------
/**
 * @brief   _XQ[isp[^
 *
 * ̃p[^ΑSʂč\zo邾̏񂪓Ă܂B
 * ʐM̓T[o[q@̓f[^󂯎鎖ɂȂ܂B
 * {IɃj[ʂ̉ʕÂ悤ȎȂA
 * X̎q@ŒlQƂ鎖͂Ȃ͂łB
 */
//--------------------------------------------------------------
typedef struct{
	u8 breeder_sort[BREEDER_MAX];	///<Zo(o鏇Ƀu[_[ԍĂ܂)
	u8 breeder_end_count;			///<sIu[_[̐JEg

	u8 breeder_rotation[BREEDER_MAX];	///<݂̃u[_[̃[e[V
										///<C_T[珇XɃu[_[ԍĂ܂
	
	s16 dance_point[BREEDER_MAX];	///<l_X|Cg
	
	u32 one_tempo_frame;			///<1ߐiނ̂ɕKvȃt[
									///<(FONE_TEMPO_CALC_DECIMALZAȉ)
	u32 all_tempo_frame;			///<ʒ[[܂Őiނ̂ɕKvȃt[()
	u16 tempo;						///<_XȂ̃e|
}DANCE_GAME_PARAM;

//--------------------------------------------------------------
/**
 * @brief   ߑMpp[^
 * 
 * T[o[Ƃ̖߂̑MɎgp܂
 */
//--------------------------------------------------------------
typedef struct{
	u8 breeder_no;
	
	u8 buffer[255];					///<e߂Ōʂɓnf[^ςꍇAgp
}DANCE_ORDER_PARAM;

//--------------------------------------------------------------
/**
 * @brief   Q[ʂ\邽߂ɕKvȃVXef[^ނ\
 *
 * ʐMłSẴ}VŌʂɍ쐬܂
 * eX^btߎMÃ}VXŐ̃[Nobt@nɂȂ܂
 */
//--------------------------------------------------------------
typedef struct{
	CONTEST_GAME_PARAM *c_game;		///<ReXgisp[^(tŊɒʐMς݂̃f[^ւ̃|C^BQƗp)
	
	SOFT_SPRITE_MANAGER	*soft_sprite;
	SOFT_SPRITE *ss[BREEDER_MAX];
	CATS_SYS_PTR		csp;
	CATS_RES_PTR		crp;
	GF_BGL_INI *bgl;
	GF_BGL_BMPWIN win[DANCE_BMPWIN_MAX];
	MSGDATA_MANAGER *dance_msg;	///<_X僁bZ[WpbZ[W}l[W̃|C^
	WORDSET *wordset;
	STRBUF *msg_buf;				///<Allocobt@ւ̃|C^
	PALETTE_FADE_PTR pfd;			///<pbgtF[hVXeւ̃|C^
	FONTOAM_SYS_PTR fontoam_sys;	///<tHgOAMVXeւ̃|C^
	
	EXCHR_PARAM exchr_param[BREEDER_MAX];		///<ZGtFNgpLWJobt@

	CATS_ACT_PTR onpu_cap[ONPU_ACTOR_MAX];		///<AN^[̃|C^
	
	CATS_ACT_PTR my_cursor_cap;		///<J[\AN^[̃|C^
	TCB_PTR my_cursor_tcb;			///<J[\^XNTCB|C^
	
	REVIEW_PANEL_TASK_WORK rptw[REVIEW_ACTOR_MAX];	///<]pl^XÑ[N
	CATS_ACT_PTR review_cap[REVIEW_ACTOR_MAX];		///<]plAN^[̃|C^
	ADV_FONTACT fontact[REVIEW_TYPE_MAX][REVIEW_ACTOR_MAX];	///<]pl̃tHgAN^[

	const DANCE_MUSIC_DATA *musicdata;		///<yisf[^ւ̃|C^

	u8 talk_msg_index;				///<`惋[`̃CfbNX
}DANCE_SYSTEM_PARAM;

//--------------------------------------------------------------
/**
 * @brief   _XǗ[N
 *
 * _XŜǗ匳̃[NɂȂ܂B
 * ʐMłSẴ}VŌʂɍ쐬܂
 */
//--------------------------------------------------------------
typedef struct _DANCE_PROC_WORK{
	CONTEST_SYSTEM *consys;			///<ReXgVXe[Nւ̃|C^
	TCB_PTR update_tcb;				///<VXeXV
	TCB_PTR move_tcb;				///<|P_XGtFNgs^XNւ̃|C^
	
	DANCE_SYSTEM_PARAM sys;			///<_XVXef[^p[^
	DANCE_GAME_PARAM d_game;			///<Q[isp[^
	DANCE_ADVANCE_PARAM advance;		///<isp[^
	DANCE_ORDER_PARAM order[BREEDER_MAX];	///<߃p[^
	DANCE_MOVE_WORK move[BREEDER_MAX];		///<_XAj[V[N
	POKE_DEF_ANM_WORK pda[BREEDER_MAX];		///<|P풓Ajp[N
	
	void *dip;						///<TuʐVXe\̂ւ̃|C^
	
	u8 music_vcount_flag;			///<TRUEFȐist[JEgAbv
	u64 music_vcount;				///<Ȑis̃t[mF(ȂƂȂ悤Vblank++)
	u64 music_vcount_start;			///<_XJnVJE^L
	
	u16 seq;
	u16 tbl_seq_no;					///<CV[PXe[u̔ԍ
	u8 proc_mode;					///<݂̓

#if 0
	//-- Mobt@ --//
	u32 request_bit;				///<߂oĂrbg
	u8 transmit_buf[TRANSMIT_BUF_SIZE];	///<Mpobt@
	u8 receive_buf[RECEIVE_BUF_SIZE];	///<Mpobt@
	u8 transmit_flag;				///<TRUEFM҂B@FALSE:Vȃf[^Zbg\
	u8 receive_flag;				///<TRUEFf[^M
#endif
	CONTEST_ORDER_WORK cow;			///<M[N

	DANCING_PARAM dancing[BREEDER_MAX];		///<_Xs̃p[^
	DANCING_PARAM maindancer_record[DANCING_RECORD_MAX];	///<C_T[̃_X(ʐMAf[^͌X̂̏ꏊɎM鎖ɂȂANCAgꂼꂪgDANCE_PROC_WORK̂̏ꏊQƂ鎖ɂȂ܂)

	DANCE_LOCAL_WORK local;			///<[J[N
	u8 main_end;					///<TRUE:CI
}DANCE_PROC_WORK;


//==============================================================================
//	O֐錾
//==============================================================================
extern PROC_RESULT DanceProc_Init( PROC * proc, int * seq );
extern PROC_RESULT DanceProc_Main( PROC * proc, int * seq );
extern PROC_RESULT DanceProc_End( PROC * proc, int * seq );

//==============================================================================
//	Of[^錾
//==============================================================================
extern const PROC_DATA ContestDanceProcData;



#endif	//__DANCE_H__

