//==============================================================================
/**
 * @file	dance_input.c
 * @brief	Z͕͉ʏ
 * @author	matsuda
 * @date	2005.12.02()
 */
//==============================================================================
#include "common.h"
#include "contest/contest.h"
#include "dance.h"
#include "dance_tcb_pri.h"
#include "battle/battle_common.h"
#include "system/clact_tool.h"
#include "system/palanm.h"

#include "system/arc_tool.h"
#include "system/arc_util.h"

#include "system/softsprite.h"

#include "system/fontproc.h"
#include "system/msgdata.h"

#include "wazaeffect/battle_particle.h"
#include "system/particle.h"
#include "wazaeffect/we_mana.h"
#include "wazaeffect/we_sys.h"

#include "system/brightness.h"

#include "graphic/contest_bg_def.h"
#include "graphic/contest_obj_def.h"

#include "dance_tool.h"
#include "con_tool.h"
#include "dance_id.h"
#include "dance_input.h"
#include "battle/wazatype_panel.h"
#include "gflib/touchpanel.h"
#include "contype_icon.h"
#include "poketool/waza_tool.h"
#include "aci_tool.h"

#include "system/msgdata_util.h"
#include "system/wordset.h"

#include "msgdata/msg_cmsg_dance.h"
#include "system/fontoam.h"



//==============================================================================
//	萔`
//==============================================================================
///PtHgOBJ̏d̂ōŏɐāAȌAojbVON,OFFōs
///O܂ŒʂKvȎɐāAKvȂȂ폜
#define FONTOBJ_VANISH		(1)


//--------------------------------------------------------------
//	[JTCBvCIeB
//--------------------------------------------------------------
#define VWAIT_TCBPRI_FRAMEVISIBLE		(10)
#define VWAIT_TCBPRI_BACKSCRN_VISIBLE	(10)
#define VWAIT_TCBPRI_CGRPARAM_TRANS		(20)



//--------------------------------------------------------------
//	
//--------------------------------------------------------------
///BGwȂ
#define NONE_ID			(0xffff)

///BGgpʐ
#define DCI_BG_NUM		(4)

///Wpbgf[^gp{
#define BASE_PLTT_NUM	(16)

///makedata_nol(gp)
#define MAKEDATA_NO_INIT	(-1)

///ReXg͉ʂŎgpoBGCGRTCY
#define DCI_BG_CGR_SIZE			(0x6000)

///BGXN[̃NAR[h
#define BG_CLEAR_CODE			(0)

///1Ώۖ
#define BLD_PLANE_1		(GX_BLEND_PLANEMASK_BG0)
///2Ώۖ
#define BLD_PLANE_2		(GX_BLEND_BGALL)
///1Ώۖʂɑ΂郿ufBOW
#define BLD_ALPHA_1		(9)
///2Ώۖʂɑ΂郿ufBOW
#define BLD_ALPHA_2		(8)

//--------------------------------------------------------------
//	XN[XN[l
//--------------------------------------------------------------
///TYPE_ABG\Ƀ^b`plꂽYɃXN[l(GtFNg)
#define SCRN_SCROLL_A_EFF_Y				(-2)
///TYPE_ABG\Ƀ^b`plꂽYɃXN[l(GtFNg)
#define SCRN_SCROLL_BACK_A_EFF_Y		(1)
///SCRN_SCROLL_BACK_A_EFF_Y̌ɒʒuɖ߂܂ł̃XN[l
#define SCRN_SCROLL_RESET_A_EFF_Y		(-(SCRN_SCROLL_A_EFF_Y + SCRN_SCROLL_BACK_A_EFF_Y))

//--------------------------------------------------------------
//	tHgOBJ
//--------------------------------------------------------------
///tHgOBJ̕ԊuX
#define PANEL_MSG_MARGIN		(0)
///tHgOBJ̍őgpOAM
#define PANEL_MSG_MAXOAM		(8)
///tHgOBJ̃AN^[\tgvCIeB
#define PANEL_MSG_SOFTPRI		(100)
///tHgOBJBGvCIeB
#define PANEL_MSG_BGPRI			(0)

enum{
	FONTOAM_LEFT,		///<X[W
	FONTOAM_CENTER,		///<XSW
};

///tHgOBJAN^[[NŎgpŸʒu
enum{
	//COMMAND
	FA_NO_FORWARD = 0,			///<܂
	FA_NO_BACK,					///<
	FA_NO_LEFT,					///<Ђ
	FA_NO_RIGHT,				///<݂
	
	
	FA_NO_MAX = FA_NO_RIGHT + 1,		///<tHgOBJxɏoő吔
};

///tHgOBJ̕\W
enum{
	//-- COMMAND --//
	FA_POS_FORWARD_X = 0x10 * 8,	//X͒SW
	FA_POS_FORWARD_Y = 7 * 8,
	FA_POS_BACK_X = 0x10 * 8,	//X͒SW
	FA_POS_BACK_Y = 0x12 * 8,
	FA_POS_LEFT_X = 5 * 8,	//X͒SW
	FA_POS_LEFT_Y = 0xc * 8,
	FA_POS_RIGHT_X = 0x1b * 8,	//X͒SW
	FA_POS_RIGHT_Y = 0xc * 8,
};

//--------------------------------------------------------------
//	pbg֘A`
//--------------------------------------------------------------
///tHgOBJ̃pbgԍItZbg
enum{
	PALOFS_COMMAND = 0,
};

#define MSGCOLOR_COMMAND		(GF_PRINTCOLOR_MAKE(0xb, 0xc, 0xd))

//--------------------------------------------------------------
//	GtFNgTCB
//--------------------------------------------------------------
///pl^b`AGtFNgő҂t[
#define SCRN_TOUCH_WAIT	(2)
///pl^b`AGtFNgő҂t[
#define SCRN_TOUCH_ANM_WAIT	(2)


//==============================================================================
//	\̒`
//==============================================================================
///XN[͈͎̔w\
typedef struct{
	s32 top;
	s32 bottom;
	s32 left;
	s32 right;
}REWRITE_SCRN_RECT;

///CGR]Ajs͈̔̓f[^
typedef struct{
	u16 dest_x;			///<]XJnʒu(LP)
	u16 dest_y;			///<]YJnʒu(LP)
	u16 src_x;			///<]XJnʒu(LP)
	u16 src_y;			///<]YJnʒu(LP)
	u16 size_x;			///<X]TCY(LP)
	u16 size_y;			///<Y]TCY(LP)
}CGR_TRANS_RECTDATA;

///CGR]Ajs̃p[^
typedef struct{
	TCB_PTR v_tcb;		///<VuN]sTCB̃|C^
	u8 *dest_vram;		///<VRAM]AhX
	void *arc_data;		///<A[JCuLt@C̃|C^
	u8 *raw_data;		///<A[JCuLt@C̃Lf[^擪AhX
	CGR_TRANS_RECTDATA rd;	///<CGR]Ajs͈̔̓f[^
	u16 x_len;			///<Lt@CX(oCgP)
}CGR_TRANS_PARAM;

///paracgr\̂ŎgpAN^[|C^̐
#define PARACGR_CAP_MAX			(3)
///{^̃Ajp^[
#define BUTTON_ANM_NUM			(3)

///GtFNgTCBp̃[N
typedef struct{
	s16 seq;
	s16 wait;
	union{
		struct{		//CGR]p(ėp)
			CGR_TRANS_PARAM *ctp;
			const CGR_TRANS_RECTDATA *ctp_rd_ptr[BUTTON_ANM_NUM];
			CATS_ACT_PTR cap[PARACGR_CAP_MAX];	///<ꏏɃXN[AN^[ւ̃|C^
			u32 transcgr_id[BUTTON_ANM_NUM];
			int tp_ret;
			u16 arc_id;
			u8 fa_no;						///<ΏۃtHgOBJAN^[[N̓Y
		}paracgr;
	};
}DCI_EFFECT_WORK;

///GtFNgBGp[^
typedef struct{
	const REWRITE_SCRN_RECT *rsr;	///<XN[͈̓f[^ւ̃|C^
	u8 rsr_num;						///<rsrf[^
	s8 add_charname;				///<LN^l[ɑރItZbgl
}EFFBG_WRITE_PARAM;

///tHgAN^[[N
typedef struct{
	FONTOAM_OBJ_PTR fontoam;
	CHAR_MANAGER_ALLOCDATA cma;
	u16 font_len;
}FONT_ACTOR;

///ReXg͉ʐ䃏[N
typedef struct _DCI_PARAM{
	DANCE_SYSTEM_PARAM *sys;
	void *scene_work;	///<V[ɈقȂKvƂȂf[^ނւ̃|C^
	TCB_PTR effect_tcb;	///<GtFNgTCBւ̃|C^
	EFFBG_WRITE_PARAM ewp;	///<GtFNgBGp[^

	//tHgOAM
	FONTOAM_SYS_PTR fontoam_sys;	///<tHgVXeւ̃|C^
	FONT_ACTOR font_actor[FA_NO_MAX];	///<tHgAN^[[N
	
	s8 makedata_no;		///<ݎgpĂBgMakeData̔ԍ
	
	DCI_EFFECT_WORK effect_work;	///<GtFNgTCBp[N
}DCI_PARAM;

///BG쐬f[^\
typedef struct{
	u16 cgr_id;			///<gpCGR̃A[JCuID
	u16 pal_id;			///<gppbg̃A[JCuID
	union{
		struct{
			u16 scr0_id;
			u16 scr1_id;
			u16 scr2_id;
			u16 scr3_id;
		};
		u16 scr_id[DCI_BG_NUM];		///<gpXN[̃A[JCuID
	};
	union{
		struct{
			u16 pri0;		///<BG0ʂ̃vCIeB
			u16 pri1;		///<BG1ʂ̃vCIeB
			u16 pri2;
			u16 pri3;
		};
		u16 pri[DCI_BG_NUM];		///<BG̃vCIeB
	};
	
	//^b`pl
	const RECT_HIT_TBL *tpd;	///<gp^b`plf[^ւ̃|C^
	const int *tpd_ret;			///<^b`pľ
	
	//֐|C^
	void (*callback_bg)(DCI_PARAM_PTR, int, int);	///<BGCreateɌĂяo֐
	int (*callback_tp)(DCI_PARAM_PTR, int);			///<^b`plɌĂяo֐
}BG_MAKE_DATA;


//==============================================================================
//	vg^Cv錾
//==============================================================================
static void Sub_ScrnErase(const REWRITE_SCRN_RECT rsr[], int rsr_num, GF_BGL_INI *bgl, 
	int frame_no, u16 clear_code);
static CGR_TRANS_PARAM * Sub_CgrTransParamSet(int frame_no, u16 arc_id, u32 cgr_id,
	const CGR_TRANS_RECTDATA *rd);
static CGR_TRANS_PARAM * Sub_CgrTransTaskSet(int frame_no, u16 arc_id, u32 cgr_id,
	const CGR_TRANS_RECTDATA *rd);
static void * DINPUT_WorkInit(void);
static void BGCallback_CommandSelect(DCI_PARAM_PTR dci, int select_bg, int force_put);
static int TPCallback_CommandSelect(DCI_PARAM_PTR dci, int tp_ret);
static BOOL Sub_CgrTransEndCheck(CGR_TRANS_PARAM *ctp);
static void Sub_CgrTransNowCopy(int frame_no, u16 arc_id, u32 cgr_id, 
	const CGR_TRANS_RECTDATA *rd);
static void Sub_CgrParamTrans(CGR_TRANS_PARAM *ctp);
static void Sub_BackScrnOnlyVisible(void);
static void Sub_TouchEndDelete(DCI_PARAM_PTR dci);
static void Sub_SceneOBJDelete(DCI_PARAM_PTR dci, int sys_exit);
static void EffectTCB_Add(TCB_FUNC func, DCI_PARAM_PTR dci);
static void EffectTCB_Delete(DCI_PARAM_PTR dci);
static void Effect_ButtonDown(TCB_PTR tcb, void *work);
static void VWait_FrameVisibleUpdate(TCB_PTR tcb, void *work);
static void VWait_BackScrnOnlyVisible(TCB_PTR tcb, void *work);
static void VWait_CgrParamTrans(TCB_PTR tcb, void *work);
static void CommandFontObjCreate(DCI_PARAM_PTR dci);
static void Sub_FontOamCreate(DCI_PARAM_PTR dci, FONT_ACTOR *font_actor, const STRBUF *str, 
	FONT_TYPE font_type, GF_PRINTCOLOR color, int pal_offset, int pal_id, 
	int x, int y, int pos_center);
static void Sub_FontOamDeleteAll(DCI_PARAM_PTR dci);
static void Sub_FontOamVanishAll(DCI_PARAM_PTR dci, int vanish);




//==============================================================================
//	f[^
//==============================================================================
///ReXg͉ʗpBGt[\
static const GF_BGL_BGCNT_HEADER AciBgCntDat[] = {
	{//GF_BGL_FRAME0_S
		0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
		GX_BG_SCRBASE_0x6000, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_01,
		0, 0, 0, FALSE
	},
	{//GF_BGL_FRAME1_S
		0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
		GX_BG_SCRBASE_0x6800, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_01,
		0, 0, 0, FALSE
	},
	{//GF_BGL_FRAME2_S
		0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
		GX_BG_SCRBASE_0x7000, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_01,
		0, 0, 0, FALSE
	},
	{//GF_BGL_FRAME3_S
		0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
		GX_BG_SCRBASE_0x7800, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_01,
		0, 0, 0, FALSE
	},
};


//============================================================================================
//	^b`pl̈ݒ
//============================================================================================
//--------------------------------------------------------------
//	
//--------------------------------------------------------------
///ZI^b`pl̈ݒ
static const RECT_HIT_TBL CommandSelectTouchData[] = {
	//TOP BOTTOM LEFT RIGHT
	{2*8, 11*8, 10*8, 0x16*8},		//DANCE_TP_JUMP
	{0xd*8, 0x16*8, 10*8, 0x16*8},	//DANCE_TP_ADVANCE
	{2*8, 0x16*8, 1*8, 9*8},		//DANCE_TP_LEFT
	{2*8, 0x16*8, 0x17*8, 0x1f*8},	//DANCE_TP_RIGHT
	{ RECT_HIT_END, 0, 0, 0 }
};
///ZI^b`pl̃^b`ʕԎ
static const int CommandSelectTouchRet[NELEMS(CommandSelectTouchData) - 1] = {
	DANCE_TP_JUMP,
	DANCE_TP_ADVANCE,
	DANCE_TP_LEFT,
	DANCE_TP_RIGHT,
};


//==============================================================================
//	
//==============================================================================
///BG쐬f[^(̕тǉAύXDINPUT_TYPE_???̒`ύX邱ƁII)
static const BG_MAKE_DATA BgMakeData[] = {
	{//WALL
		CON_SUB_NCGR_BIN,
		CONTEST_SUB_NCLR,
		{
			CON_TIT_NSCR_BIN,		//pl
			NONE_ID,		//g
			CON_SUB_BG_NSCR_BIN,		//wi
			NONE_ID,							//gXChp
		},
		{2, 1, 3, 0},
		NULL,				//^b`plf[^
		NULL,				//^b`pl
		NULL,				//BG쐬̃R[obN֐
		NULL,				//^b`pl̃R[obN֐
	},
	{//COMMAND
		CON_DANCE_BUT_NCGR_BIN,
		CONTEST_DANCE_SUB_BG_NCLR,
		{
			CON_DANCE_BUT_NSCR_BIN,		//pl
			NONE_ID,		//g
			NONE_ID,		//wi
			NONE_ID,							//gXChp
		},
		{2, 1, 3, 0},
		CommandSelectTouchData,				//^b`plf[^
		CommandSelectTouchRet,					//^b`pl
		BGCallback_CommandSelect,				//BG쐬̃R[obN֐
		TPCallback_CommandSelect,				//^b`pl̃R[obN֐
	},
};



//==============================================================================
//
//	
//
//==============================================================================
///R}hIplCGRAj]͈
static const CGR_TRANS_RECTDATA CommandSelectCgrTransRect[][WAZA_TEMOTI_MAX] = {
	{
		{0+1, 0, 12, 0, 6, 9},		//DANCE_TP_JUMP
		{6+1, 0, 12, 0, 6, 9},		//DANCE_TP_ADVANCE
		{12+1, 0, 12, 0, 6, 9},		//DANCE_TP_LEFT
		{18+1, 0, 12, 0, 6, 9},		//DANCE_TP_RIGHT
	},
	{
		{0+1, 0, 6, 0, 6, 9},		//DANCE_TP_JUMP
		{6+1, 0, 6, 0, 6, 9},		//DANCE_TP_ADVANCE
		{12+1, 0, 6, 0, 6, 9},		//DANCE_TP_LEFT
		{18+1, 0, 6, 0, 6, 9},		//DANCE_TP_RIGHT
	},
	{
		{0+1, 0, 0, 0, 6, 9},		//DANCE_TP_JUMP
		{6+1, 0, 0, 0, 6, 9},		//DANCE_TP_ADVANCE
		{12+1, 0, 0, 0, 6, 9},		//DANCE_TP_LEFT
		{18+1, 0, 0, 0, 6, 9},		//DANCE_TP_RIGHT
	},
};


//==============================================================================
//
//	
//
//==============================================================================

//--------------------------------------------------------------
/**
 * @brief   DIVXe[N̊mۂƏ
 *
 * @retval  mۂDIVXe[Ñ|C^
 */
//--------------------------------------------------------------
static void * DINPUT_WorkInit(void)
{
	DCI_PARAM *dci;

	dci = sys_AllocMemory(HEAPID_DANCE, sizeof(DCI_PARAM));
	MI_CpuClear8(dci, sizeof(DCI_PARAM));
	
	dci->makedata_no = MAKEDATA_NO_INIT;
	
	return dci;
}

//--------------------------------------------------------------
/**
 * @brief   BG\Wt[\Őݒ肷
 * @param   bgl		BGLf[^
 */
//--------------------------------------------------------------
void DINPUT_DefaultFrameSet(GF_BGL_INI *bgl)
{
	int i;
	
	for(i = 0; i < NELEMS(AciBgCntDat); i++){
		GF_BGL_BGControlSet(bgl, GF_BGL_FRAME0_S + i, &AciBgCntDat[i], GF_BGL_MODE_TEXT);
		GF_BGL_ScrClearCode(bgl, GF_BGL_FRAME0_S + i, BG_CLEAR_CODE);
		GF_BGL_ScrollSet(bgl, GF_BGL_FRAME0_S + i, GF_BGL_SCROLL_X_SET, 0);
		GF_BGL_ScrollSet(bgl, GF_BGL_FRAME0_S + i, GF_BGL_SCROLL_Y_SET, 0);
	}
}

//--------------------------------------------------------------
/**
 * @brief   BGt[I
 * @param   bgl		BGLf[^
 */
//--------------------------------------------------------------
void DINPUT_FrameExit(GF_BGL_INI *bgl)
{
	int i;
	
	for(i = 0; i < NELEMS(AciBgCntDat); i++){
		GF_BGL_VisibleSet(GF_BGL_FRAME0_S + i, VISIBLE_OFF);
		GF_BGL_BGControlExit(bgl, GF_BGL_FRAME0_S + i);
	}
}

//--------------------------------------------------------------
/**
 * @brief   ReXg͉ʂ̃VXe
 * @param   bgl		BGLf[^
 * @retval  AllocReXg͉ʂ̃VXe[Ñ|C^
 */
//--------------------------------------------------------------
void * DINPUT_SystemInit(DANCE_SYSTEM_PARAM *sys)
{
	DCI_PARAM *dci;
	
	//[Nm
	dci = DINPUT_WorkInit();
	dci->sys = sys;
	
	//t[\ݒ	ł邩͔H
//	DINPUT_DefaultFrameSet(bgl);

	//tHgOAMVXe쐬
	dci->fontoam_sys = FONTOAM_SysInit(FA_NO_MAX, HEAPID_DANCE);

	return dci;
}

//--------------------------------------------------------------
/**
 * @brief   ReXg͉ʂ̃VXe
 * @param   dci		DIVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
void DINPUT_SystemFree(DCI_PARAM_PTR dci)
{
	Sub_SceneOBJDelete(dci, TRUE);
	FONTOAM_SysDelete(dci->fontoam_sys);
	sys_FreeMemoryEz(dci);
}

//--------------------------------------------------------------
/**
 * @brief   ReXg͉ʂōŏɃZbgĂ풓AN^[̓o^s
 * @param   dci		DIVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
void DINPUT_DefaultActorSet(DCI_PARAM_PTR dci)
{
#if FONTOBJ_VANISH
	CommandFontObjCreate(dci);
	Sub_FontOamVanishAll(dci, FALSE);
#endif
}

//--------------------------------------------------------------
/**
 * @brief   w^CvBGʂ`
 *
 * @param   dci				DIVXe[Nւ̃|C^
 * @param   select_bg		\BG^Cv(DINPUT_TYPE_???)
 * @param   force_put		TRUE:]AFALSE:ɓf[^]ĂȂē]͂Ȃ
 * @param   work			V[ɈقȂKvȃf[^ւ̃|C^
 */
//--------------------------------------------------------------
void DINPUT_CreateBG(DCI_PARAM_PTR dci, int select_bg, int force_put, void *scene_work)
{
	const BG_MAKE_DATA *bmd, *old_bmd;
	int i;
	GF_BGL_INI *bgl;
	CATS_SYS_PTR csp;
	CATS_RES_PTR crp;
	
	dci->scene_work = scene_work;
	bgl = dci->sys->bgl;
	csp = dci->sys->csp;
	crp = dci->sys->crp;
	
	if(dci->makedata_no == MAKEDATA_NO_INIT){
		force_put = TRUE;
		old_bmd = NULL;
	}
	else{
		old_bmd = &BgMakeData[dci->makedata_no];
	}
	bmd = &BgMakeData[select_bg];

	//wiȊO͑SĔ\
	Sub_BackScrnOnlyVisible();
	
	//eBGʂBGvCIeBXV
	{
		for(i = 0; i < DCI_BG_NUM; i++){
			GF_BGL_PrioritySet(GF_BGL_FRAME0_S + i, bmd->pri[i]);
		}
	}
	
	//CGR
	if(1){	//CGR]AjsȂLIDłK]ĂȂƃAj߂Ȃ
//	if(bmd->cgr_id != NONE_ID && (force_put == TRUE || bmd->cgr_id != old_bmd->cgr_id)){
		ArcUtil_BgCharSet(ARC_CONTEST_BG, bmd->cgr_id, bgl, GF_BGL_FRAME0_S, 
			0, DCI_BG_CGR_SIZE, 1, HEAPID_DANCE);
	}
	//PALETTE
	if(bmd->pal_id != NONE_ID && (force_put == TRUE || bmd->pal_id != old_bmd->pal_id)){
		PaletteWorkSet_Arc(dci->sys->pfd, ARC_CONTEST_BG, bmd->pal_id, HEAPID_DANCE, 
			FADE_SUB_BG, 0, 0);

	}
	//SCREEN
	for(i = 0; i < DCI_BG_NUM; i++){
		if(bmd->scr_id[i] != NONE_ID 
				&& (force_put == TRUE || bmd->scr_id[i] != old_bmd->scr_id[i])){
			ArcUtil_ScrnSet(ARC_CONTEST_BG, bmd->scr_id[i], bgl, 
				GF_BGL_FRAME0_S + i, 0, 0, 1, HEAPID_DANCE);
		}
	}
	
	dci->makedata_no = select_bg;

	G2S_SetBlendAlpha(BLD_PLANE_1, BLD_PLANE_2, BLD_ALPHA_1, BLD_ALPHA_2);

	Sub_SceneOBJDelete(dci, FALSE);
	//R[obN֐Ăяo
	if(bmd->callback_bg != NULL){
		bmd->callback_bg(dci, select_bg, force_put);
	}

	VWaitTCB_Add(VWait_FrameVisibleUpdate, dci, VWAIT_TCBPRI_FRAMEVISIBLE);
}

//--------------------------------------------------------------
/**
 * @brief   ^b`plԂ𒲂ׂ
 * @param   dci		DIVXe[Nւ̃|C^
 * @retval  (Ȃ̏ꍇRECT_HIT_NONE)
 */
//--------------------------------------------------------------
int DINPUT_TouchCheck(DCI_PARAM_PTR dci)
{
	int tp_ret, hit, ret;
	const BG_MAKE_DATA *bmd;
	
	GF_ASSERT(dci->makedata_no != MAKEDATA_NO_INIT);
	
	bmd = &BgMakeData[dci->makedata_no];
	if(bmd->tpd == NULL){
		return RECT_HIT_NONE;
	}
	
	GF_ASSERT(bmd->tpd_ret != NULL);
	
	hit = GF_TP_RectHitTrg(bmd->tpd);
	if(hit == RECT_HIT_NONE){
		tp_ret = RECT_HIT_NONE;
	}
	else{
		tp_ret = bmd->tpd_ret[hit];
	}
	
	//R[obN֐Ăяo
	if(bmd->callback_tp != NULL){
		tp_ret = bmd->callback_tp(dci, tp_ret);
	}
	
	return tp_ret;
}

//--------------------------------------------------------------
/**
 * @brief   GtFNgTCBIĂ邩`FbN
 * @param   dci		DIVXe[Nւ̃|C^
 * @retval  TRUE:IĂB@FALSE:IĂȂ
 */
//--------------------------------------------------------------
BOOL DINPUT_EffectEndCheck(DCI_PARAM_PTR dci)
{
	if(dci->effect_tcb == NULL){
		return TRUE;
	}
	return FALSE;
}

//--------------------------------------------------------------
/**
 * @brief   ݎgpĂBgMakeData̔ԍ擾
 * @param   dci		DIVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
int DINPUT_MakeDataNoGet(DCI_PARAM_PTR dci)
{
	return dci->makedata_no;
}


//==============================================================================
//
//	BG쐬ɌĂ΂R[obN֐
//
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   DINPUT_TYPE_ABGCreateɌĂ΂R[obN֐
 *
 * @param   dci				DIVXe[Nւ̃|C^
 * @param   select_bg		\BG^Cv(DINPUT_TYPE_???)
 * @param   force_put		TRUE:]AFALSE:ɓf[^]ĂȂē]͂Ȃ
 */
//--------------------------------------------------------------
static void BGCallback_CommandSelect(DCI_PARAM_PTR dci, int select_bg, int force_put)
{
#if FONTOBJ_VANISH
	Sub_FontOamVanishAll(dci, TRUE);
#else
	CommandFontObjCreate(dci);
#endif
}

//--------------------------------------------------------------
/**
 * @brief   R}hIʂ̃tHgOBJ𐶐
 * @param   dci		DIVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
static void CommandFontObjCreate(DCI_PARAM_PTR dci)
{
	STRBUF *forward_src, *back_src, *left_src, *right_src;
	MSGDATA_MANAGER *msg_man;

	msg_man = dci->sys->dance_msg;
	forward_src = MSGMAN_AllocString(msg_man, CDMSG_FORWARD);
	back_src = MSGMAN_AllocString(msg_man, CDMSG_BACK);
	left_src = MSGMAN_AllocString(msg_man, CDMSG_LEFT);
	right_src = MSGMAN_AllocString(msg_man, CDMSG_RIGHT);

	Sub_FontOamCreate(dci, &dci->font_actor[FA_NO_FORWARD], forward_src, FONT_BUTTON, 
		MSGCOLOR_COMMAND, PALOFS_COMMAND,
		D_PLTTID_OBJ_COMMON_SUB, FA_POS_FORWARD_X, FA_POS_FORWARD_Y, FONTOAM_CENTER);
	Sub_FontOamCreate(dci, &dci->font_actor[FA_NO_BACK], back_src, FONT_BUTTON, 
		MSGCOLOR_COMMAND, PALOFS_COMMAND,
		D_PLTTID_OBJ_COMMON_SUB, FA_POS_BACK_X, FA_POS_BACK_Y, FONTOAM_CENTER);
	Sub_FontOamCreate(dci, &dci->font_actor[FA_NO_LEFT], left_src, FONT_BUTTON, 
		MSGCOLOR_COMMAND, PALOFS_COMMAND,
		D_PLTTID_OBJ_COMMON_SUB, FA_POS_LEFT_X, FA_POS_LEFT_Y, FONTOAM_CENTER);
	Sub_FontOamCreate(dci, &dci->font_actor[FA_NO_RIGHT], right_src, FONT_BUTTON, 
		MSGCOLOR_COMMAND, PALOFS_COMMAND,
		D_PLTTID_OBJ_COMMON_SUB, FA_POS_RIGHT_X, FA_POS_RIGHT_Y, FONTOAM_CENTER);
	
	STRBUF_Delete(forward_src);
	STRBUF_Delete(back_src);
	STRBUF_Delete(left_src);
	STRBUF_Delete(right_src);
}



//==============================================================================
//
//	^b`plɌĂ΂R[obN֐
//
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   DINPUT_TYPE_COMMANDŃ^b`plɌĂяoR[obN֐
 *
 * @param   dci			DIVXe[Nւ̃|C^
 * @param   tp_ret		^b`pl(bmd->tpd_ret̒lRECT_HIT_NONE)
 * 
 * @retval  tp_retԂ(̒ŕύXKvȂȂAœnꂽl̂܂ܕԂ)
 */
//--------------------------------------------------------------
static int TPCallback_CommandSelect(DCI_PARAM_PTR dci, int tp_ret)
{
	int fa_no;
	
	switch(tp_ret){
	case RECT_HIT_NONE:
	default:
		return tp_ret;
	case DANCE_TP_JUMP:
		fa_no = FA_NO_FORWARD;
		break;
	case DANCE_TP_ADVANCE:
		fa_no = FA_NO_BACK;
		break;
	case DANCE_TP_LEFT:
		fa_no = FA_NO_LEFT;
		break;
	case DANCE_TP_RIGHT:
		fa_no = FA_NO_RIGHT;
		break;
	}
	
	EffectTCB_Add(Effect_ButtonDown, dci);
	dci->effect_work.paracgr.transcgr_id[0] = CON_DANCE_BUT_ANIM_NCGR_BIN;
	dci->effect_work.paracgr.transcgr_id[1] = CON_DANCE_BUT_ANIM_NCGR_BIN;
	dci->effect_work.paracgr.transcgr_id[2] = CON_DANCE_BUT_ANIM_NCGR_BIN;
	dci->effect_work.paracgr.arc_id = ARC_CONTEST_BG;
	dci->effect_work.paracgr.ctp_rd_ptr[0] = &CommandSelectCgrTransRect[0][tp_ret];
	dci->effect_work.paracgr.ctp_rd_ptr[1] = &CommandSelectCgrTransRect[1][tp_ret];
	dci->effect_work.paracgr.ctp_rd_ptr[2] = &CommandSelectCgrTransRect[2][tp_ret];
	dci->effect_work.paracgr.tp_ret = tp_ret;
	dci->effect_work.paracgr.fa_no = fa_no;
	return tp_ret;
}




//==============================================================================
//
//	Tu֐
//
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   w͈͂̃XN[obt@wR[hŃNA
 *
 * @param   rsr[]			NA͈
 * @param   rsr_num			rsrf[^
 * @param   bgl				BGLf[^
 * @param   frame_no		t[ԍ
 * @param   clear_code		NA[R[h
 */
//--------------------------------------------------------------
static void Sub_ScrnErase(const REWRITE_SCRN_RECT rsr[], int rsr_num, GF_BGL_INI *bgl, 
	int frame_no, u16 clear_code)
{
	u16 *buf;
	int i, y;
	
	buf = GF_BGL_ScreenAdrsGet(bgl, frame_no);
	GF_ASSERT(buf != NULL);

	for(i = 0; i < rsr_num; i++){
		for(y = rsr[i].top; y <= rsr[i].bottom; y++){
			MI_CpuFill16(&buf[0x20*y + rsr[i].left], clear_code, 
				(rsr[i].right - rsr[i].left + 1) * 2);
		}
	}
}

//--------------------------------------------------------------
/**
 * @brief   CGR]Ajs߂̃p[^Zbg܂
 *
 * @param   frame_no		t[NO
 * @param   arc_id			ARCCfbNX
 * @param   cgr_id			]OtBbNCGRID(0xffffffff̏ꍇ̓NA܂)
 * @param   rd				]͈̓f[^̃|C^(cgr_id0xffffffff̏ꍇsrc̒l͓KOK)
 *
 * @retval  CGR]Ajp[^[Nւ̃|C^
 */
//--------------------------------------------------------------
static CGR_TRANS_PARAM * Sub_CgrTransParamSet(int frame_no, u16 arc_id, u32 cgr_id,
	const CGR_TRANS_RECTDATA *rd)
{
	void *arc_data;
	NNSG2dCharacterData *char_data;
	CGR_TRANS_PARAM *ctp;
	
	ctp = sys_AllocMemory(HEAPID_DANCE, sizeof(CGR_TRANS_PARAM));
	MI_CpuClear8(ctp, sizeof(CGR_TRANS_PARAM));
	
	if(cgr_id != 0xffffffff){
		ctp->arc_data = ArcUtil_CharDataGet(arc_id, cgr_id, 1, &char_data, HEAPID_DANCE);
		ctp->raw_data = char_data->pRawData;
	}
	ctp->x_len = char_data->W * 0x20;
	
	ctp->rd = *rd;
	ctp->dest_vram = GF_BGL_CgxGet(frame_no);
	
	return ctp;
}

//--------------------------------------------------------------
/**
 * @brief   CGR]Ajs^XN𐶐܂
 *
 * @param   frame_no		t[NO
 * @param   arc_id			ARCCfbNX
 * @param   cgr_id			]OtBbNCGRID(0xffffffff̏ꍇ̓NA܂)
 * @param   rd				]͈̓f[^̃|C^(cgr_id0xffffffff̏ꍇsrc̒l͓KOK)
 *
 * @retval  CGR]Ajp[^[Nւ̃|C^
 *
 * ̊֐gpAKSub_CgrTransEndCheck֐gpAImFsĂB
 * Sub_CgrTransEndCheck֐Ń[N̉ȂǂsĂ܂B
 */
//--------------------------------------------------------------
static CGR_TRANS_PARAM * Sub_CgrTransTaskSet(int frame_no, u16 arc_id, u32 cgr_id,
	const CGR_TRANS_RECTDATA *rd)
{
	CGR_TRANS_PARAM *ctp;

	ctp = Sub_CgrTransParamSet(frame_no, arc_id, cgr_id, rd);
	ctp->v_tcb = VWaitTCB_Add(VWait_CgrParamTrans, ctp, VWAIT_TCBPRI_CGRPARAM_TRANS);
	return ctp;
}

//--------------------------------------------------------------
/**
 * @brief   CGR]Aj^XNIĂ邩mF
 * @param   ctp		CGR]Ajp[^[Nւ̃|C^
 * @retval  TRUE:IB@FALSE:s
 *
 * TRUEԂACGR]Ajp[^[N̉s܂B
 */
//--------------------------------------------------------------
static BOOL Sub_CgrTransEndCheck(CGR_TRANS_PARAM *ctp)
{
	if(ctp->v_tcb == NULL){
		if(ctp->arc_data != NULL){
			sys_FreeMemoryEz(ctp->arc_data);
		}
		sys_FreeMemoryEz(ctp);
		return TRUE;
	}
	return FALSE;
}

//--------------------------------------------------------------
/**
 * @brief   CGR]AjVuN^XN𗘗pɂs܂
 *
 * @param   frame_no		t[NO
 * @param   arc_id			ARCCfbNX
 * @param   cgr_id			]OtBbNCGRID(0xffffffff̏ꍇ̓NA܂)
 * @param   rd				]͈̓f[^̃|C^(cgr_id0xffffffff̏ꍇsrc̒l͓KOK)
 *
 * @retval  CGR]Ajp[^[Nւ̃|C^
 *
 * ̊֐gpAKSub_CgrTransEndCheck֐gpAImFsĂB
 * Sub_CgrTransEndCheck֐Ń[N̉ȂǂsĂ܂B
 */
//--------------------------------------------------------------
static void Sub_CgrTransNowCopy(int frame_no, u16 arc_id, u32 cgr_id, const CGR_TRANS_RECTDATA *rd)
{
	CGR_TRANS_PARAM *ctp;
	
	ctp = Sub_CgrTransParamSet(frame_no, arc_id, cgr_id, rd);
	Sub_CgrParamTrans(ctp);
	if(ctp->arc_data != NULL){
		sys_FreeMemoryEz(ctp->arc_data);
	}
	sys_FreeMemoryEz(ctp);
}

//--------------------------------------------------------------
/**
 * @brief   CGR]Ajs܂
 * @param   ctp		CGR]Ajp[^[Nւ̃|C^
 */
//--------------------------------------------------------------
static void Sub_CgrParamTrans(CGR_TRANS_PARAM *ctp)
{
	int x, y, dest_x_len;
	u32 src_y, dest_y;
	
	dest_x_len = 32*32;
	
	src_y = ctp->rd.src_y * ctp->x_len;
	dest_y = ctp->rd.dest_y * dest_x_len;
	
	for(y = 0; y < ctp->rd.size_y; y++){
		if(ctp->arc_data != NULL){
			MI_CpuCopy16(&ctp->raw_data[ctp->x_len * y + src_y + ctp->rd.src_x*0x20], 
				&ctp->dest_vram[dest_x_len * y + dest_y + ctp->rd.dest_x*0x20],
				ctp->rd.size_x * 0x20);
		}
		else{
			MI_CpuClear16(&ctp->dest_vram[dest_x_len * y + dest_y + ctp->rd.dest_x*0x20],
				ctp->rd.size_x * 0x20);
		}
	}
}

//--------------------------------------------------------------
/**
 * @brief   tHgOAM쐬
 *
 * @param   dci			BIVXe[Nւ̃|C^
 * @param   font_actor	tHgOAM֘Ã[N
 * @param   str			
 * @param   font_type	tHg^Cv(FONT_SYSTEM)
 * @param   color		tHgJ[\
 * @param   pal_offset	pbgԍItZbg
 * @param   pal_id		o^JnpbgID
 * @param   x			WX
 * @param   y			WY
 * @param   pos_center  FONTOAM_LEFT(X[W) or FONTOAM_CENTER(XSW)
 */
//--------------------------------------------------------------
static void Sub_FontOamCreate(DCI_PARAM_PTR dci, FONT_ACTOR *font_actor, const STRBUF *str, 
	FONT_TYPE font_type, GF_PRINTCOLOR color, int pal_offset, int pal_id, 
	int x, int y, int pos_center)
{
	FONTOAM_INIT finit;
	GF_BGL_BMPWIN bmpwin;
	CHAR_MANAGER_ALLOCDATA cma;
	int vram_size;
	FONTOAM_OBJ_PTR fontoam;
	GF_BGL_INI *bgl;
	CATS_RES_PTR crp;
	int font_len, char_len;
	
	GF_ASSERT(font_actor->fontoam == NULL);
	
	bgl = dci->sys->bgl;
	crp = dci->sys->crp;
	
	//̃hbgAgpLZo
	{
		font_len = FontProc_GetPrintStrWidth(font_type, str, PANEL_MSG_MARGIN);
		char_len = font_len / 8;
		if(FX_ModS32(font_len, 8) != 0){
			char_len++;
		}
	}

	//BMP쐬
	{
		GF_BGL_BmpWinInit(&bmpwin);
		GF_BGL_BmpWinObjAdd(bgl, &bmpwin, char_len, 16 / 8, 0, 0);
		GF_STR_PrintExpand(&bmpwin, font_type, str, 0, 0, MSG_NO_PUT, color, 
			PANEL_MSG_MARGIN, 0, NULL);
//		GF_STR_PrintColor(&bmpwin, font_type, str, 0, 0, MSG_NO_PUT, color, NULL );
	}

	vram_size = FONTOAM_NeedCharSize(&bmpwin, NNS_G2D_VRAM_TYPE_2DSUB,  HEAPID_DANCE);
	CharVramAreaAlloc(vram_size, CHARM_CONT_AREACONT, NNS_G2D_VRAM_TYPE_2DSUB, &cma);
	
	//WʒuC
	if(pos_center == FONTOAM_CENTER){
		x -= font_len / 2;
	}
	y += SUB_SURFACE_Y_INTEGER - 8;
	
	finit.fontoam_sys = dci->fontoam_sys;
	finit.bmp = &bmpwin;
	finit.clact_set = CATS_GetClactSetPtr(crp);
	finit.pltt = CATS_PlttProxy(crp, pal_id);
	finit.parent = NULL;
	finit.char_ofs = cma.alloc_ofs;
	finit.x = x;
	finit.y = y;
	finit.bg_pri = PANEL_MSG_BGPRI;
	finit.soft_pri = PANEL_MSG_SOFTPRI;
	finit.draw_area = NNS_G2D_VRAM_TYPE_2DSUB;
	finit.heap = HEAPID_DANCE;
	
	fontoam = FONTOAM_Init(&finit);
	FONTOAM_SetPaletteOffset(fontoam, pal_offset);
	FONTOAM_SetMat(fontoam, x, y);
	
	//
	GF_BGL_BmpWinDel(&bmpwin);
	
	font_actor->fontoam = fontoam;
	font_actor->cma = cma;
	font_actor->font_len = font_len;
}

//--------------------------------------------------------------
/**
 * @brief   ĂtHgOAMSč폜
 * @param   dci		BIVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
static void Sub_FontOamDeleteAll(DCI_PARAM_PTR dci)
{
	int i;
	
	for(i = 0; i < FA_NO_MAX; i++){
		if(dci->font_actor[i].fontoam != NULL){
			FONTOAM_Delete(dci->font_actor[i].fontoam);
			CharVramAreaFree(&dci->font_actor[i].cma);
			dci->font_actor[i].fontoam = NULL;
		}
	}
}

//--------------------------------------------------------------
/**
 * @brief   ĂtHgOBJSẴojbVtO𑀍삷
 * @param   dci		DIVXe[Nւ̃|C^
 * @param   vanish	ojbVtO(TRUE(\) or FALSE(\))
 */
//--------------------------------------------------------------
static void Sub_FontOamVanishAll(DCI_PARAM_PTR dci, int vanish)
{
	CATS_RES_PTR crp;
	int i;
	
	crp = dci->sys->crp;
	for(i = 0; i < FA_NO_MAX; i++){
		if(dci->font_actor[i].fontoam != NULL){
			FONTOAM_SetDrawFlag(dci->font_actor[i].fontoam, vanish);
		}
	}
}

//--------------------------------------------------------------
/**
 * @brief   wiȊÕt[SĔ\ɂ
 */
//--------------------------------------------------------------
static void Sub_BackScrnOnlyVisible(void)
{
	int i;
	
	for(i = 0; i < DCI_BG_NUM; i++){
		if(GF_BGL_FRAME0_S + i != DANCESUB_FRAME_BACK){
			GF_BGL_VisibleSet(GF_BGL_FRAME0_S + i, VISIBLE_OFF);
		}
		else{
			GF_BGL_VisibleSet(GF_BGL_FRAME0_S + i, VISIBLE_ON);
		}
	}
}

//--------------------------------------------------------------
/**
 * @brief   pl^b`GtFNgIAwî݂ɂ邽߂̏FX(tHgOBJ̍폜Ƃ)
 * @param   none		DIVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
static void Sub_TouchEndDelete(DCI_PARAM_PTR dci)
{
	Sub_SceneOBJDelete(dci, FALSE);
	VWaitTCB_Add(VWait_BackScrnOnlyVisible, dci, VWAIT_TCBPRI_BACKSCRN_VISIBLE);
}

//--------------------------------------------------------------
/**
 * @brief   BG^Cv؂ւ閈ɍ폜Kv̂OBJDelete
 * @param   dci		DIVXe[Nւ̃|C^
 * @param   sys_exit	TRUE:VXȅIɂ폜B@FALSE:ʕύXAGtFNgł̍폜
 */
//--------------------------------------------------------------
static void Sub_SceneOBJDelete(DCI_PARAM_PTR dci, int sys_exit)
{
#if FONTOBJ_VANISH
	if(sys_exit == TRUE){
		Sub_FontOamDeleteAll(dci);
	}
	else{
		Sub_FontOamVanishAll(dci, FALSE);
	}
#else
	Sub_FontOamDeleteAll(dci);
#endif
}



//==============================================================================
//
//	GtFNgTCB
//
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   GtFNgTCB𐶐
 *
 * @param   func		TCBɃZbg֐|C^
 * @param   dci			DIVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
static void EffectTCB_Add(TCB_FUNC func, DCI_PARAM_PTR dci)
{
	GF_ASSERT(dci->effect_tcb == NULL);
	
	MI_CpuClear8(&dci->effect_work, sizeof(DCI_EFFECT_WORK));
	dci->effect_tcb = TCB_Add(func, dci, TCBPRI_DINPUT_EFFECT);
}

//--------------------------------------------------------------
/**
 * @brief   GtFNgTCB폜
 * @param   dci		DIVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
static void EffectTCB_Delete(DCI_PARAM_PTR dci)
{
	if(dci->effect_tcb != NULL){
		TCB_Delete(dci->effect_tcb);
		dci->effect_tcb = NULL;
		MI_CpuClear8(&dci->effect_work, sizeof(DCI_EFFECT_WORK));
	}
}


//--------------------------------------------------------------
/**
 * @brief   plL]Ajsď܂B
 *          1̃plɑ΂1̃tHgOBJZbgɂȂĂ̗p̔ėp^XNł
 *
 * @param   tcb		TCBւ̃|C^
 * @param   work	DIVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
static void Effect_ButtonDown(TCB_PTR tcb, void *work)
{
	DCI_PARAM_PTR dci = work;
	GF_BGL_INI *bgl;
	int x, y;
	int i;
	
	bgl = dci->sys->bgl;
	
	switch(dci->effect_work.seq){
	case 0:
		dci->effect_work.paracgr.ctp = Sub_CgrTransTaskSet(DANCESUB_FRAME_PANEL, 
			dci->effect_work.paracgr.arc_id,
			dci->effect_work.paracgr.transcgr_id[0], dci->effect_work.paracgr.ctp_rd_ptr[0]);
		
		FONTOAM_GetMat(dci->font_actor[dci->effect_work.paracgr.fa_no].fontoam, &x, &y);
		FONTOAM_SetMat(dci->font_actor[dci->effect_work.paracgr.fa_no].fontoam, 
			x, y + SCRN_SCROLL_A_EFF_Y);
		
		for(i = 0; i < PARACGR_CAP_MAX; i++){
			if(dci->effect_work.paracgr.cap[i] != NULL){
				CATS_ObjectPosMove(dci->effect_work.paracgr.cap[i]->act, 0, SCRN_SCROLL_A_EFF_Y);
			}
		}
		
		dci->effect_work.seq++;
		break;
	case 1:
		if(Sub_CgrTransEndCheck(dci->effect_work.paracgr.ctp) == FALSE){
			break;
		}
		dci->effect_work.seq++;
		//break;
	case 2:
		dci->effect_work.wait++;
		if(dci->effect_work.wait > SCRN_TOUCH_ANM_WAIT){
			dci->effect_work.wait = 0;
			dci->effect_work.seq++;
		}
		else{
			break;
		}
		//break;
	case 3:
		dci->effect_work.paracgr.ctp = Sub_CgrTransTaskSet(DANCESUB_FRAME_PANEL, 
			dci->effect_work.paracgr.arc_id,
			dci->effect_work.paracgr.transcgr_id[1], dci->effect_work.paracgr.ctp_rd_ptr[1]);
		
		FONTOAM_GetMat(dci->font_actor[dci->effect_work.paracgr.fa_no].fontoam, &x, &y);
		FONTOAM_SetMat(dci->font_actor[dci->effect_work.paracgr.fa_no].fontoam, 
			x, y + SCRN_SCROLL_BACK_A_EFF_Y);
		
		for(i = 0; i < PARACGR_CAP_MAX; i++){
			if(dci->effect_work.paracgr.cap[i] != NULL){
				CATS_ObjectPosMove(dci->effect_work.paracgr.cap[i]->act, 
					0, SCRN_SCROLL_BACK_A_EFF_Y);
			}
		}
		
		dci->effect_work.seq++;
		break;
	case 4:
		if(Sub_CgrTransEndCheck(dci->effect_work.paracgr.ctp) == FALSE){
			break;
		}
		dci->effect_work.seq++;
		//break;
	case 5:
		dci->effect_work.wait++;
		if(dci->effect_work.wait > SCRN_TOUCH_WAIT){
			dci->effect_work.wait = 0;
			dci->effect_work.seq++;
		}
		else{
			break;
		}
		//break;

	case 6:
		dci->effect_work.paracgr.ctp = Sub_CgrTransTaskSet(DANCESUB_FRAME_PANEL, 
			dci->effect_work.paracgr.arc_id,
			dci->effect_work.paracgr.transcgr_id[2], dci->effect_work.paracgr.ctp_rd_ptr[2]);

		FONTOAM_GetMat(dci->font_actor[dci->effect_work.paracgr.fa_no].fontoam, &x, &y);
		FONTOAM_SetMat(dci->font_actor[dci->effect_work.paracgr.fa_no].fontoam, 
			x, y + SCRN_SCROLL_RESET_A_EFF_Y);
		
		for(i = 0; i < PARACGR_CAP_MAX; i++){
			if(dci->effect_work.paracgr.cap[i] != NULL){
				CATS_ObjectPosMove(dci->effect_work.paracgr.cap[i]->act, 
					0, SCRN_SCROLL_RESET_A_EFF_Y);
			}
		}
		
		dci->effect_work.seq++;
		break;
	case 7:
		if(Sub_CgrTransEndCheck(dci->effect_work.paracgr.ctp) == FALSE){
			break;
		}
		dci->effect_work.seq++;
		//break;
	case 8:
		dci->effect_work.wait++;
		if(dci->effect_work.wait > SCRN_TOUCH_WAIT){
			dci->effect_work.wait = 0;
			dci->effect_work.seq++;
		}
		else{
			break;
		}
		//break;

	default:
		//Sub_TouchEndDelete(dci);
		EffectTCB_Delete(dci);
		return;
	}
}









//==============================================================================
//
//	VuN
//
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   et[Visibleݒs
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		DIVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
static void VWait_FrameVisibleUpdate(TCB_PTR tcb, void *work)
{
	DCI_PARAM_PTR dci = work;
	const BG_MAKE_DATA *bmd;
	int i;

	bmd = &BgMakeData[dci->makedata_no];
	
	//eBGʂ̕\E\ݒ
	for(i = 0; i < DCI_BG_NUM; i++){
		if(bmd->scr_id[i] == NONE_ID){
			GF_BGL_VisibleSet(GF_BGL_FRAME0_S + i, VISIBLE_OFF);
		}
		else{
			GF_BGL_VisibleSet(GF_BGL_FRAME0_S + i, VISIBLE_ON);
		}
	}
	
	TCB_Delete(tcb);
}

//--------------------------------------------------------------
/**
 * @brief   wiȊÕt[SĂ\ɂ
 *
 * @param   tcb		TCBւ̃|C^
 * @param   work	DIVXe[Nւ̃|C^
 *
 * @retval  
 *
 *
 */
//--------------------------------------------------------------
static void VWait_BackScrnOnlyVisible(TCB_PTR tcb, void *work)
{
	DCI_PARAM_PTR dci = work;

	Sub_BackScrnOnlyVisible();
	TCB_Delete(tcb);
}

//--------------------------------------------------------------
/**
 * @brief   VuNCGR]Ajs܂
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		CGR]Ajp[^[Nւ̃|C^
 */
//--------------------------------------------------------------
static void VWait_CgrParamTrans(TCB_PTR tcb, void *work)
{
	CGR_TRANS_PARAM *ctp = work;
	
	Sub_CgrParamTrans(ctp);
	ctp->v_tcb = NULL;
	TCB_Delete(tcb);
}


