//==============================================================================
/**
 * @file	dance_order.c
 * @brief	_XFߑM
 * @author	matsuda
 * @date	2005.12.13()
 */
//==============================================================================
#include "common.h"
#include "contest/contest.h"
#include "battle/battle_common.h"
#include "contest_order.h"
#include "dance.h"
#include "dance_order.h"

#include "dance_tcb_pri.h"
#include "system/clact_tool.h"
#include "system/palanm.h"

#include "system/arc_tool.h"
#include "system/arc_util.h"

#include "system/softsprite.h"

#include "system/fontproc.h"
#include "system/msgdata.h"

#include "wazaeffect/battle_particle.h"
#include "system/particle.h"
#include "wazaeffect/we_mana.h"
#include "wazaeffect/we_sys.h"

#include "system/brightness.h"

#include "graphic/contest_bg_def.h"
#include "graphic/contest_obj_def.h"

#include "dance_tool.h"
#include "poketool/poke_tool.h"
#include "gflib/touchpanel.h"
#include "system/snd_tool.h"
#include "dance_input.h"
#include "system/window.h"

#include "communication/communication.h"
#include "comm_command_contest.h"


//==============================================================================
//	萔`
//==============================================================================
///[e[V̈ړɂt[
#define ROTATION_SPEED_NORMAL		(90)

///ǂ񂿂傤̏㏸x(8rbg)
#define DONCHOU_UP_SPEED			(3 << 8)
///ǂ񂿂傤ꂾXN[~(8rbg)
#define DONCHOU_STOP_SCROLL			(200 << 8)

///ǂ񂿂傤AjEFCg
#define DONCHOU_ANM_WAIT		(1)
///ǂ񂿂傤1iAjI閈ɂAjEFCg
#define DONCHOU_DANSA_ANM_WAIT		(0)
///ǂ񂿂傤̃Aj]p̃LN^ɉLĂ邩
#define DONCHOU_ANM_DATA_X_LEN	(8)
///ǂ񂿂傤̃Aj]p̃LN^cɉLĂ邩
#define DONCHOU_ANM_DATA_Y_LEN	(4)

//==============================================================================
//	\̒`
//==============================================================================
///_Xp[^M^XN[N
typedef struct{
	DANCE_PROC_WORK *dpw;
	DANCING_PARAM dancing_param;
	u8 ai;
}DANCING_SEND_WORK;

//==============================================================================
//	vg^Cv錾
//==============================================================================
static int Request_Sample(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work);
static void Recieve_Sample(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data);
static void Answer_Sample(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *answer_head, CO_ANSDAT *ansdat, int net_id);
static int Request_DonchouUp(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work);
static void Recieve_DonchouUp(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data);
static void DOTCB_DonchouUp(TCB_PTR tcb, void *work);
static int Request_DonchouDown(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work);
static void Recieve_DonchouDown(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data);
static void DOTCB_DonchouDown(TCB_PTR tcb, void *work);
static int Request_Rotation(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work);
static void Recieve_Rotation(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data);
static void DOTCB_Rotation(TCB_PTR tcb, void *work);
static void DOTCB_RotationBreeder(TCB_PTR tcb, void *work);
static int Request_Dancing(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work);
static void Recieve_Dancing(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data);
static void DOTCB_Dancing(TCB_PTR tcb, void *work);
static void Answer_Dancing(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *answer_head, CO_ANSDAT *ansdat, int net_id);
static int Request_DanceExit(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work);
static void Recieve_DanceExit(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data);
static int DanceTouchCheck(DANCE_TOUCH_WORK *dtw, int *tp_ret, int check, int no_touch_bg);
static void DancerReactionSet(int breeder_no, int reaction, u32 frame, u32 one_tempo_frame, 
	const DANCE_LAG_DATA *dld, DANCING_PARAM *param, const DANCING_PARAM *maindancer_record,
	int rotation_pos);
static void DancingParamSendTaskMain(TCB_PTR tcb, void *work);
static DANCE_AI_WORK * DanceAI_Create(int breeder_no,int rotation_pos,
	u8 ai_no, u16 ai_random_seed);
static void DanceAI_Delete(DANCE_AI_WORK *aiwork);
static void DanceAI_Calc(DANCE_PROC_WORK *dpw, DANCE_AI_WORK *aiwork, 
	u32 all_tempo_frame, u32 one_tempo_frame, const DANCE_MUSIC_DATA *musicdata);
static void DanceAI_Main(DANCE_PROC_WORK *dpw, DANCE_AI_WORK *aiwork, u32 frame, 
	u32 all_tempo_frame, u32 one_tempo_frame, const DANCE_MUSIC_DATA *musicdata);
static int Request_Before(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work);
static void Recieve_Before(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data);
static void DOTCB_Before(TCB_PTR tcb, void *work);
static int Request_After(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work);
static void Recieve_After(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data);
static void DOTCB_After(TCB_PTR tcb, void *work);
static int Request_Talk(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work);
static void Recieve_Talk(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data);
static void DOTCB_TalkPut(TCB_PTR tcb, void *work);


//==============================================================================
//	f[^
//==============================================================================
///ߑMp֐|C^\̃e[u	ɒǉK.henumɂǉ鎖!!
static const CON_ORDER_FUNC OrderFuncTbl[] = {
	{//DORDER_NO_SAMPLE		Tv
		Request_Sample, 
		Recieve_Sample, 
		Answer_Sample, 
	},
	{//DORDER_NO_DONCHOU_UP
		Request_DonchouUp, 
		Recieve_DonchouUp, 
		NULL, 
	},
	{//DORDER_NO_DONCHOU_DOWN
		Request_DonchouDown, 
		Recieve_DonchouDown, 
		NULL, 
	},
	{//DORDER_NO_DANCE_EXIT
		Request_DanceExit,
		Recieve_DanceExit,
		NULL,
	},
	{//DORDER_NO_DANCING
		Request_Dancing, 
		Recieve_Dancing, 
		Answer_Dancing, 
	},
	{//DORDER_NO_ROTATION
		Request_Rotation, 
		Recieve_Rotation, 
		NULL, 
	},
	{//DORDER_NO_BEFORE
		Request_Before, 
		Recieve_Before, 
		NULL, 
	},
	{//DORDER_NO_AFTER
		Request_After, 
		Recieve_After, 
		NULL, 
	},
	{//DORDER_NO_TALK
		Request_Talk, 
		Recieve_Talk, 
		NULL, 
	},
};


//--------------------------------------------------------------
//	
//--------------------------------------------------------------
//--------------------------------------------------------------
//	
//--------------------------------------------------------------
///ǂ񂿂傤Aj̃XN[x[Xʒu
ALIGN4 static const s8 DonchouAnmLineData[] = {
	15, 11, 7, 3, -1
};

///ǂ񂿂傤̃Ajp^[̃LN^NoJnʒu
ALIGN4 static const u16 DonchouAnmPaternStartCharNo[] = {
	0x20, 0x28, 0x30, 0x38,
	0xa0, 0xa8, 0xb0, 0xb8,
	0x120, 0x128, 0x130, 0x138,
};
///ǂ񂿂傤̔ȂꖋŉĩLN^No
#define DONCHOU_NUKINASHI_MAKU		(0x200)




//--------------------------------------------------------------
/**
 * @brief   _XFReXgM[N
 * @param   dpw		_XǗ[Nւ̃|C^
 */
//--------------------------------------------------------------
void DanceOrder_WorkInit(DANCE_PROC_WORK *dpw)
{
	CO_INIT_DATA initdata;
	
	initdata.func_tbl = OrderFuncTbl;
	initdata.func_tbl_max = NELEMS(OrderFuncTbl);
	initdata.my_breeder_no = dpw->consys->c_game.my_breeder_no;
	initdata.server_no = dpw->consys->c_game.server_no;
	initdata.sio_flag = dpw->consys->sio_flag;
	
	CO_WorkInit(&dpw->cow, &initdata);
}


//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   ߑM(M)FTv
 *
 * @param   dpw			_XǗ[Nւ̃|C^
 * @param   work		Cӂ̃|C^
 *
 * @retval  o^ꂽNGXgrbgԍ
 */
//--------------------------------------------------------------
static int Request_Sample(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work)
{
	DANCE_PROC_WORK *dpw = syswork;
	int bit_no;
	
	bit_no = CO_REQUEST_TransmitBufferSet(cow, CSELECT_ALL, order_no, NULL, 0);
	return bit_no;
}

//--------------------------------------------------------------
/**
 * @brief   ߎM(M)FTv
 *
 * @param   dpw			_XǗ[Nւ̃|C^
 * @param   req_head	NGXgwb_̃|C^
 * @param   data		Mf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void Recieve_Sample(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data)
{
	DANCE_PROC_WORK *dpw = syswork;
	
	//ԎԂ	obt@͓ɓn̂Ȃ̂NULLw
	CO_ANSWER_TransmitBufferSet(cow, req_head, NULL, 0);
}

//--------------------------------------------------------------
/**
 * @brief   ԎM(M)FTv
 *
 * @param   dpw				_XǗ[Nւ̃|C^
 * @param   answer_head		Ԏwb_̃|C^
 * @param   ansdat			Mf[^ւ̃|C^
 * @param   net_id			ԎM҂̃lbgID
 */
//--------------------------------------------------------------
static void Answer_Sample(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *answer_head, CO_ANSDAT *ansdat, int net_id)
{
	DANCE_PROC_WORK *dpw = syswork;
	
	//Ԏ󂯎邾Ȃ̂œɂ鎖Ȃ
	return;
}


//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   ߑM(M)Fǂ񂿂傤グ
 *
 * @param   dpw			_XǗ[Nւ̃|C^
 * @param   work		Cӂ̃|C^
 *
 * @retval  o^ꂽNGXgrbgԍ
 */
//--------------------------------------------------------------
static int Request_DonchouUp(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work)
{
	DANCE_PROC_WORK *dpw = syswork;
	int bit_no;
	
	bit_no = CO_REQUEST_TransmitBufferSet(cow, CSELECT_ALL, order_no, NULL, 0);
	return bit_no;
}

//--------------------------------------------------------------
/**
 * @brief   ߎM(M)Fǂ񂿂傤グ
 *
 * @param   dpw			_XǗ[Nւ̃|C^
 * @param   req_head	NGXgwb_̃|C^
 * @param   data		Mf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void Recieve_DonchouUp(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data)
{
	DANCE_PROC_WORK *dpw = syswork;
	DOLOCAL_DONCHOU_UP *du;
	
	du = sys_AllocMemory(HEAPID_DANCE, sizeof(DOLOCAL_DONCHOU_UP));
	MI_CpuClear8(du, sizeof(DOLOCAL_DONCHOU_UP));

	du->dpw = dpw;
	du->req_head = *req_head;
	du->cow = cow;
	
	TCB_Add(DOTCB_DonchouUp, du, TCBPRI_DANCE_ORDERSUB);
}

//--------------------------------------------------------------
/**
 * @brief   ǂ񂿂傤グ
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		DOLOCAL_DONCHOU_UP\
 */
//--------------------------------------------------------------
static void DOTCB_DonchouUp(TCB_PTR tcb, void *work)
{
	DOLOCAL_DONCHOU_UP *du = work;
	
	switch(du->seq){
	case 0:
		//AjEFCg
		if(du->anm_dansa_wait > 0){
			du->anm_dansa_wait--;
			break;
		}
		if(du->anm_wait > 0){
			du->anm_wait--;
			break;
		}
		du->anm_wait = DONCHOU_ANM_WAIT;
		
		//Aj
		{
			u16 *scrn_buf, *dest_scrn;
			int x, y, pos_x, s, base_charno;
			
			scrn_buf = GF_BGL_ScreenAdrsGet(du->dpw->sys.bgl, DANCE_FRAME_EFF);
			for(y = 0; y < DONCHOU_ANM_DATA_Y_LEN; y++){
				if(DonchouAnmLineData[du->anm_line] + y < 0){
					continue;
				}
				dest_scrn = &scrn_buf[32 * (DonchouAnmLineData[du->anm_line] + y)];
				base_charno = DonchouAnmPaternStartCharNo[du->anm_no] + 32*y;
				pos_x = 0;
				for(s = 0; s < 32 / DONCHOU_ANM_DATA_X_LEN; s++){
					for(x = 0; x < DONCHOU_ANM_DATA_X_LEN; x++){
						dest_scrn[pos_x + x] &= 0xfc00;		//LN^Nô݃NA
						dest_scrn[pos_x + x] |= base_charno + x;
					}
					pos_x += DONCHOU_ANM_DATA_X_LEN;
				}
			}
			
			//2iڈȍ~̂ǂ񂿂傤ł͍Ō̃AjꃉCcȂ̂ŁA
			//Ôǂ񂿂傤̎cNAĂ
			//Ӗ킩Ȃꍇ͂Ƃ肠́op܂邲ƃRgAEgĂ݂Ε
			{
				if(du->anm_line > 0 && du->anm_no == 0){
					dest_scrn = &scrn_buf[32 * DonchouAnmLineData[du->anm_line - 1]];
					for(s = 0; s < 32; s++){
						dest_scrn[s] &= 0xfc00;		//LN^Nô݃NA
					}
				}
			}
			
			GF_BGL_LoadScreenV_Req(du->dpw->sys.bgl, DANCE_FRAME_EFF);
		}
		
		du->anm_no++;
		if(du->anm_no >= NELEMS(DonchouAnmPaternStartCharNo)){
			du->anm_no = 0;
			du->anm_line++;
			du->anm_dansa_wait = DONCHOU_DANSA_ANM_WAIT;
			if(du->anm_line >= NELEMS(DonchouAnmLineData)){
				du->seq++;
			}
		}
		break;
	default:
		CO_ANSWER_TransmitBufferSet(du->cow, &du->req_head, NULL, 0);

		sys_FreeMemoryEz(du);
		TCB_Delete(tcb);
		return;
	}
}


//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   ߑM(M)Fǂ񂿂傤
 *
 * @param   dpw			_XǗ[Nւ̃|C^
 * @param   work		Cӂ̃|C^
 *
 * @retval  o^ꂽNGXgrbgԍ
 */
//--------------------------------------------------------------
static int Request_DonchouDown(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work)
{
	DANCE_PROC_WORK *dpw = syswork;
	int bit_no;
	
	bit_no = CO_REQUEST_TransmitBufferSet(cow, CSELECT_ALL, order_no, NULL, 0);
	return bit_no;
}

//--------------------------------------------------------------
/**
 * @brief   ߎM(M)Fǂ񂿂傤
 *
 * @param   dpw			_XǗ[Nւ̃|C^
 * @param   req_head	NGXgwb_̃|C^
 * @param   data		Mf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void Recieve_DonchouDown(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data)
{
	DANCE_PROC_WORK *dpw = syswork;
	DOLOCAL_DONCHOU_DOWN *dd;
	
	dd = sys_AllocMemory(HEAPID_DANCE, sizeof(DOLOCAL_DONCHOU_DOWN));
	MI_CpuClear8(dd, sizeof(DOLOCAL_DONCHOU_DOWN));

	dd->dpw = dpw;
	dd->req_head = *req_head;
	dd->cow = cow;
	
	TCB_Add(DOTCB_DonchouDown, dd, TCBPRI_DANCE_ORDERSUB);

	Snd_BgmPlay(SEQ_CO_TEST);
}

//--------------------------------------------------------------
/**
 * @brief   ǂ񂿂傤
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		DOLOCAL_DONCHOU_DOWN\
 */
//--------------------------------------------------------------
static void DOTCB_DonchouDown(TCB_PTR tcb, void *work)
{
	DOLOCAL_DONCHOU_DOWN *dd = work;
	
	switch(dd->seq){
	case 0:
		//AjEFCg
		if(dd->anm_dansa_wait > 0){
			dd->anm_dansa_wait--;
			break;
		}
		if(dd->anm_wait > 0){
			dd->anm_wait--;
			break;
		}
		dd->anm_wait = DONCHOU_ANM_WAIT;
		
		//Aj
		{
			u16 *scrn_buf, *dest_scrn;
			int x, y, pos_x, s, base_charno;
			int base_line;
			
			scrn_buf = GF_BGL_ScreenAdrsGet(dd->dpw->sys.bgl, DANCE_FRAME_EFF);
			for(y = 0; y < DONCHOU_ANM_DATA_Y_LEN; y++){
				base_line = DonchouAnmLineData[NELEMS(DonchouAnmLineData) - 1 - dd->anm_line];
				if(base_line + y < 0){
					continue;
				}
				dest_scrn = &scrn_buf[32 * (base_line + y)];
				base_charno = DonchouAnmPaternStartCharNo[NELEMS(DonchouAnmPaternStartCharNo) - 1 - dd->anm_no] + 32*y;
				pos_x = 0;
				for(s = 0; s < 32 / DONCHOU_ANM_DATA_X_LEN; s++){
					for(x = 0; x < DONCHOU_ANM_DATA_X_LEN; x++){
						dest_scrn[pos_x + x] &= 0xfc00;		//LN^Nô݃NA
						dest_scrn[pos_x + x] |= base_charno + x;
					}
					pos_x += DONCHOU_ANM_DATA_X_LEN;
				}
			}
			
			//ԉ̃CȊO͍Ō܂ŉ̃Aj̐ꖋȂ̂ŁA
			//̒ĩAjsꂽ^C~OŔȂ̃AjɕςĂ
			//Ӗ킩Ȃꍇ͂Ƃ肠́op܂邲ƃRgAEgĂ݂Ε
			{
				if(dd->anm_line > 0 && dd->anm_no == 0){
					base_line = DonchouAnmLineData[NELEMS(DonchouAnmLineData) - 1 - dd->anm_line + 1];
					base_line += DONCHOU_ANM_DATA_Y_LEN - 1;
					dest_scrn = &scrn_buf[base_line * 32];
					for(s = 0; s < 32; s++){
						dest_scrn[s] &= 0xfc00;		//LN^Nô݃NA
						dest_scrn[s] |= DONCHOU_NUKINASHI_MAKU + (s % DONCHOU_ANM_DATA_X_LEN);
					}
				}
			}
			
			GF_BGL_LoadScreenV_Req(dd->dpw->sys.bgl, DANCE_FRAME_EFF);
		}
		
		dd->anm_no++;
		if(dd->anm_no >= NELEMS(DonchouAnmPaternStartCharNo)){
			dd->anm_no = 0;
			dd->anm_line++;
			dd->anm_dansa_wait = DONCHOU_DANSA_ANM_WAIT;
			if(dd->anm_line >= NELEMS(DonchouAnmLineData)){
				dd->seq++;
			}
		}
		break;
	default:
		CO_ANSWER_TransmitBufferSet(dd->cow, &dd->req_head, NULL, 0);

		sys_FreeMemoryEz(dd);
		TCB_Delete(tcb);
		return;
	}
}


//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   ߑM(M)F_XI
 *
 * @param   vpw			Z͕Ǘ[Nւ̃|C^
 * @param   work		Cӂ̃|C^
 *
 * @retval  o^ꂽNGXgrbgԍ
 */
//--------------------------------------------------------------
static int Request_DanceExit(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work)
{
	DANCE_PROC_WORK *dpw = syswork;
	int bit_no;
	
	bit_no = CO_REQUEST_TransmitBufferSet(cow, CSELECT_ALL, order_no, NULL, 0);
	return bit_no;
}

//--------------------------------------------------------------
/**
 * @brief   ߎM(M)F_XI
 *
 * @param   dpw			Z͕Ǘ[Nւ̃|C^
 * @param   req_head	NGXgwb_̃|C^
 * @param   data		Mf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void Recieve_DanceExit(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data)
{
	DANCE_PROC_WORK *dpw = syswork;

	dpw->main_end = TRUE;
	
	//ԎԂ	obt@͓ɓn̂Ȃ̂NULLw
	CO_ANSWER_TransmitBufferSet(cow, req_head, NULL, 0);
}


//==============================================================================
//	
//==============================================================================
#if 0	//C_T[obN_T[ʂQƂ悤ɂȂB
//--------------------------------------------------------------
/**
 * @brief   ߑM(M)FC_X
 *
 * @param   dpw			_XǗ[Nւ̃|C^
 * @param   work		Cӂ̃|C^
 *
 * @retval  o^ꂽNGXgrbgԍ
 */
//--------------------------------------------------------------
static int Request_Dancing(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work)
{
	DANCE_PROC_WORK *dpw = syswork;
	int bit_no;
	
	bit_no = CO_REQUEST_TransmitBufferSet(cow, CSELECT_ALL, order_no, 
		work, sizeof(DANCE_ADVANCE_PARAM));
	return bit_no;
}

//--------------------------------------------------------------
/**
 * @brief   ߎM(M)FC_X
 *
 * @param   dpw			_XǗ[Nւ̃|C^
 * @param   req_head	NGXgwb_̃|C^
 * @param   data		Mf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void Recieve_Dancing(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data)
{
	DANCE_PROC_WORK *dpw = syswork;
	DANCE_ADVANCE_PARAM *dap = data;
	DOLOCAL_MAINDANCE *md;
	
	md = sys_AllocMemory(HEAPID_DANCE, sizeof(DOLOCAL_MAINDANCE));
	MI_CpuClear8(md, sizeof(DOLOCAL_MAINDANCE));

	md->dpw = dpw;
	md->req_head = *req_head;
	md->cow = cow;
	md->dap = *dap;
	
	md->dtw.dpw = dpw;
	
	TCB_Add(DOTCB_Dancing, md, TCBPRI_DANCE_ORDERSUB);
}

//--------------------------------------------------------------
/**
 * @brief   _Xsp[^M^XN𐶐܂
 * @param   param		_Xsp[^ւ̃|C^
 * @retval  M^XÑ|C^
 */
//--------------------------------------------------------------
static TCB_PTR DancingParamSendTaskSet(DANCE_PROC_WORK *dpw, const DANCING_PARAM *param)
{
	DANCING_SEND_WORK *sendwork;
	
	sendwork = sys_AllocMemory(HEAPID_DANCE, sizeof(DANCING_SEND_WORK));
	MI_CpuClear8(sendwork, sizeof(DANCING_SEND_WORK));
	sendwork->dpw = dpw;
	sendwork->dancing_param = *param;
	
	//ʐM̎łAC_T[̃_XXV^C~OX̃NCAgł
	//ɂ邽߁AOrdernSďIĂs^XNŃp[^̑M
	return TCB_Add(DancingParamSendTaskMain, sendwork, TCBPRI_DANCE_DANCING_PARAM_SEND);
}

//--------------------------------------------------------------
/**
 * @brief   _Xsp[^M^XNC
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		DANCING_SEND_WORK\
 */
//--------------------------------------------------------------
static void DancingParamSendTaskMain(TCB_PTR tcb, void *work)
{
	DANCING_SEND_WORK *sendwork = work;
	int end = 0;
	
	if(sendwork->dpw->consys->sio_flag == FALSE){
		DT_DancingParamRecieve(sendwork->dpw, &sendwork->dancing_param);
		OS_TPrintf("_Xsf[^MFMu[_[=%d\n", 
			sendwork->dancing_param.breeder_no);

		end++;
	}
	else{
		if(CommSendFixSizeData(CC_DANCE_DATA, &sendwork->dancing_param) == TRUE){
			OS_TPrintf("_Xsf[^MFMu[_[=%d\n", 
				sendwork->dancing_param.breeder_no);
			
			end++;
		}
		else{
			
		}
	}
	
	if(end > 0){
		sys_FreeMemoryEz(work);
		TCB_Delete(tcb);
		return;
	}
}

//--------------------------------------------------------------
/**
 * @brief   C_X(xꍇ)
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		DOLOCAL_MAINDANCE\
 */
//--------------------------------------------------------------
static void DOTCB_Dancing(TCB_PTR tcb, void *work)
{
	DOLOCAL_MAINDANCE *md = work;
	int tp_ret, dancer_type, rotation_pos;
	
	if(md->dpw->consys->c_game.my_breeder_no == md->dap.now_breeder){
		dancer_type = DANCER_MAIN;
	}
	else{
		dancer_type = DANCER_BACK;
	}
	
	switch(md->seq){
	case 0:
		if(dancer_type == DANCER_MAIN){
			DT_FumenColorSet(&md->dpw->sys, FUMENCOLOR_MAIN);
		}
		else{
			DT_FumenColorSet(&md->dpw->sys, FUMENCOLOR_BACK);
		}
		md->seq++;
		break;
	case 1:
		md->frame++;
		
		{//Ȑiso[XV
			int frame;
			
			if(dancer_type == DANCER_MAIN){
				frame = md->frame;
			}
			else{
				if(md->frame <= md->dap.musicdata.frame / 2){
					if(md->loop == 0){
						frame = 0;
					}
					else{
						frame = md->frame + md->dap.musicdata.frame / 2;
					}
				}
				else{
					frame = md->frame - md->dap.musicdata.frame / 2;
				}
			}
			DT_MusicBarAnimeUpdateFrame(&md->dpw->sys, frame, md->dap.musicdata.frame);
		}
		
		{//Ȑiso[̓B⃋[vmF
			if(md->frame >= md->dap.musicdata.frame){
				md->loop++;
				md->frame = 0;
				if(dancer_type == DANCER_MAIN){
					DT_OnpuActorDelAll(&md->dpw->sys);
					if(md->loop >= md->dap.musicdata.loop){
						DT_FumenColorSet(&md->dpw->sys, FUMENCOLOR_NULL);
					}
				}
			}
			else if(md->loop >= md->dap.musicdata.loop 
					&& md->frame >= md->dap.musicdata.frame / 2){
				md->seq++;
				break;
			}
			else if(dancer_type == DANCER_BACK && md->frame == md->dap.musicdata.frame / 2){
				DT_OnpuActorDelAll(&md->dpw->sys);
			}
		}
		
		{//[e[Vʒu擾
			for(rotation_pos = 0; rotation_pos < BREEDER_MAX; rotation_pos++){
				if(md->dap.breeder_rotation[rotation_pos] ==md->dpw->consys->c_game.my_breeder_no){
					break;
				}
			}
		}
		
		{//^b``FbN
			DANCING_PARAM dancing_param;
			
			if(dancer_type == DANCER_MAIN){
				//C_T[
				if(md->loop < md->dap.musicdata.loop 
						&& md->frame >= md->dap.musicdata.frame / 2){
					DanceTouchCheck(&md->dtw, &tp_ret, FALSE, FALSE);
				}
				else{
					DanceTouchCheck(&md->dtw, &tp_ret, TRUE, TRUE);
				}
				
				if(tp_ret != RECT_HIT_NONE){
					DancerReactionSet(md->dpw->consys->c_game.my_breeder_no, tp_ret, md->frame, 
						md->dap.musicdata.frame, &md->dap.musicdata.lag, 
						&dancing_param, NULL, rotation_pos);
					DancingParamSendTaskSet(md->dpw, &dancing_param);
				}
			}
			else{
				//obN_T[
				if(md->loop > 0 && md->frame < md->dap.musicdata.frame / 2){
					DanceTouchCheck(&md->dtw, &tp_ret, FALSE, FALSE);
				}
				else{
					DanceTouchCheck(&md->dtw, &tp_ret, TRUE, TRUE);
				}
				
				if(tp_ret != RECT_HIT_NONE){
					DancerReactionSet(md->dpw->consys->c_game.my_breeder_no, tp_ret, md->frame, 
						md->dap.musicdata.frame, &md->dap.musicdata.lag, 
						&dancing_param, md->dpw->maindancer_record, rotation_pos);
					DancingParamSendTaskSet(md->dpw, &dancing_param);
				}
			}
		}
		break;
	default:
		if(DanceTouchCheck(&md->dtw, &tp_ret, TRUE, FALSE) == TRUE){
			DT_OnpuActorDelAll(&md->dpw->sys);
			DT_MusicBarAnimeUpdateFrame(&md->dpw->sys, 0, md->dap.musicdata.frame);
			DT_FumenColorSet(&md->dpw->sys, FUMENCOLOR_NULL);
			if(DINPUT_MakeDataNoGet(md->dpw->dip) != DINPUT_TYPE_WALL){
				DINPUT_CreateBG(md->dpw->dip, DINPUT_TYPE_WALL, TRUE, NULL);
			}
			
			CO_ANSWER_TransmitBufferSet(md->cow, &md->req_head, NULL, 0);

			sys_FreeMemoryEz(md);
			TCB_Delete(tcb);
			return;
		}
		break;
	}
}

//--------------------------------------------------------------
/**
 * @brief   _Xł̃^b``FbN
 *
 * @param   dtw			
 * @param   tp_ret		^b`ʑ
 * @param   check		TRUE:ҋ@Ԃ`FbN(^b`ɂ͔Ȃ)
 * @param   no_touch_bg	TRUE:^b`oȂBGԂɂ(ҋ@ԂɂȂĂ鎞̂ݗL)
 *
 * @retval  TRUE:ҋ@B@FALSE:(GtFNgȂ)
 */
//--------------------------------------------------------------
static int DanceTouchCheck(DANCE_TOUCH_WORK *dtw, int *tp_ret, int check, int no_touch_bg)
{
	int taiki;
	
	taiki = FALSE;
	*tp_ret = RECT_HIT_NONE;
	
	switch(dtw->seq){
	case 0:
		if(check == FALSE && no_touch_bg == FALSE){
			DINPUT_CreateBG(dtw->dpw->dip, DINPUT_TYPE_COMMAND, TRUE, NULL);
			dtw->seq++;
		}
		else{
			taiki = TRUE;
		}
		break;
	case 1:
		if(check == TRUE){
			taiki = TRUE;
			break;		//`FbN̎͂炽ȃ^b`Ȃ
		}
		
		*tp_ret = DINPUT_TouchCheck(dtw->dpw->dip);
		if(*tp_ret != RECT_HIT_NONE){
			Snd_SePlay(DSE_DECIDE);
			dtw->seq++;
		}
		else{
			taiki = TRUE;
		}
		break;
	case 2:
		if(DINPUT_EffectEndCheck(dtw->dpw->dip) == TRUE){
			DINPUT_CreateBG(dtw->dpw->dip, DINPUT_TYPE_COMMAND, TRUE, NULL);
			dtw->seq = 1;
		}
		break;
	}
	
	if(no_touch_bg == TRUE && taiki == TRUE){
		if(DINPUT_MakeDataNoGet(dtw->dpw->dip) != DINPUT_TYPE_WALL){
			DINPUT_CreateBG(dtw->dpw->dip, DINPUT_TYPE_WALL, TRUE, NULL);
			dtw->seq = 0;
		}
	}
	
	return taiki;
}

//--------------------------------------------------------------
/**
 * @brief   ^b`plʂ_X^Cvɕϊ
 * @param   dance_tp		DANCE_TP_???
 * @retval  DANCE_STEP_???
 */
//--------------------------------------------------------------
static int DanceTP_to_DanceStep(int dance_tp)
{
	int dance_step;
	
	switch(dance_tp){
	case DANCE_TP_JUMP:
		dance_step = DANCE_STEP_JUMP;
		break;
	case DANCE_TP_ADVANCE:
		dance_step = DANCE_STEP_ADVANCE;
		break;
	case DANCE_TP_LEFT:
		dance_step = DANCE_STEP_LEFT;
		break;
	case DANCE_TP_RIGHT:
		dance_step = DANCE_STEP_RIGHT;
		break;
	default:
		GF_ASSERT(0 && "ȃANVł\n");
		return 0;
	}
	return dance_step;
}

//--------------------------------------------------------------
/**
 * @brief   _X̂ꂩ]擾
 *
 * @param   lag				_X̂(q牽t[Ă邩)
 * @param   dld				rf[^ւ̃|C^
 * @param   ret_review		]^Cv
 * @param   ret_lag			O^Cv
 * @param   ret_onpu		^Cv
 */
//--------------------------------------------------------------
static void DanceLagReviewTypeGet(int lag, const DANCE_LAG_DATA *dld, 
	u8 *ret_review, u8 *ret_lag, u8 *ret_onpu)
{
	if(lag <= dld->excellent_a){
		*ret_review = REVIEW_TYPE_EXCELLENT;
		*ret_lag = DANCE_LAG_EXCELLENT_A;
		*ret_onpu = ONPU_TYPE_B;
	}
	else if(lag <= dld->excellent_b){
		*ret_review = REVIEW_TYPE_EXCELLENT;
		*ret_lag = DANCE_LAG_EXCELLENT_B;
		*ret_onpu = ONPU_TYPE_B;
	}
	else if(lag <= dld->good_a){
		*ret_review = REVIEW_TYPE_GOOD;
		*ret_lag = DANCE_LAG_GOOD_A;
		*ret_onpu = ONPU_TYPE_A;
	}
	else if(lag <= dld->good_b){
		*ret_review = REVIEW_TYPE_GOOD;
		*ret_lag = DANCE_LAG_GOOD_B;
		*ret_onpu = ONPU_TYPE_A;
	}
	else{
		*ret_review = REVIEW_TYPE_FAILED;
		*ret_lag = DANCE_LAG_FAILED;
		*ret_onpu = ONPU_TYPE_A;
	}
}

//--------------------------------------------------------------
/**
 * @brief   _Xt[ΏۂƂȂ鏬߂ƁA
 *          ̏ߒx̃t[牽t[Ă邩擾
 *
 * @param   frame		_XsuԂ̃t[
 * @param   max_frame	Ȑis̍őt[
 * @param   ret_lag		(t[q炸Ă邩)
 * @param   ret_beat	ΏۂƂȂߑ
 */
//--------------------------------------------------------------
static void DancerLagBeatCheck(int frame, int max_frame, u32 *ret_lag, u32 *ret_beat)
{
	u32 just_frame, hit_frame, min_frame, big_frame, check_frame;
	u32 min_lag, big_lag;
	u32 hit_beat, lag;
	
	just_frame = (max_frame << 8) / DANCE_BEAT;
	hit_frame = frame << 8;
	
	min_frame = 0;
	hit_beat = 0;
	for(check_frame = 0; check_frame < hit_frame; check_frame += just_frame){
		min_frame = check_frame;
		hit_beat++;
	}
	big_frame = check_frame;
	
	min_frame = (min_frame + 0x0080) >> 8;	//ľܓĐ
	big_frame = (big_frame + 0x0080) >> 8;
	hit_frame >>= 8;
	
	//̏ȂvZ̑ΏۂƂ
	min_lag = MATH_ABS((s32)(hit_frame - min_frame));
	big_lag = MATH_ABS((s32)(hit_frame - big_frame));
	if(min_lag <= big_lag){
		lag = min_lag;
		hit_beat--;
	}
	else{
		lag = big_lag;
	}
	
	*ret_lag = lag;
	*ret_beat = hit_beat;
}

//--------------------------------------------------------------
/**
 * @brief   _T[_Xs̃ANVp[^Zbg
 *
 * @param   breeder_no		̃u[_[ԍ
 * @param   reaction		s_X(DANCE_TP_???)
 * @param   frame			_Xst[
 * @param   max_frame		Ȑisőt[
 * @param   dld				rf[^ւ̃|C^
 * @param   param			ANVp[^ւ̃|C^
 * @param   maindancer_record	_XĂ̂C_T[̏ꍇNULLw
 *                              obN_T[̏ꍇ̓C_T[̃_Xւ̃|C^
 * @param   rotation_pos	[e[Vʒu
 */
//--------------------------------------------------------------
static void DancerReactionSet(int breeder_no, int reaction, int frame, int max_frame, 
	const DANCE_LAG_DATA *dld, DANCING_PARAM *param, const DANCING_PARAM *maindancer_record,
	int rotation_pos)
{
	int dance_step, i;
	u8 review_type, lag_type, onpu_type;
	u32 lag, hit_beat;
	int main_back;
	
	//^b`plʂ_X^Cv擾
	dance_step = DanceTP_to_DanceStep(reaction);
	
	//^b`t[ΏۂƂȂ鏬߂ƁȀߒx̃t[牽t[Ă邩擾
	DancerLagBeatCheck(frame, max_frame, &lag, &hit_beat);
	OS_TPrintf("Ώۏ=%d, =%dt[\n", hit_beat, lag);
	
	//ꂩ]擾
	DanceLagReviewTypeGet(lag, dld, &review_type, &lag_type, &onpu_type);
	if(maindancer_record != NULL){
		//obN_T[̏ꍇAC_T[̃_XƔrs
		for(i = 0; i < DANCING_RECORD_MAX; i++){
			if(maindancer_record[i].frame != 0 && maindancer_record[i].hit_beat == hit_beat){
				break;	//߂̃C_T[̗ɂ̂ō̂f[^̗p
			}
		}
		if(i == DANCING_RECORD_MAX){
			lag = 0xff;	//qbg߂Ȃ̂łőɂ(FAILED]𓾂)
			OS_TPrintf("C_T[ƃqbgȂ̂łő\n");
		}
		main_back = DANCER_BACK;
	}
	else{
		main_back = DANCER_MAIN;
	}
	
	//p[^Zbg
	param->breeder_no = breeder_no;
	param->frame = frame;
	param->dance_step = dance_step;
	param->review_type = review_type;
	param->lag_type = lag_type;
	param->onpu_type = onpu_type;
	param->hit_beat = hit_beat;
	param->rotation_pos = rotation_pos;
	param->main_back = main_back;
}

//--------------------------------------------------------------
/**
 * @brief   ԎM(M)FC_X
 *
 * @param   dpw				_XǗ[Nւ̃|C^
 * @param   answer_head		Ԏwb_̃|C^
 * @param   ansdat			Mf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void Answer_Dancing(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *answer_head, CO_ANSDAT *ansdat, int net_id)
{
	DANCE_PROC_WORK *dpw = syswork;
	
	//Ԏ󂯎邾Ȃ̂œɂ鎖Ȃ
	return;
}
#else	//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//==============================================================================
//	C_X
//==============================================================================
//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   ߑM(M)FC_X
 *
 * @param   dpw			_XǗ[Nւ̃|C^
 * @param   work		Cӂ̃|C^
 *
 * @retval  o^ꂽNGXgrbgԍ
 */
//--------------------------------------------------------------
static int Request_Dancing(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work)
{
	DANCE_PROC_WORK *dpw = syswork;
	int bit_no;
	
	bit_no = CO_REQUEST_TransmitBufferSet(cow, CSELECT_ALL, order_no, 
		work, sizeof(DANCE_ADVANCE_PARAM));
	return bit_no;
}

//--------------------------------------------------------------
/**
 * @brief   ߎM(M)FC_X
 *
 * @param   dpw			_XǗ[Nւ̃|C^
 * @param   req_head	NGXgwb_̃|C^
 * @param   data		Mf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void Recieve_Dancing(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data)
{
	DANCE_PROC_WORK *dpw = syswork;
	DANCE_ADVANCE_PARAM *dap = data;
	DOLOCAL_MAINDANCE *md;
	int i, rotation_pos;
	
	md = sys_AllocMemory(HEAPID_DANCE, sizeof(DOLOCAL_MAINDANCE));
	MI_CpuClear8(md, sizeof(DOLOCAL_MAINDANCE));

	md->dpw = dpw;
	md->req_head = *req_head;
	md->cow = cow;
	md->dap = *dap;
	
	md->dtw.dpw = dpw;
	
	TCB_Add(DOTCB_Dancing, md, TCBPRI_DANCE_ORDERSUB);
	
	//AI^XN(ʐMł̒xlAIAIԍAIp̃_̎킾
	//e[JŌvZ͍s)
	for(i = dpw->consys->c_game.player_num; i < BREEDER_MAX; i++){
		{//[e[Vʒu擾
			for(rotation_pos = 0; rotation_pos < BREEDER_MAX; rotation_pos++){
				if(md->dap.breeder_rotation[rotation_pos] == i){
					break;
				}
			}
		}
		md->aiwork[i] = DanceAI_Create(i, rotation_pos, dap->ai_no[i], dap->ai_random_seed[i]);
		DanceAI_Calc(dpw, md->aiwork[i], dap->all_tempo_frame, 
			dap->one_tempo_frame, &dap->musicdata);
	}
}

///C_T[̃t[mF(TRUEƃC_T[t[)
#define MAIN_DANCER_FRAME_CHECK(frame, all_tempo_frame)		(frame < all_tempo_frame / 2)
///obN_T[̃t[mF(TRUEƃobN_T[t[)
#define BACK_DANCER_FRAME_CHECK(frame, all_tempo_frame)		(frame >= all_tempo_frame / 2)

//--------------------------------------------------------------
/**
 * @brief   _Xsp[^M^XN𐶐܂
 * @param   param		_Xsp[^ւ̃|C^
 * @param   ai			TRUE=AIAFALSE=vC[
 * @retval  M^XÑ|C^
 */
//--------------------------------------------------------------
static TCB_PTR DancingParamSendTaskSet(DANCE_PROC_WORK *dpw, const DANCING_PARAM *param, int ai)
{
	DANCING_SEND_WORK *sendwork;
	
	sendwork = sys_AllocMemory(HEAPID_DANCE, sizeof(DANCING_SEND_WORK));
	MI_CpuClear8(sendwork, sizeof(DANCING_SEND_WORK));
	sendwork->dpw = dpw;
	sendwork->dancing_param = *param;
	sendwork->ai = ai;
	
	//ʐM̎łAC_T[̃_XXV^C~OX̃NCAgł
	//ɂ邽߁AOrdernSďIĂs^XNŃp[^̑M
	return TCB_Add(DancingParamSendTaskMain, sendwork, TCBPRI_DANCE_DANCING_PARAM_SEND);
}

//--------------------------------------------------------------
/**
 * @brief   _Xsp[^M^XNC
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		DANCING_SEND_WORK\
 */
//--------------------------------------------------------------
static void DancingParamSendTaskMain(TCB_PTR tcb, void *work)
{
	DANCING_SEND_WORK *sendwork = work;
	int end = 0;
	
	if(sendwork->dpw->consys->sio_flag == FALSE || sendwork->ai == TRUE){
		DT_DancingParamRecieve(sendwork->dpw, &sendwork->dancing_param);
		OS_TPrintf("_Xsf[^MFMu[_[=%d\n", 
			sendwork->dancing_param.breeder_no);

		end++;
	}
	else{
		if(CommSendFixSizeData(CC_DANCE_DATA, &sendwork->dancing_param) == TRUE){
			OS_TPrintf("_Xsf[^MFMu[_[=%d\n", 
				sendwork->dancing_param.breeder_no);
			
			end++;
		}
		else{
			
		}
	}
	
	if(end > 0){
		sys_FreeMemoryEz(work);
		TCB_Delete(tcb);
		return;
	}
}

//--------------------------------------------------------------
/**
 * @brief   C_X(xꍇ)
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		DOLOCAL_MAINDANCE\
 */
//--------------------------------------------------------------
static void DOTCB_Dancing(TCB_PTR tcb, void *work)
{
	DOLOCAL_MAINDANCE *md = work;
	int tp_ret, dancer_type, rotation_pos;
	u32 frame;
	
	if(md->dpw->consys->c_game.my_breeder_no == md->dap.now_breeder){
		dancer_type = DANCER_MAIN;
	}
	else{
		dancer_type = DANCER_BACK;
	}
	
	frame = md->dpw->music_vcount - md->dpw->music_vcount_start;
	
	switch(md->seq){
	case 0:
	#if 0
		if(dancer_type == DANCER_MAIN){
			DT_FumenColorSet(&md->dpw->sys, FUMENCOLOR_MAIN);
		}
		else{
			DT_FumenColorSet(&md->dpw->sys, FUMENCOLOR_BACK);
		}
	#endif
		DT_FumenColorSet(&md->dpw->sys, FUMENCOLOR_MAIN);
		DT_MainDancerRecordInit(md->dpw);
		
		Snd_BgmPlay(SEQ_CO_JUNBI);
		
		md->seq++;
		break;
	case 1:
		if(Snd_BgmPlayCheck(SEQ_CO_JUNBI) == FALSE){
			Snd_BgmPlay(SEQ_CO_KAWAI);
			
			md->dpw->music_vcount_flag = TRUE;
			md->dpw->music_vcount_start = md->dpw->music_vcount;
			OS_TPrintf("PTcount = %d\n", md->dpw->music_vcount_start);
			md->seq++;
		}
		break;
	case 2:
		{//Ȑiso[XV
			DT_MusicBarAnimeUpdateFrame(&md->dpw->sys, 
				md->dpw->music_vcount - md->dpw->music_vcount_start, md->dap.all_tempo_frame);
		}
		
		{//Ȑiso[̓B⃋[vmF
			if(frame >= md->dap.all_tempo_frame){
				md->loop++;
				md->dpw->music_vcount_start = md->dpw->music_vcount;
				OS_TPrintf("2Tcount = %d\n", md->dpw->music_vcount_start);
				DT_OnpuActorDelAll(&md->dpw->sys);
				DT_MainDancerRecordInit(md->dpw);

				//^b`񐔃Zbg
				{
					int i;
					md->touch_count = 0;
					for(i = md->dpw->consys->c_game.player_num; i < BREEDER_MAX; i++){
						md->aiwork[i]->touch_count = 0;
					}
				}

				if(md->loop >= md->dap.musicdata.loop){
					DT_FumenColorSet(&md->dpw->sys, FUMENCOLOR_NULL);
					md->seq++;
					break;
				}
				break;
			}
		}
		
		{//[e[Vʒu擾
			for(rotation_pos = 0; rotation_pos < BREEDER_MAX; rotation_pos++){
				if(md->dap.breeder_rotation[rotation_pos] ==md->dpw->consys->c_game.my_breeder_no){
					break;
				}
			}
		}
		
		{//^b``FbN
			DANCING_PARAM dancing_param;
			
			if(dancer_type == DANCER_MAIN){
				//C_T[
				//if(frame < md->dap.all_tempo_frame / 2){
				if(MAIN_DANCER_FRAME_CHECK(frame, md->dap.all_tempo_frame)
						&& md->touch_count < md->dap.musicdata.touch_count){
					DanceTouchCheck(&md->dtw, &tp_ret, FALSE, FALSE);
				}
				else{
					DanceTouchCheck(&md->dtw, &tp_ret, TRUE, TRUE);
				}
				
				if(tp_ret != RECT_HIT_NONE){
					DancerReactionSet(md->dpw->consys->c_game.my_breeder_no, tp_ret, frame, 
						md->dap.one_tempo_frame, &md->dap.musicdata.lag, 
						&dancing_param, NULL, rotation_pos);
					DancingParamSendTaskSet(md->dpw, &dancing_param, FALSE);
					md->touch_count++;
				}
			}
			else{
				//obN_T[
				//if(frame >= md->dap.all_tempo_frame / 2){
				if(BACK_DANCER_FRAME_CHECK(frame, md->dap.all_tempo_frame)
						&& md->touch_count < md->dap.musicdata.touch_count){
					DanceTouchCheck(&md->dtw, &tp_ret, FALSE, FALSE);
				}
				else{
					DanceTouchCheck(&md->dtw, &tp_ret, TRUE, TRUE);
				}
				
				if(tp_ret != RECT_HIT_NONE){
					DancerReactionSet(md->dpw->consys->c_game.my_breeder_no, tp_ret, frame, 
						md->dap.one_tempo_frame, &md->dap.musicdata.lag, 
						&dancing_param, md->dpw->maindancer_record, rotation_pos);
					DancingParamSendTaskSet(md->dpw, &dancing_param, FALSE);
					md->touch_count++;
				}
			}
		}
		
		//AIvZ
		{
			int i;
			
			for(i = md->dpw->consys->c_game.player_num; i < BREEDER_MAX; i++){
				DanceAI_Main(md->dpw, md->aiwork[i], frame, 
					md->dap.all_tempo_frame, md->dap.one_tempo_frame, &md->dap.musicdata);
			}
		}
		
		break;
	case 3:
		if(DanceTouchCheck(&md->dtw, &tp_ret, TRUE, FALSE) == TRUE){
			DT_OnpuActorDelAll(&md->dpw->sys);
			DT_MusicBarAnimeUpdateFrame(&md->dpw->sys, 0, md->dap.all_tempo_frame);
			DT_FumenColorSet(&md->dpw->sys, FUMENCOLOR_NULL);
			if(DINPUT_MakeDataNoGet(md->dpw->dip) != DINPUT_TYPE_WALL){
				DINPUT_CreateBG(md->dpw->dip, DINPUT_TYPE_WALL, TRUE, NULL);
			}
			
			//AI폜
			{
				int i;
				
				for(i = md->dpw->consys->c_game.player_num; i < BREEDER_MAX; i++){
					DanceAI_Delete(md->aiwork[i]);
					md->aiwork[i] = NULL;
				}
			}

			//Snd_BgmStop(SEQ_CO_KAWAI, 0);
			Snd_BgmFadeOut(0, 30);

			md->dpw->music_vcount_flag = FALSE;
			
			md->seq++;
		}
		break;
	default:
		if(Snd_FadeCheck() == 0){
			CO_ANSWER_TransmitBufferSet(md->cow, &md->req_head, NULL, 0);

			sys_FreeMemoryEz(md);
			TCB_Delete(tcb);
			return;
		}
		break;
	}
}

//--------------------------------------------------------------
/**
 * @brief   _Xł̃^b``FbN
 *
 * @param   dtw			
 * @param   tp_ret		^b`ʑ
 * @param   check		TRUE:ҋ@Ԃ`FbN(^b`ɂ͔Ȃ)
 * @param   no_touch_bg	TRUE:^b`oȂBGԂɂ(ҋ@ԂɂȂĂ鎞̂ݗL)
 *
 * @retval  TRUE:ҋ@B@FALSE:(GtFNgȂ)
 */
//--------------------------------------------------------------
///^b`Ɏ̃^b``FbNo܂ł̃EFCg
#define DANCE_TOUCH_WAIT		(10)
static int DanceTouchCheck(DANCE_TOUCH_WORK *dtw, int *tp_ret, int check, int no_touch_bg)
{
	int taiki;
	
	taiki = FALSE;
	*tp_ret = RECT_HIT_NONE;
	
	switch(dtw->seq){
	case 0:
		if(check == FALSE && no_touch_bg == FALSE){
			DINPUT_CreateBG(dtw->dpw->dip, DINPUT_TYPE_COMMAND, TRUE, NULL);
			dtw->seq++;
		}
		else{
			taiki = TRUE;
		}
		break;
	case 1:
		if(check == TRUE){
			taiki = TRUE;
			break;		//`FbN̎͂炽ȃ^b`Ȃ
		}
		if(dtw->touch_wait > 0){
			dtw->touch_wait = 0;
		}
		
		*tp_ret = DINPUT_TouchCheck(dtw->dpw->dip);
		if(*tp_ret != RECT_HIT_NONE){
//			Snd_SePlay(DSE_DECIDE);
			dtw->seq++;
		}
		else{
			taiki = TRUE;
		}
		break;
	case 2:
		if(DINPUT_EffectEndCheck(dtw->dpw->dip) == TRUE){
			//DINPUT_CreateBG(dtw->dpw->dip, DINPUT_TYPE_COMMAND, TRUE, NULL);
			dtw->touch_wait = DANCE_TOUCH_WAIT;
			dtw->seq = 1;
		}
		break;
	}
	
	if(no_touch_bg == TRUE && taiki == TRUE){
		if(DINPUT_MakeDataNoGet(dtw->dpw->dip) != DINPUT_TYPE_WALL){
			DINPUT_CreateBG(dtw->dpw->dip, DINPUT_TYPE_WALL, TRUE, NULL);
			dtw->seq = 0;
		}
	}
	
	return taiki;
}

//--------------------------------------------------------------
/**
 * @brief   ^b`plʂ_X^Cvɕϊ
 * @param   dance_tp		DANCE_TP_???
 * @retval  DANCE_STEP_???
 */
//--------------------------------------------------------------
static int DanceTP_to_DanceStep(int dance_tp)
{
	int dance_step;
	
	switch(dance_tp){
	case DANCE_TP_JUMP:
		dance_step = DANCE_STEP_JUMP;
		break;
	case DANCE_TP_ADVANCE:
		dance_step = DANCE_STEP_ADVANCE;
		break;
	case DANCE_TP_LEFT:
		dance_step = DANCE_STEP_LEFT;
		break;
	case DANCE_TP_RIGHT:
		dance_step = DANCE_STEP_RIGHT;
		break;
	default:
		GF_ASSERT(0 && "ȃANVł\n");
		return 0;
	}
	return dance_step;
}

//--------------------------------------------------------------
/**
 * @brief   _X̂ꂩ]擾
 *
 * @param   lag				_X̂(q牽t[Ă邩)
 * @param   dld				rf[^ւ̃|C^
 * @param   ret_review		]^Cv
 * @param   ret_lag			O^Cv
 */
//--------------------------------------------------------------
static void DanceLagReviewTypeGet(int lag, const DANCE_LAG_DATA *dld, 
	u8 *ret_review, u8 *ret_lag)
{
	if(lag <= dld->excellent_a){
		*ret_review = REVIEW_TYPE_EXCELLENT;
		*ret_lag = DANCE_LAG_EXCELLENT_A;
	}
	else if(lag <= dld->excellent_b){
		*ret_review = REVIEW_TYPE_EXCELLENT;
		*ret_lag = DANCE_LAG_EXCELLENT_B;
	}
	else if(lag <= dld->good_a){
		*ret_review = REVIEW_TYPE_GOOD;
		*ret_lag = DANCE_LAG_GOOD_A;
	}
	else if(lag <= dld->good_b){
		*ret_review = REVIEW_TYPE_GOOD;
		*ret_lag = DANCE_LAG_GOOD_B;
	}
	else{
		*ret_review = REVIEW_TYPE_FAILED;
		*ret_lag = DANCE_LAG_FAILED;
	}
}

//--------------------------------------------------------------
/**
 * @brief   _Xt[ΏۂƂȂ鏬߂ƁA
 *          ̏ߒx̃t[牽t[Ă邩擾
 *
 * @param   frame				_XsuԂ̃t[
 * @param   one_tempo_frame		1߂ɂt[
 * @param   ret_lag				(t[q炸Ă邩)
 * @param   ret_beat			ΏۂƂȂߑ
 */
//--------------------------------------------------------------
static void DancerLagBeatCheck(u32 frame, u32 one_tempo_frame, u32 *ret_lag, u32 *ret_beat)
{
	u32 just_frame, hit_frame, min_frame, big_frame, check_frame;
	u32 min_lag, big_lag;
	u32 hit_beat, lag;
	u32 half_tempo_frame;
	s64 calc_frame;
	
	hit_frame = frame * ONE_TEMPO_CALC_DECIMAL;
	half_tempo_frame = one_tempo_frame / 2;	//邽߁A1߂̔ɂ
	
	min_frame = 0;
	hit_beat = 0;
	for(check_frame = 0; check_frame < hit_frame; check_frame += half_tempo_frame){
		min_frame = check_frame;
		hit_beat++;
	}
	big_frame = check_frame;
	
	//ľܓĐ
	min_frame = (min_frame + ONE_TEMPO_CALC_DECIMAL / 2) / ONE_TEMPO_CALC_DECIMAL;
	big_frame = (big_frame + ONE_TEMPO_CALC_DECIMAL / 2) / ONE_TEMPO_CALC_DECIMAL;
	hit_frame /= ONE_TEMPO_CALC_DECIMAL;
	
	//̏ȂvZ̑ΏۂƂ
	calc_frame = hit_frame;	//u32̂܂܌vZƃ}CiXȂ̂s64Ɉڂ
	min_lag = MATH_IAbs(calc_frame - min_frame);
	big_lag = MATH_IAbs(calc_frame - big_frame);
	if(min_lag <= big_lag){
		lag = min_lag;
		hit_beat--;
	}
	else{
		lag = big_lag;
	}
	
	*ret_lag = lag;
	*ret_beat = hit_beat;

	OS_TPrintf("min_lag = %d, big_lag = %d, min_frame = %d, big_frame = %d, hit_frame = %d, hit_beat = %d\n", min_lag, big_lag, min_frame, big_frame, hit_frame, hit_beat);
}

//--------------------------------------------------------------
/**
 * @brief   _T[_Xs̃ANVp[^Zbg
 *
 * @param   breeder_no		̃u[_[ԍ
 * @param   reaction		s_X(DANCE_TP_???)
 * @param   frame			_Xst[
 * @param   one_tempo_frame	1߂ɂt[
 * @param   dld				rf[^ւ̃|C^
 * @param   param			ANVp[^ւ̃|C^
 * @param   maindancer_record	_XĂ̂C_T[̏ꍇNULLw
 *                              obN_T[̏ꍇ̓C_T[̃_Xւ̃|C^
 * @param   rotation_pos	[e[Vʒu
 */
//--------------------------------------------------------------
static void DancerReactionSet(int breeder_no, int reaction, u32 frame, u32 one_tempo_frame, 
	const DANCE_LAG_DATA *dld, DANCING_PARAM *param, const DANCING_PARAM *maindancer_record,
	int rotation_pos)
{
	int dance_step, i;
	u8 review_type, lag_type;
	u32 lag, hit_beat;
	
	//^b`plʂ_X^Cv擾
	dance_step = DanceTP_to_DanceStep(reaction);
	
	//^b`t[ΏۂƂȂ鏬߂ƁȀߒx̃t[牽t[Ă邩擾
	DancerLagBeatCheck(frame, one_tempo_frame, &lag, &hit_beat);
	OS_TPrintf("Ώۏ=%d, =%dt[\n", hit_beat, lag);
	
	//ꂩ]擾
	DanceLagReviewTypeGet(lag, dld, &review_type, &lag_type);
	if(maindancer_record != NULL){
		//obN_T[̏ꍇAC_T[̃_XƔrs
		for(i = 0; i < DANCING_RECORD_MAX; i++){
			if(maindancer_record[i].occ == TRUE && maindancer_record[i].hit_beat == hit_beat){
				break;	//߂̃C_T[̗ɂ̂ō̂f[^̗p
			}
		}
		if(i == DANCING_RECORD_MAX){
			lag = 0xff;	//qbg߂Ȃ̂łőɂ(FAILED]𓾂)
			OS_TPrintf("C_T[ƃqbgȂ̂łő\n");
		}
	}
	
	//p[^Zbg
	param->breeder_no = breeder_no;
	param->frame = frame;
	param->dance_step = dance_step;
	param->review_type = review_type;
	param->lag_type = lag_type;
	param->hit_beat = hit_beat;
	param->rotation_pos = rotation_pos;
	param->occ = TRUE;
}

//--------------------------------------------------------------
/**
 * @brief   ԎM(M)FC_X
 *
 * @param   dpw				_XǗ[Nւ̃|C^
 * @param   answer_head		Ԏwb_̃|C^
 * @param   ansdat			Mf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void Answer_Dancing(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *answer_head, CO_ANSDAT *ansdat, int net_id)
{
	DANCE_PROC_WORK *dpw = syswork;
	
	//Ԏ󂯎邾Ȃ̂œɂ鎖Ȃ
	return;
}
#endif	//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//--------------------------------------------------------------
/**
 * @brief   AI쐬
 *
 * @param   breeder_no			AIg̃u[_[ԍ
 * @param   rotation_pos		[e[Vʒu
 * @param   ai_no				AIԍ
 * @param   ai_random_seed		AIvZp̃_̎
 *
 * @retval  AIp[Nւ̃|C^
 *
 * ʐMł̒xlAIAIԍAIp̃_̎킾Ċe[JŌvZ͍s
 */
//--------------------------------------------------------------
static DANCE_AI_WORK * DanceAI_Create(int breeder_no,int rotation_pos,u8 ai_no, u16 ai_random_seed)
{
	DANCE_AI_WORK *aiwork;
	
	aiwork = sys_AllocMemory(HEAPID_DANCE, sizeof(DANCE_AI_WORK));
	MI_CpuClear8(aiwork, sizeof(DANCE_AI_WORK));
	
	aiwork->breeder_no = breeder_no;
	aiwork->rotation_pos = rotation_pos;
	aiwork->ai_no = ai_no;
	aiwork->ai_random_seed = ai_random_seed;
	
	return aiwork;
}

//--------------------------------------------------------------
/**
 * @brief   AI폜
 * @param   aiwork		AI[Nւ̃|C^
 */
//--------------------------------------------------------------
static void DanceAI_Delete(DANCE_AI_WORK *aiwork)
{
	sys_FreeMemoryEz(aiwork);
}

//--------------------------------------------------------------
/**
 * @brief   AIC
 *
 * @param   dpw					_XǗ[Nւ̃|C^
 * @param   aiwork				AI[Nւ̃|C^
 * @param   frame				݂̃t[
 * @param   all_tempo_frame		[^[[[܂œBt[
 * @param   one_tempo_frame		1ߐiނ̂ɕKvȃt[
 *                              (FONE_TEMPO_CALC_DECIMALZAȉ)
 * @param   musicdata			ȃf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void DanceAI_Main(DANCE_PROC_WORK *dpw, DANCE_AI_WORK *aiwork, u32 frame, 
	u32 all_tempo_frame, u32 one_tempo_frame, const DANCE_MUSIC_DATA *musicdata)
{
	DANCING_PARAM dancing_param;
	u32 half_tempo_frame;
	
	half_tempo_frame = one_tempo_frame / 2;		//悤
	
	if((aiwork->rotation_pos == 0 && BACK_DANCER_FRAME_CHECK(frame, all_tempo_frame))
			|| (aiwork->rotation_pos > 0 && MAIN_DANCER_FRAME_CHECK(frame, all_tempo_frame))){
		return;
	}
	
	if(aiwork->touch_count >= musicdata->touch_count){
		return;
	}
	
#if 0
	if(aiwork->rotation_pos == 0){	//C_T[
		u32 check_frame;
		
		if(dpw->consys->sio_flag == TRUE){
			check_frame = one_tempo_frame / ONE_TEMPO_CALC_DECIMAL;
			if(frame % check_frame == 0){
				DancerReactionSet(aiwork->breeder_no, 
					DANCE_TP_JUMP + (contest_rand(dpw->consys) % DANCE_TP_MAX), frame, 
					one_tempo_frame, &musicdata->lag, &dancing_param, NULL, aiwork->rotation_pos);
				DancingParamSendTaskSet(dpw, &dancing_param, TRUE);
				aiwork->touch_count++;
			}
		}
		else{	//ʐM̎͂ƂAIʔׁA_gB
			check_frame = one_tempo_frame / ONE_TEMPO_CALC_DECIMAL;
			if(frame % check_frame == 0 && (contest_rand(dpw->consys) & 1)){
				DancerReactionSet(aiwork->breeder_no, 
					DANCE_TP_JUMP + (contest_rand(dpw->consys) % DANCE_TP_MAX), frame, 
					one_tempo_frame, &musicdata->lag, &dancing_param, NULL, aiwork->rotation_pos);
				DancingParamSendTaskSet(dpw, &dancing_param, TRUE);
				aiwork->touch_count++;
			}
		}
	}
	else{	//obN_T[
		int i;
		
		for(i = 0; i < DANCING_RECORD_MAX; i++){
			if(dpw->maindancer_record[i].occ == FALSE){
				continue;
			}
			if(frame == dpw->maindancer_record[i].frame + all_tempo_frame / 2){
				DancerReactionSet(aiwork->breeder_no, 
					dpw->maindancer_record[i].dance_step - DANCE_STEP_JUMP,
					frame, one_tempo_frame, &musicdata->lag, &dancing_param, 
					dpw->maindancer_record, aiwork->rotation_pos);
				DancingParamSendTaskSet(dpw, &dancing_param, TRUE);
				aiwork->touch_count++;
				break;
			}
		}
	}
#else	//AI_Calcł炩߃_X^C~OvZĂ悤ɂB
		//ł{AIꍇ́AC_T[擾obN_T[_XJn܂
		//EFCgSȂ߁A炩ߌvZĂA
		//ƂƂ͏oȂ(C_X͂ł)
	{
		int i;
		
		for(i = 0; i < DANCING_MAX; i++){
			if(aiwork->hit_frame[i] == 0){
				continue;
			}
			
			if(aiwork->hit_frame[i] == frame){
				if(aiwork->rotation_pos == 0){
					DancerReactionSet(aiwork->breeder_no, 
						DANCE_TP_JUMP + (contest_rand(dpw->consys) % DANCE_TP_MAX), frame, 
						one_tempo_frame, &musicdata->lag, &dancing_param, NULL, 
						aiwork->rotation_pos);
					DancingParamSendTaskSet(dpw, &dancing_param, TRUE);
				}
				else{
					int step_type;
					
					if(dpw->maindancer_record[i].dance_step == DANCE_STEP_NONE){
						step_type = DANCE_TP_JUMP + (contest_rand(dpw->consys) % DANCE_TP_MAX);
					}
					else{
						step_type = dpw->maindancer_record[i].dance_step - DANCE_STEP_JUMP;
					}
					
					DancerReactionSet(aiwork->breeder_no, 
						//dpw->maindancer_record[i].dance_step - DANCE_STEP_JUMP,
						step_type,
						frame, one_tempo_frame, &musicdata->lag, &dancing_param, 
						dpw->maindancer_record, aiwork->rotation_pos);
					DancingParamSendTaskSet(dpw, &dancing_param, TRUE);
				}
				aiwork->touch_count++;
				break;
			}
		}
	}
#endif
}

//--------------------------------------------------------------
/**
 * @brief   AIvZs
 *
 * @param   dpw					_XǗ[Nւ̃|C^
 * @param   aiwork				AI[Nւ̃|C^
 * @param   all_tempo_frame		[^[[[܂œBt[
 * @param   one_tempo_frame		1ߐiނ̂ɕKvȃt[
 *                              (FONE_TEMPO_CALC_DECIMALZAȉ)
 * @param   musicdata			ȃf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void DanceAI_Calc(DANCE_PROC_WORK *dpw, DANCE_AI_WORK *aiwork, 
	u32 all_tempo_frame, u32 one_tempo_frame, const DANCE_MUSIC_DATA *musicdata)
{
	DANCING_PARAM dancing_param;
	u32 half_tempo_frame;
	u32 hit;
	int i;
	
	half_tempo_frame = one_tempo_frame / 2;		//悤
	
	if(aiwork->rotation_pos == 0){	//C_T[
		hit = 1;
		for(i = 0; i < musicdata->touch_count; i++){
			if(gf_rand_local(aiwork->ai_random_seed, &aiwork->ai_random_seed) & 1){
				aiwork->hit_frame[i] = one_tempo_frame * hit;
			}
			else{
				aiwork->hit_frame[i] = one_tempo_frame * (hit + 1);
			}
			aiwork->hit_frame[i] /= ONE_TEMPO_CALC_DECIMAL;
			if(gf_rand_local(aiwork->ai_random_seed, &aiwork->ai_random_seed) & 1){
				aiwork->hit_frame[i] += 
					gf_rand_local(aiwork->ai_random_seed, &aiwork->ai_random_seed) % 6;
			}
			else{
				aiwork->hit_frame[i] -= 
					gf_rand_local(aiwork->ai_random_seed, &aiwork->ai_random_seed) % 6;
			}
			OS_TPrintf("main hit_frame = %d\n", aiwork->hit_frame[i]);
			hit += 2;
		}
	}
	else{
		hit = 1;
		for(i = 0; i < musicdata->touch_count; i++){
			if(gf_rand_local(aiwork->ai_random_seed, &aiwork->ai_random_seed) & 1){
				aiwork->hit_frame[i] = one_tempo_frame * hit + all_tempo_frame / 2;
			}
			else{
				aiwork->hit_frame[i] = one_tempo_frame * (hit + 1) + all_tempo_frame / 2;
			}
			aiwork->hit_frame[i] /= ONE_TEMPO_CALC_DECIMAL;
			aiwork->hit_frame[i] += all_tempo_frame/2;
			if(gf_rand_local(aiwork->ai_random_seed, &aiwork->ai_random_seed) & 1){
				aiwork->hit_frame[i] += 
					gf_rand_local(aiwork->ai_random_seed, &aiwork->ai_random_seed) % 6;
			}
			else{
				aiwork->hit_frame[i] -= 
					gf_rand_local(aiwork->ai_random_seed, &aiwork->ai_random_seed) % 6;
			}
			OS_TPrintf("back hit_frame = %d\n", aiwork->hit_frame[i]);
			hit += 2;
		}
	}
}


//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   ߑM(M)F[e[V
 *
 * @param   dpw			_XǗ[Nւ̃|C^
 * @param   work		Cӂ̃|C^
 *
 * @retval  o^ꂽNGXgrbgԍ
 */
//--------------------------------------------------------------
static int Request_Rotation(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work)
{
	DANCE_PROC_WORK *dpw = syswork;
	int bit_no;
	
	bit_no = CO_REQUEST_TransmitBufferSet(cow, CSELECT_ALL, order_no, 
		work, sizeof(DANCE_ADVANCE_PARAM));
	return bit_no;
}

//--------------------------------------------------------------
/**
 * @brief   ߎM(M)F[e[V
 *
 * @param   dpw			_XǗ[Nւ̃|C^
 * @param   req_head	NGXgwb_̃|C^
 * @param   data		Mf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void Recieve_Rotation(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data)
{
	DANCE_PROC_WORK *dpw = syswork;
	DANCE_ADVANCE_PARAM *dap = data;
	DOLOCAL_ROTATION *rt;
	
	rt = sys_AllocMemory(HEAPID_DANCE, sizeof(DOLOCAL_ROTATION));
	MI_CpuClear8(rt, sizeof(DOLOCAL_ROTATION));

	rt->dpw = dpw;
	rt->req_head = *req_head;
	rt->cow = cow;
	rt->dap = *dap;
	
	TCB_Add(DOTCB_Rotation, rt, TCBPRI_DANCE_ORDERSUB);
}

//--------------------------------------------------------------
/**
 * @brief   |P[e[V
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		DOLOCAL_ROTATION\
 */
//--------------------------------------------------------------
static void DOTCB_Rotation(TCB_PTR tcb, void *work)
{
	DOLOCAL_ROTATION *rt = work;
	int breeder, i;
	
	switch(rt->seq){
	case 0:
		for(i = 0; i < BREEDER_MAX; i++){
			breeder = rt->dap.breeder_rotation[i];
			rt->sub_rb[breeder].pp = rt->dpw->sys.c_game->pp[breeder];
			rt->sub_rb[breeder].ss = rt->dpw->sys.ss[breeder];
			rt->sub_rb[breeder].move_frame = ROTATION_SPEED_NORMAL;
			rt->sub_rb[breeder].now_rotation_pos = i;
			if(i == 0){
				rt->sub_rb[breeder].next_rotation_pos = DANCE_ROTATION_POS_D;
			}
			else{
				rt->sub_rb[breeder].next_rotation_pos = i - 1;
			}
			
			TCB_Add(DOTCB_RotationBreeder, &rt->sub_rb[breeder], TCBPRI_DANCE_ROTATION);
		}

		Snd_BgmPlay(SEQ_CO_IREKAE);
		
		rt->seq++;
		break;
	case 1:
		for(i = 0; i < BREEDER_MAX; i++){
			if(rt->sub_rb[i].end == FALSE){
				break;
			}
		}
		if(i == BREEDER_MAX){
			//Snd_BgmStop(SEQ_CO_IREKAE, 30);
			Snd_BgmFadeOut(0, 30);
			rt->seq++;
		}
		break;
	case 2:
		if(Snd_FadeCheck() == 0){
			rt->seq++;
		}
		break;
	default:
		CO_ANSWER_TransmitBufferSet(rt->cow, &rt->req_head, NULL, 0);

		sys_FreeMemoryEz(rt);
		TCB_Delete(tcb);
		return;
	}
}

//--------------------------------------------------------------
/**
 * @brief   |P[e[VFeu[_[
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		DOLOCAL_ROTATION_BREEDER\
 */
//--------------------------------------------------------------
static void DOTCB_RotationBreeder(TCB_PTR tcb, void *work)
{
	DOLOCAL_ROTATION_BREEDER *rtb = work;
	
	switch(rtb->seq){
	case 0:
		rtb->x = SoftSpriteParaGet(rtb->ss, SS_PARA_POS_X) * 0x100;
		rtb->y = SoftSpriteParaGet(rtb->ss, SS_PARA_POS_Y) * 0x100;
		rtb->z = SoftSpriteParaGet(rtb->ss, SS_PARA_POS_Z) * 0x100;
		{
			int now_x, now_y, now_z, end_x, end_y, end_z;
			
			now_x = DT_RotationPosGetX(rtb->now_rotation_pos) * 0x100;
			now_y = DT_RotationPosGetY(rtb->now_rotation_pos) * 0x100;
			now_z = DT_RotationPosGetZ(rtb->now_rotation_pos) * 0x100;
			end_x = DT_RotationPosGetX(rtb->next_rotation_pos) * 0x100;
			end_y = DT_RotationPosGetY(rtb->next_rotation_pos) * 0x100;
			end_z = DT_RotationPosGetZ(rtb->next_rotation_pos) * 0x100;
			
			rtb->add_x = (end_x - now_x) / rtb->move_frame;
			rtb->add_y = (end_y - now_y) / rtb->move_frame;
			rtb->add_z = (end_z - now_z) / rtb->move_frame;
		}
		
		rtb->seq++;
		break;
	case 1:
		rtb->x += rtb->add_x;
		rtb->y += rtb->add_y;
		rtb->z += rtb->add_z;
		rtb->frame++;
		if(rtb->frame >= rtb->move_frame){
			int height;
			
			height = PokeParaHeightGet(rtb->pp, PARA_FRONT);
			rtb->x = DT_RotationPosGetX(rtb->next_rotation_pos) * 0x100;
			rtb->y = (DT_RotationPosGetY(rtb->next_rotation_pos) + height) * 0x100;
			rtb->z = DT_RotationPosGetZ(rtb->next_rotation_pos) * 0x100;
			rtb->seq++;
		}
		SoftSpriteParaSet(rtb->ss, SS_PARA_POS_X, rtb->x / 0x100);
		SoftSpriteParaSet(rtb->ss, SS_PARA_POS_Y, rtb->y / 0x100);
		SoftSpriteParaSet(rtb->ss, SS_PARA_POS_Z, rtb->z / 0x100);
		DT_PokeAffineUpdateZ(rtb->ss);
		break;
	default:
		rtb->end = TRUE;
		TCB_Delete(tcb);
		return;
	}
}


//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   ߑM(M)F_XJnO
 *
 * @param   dpw			_XǗ[Nւ̃|C^
 * @param   work		Cӂ̃|C^
 *
 * @retval  o^ꂽNGXgrbgԍ
 */
//--------------------------------------------------------------
static int Request_Before(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work)
{
	DANCE_PROC_WORK *dpw = syswork;
	int bit_no;
	
	bit_no = CO_REQUEST_TransmitBufferSet(cow, CSELECT_ALL, order_no, 
		work, sizeof(DANCE_ADVANCE_PARAM));
	return bit_no;
}

//--------------------------------------------------------------
/**
 * @brief   ߎM(M)F_XJnO
 *
 * @param   dpw			_XǗ[Nւ̃|C^
 * @param   req_head	NGXgwb_̃|C^
 * @param   data		Mf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void Recieve_Before(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data)
{
	DANCE_PROC_WORK *dpw = syswork;
	DOLOCAL_BEFORE *db;
	DANCE_ADVANCE_PARAM *dap = data;
	
	db = sys_AllocMemory(HEAPID_DANCE, sizeof(DOLOCAL_BEFORE));
	MI_CpuClear8(db, sizeof(DOLOCAL_BEFORE));
	
	db->dpw = dpw;
	db->req_head = *req_head;
	db->cow = cow;
	db->dap = *dap;
	
	TCB_Add(DOTCB_Before, db, TCBPRI_DANCE_ORDERSUB);
}

//--------------------------------------------------------------
/**
 * @brief   _XJnOɍs
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		DOLOCAL_BEFORE\
 */
//--------------------------------------------------------------
static void DOTCB_Before(TCB_PTR tcb, void *work)
{
	DOLOCAL_BEFORE *db = work;
	int i;
	
	switch(db->seq){
	case 0:
		for(i = 0; i < BREEDER_MAX; i++){
			DT_PokemonDefaultAnimeTaskSet(db->dpw, db->dap.breeder_rotation[i], i);
		}
		db->seq++;
		break;
	default:
		CO_ANSWER_TransmitBufferSet(db->cow, &db->req_head, NULL, 0);

		sys_FreeMemoryEz(db);
		TCB_Delete(tcb);
		return;
	}
}


//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   ߑM(M)F_XI
 *
 * @param   dpw			_XǗ[Nւ̃|C^
 * @param   work		Cӂ̃|C^
 *
 * @retval  o^ꂽNGXgrbgԍ
 */
//--------------------------------------------------------------
static int Request_After(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work)
{
	DANCE_PROC_WORK *dpw = syswork;
	int bit_no;
	
	bit_no = CO_REQUEST_TransmitBufferSet(cow, CSELECT_ALL, order_no, 
		work, sizeof(DANCE_ADVANCE_PARAM));
	return bit_no;
}

//--------------------------------------------------------------
/**
 * @brief   ߎM(M)F_XI
 *
 * @param   dpw			_XǗ[Nւ̃|C^
 * @param   req_head	NGXgwb_̃|C^
 * @param   data		Mf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void Recieve_After(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data)
{
	DANCE_PROC_WORK *dpw = syswork;
	DOLOCAL_AFTER *da;
	DANCE_ADVANCE_PARAM *dap = data;
	
	da = sys_AllocMemory(HEAPID_DANCE, sizeof(DOLOCAL_AFTER));
	MI_CpuClear8(da, sizeof(DOLOCAL_AFTER));
	
	da->dpw = dpw;
	da->req_head = *req_head;
	da->cow = cow;
	da->dap = *dap;
	
	TCB_Add(DOTCB_After, da, TCBPRI_DANCE_ORDERSUB);
}

//--------------------------------------------------------------
/**
 * @brief   _XIɍs
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		DOLOCAL_AFTER\
 */
//--------------------------------------------------------------
static void DOTCB_After(TCB_PTR tcb, void *work)
{
	DOLOCAL_AFTER *da = work;
	int i;
	
	switch(da->seq){
	case 0:
		if(DT_DanceMoveStepNoneAllCheck(da->dpw) == FALSE){
			break;
		}
		
		for(i = 0; i < BREEDER_MAX; i++){
			DT_PokemonDefaultAnimeReq(da->dpw, i, PDA_REQ_AFF_STOP_REQ);
			DT_PokemonDefaultAnimeReq(da->dpw, i, PDA_REQ_MOVE_STOP_REQ);
		}
		da->seq++;
		break;
	case 1:
		{
			int aff_end = 0, move_end = 0;
			
			for(i = 0; i < BREEDER_MAX; i++){
				if(DT_PokemonDefaultAnimeStopCheckAff(da->dpw, i) == TRUE){
					aff_end++;
				}
				if(DT_PokemonDefaultAnimeStopCheckMove(da->dpw, i) == TRUE){
					move_end++;
				}
			}
			if(aff_end >= BREEDER_MAX && move_end >= BREEDER_MAX){
				DT_PokemonDefaultAnimeTaskDelAll(da->dpw);
				da->seq++;
			}
		}
		break;
	default:
		CO_ANSWER_TransmitBufferSet(da->cow, &da->req_head, NULL, 0);

		sys_FreeMemoryEz(da);
		TCB_Delete(tcb);
		return;
	}
}

//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   ߑM(M)FbbZ[W̕\
 *
 * @param   dpw			_XǗ[Nւ̃|C^
 * @param   work		Cӂ̃|C^
 *
 * @retval  o^ꂽNGXgrbgԍ
 */
//--------------------------------------------------------------
static int Request_Talk(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work)
{
	DANCE_PROC_WORK *dpw = syswork;
	int bit_no;
	
	bit_no = CO_REQUEST_TransmitBufferSet(cow, CSELECT_ALL, order_no, 
		work, sizeof(DANCE_ADVANCE_PARAM));
	return bit_no;
}

//--------------------------------------------------------------
/**
 * @brief   ߎM(M)FbbZ[W̕\
 *
 * @param   dpw			_XǗ[Nւ̃|C^
 * @param   req_head	NGXgwb_̃|C^
 * @param   data		Mf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void Recieve_Talk(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data)
{
	DANCE_PROC_WORK *dpw = syswork;
	DANCE_ADVANCE_PARAM *dap = data;
	DOLOCAL_TALK_PUT *talk;
	
	talk = sys_AllocMemory(HEAPID_DANCE, sizeof(DOLOCAL_TALK_PUT));
	MI_CpuClear8(talk, sizeof(DOLOCAL_TALK_PUT));
	
	talk->dpw = dpw;
	talk->req_head = *req_head;
	talk->cow = cow;
	talk->breeder_no = dap->now_breeder;
	
	talk->a_talk_tagpara = dap->a_talk_tagpara;
	talk->a_talk_id = dap->a_talk_id;
	talk->a_talk_bmpwin_not_close = dap->a_talk_bmpwin_not_close;
	talk->a_talk_bmpwin_close_wait = dap->a_talk_bmpwin_close_wait;
	
	TCB_Add(DOTCB_TalkPut, talk, TCBPRI_DANCE_ORDERSUB);
}

//--------------------------------------------------------------
/**
 * @brief   bbZ[W̕\
 * @param   tcb			TCBւ̃|C^
 * @param   work		DOLOCAL_TALK_PUT\
 */
//--------------------------------------------------------------
static void DOTCB_TalkPut(TCB_PTR tcb, void *work)
{
	DOLOCAL_TALK_PUT *talk = work;
	
	switch(talk->seq){
	case 0:
		if(talk->a_talk_id != A_TALK_DANCE_NULL){
			BmpTalkWinWrite(&talk->dpw->sys.win[DANCE_BMPWIN_TALK], WINDOW_TRANS_OFF,
				DANCE_TALKWIN_CGX_OFFSET, DANCE_TALKWIN_PALNO);
			GF_BGL_LoadScreenV_Req(talk->dpw->sys.bgl, DANCE_FRAME_WIN);

			DT_A_TalkMessageSet(talk->dpw, talk->a_talk_id, &talk->a_talk_tagpara);
			talk->seq++;
		}
		else{
			talk->seq = 100;
		}
		break;
	case 1:
		if(DT_TalkMessageEndCheck(talk->dpw) == 0){
			talk->seq++;
		}
		break;
	case 2:
		talk->close_wait++;
		if(talk->a_talk_bmpwin_not_close == TRUE){
			talk->seq++;
		}
		else if(talk->close_wait >= talk->a_talk_bmpwin_close_wait){
			BmpTalkWinClear(&talk->dpw->sys.win[DANCE_BMPWIN_TALK], WINDOW_TRANS_OFF);
			GF_BGL_LoadScreenV_Req(talk->dpw->sys.bgl, DANCE_FRAME_WIN);
			talk->seq++;
		}
		break;
	default:
		CO_ANSWER_TransmitBufferSet(talk->cow, &talk->req_head, NULL, 0);

		sys_FreeMemoryEz(talk);
		TCB_Delete(tcb);
		return;
	}
}

