//==============================================================================
/**
 * @file	dance_tool.c
 * @brief	_Xc[
 * @author	matsuda
 * @date	2005.12.10(y)
 */
//==============================================================================
#include "common.h"
#include "contest/contest.h"
#include "battle/battle_common.h"
#include "system/clact_tool.h"
#include "system/palanm.h"

#include "system/arc_tool.h"
#include "system/arc_util.h"

#include "system/softsprite.h"

#include "system/fontproc.h"
#include "system/msgdata.h"

#include "system/brightness.h"

#include "graphic/contest_bg_def.h"
#include "graphic/contest_obj_def.h"

#include "msgdata/msg.naix"

#include "dance.h"
#include "dance_tool.h"
#include "con_tool.h"
#include "dance_id.h"
#include "dance_tcb_pri.h"

#include "system/msgdata_util.h"
#include "system/wordset.h"
#include "msgdata/msg_cmsg_dance.h"
#include "system/fontoam.h"

#include "adv_tool.h"


//==============================================================================
//	萔`
//==============================================================================
///]pl̏̃tHgOAM̃J[ݒ
#define REVIEW_PRINTCOLOR	(GF_PRINTCOLOR_MAKE(0xb, 0xc, 0))

//--------------------------------------------------------------
//	_XAjړf[^
//--------------------------------------------------------------
///_XAjFobN_T[̏ꍇ͈ړʂ␳BC_T[̉%ɐ邩
///100ƃC_T[Ɠ
#define MOVE_BACKDANCER_REVISION		(50)

///_XAjAWvFWv
#define MOVE_JUMP_UP_POWER		(0x0400)
///_XAjAWvFd
#define MOVE_JUMP_GRAVITY		(0x0080)

///_XAjAOiFs̈ړɂt[
#define MOVE_ADVANCE_GO_FRAME		(5)
///_XAjAOiFÄړɂt[
#define MOVE_ADVANCE_BACK_FRAME		(7)
///_XAjAOiFOɈړhbg
#define MOVE_ADVANCE_Y_LEN			(24)
///_XAjAOiF1t[ɑލsXړ(16rbg)
#define MOVE_ADVANCE_ADD_GO_Y		(MOVE_ADVANCE_Y_LEN * 0x0100 / MOVE_ADVANCE_GO_FRAME)
///_XAjAOiF1t[ɑދAXړ(16rbg)
#define MOVE_ADVANCE_ADD_BACK_Y		(MOVE_ADVANCE_Y_LEN * 0x0100 / MOVE_ADVANCE_BACK_FRAME)

///_XAjAEړFs̈ړɂt[
#define MOVE_LR_GO_FRAME		(5)
///_XAjAEړFÄړɂt[
#define MOVE_LR_BACK_FRAME		(7)
///_XAjAEړFEɈړhbg
#define MOVE_LR_X_LEN			(24)
///_XAjAEړFyWv鎞̏㏸(ő㏸̃hbg)
#define MOVE_LR_FURIHABA_Y		(8)
///_XAjAEړF1t[ɑފpx
#define MOVE_LR_ADD_THETA		((180 << FX32_SHIFT) / MOVE_LR_GO_FRAME)
///_XAjAEړF1t[ɑލsXړ(16rbg)
#define MOVE_LR_ADD_GO_X		(MOVE_LR_X_LEN * 0x0100 / MOVE_LR_GO_FRAME)
///_XAjAEړF1t[ɑދAXړ(16rbg)
#define MOVE_LR_ADD_BACK_X		(MOVE_LR_X_LEN * 0x0100 / MOVE_LR_BACK_FRAME)

//--------------------------------------------------------------
//	|P풓Aj
//--------------------------------------------------------------
///|P풓AjFgkZl
#define PDA_AFF_ADD_Z		(0x0400)
///|P풓AjFgkJԂ(̐ADDt֐i)
#define PDA_AFF_ADD_LOOP	(8)
///|P풓AjFWړASinZl(8rbg)(C_T[)
#define PDA_MOVE_ADD_SIN_MAIN		(10 << 8)
///|P풓AjFWړASinZl(8rbg)(obN_T[)
#define PDA_MOVE_ADD_SIN_BACK		(6 << 8)
///|P풓AjFWړAӂ蕝X(C_T[)
#define PDA_MOVE_FURIHABA_X_MAIN	(3)
///|P풓AjFWړAӂ蕝X(obN_T[)
#define PDA_MOVE_FURIHABA_X_BACK	(2)


//==============================================================================
//	vg^Cv錾
//==============================================================================
static void ReviewPanelTaskMain(TCB_PTR tcb, void *work);
static void MyCursorTaskMain(TCB_PTR tcb, void *work);
static void DT_DanceMoveReq(DANCE_PROC_WORK *dpw, int breeder_no, int rotation_pos, 
	int dance_step);
static void DT_DanceMove(TCB_PTR tcb, void *work);
static BOOL Move_Jump(MOVE_EFF_WORK *eff, SOFT_SPRITE *ss, int rotation_pos);
static BOOL Move_Advance(MOVE_EFF_WORK *eff, SOFT_SPRITE *ss, int rotation_pos);
static BOOL Move_Left(MOVE_EFF_WORK *eff, SOFT_SPRITE *ss, int rotation_pos);
static BOOL Move_Right(MOVE_EFF_WORK *eff, SOFT_SPRITE *ss, int rotation_pos);
void DT_PokemonDefaultAnimeTaskDelAll(DANCE_PROC_WORK *dpw);
void DT_PokemonDefaultAnimeReq(DANCE_PROC_WORK *dpw, int breeder_no, PDA_REQ req);
int DT_PokemonDefaultAnimeStopCheckAff(DANCE_PROC_WORK *dpw, int breeder_no);
int DT_PokemonDefaultAnimeStopCheckMove(DANCE_PROC_WORK *dpw, int breeder_no);
static void PokemonDefaultAnime(TCB_PTR tcb, void *work);
static void PokemonDefaultAnime_Affine(POKE_DEF_ANM_WORK *pda);
static void PokemonDefaultAnime_Move(POKE_DEF_ANM_WORK *pda);


//==============================================================================
//	f[^
//==============================================================================
///|P\W
ALIGN4 static const s16 DancePokePos[BREEDER_MAX][3] = {	//X, Y, Z
	{128, 110, DANCE_POKEPOS_Z_MAIN},
	{48, 40, DANCE_POKEPOS_Z_SUB},
	{128, 40, DANCE_POKEPOS_Z_SUB},
	{256-48, 40, DANCE_POKEPOS_Z_SUB},
};

///]pl\W
ALIGN4 static const s16 ReviewPanelPos[BREEDER_MAX][2] = {	//X, Y
	{128, 110},
	{48, 32},
	{128, 32},
	{256-48, 32},
};

///̕\WY(u[_[[e[V̈ʒu)
ALIGN4 static const u8 OnpuPosY[] = {
	0x16*8, 0x15*8, 0x16*8, 0x17*8,
};

//--------------------------------------------------------------
//	AN^[wb_
//--------------------------------------------------------------
///Ȑiso[(8x8)̃AN^[wb_
static const TCATS_OBJECT_ADD_PARAM_S MusicBar8ObjParam = {
	0, 0, 0,		//x, y, z
	0, DANCE_SOFTPRI_MUSIC_BAR, PALOFS_MUSIC_BAR,	//AjԍAD揇ʁApbgԍ
	NNS_G2D_VRAM_TYPE_2DMAIN,		//`GA
	{	//gp\[XIDe[u
		D_CHARID_MUSIC_BAR8,	//L
		D_PLTTID_OBJ_COMMON,	//pbg
		D_CELLID_MUSIC_BAR8,	//Z
		D_CELLANMID_MUSIC_BAR8,	//ZAj
		CLACT_U_HEADER_DATA_NONE,		//}`Z
		CLACT_U_HEADER_DATA_NONE,		//}`ZAj
	},
	DANCE_BGPRI_MUSIC_BAR,			//BGvCIeB
	0,			//Vram]tO
};

///̃AN^[wb_
static const TCATS_OBJECT_ADD_PARAM_S OnpuObjParam = {
	0, 0, 0,		//x, y, z
	0, DANCE_SOFTPRI_ONPU, PALOFS_ONPU,	//AjԍAD揇ʁApbgԍ
	NNS_G2D_VRAM_TYPE_2DMAIN,		//`GA
	{	//gp\[XIDe[u
		D_CHARID_ONPU,	//L
		D_PLTTID_OBJ_COMMON,	//pbg
		D_CELLID_ONPU,	//Z
		D_CELLANMID_ONPU,	//ZAj
		CLACT_U_HEADER_DATA_NONE,		//}`Z
		CLACT_U_HEADER_DATA_NONE,		//}`ZAj
	},
	DANCE_BGPRI_ONPU,			//BGvCIeB
	0,			//Vram]tO
};

///]pl̃AN^[wb_
static const TCATS_OBJECT_ADD_PARAM_S ReviewPanelObjParam = {
	0, 0, 0,		//x, y, z
	0, DANCE_SOFTPRI_REVIEW, PALOFS_REVIEW,	//AjԍAD揇ʁApbgԍ
	NNS_G2D_VRAM_TYPE_2DMAIN,		//`GA
	{	//gp\[XIDe[u
		D_CHARID_REVIEW,	//L
		D_PLTTID_OBJ_COMMON,	//pbg
		D_CELLID_REVIEW,	//Z
		D_CELLANMID_REVIEW,	//ZAj
		CLACT_U_HEADER_DATA_NONE,		//}`Z
		CLACT_U_HEADER_DATA_NONE,		//}`ZAj
	},
	DANCE_BGPRI_REVIEW,			//BGvCIeB
	0,			//Vram]tO
};

///J[\̃AN^[wb_
static const TCATS_OBJECT_ADD_PARAM_S MyCursorObjParam = {
	0, 0, 0,		//x, y, z
	0, DANCE_SOFTPRI_MY_CURSOR, PALOFS_MY_CURSOR,	//AjԍAD揇ʁApbgԍ
	NNS_G2D_VRAM_TYPE_2DMAIN,		//`GA
	{	//gp\[XIDe[u
		D_CHARID_MY_CURSOR,	//L
		D_PLTTID_OBJ_COMMON,	//pbg
		D_CELLID_MY_CURSOR,	//Z
		D_CELLANMID_MY_CURSOR,	//ZAj
		CLACT_U_HEADER_DATA_NONE,		//}`Z
		CLACT_U_HEADER_DATA_NONE,		//}`ZAj
	},
	DANCE_BGPRI_MY_CURSOR,			//BGvCIeB
	0,			//Vram]tO
};

//--------------------------------------------------------------
//	
//--------------------------------------------------------------
///ʂ̐Ff[^
ALIGN4 static const u16 FumenColor[][2] = {
	{0x463f, 0x2958},		//FUMENCOLOR_MAIN
	{0x67f8, 0x2b49},		//FUMENCOLOR_BACK
	{0x7fff, 0x6739},		//FUMENCOLOR_NULL
};


//--------------------------------------------------------------
//	
//--------------------------------------------------------------
///_Xm[}bbZ[Wf[^	A_TALK_DANCE_???̒`ƕт𓯂ɂĂII
static const DANCE_MESSAGE_PARAM DanceTalkMsgData[] = {
	{0,									DTAG_NONE},	//_~[
	{msg_con_dance_begin_host_01,		DTAG_RANK_NUM_OYA_NICK},
	{msg_con_dance_end_host_01,			DTAG_NONE},
};




//--------------------------------------------------------------
/**
 * @brief   [e[Vʒu̍WX擾
 * @param   rotation_pos		[e[Vʒu(DANCE_ROTATION_POS_???)
 * @retval  WX
 */
//--------------------------------------------------------------
s16 DT_RotationPosGetX(int rotation_pos)
{
	return DancePokePos[rotation_pos][0];
}

//--------------------------------------------------------------
/**
 * @brief   [e[Vʒu̍WY擾
 * @param   rotation_pos		[e[Vʒu(DANCE_ROTATION_POS_???)
 * @retval  WY
 */
//--------------------------------------------------------------
s16 DT_RotationPosGetY(int rotation_pos)
{
	return DancePokePos[rotation_pos][1];
}

//--------------------------------------------------------------
/**
 * @brief   [e[Vʒu̍WZ擾
 * @param   rotation_pos		[e[Vʒu(DANCE_ROTATION_POS_???)
 * @retval  WY
 */
//--------------------------------------------------------------
s16 DT_RotationPosGetZ(int rotation_pos)
{
	return DancePokePos[rotation_pos][2];
}


//--------------------------------------------------------------
/**
 * @brief   SẴu[_[̃\tgEFAXvCg(|P)𐶐
 *
 * @param   dpw		_XǗ[Nւ̃|C^
 */
//--------------------------------------------------------------
void DT_SoftSpriteAddAll(DANCE_PROC_WORK *dpw)
{
	int i;
	
	for(i = 0; i < BREEDER_MAX; i++){
		GF_ASSERT(dpw->sys.exchr_param[i].exchr_buffer == NULL);
		dpw->sys.exchr_param[i].exchr_buffer = sys_AllocMemory(HEAPID_DANCE, EXCHR_BUFFER_SIZE);
	}
	
	//WZbg(u[_[[e[VɃZbgĂ̂ŕKSĂssĂ鎖)
	for(i = 0; i < BREEDER_MAX; i++){
		dpw->sys.ss[dpw->d_game.breeder_rotation[i]] = 
			ConTool_BreederPokemonAdd(dpw->sys.soft_sprite, i, dpw->sys.c_game->pp[i], 
			PARA_FRONT, &dpw->sys.exchr_param[i], HEAPID_DANCE, 
			DancePokePos[i][0], DancePokePos[i][1], DancePokePos[i][2]);
	}
}

//--------------------------------------------------------------
/**
 * @brief   SẴu[_[̃\tgEFAXvCg(|P)폜
 * @param   sys		_XVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
void DT_SoftSpriteDelAll(DANCE_SYSTEM_PARAM *sys)
{
	int i;
	
	for(i = 0; i < BREEDER_MAX; i++){
		SoftSpriteDel(sys->ss[i]);
		sys_FreeMemoryEz(sys->exchr_param[i].exchr_buffer);
		sys->exchr_param[i].exchr_buffer = NULL;
	}
}

//--------------------------------------------------------------
/**
 * @brief   ϋqn[g̃\[X[h
 *
 * @param   csp
 * @param   crp
 */
//--------------------------------------------------------------
void DT_HeartResourceLoad(CATS_SYS_PTR csp, CATS_RES_PTR crp)
{
#if 0
	//pbg͏풓pbggp̂Ń[hȂ
	CATS_LoadResourceCharArc(csp, crp, ARC_CONTEST_OBJ, 
		HEART8_NCGR_BIN, 1, 
		NNS_G2D_VRAM_TYPE_2DMAIN, CHARID_APPEAL_POINT);
	CATS_LoadResourceCellArc(csp, crp, ARC_CONTEST_OBJ, 
		HEART8_NCER_BIN, 1, 
		CELLID_APPEAL_POINT);
	CATS_LoadResourceCellAnmArc(csp, crp, ARC_CONTEST_OBJ, 
		HEART8_NANR_BIN, 1, CELLANMID_APPEAL_POINT);
#endif
}

//--------------------------------------------------------------
/**
 * @brief   ϋqn[g̃\[X
 *
 * @param   crp		
 */
//--------------------------------------------------------------
void DT_HeartResourceFree(CATS_RES_PTR crp)
{
#if 0
	//pbg͏풓pbgȂ̂ō폜Ȃ
	CATS_FreeResourceChar(crp, CHARID_APPEAL_POINT);
	CATS_FreeResourceCell(crp, CELLID_APPEAL_POINT);
	CATS_FreeResourceCellAnm(crp, CELLANMID_APPEAL_POINT);
#endif
}



//--------------------------------------------------------------
/**
 * @brief   Ȑiso[AN^[̃AjXV
 *
 * @param   sys		_XVXe[Nւ̃|C^
 * @param   len		o[̒(hbgP)
 */
//--------------------------------------------------------------
void DT_MusicBarAnimeUpdate(DANCE_SYSTEM_PARAM *sys, int len)
{
	int i, full, amari;

	if(len > MUSIC_BAR_LEN){
		len = MUSIC_BAR_LEN;
	}
	
	full = len / MUSIC_BAR_ONE_LEN;
	amari = len % MUSIC_BAR_ONE_LEN;
	
	{
		u16 *scrn_buf;
		
		scrn_buf = GF_BGL_ScreenAdrsGet(sys->bgl, DANCE_FRAME_BACKGROUND);
		scrn_buf = &scrn_buf[32 * 0x13];
		
		//SĖ܂ĂQ[W`
		for(i = 0; i < full; i++){
			scrn_buf[i] = 
				(i & 1) ? MUSIC_BAR_SECOND_SCRN_CODE_FULL : MUSIC_BAR_FAST_SCRN_CODE_FULL;
		}
		//Q[W̐ۂ`
		if(i < MUSIC_BAR_NUM){
			scrn_buf[i] = 
				((i & 1) ? MUSIC_BAR_SECOND_SCRN_CODE_BASE : MUSIC_BAR_FAST_SCRN_CODE_BASE)
				+ amari;
			i++;
		}
		//c̋
		for( ; i < MUSIC_BAR_NUM; i++){
			scrn_buf[i] = 
				(i & 1) ? MUSIC_BAR_SECOND_SCRN_CODE_BASE : MUSIC_BAR_FAST_SCRN_CODE_BASE;
		}
		
		GF_BGL_LoadScreenV_Req(sys->bgl, DANCE_FRAME_BACKGROUND);
	}
}

//--------------------------------------------------------------
/**
 * @brief   Ȑiso[AN^[̃AjXV(o߃t[ƏIt[vZ)
 *
 * @param   sys				_XVXe[Nւ̃|C^
 * @param   now_frame		݂̃t[
 * @param   end_frame		ŏIt[
 */
//--------------------------------------------------------------
void DT_MusicBarAnimeUpdateFrame(DANCE_SYSTEM_PARAM *sys, int now_frame, int end_frame)
{
	int len;
	
	len = now_frame * MUSIC_BAR_LEN / end_frame;
	DT_MusicBarAnimeUpdate(sys, len);
}

//--------------------------------------------------------------
/**
 * @brief   ̃\[XZbg
 *
 * @param   csp		
 * @param   crp		
 */
//--------------------------------------------------------------
void DT_OnpuResourceLoad(CATS_SYS_PTR csp, CATS_RES_PTR crp)
{
	//pbg͏풓pbggp̂Ń[hȂ

	CATS_LoadResourceCharArc(csp, crp, ARC_CONTEST_OBJ, 
		ONPU_NCGR_BIN, 1, 
		NNS_G2D_VRAM_TYPE_2DMAIN, D_CHARID_ONPU);
	CATS_LoadResourceCellArc(csp, crp, ARC_CONTEST_OBJ, 
		ONPU_NCER_BIN, 1, 
		D_CELLID_ONPU);
	CATS_LoadResourceCellAnmArc(csp, crp, ARC_CONTEST_OBJ, 
		ONPU_NANR_BIN, 1, D_CELLANMID_ONPU);
}

//--------------------------------------------------------------
/**
 * @brief   ̃\[X
 *
 * @param   crp		
 */
//--------------------------------------------------------------
void DT_OnpuResourceFree(CATS_RES_PTR crp)
{
	//pbg͏풓pbgȂ̂ō폜Ȃ
	CATS_FreeResourceChar(crp, D_CHARID_ONPU);
	CATS_FreeResourceCell(crp, D_CELLID_ONPU);
	CATS_FreeResourceCellAnm(crp, D_CELLANMID_ONPU);
}

//--------------------------------------------------------------
/**
 * @brief   AN^[𐶐
 *
 * @param   sys				_XVXe[Nւ̃|C^
 * @param   csp		
 * @param   crp		
 * @param   mine_enemy		TRUE:̉B@FALSE:ȊỎ
 * @param   x				\WX
 * @param   y				\WY
 *
 * @retval  ZbgAN^[z̓Yӏ
 */
//--------------------------------------------------------------
static int DT_OnpuActorSet(DANCE_SYSTEM_PARAM *sys, CATS_SYS_PTR csp, CATS_RES_PTR crp, 
	int mine_enemy, int x, int y)
{
	CATS_ACT_PTR onpu_cap;
	int i;
	
	onpu_cap = CATS_ObjectAdd_S(csp, crp, &OnpuObjParam);
	if(mine_enemy == FALSE){
		CATS_ObjectAnimeSeqSetCap(onpu_cap, 1);
	}
	CATS_ObjectUpdate(onpu_cap->act);
	CATS_ObjectPosSetCap(onpu_cap, x, y);
	
	//󂢂ĂꏊɃ|C^Zbg
	for(i = 0; i < ONPU_ACTOR_MAX; i++){
		if(sys->onpu_cap[i] == NULL){
			sys->onpu_cap[i] = onpu_cap;
			return i;
		}
	}
	GF_ASSERT(0 && "AN^[Zbgz񃏁[Nɋ󂫂܂I\n");
	return 0;
}

//--------------------------------------------------------------
/**
 * @brief   AN^[Sč폜
 *
 * @param   sys		_XVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
void DT_OnpuActorDelAll(DANCE_SYSTEM_PARAM *sys)
{
	int i;
	
	for(i = 0; i < ONPU_ACTOR_MAX; i++){
		if(sys->onpu_cap[i] != NULL){
			CATS_ActorPointerDelete_S(sys->onpu_cap[i]);
			sys->onpu_cap[i] = NULL;
		}
	}
}

//--------------------------------------------------------------
/**
 * @brief   ]pl̃\[XZbg
 *
 * @param   csp		
 * @param   crp		
 */
//--------------------------------------------------------------
void DT_ReviewPanelResourceLoad(CATS_SYS_PTR csp, CATS_RES_PTR crp)
{
	//pbg͏풓pbggp̂Ń[hȂ

	CATS_LoadResourceCharArc(csp, crp, ARC_CONTEST_OBJ, 
		WIN_EXCELLENT_NCGR_BIN, 1, 
		NNS_G2D_VRAM_TYPE_2DMAIN, D_CHARID_REVIEW);
	CATS_LoadResourceCellArc(csp, crp, ARC_CONTEST_OBJ, 
		WIN_EXCELLENT_NCER_BIN, 1, 
		D_CELLID_REVIEW);
	CATS_LoadResourceCellAnmArc(csp, crp, ARC_CONTEST_OBJ, 
		WIN_EXCELLENT_NANR_BIN, 1, D_CELLANMID_REVIEW);
}

//--------------------------------------------------------------
/**
 * @brief   ]pl̃\[X
 *
 * @param   crp		
 */
//--------------------------------------------------------------
void DT_ReviewPanelResourceFree(CATS_RES_PTR crp)
{
	//pbg͏풓pbgȂ̂ō폜Ȃ
	CATS_FreeResourceChar(crp, D_CHARID_REVIEW);
	CATS_FreeResourceCell(crp, D_CELLID_REVIEW);
	CATS_FreeResourceCellAnm(crp, D_CELLANMID_REVIEW);
}

//--------------------------------------------------------------
/**
 * @brief   ]plAN^[𐶐
 *
 * @param   sys				_XVXe[Nւ̃|C^
 * @param   csp		
 * @param   crp		
 * @param   review_type		r[^Cv(REVIEW_TYPE_???)
 * @param   breeder_no		u[_[ԍ
 * @param   breeder_rotation	݂̃u[_[[e[Vւ̃|C^
 *
 * @retval  Zbg]plAN^[z̓Yӏ
 */
//--------------------------------------------------------------
void DT_ReviewPanelActorSetAll(DANCE_SYSTEM_PARAM *sys, CATS_SYS_PTR csp, CATS_RES_PTR crp)
{
	CATS_ACT_PTR review_cap;
	int i;
	
	for(i = 0; i < REVIEW_ACTOR_MAX; i++){
		sys->review_cap[i] = CATS_ObjectAdd_S(csp, crp, &ReviewPanelObjParam);
		CATS_ObjectEnableCap(sys->review_cap[i], CATS_ENABLE_FALSE);
	}
}

//--------------------------------------------------------------
/**
 * @brief   ]plAN^[Sč폜
 *
 * @param   sys		_XVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
void DT_ReviewPanelActorDelAll(DANCE_SYSTEM_PARAM *sys)
{
	int i, breeder;
	
	for(i = 0; i < REVIEW_ACTOR_MAX; i++){
		CATS_ActorPointerDelete_S(sys->review_cap[i]);
		sys->review_cap[i] = NULL;
	}
}

//--------------------------------------------------------------
/**
 * @brief   ]pl̃tHgOAMSĐ
 * @param   sys		_XVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
void DT_ReviewFontOamCreateAll(DANCE_SYSTEM_PARAM *sys)
{
	int i;
	STRBUF *excellent_src, *good_src, *failed_src;

	excellent_src = MSGMAN_AllocString(sys->dance_msg, CDMSG_EXCELLENT);
	good_src = MSGMAN_AllocString(sys->dance_msg, CDMSG_GOOD);
	failed_src = MSGMAN_AllocString(sys->dance_msg, CDMSG_FAILED);
	
	for(i = 0; i < REVIEW_ACTOR_MAX; i++){
		ADV_FontOamCreate(HEAPID_DANCE, sys->bgl, sys->crp, sys->fontoam_sys,
			&sys->fontact[REVIEW_TYPE_EXCELLENT][i],
			excellent_src, FONT_SYSTEM, REVIEW_PRINTCOLOR, 0, D_PLTTID_OBJ_COMMON, 
			0, 0, TRUE, DANCE_BGPRI_REVIEW, DANCE_SOFTPRI_REVIEW_FONT);
		FONTOAM_SetDrawFlag(sys->fontact[REVIEW_TYPE_EXCELLENT][i].fontoam, FALSE);
		
		ADV_FontOamCreate(HEAPID_DANCE, sys->bgl, sys->crp, sys->fontoam_sys,
			&sys->fontact[REVIEW_TYPE_GOOD][i],
			good_src, FONT_SYSTEM, REVIEW_PRINTCOLOR, 0, D_PLTTID_OBJ_COMMON, 
			0, 0, TRUE, DANCE_BGPRI_REVIEW, DANCE_SOFTPRI_REVIEW_FONT);
		FONTOAM_SetDrawFlag(sys->fontact[REVIEW_TYPE_GOOD][i].fontoam, FALSE);

		ADV_FontOamCreate(HEAPID_DANCE, sys->bgl, sys->crp, sys->fontoam_sys,
			&sys->fontact[REVIEW_TYPE_FAILED][i],
			failed_src, FONT_SYSTEM, REVIEW_PRINTCOLOR, 0, D_PLTTID_OBJ_COMMON, 
			0, 0, TRUE, DANCE_BGPRI_REVIEW, DANCE_SOFTPRI_REVIEW_FONT);
		FONTOAM_SetDrawFlag(sys->fontact[REVIEW_TYPE_FAILED][i].fontoam, FALSE);
	}

	STRBUF_Delete(excellent_src);
	STRBUF_Delete(good_src);
	STRBUF_Delete(failed_src);
}

//--------------------------------------------------------------
/**
 * @brief   ]pl̃tHgOAMSč폜
 * @param   sys		_XVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
void DT_ReviewFontOamDeleteAll(DANCE_SYSTEM_PARAM *sys)
{
	int i, s;
	
	for(s = 0; s < REVIEW_TYPE_MAX; s++){
		for(i = 0; i < REVIEW_ACTOR_MAX; i++){
			ADV_FontOamDelete(&sys->fontact[s][i]);
		}
	}
}

//--------------------------------------------------------------
/**
 * @brief   ]plAN^[̃^XN𐶐
 *
 * @param   sys				_XVXe[Nւ̃|C^
 * @param   csp		
 * @param   crp		
 * @param   review_type		r[^Cv(REVIEW_TYPE_???)
 * @param   breeder_no		u[_[ԍ
 * @param   breeder_rotation	u[_[̃[e[Vʒu
 */
//--------------------------------------------------------------
void DT_ReviewPanelTaskSet(DANCE_SYSTEM_PARAM *sys, CATS_SYS_PTR csp, CATS_RES_PTR crp, 
	int review_type, int breeder_no, u8 rotation_pos)
{
	CATS_ACT_PTR review_cap;
	int i, x, y, cap_pos;
	FONTOAM_OBJ_PTR fontoam;
	REVIEW_PANEL_TASK_WORK *rptw;
	
	cap_pos = rotation_pos == 0 ? rotation_pos : (rotation_pos-1);

//	rptw = sys_AllocMemory(HEAPID_DANCE, sizeof(REVIEW_PANEL_TASK_WORK));
	rptw = &sys->rptw[cap_pos];
	if(rptw->tcb != NULL){
		TCB_Delete(rptw->tcb);
		OS_TPrintf("ɐ̃r[plLZĐV蒼܂\n");
	}
	MI_CpuClear8(rptw, sizeof(REVIEW_PANEL_TASK_WORK));
	
	x = ReviewPanelPos[rotation_pos][0];
	y = ReviewPanelPos[rotation_pos][1];
	
	rptw->cap = sys->review_cap[cap_pos];
	CATS_ObjectAnimeSeqSetCap(rptw->cap, review_type);
	CATS_ObjectPosSetCap(rptw->cap, x, y);
	CATS_ObjectUpdate(rptw->cap->act);
	CATS_ObjectEnableCap(rptw->cap, CATS_ENABLE_TRUE);
	
	rptw->fontact = &sys->fontact[review_type][cap_pos];
	ADV_FontOamPosSet(rptw->fontact, x, y, TRUE);
	FONTOAM_SetDrawFlag(rptw->fontact->fontoam, TRUE);
	
//	CATS_ObjectAffineSetCap(rptw->cap, CLACT_AFFINE_NORMAL);
//	CATS_ObjectScaleSetCap(rptw->cap, 0, 0);
	
	rptw->tcb = TCB_Add(ReviewPanelTaskMain, rptw, TCBPRI_DANCE_REVIEWPANEL);
}

//--------------------------------------------------------------
/**
 * @brief   ]plGtFNgC^XN
 * @param   tcb			TCBvCIeB
 * @param   work		REVIEW_PANEL_TASK_WORK\
 */
//--------------------------------------------------------------
static void ReviewPanelTaskMain(TCB_PTR tcb, void *work)
{
	REVIEW_PANEL_TASK_WORK *rptw = work;
	int x, y;
	
	switch(rptw->seq){
	case 0:
		FONTOAM_GetMat(rptw->fontact->fontoam, &x, &y);
		y += REVIEW_PANEL_SPEED_Y;
		FONTOAM_SetMat(rptw->fontact->fontoam, x, y);
		CATS_ObjectPosMoveCap(rptw->cap, 0, REVIEW_PANEL_SPEED_Y);
		
//		CATS_ObjectScaleAddCap(rptw->cap, 0.25, 0.25);
		
		rptw->work++;
		if(rptw->work > 4){
			rptw->work = 0;
//			FONTOAM_SetDrawFlag(rptw->fontact->fontoam, TRUE);
			rptw->seq++;
		}
		break;
	case 1:
		rptw->work++;
		if(rptw->work > 14){
			rptw->seq++;
		}
		break;
	default:
		FONTOAM_SetDrawFlag(rptw->fontact->fontoam, FALSE);
		CATS_ObjectEnableCap(rptw->cap, CATS_ENABLE_FALSE);
		
//		CATS_ObjectAffineSetCap(rptw->cap, CLACT_AFFINE_NONE);

		rptw->tcb = NULL;
		//sys_FreeMemoryEz(work);
		TCB_Delete(tcb);
		return;
	}
}

//--------------------------------------------------------------
/**
 * @brief   ]pl^XNSč폜܂
 * @param   sys		_XVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
void DT_ReviewPanelTaskDelAll(DANCE_SYSTEM_PARAM *sys)
{
	int i;

	for(i = 0; i < REVIEW_ACTOR_MAX; i++){
		if(sys->rptw[i].tcb != NULL){
			TCB_Delete(sys->rptw[i].tcb);
			sys->rptw[i].tcb = NULL;
		}
	}
}

//--------------------------------------------------------------
/**
 * @brief   J[\̃\[XZbg
 *
 * @param   csp		
 * @param   crp		
 */
//--------------------------------------------------------------
void DT_MyCursorResourceLoad(CATS_SYS_PTR csp, CATS_RES_PTR crp)
{
	//pbg͏풓pbggp̂Ń[hȂ

	CATS_LoadResourceCharArc(csp, crp, ARC_CONTEST_OBJ, 
		MY_CURSOR_NCGR_BIN, 1, 
		NNS_G2D_VRAM_TYPE_2DMAIN, D_CHARID_MY_CURSOR);
	CATS_LoadResourceCellArc(csp, crp, ARC_CONTEST_OBJ, 
		MY_CURSOR_NCER_BIN, 1, 
		D_CELLID_MY_CURSOR);
	CATS_LoadResourceCellAnmArc(csp, crp, ARC_CONTEST_OBJ, 
		MY_CURSOR_NANR_BIN, 1, D_CELLANMID_MY_CURSOR);
}

//--------------------------------------------------------------
/**
 * @brief   J[\̃\[X
 *
 * @param   crp		
 */
//--------------------------------------------------------------
void DT_MyCursorResourceFree(CATS_RES_PTR crp)
{
	//pbg͏풓pbgȂ̂ō폜Ȃ
	CATS_FreeResourceChar(crp, D_CHARID_MY_CURSOR);
	CATS_FreeResourceCell(crp, D_CELLID_MY_CURSOR);
	CATS_FreeResourceCellAnm(crp, D_CELLANMID_MY_CURSOR);
}

//--------------------------------------------------------------
/**
 * @brief   J[\AN^[𐶐
 *
 * @param   sys				_XVXe[Nւ̃|C^
 * @param   csp		
 * @param   crp		
 */
//--------------------------------------------------------------
void DT_MyCursorActorSet(DANCE_SYSTEM_PARAM *sys, CATS_SYS_PTR csp, CATS_RES_PTR crp)
{
	CATS_ACT_PTR my_cursor_cap;
	
	my_cursor_cap = CATS_ObjectAdd_S(csp, crp, &MyCursorObjParam);
	CATS_ObjectUpdate(my_cursor_cap->act);
	
	sys->my_cursor_cap = my_cursor_cap;
}

//--------------------------------------------------------------
/**
 * @brief   J[\AN^[폜
 *
 * @param   sys		_XVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
void DT_MyCursorActorDel(DANCE_SYSTEM_PARAM *sys)
{
	int i, breeder;
	
	if(sys->my_cursor_cap != NULL){
		CATS_ActorPointerDelete_S(sys->my_cursor_cap);
		sys->my_cursor_cap = NULL;
	}
}

//--------------------------------------------------------------
/**
 * @brief   J[\AN^[^XN𐶐
 * @param   dpw		_XǗ[Nւ̃|C^
 */
//--------------------------------------------------------------
void DT_MyCursorTaskSet(DANCE_PROC_WORK *dpw)
{
	dpw->sys.my_cursor_tcb = TCB_Add(MyCursorTaskMain, dpw, TCBPRI_DANCE_MY_CURSOR);
}

//--------------------------------------------------------------
/**
 * @brief   J[\AN^[^XN폜
 * @param   dpw		_XǗ[Nւ̃|C^
 */
//--------------------------------------------------------------
void DT_MyCursorTaskDel(DANCE_PROC_WORK *dpw)
{
	TCB_Delete(dpw->sys.my_cursor_tcb);
}

//--------------------------------------------------------------
/**
 * @brief   J[\^XNC
 * @param   tcb			TCBւ̃|C^
 * @param   work		_XǗ[Nւ̃|C^
 */
//--------------------------------------------------------------
static void MyCursorTaskMain(TCB_PTR tcb, void *work)
{
	DANCE_PROC_WORK *dpw = work;
	int x, y, my_breeder_no;
	
	my_breeder_no = dpw->consys->c_game.my_breeder_no;
	x = SoftSpriteParaGet(dpw->sys.ss[my_breeder_no], SS_PARA_POS_X);
	y = SoftSpriteParaGet(dpw->sys.ss[my_breeder_no], SS_PARA_POS_Y);
	
	CATS_ObjectPosSetCap(dpw->sys.my_cursor_cap, x, y - 8*5);
}

//--------------------------------------------------------------
/**
 * @brief   C_T[ʒu̕ʂ̐FAw肵^Cv̐FɕύX
 *
 * @param   sys				_XVXe[Nւ̃|C^
 * @param   color_type		J[^Cv(FUMENCOLOR_???)
 */
//--------------------------------------------------------------
void DT_FumenColorSet(DANCE_SYSTEM_PARAM *sys, FUMENCOLOR_TYPE color_type)
{
//	PaletteWorkSet(sys->pfd, FumenColor[color_type], FADE_MAIN_BG, FUMEN_MAIN_COLOR_POS,
//		FUMEN_MAIN_COLOR_NUM * 2);
}

//--------------------------------------------------------------
/**
 * @brief   ݂ZʒuɃ|P̊gk̐ݒs܂
 *
 * @param   ss				Ώۂ̃|P(\tgEFAXvCg)ւ̃|C^
 */
//--------------------------------------------------------------
void DT_PokeAffineUpdateZ(SOFT_SPRITE *ss)
{
	s32 now_z, set_aff;
	
	now_z = SoftSpriteParaGet(ss, SS_PARA_POS_Z);
	
	if(now_z == DANCE_POKEPOS_Z_SUB){
		set_aff = DANCE_POKEAFF_BACK;
	}
	else if(now_z == DANCE_POKEPOS_Z_MAIN){
		set_aff = DANCE_POKEAFF_MAIN;
	}
	else{
		set_aff = (now_z - DANCE_POKEPOS_Z_SUB) * (DANCE_POKEAFF_MAIN - DANCE_POKEAFF_BACK) 
					/ (DANCE_POKEPOS_Z_MAIN - DANCE_POKEPOS_Z_SUB);
		set_aff += DANCE_POKEAFF_BACK;
	}
	
	SoftSpriteParaSet(ss, SS_PARA_AFF_X, set_aff);
	SoftSpriteParaSet(ss, SS_PARA_AFF_Y, set_aff);
}

//--------------------------------------------------------------
/**
 * @brief   SẴu[_[ɑ΂āA݂ZʒuɃ|P̊gk̐ݒs܂
 *
 * @param   sys				_XVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
void DT_PokeAffineUpdateZAll(DANCE_SYSTEM_PARAM *sys)
{
	int i;
	
	for(i = 0; i < BREEDER_MAX; i++){
		DT_PokeAffineUpdateZ(sys->ss[i]);
	}
}

//--------------------------------------------------------------
/**
 * @brief   nꂽ_Xsp[^K؂Ȉʒuɉ\
 *
 * @param   sys				_XVXe[Nւ̃|C^
 * @param   my_breeder_no	̃u[_[ԍ(_Xsp[^̃u[_[ԍł͂Ȃ)
 * @param   param			_Xsp[^ւ̃|C^
 *
 * @retval  TRUEFB@FALSEFKvȂ
 */
//--------------------------------------------------------------
static BOOL OnpuFrameSet(DANCE_SYSTEM_PARAM *sys, int my_breeder_no, const DANCING_PARAM *param)
{
	int mine_data;
	int x, y, half_beat_x;
	
	mine_data = (param->breeder_no == my_breeder_no) ? TRUE : FALSE;
	
#if 0
	if(mine_data == TRUE){	//̃f[^
		if(param->main_back == DANCER_MAIN){	//C_T[̏ꍇ̃_Xf[^
			x = 256 / DANCE_BEAT * param->hit_beat;
		}
		else{		//obN_T[̏ꍇ̃_Xf[^
			x = (256 / DANCE_BEAT * param->hit_beat) + (256 / 2);
		}
	}
	else{//ȊÕ_Xf[^
		if(param->main_back == DANCER_MAIN){
			x = (256 / DANCE_BEAT * param->hit_beat) - (256 / 2);
		}
		else{
			//ȊÕ_Xf[^ŁAꂪC_T[̃f[^ł͂ȂȂ\̕KvȂ
			return FALSE;
		}
	}
#else
	x = 256 / DANCE_BEAT * param->hit_beat;
#endif
	y = OnpuPosY[param->rotation_pos];
	
	//ɓʒuɉĂȂ`FbN
	{
		s16 check_x, check_y;
		int i;
		
		for(i = 0; i < ONPU_ACTOR_MAX; i++){
			if(sys->onpu_cap[i] != NULL){
				CATS_ObjectPosGetCap(sys->onpu_cap[i], &check_x, &check_y);
				if(check_x == x && check_y == y){
					return FALSE;
				}
			}
		}
	}
	
	DT_OnpuActorSet(sys, sys->csp, sys->crp, mine_data, x, y);
	return TRUE;
}

//--------------------------------------------------------------
/**
 * @brief   _Xsp[^M̏
 *
 * @param   dpw					_XǗ[Nւ̃|C^
 * @param   dancing_param		_Xsp[^ւ̃|C^
 */
//--------------------------------------------------------------
void DT_DancingParamRecieve(DANCE_PROC_WORK *dpw, const DANCING_PARAM *dancing_param)
{
	int i, dancer_breeder, point;
	
	dancer_breeder = dancing_param->breeder_no;

	//Mf[^vZ(T[o[̂ݎs)
	if(dpw->consys->c_game.my_breeder_no == dpw->consys->c_game.server_no){
		//_Z
		switch(dancing_param->lag_type){
		case DANCE_LAG_EXCELLENT_A:
			point = DANCE_POINT_EXCELLENT_A;
			break;
		case DANCE_LAG_EXCELLENT_B:
			point = DANCE_POINT_EXCELLENT_B;
			break;
		case DANCE_LAG_GOOD_A:
			point = DANCE_POINT_GOOD_A;
			break;
		case DANCE_LAG_GOOD_B:
			point = DANCE_POINT_GOOD_B;
			break;
		default:
			point = 0;
			break;
		}
		dpw->d_game.dance_point[dancer_breeder] += point;
		OS_TPrintf("%dԂ̃u[_[%d_lBv=%d\n", dancer_breeder, point, 
			dpw->d_game.dance_point[dancer_breeder]);
	}
	
	//Mf[^vZ(SNCAgs)
	if(dancing_param->rotation_pos == 0){	//C_T[̏ꍇA
		for(i = 0; i < DANCING_RECORD_MAX; i++){
			if(dpw->maindancer_record[i].occ == FALSE){
				dpw->maindancer_record[i] = *dancing_param;
				break;
			}
			else if(dpw->maindancer_record[i].hit_beat == dancing_param->hit_beat){
				OS_TPrintf("߂̃_Xf[^Ȃ̂Ŗ\n");
				break;
			}
		}
		//GF_ASSERT(i < DANCING_RECORD_MAX);	//C_XI[o[
		if(i >= DANCING_RECORD_MAX){
			OS_TPrintf("_Xobt@I[o[̂Ńf[^󂯎܂łIII\n");
		}
	}
	
	//GtFNg(SNCAgs)
	DT_ReviewPanelTaskSet(&dpw->sys, dpw->sys.csp, dpw->sys.crp, dancing_param->review_type,
		dancing_param->breeder_no, dancing_param->rotation_pos);
	//\
	OnpuFrameSet(&dpw->sys, dpw->consys->c_game.my_breeder_no, dancing_param);
	//AjNGXg
	DT_DanceMoveReq(dpw, dancing_param->breeder_no, dancing_param->rotation_pos, 
		dancing_param->dance_step);
	
	//SEĐ
	switch(dancing_param->dance_step){
	case DANCE_STEP_JUMP:
		Snd_SePlay(DSE_STEP_JUMP);
		break;
	case DANCE_STEP_ADVANCE:
		Snd_SePlay(DSE_STEP_ADVANCE);
		break;
	case DANCE_STEP_LEFT:
		Snd_SePlay(DSE_STEP_LEFT);
		break;
	case DANCE_STEP_RIGHT:
		Snd_SePlay(DSE_STEP_RIGHT);
		break;
	}
	//Snd_SePlay(DSE_HANDCLAP);
}

//--------------------------------------------------------------
/**
 * @brief   _XAj[VNGXg
 *
 * @param   dpw				_XǗ[Nւ̃|C^
 * @param   breeder_no		u[_[No
 * @param   rotation_pos	[e[Vʒu
 * @param   dance_step		Xebv^Cv(DANCE_STEP_???)
 */
//--------------------------------------------------------------
static void DT_DanceMoveReq(DANCE_PROC_WORK *dpw, int breeder_no, int rotation_pos, int dance_step)
{
	int i, set_work;
	DANCE_MOVE_WORK *move;
	
	move = &dpw->move[breeder_no];
	set_work = -1;
	for(i = move->work_pos; i < DANCE_STEP_REQUEST_MAX; i++){
		if(move->dance_step[i] == DANCE_STEP_NONE){
			set_work = i;
			break;
		}
	}
	if(set_work == -1){
		for(i = 0; i < move->work_pos; i++){
			if(move->dance_step[i] == DANCE_STEP_NONE){
				set_work = i;
				break;
			}
		}
	}
	
	if(set_work == -1){
		//OS_TPrintf("*****_XAj\obt@ɂςłI\n****");
		GF_ASSERT(0 && "_XAjobt@ɂςłI");
		return;
	}
	
	move->dance_step[set_work] = dance_step;
	move->rotation_pos = rotation_pos;
}

//--------------------------------------------------------------
/**
 * @brief   |P_XGtFNgs^XN𐶐
 * @param   dpw		_XǗ[Nւ̃|C^
 */
//--------------------------------------------------------------
void DT_DanceMoveTaskSet(DANCE_PROC_WORK *dpw)
{
	dpw->move_tcb = TCB_Add(DT_DanceMove, dpw, TCBPRI_DANCE_MOVE);
}

//--------------------------------------------------------------
/**
 * @brief   |P_XGtFNgs^XN폜
 * @param   dpw		_XǗ[Nւ̃|C^
 */
//--------------------------------------------------------------
void DT_DanceMoveTaskDel(DANCE_PROC_WORK *dpw)
{
	TCB_Delete(dpw->move_tcb);
	dpw->move_tcb = NULL;
}

//--------------------------------------------------------------
/**
 * @brief   SẴu[_[̃_XGtFNgIĂ邩mF
 *
 * @param   dpw				_XǗ[Nւ̃|C^
 *
 * @retval  TRUE:S̃_XGtFNgIĂ
 * @retval  FALSE:1Cȏオ܂_X
 */
//--------------------------------------------------------------
BOOL DT_DanceMoveStepNoneAllCheck(DANCE_PROC_WORK *dpw)
{
	DANCE_MOVE_WORK *move;
	int i;
	
	for(i = 0; i < BREEDER_MAX; i++){
		move = &dpw->move[i];
		if(move->dance_step[move->work_pos] != DANCE_STEP_NONE){
			return FALSE;
		}
	}
	return TRUE;
}

//--------------------------------------------------------------
/**
 * @brief   |P_XGtFNgs^XN
 * @param   tcb			TCBւ̃|C^
 * @param   work		_XǗ[Nւ̃|C^
 */
//--------------------------------------------------------------
static void DT_DanceMove(TCB_PTR tcb, void *work)
{
	DANCE_PROC_WORK *dpw = work;
	DANCE_MOVE_WORK *move;
	int dance_step, end, i;
	
	for(i = 0; i < BREEDER_MAX; i++){
		move = &dpw->move[i];
		dance_step = move->dance_step[move->work_pos];
		end = FALSE;
		
		if(dance_step == DANCE_STEP_NONE){
			continue;	//AjNGXgĂȂ̂Ŕ΂
		}
		
		//_XGtFNg͏풓Aj~
		DT_PokemonDefaultAnimeReq(dpw, i, PDA_REQ_MOVE_STOP);
		
		switch(dance_step){
		case DANCE_STEP_JUMP:
			end = Move_Jump(&move->eff, dpw->sys.ss[i], move->rotation_pos);
			break;
		case DANCE_STEP_ADVANCE:
			end = Move_Advance(&move->eff, dpw->sys.ss[i], move->rotation_pos);
			break;
		case DANCE_STEP_LEFT:
			end = Move_Left(&move->eff, dpw->sys.ss[i], move->rotation_pos);
			break;
		case DANCE_STEP_RIGHT:
			end = Move_Right(&move->eff, dpw->sys.ss[i], move->rotation_pos);
			break;
		default:
			GF_ASSERT(0 && "pӂĂȂXebv^Cvł\n");
			break;
		}
		
		//s̃AjIĂÃAjw悤Ƀ[Nʒuړ
		if(end == TRUE){
			move->dance_step[move->work_pos] = DANCE_STEP_NONE;
			move->work_pos++;
			if(move->work_pos >= DANCE_STEP_REQUEST_MAX){
				move->work_pos = 0;
			}
			MI_CpuClear8(&move->eff, sizeof(MOVE_EFF_WORK));
	
			//풓AjĊJ
			DT_PokemonDefaultAnimeReq(dpw, i, PDA_REQ_MOVE_SET);
		}
	}
}

//--------------------------------------------------------------
/**
 * @brief   |P\tgEFAXvCgɈړ̍WZbg
 *          obN_T[̏ꍇ͈ړʕ␳s܂
 *
 * @param   eff				_XAjGtFNg샏[Nւ̃|C^
 * @param   ss				Ώۂ̃|P̃\tgEFAXvCgւ̃|C^
 * @param   rotation_pos	[e[Vʒu
 */
//--------------------------------------------------------------
static inline void Move_PosSet(MOVE_EFF_WORK *eff, SOFT_SPRITE *ss, int rotation_pos)
{
	s32 offset_x, offset_y, set_x, set_y;
	
	if(rotation_pos != 0){
		offset_x = eff->x - eff->start_x;
		offset_y = eff->y - eff->start_y;

		offset_x = offset_x * MOVE_BACKDANCER_REVISION / 100;
		offset_y = offset_y * MOVE_BACKDANCER_REVISION / 100;
		
		set_x = eff->start_x + offset_x;
		set_y = eff->start_y + offset_y;
	}
	else{
		set_x = eff->x;
		set_y = eff->y;
	}
	
	SoftSpriteParaSet(ss, SS_PARA_POS_X, set_x / 0x0100);
	SoftSpriteParaSet(ss, SS_PARA_POS_Y, set_y / 0x0100);
}

//--------------------------------------------------------------
/**
 * @brief   |PFWv
 * @param   eff		_XAjGtFNg샏[Nւ̃|C^
 * @param   ss		Ώۂ̃|P̃\tgEFAXvCgւ̃|C^
 * @retval  TRUE:IB@FALSE:p
 */
//--------------------------------------------------------------
static BOOL Move_Jump(MOVE_EFF_WORK *eff, SOFT_SPRITE *ss, int rotation_pos)
{
	BOOL end = FALSE;
	
	switch(eff->seq){
	case 0:
		eff->start_x = SoftSpriteParaGet(ss, SS_PARA_POS_X) * 0x0100;
		eff->start_y = SoftSpriteParaGet(ss, SS_PARA_POS_Y) * 0x0100;
		eff->x = eff->start_x;
		eff->y = eff->start_y;
		
		eff->jump.up_power = -MOVE_JUMP_UP_POWER;
		eff->seq++;
		//break;
	case 1:
		eff->y += eff->jump.up_power;
		eff->jump.up_power += MOVE_JUMP_GRAVITY;
		if(eff->y >= eff->start_y){
			eff->y = eff->start_y;
			end = TRUE;
			eff->seq++;
		}
		break;
	default:
		return TRUE;
	}
	
	Move_PosSet(eff, ss, rotation_pos);
	return end;
}

//--------------------------------------------------------------
/**
 * @brief   |PFOi
 * @param   eff		_XAjGtFNg샏[Nւ̃|C^
 * @param   ss		Ώۂ̃|P̃\tgEFAXvCgւ̃|C^
 * @retval  TRUE:IB@FALSE:p
 */
//--------------------------------------------------------------
static BOOL Move_Advance(MOVE_EFF_WORK *eff, SOFT_SPRITE *ss, int rotation_pos)
{
	BOOL end = FALSE;
	
	switch(eff->seq){
	case 0:
		eff->start_x = SoftSpriteParaGet(ss, SS_PARA_POS_X) * 0x0100;
		eff->start_y = SoftSpriteParaGet(ss, SS_PARA_POS_Y) * 0x0100;
		eff->x = eff->start_x;
		eff->y = eff->start_y;
		
		eff->seq++;
		//break;
	case 1:
		eff->y += MOVE_ADVANCE_ADD_GO_Y;
		if(eff->y - eff->start_y >= MOVE_ADVANCE_Y_LEN * 0x0100){
			eff->y = eff->start_y + MOVE_ADVANCE_Y_LEN * 0x0100;
			eff->seq++;
		}
		break;
	case 2:
		eff->y -= MOVE_ADVANCE_ADD_BACK_Y;
		if(eff->y <= eff->start_y){
			eff->y = eff->start_y;
			eff->seq++;
			end = TRUE;
		}
		break;
	default:
		return TRUE;
	}

	Move_PosSet(eff, ss, rotation_pos);
	return end;
}

//--------------------------------------------------------------
/**
 * @brief   |PFړ
 * @param   eff		_XAjGtFNg샏[Nւ̃|C^
 * @param   ss		Ώۂ̃|P̃\tgEFAXvCgւ̃|C^
 * @retval  TRUE:IB@FALSE:p
 */
//--------------------------------------------------------------
static BOOL Move_Left(MOVE_EFF_WORK *eff, SOFT_SPRITE *ss, int rotation_pos)
{
	BOOL end = FALSE;
	
	switch(eff->seq){
	case 0:
		eff->start_x = SoftSpriteParaGet(ss, SS_PARA_POS_X) * 0x0100;
		eff->start_y = SoftSpriteParaGet(ss, SS_PARA_POS_Y) * 0x0100;
		eff->x = eff->start_x;
		eff->y = eff->start_y;
		
		eff->seq++;
		//break;
	case 1:
		eff->lr.theta += MOVE_LR_ADD_THETA;
		eff->y = eff->start_y 
			- ((Sin360FX(eff->lr.theta) * MOVE_LR_FURIHABA_Y / FX32_ONE) * 0x0100);

		eff->x -= MOVE_LR_ADD_GO_X;
		if(abs(eff->x - eff->start_x) >= MOVE_LR_X_LEN * 0x0100){
			eff->x = eff->start_x - MOVE_LR_X_LEN * 0x0100;
			eff->y = eff->start_y;
			eff->seq++;
		}
		break;
	case 2:
		eff->x += MOVE_LR_ADD_BACK_X;
		if(eff->x >= eff->start_x){
			eff->x = eff->start_x;
			eff->seq++;
			end = TRUE;
		}
		break;
	default:
		return TRUE;
	}

	Move_PosSet(eff, ss, rotation_pos);
	return end;
}

//--------------------------------------------------------------
/**
 * @brief   |PFEړ
 * @param   eff		_XAjGtFNg샏[Nւ̃|C^
 * @param   ss		Ώۂ̃|P̃\tgEFAXvCgւ̃|C^
 * @retval  TRUE:IB@FALSE:p
 */
//--------------------------------------------------------------
static BOOL Move_Right(MOVE_EFF_WORK *eff, SOFT_SPRITE *ss, int rotation_pos)
{
	BOOL end = FALSE;
	
	switch(eff->seq){
	case 0:
		eff->start_x = SoftSpriteParaGet(ss, SS_PARA_POS_X) * 0x0100;
		eff->start_y = SoftSpriteParaGet(ss, SS_PARA_POS_Y) * 0x0100;
		eff->x = eff->start_x;
		eff->y = eff->start_y;
		
		eff->seq++;
		//break;
	case 1:
		eff->lr.theta += MOVE_LR_ADD_THETA;
		eff->y = eff->start_y 
			- ((Sin360FX(eff->lr.theta) * MOVE_LR_FURIHABA_Y / FX32_ONE) * 0x0100);

		eff->x += MOVE_LR_ADD_GO_X;
		if(abs(eff->x - eff->start_x) >= MOVE_LR_X_LEN * 0x0100){
			eff->x = eff->start_x + MOVE_LR_X_LEN * 0x0100;
			eff->y = eff->start_y;
			eff->seq++;
		}
		break;
	case 2:
		eff->x -= MOVE_LR_ADD_BACK_X;
		if(eff->x <= eff->start_x){
			eff->x = eff->start_x;
			eff->seq++;
			end = TRUE;
		}
		break;
	default:
		return TRUE;
	}

	Move_PosSet(eff, ss, rotation_pos);
	return end;
}

//--------------------------------------------------------------
/**
 * @brief   C_T[
 * @param   dpw		_XǗ[Nւ̃|C^
 */
//--------------------------------------------------------------
void DT_MainDancerRecordInit(DANCE_PROC_WORK *dpw)
{
	int i;
	
	for(i = 0; i < DANCING_RECORD_MAX; i++){
		dpw->maindancer_record[i].occ = FALSE;
	}
}

//--------------------------------------------------------------
/**
 * @brief   |P풓Aj^XN𐶐
 * @param   dpw				_XǗ[Nւ̃|C^
 * @param   breeder_no		u[_[No
 * @param   rotation_pos	[e[Vʒu
 */
//--------------------------------------------------------------
void DT_PokemonDefaultAnimeTaskSet(DANCE_PROC_WORK *dpw, int breeder_no, int rotation_pos)
{
	GF_ASSERT(dpw->pda[breeder_no].tcb == NULL);
	
	MI_CpuClear8(&dpw->pda[breeder_no], sizeof(POKE_DEF_ANM_WORK));
	dpw->pda[breeder_no].breeder_no = breeder_no;
	dpw->pda[breeder_no].rotation_pos = rotation_pos;
	dpw->pda[breeder_no].ss = dpw->sys.ss[breeder_no];
	dpw->pda[breeder_no].tcb = TCB_Add(PokemonDefaultAnime, &dpw->pda[breeder_no], 
		TCBPRI_DANCE_DEFANM);
}

//--------------------------------------------------------------
/**
 * @brief   |P풓Aj^XNSč폜
 * @param   dpw		_XǗ[Nւ̃|C^
 */
//--------------------------------------------------------------
void DT_PokemonDefaultAnimeTaskDelAll(DANCE_PROC_WORK *dpw)
{
	int i;
	
	for(i = 0; i < BREEDER_MAX; i++){
		if(dpw->pda[i].tcb != NULL){
			TCB_Delete(dpw->pda[i].tcb);
			dpw->pda[i].tcb = NULL;
		}
	}
}

//--------------------------------------------------------------
/**
 * @brief   |P풓AjFNGXgݒ
 *
 * @param   dpw				_XǗ[Nւ̃|C^
 * @param   breeder_no		u[_[No
 * @param   req				NGXgԍ(PDA_REQ_???)
 */
//--------------------------------------------------------------
void DT_PokemonDefaultAnimeReq(DANCE_PROC_WORK *dpw, int breeder_no, PDA_REQ req)
{
	if(dpw->pda[breeder_no].tcb == NULL){
		return;
	}
	
	switch(req){
	case PDA_REQ_AFF_SET:
		dpw->pda[breeder_no].aff_stop = 0;
		dpw->pda[breeder_no].aff_stop_req = 0;
		break;
	case PDA_REQ_AFF_STOP:
		dpw->pda[breeder_no].aff_stop = 1;
		break;
	case PDA_REQ_AFF_STOP_REQ:
		dpw->pda[breeder_no].aff_stop_req = 1;
		break;
	case PDA_REQ_MOVE_SET:
		dpw->pda[breeder_no].move_stop = 0;
		dpw->pda[breeder_no].move_stop_req = 0;
		break;
	case PDA_REQ_MOVE_STOP:
		dpw->pda[breeder_no].move_stop = 1;
		break;
	case PDA_REQ_MOVE_STOP_REQ:
		dpw->pda[breeder_no].move_stop_req = 1;
		break;
	default:
		GF_ASSERT(0 && "w胊NGXg͗pӂĂ܂");
		break;
	}
}

//--------------------------------------------------------------
/**
 * @brief   |P풓AjFgkAj~Ԃ`FbN
 * @param   dpw				_XǗ[Nւ̃|C^
 * @param   breeder_no		u[_[No
 * @retval  TRUE:~ԁB@FASE:ғ
 */
//--------------------------------------------------------------
int DT_PokemonDefaultAnimeStopCheckAff(DANCE_PROC_WORK *dpw, int breeder_no)
{
	if(dpw->pda[breeder_no].tcb == NULL){
		return TRUE;
	}
	if(dpw->pda[breeder_no].aff_stop == 1 || dpw->pda[breeder_no].rotation_pos == 0){
		return TRUE;
	}
	return FALSE;
}

//--------------------------------------------------------------
/**
 * @brief   |P풓AjFړAj~Ԃ`FbN
 * @param   dpw				_XǗ[Nւ̃|C^
 * @param   breeder_no		u[_[No
 * @retval  TRUE:~ԁB@FASE:ғ
 */
//--------------------------------------------------------------
int DT_PokemonDefaultAnimeStopCheckMove(DANCE_PROC_WORK *dpw, int breeder_no)
{
	if(dpw->pda[breeder_no].tcb == NULL){
		return TRUE;
	}
	if(dpw->pda[breeder_no].move_stop == 1){
		return TRUE;
	}
	return FALSE;
}


//--------------------------------------------------------------
/**
 * @brief   |P풓AjFs^XN
 * @param   tcb			TCBւ̃|C^
 * @param   work		풓Ajp[N
 */
//--------------------------------------------------------------
static void PokemonDefaultAnime(TCB_PTR tcb, void *work)
{
	POKE_DEF_ANM_WORK *pda = work;
	s32 z;
	
	if(pda->aff_stop == 0 && pda->rotation_pos > 0){
		PokemonDefaultAnime_Affine(pda);
	}
	
	if(pda->move_stop == 0){
		PokemonDefaultAnime_Move(pda);
	}
}

//--------------------------------------------------------------
/**
 * @brief   |P풓AjFgk
 * @param   pda		풓Ajp[Nւ̃|C^
 */
//--------------------------------------------------------------
static void PokemonDefaultAnime_Affine(POKE_DEF_ANM_WORK *pda)
{
	switch(pda->aff_seq){
	case 0:
		pda->aff_z = DANCE_POKEPOS_Z_SUB * 0x100;
		pda->aff_seq++;
		//break;
	case 1:
		if(pda->aff_dir == 0){
			pda->aff_z += PDA_AFF_ADD_Z;
		}
		else{
			pda->aff_z -= PDA_AFF_ADD_Z;
		}
		pda->aff_loop++;
		if(pda->aff_loop >= PDA_AFF_ADD_LOOP){
			pda->aff_loop = 0;
			pda->aff_dir ^= 1;
		}
		break;
	}
	
	if(pda->aff_stop_req == 1){
		if(pda->aff_z == DANCE_POKEPOS_Z_SUB * 0x100){
			pda->aff_stop_req = 0;
			pda->aff_stop = 1;
		}
	}

	SoftSpriteParaSet(pda->ss, SS_PARA_POS_Z, pda->aff_z / 0x0100);
	DT_PokeAffineUpdateZ(pda->ss);
}

//--------------------------------------------------------------
/**
 * @brief   |P풓AjFړAj
 * @param   pda		풓Ajp[Nւ̃|C^
 */
//--------------------------------------------------------------
static void PokemonDefaultAnime_Move(POKE_DEF_ANM_WORK *pda)
{
	s32 old_sin, offset_x, furihaba_x;
	
	old_sin = pda->move_sin;

	switch(pda->move_seq){
	case 0:
		pda->move_seq++;
		break;
	case 1:
		if(pda->rotation_pos == 0){
			pda->move_sin += PDA_MOVE_ADD_SIN_MAIN;
		}
		else{
			pda->move_sin += PDA_MOVE_ADD_SIN_BACK;
		}
		
		if(pda->move_sin >= (360 << 8)){
			pda->move_sin -= 360 << 8;
		}
		break;
	}
	
	if(pda->move_stop_req == 1){
		if((old_sin > pda->move_sin) || (old_sin < (180<<8) && pda->move_sin >= (180<<8))){
			pda->move_sin = 0;
			pda->move_stop_req = 0;
			pda->move_stop = 1;
		}
	}
	
	furihaba_x = pda->rotation_pos == 0 ? PDA_MOVE_FURIHABA_X_MAIN : PDA_MOVE_FURIHABA_X_BACK;
	offset_x = Sin360(pda->move_sin >> 8) * furihaba_x / FX32_ONE;//>> FX32_SHIFT;
	if(pda->move_sin >= (180<<8)){
//		offset_x *= -1;
	}
	SoftSpriteParaSet(pda->ss, SS_PARA_POS_X, offset_x + DancePokePos[pda->rotation_pos][0]);
}

//--------------------------------------------------------------
/**
 * @brief   bZ[W^OWJ
 *
 * @param   dpw			_XǗ[Nւ̃|C^
 * @param   msg_tag		^OR[h
 * @param   tagpara		^OWJꍇAQƂp[^
 *                      (^OɂĂ͕KvȂ̂ŁȀꍇANULLłOK)
 */
//--------------------------------------------------------------
static void DT_MessageTagExpand(DANCE_PROC_WORK *dpw, int msg_tag, const DTAG_PARAM *tagpara)
{
	u32 str_id;
	
	if(msg_tag != DTAG_NONE){
		GF_ASSERT(tagpara != NULL);
	}
	
	switch(msg_tag){
	case DTAG_NONE:
		break;
	
	case DTAG_RANK:
		str_id = ConTool_GetRankMsgID(dpw->consys->c_game.rank);
		WORDSET_RegisterContestRank(dpw->sys.wordset, 0, str_id);
		break;
	case DTAG_OYA_NICK:
		WORDSET_RegisterWord(dpw->sys.wordset, 0, 
			dpw->consys->c_game.breeder_name_str[tagpara->mine_brd], 
			dpw->consys->c_game.player_sex[tagpara->mine_brd], TRUE, PM_LANG);
		WORDSET_RegisterPokeNickName(dpw->sys.wordset, 1, 
			PPPPointerGet(dpw->sys.c_game->pp[tagpara->mine_brd]));
		break;
	case DTAG_RANK_NUM_OYA_NICK:
		str_id = ConTool_GetRankMsgID(dpw->consys->c_game.rank);
		WORDSET_RegisterContestRank(dpw->sys.wordset, 0, str_id);

		WORDSET_RegisterNumber(dpw->sys.wordset, 1, tagpara->num, 1, 
			NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT);

		WORDSET_RegisterWord(dpw->sys.wordset, 2, 
			dpw->consys->c_game.breeder_name_str[tagpara->mine_brd], 
			dpw->consys->c_game.player_sex[tagpara->mine_brd], TRUE, PM_LANG);
		WORDSET_RegisterPokeNickName(dpw->sys.wordset, 3, 
			PPPPointerGet(dpw->sys.c_game->pp[tagpara->mine_brd]));
		break;

	default:
		GF_ASSERT(0 && "FłȂ^Oł\n");
		break;
	}
}

//--------------------------------------------------------------
/**
 * @brief   bbZ[WZbg
 *
 * @param   dpw			_XǗ[Nւ̃|C^
 * @param   msg_id		bZ[WID
 * @param   msg_tag		^OR[h
 * @param   tagpara		^OWJꍇAQƂp[^
 *                      (^OɂĂ͕KvȂ̂ŁȀꍇANULLłOK)
 */
//--------------------------------------------------------------
static void DT_TalkMessageSet(DANCE_PROC_WORK *dpw, MSGDATA_MANAGER *msg_man, 
	u32 msg_id, int msg_tag, const DTAG_PARAM *tagpara)
{
	STRBUF *message_src;
	
//	BattleMSG_TagExpand(bw,mp);
//	BattleMSG_MsgExpand(bw,msg_m,mp);

	message_src = MSGMAN_AllocString(msg_man, msg_id);
	DT_MessageTagExpand(dpw, msg_tag, tagpara);
	WORDSET_ExpandStr(dpw->sys.wordset, dpw->sys.msg_buf, message_src);

	GF_BGL_BmpWinDataFill(&dpw->sys.win[DANCE_BMPWIN_TALK], 0xff);
	dpw->sys.talk_msg_index = GF_STR_PrintSimple(&dpw->sys.win[DANCE_BMPWIN_TALK], 
		FONT_TALK, dpw->sys.msg_buf, 0, 0, CONTEST_MESSAGE_WAIT, NULL);

	STRBUF_Delete(message_src);
}

//--------------------------------------------------------------
/**
 * @brief   m[}bp̃bZ[WZbg
 *
 * @param   dpw				_XǗ[Nւ̃|C^
 * @param   a_talk_id		A_TALK_???
 * @param   tagpara			^OWJꍇAQƂp[^
 *                  	    (^OɂĂ͕KvȂ̂ŁȀꍇANULLłOK)
 */
//--------------------------------------------------------------
void DT_A_TalkMessageSet(DANCE_PROC_WORK *dpw, u32 a_talk_id, const DTAG_PARAM *tagpara)
{
	u32 msg_id, msg_tag;
	
	GF_ASSERT(a_talk_id < NELEMS(DanceTalkMsgData));
	
	msg_id = DanceTalkMsgData[a_talk_id].msg_id;
	msg_tag = DanceTalkMsgData[a_talk_id].msg_tag;
	DT_TalkMessageSet(dpw, dpw->sys.dance_msg, msg_id, msg_tag, tagpara);
}

//--------------------------------------------------------------
/**
 * @brief   bbZ[WtHg\Ă邩`FbN
 * @param   dpw		_XǗ[Nւ̃|C^
 * @retval  0=I
 */
//--------------------------------------------------------------
int DT_TalkMessageEndCheck(DANCE_PROC_WORK *dpw)
{
	return GF_MSG_PrintEndCheck(dpw->sys.talk_msg_index);
}
