//==============================================================================
/**
 * @file	res_order.c
 * @brief	ReXgʔ\ʁFߑM
 * @author	matsuda
 * @date	2006.03.17()
 */
//==============================================================================
#include "common.h"
#include "contest/contest.h"
#include "battle/battle_common.h"
#include "contest_order.h"
#include "con_result.h"
#include "res_order.h"

#include "res_tcb_pri.h"
#include "system/clact_tool.h"
#include "system/palanm.h"

#include "system/arc_tool.h"
#include "system/arc_util.h"

#include "system/softsprite.h"

#include "system/fontproc.h"
#include "system/msgdata.h"

#include "wazaeffect/battle_particle.h"
#include "system/particle.h"
#include "wazaeffect/we_mana.h"
#include "wazaeffect/we_sys.h"

#include "system/brightness.h"

#include "graphic/contest_bg_def.h"
#include "graphic/contest_obj_def.h"

#include "res_tool.h"
#include "poketool/poke_tool.h"
#include "gflib/touchpanel.h"
#include "system/snd_tool.h"
#include "system/window.h"

#include "communication/communication.h"
#include "comm_command_contest.h"


//==============================================================================
//	萔`
//==============================================================================
///ǂ񂿂傤AjEFCg
#define DONCHOU_ANM_WAIT		(1)
///ǂ񂿂傤1iAjI閈ɂAjEFCg
#define DONCHOU_DANSA_ANM_WAIT		(0)
///ǂ񂿂傤̃Aj]p̃LN^ɉLĂ邩
#define DONCHOU_ANM_DATA_X_LEN	(8)
///ǂ񂿂傤̃Aj]p̃LN^cɉLĂ邩
#define DONCHOU_ANM_DATA_Y_LEN	(4)

//==============================================================================
//	vg^Cv錾
//==============================================================================
static int Request_Sample(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work);
static void Recieve_Sample(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data);
static void Answer_Sample(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *answer_head, CO_ANSDAT *ansdat, int net_id);
static int Request_DonchouUp(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work);
static void Recieve_DonchouUp(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data);
static void ROTCB_DonchouUp(TCB_PTR tcb, void *work);
static int Request_DonchouDown(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work);
static void Recieve_DonchouDown(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data);
static void ROTCB_DonchouDown(TCB_PTR tcb, void *work);
static int Request_ConresExit(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work);
static void Recieve_ConresExit(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data);
static int Request_Talk(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work);
static void Recieve_Talk(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data);
static void ROTCB_TalkPut(TCB_PTR tcb, void *work);


//==============================================================================
//	f[^
//==============================================================================
///ߑMp֐|C^\̃e[u	ɒǉK.henumɂǉ鎖!!
static const CON_ORDER_FUNC OrderFuncTbl[] = {
	{//DORDER_NO_SAMPLE		Tv
		Request_Sample, 
		Recieve_Sample, 
		Answer_Sample, 
	},
	{//DORDER_NO_DONCHOU_UP
		Request_DonchouUp, 
		Recieve_DonchouUp, 
		NULL, 
	},
	{//DORDER_NO_DONCHOU_DOWN
		Request_DonchouDown, 
		Recieve_DonchouDown, 
		NULL, 
	},
	{//DORDER_NO_CONRES_EXIT
		Request_ConresExit,
		Recieve_ConresExit,
		NULL,
	},
	{//DORDER_NO_TALK
		Request_Talk, 
		Recieve_Talk, 
		NULL, 
	},
};


//--------------------------------------------------------------
//	
//--------------------------------------------------------------
//--------------------------------------------------------------
//	
//--------------------------------------------------------------
///ǂ񂿂傤Aj̃XN[x[Xʒu
ALIGN4 static const s8 DonchouAnmLineData[] = {
	15, 11, 7, 3, -1
};

///ǂ񂿂傤̃Ajp^[̃LN^NoJnʒu
ALIGN4 static const u16 DonchouAnmPaternStartCharNo[] = {
	0x20, 0x28, 0x30, 0x38,
	0xa0, 0xa8, 0xb0, 0xb8,
	0x120, 0x128, 0x130, 0x138,
};
///ǂ񂿂傤̔ȂꖋŉĩLN^No
#define DONCHOU_NUKINASHI_MAKU		(0x200)




//--------------------------------------------------------------
/**
 * @brief   _XFReXgM[N
 * @param   rpw		_XǗ[Nւ̃|C^
 */
//--------------------------------------------------------------
void ConresOrder_WorkInit(CONRES_PROC_WORK *rpw)
{
	CO_INIT_DATA initdata;
	
	initdata.func_tbl = OrderFuncTbl;
	initdata.func_tbl_max = NELEMS(OrderFuncTbl);
	initdata.my_breeder_no = rpw->consys->c_game.my_breeder_no;
	initdata.server_no = rpw->consys->c_game.server_no;
	initdata.sio_flag = rpw->consys->sio_flag;
	
	CO_WorkInit(&rpw->cow, &initdata);
}


//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   ߑM(M)FTv
 *
 * @param   rpw			_XǗ[Nւ̃|C^
 * @param   work		Cӂ̃|C^
 *
 * @retval  o^ꂽNGXgrbgԍ
 */
//--------------------------------------------------------------
static int Request_Sample(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work)
{
	CONRES_PROC_WORK *rpw = syswork;
	int bit_no;
	
	bit_no = CO_REQUEST_TransmitBufferSet(cow, CSELECT_ALL, order_no, NULL, 0);
	return bit_no;
}

//--------------------------------------------------------------
/**
 * @brief   ߎM(M)FTv
 *
 * @param   rpw			_XǗ[Nւ̃|C^
 * @param   req_head	NGXgwb_̃|C^
 * @param   data		Mf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void Recieve_Sample(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data)
{
	CONRES_PROC_WORK *rpw = syswork;
	
	//ԎԂ	obt@͓ɓn̂Ȃ̂NULLw
	CO_ANSWER_TransmitBufferSet(cow, req_head, NULL, 0);
}

//--------------------------------------------------------------
/**
 * @brief   ԎM(M)FTv
 *
 * @param   rpw				_XǗ[Nւ̃|C^
 * @param   answer_head		Ԏwb_̃|C^
 * @param   ansdat			Mf[^ւ̃|C^
 * @param   net_id			ԎM҂̃lbgID
 */
//--------------------------------------------------------------
static void Answer_Sample(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *answer_head, CO_ANSDAT *ansdat, int net_id)
{
	CONRES_PROC_WORK *rpw = syswork;
	
	//Ԏ󂯎邾Ȃ̂œɂ鎖Ȃ
	return;
}


//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   ߑM(M)Fǂ񂿂傤グ
 *
 * @param   rpw			_XǗ[Nւ̃|C^
 * @param   work		Cӂ̃|C^
 *
 * @retval  o^ꂽNGXgrbgԍ
 */
//--------------------------------------------------------------
static int Request_DonchouUp(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work)
{
	CONRES_PROC_WORK *rpw = syswork;
	int bit_no;
	
	bit_no = CO_REQUEST_TransmitBufferSet(cow, CSELECT_ALL, order_no, NULL, 0);
	return bit_no;
}

//--------------------------------------------------------------
/**
 * @brief   ߎM(M)Fǂ񂿂傤グ
 *
 * @param   rpw			_XǗ[Nւ̃|C^
 * @param   req_head	NGXgwb_̃|C^
 * @param   data		Mf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void Recieve_DonchouUp(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data)
{
	CONRES_PROC_WORK *rpw = syswork;
	ROLOCAL_DONCHOU_UP *du;
	
	du = sys_AllocMemory(HEAPID_CONRES, sizeof(ROLOCAL_DONCHOU_UP));
	MI_CpuClear8(du, sizeof(ROLOCAL_DONCHOU_UP));

	du->rpw = rpw;
	du->req_head = *req_head;
	du->cow = cow;
	
	TCB_Add(ROTCB_DonchouUp, du, TCBPRI_CONRES_ORDERSUB);
}

//--------------------------------------------------------------
/**
 * @brief   ǂ񂿂傤グ
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		ROLOCAL_DONCHOU_UP\
 */
//--------------------------------------------------------------
static void ROTCB_DonchouUp(TCB_PTR tcb, void *work)
{
	ROLOCAL_DONCHOU_UP *du = work;
	
	switch(du->seq){
	case 0:
		//AjEFCg
		if(du->anm_dansa_wait > 0){
			du->anm_dansa_wait--;
			break;
		}
		if(du->anm_wait > 0){
			du->anm_wait--;
			break;
		}
		du->anm_wait = DONCHOU_ANM_WAIT;
		
		//Aj
		{
			u16 *scrn_buf, *dest_scrn;
			int x, y, pos_x, s, base_charno;
			
			scrn_buf = GF_BGL_ScreenAdrsGet(du->rpw->sys.bgl, CONRES_FRAME_EFF);
			for(y = 0; y < DONCHOU_ANM_DATA_Y_LEN; y++){
				if(DonchouAnmLineData[du->anm_line] + y < 0){
					continue;
				}
				dest_scrn = &scrn_buf[32 * (DonchouAnmLineData[du->anm_line] + y)];
				base_charno = DonchouAnmPaternStartCharNo[du->anm_no] + 32*y;
				pos_x = 0;
				for(s = 0; s < 32 / DONCHOU_ANM_DATA_X_LEN; s++){
					for(x = 0; x < DONCHOU_ANM_DATA_X_LEN; x++){
						dest_scrn[pos_x + x] &= 0xfc00;		//LN^Nô݃NA
						dest_scrn[pos_x + x] |= base_charno + x;
					}
					pos_x += DONCHOU_ANM_DATA_X_LEN;
				}
			}
			
			//2iڈȍ~̂ǂ񂿂傤ł͍Ō̃AjꃉCcȂ̂ŁA
			//Ôǂ񂿂傤̎cNAĂ
			//Ӗ킩Ȃꍇ͂Ƃ肠́op܂邲ƃRgAEgĂ݂Ε
			{
				if(du->anm_line > 0 && du->anm_no == 0){
					dest_scrn = &scrn_buf[32 * DonchouAnmLineData[du->anm_line - 1]];
					for(s = 0; s < 32; s++){
						dest_scrn[s] &= 0xfc00;		//LN^Nô݃NA
					}
				}
			}
			
			GF_BGL_LoadScreenV_Req(du->rpw->sys.bgl, CONRES_FRAME_EFF);
		}
		
		du->anm_no++;
		if(du->anm_no >= NELEMS(DonchouAnmPaternStartCharNo)){
			du->anm_no = 0;
			du->anm_line++;
			du->anm_dansa_wait = DONCHOU_DANSA_ANM_WAIT;
			if(du->anm_line >= NELEMS(DonchouAnmLineData)){
				du->seq++;
			}
		}
		break;
	default:
		CO_ANSWER_TransmitBufferSet(du->cow, &du->req_head, NULL, 0);

		sys_FreeMemoryEz(du);
		TCB_Delete(tcb);
		return;
	}
}


//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   ߑM(M)Fǂ񂿂傤
 *
 * @param   rpw			_XǗ[Nւ̃|C^
 * @param   work		Cӂ̃|C^
 *
 * @retval  o^ꂽNGXgrbgԍ
 */
//--------------------------------------------------------------
static int Request_DonchouDown(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work)
{
	CONRES_PROC_WORK *rpw = syswork;
	int bit_no;
	
	bit_no = CO_REQUEST_TransmitBufferSet(cow, CSELECT_ALL, order_no, NULL, 0);
	return bit_no;
}

//--------------------------------------------------------------
/**
 * @brief   ߎM(M)Fǂ񂿂傤
 *
 * @param   rpw			_XǗ[Nւ̃|C^
 * @param   req_head	NGXgwb_̃|C^
 * @param   data		Mf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void Recieve_DonchouDown(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data)
{
	CONRES_PROC_WORK *rpw = syswork;
	ROLOCAL_DONCHOU_DOWN *dd;
	
	dd = sys_AllocMemory(HEAPID_CONRES, sizeof(ROLOCAL_DONCHOU_DOWN));
	MI_CpuClear8(dd, sizeof(ROLOCAL_DONCHOU_DOWN));

	dd->rpw = rpw;
	dd->req_head = *req_head;
	dd->cow = cow;
	
	TCB_Add(ROTCB_DonchouDown, dd, TCBPRI_CONRES_ORDERSUB);
}

//--------------------------------------------------------------
/**
 * @brief   ǂ񂿂傤
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		ROLOCAL_DONCHOU_DOWN\
 */
//--------------------------------------------------------------
static void ROTCB_DonchouDown(TCB_PTR tcb, void *work)
{
	ROLOCAL_DONCHOU_DOWN *dd = work;
	
	switch(dd->seq){
	case 0:
		//AjEFCg
		if(dd->anm_dansa_wait > 0){
			dd->anm_dansa_wait--;
			break;
		}
		if(dd->anm_wait > 0){
			dd->anm_wait--;
			break;
		}
		dd->anm_wait = DONCHOU_ANM_WAIT;
		
		//Aj
		{
			u16 *scrn_buf, *dest_scrn;
			int x, y, pos_x, s, base_charno;
			int base_line;
			
			scrn_buf = GF_BGL_ScreenAdrsGet(dd->rpw->sys.bgl, CONRES_FRAME_EFF);
			for(y = 0; y < DONCHOU_ANM_DATA_Y_LEN; y++){
				base_line = DonchouAnmLineData[NELEMS(DonchouAnmLineData) - 1 - dd->anm_line];
				if(base_line + y < 0){
					continue;
				}
				dest_scrn = &scrn_buf[32 * (base_line + y)];
				base_charno = DonchouAnmPaternStartCharNo[NELEMS(DonchouAnmPaternStartCharNo) - 1 - dd->anm_no] + 32*y;
				pos_x = 0;
				for(s = 0; s < 32 / DONCHOU_ANM_DATA_X_LEN; s++){
					for(x = 0; x < DONCHOU_ANM_DATA_X_LEN; x++){
						dest_scrn[pos_x + x] &= 0xfc00;		//LN^Nô݃NA
						dest_scrn[pos_x + x] |= base_charno + x;
					}
					pos_x += DONCHOU_ANM_DATA_X_LEN;
				}
			}
			
			//ԉ̃CȊO͍Ō܂ŉ̃Aj̐ꖋȂ̂ŁA
			//̒ĩAjsꂽ^C~OŔȂ̃AjɕςĂ
			//Ӗ킩Ȃꍇ͂Ƃ肠́op܂邲ƃRgAEgĂ݂Ε
			{
				if(dd->anm_line > 0 && dd->anm_no == 0){
					base_line = DonchouAnmLineData[NELEMS(DonchouAnmLineData) - 1 - dd->anm_line + 1];
					base_line += DONCHOU_ANM_DATA_Y_LEN - 1;
					dest_scrn = &scrn_buf[base_line * 32];
					for(s = 0; s < 32; s++){
						dest_scrn[s] &= 0xfc00;		//LN^Nô݃NA
						dest_scrn[s] |= DONCHOU_NUKINASHI_MAKU + (s % DONCHOU_ANM_DATA_X_LEN);
					}
				}
			}
			
			GF_BGL_LoadScreenV_Req(dd->rpw->sys.bgl, CONRES_FRAME_EFF);
		}
		
		dd->anm_no++;
		if(dd->anm_no >= NELEMS(DonchouAnmPaternStartCharNo)){
			dd->anm_no = 0;
			dd->anm_line++;
			dd->anm_dansa_wait = DONCHOU_DANSA_ANM_WAIT;
			if(dd->anm_line >= NELEMS(DonchouAnmLineData)){
				dd->seq++;
			}
		}
		break;
	default:
		CO_ANSWER_TransmitBufferSet(dd->cow, &dd->req_head, NULL, 0);

		sys_FreeMemoryEz(dd);
		TCB_Delete(tcb);
		return;
	}
}


//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   ߑM(M)F_XI
 *
 * @param   vpw			Z͕Ǘ[Nւ̃|C^
 * @param   work		Cӂ̃|C^
 *
 * @retval  o^ꂽNGXgrbgԍ
 */
//--------------------------------------------------------------
static int Request_ConresExit(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work)
{
	CONRES_PROC_WORK *rpw = syswork;
	int bit_no;
	
	bit_no = CO_REQUEST_TransmitBufferSet(cow, CSELECT_ALL, order_no, NULL, 0);
	return bit_no;
}

//--------------------------------------------------------------
/**
 * @brief   ߎM(M)F_XI
 *
 * @param   rpw			Z͕Ǘ[Nւ̃|C^
 * @param   req_head	NGXgwb_̃|C^
 * @param   data		Mf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void Recieve_ConresExit(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data)
{
	CONRES_PROC_WORK *rpw = syswork;

	rpw->main_end = TRUE;
	
	//ԎԂ	obt@͓ɓn̂Ȃ̂NULLw
	CO_ANSWER_TransmitBufferSet(cow, req_head, NULL, 0);
}


//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   ߑM(M)FbbZ[W̕\
 *
 * @param   rpw			_XǗ[Nւ̃|C^
 * @param   work		Cӂ̃|C^
 *
 * @retval  o^ꂽNGXgrbgԍ
 */
//--------------------------------------------------------------
static int Request_Talk(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work)
{
	CONRES_PROC_WORK *rpw = syswork;
	int bit_no;
	
	bit_no = CO_REQUEST_TransmitBufferSet(cow, CSELECT_ALL, order_no, 
		work, sizeof(CONRES_ADVANCE_PARAM));
	return bit_no;
}

//--------------------------------------------------------------
/**
 * @brief   ߎM(M)FbbZ[W̕\
 *
 * @param   rpw			_XǗ[Nւ̃|C^
 * @param   req_head	NGXgwb_̃|C^
 * @param   data		Mf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void Recieve_Talk(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data)
{
	CONRES_PROC_WORK *rpw = syswork;
	CONRES_ADVANCE_PARAM *dap = data;
	ROLOCAL_TALK_PUT *talk;
	
	talk = sys_AllocMemory(HEAPID_CONRES, sizeof(ROLOCAL_TALK_PUT));
	MI_CpuClear8(talk, sizeof(ROLOCAL_TALK_PUT));
	
	talk->rpw = rpw;
	talk->req_head = *req_head;
	talk->cow = cow;
	talk->breeder_no = dap->now_breeder;
	
	talk->a_talk_tagpara = dap->a_talk_tagpara;
	talk->a_talk_id = dap->a_talk_id;
	talk->a_talk_bmpwin_not_close = dap->a_talk_bmpwin_not_close;
	talk->a_talk_bmpwin_close_wait = dap->a_talk_bmpwin_close_wait;
	
	TCB_Add(ROTCB_TalkPut, talk, TCBPRI_CONRES_ORDERSUB);
}

//--------------------------------------------------------------
/**
 * @brief   bbZ[W̕\
 * @param   tcb			TCBւ̃|C^
 * @param   work		ROLOCAL_TALK_PUT\
 */
//--------------------------------------------------------------
static void ROTCB_TalkPut(TCB_PTR tcb, void *work)
{
	ROLOCAL_TALK_PUT *talk = work;
	
	switch(talk->seq){
	case 0:
		if(talk->a_talk_id != A_TALK_CONRES_NULL){
			BmpTalkWinWrite(&talk->rpw->sys.win[CONRES_BMPWIN_TALK], WINDOW_TRANS_OFF,
				CONRES_TALKWIN_CGX_OFFSET, CONRES_TALKWIN_PALNO);
			GF_BGL_LoadScreenV_Req(talk->rpw->sys.bgl, CONRES_FRAME_WIN);

			RT_A_TalkMessageSet(talk->rpw, talk->a_talk_id, &talk->a_talk_tagpara);
			talk->seq++;
		}
		else{
			talk->seq = 100;
		}
		break;
	case 1:
		if(RT_TalkMessageEndCheck(talk->rpw) == 0){
			talk->seq++;
		}
		break;
	case 2:
		talk->close_wait++;
		if(talk->a_talk_bmpwin_not_close == TRUE){
			talk->seq++;
		}
		else if(talk->close_wait >= talk->a_talk_bmpwin_close_wait){
			BmpTalkWinClear(&talk->rpw->sys.win[CONRES_BMPWIN_TALK], WINDOW_TRANS_OFF);
			GF_BGL_LoadScreenV_Req(talk->rpw->sys.bgl, CONRES_FRAME_WIN);
			talk->seq++;
		}
		break;
	default:
		CO_ANSWER_TransmitBufferSet(talk->cow, &talk->req_head, NULL, 0);

		sys_FreeMemoryEz(talk);
		TCB_Delete(tcb);
		return;
	}
}

