//==============================================================================
/**
 * @file	res_tool.c
 * @brief	ʔ\ʃc[
 * @author	matsuda
 * @date	2006.03.17()
 */
//==============================================================================
#include "common.h"
#include "contest/contest.h"
#include "battle/battle_common.h"
#include "system/clact_tool.h"
#include "system/palanm.h"

#include "system/arc_tool.h"
#include "system/arc_util.h"

#include "system/softsprite.h"

#include "system/fontproc.h"
#include "system/msgdata.h"

#include "system/brightness.h"

#include "graphic/contest_bg_def.h"
#include "graphic/contest_obj_def.h"

#include "msgdata/msg.naix"

#include "con_result.h"
#include "con_tool.h"

#include "system/msgdata_util.h"
#include "system/wordset.h"
#include "system/fontoam.h"
#include "msgdata/msg_cmsg_result.h"

#include "adv_tool.h"


//==============================================================================
//	萔`
//==============================================================================


//==============================================================================
//	vg^Cv錾
//==============================================================================
static void RT_MessageTagExpand(CONRES_PROC_WORK *rpw, int msg_tag, const CRTAG_PARAM *tagpara);
static void RT_TalkMessageSet(CONRES_PROC_WORK *rpw, MSGDATA_MANAGER *msg_man, 
	u32 msg_id, int msg_tag, const CRTAG_PARAM *tagpara);
void RT_SoftSpriteAddAll(CONRES_PROC_WORK *rpw);
void RT_SoftSpriteDelAll(CONRES_SYSTEM_PARAM *sys);
void RT_A_TalkMessageSet(CONRES_PROC_WORK *rpw, u32 a_talk_id, const CRTAG_PARAM *tagpara);
int RT_TalkMessageEndCheck(CONRES_PROC_WORK *rpw);

//==============================================================================
//	f[^
//==============================================================================
///|P\W
ALIGN4 static const s16 ConresPokePos[BREEDER_MAX][3] = {	//X, Y, Z
	{128, 110, CONRES_POKEPOS_Z_MAIN},
	{48, 40, CONRES_POKEPOS_Z_SUB},
	{128, 40, CONRES_POKEPOS_Z_SUB},
	{256-48, 40, CONRES_POKEPOS_Z_SUB},
};


//--------------------------------------------------------------
//	
//--------------------------------------------------------------
///_Xm[}bbZ[Wf[^	A_TALK_CONRES_???̒`ƕт𓯂ɂĂII
static const CONRES_MESSAGE_PARAM ConresTalkMsgData[] = {
	{0,									CRTAG_NONE},	//_~[
	{CRMSG_RESULT,						CRTAG_OYA_NICK},
};




//--------------------------------------------------------------
/**
 * @brief   SẴu[_[̃\tgEFAXvCg(|P)𐶐
 *
 * @param   rpw		_XǗ[Nւ̃|C^
 */
//--------------------------------------------------------------
void RT_SoftSpriteAddAll(CONRES_PROC_WORK *rpw)
{
	int i;
	
	for(i = 0; i < BREEDER_MAX; i++){
		GF_ASSERT(rpw->sys.exchr_param[i].exchr_buffer == NULL);
		rpw->sys.exchr_param[i].exchr_buffer = sys_AllocMemory(HEAPID_CONRES, EXCHR_BUFFER_SIZE);
		rpw->sys.ss[i] = 
			ConTool_BreederPokemonAdd(rpw->sys.soft_sprite, i, rpw->sys.c_game->pp[i], 
			PARA_FRONT, &rpw->sys.exchr_param[i], HEAPID_CONRES, 
			ConresPokePos[i][0], ConresPokePos[i][1], ConresPokePos[i][2]);
	}
}

//--------------------------------------------------------------
/**
 * @brief   SẴu[_[̃\tgEFAXvCg(|P)폜
 * @param   sys		_XVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
void RT_SoftSpriteDelAll(CONRES_SYSTEM_PARAM *sys)
{
	int i;
	
	for(i = 0; i < BREEDER_MAX; i++){
		SoftSpriteDel(sys->ss[i]);
		sys_FreeMemoryEz(sys->exchr_param[i].exchr_buffer);
		sys->exchr_param[i].exchr_buffer = NULL;
	}
}

//--------------------------------------------------------------
/**
 * @brief   bZ[W^OWJ
 *
 * @param   rpw			_XǗ[Nւ̃|C^
 * @param   msg_tag		^OR[h
 * @param   tagpara		^OWJꍇAQƂp[^
 *                      (^OɂĂ͕KvȂ̂ŁȀꍇANULLłOK)
 */
//--------------------------------------------------------------
static void RT_MessageTagExpand(CONRES_PROC_WORK *rpw, int msg_tag, const CRTAG_PARAM *tagpara)
{
	u32 str_id;
	
	if(msg_tag != CRTAG_NONE){
		GF_ASSERT(tagpara != NULL);
	}
	
	switch(msg_tag){
	case CRTAG_NONE:
		break;
	
	case CRTAG_RANK:
		str_id = ConTool_GetRankMsgID(rpw->consys->c_game.rank);
		WORDSET_RegisterContestRank(rpw->sys.wordset, 0, str_id);
		break;
	case CRTAG_OYA_NICK:
		WORDSET_RegisterWord(rpw->sys.wordset, 0, 
			rpw->consys->c_game.breeder_name_str[tagpara->mine_brd], 
			rpw->consys->c_game.player_sex[tagpara->mine_brd], TRUE, PM_LANG);
		WORDSET_RegisterPokeNickName(rpw->sys.wordset, 1, 
			PPPPointerGet(rpw->sys.c_game->pp[tagpara->mine_brd]));
		break;

	default:
		GF_ASSERT(0 && "FłȂ^Oł\n");
		break;
	}
}

//--------------------------------------------------------------
/**
 * @brief   bbZ[WZbg
 *
 * @param   rpw			_XǗ[Nւ̃|C^
 * @param   msg_id		bZ[WID
 * @param   msg_tag		^OR[h
 * @param   tagpara		^OWJꍇAQƂp[^
 *                      (^OɂĂ͕KvȂ̂ŁȀꍇANULLłOK)
 */
//--------------------------------------------------------------
static void RT_TalkMessageSet(CONRES_PROC_WORK *rpw, MSGDATA_MANAGER *msg_man, 
	u32 msg_id, int msg_tag, const CRTAG_PARAM *tagpara)
{
	STRBUF *message_src;
	
//	BattleMSG_TagExpand(bw,mp);
//	BattleMSG_MsgExpand(bw,msg_m,mp);

	message_src = MSGMAN_AllocString(msg_man, msg_id);
	RT_MessageTagExpand(rpw, msg_tag, tagpara);
	WORDSET_ExpandStr(rpw->sys.wordset, rpw->sys.msg_buf, message_src);

	GF_BGL_BmpWinDataFill(&rpw->sys.win[CONRES_BMPWIN_TALK], 0xff);
	rpw->sys.talk_msg_index = GF_STR_PrintSimple(&rpw->sys.win[CONRES_BMPWIN_TALK], 
		FONT_TALK, rpw->sys.msg_buf, 0, 0, CONTEST_MESSAGE_WAIT, NULL);

	STRBUF_Delete(message_src);
}

//--------------------------------------------------------------
/**
 * @brief   m[}bp̃bZ[WZbg
 *
 * @param   rpw				_XǗ[Nւ̃|C^
 * @param   a_talk_id		A_TALK_???
 * @param   tagpara			^OWJꍇAQƂp[^
 *                  	    (^OɂĂ͕KvȂ̂ŁȀꍇANULLłOK)
 */
//--------------------------------------------------------------
void RT_A_TalkMessageSet(CONRES_PROC_WORK *rpw, u32 a_talk_id, const CRTAG_PARAM *tagpara)
{
	u32 msg_id, msg_tag;
	
	GF_ASSERT(a_talk_id < NELEMS(ConresTalkMsgData));
	
	msg_id = ConresTalkMsgData[a_talk_id].msg_id;
	msg_tag = ConresTalkMsgData[a_talk_id].msg_tag;
	RT_TalkMessageSet(rpw, rpw->sys.conres_msg, msg_id, msg_tag, tagpara);
}

//--------------------------------------------------------------
/**
 * @brief   bbZ[WtHg\Ă邩`FbN
 * @param   rpw		_XǗ[Nւ̃|C^
 * @retval  0=I
 */
//--------------------------------------------------------------
int RT_TalkMessageEndCheck(CONRES_PROC_WORK *rpw)
{
	return GF_MSG_PrintEndCheck(rpw->sys.talk_msg_index);
}
