//==============================================================================
/**
 * @file	visual.c
 * @brief	rWA
 * @author	matsuda
 * @date	2005.12.10(y)
 */
//==============================================================================
#include "common.h"
#include "contest/contest.h"
#include "battle/battle_common.h"
#include "system/clact_tool.h"
#include "system/palanm.h"

#include "system/arc_tool.h"
#include "system/arc_util.h"

#include "system/softsprite.h"
#include "system/gra_tool.h"

#include "wazaeffect/battle_particle.h"
#include "system/particle.h"

#include "system/fontproc.h"
#include "system/msgdata.h"

#include "system/brightness.h"
#include "system/snd_tool.h"

#include "graphic/contest_bg_def.h"
#include "graphic/contest_obj_def.h"

#include "msgdata/msg.naix"

#include "con_tool.h"
#include "visual.h"
#include "visual_tool.h"
#include "visual_tcb_pri.h"
#include "visual_id.h"
#include "visual_order.h"

#include "system/window.h"

#include "system/pm_overlay.h"
FS_EXTERN_OVERLAY(bc_common);



//==============================================================================
//	萔`
//==============================================================================
///݂̓
enum{
	VPW_PROC_MODE_INIT,		///<
	VPW_PROC_MODE_MAIN,		///<C
	VPW_PROC_MODE_ETC,		///<ȊO
};

///Vram]}l[W[^XN
#define VISUAL_VRAM_TRANSFER_TASK_NUM	(BATTLE_VRAM_TRANSFER_TASK_NUM)

//--------------------------------------------------------------
//	BMPEBhE
//--------------------------------------------------------------
///BMPEBhECGXGAJnʒu(ItZbg)
#define BMPWIN_CGX_START			(TALK_WIN_CGX_SIZ + VISUAL_TALKWIN_CGX_OFFSET)

#define BMPWIN_TALK_COLOR			(13)
#define BMPWIN_TALK_CGX_OFFSET		(BMPWIN_CGX_START)

//--------------------------------------------------------------
//	CL_ACTp̒萔`
//--------------------------------------------------------------
///C	OAMǗ̈EJn
#define VISUAL_OAM_START_MAIN			(BATTLE_OAM_START_MAIN)
///C	OAMǗ̈EI
#define VISUAL_OAM_END_MAIN				(BATTLE_OAM_END_MAIN)
///C	AtBǗ̈EJn
#define VISUAL_OAM_AFFINE_START_MAIN		(BATTLE_OAM_AFFINE_START_MAIN)
///C	AtBǗ̈EI
#define VISUAL_OAM_AFFINE_END_MAIN		(BATTLE_OAM_AFFINE_END_MAIN)
///Tu	OAMǗ̈EJn
#define VISUAL_OAM_START_SUB				(BATTLE_OAM_START_SUB)
///Tu	OAMǗ̈EI
#define VISUAL_OAM_END_SUB				(BATTLE_OAM_END_SUB)
///Tu AtBǗ̈EJn
#define VISUAL_OAM_AFFINE_START_SUB		(BATTLE_OAM_AFFINE_START_SUB)
///Tu	AtBǗ̈EI
#define VISUAL_OAM_AFFINE_END_SUB		(BATTLE_OAM_AFFINE_END_SUB)

///L}l[WFLN^IDǗ(ʁ{)
#define VISUAL_CHAR_MAX					(BATTLE_CHAR_MAX)
///L}l[WFCʃTCY(byteP)
#define VISUAL_CHAR_VRAMSIZE_MAIN		(BATTLE_CHAR_VRAMSIZE_MAIN)
///L}l[WFTuʃTCY(byteP)
#define VISUAL_CHAR_VRAMSIZE_SUB			(BATTLE_CHAR_VRAMSIZE_SUB)

///Cʁ{TuʂŎgpAN^[
#define VISUAL_ACTOR_MAX					(BATTLE_ACTOR_MAX)

///OBJŎgppbg{(ʁ{)
#define VISUAL_OAM_PLTT_MAX				(BATTLE_OAM_PLTT_MAX)

///][h 3D = 0 main = 1 sub = 2 main/sub = 3
#define VISUAL_OAM_VRAM_TRANS			(BATTLE_OAM_VRAM_TRANS)

///OAM\[XFLo^ő吔(C + Tu)
#define VISUAL_OAMRESOURCE_CHAR_MAX		(BATTLE_OAMRESOURCE_CHAR_MAX)
///OAM\[XFpbgo^ő吔(C + Tu)
#define VISUAL_OAMRESOURCE_PLTT_MAX		(BATTLE_OAMRESOURCE_PLTT_MAX)
///OAM\[XFZo^ő吔
#define VISUAL_OAMRESOURCE_CELL_MAX		(BATTLE_OAMRESOURCE_CELL_MAX)
///OAM\[XFZAjo^ő吔
#define VISUAL_OAMRESOURCE_CELLANM_MAX	(BATTLE_OAMRESOURCE_CELLANM_MAX)
///OAM\[XF}`Zo^ő吔
#define VISUAL_OAMRESOURCE_MCELL_MAX		(BATTLE_OAMRESOURCE_MCELL_MAX)
///OAM\[XF}`ZAjo^ő吔
#define VISUAL_OAMRESOURCE_MCELLANM_MAX	(BATTLE_OAMRESOURCE_MCELLANM_MAX)

//--------------------------------------------------------------
//	
//--------------------------------------------------------------
///TuBG̃XN[NAR[h
#define SUB_BG_CLEAR_CODE		(0)

//--------------------------------------------------------------
//	
//--------------------------------------------------------------
///ǂ񂿂傤̃pbgԍ
#define DONTYOU_PALNO			(0xc)


//==============================================================================
//	vg^Cv錾
//==============================================================================
static void VisualVBlank(void *work);
static void VisualUpdate(TCB_PTR tcb, void *work);
static void VisualSys_VramBankSet(GF_BGL_INI *bgl);
static void VisualSys_DefaultBmpWinAdd(VISUAL_PROC_WORK *vpw);
static void VisualSystemWorkInit(VISUAL_PROC_WORK *vpw);
static void VisualDefaultOBJSet(VISUAL_PROC_WORK *vpw);
static void VisualDefaultOBJDel(VISUAL_PROC_WORK *vpw);
static void VisualDefaultOBJSet_Sub(VISUAL_PROC_WORK *vpw);
static void VisualDefaultOBJDel_Sub(VISUAL_PROC_WORK *vpw);
static void VisualDefaultBGSet(VISUAL_PROC_WORK *vpw);
static void VisualDefaultBGDel(VISUAL_PROC_WORK *vpw);
static void VisualDefaultBGSet_Sub(VISUAL_PROC_WORK *vpw);
static void VisualDefaultBGDel_Sub(VISUAL_PROC_WORK *vpw);
static int VisualSeq_Init(VISUAL_PROC_WORK *vpw, VISUAL_LOCAL_WORK *local);
static int VisualSeq_JudgeFastTalk(VISUAL_PROC_WORK *vpw, VISUAL_LOCAL_WORK *local);
static int VisualSeq_EndTalk(VISUAL_PROC_WORK *vpw, VISUAL_LOCAL_WORK *local);
static int VisualSeq_End(VISUAL_PROC_WORK *vpw, VISUAL_LOCAL_WORK *local);
static void VisualParticleInit(void);
static int VisualSeq_PokeSelect(VISUAL_PROC_WORK *vpw, VISUAL_LOCAL_WORK *local);
static int VisualSeq_Appear(VISUAL_PROC_WORK *vpw, VISUAL_LOCAL_WORK *local);
static int VisualSeq_TrainerIn(VISUAL_PROC_WORK *vpw, VISUAL_LOCAL_WORK *local);
static int VisualSeq_IntroduceTalk(VISUAL_PROC_WORK *vpw, VISUAL_LOCAL_WORK *local);
static int VisualSeq_AppearEffect(VISUAL_PROC_WORK *vpw, VISUAL_LOCAL_WORK *local);
static int VisualSeq_TrainerOut(VISUAL_PROC_WORK *vpw, VISUAL_LOCAL_WORK *local);
static int VisualSeq_Advance(VISUAL_PROC_WORK *vpw, VISUAL_LOCAL_WORK *local);
static int VisualSeq_AudienceEvaluate(VISUAL_PROC_WORK *vpw, VISUAL_LOCAL_WORK *local);
static int VisualSeq_PokeOut(VISUAL_PROC_WORK *vpw, VISUAL_LOCAL_WORK *local);
static int VisualSeq_NextPoke(VISUAL_PROC_WORK *vpw, VISUAL_LOCAL_WORK *local);
static int VisualSeq_DonchouUp(VISUAL_PROC_WORK *vpw, VISUAL_LOCAL_WORK *local);
static int VisualSeq_DonchouDown(VISUAL_PROC_WORK *vpw, VISUAL_LOCAL_WORK *local);


//==============================================================================
//	f[^
//==============================================================================

//==============================================================================
//	V[PXe[u
//==============================================================================
///VisualMainSeqTbl̖߂lƂĎgp
enum{
	VSRET_CONTINUE,		///<ێ
	VSRET_NEXT,			///<̃V[PX
	VSRET_SELECT_SEQ,	///<select_seq[NɓĂV[PX֐i
	VSRET_END,			///<I
};

///rWA僁C֐̃V[PXe[u
static int (* const VisualMainSeqTbl[])(VISUAL_PROC_WORK *vpw, VISUAL_LOCAL_WORK *local) = {
	VisualSeq_Init,
	VisualSeq_JudgeFastTalk,
	VisualSeq_DonchouUp,
	VisualSeq_PokeSelect,
//	VisualSeq_Appear,
	VisualSeq_IntroduceTalk,
	VisualSeq_TrainerIn,
	VisualSeq_AppearEffect,
//	VisualSeq_TrainerOut,
//	VisualSeq_Advance,
	VisualSeq_AudienceEvaluate,
	VisualSeq_PokeOut,
	VisualSeq_NextPoke,
	VisualSeq_DonchouDown,
	VisualSeq_EndTalk,
	VisualSeq_End,
};
///VisualMainSeqTbl̃V[PXԍ	VisualMainSeqTblƕт𓯂ɂĂƁII
enum{
	VSEQ_INIT,
	VSEQ_JUDGE_FAST_TALK,
	VSEQ_DONCHOU_UP,
	VSEQ_POKE_SELECT,
//	VSEQ_APPEAR,
	VSEQ_INTRODUCE_TALK,
	VSEQ_TRAINER_IN,
	VSEQ_APPEAR_EFFECT,
//	VSEQ_TRAINER_OUT,
//	VSEQ_ADVANCE,
	VSEQ_AUDIENCE_EVALUATE,
	VSEQ_POKE_OUT,
	VSEQ_NEXT_POKE,
	VSEQ_DONCHOU_DOWN,
	VSEQ_END_TALK,
	VSEQ_END,
};

//==============================================================================
//	CLACTpf[^
//==============================================================================
static	const TCATS_OAM_INIT VisualTcats = {
	VISUAL_OAM_START_MAIN, VISUAL_OAM_END_MAIN,
	VISUAL_OAM_AFFINE_START_MAIN, VISUAL_OAM_AFFINE_END_MAIN,
	VISUAL_OAM_START_SUB, VISUAL_OAM_END_SUB,
	VISUAL_OAM_AFFINE_START_SUB, VISUAL_OAM_AFFINE_END_SUB,
};

static	const TCATS_CHAR_MANAGER_MAKE VisualCcmm = {
	VISUAL_CHAR_MAX,
	VISUAL_CHAR_VRAMSIZE_MAIN,
	VISUAL_CHAR_VRAMSIZE_SUB,
	GX_OBJVRAMMODE_CHAR_1D_64K,
	GX_OBJVRAMMODE_CHAR_1D_32K
};

static const TCATS_RESOURCE_NUM_LIST VisualResourceList = {
	VISUAL_OAMRESOURCE_CHAR_MAX,
	VISUAL_OAMRESOURCE_PLTT_MAX,
	VISUAL_OAMRESOURCE_CELL_MAX,
	VISUAL_OAMRESOURCE_CELLANM_MAX,
	VISUAL_OAMRESOURCE_MCELL_MAX,
	VISUAL_OAMRESOURCE_MCELLANM_MAX,
};



//--------------------------------------------------------------
/**
 * @brief   vZX֐F
 *
 * @param   proc		vZXf[^
 * @param   seq			V[PX
 *
 * @retval  
 */
//--------------------------------------------------------------
PROC_RESULT VisualProc_Init( PROC * proc, int * seq )
{
	VISUAL_PROC_WORK *vpw;

	sys_VBlankFuncChange(NULL, NULL);	// VBlankZbg
	sys_HBlankIntrStop();	//HBlank荞ݒ~

	GF_Disp_GX_VisibleControlInit();
	GF_Disp_GXS_VisibleControlInit();
	GX_SetVisiblePlane(0);
	GXS_SetVisiblePlane(0);

	sys_CreateHeap(HEAPID_BASE_APP, HEAPID_VISUAL, VISUAL_ALLOC_SIZE);

	simple_3DBGInit(HEAPID_VISUAL);
	
	vpw = PROC_AllocWork(proc, sizeof(VISUAL_PROC_WORK), HEAPID_VISUAL );
	MI_CpuClear8(vpw, sizeof(VISUAL_PROC_WORK));

	vpw->consys = PROC_GetParentWork(proc);
	vpw->consys->class_proc = vpw;
	vpw->consys->class_flag = CON_CLASS_VISUAL;
	vpw->sys.c_game = &vpw->consys->c_game;
	VisualSystemWorkInit(vpw);
	
	//pbgtF[hVXe쐬
	vpw->sys.pfd = PaletteFadeInit(HEAPID_VISUAL);
	PaletteTrans_AutoSet(vpw->sys.pfd, TRUE);
	PaletteFadeWorkAllocSet(vpw->sys.pfd, FADE_MAIN_BG, 0x200, HEAPID_VISUAL);
	PaletteFadeWorkAllocSet(vpw->sys.pfd, FADE_SUB_BG, 0x200, HEAPID_VISUAL);
	PaletteFadeWorkAllocSet(vpw->sys.pfd, FADE_MAIN_OBJ, 0x200, HEAPID_VISUAL);
	PaletteFadeWorkAllocSet(vpw->sys.pfd, FADE_SUB_OBJ, 0x200, HEAPID_VISUAL);
	
	vpw->sys.bgl = GF_BGL_BglIniAlloc(HEAPID_VISUAL);

	initVramTransferManagerHeap(VISUAL_VRAM_TRANSFER_TASK_NUM, HEAPID_VISUAL);

	sys_KeyRepeatSpeedSet( 4, 8 );

//	vpw->aip = AINPUT_SystemInit(&vpw->sys);

	//VRAM蓖Đݒ
	VisualSys_VramBankSet(vpw->sys.bgl);

	// ^b`plVXe
	InitTPSystem();
	InitTPNoBuff(4);

	// {^ptHgǂݍ
	FontProc_LoadFont(FONT_BUTTON, HEAPID_VISUAL);

	// ۑ
//	SetVisualWorkParameter(vpw, (NAMEIN_PARAM*)PROC_GetParentWork(proc));

	//AN^[VXe쐬
	vpw->sys.csp=CATS_AllocMemory(HEAPID_VISUAL);
	CATS_SystemInit(vpw->sys.csp,&VisualTcats,&VisualCcmm,VISUAL_OAM_PLTT_MAX);
	vpw->sys.crp=CATS_ResourceCreate(vpw->sys.csp);
	CATS_ClactSetInit(vpw->sys.csp, vpw->sys.crp, VISUAL_ACTOR_MAX);
	CATS_ResourceManagerInit(vpw->sys.csp,vpw->sys.crp,&VisualResourceList);

	vpw->sys.soft_sprite = SoftSpriteInit(HEAPID_VISUAL);
	VisualParticleInit();	//p[eBN

	//bZ[W}l[W쐬
	vpw->sys.visual_msg = MSGMAN_Create(MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_cmsg_visual_dat, 
		HEAPID_VISUAL);
	vpw->sys.wordset = WORDSET_Create(HEAPID_VISUAL);
	vpw->sys.msg_buf = STRBUF_Create(VISUAL_MESSAGE_BUF_SIZE, HEAPID_VISUAL);
	
	//풓BGZbg
	VisualDefaultBGSet(vpw);
	VisualDefaultBGSet_Sub(vpw);

	//BMPEBhEǉ
	VisualSys_DefaultBmpWinAdd(vpw);

	//풓OBJZbg
	VisualDefaultOBJSet(vpw);
	VisualDefaultOBJSet_Sub(vpw);
	
	//|P(\tgEFAXvCg)
	//VT_SoftSpriteAddAll(&vpw->sys);
	
	// PxύXZbg
	ChangeBrightnessRequest(
		8, 0, -16, PLANEMASK_ALL, MASK_DOUBLE_DISPLAY );

	vpw->update_tcb = TCB_Add(VisualUpdate, vpw, TCBPRI_VISUAL_UPDATE);
	vpw->proc_mode = VPW_PROC_MODE_MAIN;

	GF_Disp_DispOn();
	GF_Disp_GX_VisibleControl(GX_PLANEMASK_OBJ, VISIBLE_ON);
	GF_Disp_GXS_VisibleControl(GX_PLANEMASK_OBJ, VISIBLE_ON);

	//TEhf[^[h(ReXg)
	Snd_DataSetByScene( SND_SCENE_CONTEST, SEQ_DP_CONTEST, 0 );
	Snd_Stop();
	Snd_BgmPlay(SEQ_CO_TEST);
	
	sys_VBlankFuncChange(VisualVBlank, vpw);
	return PROC_RES_FINISH;
}

//--------------------------------------------------------------
/**
 * @brief   vZX֐FC
 *
 * @param   proc		vZXf[^
 * @param   seq			V[PX
 *
 * @retval  
 */
//--------------------------------------------------------------
PROC_RESULT VisualProc_Main( PROC * proc, int * seq )
{
	VISUAL_PROC_WORK * vpw  = PROC_GetWork( proc );
	int ret;
	enum{
		SEQ_IN,
		SEQ_MAIN,
		SEQ_OUT,
	};
	
	contest_rand(vpw->consys);
	
	switch( *seq ){
	case SEQ_IN:
		if( IsFinishedBrightnessChg(MASK_DOUBLE_DISPLAY) ){
			*seq = SEQ_MAIN;
		}
		break;

	case SEQ_MAIN:
		if(ConTool_ServerMineCheck(vpw->consys) == TRUE){
			ret = VisualMainSeqTbl[vpw->tbl_seq_no](vpw, &vpw->local);
			if(ret == VSRET_NEXT || ret == VSRET_SELECT_SEQ){
				if(ret == VSRET_NEXT){
					vpw->tbl_seq_no++;
				}
				else{
					vpw->tbl_seq_no = vpw->local.select_seq;
				}
				MI_CpuClear8(&vpw->local, sizeof(VISUAL_LOCAL_WORK));
			}
			else if(ret == VSRET_END){
				*seq = SEQ_OUT;
				MI_CpuClear8(&vpw->local, sizeof(VISUAL_LOCAL_WORK));
				break;
			}
		}
		
		CO_TransmitCheckExe(&vpw->cow);
		CO_RecieveCheckExe(&vpw->cow, vpw);

		if(vpw->main_end == TRUE){
			*seq = SEQ_OUT;
			MI_CpuClear8(&vpw->local, sizeof(VISUAL_LOCAL_WORK));
		}
		break;

	case SEQ_OUT:
		if(IsFinishedBrightnessChg(MASK_DOUBLE_DISPLAY)){
			return PROC_RES_FINISH;
		}
		break;
	}

	return PROC_RES_CONTINUE;
}

//--------------------------------------------------------------
/**
 * @brief   vZX֐FI
 *
 * @param   proc		vZXf[^
 * @param   seq			V[PX
 *
 * @retval  
 */
//--------------------------------------------------------------
PROC_RESULT VisualProc_End( PROC * proc, int * seq )
{
	VISUAL_PROC_WORK * vpw = PROC_GetWork( proc );
	int i;

	Particle_SystemExitAll();

	//풓OBJ폜
	VisualDefaultOBJDel(vpw);
	VisualDefaultOBJDel_Sub(vpw);
	//풓BG폜
	VisualDefaultBGDel(vpw);
	VisualDefaultBGDel_Sub(vpw);

	//BMPJ
	for(i = 0; i < VISUAL_BMPWIN_MAX; i++){
		GF_BGL_BmpWinDel(&vpw->sys.win[i]);
	}

	//CBG폜
	GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG0, VISIBLE_OFF );
	GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG1, VISIBLE_OFF );
	GF_BGL_BGControlExit(vpw->sys.bgl, VISUAL_FRAME_WIN );
	GF_BGL_BGControlExit(vpw->sys.bgl, VISUAL_FRAME_EFF );
	GF_BGL_BGControlExit(vpw->sys.bgl, VISUAL_FRAME_BACKGROUND );
	//TuBG폜
	GF_BGL_VisibleSet(VISUAL_FRAME_SUB_AUDIENCE, VISIBLE_OFF);
	GF_BGL_BGControlExit(vpw->sys.bgl, VISUAL_FRAME_SUB_AUDIENCE);

	//AN^[VXe폜
	CATS_ResourceDestructor_S(vpw->sys.csp,vpw->sys.crp);
	CATS_FreeMemory(vpw->sys.csp);

	//Vram]}l[W[폜
	DellVramTransferManager();

	//\tgEFAXvCg폜
	VT_SoftSpriteDelAll(&vpw->sys);
	VT_TrainerDel(vpw);
	SoftSpriteEnd(vpw->sys.soft_sprite);

	//bZ[W}l[W̍폜
//	MSGMAN_Delete(vpw->fight_msg);

	//tHg폜
	FontProc_UnloadFont(FONT_BUTTON);

	//pbgtF[hVXe폜
	PaletteFadeWorkAllocFree(vpw->sys.pfd, FADE_MAIN_BG);
	PaletteFadeWorkAllocFree(vpw->sys.pfd, FADE_SUB_BG);
	PaletteFadeWorkAllocFree(vpw->sys.pfd, FADE_MAIN_OBJ);
	PaletteFadeWorkAllocFree(vpw->sys.pfd, FADE_SUB_OBJ);
	PaletteFadeFree(vpw->sys.pfd);

	//bZ[W}l[W̍폜
	WORDSET_Delete(vpw->sys.wordset);
	STRBUF_Delete(vpw->sys.msg_buf);
	MSGMAN_Delete(vpw->sys.visual_msg);

	//BGLJ
	sys_FreeMemoryEz(vpw->sys.bgl);

	TCB_Delete(vpw->update_tcb);

	StopTP();		//^b`pl̏I

	PROC_FreeWork(proc);				// [NJ
	
	simple_3DBGExit();
	
	sys_VBlankFuncChange( NULL, NULL );		// VBlankZbg
	sys_HBlankIntrStop();	//HBlank荞ݒ~

	sys_DeleteHeap(HEAPID_VISUAL);

	Overlay_UnloadID(FS_OVERLAY_ID(bc_common));
	return PROC_RES_FINISH;
}

//--------------------------------------------------------------
/**
 * @brief	VBLANK֐
 *
 * @param	work	
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
static void VisualVBlank(void *work)
{
	VISUAL_PROC_WORK *vpw = work;
	
	SoftSpriteTextureTrans(vpw->sys.soft_sprite);

	DoVramTransferManager();	// Vram]}l[W[s
	CATS_RenderOamTrans();
	PaletteFadeTrans(vpw->sys.pfd);

	GF_BGL_VBlankFunc(vpw->sys.bgl);
	
	OS_SetIrqCheckFlag( OS_IE_V_BLANK);
}

//--------------------------------------------------------------
/**
 * @brief   C[v̍ŌɍsVXe֘A̍XV
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		vpw
 */
//--------------------------------------------------------------
static void VisualUpdate(TCB_PTR tcb, void *work)
{
	VISUAL_PROC_WORK *vpw = work;
	
	if(vpw->proc_mode == VPW_PROC_MODE_MAIN){
		SoftSpriteMain(vpw->sys.soft_sprite);
		BattleParticle_Main();
		CATS_Draw(vpw->sys.crp);
		CATS_UpdateTransfer();
		G3_SwapBuffers(GX_SORTMODE_MANUAL, GX_BUFFERMODE_Z);
	}
}

//--------------------------------------------------------------
/**
 * @brief   VramoNݒs
 *
 * @param   bgl		BGLf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void VisualSys_VramBankSet(GF_BGL_INI *bgl)
{
	GF_Disp_GX_VisibleControlInit();

	//VRAMݒ
	{
		GF_BGL_DISPVRAM vramSetTable = {
			GX_VRAM_BG_128_C,				// C2DGWBG
			GX_VRAM_BGEXTPLTT_NONE,			// C2DGWBGgpbg
			GX_VRAM_SUB_BG_32_H,			// Tu2DGWBG
			GX_VRAM_SUB_BGEXTPLTT_NONE,		// Tu2DGWBGgpbg
			GX_VRAM_OBJ_64_E,				// C2DGWOBJ
			GX_VRAM_OBJEXTPLTT_NONE,		// C2DGWOBJgpbg
			GX_VRAM_SUB_OBJ_16_I,			// Tu2DGWOBJ
			GX_VRAM_SUB_OBJEXTPLTT_NONE,	// Tu2DGWOBJgpbg
			GX_VRAM_TEX_01_AB,				// eNX`C[WXbg
			GX_VRAM_TEXPLTT_01_FG			// eNX`pbgXbg
		};
		GF_Disp_SetBank( &vramSetTable );

		//VRAMNA
		MI_CpuClear32((void*)HW_BG_VRAM, HW_BG_VRAM_SIZE);
		MI_CpuClear32((void*)HW_DB_BG_VRAM, HW_DB_BG_VRAM_SIZE);
		MI_CpuClear32((void*)HW_OBJ_VRAM, HW_OBJ_VRAM_SIZE);
		MI_CpuClear32((void*)HW_DB_OBJ_VRAM, HW_DB_OBJ_VRAM_SIZE);
	}

	// BG SYSTEM
	{
		GF_BGL_SYS_HEADER BGsys_data = {
			GX_DISPMODE_GRAPHICS, GX_BGMODE_0, GX_BGMODE_0, GX_BG0_AS_3D,
		};
		GF_BGL_InitBG( &BGsys_data );
	}

	//Cʃt[ݒ
	{
		GF_BGL_BGCNT_HEADER TextBgCntDat[] = {
			///<FRAME1_M	EBhE
			{
				0, 0, 0x1000, 0, GF_BGL_SCRSIZ_512x256, GX_BG_COLORMODE_16,
//				0, 0, 0x0800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
				GX_BG_SCRBASE_0x0000, GX_BG_CHARBASE_0x0c000, GX_BG_EXTPLTT_01,
				VISUAL_BGPRI_WIN, 0, 0, FALSE
			},
			///<FRAME2_M	GtFNg
			{
				0, 0, 0x2000, 0, GF_BGL_SCRSIZ_512x512, GX_BG_COLORMODE_16,
				GX_BG_SCRBASE_0x1000, GX_BG_CHARBASE_0x14000, GX_BG_EXTPLTT_01,
				VISUAL_BGPRI_EFF, 0, 0, FALSE
			},
			///<FRAME3_M	wi
			{
				0, 0, 0x1000, 0, GF_BGL_SCRSIZ_512x256, GX_BG_COLORMODE_16,
				GX_BG_SCRBASE_0x3000, GX_BG_CHARBASE_0x04000, GX_BG_EXTPLTT_01,
				VISUAL_BGPRI_SUB_AUDIENCE, 0, 0, FALSE
			},
		};
		GF_BGL_BGControlSet(bgl, VISUAL_FRAME_WIN, &TextBgCntDat[0], GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear(bgl, VISUAL_FRAME_WIN );
		GF_BGL_ScrollSet(bgl, VISUAL_FRAME_WIN, GF_BGL_SCROLL_X_SET, 0);
		GF_BGL_ScrollSet(bgl, VISUAL_FRAME_WIN, GF_BGL_SCROLL_Y_SET, 0);
		GF_BGL_BGControlSet(bgl, VISUAL_FRAME_EFF, &TextBgCntDat[1], GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear(bgl, VISUAL_FRAME_EFF );
		GF_BGL_ScrollSet(bgl, VISUAL_FRAME_EFF, GF_BGL_SCROLL_X_SET, 0);
		GF_BGL_ScrollSet(bgl, VISUAL_FRAME_EFF, GF_BGL_SCROLL_Y_SET, 0);
		GF_BGL_BGControlSet(bgl, VISUAL_FRAME_BACKGROUND, &TextBgCntDat[2], GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear(bgl, VISUAL_FRAME_BACKGROUND );
		GF_BGL_ScrollSet(bgl, VISUAL_FRAME_BACKGROUND, GF_BGL_SCROLL_X_SET, 0);
		GF_BGL_ScrollSet(bgl, VISUAL_FRAME_BACKGROUND, GF_BGL_SCROLL_Y_SET, 0);

		G2_SetBG0Priority(VISUAL_3DBG_PRIORITY);
		GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG0, VISIBLE_ON );
	}
	//Tuʃt[ݒ
	{
		GF_BGL_BGCNT_HEADER SubBgCntDat[] = {
			///<FRAME0_S	ϋq
			{
				0, 0, 0x0800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
				GX_BG_SCRBASE_0x7800, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_01,
				VISUAL_BGPRI_SUB_AUDIENCE, 0, 0, FALSE
			},
		};
		GF_BGL_BGControlSet(bgl, VISUAL_FRAME_SUB_AUDIENCE, &SubBgCntDat[0], GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear(bgl, VISUAL_FRAME_SUB_AUDIENCE );
		GF_BGL_ScrollSet(bgl, VISUAL_FRAME_SUB_AUDIENCE, GF_BGL_SCROLL_X_SET, 0);
		GF_BGL_ScrollSet(bgl, VISUAL_FRAME_SUB_AUDIENCE, GF_BGL_SCROLL_Y_SET, 0);
	}
}

//--------------------------------------------------------------
/**
 * @brief   BMPEBhEݒ肷
 *
 * @param   vpw		rWAǗ[Nւ̃|C^
 */
//--------------------------------------------------------------
static void VisualSys_DefaultBmpWinAdd(VISUAL_PROC_WORK *vpw)
{
	GF_BGL_BmpWinAdd(vpw->sys.bgl, &vpw->sys.win[VISUAL_BMPWIN_TALK], VISUAL_FRAME_WIN, 
		0x02,0x13,27,4, BMPWIN_TALK_COLOR, BMPWIN_TALK_CGX_OFFSET);
}

//--------------------------------------------------------------
/**
 * @brief   rWApp[eBN
 */
//--------------------------------------------------------------
static void VisualParticleInit(void)
{
	//--------------------------------------------------------------
	//	
	//--------------------------------------------------------------
	// }l[WeNX`C[WXbgwXbgǗł悤ɂ
	// ftHg}l[WɂB
	NNS_GfdInitFrmTexVramManager(2, TRUE);
		
	// }l[Wpbg32KBǗł悤ɂ
	// ftHg}l[WɂB
	NNS_GfdInitFrmPlttVramManager(0x8000, TRUE);

	//|PŎgp镪m
	NNS_GfdAllocFrmTexVram(0x4000, 0, 0);
	NNS_GfdAllocFrmPlttVram(0x20 * 4, 0, NNS_GFD_ALLOC_FROM_LOW);

	//p[eBNVXe[N
	Particle_SystemWorkInit();
}

//--------------------------------------------------------------
/**
 * @brief   rWAǗ[N̏p[^Zbg
 * @param   vpw		rWAǗ[Nւ̃|C^
 */
//--------------------------------------------------------------
static void VisualSystemWorkInit(VISUAL_PROC_WORK *vpw)
{
	int i;
	
	GF_ASSERT(vpw->consys != NULL);
	
	for(i = 0; i < BREEDER_MAX; i++){
		vpw->v_game.breeder_sort[i] = BREEDER_MAX - 1 - i;
	}

	VisualOrder_WorkInit(vpw);
}

//--------------------------------------------------------------
/**
 * @brief   rWAŎgp{Iȏ풓OBJ̓o^s
 * @param   vpw		rWAǗ[Nւ̃|C^
 */
//--------------------------------------------------------------
static void VisualDefaultOBJSet(VISUAL_PROC_WORK *vpw)
{
	//풓OBJpbg[h
	CATS_LoadResourcePlttWorkArc(vpw->sys.pfd, FADE_MAIN_OBJ, vpw->sys.csp, vpw->sys.crp, 
		ARC_CONTEST_OBJ, CONTEST_VISUAL_OBJ_NCLR, 0, 
		VISUAL_COMMON_PAL_NUM, NNS_G2D_VRAM_TYPE_2DMAIN, V_PLTTID_OBJ_COMMON);
	
	VT_AudienceHeartResourceLoad(vpw->sys.csp, vpw->sys.crp);
	
	VT_FlowerResourceLoad(vpw->sys.csp, vpw->sys.crp);
	VT_FlowerActorAddAll(vpw);
}

//--------------------------------------------------------------
/**
 * @brief   rWAŎgp{Iȏ풓OBJ̍폜s
 * @param   vpw		rWAǗ[Nւ̃|C^
 */
//--------------------------------------------------------------
static void VisualDefaultOBJDel(VISUAL_PROC_WORK *vpw)
{
	VT_AudienceHeartResourceFree(vpw->sys.crp);
	
	VT_FlowerActorDelAll(vpw);
	VT_FlowerResourceFree(vpw->sys.crp);
	
	//풓OBJpbg
	CATS_FreeResourcePltt(vpw->sys.crp, V_PLTTID_OBJ_COMMON);
}

//--------------------------------------------------------------
/**
 * @brief   TuOBJFrWAŎgp{Iȏ풓OBJ̓o^s
 * @param   vpw		rWAǗ[Nւ̃|C^
 */
//--------------------------------------------------------------
static void VisualDefaultOBJSet_Sub(VISUAL_PROC_WORK *vpw)
{
	//풓OBJpbg[h
	CATS_LoadResourcePlttWorkArc(vpw->sys.pfd, FADE_SUB_OBJ, vpw->sys.csp, vpw->sys.crp, 
		ARC_CONTEST_OBJ, CONTEST_VISUAL_SUB_OBJ_NCLR, 0, 
		VISUAL_SUB_COMMON_PAL_NUM, NNS_G2D_VRAM_TYPE_2DSUB, V_PLTTID_OBJ_COMMON_SUB);
}

//--------------------------------------------------------------
/**
 * @brief   TuOBJFrWAŎgp{Iȏ풓OBJ̍폜s
 * @param   vpw		rWAǗ[Nւ̃|C^
 */
//--------------------------------------------------------------
static void VisualDefaultOBJDel_Sub(VISUAL_PROC_WORK *vpw)
{
	//풓OBJpbg
	CATS_FreeResourcePltt(vpw->sys.crp, V_PLTTID_OBJ_COMMON_SUB);
}

//--------------------------------------------------------------
/**
 * @brief   CBGFrWAŎgp{BGf[^̃Zbgs
 * @param   vpw		rWAǗ[Nւ̃|C^
 */
//--------------------------------------------------------------
static void VisualDefaultBGSet(VISUAL_PROC_WORK *vpw)
{
	//LN^
	ArcUtil_BgCharSet(ARC_CONTEST_BG, CON_VISUAL_BG_NCGR_BIN, vpw->sys.bgl, 
		VISUAL_FRAME_BACKGROUND, 0, 0, 1, HEAPID_VISUAL);
	//XN[
	ArcUtil_ScrnSet(ARC_CONTEST_BG, CON_VISUAL_BG_NSCR_BIN, vpw->sys.bgl, 
		VISUAL_FRAME_BACKGROUND, 0, 0, 1, HEAPID_VISUAL);
	GF_BGL_ScrClear(vpw->sys.bgl, VISUAL_FRAME_WIN);

	//pbg
	PaletteWorkSet_Arc(vpw->sys.pfd, ARC_CONTEST_BG, CONTEST_VISUAL_BG_NCLR, 
		HEAPID_VISUAL, FADE_MAIN_BG, 0, 0);
	//tHgppbg
	PaletteWorkSet_Arc(vpw->sys.pfd, ARC_CONTEST_BG, CON_BG_FONT_NCLR, 
		HEAPID_VISUAL, FADE_MAIN_BG, 0x20, BMPWIN_TALK_COLOR * 16);


	//bEBhE
	TalkWinGraphicSet(vpw->sys.bgl, VISUAL_FRAME_WIN, VISUAL_TALKWIN_CGX_OFFSET, 
		VISUAL_TALKWIN_BACK_COLOR, VISUAL_TALKWIN_WIN_NO, HEAPID_VISUAL);
	PaletteWorkSet_Arc(vpw->sys.pfd, ARC_WINFRAME, TalkWinPalArcGet(VISUAL_TALKWIN_WIN_NO), 
		HEAPID_VISUAL, FADE_MAIN_BG, 0x20, VISUAL_TALKWIN_PALNO * 16);

	//ǂ񂿂傤
	ArcUtil_BgCharSet(ARC_CONTEST_BG, DONTYOU_ANIM_NCGR_BIN, vpw->sys.bgl, 
		VISUAL_FRAME_EFF, 0, 0, 1, HEAPID_VISUAL);
	ArcUtil_ScrnSet(ARC_CONTEST_BG, CON_VISUAL_DONCHOU_NSCR_BIN, vpw->sys.bgl, 
		VISUAL_FRAME_EFF, 0, 0, 1, HEAPID_VISUAL);
	PaletteWorkSet_Arc(vpw->sys.pfd, ARC_CONTEST_BG, DONTYOU_ANIM_NCLR, 
		HEAPID_VISUAL, FADE_MAIN_BG, 0x20, DONTYOU_PALNO * 16);
}

//--------------------------------------------------------------
/**
 * @brief   CBGFrWAŎgp{BGf[^̍폜s
 * @param   vpw		rWAǗ[Nւ̃|C^
 */
//--------------------------------------------------------------
static void VisualDefaultBGDel(VISUAL_PROC_WORK *vpw)
{
	return;
}

//--------------------------------------------------------------
/**
 * @brief   TuBGFrWAŎgp{BGf[^̃Zbgs
 * @param   vpw		rWAǗ[Nւ̃|C^
 */
//--------------------------------------------------------------
static void VisualDefaultBGSet_Sub(VISUAL_PROC_WORK *vpw)
{
	//LN^
	ArcUtil_BgCharSet(ARC_CONTEST_BG, CON_VISUAL_SUB_BG_NCGR_BIN, vpw->sys.bgl, 
		VISUAL_FRAME_SUB_AUDIENCE, 0, 0, 1, HEAPID_VISUAL);
	//XN[
	ArcUtil_ScrnSet(ARC_CONTEST_BG, CON_VISUAL__SUB_BG_NSCR_BIN, vpw->sys.bgl, 
		VISUAL_FRAME_SUB_AUDIENCE, 0, 0, 1, HEAPID_VISUAL);

	//pbg
	PaletteWorkSet_Arc(vpw->sys.pfd, ARC_CONTEST_BG, CONTEST_VISUAL_SUB_BG_NCLR, 
		HEAPID_VISUAL, FADE_SUB_BG, 0, 0);
}

//--------------------------------------------------------------
/**
 * @brief   TuBGFrWAŎgp{BGf[^̍폜s
 * @param   vpw		rWAǗ[Nւ̃|C^
 */
//--------------------------------------------------------------
static void VisualDefaultBGDel_Sub(VISUAL_PROC_WORK *vpw)
{
}




//==============================================================================
//
//	V[PX
//
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   rWAV[PXF
 *
 * @param   vpw			rWAǗ[Nւ̃|C^
 * @param   local		[J[Nւ̃|C^
 *
 * @retval  ptO
 */
//--------------------------------------------------------------
static int VisualSeq_Init(VISUAL_PROC_WORK *vpw, VISUAL_LOCAL_WORK *local)
{
	switch(local->seq){
	case 0:
		//VT_SoftSpriteAddAll(&vpw->sys);
//		if(CO_OrderSet(vpw, AORDER_NO_POKEMON_SPRITE_ADD_ALL, NULL) == TRUE){
			local->seq++;
//		}
		break;
	default:
//		if(CO_RequestBitNumCheck(vpw) == 0){
//		if(CO_AnswerCountCheck(&vpw->cow, vpw->consys->c_game.player_num, vpw->consys->c_game.my_breeder_no, vpw->consys->c_game.server_no) == TRUE){
			return VSRET_NEXT;
//		}
		break;
	}
	return VSRET_CONTINUE;
}

//--------------------------------------------------------------
/**
 * @brief   rWAV[PXFR̍ŏ̉b
 *
 * @param   vpw			rWAǗ[Nւ̃|C^
 * @param   local		[J[Nւ̃|C^
 *
 * @retval  ptO
 */
//--------------------------------------------------------------
static int VisualSeq_JudgeFastTalk(VISUAL_PROC_WORK *vpw, VISUAL_LOCAL_WORK *local)
{
	
	switch(local->seq){
	case 0:
		vpw->advance.a_talk_id = A_TALK_VISUAL_HOST_01;
		vpw->advance.a_talk_bmpwin_close_wait = CONTEST_MESSAGE_END_WAIT;
		vpw->advance.a_talk_bmpwin_not_close = 0;
		if(CO_OrderSet(&vpw->cow, vpw, VORDER_NO_TALK, &vpw->advance) == TRUE){
			local->seq++;
		}
		break;
	default:
//		if(CO_RequestBitNumCheck(&vpw->cow) == 0){
		if(CO_AnswerCountCheck(&vpw->cow, vpw->consys->c_game.player_num, 
				vpw->consys->c_game.my_breeder_no, vpw->consys->c_game.server_no) == TRUE){
			return VSRET_NEXT;
		}
		break;
	}
	return VSRET_CONTINUE;
}

//--------------------------------------------------------------
/**
 * @brief   rWAV[PXF|PI
 *
 * @param   vpw			rWAǗ[Nւ̃|C^
 * @param   local		[J[Nւ̃|C^
 *
 * @retval  ptO
 */
//--------------------------------------------------------------
static int VisualSeq_PokeSelect(VISUAL_PROC_WORK *vpw, VISUAL_LOCAL_WORK *local)
{
	
	switch(local->seq){
	case 0:
		vpw->advance.now_breeder = vpw->v_game.breeder_sort[vpw->v_game.breeder_end_count];
		if(CO_OrderSet(&vpw->cow, vpw, VORDER_NO_SAMPLE, &vpw->advance) == TRUE){
			local->seq++;
		}
		break;
	default:
//		if(CO_RequestBitNumCheck(&vpw->cow) == 0){
		if(CO_AnswerCountCheck(&vpw->cow, vpw->consys->c_game.player_num, 
				vpw->consys->c_game.my_breeder_no, vpw->consys->c_game.server_no) == TRUE){
			return VSRET_NEXT;
		}
		break;
	}
	return VSRET_CONTINUE;
}

//--------------------------------------------------------------
/**
 * @brief   rWAV[PXF|Po
 *
 * @param   vpw			rWAǗ[Nւ̃|C^
 * @param   local		[J[Nւ̃|C^
 *
 * @retval  ptO
 */
//--------------------------------------------------------------
static int VisualSeq_Appear(VISUAL_PROC_WORK *vpw, VISUAL_LOCAL_WORK *local)
{
	switch(local->seq){
	case 0:
		if(CO_OrderSet(&vpw->cow, vpw, VORDER_NO_APPEAR, &vpw->advance) == TRUE){
			local->seq++;
		}
		break;
	default:
//		if(CO_RequestBitNumCheck(&vpw->cow) == 0){
		if(CO_AnswerCountCheck(&vpw->cow, vpw->consys->c_game.player_num, 
				vpw->consys->c_game.my_breeder_no, vpw->consys->c_game.server_no) == TRUE){
			return VSRET_NEXT;
		}
		break;
	}
	return VSRET_CONTINUE;
}

//--------------------------------------------------------------
/**
 * @brief   rWAV[PXFǂ񂿂傤グ
 *
 * @param   vpw			rWAǗ[Nւ̃|C^
 * @param   local		[J[Nւ̃|C^
 *
 * @retval  ptO
 */
//--------------------------------------------------------------
static int VisualSeq_DonchouUp(VISUAL_PROC_WORK *vpw, VISUAL_LOCAL_WORK *local)
{
	switch(local->seq){
	case 0:
		if(CO_OrderSet(&vpw->cow, vpw, VORDER_NO_DONCHOU_UP, &vpw->advance) == TRUE){
			local->seq++;
		}
		break;
	default:
//		if(CO_RequestBitNumCheck(&vpw->cow) == 0){
		if(CO_AnswerCountCheck(&vpw->cow, vpw->consys->c_game.player_num, 
				vpw->consys->c_game.my_breeder_no, vpw->consys->c_game.server_no) == TRUE){
			return VSRET_NEXT;
		}
		break;
	}
	return VSRET_CONTINUE;
}

//--------------------------------------------------------------
/**
 * @brief   rWAV[PXFg[i[o
 *
 * @param   vpw			rWAǗ[Nւ̃|C^
 * @param   local		[J[Nւ̃|C^
 *
 * @retval  ptO
 */
//--------------------------------------------------------------
static int VisualSeq_TrainerIn(VISUAL_PROC_WORK *vpw, VISUAL_LOCAL_WORK *local)
{
	switch(local->seq){
	case 0:
		if(CO_OrderSet(&vpw->cow, vpw, VORDER_NO_TRAINER_IN, &vpw->advance) == TRUE){
			local->seq++;
		}
		break;
	default:
//		if(CO_RequestBitNumCheck(&vpw->cow) == 0){
		if(CO_AnswerCountCheck(&vpw->cow, vpw->consys->c_game.player_num, 
				vpw->consys->c_game.my_breeder_no, vpw->consys->c_game.server_no) == TRUE){
			return VSRET_NEXT;
		}
		break;
	}
	return VSRET_CONTINUE;
}

//--------------------------------------------------------------
/**
 * @brief   rWAV[PXFЉbZ[W
 *
 * @param   vpw			rWAǗ[Nւ̃|C^
 * @param   local		[J[Nւ̃|C^
 *
 * @retval  ptO
 */
//--------------------------------------------------------------
static int VisualSeq_IntroduceTalk(VISUAL_PROC_WORK *vpw, VISUAL_LOCAL_WORK *local)
{
	switch(local->seq){
	case 0:
		switch(vpw->v_game.breeder_end_count){
		case 0:
			vpw->advance.a_talk_id = A_TALK_VISUAL_HOST_02;
			break;
		case 1:
			vpw->advance.a_talk_id = A_TALK_VISUAL_HOST_03;
			break;
		case 2:
			vpw->advance.a_talk_id = A_TALK_VISUAL_HOST_04;
			break;
		default:
			vpw->advance.a_talk_id = A_TALK_VISUAL_HOST_05;
			break;
		}
		vpw->advance.a_talk_bmpwin_close_wait = CONTEST_MESSAGE_END_WAIT;
		vpw->advance.a_talk_bmpwin_not_close = 0;
		vpw->advance.a_talk_tagpara.mine_brd = vpw->advance.now_breeder;
		local->seq++;
		//break;
	case 1:
		if(CO_OrderSet(&vpw->cow, vpw, VORDER_NO_TALK, &vpw->advance) == TRUE){
			local->seq++;
		}
		break;
	default:
//		if(CO_RequestBitNumCheck(&vpw->cow) == 0){
		if(CO_AnswerCountCheck(&vpw->cow, vpw->consys->c_game.player_num, 
				vpw->consys->c_game.my_breeder_no, vpw->consys->c_game.server_no) == TRUE){
			return VSRET_NEXT;
		}
		break;
	}
	return VSRET_CONTINUE;
}

//--------------------------------------------------------------
/**
 * @brief   rWAV[PXF|PoGtFNg
 *
 * @param   vpw			rWAǗ[Nւ̃|C^
 * @param   local		[J[Nւ̃|C^
 *
 * @retval  ptO
 */
//--------------------------------------------------------------
static int VisualSeq_AppearEffect(VISUAL_PROC_WORK *vpw, VISUAL_LOCAL_WORK *local)
{
	switch(local->seq){
	case 0:
		if(CO_OrderSet(&vpw->cow, vpw, VORDER_NO_APPEAR_EFFECT, &vpw->advance) == TRUE){
			local->seq++;
		}
		break;
	default:
//		if(CO_RequestBitNumCheck(&vpw->cow) == 0){
		if(CO_AnswerCountCheck(&vpw->cow, vpw->consys->c_game.player_num, 
				vpw->consys->c_game.my_breeder_no, vpw->consys->c_game.server_no) == TRUE){
			return VSRET_NEXT;
		}
		break;
	}
	return VSRET_CONTINUE;
}

//--------------------------------------------------------------
/**
 * @brief   rWAV[PXFg[i[ޏ
 *
 * @param   vpw			rWAǗ[Nւ̃|C^
 * @param   local		[J[Nւ̃|C^
 *
 * @retval  ptO
 */
//--------------------------------------------------------------
static int VisualSeq_TrainerOut(VISUAL_PROC_WORK *vpw, VISUAL_LOCAL_WORK *local)
{
	switch(local->seq){
	case 0:
		if(CO_OrderSet(&vpw->cow, vpw, VORDER_NO_TRAINER_OUT, &vpw->advance) == TRUE){
			local->seq++;
		}
		break;
	default:
//		if(CO_RequestBitNumCheck(&vpw->cow) == 0){
		if(CO_AnswerCountCheck(&vpw->cow, vpw->consys->c_game.player_num, 
				vpw->consys->c_game.my_breeder_no, vpw->consys->c_game.server_no) == TRUE){
			return VSRET_NEXT;
		}
		break;
	}
	return VSRET_CONTINUE;
}

//--------------------------------------------------------------
/**
 * @brief   rWAV[PXF|POi
 *
 * @param   vpw			rWAǗ[Nւ̃|C^
 * @param   local		[J[Nւ̃|C^
 *
 * @retval  ptO
 */
//--------------------------------------------------------------
static int VisualSeq_Advance(VISUAL_PROC_WORK *vpw, VISUAL_LOCAL_WORK *local)
{
	switch(local->seq){
	case 0:
		if(CO_OrderSet(&vpw->cow, vpw, VORDER_NO_ADVANCE, &vpw->advance) == TRUE){
			local->seq++;
		}
		break;
	default:
//		if(CO_RequestBitNumCheck(&vpw->cow) == 0){
		if(CO_AnswerCountCheck(&vpw->cow, vpw->consys->c_game.player_num, 
				vpw->consys->c_game.my_breeder_no, vpw->consys->c_game.server_no) == TRUE){
			return VSRET_NEXT;
		}
		break;
	}
	return VSRET_CONTINUE;
}

//--------------------------------------------------------------
/**
 * @brief   rWAV[PXFϋq]
 *
 * @param   vpw			rWAǗ[Nւ̃|C^
 * @param   local		[J[Nւ̃|C^
 *
 * @retval  ptO
 */
//--------------------------------------------------------------
static int VisualSeq_AudienceEvaluate(VISUAL_PROC_WORK *vpw, VISUAL_LOCAL_WORK *local)
{
	switch(local->seq){
	case 0:
		vpw->advance.evaluate_heart_num = contest_rand(vpw->consys) % 20;
		if(CO_OrderSet(&vpw->cow, vpw, VORDER_NO_AUDIENCE_EVALUATE, &vpw->advance) == TRUE){
			local->seq++;
		}
		break;
	default:
//		if(CO_RequestBitNumCheck(&vpw->cow) == 0){
		if(CO_AnswerCountCheck(&vpw->cow, vpw->consys->c_game.player_num, 
				vpw->consys->c_game.my_breeder_no, vpw->consys->c_game.server_no) == TRUE){
			return VSRET_NEXT;
		}
		break;
	}
	return VSRET_CONTINUE;
}

//--------------------------------------------------------------
/**
 * @brief   rWAV[PXF|Pޏ
 *
 * @param   vpw			rWAǗ[Nւ̃|C^
 * @param   local		[J[Nւ̃|C^
 *
 * @retval  ptO
 */
//--------------------------------------------------------------
static int VisualSeq_PokeOut(VISUAL_PROC_WORK *vpw, VISUAL_LOCAL_WORK *local)
{
	switch(local->seq){
	case 0:
		if(CO_OrderSet(&vpw->cow, vpw, VORDER_NO_POKE_OUT, &vpw->advance) == TRUE){
			local->seq++;
		}
		break;
	default:
//		if(CO_RequestBitNumCheck(&vpw->cow) == 0){
		if(CO_AnswerCountCheck(&vpw->cow, vpw->consys->c_game.player_num, 
				vpw->consys->c_game.my_breeder_no, vpw->consys->c_game.server_no) == TRUE){
			return VSRET_NEXT;
		}
		break;
	}
	return VSRET_CONTINUE;
}

//--------------------------------------------------------------
/**
 * @brief   rWAV[PXFǂ񂿂傤
 *
 * @param   vpw			rWAǗ[Nւ̃|C^
 * @param   local		[J[Nւ̃|C^
 *
 * @retval  ptO
 */
//--------------------------------------------------------------
static int VisualSeq_DonchouDown(VISUAL_PROC_WORK *vpw, VISUAL_LOCAL_WORK *local)
{
	switch(local->seq){
	case 0:
		if(CO_OrderSet(&vpw->cow, vpw, VORDER_NO_DONCHOU_DOWN, &vpw->advance) == TRUE){
			local->seq++;
		}
		break;
	default:
//		if(CO_RequestBitNumCheck(&vpw->cow) == 0){
		if(CO_AnswerCountCheck(&vpw->cow, vpw->consys->c_game.player_num, 
				vpw->consys->c_game.my_breeder_no, vpw->consys->c_game.server_no) == TRUE){
			return VSRET_NEXT;
		}
		break;
	}
	return VSRET_CONTINUE;
}

//--------------------------------------------------------------
/**
 * @brief   rWAV[PXF̃|P֐iޑǑ㏈
 *
 * @param   vpw			rWAǗ[Nւ̃|C^
 * @param   local		[J[Nւ̃|C^
 *
 * @retval  ptO
 */
//--------------------------------------------------------------
static int VisualSeq_NextPoke(VISUAL_PROC_WORK *vpw, VISUAL_LOCAL_WORK *local)
{
	switch(local->seq){
	case 0:
		vpw->v_game.breeder_end_count++;
		local->seq++;
		break;
	default:
		if(vpw->v_game.breeder_end_count >= BREEDER_MAX){
			return VSRET_NEXT;
		}
		local->select_seq = VSEQ_POKE_SELECT;
		return VSRET_SELECT_SEQ;
	}
	return VSRET_CONTINUE;
}

//--------------------------------------------------------------
/**
 * @brief   rWAV[PXFrWAI鎞̃bZ[W\
 *
 * @param   vpw			rWAǗ[Nւ̃|C^
 * @param   local		[J[Nւ̃|C^
 *
 * @retval  ptO
 */
//--------------------------------------------------------------
static int VisualSeq_EndTalk(VISUAL_PROC_WORK *vpw, VISUAL_LOCAL_WORK *local)
{
	switch(local->seq){
	case 0:
		switch(vpw->consys->c_game.mode){
		case CONMODE_GRAND:
			vpw->advance.a_talk_id = A_TALK_VISUAL_HOST_06;
			break;
		case CONMODE_CHARM:
			vpw->advance.a_talk_id = A_TALK_VISUAL_HOST_07;
			break;
		default:
			GF_ASSERT(0 && "sȃReXg[hł");
			return VSRET_NEXT;
		}
		vpw->advance.a_talk_bmpwin_close_wait = CONTEST_MESSAGE_END_WAIT;
		vpw->advance.a_talk_bmpwin_not_close = 0;
		local->seq++;
		//break;
	case 1:
		if(CO_OrderSet(&vpw->cow, vpw, VORDER_NO_TALK, &vpw->advance) == TRUE){
			local->seq++;
		}
		break;
	default:
//		if(CO_RequestBitNumCheck(&vpw->cow) == 0){
		if(CO_AnswerCountCheck(&vpw->cow, vpw->consys->c_game.player_num, 
				vpw->consys->c_game.my_breeder_no, vpw->consys->c_game.server_no) == TRUE){
			return VSRET_NEXT;
		}
		break;
	}
	return VSRET_CONTINUE;
}

//--------------------------------------------------------------
/**
 * @brief   rWAV[PXFI
 *
 * @param   vpw			rWAǗ[Nւ̃|C^
 * @param   local		[J[Nւ̃|C^
 *
 * @retval  ptO
 */
//--------------------------------------------------------------
static int VisualSeq_End(VISUAL_PROC_WORK *vpw, VISUAL_LOCAL_WORK *local)
{
	switch(local->seq){
	case 0:
		if(CO_OrderSet(&vpw->cow, vpw, VORDER_NO_VISUAL_EXIT, NULL) == TRUE){
			local->seq++;
		}
		break;
	default:
//		if(CO_RequestBitNumCheck(&vpw->cow) == 0){
		if(CO_AnswerCountCheck(&vpw->cow, vpw->consys->c_game.player_num, 
				vpw->consys->c_game.my_breeder_no, vpw->consys->c_game.server_no) == TRUE){
			return VSRET_END;
		}
		break;
	}
	return VSRET_CONTINUE;
}

