//==============================================================================
/**
 * @file	visual.h
 * @brief	rWÃwb_
 * @author	matsuda
 * @date	2005.12.10(y)
 */
//==============================================================================
#ifndef __VISUAL_H__
#define __VISUAL_H__

#include "system/procsys.h"
#include "battle/battle_common.h"
#include "system/buflen.h"
#include "contest/contest.h"
#include "system/softsprite.h"
#include "system/fontproc.h"
#include "system/msgdata.h"
#include "system/gra_tool.h"
#include "system/clact_tool.h"
#include "system/wordset.h"
#include "contest_order.h"
#include "visual_snd_def.h"
#include "contest/visual_ex.h"



//==============================================================================
//	萔`
//==============================================================================
///ϋqɏon[g̐
#define VISUAL_AUDIENCE_HEART_MAX		(8)
///ԕ͗lAN^[̐
#define VISUAL_FLOWER_MAX				(6)


//--------------------------------------------------------------
//	obt@
//--------------------------------------------------------------
///obt@̃TCY
#define VISUAL_MESSAGE_BUF_SIZE	(2*160)		///<błPUO

//--------------------------------------------------------------
//	t[ԍFC
//--------------------------------------------------------------
///EBhEEplʂ̃t[
#define VISUAL_FRAME_WIN				(GF_BGL_FRAME1_M)
///GtFNgʂ̃t[
#define VISUAL_FRAME_EFF				(GF_BGL_FRAME2_M)
///ϋq(wi)ʂ̃t[
#define VISUAL_FRAME_BACKGROUND			(GF_BGL_FRAME3_M)

///<BGԍFEBhE
#define VISUAL_BGNO_WIN			(1)
///<BGԍFGtFNg
#define VISUAL_BGNO_EFF			(2)
///<BGԍFwi
#define VISUAL_BGNO_AUDIENCE	(3)

///<3DʂBGvCIeB
#define VISUAL_3DBG_PRIORITY		(2)
///EBhEʂBGvCIeB
#define VISUAL_BGPRI_WIN			(2)
///GtFNgʂBGvCIeB
#define VISUAL_BGPRI_EFF			(1)
///wiʂBGvCIeB
#define VISUAL_BGPRI_AUDIENCE		(3)

//--------------------------------------------------------------
//	t[ԍFTu
//--------------------------------------------------------------
///ϋqʂ̃t[
#define VISUAL_FRAME_SUB_AUDIENCE				(GF_BGL_FRAME0_S)

///<BGԍFϋq
#define VISUAL_BGNO_SUB_AUDIENCE			(0)

///ϋqʂBGvCIeB
#define VISUAL_BGPRI_SUB_AUDIENCE			(3)


//--------------------------------------------------------------
//	BMPEBhE
//--------------------------------------------------------------
enum{
	VISUAL_BMPWIN_TALK,		///<bEBhE
	
	VISUAL_BMPWIN_MAX,
};


//--------------------------------------------------------------
//	bEBhE
//--------------------------------------------------------------
///bEBhẼLN^]ItZbg(LN^P)
#define VISUAL_TALKWIN_CGX_OFFSET	(1)
///bEBhEwiF
#define VISUAL_TALKWIN_BACK_COLOR	(15)
///bEBhEŎgpEBhELN^p^[
#define VISUAL_TALKWIN_WIN_NO		(0)
///bEBhẼpbgԍ
#define VISUAL_TALKWIN_PALNO		(14)

//--------------------------------------------------------------
//	AN^[vCIeB
//--------------------------------------------------------------
///ԕ͗lBGvCIeB
#define V_FLOWER_BGPRI				(VISUAL_BGPRI_AUDIENCE)
///ԕ͗l̃\tgvCIeB
#define V_FLOWER_SOFTPRI			(200)
///ϋqn[gBGvCIeB
#define V_AUDIENCE_HEART_BGPRI		(1)
///ϋqn[g̃\tgvCIeB
#define V_AUDIENCE_HEART_SOFTPRI	(10)


//--------------------------------------------------------------
//	bZ[W^O
//--------------------------------------------------------------
///bZ[W^O
enum{
	VTAG_NONE,		///<^OȂ
	
	VTAG_OYA_NICK,
	
	VTAG_MAX,
};

//==============================================================================
//	\̒`
//==============================================================================
//--------------------------------------------------------------
//	bZ[W
//--------------------------------------------------------------
///Z僁bZ[Wf[^
typedef struct{
	u16 msg_id;				///<bZ[WID
	u8 msg_tag;				///<^OR[h
}VISUAL_MESSAGE_PARAM;

///bZ[W^OWJꍇAQƂp[^
typedef struct{
	u8 mine_brd;		///<MINEw肳ĂɎQƂu[_[̔ԍ
	u8 num;				///<NUMw肳Ăɕ\鐔l
	u8 judge_no;		///<JUDGEw肳ĂɎQƂR̔ԍ
	
	u8 dummy;	//4oCgEItZbg
}VTAG_PARAM;

//--------------------------------------------------------------
//	
//--------------------------------------------------------------
///CV[PXŎgp郍[J[N
typedef struct{
	u16 seq;
	u16 select_seq;
	s32 work;
}VISUAL_LOCAL_WORK;

//--------------------------------------------------------------
/**
 * @brief   rWAisp[^(݋ZoĂ|P̐isp[^)
 */
//--------------------------------------------------------------
typedef struct{
	u8 now_breeder;					///<ݏɏoĂu[_[̔ԍ
	u8 evaluate_heart_num;			///<ϋq\n[g̐

	VTAG_PARAM a_talk_tagpara;		///<m[}bF^OWJpp[^
	u8 a_talk_id;					///<m[}bID(A_TALK_VISUAL_???)
	u8 a_talk_bmpwin_close_wait;	///<bZ[W\ĂEBhE܂łwait
	u8 a_talk_bmpwin_not_close;		///<TRUE:EBhEɏI
}VISUAL_ADVANCE_PARAM;

//--------------------------------------------------------------
/**
 * @brief   rWAQ[isp[^
 *
 * ̃p[^ΑSʂč\zo邾̏񂪓Ă܂B
 * ʐM̓T[o[q@̓f[^󂯎鎖ɂȂ܂B
 * {IɃj[ʂ̉ʕÂ悤ȎȂA
 * X̎q@ŒlQƂ鎖͂Ȃ͂łB
 */
//--------------------------------------------------------------
typedef struct{
	u8 breeder_sort[BREEDER_MAX];	///<Zo(o鏇Ƀu[_[ԍĂ܂)
	u8 breeder_end_count;			///<sIu[_[̐JEg
	
	s16 bp[BREEDER_MAX];			///<lu[_[|Cg
}VISUAL_GAME_PARAM;

//--------------------------------------------------------------
/**
 * @brief   ߑMpp[^
 * 
 * T[o[Ƃ̖߂̑MɎgp܂
 */
//--------------------------------------------------------------
typedef struct{
	u8 breeder_no;
	
	u8 buffer[255];					///<e߂Ōʂɓnf[^ςꍇAgp
}VISUAL_ORDER_PARAM;

//--------------------------------------------------------------
/**
 * @brief   Q[ʂ\邽߂ɕKvȃVXef[^ނ\
 *
 * ʐMłSẴ}VŌʂɍ쐬܂
 * eX^btߎMÃ}VXŐ̃[Nobt@nɂȂ܂
 */
//--------------------------------------------------------------
typedef struct{
	CONTEST_GAME_PARAM *c_game;		///<ReXgisp[^(tŊɒʐMς݂̃f[^ւ̃|C^BQƗp)
	
	SOFT_SPRITE_MANAGER	*soft_sprite;
	SOFT_SPRITE *ss[BREEDER_MAX];
	SOFT_SPRITE *trainer_ss;
	CATS_SYS_PTR		csp;
	CATS_RES_PTR		crp;
	GF_BGL_INI *bgl;
	GF_BGL_BMPWIN win[VISUAL_BMPWIN_MAX];
	MSGDATA_MANAGER *visual_msg;	///<rWA僁bZ[WpbZ[W}l[W̃|C^
	WORDSET *wordset;
	STRBUF *msg_buf;				///<Allocobt@ւ̃|C^
	PALETTE_FADE_PTR pfd;			///<pbgtF[hVXeւ̃|C^

	EXCHR_PARAM exchr_param[BREEDER_MAX];		///<ZGtFNgpLWJobt@

	CATS_ACT_PTR heart_cap[VISUAL_AUDIENCE_HEART_MAX];	///<ϋqon[gAN^[̃|C^
	
	CATS_ACT_PTR flower_cap[VISUAL_FLOWER_MAX];			///<ԕ͗lAN^[̃|C^
	TCB_PTR flower_tcb;					///<ԕ͗l^XN

	u8 talk_msg_index;				///<`惋[`̃CfbNX
}VISUAL_SYSTEM_PARAM;

//--------------------------------------------------------------
/**
 * @brief   rWAǗ[N
 *
 * rWAŜǗ匳̃[NɂȂ܂B
 * ʐMłSẴ}VŌʂɍ쐬܂
 */
//--------------------------------------------------------------
typedef struct{
	CONTEST_SYSTEM *consys;			///<ReXgVXe[Nւ̃|C^
	TCB_PTR update_tcb;
	
	VISUAL_SYSTEM_PARAM sys;			///<rWAVXef[^p[^
	VISUAL_GAME_PARAM v_game;			///<Q[isp[^
	VISUAL_ADVANCE_PARAM advance;		///<isp[^
	VISUAL_ORDER_PARAM order[BREEDER_MAX];	///<߃p[^
	
	u16 seq;
	u16 tbl_seq_no;					///<CV[PXe[u̔ԍ
	u8 proc_mode;					///<݂̓

#if 0
	//-- Mobt@ --//
	u32 request_bit;				///<߂oĂrbg
	u8 transmit_buf[TRANSMIT_BUF_SIZE];	///<Mpobt@
	u8 receive_buf[RECEIVE_BUF_SIZE];	///<Mpobt@
	u8 transmit_flag;				///<TRUEFM҂B@FALSE:Vȃf[^Zbg\
	u8 receive_flag;				///<TRUEFf[^M
#endif
	CONTEST_ORDER_WORK cow;			///<M[N
	
	VISUAL_LOCAL_WORK local;			///<[J[N
	u8 main_end;					///<TRUE:CI
}VISUAL_PROC_WORK;


//==============================================================================
//	O֐錾
//==============================================================================
extern PROC_RESULT VisualProc_Init( PROC * proc, int * seq );
extern PROC_RESULT VisualProc_Main( PROC * proc, int * seq );
extern PROC_RESULT VisualProc_End( PROC * proc, int * seq );

//==============================================================================
//	Of[^錾
//==============================================================================
extern const PROC_DATA ContestVisualProcData;



#endif	//__VISUAL_H__

