//==============================================================================
/**
 * @file	visual_order.c
 * @brief	rWAFߑM
 * @author	matsuda
 * @date	2005.12.13()
 */
//==============================================================================
#include "common.h"
#include "contest/contest.h"
#include "battle/battle_common.h"
#include "contest_order.h"
#include "visual.h"
#include "visual_order.h"

#include "visual_tcb_pri.h"
#include "system/clact_tool.h"
#include "system/palanm.h"

#include "system/arc_tool.h"
#include "system/arc_util.h"

#include "system/softsprite.h"

#include "system/fontproc.h"
#include "system/msgdata.h"

#include "wazaeffect/battle_particle.h"
#include "system/particle.h"
#include "wazaeffect/we_mana.h"
#include "wazaeffect/we_sys.h"

#include "system/brightness.h"

#include "graphic/contest_bg_def.h"
#include "graphic/contest_obj_def.h"

#include "visual_tool.h"
#include "poketool/poke_tool.h"
#include "gflib/touchpanel.h"
#include "system/snd_tool.h"
#include "system/window.h"


//==============================================================================
//	萔`
//==============================================================================
///ǂ񂿂傤̏㏸x(8rbg)
#define DONCHOU_UP_SPEED			(3 << 8)
///ǂ񂿂傤ꂾXN[~(8rbg)
#define DONCHOU_STOP_SCROLL			(200 << 8)
///ǂ񂿂傤̉~x(8rbg)
#define DONCHOU_DOWN_SPEED			(-(DONCHOU_UP_SPEED))

///ǂ񂿂傤AjEFCg
#define DONCHOU_ANM_WAIT		(1)
///ǂ񂿂傤1iAjI閈ɂAjEFCg
#define DONCHOU_DANSA_ANM_WAIT		(0)
///ǂ񂿂傤̃Aj]p̃LN^ɉLĂ邩
#define DONCHOU_ANM_DATA_X_LEN	(8)
///ǂ񂿂傤̃Aj]p̃LN^cɉLĂ邩
#define DONCHOU_ANM_DATA_Y_LEN	(4)

///g[i[oꑬx(8rbg)
#define TRAINER_IN_SPEED_X		(0x0400)
///g[i[ޏꑬx(8rbg)
#define TRAINER_OUT_SPEED_X		(0x0800)

///|PoGtFNg̃|P傫ȂXs[h
#define	POKE_AFF_SPEED		(0x20)

///{[GtFNgJnÕEFCg
#define BALL_START_WAIT		(0)

///g[i[ޏꓮJn܂ł̃EFCg
#define TRAINER_MOVE_START_WAIT		(2)
///g[i[{[𓊂鎞̗hꕝ
#define TRAINER_BALL_SHAKE_Y		(3)
///g[i[{[𓊂鎞̗h炷(ƌ̈ʒuɖ߂ďÎŊɂ鎖I)
#define TRAINER_BALL_SHAKE_LOOP		(3)
///g[i[{[𓊂鎞AhꂽAޏꂷ܂ł̃EFCg
#define TRAINER_BALL_OUT_WAIT		(4)


//==============================================================================
//	vg^Cv錾
//==============================================================================
static int Request_Sample(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work);
static void Recieve_Sample(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data);
static void Answer_Sample(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *answer_head, CO_ANSDAT *ansdat, int net_id);
static int Request_PokeAppear(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work);
static void Recieve_PokeAppear(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data);
static int Request_Advance(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work);
static void Recieve_Advance(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data);
static void VOTCB_Advance(TCB_PTR tcb, void *work);
static int Request_AudienceEvaluate(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work);
static void Recieve_AudienceEvaluate(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data);
static void VOTCB_AudienceEvaluate(TCB_PTR tcb, void *work);
static int Request_PokeOut(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work);
static void Recieve_PokeOut(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data);
static void VOTCB_PokeOut(TCB_PTR tcb, void *work);
static int Request_VisualExit(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work);
static void Recieve_VisualExit(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data);
static int Request_DonchouUp(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work);
static void Recieve_DonchouUp(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data);
static void VOTCB_DonchouUp(TCB_PTR tcb, void *work);
static int Request_DonchouDown(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work);
static void Recieve_DonchouDown(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data);
static void VOTCB_DonchouDown(TCB_PTR tcb, void *work);
static int Request_TrainerIn(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work);
static void Recieve_TrainerIn(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data);
static void VOTCB_TrainerIn(TCB_PTR tcb, void *work);
static int Request_TrainerOut(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work);
static void Recieve_TrainerOut(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data);
static void VOTCB_TrainerOut(TCB_PTR tcb, void *work);
static int Request_AppearEffect(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work);
static void Recieve_AppearEffect(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data);
static void VOTCB_AppearEffect(TCB_PTR tcb, void *work);
static void VOTCB_Sub_BallEffect(TCB_PTR tcb, void *work);
static void VOTCB_Sub_BallMove(TCB_PTR tcb, void *work);
static void VOTCB_Sub_PokeAppear(TCB_PTR tcb, void *work);
static void VOTCB_Sub_TrainerOut(TCB_PTR tcb, void *work);
static int Request_Talk(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work);
static void Recieve_Talk(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data);
static void VOTCB_TalkPut(TCB_PTR tcb, void *work);


//==============================================================================
//	f[^
//==============================================================================
///ߑMp֐|C^\̃e[u	ɒǉK.henumɂǉ鎖!!
static const CON_ORDER_FUNC OrderFuncTbl[] = {
	{//VORDER_NO_SAMPLE		Tv
		Request_Sample, 
		Recieve_Sample, 
		Answer_Sample, 
	},
	{//VORDER_NO_VISUAL_EXIT
		Request_VisualExit,
		Recieve_VisualExit,
		NULL,
	},
	{//VORDER_NO_POKE_APPEAR
		Request_PokeAppear, 
		Recieve_PokeAppear, 
		NULL, 
	},
	{//VORDER_NO_ADVANCE
		Request_Advance, 
		Recieve_Advance, 
		NULL, 
	},
	{//VORDER_NO_AUDIENCE_EVALUATE
		Request_AudienceEvaluate, 
		Recieve_AudienceEvaluate, 
		NULL, 
	},
	{//VORDER_NO_POKE_OUT
		Request_PokeOut, 
		Recieve_PokeOut, 
		NULL, 
	},
	{//VORDER_NO_DONCHOU_UP
		Request_DonchouUp, 
		Recieve_DonchouUp, 
		NULL, 
	},
	{//VORDER_NO_DONCHOU_DOWN
		Request_DonchouDown, 
		Recieve_DonchouDown, 
		NULL, 
	},
	{//VORDER_NO_TRAINER_IN
		Request_TrainerIn, 
		Recieve_TrainerIn, 
		NULL, 
	},
	{//VORDER_NO_TRAINER_OUT
		Request_TrainerOut, 
		Recieve_TrainerOut, 
		NULL, 
	},
	{//VORDER_NO_APPEAR_EFFECT
		Request_AppearEffect, 
		Recieve_AppearEffect, 
		NULL, 
	},
	{//VORDER_NO_TALK
		Request_Talk, 
		Recieve_Talk, 
		NULL, 
	},
};


//--------------------------------------------------------------
//	
//--------------------------------------------------------------
///ǂ񂿂傤Aj̃XN[x[Xʒu
ALIGN4 static const s8 DonchouAnmLineData[] = {
	13, 9, 5, 1, -3
};

///ǂ񂿂傤̃Ajp^[̃LN^NoJnʒu
ALIGN4 static const u16 DonchouAnmPaternStartCharNo[] = {
	0x20, 0x28, 0x30, 0x38,
	0xa0, 0xa8, 0xb0, 0xb8,
	0x120, 0x128, 0x130, 0x138,
};
///ǂ񂿂傤̔ȂꖋŉĩLN^No
#define DONCHOU_NUKINASHI_MAKU		(0x200)


//--------------------------------------------------------------
/**
 * @brief   rWAFReXgM[N
 * @param   vpw		rWAǗ[Nւ̃|C^
 */
//--------------------------------------------------------------
void VisualOrder_WorkInit(VISUAL_PROC_WORK *vpw)
{
	CO_INIT_DATA initdata;
	
	initdata.func_tbl = OrderFuncTbl;
	initdata.func_tbl_max = NELEMS(OrderFuncTbl);
	initdata.my_breeder_no = vpw->consys->c_game.my_breeder_no;
	initdata.server_no = vpw->consys->c_game.server_no;
	initdata.sio_flag = vpw->consys->sio_flag;
	
	CO_WorkInit(&vpw->cow, &initdata);
}


//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   ߑM(M)FTv
 *
 * @param   vpw			rWAǗ[Nւ̃|C^
 * @param   work		Cӂ̃|C^
 *
 * @retval  o^ꂽNGXgrbgԍ
 */
//--------------------------------------------------------------
static int Request_Sample(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work)
{
	VISUAL_PROC_WORK *vpw = syswork;
	int bit_no;
	
	bit_no = CO_REQUEST_TransmitBufferSet(cow, CSELECT_ALL, order_no, NULL, 0);
	OS_TPrintf("ߑMFTv\n");
	return bit_no;
}

//--------------------------------------------------------------
/**
 * @brief   ߎM(M)FTv
 *
 * @param   vpw			rWAǗ[Nւ̃|C^
 * @param   req_head	NGXgwb_̃|C^
 * @param   data		Mf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void Recieve_Sample(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data)
{
	VISUAL_PROC_WORK *vpw = syswork;
	
	//ԎԂ	obt@͓ɓn̂Ȃ̂NULLw
	CO_ANSWER_TransmitBufferSet(cow, req_head, NULL, 0);

	OS_TPrintf("ߎMFTv\n");
}

//--------------------------------------------------------------
/**
 * @brief   ԎM(M)FTv
 *
 * @param   vpw				rWAǗ[Nւ̃|C^
 * @param   answer_head		Ԏwb_̃|C^
 * @param   ansdat			Mf[^ւ̃|C^
 * @param   net_id			ԎM҂̃lbgID
 */
//--------------------------------------------------------------
static void Answer_Sample(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *answer_head, CO_ANSDAT *ansdat, int net_id)
{
	VISUAL_PROC_WORK *vpw = syswork;
	
	OS_TPrintf("ߕԐMFTv\n");
	//Ԏ󂯎邾Ȃ̂œɂ鎖Ȃ
	return;
}


//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   ߑM(M)FrWAI
 *
 * @param   vpw			Z͕Ǘ[Nւ̃|C^
 * @param   work		Cӂ̃|C^
 *
 * @retval  o^ꂽNGXgrbgԍ
 */
//--------------------------------------------------------------
static int Request_VisualExit(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work)
{
	VISUAL_PROC_WORK *vpw = syswork;
	int bit_no;
	
	OS_TPrintf("ߑMFrWAI\n");
	bit_no = CO_REQUEST_TransmitBufferSet(cow, CSELECT_ALL, order_no, NULL, 0);
	return bit_no;
}

//--------------------------------------------------------------
/**
 * @brief   ߎM(M)FrWAI
 *
 * @param   vpw			Z͕Ǘ[Nւ̃|C^
 * @param   req_head	NGXgwb_̃|C^
 * @param   data		Mf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void Recieve_VisualExit(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data)
{
	VISUAL_PROC_WORK *vpw = syswork;

	OS_TPrintf("ߎMFrWAI\n");

	vpw->main_end = TRUE;
	
	//ԎԂ	obt@͓ɓn̂Ȃ̂NULLw
	CO_ANSWER_TransmitBufferSet(cow, req_head, NULL, 0);
}


//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   ߑM(M)F|Po
 *
 * @param   vpw			rWAǗ[Nւ̃|C^
 * @param   work		Cӂ̃|C^
 *
 * @retval  o^ꂽNGXgrbgԍ
 */
//--------------------------------------------------------------
static int Request_PokeAppear(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work)
{
	VISUAL_PROC_WORK *vpw = syswork;
	int bit_no;
	
	OS_TPrintf("ߑMF|Po\n");
	bit_no = CO_REQUEST_TransmitBufferSet(cow, CSELECT_ALL, order_no, 
		work, sizeof(VISUAL_ADVANCE_PARAM));
	return bit_no;
}

//--------------------------------------------------------------
/**
 * @brief   ߎM(M)F|Po
 *
 * @param   vpw			rWAǗ[Nւ̃|C^
 * @param   req_head	NGXgwb_̃|C^
 * @param   data		Mf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void Recieve_PokeAppear(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data)
{
	VISUAL_PROC_WORK *vpw = syswork;
	VISUAL_ADVANCE_PARAM *vap = data;
	s32 height;

	OS_TPrintf("ߎMF|Po\n");
	
	height = PokeParaHeightGet(vpw->sys.c_game->pp[vap->now_breeder], PARA_FRONT);

	VT_SoftSpriteAdd(&vpw->sys, vap->now_breeder);
	SoftSpriteParaSet(vpw->sys.ss[vap->now_breeder], SS_PARA_POS_Y, VISUAL_APPEAR_X);
	SoftSpriteParaSet(vpw->sys.ss[vap->now_breeder], SS_PARA_POS_Y, 
		VISUAL_APPEAR_Y + height);
	
	SoftSpriteParaSet(vpw->sys.ss[vap->now_breeder], SS_PARA_VANISH, FALSE);

	OS_TPrintf("ԎMF|Po\n");
	CO_ANSWER_TransmitBufferSet(cow, req_head, NULL, 0);
}


//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   ߑM(M)F|POi
 *
 * @param   vpw			rWAǗ[Nւ̃|C^
 * @param   work		Cӂ̃|C^
 *
 * @retval  o^ꂽNGXgrbgԍ
 */
//--------------------------------------------------------------
static int Request_Advance(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work)
{
	VISUAL_PROC_WORK *vpw = syswork;
	int bit_no;
	
	bit_no = CO_REQUEST_TransmitBufferSet(cow, CSELECT_ALL, order_no, 
		work, sizeof(VISUAL_ADVANCE_PARAM));
	return bit_no;
}

//--------------------------------------------------------------
/**
 * @brief   ߎM(M)F|POi
 *
 * @param   vpw			rWAǗ[Nւ̃|C^
 * @param   req_head	NGXgwb_̃|C^
 * @param   data		Mf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void Recieve_Advance(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data)
{
	VISUAL_PROC_WORK *vpw = syswork;
	VISUAL_ADVANCE_PARAM *vap = data;
	VOLOCAL_ADVANCE *ad;
	
	ad = sys_AllocMemory(HEAPID_VISUAL, sizeof(VOLOCAL_ADVANCE));
	MI_CpuClear8(ad, sizeof(VOLOCAL_ADVANCE));

	ad->vpw = vpw;
	ad->req_head = *req_head;
	ad->cow = cow;
	ad->breeder_no = vap->now_breeder;

	TCB_Add(VOTCB_Advance, ad, TCBPRI_VISUAL_ORDERSUB);
}

//--------------------------------------------------------------
/**
 * @brief   |POi
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		VOLOCAL_ADVANCE\
 */
//--------------------------------------------------------------
static void VOTCB_Advance(TCB_PTR tcb, void *work)
{
	VOLOCAL_ADVANCE *ad = work;
	int height;
	
	switch(ad->seq){
	case 0:
		ad->x = SoftSpriteParaGet(ad->vpw->sys.ss[ad->breeder_no], SS_PARA_POS_X) << 8;
		ad->y = SoftSpriteParaGet(ad->vpw->sys.ss[ad->breeder_no], SS_PARA_POS_Y) << 8;
		ad->seq++;
		break;
	case 1:
		height = PokeParaHeightGet(ad->vpw->sys.c_game->pp[ad->breeder_no], PARA_FRONT);

		ad->y += 0x0100;
		if(ad->y >= (VISUAL_ARRIVAL_Y << 8)){
		//if((ad->y + height) >= (VISUAL_ARRIVAL_Y << 8)){
			ad->y = VISUAL_ARRIVAL_Y << 8;
			ad->seq++;
		}
		SoftSpriteParaSet(ad->vpw->sys.ss[ad->breeder_no], SS_PARA_POS_X, ad->x >> 8);
		SoftSpriteParaSet(ad->vpw->sys.ss[ad->breeder_no], SS_PARA_POS_Y, ad->y >> 8);
		break;
	default:
		CO_ANSWER_TransmitBufferSet(ad->cow, &ad->req_head, NULL, 0);

		sys_FreeMemoryEz(ad);
		TCB_Delete(tcb);
		return;
	}
}



//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   ߑM(M)Fϋq]
 *
 * @param   vpw			rWAǗ[Nւ̃|C^
 * @param   work		Cӂ̃|C^
 *
 * @retval  o^ꂽNGXgrbgԍ
 */
//--------------------------------------------------------------
static int Request_AudienceEvaluate(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work)
{
	VISUAL_PROC_WORK *vpw = syswork;
	int bit_no;
	
	bit_no = CO_REQUEST_TransmitBufferSet(cow, CSELECT_ALL, order_no, 
		work, sizeof(VISUAL_ADVANCE_PARAM));
	return bit_no;
}

//--------------------------------------------------------------
/**
 * @brief   ߎM(M)Fϋq]
 *
 * @param   vpw			rWAǗ[Nւ̃|C^
 * @param   req_head	NGXgwb_̃|C^
 * @param   data		Mf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void Recieve_AudienceEvaluate(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data)
{
	VISUAL_PROC_WORK *vpw = syswork;
	VISUAL_ADVANCE_PARAM *vap = data;
	VOLOCAL_EVALUATE *eva;
	
	eva = sys_AllocMemory(HEAPID_VISUAL, sizeof(VOLOCAL_EVALUATE));
	MI_CpuClear8(eva, sizeof(VOLOCAL_EVALUATE));

	eva->vpw = vpw;
	eva->req_head = *req_head;
	eva->cow = cow;
	
	eva->evaluate_heart_num = vap->evaluate_heart_num;
	
	TCB_Add(VOTCB_AudienceEvaluate, eva, TCBPRI_VISUAL_ORDERSUB);
}

//--------------------------------------------------------------
/**
 * @brief   ϋq]
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		VOLOCAL_EVALUATE\
 */
//--------------------------------------------------------------
///ϋqn[gon߂ÕEFCg
#define EVALUATE_HEART_START_WAIT		(30)
///n[gXoĂɊJԊu
#define EVALUATE_HEART_WAIT		(5)
///n[gSďoIAI̕ԎԂ܂ł̃EFCg
#define EVALUATE_HEART_END_WAIT	(60)
///n[g\ʒu[EW(荶ɂ͕\Ȃ)
#define EVALUATE_HEART_X_L		(32)
///n[g\ʒuE[EW(Eɂ͕\Ȃ)
#define EVALUATE_HEART_X_R		(32)
///n[g\ʒu_X
#define EVALUATE_HEART_X_RND	((256 - EVALUATE_HEART_X_L - EVALUATE_HEART_X_R) / 2)
///n[g\ʒu[EW(荶ɂ͕\Ȃ)
#define EVALUATE_HEART_Y_U		(32)
///n[g\ʒuE[EW(Eɂ͕\Ȃ)
#define EVALUATE_HEART_Y_D		(32)
///n[g\ʒu_X
#define EVALUATE_HEART_Y_RND	((192 - EVALUATE_HEART_Y_U - EVALUATE_HEART_Y_D) / 2)
static void VOTCB_AudienceEvaluate(TCB_PTR tcb, void *work)
{
	VOLOCAL_EVALUATE *eva = work;
	int height;
	
	switch(eva->seq){
	case 0:
		Snd_SePlay(DSE_AUDIENCE);
		eva->wait = EVALUATE_HEART_START_WAIT;
		eva->seq++;
		//break;
	case 1:
		if(eva->put_count >= eva->evaluate_heart_num){
			eva->wait = 0;
			eva->seq++;
			break;
		}
		
		if(eva->wait > 0){
			eva->wait--;
			break;
		}
		
		eva->wait = EVALUATE_HEART_WAIT;
		
		//n[g\
		{
			s16 x, y, rnd_x, rnd_y;
			
			rnd_x = contest_rand(eva->vpw->consys) % EVALUATE_HEART_X_RND;
			rnd_y = contest_rand(eva->vpw->consys) % EVALUATE_HEART_Y_RND;
			if(contest_rand(eva->vpw->consys) & 1){
				x = 128 + rnd_x;
			}
			else{
				x = 128 - rnd_x;
			}
			if(contest_rand(eva->vpw->consys) & 1){
				y = 96 + rnd_y;
			}
			else{
				y = 96 - rnd_y;
			}
			//n[g߂ꏊɌł܂Ȃ悤ɋWƔrēKxɎU炷
			if(eva->put_count > 0){
				if(((eva->old_x < 128 && x < 128) || (eva->old_x > 128 && x > 128))
						&& ((eva->old_y < 96 && y < 96) || (eva->old_y > 96 && y > 96))){
					if(contest_rand(eva->vpw->consys) & 1){
						if(x < 128){
							x = 128 + rnd_x;
						}
						else{
							x = 128 - rnd_x;
						}
					}
					else{
						if(y < 96){
							y = 96 + rnd_y;
						}
						else{
							y = 96 - rnd_y;
						}
					}
				}
			}
			
			if(eva->put_count & 1){
				VT_AudienceHeartActorAdd(eva->vpw, x, y, 180 << FX32_SHIFT);
			}
			else{
				VT_AudienceHeartActorAdd(eva->vpw, x, y, 0);
			}
			
			eva->old_x = x;
			eva->old_y = y;
		}
		eva->put_count++;
		break;
	case 2:
		eva->wait++;
		if(eva->wait > EVALUATE_HEART_END_WAIT){
			eva->seq++;
		}
		break;
	default:
		CO_ANSWER_TransmitBufferSet(eva->cow, &eva->req_head, NULL, 0);

		sys_FreeMemoryEz(eva);
		TCB_Delete(tcb);
		return;
	}
}


//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   ߑM(M)F|Pޏ
 *
 * @param   vpw			rWAǗ[Nւ̃|C^
 * @param   work		Cӂ̃|C^
 *
 * @retval  o^ꂽNGXgrbgԍ
 */
//--------------------------------------------------------------
static int Request_PokeOut(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work)
{
	VISUAL_PROC_WORK *vpw = syswork;
	int bit_no;
	
	bit_no = CO_REQUEST_TransmitBufferSet(cow, CSELECT_ALL, order_no, 
		work, sizeof(VISUAL_ADVANCE_PARAM));
	return bit_no;
}

//--------------------------------------------------------------
/**
 * @brief   ߎM(M)F|Pޏ
 *
 * @param   vpw			rWAǗ[Nւ̃|C^
 * @param   req_head	NGXgwb_̃|C^
 * @param   data		Mf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void Recieve_PokeOut(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data)
{
	VISUAL_PROC_WORK *vpw = syswork;
	VISUAL_ADVANCE_PARAM *vap = data;
	VOLOCAL_POKEOUT *po;
	
	po = sys_AllocMemory(HEAPID_VISUAL, sizeof(VOLOCAL_POKEOUT));
	MI_CpuClear8(po, sizeof(VOLOCAL_POKEOUT));

	po->vpw = vpw;
	po->req_head = *req_head;
	po->cow = cow;
	po->breeder_no = vap->now_breeder;

	TCB_Add(VOTCB_PokeOut, po, TCBPRI_VISUAL_ORDERSUB);
}

//--------------------------------------------------------------
/**
 * @brief   |Pޏ
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		VOLOCAL_POKEOUT\
 */
//--------------------------------------------------------------
static void VOTCB_PokeOut(TCB_PTR tcb, void *work)
{
	VOLOCAL_POKEOUT *po = work;
	int height;
	
	switch(po->seq){
	case 0:
		po->x = SoftSpriteParaGet(po->vpw->sys.ss[po->breeder_no], SS_PARA_POS_X) << 8;
		po->y = SoftSpriteParaGet(po->vpw->sys.ss[po->breeder_no], SS_PARA_POS_Y) << 8;
		po->seq++;
		break;
	case 1:
		po->x += 0x0300;
		if(po->x >= (300<<8)){
			SoftSpriteParaSet(po->vpw->sys.ss[po->breeder_no], SS_PARA_VANISH, TRUE);
			po->seq++;
		}
		SoftSpriteParaSet(po->vpw->sys.ss[po->breeder_no], SS_PARA_POS_X, po->x >> 8);
		SoftSpriteParaSet(po->vpw->sys.ss[po->breeder_no], SS_PARA_POS_Y, po->y >> 8);
		break;
	default:
		VT_SoftSpriteDel(&po->vpw->sys, po->breeder_no);
		
		CO_ANSWER_TransmitBufferSet(po->cow, &po->req_head, NULL, 0);

		sys_FreeMemoryEz(po);
		TCB_Delete(tcb);
		return;
	}
}


//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   ߑM(M)Fǂ񂿂傤グ
 *
 * @param   vpw			rWAǗ[Nւ̃|C^
 * @param   work		Cӂ̃|C^
 *
 * @retval  o^ꂽNGXgrbgԍ
 */
//--------------------------------------------------------------
static int Request_DonchouUp(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work)
{
	VISUAL_PROC_WORK *vpw = syswork;
	int bit_no;
	
	bit_no = CO_REQUEST_TransmitBufferSet(cow, CSELECT_ALL, order_no, NULL, 0);
	return bit_no;
}

//--------------------------------------------------------------
/**
 * @brief   ߎM(M)Fǂ񂿂傤グ
 *
 * @param   vpw			rWAǗ[Nւ̃|C^
 * @param   req_head	NGXgwb_̃|C^
 * @param   data		Mf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void Recieve_DonchouUp(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data)
{
	VISUAL_PROC_WORK *vpw = syswork;
	VOLOCAL_DONCHOU_UP *du;
	
	du = sys_AllocMemory(HEAPID_VISUAL, sizeof(VOLOCAL_DONCHOU_UP));
	MI_CpuClear8(du, sizeof(VOLOCAL_DONCHOU_UP));

	du->vpw = vpw;
	du->req_head = *req_head;
	du->cow = cow;
	
	TCB_Add(VOTCB_DonchouUp, du, TCBPRI_VISUAL_ORDERSUB);
}

//--------------------------------------------------------------
/**
 * @brief   ǂ񂿂傤グ
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		VOLOCAL_DONCHOU_UP\
 */
//--------------------------------------------------------------
static void VOTCB_DonchouUp(TCB_PTR tcb, void *work)
{
	VOLOCAL_DONCHOU_UP *du = work;
	
	switch(du->seq){
	case 0:
		//AjEFCg
		if(du->anm_dansa_wait > 0){
			du->anm_dansa_wait--;
			break;
		}
		if(du->anm_wait > 0){
			du->anm_wait--;
			break;
		}
		du->anm_wait = DONCHOU_ANM_WAIT;
		
		//Aj
		{
			u16 *scrn_buf, *dest_scrn;
			int x, y, pos_x, s, base_charno;
			
			scrn_buf = GF_BGL_ScreenAdrsGet(du->vpw->sys.bgl, VISUAL_FRAME_EFF);
			for(y = 0; y < DONCHOU_ANM_DATA_Y_LEN; y++){
				if(DonchouAnmLineData[du->anm_line] + y < 0){
					continue;
				}
				dest_scrn = &scrn_buf[32 * (DonchouAnmLineData[du->anm_line] + y)];
				base_charno = DonchouAnmPaternStartCharNo[du->anm_no] + 32*y;
				pos_x = 0;
				for(s = 0; s < 32 / DONCHOU_ANM_DATA_X_LEN; s++){
					for(x = 0; x < DONCHOU_ANM_DATA_X_LEN; x++){
						dest_scrn[pos_x + x] &= 0xfc00;		//LN^Nô݃NA
						dest_scrn[pos_x + x] |= base_charno + x;
					}
					pos_x += DONCHOU_ANM_DATA_X_LEN;
				}
			}
			
			//2iڈȍ~̂ǂ񂿂傤ł͍Ō̃AjꃉCcȂ̂ŁA
			//Ôǂ񂿂傤̎cNAĂ
			//Ӗ킩Ȃꍇ͂Ƃ肠́op܂邲ƃRgAEgĂ݂Ε
			{
				if(du->anm_line > 0 && du->anm_no == 0){
					dest_scrn = &scrn_buf[32 * DonchouAnmLineData[du->anm_line - 1]];
					for(s = 0; s < 32; s++){
						dest_scrn[s] &= 0xfc00;		//LN^Nô݃NA
					}
				}
			}
			
			GF_BGL_LoadScreenV_Req(du->vpw->sys.bgl, VISUAL_FRAME_EFF);
		}
		
		du->anm_no++;
		if(du->anm_no >= NELEMS(DonchouAnmPaternStartCharNo)){
			du->anm_no = 0;
			du->anm_line++;
			du->anm_dansa_wait = DONCHOU_DANSA_ANM_WAIT;
			if(du->anm_line >= NELEMS(DonchouAnmLineData)){
				du->seq++;
			}
		}
		break;
	default:
		CO_ANSWER_TransmitBufferSet(du->cow, &du->req_head, NULL, 0);

		sys_FreeMemoryEz(du);
		TCB_Delete(tcb);
		return;
	}
}


//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   ߑM(M)Fǂ񂿂傤
 *
 * @param   vpw			rWAǗ[Nւ̃|C^
 * @param   work		Cӂ̃|C^
 *
 * @retval  o^ꂽNGXgrbgԍ
 */
//--------------------------------------------------------------
static int Request_DonchouDown(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work)
{
	VISUAL_PROC_WORK *vpw = syswork;
	int bit_no;
	
	bit_no = CO_REQUEST_TransmitBufferSet(cow, CSELECT_ALL, order_no, NULL, 0);
	return bit_no;
}

//--------------------------------------------------------------
/**
 * @brief   ߎM(M)Fǂ񂿂傤
 *
 * @param   vpw			rWAǗ[Nւ̃|C^
 * @param   req_head	NGXgwb_̃|C^
 * @param   data		Mf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void Recieve_DonchouDown(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data)
{
	VISUAL_PROC_WORK *vpw = syswork;
	VOLOCAL_DONCHOU_DOWN *dd;
	
	dd = sys_AllocMemory(HEAPID_VISUAL, sizeof(VOLOCAL_DONCHOU_DOWN));
	MI_CpuClear8(dd, sizeof(VOLOCAL_DONCHOU_DOWN));

	dd->vpw = vpw;
	dd->req_head = *req_head;
	dd->cow = cow;
	
	TCB_Add(VOTCB_DonchouDown, dd, TCBPRI_VISUAL_ORDERSUB);
}

//--------------------------------------------------------------
/**
 * @brief   ǂ񂿂傤
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		VOLOCAL_DONCHOU_DOWN\
 */
//--------------------------------------------------------------
static void VOTCB_DonchouDown(TCB_PTR tcb, void *work)
{
	VOLOCAL_DONCHOU_DOWN *dd = work;
	
	switch(dd->seq){
	case 0:
		//AjEFCg
		if(dd->anm_dansa_wait > 0){
			dd->anm_dansa_wait--;
			break;
		}
		if(dd->anm_wait > 0){
			dd->anm_wait--;
			break;
		}
		dd->anm_wait = DONCHOU_ANM_WAIT;
		
		//Aj
		{
			u16 *scrn_buf, *dest_scrn;
			int x, y, pos_x, s, base_charno;
			int base_line;
			
			scrn_buf = GF_BGL_ScreenAdrsGet(dd->vpw->sys.bgl, VISUAL_FRAME_EFF);
			for(y = 0; y < DONCHOU_ANM_DATA_Y_LEN; y++){
				base_line = DonchouAnmLineData[NELEMS(DonchouAnmLineData) - 1 - dd->anm_line];
				if(base_line + y < 0){
					continue;
				}
				dest_scrn = &scrn_buf[32 * (base_line + y)];
				base_charno = DonchouAnmPaternStartCharNo[NELEMS(DonchouAnmPaternStartCharNo) - 1 - dd->anm_no] + 32*y;
				pos_x = 0;
				for(s = 0; s < 32 / DONCHOU_ANM_DATA_X_LEN; s++){
					for(x = 0; x < DONCHOU_ANM_DATA_X_LEN; x++){
						dest_scrn[pos_x + x] &= 0xfc00;		//LN^Nô݃NA
						dest_scrn[pos_x + x] |= base_charno + x;
					}
					pos_x += DONCHOU_ANM_DATA_X_LEN;
				}
			}
			
			//ԉ̃CȊO͍Ō܂ŉ̃Aj̐ꖋȂ̂ŁA
			//̒ĩAjsꂽ^C~OŔȂ̃AjɕςĂ
			//Ӗ킩Ȃꍇ͂Ƃ肠́op܂邲ƃRgAEgĂ݂Ε
			{
				if(dd->anm_line > 0 && dd->anm_no == 0){
					base_line = DonchouAnmLineData[NELEMS(DonchouAnmLineData) - 1 - dd->anm_line + 1];
					base_line += DONCHOU_ANM_DATA_Y_LEN - 1;
					dest_scrn = &scrn_buf[base_line * 32];
					for(s = 0; s < 32; s++){
						dest_scrn[s] &= 0xfc00;		//LN^Nô݃NA
						dest_scrn[s] |= DONCHOU_NUKINASHI_MAKU + (s % DONCHOU_ANM_DATA_X_LEN);
					}
				}
			}
			
			GF_BGL_LoadScreenV_Req(dd->vpw->sys.bgl, VISUAL_FRAME_EFF);
		}
		
		dd->anm_no++;
		if(dd->anm_no >= NELEMS(DonchouAnmPaternStartCharNo)){
			dd->anm_no = 0;
			dd->anm_line++;
			dd->anm_dansa_wait = DONCHOU_DANSA_ANM_WAIT;
			if(dd->anm_line >= NELEMS(DonchouAnmLineData)){
				dd->seq++;
			}
		}
		break;
	default:
		CO_ANSWER_TransmitBufferSet(dd->cow, &dd->req_head, NULL, 0);

		sys_FreeMemoryEz(dd);
		TCB_Delete(tcb);
		return;
	}
}


//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   ߑM(M)Fg[i[o
 *
 * @param   vpw			rWAǗ[Nւ̃|C^
 * @param   work		Cӂ̃|C^
 *
 * @retval  o^ꂽNGXgrbgԍ
 */
//--------------------------------------------------------------
static int Request_TrainerIn(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work)
{
	VISUAL_PROC_WORK *vpw = syswork;
	int bit_no;
	
	bit_no = CO_REQUEST_TransmitBufferSet(cow, CSELECT_ALL, order_no, 
		work, sizeof(VISUAL_ADVANCE_PARAM));
	OS_TPrintf("ߑMFg[i[o\n");
	return bit_no;
}

//--------------------------------------------------------------
/**
 * @brief   ߎM(M)Fg[i[o
 *
 * @param   vpw			rWAǗ[Nւ̃|C^
 * @param   req_head	NGXgwb_̃|C^
 * @param   data		Mf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void Recieve_TrainerIn(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data)
{
	VISUAL_PROC_WORK *vpw = syswork;
	VISUAL_ADVANCE_PARAM *vap = data;
	VOLOCAL_TRAINER_INOUT *tio;
	
	OS_TPrintf("ߎMFg[i[o\n");
	
	tio = sys_AllocMemory(HEAPID_VISUAL, sizeof(VOLOCAL_TRAINER_INOUT));
	MI_CpuClear8(tio, sizeof(VOLOCAL_TRAINER_INOUT));
	
	tio->vpw = vpw;
	tio->req_head = *req_head;
	tio->cow = cow;
	tio->breeder_no = vap->now_breeder;
	
	TCB_Add(VOTCB_TrainerIn, tio, TCBPRI_VISUAL_ORDERSUB);
}

//--------------------------------------------------------------
/**
 * @brief   g[i[o
 * @param   tcb			TCBւ̃|C^
 * @param   work		VOLOCAL_TRAINER_INOUT\
 */
//--------------------------------------------------------------
static void VOTCB_TrainerIn(TCB_PTR tcb, void *work)
{
	VOLOCAL_TRAINER_INOUT *tio = work;
	
	switch(tio->seq){
	case 0:
		VT_TrainerAdd(tio->vpw, tio->breeder_no);
		tio->x = SoftSpriteParaGet(tio->vpw->sys.trainer_ss, SS_PARA_POS_X) * 0x0100;
		tio->y = SoftSpriteParaGet(tio->vpw->sys.trainer_ss, SS_PARA_POS_Y) * 0x0100;
		tio->seq++;
		//break;
	case 1:
		tio->x -= TRAINER_IN_SPEED_X;
		if(tio->x <= (VISUAL_TRAINER_ARRIVAL_X * 0x0100)){
			tio->x = VISUAL_TRAINER_ARRIVAL_X * 0x0100;
			tio->seq++;
		}
		SoftSpriteParaSet(tio->vpw->sys.trainer_ss, SS_PARA_POS_X, tio->x / 0x0100);
		SoftSpriteParaSet(tio->vpw->sys.trainer_ss, SS_PARA_POS_Y, tio->y / 0x0100);
		break;
	default:
		CO_ANSWER_TransmitBufferSet(tio->cow, &tio->req_head, NULL, 0);

		sys_FreeMemoryEz(tio);
		TCB_Delete(tcb);
		return;
	}
}


//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   ߑM(M)Fg[i[ޏ
 *
 * @param   vpw			rWAǗ[Nւ̃|C^
 * @param   work		Cӂ̃|C^
 *
 * @retval  o^ꂽNGXgrbgԍ
 */
//--------------------------------------------------------------
static int Request_TrainerOut(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work)
{
	VISUAL_PROC_WORK *vpw = syswork;
	int bit_no;
	
	bit_no = CO_REQUEST_TransmitBufferSet(cow, CSELECT_ALL, order_no, 
		work, sizeof(VISUAL_ADVANCE_PARAM));
	OS_TPrintf("ߑMFg[i[ޏ\n");
	return bit_no;
}

//--------------------------------------------------------------
/**
 * @brief   ߎM(M)Fg[i[ޏ
 *
 * @param   vpw			rWAǗ[Nւ̃|C^
 * @param   req_head	NGXgwb_̃|C^
 * @param   data		Mf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void Recieve_TrainerOut(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data)
{
	VISUAL_PROC_WORK *vpw = syswork;
	VISUAL_ADVANCE_PARAM *vap = data;
	VOLOCAL_TRAINER_INOUT *tio;
	
	OS_TPrintf("ߎMFg[i[ޏ\n");
	
	tio = sys_AllocMemory(HEAPID_VISUAL, sizeof(VOLOCAL_TRAINER_INOUT));
	MI_CpuClear8(tio, sizeof(VOLOCAL_TRAINER_INOUT));
	
	tio->vpw = vpw;
	tio->req_head = *req_head;
	tio->cow = cow;
	tio->breeder_no = vap->now_breeder;
	
	TCB_Add(VOTCB_TrainerOut, tio, TCBPRI_VISUAL_ORDERSUB);
}

//--------------------------------------------------------------
/**
 * @brief   g[i[ޏ
 * @param   tcb			TCBւ̃|C^
 * @param   work		VOLOCAL_TRAINER_INOUT\
 */
//--------------------------------------------------------------
static void VOTCB_TrainerOut(TCB_PTR tcb, void *work)
{
	VOLOCAL_TRAINER_INOUT *tio = work;
	
	switch(tio->seq){
	case 0:
		GF_ASSERT(tio->vpw->sys.trainer_ss != NULL);
		
		tio->x = SoftSpriteParaGet(tio->vpw->sys.trainer_ss, SS_PARA_POS_X) * 0x0100;
		tio->y = SoftSpriteParaGet(tio->vpw->sys.trainer_ss, SS_PARA_POS_Y) * 0x0100;
		tio->seq++;
		//break;
	case 1:
		tio->x += TRAINER_OUT_SPEED_X;
		if(tio->x >= (VISUAL_TRAINER_APPEAR_X * 0x0100)){
			tio->x = VISUAL_TRAINER_APPEAR_X * 0x0100;
			tio->seq++;
		}
		SoftSpriteParaSet(tio->vpw->sys.trainer_ss, SS_PARA_POS_X, tio->x / 0x0100);
		SoftSpriteParaSet(tio->vpw->sys.trainer_ss, SS_PARA_POS_Y, tio->y / 0x0100);
		break;
	default:
		VT_TrainerDel(tio->vpw);
		
		CO_ANSWER_TransmitBufferSet(tio->cow, &tio->req_head, NULL, 0);

		sys_FreeMemoryEz(tio);
		TCB_Delete(tcb);
		return;
	}
}


//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   ߑM(M)FoGtFNg
 *
 * @param   vpw			rWAǗ[Nւ̃|C^
 * @param   work		Cӂ̃|C^
 *
 * @retval  o^ꂽNGXgrbgԍ
 */
//--------------------------------------------------------------
static int Request_AppearEffect(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work)
{
	VISUAL_PROC_WORK *vpw = syswork;
	int bit_no;
	
	bit_no = CO_REQUEST_TransmitBufferSet(cow, CSELECT_ALL, order_no, 
		work, sizeof(VISUAL_ADVANCE_PARAM));
	return bit_no;
}

//--------------------------------------------------------------
/**
 * @brief   ߎM(M)FoGtFNg
 *
 * @param   vpw			rWAǗ[Nւ̃|C^
 * @param   req_head	NGXgwb_̃|C^
 * @param   data		Mf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void Recieve_AppearEffect(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data)
{
	VISUAL_PROC_WORK *vpw = syswork;
	VISUAL_ADVANCE_PARAM *vap = data;
	VOLOCAL_APPEAR_EFF *ae;
	
	ae = sys_AllocMemory(HEAPID_VISUAL, sizeof(VOLOCAL_APPEAR_EFF));
	MI_CpuClear8(ae, sizeof(VOLOCAL_APPEAR_EFF));
	
	ae->vpw = vpw;
	ae->req_head = *req_head;
	ae->cow = cow;
	ae->breeder_no = vap->now_breeder;
	
	ae->ball_move.vpw = vpw;
	ae->poke_eff.vpw = vpw;
	ae->poke_eff.breeder_no = vap->now_breeder;
	ae->tr_eff.vpw = vpw;
	
	TCB_Add(VOTCB_AppearEffect, ae, TCBPRI_VISUAL_ORDERSUB);
}

//--------------------------------------------------------------
/**
 * @brief   oGtFNgs^XN
 * @param   tcb			TCBւ̃|C^
 * @param   work		VOLOCAL_APPEAR_EFF\
 */
//--------------------------------------------------------------
static void VOTCB_AppearEffect(TCB_PTR tcb, void *work)
{
	VOLOCAL_APPEAR_EFF *ae = work;
	
	switch(ae->seq){
	case 0:
		TCB_Add(VOTCB_Sub_BallMove, &ae->ball_move, TCBPRI_VISUAL_ORDERSUB_SUB);
		TCB_Add(VOTCB_Sub_TrainerOut, &ae->tr_eff, TCBPRI_VISUAL_ORDERSUB_SUB);
		ae->seq++;
		break;
	case 1:
		if(ae->ball_move.end == TRUE){
			TCB_Add(VOTCB_Sub_BallEffect, &ae->ball_eff, TCBPRI_VISUAL_ORDERSUB_SUB);
			TCB_Add(VOTCB_Sub_PokeAppear, &ae->poke_eff, TCBPRI_VISUAL_ORDERSUB_SUB);
			ae->seq++;
		}
		break;
	case 2:
		if(ae->ball_eff.end == TRUE && ae->poke_eff.end == TRUE && ae->tr_eff.end == TRUE){
			ae->seq++;
		}
		break;
	default:
		CO_ANSWER_TransmitBufferSet(ae->cow, &ae->req_head, NULL, 0);

		sys_FreeMemoryEz(work);
		TCB_Delete(tcb);
		return;
	}
}

//--------------------------------------------------------------
/**
 * @brief	{[̃R[obN֐(Ƃ肠W킹ׂ̎b)
 * @param	emit	
 */
//--------------------------------------------------------------
static void BallEffect_CallBack(EMIT_PTR emit)
{
	TBALL_INIT_PARAM* bip;
	
	bip = Particle_GetTempPtr();
	
	{
		VecFx32 pos = {0, 0, 0};
		
		SPL_SetEmitterPosition(emit, &pos);
	}
}

//--------------------------------------------------------------
/**
 * @brief   {[GtFNgs
 * @param   tcb			TCBւ̃|C^
 * @param   work		VOLOCAL_SUB_BALL_EFF\
 */
//--------------------------------------------------------------
static void VOTCB_Sub_BallEffect(TCB_PTR tcb, void *work)
{
	VOLOCAL_SUB_BALL_EFF *ball_eff = work;
	
	switch(ball_eff->seq){
	case 0:
		ball_eff->bcp.client_type = CLIENT_TYPE_AA;
		ball_eff->bes = BallEffect_Init(HEAPID_VISUAL, &ball_eff->bcp);
		BallEffect_Executed(ball_eff->bes, BallEffect_CallBack);
		
		ball_eff->seq++;
		break;
	case 1:
		if(BallEffect_EndCheck(ball_eff->bes) == FALSE){
			BallEffect_FreeMemory(ball_eff->bes);
			ball_eff->seq++;
		}
		break;
	default:
		ball_eff->end = TRUE;
		TCB_Delete(tcb);
		return;
	}
}

//--------------------------------------------------------------
/**
 * @brief   {[ړ
 * @param   tcb			TCBւ̃|C^
 * @param   work		VOLOCAL_SUB_BALL_MOVE\
 */
//--------------------------------------------------------------
static void VOTCB_Sub_BallMove(TCB_PTR tcb, void *work)
{
	VOLOCAL_SUB_BALL_MOVE *ball_move = work;
	
	switch(ball_move->seq){
	case 0:
		ball_move->wait++;
		if(ball_move->wait >= BALL_START_WAIT){
			ball_move->wait = 0;
			ball_move->seq++;
		}
		break;
	case 1:
		{
			TBALL_MOVE_DATA bmd;

			bmd.type = EBMT_VISUAL;
			bmd.heap_id = HEAPID_VISUAL;
			bmd.mode = EBMM_THROW;
			bmd.id = 0;
			bmd.csp = ball_move->vpw->sys.csp;
			bmd.pfd = ball_move->vpw->sys.pfd;

			ball_move->bms = BM_Init(&bmd);
		}
		ball_move->seq++;
		break;
	case 2:
		if(BM_EndCheck(ball_move->bms) == TRUE){
			break;
		}
		//break;
	default:
		BM_Delete(ball_move->bms);
		ball_move->end = TRUE;
		TCB_Delete(tcb);
		return;
	}
}

//--------------------------------------------------------------
/**
 * @brief   |Pg債Ȃo
 * @param   tcb			TCBւ̃|C^
 * @param   work		VOLOCAL_SUB_POKE_EFF\
 */
//--------------------------------------------------------------
static void VOTCB_Sub_PokeAppear(TCB_PTR tcb, void *work)
{
	VOLOCAL_SUB_POKE_EFF *poke_eff = work;
	s32 height;
	SOFT_SPRITE *ss;
	s32 monsno;
	
	height = PokeParaHeightGet(poke_eff->vpw->sys.c_game->pp[poke_eff->breeder_no], PARA_FRONT);
	ss = poke_eff->vpw->sys.ss[poke_eff->breeder_no];
	
	switch(poke_eff->seq){
	case 0:
		{
			VT_SoftSpriteAdd(&poke_eff->vpw->sys, poke_eff->breeder_no);
			ss = poke_eff->vpw->sys.ss[poke_eff->breeder_no];
			
			SoftSpriteParaSet(ss, SS_PARA_POS_Y, VISUAL_ARRIVAL_X);
			SoftSpriteParaSet(ss, SS_PARA_POS_Y, VISUAL_ARRIVAL_Y + height);
			
			SoftSpriteParaSet(ss, SS_PARA_VANISH, FALSE);

			//k
			SoftSpriteParaSet(ss, SS_PARA_AFF_X, AFF_APPEAR_X_S);
			SoftSpriteParaSet(ss, SS_PARA_AFF_Y, AFF_APPEAR_Y_S);
			SoftSpriteOYCalc(ss, height);
		}
		poke_eff->seq++;
		break;
	case 1:
		SoftSpriteParaCalc(ss, SS_PARA_AFF_X, POKE_AFF_SPEED);
		SoftSpriteParaCalc(ss, SS_PARA_AFF_Y, POKE_AFF_SPEED);
		SoftSpriteOYCalc(ss, height);
		
		if(SoftSpriteParaGet(ss, SS_PARA_AFF_X) >= AFF_APPEAR_X_B){
			SoftSpriteParaSet(ss, SS_PARA_AFF_X, AFF_APPEAR_X_B);
			SoftSpriteParaSet(ss, SS_PARA_AFF_Y, AFF_APPEAR_Y_B);
			
			monsno = PokeParaGet(poke_eff->vpw->sys.c_game->pp[poke_eff->breeder_no],
				ID_PARA_monsno, NULL);
			Snd_PMVoicePlay(monsno);
			
			poke_eff->seq++;
		}
		break;
	default:
		poke_eff->end = TRUE;
		TCB_Delete(tcb);
		return;
	}
}

//--------------------------------------------------------------
/**
 * @brief   g[i[ޏ
 * @param   tcb			TCBւ̃|C^
 * @param   work		VOLOCAL_SUB_TRAINER_EFF\
 */
//--------------------------------------------------------------
static void VOTCB_Sub_TrainerOut(TCB_PTR tcb, void *work)
{
	VOLOCAL_SUB_TRAINER_EFF *tr_eff = work;
	
	switch(tr_eff->seq){
	case 0:
		GF_ASSERT(tr_eff->vpw->sys.trainer_ss != NULL);
		
		tr_eff->wait++;
		if(tr_eff->wait > TRAINER_MOVE_START_WAIT){
			tr_eff->wait = 0;
			tr_eff->seq++;
		}
		break;
	case 1:
		tr_eff->x = SoftSpriteParaGet(tr_eff->vpw->sys.trainer_ss, SS_PARA_POS_X) * 0x0100;
		tr_eff->y = SoftSpriteParaGet(tr_eff->vpw->sys.trainer_ss, SS_PARA_POS_Y) * 0x0100;
		tr_eff->seq++;
		//break;
	case 2:
		if(tr_eff->loop & 1){
			SoftSpriteParaSet(tr_eff->vpw->sys.trainer_ss, SS_PARA_POS_X, tr_eff->x / 0x0100);
			SoftSpriteParaSet(tr_eff->vpw->sys.trainer_ss, SS_PARA_POS_Y, tr_eff->y / 0x0100);
		}
		else{
			SoftSpriteParaSet(tr_eff->vpw->sys.trainer_ss, SS_PARA_POS_X, tr_eff->x / 0x0100);
			SoftSpriteParaSet(tr_eff->vpw->sys.trainer_ss, SS_PARA_POS_Y, 
				tr_eff->y / 0x0100 - TRAINER_BALL_SHAKE_Y);
		}
		
		tr_eff->loop++;
		if(tr_eff->loop >= TRAINER_BALL_SHAKE_LOOP){
			tr_eff->seq++;
		}
		break;
	case 3:
		tr_eff->wait++;
		if(tr_eff->wait >= TRAINER_BALL_OUT_WAIT){
			tr_eff->wait = 0;
			tr_eff->seq++;
		}
		break;
	case 4:
		tr_eff->x += TRAINER_OUT_SPEED_X;
		if(tr_eff->x >= (VISUAL_TRAINER_APPEAR_X * 0x0100)){
			tr_eff->x = VISUAL_TRAINER_APPEAR_X * 0x0100;
			tr_eff->seq++;
		}
		SoftSpriteParaSet(tr_eff->vpw->sys.trainer_ss, SS_PARA_POS_X, tr_eff->x / 0x0100);
		SoftSpriteParaSet(tr_eff->vpw->sys.trainer_ss, SS_PARA_POS_Y, tr_eff->y / 0x0100);
		break;
	default:
		VT_TrainerDel(tr_eff->vpw);
		
		tr_eff->end = TRUE;
		TCB_Delete(tcb);
		return;
	}
}

//==============================================================================
//	
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   ߑM(M)FbbZ[W̕\
 *
 * @param   vpw			rWAǗ[Nւ̃|C^
 * @param   work		Cӂ̃|C^
 *
 * @retval  o^ꂽNGXgrbgԍ
 */
//--------------------------------------------------------------
static int Request_Talk(CONTEST_ORDER_WORK *cow, void *syswork, int order_no, void *work)
{
	VISUAL_PROC_WORK *vpw = syswork;
	int bit_no;
	
	bit_no = CO_REQUEST_TransmitBufferSet(cow, CSELECT_ALL, order_no, 
		work, sizeof(VISUAL_ADVANCE_PARAM));
	return bit_no;
}

//--------------------------------------------------------------
/**
 * @brief   ߎM(M)FbbZ[W̕\
 *
 * @param   vpw			rWAǗ[Nւ̃|C^
 * @param   req_head	NGXgwb_̃|C^
 * @param   data		Mf[^ւ̃|C^
 */
//--------------------------------------------------------------
static void Recieve_Talk(CONTEST_ORDER_WORK *cow, void *syswork, const CORDER_HEAD *req_head, void *data)
{
	VISUAL_PROC_WORK *vpw = syswork;
	VISUAL_ADVANCE_PARAM *vap = data;
	VOLOCAL_TALK_PUT *talk;
	
	talk = sys_AllocMemory(HEAPID_VISUAL, sizeof(VOLOCAL_TALK_PUT));
	MI_CpuClear8(talk, sizeof(VOLOCAL_TALK_PUT));
	
	talk->vpw = vpw;
	talk->req_head = *req_head;
	talk->cow = cow;
	talk->breeder_no = vap->now_breeder;
	
	talk->a_talk_tagpara = vap->a_talk_tagpara;
	talk->a_talk_id = vap->a_talk_id;
	talk->a_talk_bmpwin_not_close = vap->a_talk_bmpwin_not_close;
	talk->a_talk_bmpwin_close_wait = vap->a_talk_bmpwin_close_wait;
	
	TCB_Add(VOTCB_TalkPut, talk, TCBPRI_VISUAL_ORDERSUB);
}

//--------------------------------------------------------------
/**
 * @brief   bbZ[W̕\
 * @param   tcb			TCBւ̃|C^
 * @param   work		VOLOCAL_TALK_PUT\
 */
//--------------------------------------------------------------
static void VOTCB_TalkPut(TCB_PTR tcb, void *work)
{
	VOLOCAL_TALK_PUT *talk = work;
	
	switch(talk->seq){
	case 0:
		if(talk->a_talk_id != A_TALK_VISUAL_NULL){
			BmpTalkWinWrite(&talk->vpw->sys.win[VISUAL_BMPWIN_TALK], WINDOW_TRANS_OFF,
				VISUAL_TALKWIN_CGX_OFFSET, VISUAL_TALKWIN_PALNO);
			GF_BGL_LoadScreenV_Req(talk->vpw->sys.bgl, VISUAL_FRAME_WIN);
			
			VT_A_TalkMessageSet(talk->vpw, talk->a_talk_id, &talk->a_talk_tagpara);
			talk->seq++;
		}
		else{
			talk->seq = 100;
		}
		break;
	case 1:
		if(VT_TalkMessageEndCheck(talk->vpw) == 0){
			talk->seq++;
		}
		break;
	case 2:
		talk->close_wait++;
		if(talk->a_talk_bmpwin_not_close == TRUE){
			talk->seq++;
		}
		else if(talk->close_wait >= talk->a_talk_bmpwin_close_wait){
			BmpTalkWinClear(&talk->vpw->sys.win[VISUAL_BMPWIN_TALK], WINDOW_TRANS_OFF);
			GF_BGL_LoadScreenV_Req(talk->vpw->sys.bgl, VISUAL_FRAME_WIN);
			talk->seq++;
		}
		break;
	default:
		CO_ANSWER_TransmitBufferSet(talk->cow, &talk->req_head, NULL, 0);

		sys_FreeMemoryEz(talk);
		TCB_Delete(tcb);
		return;
	}
}

