//==============================================================================================
/**
 * @file	d_fight.c
 * @brief	fobOt@Cg
 * @author	sogabe
 * @date	2006.01.06
 */
//==============================================================================================
#include "common.h"
#include "system/fontproc.h"
#include "system/pm_str.h"
#include "system/msgdata.h"						//MSGDATA_MANAGER
#include "system/arc_tool.h"
#include "system/arc_util.h"
#include "system/softsprite.h"
#include "poke_test.h"

#include "msgdata/msg.naix"						//NARC_msg_??_dat
#include "msgdata/msg_debug_fight.h"
#include "battle/battle_common.h"
#include "poketool/monsno.h"
#include "battle/attr_def.h"
#include "battle/wazano_def.h"
#include "battle/chr_def.h"
#include "battle/tokusyu_def.h"
#include "battle/fight.h"
#include "poketool/poke_tool.h"
#include "poketool/pokeparty.h"
#include "system/snd_tool.h"
#include "system/wordset.h"
#include "system/brightness.h"
#include "itemtool/itemsym.h"
#include "itemtool/myitem.h"

#include "communication/communication.h"
#include "communication/comm_state.h"

#include "system/main.h"
#include "demo/title.h"
#include "savedata/savedata.h"

extern	BOOL	PMSVLD_Load(u32 src, void * dst, u32 len);
extern	BOOL	PMSVLD_Save(u32 src, void * dst, u32 len);

//==============================================================================================
//
//	\
//
//==============================================================================================

#define		SAVE_BANK	(31)

enum{
	STATUS_HP=0,
	STATUS_POW,
	STATUS_DEF,
	STATUS_AGI,
	STATUS_SPEPOW,
	STATUS_SPEDEF,
	STATUS_MAX
};

enum{
	COND_NORMAL=0,
	COND_NEMURI,
	COND_DOKU,
	COND_YAKEDO,
	COND_MAHI,
	COND_KOORI,
	COND_DOKUDOKU,

	DF_COND_MAX=COND_DOKUDOKU,
};

static	const	cond_table[]={
	CONDITION_NOCHECK,
	CONDITION_NEMURI,
	CONDITION_DOKU,
	CONDITION_YAKEDO,
	CONDITION_MAHI,
	CONDITION_KOORI,
	CONDITION_DOKUDOKU,
};

typedef struct{
	u32	exp;
	u32	id;
	u32	personal_rnd;

	u32	waza[4];

	u32	mons_no;
	u32	item;

	u32	level;
	u32	sex;
	u32	chr;
	u32	condition;

	u32	friend;
	u32	pokerus;
	u32	speabi;
	u32	fur;

	u32	status_rnd[STATUS_MAX];
	u32	status_exp[STATUS_MAX];

	u32	get_place;
	u32	get_level;
	u32	get_cassette;
	u32	get_ball;

	u32	style;
	u32	beautiful;
	u32	cute;
	u32	clever;

	u32	strong;

	u32	hp_max;
	u32	default_hp;
	u32	speabino;
	u32	speabino_set;
}DEBUG_POKEMON_PARAM;

typedef struct{
	DEBUG_POKEMON_PARAM	dpp[12];
	int					ground;
	int					my_sex;
	int					fight_type;
	int					trainer_id;
}DEBUG_SAVE_PARAM;

typedef struct{
	GF_BGL_INI			*bgl;
	GF_BGL_BMPWIN		*win_m;
	GF_BGL_BMPWIN		*win_s;
	int					seq_no;
	int					sub_seq_no;
	int					sub_act_seq_no;
	BOOL				end_flag;
	MSGDATA_MANAGER		*man_msg;
	MSGDATA_MANAGER		*man_poke;
	MSGDATA_MANAGER		*man_waza;
	MSGDATA_MANAGER		*man_chr;
	MSGDATA_MANAGER		*man_speabi;
	MSGDATA_MANAGER		*man_item;
	int					cur_pos_m;
	int					cur_pos_s;
	int					cur_pos_keta;
	int					page;
	int					flag;
	int					put_req;
	STRBUF				*msg_buf;
	WORDSET				*wordset;
	PROC				*proc;
	BATTLE_PARAM		*param;
	DEBUG_SAVE_PARAM	dsp;
	POKEMON_PARAM		*pp;
}DEBUG_FIGHT_PARAM;

typedef BOOL (*DF_FUNC)(DEBUG_FIGHT_PARAM *);

typedef struct
{
	u8		cursor_pos_x;	//J[\Xʒu
	u8		cursor_pos_y;	//J[\Yʒu
	u8		move_up;		//L[Ƃ̈ړ
	u8		move_down;		//L[Ƃ̈ړ
	u8		move_left;		//L[Ƃ̈ړ
	u8		move_right;		//EL[Ƃ̈ړ
	DF_FUNC	a_button_act;	//A{^Ƃ̃ANV
}MENU_LIST_PARAM;

//==============================================================================================
//
//	vg^Cv錾
//
//==============================================================================================

static	void	InitDebugFight(DEBUG_FIGHT_PARAM *dfp);

static	BOOL	DebugFightStart(DEBUG_FIGHT_PARAM *dfp);

static	void	DebugFightBGCreate(DEBUG_FIGHT_PARAM *dfp,GF_BGL_INI *bgl);
static	void	DebugFightPokemonParamInit(DEBUG_POKEMON_PARAM *dpp);
static	void	DebugFightMainScreenCreate(DEBUG_FIGHT_PARAM *dfp);
static	void	DebugFightSubScreenCreate(DEBUG_FIGHT_PARAM *dfp,int page);
static	void	DebugFightMonsNamePut(DEBUG_FIGHT_PARAM *dfp,int pos);
static	void	DebugFightFightTypePut(DEBUG_FIGHT_PARAM *dfp);
static	void	DebugFightFightTypeDataPut(DEBUG_FIGHT_PARAM *dfp,GF_PRINTCOLOR col);
static	void	DebugFightGroundPut(DEBUG_FIGHT_PARAM *dfp);
static	void	DebugFightGroundDataPut(DEBUG_FIGHT_PARAM *dfp,GF_PRINTCOLOR col);
static	void	DebugFightMySexPut(DEBUG_FIGHT_PARAM *dfp);
static	void	DebugFightMySexDataPut(DEBUG_FIGHT_PARAM *dfp,GF_PRINTCOLOR col);
static	void	DebugFightKindPut(DEBUG_FIGHT_PARAM *dfp);
static	void	DebugFightKindDataPut(DEBUG_FIGHT_PARAM *dfp,int mode);
static	void	DebugFightLevelPut(DEBUG_FIGHT_PARAM *dfp);
static	void	DebugFightLevelDataPut(DEBUG_FIGHT_PARAM *dfp,int mode);
static	void	DebugFightExpPut(DEBUG_FIGHT_PARAM *dfp);
static	void	DebugFightExpDataPut(DEBUG_FIGHT_PARAM *dfp,int mode);
static	void	DebugFightSexPut(DEBUG_FIGHT_PARAM *dfp);
static	void	DebugFightSexDataPut(DEBUG_FIGHT_PARAM *dfp,GF_PRINTCOLOR col);
static	void	DebugFightChrPut(DEBUG_FIGHT_PARAM *dfp);
static	void	DebugFightChrDataPut(DEBUG_FIGHT_PARAM *dfp,GF_PRINTCOLOR col);

static	void	DebugFightHPRndPut(DEBUG_FIGHT_PARAM *dfp);
static	void	DebugFightPowRndPut(DEBUG_FIGHT_PARAM *dfp);
static	void	DebugFightDefRndPut(DEBUG_FIGHT_PARAM *dfp);
static	void	DebugFightAgiRndPut(DEBUG_FIGHT_PARAM *dfp);
static	void	DebugFightSpePowRndPut(DEBUG_FIGHT_PARAM *dfp);
static	void	DebugFightSpeDefRndPut(DEBUG_FIGHT_PARAM *dfp);

static	void	DebugFightHPExpPut(DEBUG_FIGHT_PARAM *dfp);
static	void	DebugFightPowExpPut(DEBUG_FIGHT_PARAM *dfp);
static	void	DebugFightDefExpPut(DEBUG_FIGHT_PARAM *dfp);
static	void	DebugFightAgiExpPut(DEBUG_FIGHT_PARAM *dfp);
static	void	DebugFightSpePowExpPut(DEBUG_FIGHT_PARAM *dfp);
static	void	DebugFightSpeDefExpPut(DEBUG_FIGHT_PARAM *dfp);

static	void	DebugFightStatusRndDataPut(DEBUG_FIGHT_PARAM *dfp,int status,int mode);
static	void	DebugFightStatusExpDataPut(DEBUG_FIGHT_PARAM *dfp,int status,int mode);

static	void	DebugFightParamPut(DEBUG_FIGHT_PARAM *dfp);
static	void	DebugFightDefaultSet(DEBUG_FIGHT_PARAM *dfp,int mode);

static	void	DebugFightWazaPut(DEBUG_FIGHT_PARAM *dfp,int pos);
static	void	DebugFightWazaDataPut(DEBUG_FIGHT_PARAM *dfp,int pos,int mode);
static	void	DebugFightSpeAbiPut(DEBUG_FIGHT_PARAM *dfp);
static	void	DebugFightSpeAbiDataPut(DEBUG_FIGHT_PARAM *dfp,GF_PRINTCOLOR col);
static	void	DebugFightSpeAbiSetPut(DEBUG_FIGHT_PARAM *dfp);
static	void	DebugFightSpeAbiSetDataPut(DEBUG_FIGHT_PARAM *dfp,int mode);
static	void	DebugFightItemPut(DEBUG_FIGHT_PARAM *dfp);
static	void	DebugFightItemDataPut(DEBUG_FIGHT_PARAM *dfp,int mode);
static	void	DebugFightFriendPut(DEBUG_FIGHT_PARAM *dfp);
static	void	DebugFightFriendDataPut(DEBUG_FIGHT_PARAM *dfp,int mode);
static	void	DebugFightConditionPut(DEBUG_FIGHT_PARAM *dfp);
static	void	DebugFightConditionDataPut(DEBUG_FIGHT_PARAM *dfp,GF_PRINTCOLOR col);
static	void	DebugFightDefaultHPPut(DEBUG_FIGHT_PARAM *dfp);
static	void	DebugFightDefaultHPDataPut(DEBUG_FIGHT_PARAM *dfp,int mode);

static	void	DebugFightNumPut(DEBUG_FIGHT_PARAM *dfp,int x,int y,int param,int keta,int pos,int mode);
static	void	DebugFightVBlank(void *work);
static	void	CursorMove(DEBUG_FIGHT_PARAM *dfp,int side,int pos,int mode);

static	BOOL	DebugFightPokeAct(DEBUG_FIGHT_PARAM *dfp);
static	BOOL	DebugFightGroundAct(DEBUG_FIGHT_PARAM *dfp);
static	BOOL	DebugFightMySexAct(DEBUG_FIGHT_PARAM *dfp);
static	BOOL	DebugFightFightTypeAct(DEBUG_FIGHT_PARAM *dfp);
static	BOOL	DebugFightLoadAct(DEBUG_FIGHT_PARAM *dfp);
static	BOOL	DebugFightSaveAct(DEBUG_FIGHT_PARAM *dfp);

static	BOOL	DebugFightKindAct(DEBUG_FIGHT_PARAM *dfp);
static	BOOL	DebugFightLevelAct(DEBUG_FIGHT_PARAM *dfp);
static	BOOL	DebugFightExpAct(DEBUG_FIGHT_PARAM *dfp);
static	BOOL	DebugFightSexAct(DEBUG_FIGHT_PARAM *dfp);
static	BOOL	DebugFightChrAct(DEBUG_FIGHT_PARAM *dfp);
static	BOOL	DebugFightStatusRndAct(DEBUG_FIGHT_PARAM *dfp);
static	BOOL	DebugFightStatusExpAct(DEBUG_FIGHT_PARAM *dfp);

static	BOOL	DebugFightWazaAct(DEBUG_FIGHT_PARAM *dfp);
static	BOOL	DebugFightSpeAbiAct(DEBUG_FIGHT_PARAM *dfp);
static	BOOL	DebugFightSpeAbiSetAct(DEBUG_FIGHT_PARAM *dfp);
static	BOOL	DebugFightItemAct(DEBUG_FIGHT_PARAM *dfp);
static	BOOL	DebugFightFriendAct(DEBUG_FIGHT_PARAM *dfp);
static	BOOL	DebugFightConditionAct(DEBUG_FIGHT_PARAM *dfp);
static	BOOL	DebugFightDefaultHPAct(DEBUG_FIGHT_PARAM *dfp);
static	void	DebugFightDefaultPokeSet(DEBUG_FIGHT_PARAM *dfp,int pos);

static	int		DebugFightNumCalc(DEBUG_FIGHT_PARAM *dfp,u32 *param,int keta,int min,int max,int mode);

static	void	DebugFight_SetProc(DEBUG_FIGHT_PARAM *dfp);


extern	BATTLE_PARAM *BattleParam_Create(int heapID,u32 fight_type);
extern	void BattleParam_Delete(BATTLE_PARAM * bp);

//==================================================================================================
//
//	f[^
//
//==================================================================================================

#define	CREATE_HEAP_SIZE	(0x28000)	//CreateHeapSize

#define	CUR_DEL				(0)
#define	CUR_PUT				(1)

#define	MINE_X				(24)		//uԂv\XW
#define	MINE_Y				(8)			//uԂv\YW
#define	ENEMY_X				(152)		//uāv\XW
#define	ENEMY_Y				(8)			//uāv\YW

#define	POKE_TOP			(28)

#define	MINE_POKE_X			(24)		//Ԃ̎莝|P1̖ڕ\XW
#define	MINE_POKE_Y			(POKE_TOP)	//Ԃ̎莝|P1̖ڕ\YW
#define	MINE_POKE_Y_OFS		(16)		//Ԃ̎莝|PYWItZbg

#define	ENEMY_POKE_X		(152)		//Ă̎莝|P1̖ڕ\XW
#define	ENEMY_POKE_Y		(POKE_TOP)	//Ă̎莝|P1̖ڕ\YW
#define	ENEMY_POKE_Y_OFS	(16)		//Ă̎莝|PYWItZbg

#define	BG_TOP				(128)

#define	BG_X				(24)			//uv\XW
#define	BG_Y				(BG_TOP)		//uv\YW

#define	BG_DATA_X			(152)			//uvf[^\XW
#define	BG_DATA_Y			(BG_TOP)		//uvf[^\YW

#define	MYSEX_X				(24)			//uԂׂ̂v\XW
#define	MYSEX_Y				(BG_TOP+16)		//uԂׂ̂v\YW

#define	MYSEX_DATA_X		(152)			//uԂׂ̂vf[^\XW
#define	MYSEX_DATA_Y		(BG_TOP+16)		//uԂׂ̂vf[^\YW

#define	FIGHT_TYPE_X		(24)			//uƂ^Cvv\XW
#define	FIGHT_TYPE_Y		(BG_TOP+32)		//uƂ^Cvv\YW

#define	FIGHT_TYPE_DATA_X	(152)			//uƂ^Cvvf[^\XW
#define	FIGHT_TYPE_DATA_Y	(BG_TOP+32)		//uƂ^Cvvf[^\YW

#define	LOAD_X				(24)
#define	LOAD_Y				(BG_TOP+48)

#define	SAVE_X				(152)
#define	SAVE_Y				(BG_TOP+48)

#define	TRAINER_ID_X		(24)			//ug[i[IDv\XW
#define	TRAINER_ID_Y		(BG_TOP+48)		//ug[i[IDv\YW

#define	TRAINER_ID_DATA_X	(152)			//ug[i[IDvf[^\XW
#define	TRAINER_ID_DATA_Y	(BG_TOP+48)		//ug[i[IDvf[^\YW


#define	MINE_POKE1_CUR_X	(12)			//Ԃ̎莝|P1̖ڃJ[\\XW
#define	MINE_POKE1_CUR_Y	(POKE_TOP)		//Ԃ̎莝|P1̖ڃJ[\\YW
#define	MINE_POKE2_CUR_X	(12)			//Ԃ̎莝|P2̖ڃJ[\\XW
#define	MINE_POKE2_CUR_Y	(POKE_TOP+16)	//Ԃ̎莝|P2̖ڃJ[\\YW
#define	MINE_POKE3_CUR_X	(12)			//Ԃ̎莝|P3̖ڃJ[\\XW
#define	MINE_POKE3_CUR_Y	(POKE_TOP+32)	//Ԃ̎莝|P3̖ڃJ[\\YW
#define	MINE_POKE4_CUR_X	(12)			//Ԃ̎莝|P4̖ڃJ[\\XW
#define	MINE_POKE4_CUR_Y	(POKE_TOP+48)	//Ԃ̎莝|P4̖ڃJ[\\YW
#define	MINE_POKE5_CUR_X	(12)			//Ԃ̎莝|P5̖ڃJ[\\XW
#define	MINE_POKE5_CUR_Y	(POKE_TOP+64)	//Ԃ̎莝|P5̖ڃJ[\\YW
#define	MINE_POKE6_CUR_X	(12)			//Ԃ̎莝|P6̖ڃJ[\\XW
#define	MINE_POKE6_CUR_Y	(POKE_TOP+80)	//Ԃ̎莝|P6̖ڃJ[\\YW
#define	ENEMY_POKE1_CUR_X	(140)			//Ă̎莝|P1̖ڃJ[\\XW
#define	ENEMY_POKE1_CUR_Y	(POKE_TOP)		//Ă̎莝|P1̖ڃJ[\\YW
#define	ENEMY_POKE2_CUR_X	(140)			//Ă̎莝|P2̖ڃJ[\\XW
#define	ENEMY_POKE2_CUR_Y	(POKE_TOP+16)	//Ă̎莝|P2̖ڃJ[\\YW
#define	ENEMY_POKE3_CUR_X	(140)			//Ă̎莝|P3̖ڃJ[\\XW
#define	ENEMY_POKE3_CUR_Y	(POKE_TOP+32)	//Ă̎莝|P3̖ڃJ[\\YW
#define	ENEMY_POKE4_CUR_X	(140)			//Ă̎莝|P4̖ڃJ[\\XW
#define	ENEMY_POKE4_CUR_Y	(POKE_TOP+48)	//Ă̎莝|P4̖ڃJ[\\YW
#define	ENEMY_POKE5_CUR_X	(140)			//Ă̎莝|P5̖ڃJ[\\XW
#define	ENEMY_POKE5_CUR_Y	(POKE_TOP+64)	//Ă̎莝|P5̖ڃJ[\\YW
#define	ENEMY_POKE6_CUR_X	(140)			//Ă̎莝|P6̖ڃJ[\\XW
#define	ENEMY_POKE6_CUR_Y	(POKE_TOP+80)	//Ă̎莝|P6̖ڃJ[\\YW

#define	BG_CUR_X			(12)			//u͂vJ[\\XW
#define	BG_CUR_Y			(BG_TOP)		//u͂vJ[\\YW

#define	MYSEX_CUR_X			(12)			//uԂׂ̂vJ[\\XW
#define	MYSEX_CUR_Y			(BG_TOP+16)		//uԂׂ̂vJ[\\YW

#define	FIGHT_TYPE_CUR_X	(12)			//uƂ^CvvJ[\\XW
#define	FIGHT_TYPE_CUR_Y	(BG_TOP+32)		//uƂ^CvvJ[\\YW

#define	LOAD_CUR_X			(12)
#define	LOAD_CUR_Y			(BG_TOP+48)

#define	SAVE_CUR_X			(140)
#define	SAVE_CUR_Y			(BG_TOP+48)

#define	TRAINER_ID_CUR_X	(12)			//ug[i[IDvJ[\\XW
#define	TRAINER_ID_CUR_Y	(BG_TOP+48)		//ug[i[IDvJ[\\YW

//CXN[j[f[^
enum{
	MS_MINE_POKE_1=0,
	MS_MINE_POKE_2,
	MS_MINE_POKE_3,
	MS_MINE_POKE_4,
	MS_MINE_POKE_5,
	MS_MINE_POKE_6,
	MS_ENEMY_POKE_1,
	MS_ENEMY_POKE_2,
	MS_ENEMY_POKE_3,
	MS_ENEMY_POKE_4,
	MS_ENEMY_POKE_5,
	MS_ENEMY_POKE_6,
	MS_GROUND,
	MS_MYSEX,
	MS_FIGHT_TYPE,
	MS_LOAD,
	MS_SAVE,
	MS_TRAINER_ID,
	MS_END
};

#define	NO_MOVE		(0xff)

static	const	MENU_LIST_PARAM	mlp_m[]={
	//MS_MINE_POKE_1
	{
		MINE_POKE1_CUR_X,		//J[\Xʒu
		MINE_POKE1_CUR_Y,		//J[\Yʒu
		MS_LOAD,				//L[Ƃ̈ړ
		MS_MINE_POKE_2,			//L[Ƃ̈ړ
		NO_MOVE,				//L[Ƃ̈ړ
		MS_ENEMY_POKE_1,		//EL[Ƃ̈ړ
		DebugFightPokeAct,		//A{^Ƃ̃ANV
	},
	//MS_MINE_POKE_2
	{
		MINE_POKE2_CUR_X,		//J[\Xʒu
		MINE_POKE2_CUR_Y,		//J[\Yʒu
		MS_MINE_POKE_1,			//L[Ƃ̈ړ
		MS_MINE_POKE_3,			//L[Ƃ̈ړ
		NO_MOVE,				//L[Ƃ̈ړ
		MS_ENEMY_POKE_2,		//EL[Ƃ̈ړ
		DebugFightPokeAct,		//A{^Ƃ̃ANV
	},
	//MS_MINE_POKE_3
	{
		MINE_POKE3_CUR_X,		//J[\Xʒu
		MINE_POKE3_CUR_Y,		//J[\Yʒu
		MS_MINE_POKE_2,			//L[Ƃ̈ړ
		MS_MINE_POKE_4,			//L[Ƃ̈ړ
		NO_MOVE,				//L[Ƃ̈ړ
		MS_ENEMY_POKE_3,		//EL[Ƃ̈ړ
		DebugFightPokeAct,		//A{^Ƃ̃ANV
	},
	//MS_MINE_POKE_4
	{
		MINE_POKE4_CUR_X,		//J[\Xʒu
		MINE_POKE4_CUR_Y,		//J[\Yʒu
		MS_MINE_POKE_3,			//L[Ƃ̈ړ
		MS_MINE_POKE_5,			//L[Ƃ̈ړ
		NO_MOVE,				//L[Ƃ̈ړ
		MS_ENEMY_POKE_4,		//EL[Ƃ̈ړ
		DebugFightPokeAct,		//A{^Ƃ̃ANV
	},
	//MS_MINE_POKE_5
	{
		MINE_POKE5_CUR_X,		//J[\Xʒu
		MINE_POKE5_CUR_Y,		//J[\Yʒu
		MS_MINE_POKE_4,			//L[Ƃ̈ړ
		MS_MINE_POKE_6,			//L[Ƃ̈ړ
		NO_MOVE,				//L[Ƃ̈ړ
		MS_ENEMY_POKE_5,		//EL[Ƃ̈ړ
		DebugFightPokeAct,		//A{^Ƃ̃ANV
	},
	//MS_MINE_POKE_6
	{
		MINE_POKE6_CUR_X,		//J[\Xʒu
		MINE_POKE6_CUR_Y,		//J[\Yʒu
		MS_MINE_POKE_5,			//L[Ƃ̈ړ
		MS_GROUND,				//L[Ƃ̈ړ
		NO_MOVE,				//L[Ƃ̈ړ
		MS_ENEMY_POKE_6,		//EL[Ƃ̈ړ
		DebugFightPokeAct,		//A{^Ƃ̃ANV
	},
	//MS_ENEMY_POKE_1
	{
		ENEMY_POKE1_CUR_X,		//J[\Xʒu
		ENEMY_POKE1_CUR_Y,		//J[\Yʒu
		MS_SAVE,				//L[Ƃ̈ړ
		MS_ENEMY_POKE_2,		//L[Ƃ̈ړ
		MS_MINE_POKE_1,			//L[Ƃ̈ړ
		NO_MOVE,				//EL[Ƃ̈ړ
		DebugFightPokeAct,		//A{^Ƃ̃ANV
	},
	//MS_ENEMY_POKE_2
	{
		ENEMY_POKE2_CUR_X,		//J[\Xʒu
		ENEMY_POKE2_CUR_Y,		//J[\Yʒu
		MS_ENEMY_POKE_1,		//L[Ƃ̈ړ
		MS_ENEMY_POKE_3,		//L[Ƃ̈ړ
		MS_MINE_POKE_2,			//L[Ƃ̈ړ
		NO_MOVE,				//EL[Ƃ̈ړ
		DebugFightPokeAct,		//A{^Ƃ̃ANV
	},
	//MS_ENEMY_POKE_3
	{
		ENEMY_POKE3_CUR_X,		//J[\Xʒu
		ENEMY_POKE3_CUR_Y,		//J[\Yʒu
		MS_ENEMY_POKE_2,		//L[Ƃ̈ړ
		MS_ENEMY_POKE_4,		//L[Ƃ̈ړ
		MS_MINE_POKE_3,			//L[Ƃ̈ړ
		NO_MOVE,				//EL[Ƃ̈ړ
		DebugFightPokeAct,		//A{^Ƃ̃ANV
	},
	//MS_ENEMY_POKE_4
	{
		ENEMY_POKE4_CUR_X,		//J[\Xʒu
		ENEMY_POKE4_CUR_Y,		//J[\Yʒu
		MS_ENEMY_POKE_3,		//L[Ƃ̈ړ
		MS_ENEMY_POKE_5,		//L[Ƃ̈ړ
		MS_MINE_POKE_4,			//L[Ƃ̈ړ
		NO_MOVE,				//EL[Ƃ̈ړ
		DebugFightPokeAct,		//A{^Ƃ̃ANV
	},
	//MS_ENEMY_POKE_5
	{
		ENEMY_POKE5_CUR_X,		//J[\Xʒu
		ENEMY_POKE5_CUR_Y,		//J[\Yʒu
		MS_ENEMY_POKE_4,		//L[Ƃ̈ړ
		MS_ENEMY_POKE_6,		//L[Ƃ̈ړ
		MS_MINE_POKE_5,			//L[Ƃ̈ړ
		NO_MOVE,				//EL[Ƃ̈ړ
		DebugFightPokeAct,		//A{^Ƃ̃ANV
	},
	//MS_ENEMY_POKE_6
	{
		ENEMY_POKE6_CUR_X,		//J[\Xʒu
		ENEMY_POKE6_CUR_Y,		//J[\Yʒu
		MS_ENEMY_POKE_5,		//L[Ƃ̈ړ
		MS_GROUND,				//L[Ƃ̈ړ
		MS_MINE_POKE_6,			//L[Ƃ̈ړ
		NO_MOVE,				//EL[Ƃ̈ړ
		DebugFightPokeAct,		//A{^Ƃ̃ANV
	},
	//MS_GROUND
	{
		BG_CUR_X,				//J[\Xʒu
		BG_CUR_Y,				//J[\Yʒu
		MS_MINE_POKE_6,			//L[Ƃ̈ړ
		MS_MYSEX,				//L[Ƃ̈ړ
		NO_MOVE,				//L[Ƃ̈ړ
		NO_MOVE,				//EL[Ƃ̈ړ
		DebugFightGroundAct,	//A{^Ƃ̃ANV
	},
	//MS_MYSEX,
	{
		MYSEX_CUR_X,			//J[\Xʒu
		MYSEX_CUR_Y,			//J[\Yʒu
		MS_GROUND,				//L[Ƃ̈ړ
		MS_FIGHT_TYPE,			//L[Ƃ̈ړ
		NO_MOVE,				//L[Ƃ̈ړ
		NO_MOVE,				//EL[Ƃ̈ړ
		DebugFightMySexAct,		//A{^Ƃ̃ANV
	},
	//MS_FIGHT_TYPE
	{
		FIGHT_TYPE_CUR_X,		//J[\Xʒu
		FIGHT_TYPE_CUR_Y,		//J[\Yʒu
		MS_MYSEX,				//L[Ƃ̈ړ
		MS_LOAD,				//L[Ƃ̈ړ
		NO_MOVE,				//L[Ƃ̈ړ
		NO_MOVE,				//EL[Ƃ̈ړ
		DebugFightFightTypeAct,	//A{^Ƃ̃ANV
	},
	//MS_LOAD
	{
		LOAD_CUR_X,				//J[\Xʒu
		LOAD_CUR_Y,				//J[\Yʒu
		MS_FIGHT_TYPE,			//L[Ƃ̈ړ
		MS_MINE_POKE_1,			//L[Ƃ̈ړ
		NO_MOVE,				//L[Ƃ̈ړ
		MS_SAVE,				//EL[Ƃ̈ړ
		DebugFightLoadAct,		//A{^Ƃ̃ANV
	},
	//MS_SAVE
	{
		SAVE_CUR_X,				//J[\Xʒu
		SAVE_CUR_Y,				//J[\Yʒu
		MS_FIGHT_TYPE,			//L[Ƃ̈ړ
		MS_ENEMY_POKE_1,		//L[Ƃ̈ړ
		MS_LOAD,				//L[Ƃ̈ړ
		NO_MOVE,				//EL[Ƃ̈ړ
		DebugFightSaveAct,		//A{^Ƃ̃ANV
	},
	//MS_TRAINER_ID,
	{
		BG_CUR_X,			//J[\Xʒu
		BG_CUR_Y,			//J[\Yʒu
		MS_FIGHT_TYPE,		//L[Ƃ̈ړ
		NO_MOVE,			//L[Ƃ̈ړ
		NO_MOVE,			//L[Ƃ̈ړ
		NO_MOVE,			//EL[Ƃ̈ړ
		NULL,				//A{^Ƃ̃ANV
	},
};

enum{
	MENU1_KIND=0,
	MENU1_LEVEL,
	MENU1_EXP,
	MENU1_SEX,
	MENU1_CHR,
	MENU1_HP_RND,
	MENU1_POW_RND,
	MENU1_DEF_RND,
	MENU1_AGI_RND,
	MENU1_SPEPOW_RND,
	MENU1_SPEDEF_RND,
	MENU1_HP_EXP,
	MENU1_POW_EXP,
	MENU1_DEF_EXP,
	MENU1_AGI_EXP,
	MENU1_SPEPOW_EXP,
	MENU1_SPEDEF_EXP
};

#define	MENU1_LIST_L_X		(24)
#define	MENU1_LIST_R_X		(140)
#define	MENU1_LIST_Y		(8)
#define	MENU1_LIST_OFS		(16)

#define	EXP_LIST_X			(120)
#define	CHR_LIST_X			(120)

#define	KIND_CUR_X			(MENU1_LIST_L_X-12)
#define	KIND_CUR_Y			(MENU1_LIST_Y+MENU1_LIST_OFS*0)
#define	LEVEL_CUR_X			(MENU1_LIST_L_X-12)
#define	LEVEL_CUR_Y			(MENU1_LIST_Y+MENU1_LIST_OFS*1)
#define	EXP_CUR_X			(EXP_LIST_X-12)
#define	EXP_CUR_Y			(MENU1_LIST_Y+MENU1_LIST_OFS*1)
#define	SEX_CUR_X			(MENU1_LIST_L_X-12)
#define	SEX_CUR_Y			(MENU1_LIST_Y+MENU1_LIST_OFS*2)
#define	CHR_CUR_X			(CHR_LIST_X-12)
#define	CHR_CUR_Y			(MENU1_LIST_Y+MENU1_LIST_OFS*2)
#define	HP_RND_CUR_X		(MENU1_LIST_L_X-12)
#define	HP_RND_CUR_Y		(MENU1_LIST_Y+MENU1_LIST_OFS*3)
#define	POW_RND_CUR_X		(MENU1_LIST_L_X-12)
#define	POW_RND_CUR_Y		(MENU1_LIST_Y+MENU1_LIST_OFS*4)
#define	DEF_RND_CUR_X		(MENU1_LIST_L_X-12)
#define	DEF_RND_CUR_Y		(MENU1_LIST_Y+MENU1_LIST_OFS*5)
#define	AGI_RND_CUR_X		(MENU1_LIST_L_X-12)
#define	AGI_RND_CUR_Y		(MENU1_LIST_Y+MENU1_LIST_OFS*6)
#define	SPEPOW_RND_CUR_X	(MENU1_LIST_L_X-12)
#define	SPEPOW_RND_CUR_Y	(MENU1_LIST_Y+MENU1_LIST_OFS*7)
#define	SPEDEF_RND_CUR_X	(MENU1_LIST_L_X-12)
#define	SPEDEF_RND_CUR_Y	(MENU1_LIST_Y+MENU1_LIST_OFS*8)
#define	HP_EXP_CUR_X		(MENU1_LIST_R_X-12)
#define	HP_EXP_CUR_Y		(MENU1_LIST_Y+MENU1_LIST_OFS*3)
#define	POW_EXP_CUR_X		(MENU1_LIST_R_X-12)
#define	POW_EXP_CUR_Y		(MENU1_LIST_Y+MENU1_LIST_OFS*4)
#define	DEF_EXP_CUR_X		(MENU1_LIST_R_X-12)
#define	DEF_EXP_CUR_Y		(MENU1_LIST_Y+MENU1_LIST_OFS*5)
#define	AGI_EXP_CUR_X		(MENU1_LIST_R_X-12)
#define	AGI_EXP_CUR_Y		(MENU1_LIST_Y+MENU1_LIST_OFS*6)
#define	SPEPOW_EXP_CUR_X	(MENU1_LIST_R_X-12)
#define	SPEPOW_EXP_CUR_Y	(MENU1_LIST_Y+MENU1_LIST_OFS*7)
#define	SPEDEF_EXP_CUR_X	(MENU1_LIST_R_X-12)
#define	SPEDEF_EXP_CUR_Y	(MENU1_LIST_Y+MENU1_LIST_OFS*8)

#define	PARAM1_LIST_X		(MENU1_LIST_L_X-12)
#define	PARAM1_LIST_Y		(MENU1_LIST_Y+MENU1_LIST_OFS*9+4)
#define	PARAM2_LIST_X		(MENU1_LIST_L_X-12)
#define	PARAM2_LIST_Y		(MENU1_LIST_Y+MENU1_LIST_OFS*10+4)

#define	KIND_DATA_X			(72)
#define	KIND_DATA_Y			(8)
#define	KIND_NAME_X			(120)

#define	LEVEL_DATA_X		(72)
#define	LEVEL_DATA_Y		(24)
#define	LEVEL_KETA			(3)

#define	EXP_DATA_X			(180)
#define	EXP_DATA_Y			(24)
#define	EXP_KETA			(7)

#define	SEX_DATA_X			(72)
#define	SEX_DATA_Y			(40)

#define	CHR_DATA_X			(180)
#define	CHR_DATA_Y			(40)

#define	STRND_DATA_X		(96)
#define	STRND_DATA_Y		(MENU1_LIST_Y+MENU1_LIST_OFS*3)
#define	STRND_DATA_OFS		(16)
#define	STRND_KETA			(2)

#define	STEXP_DATA_X		(216)
#define	STEXP_DATA_Y		(MENU1_LIST_Y+MENU1_LIST_OFS*3)
#define	STEXP_DATA_OFS		(16)
#define	STEXP_KETA			(3)

static	const	MENU_LIST_PARAM	mlp_s1[]={
	//MENU1_KIND
	{
		KIND_CUR_X,				//J[\Xʒu
		KIND_CUR_Y,				//J[\Yʒu
		MENU1_SPEDEF_RND,		//L[Ƃ̈ړ
		MENU1_LEVEL,			//L[Ƃ̈ړ
		NO_MOVE,				//L[Ƃ̈ړ
		NO_MOVE,				//EL[Ƃ̈ړ
		DebugFightKindAct,		//A{^Ƃ̃ANV
	},
	//MENU1_LEVEL
	{
		LEVEL_CUR_X,			//J[\Xʒu
		LEVEL_CUR_Y,			//J[\Yʒu
		MENU1_KIND,				//L[Ƃ̈ړ
		MENU1_SEX,				//L[Ƃ̈ړ
		NO_MOVE,				//L[Ƃ̈ړ
		MENU1_EXP,				//EL[Ƃ̈ړ
		DebugFightLevelAct,		//A{^Ƃ̃ANV
	},
	//MENU1_EXP
	{
		EXP_CUR_X,				//J[\Xʒu
		EXP_CUR_Y,				//J[\Yʒu
		MENU1_KIND,				//L[Ƃ̈ړ
		MENU1_CHR,				//L[Ƃ̈ړ
		MENU1_LEVEL,			//L[Ƃ̈ړ
		NO_MOVE,				//EL[Ƃ̈ړ
		DebugFightExpAct,		//A{^Ƃ̃ANV
	},
	//MENU1_SEX
	{
		SEX_CUR_X,				//J[\Xʒu
		SEX_CUR_Y,				//J[\Yʒu
		MENU1_LEVEL,			//L[Ƃ̈ړ
		MENU1_HP_RND,			//L[Ƃ̈ړ
		NO_MOVE,				//L[Ƃ̈ړ
		MENU1_CHR,				//EL[Ƃ̈ړ
		DebugFightSexAct,		//A{^Ƃ̃ANV
	},
	//MENU1_CHR
	{
		CHR_CUR_X,				//J[\Xʒu
		CHR_CUR_Y,				//J[\Yʒu
		MENU1_EXP,				//L[Ƃ̈ړ
		MENU1_HP_EXP,			//L[Ƃ̈ړ
		MENU1_SEX,				//L[Ƃ̈ړ
		NO_MOVE,				//EL[Ƃ̈ړ
		DebugFightChrAct,		//A{^Ƃ̃ANV
	},
	//MENU1_HP_RND
	{
		HP_RND_CUR_X,			//J[\Xʒu
		HP_RND_CUR_Y,			//J[\Yʒu
		MENU1_SEX,				//L[Ƃ̈ړ
		MENU1_POW_RND,			//L[Ƃ̈ړ
		NO_MOVE,				//L[Ƃ̈ړ
		MENU1_HP_EXP,			//EL[Ƃ̈ړ
		DebugFightStatusRndAct,					//A{^Ƃ̃ANV
	},
	//MENU1_POW_RND
	{
		POW_RND_CUR_X,			//J[\Xʒu
		POW_RND_CUR_Y,			//J[\Yʒu
		MENU1_HP_RND,			//L[Ƃ̈ړ
		MENU1_DEF_RND,			//L[Ƃ̈ړ
		NO_MOVE,				//L[Ƃ̈ړ
		MENU1_POW_EXP,			//EL[Ƃ̈ړ
		DebugFightStatusRndAct,					//A{^Ƃ̃ANV
	},
	//MENU1_DEF_RND
	{
		DEF_RND_CUR_X,			//J[\Xʒu
		DEF_RND_CUR_Y,			//J[\Yʒu
		MENU1_POW_RND,			//L[Ƃ̈ړ
		MENU1_AGI_RND,			//L[Ƃ̈ړ
		NO_MOVE,				//L[Ƃ̈ړ
		MENU1_DEF_EXP,			//EL[Ƃ̈ړ
		DebugFightStatusRndAct,					//A{^Ƃ̃ANV
	},
	//MENU1_AGI_RND
	{
		AGI_RND_CUR_X,			//J[\Xʒu
		AGI_RND_CUR_Y,			//J[\Yʒu
		MENU1_DEF_RND,			//L[Ƃ̈ړ
		MENU1_SPEPOW_RND,		//L[Ƃ̈ړ
		NO_MOVE,				//L[Ƃ̈ړ
		MENU1_AGI_EXP,			//EL[Ƃ̈ړ
		DebugFightStatusRndAct,					//A{^Ƃ̃ANV
	},
	//MENU1_SPEPOW_RND
	{
		SPEPOW_RND_CUR_X,		//J[\Xʒu
		SPEPOW_RND_CUR_Y,		//J[\Yʒu
		MENU1_AGI_RND,			//L[Ƃ̈ړ
		MENU1_SPEDEF_RND,		//L[Ƃ̈ړ
		NO_MOVE,				//L[Ƃ̈ړ
		MENU1_SPEPOW_EXP,		//EL[Ƃ̈ړ
		DebugFightStatusRndAct,					//A{^Ƃ̃ANV
	},
	//MENU1_SPEDEF_RND
	{
		SPEDEF_RND_CUR_X,		//J[\Xʒu
		SPEDEF_RND_CUR_Y,		//J[\Yʒu
		MENU1_SPEPOW_RND,		//L[Ƃ̈ړ
		MENU1_KIND,				//L[Ƃ̈ړ
		NO_MOVE,				//L[Ƃ̈ړ
		MENU1_SPEDEF_EXP,		//EL[Ƃ̈ړ
		DebugFightStatusRndAct,					//A{^Ƃ̃ANV
	},
	//MENU1_HP_EXP
	{
		HP_EXP_CUR_X,			//J[\Xʒu
		HP_EXP_CUR_Y,			//J[\Yʒu
		MENU1_CHR,				//L[Ƃ̈ړ
		MENU1_POW_EXP,			//L[Ƃ̈ړ
		MENU1_HP_RND,			//L[Ƃ̈ړ
		NO_MOVE,				//EL[Ƃ̈ړ
		DebugFightStatusExpAct,					//A{^Ƃ̃ANV
	},
	//MENU1_POW_EXP
	{
		POW_EXP_CUR_X,			//J[\Xʒu
		POW_EXP_CUR_Y,			//J[\Yʒu
		MENU1_HP_EXP,			//L[Ƃ̈ړ
		MENU1_DEF_EXP,			//L[Ƃ̈ړ
		MENU1_POW_RND,			//L[Ƃ̈ړ
		NO_MOVE,				//EL[Ƃ̈ړ
		DebugFightStatusExpAct,					//A{^Ƃ̃ANV
	},
	//MENU1_DEF_EXP
	{
		DEF_EXP_CUR_X,			//J[\Xʒu
		DEF_EXP_CUR_Y,			//J[\Yʒu
		MENU1_POW_EXP,			//L[Ƃ̈ړ
		MENU1_AGI_EXP,			//L[Ƃ̈ړ
		MENU1_DEF_RND,			//L[Ƃ̈ړ
		NO_MOVE,				//EL[Ƃ̈ړ
		DebugFightStatusExpAct,					//A{^Ƃ̃ANV
	},
	//MENU1_AGI_EXP
	{
		AGI_EXP_CUR_X,			//J[\Xʒu
		AGI_EXP_CUR_Y,			//J[\Yʒu
		MENU1_DEF_EXP,			//L[Ƃ̈ړ
		MENU1_SPEPOW_EXP,		//L[Ƃ̈ړ
		MENU1_AGI_RND,			//L[Ƃ̈ړ
		NO_MOVE,				//EL[Ƃ̈ړ
		DebugFightStatusExpAct,					//A{^Ƃ̃ANV
	},
	//MENU1_SPEPOW_EXP
	{
		SPEPOW_EXP_CUR_X,		//J[\Xʒu
		SPEPOW_EXP_CUR_Y,		//J[\Yʒu
		MENU1_AGI_EXP,			//L[Ƃ̈ړ
		MENU1_SPEDEF_EXP,		//L[Ƃ̈ړ
		MENU1_SPEPOW_RND,		//L[Ƃ̈ړ
		NO_MOVE,				//EL[Ƃ̈ړ
		DebugFightStatusExpAct,					//A{^Ƃ̃ANV
	},
	//MENU1_SPEDEF_EXP
	{
		SPEDEF_EXP_CUR_X,		//J[\Xʒu
		SPEDEF_EXP_CUR_Y,		//J[\Yʒu
		MENU1_SPEPOW_EXP,		//L[Ƃ̈ړ
		MENU1_KIND,				//L[Ƃ̈ړ
		MENU1_SPEDEF_RND,		//L[Ƃ̈ړ
		NO_MOVE,				//EL[Ƃ̈ړ
		DebugFightStatusExpAct,					//A{^Ƃ̃ANV
	},
};

enum{
	MENU2_WAZA1=0,
	MENU2_WAZA2,
	MENU2_WAZA3,
	MENU2_WAZA4,
	MENU2_SPEABI,
	MENU2_SPEABI_SET,
	MENU2_ITEM,
	MENU2_FRIEND,
	MENU2_CONDITION,
	MENU2_DEFAULT_HP,
};

#define	MENU2_LIST_X		(24)
#define	MENU2_LIST_Y		(8)
#define	MENU2_LIST_OFS		(16)

#define	WAZA1_CUR_X			(MENU2_LIST_X-12)
#define	WAZA1_CUR_Y			(MENU2_LIST_Y+MENU2_LIST_OFS*0)
#define	WAZA2_CUR_X			(MENU2_LIST_X-12)
#define	WAZA2_CUR_Y			(MENU2_LIST_Y+MENU2_LIST_OFS*1)
#define	WAZA3_CUR_X			(MENU2_LIST_X-12)
#define	WAZA3_CUR_Y			(MENU2_LIST_Y+MENU2_LIST_OFS*2)
#define	WAZA4_CUR_X			(MENU2_LIST_X-12)
#define	WAZA4_CUR_Y			(MENU2_LIST_Y+MENU2_LIST_OFS*3)
#define	SPEABI_CUR_X		(MENU2_LIST_X-12)
#define	SPEABI_CUR_Y		(MENU2_LIST_Y+MENU2_LIST_OFS*4)
#define	SPEABI_SET_CUR_X	(MENU2_LIST_X-12)
#define	SPEABI_SET_CUR_Y	(MENU2_LIST_Y+MENU2_LIST_OFS*5)
#define	ITEM_CUR_X			(MENU2_LIST_X-12)
#define	ITEM_CUR_Y			(MENU2_LIST_Y+MENU2_LIST_OFS*6)
#define	FRIEND_CUR_X		(MENU2_LIST_X-12)
#define	FRIEND_CUR_Y		(MENU2_LIST_Y+MENU2_LIST_OFS*7)
#define	CONDITION_CUR_X		(MENU2_LIST_X-12)
#define	CONDITION_CUR_Y		(MENU2_LIST_Y+MENU2_LIST_OFS*8)
#define	DEFAULT_HP_CUR_X	(MENU2_LIST_X-12)
#define	DEFAULT_HP_CUR_Y	(MENU2_LIST_Y+MENU2_LIST_OFS*9)

#define	WAZA_NUM_X			(MENU2_LIST_X+84)
#define	WAZA_NUM_Y			(MENU2_LIST_Y+MENU2_LIST_OFS*0)
#define	WAZA_NUM_OFS		(MENU2_LIST_OFS)
#define	WAZA_DATA_X			(MENU2_LIST_X+84+12*4)
#define	WAZA_DATA_Y			(MENU2_LIST_Y+MENU2_LIST_OFS*0)
#define	WAZA_DATA_OFS		(MENU2_LIST_OFS)

#define	SPEABI_DATA_X		(MENU2_LIST_X+84)
#define	SPEABI_DATA_Y		(MENU2_LIST_Y+MENU2_LIST_OFS*4)
#define	SPEABI_SET_NUM_X	(MENU2_LIST_X+84)
#define	SPEABI_SET_NUM_Y	(MENU2_LIST_Y+MENU2_LIST_OFS*5)
#define	SPEABI_SET_DATA_X	(MENU2_LIST_X+84+12*4)
#define	SPEABI_SET_DATA_Y	(MENU2_LIST_Y+MENU2_LIST_OFS*5)
#define	ITEM_NUM_X			(MENU2_LIST_X+84)
#define	ITEM_NUM_Y			(MENU2_LIST_Y+MENU2_LIST_OFS*6)
#define	ITEM_DATA_X			(MENU2_LIST_X+84+12*4)
#define	ITEM_DATA_Y			(MENU2_LIST_Y+MENU2_LIST_OFS*6)
#define	FRIEND_DATA_X		(MENU2_LIST_X+84)
#define	FRIEND_DATA_Y		(MENU2_LIST_Y+MENU2_LIST_OFS*7)
#define	CONDITION_DATA_X	(MENU2_LIST_X+84)
#define	CONDITION_DATA_Y	(MENU2_LIST_Y+MENU2_LIST_OFS*8)
#define	DEFAULT_HP_DATA_X	(MENU2_LIST_X+84)
#define	DEFAULT_HP_DATA_Y	(MENU2_LIST_Y+MENU2_LIST_OFS*9)

static	const	MENU_LIST_PARAM	mlp_s2[]={
	//MENU2_WAZA1
	{
		WAZA1_CUR_X,			//J[\Xʒu
		WAZA1_CUR_Y,			//J[\Yʒu
		MENU2_DEFAULT_HP,		//L[Ƃ̈ړ
		MENU2_WAZA2,			//L[Ƃ̈ړ
		NO_MOVE,				//L[Ƃ̈ړ
		NO_MOVE,				//EL[Ƃ̈ړ
		DebugFightWazaAct,		//A{^Ƃ̃ANV
	},
	//MENU2_WAZA2
	{
		WAZA2_CUR_X,			//J[\Xʒu
		WAZA2_CUR_Y,			//J[\Yʒu
		MENU2_WAZA1,			//L[Ƃ̈ړ
		MENU2_WAZA3,			//L[Ƃ̈ړ
		NO_MOVE,				//L[Ƃ̈ړ
		NO_MOVE,				//EL[Ƃ̈ړ
		DebugFightWazaAct,		//A{^Ƃ̃ANV
	},
	//MENU2_WAZA3
	{
		WAZA3_CUR_X,			//J[\Xʒu
		WAZA3_CUR_Y,			//J[\Yʒu
		MENU2_WAZA2,			//L[Ƃ̈ړ
		MENU2_WAZA4,			//L[Ƃ̈ړ
		NO_MOVE,				//L[Ƃ̈ړ
		NO_MOVE,				//EL[Ƃ̈ړ
		DebugFightWazaAct,		//A{^Ƃ̃ANV
	},
	//MENU2_WAZA4
	{
		WAZA4_CUR_X,			//J[\Xʒu
		WAZA4_CUR_Y,			//J[\Yʒu
		MENU2_WAZA3,			//L[Ƃ̈ړ
		MENU2_SPEABI,			//L[Ƃ̈ړ
		NO_MOVE,				//L[Ƃ̈ړ
		NO_MOVE,				//EL[Ƃ̈ړ
		DebugFightWazaAct,		//A{^Ƃ̃ANV
	},
	//MENU2_SPEABI
	{
		SPEABI_CUR_X,			//J[\Xʒu
		SPEABI_CUR_Y,			//J[\Yʒu
		MENU2_WAZA4,			//L[Ƃ̈ړ
		MENU2_SPEABI_SET,		//L[Ƃ̈ړ
		NO_MOVE,				//L[Ƃ̈ړ
		NO_MOVE,				//EL[Ƃ̈ړ
		DebugFightSpeAbiAct,	//A{^Ƃ̃ANV
	},
	//MENU2_SPEABI_SET
	{
		SPEABI_SET_CUR_X,		//J[\Xʒu
		SPEABI_SET_CUR_Y,		//J[\Yʒu
		MENU2_SPEABI,			//L[Ƃ̈ړ
		MENU2_ITEM,				//L[Ƃ̈ړ
		NO_MOVE,				//L[Ƃ̈ړ
		NO_MOVE,				//EL[Ƃ̈ړ
		DebugFightSpeAbiSetAct,	//A{^Ƃ̃ANV
	},
	//MENU2_ITEM
	{
		ITEM_CUR_X,				//J[\Xʒu
		ITEM_CUR_Y,				//J[\Yʒu
		MENU2_SPEABI_SET,		//L[Ƃ̈ړ
		MENU2_FRIEND,			//L[Ƃ̈ړ
		NO_MOVE,				//L[Ƃ̈ړ
		NO_MOVE,				//EL[Ƃ̈ړ
		DebugFightItemAct,		//A{^Ƃ̃ANV
	},
	//MENU2_FRIEND
	{
		FRIEND_CUR_X,			//J[\Xʒu
		FRIEND_CUR_Y,			//J[\Yʒu
		MENU2_ITEM,				//L[Ƃ̈ړ
		MENU2_CONDITION,		//L[Ƃ̈ړ
		NO_MOVE,				//L[Ƃ̈ړ
		NO_MOVE,				//EL[Ƃ̈ړ
		DebugFightFriendAct,	//A{^Ƃ̃ANV
	},
	//MENU2_CONDITION
	{
		CONDITION_CUR_X,		//J[\Xʒu
		CONDITION_CUR_Y,		//J[\Yʒu
		MENU2_FRIEND,			//L[Ƃ̈ړ
		MENU2_DEFAULT_HP,		//L[Ƃ̈ړ
		NO_MOVE,				//L[Ƃ̈ړ
		NO_MOVE,				//EL[Ƃ̈ړ
		DebugFightConditionAct,	//A{^Ƃ̃ANV
	},
	//MENU2_DEFAULT_HP
	{
		DEFAULT_HP_CUR_X,		//J[\Xʒu
		DEFAULT_HP_CUR_Y,		//J[\Yʒu
		MENU2_CONDITION,		//L[Ƃ̈ړ
		MENU2_WAZA1,			//L[Ƃ̈ړ
		NO_MOVE,				//L[Ƃ̈ړ
		NO_MOVE,				//EL[Ƃ̈ړ
		DebugFightDefaultHPAct,	//A{^Ƃ̃ANV
	},
};

static	const	MENU_LIST_PARAM	*	const	mlp_s_list[]={
	mlp_s1,
	mlp_s2,
};

enum{
	SEQ_MAIN_MENU_MOVE=0,
	SEQ_A_BUTTON_ACT,
	SEQ_BATTLE_INIT,
	SEQ_BATTLE_MAIN,
};

enum{
	MOVE_MAIN=0,
	MOVE_SUB,
};

enum{
	MODE_NORMAL=0,
	MODE_ACTIVE,
	MODE_LOOP,
	MODE_STOP,
	MODE_DEFAULT_PARAM,
	MODE_DEFAULT_WAZA,
};

#define	NORMAL_LETTER	(1)
#define	NORMAL_SHADOW	(2)
#define	NORMAL_GROUND	(15)

#define	ACTIVE_LETTER	(3)
#define	ACTIVE_SHADOW	(2)
#define	ACTIVE_GROUND	(15)

#define	CURSOR_LETTER	(4)
#define	CURSOR_SHADOW	(2)
#define	CURSOR_GROUND	(15)

#define	COL_NORMAL		(GF_PRINTCOLOR_MAKE(NORMAL_LETTER,NORMAL_SHADOW,NORMAL_GROUND))
#define	COL_ACTIVE		(GF_PRINTCOLOR_MAKE(ACTIVE_LETTER,ACTIVE_SHADOW,ACTIVE_GROUND))
#define	COL_CURSOR		(GF_PRINTCOLOR_MAKE(CURSOR_LETTER,CURSOR_SHADOW,CURSOR_GROUND))

static	const	u16	pal[]={
		GX_RGB(31,31,31),				//0:
		GX_RGB(13,13,13),				//1:ZD
		GX_RGB(24,24,24),				//2:D
		GX_RGB(15,31,15),				//3:݂ǂ
		GX_RGB(31,15,15),				//4:
		GX_RGB( 0, 0, 0),
		GX_RGB( 0, 0, 0),
		GX_RGB( 0, 0, 0),
		GX_RGB( 0, 0, 0),
		GX_RGB( 0, 0, 0),
		GX_RGB( 0, 0, 0),
		GX_RGB( 0, 0, 0),
		GX_RGB( 0, 0, 0),
		GX_RGB( 0, 0, 0),
		GX_RGB( 0, 0, 0),
		GX_RGB(31,31,31),				//15:
};

enum{
	NUM_CALC_NONE=0,
	NUM_CALC_MOVE,
	NUM_CALC_CHANGE,
	NUM_CALC_END,
};

static	const	int	param_mode_tbl[]={
	MODE_DEFAULT_PARAM,
	MODE_DEFAULT_WAZA,
};

enum{
	FT_YASEI=0,
	FT_TRAINER,
	FT_2vs2,
	FT_1vs1_SIO_P,
	FT_1vs1_SIO_C,
	FT_2vs2_SIO_P,
	FT_2vs2_SIO_C,
	FT_MULTI_SIO_P,
	FT_MULTI_SIO_C,
//	FT_2vs2_YASEI,
//	FT_AI_MULTI,
	FIGHT_TYPE_MAX

};

static	const	u32	fight_type_table[][2]={
	{FIGHT_TYPE_YASEI,			0x03},
	{FIGHT_TYPE_TRAINER,		0x03},
	{FIGHT_TYPE_2vs2_TRAINER,	0x0f},
	{FIGHT_TYPE_1vs1_SIO,		0x03},
	{FIGHT_TYPE_1vs1_SIO,		0x03},
	{FIGHT_TYPE_2vs2_SIO,		0x0f},
	{FIGHT_TYPE_2vs2_SIO,		0x0f},
	{FIGHT_TYPE_MULTI_SIO,		0x03},
	{FIGHT_TYPE_MULTI_SIO,		0x03},
	{FIGHT_TYPE_2vs2_YASEI,		0x0f},
	{FIGHT_TYPE_AI_MULTI,		0x0f},
};

#define	DEBUG_FIGHT_END_KEY	(PAD_BUTTON_L|PAD_BUTTON_R|PAD_BUTTON_SELECT)

//==================================================================================================
//
//	֐
//
//==================================================================================================

static	void	InitDebugFight(DEBUG_FIGHT_PARAM *dfp)
{
	int	i;

	MI_CpuClearFast(dfp,sizeof(DEBUG_FIGHT_PARAM));

	dfp->man_msg=MSGMAN_Create(MSGMAN_TYPE_NORMAL,ARC_MSG,NARC_msg_debug_fight_dat,HEAPID_DEBUG_APPLICATION);
	dfp->man_poke=MSGMAN_Create( MSGMAN_TYPE_NORMAL,ARC_MSG,NARC_msg_monsname_dat,HEAPID_DEBUG_APPLICATION);
	dfp->man_waza=MSGMAN_Create(MSGMAN_TYPE_NORMAL,ARC_MSG,NARC_msg_wazaname_dat,HEAPID_DEBUG_APPLICATION);
	dfp->man_chr=MSGMAN_Create(MSGMAN_TYPE_NORMAL,ARC_MSG,NARC_msg_chr_dat,HEAPID_DEBUG_APPLICATION);
	dfp->man_speabi=MSGMAN_Create(MSGMAN_TYPE_NORMAL,ARC_MSG,NARC_msg_tokusei_dat,HEAPID_DEBUG_APPLICATION);
	dfp->man_item=MSGMAN_Create(MSGMAN_TYPE_NORMAL,ARC_MSG,NARC_msg_itemname_dat,HEAPID_DEBUG_APPLICATION);

	dfp->end_flag = FALSE;
	dfp->bgl=GF_BGL_BglIniAlloc(HEAPID_DEBUG_APPLICATION);
	dfp->win_m=GF_BGL_BmpWinAllocGet(HEAPID_DEBUG_APPLICATION,1);
	dfp->win_s=GF_BGL_BmpWinAllocGet(HEAPID_DEBUG_APPLICATION,1);
	dfp->msg_buf=STRBUF_Create(0x100,HEAPID_DEBUG_APPLICATION);
	dfp->wordset=WORDSET_Create(HEAPID_DEBUG_APPLICATION);

	dfp->pp=PokemonParam_AllocWork(HEAPID_DEBUG_APPLICATION);

	DebugFightBGCreate(dfp,dfp->bgl);

	GF_BGL_BmpWinAdd(dfp->bgl,dfp->win_m,GF_BGL_FRAME1_M,0x00,0x00,32,24,0x00,0x01);
	GF_BGL_BmpWinAdd(dfp->bgl,dfp->win_s,GF_BGL_FRAME1_S,0x00,0x00,32,24,0x00,0x01);

	for(i=0;i<12;i++){
		DebugFightPokemonParamInit(&dfp->dsp.dpp[i]);
		if((i==0)||(i==6)){
			DebugFightDefaultPokeSet(dfp,i);
		}
	}

	dfp->flag=0xff;

	DebugFightMainScreenCreate(dfp);
	DebugFightSubScreenCreate(dfp,dfp->page);
	CursorMove(dfp,MOVE_MAIN,dfp->cur_pos_m,CUR_PUT);

	Snd_Stop();
}

//============================================================================================
/**
 *	퓬wiʏʐ
 */
//============================================================================================
static	void	DebugFightBGCreate(DEBUG_FIGHT_PARAM *dfp,GF_BGL_INI *bgl)
{
	GF_Disp_GX_VisibleControlInit();

	//VRAMݒ
	{
		GF_BGL_DISPVRAM vramSetTable = {
			GX_VRAM_BG_128_B,				// C2DGWBG
			GX_VRAM_BGEXTPLTT_NONE,			// C2DGWBGgpbg
			GX_VRAM_SUB_BG_128_C,			// Tu2DGWBG
			GX_VRAM_SUB_BGEXTPLTT_NONE,		// Tu2DGWBGgpbg
			GX_VRAM_OBJ_64_E,				// C2DGWOBJ
			GX_VRAM_OBJEXTPLTT_NONE,		// C2DGWOBJgpbg
			GX_VRAM_SUB_OBJ_16_I,			// Tu2DGWOBJ
			GX_VRAM_SUB_OBJEXTPLTT_NONE,	// Tu2DGWOBJgpbg
			GX_VRAM_TEX_0_A,				// eNX`C[WXbg
			GX_VRAM_TEXPLTT_01_FG			// eNX`pbgXbg
		};
		GF_Disp_SetBank( &vramSetTable );
	}

	// BG SYSTEM
	{
		GF_BGL_SYS_HEADER BGsys_data = {
			GX_DISPMODE_GRAPHICS, GX_BGMODE_0, GX_BGMODE_0, GX_BG0_AS_3D,
		};
		GF_BGL_InitBG( &BGsys_data );
	}

	//Cʃt[ݒ
	{
		GF_BGL_BGCNT_HEADER TextBgCntDat[] = {
			///<FRAME1_M
			{
				0, 0, 0x0800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
				GX_BG_SCRBASE_0x0000, GX_BG_CHARBASE_0x04000, GX_BG_EXTPLTT_01,
				0, 0, 0, FALSE
			},
		};
		GF_BGL_BGControlSet(bgl, GF_BGL_FRAME1_M, &TextBgCntDat[0], GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear(bgl, GF_BGL_FRAME1_M );
	}
	//Tuʃt[ݒ
	{
		GF_BGL_BGCNT_HEADER TextBgCntDat[] = {
			///<FRAME1_S
			{
				0, 0, 0x0800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
				GX_BG_SCRBASE_0x0000, GX_BG_CHARBASE_0x04000, GX_BG_EXTPLTT_01,
				0, 0, 0, FALSE
			},
		};
		GF_BGL_BGControlSet(bgl, GF_BGL_FRAME1_S, &TextBgCntDat[0], GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear(bgl, GF_BGL_FRAME1_S );
	}

	//wiOtBbNf[^[h
	{
		DC_FlushRange((void *)&pal,sizeof(pal));
		GX_LoadBGPltt((void *)&pal,0,sizeof(pal));
		DC_FlushRange((void *)&pal,sizeof(pal));
		GXS_LoadBGPltt((void *)&pal,0,sizeof(pal));
	}

	GF_Disp_DispOn();

	sys_VBlankFuncChange(DebugFightVBlank,dfp);

	FontProc_LoadBitData(FONT_SYSTEM,HEAPID_DEBUG_APPLICATION);
}

//============================================================================================
/**
 *	fobOt@Cgp|Pp[^
 */
//============================================================================================
static	void	DebugFightPokemonParamInit(DEBUG_POKEMON_PARAM *dpp)
{
	MI_CpuClearFast(dpp,sizeof(DEBUG_POKEMON_PARAM));

	dpp->level=1;
	dpp->exp=1;
	dpp->waza[0]=WAZANO_HATAKU;
}

//============================================================================================
/**
 *	CXN[
 */
//============================================================================================

static	void	DebugFightMainScreenCreate(DEBUG_FIGHT_PARAM *dfp)
{
	int		i;

	GF_BGL_BmpWinDataFill(dfp->win_m,0xff);

	MSGMAN_GetString(dfp->man_msg,DF_MINE,dfp->msg_buf);
	GF_STR_PrintSimple(dfp->win_m,FONT_SYSTEM,dfp->msg_buf,MINE_X,MINE_Y,MSG_NO_PUT,NULL);
	MSGMAN_GetString(dfp->man_msg,DF_ENEMY,dfp->msg_buf);
	GF_STR_PrintSimple(dfp->win_m,FONT_SYSTEM,dfp->msg_buf,ENEMY_X,ENEMY_Y,MSG_NO_PUT,NULL);

	MSGMAN_GetString(dfp->man_msg,DF_LOAD,dfp->msg_buf);
	GF_STR_PrintSimple(dfp->win_m,FONT_SYSTEM,dfp->msg_buf,LOAD_X,LOAD_Y,MSG_NO_PUT,NULL);
	MSGMAN_GetString(dfp->man_msg,DF_SAVE,dfp->msg_buf);
	GF_STR_PrintSimple(dfp->win_m,FONT_SYSTEM,dfp->msg_buf,SAVE_X,SAVE_Y,MSG_NO_PUT,NULL);

	for(i=0;i<12;i++){
		DebugFightMonsNamePut(dfp,i);
	}

	DebugFightFightTypePut(dfp);
	DebugFightFightTypeDataPut(dfp,COL_NORMAL);
	DebugFightGroundPut(dfp);
	DebugFightGroundDataPut(dfp,COL_NORMAL);
	DebugFightMySexPut(dfp);
	DebugFightMySexDataPut(dfp,COL_NORMAL);

	dfp->put_req=1;
}

static	const	u16	MonsNamePosTable[][2]={
	{MINE_POKE_X,MINE_POKE_Y+MINE_POKE_Y_OFS*0},
	{MINE_POKE_X,MINE_POKE_Y+MINE_POKE_Y_OFS*1},
	{MINE_POKE_X,MINE_POKE_Y+MINE_POKE_Y_OFS*2},
	{MINE_POKE_X,MINE_POKE_Y+MINE_POKE_Y_OFS*3},
	{MINE_POKE_X,MINE_POKE_Y+MINE_POKE_Y_OFS*4},
	{MINE_POKE_X,MINE_POKE_Y+MINE_POKE_Y_OFS*5},
	{ENEMY_POKE_X,ENEMY_POKE_Y+ENEMY_POKE_Y_OFS*0},
	{ENEMY_POKE_X,ENEMY_POKE_Y+ENEMY_POKE_Y_OFS*1},
	{ENEMY_POKE_X,ENEMY_POKE_Y+ENEMY_POKE_Y_OFS*2},
	{ENEMY_POKE_X,ENEMY_POKE_Y+ENEMY_POKE_Y_OFS*3},
	{ENEMY_POKE_X,ENEMY_POKE_Y+ENEMY_POKE_Y_OFS*4},
	{ENEMY_POKE_X,ENEMY_POKE_Y+ENEMY_POKE_Y_OFS*5},
};

static	void	DebugFightMonsNamePut(DEBUG_FIGHT_PARAM *dfp,int pos)
{
	GF_BGL_BmpWinFill(dfp->win_m,0x0f,MonsNamePosTable[pos][0],MonsNamePosTable[pos][1],120,16);
	MSGMAN_GetString(dfp->man_poke,dfp->dsp.dpp[pos].mons_no,dfp->msg_buf);
	GF_STR_PrintSimple(dfp->win_m,FONT_SYSTEM,dfp->msg_buf,MonsNamePosTable[pos][0],MonsNamePosTable[pos][1],MSG_NO_PUT,NULL);
	dfp->put_req=1;
}

static	void	DebugFightFightTypePut(DEBUG_FIGHT_PARAM *dfp)
{
	MSGMAN_GetString(dfp->man_msg,DF_FIGHTTYPE,dfp->msg_buf);
	GF_STR_PrintSimple(dfp->win_m,FONT_SYSTEM,dfp->msg_buf,FIGHT_TYPE_X,FIGHT_TYPE_Y,MSG_NO_PUT,NULL);
	dfp->put_req=1;
}

static	void	DebugFightFightTypeDataPut(DEBUG_FIGHT_PARAM *dfp,GF_PRINTCOLOR col)
{
	GF_BGL_BmpWinFill(dfp->win_m,0x0f,FIGHT_TYPE_DATA_X,FIGHT_TYPE_DATA_Y,120,16);
	MSGMAN_GetString(dfp->man_msg,DF_FT_1VS1+dfp->dsp.fight_type,dfp->msg_buf);
	GF_STR_PrintColor(dfp->win_m,FONT_SYSTEM,dfp->msg_buf,FIGHT_TYPE_DATA_X,FIGHT_TYPE_DATA_Y,MSG_NO_PUT,col,NULL);
	dfp->put_req=1;
}

static	void	DebugFightGroundPut(DEBUG_FIGHT_PARAM *dfp)
{
	MSGMAN_GetString(dfp->man_msg,DF_GROUND,dfp->msg_buf);
	GF_STR_PrintSimple(dfp->win_m,FONT_SYSTEM,dfp->msg_buf,BG_X,BG_Y,MSG_NO_PUT,NULL);
	dfp->put_req=1;
}

static	void	DebugFightGroundDataPut(DEBUG_FIGHT_PARAM *dfp,GF_PRINTCOLOR col)
{
	GF_BGL_BmpWinFill(dfp->win_m,0x0f,BG_DATA_X,BG_DATA_Y,12*6,16);
	MSGMAN_GetString(dfp->man_msg,DF_GROUND_GRAVEL+dfp->dsp.ground,dfp->msg_buf);
	GF_STR_PrintColor(dfp->win_m,FONT_SYSTEM,dfp->msg_buf,BG_DATA_X,BG_DATA_Y,MSG_NO_PUT,col,NULL);
	dfp->put_req=1;
}

static	void	DebugFightMySexPut(DEBUG_FIGHT_PARAM *dfp)
{
	MSGMAN_GetString(dfp->man_msg,DF_MYSEX,dfp->msg_buf);
	GF_STR_PrintSimple(dfp->win_m,FONT_SYSTEM,dfp->msg_buf,MYSEX_X,MYSEX_Y,MSG_NO_PUT,NULL);
	dfp->put_req=1;
}

static	void	DebugFightMySexDataPut(DEBUG_FIGHT_PARAM *dfp,GF_PRINTCOLOR col)
{
	GF_BGL_BmpWinFill(dfp->win_m,0x0f,MYSEX_DATA_X,MYSEX_DATA_Y,12*3,16);
	MSGMAN_GetString(dfp->man_msg,DF_BOY+dfp->dsp.my_sex,dfp->msg_buf);
	GF_STR_PrintColor(dfp->win_m,FONT_SYSTEM,dfp->msg_buf,MYSEX_DATA_X,MYSEX_DATA_Y,MSG_NO_PUT,col,NULL);
	dfp->put_req=1;
}

//============================================================================================
/**
 *	TuXN[
 */
//============================================================================================

static	void	DebugFightSubScreenCreate(DEBUG_FIGHT_PARAM *dfp,int page)
{
	switch(page){
	case 0:
		{
			int	i;

			if(page!=dfp->flag){
				dfp->flag=page;

				GF_BGL_BmpWinDataFill(dfp->win_s,0xff);

				DebugFightKindPut(dfp);
				DebugFightLevelPut(dfp);
				DebugFightExpPut(dfp);
				DebugFightSexPut(dfp);
				DebugFightChrPut(dfp);

				DebugFightHPRndPut(dfp);
				DebugFightPowRndPut(dfp);
				DebugFightDefRndPut(dfp);
				DebugFightAgiRndPut(dfp);
				DebugFightSpePowRndPut(dfp);
				DebugFightSpeDefRndPut(dfp);

				DebugFightHPExpPut(dfp);
				DebugFightPowExpPut(dfp);
				DebugFightDefExpPut(dfp);
				DebugFightAgiExpPut(dfp);
				DebugFightSpePowExpPut(dfp);
				DebugFightSpeDefExpPut(dfp);
			}

			DebugFightKindDataPut(dfp,MODE_NORMAL);
			DebugFightLevelDataPut(dfp,MODE_NORMAL);
			DebugFightExpDataPut(dfp,MODE_NORMAL);
			DebugFightSexDataPut(dfp,COL_NORMAL);
			DebugFightChrDataPut(dfp,COL_NORMAL);

			for(i=STATUS_HP;i<STATUS_MAX;i++){
				DebugFightStatusRndDataPut(dfp,i,MODE_NORMAL);
				DebugFightStatusExpDataPut(dfp,i,MODE_NORMAL);
			}

			DebugFightParamPut(dfp);
		}
		break;
	case 1:
		{
			int	i;

			if(page!=dfp->flag){
				dfp->flag=page;

				GF_BGL_BmpWinDataFill(dfp->win_s,0xff);

				for(i=0;i<4;i++){
					DebugFightWazaPut(dfp,i);
				}

				DebugFightSpeAbiPut(dfp);
				DebugFightSpeAbiSetPut(dfp);
				DebugFightItemPut(dfp);
				DebugFightFriendPut(dfp);
				DebugFightConditionPut(dfp);
				DebugFightDefaultHPPut(dfp);
			}

			for(i=0;i<4;i++){
				DebugFightWazaDataPut(dfp,i,MODE_NORMAL);
			}

			DebugFightSpeAbiDataPut(dfp,COL_NORMAL);
			DebugFightSpeAbiSetDataPut(dfp,MODE_NORMAL);
			DebugFightItemDataPut(dfp,MODE_NORMAL);
			DebugFightFriendDataPut(dfp,MODE_NORMAL);
			DebugFightConditionDataPut(dfp,COL_NORMAL);
			DebugFightDefaultHPDataPut(dfp,MODE_NORMAL);
		}
		break;
	default:
		dfp->flag=page;
		GF_BGL_BmpWinOn(dfp->win_s);
		break;
	}
}

static	void	DebugFightKindPut(DEBUG_FIGHT_PARAM *dfp)
{
	MSGMAN_GetString(dfp->man_msg,DF_KIND,dfp->msg_buf);
	GF_STR_PrintSimple(dfp->win_s,FONT_SYSTEM,dfp->msg_buf,MENU1_LIST_L_X,MENU1_LIST_Y+MENU1_LIST_OFS*0,MSG_NO_PUT,NULL);
	dfp->put_req=1;
}

static	void	DebugFightKindDataPut(DEBUG_FIGHT_PARAM *dfp,int mode)
{
	GF_BGL_BmpWinFill(dfp->win_s,0x0f,KIND_DATA_X,KIND_DATA_Y,256-KIND_DATA_X,16);

	DebugFightNumPut(dfp,KIND_DATA_X,KIND_DATA_Y,dfp->dsp.dpp[dfp->cur_pos_m].mons_no,3,dfp->cur_pos_keta,mode);

	MSGMAN_GetString(dfp->man_poke,dfp->dsp.dpp[dfp->cur_pos_m].mons_no,dfp->msg_buf);
	GF_STR_PrintSimple(dfp->win_s,FONT_SYSTEM,dfp->msg_buf,KIND_NAME_X,KIND_DATA_Y,MSG_NO_PUT,NULL);
	dfp->put_req=1;
}

static	void	DebugFightLevelPut(DEBUG_FIGHT_PARAM *dfp)
{
	MSGMAN_GetString(dfp->man_msg,DF_LEVEL,dfp->msg_buf);
	GF_STR_PrintSimple(dfp->win_s,FONT_SYSTEM,dfp->msg_buf,MENU1_LIST_L_X,MENU1_LIST_Y+MENU1_LIST_OFS*1,MSG_NO_PUT,NULL);
	dfp->put_req=1;
}

static	void	DebugFightLevelDataPut(DEBUG_FIGHT_PARAM *dfp,int mode)
{
	GF_BGL_BmpWinFill(dfp->win_s,0x0f,LEVEL_DATA_X,LEVEL_DATA_Y,12*LEVEL_KETA,16);
	DebugFightNumPut(dfp,LEVEL_DATA_X,LEVEL_DATA_Y,dfp->dsp.dpp[dfp->cur_pos_m].level,LEVEL_KETA,dfp->cur_pos_keta,mode);
}

static	void	DebugFightExpPut(DEBUG_FIGHT_PARAM *dfp)
{
	MSGMAN_GetString(dfp->man_msg,DF_EXP,dfp->msg_buf);
	GF_STR_PrintSimple(dfp->win_s,FONT_SYSTEM,dfp->msg_buf,EXP_LIST_X,MENU1_LIST_Y+MENU1_LIST_OFS*1,MSG_NO_PUT,NULL);
	dfp->put_req=1;
}

static	void	DebugFightExpDataPut(DEBUG_FIGHT_PARAM *dfp,int mode)
{
	GF_BGL_BmpWinFill(dfp->win_s,0x0f,EXP_DATA_X,EXP_DATA_Y,12*EXP_KETA,16);
	DebugFightNumPut(dfp,EXP_DATA_X,EXP_DATA_Y,dfp->dsp.dpp[dfp->cur_pos_m].exp,EXP_KETA,dfp->cur_pos_keta,mode);
}

static	void	DebugFightSexPut(DEBUG_FIGHT_PARAM *dfp)
{
	MSGMAN_GetString(dfp->man_msg,DF_SEX,dfp->msg_buf);
	GF_STR_PrintSimple(dfp->win_s,FONT_SYSTEM,dfp->msg_buf,MENU1_LIST_L_X,MENU1_LIST_Y+MENU1_LIST_OFS*2,MSG_NO_PUT,NULL);
	dfp->put_req=1;
}

static	void	DebugFightSexDataPut(DEBUG_FIGHT_PARAM *dfp,GF_PRINTCOLOR col)
{
	GF_BGL_BmpWinFill(dfp->win_s,0x0f,SEX_DATA_X,SEX_DATA_Y,12*3,16);
	MSGMAN_GetString(dfp->man_msg,DF_MALE+dfp->dsp.dpp[dfp->cur_pos_m].sex,dfp->msg_buf);
	GF_STR_PrintColor(dfp->win_s,FONT_SYSTEM,dfp->msg_buf,SEX_DATA_X,SEX_DATA_Y,MSG_NO_PUT,col,NULL);
	dfp->put_req=1;
}

static	void	DebugFightChrPut(DEBUG_FIGHT_PARAM *dfp)
{
	MSGMAN_GetString(dfp->man_msg,DF_CHR,dfp->msg_buf);
	GF_STR_PrintSimple(dfp->win_s,FONT_SYSTEM,dfp->msg_buf,CHR_LIST_X,MENU1_LIST_Y+MENU1_LIST_OFS*2,MSG_NO_PUT,NULL);
	dfp->put_req=1;
}

static	void	DebugFightChrDataPut(DEBUG_FIGHT_PARAM *dfp,GF_PRINTCOLOR col)
{
	GF_BGL_BmpWinFill(dfp->win_s,0x0f,CHR_DATA_X,CHR_DATA_Y,12*5,16);
	MSGMAN_GetString(dfp->man_chr,dfp->dsp.dpp[dfp->cur_pos_m].chr,dfp->msg_buf);
	GF_STR_PrintColor(dfp->win_s,FONT_SYSTEM,dfp->msg_buf,CHR_DATA_X,CHR_DATA_Y,MSG_NO_PUT,col,NULL);
	dfp->put_req=1;
}

static	void	DebugFightHPRndPut(DEBUG_FIGHT_PARAM *dfp)
{
	MSGMAN_GetString(dfp->man_msg,DF_HPRND,dfp->msg_buf);
	GF_STR_PrintSimple(dfp->win_s,FONT_SYSTEM,dfp->msg_buf,MENU1_LIST_L_X,MENU1_LIST_Y+MENU1_LIST_OFS*3,MSG_NO_PUT,NULL);
	dfp->put_req=1;
}

static	void	DebugFightHPExpPut(DEBUG_FIGHT_PARAM *dfp)
{
	MSGMAN_GetString(dfp->man_msg,DF_HPEXP,dfp->msg_buf);
	GF_STR_PrintSimple(dfp->win_s,FONT_SYSTEM,dfp->msg_buf,MENU1_LIST_R_X,MENU1_LIST_Y+MENU1_LIST_OFS*3,MSG_NO_PUT,NULL);
	dfp->put_req=1;
}

static	void	DebugFightPowRndPut(DEBUG_FIGHT_PARAM *dfp)
{
	MSGMAN_GetString(dfp->man_msg,DF_POWRND,dfp->msg_buf);
	GF_STR_PrintSimple(dfp->win_s,FONT_SYSTEM,dfp->msg_buf,MENU1_LIST_L_X,MENU1_LIST_Y+MENU1_LIST_OFS*4,MSG_NO_PUT,NULL);
	dfp->put_req=1;
}

static	void	DebugFightPowExpPut(DEBUG_FIGHT_PARAM *dfp)
{
	MSGMAN_GetString(dfp->man_msg,DF_POWEXP,dfp->msg_buf);
	GF_STR_PrintSimple(dfp->win_s,FONT_SYSTEM,dfp->msg_buf,MENU1_LIST_R_X,MENU1_LIST_Y+MENU1_LIST_OFS*4,MSG_NO_PUT,NULL);
	dfp->put_req=1;
}

static	void	DebugFightDefRndPut(DEBUG_FIGHT_PARAM *dfp)
{
	MSGMAN_GetString(dfp->man_msg,DF_DEFRND,dfp->msg_buf);
	GF_STR_PrintSimple(dfp->win_s,FONT_SYSTEM,dfp->msg_buf,MENU1_LIST_L_X,MENU1_LIST_Y+MENU1_LIST_OFS*5,MSG_NO_PUT,NULL);
	dfp->put_req=1;
}

static	void	DebugFightDefExpPut(DEBUG_FIGHT_PARAM *dfp)
{
	MSGMAN_GetString(dfp->man_msg,DF_DEFEXP,dfp->msg_buf);
	GF_STR_PrintSimple(dfp->win_s,FONT_SYSTEM,dfp->msg_buf,MENU1_LIST_R_X,MENU1_LIST_Y+MENU1_LIST_OFS*5,MSG_NO_PUT,NULL);
	dfp->put_req=1;
}

static	void	DebugFightAgiRndPut(DEBUG_FIGHT_PARAM *dfp)
{
	MSGMAN_GetString(dfp->man_msg,DF_AGIRND,dfp->msg_buf);
	GF_STR_PrintSimple(dfp->win_s,FONT_SYSTEM,dfp->msg_buf,MENU1_LIST_L_X,MENU1_LIST_Y+MENU1_LIST_OFS*6,MSG_NO_PUT,NULL);
	dfp->put_req=1;
}

static	void	DebugFightAgiExpPut(DEBUG_FIGHT_PARAM *dfp)
{
	MSGMAN_GetString(dfp->man_msg,DF_AGIEXP,dfp->msg_buf);
	GF_STR_PrintSimple(dfp->win_s,FONT_SYSTEM,dfp->msg_buf,MENU1_LIST_R_X,MENU1_LIST_Y+MENU1_LIST_OFS*6,MSG_NO_PUT,NULL);
	dfp->put_req=1;
}

static	void	DebugFightSpePowRndPut(DEBUG_FIGHT_PARAM *dfp)
{
	MSGMAN_GetString(dfp->man_msg,DF_SPEPOWRND,dfp->msg_buf);
	GF_STR_PrintSimple(dfp->win_s,FONT_SYSTEM,dfp->msg_buf,MENU1_LIST_L_X,MENU1_LIST_Y+MENU1_LIST_OFS*7,MSG_NO_PUT,NULL);
	dfp->put_req=1;
}

static	void	DebugFightSpePowExpPut(DEBUG_FIGHT_PARAM *dfp)
{
	MSGMAN_GetString(dfp->man_msg,DF_SPEPOWEXP,dfp->msg_buf);
	GF_STR_PrintSimple(dfp->win_s,FONT_SYSTEM,dfp->msg_buf,MENU1_LIST_R_X,MENU1_LIST_Y+MENU1_LIST_OFS*7,MSG_NO_PUT,NULL);
	dfp->put_req=1;
}

static	void	DebugFightSpeDefRndPut(DEBUG_FIGHT_PARAM *dfp)
{
	MSGMAN_GetString(dfp->man_msg,DF_SPEDEFRND,dfp->msg_buf);
	GF_STR_PrintSimple(dfp->win_s,FONT_SYSTEM,dfp->msg_buf,MENU1_LIST_L_X,MENU1_LIST_Y+MENU1_LIST_OFS*8,MSG_NO_PUT,NULL);
	dfp->put_req=1;
}

static	void	DebugFightSpeDefExpPut(DEBUG_FIGHT_PARAM *dfp)
{
	MSGMAN_GetString(dfp->man_msg,DF_SPEDEFEXP,dfp->msg_buf);
	GF_STR_PrintSimple(dfp->win_s,FONT_SYSTEM,dfp->msg_buf,MENU1_LIST_R_X,MENU1_LIST_Y+MENU1_LIST_OFS*8,MSG_NO_PUT,NULL);
	dfp->put_req=1;
}

static	void	DebugFightStatusRndDataPut(DEBUG_FIGHT_PARAM *dfp,int status,int mode)
{
	GF_BGL_BmpWinFill(dfp->win_s,0x0f,STRND_DATA_X,STRND_DATA_Y+STRND_DATA_OFS*status,12*STRND_KETA,16);
	DebugFightNumPut(dfp,STRND_DATA_X,STRND_DATA_Y+STRND_DATA_OFS*status,dfp->dsp.dpp[dfp->cur_pos_m].status_rnd[status],
					STRND_KETA,dfp->cur_pos_keta,mode);
}

static	void	DebugFightStatusExpDataPut(DEBUG_FIGHT_PARAM *dfp,int status,int mode)
{
	GF_BGL_BmpWinFill(dfp->win_s,0x0f,STEXP_DATA_X,STEXP_DATA_Y+STEXP_DATA_OFS*status,12*STEXP_KETA,16);
	DebugFightNumPut(dfp,STEXP_DATA_X,STEXP_DATA_Y+STEXP_DATA_OFS*status,dfp->dsp.dpp[dfp->cur_pos_m].status_exp[status],
					STEXP_KETA,dfp->cur_pos_keta,mode);
}

static	void	DebugFightParamPut(DEBUG_FIGHT_PARAM *dfp)
{
	STRBUF	*src_buf1;
	STRBUF	*src_buf2;

	GF_BGL_BmpWinFill(dfp->win_s,0x0f,0,PARAM1_LIST_Y,256,32);

	src_buf1=MSGMAN_AllocString(dfp->man_msg,DF_PARAM1);
	src_buf2=MSGMAN_AllocString(dfp->man_msg,DF_PARAM2);

	if(dfp->dsp.dpp[dfp->cur_pos_m].mons_no){
		{
			int		i;
			u32		hp_max;
			int		mpp;
			int		mpt;
			u32		rnd;
			BOOL	flag;

#if 0
			PokeParaSetSexChr(dfp->pp,
							  dfp->dsp.dpp[dfp->cur_pos_m].mons_no,
							  dfp->dsp.dpp[dfp->cur_pos_m].level,
							  0,
							  dfp->dsp.dpp[dfp->cur_pos_m].sex,
							  dfp->dsp.dpp[dfp->cur_pos_m].chr,
							  0);
#endif

			flag=PokeParaFastModeOn(dfp->pp);

			PokeParaPutFast(dfp->pp,ID_PARA_monsno,&dfp->dsp.dpp[dfp->cur_pos_m].mons_no);
			PokeParaPutFast(dfp->pp,ID_PARA_level,&dfp->dsp.dpp[dfp->cur_pos_m].level);
			PokeParaPutFast(dfp->pp,ID_PARA_exp,&dfp->dsp.dpp[dfp->cur_pos_m].exp);
			rnd=PokeParaSexChrRndGet(dfp->dsp.dpp[dfp->cur_pos_m].mons_no,
									 dfp->dsp.dpp[dfp->cur_pos_m].sex,
									 dfp->dsp.dpp[dfp->cur_pos_m].chr);
			PokeParaPutFast(dfp->pp,ID_PARA_personal_rnd,&rnd);

			for(i=STATUS_HP;i<STATUS_MAX;i++){
				PokeParaPutFast(dfp->pp,ID_PARA_hp_rnd+i,&dfp->dsp.dpp[dfp->cur_pos_m].status_rnd[i]);
				PokeParaPutFast(dfp->pp,ID_PARA_hp_exp+i,&dfp->dsp.dpp[dfp->cur_pos_m].status_exp[i]);
			}
			mpp=	((dfp->dsp.dpp[dfp->cur_pos_m].status_rnd[0]&2)>>1)|
					((dfp->dsp.dpp[dfp->cur_pos_m].status_rnd[1]&2)>>0)|
					((dfp->dsp.dpp[dfp->cur_pos_m].status_rnd[2]&2)<<1)|
					((dfp->dsp.dpp[dfp->cur_pos_m].status_rnd[3]&2)<<2)|
					((dfp->dsp.dpp[dfp->cur_pos_m].status_rnd[4]&2)<<3)|
					((dfp->dsp.dpp[dfp->cur_pos_m].status_rnd[5]&2)<<4);
			mpt=	((dfp->dsp.dpp[dfp->cur_pos_m].status_rnd[0]&1)>>0)|
					((dfp->dsp.dpp[dfp->cur_pos_m].status_rnd[1]&1)<<1)|
					((dfp->dsp.dpp[dfp->cur_pos_m].status_rnd[2]&1)<<2)|
					((dfp->dsp.dpp[dfp->cur_pos_m].status_rnd[3]&1)<<3)|
					((dfp->dsp.dpp[dfp->cur_pos_m].status_rnd[4]&1)<<4)|
					((dfp->dsp.dpp[dfp->cur_pos_m].status_rnd[5]&1)<<5);

			mpp=mpp*40/63+30;
			mpt=(mpt*15/63)+1;

			if(mpt>=HATE_TYPE){
				mpt++;
			}
			PokeParaCalc(dfp->pp);
			hp_max=PokeParaGetFast(dfp->pp,ID_PARA_hpmax,NULL);
			WORDSET_RegisterNumber(dfp->wordset,0,hp_max,
									3,NUMBER_DISPTYPE_ZERO,NUMBER_CODETYPE_DEFAULT);
			WORDSET_RegisterNumber(dfp->wordset,1,PokeParaGetFast(dfp->pp,ID_PARA_pow,NULL),
									3,NUMBER_DISPTYPE_ZERO,NUMBER_CODETYPE_DEFAULT);
			WORDSET_RegisterNumber(dfp->wordset,2,PokeParaGetFast(dfp->pp,ID_PARA_def,NULL),
									3,NUMBER_DISPTYPE_ZERO,NUMBER_CODETYPE_DEFAULT);
			WORDSET_RegisterNumber(dfp->wordset,3,PokeParaGetFast(dfp->pp,ID_PARA_agi,NULL),
									3,NUMBER_DISPTYPE_ZERO,NUMBER_CODETYPE_DEFAULT);
			WORDSET_ExpandStr(dfp->wordset,dfp->msg_buf,src_buf1);
			GF_STR_PrintSimple(dfp->win_s,FONT_SYSTEM,dfp->msg_buf,PARAM1_LIST_X,PARAM1_LIST_Y,MSG_NO_PUT,NULL);
			WORDSET_RegisterNumber(dfp->wordset,0,PokeParaGetFast(dfp->pp,ID_PARA_spepow,NULL),
									3,NUMBER_DISPTYPE_ZERO,NUMBER_CODETYPE_DEFAULT);
			WORDSET_RegisterNumber(dfp->wordset,1,PokeParaGetFast(dfp->pp,ID_PARA_spedef,NULL),
									3,NUMBER_DISPTYPE_ZERO,NUMBER_CODETYPE_DEFAULT);
			WORDSET_RegisterNumber(dfp->wordset,2,mpp,3,NUMBER_DISPTYPE_ZERO,NUMBER_CODETYPE_DEFAULT);
			WORDSET_RegisterPokeTypeName(dfp->wordset,3,mpt);
			WORDSET_ExpandStr(dfp->wordset,dfp->msg_buf,src_buf2);
			GF_STR_PrintSimple(dfp->win_s,FONT_SYSTEM,dfp->msg_buf,PARAM2_LIST_X,PARAM2_LIST_Y,MSG_NO_PUT,NULL);
			if((hp_max<dfp->dsp.dpp[dfp->cur_pos_m].default_hp)||
			   (dfp->dsp.dpp[dfp->cur_pos_m].hp_max==dfp->dsp.dpp[dfp->cur_pos_m].default_hp)){
				dfp->dsp.dpp[dfp->cur_pos_m].default_hp=hp_max;
			}
			dfp->dsp.dpp[dfp->cur_pos_m].hp_max=hp_max;
			dfp->put_req=1;
			PokeParaFastModeOff(dfp->pp,flag);
		}
	}
	else{
		WORDSET_RegisterNumber(dfp->wordset,0,0,3,NUMBER_DISPTYPE_ZERO,NUMBER_CODETYPE_DEFAULT);
		WORDSET_RegisterNumber(dfp->wordset,1,0,3,NUMBER_DISPTYPE_ZERO,NUMBER_CODETYPE_DEFAULT);
		WORDSET_RegisterNumber(dfp->wordset,2,0,3,NUMBER_DISPTYPE_ZERO,NUMBER_CODETYPE_DEFAULT);
		WORDSET_RegisterNumber(dfp->wordset,3,0,3,NUMBER_DISPTYPE_ZERO,NUMBER_CODETYPE_DEFAULT);
		WORDSET_ExpandStr(dfp->wordset,dfp->msg_buf,src_buf1);
		GF_STR_PrintSimple(dfp->win_s,FONT_SYSTEM,dfp->msg_buf,PARAM1_LIST_X,PARAM1_LIST_Y,MSG_NO_PUT,NULL);
		WORDSET_RegisterPokeTypeName(dfp->wordset,3,0);
		WORDSET_ExpandStr(dfp->wordset,dfp->msg_buf,src_buf2);
		GF_STR_PrintSimple(dfp->win_s,FONT_SYSTEM,dfp->msg_buf,PARAM2_LIST_X,PARAM2_LIST_Y,MSG_NO_PUT,NULL);
		dfp->put_req=1;
	}
	sys_FreeMemoryEz(src_buf1);
	sys_FreeMemoryEz(src_buf2);
}

static	void	DebugFightDefaultSet(DEBUG_FIGHT_PARAM *dfp,int mode)
{
	int				i;

	PokeParaSetSexChr(dfp->pp,
					  dfp->dsp.dpp[dfp->cur_pos_m].mons_no,
					  dfp->dsp.dpp[dfp->cur_pos_m].level,
					  POW_RND,
					  dfp->dsp.dpp[dfp->cur_pos_m].sex,
					  dfp->dsp.dpp[dfp->cur_pos_m].chr,
					  0);
	switch(mode){
	case MODE_DEFAULT_PARAM:
		for(i=STATUS_HP;i<STATUS_MAX;i++){
			dfp->dsp.dpp[dfp->cur_pos_m].status_rnd[i]=PokeParaGet(dfp->pp,ID_PARA_hp_rnd+i,NULL);
		}
		break;
	case MODE_DEFAULT_WAZA:
		for(i=0;i<4;i++){
			dfp->dsp.dpp[dfp->cur_pos_m].waza[i]=PokeParaGet(dfp->pp,ID_PARA_waza1+i,NULL);
		}
		break;
	default:
		break;
	}
}

static	void	DebugFightWazaPut(DEBUG_FIGHT_PARAM *dfp,int pos)
{
	MSGMAN_GetString(dfp->man_msg,DF_WAZA1+pos,dfp->msg_buf);
	GF_STR_PrintSimple(dfp->win_s,FONT_SYSTEM,dfp->msg_buf,MENU2_LIST_X,MENU2_LIST_Y+MENU2_LIST_OFS*pos,MSG_NO_PUT,NULL);
	dfp->put_req=1;
}

static	void	DebugFightWazaDataPut(DEBUG_FIGHT_PARAM *dfp,int pos,int mode)
{
	GF_BGL_BmpWinFill(dfp->win_s,0x0f,WAZA_NUM_X,WAZA_NUM_Y+WAZA_NUM_OFS*pos,256-WAZA_NUM_X,16);

	DebugFightNumPut(dfp,WAZA_NUM_X,WAZA_NUM_Y+WAZA_NUM_OFS*pos,dfp->dsp.dpp[dfp->cur_pos_m].waza[pos],3,dfp->cur_pos_keta,mode);

	MSGMAN_GetString(dfp->man_waza,dfp->dsp.dpp[dfp->cur_pos_m].waza[pos],dfp->msg_buf);
	GF_STR_PrintSimple(dfp->win_s,FONT_SYSTEM,dfp->msg_buf,WAZA_DATA_X,WAZA_DATA_Y+WAZA_DATA_OFS*pos,MSG_NO_PUT,NULL);
	dfp->put_req=1;
}

static	void	DebugFightSpeAbiPut(DEBUG_FIGHT_PARAM *dfp)
{
	MSGMAN_GetString(dfp->man_msg,DF_SPEABI,dfp->msg_buf);
	GF_STR_PrintSimple(dfp->win_s,FONT_SYSTEM,dfp->msg_buf,MENU2_LIST_X,SPEABI_DATA_Y,MSG_NO_PUT,NULL);
	dfp->put_req=1;
}

static	void	DebugFightSpeAbiDataPut(DEBUG_FIGHT_PARAM *dfp,GF_PRINTCOLOR col)
{
	GF_BGL_BmpWinFill(dfp->win_s,0x0f,SPEABI_DATA_X,SPEABI_DATA_Y,12*7,16);

	if(dfp->dsp.dpp[dfp->cur_pos_m].speabi){
		dfp->dsp.dpp[dfp->cur_pos_m].speabino=PokePersonalParaGet(dfp->dsp.dpp[dfp->cur_pos_m].mons_no,ID_PER_speabi2);
	}
	else{
		dfp->dsp.dpp[dfp->cur_pos_m].speabino=PokePersonalParaGet(dfp->dsp.dpp[dfp->cur_pos_m].mons_no,ID_PER_speabi1);
	}

	MSGMAN_GetString(dfp->man_speabi,dfp->dsp.dpp[dfp->cur_pos_m].speabino,dfp->msg_buf);
	GF_STR_PrintColor(dfp->win_s,FONT_SYSTEM,dfp->msg_buf,SPEABI_DATA_X,SPEABI_DATA_Y,MSG_NO_PUT,col,NULL);
	dfp->put_req=1;
}

static	void	DebugFightSpeAbiSetPut(DEBUG_FIGHT_PARAM *dfp)
{
	MSGMAN_GetString(dfp->man_msg,DF_SPEABI_SET,dfp->msg_buf);
	GF_STR_PrintSimple(dfp->win_s,FONT_SYSTEM,dfp->msg_buf,MENU2_LIST_X,SPEABI_SET_DATA_Y,MSG_NO_PUT,NULL);
	dfp->put_req=1;
}

static	void	DebugFightSpeAbiSetDataPut(DEBUG_FIGHT_PARAM *dfp,int mode)
{
	GF_BGL_BmpWinFill(dfp->win_s,0x0f,SPEABI_DATA_X,SPEABI_SET_DATA_Y,12*11,16);

	DebugFightNumPut(dfp,SPEABI_SET_NUM_X,SPEABI_SET_NUM_Y,dfp->dsp.dpp[dfp->cur_pos_m].speabino_set,3,dfp->cur_pos_keta,mode);

	MSGMAN_GetString(dfp->man_speabi,dfp->dsp.dpp[dfp->cur_pos_m].speabino_set,dfp->msg_buf);
	GF_STR_PrintSimple(dfp->win_s,FONT_SYSTEM,dfp->msg_buf,SPEABI_SET_DATA_X,SPEABI_SET_DATA_Y,MSG_NO_PUT,NULL);
	dfp->put_req=1;
}

static	void	DebugFightItemPut(DEBUG_FIGHT_PARAM *dfp)
{
	MSGMAN_GetString(dfp->man_msg,DF_ITEM,dfp->msg_buf);
	GF_STR_PrintSimple(dfp->win_s,FONT_SYSTEM,dfp->msg_buf,MENU2_LIST_X,ITEM_DATA_Y,MSG_NO_PUT,NULL);
	dfp->put_req=1;
}

static	void	DebugFightItemDataPut(DEBUG_FIGHT_PARAM *dfp,int mode)
{
	GF_BGL_BmpWinFill(dfp->win_s,0x0f,ITEM_NUM_X,ITEM_NUM_Y,256-ITEM_NUM_X,16);

	DebugFightNumPut(dfp,ITEM_NUM_X,ITEM_NUM_Y,dfp->dsp.dpp[dfp->cur_pos_m].item,3,dfp->cur_pos_keta,mode);

	MSGMAN_GetString(dfp->man_item,dfp->dsp.dpp[dfp->cur_pos_m].item,dfp->msg_buf);
	GF_STR_PrintSimple(dfp->win_s,FONT_SYSTEM,dfp->msg_buf,ITEM_DATA_X,ITEM_DATA_Y,MSG_NO_PUT,NULL);
	dfp->put_req=1;
}

static	void	DebugFightFriendPut(DEBUG_FIGHT_PARAM *dfp)
{
	MSGMAN_GetString(dfp->man_msg,DF_FRIEND,dfp->msg_buf);
	GF_STR_PrintSimple(dfp->win_s,FONT_SYSTEM,dfp->msg_buf,MENU2_LIST_X,FRIEND_DATA_Y,MSG_NO_PUT,NULL);
	dfp->put_req=1;
}

static	void	DebugFightFriendDataPut(DEBUG_FIGHT_PARAM *dfp,int mode)
{
	GF_BGL_BmpWinFill(dfp->win_s,0x0f,FRIEND_DATA_X,FRIEND_DATA_Y,12*3,16);
	DebugFightNumPut(dfp,FRIEND_DATA_X,FRIEND_DATA_Y,dfp->dsp.dpp[dfp->cur_pos_m].friend,3,dfp->cur_pos_keta,mode);
}

static	void	DebugFightConditionPut(DEBUG_FIGHT_PARAM *dfp)
{
	MSGMAN_GetString(dfp->man_msg,DF_CONDITION,dfp->msg_buf);
	GF_STR_PrintSimple(dfp->win_s,FONT_SYSTEM,dfp->msg_buf,MENU2_LIST_X,CONDITION_DATA_Y,MSG_NO_PUT,NULL);
	dfp->put_req=1;
}

static	void	DebugFightConditionDataPut(DEBUG_FIGHT_PARAM *dfp,GF_PRINTCOLOR col)
{
	GF_BGL_BmpWinFill(dfp->win_s,0x0f,CONDITION_DATA_X,CONDITION_DATA_Y,256-CONDITION_DATA_X,16);
	MSGMAN_GetString(dfp->man_msg,DF_COND_NORMAL+dfp->dsp.dpp[dfp->cur_pos_m].condition,dfp->msg_buf);
	GF_STR_PrintColor(dfp->win_s,FONT_SYSTEM,dfp->msg_buf,CONDITION_DATA_X,CONDITION_DATA_Y,MSG_NO_PUT,col,NULL);
	dfp->put_req=1;
}

static	void	DebugFightDefaultHPPut(DEBUG_FIGHT_PARAM *dfp)
{
	MSGMAN_GetString(dfp->man_msg,DF_DEFAULT_HP,dfp->msg_buf);
	GF_STR_PrintSimple(dfp->win_s,FONT_SYSTEM,dfp->msg_buf,MENU2_LIST_X,DEFAULT_HP_DATA_Y,MSG_NO_PUT,NULL);
	dfp->put_req=1;
}

static	void	DebugFightDefaultHPDataPut(DEBUG_FIGHT_PARAM *dfp,int mode)
{
	GF_BGL_BmpWinFill(dfp->win_s,0x0f,DEFAULT_HP_DATA_X,DEFAULT_HP_DATA_Y,256-DEFAULT_HP_DATA_X,16);
	DebugFightNumPut(dfp,DEFAULT_HP_DATA_X,DEFAULT_HP_DATA_Y,dfp->dsp.dpp[dfp->cur_pos_m].default_hp,3,dfp->cur_pos_keta,mode);
	DebugFightNumPut(dfp,DEFAULT_HP_DATA_X+12*3,DEFAULT_HP_DATA_Y,dfp->dsp.dpp[dfp->cur_pos_m].hp_max,3,NULL,MODE_NORMAL);
}

static	void	DebugFightNumPut(DEBUG_FIGHT_PARAM *dfp,int x,int y,int param,int keta,int pos,int mode)
{
	int		i;
	int		data,ofs;
	int		keta_tbl[10]={
		1000000000,
		100000000,
		10000000,
		1000000,
		100000,
		10000,
		1000,
		100,
		10,
		1,
	};

	ofs=0;
	for(i=0;i<keta;i++){
		data=param/keta_tbl[10-keta+i];
		param%=keta_tbl[10-keta+i];
		STRBUF_SetNumber(dfp->msg_buf,data,1,NUMBER_DISPTYPE_ZERO,NUMBER_CODETYPE_DEFAULT);
		if(mode==MODE_NORMAL){
			GF_STR_PrintColor(dfp->win_s,FONT_SYSTEM,dfp->msg_buf,x+ofs,y,MSG_NO_PUT,COL_NORMAL,NULL);
		}
		else{
			if((keta-1)-i==pos){
				GF_STR_PrintColor(dfp->win_s,FONT_SYSTEM,dfp->msg_buf,x+ofs,y,MSG_NO_PUT,COL_CURSOR,NULL);
			}
			else{
				GF_STR_PrintColor(dfp->win_s,FONT_SYSTEM,dfp->msg_buf,x+ofs,y,MSG_NO_PUT,COL_ACTIVE,NULL);
			}
		}
		ofs+=FontProc_GetPrintStrWidth(FONT_SYSTEM,dfp->msg_buf,0);
	}
	dfp->put_req=1;
}

//============================================================================================
/**
 *	C[v^XN
 */
//============================================================================================
static	void	MainDebugFight(DEBUG_FIGHT_PARAM *dfp)
{
	int	move=NO_MOVE;

	if(dfp->put_req){
		dfp->put_req=0;
		GF_BGL_BmpWinOn(dfp->win_m);
		GF_BGL_BmpWinOn(dfp->win_s);
	}

	switch(dfp->seq_no){
	case SEQ_MAIN_MENU_MOVE:
		if(sys.trg==PAD_KEY_LEFT){
			move=mlp_m[dfp->cur_pos_m].move_left;
		}
		else if(sys.trg==PAD_KEY_RIGHT){
			move=mlp_m[dfp->cur_pos_m].move_right;
		}
		if(sys.trg==PAD_KEY_UP){
			move=mlp_m[dfp->cur_pos_m].move_up;
		}
		else if(sys.trg==PAD_KEY_DOWN){
			move=mlp_m[dfp->cur_pos_m].move_down;
		}
		else if(sys.trg==PAD_BUTTON_A){
			if(mlp_m[dfp->cur_pos_m].a_button_act!=NULL){
				dfp->sub_seq_no=0;
				dfp->seq_no=SEQ_A_BUTTON_ACT;
			}
		}
		else if((sys.trg==PAD_BUTTON_L)&&(dfp->page)&&(dfp->cur_pos_m<=MS_ENEMY_POKE_6)){
			dfp->page--;
			DebugFightSubScreenCreate(dfp,dfp->page);
		}
		else if((sys.trg==PAD_BUTTON_R)&&(dfp->page<NELEMS(mlp_s_list)-1)&&(dfp->cur_pos_m<=MS_ENEMY_POKE_6)){
			dfp->page++;
			DebugFightSubScreenCreate(dfp,dfp->page);
		}
		if(sys.cont==DEBUG_FIGHT_END_KEY){
			GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG0, VISIBLE_OFF );
			GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG1, VISIBLE_OFF );
			GF_BGL_BGControlExit(dfp->bgl, GF_BGL_FRAME1_M );
			GF_BGL_BGControlExit(dfp->bgl, GF_BGL_FRAME1_S );
			GF_BGL_BmpWinFree(dfp->win_m,1);
			GF_BGL_BmpWinFree(dfp->win_s,1);
			sys_FreeMemoryEz(dfp->bgl);
			MSGMAN_Delete(dfp->man_msg);
			MSGMAN_Delete(dfp->man_poke);
			MSGMAN_Delete(dfp->man_waza);
			MSGMAN_Delete(dfp->man_chr);
			MSGMAN_Delete(dfp->man_speabi);
			MSGMAN_Delete(dfp->man_item);
			sys_FreeMemoryEz(dfp->pp);
			sys_FreeMemoryEz(dfp->msg_buf);
			WORDSET_Delete(dfp->wordset);
			FontProc_UnloadBitData(FONT_SYSTEM);
			dfp->end_flag = TRUE;
			return;
		}
		if(sys.trg==PAD_BUTTON_START){
			if(DebugFightStart(dfp)==TRUE){
				Snd_SceneSet(SND_SCENE_DUMMY);
				Snd_DataSetByScene( SND_SCENE_BATTLE, SEQ_FIGHT0101, 1 );	//ogȍĐ
				ChangeBrightnessRequest(16, BRIGHTNESS_BLACK, BRIGHTNESS_NORMAL, PLANEMASK_ALL, MASK_DOUBLE_DISPLAY );
				dfp->seq_no=SEQ_BATTLE_INIT;
			}
			break;
		}
		if(move!=NO_MOVE){
			CursorMove(dfp,MOVE_MAIN,move,CUR_PUT);
#if 0
			if(dfp->cur_pos_m<=MS_ENEMY_POKE_6){
				DebugFightSubScreenCreate(dfp,dfp->page);
			}
			else{
				DebugFightSubScreenCreate(dfp,0xff);
			}
#endif
		}
		break;
	case SEQ_A_BUTTON_ACT:
		if(mlp_m[dfp->cur_pos_m].a_button_act(dfp)==TRUE){
			dfp->seq_no=SEQ_MAIN_MENU_MOVE;
		}
		break;
	case SEQ_BATTLE_INIT:
		if(IsFinishedBrightnessChg(MASK_DOUBLE_DISPLAY)==FALSE){
			break;
		}
		if((dfp->param->fight_type&FIGHT_TYPE_SIO)&&(CommStateDBattleIsReady()!=TRUE)){
			break;
		}
		GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG0, VISIBLE_OFF );
		GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG1, VISIBLE_OFF );
		GF_BGL_BGControlExit(dfp->bgl, GF_BGL_FRAME1_M );
		GF_BGL_BGControlExit(dfp->bgl, GF_BGL_FRAME1_S );
		DebugFight_SetProc(dfp);
		dfp->seq_no=SEQ_BATTLE_MAIN;
		break;
	case SEQ_BATTLE_MAIN:
		if(ProcMain(dfp->proc)){
			PROC_Delete(dfp->proc);
			if(dfp->param->fight_type&FIGHT_TYPE_SIO){
				CommSendFixData(CS_AUTO_EXIT);
			}
			BattleParam_Delete(dfp->param);
			dfp->proc=NULL;
			DebugFightBGCreate(dfp,dfp->bgl);

			DebugFightMainScreenCreate(dfp);
			if(dfp->cur_pos_m<=MS_ENEMY_POKE_6){
				DebugFightSubScreenCreate(dfp,dfp->page);
			}
			CursorMove(dfp,MOVE_MAIN,dfp->cur_pos_m,CUR_PUT);
			dfp->seq_no=SEQ_MAIN_MENU_MOVE;
			Snd_Stop();
		}
		break;
	}
}

static	BOOL	DebugFightStart(DEBUG_FIGHT_PARAM *dfp)
{
	int				i,j;
	int				cnt;
	STRCODE			name[PERSON_NAME_SIZE+EOM_SIZE];

	cnt=0;
	for(i=0;i<6;i++){
		if((dfp->dsp.dpp[i].mons_no)&&(dfp->dsp.dpp[i].default_hp)){
			if(cnt&1){
				cnt|=4;
			}
			else{
				cnt|=1;
			}
		}
		if((dfp->dsp.dpp[i+6].mons_no)&&(dfp->dsp.dpp[i+6].default_hp)){
			if(cnt&2){
				cnt|=8;
			}
			else{
				cnt|=2;
			}
		}
	}
	if((cnt&fight_type_table[dfp->dsp.fight_type][1])!=fight_type_table[dfp->dsp.fight_type][1]){
		return FALSE;
	}
	dfp->param=BattleParam_Create(HEAPID_DEBUG_APPLICATION,fight_type_table[dfp->dsp.fight_type][0]);
	MSGMAN_GetStr(dfp->man_msg,DF_BOY_NAME+dfp->dsp.my_sex,name);
	Debug_MyStatus_Make(dfp->param->my_status[0],name,dfp->dsp.my_sex);
	Debug_MyItem_MakeBag(dfp->param->my_item,HEAPID_DEBUG_APPLICATION);

	for(i=0;i<6;i++){
		if(dfp->dsp.dpp[i].mons_no){
			PokeParaSetSexChr(dfp->pp,
							  dfp->dsp.dpp[i].mons_no,
							  dfp->dsp.dpp[i].level,
							  0,
							  dfp->dsp.dpp[i].sex,
							  dfp->dsp.dpp[i].chr,
							  0);
	
			for(j=0;j<4;j++){
				PokeWazaSetPos(dfp->pp,dfp->dsp.dpp[i].waza[j],j);
			}
			for(j=STATUS_HP;j<STATUS_MAX;j++){
				PokeParaPut(dfp->pp,ID_PARA_hp_rnd+j,&dfp->dsp.dpp[i].status_rnd[j]);
				PokeParaPut(dfp->pp,ID_PARA_hp_exp+j,&dfp->dsp.dpp[i].status_exp[j]);
			}
			PokeParaCalc(dfp->pp);
			if(dfp->dsp.dpp[i].speabino_set){
				PokeParaPut(dfp->pp,ID_PARA_speabino,&dfp->dsp.dpp[i].speabino_set);
			}
			else{
				PokeParaPut(dfp->pp,ID_PARA_speabino,&dfp->dsp.dpp[i].speabino);
			}
			PokeParaPut(dfp->pp,ID_PARA_item,&dfp->dsp.dpp[i].item);
			PokeParaPut(dfp->pp,ID_PARA_friend,&dfp->dsp.dpp[i].friend);
			PokeParaPut(dfp->pp,ID_PARA_condition,&cond_table[dfp->dsp.dpp[i].condition]);
			PokeParaPut(dfp->pp,ID_PARA_hp,&dfp->dsp.dpp[i].default_hp);
			PokeParaPut(dfp->pp,ID_PARA_exp,&dfp->dsp.dpp[i].exp);
			PokeParty_Add(dfp->param->poke_party[0],dfp->pp);
		}
		if(dfp->dsp.dpp[i+6].mons_no){
			PokeParaSetSexChr(dfp->pp,
							  dfp->dsp.dpp[i+6].mons_no,
							  dfp->dsp.dpp[i+6].level,
							  0,
							  dfp->dsp.dpp[i+6].sex,
							  dfp->dsp.dpp[i+6].chr,
							  0);
	
			for(j=0;j<4;j++){
				PokeWazaSetPos(dfp->pp,dfp->dsp.dpp[i+6].waza[j],j);
			}
			for(j=STATUS_HP;j<STATUS_MAX;j++){
				PokeParaPut(dfp->pp,ID_PARA_hp_rnd+j,&dfp->dsp.dpp[i+6].status_rnd[j]);
				PokeParaPut(dfp->pp,ID_PARA_hp_exp+j,&dfp->dsp.dpp[i+6].status_exp[j]);
			}
			PokeParaCalc(dfp->pp);
			if(dfp->dsp.dpp[i+6].speabino_set){
				PokeParaPut(dfp->pp,ID_PARA_speabino,&dfp->dsp.dpp[i+6].speabino_set);
			}
			else{
				PokeParaPut(dfp->pp,ID_PARA_speabino,&dfp->dsp.dpp[i+6].speabino);
			}
			PokeParaPut(dfp->pp,ID_PARA_item,&dfp->dsp.dpp[i+6].item);
			PokeParaPut(dfp->pp,ID_PARA_friend,&dfp->dsp.dpp[i+6].friend);
			PokeParaPut(dfp->pp,ID_PARA_condition,&cond_table[dfp->dsp.dpp[i+6].condition]);
			PokeParaPut(dfp->pp,ID_PARA_hp,&dfp->dsp.dpp[i+6].default_hp);
			PokeParaPut(dfp->pp,ID_PARA_exp,&dfp->dsp.dpp[i+6].exp);
			PokeParty_Add(dfp->param->poke_party[1],dfp->pp);
		}
	}
	dfp->param->trainer_id[0]=gf_rand()%247+1;

	//GJEgtB[h
	dfp->param->ground_id=dfp->dsp.ground;
	dfp->param->bg_id=0;
	dfp->param->battle_status_flag=0;

	switch(dfp->dsp.fight_type){
	case FT_1vs1_SIO_P:
		CommStateDBattleConnect(TRUE,COMM_MODE_BATTLE_SINGLE,dfp->param->my_status[0]);
		break;
	case FT_2vs2_SIO_P:
		CommStateDBattleConnect(TRUE,COMM_MODE_BATTLE_DOUBLE,dfp->param->my_status[0]);
		break;
	case FT_MULTI_SIO_P:
		CommStateDBattleConnect(TRUE,COMM_MODE_BATTLE_MULTI,dfp->param->my_status[0]);
		break;
	case FT_1vs1_SIO_C:
		CommStateDBattleConnect(FALSE,COMM_MODE_BATTLE_SINGLE,dfp->param->my_status[0]);
		break;
	case FT_2vs2_SIO_C:
		CommStateDBattleConnect(FALSE,COMM_MODE_BATTLE_DOUBLE,dfp->param->my_status[0]);
		break;
	case FT_MULTI_SIO_C:
		CommStateDBattleConnect(FALSE,COMM_MODE_BATTLE_MULTI,dfp->param->my_status[0]);
		break;
	default:
		break;
	}

	FontProc_UnloadBitData(FONT_SYSTEM);

	return TRUE;
}

//==============================================================================================
//
//	j[J[\ړ
//
//==============================================================================================
static	void	CursorMove(DEBUG_FIGHT_PARAM *dfp,int side,int pos,int mode)
{
	dfp->put_req=1;
	switch(side){
	case MOVE_MAIN:
	default:
		GF_BGL_BmpWinFill(dfp->win_m,0x0f,mlp_m[dfp->cur_pos_m].cursor_pos_x,mlp_m[dfp->cur_pos_m].cursor_pos_y,12,16);
		if(mode==CUR_PUT){
			MSGMAN_GetString(dfp->man_msg,DF_CURSOR,dfp->msg_buf);
			GF_STR_PrintSimple(dfp->win_m,FONT_SYSTEM,dfp->msg_buf,mlp_m[pos].cursor_pos_x,mlp_m[pos].cursor_pos_y,MSG_NO_PUT,NULL);
			dfp->cur_pos_m=pos;	
		}
		break;
	case MOVE_SUB:
		{
			MENU_LIST_PARAM	*mlp;

			mlp=(MENU_LIST_PARAM *)mlp_s_list[dfp->page];

			GF_BGL_BmpWinFill(dfp->win_s,0x0f,mlp[dfp->cur_pos_s].cursor_pos_x,mlp[dfp->cur_pos_s].cursor_pos_y,12,16);
			if(mode==CUR_PUT){
				MSGMAN_GetString(dfp->man_msg,DF_CURSOR,dfp->msg_buf);
				GF_STR_PrintSimple(dfp->win_s,FONT_SYSTEM,dfp->msg_buf,mlp[pos].cursor_pos_x,mlp[pos].cursor_pos_y,MSG_NO_PUT,NULL);
				dfp->cur_pos_s=pos;
				dfp->put_req=1;
			}
		}
		break;
	}
}

//==============================================================================================
//
//	퓬^CvҏW
//
//==============================================================================================
enum{
	SEQ_FTA_INIT=0,
	SEQ_FTA_MAIN
};

static	BOOL	DebugFightFightTypeAct(DEBUG_FIGHT_PARAM *dfp)
{
	switch(dfp->sub_seq_no){
	case SEQ_FTA_INIT:
		DebugFightFightTypeDataPut(dfp,COL_ACTIVE);
		dfp->sub_seq_no=SEQ_FTA_MAIN;
		break;
	case SEQ_FTA_MAIN:
		if(sys.repeat&PAD_KEY_UP){
			if(dfp->dsp.fight_type){
				dfp->dsp.fight_type--;
			}
			else{
				dfp->dsp.fight_type=FIGHT_TYPE_MAX-1;
			}
			DebugFightFightTypeDataPut(dfp,COL_ACTIVE);
		}
		else if(sys.repeat&PAD_KEY_DOWN){
			if(dfp->dsp.fight_type<FIGHT_TYPE_MAX-1){
				dfp->dsp.fight_type++;
			}
			else{
				dfp->dsp.fight_type=0;
			}
			DebugFightFightTypeDataPut(dfp,COL_ACTIVE);
		}
		else if((sys.trg&PAD_BUTTON_A)||(sys.trg&PAD_BUTTON_B)){
			if((dfp->dsp.fight_type==FT_2vs2)||
			   (dfp->dsp.fight_type==FT_2vs2_SIO_P)||
			   (dfp->dsp.fight_type==FT_2vs2_SIO_C)){
//			   (dfp->dsp.fight_type==FT_2vs2_YASEI)||
//			   (dfp->dsp.fight_type==FT_AI_MULTI)){
				if(dfp->dsp.dpp[1].mons_no==0){
					DebugFightDefaultPokeSet(dfp,1);
				}
				if(dfp->dsp.dpp[1+6].mons_no==0){
					DebugFightDefaultPokeSet(dfp,1+6);
				}
				DebugFightMainScreenCreate(dfp);
			}
			DebugFightFightTypeDataPut(dfp,COL_NORMAL);
			return TRUE;
		}
		break;
	}
	return FALSE;
}

//==============================================================================================
//
//	p[^[h
//
//==============================================================================================
static	BOOL	DebugFightLoadAct(DEBUG_FIGHT_PARAM *dfp)
{
	PMSVLD_Load(SAVE_BANK,&dfp->dsp,sizeof(DEBUG_SAVE_PARAM));
	Snd_SePlay(SEQ_SE_DP_DECIDE);

	DebugFightMainScreenCreate(dfp);
	CursorMove(dfp,MOVE_MAIN,dfp->cur_pos_m,CUR_PUT);

	return TRUE;
}

//==============================================================================================
//
//	p[^Z[u
//
//==============================================================================================
static	BOOL	DebugFightSaveAct(DEBUG_FIGHT_PARAM *dfp)
{
	PMSVLD_Save(SAVE_BANK,&dfp->dsp,sizeof(DEBUG_SAVE_PARAM));
	Snd_SePlay(SEQ_SE_DP_DECIDE);

	return TRUE;
}

//==============================================================================================
//
//	n`̕ҏW
//
//==============================================================================================
static	BOOL	DebugFightGroundAct(DEBUG_FIGHT_PARAM *dfp)
{
	switch(dfp->sub_seq_no){
	case 0:
		DebugFightGroundDataPut(dfp,COL_ACTIVE);
		dfp->sub_seq_no=1;
		break;
	case 1:
		if((sys.repeat&PAD_KEY_UP)&&(dfp->dsp.ground>0)){
			dfp->dsp.ground--;
			DebugFightGroundDataPut(dfp,COL_ACTIVE);
		}
		else if((sys.repeat&PAD_KEY_DOWN)&&(dfp->dsp.ground<GROUND_ID_BRIDGE)){
			dfp->dsp.ground++;
			DebugFightGroundDataPut(dfp,COL_ACTIVE);
		}
		else if((sys.trg&PAD_BUTTON_A)||(sys.trg&PAD_BUTTON_B)){
			DebugFightGroundDataPut(dfp,COL_NORMAL);
			return TRUE;
		}
		break;
	}
	return FALSE;
}

//==============================================================================================
//
//	̐ʕҏW
//
//==============================================================================================
static	BOOL	DebugFightMySexAct(DEBUG_FIGHT_PARAM *dfp)
{
	switch(dfp->sub_seq_no){
	case 0:
		DebugFightMySexDataPut(dfp,COL_ACTIVE);
		dfp->sub_seq_no=1;
		break;
	case 1:
		if((sys.repeat&PAD_KEY_UP)||(sys.repeat&PAD_KEY_DOWN)){
			dfp->dsp.my_sex^=1;
			DebugFightMySexDataPut(dfp,COL_ACTIVE);
		}
		else if((sys.trg&PAD_BUTTON_A)||(sys.trg&PAD_BUTTON_B)){
			DebugFightMySexDataPut(dfp,COL_NORMAL);
			return TRUE;
		}
		break;
	}
	return FALSE;
}

//==============================================================================================
//
//	|Pp[^ҏW
//
//==============================================================================================
enum{
	SEQ_SUB_MENU_INIT=0,
	SEQ_SUB_MENU_WRITE,
	SEQ_SUB_MENU_MOVE,
	SEQ_SUB_MENU_ACT,
};

static	BOOL	DebugFightPokeAct(DEBUG_FIGHT_PARAM *dfp)
{
	int				move=NO_MOVE;
	MENU_LIST_PARAM	*mlp;

	switch(dfp->sub_seq_no){
	case SEQ_SUB_MENU_INIT:
		if(dfp->dsp.dpp[dfp->cur_pos_m].mons_no==0){
			dfp->page=0;
		}
	case SEQ_SUB_MENU_WRITE:
		dfp->cur_pos_s=0;
		DebugFightSubScreenCreate(dfp,dfp->page);
		CursorMove(dfp,MOVE_SUB,dfp->cur_pos_s,CUR_PUT);
		dfp->sub_seq_no=SEQ_SUB_MENU_MOVE;
	case SEQ_SUB_MENU_MOVE:
		mlp=(MENU_LIST_PARAM *)mlp_s_list[dfp->page];

		if((sys.trg==PAD_KEY_LEFT)&&(dfp->dsp.dpp[dfp->cur_pos_m].mons_no)){
			move=mlp[dfp->cur_pos_s].move_left;
		}
		else if((sys.trg==PAD_KEY_RIGHT)&&(dfp->dsp.dpp[dfp->cur_pos_m].mons_no)){
			move=mlp[dfp->cur_pos_s].move_right;
		}
		if((sys.trg==PAD_KEY_UP)&&(dfp->dsp.dpp[dfp->cur_pos_m].mons_no)){
			move=mlp[dfp->cur_pos_s].move_up;
		}
		else if((sys.trg==PAD_KEY_DOWN)&&(dfp->dsp.dpp[dfp->cur_pos_m].mons_no)){
			move=mlp[dfp->cur_pos_s].move_down;
		}
		else if((sys.trg==PAD_BUTTON_L)&&(dfp->page)&&(dfp->dsp.dpp[dfp->cur_pos_m].mons_no)){
			dfp->page--;
			dfp->sub_seq_no=SEQ_SUB_MENU_WRITE;
		}
		else if((sys.trg==PAD_BUTTON_R)&&(dfp->page<NELEMS(mlp_s_list)-1)&&(dfp->dsp.dpp[dfp->cur_pos_m].mons_no)){
			dfp->page++;
			dfp->sub_seq_no=SEQ_SUB_MENU_WRITE;
		}
		else if(sys.trg==PAD_BUTTON_X){
			DebugFightDefaultSet(dfp,param_mode_tbl[dfp->page]);
			DebugFightSubScreenCreate(dfp,dfp->page);
			CursorMove(dfp,MOVE_SUB,dfp->cur_pos_s,CUR_PUT);
		}
		else if(sys.trg==PAD_BUTTON_A){
			if(mlp[dfp->cur_pos_s].a_button_act!=NULL){
				dfp->sub_act_seq_no=0;
				dfp->sub_seq_no=SEQ_SUB_MENU_ACT;
			}
		}
		if(sys.trg==PAD_BUTTON_START){
			DebugFightMainScreenCreate(dfp);
			CursorMove(dfp,MOVE_MAIN,dfp->cur_pos_m,CUR_PUT);
			CursorMove(dfp,MOVE_SUB,dfp->cur_pos_s,CUR_DEL);
			return TRUE;
		}
		if(move!=NO_MOVE){
			CursorMove(dfp,MOVE_SUB,move,CUR_PUT);
		}
		break;
	case SEQ_SUB_MENU_ACT:
		mlp=(MENU_LIST_PARAM *)mlp_s_list[dfp->page];
		if(mlp[dfp->cur_pos_s].a_button_act(dfp)==TRUE){
			dfp->sub_seq_no=SEQ_SUB_MENU_MOVE;
		}
		break;
	}
	return FALSE;
}

//==============================================================================================
//
//	|PޕҏW
//
//==============================================================================================
static	BOOL	DebugFightKindAct(DEBUG_FIGHT_PARAM *dfp)
{
	BOOL	ret=FALSE;
	int		min;

	switch(dfp->sub_act_seq_no){
	case 0:
		DebugFightKindDataPut(dfp,MODE_ACTIVE);
		dfp->sub_act_seq_no++;
	case 1:
		if((dfp->cur_pos_m==MS_MINE_POKE_1)||(dfp->cur_pos_m==MS_ENEMY_POKE_1)){
			min=MONSNO_HUSIGIDANE;
		}
		else{
			min=0;
		}
		switch(DebugFightNumCalc(dfp,&dfp->dsp.dpp[dfp->cur_pos_m].mons_no,3,min,MONSNO_END,MODE_LOOP)){
		case NUM_CALC_NONE:
			break;
		case NUM_CALC_CHANGE:
			//ol擾
			dfp->dsp.dpp[dfp->cur_pos_m].exp=PokeLevelExpGet(dfp->dsp.dpp[dfp->cur_pos_m].mons_no,dfp->dsp.dpp[dfp->cur_pos_m].level);
			DebugFightExpDataPut(dfp,MODE_NORMAL);
			//ʎ擾
			switch(PokePersonalParaGet(dfp->dsp.dpp[dfp->cur_pos_m].mons_no,ID_PER_sex)){
			case MONS_MALE:
			default:
				dfp->dsp.dpp[dfp->cur_pos_m].sex=PARA_MALE;
				break;
			case MONS_FEMALE:
				dfp->dsp.dpp[dfp->cur_pos_m].sex=PARA_FEMALE;
				break;
			case MONS_UNKNOWN:
				dfp->dsp.dpp[dfp->cur_pos_m].sex=PARA_UNK;
				break;
			}
			DebugFightSexDataPut(dfp,COL_NORMAL);
			//p[^vZ
			DebugFightParamPut(dfp);
		case NUM_CALC_MOVE:
			DebugFightKindDataPut(dfp,MODE_ACTIVE);
			break;
		case NUM_CALC_END:
			DebugFightKindDataPut(dfp,MODE_NORMAL);
			if(dfp->dsp.dpp[dfp->cur_pos_m].mons_no==0){
				DebugFightPokemonParamInit(&dfp->dsp.dpp[dfp->cur_pos_m]);
			}
			ret=TRUE;
			break;
		}
		break;
	}
	return ret;
}

//==============================================================================================
//
//	xҏW
//
//==============================================================================================
static	BOOL	DebugFightLevelAct(DEBUG_FIGHT_PARAM *dfp)
{
	BOOL	ret=FALSE;

	switch(dfp->sub_act_seq_no){
	case 0:
		DebugFightLevelDataPut(dfp,MODE_ACTIVE);
		dfp->sub_act_seq_no++;
	case 1:
		switch(DebugFightNumCalc(dfp,&dfp->dsp.dpp[dfp->cur_pos_m].level,3,1,100,MODE_LOOP)){
		case NUM_CALC_NONE:
			break;
		case NUM_CALC_CHANGE:
			dfp->dsp.dpp[dfp->cur_pos_m].exp=PokeLevelExpGet(dfp->dsp.dpp[dfp->cur_pos_m].mons_no,dfp->dsp.dpp[dfp->cur_pos_m].level);
			DebugFightExpDataPut(dfp,MODE_NORMAL);
			DebugFightParamPut(dfp);
		case NUM_CALC_MOVE:
			DebugFightLevelDataPut(dfp,MODE_ACTIVE);
			break;
		case NUM_CALC_END:
			DebugFightLevelDataPut(dfp,MODE_NORMAL);
			ret=TRUE;
			break;
		}
		break;
	}
	return ret;
}

//==============================================================================================
//
//	olҏW
//
//==============================================================================================
static	BOOL	DebugFightExpAct(DEBUG_FIGHT_PARAM *dfp)
{
	BOOL	ret=FALSE;

	switch(dfp->sub_act_seq_no){
	case 0:
		DebugFightExpDataPut(dfp,MODE_ACTIVE);
		dfp->sub_act_seq_no++;
	case 1:
		{
			u32	exp_max;

			exp_max=PokeLevelExpGet(dfp->dsp.dpp[dfp->cur_pos_m].mons_no,100);
			switch(DebugFightNumCalc(dfp,&dfp->dsp.dpp[dfp->cur_pos_m].exp,EXP_KETA,1,exp_max,MODE_LOOP)){
			case NUM_CALC_NONE:
				break;
			case NUM_CALC_CHANGE:
				dfp->dsp.dpp[dfp->cur_pos_m].level=PokeLevelCalc(dfp->dsp.dpp[dfp->cur_pos_m].mons_no,dfp->dsp.dpp[dfp->cur_pos_m].exp);
				DebugFightLevelDataPut(dfp,MODE_NORMAL);
				DebugFightParamPut(dfp);
			case NUM_CALC_MOVE:
				DebugFightExpDataPut(dfp,MODE_ACTIVE);
				break;
			case NUM_CALC_END:
				DebugFightExpDataPut(dfp,MODE_NORMAL);
				ret=TRUE;
				break;
			}
		}
		break;
	}
	return ret;
}

//==============================================================================================
//
//	ʕҏW
//
//==============================================================================================
static	BOOL	DebugFightSexAct(DEBUG_FIGHT_PARAM *dfp)
{
	//ʌŒ̏ꍇ́AҏWȂ
	switch(PokePersonalParaGet(dfp->dsp.dpp[dfp->cur_pos_m].mons_no,ID_PER_sex)){
	case MONS_MALE:
	case MONS_FEMALE:
	case MONS_UNKNOWN:
		return TRUE;
	default:
		break;
	}
	switch(dfp->sub_act_seq_no){
	case 0:
		DebugFightSexDataPut(dfp,COL_ACTIVE);
		dfp->sub_act_seq_no++;
	case 1:
		if((sys.repeat&PAD_KEY_UP)&&(dfp->dsp.dpp[dfp->cur_pos_m].sex)){
			dfp->dsp.dpp[dfp->cur_pos_m].sex--;
			DebugFightSexDataPut(dfp,COL_ACTIVE);
		}
		if((sys.repeat&PAD_KEY_DOWN)&&(dfp->dsp.dpp[dfp->cur_pos_m].sex<PARA_FEMALE)){
			dfp->dsp.dpp[dfp->cur_pos_m].sex++;
			DebugFightSexDataPut(dfp,COL_ACTIVE);
		}
		else if((sys.trg&PAD_BUTTON_A)||(sys.trg&PAD_BUTTON_B)){
			DebugFightSexDataPut(dfp,COL_NORMAL);
			return TRUE;
		}
		break;
	}
	return FALSE;
}

//==============================================================================================
//
//	iҏW
//
//==============================================================================================
static	BOOL	DebugFightChrAct(DEBUG_FIGHT_PARAM *dfp)
{
	switch(dfp->sub_act_seq_no){
	case 0:
		DebugFightChrDataPut(dfp,COL_ACTIVE);
		dfp->sub_act_seq_no++;
	case 1:
		if((sys.repeat&PAD_KEY_UP)&&(dfp->dsp.dpp[dfp->cur_pos_m].chr)){
			dfp->dsp.dpp[dfp->cur_pos_m].chr--;
			DebugFightChrDataPut(dfp,COL_ACTIVE);
			DebugFightParamPut(dfp);
		}
		if((sys.repeat&PAD_KEY_DOWN)&&(dfp->dsp.dpp[dfp->cur_pos_m].chr<CHR_MAX)){
			dfp->dsp.dpp[dfp->cur_pos_m].chr++;
			DebugFightChrDataPut(dfp,COL_ACTIVE);
			DebugFightParamPut(dfp);
		}
		else if((sys.trg&PAD_BUTTON_A)||(sys.trg&PAD_BUTTON_B)){
			DebugFightChrDataPut(dfp,COL_NORMAL);
			return TRUE;
		}
		break;
	}
	return FALSE;
}

//==============================================================================================
//
//	p[ҏW
//
//==============================================================================================
static	BOOL	DebugFightStatusRndAct(DEBUG_FIGHT_PARAM *dfp)
{
	BOOL	ret=FALSE;
	int		status;

	status=dfp->cur_pos_s-MENU1_HP_RND;

	switch(dfp->sub_act_seq_no){
	case 0:
		DebugFightStatusRndDataPut(dfp,status,MODE_ACTIVE);
		dfp->sub_act_seq_no++;
	case 1:
		switch(DebugFightNumCalc(dfp,&dfp->dsp.dpp[dfp->cur_pos_m].status_rnd[status],STRND_KETA,0,31,MODE_LOOP)){
		case NUM_CALC_NONE:
			break;
		case NUM_CALC_CHANGE:
			DebugFightParamPut(dfp);
		case NUM_CALC_MOVE:
			DebugFightStatusRndDataPut(dfp,status,MODE_ACTIVE);
			break;
		case NUM_CALC_END:
			DebugFightStatusRndDataPut(dfp,status,MODE_NORMAL);
			ret=TRUE;
			break;
		}
		break;
	}
	return ret;
}

//==============================================================================================
//
//	w͒lҏW
//
//==============================================================================================
static	BOOL	DebugFightStatusExpAct(DEBUG_FIGHT_PARAM *dfp)
{
	BOOL	ret=FALSE;
	int		status;

	status=dfp->cur_pos_s-MENU1_HP_EXP;

	switch(dfp->sub_act_seq_no){
	case 0:
		DebugFightStatusExpDataPut(dfp,status,MODE_ACTIVE);
		dfp->sub_act_seq_no++;
	case 1:
		{
			int	i;
			int	exp_total;
			int	exp_max;

			exp_total=0;
			for(i=STATUS_HP;i<STATUS_MAX;i++){
				exp_total+=dfp->dsp.dpp[dfp->cur_pos_m].status_exp[i];
			}
			if(PARA_EXP_TOTAL_MAX<exp_total+(PARA_EXP_MAX-dfp->dsp.dpp[dfp->cur_pos_m].status_exp[status])){
				exp_max=PARA_EXP_MAX-
						((exp_total+(PARA_EXP_MAX-dfp->dsp.dpp[dfp->cur_pos_m].status_exp[status]))-PARA_EXP_TOTAL_MAX);
			}
			else{
				exp_max=PARA_EXP_MAX;
			}
			switch(DebugFightNumCalc(dfp,&dfp->dsp.dpp[dfp->cur_pos_m].status_exp[status],STEXP_KETA,0,exp_max,MODE_LOOP)){
			case NUM_CALC_NONE:
				break;
			case NUM_CALC_CHANGE:
				DebugFightParamPut(dfp);
			case NUM_CALC_MOVE:
				DebugFightStatusExpDataPut(dfp,status,MODE_ACTIVE);
				break;
			case NUM_CALC_END:
				DebugFightStatusExpDataPut(dfp,status,MODE_NORMAL);
				ret=TRUE;
				break;
			}
		}
		break;
	}
	return ret;
}

//==============================================================================================
//
//	ZҏW
//
//==============================================================================================
static	BOOL	DebugFightWazaAct(DEBUG_FIGHT_PARAM *dfp)
{
	BOOL	ret=FALSE;
	int		min;

	switch(dfp->sub_act_seq_no){
	case 0:
		DebugFightWazaDataPut(dfp,dfp->cur_pos_s,MODE_ACTIVE);
		dfp->sub_act_seq_no++;
	case 1:
		if(dfp->cur_pos_s){
			min=0;
		}
		else{
			min=WAZANO_HATAKU;
		}
		switch(DebugFightNumCalc(dfp,&dfp->dsp.dpp[dfp->cur_pos_m].waza[dfp->cur_pos_s],3,min,WAZANO_MAX,MODE_LOOP)){
		case NUM_CALC_NONE:
			break;
		case NUM_CALC_CHANGE:
		case NUM_CALC_MOVE:
			DebugFightWazaDataPut(dfp,dfp->cur_pos_s,MODE_ACTIVE);
			break;
		case NUM_CALC_END:
			DebugFightWazaDataPut(dfp,dfp->cur_pos_s,MODE_NORMAL);
			ret=TRUE;
			break;
		}
		break;
	}
	return ret;
}

//==============================================================================================
//
//	ҏW
//
//==============================================================================================
static	BOOL	DebugFightSpeAbiAct(DEBUG_FIGHT_PARAM *dfp)
{
	switch(dfp->sub_act_seq_no){
	case 0:
		DebugFightSpeAbiDataPut(dfp,COL_ACTIVE);
		dfp->sub_act_seq_no++;
	case 1:
		if((sys.repeat&PAD_KEY_UP)||(sys.repeat&PAD_KEY_DOWN)){
			dfp->dsp.dpp[dfp->cur_pos_m].speabi^=1;
			DebugFightSpeAbiDataPut(dfp,COL_ACTIVE);
		}
		else if((sys.trg&PAD_BUTTON_A)||(sys.trg&PAD_BUTTON_B)){
			DebugFightSpeAbiDataPut(dfp,COL_NORMAL);
			return TRUE;
		}
		break;
	}
	return FALSE;
}

//==============================================================================================
//
//	ҏWip[\if[^ɈˑȂj
//
//==============================================================================================
static	BOOL	DebugFightSpeAbiSetAct(DEBUG_FIGHT_PARAM *dfp)
{
	BOOL	ret;

	ret=FALSE;

	switch(dfp->sub_act_seq_no){
	case 0:
		DebugFightSpeAbiSetDataPut(dfp,MODE_ACTIVE);
		dfp->sub_act_seq_no++;
	case 1:
		switch(DebugFightNumCalc(dfp,&dfp->dsp.dpp[dfp->cur_pos_m].speabino_set,3,0,TOKUSYU_MAX,MODE_LOOP)){
		case NUM_CALC_NONE:
			break;
		case NUM_CALC_CHANGE:
		case NUM_CALC_MOVE:
			DebugFightSpeAbiSetDataPut(dfp,MODE_ACTIVE);
			break;
		case NUM_CALC_END:
			DebugFightSpeAbiSetDataPut(dfp,MODE_NORMAL);
			ret=TRUE;
			break;
		}
		break;
	}
	return ret;
}

//==============================================================================================
//
//	ACeҏW
//
//==============================================================================================
static	BOOL	DebugFightItemAct(DEBUG_FIGHT_PARAM *dfp)
{
	BOOL	ret=FALSE;

	switch(dfp->sub_act_seq_no){
	case 0:
		DebugFightItemDataPut(dfp,MODE_ACTIVE);
		dfp->sub_act_seq_no++;
	case 1:
		switch(DebugFightNumCalc(dfp,&dfp->dsp.dpp[dfp->cur_pos_m].item,3,0,ITEM_DATA_MAX,MODE_LOOP)){
		case NUM_CALC_NONE:
			break;
		case NUM_CALC_CHANGE:
		case NUM_CALC_MOVE:
			DebugFightItemDataPut(dfp,MODE_ACTIVE);
			break;
		case NUM_CALC_END:
			DebugFightItemDataPut(dfp,MODE_NORMAL);
			ret=TRUE;
			break;
		}
		break;
	}
	return ret;
}

//==============================================================================================
//
//	ȂxҏW
//
//==============================================================================================
static	BOOL	DebugFightFriendAct(DEBUG_FIGHT_PARAM *dfp)
{
	BOOL	ret=FALSE;

	switch(dfp->sub_act_seq_no){
	case 0:
		DebugFightFriendDataPut(dfp,MODE_ACTIVE);
		dfp->sub_act_seq_no++;
	case 1:
		switch(DebugFightNumCalc(dfp,&dfp->dsp.dpp[dfp->cur_pos_m].friend,3,0,255,MODE_LOOP)){
		case NUM_CALC_NONE:
			break;
		case NUM_CALC_CHANGE:
		case NUM_CALC_MOVE:
			DebugFightFriendDataPut(dfp,MODE_ACTIVE);
			break;
		case NUM_CALC_END:
			DebugFightFriendDataPut(dfp,MODE_NORMAL);
			ret=TRUE;
			break;
		}
	}
	return ret;
}

//==============================================================================================
//
//	ԈُҏW
//
//==============================================================================================
static	BOOL	DebugFightConditionAct(DEBUG_FIGHT_PARAM *dfp)
{
	switch(dfp->sub_act_seq_no){
	case 0:
		DebugFightConditionDataPut(dfp,COL_ACTIVE);
		dfp->sub_act_seq_no++;
	case 1:
		if((sys.repeat&PAD_KEY_UP)&&(dfp->dsp.dpp[dfp->cur_pos_m].condition)){
			dfp->dsp.dpp[dfp->cur_pos_m].condition--;
			DebugFightConditionDataPut(dfp,COL_ACTIVE);
		}
		if((sys.repeat&PAD_KEY_DOWN)&&(dfp->dsp.dpp[dfp->cur_pos_m].condition<DF_COND_MAX)){
			dfp->dsp.dpp[dfp->cur_pos_m].condition++;
			DebugFightConditionDataPut(dfp,COL_ACTIVE);
		}
		else if((sys.trg&PAD_BUTTON_A)||(sys.trg&PAD_BUTTON_B)){
			DebugFightConditionDataPut(dfp,COL_NORMAL);
			return TRUE;
		}
		break;
	}
	return FALSE;
}

//==============================================================================================
//
//	goҏW
//
//==============================================================================================
static	BOOL	DebugFightDefaultHPAct(DEBUG_FIGHT_PARAM *dfp)
{
	BOOL	ret=FALSE;

	switch(dfp->sub_act_seq_no){
	case 0:
		DebugFightDefaultHPDataPut(dfp,MODE_ACTIVE);
		dfp->sub_act_seq_no++;
	case 1:
		switch(DebugFightNumCalc(dfp,&dfp->dsp.dpp[dfp->cur_pos_m].default_hp,3,0,dfp->dsp.dpp[dfp->cur_pos_m].hp_max,MODE_LOOP)){
		case NUM_CALC_NONE:
			break;
		case NUM_CALC_CHANGE:
		case NUM_CALC_MOVE:
			DebugFightDefaultHPDataPut(dfp,MODE_ACTIVE);
			break;
		case NUM_CALC_END:
			DebugFightDefaultHPDataPut(dfp,MODE_NORMAL);
			ret=TRUE;
			break;
		}
	}
	return ret;
}

//==============================================================================================
//
//	lҏW
//
//==============================================================================================
static	int	DebugFightNumCalc(DEBUG_FIGHT_PARAM *dfp,u32 *param,int keta,int min,int max,int mode)
{
	int ret=NUM_CALC_NONE;
	u32	calc_work[]={
		1,
		10,
		100,
		1000,
		10000,
		100000,
		1000000,
		10000000,
		100000000,
		1000000000,
	};

	if((sys.repeat & PAD_KEY_LEFT)&&(dfp->cur_pos_keta<(keta-1))){
		dfp->cur_pos_keta++;
		ret=NUM_CALC_MOVE;
	}
	else if((sys.repeat & PAD_KEY_RIGHT)&&(dfp->cur_pos_keta)){
		dfp->cur_pos_keta--;
		ret=NUM_CALC_MOVE;
	}
	else if(sys.repeat & PAD_KEY_UP){
		if(mode==MODE_LOOP){
			if((param[0]+calc_work[dfp->cur_pos_keta])>max){
				param[0]=min;
				ret=NUM_CALC_CHANGE;
			}
			else{
				param[0]+=calc_work[dfp->cur_pos_keta];
				ret=NUM_CALC_CHANGE;
			}
		}
		else{
			if((param[0]+calc_work[dfp->cur_pos_keta])>max){
				param[0]=max;
				ret=NUM_CALC_CHANGE;
			}
			else{
				param[0]+=calc_work[dfp->cur_pos_keta];
				ret=NUM_CALC_CHANGE;
			}
		}
	}
	else if(sys.repeat & PAD_KEY_DOWN){
		if(mode==MODE_LOOP){
			if((param[0]<calc_work[dfp->cur_pos_keta])||((param[0]-calc_work[dfp->cur_pos_keta])<min)){
				param[0]=max;
				ret=NUM_CALC_CHANGE;
			}
			else{
				param[0]-=calc_work[dfp->cur_pos_keta];
				ret=NUM_CALC_CHANGE;
			}
		}
		else{
			if((param[0]<calc_work[dfp->cur_pos_keta])||((param[0]-calc_work[dfp->cur_pos_keta])<min)){
				param[0]=min;
				ret=NUM_CALC_CHANGE;
			}
			else{
				param[0]-=calc_work[dfp->cur_pos_keta];
				ret=NUM_CALC_CHANGE;
			}
		}
	}
	else if((sys.trg & PAD_BUTTON_A)||(sys.trg & PAD_BUTTON_B)){
		dfp->cur_pos_keta=0;
		ret=NUM_CALC_END;
	}

	return ret;
}

static	void	DebugFightDefaultPokeSet(DEBUG_FIGHT_PARAM *dfp,int pos)
{
	dfp->dsp.dpp[pos].mons_no=MONSNO_HUSIGIDANE;
	PokeParaSetSexChr(dfp->pp,
					  dfp->dsp.dpp[pos].mons_no,
					  dfp->dsp.dpp[pos].level,
					  0,
					  dfp->dsp.dpp[pos].sex,
					  dfp->dsp.dpp[pos].chr,
					  0);
	dfp->dsp.dpp[pos].default_hp=PokeParaGet(dfp->pp,ID_PARA_hpmax,NULL);
	dfp->dsp.dpp[pos].hp_max=PokeParaGet(dfp->pp,ID_PARA_hpmax,NULL);
	dfp->dsp.dpp[pos].speabino=PokePersonalParaGet(dfp->dsp.dpp[pos].mons_no,ID_PER_speabi1);
}

//==============================================================================================
//
//	^CgfobNj[Ă΂悤ɒǉ
//
//==============================================================================================
//--------------------------------------------------------------
//--------------------------------------------------------------
static PROC_RESULT DebugFightProc_Init(PROC * proc, int * seq)
{
	DEBUG_FIGHT_PARAM	*dfp;

	sys_CreateHeap(HEAPID_BASE_APP,HEAPID_DEBUG_APPLICATION,CREATE_HEAP_SIZE);
	dfp=PROC_AllocWork(proc,sizeof(DEBUG_FIGHT_PARAM),HEAPID_DEBUG_APPLICATION);
	InitDebugFight(dfp);

	return PROC_RES_FINISH;
}

//--------------------------------------------------------------
//--------------------------------------------------------------
static PROC_RESULT DebugFightProc_Main(PROC * proc, int * seq)
{
	DEBUG_FIGHT_PARAM *dfp = PROC_GetWork(proc);

	MainDebugFight(dfp);

	if (dfp->end_flag) {
		return PROC_RES_FINISH;
	} else {
		return PROC_RES_CONTINUE;
	}
}

//--------------------------------------------------------------
//--------------------------------------------------------------
static PROC_RESULT DebugFightProc_End(PROC * proc, int * seq)
{
	PROC_FreeWork(proc);
	sys_DeleteHeap(HEAPID_DEBUG_APPLICATION);
	Main_SetNextProc(NO_OVERLAY_ID, &TitleProcData);
	OS_ResetSystem(0);									//\tgZbg
	return PROC_RES_FINISH;
}

//--------------------------------------------------------------
//--------------------------------------------------------------
const PROC_DATA DebugFightProcData = {
	DebugFightProc_Init,
	DebugFightProc_Main,
	DebugFightProc_End,
	NO_OVERLAY_ID,
};

//------------------------------------------------------------------
/**
 * @brief	vZX֐FF퓬ieXgj
 */
//------------------------------------------------------------------
static PROC_RESULT TestBattleProc_Init(PROC * proc, int * seq)
{
	return PROC_RES_FINISH;
}
//------------------------------------------------------------------
/**
 * @brief	vZX֐FCF퓬ieXgj
 */
//------------------------------------------------------------------
static PROC_RESULT TestBattleProc_Main(PROC * proc, int * seq)
{
	if (BattleSystemProc(proc,seq)) {
		return PROC_RES_FINISH;
	} else {
		return PROC_RES_CONTINUE;
	}
}
//------------------------------------------------------------------
/**
 * @brief	vZX֐FIF퓬ieXgj
 */
//------------------------------------------------------------------
static PROC_RESULT TestBattleProc_End(PROC * proc, int * seq)
{
	return PROC_RES_FINISH;
}

#if 0
//------------------------------------------------------------------
/**
 * @brief	vZX`f[^F퓬ieXgj
 */
//------------------------------------------------------------------
static const PROC_DATA TestBattleProcData = {
	TestBattleProc_Init,
	TestBattleProc_Main,
	TestBattleProc_End,
	NO_OVERLAY_ID,
};
#endif

//------------------------------------------------------------------
//------------------------------------------------------------------
static	void DebugFight_SetProc(DEBUG_FIGHT_PARAM *dfp)
{
	FS_EXTERN_OVERLAY(battle);

static const PROC_DATA TestBattleProcData = {
	TestBattleProc_Init,
	TestBattleProc_Main,
	TestBattleProc_End,
	FS_OVERLAY_ID(battle),
};
	dfp->proc=PROC_Create(&TestBattleProcData, dfp->param, HEAPID_DEBUG_APPLICATION);
}


//--------------------------------------------------------------
/**
 * @brief	VBLANK֐
 *
 * @param	work	VBLankɂ͈KvȂ̂Œ`Ă邪ۂɂNULLĂ̂ŁAANZX͋֎~I
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
static	void	DebugFightVBlank(void *work)
{
	OS_SetIrqCheckFlag( OS_IE_V_BLANK);
}

