//============================================================================================
/**
 * @file	d_startmenu.c	
 * @bfief	fobO^Cgj[
 * @author	Hiroyuki Nakamura
 * @date	05.07.08
 * 
 * 2005.12.13	tamada	d_title.cRs[č쐬
 */
//============================================================================================
#include "common.h"
#include "system/fontproc.h"
#include "system/bmp_list.h"
#include "system/lib_pack.h"
#include "system/arc_util.h"

#if 1
#include "system/window.h"
#include "system/wordset.h"
#include "system/msgdata_util.h"
#include "system/zukanwork.h"
#include "msgdata/msg.naix"
#include "msgdata/msg_startmenu.h"
#include "msgdata/msg_bconfind.h"
#include "strbuf_family.h"	//for STRBUF_SetStringCode 
#endif

#include "demo/title.h"
#include "field/field.h"
#include "poke_test.h"

#include "system/main.h"
#include "system/brightness.h"

extern const PROC_DATA OpeningProcData;

//============================================================================================
//	萔`
//============================================================================================

typedef void (*SELECT_FUNC)(SAVEDATA *);

static u32 d_title_win0[] = {
  mes_startmenu_01,			// Â@͂߂
  mes_startmenu_13,			// ザ񂱂
  mes_startmenu_14,			// vC
  mes_startmenu_15,			// |P
  mes_startmenu_16,			// ĂobW
  0,
};
static u32 d_title_win1[] =  { mes_startmenu_02, 0 };	// 傩@͂߂
static u32 d_title_win2[] =  { mes_startmenu_03, 0 };	// ӂȁ@
static u32 d_title_win3[] =  { mes_startmenu_04, 0 };	// |PW[Ƃ́@
static u32 d_title_win40[] = { mes_startmenu_05, 0 };	// r[@Ă
static u32 d_title_win41[] = { mes_startmenu_06, 0 };	// Tt@CA@Ă
static u32 d_title_win42[] = { mes_startmenu_07, 0 };	// [tO[@Ă
static u32 d_title_win43[] = { mes_startmenu_08, 0 };	// t@C[bh@Ă
static u32 d_title_win44[] = { mes_startmenu_09, 0 };	// Gh@Ă
static u32 d_title_win5[] =  { mes_startmenu_10, 0 };	// ܂ۂ
static u32 d_title_win6[] =  { mes_startmenu_11, 0 };	// {[V
static u32 d_title_win7[] =  { mes_startmenu_12, 0 };	// v|eĂ

typedef struct {
  int flag;
  int height;				// c̃LN^TCY
  u32 *msg;			       // bZ[Wf[^ւ̃|C^
} D_TITLE_WINDATA;

#define MAX_D_TITLEWIN_NUM	10
#define D_TITLE_WIN_MARGIN_L	32


static D_TITLE_WINDATA title_windata[MAX_D_TITLEWIN_NUM] = {
#if 1
  { 0, 10, d_title_win0 },
  { 1, 2, d_title_win1 },
  { 0, 2, d_title_win2 },
  { 0, 2, d_title_win3 },
  { 0, 2, d_title_win43 },
  { 0, 2, d_title_win6 },
  { 0, 2, d_title_win7 },
#else
  { 1, 10, d_title_win0 },
  { 1, 2, d_title_win1 },
  { 1, 2, d_title_win2 },
  { 1, 2, d_title_win3 },
  { 1, 2, d_title_win43 },
  { 1, 2, d_title_win6 },
  { 1, 2, d_title_win7 },
#endif
  { 0 },
};



typedef struct {
  int used;
  GF_BGL_BMPWIN	win;
} D_TITLE_WINWORK;





typedef struct {
  GF_BGL_INI * bgl;
  GF_BGL_BMPWIN	win;
  BMPLIST_WORK * lw;
  SELECT_FUNC select_func;

  WORDSET * word;	      // <PꃂW[䃏[Nւ̃|C^
  MSGDATA_MANAGER * msgman;	    // <MSGf[^}l[Wւ̃|C^
  ZUKAN_WORK * zw;
  MYSTATUS * mst;
  D_TITLE_WINWORK swin[MAX_D_TITLEWIN_NUM];

  GF_BGL_BMPWIN	rwin;
  GF_BGL_BMPWIN	awin;

  int select;			// IĂgԍ(title_windata̓Y)
  
}D_TITLE_WORK;


// ̃vC[
static const STRCODE str_playername[] = { DA_, I_, YA_, EOM_ };





#define	FONT_PAL_NO_N		( 0 )	// m[}pbg
#define	FONT_PAL_NO_S		( 1 )	// Ipbg


#define	HEAPID_DEBUG_TITLE	HEAPID_DEBUG_APPLICATION

//============================================================================================
//	vg^Cv錾
//============================================================================================

static void VramBankSet(void);
static void BgInit( GF_BGL_INI * ini );
static void BmpListCB1( u32 param, u8 mode );
static void BmpListCB2( u8 index, u32 param, u8 y );
static void D_TitleMenuMemFree( GF_BGL_INI * ini );


static void SetFieldContinueProc(SAVEDATA * savedata);
static void SetFirstGameProc(SAVEDATA * savedata);
static void SetTitleProc(SAVEDATA * savedata);

//============================================================================================
//	O[oϐ
//============================================================================================
static const STRCODE str_firstgame[] = { sa_,i_,si_,yyo_,ka_,ra_,EOM_ };
static const STRCODE str_continue[] = { tu_,du_,ki_,ka_,ra_,EOM_ };
static const u16 str_modoru[] = { mo_,do_,ru_,EOM_ };

static const BMPLIST_DATA ListData[] =
{
	{ (const void *)str_continue, (u32)SetFieldContinueProc },
	{ (const void *)str_firstgame, (u32)SetFirstGameProc },
	{ (const void *)str_modoru, (u32)SetTitleProc },
};

static const BMPLIST_HEADER ListHeader = {
	ListData,
	NULL,					// J[\ړƂ̃R[obN֐
	NULL,					// \Ƃ̃R[obN֐
	NULL,					// BMPEBhEf[^
	NELEMS(ListData),		// Xgڐ
	5,						// \ő區ڐ
	0,						// x\wW
	12,						// ڕ\wW
	0,						// J[\\wW
	0,						// \xW
	FBMP_COL_WHITE,			//F
	FBMP_COL_BLACK,			//wiF
	FBMP_COL_BLK_SDW,		//eF
	0,						// Ԋuw
	16,						// Ԋux
	BMPLIST_LRKEY_SKIP,		// y[WXLbv^Cv
	FONT_SYSTEM,			// w({ u8 ǁAȂɍȂƎv̂)
	0						// afJ[\(allow)\tO(0:ON,1:OFF)
};



//--------------------------------------------------------------------------------------------
/**
 * VRAM
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void VramBankSet(void)
{
	GF_BGL_DISPVRAM vramSetTable = {
		GX_VRAM_BG_128_C,				// C2DGWBG
		GX_VRAM_BGEXTPLTT_NONE,			// C2DGWBGgpbg
		GX_VRAM_SUB_BG_32_H,			// Tu2DGWBG
		GX_VRAM_SUB_BGEXTPLTT_NONE,		// Tu2DGWBGgpbg
		GX_VRAM_OBJ_16_F,				// C2DGWOBJ
		GX_VRAM_OBJEXTPLTT_NONE,		// C2DGWOBJgpbg
		GX_VRAM_SUB_OBJ_16_I,			// Tu2DGWOBJ
		GX_VRAM_SUB_OBJEXTPLTT_NONE,	// Tu2DGWOBJgpbg
		GX_VRAM_TEX_01_AB,				// eNX`C[WXbg
		GX_VRAM_TEXPLTT_0123_E			// eNX`pbgXbg
	};
	GF_Disp_SetBank( &vramSetTable );
}

//--------------------------------------------------------------------------------------------
/**
 * BG
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BgInit( GF_BGL_INI * ini )
{
	{	// BG SYSTEM
		GF_BGL_SYS_HEADER BGsys_data = {
			GX_DISPMODE_GRAPHICS, GX_BGMODE_0, GX_BGMODE_0, GX_BG0_AS_2D,
		};
		GF_BGL_InitBG( &BGsys_data );
	}

	{	// MAIN DISP BG0
		GF_BGL_BGCNT_HEADER MBg0_Data = {
			0, 0, 0x1000, 0,
			GF_BGL_SCRSIZ_256x512, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xd000, GX_BG_CHARBASE_0x00000,
			GX_BG_EXTPLTT_01, 0, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME0_M, &MBg0_Data, GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear( ini, GF_BGL_FRAME0_M );
	}

	{	// MAIN DISP BG1
		GF_BGL_BGCNT_HEADER MBg1_Data = {
			0, 0, 0x800, 0,
			GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xe000, GX_BG_CHARBASE_0x00000,
			GX_BG_EXTPLTT_01, 1, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME1_M, &MBg1_Data, GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear( ini, GF_BGL_FRAME1_M );
	}

	{	// MAIN DISP BG2
		GF_BGL_BGCNT_HEADER MBg2_Data = {
			0, 0, 0x800, 0,
			GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xe800, GX_BG_CHARBASE_0x00000,
			GX_BG_EXTPLTT_23, 2, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME2_M, &MBg2_Data, GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear( ini, GF_BGL_FRAME2_M );
	}

	{	// MAIN DISP BG3
		GF_BGL_BGCNT_HEADER MBg3_Data = {
			0, 0, 0x800, 0,
			GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xf800, GX_BG_CHARBASE_0x00000,
			GX_BG_EXTPLTT_23, 3, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME3_M, &MBg3_Data, GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear( ini, GF_BGL_FRAME3_M );
	}
}


//--------------------------------------------------------------------------------------------
/**
 * J
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void D_TitleMenuMemFree( GF_BGL_INI * ini )
{
	// BGLJ
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME0_M );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME1_M );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME2_M );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME3_M );
}

//--------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------
static void SetFieldContinueProc(SAVEDATA * savedata)
{
	Main_SetNextProc(NO_OVERLAY_ID, &ContinueGameProcData);
}
static void SetFirstGameProc(SAVEDATA * savedata)
{
	GameData_SetNewGame(savedata);
	Main_SetNextProc(NO_OVERLAY_ID, &OpeningProcData);
	//Main_SetNextProc(NO_OVERLAY_ID, &DebugNewGameProcData);
}
static void SetTitleProc(SAVEDATA * savedata)
{
	FS_EXTERN_OVERLAY( title );
//	Main_SetNextProc(NO_OVERLAY_ID, &TitleProcData);
	Main_SetNextProc( FS_OVERLAY_ID(title), &TitleProcData);
}

//--------------------------------------------------------------------------------------------
/**
 * @brief	^CgvZXF
 * @param	proc	vZXւ̃|C^
 * @param	seq		V[PXp[Nւ̃|C^
 * @return	PROC_RES_CONTINUE	p
 * @return	PROC_RES_FINISH		I
 */
//--------------------------------------------------------------------------------------------
static PROC_RESULT DebugStartMenuProc_Init(PROC * proc, int * seq)
{
  SetBrightness(BRIGHTNESS_BLACK, PLANEMASK_ALL, MASK_DOUBLE_DISPLAY);
  sys_CreateHeap( HEAPID_BASE_APP, HEAPID_DEBUG_TITLE, 0x10000);
  {
    D_TITLE_WORK * wk;

    wk = PROC_AllocWork(proc, sizeof(D_TITLE_WORK), HEAPID_DEBUG_TITLE);
    wk->select_func = (SELECT_FUNC)NULL;
    
    wk->bgl = GF_BGL_BglIniAlloc( HEAPID_DEBUG_TITLE );

    GF_Disp_GX_VisibleControlInit();
    VramBankSet();
    BgInit( wk->bgl );

    MSG_PrintInit();

    SystemFontPaletteLoad( PALTYPE_MAIN_BG, FONT_PAL_NO_N * 32, HEAPID_DEBUG_TITLE );
    SystemFontPaletteLoad( PALTYPE_MAIN_BG, FONT_PAL_NO_S * 32, HEAPID_DEBUG_TITLE );

/* ------------------------------------------------------------------
 */
#define STARTMENU_0_H		9
#define STARTMENU_1_H		2
    
#define STARTMENU_FRAMECHR1	1
#define STARTMENU_FRAMECHR2	(STARTMENU_FRAMECHR1+9)
#define STARTMENU_WINDOWCHR	(STARTMENU_FRAMECHR2+9)
#define STARTMENU_FRAMECHR3	(768)

#define WAKU_PALETTE_NUMBER1	2
#define WAKU_PALETTE_NUMBER2	3

#define	STARTMENU_BLACK		(GF_PRINTCOLOR_MAKE(1, 2, 15))
#define	STARTMENU_RED		(GF_PRINTCOLOR_MAKE(3, 4, 15))
#define	STARTMENU_BLUE		(GF_PRINTCOLOR_MAKE(5, 6, 15))
#define	STARTMENU_WHITE		(GF_PRINTCOLOR_MAKE(15, 2, 0))
    {
      int i, y, base, my, wsize, width;
      STRBUF * msg;

      //EBhEgLApbgZbg
      MenuWinGraphicSet(wk->bgl, GF_BGL_FRAME0_M, STARTMENU_FRAMECHR1, WAKU_PALETTE_NUMBER1, 0, HEAPID_DEBUG_TITLE );
      MenuWinGraphicSet(wk->bgl, GF_BGL_FRAME0_M, STARTMENU_FRAMECHR2, WAKU_PALETTE_NUMBER2, 1, HEAPID_DEBUG_TITLE );
      // ߂ȂR[h
      {
#define RGB(r, g, b)	(((b)&31)<<10|((g)&31)<<5|((r)&31))
	u16 *plt = (u16 *)0x05000000;
	// pbgOJ[O̐Fł
	*plt = RGB(12, 12, 31);
#if 0
	// ĨtHgJ[ł
	plt = (u16 *)0x0500003E;
	*plt = RGB(24, 24, 24);
#endif
      }

      
      GF_BGL_ScrollSet(wk->bgl, GF_BGL_FRAME0_M, GF_BGL_SCROLL_Y_SET, -0);


      wk->msgman = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_startmenu_dat, HEAPID_DEBUG_TITLE);
      wk->word = WORDSET_Create(HEAPID_DEBUG_TITLE);
      wk->mst = SaveData_GetMyStatus(((MAINWORK *)PROC_GetParentWork(proc))->savedata);
      wk->zw = SaveData_GetZukanWork(((MAINWORK *)PROC_GetParentWork(proc))->savedata);
      
      y = 1;
      base = STARTMENU_WINDOWCHR;

      // Z[uf[^΁uÂ@͂߂v\Ȃ
      if (SaveData_GetExistFlag(((MAINWORK *)PROC_GetParentWork(proc))->savedata)) {
	title_windata[0].flag = 1;
	wk->select = 0;
      } else {
	wk->select = 1;
      }
      
      for(i = 0; i < MAX_D_TITLEWIN_NUM; i++){
	wk->swin[i].used = 0;
	if(title_windata[i].flag == 0)	continue;
	wk->swin[i].used = 1;
	//bitmap̈ǉ
	GF_BGL_BmpWinAdd(wk->bgl, &wk->swin[i].win, GF_BGL_FRAME0_M,
			 3, y, 26, title_windata[i].height, FONT_PAL_NO_N, base);
	//EBhEghԂ
	GF_BGL_BmpWinDataFill(&wk->swin[i].win, FontHeaderGet(FONT_SYSTEM, FONT_HEADER_B_COLOR));
	// ŏ̂PbZ[W͋Iɕ\
	msg = MSGDAT_UTIL_AllocExpandString(wk->word, wk->msgman, title_windata[i].msg[0], HEAPID_DEBUG_TITLE);
	GF_STR_PrintSimple(&wk->swin[i].win, FONT_SYSTEM, msg, 0, 0, MSG_NO_PUT, NULL);
	STRBUF_Delete(msg);
	// Qsڈȍ~̓IvV\
	for(my = 1; title_windata[i].msg[my]; my++){
	  msg = MSGDAT_UTIL_AllocExpandString(wk->word, wk->msgman, title_windata[i].msg[my], HEAPID_DEBUG_TITLE);
	  GF_STR_PrintColor(&wk->swin[i].win, FONT_SYSTEM, msg, D_TITLE_WIN_MARGIN_L, my*16, MSG_NO_PUT, STARTMENU_BLUE, NULL);
	  STRBUF_Delete(msg);

	  // ザ񂱂̖O\
	  if(my == 1){
#if 0
	    // ̎_ł̓vC[m肵ĂȂ悤Ȃ̂ŁA_~[Zbg
	    MyStatus_SetMyName(wk->mst, str_playername);
#endif
	    // vC[̖O\
	    WORDSET_RegisterPlayerName(wk->word, 0, wk->mst);
	    msg = MSGDAT_UTIL_AllocExpandString(wk->word, wk->msgman, mes_startmenu_17, HEAPID_DEBUG_TITLE);
	    width = FontProc_GetPrintStrWidth(FONT_SYSTEM, msg,	FontHeaderGet(FONT_SYSTEM, FONT_HEADER_SPACE_X));
	    wsize = GF_BGL_BmpWinGet_SizeX(&wk->swin[i].win) * 8 - (width + D_TITLE_WIN_MARGIN_L);
	    GF_STR_PrintColor(&wk->swin[i].win, FONT_SYSTEM, msg, wsize, my*16, MSG_NO_PUT, STARTMENU_BLUE, NULL);
	    STRBUF_Delete(msg);
	  }

	  // vC\
	  if(my == 2){
	    int count, keta, type;
#if 0
	    // ͂vCԂĂȂ̂Ń_~[Zbg
	    MyStatus_SetPlayTime(wk->mst, 2, 27, 0);
#endif
	    count = MyStatus_GetPlayTimeHour(wk->mst);
	    if (count >= 100) {
	      keta = 3;
	      type = NUMBER_DISPTYPE_LEFT;
	    } else if (count >= 10) {
	      keta = 3;
	      type = NUMBER_DISPTYPE_SPACE;
	    } else {
	      keta = 3 - 1;
	      type = NUMBER_DISPTYPE_SPACE;
	    }
	    WORDSET_RegisterNumber(wk->word, 0,
				   MyStatus_GetPlayTimeHour(wk->mst),
				   keta, type, NUMBER_CODETYPE_DEFAULT);
	    WORDSET_RegisterNumber(wk->word, 1,
				   MyStatus_GetPlayTimeMinute(wk->mst),
				   2, NUMBER_DISPTYPE_ZERO, NUMBER_CODETYPE_DEFAULT);

	    msg = MSGDAT_UTIL_AllocExpandString(wk->word, wk->msgman, mes_startmenu_18, HEAPID_DEBUG_TITLE);
	    width = FontProc_GetPrintStrWidth(FONT_SYSTEM, msg,	FontHeaderGet(FONT_SYSTEM, FONT_HEADER_SPACE_X));
	    wsize = GF_BGL_BmpWinGet_SizeX(&wk->swin[i].win) * 8 - (width + D_TITLE_WIN_MARGIN_L);
	    GF_STR_PrintColor(&wk->swin[i].win, FONT_SYSTEM, msg, wsize, my*16, MSG_NO_PUT, STARTMENU_BLUE, NULL);
	    STRBUF_Delete(msg);
	  }

	  // |P
	  if(my == 3){
	    int count, keta, type, zukan;

#if 0	// ĂȂ悤Ȃ̂ŁAx
	    ZukanWork_Init(wk->zw);
	    zukan = 12;
#else
	    zukan = ZukanWork_GetPokeGetCount(wk->zw);
#endif
	    
	    count = zukan;
	    if (count >= 100) {
	      keta = 3;
	      type = NUMBER_DISPTYPE_LEFT;
	    } else if (count >= 10) {
	      keta = 3;
	      type = NUMBER_DISPTYPE_SPACE;
	    } else {
	      keta = 3 - 1;
	      type = NUMBER_DISPTYPE_SPACE;
	    }
	    WORDSET_RegisterNumber(wk->word, 0,
				   zukan,
				   keta, type, NUMBER_CODETYPE_DEFAULT);
	    msg = MSGDAT_UTIL_AllocExpandString(wk->word, wk->msgman, mes_startmenu_19, HEAPID_DEBUG_TITLE);
	    width = FontProc_GetPrintStrWidth(FONT_SYSTEM, msg,	FontHeaderGet(FONT_SYSTEM, FONT_HEADER_SPACE_X));
	    wsize = GF_BGL_BmpWinGet_SizeX(&wk->swin[i].win) * 8 - (width + D_TITLE_WIN_MARGIN_L);
	    GF_STR_PrintColor(&wk->swin[i].win, FONT_SYSTEM, msg, wsize, my*16, MSG_NO_PUT, STARTMENU_BLUE, NULL);
	    STRBUF_Delete(msg);

	  }

	  // ĂobW
	  if(my == 4){
	    int badge;
#if 0
	    // ĂobW̐Ⴈ
	    badge = 0;
#else
	    badge = MyStatus_GetBadgeCount(wk->mst);
#endif	    
	    WORDSET_RegisterNumber(wk->word, 0,
				   badge,
				   1, NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT);
	    msg = MSGDAT_UTIL_AllocExpandString(wk->word, wk->msgman, mes_startmenu_20, HEAPID_DEBUG_TITLE);
	    width = FontProc_GetPrintStrWidth(FONT_SYSTEM, msg,	FontHeaderGet(FONT_SYSTEM, FONT_HEADER_SPACE_X));
	    wsize = GF_BGL_BmpWinGet_SizeX(&wk->swin[i].win) * 8 - (width + D_TITLE_WIN_MARGIN_L);
	    GF_STR_PrintColor(&wk->swin[i].win, FONT_SYSTEM, msg, wsize, my*16, MSG_NO_PUT, STARTMENU_BLUE, NULL);
	    STRBUF_Delete(msg);
	  }
	}
	y += title_windata[i].height + 2;
	base += 26 * title_windata[i].height;
      }
    }
    MSGMAN_Delete(wk->msgman);
    WORDSET_Delete(wk->word);
  }
  
  GF_Disp_DispOn();
  return PROC_RES_FINISH;
}


static void DebugStartMenu_RangerScreenInit(PROC * proc)
{
  int base;
  STRBUF * msg;
  D_TITLE_WORK * wk = PROC_GetWork(proc);

  BgInit( wk->bgl );
  GF_BGL_ScrollSet(wk->bgl, GF_BGL_FRAME0_M, GF_BGL_SCROLL_Y_SET, 0);

  wk->msgman = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_bconfind_dat, HEAPID_DEBUG_TITLE);
  wk->word = WORDSET_Create(HEAPID_DEBUG_TITLE);

  base = STARTMENU_WINDOWCHR;
  // u`{^Ł@ցv\EBhE
  GF_BGL_BmpWinAdd(wk->bgl, &wk->awin, GF_BGL_FRAME0_M, 20, 22, 11, 2, FONT_PAL_NO_N, base);
  //EBhEghԂ(F)
  GF_BGL_BmpWinDataFill(&wk->awin, 0);
  // ŏ̂PbZ[W͋Iɕ\
  msg = MSGDAT_UTIL_AllocExpandString(wk->word, wk->msgman, bcon_005, HEAPID_DEBUG_TITLE);
  GF_STR_PrintColor(&wk->awin, FONT_SYSTEM, msg, 0, 0, MSG_NO_PUT, STARTMENU_WHITE, NULL);
  STRBUF_Delete(msg);
  //EBhEg`
  BmpMenuWinWrite(&wk->awin, WINDOW_TRANS_ON, STARTMENU_FRAMECHR3, WAKU_PALETTE_NUMBER2);
  base += 26*2;


  // bZ[W\EBhE
  GF_BGL_BmpWinAdd(wk->bgl, &wk->rwin, GF_BGL_FRAME0_M, 3, 1, 26, 20, FONT_PAL_NO_N, base);
  //EBhEghԂ
  GF_BGL_BmpWinDataFill(&wk->rwin, FontHeaderGet(FONT_SYSTEM, FONT_HEADER_B_COLOR));
  // ŏ̂PbZ[W͋Iɕ\
  msg = MSGDAT_UTIL_AllocExpandString(wk->word, wk->msgman, bcon_001, HEAPID_DEBUG_TITLE);
  GF_STR_PrintSimple(&wk->rwin, FONT_SYSTEM, msg, 0, 0, MSG_NO_PUT, NULL);
  STRBUF_Delete(msg);
  //EBhEg`
  BmpMenuWinWrite(&wk->rwin, WINDOW_TRANS_ON, STARTMENU_FRAMECHR2, WAKU_PALETTE_NUMBER2);
  MSGMAN_Delete(wk->msgman);
  WORDSET_Delete(wk->word);
}


static void DebugStartMenu_FrameRedraw(D_TITLE_WORK * wk, int sel)
{
  int i;

  //EBhEg`
  for(i = 0; i < MAX_D_TITLEWIN_NUM; i++){
    if(title_windata[i].flag == 0)	continue;
    if(i == sel){
      BmpMenuWinWrite(&wk->swin[i].win, WINDOW_TRANS_ON, STARTMENU_FRAMECHR2, WAKU_PALETTE_NUMBER2);
    } else {
      BmpMenuWinWrite(&wk->swin[i].win, WINDOW_TRANS_ON, STARTMENU_FRAMECHR1, WAKU_PALETTE_NUMBER1);
    }
  }
}

static int DebugStartMenu_GetNextWindow(D_TITLE_WORK *wk, int add)
{
  int sel = wk->select;

  while(1){
    sel += add;
    if(sel == -1 || sel == sizeof(title_windata) / sizeof(D_TITLE_WINDATA))
      return wk->select;
    if(title_windata[sel].flag)
      return sel;
  }
  return 0;
}




//--------------------------------------------------------------------------------------------
/**
 * @brief	^CgvZXFC
 * @param	proc	vZXւ̃|C^
 * @param	seq		V[PXp[Nւ̃|C^
 * @return	PROC_RES_CONTINUE	p
 * @return	PROC_RES_FINISH		I
 */
//--------------------------------------------------------------------------------------------
static PROC_RESULT DebugStartMenuProc_Main(PROC * proc, int * seq)
{
	D_TITLE_WORK * wk = PROC_GetWork(proc);
	u32	ret;
	int oldsel;

	switch (*seq) {
	case 0:
		ChangeBrightnessRequest(8, BRIGHTNESS_NORMAL, BRIGHTNESS_BLACK,
				PLANEMASK_ALL, MASK_DOUBLE_DISPLAY);
		GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG0, VISIBLE_ON );		// START\
		DebugStartMenu_FrameRedraw(wk, wk->select);
		(*seq) ++;
		break;
	case 1:
		if (IsFinishedBrightnessChg(MASK_DOUBLE_DISPLAY)) {
		  (*seq) ++;
		}
		break;
#if 0
	case 2:
		ret = BmpListMain( wk->lw );

		switch( ret ){
		case BMPLIST_NULL:
			break;
		case BMPLIST_CANCEL:
			ret = (u32)SetTitleProc;
			//break;
		default:
			BmpListExit( wk->lw, NULL, NULL );
			GF_BGL_BmpWinOff( &wk->win );
			GF_BGL_BmpWinDel( &wk->win );
			D_TitleMenuMemFree( wk->bgl );
			sys_FreeMemoryEz( wk->bgl );
			wk->select_func = (SELECT_FUNC)ret;
			ChangeBrightnessRequest(8, BRIGHTNESS_BLACK, BRIGHTNESS_NORMAL,
					PLANEMASK_ALL, MASK_DOUBLE_DISPLAY);
			(*seq) ++;
			break;
		}
	case 3:
		if (IsFinishedBrightnessChg(MASK_DOUBLE_DISPLAY)) {
			return PROC_RES_FINISH;
		}
		break;
#else
	case 2:
#if 0
	  // zgGF_BGL_ScrollReqgƂ낾ǁcǂ킩
	  if(sys.trg & PAD_KEY_LEFT){
	    GF_BGL_ScrollSet(wk->bgl, GF_BGL_FRAME0_M, GF_BGL_SCROLL_Y_SET, -0);
	  } else if(sys.trg & PAD_KEY_RIGHT){
	    GF_BGL_ScrollSet(wk->bgl, GF_BGL_FRAME0_M, GF_BGL_SCROLL_Y_SET, 96-0);
	  }
#endif
	  oldsel = wk->select;

	  if(sys.trg & PAD_KEY_DOWN){
	    wk->select = DebugStartMenu_GetNextWindow(wk, 1);
	  }
	  if(sys.trg & PAD_KEY_UP){
	    wk->select = DebugStartMenu_GetNextWindow(wk, -1);
	  }
	  if(oldsel != wk->select){
	    DebugStartMenu_FrameRedraw(wk, wk->select);
	  }

	  if(sys.trg & PAD_BUTTON_A){
	    switch(wk->select){
	    case 0:	// Â@͂߂
	      wk->select_func = (SELECT_FUNC)SetFieldContinueProc;
	      break;
	    case 1:	// 傩@͂߂
	      wk->select_func = (SELECT_FUNC)SetFirstGameProc;
	      break;
	    case 3:	// |PW[Ɓ@
	      (*seq) ++;
	      break;
	    }
	  }
#if 1  // PɂƂa{^Ń^Cgɖ߂낤Ƃ܂
	  if(sys.trg & PAD_BUTTON_B){
	    wk->select_func = (SELECT_FUNC)SetTitleProc;
	  }
#endif
	  if(wk->select_func){
	    ChangeBrightnessRequest(8, BRIGHTNESS_BLACK, BRIGHTNESS_NORMAL,
				    PLANEMASK_ALL, MASK_DOUBLE_DISPLAY);
	    *seq = 5;
	  }

	  
	  break;
	case 3:
	  DebugStartMenu_RangerScreenInit(proc);
	  (*seq) ++;
	  break;
	case 4:
#if 0
	  if(sys.cont & PAD_KEY_UP){
	    GF_BGL_ScrollSet(wk->bgl, GF_BGL_FRAME0_M, GF_BGL_SCROLL_Y_INC,  1);
	  } else if(sys.cont & PAD_KEY_DOWN){
	    GF_BGL_ScrollSet(wk->bgl, GF_BGL_FRAME0_M, GF_BGL_SCROLL_Y_INC, -1);
	  }
#endif
	  if(sys.trg & (PAD_BUTTON_B|PAD_BUTTON_A)){
	    ChangeBrightnessRequest(8, BRIGHTNESS_BLACK, BRIGHTNESS_NORMAL,
				    PLANEMASK_ALL, MASK_DOUBLE_DISPLAY);
	    wk->select_func = (SELECT_FUNC)SetTitleProc;
	    *seq = 6;
	  }
	  break;

	case 5:
	  if (IsFinishedBrightnessChg(MASK_DOUBLE_DISPLAY)) {
	    int i;
	    for(i = 0; i < MAX_D_TITLEWIN_NUM; i++){
	      if(wk->swin[i].used){
		GF_BGL_BmpWinOff( &wk->swin[i].win );
		GF_BGL_BmpWinDel( &wk->swin[i].win );
	      }
	    }
	    D_TitleMenuMemFree( wk->bgl );
	    sys_FreeMemoryEz( wk->bgl );
	    return PROC_RES_FINISH;
	  }
	  break;

	case 6:
	  if (IsFinishedBrightnessChg(MASK_DOUBLE_DISPLAY)) {
	    int i;
	    GF_BGL_BmpWinOff( &wk->rwin ); GF_BGL_BmpWinDel( &wk->rwin );
	    GF_BGL_BmpWinOff( &wk->awin ); GF_BGL_BmpWinDel( &wk->awin );
	    for(i = 0; i < MAX_D_TITLEWIN_NUM; i++){
	      if(wk->swin[i].used){
		GF_BGL_BmpWinOff( &wk->swin[i].win );
		GF_BGL_BmpWinDel( &wk->swin[i].win );
	      }
	    }
	    D_TitleMenuMemFree( wk->bgl );
	    sys_FreeMemoryEz( wk->bgl );
	    return PROC_RES_FINISH;
	  }
	  break;
#endif
		break;
	}
	return PROC_RES_CONTINUE;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief	^CgvZXFI
 * @param	proc	vZXւ̃|C^
 * @param	seq		V[PXp[Nւ̃|C^
 * @return	PROC_RES_CONTINUE	p
 * @return	PROC_RES_FINISH		I
 */
//--------------------------------------------------------------------------------------------
static PROC_RESULT DebugStartMenuProc_End(PROC * proc, int * seq)
{
	D_TITLE_WORK * wk = PROC_GetWork(proc);
	wk->select_func(((MAINWORK *)PROC_GetParentWork(proc))->savedata);
	PROC_FreeWork(proc);

	sys_DeleteHeap(HEAPID_DEBUG_TITLE);
	
	return PROC_RES_FINISH;
}

//--------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------
const PROC_DATA DebugStartMenuProcData = {
	DebugStartMenuProc_Init,
	DebugStartMenuProc_Main,
	DebugStartMenuProc_End,
	NO_OVERLAY_ID
};

