//============================================================================================
/**
 * @file	d_title.c	
 * @bfief	fobO^Cgj[
 * @author	Hiroyuki Nakamura
 * @date	05.07.08
 */
//============================================================================================
#include "common.h"
#include "system/fontproc.h"
#include "system/bmp_list.h"
#include "system/lib_pack.h"
#include "system/arc_util.h"
#include "demo/title.h"
//#include "demo/opening/opening_sys.h"
#include "field/field.h"
#include "poke_test.h"

#include "system/main.h"

#include "msgdata/msg_debug_title.h"
#include "msgdata/msg.naix"

//============================================================================================
//	萔`
//============================================================================================
typedef void (*SELECT_FUNC)(SAVEDATA *);

typedef struct {
	GF_BGL_INI * bgl;
	GF_BGL_BMPWIN	win;
	BMPLIST_WORK * lw;
	SELECT_FUNC select_func;
	BMP_MENULIST_DATA *bmd;
	u32	end_flg;
}D_TITLE_WORK;

#define	FONT_PAL_NO		( 0 )


#define	HEAPID_DEBUG_TITLE	HEAPID_DEBUG_APPLICATION

//============================================================================================
//	vg^Cv錾
//============================================================================================

static void VramBankSet(void);
static void BgInit( GF_BGL_INI * ini );
static void BmpListCB1( u32 param, u8 mode );
static void BmpListCB2( u8 index, u32 param, u8 y );
static void D_TitleMenuMemFree( GF_BGL_INI * ini );


static void SetFieldStartProc(SAVEDATA * savedata);
static void SetFieldDebugStartProc(SAVEDATA * savedata);
static void SetFieldContinueProc(SAVEDATA * savedata);
static void SetDebugPokeGraProc(SAVEDATA * savedata);
static void SetDebugSoundTestProc(SAVEDATA * savedata);
static void SetDebugFightProc(SAVEDATA * savedata);
static void SetTitleProc(SAVEDATA * savedata);
//static void SetOpeningProc(SAVEDATA * savedata);

//============================================================================================
//	O[oϐ
//============================================================================================

//gmmt@CID𕶎wɎg\̐錾
typedef struct
{
	u32	strID;
	u32	param;
}LIST_DATA;

static const LIST_DATA ListData[] =
{
	//j[́̕Aconvert/message/src/debug_title.gmmɒǉĂ
	{ DT_DEBUGGAME,		(u32)SetFieldDebugStartProc },
	{ DT_CONTINUE,		(u32)SetFieldContinueProc },
	//{ DT_OPENING,		(u32)SetOpeningProc },
	{ DT_SOUNDTEST,		(u32)SetDebugSoundTestProc },
	{ DT_POKEGRATEST,	(u32)SetDebugPokeGraProc },
	{ DT_DEBUGFIGHT,	(u32)SetDebugFightProc },
//	{ (const void *)str_firstgame, (u32)SetFieldStartProc },
	{ DT_MODORU,		(u32)SetTitleProc },
};

static const BMPLIST_HEADER ListHeader = {
	NULL,
	NULL,					// J[\ړƂ̃R[obN֐
	NULL,					// \Ƃ̃R[obN֐
	NULL,					// BMPEBhEf[^
	NELEMS(ListData),		// Xgڐ
	6,						// \ő區ڐ
	0,						// x\wW
	12,						// ڕ\wW
	0,						// J[\\wW
	0,						// \xW
	FBMP_COL_WHITE,			//F
	FBMP_COL_BLACK,			//wiF
	FBMP_COL_BLK_SDW,		//eF
	0,						// Ԋuw
	16,						// Ԋux
	BMPLIST_LRKEY_SKIP,		// y[WXLbv^Cv
	FONT_SYSTEM,			// w({ u8 ǁAȂɍȂƎv̂)
	0						// afJ[\(allow)\tO(0:ON,1:OFF)
};

//\[X當\[X͏O by soga
#if 0
static const u16 str_modoru[] = { mo_,do_,ru_,EOM_ };
static const u16 str_soundtest[] = { SA_,U_,N_,DO_,TE_,SU_,TO_,EOM_ };
static const u16 str_pokegratest[] = { PO_,KE_,MO_,N_,GU_,RA_,HU_,II_,TTU_,KU_,EOM_ };
static const STRCODE str_firstgame[] = { sa_,i_,si_,yyo_,ka_,ra_,EOM_ };
static const STRCODE str_debuggame[] = { DE_,BA_,TTU_,GU_,ka_,i_,si_,EOM_ };
static const STRCODE str_continue[] = { tu_,du_,ki_,ka_,ra_,EOM_ };
static const STRCODE str_opening[] = { O_,bou_,PU_,NI_,N_,GU_,EOM_ };

static const BMPLIST_DATA ListData[] =
{
	{ (const void *)str_debuggame, (u32)SetFieldDebugStartProc },
	{ (const void *)str_continue, (u32)SetFieldContinueProc },
	{ (const void *)str_opening, (u32)SetOpeningProc },
	{ (const void *)str_soundtest, (u32)SetDebugSoundTestProc },
	{ (const void *)str_pokegratest, (u32)SetDebugPokeGraProc },
//	{ (const void *)str_firstgame, (u32)SetFieldStartProc },
	{ (const void *)str_modoru, (u32)SetTitleProc },
};

static const BMPLIST_HEADER ListHeader = {
	ListData,
	NULL,					// J[\ړƂ̃R[obN֐
	NULL,					// \Ƃ̃R[obN֐
	NULL,					// BMPEBhEf[^
	NELEMS(ListData),		// Xgڐ
	5,						// \ő區ڐ
	0,						// x\wW
	12,						// ڕ\wW
	0,						// J[\\wW
	0,						// \xW
	FBMP_COL_WHITE,			//F
	FBMP_COL_BLACK,			//wiF
	FBMP_COL_BLK_SDW,		//eF
	0,						// Ԋuw
	16,						// Ԋux
	BMPLIST_LRKEY_SKIP,		// y[WXLbv^Cv
	FONT_SYSTEM,			// w({ u8 ǁAȂɍȂƎv̂)
	0						// afJ[\(allow)\tO(0:ON,1:OFF)
};
#endif



//--------------------------------------------------------------------------------------------
/**
 * VRAM
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void VramBankSet(void)
{
	GF_BGL_DISPVRAM vramSetTable = {
		GX_VRAM_BG_128_C,				// C2DGWBG
		GX_VRAM_BGEXTPLTT_NONE,			// C2DGWBGgpbg
		GX_VRAM_SUB_BG_32_H,			// Tu2DGWBG
		GX_VRAM_SUB_BGEXTPLTT_NONE,		// Tu2DGWBGgpbg
		GX_VRAM_OBJ_16_F,				// C2DGWOBJ
		GX_VRAM_OBJEXTPLTT_NONE,		// C2DGWOBJgpbg
		GX_VRAM_SUB_OBJ_16_I,			// Tu2DGWOBJ
		GX_VRAM_SUB_OBJEXTPLTT_NONE,	// Tu2DGWOBJgpbg
		GX_VRAM_TEX_01_AB,				// eNX`C[WXbg
		GX_VRAM_TEXPLTT_0123_E			// eNX`pbgXbg
	};
	GF_Disp_SetBank( &vramSetTable );
}

//--------------------------------------------------------------------------------------------
/**
 * BG
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BgInit( GF_BGL_INI * ini )
{
	{	// BG SYSTEM
		GF_BGL_SYS_HEADER BGsys_data = {
			GX_DISPMODE_GRAPHICS, GX_BGMODE_0, GX_BGMODE_0, GX_BG0_AS_2D,
		};
		GF_BGL_InitBG( &BGsys_data );
	}

	{	// MAIN DISP BG0
		GF_BGL_BGCNT_HEADER MBg0_Data = {
			0, 0, 0x800, 0,
			GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xd000, GX_BG_CHARBASE_0x00000,
			GX_BG_EXTPLTT_01, 0, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME0_M, &MBg0_Data, GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear( ini, GF_BGL_FRAME0_M );
	}

	{	// MAIN DISP BG1
		GF_BGL_BGCNT_HEADER MBg1_Data = {
			0, 0, 0x800, 0,
			GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xd800, GX_BG_CHARBASE_0x00000,
			GX_BG_EXTPLTT_01, 1, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME1_M, &MBg1_Data, GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear( ini, GF_BGL_FRAME1_M );
	}

	{	// MAIN DISP BG2
		GF_BGL_BGCNT_HEADER MBg2_Data = {
			0, 0, 0x800, 0,
			GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xe800, GX_BG_CHARBASE_0x00000,
			GX_BG_EXTPLTT_23, 2, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME2_M, &MBg2_Data, GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear( ini, GF_BGL_FRAME2_M );
	}

	{	// MAIN DISP BG3
		GF_BGL_BGCNT_HEADER MBg3_Data = {
			0, 0, 0x800, 0,
			GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xf800, GX_BG_CHARBASE_0x00000,
			GX_BG_EXTPLTT_23, 3, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME3_M, &MBg3_Data, GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear( ini, GF_BGL_FRAME3_M );
	}
}


//--------------------------------------------------------------------------------------------
/**
 * J
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void D_TitleMenuMemFree( GF_BGL_INI * ini )
{
	// BGLJ
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME0_M );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME1_M );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME2_M );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME3_M );
/*
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME0_S );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME1_S );
*/
}
//--------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------
static void SetFieldStartProc(SAVEDATA * savedata)
{
	Main_SetNextProc(NO_OVERLAY_ID, &GameMainProcData);
}
static void SetFieldDebugStartProc(SAVEDATA * savedata)
{
	Main_SetNextProc(NO_OVERLAY_ID, &DebugNewGameProcData);
}
static void SetFieldContinueProc(SAVEDATA * savedata)
{
	Main_SetNextProc(NO_OVERLAY_ID, &ContinueGameProcData);
}
static void SetDebugPokeGraProc(SAVEDATA * savedata)
{
	Main_SetNextProc(NO_OVERLAY_ID, &PokeGraTestProcData);
}
static void SetDebugFightProc(SAVEDATA * savedata)
{
	Main_SetNextProc(NO_OVERLAY_ID, &DebugFightProcData);
}
static void SetDebugSoundTestProc(SAVEDATA * savedata)
{
	Main_SetNextProc(NO_OVERLAY_ID, &SoundTestProcData);
}
static void SetTitleProc(SAVEDATA * savedata)
{
	Main_SetNextProc(NO_OVERLAY_ID, &TitleProcData);
}
#if 0
static void SetOpeningProc(SAVEDATA * savedata)
{
	GameData_SetNewGame(savedata);
	Main_SetNextProc(NO_OVERLAY_ID, &OpeningProcData);
}
#endif

//--------------------------------------------------------------------------------------------
/**
 * @brief	^CgvZXFBMPMENULISTDATA̐
 * @param	bmd		BMP_MENULIST_DATA\̂ւ̃|C^
 */
//--------------------------------------------------------------------------------------------
static	void	BMP_MENULIST_Make(BMP_MENULIST_DATA *bmd)
{
	int				i;
	MSGDATA_MANAGER	*man;

	man=MSGMAN_Create(MSGMAN_TYPE_NORMAL,ARC_MSG,NARC_msg_debug_title_dat,HEAPID_DEBUG_TITLE);

	for(i=0;i<NELEMS(ListData);i++){
		BMP_MENULIST_AddArchiveString(bmd,man,ListData[i].strID,ListData[i].param);
	}

	MSGMAN_Delete(man);
}

//--------------------------------------------------------------------------------------------
/**
 * @brief	^CgvZXF
 * @param	proc	vZXւ̃|C^
 * @param	seq		V[PXp[Nւ̃|C^
 * @return	PROC_RES_CONTINUE	p
 * @return	PROC_RES_FINISH		I
 */
//--------------------------------------------------------------------------------------------
static PROC_RESULT DebugTitleMenuProc_Init(PROC * proc, int * seq)
{
//\[X當\[XÔɑΉo[W
	sys_CreateHeap( HEAPID_BASE_APP, HEAPID_DEBUG_TITLE, 0x10000);
	{
		D_TITLE_WORK * wk;

		wk = PROC_AllocWork(proc, sizeof(D_TITLE_WORK), HEAPID_DEBUG_TITLE);

		wk->bgl = GF_BGL_BglIniAlloc( HEAPID_DEBUG_TITLE );

		GF_Disp_GX_VisibleControlInit();
		VramBankSet();
		BgInit( wk->bgl );

		MSG_PrintInit();

		SystemFontPaletteLoad( PALTYPE_MAIN_BG, FONT_PAL_NO * 32, HEAPID_DEBUG_TITLE );

		{
			BMPLIST_HEADER	list_h;

			wk->bmd=BMP_MENULIST_Create(NELEMS(ListData),HEAPID_DEBUG_TITLE);
			BMP_MENULIST_Make(wk->bmd);

			GF_BGL_BmpWinAdd(
				wk->bgl, &wk->win, GF_BGL_FRAME0_M, 1, 1, 14, 12, FONT_PAL_NO, 1 );

			list_h = ListHeader;
			list_h.list = wk->bmd;
			list_h.win = &wk->win;
			wk->lw = BmpListSet( &list_h, 0, 0, HEAPID_DEBUG_TITLE );
		}
	}

		GF_Disp_DispOn();
	return PROC_RES_FINISH;
#if 0
	sys_CreateHeap( HEAPID_BASE_APP, HEAPID_DEBUG_TITLE, 0x10000);
	{
		D_TITLE_WORK * wk;

		wk = PROC_AllocWork(proc, sizeof(D_TITLE_WORK), HEAPID_DEBUG_TITLE);

		wk->bgl = GF_BGL_BglIniAlloc( HEAPID_DEBUG_TITLE );

		GF_Disp_GX_VisibleControlInit();
		VramBankSet();
		BgInit( wk->bgl );

		MSG_PrintInit();

		SystemFontPaletteLoad( PALTYPE_MAIN_BG, FONT_PAL_NO * 32, HEAPID_DEBUG_TITLE );

		{
			BMPLIST_HEADER	list_h;

			GF_BGL_BmpWinAdd(
				wk->bgl, &wk->win, GF_BGL_FRAME0_M, 1, 1, 14, 12, FONT_PAL_NO, 1 );

			list_h = ListHeader;
			list_h.win = &wk->win;
			wk->lw = BmpListSet( &list_h, 0, 0, HEAPID_DEBUG_TITLE );
		}
	}

		GF_Disp_DispOn();
	return PROC_RES_FINISH;
#endif
}

//--------------------------------------------------------------------------------------------
/**
 * @brief	^CgvZXFC
 * @param	proc	vZXւ̃|C^
 * @param	seq		V[PXp[Nւ̃|C^
 * @return	PROC_RES_CONTINUE	p
 * @return	PROC_RES_FINISH		I
 */
//--------------------------------------------------------------------------------------------
static PROC_RESULT DebugTitleMenuProc_Main(PROC * proc, int * seq)
{
	D_TITLE_WORK * wk = PROC_GetWork(proc);
	u32	ret;

	ret = BmpListMain( wk->lw );

	switch( ret ){
	case BMPLIST_NULL:
		break;
	case BMPLIST_CANCEL:
		ret = (u32)SetTitleProc;
	default:
		BMP_MENULIST_Delete(wk->bmd);
		BmpListExit( wk->lw, NULL, NULL );
		GF_BGL_BmpWinOff( &wk->win );
		GF_BGL_BmpWinDel( &wk->win );
		D_TitleMenuMemFree( wk->bgl );
		sys_FreeMemoryEz( wk->bgl );
		wk->select_func = (SELECT_FUNC)ret;
		return PROC_RES_FINISH;
	}
	return PROC_RES_CONTINUE;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief	^CgvZXFI
 * @param	proc	vZXւ̃|C^
 * @param	seq		V[PXp[Nւ̃|C^
 * @return	PROC_RES_CONTINUE	p
 * @return	PROC_RES_FINISH		I
 */
//--------------------------------------------------------------------------------------------
static PROC_RESULT DebugTitleMenuProc_End(PROC * proc, int * seq)
{
	D_TITLE_WORK * wk = PROC_GetWork(proc);
	wk->select_func(((MAINWORK*)PROC_GetParentWork(proc))->savedata);
	PROC_FreeWork(proc);

	sys_DeleteHeap(HEAPID_DEBUG_TITLE);
	return PROC_RES_FINISH;
}


//--------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------
const PROC_DATA DebugTitleMenuProcData = {
	DebugTitleMenuProc_Init,
	DebugTitleMenuProc_Main,
	DebugTitleMenuProc_End,
	NO_OVERLAY_ID
};

