//==============================================================================================
/**
 * @file	poke_test.c
 * @brief	|POtBbN`FbN
 * @author	sogabe
 * @date	2005.11.08
 */
//==============================================================================================
#include "common.h"
#include "system/fontproc.h"
#include "system/pm_str.h"
#include "system/msgdata.h"						//MSGDATA_MANAGER
#include "system/arc_tool.h"
#include "system/arc_util.h"
#include "system/softsprite.h"
#include "poke_test.h"

#include "msgdata/msg.naix"						//NARC_msg_??_dat
#include "battle/graphic/batt_bg_def.h"
#include "battle/battle_common.h"
#include "poketool/monsno.h"
#include "poketool/poke_tool.h"
#include "system/snd_tool.h"
#include "system/wordset.h"

#include "system/main.h"
#include "demo/title.h"
#include "msgdata/msg_poke_test.h"

//==============================================================================================
//
//	msgf[^
//
//==============================================================================================

//==============================================================================================
//
//	\
//
//==============================================================================================

typedef struct{
	BOOL end_flag;
	GF_BGL_INI			*bgl;
	GF_BGL_BMPWIN		*win;
	SOFT_SPRITE_MANAGER	*ssm;
	SOFT_SPRITE			*ss[2];
	int					seq_no;
	int					mons_no;
	int					sex;
	int					col;
}POKE_GRA_TEST;

//==============================================================================================
//
//	vg^Cv錾
//
//==============================================================================================

static	void	PokeGraInit(POKE_GRA_TEST *pgt);
static	void	PokeGraTestBGCreate(POKE_GRA_TEST *pgt,GF_BGL_INI *bgl);
static	void	PokeGraTestDebugPrint(POKE_GRA_TEST *pgt);
static	void	PokeGraTestVBlank(void *work);
static	void	Init3DStuff_(void);
static	u8		PokeGraTestSexGet(u16 monsno);
static	void	PokeGraTestMSG_Print(POKE_GRA_TEST *pgt);


//==================================================================================================
//
//	f[^
//
//==================================================================================================

//==================================================================================================
//
//	֐
//
//==================================================================================================

static	void	PokeGraInit(POKE_GRA_TEST *pgt)
{
	SOFT_SPRITE_ARC	ssa;
	int				height;

	MI_CpuClearFast(pgt,sizeof(POKE_GRA_TEST));

	pgt->end_flag = FALSE;
	pgt->bgl=GF_BGL_BglIniAlloc(HEAPID_BATTLE);
	pgt->win=GF_BGL_BmpWinAllocGet(HEAPID_BATTLE,1);

	PokeGraTestBGCreate(pgt,pgt->bgl);

	pgt->ssm=SoftSpriteInit(HEAPID_BATTLE);

	pgt->mons_no=1;
	pgt->sex=PokeGraTestSexGet(pgt->mons_no);
	if(pgt->sex==3){
		pgt->sex=0;
	}

	PokeGraArcDataGet(&ssa,pgt->mons_no,pgt->sex,PARA_BACK,pgt->col);
	height=PokeHeightGet(pgt->mons_no,pgt->sex,PARA_BACK);
	pgt->ss[0]=SoftSpriteAdd(pgt->ssm,&ssa,APPEAR_X_TYPE_AA,APPEAR_Y_TYPE_AA+height,APPEAR_Z_TYPE_AA,
							 0,NULL,NULL);
	PokeGraArcDataGet(&ssa,pgt->mons_no,pgt->sex,PARA_FRONT,pgt->col);
	height=PokeHeightGet(pgt->mons_no,pgt->sex,PARA_FRONT);
	pgt->ss[1]=SoftSpriteAdd(pgt->ssm,&ssa,APPEAR_X_TYPE_BB,APPEAR_Y_TYPE_BB+height,APPEAR_Z_TYPE_BB,
							 1,NULL,NULL);

	GF_BGL_BmpWinAdd(pgt->bgl,pgt->win,GF_BGL_FRAME1_M,0x02,0x13,28,4,0x0a,0x0d);

	PokeGraTestMSG_Print(pgt);
	Snd_Stop();
}

//============================================================================================
/**
 *	퓬wiʏʐ
 */
//============================================================================================
static	void	PokeGraTestBGCreate(POKE_GRA_TEST *pgt,GF_BGL_INI *bgl)
{
	Init3DStuff_();

	//J̋ʐݒs܂B
    {
        // PʍsƓ
        VecFx32 Eye = { 0, 0, 0 };                  // Eye position
        VecFx32 vUp = { 0, FX32_ONE, 0 };           // Up
        VecFx32 at = { 0, 0, -FX32_ONE };           // Viewpoint

        // Matrix mode is changed to GX_MTXMODE_POSITION_VECTOR internally,
        // and the camera matrix is loaded to the current matrix.
        G3_LookAt(&Eye, &vUp, &at, NULL);
    }
    // `̍ۂɗLƂȂAݒ肵܂B
    // sKvȁA𖳌ݒ肷邱ƂɂāAptH[}Xサ܂B
    NNS_G2dSetSpriteAttrEnable(
        NNS_G2D_SPRITEATTR_ALPHA |
        NNS_G2D_SPRITEATTR_UV    |
        NNS_G2D_SPRITEATTR_TEXTUE|
        NNS_G2D_SPRITEATTR_ROTXY |
        NNS_G2D_SPRITEATTR_ROTO
    );

	GF_Disp_GX_VisibleControlInit();

	//VRAMݒ
	{
		GF_BGL_DISPVRAM vramSetTable = {
			GX_VRAM_BG_128_C,				// C2DGWBG
			GX_VRAM_BGEXTPLTT_NONE,			// C2DGWBGgpbg
			GX_VRAM_SUB_BG_32_H,			// Tu2DGWBG
			GX_VRAM_SUB_BGEXTPLTT_NONE,		// Tu2DGWBGgpbg
			GX_VRAM_OBJ_64_E,				// C2DGWOBJ
			GX_VRAM_OBJEXTPLTT_NONE,		// C2DGWOBJgpbg
			GX_VRAM_SUB_OBJ_16_I,			// Tu2DGWOBJ
			GX_VRAM_SUB_OBJEXTPLTT_NONE,	// Tu2DGWOBJgpbg
			GX_VRAM_TEX_01_AB,				// eNX`C[WXbg
			GX_VRAM_TEXPLTT_01_FG			// eNX`pbgXbg
		};
		GF_Disp_SetBank( &vramSetTable );
	}

	// BG SYSTEM
	{
		GF_BGL_SYS_HEADER BGsys_data = {
			GX_DISPMODE_GRAPHICS, GX_BGMODE_0, GX_BGMODE_0, GX_BG0_AS_3D,
		};
		GF_BGL_InitBG( &BGsys_data );
	}

	//Cʃt[ݒ
	{
		GF_BGL_BGCNT_HEADER TextBgCntDat[] = {
			///<FRAME1_M
			{
				0, 0, 0x0800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
				GX_BG_SCRBASE_0x0000, GX_BG_CHARBASE_0x04000, GX_BG_EXTPLTT_01,
				0, 0, 0, FALSE
			},
			///<FRAME2_M
			{
				0, 0, 0x2000, 0, GF_BGL_SCRSIZ_512x512, GX_BG_COLORMODE_16,
				GX_BG_SCRBASE_0x1000, GX_BG_CHARBASE_0x0c000, GX_BG_EXTPLTT_01,
				1, 0, 0, FALSE
			},
			///<FRAME3_M
			{
				0, 0, 0x1000, 0, GF_BGL_SCRSIZ_512x256, GX_BG_COLORMODE_256,
				GX_BG_SCRBASE_0x3000, GX_BG_CHARBASE_0x10000, GX_BG_EXTPLTT_01,
				3, 0, 0, FALSE
			},
		};
		GF_BGL_BGControlSet(bgl, GF_BGL_FRAME1_M, &TextBgCntDat[0], GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear(bgl, GF_BGL_FRAME1_M );
		GF_BGL_BGControlSet(bgl, GF_BGL_FRAME2_M, &TextBgCntDat[1], GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear(bgl, GF_BGL_FRAME2_M );
		GF_BGL_BGControlSet(bgl, GF_BGL_FRAME3_M, &TextBgCntDat[2], GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear(bgl, GF_BGL_FRAME3_M );

		G2_SetBG0Priority(0x01);
		GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG0, VISIBLE_ON );
	}
	//Tuʃt[ݒ
	{
	}

	//wiOtBbNf[^[h
	{
		ArcUtil_BgCharSet(ARC_BATT_BG,BATTLE_WBG0A_NCGR_BIN,bgl,GF_BGL_FRAME1_M,0,0,1,HEAPID_BATTLE);
		ArcUtil_ScrnSet(ARC_BATT_BG,BATTLE_WBG0A_NSCR_BIN,bgl,GF_BGL_FRAME1_M,0,0,1,HEAPID_BATTLE);
		ArcUtil_BgCharSet(ARC_BATT_BG,BATTLE_BG00_NCGR_BIN,bgl,GF_BGL_FRAME3_M,0,0,1,HEAPID_BATTLE);
		ArcUtil_PalSet(ARC_BATT_BG,BATT_BG00_D_NCLR,PALTYPE_MAIN_BG,0,0,HEAPID_BATTLE);
		ArcUtil_ScrnSet(ARC_BATT_BG,BATTLE_BG00_NSCR_BIN,bgl,GF_BGL_FRAME3_M,0,0,1,HEAPID_BATTLE);
	}

	GF_Disp_DispOn();

	sys_VBlankFuncChange(PokeGraTestVBlank,pgt);
}

//============================================================================================
/**
 *	C[v^XN
 */
//============================================================================================
static	void	PokeGraTestMain(POKE_GRA_TEST * pgt)
{
	u8				sex;

	if(sys.repeat & PAD_KEY_LEFT){
		if(pgt->mons_no==1){
			pgt->mons_no=MONSNO_END;
		}
		else{
			pgt->mons_no--;
		}
	}
	else if(sys.repeat & PAD_KEY_RIGHT){
		if(pgt->mons_no==MONSNO_END){
			pgt->mons_no=1;
		}
		else{
			pgt->mons_no++;
		}
	}
	if(sys.repeat & PAD_BUTTON_L){
		if(pgt->mons_no-10<1){
			pgt->mons_no=MONSNO_END+(pgt->mons_no-10);
		}
		else{
			pgt->mons_no-=10;
		}
	}
	else if(sys.repeat & PAD_BUTTON_R){
		if(pgt->mons_no+10>MONSNO_END){
			pgt->mons_no=pgt->mons_no+10-MONSNO_END;
		}
		else{
			pgt->mons_no+=10;
		}
	}
	else if(sys.repeat & PAD_BUTTON_A){
		sex=PokeGraTestSexGet(pgt->mons_no);
		if(sex==3){
			pgt->sex^=1;
		}
	}
	else if(sys.repeat & PAD_BUTTON_B){
		pgt->col^=1;
	}
	if(sys.repeat){
		if((sys.repeat & (PAD_BUTTON_A|PAD_BUTTON_B))==0){
			pgt->sex=PokeGraTestSexGet(pgt->mons_no);
			if(pgt->sex==3){
				pgt->sex=0;
			}
		}
		PokeGraTestDebugPrint(pgt);
	}
	if(sys.trg & PAD_BUTTON_SELECT){
		GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG0, VISIBLE_OFF );
		GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG1, VISIBLE_OFF );
		GF_BGL_BGControlExit(pgt->bgl, GF_BGL_FRAME1_M );
		GF_BGL_BGControlExit(pgt->bgl, GF_BGL_FRAME2_M );
		GF_BGL_BGControlExit(pgt->bgl, GF_BGL_FRAME3_M );
		GF_BGL_BmpWinFree(pgt->win,1);
		SoftSpriteEnd(pgt->ssm);
		sys_FreeMemoryEz(pgt->bgl);
		pgt->end_flag = TRUE;
		return;
	}

	SoftSpriteMain(pgt->ssm);
	G3_SwapBuffers(GX_SORTMODE_AUTO, GX_BUFFERMODE_Z);
}

//============================================================================================
/**
 *	C[v^XN
 */
//============================================================================================
static	void	PokeGraTestDebugPrint(POKE_GRA_TEST *pgt)
{
	int				height;
	SOFT_SPRITE_ARC	*ssa;

	ssa=SoftSpriteArcPointerGet(pgt->ssm,0);
	PokeGraArcDataGet(ssa,pgt->mons_no,pgt->sex,PARA_BACK,pgt->col);
	height=PokeHeightGet(pgt->mons_no,pgt->sex,PARA_BACK)+APPEAR_Y_TYPE_AA;
	SoftSpriteParaSet(pgt->ss[0],SS_PARA_POS_Y,height);

	ssa=SoftSpriteArcPointerGet(pgt->ssm,1);
	PokeGraArcDataGet(ssa,pgt->mons_no,pgt->sex,PARA_FRONT,pgt->col);
	height=PokeHeightGet(pgt->mons_no,pgt->sex,PARA_FRONT)+APPEAR_Y_TYPE_BB;
	SoftSpriteParaSet(pgt->ss[1],SS_PARA_POS_Y,height);

	PokeGraTestMSG_Print(pgt);

	SoftSpriteRecover(pgt->ssm);
	Snd_PMVoicePlay(pgt->mons_no);
}

//==============================================================================================
//
//	^CgfobNj[Ă΂悤ɒǉ
//
//==============================================================================================
//--------------------------------------------------------------
//--------------------------------------------------------------
static PROC_RESULT PokeGraTestProc_Init(PROC * proc, int * seq)
{
	POKE_GRA_TEST	*pgt;
	sys_CreateHeap(HEAPID_BASE_APP,HEAPID_BATTLE,BATTLE_ALLOC_SIZE);
	pgt=PROC_AllocWork(proc,sizeof(POKE_GRA_TEST),HEAPID_BATTLE);
	PokeGraInit(pgt);
	return PROC_RES_FINISH;
}

//--------------------------------------------------------------
//--------------------------------------------------------------
static PROC_RESULT PokeGraTestProc_Main(PROC * proc, int * seq)
{
	POKE_GRA_TEST * pgt = PROC_GetWork(proc);
	PokeGraTestMain(pgt);
	if (pgt->end_flag) {
		return PROC_RES_FINISH;
	} else {
		return PROC_RES_CONTINUE;
	}
}

//--------------------------------------------------------------
//--------------------------------------------------------------
static PROC_RESULT PokeGraTestProc_End(PROC * proc, int * seq)
{
	PROC_FreeWork(proc);
	sys_DeleteHeap(HEAPID_BATTLE);
	Main_SetNextProc(NO_OVERLAY_ID, &TitleProcData);
	//sys_MainProcChange( TitleMainProc );				//A
	//\tgZbg
	//ڍׂ̓\[X擪́uTEheXg̗OɂāvQƂĉ
	//OS_InitReset();
	OS_ResetSystem(0);									//\tgZbg
	return PROC_RES_FINISH;
}

//--------------------------------------------------------------
//--------------------------------------------------------------
const PROC_DATA PokeGraTestProcData = {
	PokeGraTestProc_Init,
	PokeGraTestProc_Main,
	PokeGraTestProc_End,
	NO_OVERLAY_ID
};

//--------------------------------------------------------------
/**
 * @brief	VBLANK֐
 *
 * @param	work	VBLankɂ͈KvȂ̂Œ`Ă邪ۂɂNULLĂ̂ŁAANZX͋֎~I
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
static	void	PokeGraTestVBlank(void *work)
{
	POKE_GRA_TEST	*pgt=(POKE_GRA_TEST *)work;

	SoftSpriteTextureTrans(pgt->ssm);
	OS_SetIrqCheckFlag( OS_IE_V_BLANK);
}

//--------------------------------------------------------------
/**
 * @brief	3D
 *
 * @retval	none	
 */
//--------------------------------------------------------------
static void Init3DStuff_(void)
{
    G3X_Init();                                            // initialize the 3D graphics states
    G3X_InitMtxStack();                                    // initialize the matrix stack

    G2_SetBG0Priority(1);

    G3X_SetShading(GX_SHADING_TOON);
    G3X_AntiAlias(TRUE);
    G3X_AlphaBlend(TRUE);

    // 3D ʂ͓OFFłBGʂƃufBOs܂A
    // ̂߂ɂ̓ufBOΏۖʂ̎wsKv܂B
    // SDK ɂ͑Ώۖʂ݂̂ݒ肷 API ݂Ȃ̂ŁA G2_SetBlendAlpha g܂B
    // ̏ꍇ G2_SetBlendAlpha ̌2͖̈܂B
    G2_SetBlendAlpha(GX_BLEND_PLANEMASK_BG0, GX_BLEND_PLANEMASK_BD, 0, 0);

    // clear color
    G3X_SetClearColor(GX_RGB(0, 0, 0), 0, 0x7fff, 0, FALSE );

    G3_SwapBuffers(GX_SORTMODE_AUTO, GX_BUFFERMODE_Z);
}

//--------------------------------------------------------------
/**
 * @brief	|PʃQbg
 *
 * @retval	none	
 */
//--------------------------------------------------------------
static	u8	PokeGraTestSexGet(u16 monsno)
{
	u8	sex;

	sex=PokePersonalParaGet(monsno,ID_PER_sex);
	switch(sex){
		case	MONS_MALE:
			return	PARA_MALE;
		case	MONS_FEMALE:
			return	PARA_FEMALE;
		case	MONS_UNKNOWN:
			return	PARA_UNK;
	}
	return	3;
}

//--------------------------------------------------------------
//	bZ[W\ʒu`
//--------------------------------------------------------------
#define	MONS_NUM_X	(0)		//X^[io[\Xʒu
#define	MONS_NUM_Y	(8)		//X^[io[\Yʒu
#define	MONS_NAME_X	(32)	//X^[\Xʒu
#define	MONS_NAME_Y	(8)		//X^[\Yʒu
#define	MONS_SEX_X	(96)	//X^[ʕ\Xʒu
#define	MONS_SEX_Y	(8)		//X^[ʕ\Yʒu
#define	MONS_COL_X	(128)	//X^[J[\Xʒu
#define	MONS_COL_Y	(8)		//X^[J[\Yʒu


//--------------------------------------------------------------
/**
 * @brief	bZ[W\
 *
 * @retval	none	
 */
//--------------------------------------------------------------
static	void	PokeGraTestMSG_Print(POKE_GRA_TEST *pgt)
{
	MSGDATA_MANAGER		*msg_m;
	STRBUF				*msg_buf;

	GF_BGL_BmpWinDataFill(pgt->win,0xff);

	msg_buf=STRBUF_Create(0x100,HEAPID_BATTLE);

	//X^[io[
	STRBUF_SetNumber( msg_buf, pgt->mons_no, 3, NUMBER_DISPTYPE_ZERO,NUMBER_CODETYPE_DEFAULT);
	GF_STR_PrintSimple(pgt->win,FONT_SYSTEM,msg_buf,MONS_NUM_X,MONS_NUM_Y,0,NULL);

	//X^[
	msg_m=MSGMAN_Create(MSGMAN_TYPE_DIRECT,ARC_MSG,NARC_msg_monsname_dat,HEAPID_BATTLE);
	MSGMAN_GetString(msg_m,pgt->mons_no,msg_buf);
	MSGMAN_Delete(msg_m);
	GF_STR_PrintSimple(pgt->win,FONT_SYSTEM,msg_buf,MONS_NAME_X,MONS_NAME_Y,0,NULL);

	//
	msg_m=MSGMAN_Create(MSGMAN_TYPE_DIRECT,ARC_MSG,NARC_msg_poke_test_dat,HEAPID_BATTLE);
	MSGMAN_GetString(msg_m,POKE_TEST_002+pgt->sex,msg_buf);
	GF_STR_PrintSimple(pgt->win,FONT_SYSTEM,msg_buf,MONS_SEX_X,MONS_SEX_Y,0,NULL);

	//J[
	MSGMAN_GetString(msg_m,POKE_TEST_005+pgt->col,msg_buf);
	GF_STR_PrintSimple(pgt->win,FONT_SYSTEM,msg_buf,MONS_COL_X,MONS_COL_Y,0,NULL);

	//bZ[W}l[W֘A폜
	MSGMAN_Delete(msg_m);
	sys_FreeMemoryEz(msg_buf);
}

