//==============================================================================================
/**
 * @file	snd_test.c
 * @brief	TEheXg(TEh`FbN)
 * @author	nohara
 * @date	2005.07.04
 *
 * TEheXg̗Oɂā
 *
 * Pj
 * TEhq[vgpāAf[^̃[hs悤ɂƁA
 * Ȃ̍ĐA~ƂɁAmہAJsȂƂȂȂ܂B
 *
 * ꂾƁAɕ̃V[PXf[^Đ邱Ƃ͓̂ŁA
 * ߂Ƀq[vSăNAāABGM,SE,PṼvC[ɑ΂āA
 * vC[q[v쐬悤ɂđΏĂ܂B
 *
 * Qj
 * ܂AMẼvC[̓q[veʂȂ߁A
 * vC[q[v쐬邱ƂoȂ̂ŁA
 * BGM̃vC[gpĖ炷悤ɂĂ܂B
 *
 * Rj
 * L̗OĂ̂ŁA
 * TEhݒ肪AQ[Ƃ́ASقȂ܂B
 * ̂߁Aʏ̃TEhʂA
 * SȂ̂ŁAIŁA\tgZbgĂ܂B
 */
//==============================================================================================
#include "common.h"
#include "system/main.h"
#include "system/fontproc.h"
#include "system/bmp_list.h"
#include "system/lib_pack.h"
#include "system/palanm.h"
#include "system/pm_str.h"
#include "../system/snd_tool.h"
//#include "include/system/snd_tool.h"
#include "system/bmp_menu.h"
#include "system/get_text.h"					//GetMessageData
#include "system/msgdata.h"						//MSGDATA_MANAGER
#include "system/bmp_menu.h"
#include "snd_test.h"
#include "demo/title.h"
#include "msgdata/msg_snd_test_name.h"

#include "msgdata/msg.naix"						//NARC_msg_??_dat
#include "msgdata/msg_snd_test_str.h"

//extern void Snd_UseHeapSizeOsPrint(void);


//==============================================================================================
//
//	
//
//==============================================================================================
enum{
	BUF_BGM = 0,
	BUF_SE,
	BUF_PV,

	BUF_MAX,								//obt@̍ő吔
};
#define SND_TEST_BUF_SIZE		(48)		//obt@̃TCY

#define D_SE_HANDLE_MAX		(4)		//ӁI


//==============================================================================================
//
//	\
//
//==============================================================================================
//TEheXg\
typedef	struct {
	BOOL end_flag;
	u8	seq;							//io[
	s8  select;							//IΏ
	u16 dmy2;

	int	bgm;							//BGMio[
	int	se;								//SEio[
	int	pv;								//|Pio[

	int bgm_lv;							//Kw
	int se_lv[D_SE_HANDLE_MAX];			//Kw
	int pv_lv;							//Kw

	u8  bgm_play_flag;					//xłĐtO
	u8  se_play_flag[D_SE_HANDLE_MAX];	//xłĐtO
	u8  pv_play_flag;					//xłĐtO
	u8  dmy3;
	
	int pitch;							//
	int tempo;							//e|

	u16* pMsg;


	GF_BGL_INI * bgl;

	GF_BGL_BMPWIN bmpwin;				//BMPEBhEf[^

	STRBUF* msg_buf[BUF_MAX];

	MSGDATA_MANAGER* msgman;			//bZ[W}l[W[

}SND_TEST_WORK;


//==============================================================================================
//
//	vg^Cv錾
//
//==============================================================================================
static void SndTestCall(SND_TEST_WORK * wk);

static void SndTestWorkInit( SND_TEST_WORK* wk );
static void SndTestSeqNext( SND_TEST_WORK* wk );

static void SndTestSeqInit( SND_TEST_WORK* wk );
static void SndTestSeqBgmFadeWait( SND_TEST_WORK* wk );
static void SndTestSeqKeyCheck( SND_TEST_WORK* wk );
static void SndTestSeqExit( SND_TEST_WORK* wk );

static void SndTestStop( SND_TEST_WORK* wk );
static void SndTestPlay( SND_TEST_WORK* wk );

//static void (* const SndTestTable[])() = {
static void (* const SndTestTable[])(SND_TEST_WORK*) = {
	SndTestSeqInit,						//
	SndTestSeqBgmFadeWait,				//BGMtF[hAEg҂
	SndTestSeqKeyCheck,					//L[`FbN
	SndTestSeqExit,						//I
};

static void SndTestNumMsgSet( GF_BGL_BMPWIN* win, int num, u8 x, u8 y );
static void SndTestNameMsgSet( GF_BGL_BMPWIN* win, const STRBUF* msg, u8 x, u8 y );
static void MsgRewrite( SND_TEST_WORK* wk, s8 select );
static void SndTestInit( SND_TEST_WORK* wk );
static void SndTestCursor( SND_TEST_WORK* wk );
static void SndTestSysMsgSet( SND_TEST_WORK* wk );
static void SndTestStrPrint( GF_BGL_BMPWIN* win, u32 fontID, u32 strID, u32 x, u32 y, u32 wait, pStrPrintCallBack callback );

//BGݒ
static void SetBank();
static void BgSet( SND_TEST_WORK* wk );


//==================================================================================================
//
//	f[^
//
//==================================================================================================
static const BMPWIN_DAT	SndTestWinData = {
	SND_TEST_BMPWIN_FRAME,					//EChEgpt[
	SND_TEST_BMPWIN_PX1,SND_TEST_BMPWIN_PY1,//EChË̍X,YWiLPʂŎwj
	SND_TEST_BMPWIN_SX,	SND_TEST_BMPWIN_SY,	//EChËX,YTCYiLPʂŎwj
	SND_TEST_BMPWIN_PL,						//EChË̃pbgio[	
	SND_TEST_BMPWIN_CH						//EChEL̈̊JnLN^io[
};

//tHgJ[f[^(gflib/fntsys.hɒ`)
static const u16 font_pal[] = {
	//0x3713,0x31ad,0x5ef6,0x7fff,0x4230,0x7dc0,0x76ef,0x089d,
	//0x1fff,0x31ad,0x5ef6,0x7fff,0x4230,0x7dc0,0x76ef,0x089d,
	0x22ff,0x31ad,0x5ef6,0x7fff,0x4230,0x7dc0,0x76ef,0x089d,
	0x5ebf,0x5e5f,0x737f,0x135e,0x57bf,0x0f45,0x47b3,0x7fff
};


//==================================================================================================
//
//	֐
//
//==================================================================================================

//--------------------------------------------------------------
/**
 * @brief	TEheXgĂяo
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void SndTestCall(SND_TEST_WORK * wk)
{

	if( wk == NULL ){
		OS_Printf("snd_test.c Alloc ERROR!");
		return;
	}

	wk->bgl = GF_BGL_BglIniAlloc( HEAPID_BASE_DEBUG );

	//BGݒ
	GF_Disp_GX_VisibleControlInit();	//Cʂ̊eʂ̕\Rg[
	SetBank();							//VRAMoNݒ
	BgSet(wk);							//BGݒ
	GF_Disp_DispOn();					//\Lݒ
	MSG_PrintInit();					//\֐

#ifdef SOUND_OS_PRINT_ON
	OS_Printf( "\n\n//==========================================\n" );
	OS_Printf( "//\tTEheXg@X^[g\n" );
	OS_Printf( "//==========================================\n" );
#endif

	wk->end_flag = FALSE;
	wk->seq			= 0;									//io[
	SndTestWorkInit(wk);									//[N

	//bZ[Wf[^}l[W[쐬
	wk->msgman = MSGMAN_Create( MSGMAN_TYPE_DIRECT, ARC_MSG, 
									NARC_msg_snd_test_name_dat, HEAPID_BASE_DEBUG );

	//app(fld_debug.c)
	//FieldBitMapWinCgxSet();
	
	GX_LoadBGPltt( font_pal, 0, sizeof(font_pal) );			//tHgpbgf[^Zbg

	GF_BGL_BmpWinAddEx( wk->bgl, &wk->bmpwin, &SndTestWinData );		//rbg}bvǉ
	GF_BGL_BmpWinDataFill( &wk->bmpwin, FBMP_COL_WHITE );				//hԂ

	SndTestSysMsgSet( wk );									//Kvȏ񃁃bZ[W
	SndTestCursor( wk );									//J[\XV

	//ȖbZ[W\
	MsgRewrite( wk, SND_TEST_TYPE_BGM );					//BGMio[
	MsgRewrite( wk, SND_TEST_TYPE_SE );						//SEio[
	MsgRewrite( wk, SND_TEST_TYPE_PV );						//PVio[

	SndTestNumMsgSet( &wk->bmpwin, wk->pitch, ST_TYPE_X+88, ST_BGM_MSG_Y );//
	SndTestNumMsgSet( &wk->bmpwin, wk->tempo, ST_TYPE_X+168, ST_BGM_MSG_Y );//e|

	GF_BGL_BmpWinOn( &wk->bmpwin );


	return;
}

//--------------------------------------------------------------
/**
 * @brief	[N
 *
 * @param	wk		SND_TEST_WORKւ̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void SndTestWorkInit( SND_TEST_WORK* wk )
{
	int i;

	wk->select		= SND_TEST_TYPE_BGM;		//IΏ

	wk->bgm			= SND_TEST_BGM_START_NO;	//BGMX^[gio[
	wk->se			= SND_TEST_SE_START_NO;		//SEX^[gio[
	wk->pv			= SND_TEST_PV_START_NO;		//|PX^[gio[

	//Kw
	wk->bgm_lv		= 1;			
	wk->pv_lv		= 1;		

	for( i=0; i < D_SE_HANDLE_MAX ;i++ ){
		wk->se_lv[i] = 1;		
	}

	//xłĐtO
	wk->bgm_play_flag	= 0;					
	wk->pv_play_flag	= 0;

	for( i=0; i < D_SE_HANDLE_MAX ;i++ ){
		wk->se_play_flag[i]	= 0;
	}

	wk->pMsg = NULL;

	wk->pitch		= 0;	//
	wk->tempo		= 256;	//e|

	// obt@쐬
	for(i=0; i<BUF_MAX; i++)
	{
		wk->msg_buf[i] = STRBUF_Create(SND_TEST_BUF_SIZE*2, HEAPID_BASE_DEBUG);
	}

	return;
}

//--------------------------------------------------------------
/**
 * @brief	̏
 *
 * @param	wk		SND_TEST_WORKւ̃|C^
 *
 * @retval	none
 *
 * KvȏǉĂ(TuV[PX̃NAȂ)
 */
//--------------------------------------------------------------
static void SndTestSeqNext( SND_TEST_WORK* wk)
{
	wk->seq++;
	return;
}

//--------------------------------------------------------------
/**
 * @brief	
 *
 * @param	wk		SND_TEST_WORKւ̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void SndTestSeqInit( SND_TEST_WORK* wk )
{
	//Snd_BgmFadeOut( 60 );				//BGMtF[hAEg
	Snd_Stop();							//S~
	
	SndTestSeqNext(wk);
	return;
}

//--------------------------------------------------------------
/**
 * @brief	BGMtF[hAEg҂
 *
 * @param	wk		SND_TEST_WORKւ̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void SndTestSeqBgmFadeWait( SND_TEST_WORK* wk )
{
	int ret;

	if( Snd_FadeCheck() ){						//BGMtF[hAEg҂
		return;
	}

#ifdef SOUND_OS_PRINT_ON
	OS_Printf( "TEheXgpɉ[hĂȂԂɂI\n" );
#endif
	Snd_HeapStateClear();						//[hĂȂԂɂ(풓)
	
	//x[VbNoNAg`[h
	Snd_DebugLoadBank( BANK_BASIC );
	
	//vC[q[v쐬
	
	//PLAYER_FILED,PLAYER_BGM,PLAYER_MÉA
	//S"PLAYER_BGM"ōĐ悤ɂI
	ret = Snd_PlayerHeapCreate( PLAYER_BGM, 80000 );
	//Snd_UseHeapSizeOsPrint();						//ǉTEhq[v̗eʂo͂
	//OS_Printf( "player_bgm heap create = %d\n", ret );

	//PLAYER_SE_1,SE_2,SE_3,SE_4́A
	//S"PLAYER_SE_1"ōĐ悤ɂI
	ret = Snd_PlayerHeapCreate( PLAYER_SE_1,  100000 );
	//Snd_UseHeapSizeOsPrint();						//ǉTEhq[v̗eʂo͂
	//OS_Printf( "player_se_1 heap create = %d\n", ret );

	SndTestSeqNext(wk);
	return;
}

//--------------------------------------------------------------
/**
 * @brief	L[`FbN
 *
 * @param	wk		SND_TEST_WORKւ̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void SndTestSeqKeyCheck( SND_TEST_WORK* wk )
{
	int ret, i, spd;

	//ύX
	if( sys.cont & PAD_BUTTON_SELECT ){
		if( sys.repeat & PAD_KEY_UP ){
			wk->pitch++;
		}else if( sys.repeat & PAD_KEY_DOWN ){
			wk->pitch--;
		}
		SndTestNumMsgSet( &wk->bmpwin, wk->pitch, ST_TYPE_X+88, ST_BGM_MSG_Y );
		Snd_PlayerSetTrackPitch( SND_HANDLE_BGM, 0xffff, (wk->pitch*64) );
		GF_BGL_BmpWinOn( &wk->bmpwin );
		return;
	}

	//e|ύX
	if( sys.cont & PAD_BUTTON_START ){
		if( sys.repeat & PAD_KEY_UP ){
			wk->tempo+=32;
		}else if( sys.repeat & PAD_KEY_DOWN ){
			wk->tempo-=32;
		}
		SndTestNumMsgSet( &wk->bmpwin, wk->tempo, ST_TYPE_X+168, ST_BGM_MSG_Y );
		Snd_PlayerSetTempoRatio( SND_HANDLE_BGM, wk->tempo );
		GF_BGL_BmpWinOn( &wk->bmpwin );
		return;
	}

	//ΏۂύX(BGMPVSE)
	if( sys.trg & PAD_KEY_DOWN ){
		wk->select++;
		if( wk->select >= SND_TEST_TYPE_MAX ){
			wk->select = SND_TEST_TYPE_BGM;
		}

		SndTestCursor( wk );					//J[\XV
		GF_BGL_BmpWinOn( &wk->bmpwin );
	}

	//ΏۂύX(BGMSEPV)
	if( sys.trg & PAD_KEY_UP ){
		wk->select--;
		if( wk->select < SND_TEST_TYPE_BGM ){
			wk->select = (SND_TEST_TYPE_MAX-1);
		}

		SndTestCursor( wk );					//J[\XV
		GF_BGL_BmpWinOn( &wk->bmpwin );
	}

	//V[PXio[i߂
	if( sys.repeat & PAD_KEY_RIGHT ){

		if( (sys.cont & PAD_BUTTON_R) || (sys.cont & PAD_BUTTON_L) ){
			spd = 10;												//10
		}else{
			spd = 1;												//1
		}

		switch( wk->select ){
		case SND_TEST_TYPE_BGM:
			wk->bgm+=spd;
			if( wk->bgm >= SND_TEST_BGM_END_NO ){
				wk->bgm = SND_TEST_BGM_START_NO;
			}

			MsgRewrite( wk, SND_TEST_TYPE_BGM );					//BGMio[
			GF_BGL_BmpWinOn( &wk->bmpwin );
			break;
		case SND_TEST_TYPE_SE:
			wk->se+=spd;
			if( wk->se >= SND_TEST_SE_END_NO ){
				wk->se = SND_TEST_SE_START_NO;
			}

			MsgRewrite( wk, SND_TEST_TYPE_SE );						//SEio[
			GF_BGL_BmpWinOn( &wk->bmpwin );
			break;
		case SND_TEST_TYPE_PV:
			wk->pv+=spd;
			if( wk->pv >= SND_TEST_PV_END_NO ){
				wk->pv = SND_TEST_PV_START_NO;
			}

			MsgRewrite( wk, SND_TEST_TYPE_PV );						//PVio[
			GF_BGL_BmpWinOn( &wk->bmpwin );
			break;
		};
	}

	//V[PXio[߂
	if( sys.repeat & PAD_KEY_LEFT ){

		if( (sys.cont & PAD_BUTTON_R) || (sys.cont & PAD_BUTTON_L) ){
			spd = 10;												//10
		}else{
			spd = 1;												//1
		}

		switch( wk->select ){
		case SND_TEST_TYPE_BGM:
			wk->bgm-=spd;
			if( wk->bgm < SND_TEST_BGM_START_NO ){
				wk->bgm = (SND_TEST_BGM_END_NO);
			}

			MsgRewrite( wk, SND_TEST_TYPE_BGM );					//BGMio[
			GF_BGL_BmpWinOn( &wk->bmpwin );
			break;
		case SND_TEST_TYPE_SE:
			wk->se-=spd;
			if( wk->se < SND_TEST_SE_START_NO ){
				wk->se = (SND_TEST_SE_END_NO);
			}

			MsgRewrite( wk, SND_TEST_TYPE_SE );						//SEio[
			GF_BGL_BmpWinOn( &wk->bmpwin );
			break;
		case SND_TEST_TYPE_PV:
			wk->pv-=spd;
			if( wk->pv < SND_TEST_PV_START_NO ){
				wk->pv = (SND_TEST_PV_END_NO);
			}

			MsgRewrite( wk, SND_TEST_TYPE_PV );						//PVio[
			GF_BGL_BmpWinOn( &wk->bmpwin );
			break;
		};
	}

	//~
	if( sys.trg & PAD_BUTTON_B ){
		SndTestStop(wk);
	}

	//Đ(~ĂĐ)
	if( sys.trg & PAD_BUTTON_A ){
		SndTestStop(wk);
		SndTestPlay(wk);
	}

	//
	//if( sys.cont & PAD_BUTTON_SELECT ){
	if( sys.cont & PAD_BUTTON_Y ){
		Snd_Stop();						//SĒ~
		SndTestInit( wk );				//[NAf[^ȂǃNA
		GF_BGL_BmpWinOn( &wk->bmpwin );
	}

	//I
	//if( sys.cont & PAD_BUTTON_START ){
	if( sys.cont & PAD_BUTTON_X ){
		Snd_Stop();						//SĒ~
		SndTestSeqNext(wk);
		return;
	}

	return;
}

//--------------------------------------------------------------
/**
 * @brief	I
 *
 * @param	wk		SND_TEST_WORKւ̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void SndTestSeqExit( SND_TEST_WORK* wk )
{
	int i;

	//BMPEBhEOFF
	GF_BGL_BmpWinOff( &wk->bmpwin );
	
	//BMPXgj
	//BmpListExit( wp->bmplistContID,&DebugList,&DebugCursor );
	//BmpListExit( wk->blwin, NULL, NULL );

	//BMPWindow
	GF_BGL_BmpWinDel( &wk->bmpwin );

	MSGMAN_Delete( wk->msgman );

	//BGLJ
	GF_BGL_BGControlExit( wk->bgl, SND_TEST_BMPWIN_FRAME );

	//bgl폜
	sys_FreeMemoryEz( wk->bgl );

	//obt@폜
	for(i=0; i<BUF_MAX; i++)
	{
		if(wk->msg_buf[i]){
			STRBUF_Delete(wk->msg_buf[i]);
		}
	}

#if 0
	//NNS_SndHeapDestroy( ret );		//vC[q[vjȂƂȂ
	Snd_HeapStateClear();				//[hĂȂԂɂ(풓)
	Snd_GameStartLoad();				//Q[JñTEhf[^[h
#endif
	
	wk->end_flag = TRUE;

	return;
}

//--------------------------------------------------------------
/**
 * @brief	TEh~
 *
 * @param	wk		SND_TEST_WORKւ̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void SndTestStop( SND_TEST_WORK* wk )
{
	int i,type;

	switch( wk->select ){
	case SND_TEST_TYPE_BGM:
		Snd_BgmStop(Snd_NowBgmNoGet(), 0);
		break;
	case SND_TEST_TYPE_SE:
		Snd_SeStopBySeqNo( wk->se, 0 );
		break;
	case SND_TEST_TYPE_PV:
		Snd_PMVoiceStop(0);
		break;
	};

	return;
}

//--------------------------------------------------------------
/**
 * @brief	TEhĐ
 *
 * @param	wk		SND_TEST_WORKւ̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void SndTestPlay( SND_TEST_WORK* wk )
{
	int type,ret;

	switch( wk->select ){
	case SND_TEST_TYPE_BGM:
		//BGMME𔻕ʂāAMEȂATEheXĝPLAYER_BGMŖ炷悤ɂI
		//V[PXio[AvC[io[擾
		type = Snd_GetPlayerNo(wk->bgm);
		if( type == PLAYER_BGM ){
			ret = Snd_BgmPlay( wk->bgm );
		}else if( (type == PLAYER_ME) || (type == PLAYER_FIELD) ){
			Snd_ArcPlayerStartSeqEx( SND_HANDLE_BGM, PLAYER_BGM, wk->bgm );	//I
		}

		break;

	case SND_TEST_TYPE_SE:
		//SĂSE~
		Snd_SeStop( SND_HANDLE_SE_1, 0 );
		//Snd_SeStop( SND_HANDLE_SE_2, 0 );
		//Snd_SeStop( SND_HANDLE_SE_3, 0 );
		//Snd_SeStop( SND_HANDLE_SE_4, 0 );
		//Snd_SePlay( wk->se );	//Đ
		Snd_ArcPlayerStartSeqEx( SND_HANDLE_SE_1, PLAYER_SE_1, wk->se );	//I
		break;

	case SND_TEST_TYPE_PV:
		Snd_PMVoicePlay( wk->pv );
		break;
	};

	return;
}


//==============================================================================================
//
//	ݒ֐
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	VRAMoNݒ
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void SetBank(void)
{
	//display.c
	
	GF_BGL_DISPVRAM vramSetTable = {	//VRAMݒ\
		//GX_VRAM_BG_256_AB,			//C2DGWBG
		GX_VRAM_BG_128_C,				//C2DGWBG
		GX_VRAM_BGEXTPLTT_NONE,			//C2DGWBGgpbg

		GX_VRAM_SUB_BG_32_H,			//Tu2DGWBG
		GX_VRAM_SUB_BGEXTPLTT_NONE,		//Tu2DGWBGgpbg

		//GX_VRAM_OBJ_64_E,				//C2DGWOBJ
		GX_VRAM_OBJ_16_F,				//C2DGWOBJ
		GX_VRAM_OBJEXTPLTT_NONE,		//C2DGWOBJgpbg

		//GX_VRAM_SUB_OBJ_NONE,			//Tu2DGWOBJ
		GX_VRAM_SUB_OBJ_16_I,			//Tu2DGWOBJ
		GX_VRAM_SUB_OBJEXTPLTT_NONE,	//Tu2DGWOBJgpbg

		GX_VRAM_TEX_01_AB,			//eNX`C[WXbg
		//GX_VRAM_TEX_0_A,				//eNX`C[WXbg
		GX_VRAM_TEXPLTT_0123_E			//eNX`pbgXbg
		//GX_VRAM_TEX_NONE,				//eNX`C[WXbg
		//GX_VRAM_TEXPLTT_NONE			//eNX`pbgXbg
		//GX_VRAM_TEXPLTT_0123_E		//eNX`pbgXbg
	};

	GF_Disp_SetBank( &vramSetTable );
	return;
}

//--------------------------------------------------------------
/**
 * @brief	BGݒ
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void BgSet( SND_TEST_WORK* wk )
{
	//bg_system.c
	
#if 1
	{
		GF_BGL_SYS_HEADER BGsys_data = {	//BGVXe\
			GX_DISPMODE_GRAPHICS,			//\[hw 
			GX_BGMODE_0,					//af[hw(CXN[)
			GX_BGMODE_0,					//af[hw(TuXN[)
			GX_BG0_AS_2D,					//afÔQcARc[hI
			//GX_BG0_AS_3D,					//afÔQcARc[hI
		};

		//CATũOtBbNXGW̕\[hݒ
		//CATủʂ̊eʂ̕\Rg[(display.c)
		//rbg}bvEBhEݒ\̏
		GF_BGL_InitBG( &BGsys_data );
	}
#endif

	{	//BMPEBhE
		GF_BGL_BGCNT_HEADER BmpWinBgCntData = {	//BGRg[ݒ\
			0, 0,								//\wx
			0x800,								//XN[obt@TCY( 0 = gpȂ )
			0,									//XN[obt@ItZbg

			//BGݒ
			GF_BGL_SCRSIZ_256x256,				//XN[TCY
			GX_BG_COLORMODE_16,					//J[[h
			GX_BG_SCRBASE_0xd000,				//XN[x[XubN
			GX_BG_CHARBASE_0x00000,				//LN^x[XubN
			GX_BG_EXTPLTT_01,					//afgpbgXbgI

			0,									//\vCIeB[
			0, 0,								//GAI[o[tOA_~[
			FALSE								//UCNݒ
		};

		GF_BGL_BGControlSet(wk->bgl, SND_TEST_BMPWIN_FRAME, 
							&BmpWinBgCntData, GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear( wk->bgl, SND_TEST_BMPWIN_FRAME );
	}

	return;
}

//--------------------------------------------------------------
/**
 * @brief	bZ[W\
 *
 * @param	win_index	rbg}bvINDEX
 * @param	num			l
 * @param	x			\ʒuX
 * @param	y			\ʒuY
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void SndTestNumMsgSet( GF_BGL_BMPWIN* win, int num, u8 x, u8 y )
{
	STRBUF* buf = STRBUF_Create( 6, HEAPID_BASE_DEBUG );

	STRBUF_SetNumber( buf, num, 4, NUMBER_DISPTYPE_SPACE, NUMBER_CODETYPE_DEFAULT );
	GF_STR_PrintSimple( win, FONT_SYSTEM, buf, x, y, MSG_NO_PUT, NULL );
	STRBUF_Delete(buf);

	return;
}

//--------------------------------------------------------------
/**
 * @brief	TEhl[bZ[W\
 *
 * @param	win_index	rbg}bvINDEX
 * @param	num			l
 * @param	x			\ʒuX
 * @param	y			\ʒuY
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void SndTestNameMsgSet( GF_BGL_BMPWIN* win, const STRBUF* msg, u8 x, u8 y )
{
	GF_STR_PrintSimple( win, FONT_SYSTEM, msg, x, y, MSG_NO_PUT, NULL );
	return;
}

//------------------------------------------------------------------
/**
 * Œ蕶o
 *
 * @param   win			BitmapWindow
 * @param   fontID		tHg
 * @param   strID		hc
 * @param   x			`wW
 * @param   y			`xW
 * @param   wait		EFCg
 * @param   callback	R[obN
 *
 */
//------------------------------------------------------------------
static void SndTestStrPrint( GF_BGL_BMPWIN* win, u32 fontID, u32 strID, u32 x, u32 y, u32 wait, pStrPrintCallBack callback )
{
	MSGDATA_MANAGER* man = MSGMAN_Create( MSGMAN_TYPE_DIRECT, ARC_MSG, 
									NARC_msg_snd_test_str_dat, HEAPID_BASE_DEBUG );

	STRBUF* str = MSGMAN_AllocString( man, strID );

	GF_STR_PrintSimple( win, fontID, str, x, y, wait, callback );

	STRBUF_Delete(str);
	MSGMAN_Delete(man);
}

//--------------------------------------------------------------
/**
 * @brief	BGMbZ[Wĕ\
 *
 * @param	wk		SND_TEST_WORKւ̃|C^
 * @param	select	IΏ
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void MsgRewrite( SND_TEST_WORK* wk, s8 select )
{
	int type;
	u32 msg_h_id;

	switch( select ){
	case SND_TEST_TYPE_BGM:
		//wk->bgm,se,pvɂ́AV[PXio[Ă̂ŁA
		//X^[gio[AIĂlɂāA
		//bZ[WID̃X^[gio[𑫂bZ[W\
		msg_h_id = wk->bgm - SND_TEST_BGM_START_NO + msg_seq_pv_end + 1;

		//w͈͂hԂ
		GF_BGL_BmpWinFill( &wk->bmpwin, 
							FBMP_COL_WHITE, ST_TYPE_X, ST_BGM_MSG_Y+16, 8*24, 16*1 );

		SndTestStrPrint( &wk->bmpwin, FONT_SYSTEM, msg_BGM, 
						ST_TYPE_X, ST_BGM_MSG_Y, MSG_NO_PUT, NULL );
		SndTestNumMsgSet( &wk->bmpwin, wk->bgm, ST_TYPE_X, ST_BGM_MSG_Y+16 );

		MSGMAN_GetString( wk->msgman, msg_h_id, wk->msg_buf[BUF_BGM] );
		SndTestNameMsgSet( &wk->bmpwin, wk->msg_buf[BUF_BGM], ST_NAME_X, ST_BGM_MSG_Y+16 );

		SndTestStrPrint( &wk->bmpwin, FONT_SYSTEM, msg_ME, 
						ST_TYPE_X+32, ST_BGM_MSG_Y, MSG_NO_PUT, NULL );

		SndTestStrPrint( &wk->bmpwin, FONT_SYSTEM, msg_KEY, 
						ST_TYPE_X+56, ST_BGM_MSG_Y, MSG_NO_PUT, NULL );

		SndTestStrPrint( &wk->bmpwin, FONT_SYSTEM, msg_TMP, 
						ST_TYPE_X+136, ST_BGM_MSG_Y, MSG_NO_PUT, NULL );

		break;

	case SND_TEST_TYPE_SE:
		msg_h_id = wk->se - SND_TEST_SE_START_NO + msg_seq_bgm_end + 1;

		//w͈͂hԂ
		GF_BGL_BmpWinFill( &wk->bmpwin, 
							FBMP_COL_WHITE, ST_TYPE_X, ST_SE_MSG_Y+16, 8*24, 16*1 );

		//V[PXio[ASẼvC[io[擾
		type = Snd_GetPlayerNo(wk->se);
		type -= PLAYER_SE_1;

		//SÊ݃vC[io[\
		SndTestStrPrint( &wk->bmpwin, FONT_SYSTEM, msg_PLAYER, 
						ST_TYPE_X+32, ST_SE_MSG_Y, MSG_NO_PUT, NULL );
		SndTestNumMsgSet( &wk->bmpwin, type, ST_TYPE_X+32+56, ST_SE_MSG_Y );

		SndTestStrPrint( &wk->bmpwin, FONT_SYSTEM, msg_SE, 
						ST_TYPE_X, ST_SE_MSG_Y, MSG_NO_PUT, NULL );

		SndTestNumMsgSet( &wk->bmpwin, wk->se, ST_TYPE_X, ST_SE_MSG_Y+16 );

		MSGMAN_GetString( wk->msgman, msg_h_id, wk->msg_buf[BUF_SE] );
		SndTestNameMsgSet( &wk->bmpwin, wk->msg_buf[BUF_SE], ST_NAME_X, ST_SE_MSG_Y+16 );
		break;

	case SND_TEST_TYPE_PV:
		msg_h_id = wk->pv - SND_TEST_PV_START_NO + msg_seq_pv001;

		//w͈͂hԂ
		GF_BGL_BmpWinFill( &wk->bmpwin, 
							FBMP_COL_WHITE, ST_TYPE_X, ST_PV_MSG_Y+16, 8*24, 16*1 );

		SndTestStrPrint( &wk->bmpwin, FONT_SYSTEM, msg_PV, 
						ST_TYPE_X, ST_PV_MSG_Y, MSG_NO_PUT, NULL );
		SndTestNumMsgSet( &wk->bmpwin, wk->pv, ST_TYPE_X, ST_PV_MSG_Y+16 );

		MSGMAN_GetString( wk->msgman, msg_h_id, wk->msg_buf[BUF_PV] );
		SndTestNameMsgSet( &wk->bmpwin, wk->msg_buf[BUF_PV], ST_NAME_X, ST_PV_MSG_Y+16 );
		break;
	};

	return;
}

//--------------------------------------------------------------
/**
 * @brief	Ԃɂ(X_BUTTON̏I)
 *
 * @param	wk		SND_TEST_WORKւ̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void SndTestInit( SND_TEST_WORK* wk )
{
	//[N
	SndTestWorkInit( wk );

	//
	MsgRewrite( wk, SND_TEST_TYPE_BGM );		//BGMio[
	MsgRewrite( wk, SND_TEST_TYPE_SE );			//SEio[
	MsgRewrite( wk, SND_TEST_TYPE_PV );			//PVio[

	SndTestCursor( wk );						//J[\XV

	return;
}

//--------------------------------------------------------------
/**
 * @brief	J[\
 *
 * @param	wk		SND_TEST_WORKւ̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void SndTestCursor( SND_TEST_WORK* wk )
{
	u16 y;

	switch( wk->select ){
	case SND_TEST_TYPE_BGM:
		y = ST_BGM_MSG_Y;
		break;
	case SND_TEST_TYPE_SE:
		y = ST_SE_MSG_Y;
		break;
	case SND_TEST_TYPE_PV:
		y = ST_PV_MSG_Y;
		break;
	};

	//w͈͂hԂ
	GF_BGL_BmpWinFill( &wk->bmpwin, 
						FBMP_COL_WHITE, ST_CURSOR_X, ST_BGM_MSG_Y, 8*1, 16*8 );
	GF_BGL_BmpWinFill( &wk->bmpwin, 
						FBMP_COL_RED, ST_CURSOR_X, y, 8*1, 16*1 );

	return;
}

//--------------------------------------------------------------
/**
 * @brief	VXebZ[W
 *
 * @param	wk		SND_TEST_WORKւ̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void SndTestSysMsgSet( SND_TEST_WORK* wk )
{
	SndTestStrPrint( &wk->bmpwin, FONT_SYSTEM, msg_SOUND_TEST, 
				ST_TITLE_X, ST_TITLE_Y, MSG_NO_PUT, NULL );			//SOUND TEST
	SndTestStrPrint( &wk->bmpwin, FONT_SYSTEM, msg_A_PLAY, 
				ST_KEY_X, ST_KEY_Y, MSG_NO_PUT, NULL );				//A PLAY
	SndTestStrPrint( &wk->bmpwin, FONT_SYSTEM, msg_B_STOP, 
				ST_KEY_X+64, ST_KEY_Y, MSG_NO_PUT, NULL );			//B STOP
	SndTestStrPrint( &wk->bmpwin, FONT_SYSTEM, msg_X_END, 
				ST_KEY_X, ST_KEY_Y+16, MSG_NO_PUT, NULL );			//X END
	SndTestStrPrint( &wk->bmpwin, FONT_SYSTEM, msg_Y_INIT, 
				ST_KEY_X+64, ST_KEY_Y+16, MSG_NO_PUT, NULL );		//Y INIT

	return;
}



//==============================================================================================
//==============================================================================================
//--------------------------------------------------------------
//--------------------------------------------------------------
static PROC_RESULT SoundTestProc_Init(PROC * proc, int * seq)
{
	SND_TEST_WORK* wk = NULL;

	wk = PROC_AllocWork(proc, sizeof(SND_TEST_WORK), HEAPID_BASE_DEBUG);
	SndTestCall(wk);
	return PROC_RES_FINISH;
		
}
//--------------------------------------------------------------
//--------------------------------------------------------------
static PROC_RESULT SoundTestProc_Main(PROC * proc, int * seq)
{
	SND_TEST_WORK *swk;
	swk = PROC_GetWork(proc);

	SndTestTable[swk->seq](swk);

	if (swk->end_flag) {
		return PROC_RES_FINISH;
	} else {
		return PROC_RES_CONTINUE;
	}
}
//--------------------------------------------------------------
//--------------------------------------------------------------
static PROC_RESULT SoundTestProc_End(PROC * proc, int * seq)
{
	PROC_FreeWork(proc);
	//Main_SetNextProc(NO_OVERLAY_ID, &TitleProcData);

	//\tgZbg
	//ڍׂ̓\[X擪́uTEheXg̗OɂāvQƂĉ
	//OS_InitReset();
	OS_ResetSystem(0);									//\tgZbg
	return PROC_RES_FINISH;
}
//--------------------------------------------------------------
//--------------------------------------------------------------
const PROC_DATA SoundTestProcData = {
	SoundTestProc_Init,
	SoundTestProc_Main,
	SoundTestProc_End,
	NO_OVERLAY_ID
};

