/*---------------------------------------------------------------------------*
  Project:  PokemonDS
  File:     main.c

  C

  $NoKeywords: $
 *---------------------------------------------------------------------------*/
#include "common.h"

#define __STRESS_METER_H_GLOBAL__
#include "debug/stress_meter.h"

#ifdef STRESS_METER_APPEAR
void StressMeterInit(void);
void GetMainLoopStress(void);
void GetVblankStress(void);
void SetStressMeter(void);
void StressMeterRelease(void);

static int MainLoopStressParam = 0;
static int VBlankStressParam = 0;
static int meter_trans_timer = 0;

//---------------------------------------------------------------------------
//
// C֐
//
//---------------------------------------------------------------------------
static const u8 meter_cell_dat[]={
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x77,0x77,0x33,0x33,
	0x77,0x77,0x33,0x33,
	0x77,0x77,0x33,0x33,
	0x77,0x77,0x33,0x33,
	0x77,0x77,0x33,0x33,
	0x77,0x77,0x33,0x33,
	0x77,0x77,0x33,0x33,
	0x77,0x77,0x33,0x33,

};

//==============================================================================
/**
 * ׃[^[\
 *
 * @param   none		
 *
 * @retval  none		
 */
//==============================================================================
void StressMeterInit(void)
{
	int i;
	u16 *screen_buf;
	GF_BGL_BGCNT_HEADER TextBgCntDat = {		//BG2ʐݒp`
		0, 0,
		0x800,
		0,
		GF_BGL_SCRSIZ_256x256,
		GX_BG_COLORMODE_16,
		GX_BG_SCRBASE_0xc800,
		GX_BG_CHARBASE_0x0c000,
		GX_BG_EXTPLTT_01,
		2,
		0,
		0,
		FALSE
	};
	GF_BGL_BGControlSet( GF_BGL_FRAME2_M, &TextBgCntDat, GF_BGL_MODE_TEXT );	// BG2ʐݒ
	
}

//==============================================================================
/**
 * ׃[^[
 *
 * @param   none		
 *
 * @retval  none		
 */
//==============================================================================
void SetStressMeter(void)
{
	int i;
	u16 *screen_buf;
	GX_SetVisibleWnd(GX_WNDMASK_W0|GX_WNDMASK_W1); 
	G2_SetWnd0InsidePlane(GX_WND_PLANEMASK_BG2, 0 );
	G2_SetWnd1InsidePlane(GX_WND_PLANEMASK_BG2, 0 );
	G2_SetWndOutsidePlane(	GX_WND_PLANEMASK_BG0|
							GX_WND_PLANEMASK_BG1|
							GX_WND_PLANEMASK_BG2|
							GX_WND_PLANEMASK_BG3|
							GX_WND_PLANEMASK_OBJ, 1 );
	G2_SetWnd0Position( 1 , 0, 3, MainLoopStressParam);
	G2_SetWnd1Position( 5 , 0, 7, (VBlankStressParam-192)*3);

	if(meter_trans_timer<60){		// 蔲ʏ

		// VRAMNÂȂ̂
		screen_buf = sys_AllocMemory( HEAPID_BASE_DEBUG, 32*24*2 );			
		// vOJn60SYncxs
		GF_BGL_LoadCharacter( GF_BGL_FRAME2_M, meter_cell_dat, 32*2*2, 0 );

		for(i=0;i<32*24;i++){
			screen_buf[i] = 0xf000;
		}
		for(i=0;i<24;i++){
			screen_buf[i*32] = 0xf001;
		}
		// LEXN[Epbg]s
		GF_BGL_LoadScreen( GF_BGL_FRAME2_M, screen_buf, 32*24*2, 0 );
		sys_FreeMemory( HEAPID_BASE_DEBUG, screen_buf);
		meter_trans_timer++;
	}
	//BG0\ɂ+BG2ʂONɂ
	GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG2, VISIBLE_ON );
}

void StressMeterTransStart(void)
{
	meter_trans_timer = 0;
}

//==============================================================================
/**
 * ׃[^[VBlank҂˓Vcount擾
 *
 * @param   none		
 *
 * @retval  none		
 */
//==============================================================================
void GetMainLoopStress(void)
{
//	int vcount = GX_GetVCount();
//	G2_SetWnd0Position( 2 , 0, 4, vcount);
	MainLoopStressParam = GX_GetVCount();
}

//==============================================================================
/**
 * VBlankԏIVcount擾
 *
 * @param   none		
 *
 * @retval  none		
 */
//==============================================================================
void GetVblankStress(void)
{
	VBlankStressParam = GX_GetVCount();

	//DS̓C[v̗3DGW`ŝŁA
	//VBlankIo񂶂Ȃ̂HƎvĉ̏gݍ񂾂A
	//܂삪sȂ̂ŊOB
	/*
	while(1){
		if(GX_GetVCount()==262){
			break;
		}
	}
	*/
}
#endif		//STRESS_METER_APPEAR
