//==============================================================================================
/**
 * @file	opneing.c
 * @brief	I[vjO
 * @author	Satoshi Nohara
 * @date	2005.12.08
 */
//==============================================================================================
#include "system/main.h"
#include "system/arc_tool.h"
#include "system/arc_util.h"
#include "system/clact_tool.h"
#include "system/brightness.h"
#include "system/fontproc.h"
#include "system/snd_tool.h"
#include "system/savedata.h"
#include "system/pmfprint.h"

#include "field/field.h"
#include "msgdata\msg.naix"							//NARC_msg_??_dat
#include "msgdata\msg_opening.h"					//msg_??

#include "opening.naix"
#include "opening_sys.h"
#include "opening_obj.h"
#include "opening_bmp.h"

#include "application/namein.h"						//NameInProcData

#include "gflib/strbuf_family.h"

#include "field/union_beacon_tool.h"				//UnionView_GetTrainerType


//==============================================================================================
//
//	fobN
//
//==============================================================================================


//==============================================================================================
//
//	extern錾
//
//==============================================================================================
extern u8 MsgSpeedGet(void);


//==============================================================================================
//
//	`
//
//==============================================================================================
//V[PX`
enum {
	SEQ_WELCOME_PM_WORLD,				//I[Lhmu悤Iv
	SEQ_KEY_GUIDE,						//
	SEQ_GAME_GUIDE,						//Q[
	SEQ_SEX_CHOICE,						//ʑI
	SEQ_NAME_INPUT,						//O
	SEQ_ID_CHOICE,						//IDI
	SEQ_TO_ADVENTURE,					//`
	SEQ_EXIT,
};

#define OPENING_FADE_SYNC		(8)		//tF[hsync

#define OPENING_MSG_BUF_SIZE	(800)//(1024)	//bZ[WTCY
#define OPENING_MENU_BUF_SIZE	(64)	//j[TCY

//bZ[W\ʒu
enum{
	OP_OOKIDO_X		= 0, 
	OP_OOKIDO_Y		= 0,
	OP_KEY_GUIDE_X	= 60, 
	OP_KEY_GUIDE_Y	= 8,
	OP_GAME_GUIDE_X = 8, 
	OP_GAME_GUIDE_Y = 48,
};

//I[LhOBJXN[
#define OP_OOKIDO_SCR_SPD		(2)		//XN[Xs[h
#define OP_OOKIDO_SCR_END		(140 * FX32_ONE)
//#define OP_OOKIDO_SCR_END_2		(90 * FX32_ONE)
#define OP_OOKIDO_SCR_END_2		(86 * FX32_ONE)	//opening_obj.c̃f[^ƍ킹

//lBGXN[
#define OP_HERO_SCR_START		(-140)//(-120)	//XN[I
#define OP_HERO_SCR_SPD			(4)		//XN[CXs[h
#define OP_HERO_SCR_SPD2		(2)		//XN[SXs[h
#define OP_HERO_SCR_END			(-70)	//XN[I

#define AFF_SCALE_END			(0x700)	//(0x200)	//kl


//==============================================================================================
//
//	vg^Cv錾
//
//==============================================================================================

static void SetVramBank(void);
static void SetBgHeader( GF_BGL_INI * ini );
static void SetBgGraphic_Sub2( OPENING_WORK * wk, u32 frm  );
static void SetBgGraphic_Sub4( OPENING_WORK * wk, u32 frm  );
static void SetBgGraphic_Sub5( OPENING_WORK * wk, u32 frm  );
static void SetBgGraphic_Sub6( OPENING_WORK * wk, u32 frm, int no );
static void SetBgGraphic_Sub7( OPENING_WORK * wk, u32 frm );
static void SetBgGraphic_Sub8( OPENING_WORK * wk, u32 frm );
static void SetBgGraphic_Sub9( OPENING_WORK * wk, u32 frm );
static void BgExit( GF_BGL_INI * ini );

static void SetPalette_Sub2(void);
static void SetPalette_Sub4(void);
static void SetPalette_Sub5(void);
static void SetPalette_Sub6(void);
static void SetPalette_Sub7(void);

static void VBlankFunc( void * work );
static int KeyCheck( int trg );
static void NextSeq( OPENING_WORK* wk, int* seq, int next );

static void OpeningAff( OPENING_WORK *wk );
static void OpeningAffReset(void);

//V[PX
static BOOL Seq_WelcomePMWorld( OPENING_WORK* wk );
static BOOL Seq_KeyGuide( OPENING_WORK* wk );
static BOOL Seq_GameGuide( OPENING_WORK* wk );
static BOOL Seq_SexChoice( OPENING_WORK* wk );
static BOOL Seq_NameIn( OPENING_WORK* wk );
static BOOL Seq_IdChoice( OPENING_WORK* wk );
static BOOL Seq_ToAdventure( OPENING_WORK* wk );

//O
static void OpeningNameInCall( OPENING_WORK* wk );
static void OpeningNameInMainTCB( TCB_PTR tcb, void* work );
static void OpeningRecover( OPENING_WORK* wk );

//ʏAI
static void opening_init_sub();
static void opening_init_sub2( OPENING_WORK* wk );
static void opening_end_sub( OPENING_WORK* wk );

static void opening_talk_win_put( OPENING_WORK* wk );



//==============================================================================================
//
//	֐
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	vZX֐F
 *
 * @param	proc	vZXf[^
 * @param	seq		V[PX
 *
 * @return	""
 */
//--------------------------------------------------------------
PROC_RESULT OpeningProc_Init( PROC * proc, int * seq )
{
	int i;
	OPENING_WORK * wk;

	//PLAYER_BGMŃ^CgAI[vjO炷悤ɂ
	Snd_DataSetByScene( SND_SCENE_OPENING, SEQ_OPENING, 1 );	//I[vjOȍĐ

	opening_init_sub();

	sys_CreateHeap( HEAPID_BASE_APP, HEAPID_OPENING, 0x20000 );

	wk = PROC_AllocWork( proc, sizeof(OPENING_WORK), HEAPID_OPENING );
	memset( wk, 0, sizeof(OPENING_WORK) );
	wk->bgl = GF_BGL_BglIniAlloc( HEAPID_OPENING );

	opening_init_sub2(wk);

	//jlBG͏Ă
	GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG3, VISIBLE_OFF );

	(*seq) = SEQ_WELCOME_PM_WORLD;

	wk->proc = proc;

	return PROC_RES_FINISH;
}

//--------------------------------------------------------------
/**
 * @brief	vZX֐FC
 *
 * @param	proc	vZXf[^
 * @param	seq		V[PX
 *
 * @return	""
 */
//--------------------------------------------------------------
PROC_RESULT OpeningProc_Main( PROC * proc, int * seq )
{
	OPENING_WORK * wk  = PROC_GetWork( proc );

	//O͊Ď
	if( wk->tcb != NULL ){
		return PROC_RES_CONTINUE;
	}

	switch( *seq ){

	//I[Lhmu悤Iv
	case SEQ_WELCOME_PM_WORLD:
		if( Seq_WelcomePMWorld(wk) == TRUE ){
			NextSeq( wk, seq, wk->ret_work );
			wk->ret_work = 0;	//NA
		}
		break;

	//
	case SEQ_KEY_GUIDE:
		if( Seq_KeyGuide(wk) == TRUE ){
			NextSeq( wk, seq, SEQ_WELCOME_PM_WORLD );
		}
		break;

	//Q[
	case SEQ_GAME_GUIDE:				
		if( Seq_GameGuide(wk) == TRUE ){
			NextSeq( wk, seq, SEQ_WELCOME_PM_WORLD );
		}
		break;

	//ʑI
	case SEQ_SEX_CHOICE:		
		if( Seq_SexChoice(wk) == TRUE ){
			NextSeq( wk, seq, SEQ_NAME_INPUT );
		}
		break;

	//O
	case SEQ_NAME_INPUT:			
		if( Seq_NameIn(wk) == TRUE ){
			NextSeq( wk, seq, wk->ret_work );
			wk->ret_work = 0;	//NA
		}
		break;

	//IDI
	case SEQ_ID_CHOICE:			
		if( Seq_IdChoice(wk) == TRUE ){
			NextSeq( wk, seq, SEQ_TO_ADVENTURE );
		}
		break;

	//`
	case SEQ_TO_ADVENTURE:		
		if( Seq_ToAdventure(wk) == TRUE ){
			NextSeq( wk, seq, SEQ_EXIT );
		}
		break;

	case SEQ_EXIT:
		if( IsFinishedBrightnessChg( MASK_DOUBLE_DISPLAY ) == TRUE ){
			return PROC_RES_FINISH;
		}
		break;
	}

	CLACT_Draw( wk->ObjWork.ClactSet );			//ZAN^[풓֐

	return PROC_RES_CONTINUE;
}

//--------------------------------------------------------------
/**
 * @brief	vZX֐FI
 *
 * @param	proc	vZXf[^
 * @param	seq		V[PX
 *
 * @return	""
 */
//--------------------------------------------------------------
PROC_RESULT OpeningProc_End( PROC * proc, int * seq )
{
	int i;
	OPENING_WORK * wk = PROC_GetWork( proc );

	opening_end_sub( wk );

	PROC_FreeWork( proc );					//[NJ

	sys_VBlankFuncChange( NULL, NULL );		//VBlankZbg
	sys_DeleteHeap( HEAPID_OPENING );

	Main_SetNextProc(NO_OVERLAY_ID, &GameMainProcData);
	return PROC_RES_FINISH;
}

//--------------------------------------------------------------
/**
 * @brief	VRAMݒ
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------
static void SetVramBank(void)
{
	GF_BGL_DISPVRAM tbl = {
		//GX_VRAM_BG_64_E,				//C2DGWBG
		GX_VRAM_BG_128_A,				//C2DGWBG
		GX_VRAM_BGEXTPLTT_NONE,			//C2DGWBGgpbg

		GX_VRAM_SUB_BG_128_C,			//Tu2DGWBG
		GX_VRAM_SUB_BGEXTPLTT_NONE,		//Tu2DGWBGgpbg

		GX_VRAM_OBJ_128_B,				//C2DGWOBJ
		GX_VRAM_OBJEXTPLTT_NONE,		//C2DGWOBJgpbg

		GX_VRAM_SUB_OBJ_16_I,			//Tu2DGWOBJ
		GX_VRAM_SUB_OBJEXTPLTT_NONE,	//Tu2DGWOBJgpbg

		GX_VRAM_TEX_NONE,				//eNX`C[WXbg
		GX_VRAM_TEXPLTT_NONE			//eNX`pbgXbg
	};
	GF_Disp_SetBank( &tbl );
}

//--------------------------------------------------------------
/**
 * @brief	BGݒ
 *
 * @param	init	BGLf[^
 *
 * @return	none
 */
//--------------------------------------------------------------
static void SetBgHeader( GF_BGL_INI * ini )
{
	{	//BG SYSTEM
		GF_BGL_SYS_HEADER BGsys_data = {
			GX_DISPMODE_GRAPHICS, GX_BGMODE_1, GX_BGMODE_1, GX_BG0_AS_2D,
		};
		GF_BGL_InitBG( &BGsys_data );
	}

	{	//I[Lh
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xf800, GX_BG_CHARBASE_0x10000, GX_BG_EXTPLTT_01,
			1, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME0_M, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear( ini, GF_BGL_FRAME0_M );
	}

	{	//BG(tHg)
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xf000, GX_BG_CHARBASE_0x04000, GX_BG_EXTPLTT_01,
			0, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, OP_FRM_FONT, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear( ini, OP_FRM_FONT );
	}

	{	//ʔwi
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xe000, GX_BG_CHARBASE_0x0c000, GX_BG_EXTPLTT_01,
			3, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME2_M, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear( ini, GF_BGL_FRAME2_M );
	}

	{	//jl(256FAgk)
		GF_BGL_BGCNT_HEADER AffineBgCntDat = {
			0, 0, 0x400, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_256,
			GX_BG_SCRBASE_0xe800, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_01,
			2, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME3_M, &AffineBgCntDat, GF_BGL_MODE_AFFINE );
		GF_BGL_ScrClear( ini, GF_BGL_FRAME3_M );
	}

	{	//ʔwi
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xe000, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_01,
			3, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME2_S, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear( ini, GF_BGL_FRAME2_S );
	}
}

//--------------------------------------------------------------
/**
 * @brief	OtBbNf[^ZbgFjl
 *
 * @param	wk		OPENING_WORK^̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------
static void SetBgGraphic_Sub2( OPENING_WORK * wk, u32 frm  )
{
	u8 sex;

	//256FAgk
	SetPalette_Sub2();

	ArcUtil_BgCharSet( ARC_OPENING_GRA, NARC_opening_op_character_NCGR, 
						wk->bgl, GF_BGL_FRAME3_M, 0, 0, 0, HEAPID_OPENING );

	sex=(wk->sex == PM_MALE) ? NARC_opening_op_character01_NSCR : NARC_opening_op_character02_NSCR;
	ArcUtil_ScrnSet( ARC_OPENING_GRA, sex, wk->bgl, GF_BGL_FRAME3_M, 0, 0, 0, HEAPID_OPENING );

	return;
}

//--------------------------------------------------------------
/**
 * @brief	OtBbNf[^ZbgFʔwi
 *
 * @param	wk		OPENING_WORK^̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------
static void SetBgGraphic_Sub4( OPENING_WORK * wk, u32 frm  )
{
	SetPalette_Sub4();

	ArcUtil_BgCharSet( ARC_OPENING_GRA, NARC_opening_op_demo_NCGR, 
						wk->bgl, frm, 0, 0, 0, HEAPID_OPENING );

	ArcUtil_ScrnSet( ARC_OPENING_GRA, NARC_opening_op_demo01_NSCR, 
						wk->bgl, frm, 0, 0, 0, HEAPID_OPENING );
	return;
}

//--------------------------------------------------------------
/**
 * @brief	OtBbNf[^ZbgFʔwi
 *
 * @param	wk		OPENING_WORK^̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------
static void SetBgGraphic_Sub5( OPENING_WORK * wk, u32 frm  )
{
	SetPalette_Sub5();

	ArcUtil_BgCharSet( ARC_OPENING_GRA, NARC_opening_op_demo_NCGR, 
						wk->bgl, frm, 0, 0, 0, HEAPID_OPENING );
	ArcUtil_ScrnSet( ARC_OPENING_GRA, NARC_opening_op_demo02_NSCR, 
						wk->bgl, frm, 0, 0, 0, HEAPID_OPENING );
	return;
}

//--------------------------------------------------------------
/**
 * @brief	OtBbNf[^ZbgFʑ
 *
 * @param	wk		OPENING_WORK^̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------
static void SetBgGraphic_Sub6( OPENING_WORK * wk, u32 frm, int no )
{
	int scrn;

	ArcUtil_BgCharSet( ARC_OPENING_GRA, NARC_opening_op_tutorial_NCGR, 
						wk->bgl, frm, 0, 0, 0, HEAPID_OPENING );

	switch( no ){
	case 0:
	case 3:
		scrn = NARC_opening_op_tutorial0_NSCR;
		break;
	case 1:
		scrn = NARC_opening_op_tutorial1_NSCR;
		break;
	case 2:
		scrn = NARC_opening_op_tutorial2_NSCR;
		break;
	};

	ArcUtil_ScrnSet( ARC_OPENING_GRA, scrn,	wk->bgl, frm, 0, 0, 0, HEAPID_OPENING );

	return;
}

//--------------------------------------------------------------
/**
 * @brief	OtBbNf[^ZbgFʑ
 *
 * @param	wk		OPENING_WORK^̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------
static void SetBgGraphic_Sub7( OPENING_WORK * wk, u32 frm )
{
	ArcUtil_BgCharSet( ARC_OPENING_GRA, NARC_opening_op_tutorial_NCGR, 
						wk->bgl, frm, 0, 0, 0, HEAPID_OPENING );

	ArcUtil_ScrnSet( ARC_OPENING_GRA, NARC_opening_op_tutorial3_NSCR, 
						wk->bgl, frm, 0, 0, 0, HEAPID_OPENING );

	return;
}

//--------------------------------------------------------------
/**
 * @brief	OtBbNf[^ZbgFʃQ[
 *
 * @param	wk		OPENING_WORK^̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------
static void SetBgGraphic_Sub8( OPENING_WORK * wk, u32 frm )
{
	ArcUtil_BgCharSet( ARC_OPENING_GRA, NARC_opening_op_tutorial_NCGR, 
						wk->bgl, frm, 0, 0, 0, HEAPID_OPENING );

	ArcUtil_ScrnSet( ARC_OPENING_GRA, NARC_opening_op_tutorial4_NSCR, 
						wk->bgl, frm, 0, 0, 0, HEAPID_OPENING );

	return;
}

//--------------------------------------------------------------
/**
 * @brief	OtBbNf[^ZbgFʃQ[
 *
 * @param	wk		OPENING_WORK^̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------
static void SetBgGraphic_Sub9( OPENING_WORK * wk, u32 frm )
{
	ArcUtil_BgCharSet( ARC_OPENING_GRA, NARC_opening_op_tutorial_NCGR, 
						wk->bgl, frm, 0, 0, 0, HEAPID_OPENING );

	ArcUtil_ScrnSet( ARC_OPENING_GRA, NARC_opening_op_tutorial5_NSCR, 
						wk->bgl, frm, 0, 0, 0, HEAPID_OPENING );

	return;
}

//--------------------------------------------------------------
/**
 * @brief	BG
 *
 * @param	ini		BGLf[^
 *
 * @return	none
 */
//--------------------------------------------------------------
static void BgExit( GF_BGL_INI * ini )
{
	//Cʂ̊eʂ̕\Rg[(\OFF)
	GF_Disp_GX_VisibleControl(	GX_PLANEMASK_BG0 | 
								GX_PLANEMASK_BG1 | 
								GX_PLANEMASK_BG2 |
								GX_PLANEMASK_BG3 | 
								GX_PLANEMASK_OBJ, 
								VISIBLE_OFF );

	//Tuʂ̊eʂ̕\Rg[(\OFF)
	GF_Disp_GXS_VisibleControl(	GX_PLANEMASK_BG0 | 
								GX_PLANEMASK_BG1 | 
								GX_PLANEMASK_OBJ, 
								VISIBLE_OFF );

	//GF_BGL_BGControlSetŎ擾J
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME0_M );
	GF_BGL_BGControlExit( ini, OP_FRM_FONT );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME3_M );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME2_M );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME2_S );

	sys_FreeMemoryEz( ini );
}

//--------------------------------------------------------------
/**
 * @brief	jlpbgݒ
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------
static void SetPalette_Sub2(void)
{
	void *buf;
	NNSG2dPaletteData *dat;

	if( PM_VERSION == VERSION_DIAMOND ){
		buf = ArcUtil_PalDataGet(ARC_OPENING_GRA, NARC_opening_op_demo_d_NCLR, &dat,HEAPID_OPENING);
	}else{
		buf = ArcUtil_PalDataGet(ARC_OPENING_GRA, NARC_opening_op_demo_p_NCLR, &dat,HEAPID_OPENING);
	}

	{
		u16 * adr;
		adr = dat->pRawData;

		DC_FlushRange( dat->pRawData, (16*2)*4 );
		//]pbgAhXAZbgpbgRAMItZbgA]TCY
		GX_LoadBGPltt( dat->pRawData, 0, (16*2)*4 );			//C
		sys_FreeMemoryEz(buf);
	}

	return;
}

//--------------------------------------------------------------
/**
 * @brief	ʔwipbgݒ
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------
static void SetPalette_Sub4(void)
{
	void *buf;
	NNSG2dPaletteData *dat;

	//o[WŃpbgύX
	if( PM_VERSION == VERSION_DIAMOND ){
		buf = ArcUtil_PalDataGet(ARC_OPENING_GRA, NARC_opening_op_demo_d_NCLR, &dat,HEAPID_OPENING);
	}else{
		buf = ArcUtil_PalDataGet(ARC_OPENING_GRA, NARC_opening_op_demo_p_NCLR, &dat,HEAPID_OPENING);
	}
		
	DC_FlushRange( dat->pRawData, (16*2) );
	GX_LoadBGPltt( dat->pRawData, 0, (16*2) );		//C
	sys_FreeMemoryEz(buf);

	return;
}

//--------------------------------------------------------------
/**
 * @brief	ʔwipbgݒ
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------
static void SetPalette_Sub5(void)
{
	void *buf;
	NNSG2dPaletteData *dat;

	if( PM_VERSION == VERSION_DIAMOND ){
		buf = ArcUtil_PalDataGet(ARC_OPENING_GRA, NARC_opening_op_demo_d_NCLR, &dat,HEAPID_OPENING);
	}else{
		buf = ArcUtil_PalDataGet(ARC_OPENING_GRA, NARC_opening_op_demo_p_NCLR, &dat,HEAPID_OPENING);
	}
		
	DC_FlushRange( dat->pRawData, (16*2) );
	GXS_LoadBGPltt( dat->pRawData, 0, (16*2) );		//Tu
	sys_FreeMemoryEz(buf);

	return;
}

//--------------------------------------------------------------
/**
 * @brief	ʑpbgݒ
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------
static void SetPalette_Sub6(void)
{
	void *buf;
	NNSG2dPaletteData *dat;

	buf = ArcUtil_PalDataGet(ARC_OPENING_GRA, NARC_opening_op_tutorial_NCLR, &dat,HEAPID_OPENING);
		
	DC_FlushRange( dat->pRawData, (16*2) );
	GX_LoadBGPltt( dat->pRawData, 0, (16*2*2) );		//C
	sys_FreeMemoryEz(buf);

	return;
}

//--------------------------------------------------------------
/**
 * @brief	ʑpbgݒ
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------
static void SetPalette_Sub7(void)
{
	void *buf;
	NNSG2dPaletteData *dat;

	buf = ArcUtil_PalDataGet(ARC_OPENING_GRA, NARC_opening_op_tutorial_NCLR, &dat,HEAPID_OPENING);
		
	DC_FlushRange( dat->pRawData, (16*2) );
	GXS_LoadBGPltt( dat->pRawData, 0, (16*2*2) );		//Tu
	sys_FreeMemoryEz(buf);

	return;
}

//--------------------------------------------------------------
/**
 * @brief	VBlank֐
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------
static void VBlankFunc( void * work )
{
	OPENING_WORK* wk = work;

	//pbg]
	if( wk->pfd != NULL ){
		PaletteFadeTrans( wk->pfd );
	}

	//ZAN^[
	//Vram]}l[W[s
	DoVramTransferManager();

	//_LOAM}l[WVram]
	REND_OAMTrans();	
	
	OS_SetIrqCheckFlag( OS_IE_V_BLANK );
}

//--------------------------------------------------------------
/**
 * @brief	L[`FbN
 *
 * @param	L[
 *
 * @return	none
 */
//--------------------------------------------------------------
static int KeyCheck( int trg )
{
	return (sys.trg & trg);
}

//--------------------------------------------------------------
/**
 * @brief	V[PXύX
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------
static void NextSeq( OPENING_WORK* wk, int* seq, int next )
{
	wk->count	= 0;
	wk->sub_seq = 0;
	*seq		= next;
	return;
}

//--------------------------------------------------------------
/**
 * @brief	k
 *
 * @param	wk		OPENING_WORK^̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------
static void OpeningAff( OPENING_WORK *wk )
{
	MtxFx22 mtx;
    fx32 rScale_x,rScale_y;

	//̑傫
	//wk->ScaleX = 1 << FX32_SHIFT;
	//wk->ScaleY = 1 << FX32_SHIFT;
	
	//g
	//wk->ScaleX += 2 << (FX32_SHIFT - 6);
	//wk->ScaleY += 2 << (FX32_SHIFT - 6);
	
	//k
	wk->ScaleX -= 1 << (FX32_SHIFT - 6);
	wk->ScaleY -= 1 << (FX32_SHIFT - 6);
	//wk->ScaleX -= 2 << (FX32_SHIFT - 6);	//Ȃ
	//wk->ScaleY -= 2 << (FX32_SHIFT - 6);
	//wk->ScaleX -= 1 << (FX32_SHIFT - 2);	//Ȃ
	//wk->ScaleY -= 1 << (FX32_SHIFT - 2);
	//wk->ScaleX -= 1 << (FX32_SHIFT - 8);	//xȂ
	//wk->ScaleY -= 1 << (FX32_SHIFT - 8);

	rScale_x = FX_Inv(wk->ScaleX);
	rScale_y = FX_Inv(wk->ScaleY);
    mtx._00 = rScale_x;
    mtx._01 = 0;
    mtx._10 = 0;
    mtx._11 = rScale_y;

    SVC_WaitVBlankIntr();			//Waiting the end of VBlank interrup
	//G2S_SetBG3Affine( &mtx,		//a matrix for rotation and scaling
	G2_SetBG3Affine( &mtx,			//a matrix for rotation and scaling
						128, 96,	//the center of rotation
						0, 0);		//the reference point before rotation and scaling applied

	//OS_Printf( "scalex = %d\n", wk->ScaleX );
	//OS_Printf( "scaley = %d\n", wk->ScaleY );
	return ;
}

//--------------------------------------------------------------
/**
 * @brief	gkZbg
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------
static void OpeningAffReset(void)
{
	MtxFx22 mtx;
    fx32 rScale_x,rScale_y;
	
	rScale_x = FX_Inv((1 << FX32_SHIFT));
	rScale_y = FX_Inv((1 << FX32_SHIFT));

    mtx._00 = rScale_x;
    mtx._01 = 0;
    mtx._10 = 0;
    mtx._11 = rScale_y;

    SVC_WaitVBlankIntr();			//Waiting the end of VBlank interrup
	G2_SetBG3Affine( &mtx,			//a matrix for rotation and scaling
						128, 96,	//the center of rotation
						0, 0 );		//the reference point before rotation and scaling applied
	return;
}

//--------------------------------------------------------------
/**
 * @brief	V[PXFI[Lhmu悤Iv
 *
 * @param	wk		OPENING_WORK^̃|C^
 *
 * @return	"TRUE = ցAFALSE = p"
 */
//--------------------------------------------------------------
static BOOL Seq_WelcomePMWorld( OPENING_WORK* wk )
{
	u16 msg_id;
	u32 ret;
	VecFx32 vec;

	switch( wk->sub_seq ){

	//I[Lhf[^Zbg
	case 0:
		//Wɖ߂
		OpeningClactMoveInit( &wk->ObjWork, 0 );	//I[Lh
		OpeningClactMoveInit( &wk->ObjWork, 1 );	//e

		//ʔwi
		SetBgGraphic_Sub4( wk, GF_BGL_FRAME2_M );
	
		//ʔwi
		SetBgGraphic_Sub5( wk, GF_BGL_FRAME2_S );

		OpeningClactVanish( &wk->ObjWork, 0, 1 );			//I[Lh\
		OpeningClactVanish( &wk->ObjWork, 1, 1 );			//e\

		//bEBhE\
		opening_talk_win_put( wk );
		GF_BGL_BmpWinOn( &wk->bmpwin[BMPWIN_OOKIDO] );
		wk->sub_seq++;
		break;

	//ubNC
	case 1:
		ChangeBrightnessRequest( OPENING_FADE_SYNC, BRIGHTNESS_NORMAL, BRIGHTNESS_BLACK, 
									PLANEMASK_ALL, MASK_DOUBLE_DISPLAY );
		wk->sub_seq++;
		break;

	//tF[hI҂
	case 2:
		if( IsFinishedBrightnessChg( MASK_DOUBLE_DISPLAY ) == TRUE ){

			//bEBhEɃI[LhbZ[WZbg
			//u悭ĂꂽˁIv
			msg_id = (wk->cancel == 0) ? msg_opening_01 : msg_opening_20;
			//msg_id = (wk->cancel == 0) ? msg_opening_07 : msg_opening_07;
			wk->msg_index = OpeningWriteMsg( wk, &wk->bmpwin[BMPWIN_OOKIDO], msg_id, 
										OP_OOKIDO_X, OP_OOKIDO_Y, MsgSpeedGet(), 
										FBMP_COL_BLACK,FBMP_COL_BLK_SDW,FBMP_COL_WHITE, FONT_TALK );
			GF_BGL_BmpWinOn( &wk->bmpwin[BMPWIN_OOKIDO] );
			wk->cancel = 0;
			wk->sub_seq++;
		}
		break;

	//I[Lh̐
	case 3:
		//bZ[WI҂
		if( GF_MSG_PrintEndCheck( wk->msg_index ) == 1 ){
			break;
		}
		wk->sub_seq++;
		break;

	case 4:
		//EBhEɃJ[\摜`
		//BmpWin_DrawCursorImage(GF_BGL_BMPWIN* win, u32 x, u32 y);

		vec = OpeningClactMove( &wk->ObjWork, 0, OP_OOKIDO_SCR_SPD );	//I[Lh
		OpeningClactMove( &wk->ObjWork, 1, OP_OOKIDO_SCR_SPD );	//e

		//XN[I`FbN
		if( vec.x >= OP_OOKIDO_SCR_END ){
			//j[EBhE
			OpeningWriteMenuWin( wk->bgl, &wk->bmpwin[BMPWIN_MENU_1] );
		
			OpeningInitMenu( wk, &wk->bmpwin[BMPWIN_MENU_1], 3 );
			OpeningSetMenuData( wk, 0, SEQ_SEX_CHOICE, msg_opening_09 );
			OpeningSetMenuData( wk, 1, SEQ_KEY_GUIDE, msg_opening_07 );
			OpeningSetMenuData( wk, 2, SEQ_GAME_GUIDE, msg_opening_08 );
			wk->mw = BmpMenuAddEx( &wk->MenuH, 8, 0, 0, HEAPID_OPENING, PAD_BUTTON_B );

			wk->sub_seq++;
		}
		break;

	//I҂
	case 5:
		wk->ret_work = BmpMenuMain( wk->mw );
		if( wk->ret_work == BMPMENU_CANCEL ){
			wk->ret_work = SEQ_SEX_CHOICE;
		}

		switch( wk->ret_work ){
		case BMPMENU_NULL:
			break;
		default:
			BmpMenuExit( wk->mw, NULL );
			BmpMenuWinClear( wk->MenuH.win, WINDOW_TRANS_ON );
			wk->sub_seq++;
			break;
		};
		break;

	//ubNAEg
	case 6:
		//u傤ԁvI񂾎
		if( wk->ret_work == SEQ_SEX_CHOICE ){
			return TRUE;
		}

		ChangeBrightnessRequest(OPENING_FADE_SYNC, BRIGHTNESS_BLACK, BRIGHTNESS_NORMAL, 
								PLANEMASK_ALL, MASK_DOUBLE_DISPLAY);
		wk->sub_seq++;
		break;

	//tF[hI҂
	case 7:
		if( IsFinishedBrightnessChg( MASK_DOUBLE_DISPLAY ) == TRUE ){
			return TRUE;
		}
		break;
	};

	return FALSE;
}

//--------------------------------------------------------------
/**
 * @brief	V[PXF
 *
 * @param	wk		OPENING_WORK^̃|C^
 *
 * @return	"TRUE = ցAFALSE = p"
 */
//--------------------------------------------------------------
static BOOL Seq_KeyGuide( OPENING_WORK* wk )
{
	switch( wk->sub_seq ){

	//f[^Zbg
	case 0:
		//bEBhE
		BmpTalkWinClear( &wk->bmpwin[BMPWIN_OOKIDO], WINDOW_TRANS_ON );

		OpeningClactVanish( &wk->ObjWork, 0, 0 );			//I[Lh\
		OpeningClactVanish( &wk->ObjWork, 1, 0 );			//e\

		SetPalette_Sub6();
		SetPalette_Sub7();

		SetBgGraphic_Sub6( wk, GF_BGL_FRAME2_M, 0 );
		SetBgGraphic_Sub7( wk, GF_BGL_FRAME2_S );

		//u낢ȁv
		OpeningWriteMsg( wk, &wk->bmpwin[BMPWIN_GUIDE], msg_operation_01, 
							OP_KEY_GUIDE_X, OP_KEY_GUIDE_Y, MSG_NO_PUT,
							FBMP_COL_WHITE,FBMP_COL_BLK_SDW,FBMP_COL_NULL, FONT_SYSTEM );
		GF_BGL_BmpWinOn( &wk->bmpwin[BMPWIN_GUIDE] );
		wk->sub_seq++;
		break;

	//ubNC
	case 1:
		ChangeBrightnessRequest( OPENING_FADE_SYNC, BRIGHTNESS_NORMAL, BRIGHTNESS_BLACK, 
									PLANEMASK_ALL, MASK_DOUBLE_DISPLAY );
		wk->sub_seq++;
		break;

	//tF[hI҂
	case 2:
		if( IsFinishedBrightnessChg( MASK_DOUBLE_DISPLAY ) == TRUE ){
			wk->sub_seq++;
		}
		break;

	//1
	case 3:
		if( KeyCheck(PAD_BUTTON_A | PAD_BUTTON_B) ){

			SetBgGraphic_Sub6( wk, GF_BGL_FRAME2_M, 1 );

			//u傤䂤Ɂv
			OpeningWriteMsg( wk, &wk->bmpwin[BMPWIN_GUIDE], msg_operation_02, 
							OP_KEY_GUIDE_X, OP_KEY_GUIDE_Y, MSG_NO_PUT, 
							FBMP_COL_WHITE,FBMP_COL_BLK_SDW,FBMP_COL_NULL, FONT_SYSTEM );
			GF_BGL_BmpWinOn( &wk->bmpwin[BMPWIN_GUIDE] );

			wk->sub_seq++;
		}
		break;

	//2
	case 4:
		if( KeyCheck(PAD_BUTTON_A | PAD_BUTTON_B) ){

			SetBgGraphic_Sub6( wk, GF_BGL_FRAME2_M, 2 );

			//uj[v
			OpeningWriteMsg( wk, &wk->bmpwin[BMPWIN_GUIDE], msg_operation_03, 
								OP_KEY_GUIDE_X, OP_KEY_GUIDE_Y, MSG_NO_PUT, 
								FBMP_COL_WHITE,FBMP_COL_BLK_SDW,FBMP_COL_NULL, FONT_SYSTEM );
			GF_BGL_BmpWinOn( &wk->bmpwin[BMPWIN_GUIDE] );

			wk->sub_seq++;
		}
		break;

	//3
	case 5:
		if( KeyCheck(PAD_BUTTON_A | PAD_BUTTON_B) ){

			SetBgGraphic_Sub6( wk, GF_BGL_FRAME2_M, 3 );

			//û߂́v
			OpeningWriteMsg( wk, &wk->bmpwin[BMPWIN_GUIDE], msg_operation_04, 
								OP_KEY_GUIDE_X, OP_KEY_GUIDE_Y, MSG_NO_PUT, 
								FBMP_COL_WHITE,FBMP_COL_BLK_SDW,FBMP_COL_NULL, FONT_SYSTEM );
			GF_BGL_BmpWinOn( &wk->bmpwin[BMPWIN_GUIDE] );

			wk->sub_seq++;
		}
		break;

	//4
	case 6:
		if( KeyCheck(PAD_BUTTON_A | PAD_BUTTON_B) ){
			wk->sub_seq++;
		}
		break;

	//ubNAEg
	case 7:
		ChangeBrightnessRequest(OPENING_FADE_SYNC, BRIGHTNESS_BLACK, BRIGHTNESS_NORMAL, 
								PLANEMASK_ALL, MASK_DOUBLE_DISPLAY);
		wk->sub_seq++;
		break;

	//tF[hI҂
	case 8:
		if( IsFinishedBrightnessChg( MASK_DOUBLE_DISPLAY ) == TRUE ){
			GF_BGL_BmpWinOff( &wk->bmpwin[BMPWIN_GUIDE] );
			wk->cancel = 1;
			return TRUE;
		}
		break;
	}

	return FALSE;
}

//--------------------------------------------------------------
/**
 * @brief	V[PXFQ[
 *
 * @param	wk		OPENING_WORK^̃|C^
 *
 * @return	"TRUE = ցAFALSE = p"
 */
//--------------------------------------------------------------
static BOOL Seq_GameGuide( OPENING_WORK* wk )
{
	switch( wk->sub_seq ){

	//Q[f[^Zbg
	case 0:
		//bEBhE
		BmpTalkWinClear( &wk->bmpwin[BMPWIN_OOKIDO], WINDOW_TRANS_ON );

		OpeningClactVanish( &wk->ObjWork, 0, 0 );			//I[Lh\
		OpeningClactVanish( &wk->ObjWork, 1, 0 );			//e\

		SetPalette_Sub6();
		SetPalette_Sub7();

		SetBgGraphic_Sub8( wk, GF_BGL_FRAME2_M );
		SetBgGraphic_Sub9( wk, GF_BGL_FRAME2_S );

		//uꂩ͂܂v
		OpeningWriteMsg( wk, &wk->bmpwin[BMPWIN_GUIDE], msg_guide_01, 
							OP_GAME_GUIDE_X, OP_GAME_GUIDE_Y, MSG_NO_PUT, 
							FBMP_COL_BLACK,FBMP_COL_BLK_SDW,FBMP_COL_NULL, FONT_SYSTEM );
		GF_BGL_BmpWinOn( &wk->bmpwin[BMPWIN_GUIDE] );

		wk->sub_seq++;
		break;

	//ubNC
	case 1:
		ChangeBrightnessRequest( OPENING_FADE_SYNC, BRIGHTNESS_NORMAL, BRIGHTNESS_BLACK, 
									PLANEMASK_ALL, MASK_DOUBLE_DISPLAY );
		wk->sub_seq++;
		break;

	//tF[hI҂
	case 2:
		if( IsFinishedBrightnessChg( MASK_DOUBLE_DISPLAY ) == TRUE ){
			wk->sub_seq++;
		}
		break;

	//Q[1
	case 3:
		if( KeyCheck(PAD_BUTTON_A | PAD_BUTTON_B) ){

			//u܂݂v
			OpeningWriteMsg( wk, &wk->bmpwin[BMPWIN_GUIDE], msg_guide_02, 
								OP_GAME_GUIDE_X, OP_GAME_GUIDE_Y, MSG_NO_PUT, 
								FBMP_COL_BLACK,FBMP_COL_BLK_SDW,FBMP_COL_NULL, FONT_SYSTEM );
			GF_BGL_BmpWinOn( &wk->bmpwin[BMPWIN_GUIDE] );

			wk->sub_seq++;
		}
		break;

	//Q[2
	case 4:
		if( KeyCheck(PAD_BUTTON_A | PAD_BUTTON_B) ){

			//uĂ܂Ăv
			OpeningWriteMsg( wk, &wk->bmpwin[BMPWIN_GUIDE], msg_guide_03, 
								OP_GAME_GUIDE_X, OP_GAME_GUIDE_Y, MSG_NO_PUT, 
								FBMP_COL_BLACK,FBMP_COL_BLK_SDW,FBMP_COL_NULL, FONT_SYSTEM );
			GF_BGL_BmpWinOn( &wk->bmpwin[BMPWIN_GUIDE] );

			wk->sub_seq++;
		}
		break;

	//Q[3
	case 5:
		if( KeyCheck(PAD_BUTTON_A | PAD_BUTTON_B) ){

			//uƂɂ傤Ԃv
			OpeningWriteMsg( wk, &wk->bmpwin[BMPWIN_GUIDE], msg_guide_04, 
								OP_GAME_GUIDE_X, OP_GAME_GUIDE_Y, MSG_NO_PUT, 
								FBMP_COL_BLACK,FBMP_COL_BLK_SDW,FBMP_COL_NULL, FONT_SYSTEM );
			GF_BGL_BmpWinOn( &wk->bmpwin[BMPWIN_GUIDE] );

			wk->sub_seq++;
		}
		break;

	//Q[4
	case 6:
		if( KeyCheck(PAD_BUTTON_A | PAD_BUTTON_B) ){

			//uڂv
			OpeningWriteMsg( wk, &wk->bmpwin[BMPWIN_GUIDE], msg_guide_05, 
								OP_GAME_GUIDE_X, OP_GAME_GUIDE_Y, MSG_NO_PUT, 
								FBMP_COL_BLACK,FBMP_COL_BLK_SDW,FBMP_COL_NULL, FONT_SYSTEM );
			GF_BGL_BmpWinOn( &wk->bmpwin[BMPWIN_GUIDE] );

			wk->sub_seq++;
		}
		break;

	//Q[5
	case 7:
		if( KeyCheck(PAD_BUTTON_A | PAD_BUTTON_B) ){

			//uꂪv
			OpeningWriteMsg( wk, &wk->bmpwin[BMPWIN_GUIDE], msg_guide_06, 
								OP_GAME_GUIDE_X, OP_GAME_GUIDE_Y, MSG_NO_PUT, 
								FBMP_COL_BLACK,FBMP_COL_BLK_SDW,FBMP_COL_NULL, FONT_SYSTEM );
			GF_BGL_BmpWinOn( &wk->bmpwin[BMPWIN_GUIDE] );

			wk->sub_seq++;
		}
		break;

	//Q[6
	case 8:
		if( KeyCheck(PAD_BUTTON_A | PAD_BUTTON_B) ){
			wk->sub_seq++;
		}
		break;

	//ubNAEg
	case 9:
		ChangeBrightnessRequest(OPENING_FADE_SYNC, BRIGHTNESS_BLACK, BRIGHTNESS_NORMAL, 
								PLANEMASK_ALL, MASK_DOUBLE_DISPLAY);
		wk->sub_seq++;
		break;

	//tF[hI҂
	case 10:
		if( IsFinishedBrightnessChg( MASK_DOUBLE_DISPLAY ) == TRUE ){
			GF_BGL_BmpWinOff( &wk->bmpwin[BMPWIN_GUIDE] );
			wk->cancel = 1;
			return TRUE;
		}
		break;
	};

	return FALSE;
}

//--------------------------------------------------------------
/**
 * @brief	V[PXFʑI
 *
 * @param	wk		OPENING_WORK^̃|C^
 *
 * @return	"TRUE = ցAFALSE = p"
 */
//--------------------------------------------------------------
static BOOL Seq_SexChoice( OPENING_WORK* wk )
{
	u16 col;
	u16 msg_id;
	VecFx32 vec;

	switch( wk->sub_seq ){

	//ʑIf[^Zbg
	case 0:
		wk->sex = PM_MALE;

		//jl(256FAgk)
		SetBgGraphic_Sub2( wk, GF_BGL_FRAME3_M );

		//bEBhE\
		opening_talk_win_put( wk );
		GF_BGL_BmpWinOn( &wk->bmpwin[BMPWIN_OOKIDO] );

		//lXN[CJnʒuZbg
		GF_BGL_ScrollSet( wk->bgl, GF_BGL_FRAME3_M, GF_BGL_SCROLL_X_SET, OP_HERO_SCR_START );

		wk->sub_seq++;
		break;

	case 1:
		vec = OpeningClactMove( &wk->ObjWork, 0, -(OP_OOKIDO_SCR_SPD) );	//I[Lh
		OpeningClactMove( &wk->ObjWork, 1, -(OP_OOKIDO_SCR_SPD) );	//e

		//XN[I`FbN
		if( vec.x <= OP_OOKIDO_SCR_END_2 ){
			//Wɖ߂
			OpeningClactMoveInit( &wk->ObjWork, 0 );	//I[Lh
			OpeningClactMoveInit( &wk->ObjWork, 1 );	//e
			wk->sub_seq++;
		}
		break;

	//tF[hI҂
	case 2:
		msg_id = (wk->cancel == 0) ? msg_opening_02 : msg_opening_18;
		//msg_id = (wk->cancel == 0) ? msg_opening_07 : msg_opening_07;
		wk->cancel = 0;

		wk->msg_index = OpeningWriteMsg( wk, &wk->bmpwin[BMPWIN_OOKIDO], msg_id, 
										OP_OOKIDO_X, OP_OOKIDO_Y, MsgSpeedGet(), 
										FBMP_COL_BLACK,FBMP_COL_BLK_SDW,FBMP_COL_WHITE, FONT_TALK );
		GF_BGL_BmpWinOn( &wk->bmpwin[BMPWIN_OOKIDO] );

		wk->sub_seq++;
		break;

	//I[Lh̐
	case 3:
		//bZ[WI҂
		if( GF_MSG_PrintEndCheck( wk->msg_index ) == 1 ){
			break;
		}

		col = (PM_VERSION == VERSION_DIAMOND) ? 0x7356 : 0x573b;
		PaletteFadeReq( wk->pfd, PF_BIT_MAIN_OBJ, 0xffff, 0, 8, 16, col );
		wk->sub_seq++;
		break;

	//I[LhpbgAEg҂
	case 4:
		if( PaletteFadeCheck(wk->pfd) == 0 ){
			OpeningClactVanish( &wk->ObjWork, 0, 0 );			//I[Lh\
			OpeningClactVanish( &wk->ObjWork, 1, 0 );			//e\
			wk->sub_seq++;
		}
		break;

	//lXN[C
	case 5:
		//jlBG\
		GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG3, VISIBLE_ON );

		//lXN[C
		GF_BGL_ScrollSet( wk->bgl, GF_BGL_FRAME3_M, GF_BGL_SCROLL_X_INC, OP_HERO_SCR_SPD );

		//XN[lw擾
		if( GF_BGL_ScrollGetX(wk->bgl, GF_BGL_FRAME3_M) < OP_HERO_SCR_END ){
			break;
		}

		GF_BGL_ScrollSet( wk->bgl, GF_BGL_FRAME3_M, GF_BGL_SCROLL_X_SET, OP_HERO_SCR_END );

		//j[EBhE
		OpeningWriteMenuWin( wk->bgl, &wk->bmpwin[BMPWIN_MENU_2] );
		
		OpeningInitMenu( wk, &wk->bmpwin[BMPWIN_MENU_2], 2 );
		OpeningSetMenuData( wk, 0, PM_MALE, msg_opening_10 );
		OpeningSetMenuData( wk, 1, PM_FEMALE, msg_opening_11 );
		wk->mw = BmpMenuAddEx( &wk->MenuH, 8, 0, 0, HEAPID_OPENING, PAD_BUTTON_B );

		wk->sub_seq++;
		break;

	//ʑI
	case 6:
		wk->ret_work = BmpMenuMain( wk->mw );

		switch( wk->ret_work ){
		case BMPMENU_NULL:
		case BMPMENU_CANCEL:
			//jl(256FAgk)
			if( sys.trg == PAD_KEY_UP ){
				wk->sex = PM_MALE;
			}else if( sys.trg == PAD_KEY_DOWN ){
				wk->sex = PM_FEMALE;
			}
			SetBgGraphic_Sub2( wk, GF_BGL_FRAME3_M );
			break;
		default:
			wk->sex = wk->ret_work;
			BmpMenuExit( wk->mw, NULL );
			BmpMenuWinClear( wk->MenuH.win, WINDOW_TRANS_ON );
			wk->sub_seq++;
			break;
		};
		break;

	//E֏
	case 7:
		//lXN[AEg
		GF_BGL_ScrollSet( wk->bgl, GF_BGL_FRAME3_M, GF_BGL_SCROLL_X_DEC, OP_HERO_SCR_SPD );

		//XN[lw擾
		if( GF_BGL_ScrollGetX(wk->bgl, GF_BGL_FRAME3_M) > OP_HERO_SCR_START ){
			break;
		}

		GF_BGL_ScrollSet( wk->bgl, GF_BGL_FRAME3_M, GF_BGL_SCROLL_X_SET, OP_HERO_SCR_START );
		//GF_BGL_ScrollSet( wk->bgl, GF_BGL_FRAME3_M, GF_BGL_SCROLL_X_SET, OP_HERO_SCR_END );

		//jlBG\
		GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG3, VISIBLE_OFF );

		//I[LhtF[hC
		OpeningClactVanish( &wk->ObjWork, 0, 1 );			//I[Lh\
		OpeningClactVanish( &wk->ObjWork, 1, 1 );			//e\
		col = (PM_VERSION == VERSION_DIAMOND) ? 0x7356 : 0x573b;
		PaletteFadeReq( wk->pfd, PF_BIT_MAIN_OBJ, 0xffff, 0, 16, 0, col );

		wk->sub_seq++;
		break;

	//I[Lh\
	case 8:
		if( PaletteFadeCheck(wk->pfd) == 0 ){

			//bEBhE\
			opening_talk_win_put( wk );

			wk->msg_index = OpeningWriteMsg( wk, &wk->bmpwin[BMPWIN_OOKIDO], msg_opening_03, 
										OP_OOKIDO_X, OP_OOKIDO_Y, MsgSpeedGet(), 
										FBMP_COL_BLACK,FBMP_COL_BLK_SDW,FBMP_COL_WHITE, FONT_TALK );
			GF_BGL_BmpWinOn( &wk->bmpwin[BMPWIN_OOKIDO] );
			wk->sub_seq++;
		}
		break;

	//bZ[W\
	case 9:
		//bZ[WI҂
		if( GF_MSG_PrintEndCheck( wk->msg_index ) == 1 ){
			break;
		}

		if( KeyCheck(PAD_BUTTON_A | PAD_BUTTON_B) ){
			wk->sub_seq++;
		}
		break;

	//ubNAEg
	case 10:
		ChangeBrightnessRequest(OPENING_FADE_SYNC, BRIGHTNESS_BLACK, BRIGHTNESS_NORMAL, 
								PLANEMASK_ALL, MASK_DOUBLE_DISPLAY);
		wk->sub_seq++;
		break;

	//tF[hI҂
	case 11:
		if( IsFinishedBrightnessChg( MASK_DOUBLE_DISPLAY ) == TRUE ){
			//bEBhE
			BmpTalkWinClear( &wk->bmpwin[BMPWIN_OOKIDO], WINDOW_TRANS_ON );
			return TRUE;
		}
		break;
	};

	return FALSE;
}

//--------------------------------------------------------------
/**
 * @brief	V[PXFO
 *
 * @param	wk		OPENING_WORK^̃|C^
 *
 * @return	"TRUE = ցAFALSE = p"
 */
//--------------------------------------------------------------
static BOOL Seq_NameIn( OPENING_WORK* wk )
{
	u16 msg_id,col;

	switch( wk->sub_seq ){

	case 0:
		wk->sub_seq++;
		break;

	case 1:
		wk->sub_seq++;
		break;

	//O͌Ăяo
	case 2:
		wk->tcb = NULL;
		OpeningNameInCall( wk );
		wk->sub_seq++;
		break;

	//O͏I҂
	case 3:
		//O͊Ď
		if( wk->tcb != NULL ){
			break;
		}

		//bEBhE\
		opening_talk_win_put( wk );
		GF_BGL_BmpWinOn( &wk->bmpwin[BMPWIN_OOKIDO] );

		//u񂾂ˁHv
		msg_id = (wk->sex == PM_MALE) ? msg_opening_16 : msg_opening_17;
		//WORDSET_RegisterWord( wk->wordset, 0, nameinw, wk->sex, TRUE, PM_LANG );
		wk->msg_index = OpeningWriteMsg( wk, &wk->bmpwin[BMPWIN_OOKIDO], msg_id, 
										OP_OOKIDO_X, OP_OOKIDO_Y, MsgSpeedGet(), 
										FBMP_COL_BLACK,FBMP_COL_BLK_SDW,FBMP_COL_WHITE, FONT_TALK );

		GF_BGL_BmpWinOn( &wk->bmpwin[BMPWIN_OOKIDO] );
		wk->sub_seq++;
		break;

	//ʑI
	case 4:
		//bZ[WI҂
		if( GF_MSG_PrintEndCheck( wk->msg_index ) == 1 ){
			break;
		}

		//j[EBhE
		OpeningWriteMenuWin( wk->bgl, &wk->bmpwin[BMPWIN_YESNO] );
		OpeningInitMenu( wk, &wk->bmpwin[BMPWIN_YESNO], 2 );
		OpeningSetMenuData( wk, 0, SEQ_ID_CHOICE, msg_opening_14 );
		OpeningSetMenuData( wk, 1, SEQ_SEX_CHOICE, msg_opening_15 );
		wk->mw = BmpMenuAddEx( &wk->MenuH, 8, 0, 0, HEAPID_OPENING, PAD_BUTTON_B );
		wk->sub_seq++;
		break;

	case 5:
		wk->ret_work = BmpMenuMain( wk->mw );
		if( wk->ret_work == BMPMENU_CANCEL ){
			wk->ret_work = SEQ_SEX_CHOICE;
		}

		switch( wk->ret_work ){
		case BMPMENU_NULL:
			break;
		default:
			BmpMenuExit( wk->mw, NULL );
			BmpMenuWinClear( wk->MenuH.win, WINDOW_TRANS_ON );
			wk->sub_seq++;
			break;
		};
		break;

	case 6:
		wk->sub_seq++;
		break;

	case 7:
#if 0
		//lXN[AEg
		GF_BGL_ScrollSet( wk->bgl, GF_BGL_FRAME3_M, GF_BGL_SCROLL_X_DEC, OP_HERO_SCR_SPD );

		//XN[lw擾
		if( GF_BGL_ScrollGetX(wk->bgl, GF_BGL_FRAME3_M) > OP_HERO_SCR_START ){
			break;
		}

		GF_BGL_ScrollSet( wk->bgl, GF_BGL_FRAME3_M, GF_BGL_SCROLL_X_SET, OP_HERO_SCR_START );
		//GF_BGL_ScrollSet( wk->bgl, GF_BGL_FRAME3_M, GF_BGL_SCROLL_X_SET, OP_HERO_SCR_END );
#endif
		//jlBG\
		GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG3, VISIBLE_OFF );
		GF_BGL_ScrollSet( wk->bgl, GF_BGL_FRAME3_M, GF_BGL_SCROLL_X_SET, 0 );

		//I[LhtF[hC
		OpeningClactVanish( &wk->ObjWork, 0, 1 );			//I[Lh\
		OpeningClactVanish( &wk->ObjWork, 1, 1 );			//e\
		col = (PM_VERSION == VERSION_DIAMOND) ? 0x7356 : 0x573b;
		PaletteFadeReq( wk->pfd, PF_BIT_MAIN_OBJ, 0xffff, 0, 16, 0, col );

		wk->sub_seq++;
		break;

	case 8:
		if( PaletteFadeCheck(wk->pfd) == 0 ){

		//jlBG\
		//GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG3, VISIBLE_OFF );
		//GF_BGL_ScrollSet( wk->bgl, GF_BGL_FRAME3_M, GF_BGL_SCROLL_X_SET, OP_HERO_SCR_END );

		if( wk->ret_work == SEQ_SEX_CHOICE ){
			OpeningClactVanish( &wk->ObjWork, 0, 1 );			//I[Lh\
			OpeningClactVanish( &wk->ObjWork, 1, 1 );			//e\
			wk->cancel = 1;
		}else{
#if 1
			{
				//title.cĂ΂Ȃƃ_I********************/
				SAVEDATA * sv = ((MAINWORK *)PROC_GetParentWork(wk->proc))->savedata;
				/************************************************/

				MYSTATUS * my = SaveData_GetMyStatus(sv);

				//l̖OZbg
				//MyStatus_SetMyName(my, str);
				//MyStatus_SetMyName(my, wk->NameInParam->str);
				MyStatus_SetMyName( my, wk->str );

				//l̐ʃZbg
				MyStatus_SetMySex( my, wk->sex );
			}
#endif
		}
		return TRUE;
		}
	};

	return FALSE;
}

//--------------------------------------------------------------
/**
 * @brief	V[PXFIDI
 *
 * @param	wk		OPENING_WORK^̃|C^
 *
 * @return	"TRUE = ցAFALSE = p"
 */
//--------------------------------------------------------------
static BOOL Seq_IdChoice( OPENING_WORK* wk )
{
	u16 msg_id;

	switch( wk->sub_seq ){

	//f[^ZbgȂ
	case 0:
		OpeningClactVanish( &wk->ObjWork, 0, 1 );			//I[Lh\
		OpeningClactVanish( &wk->ObjWork, 1, 1 );			//e\

		//bEBhE\
		opening_talk_win_put( wk );
		
		msg_id = (wk->cancel == 0) ? msg_opening_04 : msg_opening_05;
		wk->cancel = 0;

		//WORDSET_RegisterPlayerName( wk->wordset, 0, 
		wk->msg_index = OpeningWriteMsg( wk, &wk->bmpwin[BMPWIN_OOKIDO], msg_id, 
		//wk->msg_index = OpeningWriteMsg( wk, &wk->bmpwin[BMPWIN_OOKIDO], msg_opening_07, 
										OP_OOKIDO_X, OP_OOKIDO_Y, MsgSpeedGet(), 
										FBMP_COL_BLACK,FBMP_COL_BLK_SDW,FBMP_COL_WHITE, FONT_TALK );
		GF_BGL_BmpWinOn( &wk->bmpwin[BMPWIN_OOKIDO] );

		wk->sub_seq++;
		break;

	//ubNC
	case 1:
		//bZ[WI҂
		if( GF_MSG_PrintEndCheck( wk->msg_index ) == 1 ){
			break;
		}

		//j[EBhE
		OpeningWriteMenuWin( wk->bgl, &wk->bmpwin[BMPWIN_IDSEL] );
		
		OpeningInitMenu( wk, &wk->bmpwin[BMPWIN_IDSEL], 2 );
		OpeningSetMenuData( wk, 0, 0, msg_opening_12 );
		OpeningSetMenuData( wk, 1, 1, msg_opening_13 );
		wk->mw = BmpMenuAddEx( &wk->MenuH, 8, 0, 0, HEAPID_OPENING, PAD_BUTTON_B );

		//ChangeBrightnessRequest( OPENING_FADE_SYNC, BRIGHTNESS_NORMAL, BRIGHTNESS_BLACK, 
		//							PLANEMASK_ALL, MASK_DOUBLE_DISPLAY );
		wk->sub_seq++;
		break;

	//tF[hI҂
	case 2:
		wk->ret_work = BmpMenuMain( wk->mw );
		if( wk->ret_work == BMPMENU_CANCEL ){
			wk->ret_work = 1;
		}

		switch( wk->ret_work ){
		case BMPMENU_NULL:
			break;
		default:
			BmpMenuExit( wk->mw, NULL );
			BmpMenuWinClear( wk->MenuH.win, WINDOW_TRANS_ON );
			wk->sub_seq++;
			break;
		};
		break;

	case 3:
		if( wk->ret_work == 1 ){
			wk->cancel = 1;
			wk->sub_seq = 0;
			break;
		}

		{
			//---------------------------------------------------------------
			//IDVbtđIԏȂ̂ŉAIDZbgĂ
			//---------------------------------------------------------------
			
			SAVEDATA * sv = ((MAINWORK *)PROC_GetParentWork(wk->proc))->savedata;
			MYSTATUS * my = SaveData_GetMyStatus(sv);

			//Iʂ猈肵g[i[^Cv̔ԍ̂̂Zo
			int view = UnionView_GetTrainerType( 0x1234, wk->sex, 0 );

			//MYSTATUSɎ́uځvi[
			MyStatus_SetTrainerView( my, view );
		}

		wk->sub_seq++;
		break;

	case 4:
		if( IsFinishedBrightnessChg( MASK_DOUBLE_DISPLAY ) == TRUE ){
			wk->count = 0;
			wk->sub_seq++;
		}
		return TRUE;
	};

	return FALSE;
}

//--------------------------------------------------------------
/**
 * @brief	V[PXF`
 *
 * @param	wk		OPENING_WORK^̃|C^
 *
 * @return	"TRUE = ցAFALSE = p"
 */
//--------------------------------------------------------------
static BOOL Seq_ToAdventure( OPENING_WORK* wk )
{
	u16 col;

	switch( wk->sub_seq ){

	//f[^ZbgȂ
	case 0:
		//bEBhE\
		opening_talk_win_put( wk );
		
		//WORDSET_RegisterPlayerName( wk->wordset, 0, 
		wk->msg_index = OpeningWriteMsg( wk, &wk->bmpwin[BMPWIN_OOKIDO], msg_opening_06, 
		//wk->msg_index = OpeningWriteMsg( wk, &wk->bmpwin[BMPWIN_OOKIDO], msg_opening_07, 
										OP_OOKIDO_X, OP_OOKIDO_Y, MsgSpeedGet(), 
										FBMP_COL_BLACK,FBMP_COL_BLK_SDW,FBMP_COL_WHITE, FONT_TALK );
		GF_BGL_BmpWinOn( &wk->bmpwin[BMPWIN_OOKIDO] );

		wk->sub_seq++;
		break;

	//I[LhbI҂
	case 1:
		//bZ[WI҂
		if( GF_MSG_PrintEndCheck( wk->msg_index ) == 1 ){
			break;
		}

		if( KeyCheck(PAD_BUTTON_A | PAD_BUTTON_B) ){
			//bEBhE
			BmpTalkWinClear( &wk->bmpwin[BMPWIN_OOKIDO], WINDOW_TRANS_ON );

			OpeningOffBmpWin( wk->bmpwin );		//BMPEBhEIt

			col = (PM_VERSION == VERSION_DIAMOND) ? 0x7356 : 0x573b;
			PaletteFadeReq( wk->pfd, PF_BIT_MAIN_OBJ, 0xffff, 0, 8, 16, col );
			//ChangeBrightnessRequest(OPENING_FADE_SYNC, BRIGHTNESS_BLACK, BRIGHTNESS_NORMAL, 
			//					PLANEMASK_ALL, MASK_DOUBLE_DISPLAY);
			wk->sub_seq++;
		}
		break;

	//I[LhtF[hAEg
	case 2:
		if( PaletteFadeCheck(wk->pfd) == 0 ){
		//if( IsFinishedBrightnessChg( MASK_DOUBLE_DISPLAY ) == TRUE ){

			OpeningClactVanish( &wk->ObjWork, 0, 0 );			//I[Lh\
			OpeningClactVanish( &wk->ObjWork, 1, 0 );			//e\

			//jl(256FAgk)
			SetBgGraphic_Sub2( wk, GF_BGL_FRAME3_M );
			//jlBG\
			GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG3, VISIBLE_ON );

			wk->count = 0;
			wk->sub_seq++;
		}
		break;

	//k
	case 3:
#if 0
		//lS
		GF_BGL_ScrollSet( wk->bgl, GF_BGL_FRAME3_M, GF_BGL_SCROLL_X_INC, OP_HERO_SCR_SPD2 );

		//XN[lw擾
		if( GF_BGL_ScrollGetX(wk->bgl, GF_BGL_FRAME3_M) < 0 ){
			break;
		}

		GF_BGL_ScrollSet( wk->bgl, GF_BGL_FRAME3_M, GF_BGL_SCROLL_X_SET, 0 );
#endif
		wk->count++;
		if( wk->count >= 10 ){
			wk->count = 0;
			wk->sub_seq++;
		}
		break;

	case 4:
		OpeningAff( wk );
		if( wk->ScaleX < AFF_SCALE_END ){ 
			return TRUE;
		}
		break;
	};

	return FALSE;
}





//--------------------------------------------------------------
/**
 * @brief	O͉ʌĂяoTCB
 *
 * @param	tcb			TCBVXe[N
 * @param	work		[NGA|C^
 *
 * @return	none
 */
//--------------------------------------------------------------
typedef struct{
	int seq_no;
	OPENING_WORK* op_work;
	NAMEIN_PARAM* NameInParam;
	PROC* proc;
}OPENING_NAMEIN_WORK;

static void OpeningNameInCall( OPENING_WORK* wk )
{
	OPENING_NAMEIN_WORK* name_wk;

	name_wk = sys_AllocMemory( HEAPID_OPENING, sizeof(OPENING_NAMEIN_WORK) );
	if( name_wk == NULL ){
		GF_ASSERT( (0) && "mێsI" );
		return;
	}
	memset( name_wk, 0, sizeof(OPENING_NAMEIN_WORK) );
	name_wk->op_work = wk; 

	wk->tcb	= TCB_Add( OpeningNameInMainTCB, name_wk, 0 );
	return;
}

static void OpeningNameInMainTCB(TCB_PTR tcb,void *work)
{
	OPENING_NAMEIN_WORK* wk = (OPENING_NAMEIN_WORK *)work;

	switch( wk->seq_no ){

	//tF[hAEg
	case 0:
		//ChangeBrightnessRequest(OPENING_FADE_SYNC, BRIGHTNESS_BLACK, BRIGHTNESS_NORMAL, 
		//						PLANEMASK_ALL, MASK_DOUBLE_DISPLAY);
		wk->seq_no++;
		break;

	//tF[hI҂
	case 1:
		if( IsFinishedBrightnessChg( MASK_DOUBLE_DISPLAY ) == TRUE ){

			//폜
			opening_end_sub( wk->op_work );

			//O͗p[N쐬
			wk->NameInParam = NameIn_ParamAllocMake( HEAPID_OPENING, NAMEIN_MYNAME, 0, 5 );
			wk->NameInParam->info = wk->op_work->sex;	//j

			wk->proc = PROC_Create( &NameInProcData, wk->NameInParam, HEAPID_OPENING );

			wk->seq_no++;
		}
		break;

	//O͉ʏI҂
	case 2:
		if( ProcMain(wk->proc) == TRUE ){


#if 0
	{
		STRCODE str[6];
		SAVEDATA * sv = ((MAINWORK *)PROC_GetParentWork(wk->proc))->savedata;
		MYSTATUS * my= SaveData_GetMyStatus(sv);

		//̕(EOMI[)obt@IuWFNgɃZbg
		//STRBUF_SetStringCode( wk->NameInParam->strbuf, (const STRCODE*)str );

		STRBUF_GetStringCode( wk->NameInParam->strbuf, str, 6 );

		OS_Printf( "str[0] = %d\n", str[0] );
		OS_Printf( "str[1] = %d\n", str[1] );
		OS_Printf( "str[2] = %d\n", str[2] );
		OS_Printf( "str[3] = %d\n", str[3] );
		OS_Printf( "str[4] = %d\n", str[4] );

		//l̖OZbg
		MyStatus_SetMyName(my, str);
		//MyStatus_SetMyName(my, wk->NameInParam->str);
	}
#else
		STRBUF_GetStringCode( wk->NameInParam->strbuf, wk->op_work->str, 6 );
#endif













			//A
			PROC_Delete( wk->proc );

			//ʍč\z
			OpeningRecover( wk->op_work );

			//wordsetmۂĂĂ
			WORDSET_RegisterWord( wk->op_work->wordset, 0, wk->NameInParam->strbuf, 
									wk->op_work->sex, TRUE, PM_LANG );

			//sys_FreeMemoryEz( wk->NameInParam );
			NameIn_ParamDelete( wk->NameInParam );				// O̓[N

		
			//ubNC
			ChangeBrightnessRequest( OPENING_FADE_SYNC, BRIGHTNESS_NORMAL, BRIGHTNESS_BLACK, 
									PLANEMASK_ALL, MASK_DOUBLE_DISPLAY );

			wk->seq_no++;
		}
		break;

	//tF[hCI҂
	case 3:
		if( IsFinishedBrightnessChg( MASK_DOUBLE_DISPLAY ) == TRUE ){
			wk->op_work->tcb = NULL;
			sys_FreeMemoryEz(work);
			TCB_Delete(tcb);
		}
		break;
	}

	return;
}
//--------------------------------------------------------------
/**
 * @brief	ʍč\z
 *
 * @param	wk		OPENING_WORK^̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------
static void OpeningRecover( OPENING_WORK* wk )
{
	int i;

	opening_init_sub();
	
	wk->bgl = GF_BGL_BglIniAlloc( HEAPID_OPENING );

	opening_init_sub2( wk );

	//jlBG\
	GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG3, VISIBLE_ON );

	//jl(256FAgk)
	SetBgGraphic_Sub2( wk, GF_BGL_FRAME3_M );

	OpeningClactVanish( &wk->ObjWork, 0, 0 );			//I[Lh\
	OpeningClactVanish( &wk->ObjWork, 1, 0 );			//e\

	//Wɖ߂
	OpeningClactMoveInit( &wk->ObjWork, 0 );	//I[Lh
	OpeningClactMoveInit( &wk->ObjWork, 1 );	//e

	//ʔwi
	SetBgGraphic_Sub4( wk, GF_BGL_FRAME2_M );
	
	//ʔwi
	SetBgGraphic_Sub5( wk, GF_BGL_FRAME2_S );

	return;
}

//--------------------------------------------------------------
/**
 * @brief	ʏ1
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------
static void opening_init_sub()
{
	sys_VBlankFuncChange( NULL, NULL );			//VBlankZbg
	sys_HBlankIntrSet( NULL,NULL );				//HBlankZbg
	GF_Disp_GX_VisibleControlInit();
	GF_Disp_GXS_VisibleControlInit();
	GX_SetVisiblePlane( 0 );
	GXS_SetVisiblePlane( 0 );
	//sys_KeyRepeatSpeedSet( 4, 8 );
	return;	
}

//--------------------------------------------------------------
/**
 * @brief	ʏ2
 *
 * @param	wk		OPENING_WORK^̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------
static void opening_init_sub2( OPENING_WORK* wk )
{
	int i;

	SetVramBank();

	SetBgHeader( wk->bgl );

	OpeningInitCellActor( &wk->ObjWork );
	OpeningSetActor( &wk->ObjWork );

	//bZ[Wf[^}l[W[쐬
	wk->msgman = MSGMAN_Create( MSGMAN_TYPE_DIRECT, ARC_MSG, 
								NARC_msg_opening_dat, HEAPID_OPENING );

	wk->wordset = WORDSET_Create( HEAPID_OPENING );
	wk->msg_buf = STRBUF_Create( OPENING_MSG_BUF_SIZE, HEAPID_OPENING );
	wk->tmp_buf = STRBUF_Create( OPENING_MSG_BUF_SIZE, HEAPID_OPENING );

	//obt@쐬
	for( i=0; i < OPENING_MENU_MAX ;i++ ){
		wk->menu_buf[i] = STRBUF_Create( OPENING_MENU_BUF_SIZE, HEAPID_OPENING );
	}

	//tHgpbg
	SystemFontPaletteLoad( PALTYPE_MAIN_BG, OP_FONT_PAL * 32, HEAPID_OPENING );
	TalkFontPaletteLoad( PALTYPE_MAIN_BG, OP_MSGFONT_PAL * 32, HEAPID_OPENING );

	//rbg}bvǉ
	OpeningAddBmpWin( wk->bgl, wk->bmpwin );

	//pbgtF[hVXe[N쐬
	wk->pfd = PaletteFadeInit( HEAPID_OPENING );
	//NGXgf[^mallocăZbg
	PaletteFadeWorkAllocSet( wk->pfd, FADE_MAIN_OBJ, FADE_PAL_ALL_SIZE, HEAPID_OPENING );

	PaletteWorkSet_Arc(
			wk->pfd, ARC_OPENING_GRA, NARC_opening_op_hakase_NCLR,
			//HEAPID_OPENING, FADE_MAIN_OBJ, 256*16*2, 0 );
			HEAPID_OPENING, FADE_MAIN_OBJ, 16*2*16, 0 );

	//sys_VBlankFuncChange( VBlankFunc, NULL );	//VBlankZbg
	sys_VBlankFuncChange( VBlankFunc, (void*)wk );	//VBlankZbg

	//
	wk->ScaleX = 1 << FX32_SHIFT;
	wk->ScaleY = 1 << FX32_SHIFT;
	wk->cancel = 0;

	MsgPrintSkipFlagSet( MSG_SKIP_ON );	//XLbvL

	return;
}

//--------------------------------------------------------------
/**
 * @brief	ʏI
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------
static void opening_end_sub( OPENING_WORK* wk )
{
	int i;

	// pbgtF[hJ
	PaletteFadeWorkAllocFree( wk->pfd, FADE_MAIN_OBJ );

	//pbgtF[hVXeJ
	PaletteFadeFree( wk->pfd );
	wk->pfd = NULL;

	OpeningAffReset();						//gkZbg
	OpeningRereaseCellObject(&wk->ObjWork);	//2DIuWFNg֘ÄJ
	MSGMAN_Delete( wk->msgman );			//bZ[W}l[WJ
	WORDSET_Delete( wk->wordset );
	STRBUF_Delete( wk->msg_buf );			//bZ[Wobt@J
	STRBUF_Delete( wk->tmp_buf );			//bZ[Wobt@J

	for( i=0; i < OPENING_MENU_MAX ;i++ ){
		STRBUF_Delete( wk->menu_buf[i] );	//j[obt@J
	}

	OpeningExitBmpWin( wk->bmpwin );		//BMPEBhEJ
	BgExit( wk->bgl );						//BGL폜
	return;
}

//--------------------------------------------------------------
/**
 * @brief	bEBhE\
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------
static void opening_talk_win_put( OPENING_WORK* wk )
{
	OpeningTalkWinPut( &wk->bmpwin[BMPWIN_OOKIDO] );
	GF_BGL_BmpWinDataFill( &wk->bmpwin[BMPWIN_OOKIDO], FBMP_COL_WHITE );	//hԂ
	return;
}


