//==============================================================================================
/**
 * @file	opneing_bmp.h
 * @brief	I[vjO BMP
 * @author	Satoshi Nohara
 * @date	2005.12.08
 */
//==============================================================================================
#ifndef _OPENING_BMP_H_
#define _OPENING_BMP_H_

#include "opening_sys.h"


//==============================================================================================
//
//	`
//
//==============================================================================================


//==============================================================================================
//
//	extern錾
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	rbg}bvǉ
 *
 * @param	ini		BGLf[^
 * @param	win		rbg}bvEBhE
 *
 * @return	none
 */
//--------------------------------------------------------------
extern void OpeningAddBmpWin( GF_BGL_INI* bgl, GF_BGL_BMPWIN* win );

//--------------------------------------------------------------
/**
 * @brief	rbg}bvEBhEj	
 *
 * @param	win		rbg}bvEBhE
 *
 * @return	none
 */
//--------------------------------------------------------------
extern void OpeningExitBmpWin( GF_BGL_BMPWIN* win );

//--------------------------------------------------------------
/**
 * @brief	rbg}bvEBhEIt
 *
 * @param	win		rbg}bvEBhE
 *
 * @return	none
 */
//--------------------------------------------------------------
extern void OpeningOffBmpWin( GF_BGL_BMPWIN* win );

//--------------------------------------------------------------
/**
 * @brief	bZ[W\
 *
 * @param	wk		OPENING_WORK^̃|C^
 * @param	win		rbg}bvEBhE
 * @param	msg_id	bZ[WID
 * @param	x		XW(hbgP)
 * @param	y		YW(hbgP)
 * @param	wait	\EFCg
 * @param	f_col	Fio[(hԂJ[R[h)
 * @param	s_col	eFio[
 * @param	b_col	wiFio[
 * @param	font	tHg
 *
 * @return	"`惋[`̃CfbNX"
 */
//--------------------------------------------------------------
extern u8 OpeningWriteMsg(OPENING_WORK* wk, GF_BGL_BMPWIN* win, int msg_id, u32 x, u32 y, u32 wait, u8 f_col, u8 s_col, u8 b_col, u8 font);

//--------------------------------------------------------------
/**
 * @brief	j[EBhE\
 *
 * @param	ini		BGLf[^
 * @param	win		rbg}bvEBhE
 *
 * @return	none
 */
//--------------------------------------------------------------
extern void OpeningWriteMenuWin( GF_BGL_INI* bgl, GF_BGL_BMPWIN* win );

//--------------------------------------------------------------
/**
 * @brief	BMPj[	wb_[ݒ
 *
 * @param	wk		OPENING_WORK^̃|C^
 * @param	y_max	ڍő吔
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void OpeningInitMenu( OPENING_WORK* wk, GF_BGL_BMPWIN* win, u8 y_max );

//--------------------------------------------------------------
/**
 * @brief	BMPj[	f[^Zbg
 *
 * @param	wk		OPENING_WORK^̃|C^
 * @param	no		Zbgꏊ(߂l)
 * @param	param	߂l
 * @param	msg_id	bZ[WID
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void OpeningSetMenuData( OPENING_WORK* wk, u8 no, u8 param, int msg_id  );

//--------------------------------------------------------------------------------------------
/**
 * tB[hbEBhE\
 *
 * @param	win		BMPf[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
extern void OpeningTalkWinPut( GF_BGL_BMPWIN * win );


#endif //_OPENING_BMP_H_


