//==============================================================================================
/**
 * @file	opneing_obj.c
 * @brief	I[vjO OBJ
 * @author	Satoshi Nohara
 * @date	2005.12.08
 */
//==============================================================================================
#include "common.h"
#include "system/arc_tool.h"
#include "system/arc_util.h"

#include "opening.naix"
#include "opening_obj.h"


//==============================================================================================
//
//	`
//
//==============================================================================================
//CETuXN[`
#define MAIN_LCD							(GF_BGL_MAIN_DISP)		//0
#define SUB_LCD								(GF_BGL_SUB_DISP)		//1

//LN^[}l[W[
#define OP_CHAR_CONT_NUM					(1)
#define OP_CHAR_VRAMTRANS_MAIN_SIZE			(2048)
#define OP_CHAR_VRAMTRANS_SUB_SIZE			(0)

//pbg}l[W[
#define OP_PLTT_CONT_NUM					(2)						//Ǘpbg

#define OP_PALETTE_NUM						(9)						//pbg9{
#define OP_BADGE_PALETTE_NUM				(4)						//pbg4{


//==============================================================================================
//
//	\̐錾
//
//==============================================================================================
typedef struct _POS_tag{
	int x;
	int y;
}_POS;


//==============================================================================================
//
//	f[^
//
//==============================================================================================
//\[X^Cv񋓂ɍ킹(include/system/clact_util_res.h)
//\[X}l[W[o^e[u
static const u8 ResEntryNumTbl[RESOURCE_NUM] = {
	1,			//L\[X
	2,			//pbg\[X
	1,			//Z\[X
	1,			//ZAj\[X
};

static const _POS obj_pos[] = {
	{86,30},	//I[Lh
	{92,96},	//e
};


//==============================================================================================
//
//	vg^Cv錾
//
//==============================================================================================
void OpeningInitCellActor( OPENING_OBJ_WORK *wk );
void OpeningSetActor( OPENING_OBJ_WORK *wk );
static void OpeningInitCharPlttManager( void );
void OpeningRereaseCellObject( OPENING_OBJ_WORK *wk );
void OpeningClactVanish(OPENING_OBJ_WORK *wk, int no, int flag);
VecFx32 OpeningClactMove(OPENING_OBJ_WORK *wk, int no, int spd);
void OpeningClactMoveInit(OPENING_OBJ_WORK *wk, int no );


//==============================================================================================
//
//	֐
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	ZAN^[
 *
 * @param	wk		OPENING_OBJ_WORK^̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------
void OpeningInitCellActor( OPENING_OBJ_WORK *wk )
{
	int i;

	OpeningInitCharPlttManager();

	//OAM}l[W[̏
	NNS_G2dInitOamManagerModule();

	//LOAM}l[W쐬
	//_pOAM}l[W쐬
	//ō쐬OAM}l[W݂ȂŋL
	REND_OAMInit( 
			0, 128,				//COAMǗ̈
			0, 32,				//CʃAtBǗ̈
			0, 128,				//TuOAMǗ̈
			0, 32,				//TuʃAtBǗ̈
			HEAPID_OPENING);
	
	//ZAN^[Zbg̊ȒP(쐬ꂽZAN^[ZbgԂ)
	wk->ClactSet = CLACT_U_SetEasyInit( OPENING_ACT_MAX, &wk->RendData, HEAPID_OPENING );
	
	//\[X}l[W[
	for(i=0;i<RESOURCE_NUM;i++){		//\[X}l[W[쐬
		wk->ResMan[i] = CLACT_U_ResManagerInit(ResEntryNumTbl[i], i, HEAPID_OPENING);
	}

	//charaǂݍ
	wk->ResObjTbl[MAIN_LCD][CLACT_U_CHAR_RES] = CLACT_U_ResManagerResAddArcChar(
					wk->ResMan[CLACT_U_CHAR_RES],
					ARC_OPENING_GRA, NARC_opening_op_hakase_NCGR,
					FALSE, 1, NNS_G2D_VRAM_TYPE_2DMAIN, HEAPID_OPENING);

	//palǂݍ
	wk->ResObjTbl[MAIN_LCD][CLACT_U_PLTT_RES] = CLACT_U_ResManagerResAddArcPltt(
					wk->ResMan[CLACT_U_PLTT_RES],
					ARC_OPENING_GRA, NARC_opening_op_hakase_NCLR,
					FALSE, 1, NNS_G2D_VRAM_TYPE_2DMAIN, OP_PALETTE_NUM, HEAPID_OPENING);

	//cellǂݍ
	wk->ResObjTbl[MAIN_LCD][CLACT_U_CELL_RES] = CLACT_U_ResManagerResAddArcKindCell(
					wk->ResMan[CLACT_U_CELL_RES],
					ARC_OPENING_GRA, NARC_opening_op_hakase_NCER,
					FALSE, 1, CLACT_U_CELL_RES, HEAPID_OPENING);

	//֐animǂݍ
	wk->ResObjTbl[MAIN_LCD][CLACT_U_CELLANM_RES] = CLACT_U_ResManagerResAddArcKindCell(
					wk->ResMan[CLACT_U_CELLANM_RES],
					ARC_OPENING_GRA, NARC_opening_op_hakase_NANR,
					FALSE, 1, CLACT_U_CELLANM_RES, HEAPID_OPENING);
							
	//\[X}l[W[]

	//Chara]
	CLACT_U_CharManagerSet( wk->ResObjTbl[MAIN_LCD][CLACT_U_CHAR_RES] );

	//pbg]
	CLACT_U_PlttManagerSet( wk->ResObjTbl[MAIN_LCD][CLACT_U_PLTT_RES] );

	{
		CLACT_U_RES_OBJ_PTR res_obj_badge_plt;

		//palǂݍ(obWpbg)
		res_obj_badge_plt = CLACT_U_ResManagerResAddArcPltt(
					wk->ResMan[CLACT_U_PLTT_RES],
					ARC_OPENING_GRA, NARC_opening_op_hakase_NCLR,
					FALSE, 2, NNS_G2D_VRAM_TYPE_2DMAIN, OP_BADGE_PALETTE_NUM, HEAPID_OPENING);

		// pbg]
		CLACT_U_PlttManagerSet( res_obj_badge_plt );
	}

	GF_Disp_GX_VisibleControl( GX_PLANEMASK_OBJ, VISIBLE_ON );		// MAIN DISP OBJ ON

	return;
}

//--------------------------------------------------------------
/**
 * @brief	ZAN^[Zbg
 *
 * @param	wk		OPENING_OBJ_WORK^̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------
void OpeningSetActor( OPENING_OBJ_WORK *wk )
{
	int i;
	CLACT_HEADER			cl_act_header;
	
	// ZAN^[wb_쐬	
	CLACT_U_MakeHeader(	&cl_act_header,
						1, 1, 1, 1,
						CLACT_U_HEADER_DATA_NONE, CLACT_U_HEADER_DATA_NONE,
						0, 1,
						wk->ResMan[CLACT_U_CHAR_RES],
						wk->ResMan[CLACT_U_PLTT_RES],
						wk->ResMan[CLACT_U_CELL_RES],
						wk->ResMan[CLACT_U_CELLANM_RES],
						NULL,NULL);

	{
		//o^i[
		u8 ofs;
		CLACT_ADD add;

		add.ClActSet	= wk->ClactSet;
		add.ClActHeader	= &cl_act_header;

		add.mat.x		= 0;//FX32_CONST(32) ;
		add.mat.y		= 0;//FX32_CONST(96) ;		//ʂ͏㉺AĂiMAINASUBj
		add.mat.z		= 0;
		add.sca.x		= FX32_ONE;
		add.sca.y		= FX32_ONE;
		add.sca.z		= FX32_ONE;
		add.rot			= 0;
		add.pri			= 2;
		add.DrawArea	= NNS_G2D_VRAM_TYPE_2DMAIN;
		add.heap		= HEAPID_OPENING;

		//ZAN^[\Jn

		// (C)
		//obW
		for(i=0;i<OPENING_ACT_MAX;i++){
			add.mat.x = FX32_ONE * obj_pos[i].x;
			add.mat.y = FX32_ONE * obj_pos[i].y;
			wk->ClActWork[i] = CLACT_Add(&add);
			CLACT_SetAnmFlag(wk->ClActWork[i],0);
			CLACT_AnmChg( wk->ClActWork[i], i );
		}
	}	
}

//--------------------------------------------------------------
/**
 * @brief	LN^[Epbg}l[W[
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------
static void OpeningInitCharPlttManager(void)
{
	//LN^}l[W[
	{
		CHAR_MANAGER_MAKE cm = {
			OP_CHAR_CONT_NUM,					//LN^䐔
			OP_CHAR_VRAMTRANS_MAIN_SIZE,		//CʂVram]pɗpӂVramTCY
			OP_CHAR_VRAMTRANS_SUB_SIZE,			//TuʂVram]pɗpӂVramTCY
			HEAPID_OPENING						//gpq[v
		};
		InitCharManager(&cm);
	}

	//pbg}l[W[
	InitPlttManager( OP_PLTT_CONT_NUM, HEAPID_OPENING );

	//ǂݍ݊Jnʒu
	CharLoadStartAll();
	PlttLoadStartAll();

	return;
}

//--------------------------------------------------------------
/**
 * @brief	2DZIuWFNg
 *
 * @param	wk		OPENING_OBJ_WORK^̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------
void OpeningRereaseCellObject(OPENING_OBJ_WORK *wk)
{
	u8 i;

	// ZAN^[\[X

	//L]}l[W[j
	CLACT_U_CharManagerDelete( wk->ResObjTbl[MAIN_LCD][CLACT_U_CHAR_RES] );
	//CLACT_U_CharManagerDelete( wk->ResObjTbl[SUB_LCD][CLACT_U_CHAR_RES] );

	//pbg]}l[W[j
	CLACT_U_PlttManagerDelete( wk->ResObjTbl[MAIN_LCD][CLACT_U_PLTT_RES] );
	//CLACT_U_PlttManagerDelete( wk->ResObjTbl[SUB_LCD][CLACT_U_PLTT_RES] );
		
	//LEpbgEZEZAj̃\[X}l[W[j
	for( i=0; i < RESOURCE_NUM ;i++ ){
		CLACT_U_ResManagerDelete( wk->ResMan[i] );
	}

	//ZAN^[Zbgj
	CLACT_DestSet(wk->ClactSet);

	//OAM_[j
	REND_OAM_Delete();

	DeleteCharManager();
	DeletePlttManager();

	return;
}

//--------------------------------------------------------------
/**
 * @brief	ojbV
 *
 * @param	wk		OPENING_OBJ_WORK^̃|C^
 * @param	flag	`tO	0:`	1:_`	
 *
 * @return	none
 */
//--------------------------------------------------------------
void OpeningClactVanish(OPENING_OBJ_WORK *wk, int no, int flag)
{
	CLACT_SetDrawFlag( wk->ClActWork[no], flag );
	return;
}

//--------------------------------------------------------------
/**
 * @brief	ړ
 *
 * @param	wk		OPENING_OBJ_WORK^̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------
VecFx32 OpeningClactMove(OPENING_OBJ_WORK *wk, int no, int spd)
{
	VecFx32	vec;

	vec = *( CLACT_GetMatrix(wk->ClActWork[no]) );
	vec.x += (spd * FX32_ONE);
	CLACT_SetMatrix( wk->ClActWork[no], &vec );
	return *( CLACT_GetMatrix(wk->ClActWork[no]) );
}

//--------------------------------------------------------------
/**
 * @brief	WZbg
 *
 * @param	wk		OPENING_OBJ_WORK^̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------
void OpeningClactMoveInit(OPENING_OBJ_WORK *wk, int no )
{
	VecFx32	vec;

	vec.x = (obj_pos[no].x * FX32_ONE);
	vec.y = (obj_pos[no].y * FX32_ONE);
	CLACT_SetMatrix( wk->ClActWork[no], &vec );
	return;
}

