//==============================================================================================
/**
 * @file	opneing_obj.h
 * @brief	I[vjO OBJ
 * @author	Satoshi Nohara
 * @date	2005.12.08
 */
//==============================================================================================
#ifndef _OPENING_OBJ_H_
#define _OPENING_OBJ_H_

#include "system/clact_tool.h"


//==============================================================================================
//
//	`
//
//==============================================================================================
//CellActorɏ郊\[X}l[W̎ނ̐i}`ZE}`ZAj͎gpȂj
#define RESOURCE_NUM					(4)
#define OPENING_ACT_MAX					(2)
#define OPENING_ACT_START				(0)


//==============================================================================================
//
//	\̐錾
//
//==============================================================================================
typedef struct OPENING_OBJ_WORK_tag
{
	CLACT_SET_PTR 			ClactSet;						//ZAN^[Zbg
	CLACT_U_EASYRENDER_DATA	RendData;						//ȈՃ_[f[^
	CLACT_U_RES_MANAGER_PTR	ResMan[RESOURCE_NUM];			//\[X}l[W
	CLACT_U_RES_OBJ_PTR 	ResObjTbl[2][RESOURCE_NUM];		//\[XIuWFe[u(㉺)
	///CLACT_HEADER			ClActHeader_m;					//ZAN^[wb_[(C)
	///CLACT_HEADER			ClActHeader_s;					//ZAN^[wb_[(Tu)
	CLACT_WORK_PTR			ClActWork[OPENING_ACT_MAX];		//ZAN^[[N|C^z
}OPENING_OBJ_WORK;


//==============================================================================================
//
//	extern錾
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	ZAN^[
 *
 * @param	wk		OPENING_OBJ_WORK^̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------
extern void OpeningInitCellActor( OPENING_OBJ_WORK *wk );

//--------------------------------------------------------------
/**
 * @brief	ZAN^[Zbg
 *
 * @param	wk		OPENING_OBJ_WORK^̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------
extern void OpeningSetActor( OPENING_OBJ_WORK *wk );

//--------------------------------------------------------------
/**
 * @brief	2DZIuWFNg
 *
 * @param	wk		OPENING_OBJ_WORK^̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------
extern void OpeningRereaseCellObject(OPENING_OBJ_WORK *wk);

//--------------------------------------------------------------
/**
 * @brief	ojbV
 *
 * @param	wk		OPENING_OBJ_WORK^̃|C^
 *@param	flag	`tO	0:`	1:_`	
 *
 * @return	none
 */
//--------------------------------------------------------------
extern void OpeningClactVanish(OPENING_OBJ_WORK *wk, int no, int flag);

//--------------------------------------------------------------
/**
 * @brief	ړ
 *
 * @param	wk		OPENING_OBJ_WORK^̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------
extern VecFx32 OpeningClactMove(OPENING_OBJ_WORK *wk, int no, int spd);

//--------------------------------------------------------------
/**
 * @brief	WZbg
 *
 * @param	wk		OPENING_OBJ_WORK^̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------
extern void OpeningClactMoveInit(OPENING_OBJ_WORK *wk, int no );


#endif //_OPENING_OBJ_H_


