//============================================================================================
/**
 * @file	title.c
 * @brief	^Cg
 * @author	Hiroyuki Nakamura
 * @date	2005.02.02
 */
//============================================================================================
#include "common.h"
//#include "touchpanel_system.h"
#include "../field/fieldmap.h"
#include "system/palanm.h"
#include "system/lib_pack.h"
#include "system/snd_tool.h"
#include "system/brightness.h"
#include "system/arc_tool.h"
#include "system/arc_util.h"

#include "field/field.h"

#include "system/pm_rtc.h"

#include "test_title_gra.naix"

#include "demo/title.h"
#include "system/main.h"

#include "system/savedata.h"
#include "demo/opening/opening_sys.h"

//============================================================================================
//	V{`
//============================================================================================
#define	MAINTASK_WORK_SIZE	( 32 )


///	JڐV[`
typedef enum {
	SCENE_ID_NOT_DECIDE = 0,		///<JڐV[m
	SCENE_ID_MENU,					///<JڐV[Fʏ탁j[
	SCENE_ID_DEBUGMENU,				///<JڐV[FfobOj[
}SCENE_ID;

enum {
	TCB_WK_BLD_MAIN_CNT = 0,
	TCB_WK_BLD_SUB_CNT,
	TCB_WK_BLD_SWITCH,
	TCB_WK_START_CNT,
	TCB_WK_SEQ,
	TCB_WK_TMP,

	TCB_WK_MAX = 8
};

typedef struct {
	SCENE_ID scene;
	GF_BGL_INI * bgl;
	PALETTE_FADE_PTR pfd;
	u32	work[TCB_WK_MAX];
	u8	title_ver;
}TITLE_WORK;


//============================================================================================
//	vg^Cv錾
//============================================================================================
static void DebugVersionSet( u8 * ver );
static void VramBankSet(void);
static void BgInit( GF_BGL_INI * ini );
static void GraphicSet( GF_BGL_INI * ini, PALETTE_FADE_PTR pfd, u8 ver );
static void TitleEnd( GF_BGL_INI * ini, PALETTE_FADE_PTR pfd);

static void TitleMain(TITLE_WORK * twk);

extern void MsgSpeedSet( u8 num );





//============================================================================================
//============================================================================================

static void TitleVBlank( void * work )
{
	TITLE_WORK *twk = work;

	GF_BGL_VBlankFunc( twk->bgl );
	PaletteFadeTrans(twk->pfd);
}


static void DebugVersionSet( u8 * ver )
{
	void * buf;

	RTCTime	rtc;

	GF_RTC_GetTime( &rtc );

	if( rtc.minute & 1 ){
		*ver = 0;
	}else{
		*ver = 1;
	}
}

//--------------------------------------------------------------------------------------------
/**
 * VRAMݒ
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void VramBankSet(void)
{
	GF_BGL_DISPVRAM tbl = {
		GX_VRAM_BG_256_AB,				// C2DGWBG
		GX_VRAM_BGEXTPLTT_0123_E,		// C2DGWBGgpbg

		GX_VRAM_SUB_BG_128_C,			// Tu2DGWBG
		GX_VRAM_SUB_BGEXTPLTT_0123_H,	// Tu2DGWBGgpbg

		GX_VRAM_OBJ_NONE,				// C2DGWOBJ
		GX_VRAM_OBJEXTPLTT_NONE,		// C2DGWOBJgpbg

		GX_VRAM_SUB_OBJ_NONE,			// Tu2DGWOBJ
		GX_VRAM_SUB_OBJEXTPLTT_NONE,	// Tu2DGWOBJgpbg

		GX_VRAM_TEX_NONE,				// eNX`C[WXbg
		GX_VRAM_TEXPLTT_NONE			// eNX`pbgXbg
	};
	GF_Disp_SetBank( &tbl );
}

//--------------------------------------------------------------------------------------------
/**
 * BG
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BgInit( GF_BGL_INI * ini )
{
	{	// BG SYSTEM
		GF_BGL_SYS_HEADER BGsys_data = {
			GX_DISPMODE_GRAPHICS, GX_BGMODE_0, GX_BGMODE_0, GX_BG0_AS_2D,
		};
		GF_BGL_InitBG( &BGsys_data );
	}

	{	// MAIN DISP BG0
		GF_BGL_BGCNT_HEADER MBg0_Data = {
			0, 0, 0x800, 0,
			GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xd000, GX_BG_CHARBASE_0x00000,
			GX_BG_EXTPLTT_01, 0, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME0_M, &MBg0_Data, GF_BGL_MODE_TEXT );
	}

	{	// MAIN DISP BG1
		GF_BGL_BGCNT_HEADER MBg1_Data = {
			0, 0, 0x1000, 0,
			GF_BGL_SCRSIZ_512x256, GX_BG_COLORMODE_256,
			GX_BG_SCRBASE_0xd800, GX_BG_CHARBASE_0x10000,
			GX_BG_EXTPLTT_01, 1, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME1_M, &MBg1_Data, GF_BGL_MODE_TEXT );
	}

	{	// MAIN DISP BG2
		GF_BGL_BGCNT_HEADER MBg2_Data = {
			0, 0, 0x1000, 0,
			GF_BGL_SCRSIZ_512x256, GX_BG_COLORMODE_256,
			GX_BG_SCRBASE_0xe800, GX_BG_CHARBASE_0x20000,
			GX_BG_EXTPLTT_23, 2, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME2_M, &MBg2_Data, GF_BGL_MODE_TEXT );
	}

	{	// MAIN DISP BG3
		GF_BGL_BGCNT_HEADER MBg3_Data = {
			0, 0, 0x800, 0,
			GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_256,
			GX_BG_SCRBASE_0xf800, GX_BG_CHARBASE_0x30000,
			GX_BG_EXTPLTT_23, 3, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME3_M, &MBg3_Data, GF_BGL_MODE_TEXT );
	}

	{	// SUB DISP BG0
		GF_BGL_BGCNT_HEADER SBg0_Data = {
			0, 0, 0x800, 0,
			GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xf800, GX_BG_CHARBASE_0x00000,
			GX_BG_EXTPLTT_01, 0, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME0_S, &SBg0_Data, GF_BGL_MODE_TEXT );
	}

	{	// SUB DISP BG1
		GF_BGL_BGCNT_HEADER SBg1_Data = {
			0, 0, 0x800, 0,
			GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_256,
			GX_BG_SCRBASE_0xf000, GX_BG_CHARBASE_0x10000,
			GX_BG_EXTPLTT_01, 1, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME1_S, &SBg1_Data, GF_BGL_MODE_TEXT );
	}
}

//--------------------------------------------------------------------------------------------
/**
 * OtBbNf[^Zbg
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void LoadCharArc( GF_BGL_INI * ini, u8 frmnum, u32 arc )
{
	void * buf;
	u32	siz;

	buf = ArchiveDataLoadMalloc( ARC_TITLE, arc, HEAPID_TITLE );
	siz = ArchiveDataSizeGet(  ARC_TITLE, arc );

	GF_BGL_LoadCharacter( ini, frmnum, buf, siz, 0 );
	sys_FreeMemoryEz( buf );
}

static void LoadScreenArc( GF_BGL_INI * ini, u8 frmnum, u32 arc )
{
	void * buf;
	u32	siz;

	buf = ArchiveDataLoadMalloc( ARC_TITLE, arc, HEAPID_TITLE );
	siz = ArchiveDataSizeGet(  ARC_TITLE, arc );

	GF_BGL_ScreenBufSet( ini, frmnum, buf, siz );
	GF_BGL_LoadScreen( ini, frmnum, buf, siz, 0 );
	sys_FreeMemoryEz( buf );
}

static void GraphicSet( GF_BGL_INI * ini, PALETTE_FADE_PTR pfd, u8 ver )
{
	void * buf;
	u16 * tpal;

	if( ver == 0 ){
		// pbg
		// ㉺ʁE
		buf = ArchiveDataLoadMalloc(
				ARC_TITLE, NARC_test_title_gra_title_white_scl_dat, HEAPID_TITLE );
		PaletteFadeWorkAllocSet(pfd, FADE_MAIN_BG, FADE_PAL_ONE_SIZE, HEAPID_TITLE );
		PaletteFadeWorkAllocSet(pfd, FADE_SUB_BG, FADE_PAL_ONE_SIZE, HEAPID_TITLE );
		tpal = buf;
		tpal[0] = 0x7fff;
		tpal[1] = 0;
		PaletteWorkSet(pfd, (const void *)buf, FADE_MAIN_BG, 0, 16*2 );
		PaletteWorkSet(pfd, (const void *)buf, FADE_SUB_BG, 0, 16*2 );
		sys_FreeMemoryEz( buf );
		// ʁEu_Chv
		buf = ArchiveDataLoadMalloc(
				ARC_TITLE, NARC_test_title_gra_title_d_rogo_scl_dat, HEAPID_TITLE );
		PaletteFadeWorkAllocSet(pfd, FADE_MAIN_BG_EX1, FADE_EXPAL_ONE_SIZE, HEAPID_TITLE );
		PaletteWorkSet(pfd, (const void *)buf, FADE_MAIN_BG_EX1, 0, 16*2*2 );
		sys_FreeMemoryEz( buf );
		// ʁE^CgS
		PaletteFadeWorkAllocSet( pfd, FADE_MAIN_BG_EX2, FADE_EXPAL_ALL_SIZE, HEAPID_TITLE );
		PaletteWorkSet_Arc(
			pfd, ARC_TITLE, NARC_test_title_gra_rogo_NCLR,
			HEAPID_TITLE, FADE_MAIN_BG_EX2, 256*16*2, 0 );

		// ʁEwi
		buf = ArchiveDataLoadMalloc(
				ARC_TITLE, NARC_test_title_gra_title_d_m_back_scl_dat, HEAPID_TITLE );
		PaletteFadeWorkAllocSet(pfd, FADE_MAIN_BG_EX3, FADE_EXPAL_ONE_SIZE, HEAPID_TITLE );
		PaletteWorkSet(pfd, (const void *)buf, FADE_MAIN_BG_EX3, 0, 16*3*2 );
		sys_FreeMemoryEz( buf );
		// ʁEwi
		buf = ArchiveDataLoadMalloc(
				ARC_TITLE, NARC_test_title_gra_title_d_s_back_scl_dat, HEAPID_TITLE );
		PaletteFadeWorkAllocSet(pfd, FADE_SUB_BG_EX1, FADE_EXPAL_ONE_SIZE, HEAPID_TITLE );
		PaletteWorkSet(pfd, (const void *)buf, FADE_SUB_BG_EX1, 0, 16*3*2 );
		sys_FreeMemoryEz( buf );

		// L
		LoadCharArc( ini, GF_BGL_FRAME0_M, NARC_test_title_gra_title_start_sch_dat );
		LoadCharArc( ini, GF_BGL_FRAME1_M, NARC_test_title_gra_title_d_rogo_sch_dat );
		ArcUtil_BgCharSet(
			ARC_TITLE, NARC_test_title_gra_rogo_NCGR,
			ini, GF_BGL_FRAME2_M, 0, 0, 0, HEAPID_TITLE );
		LoadCharArc( ini, GF_BGL_FRAME3_M, NARC_test_title_gra_title_d_m_back_sch_dat );
		LoadCharArc( ini, GF_BGL_FRAME0_S, NARC_test_title_gra_title_d_mons_sch_dat );
		LoadCharArc( ini, GF_BGL_FRAME1_S, NARC_test_title_gra_title_d_s_back_sch_dat );

		// XN[
		LoadScreenArc( ini, GF_BGL_FRAME0_M, NARC_test_title_gra_title_start_ssc_dat );
		LoadScreenArc( ini, GF_BGL_FRAME1_M, NARC_test_title_gra_title_d_rogo_ssc_dat );
		ArcUtil_ScrnSet(
			ARC_TITLE, NARC_test_title_gra_rogo_NSCR,
			ini, GF_BGL_FRAME2_M, 0, 0, 0, HEAPID_TITLE );
		LoadScreenArc( ini, GF_BGL_FRAME3_M, NARC_test_title_gra_title_back_ssc_dat );
		LoadScreenArc( ini, GF_BGL_FRAME0_S, NARC_test_title_gra_title_d_mons_ssc_dat );
		LoadScreenArc( ini, GF_BGL_FRAME1_S, NARC_test_title_gra_title_back_ssc_dat );
	}else{
		// pbg
		// ㉺ʁE
		buf = ArchiveDataLoadMalloc(
				ARC_TITLE, NARC_test_title_gra_title_white_scl_dat, HEAPID_TITLE );
		PaletteFadeWorkAllocSet(pfd, FADE_MAIN_BG, FADE_PAL_ONE_SIZE, HEAPID_TITLE );
		PaletteFadeWorkAllocSet(pfd, FADE_SUB_BG, FADE_PAL_ONE_SIZE, HEAPID_TITLE );
		tpal = buf;
		tpal[0] = 0x7fff;
		tpal[1] = 0;
		PaletteWorkSet(pfd, (const void *)buf, FADE_MAIN_BG, 0, 16*2 );
		PaletteWorkSet(pfd, (const void *)buf, FADE_SUB_BG, 0, 16*2 );
		sys_FreeMemoryEz( buf );
		// ʁEup[v
		buf = ArchiveDataLoadMalloc(
				ARC_TITLE, NARC_test_title_gra_title_p_rogo_scl_dat, HEAPID_TITLE );
		PaletteFadeWorkAllocSet(pfd, FADE_MAIN_BG_EX1, FADE_EXPAL_ONE_SIZE, HEAPID_TITLE );
		PaletteWorkSet(pfd, (const void *)buf, FADE_MAIN_BG_EX1, 0, 16*2*2 );
		sys_FreeMemoryEz( buf );
		// ʁE^CgS
		PaletteFadeWorkAllocSet( pfd, FADE_MAIN_BG_EX2, FADE_EXPAL_ALL_SIZE, HEAPID_TITLE );
		PaletteWorkSet_Arc(
			pfd, ARC_TITLE, NARC_test_title_gra_rogo_NCLR,
			HEAPID_TITLE, FADE_MAIN_BG_EX2, 256*16*2, 0 );

		// ʁEwi
		buf = ArchiveDataLoadMalloc(
				ARC_TITLE, NARC_test_title_gra_title_p_m_back_scl_dat, HEAPID_TITLE );
		PaletteFadeWorkAllocSet(pfd, FADE_MAIN_BG_EX3, FADE_EXPAL_ONE_SIZE, HEAPID_TITLE );
		PaletteWorkSet(pfd, (const void *)buf, FADE_MAIN_BG_EX3, 0, 16*1*2 );
		sys_FreeMemoryEz( buf );
		// ʁEwi
		buf = ArchiveDataLoadMalloc(
				ARC_TITLE, NARC_test_title_gra_title_p_s_back_scl_dat, HEAPID_TITLE );
		PaletteFadeWorkAllocSet(pfd, FADE_SUB_BG_EX1, FADE_EXPAL_ONE_SIZE, HEAPID_TITLE );
		PaletteWorkSet(pfd, (const void *)buf, FADE_SUB_BG_EX1, 0, 16*2*2 );
		sys_FreeMemoryEz( buf );

		// L
		LoadCharArc( ini, GF_BGL_FRAME0_M, NARC_test_title_gra_title_start_sch_dat );
		LoadCharArc( ini, GF_BGL_FRAME1_M, NARC_test_title_gra_title_p_rogo_sch_dat );
		ArcUtil_BgCharSet(
			ARC_TITLE, NARC_test_title_gra_rogo_NCGR,
			ini, GF_BGL_FRAME2_M, 0, 0, 0, HEAPID_TITLE );
		LoadCharArc( ini, GF_BGL_FRAME3_M, NARC_test_title_gra_title_p_m_back_sch_dat );
		LoadCharArc( ini, GF_BGL_FRAME0_S, NARC_test_title_gra_title_p_mons_sch_dat );
		LoadCharArc( ini, GF_BGL_FRAME1_S, NARC_test_title_gra_title_p_s_back_sch_dat );

		// XN[
		LoadScreenArc( ini, GF_BGL_FRAME0_M, NARC_test_title_gra_title_start_ssc_dat );
		LoadScreenArc( ini, GF_BGL_FRAME1_M, NARC_test_title_gra_title_p_rogo_ssc_dat );
		ArcUtil_ScrnSet(
			ARC_TITLE, NARC_test_title_gra_rogo_NSCR,
			ini, GF_BGL_FRAME2_M, 0, 0, 0, HEAPID_TITLE );
		LoadScreenArc( ini, GF_BGL_FRAME3_M, NARC_test_title_gra_title_back_ssc_dat );
		LoadScreenArc( ini, GF_BGL_FRAME0_S, NARC_test_title_gra_title_p_mons_ssc_dat );
		LoadScreenArc( ini, GF_BGL_FRAME1_S, NARC_test_title_gra_title_back_ssc_dat );
	}

	PaletteFadeReq( pfd,
		PF_BIT_MAIN_BG | PF_BIT_MAIN_BG_EX3 | PF_BIT_SUB_BG | PF_BIT_SUB_BG_EX1 |
		PF_BIT_MAIN_BG_EX1 | PF_BIT_MAIN_BG_EX2,
		0xffff, 0, 16, 16, 0x7fff );

	GF_BGL_ScrollReq( ini, GF_BGL_FRAME1_M, GF_BGL_SCROLL_Y_SET, -16 );
	GF_BGL_ScrollReq( ini, GF_BGL_FRAME2_M, GF_BGL_SCROLL_Y_SET, -16 );

	GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG0, VISIBLE_OFF );
	GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG3, VISIBLE_OFF );
	GF_Disp_GXS_VisibleControl( GX_PLANEMASK_BG0, VISIBLE_OFF );
	GF_Disp_GXS_VisibleControl( GX_PLANEMASK_BG1, VISIBLE_OFF );
}


//--------------------------------------------------------------------------------------------
/**
 * I
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void TitleEnd( GF_BGL_INI * ini, PALETTE_FADE_PTR pfd)
{
	// Tuʂ̕\Zbg
	GF_Disp_GXS_VisibleControl( GX_PLANEMASK_BG0, VISIBLE_OFF );
	GF_Disp_GXS_VisibleControl( GX_PLANEMASK_BG1, VISIBLE_OFF );
	// BGLJ
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME0_M );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME1_M );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME2_M );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME3_M );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME0_S );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME1_S );

	// pbgtF[hJ
	PaletteFadeWorkAllocFree(pfd, FADE_MAIN_BG);
	PaletteFadeWorkAllocFree(pfd, FADE_MAIN_BG_EX1);
	PaletteFadeWorkAllocFree(pfd, FADE_MAIN_BG_EX2);
	PaletteFadeWorkAllocFree(pfd, FADE_MAIN_BG_EX3);
	PaletteFadeWorkAllocFree(pfd, FADE_SUB_BG);
	PaletteFadeWorkAllocFree(pfd, FADE_SUB_BG_EX1);

	sys.pVBlank = NULL;
}



//--------------------------------------------------------------------------------------------
/**
 * C^XN
 *
 * @param	_tcb
 * @param	work
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------

enum {
	TCB_SEQ_INIT = 0,

	TCB_SEQ_D_START,
	TCB_SEQ_D1,
	TCB_SEQ_D2,
	TCB_SEQ_D3,
	TCB_SEQ_D4,
	TCB_SEQ_D5,

	TCB_SEQ_P_START,
	TCB_SEQ_P1,
	TCB_SEQ_P2,
	TCB_SEQ_P3,
	TCB_SEQ_P4,
	TCB_SEQ_P5,

	TCB_SEQ_START_ON,
	TCB_SEQ_START_WAIT,
	TCB_SEQ_PUSH_START_WAIT,

	TCB_SEQ_LOOP,

	TCB_SEQ_END_BF,
	TCB_SEQ_END_BF_WAIT,

	TCB_SEQ_END_WF,
	TCB_SEQ_END_WF_WAIT,

	TCB_SEQ_END_BO,
	TCB_SEQ_END_BO_WAIT,

	TCB_SEQ_END
};

//--------------------------------------------------------------------------------------------
/**
 * ^CgʃC
 *
 * @param	twk		^Cgp[Nւ̃|C^
 *
 */
//--------------------------------------------------------------------------------------------
static void TitleMain(TITLE_WORK * twk)
{
	u32 * wk = twk->work;

#if 1
	switch( wk[TCB_WK_SEQ] ){
	case TCB_SEQ_INIT:
		SetBrightness( BRIGHTNESS_NORMAL, PLANEMASK_ALL, MASK_DOUBLE_DISPLAY);
		PaletteFadeReq( twk->pfd,
			 PF_BIT_MAIN_BG | PF_BIT_MAIN_BG_EX1 | PF_BIT_MAIN_BG_EX2, 0xffff, 0, 16, 0, 0x7fff );
		wk[TCB_WK_SEQ] = TCB_SEQ_START_WAIT;
		break;

	case TCB_SEQ_START_WAIT:
		if( PaletteFadeCheck(twk->pfd) == 0 ){
			if( wk[TCB_WK_TMP] == 0 ){
				GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG0, VISIBLE_ON );
			}else if( wk[TCB_WK_TMP] == 0x8 ){
				GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG0, VISIBLE_OFF );
			}
			wk[TCB_WK_TMP] = ( wk[TCB_WK_TMP] + 1 ) & 0xf;

			if( sys.trg & PAD_BUTTON_SELECT ){
				TitleEnd( twk->bgl, twk->pfd );
				sys_FreeMemoryEz( twk->bgl );
				PaletteFadeFree(twk->pfd);
				twk->scene = SCENE_ID_DEBUGMENU;
				return;
			}
			if((sys.trg & PAD_BUTTON_A)||(sys.trg & PAD_BUTTON_START)){
				//Jnj[
				PaletteFadeReq( twk->pfd,
					PF_BIT_MAIN_BG | PF_BIT_MAIN_BG_EX3 | PF_BIT_SUB_BG | PF_BIT_SUB_BG_EX1 |
					PF_BIT_MAIN_BG_EX1 | PF_BIT_MAIN_BG_EX2,
					0xffff, 0, 0, 16, 0 );
				wk[TCB_WK_SEQ] = TCB_SEQ_END;
				GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG0, VISIBLE_OFF );
			}
		}
		break;

	case TCB_SEQ_END:
		if( PaletteFadeCheck(twk->pfd) == 0 ){
			TitleEnd( twk->bgl, twk->pfd );
			sys_FreeMemoryEz( twk->bgl );
			PaletteFadeFree(twk->pfd);
			twk->scene = SCENE_ID_MENU;
			return;
		}
		break;
	}


#else
	switch( wk[TCB_WK_SEQ] ){
	case TCB_SEQ_INIT:
		GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG0, VISIBLE_OFF );		// START\
//		GF_BGL_ScrollReq( twk->bgl, GF_BGL_FRAME1_M, GF_BGL_SCROLL_X_SET, -192 );
//		GF_BGL_ScrollReq( twk->bgl, GF_BGL_FRAME1_M, GF_BGL_SCROLL_Y_SET, -12 );
//		GF_BGL_ScrollReq( twk->bgl, GF_BGL_FRAME2_M, GF_BGL_SCROLL_X_SET, 256 );
		SetBrightness( BRIGHTNESS_NORMAL, PLANEMASK_ALL, MASK_DOUBLE_DISPLAY);

		if( twk->title_ver == 0 ){
			wk[TCB_WK_SEQ] = TCB_SEQ_D_START;
		}else{
			wk[TCB_WK_SEQ] = TCB_SEQ_P_START;
		}
		break;

/**************** _Cho[W ****************/
	case TCB_SEQ_D_START:
		PaletteFadeReq(twk->pfd,
			PF_BIT_MAIN_BG | PF_BIT_MAIN_BG_EX3 | PF_BIT_SUB_BG | PF_BIT_SUB_BG_EX1,
			0xffff, 0, 16, 16, 0 );
		PaletteFadeReq(twk->pfd, PF_BIT_MAIN_BG_EX1 | PF_BIT_MAIN_BG_EX2, 0xffff, 0, 8, 8, 0 );
		wk[TCB_WK_SEQ] = TCB_SEQ_D1;
		wk[TCB_WK_TMP] = 0;
		break;

	case TCB_SEQ_D1:
//		if( wk[TCB_WK_TMP] == 32 ){
		if( wk[TCB_WK_TMP] == 16 ){
			PaletteFadeReq(twk->pfd, PF_BIT_SUB_BG, 0xffff, 2, 16, 0, 0 );
			wk[TCB_WK_TMP] = 0;
			wk[TCB_WK_SEQ] = TCB_SEQ_D2;
		}else{
			wk[TCB_WK_TMP]++;
		}
		break;

	case TCB_SEQ_D2:
		if( PaletteFadeCheck(twk->pfd) == 0 ){
//			if( wk[TCB_WK_TMP] == 16 ){
			if( wk[TCB_WK_TMP] == 8 ){
				wk[TCB_WK_TMP] = 0;
				wk[TCB_WK_SEQ] = TCB_SEQ_D3;
			}else{
				wk[TCB_WK_TMP]++;
			}
		}
		break;

	case TCB_SEQ_D3:
		if( wk[TCB_WK_TMP] == 256 ){
			PaletteFadeReq(twk->pfd, PF_BIT_MAIN_BG_EX2, 0xffff, 0, 16, 0, 0x7fff );
			wk[TCB_WK_TMP] = 0;
			wk[TCB_WK_SEQ] = TCB_SEQ_D4;
		}else{
//			GF_BGL_ScrollReq( twk->bgl, GF_BGL_FRAME2_M, GF_BGL_SCROLL_X_DEC, 8 );
//			GF_BGL_ScrollReq( twk->bgl, GF_BGL_FRAME2_M, GF_BGL_SCROLL_X_DEC, 16 );
//			wk[TCB_WK_TMP] += 8;
			wk[TCB_WK_TMP] += 16;
		}
		break;

	case TCB_SEQ_D4:
		if( wk[TCB_WK_TMP] == 192 ){
			PaletteFadeReq(twk->pfd, PF_BIT_MAIN_BG_EX1, 0xffff, 0, 16, 0, 0x7fff );
			wk[TCB_WK_TMP] = 0;
			wk[TCB_WK_SEQ] = TCB_SEQ_D5;
		}else{
//			GF_BGL_ScrollReq( twk->bgl, GF_BGL_FRAME1_M, GF_BGL_SCROLL_X_INC, 8 );
//			GF_BGL_ScrollReq( twk->bgl, GF_BGL_FRAME1_M, GF_BGL_SCROLL_X_INC, 16 );
//			wk[TCB_WK_TMP] += 8;
			wk[TCB_WK_TMP] += 16;
		}
		break;

	case TCB_SEQ_D5:
//		if( wk[TCB_WK_TMP] == 24 ){
		if( wk[TCB_WK_TMP] == 12 ){
			PaletteFadeReq(twk->pfd,
				PF_BIT_MAIN_BG | PF_BIT_MAIN_BG_EX3 | PF_BIT_SUB_BG_EX1,
				0xffff, 0, 16, 0, 0 );
			wk[TCB_WK_TMP] = 0;
			wk[TCB_WK_SEQ] = TCB_SEQ_START_ON;
		}else{
			wk[TCB_WK_TMP]++;
		}
		break;

/**************** p[o[W ****************/
	case TCB_SEQ_P_START:
/*
		PaletteFadeReq(twk->pfd,
			PF_BIT_MAIN_BG | PF_BIT_MAIN_BG_EX3 | PF_BIT_SUB_BG | PF_BIT_SUB_BG_EX1,
			0xffff, 0, 16, 16, 0x7fff );
		PaletteFadeReq(twk->pfd,
			 PF_BIT_MAIN_BG_EX1 | PF_BIT_MAIN_BG_EX2, 0xffff, 0, 8, 8, 0x7fff );
*/
		wk[TCB_WK_SEQ] = TCB_SEQ_P1;
		wk[TCB_WK_TMP] = 0;
		break;

	case TCB_SEQ_P1:
//		if( wk[TCB_WK_TMP] == 32 ){
		if( wk[TCB_WK_TMP] == 16 ){
			PaletteFadeReq(twk->pfd, PF_BIT_SUB_BG, 0xffff, 2, 0, 16, 0 );
			wk[TCB_WK_TMP] = 0;
			wk[TCB_WK_SEQ] = TCB_SEQ_P2;
		}else{
			wk[TCB_WK_TMP]++;
		}
		break;

	case TCB_SEQ_P2:
		if( PaletteFadeCheck(twk->pfd) == 0 ){
//			if( wk[TCB_WK_TMP] == 16 ){
			if( wk[TCB_WK_TMP] == 8 ){
				wk[TCB_WK_TMP] = 0;
				wk[TCB_WK_SEQ] = TCB_SEQ_P3;
			}else{
				wk[TCB_WK_TMP]++;
			}
		}
		break;

	case TCB_SEQ_P3:
		if( wk[TCB_WK_TMP] == 256 ){
			PaletteFadeReq(twk->pfd, PF_BIT_MAIN_BG_EX2, 0xffff, 0, 16, 0, 0 );
			wk[TCB_WK_TMP] = 0;
			wk[TCB_WK_SEQ] = TCB_SEQ_P4;
		}else{
//			GF_BGL_ScrollReq( twk->bgl, GF_BGL_FRAME2_M, GF_BGL_SCROLL_X_DEC, 8 );
//			GF_BGL_ScrollReq( twk->bgl, GF_BGL_FRAME2_M, GF_BGL_SCROLL_X_DEC, 16 );
//			wk[TCB_WK_TMP] += 8;
			wk[TCB_WK_TMP] += 16;
		}
		break;

	case TCB_SEQ_P4:
		if( wk[TCB_WK_TMP] == 192 ){
			PaletteFadeReq(twk->pfd, PF_BIT_MAIN_BG_EX1, 0xffff, 0, 16, 0, 0 );
			wk[TCB_WK_TMP] = 0;
			wk[TCB_WK_SEQ] = TCB_SEQ_P5;
		}else{
//			GF_BGL_ScrollReq( twk->bgl, GF_BGL_FRAME1_M, GF_BGL_SCROLL_X_INC, 8 );
//			GF_BGL_ScrollReq( twk->bgl, GF_BGL_FRAME1_M, GF_BGL_SCROLL_X_INC, 16 );
//			wk[TCB_WK_TMP] += 8;
			wk[TCB_WK_TMP] += 16;
		}
		break;

	case TCB_SEQ_P5:
//		if( wk[TCB_WK_TMP] == 24 ){
		if( wk[TCB_WK_TMP] == 12 ){
			PaletteFadeReq(twk->pfd,
				PF_BIT_MAIN_BG | PF_BIT_MAIN_BG_EX3 | PF_BIT_SUB_BG_EX1,
				0xffff, 0, 16, 0, 0x7fff );
			PaletteFadeReq(twk->pfd, PF_BIT_SUB_BG, 0xffff, 0, 16, 0, 0 );
			wk[TCB_WK_TMP] = 0;
			wk[TCB_WK_SEQ] = TCB_SEQ_START_ON;
		}else{
			wk[TCB_WK_TMP]++;
		}
		break;

/****************  ****************/
	case TCB_SEQ_START_ON:
		if( PaletteFadeCheck(twk->pfd) == 0 ){
			G2S_SetBlendAlpha( GX_BLEND_PLANEMASK_BG0, GX_BLEND_PLANEMASK_BG1, 16, 16 );
			GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG0, VISIBLE_ON );		// START\
			wk[TCB_WK_SEQ] = TCB_SEQ_START_WAIT;
		}
		break;

	case TCB_SEQ_START_WAIT:
		if( wk[TCB_WK_BLD_SUB_CNT] == 0 ){
			if( wk[TCB_WK_BLD_SWITCH] == 0 ){
				wk[TCB_WK_BLD_MAIN_CNT] += 1;
				if( wk[TCB_WK_BLD_MAIN_CNT] == 8 ){
					wk[TCB_WK_BLD_SWITCH] = 1;
				}
			}else{
				wk[TCB_WK_BLD_MAIN_CNT] -= 1;
				if( wk[TCB_WK_BLD_MAIN_CNT] == 0 ){
					wk[TCB_WK_BLD_SWITCH] = 0;
				}
			}

			G2S_ChangeBlendAlpha( (8+wk[TCB_WK_BLD_MAIN_CNT]), (8+wk[TCB_WK_BLD_MAIN_CNT]) );
		}
		wk[TCB_WK_BLD_SUB_CNT] = ( wk[TCB_WK_BLD_SUB_CNT] + 1 ) & 7;

		if( wk[TCB_WK_START_CNT] == 0 ){
			GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG0, VISIBLE_ON );
//		}else if( wk[TCB_WK_START_CNT] == 0x10 ){
		}else if( wk[TCB_WK_START_CNT] == 0x8 ){
			GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG0, VISIBLE_OFF );
		}
//		wk[TCB_WK_START_CNT] = ( wk[TCB_WK_START_CNT] + 1 ) & 0x1f;
		wk[TCB_WK_START_CNT] = ( wk[TCB_WK_START_CNT] + 1 ) & 0xf;

// fobO ==================================/
		if( sys.trg & PAD_BUTTON_X ){
			 twk->title_ver = 0;

			G2S_BlendNone();

			// pbgtF[hJ
			PaletteFadeWorkAllocFree(twk->pfd, FADE_MAIN_BG);
			PaletteFadeWorkAllocFree(twk->pfd, FADE_MAIN_BG_EX1);
			PaletteFadeWorkAllocFree(twk->pfd, FADE_MAIN_BG_EX2);
			PaletteFadeWorkAllocFree(twk->pfd, FADE_MAIN_BG_EX3);
			PaletteFadeWorkAllocFree(twk->pfd, FADE_SUB_BG);
			PaletteFadeWorkAllocFree(twk->pfd, FADE_SUB_BG_EX1);
			GraphicSet( twk->bgl, twk->pfd, twk->title_ver );

			wk[TCB_WK_BLD_MAIN_CNT] = 0;
			wk[TCB_WK_BLD_SUB_CNT]  = 0;
			wk[TCB_WK_BLD_SWITCH]   = 0;
			wk[TCB_WK_START_CNT]    = 0;
			wk[TCB_WK_TMP]          = 0;
			wk[TCB_WK_SEQ] = TCB_SEQ_INIT;
			break;
		}
		if( sys.trg & PAD_BUTTON_Y ){
			twk->title_ver = 1;

			G2S_BlendNone();

			// pbgtF[hJ
			PaletteFadeWorkAllocFree(twk->pfd, FADE_MAIN_BG);
			PaletteFadeWorkAllocFree(twk->pfd, FADE_MAIN_BG_EX1);
			PaletteFadeWorkAllocFree(twk->pfd, FADE_MAIN_BG_EX2);
			PaletteFadeWorkAllocFree(twk->pfd, FADE_MAIN_BG_EX3);
			PaletteFadeWorkAllocFree(twk->pfd, FADE_SUB_BG);
			PaletteFadeWorkAllocFree(twk->pfd, FADE_SUB_BG_EX1);
			GraphicSet( twk->bgl, twk->pfd, twk->title_ver );

			wk[TCB_WK_BLD_MAIN_CNT] = 0;
			wk[TCB_WK_BLD_SUB_CNT]  = 0;
			wk[TCB_WK_BLD_SWITCH]   = 0;
			wk[TCB_WK_START_CNT]    = 0;
			wk[TCB_WK_TMP]          = 0;
			wk[TCB_WK_SEQ] = TCB_SEQ_INIT;
			break;
		}
//============================================/

//		if( wk[TCB_WK_TMP] == 0x7ff ){
		if( wk[TCB_WK_TMP] == 0x3ff ){
			if( twk->title_ver == 0 ){
				PaletteFadeReq(twk->pfd,
					PF_BIT_MAIN_BG | PF_BIT_MAIN_BG_EX1 | PF_BIT_MAIN_BG_EX2 |
					PF_BIT_MAIN_BG_EX3 | PF_BIT_SUB_BG | PF_BIT_SUB_BG_EX1,
					0xffff, 0, 0, 16, 0 );
			}else{
				PaletteFadeReq(twk->pfd,
					PF_BIT_MAIN_BG | PF_BIT_MAIN_BG_EX1 | PF_BIT_MAIN_BG_EX2 |
					PF_BIT_MAIN_BG_EX3 | PF_BIT_SUB_BG | PF_BIT_SUB_BG_EX1,
					0xffff, 0, 0, 16, 0x7fff );
			}
			wk[TCB_WK_TMP] = 0;
			wk[TCB_WK_SEQ] = TCB_SEQ_LOOP;
			break;
		}else{
			wk[TCB_WK_TMP]++;
		}
		break;

	case TCB_SEQ_PUSH_START_WAIT:
		if( PaletteFadeCheck(twk->pfd) == 0 ){
			wk[TCB_WK_SEQ] = TCB_SEQ_START_WAIT;
		}
		break;

	case TCB_SEQ_LOOP:
		if( PaletteFadeCheck(twk->pfd) == 0 ){
			G2S_BlendNone();
			wk[TCB_WK_BLD_MAIN_CNT] = 0;
			wk[TCB_WK_BLD_SUB_CNT]  = 0;
			wk[TCB_WK_BLD_SWITCH]   = 0;
			wk[TCB_WK_START_CNT]    = 0;
			wk[TCB_WK_TMP]          = 0;
			wk[TCB_WK_SEQ] = TCB_SEQ_INIT;
		}
		break;

	case TCB_SEQ_END_BF:		//<<ip[j
		if( PaletteFadeCheck(twk->pfd) == 0 ){
			GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG3, VISIBLE_OFF );
			GF_Disp_GXS_VisibleControl( GX_PLANEMASK_BG1, VISIBLE_OFF );
			wk[TCB_WK_TMP] = 0;
			wk[TCB_WK_SEQ] = TCB_SEQ_END_BF_WAIT;
		}
		break;

	case TCB_SEQ_END_BF_WAIT:
//		if( wk[TCB_WK_TMP] == 0x20 ){
		if( wk[TCB_WK_TMP] == 8 ){
			PaletteFadeReq(twk->pfd,
				PF_BIT_MAIN_BG | PF_BIT_MAIN_BG_EX1 | PF_BIT_MAIN_BG_EX2 | PF_BIT_SUB_BG,
				0xffff, -4, 0, 16, 0x7fff );
			wk[TCB_WK_SEQ] = TCB_SEQ_END_WF;
		}else{
			wk[TCB_WK_TMP]++;
		}
		break;

	case TCB_SEQ_END_WF:
		if( PaletteFadeCheck(twk->pfd) == 0 ){
			wk[TCB_WK_TMP] = 0;
			wk[TCB_WK_SEQ] = TCB_SEQ_END_WF_WAIT;
		}
		break;

	case TCB_SEQ_END_WF_WAIT:
//		if( wk[TCB_WK_TMP] == 0x1f ){
		if( wk[TCB_WK_TMP] == 0xf ){
//			wk[TCB_WK_SEQ] = TCB_SEQ_END;

			ChangeBrightnessRequest(
				8, -16, 0, PLANEMASK_ALL, MASK_DOUBLE_DISPLAY);

			wk[TCB_WK_SEQ] = TCB_SEQ_END_BO;
		}else{
			wk[TCB_WK_TMP]++;
		}
		break;

	case TCB_SEQ_END_BO:
		if( IsFinishedBrightnessChg( MASK_DOUBLE_DISPLAY ) == TRUE ){
			wk[TCB_WK_TMP] = 0;
			wk[TCB_WK_SEQ] = TCB_SEQ_END;
		}
		break;
/*
	case TCB_SEQ_END_BO_WAIT:
//		if( wk[TCB_WK_TMP] == 0x1f ){
		if( wk[TCB_WK_TMP] == 0xf ){
			wk[TCB_WK_SEQ] = TCB_SEQ_END;
		}else{
			wk[TCB_WK_TMP]++;
		}
		break;
*/
	case TCB_SEQ_END:
		TitleEnd( twk->bgl, twk->pfd );
		sys_FreeMemoryEz( twk->bgl );
		PaletteFadeFree(twk->pfd);
		twk->scene = SCENE_ID_MENU;
		break;
	}

	if( sys.trg & PAD_BUTTON_SELECT ){
		TitleEnd( twk->bgl, twk->pfd );
		sys_FreeMemoryEz( twk->bgl );
		PaletteFadeFree(twk->pfd);
		twk->scene = SCENE_ID_DEBUGMENU;
		return;
	}

	if( sys.trg & PAD_BUTTON_START ){
		if( wk[TCB_WK_SEQ] >= TCB_SEQ_PUSH_START_WAIT ){
			return;
		}else if( wk[TCB_WK_SEQ] == TCB_SEQ_START_WAIT ){
			GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG0, VISIBLE_OFF );
			G2S_BlendNone();
			PaletteFadeReq(twk->pfd,
				 PF_BIT_MAIN_BG_EX3 | PF_BIT_SUB_BG_EX1, 0xffff, -1, 0, 16, 0 );
			wk[TCB_WK_SEQ] = TCB_SEQ_END_BF;
		}else{
			wk[TCB_WK_BLD_MAIN_CNT] = 0;
			wk[TCB_WK_BLD_SUB_CNT]  = 0;
			wk[TCB_WK_BLD_SWITCH]   = 0;
			wk[TCB_WK_START_CNT]    = 0;
			wk[TCB_WK_TMP]          = 0;
			wk[TCB_WK_SEQ] = TCB_SEQ_PUSH_START_WAIT;

			G2S_SetBlendAlpha( GX_BLEND_PLANEMASK_BG0, GX_BLEND_PLANEMASK_BG1, 16, 16 );
			GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG0, VISIBLE_ON );		// START\

			GF_BGL_ScrollReq( twk->bgl, GF_BGL_FRAME1_M, GF_BGL_SCROLL_X_SET, 0 );
			GF_BGL_ScrollReq( twk->bgl, GF_BGL_FRAME2_M, GF_BGL_SCROLL_X_SET, 0 );

			PaletteFadeReqWrite(twk->pfd,
				PF_BIT_MAIN_BG | PF_BIT_MAIN_BG_EX1 | PF_BIT_MAIN_BG_EX2 |
				PF_BIT_MAIN_BG_EX3 | PF_BIT_SUB_BG | PF_BIT_SUB_BG_EX1,
				0xffff, 0, 0, 0, 0 );
		}
	}
#endif

}

//============================================================================================
//============================================================================================
//--------------------------------------------------------------------------------------------
/**
 * @brief	^CgvZXF
 * @param	proc	vZXւ̃|C^
 * @param	seq		V[PXp[Nւ̃|C^
 * @return	PROC_RES_CONTINUE	p
 * @return	PROC_RES_FINISH		I
 */
//--------------------------------------------------------------------------------------------
static PROC_RESULT TitleProc_Init(PROC * proc, int * seq)
{

	sys_CreateHeap( HEAPID_BASE_APP, HEAPID_TITLE, 0x20000 );

#ifdef SOUND_OS_PRINT_ON
	OS_Printf( "^Cgf[^[h\n" );
#endif
	Snd_DataSetByScene( SND_SCENE_TITLE, SEQ_DP_TITLE, 1 );	//^CgȍĐ

	{
		TITLE_WORK * wk;

		wk = PROC_AllocWork(proc, sizeof(TITLE_WORK), HEAPID_TITLE);
		MI_CpuClear8(wk, sizeof(TITLE_WORK));
		wk->scene = SCENE_ID_NOT_DECIDE;

		wk->bgl = GF_BGL_BglIniAlloc( HEAPID_TITLE );
		wk->pfd = PaletteFadeInit(HEAPID_TITLE);

		DebugVersionSet( &wk->title_ver );
		VramBankSet();
		GF_Disp_GX_VisibleControlInit();
		BgInit( wk->bgl );
		GraphicSet( wk->bgl, wk->pfd, wk->title_ver );
		GF_Disp_DispOn();

		sys_VBlankFuncChange( TitleVBlank, (void *)wk );
	}

	MsgSpeedSet(1);

	return PROC_RES_FINISH;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief	^CgvZXFC
 * @param	proc	vZXւ̃|C^
 * @param	seq		V[PXp[Nւ̃|C^
 * @return	PROC_RES_CONTINUE	p
 * @return	PROC_RES_FINISH		I
 */
//--------------------------------------------------------------------------------------------
static PROC_RESULT TitleProc_Main(PROC * proc, int * seq)
{
	TITLE_WORK * wk = PROC_GetWork(proc);
	TitleMain(wk);
	if (wk->scene != SCENE_ID_NOT_DECIDE) {
		//̂o^ꂽI
		return PROC_RES_FINISH;
	} else {
		return PROC_RES_CONTINUE;
	}
}

FS_EXTERN_OVERLAY(d_startmenu);
//FS_EXTERN_OVERLAY(opening);
//--------------------------------------------------------------------------------------------
/**
 * @brief	^CgvZXFI
 * @param	proc	vZXւ̃|C^
 * @param	seq		V[PXp[Nւ̃|C^
 * @return	PROC_RES_CONTINUE	p
 * @return	PROC_RES_FINISH		I
 */
//--------------------------------------------------------------------------------------------
static PROC_RESULT TitleProc_End(PROC * proc, int * seq)
{
	TITLE_WORK * wk;
	SAVEDATA * sv;
	
	sv = ((MAINWORK *)PROC_GetParentWork(proc))->savedata;
	wk = PROC_GetWork(proc);
	switch (wk->scene) {
	case SCENE_ID_MENU:
#if 0
	  if (SaveData_GetExistFlag(sv)) {
	    Main_SetNextProc(FS_OVERLAY_ID(d_startmenu), &DebugStartMenuProcData);
	  } else {
	    GameData_SetNewGame(sv);
	    Main_SetNextProc(NO_OVERLAY_ID, &OpeningProcData);
	    //Main_SetNextProc(FS_OVERLAY_ID(opening), &OpeningProcData);
	  }
#else
	  Main_SetNextProc(FS_OVERLAY_ID(d_startmenu), &DebugStartMenuProcData);
#endif
		break;
	case SCENE_ID_DEBUGMENU:
		Main_SetNextProc(NO_OVERLAY_ID, &DebugTitleMenuProcData);
		break;
	}
	PROC_FreeWork(proc);
	sys_DeleteHeap( HEAPID_TITLE );

	return PROC_RES_FINISH;
}

//--------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------
const PROC_DATA TitleProcData = {
	TitleProc_Init,
	TitleProc_Main,
	TitleProc_End,
	NO_OVERLAY_ID
};





//================================================================
//================================================================
//
//
//
//
//^CgSf
//
//
//
//================================================================
//================================================================
typedef struct TITLE_DEMO_WORK_tag
{
	GF_BGL_INI * bgl;						// BGLf[^
	int work[16];

	NNSG3dRenderObj			renderobj;
	NNSG3dResMdl*			resmodel;
	NNSG3dResFileHeader* 	resfileheader;

	VecFx32 trans;	//W
	VecFx32 scale;	//XP[
	VecFx32	rotate;	//]	

	GF_CAMERA_PTR camera_p;

	u16	rotate_speed;
	u16	end_flg;
}TITLE_DEMO_WORK;

enum{
	TITLEDEMO_SEQ_MODELLOAD,//ff[^[h
	TITLEDEMO_SEQ_DISPON,	//`nm
	TITLEDEMO_SEQ_MOVE_IN,	//C
	TITLEDEMO_SEQ_MOVE_SET,	//
	TITLEDEMO_SEQ_FLUSH1,	//tbV
	TITLEDEMO_SEQ_FLUSH2,	//
	TITLEDEMO_SEQ_END,		//I
};

static void TitleLogo_VramBankSet(void);
static void TitleLogo_BGSet(void);
static PROC_RESULT Title_Logo_Demo_Init(PROC * proc, int * seq);
static PROC_RESULT Title_Logo_Demo_Main(PROC * proc, int * seq);
static PROC_RESULT Title_Logo_Demo_Exit(PROC * proc, int * seq);
static void TitleLogo_ModelLoad( TITLE_DEMO_WORK * wk );
static void TitleLogo_ModelRelease( TITLE_DEMO_WORK * wk );
static void TitleLogo3D_Draw( TITLE_DEMO_WORK * wk );

	// vZX`f[^
const PROC_DATA Title_Logo_Demo_proc_data = {
	Title_Logo_Demo_Init,
	Title_Logo_Demo_Main,
	Title_Logo_Demo_Exit,
	NO_OVERLAY_ID,
};

//extern const	PROC_DATA TitleProcData;
extern void		Main_SetNextProc(FSOverlayID ov_id, const PROC_DATA * proc_data);
//================================================================
static PROC_RESULT Title_Logo_Demo_Init(PROC * proc, int * seq)
{
	TITLE_DEMO_WORK * wk;

	sys_VBlankFuncChange( NULL, NULL );	// VBlankZbg
	sys_HBlankIntrSet( NULL,NULL );		// HBlankZbg

	TitleLogo_VramBankSet();

	GF_Disp_GX_VisibleControlInit();
	GF_Disp_GXS_VisibleControlInit();
	GX_SetVisiblePlane( 0 );
	GXS_SetVisiblePlane( 0 );
	TitleLogo_BGSet();
	GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG0 , VISIBLE_OFF );

	sys_KeyRepeatSpeedSet( 4, 8 );
	//sys_CreateHeap( HEAPID_BASE_APP, HEAPID_TITLE_DEMO, 0x20000 );
	sys_CreateHeap( HEAPID_BASE_APP, HEAPID_TITLE_DEMO, 0x100000 );

	wk = PROC_AllocWork( proc, sizeof(TITLE_DEMO_WORK), HEAPID_TITLE_DEMO );
	memset( wk, 0, sizeof(TITLE_DEMO_WORK) );
	wk->bgl = GF_BGL_BglIniAlloc( HEAPID_TITLE_DEMO );

	simple_3DBGInit( HEAPID_TITLE_DEMO );
	wk->camera_p = GFC_AllocCamera( HEAPID_TITLE_DEMO );

	GF_Disp_DispOn();

	return	PROC_RES_FINISH;
}

//----------------------------------
static PROC_RESULT Title_Logo_Demo_Main(PROC * proc, int * seq)
{
	TITLE_DEMO_WORK * wk  = PROC_GetWork( proc );

	switch(*seq){

	case TITLEDEMO_SEQ_MODELLOAD://ff[^[h

		GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG0 , VISIBLE_OFF );//[hJnFRcʂnee
		TitleLogo_ModelLoad(wk);//f[hC
		{
			//ff[^p[^
			VecFx32 init_trans	= {0,0,0x100000};
			VecFx32 init_scale	= {FX32_ONE*4, FX32_ONE*4, FX32_ONE*4};
			VecFx32 init_rotate = {0x4000, 0, 0};

			wk->trans	= init_trans;
			wk->scale	= init_scale;
			wk->rotate  = init_rotate;
		}
		{
			//Jݒ
			VecFx32	target_pos	= {0,0,0};
			VecFx32	camera_pos	= {0,0,0x100000};
			CAMERA_ANGLE angle	= {0,0,0};
			fx32	distance	= 0x100000;
			u16		perspway	= 0x05c1;

			//InitCameraTDA(&target_pos,distance,&angle,perspway,GF_CAMERA_PERSPECTIV,wk->camera_p);
			GFC_InitCameraCDA(&camera_pos,distance,&angle,perspway,GF_CAMERA_PERSPECTIV,wk->camera_p);
			GFC_SetCameraClip(0,FX32_ONE*100,wk->camera_p);	//Nbvݒ(near-far)
			GFC_SetCameraView(GF_CAMERA_PERSPECTIV,wk->camera_p);
			GFC_AttachCamera(wk->camera_p);
		}
		{
			//Cgݒ
			NNS_G3dGlbLightVector(0, FX32_ONE, FX32_ONE, FX32_ONE);
		}
		TitleLogo3D_Draw(wk);//Rc`GW
		GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG0 , VISIBLE_ON );//[hIFRcʂnm

		//PxύXZbgihmj
		ChangeBrightnessRequest (2,	//EFCg
								BRIGHTNESS_NORMAL,	// BPx
								BRIGHTNESS_BLACK,	// JnPx
								PLANEMASK_ALL,MASK_DOUBLE_DISPLAY);//Ώۖ

		*seq = TITLEDEMO_SEQ_DISPON;

		return	PROC_RES_CONTINUE;

	case TITLEDEMO_SEQ_DISPON:	//`nm

		TitleLogo3D_Draw(wk);//Rc`GW

		wk->end_flg = 0;
		if(IsFinishedBrightnessChg(MASK_DOUBLE_DISPLAY) == TRUE){	//PxύX҂
			*seq = TITLEDEMO_SEQ_MOVE_IN;
		}
		return	PROC_RES_CONTINUE;

	case TITLEDEMO_SEQ_MOVE_IN:	//C

		if((sys.trg & PAD_BUTTON_A)||(sys.trg & PAD_BUTTON_START)||(sys.trg & PAD_BUTTON_SELECT)){
			*seq = TITLEDEMO_SEQ_FLUSH2;
			break;
		}
		TitleLogo3D_Draw(wk);//Rc`GW
		{
			//]
			wk->rotate_speed = 0x200;
			wk->rotate.x += wk->rotate_speed;
			wk->rotate.y += wk->rotate_speed;
			wk->rotate.z += wk->rotate_speed;
		}
		if(wk->trans.z == (-FX32_ONE*64)){
			*seq = TITLEDEMO_SEQ_MOVE_SET;
			break;
		}
		{
			//ړ
			if(wk->trans.z != (-FX32_ONE*64)){
				wk->trans.z -= (FX32_ONE*4);
			}
		}
		return	PROC_RES_CONTINUE;

	case TITLEDEMO_SEQ_MOVE_SET:	//C

		if((sys.trg & PAD_BUTTON_A)||(sys.trg & PAD_BUTTON_START)||(sys.trg & PAD_BUTTON_SELECT)){
			*seq = TITLEDEMO_SEQ_FLUSH2;
			break;
		}
		TitleLogo3D_Draw(wk);//Rc`GW

		if(wk->end_flg == 1){
			//PxύXZbgitbVj
			ChangeBrightnessRequest (2,	//EFCg
									BRIGHTNESS_WHITE,	// BPx
									BRIGHTNESS_NORMAL,	// JnPx
									PLANEMASK_ALL,MASK_DOUBLE_DISPLAY);	//Ώۖ
			*seq = TITLEDEMO_SEQ_FLUSH1;
			break;
		}
		{
			//]
			wk->rotate_speed = 0x100;
			wk->rotate.x += wk->rotate_speed;
			wk->rotate.y += wk->rotate_speed;
			wk->rotate.z += wk->rotate_speed;

			if(((wk->rotate.y & 0xffff) == 0) && (wk->trans.z == 0)){
				wk->end_flg++;
			}
		}
		{
			//ړ
			if(wk->trans.z){
				wk->trans.z += (FX32_ONE*2);
			}
		}
		return	PROC_RES_CONTINUE;

	case TITLEDEMO_SEQ_FLUSH1:	//tbV(seq 3-4)

		TitleLogo3D_Draw(wk);//Rc`GW
		
		if(IsFinishedBrightnessChg(MASK_DOUBLE_DISPLAY) == TRUE){	//PxύX҂
			ChangeBrightnessRequest (2,	//EFCg
									BRIGHTNESS_NORMAL,	// BPx
									BRIGHTNESS_WHITE,	// JnPx
									PLANEMASK_ALL,MASK_DOUBLE_DISPLAY);	//Ώۖ
			*seq = TITLEDEMO_SEQ_FLUSH2;
		}
		return	PROC_RES_CONTINUE;

	case TITLEDEMO_SEQ_FLUSH2:	//tbV

		TitleLogo3D_Draw(wk);//Rc`GW
		
		if(IsFinishedBrightnessChg(MASK_DOUBLE_DISPLAY) == TRUE){	//PxύX҂
			//PxύXZbgintsj
			ChangeBrightnessRequest (8,	//EFCg
									BRIGHTNESS_WHITE,	// BPx
									BRIGHTNESS_NORMAL,	// JnPx
									PLANEMASK_ALL,MASK_DOUBLE_DISPLAY);	//Ώۖ
			*seq = TITLEDEMO_SEQ_END;
		}
		return	PROC_RES_CONTINUE;

	case TITLEDEMO_SEQ_END:	//I

		TitleLogo3D_Draw(wk);//Rc`GW
		
		if(IsFinishedBrightnessChg(MASK_DOUBLE_DISPLAY) == TRUE){	//PxύX҂
			TitleLogo_ModelRelease( wk );
			(*seq) = 0;
			return	PROC_RES_FINISH;
			//return	PROC_RES_CONTINUE;
		}
		return	PROC_RES_CONTINUE;
	}
	return	PROC_RES_CONTINUE;
}

//----------------------------------
static PROC_RESULT Title_Logo_Demo_Exit(PROC * proc, int * seq)
	
{
	TITLE_DEMO_WORK * wk  = PROC_GetWork( proc );

	GF_Disp_GX_VisibleControl(
		GX_PLANEMASK_BG0 | GX_PLANEMASK_BG1 | GX_PLANEMASK_BG2 |
		GX_PLANEMASK_BG3 | GX_PLANEMASK_OBJ, VISIBLE_OFF );
	GF_Disp_GXS_VisibleControl(
		GX_PLANEMASK_BG0 | GX_PLANEMASK_BG1 | GX_PLANEMASK_OBJ, VISIBLE_OFF );

	GFC_FreeCamera(wk->camera_p);
	simple_3DBGExit();
	sys_FreeMemoryEz(wk->bgl);

	PROC_FreeWork( proc );				// [NJ

	sys_VBlankFuncChange( NULL, NULL );		// VBlankZbg
	sys_DeleteHeap( HEAPID_TITLE_DEMO );

	Main_SetNextProc(NO_OVERLAY_ID, &TitleProcData);
	return	PROC_RES_FINISH;
}

//----------------------------------
//uq`lݒ
//----------------------------------
static void TitleLogo_VramBankSet(void)
{
	GF_BGL_DISPVRAM vramSetTable = {
		GX_VRAM_BG_128_C,				// C2DGWBG
		GX_VRAM_BGEXTPLTT_NONE,			// C2DGWBGgpbg
		GX_VRAM_SUB_BG_32_H,			// Tu2DGWBG
		GX_VRAM_SUB_BGEXTPLTT_NONE,		// Tu2DGWBGgpbg
		GX_VRAM_OBJ_16_F,				// C2DGWOBJ
		GX_VRAM_OBJEXTPLTT_NONE,		// C2DGWOBJgpbg
		GX_VRAM_SUB_OBJ_16_I,			// Tu2DGWOBJ
		GX_VRAM_SUB_OBJEXTPLTT_NONE,	// Tu2DGWOBJgpbg
		GX_VRAM_TEX_01_AB,				// eNX`C[WXbg
		GX_VRAM_TEXPLTT_0123_E			// eNX`pbgXbg
	};
	GF_Disp_SetBank( &vramSetTable );
}

//----------------------------------
//afݒ
//----------------------------------
static void TitleLogo_BGSet(void)
{
	{//BG SYSTEM
		GF_BGL_SYS_HEADER BGsys_data = {
			GX_DISPMODE_GRAPHICS,GX_BGMODE_0,GX_BGMODE_0,GX_BG0_AS_3D
		};	
		GF_BGL_InitBG(&BGsys_data);
	}
}

//----------------------------------
//Rcf[^[h֐
//----------------------------------
static void TitleLogo_ModelLoad( TITLE_DEMO_WORK * wk )
{
	simple_3DModelSet(	HEAPID_TITLE_DEMO,
						"graphic/title_logo.nsbmd",
						&wk->renderobj,
						&wk->resmodel,
						&wk->resfileheader);
}

static void TitleLogo_ModelRelease( TITLE_DEMO_WORK * wk )
{
	sys_FreeMemoryEz(wk->resfileheader);
}

//----------------------------------
//Rc`֐
//----------------------------------
static void TitleLogo3D_Draw( TITLE_DEMO_WORK * wk )
{
	MtxFx33 rotate_tmp = {FX32_ONE,0,0,0,FX32_ONE,0,0,0,FX32_ONE};

	GF_G3X_Reset();
	GFC_CameraLookAt();
#if 0
	//GbW}[LOeXg
	NNS_G3dGlbPolygonAttr(
				TMAP_MLIGHT_FLAG,			// Cg   
				GX_POLYGONMODE_MODULATE,	// ʏ̃|S[h
				GX_CULL_BACK,				// JobNs
				20,							//|SID
				8,							// At@l
				GX_POLYGON_ATTR_MISC_NONE/*GX_POLYGON_ATTR_MISC_XLU_DEPTH_UPDATE*/);
#endif
	{
		VecFx32_to_MtxFx33(	&rotate_tmp,&wk->rotate);

		simple_3DModelDraw(	&wk->renderobj,
							&wk->trans,
							&rotate_tmp,
							&wk->scale);
	}

	GF_G3_RequestSwapBuffers(GX_SORTMODE_AUTO,GX_BUFFERMODE_W);
}



