//============================================================================================
//============================================================================================
#include "common.h"
#include "fieldsys.h"
#include "fieldmap.h"
#include "talk_msg.h"

#include "system/window.h"

#define	BOARD_H_GLOBAL
#include "board.h"


//============================================================================================
//============================================================================================
struct _BOARD_WORK {
	GF_BGL_BMPWIN	win;
	u16	map;
	u8	type;
	u8	req:7;
	u8	flg:1;
};




//============================================================================================
//============================================================================================
static void BoardMake( FIELDSYS_WORK * repw );
static void BoardDelete( FIELDSYS_WORK * repw );
static BOOL BoarsScroll_Up( FIELDSYS_WORK * repw );
static BOOL BoarsScroll_Down( FIELDSYS_WORK * repw );



void * BoardWorkAlloc( u32 heap )
{
	void * buf = sys_AllocMemory( heap, sizeof(BOARD_WORK) );
	memset( buf, 0, sizeof(BOARD_WORK) );
	return buf;
}

void BoardWorkDelete( BOARD_WORK * wk )
{
	if( wk->flg != 0 ){
		GF_BGL_BmpWinDel( &wk->win );
	}
	sys_FreeMemoryEz( wk );
}

void BoardDataSet( BOARD_WORK * wk, u16 type, u16 map )
{
	wk->type = type;
	wk->map  = map;
}

void BoardSetRequest( BOARD_WORK * wk, u8 req )
{
	wk->req = req;
}

GF_BGL_BMPWIN * BoardWinGet( BOARD_WORK * wk )
{
	return &wk->win;
}

u8 BoardTypeGet( BOARD_WORK * wk )
{
	return wk->type;
}


BOOL BoardReqEndCheck( BOARD_WORK * wk )
{
	if( wk->req == BOARD_REQ_WAIT ){
		return TRUE;
	}
	return FALSE;
}

void BoardMain( FIELDSYS_WORK * repw )
{
	BOARD_WORK * wk = repw->board;

	switch( wk->req ){
	case BOARD_REQ_WAIT:	// ҋ@
		break;

	case BOARD_REQ_ADD:		// ŔEBhE쐬
		BoardMake( repw );
		wk->req = BOARD_REQ_WAIT;
		break;

	case BOARD_REQ_DOWN:	// ŔEBhE
		if( BoarsScroll_Down( repw ) == 1 ){
			wk->req = BOARD_REQ_WAIT;
		}
		break;

	case BOARD_REQ_UP:		// ŔEBhEグ
		if( BoarsScroll_Up( repw ) == 1 ){
			wk->req = BOARD_REQ_WAIT;
		}
		break;

	case BOARD_REQ_DEL:		// ŔEBhEj
		BoardDelete( repw );
		wk->req = BOARD_REQ_WAIT;
		break;
	}
}

void BoardSetDirect( FIELDSYS_WORK * repw, u8 req )
{
	BoardSetRequest( repw->board, req );
	BoardMain( repw );
}


static void BoardMake( FIELDSYS_WORK * repw )
{
	GF_BGL_ScrollSet( repw->bgl, FLD_MBGFRM_FONT, GF_BGL_SCROLL_Y_SET, -48 );

	// 쐬
	if( repw->board->flg == 0 ){
		FldBoardBmpAdd( repw->bgl, &repw->board->win, repw->board->type, FLD_MBGFRM_FONT );
		repw->board->flg = 1;
	}
	FldBoardWinPut( &repw->board->win, repw->board->type, repw->board->map );
}

static void BoardDelete( FIELDSYS_WORK * repw )
{
	if( repw->board->flg == 0 ){ return; }	// 쐬

	GF_BGL_BmpWinDel( &repw->board->win );
	GF_BGL_ScrFill( repw->bgl, FLD_MBGFRM_FONT, 0, 0, 18, 32, 6, GF_BGL_SCRWRT_PALNL );
	GF_BGL_LoadScreenReq( repw->bgl, FLD_MBGFRM_FONT );
	GF_BGL_ScrollSet( repw->bgl, FLD_MBGFRM_FONT, GF_BGL_SCROLL_Y_SET, 0 );

	repw->board->flg = 0;
}

static BOOL BoarsScroll_Up( FIELDSYS_WORK * repw )
{
	int	scroll = GF_BGL_ScrollGetY( repw->bgl, FLD_MBGFRM_FONT );

	if( scroll == 0 ){ return 1; }

	if( !( scroll > -48 && scroll < 0 ) ){
		GF_BGL_ScrollSet( repw->bgl, FLD_MBGFRM_FONT, GF_BGL_SCROLL_Y_SET, -48 );
	}

	GF_BGL_ScrollSet( repw->bgl, FLD_MBGFRM_FONT, GF_BGL_SCROLL_Y_INC, 16 );

	return 0;
}

static BOOL BoarsScroll_Down( FIELDSYS_WORK * repw )
{
	int	scroll = GF_BGL_ScrollGetY( repw->bgl, FLD_MBGFRM_FONT );

	if( scroll == -48 ){
		GF_BGL_ScrFill( repw->bgl, FLD_MBGFRM_FONT, 0, 0, 18, 32, 6, GF_BGL_SCRWRT_PALNL );
		GF_BGL_LoadScreenReq( repw->bgl, FLD_MBGFRM_FONT );
		GF_BGL_ScrollSet( repw->bgl, FLD_MBGFRM_FONT, GF_BGL_SCROLL_Y_SET, 0 );
		return 1;
	}

	if( !( scroll > -48 && scroll < 0 ) ){
		GF_BGL_ScrollSet( repw->bgl, FLD_MBGFRM_FONT, GF_BGL_SCROLL_Y_SET, 0 );
	}

	GF_BGL_ScrollSet( repw->bgl, FLD_MBGFRM_FONT, GF_BGL_SCROLL_Y_DEC, 16 );

	return 0;
}

