//=============================================================================
/**
 * @file	comm_command_field.c
 * @brief	f[^𑗂邽߂̃R}he[uĂ܂
 *          tB[hpł
 *          comm_command_field.h  enum ƓтłKv܂
 * @author	Katsumi Ohno
 * @date    2005.11.07
 */
//=============================================================================

#include "common.h"
#include "communication/communication.h"
#include "comm_command_field.h"

#include "field/fieldsys.h" //FIELDSYS_WORK
#include "system/mystatus.h"
#include "system/pms_data.h"

// R[obN֐
#include "underground/ug_manager.h"
#include "comm_union.h"
#include "poketool/poke_tool.h"

//==============================================================================
//  e[uɏ֐̒`
//==============================================================================

//==============================================================================
//  static`
//==============================================================================
static int _getVariable(void);
static int _getZero(void);
static int _getOne(void);



//==============================================================================
//	e[u錾
//  comm_shar.h  enum ƓȂтɂĂ
//  CALLBACKĂ΂ꂽȂꍇNULLĂ
//  R}h̃TCYԂ֐Ă炦ƒʐMyȂ܂
//  _getZero̓TCYȂԂ܂B_getVariable͉σf[^gpɎg܂
//==============================================================================
static const CommPacketTbl _CommPacketTbl[] = {
   _SET(NULL,                        _getOne ,     "CS_YES_TO")
   _SET(NULL,                        _getOne ,      "CS_NO_TO")
   _SET(CommPlayerRecvPlace,         CommPlayerGetRecvPlaceSize ,  "CF_PLAYER_POS")
   _SET(CommPlayerRecvIDPlace,       CommPlayerGetRecvIDPlaceSize ,  "CF_PLAYER_POS_ID")
   _SET(CommPlayerRecvTalk,          _getVariable,  "CF_TALK_DISP")
   _SET(CommPlayerRecvTalk_ServerSide,     _getVariable,  "CF_TALK_DISP_SERVER_SIDE")
   _SET(CommPlayerRecvFixedTalk,             CommPlayerRecvFixedTalkSize,  "CF_FIXED_TALK")
   _SET(CommPlayerRecvFixedTalk_ServerSide,  CommPlayerRecvFixedTalkSize,  "CF_FIXED_TALK_SERVER_SIDE")
   _SET(CommPlayerRecvCheckFieldMenuOpen, _getZero,  "CF_CHECK_FIELDMENU_OPEN")
   _SET(CommUnderRecvCheckAbutton,    _getZero,  "CF_CHECK_ABUTTON_ACTION")
   _SET(CommPlayerRecvResultFieldMenuOpen, _getVariable,    "CF_RESULT_FIELDMENU_OPEN")
   _SET(CommPlayerRecvResultUGMenuOpen,    _getVariable,    "CF_RESULT_UGMENU_OPEN")
   _SET(CommTrapInfoRecvTrapData,    _getOne,  "CF_TRAP_DATA")
   _SET(CommTrapInfoRecvTrapDataDel, CommTrapInfoGetTrapDataDelSize,   "CF_TRAP_DATA_DEL")
   _SET(CommTrapInfoRecvTrapDataResult,    CommTrapInfoGetTrapDataResultSize,  "CF_TRAP_DATA_RESULT")
   _SET(CommTrapInfoRecvArrayData,   CommTrapInfoGetTrapDataSize ,"CF_TRAP_ARRAY_DATA")
   _SET(CommTrapInfoRecvServerPosData,     CommTrapInfoGetTrapPosSize ,"CF_TRAP_SERVER_DATA")
   _SET(CommTrapInfoRecvResult,      CommTrapInfoGetResultSize , "CF_TRAP_ARRAY_RESULT")
   _SET(CommTrapRecvStart,           CommTrapGetStartSize ,      "CF_TRAP_START")
   _SET(CommTrapRecvPriEnd,           _getOne,      "CF_TRAP_PRIEND")
   _SET(CommTrapRecvEnd,             _getOne ,      "CF_TRAP_END")
   _SET(CommTrapRecvEndResult,       CommTrapGetEndResultSize,      "CF_TRAP_END_RESULT")
   _SET(CommTrapRecvRelease,         CommTrapGetReleaseSize,      "CF_TRAP_RELEASE")
   _SET(CommTrapInfoRecvTouch,       CommTrapInfoGetTouchSize ,  "CF_TOUCH_GROUND")
   _SET(UgManagerRecvTouchResult1, _getVariable ,              "CF_TOUCH_RESULT1")
   _SET(UgManagerRecvTouchResult2, _getVariable ,              "CF_TOUCH_RESULT2")
   _SET(CommTrapInfoRecvTrapDefuse,    CommTrapInfoRecvTrapDefuseSize,  "CF_TRAP_DEFUSE")
   _SET(CommPlayerRecvDelete,        _getOne,                     "CF_PLAYER_DELETE")
   _SET(CommSecretBaseInfoRecvData,  CommSecretBaseInfoGetDataSize, "CF_SECRETBASE_DATA")
   _SET(CommSecretBaseInfoRecvDataServer,   CommSecretBaseInfoGetDataSize ,    "CF_SECRETBASE_DATA_SERVER")
   _SET(CommSecretBaseInfoRecvPos,    CommSecretBaseInfoGetPosSize,  "CF_SECRETBASE_POS")
   _SET(CommSecretBaseInfoRecvJumpEnd,   _getZero,  "CF_SECRETBASE_JUMP_END")
   _SET(CommSecretBaseInfoRecvRetJump,   CommSecretBaseInfoGetRetJumpSize,"CF_SECRETBASE_RETJUMP")
   _SET(UgSecretBaseRecvJumpEvent,   UgSecretBaseRecvJumpEventSize,"CF_SECRETBASE_EVENT_START")
   _SET(UgSecretBaseRecvJumpEventRes,   UgSecretBaseRecvJumpEventResSize,"CF_SECRETBASE_EVENT_RES")
   _SET(UgSecretBaseRecvGoodsCheck,   _getOne,"CF_SECRETBASE_GOODS_CHECK")
   _SET(CommPlayerRecvMoveControl,   _getOne, "CF_MOVE_CONTROL")
   _SET(CommDigRecvStoneData,        CommDigGetStoneDataSize,  "CF_DIG_STONE_DATA")
   _SET(CommDigStoneRecvPickUp,      CommDigStoneDataResultSize,"CF_DIG_STONE_PICKUP")
   _SET(CommDigStoneRecvBuryData,    CommDigStoneDataResultSize,  "CF_BURY_STONE_DATA")
   _SET(CommDigStoneRecvBuryDataResult,CommDigStoneDataResultSize,  "CF_BURY_STONE_DATA_RESULT")
   _SET(CommFossilRecvFind,     _getOne,  "CF_FIND_FOSSIL")
   _SET(CommFossilRecvDigStartReq,     _getZero,  "CF_DIG_FOSSIL_START_REQ")
   _SET(CommFossilRecvDigStart,     _getOne,  "CF_DIG_FOSSIL_START")
   _SET(CommFossilRecvDigEndReq,     _getZero,  "CF_DIG_FOSSIL_END_REQ")
   _SET(CommFossilRecvDigEnd,        _getOne,  "CF_DIG_FOSSIL_START")
   _SET(CommFossilRecvDigPos,  CommFossilGetDigPosSize ,  "CF_DIG_FOSSIL_POS")
   _SET(CommFossilRecvDigPosReturn,  CommFossilGetDigPosReturnSize ,"CF_DIG_FOSSIL_POS_RETURN")
   _SET(CommUnderTalkRecvAskSeq,  CommUnderTalkGetSeqCommandSize,   "CF_ASKSEQ_SET")
   _SET(CommUnderTalkRecvTalkSeq, CommUnderTalkGetSeqCommandSize,   "CF_TALKSEQ_SET")
   _SET(CommUnderTalkRecvAskSeqCall,  CommUnderTalkGetSeqCommandSize,   "CF_ASKSEQ_SET_CALL")
   _SET(CommUnderTalkRecvTalkSeqCall, CommUnderTalkGetSeqCommandSize,   "CF_TALKSEQ_SET_CALL")
   _SET(CommUnderTalkRecvSendItem,     CommUnderTalkGetSendItemSize,   "CF_SEND_ITEM")
   _SET(CommUnderTalkRecvSendItemCall, CommUnderTalkGetSendItemSize,   "CF_SEND_ITEM_CALL")
   _SET(UgTalkRecvSecretQ,     UgTalkGetSecretQSize,   "CF_SECRET_QUESTION")
   _SET(UgTalkRecvSecretQCall, UgTalkGetSecretQSize,   "CF_SECRET_QUESTION_CALL")
   _SET(UgRecordRecvTargetData,     _getVariable,   "CF_TARGET_RECORD")
   _SET(UgRecordRecvTargetDataCall, _getVariable,   "CF_TARGET_RECORD_CALL")
   _SET(CommUnderPCRecvAccess,  CommUnderPCGetAccessSize,   "CF_PC_ACCESS")
   _SET(CommPlayerRecvFlagState,  _getOne,   "CF_FLAG_STATE")
   _SET(CommPlayerRecvFlagStateServerRet,  CommPlayerRecvFlagStateServerRetGetSize,   "CF_FLAG_STATE_RET")
   _SET(CommSecretBaseRecvDrillStart,   _getOne,    "CF_DRILL_START")
   _SET(CommSecretBaseRecvDrillStartResult,   CommSecretBaseDrillStartResultSize,    "CF_DRILL_START_RESULT")

   _SET(CommUnionRecvStatus,  MyStatus_GetWorkSize,	 "CU_PLAYER_STATUS")
	_SET(CommUnionRecvSelect,  _getOne,                 "CU_PLAYER_SELECT")
	_SET(CommUnionRecvTalk,    _getOne,                 "CU_TALK_TALK")
	_SET(CommUnionRecvYes,     _getZero,                "CU_TALK_YES")
	_SET(CommUnionRecvNo,      _getZero,                "CU_TALK_NO")
	_SET(CommUnionStartNext,   _getOne,                 "CU_START_NEXT")
	_SET(CommUnionEndConnect,  _getZero,                "CU_END_CONNECT_SERVER")
};

//--------------------------------------------------------------
/**
 * @brief   tB[hp̃R}ȟnɏ܂
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------

void CommCommandFieldInitialize(void* pWork)
{
    int length = sizeof(_CommPacketTbl)/sizeof(CommPacketTbl);
    CommCommandInitialize(_CommPacketTbl, length, pWork);
}

//--------------------------------------------------------------
/**
 * @brief   RƂTCYԂ܂
 * @param   command         R}h
 * @retval  TCY   ςȂ COMM_VARIABLE_SIZE Zero͂OԂ
 */
//--------------------------------------------------------------
static int _getVariable(void)
{
    return COMM_VARIABLE_SIZE;
}

static int _getZero(void)
{
    return 0;
}

static int _getOne(void)
{
    return 1;
}


