//=============================================================================
/**
 * @file	comm_direct_counter.c
 * @bfief	ʐM_CNgR[i[̃JE^[
 * @author	katsumi ohno
 * @date	05/08/04
 */
//=============================================================================

#include "common.h"
#include "system/bmp_list.h"
#include "system/fontproc.h"
#include "system/bmp_menu.h"
#include "field/fieldsys.h"
//#include "system/pm_str.h"
#include "system/gamedata.h"
#include "system/window.h"

#include "communication/communication.h"
#include "comm_command_field.h"
#include "comm_field_state.h"
#include "msgdata/msg.naix"
#include "system/wordset.h"
#include "msgdata/msg_directbattlecorner.h"

#include "fieldmap.h"
#include "fld_bmp.h"
#include "talk_msg.h"
#include "field/field.h"

//==============================================================================
// extern錾
//==============================================================================

#include "comm_direct_counter.h"

//==============================================================================
// `
//==============================================================================

/// ID𕶎ɂꍇ̒
#define _ID_STR_LENGTH   (5)
/// IDobt@ɓ鎞Ɂ{l 10͑߂ɐݒ
#define _ID_STR_BUFF_LENGTH   (_ID_STR_LENGTH + 10 + EOM_SIZE)
// ؂̎NbVőlŏĂ
#define _DIRECT_CORNER_CREATURE_MAX (5)
// \e@Xg
#define _DISP_SCAN_PARENT_COUNT_MAX (5)

// e@ĨXg
#define _PARENT_MENU_LIST_WIDTH (20)
// q@\Xg̉
#define _CHILD_MENU_LIST_WIDTH (17)
// \q@Xg
#define _DISP_CONNECT_CHILD_COUNT_MAX (6)

#define _EVWIN_MSG_BUF_SIZE		(50*2)			//bZ[Wobt@TCY
#define _STRBUF_TEMP_ELEMENTS_NUM (8)

#define _CGX_COUNTER_TOP_NUM (1)
#define _CGX_COUNTER_PSUB_NUM  (_CGX_COUNTER_TOP_NUM + _PARENT_MENU_LIST_WIDTH * _DISP_SCAN_PARENT_COUNT_MAX * 2)
#define _CGX_COUNTER_CSUB_NUM  (_CGX_COUNTER_TOP_NUM + _CHILD_MENU_LIST_WIDTH * _DISP_CONNECT_CHILD_COUNT_MAX * 2)


enum{
    _TIMING_GUESTROOM = 10,    // ăQXg[ɓꍇ̃^C~Oԍ

};


enum yesno_list_e {
    _YESNO_YES_RESULT = 2,
    _YESNO_NO_RESULT,


};


typedef struct __INFO_WORK* _INFO_WORK_PTR;		// VCf[^|C^

typedef void (*INFO_FUNC_PTR)(_INFO_WORK_PTR pInfo);
typedef void (*STATE_FUNC_PTR)(TCB_PTR tcb, void* work);

// 󋵍\
typedef struct __INFO_WORK{
	STRBUF* pStrBuf[_STRBUF_TEMP_ELEMENTS_NUM]; // bZ[Wďo͂ꍇ̊i[ꏊ

    GF_BGL_BMPWIN win;		 // BMPEBhE[N
    GF_BGL_BMPWIN subWin;	 // BMPSubEBhE[N
    GF_BGL_BMPWIN talkWin;   // bpEChE[N

    WORDSET* pWordSetMain;  //[hZbg\
    WORDSET* pWordSetSub;   //[hZbg\
    WORDSET* pWordSetTalk;  //[hZbg\

    BMPLIST_WORK* lw;		 // j[[N|C^
    BMPMENU_WORK* yesNoWork; // YesNoj[[N|C^
	BMPLIST_DATA*   menulist;
    FIELDSYS_WORK* pFSys;    // tB[hVXẽ|C^
    STATE_FUNC_PTR pState;    // Xe[gŊǗ
    INFO_FUNC_PTR pFunc;         // YesNoj[YesIꍇ̓
    MSGDATA_MANAGER* msg_man;   // bZ[W}l[W[
    MYSTATUS* pMyStatus;
    MYSTATUS* pBconStatus;
    u8 bNewInfoTrg[COMM_MACHINE_MAX];
    u32 retCode;  // OɕԂR[h
    u16 curPos;              // J[\ʒu
    u16 connectIndex;
    u8 selectGameMode;
    u8 type1;
    u8 type2;
    u8 msgIndex;          // bZ[WCfbNX bZ[WI҂Ɏgp
    u8 selectChildNetID;  // ݏ̎q@ID
    u8 waitMsgCount;
    u8 bSubWin;              // SubWindowgpĂ邩ǂ
    u8 bReWrite;
} _INFO_WORK;

typedef void (*pInfoFunc)(_INFO_WORK *);



// j[ڂ̐e@i[Ăobt@

//============================================================================================
//	vg^Cv錾
//============================================================================================

// ėp`
static void _commonFunc(TCB_PTR tcb, void* work);
static void _changeState(STATE_FUNC_PTR pState);  // Xe[gύX
static void _talkStart(int messageIdx, BOOL bExpand);

static void _chkFunc(TCB_PTR tcb, void* work);

// RVA[hI
static void _gameModeMatchWaitAndListCreate(TCB_PTR tcb, void* work);
static void _gameModeMatchFunc(TCB_PTR tcb, void* work);
static void _childStart(_INFO_WORK* pInfo);
static void _parentStart(_INFO_WORK* pInfo);

static void	_parentMenuListCursor(BMPLIST_WORK * wk,u32 param,u8 mode);
static void _parentMenuListLineCallBack(BMPLIST_WORK * wk,u32 param,u8 y);

// [hI
static void _exit(_INFO_WORK* pInfo);
static void _chkFuncExit(TCB_PTR tcb, void* work);

// q@e@I
static void _selectParentWindowOpen(_INFO_WORK* pInfo);
static void _myNameAndIDDisp(_INFO_WORK* pInfo);
static void _selectParentListWaitAndListCreate(TCB_PTR tcb, void* work);
static void _selectParentListFunc(TCB_PTR tcb, void* work);
static void _selectParentSetName(_INFO_WORK* pInfo);
static void _selectParentExec(TCB_PTR tcb, void* work);

static void _waitWindowFunc(TCB_PTR tcb, void* work);
static void _selectParentCancelYesNoCheck(TCB_PTR tcb, void* work);


// e@q@ڑ҂Ă
static void _commDisconnect(void);
static void _childListWindowOpen(_INFO_WORK* pInfo);
static void _childListStartMessage(void);
static void _numDisp(_INFO_WORK* pInfo);
static void _childListLineCallBack(BMPLIST_WORK * wk,u32 param,u8 y);

static void _waitAndChildListCreate(TCB_PTR tcb, void* work);
static void _childListSelectFunc(TCB_PTR tcb, void* work);
static void _childListSelect_YesNoWait(TCB_PTR tcb, void* work);
static void _waitAndChildListSelect2(TCB_PTR tcb, void* work);
static void _waitAndChildListSelect(TCB_PTR tcb, void* work);
static void _childListFinalCheck(TCB_PTR tcb, void* work);
static void _childListFinalCheckFunc(TCB_PTR tcb, void* work);
static void _childListFinalCheckFunc2(TCB_PTR tcb, void* work);
static void _childListBCancelCheck(TCB_PTR tcb, void* work);
static void _exitBattle(TCB_PTR tcb, void* work);
static void _exitBattleFunc(TCB_PTR tcb, void* work);
static void _childListBCancelCheckFunc(TCB_PTR tcb, void* work);
static void _childListGuestRoomMessageWait(TCB_PTR tcb, void* work);
static void _waitAndYesNoMenuCreate(TCB_PTR tcb, void* work);

static void _listEnd(TCB_PTR tcb,_INFO_WORK* pInfo);
static void _yesnoMemberCheckStart(int netID, _INFO_WORK* pInfo);
static void _startParentExec(_INFO_WORK* pInfo);

static void _startChildConnectOK(_INFO_WORK* pInfo);
static void _guestRoomOKFunc(TCB_PTR tcb, void* work);
static void _guestRoomExitFunc(TCB_PTR tcb, void* work);
static void _guestRoomExitFuncEnd(TCB_PTR tcb, void* work);
static void _startChildConnectNG(_INFO_WORK* pInfo);
static void _childConnectNGFunc(TCB_PTR tcb, void* work);
static void _startChildConnectReset(_INFO_WORK* pInfo);
static void _childConnectResetFunc(TCB_PTR tcb, void* work);

// Ɉē郁bZ[W
static void _pleaseGuestRoomStart(_INFO_WORK* pInfo);

// Q[[hɂőAŏl𓾂
static int _getMaxPlayNum(void);
static int _getMinPlayNum(void);
// M[Vl𓾂
static int _getRegulationNo(void);
   

static _INFO_WORK* _pInfo = NULL;  // ̊֐̎̂|C^

// j[^XNɓo^Ăۂ̃vCIeB[
// d˂邲Ƃɂ悤ɂ邽ߒ`Ă
enum menuTaskPri_e {
    _TCB_PRI_TOP = 0,
    _MENU_TALK_PRI = _TCB_PRI_TOP,
    _MENU_SELECT_PARENT_PRI = 0,
    _MENU_WAIT_PRI = 0,
    _MENU_CHILD_LIST_PRI = 0,
    _PARENT_CONNECT_OK_PRI = 0
};

#define _TCB_COMMCHECK_PRT   (10)    ///< tB[hʐM̊Ď[`PRI

// ΂炭Ƒҋ@bZ[WɕύX
#define _CHILD_WAIT_MSG_CHANGE_TIME (30*3)


//==============================================================================
//	YesNoj[Xgpf[^
//==============================================================================
static const BMPWIN_DAT _yesNoBmpDat = {
    FLD_MBGFRM_FONT, FLD_YESNO_WIN_PX, FLD_YESNO_WIN_PY,
    FLD_YESNO_WIN_SX, FLD_YESNO_WIN_SY, FLD_YESNO_WIN_PAL, FLD_YESNO_WIN_CGX
    };


//--------------------------------------------------------------
/**
 * @brief   ʐM_CNgR[i[̃JE^[pj[  X^[g
 * @param   pMsg \bZ[W
 * @retval  none
 */
//--------------------------------------------------------------

void _talkStart(int messageIdx, BOOL bExpand)
{
    if(bExpand){
        MSGMAN_GetString( _pInfo->msg_man, messageIdx, _pInfo->pStrBuf[4] );
        WORDSET_ExpandStr( _pInfo->pWordSetTalk, _pInfo->pStrBuf[5], _pInfo->pStrBuf[4] );
    }
    else{
        MSGMAN_GetString( _pInfo->msg_man, messageIdx, _pInfo->pStrBuf[5] );
    }
    if(!GF_BGL_BmpWinAddCheck(&_pInfo->talkWin)){
        FldTalkBmpAdd( _pInfo->pFSys->bgl, &_pInfo->talkWin, FLD_MBGFRM_FONT );
    }
    FldTalkWinPut( &_pInfo->talkWin );
    _pInfo->msgIndex = FldTalkMsgStart(&_pInfo->talkWin, _pInfo->pStrBuf[5], 1);
}

//--------------------------------------------------------------
/**
 * @brief   ėpXg̍쐬
 * @param   header Xgwb_[
 * @param   x,y   JnW
 * @param   width,height  
 * @param   chrofs  LN^[ItZbg
 * @retval  none
 */
//--------------------------------------------------------------
static void _listCreate(BMPLIST_HEADER header,u8 x,u8 y,u8 width,u8 height,u16 chrofs)
{
    BMPLIST_HEADER list_h;
    //BMPEBhE
    if(!GF_BGL_BmpWinAddCheck(&_pInfo->win)){
        GF_BGL_BmpWinAdd(_pInfo->pFSys->bgl,&_pInfo->win,
                         GF_BGL_FRAME3_M, x, y, width, height, FLD_SYSFONT_PAL, chrofs);
    }
    BmpMenuWinWrite(&_pInfo->win, WINDOW_TRANS_OFF, MENU_WIN_CGX_NUM, MENU_WIN_PAL );
    list_h = header;
	list_h.list = _pInfo->menulist;
    list_h.win = &_pInfo->win;
    _pInfo->lw = BmpListSet(&list_h, 0, 0, HEAPID_FIELD);
    GF_BGL_BmpWinOn(&_pInfo->win);
}


//--------------------------------------------------------------
/**
 * @brief   ʐM_CNgR[i[̃JE^[pj[  X^[g
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------

static void _infoInitialize(FIELDSYS_WORK* pFSys)
{
    int i;
    
    GF_ASSERT_RETURN((_pInfo==NULL) && "Qdmۂ͂",);
    _pInfo = sys_AllocMemory(HEAPID_FIELD, sizeof(_INFO_WORK));
    MI_CpuFill8(_pInfo, 0, sizeof(_INFO_WORK));

    _pInfo->retCode = COMM_RETVAL_NULL;
    _pInfo->pFSys = pFSys;
    _pInfo->bSubWin = FALSE;

	// bZ[W}l[W쐬
	_pInfo->msg_man = MSGMAN_Create(
        MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_directbattlecorner_dat, HEAPID_FIELD );

    _pInfo->pMyStatus = SaveData_GetMyStatus(GameSystem_GetSaveData(_pInfo->pFSys));
    _pInfo->pBconStatus = MyStatus_AllocWork(HEAPID_FIELD);
    
    GF_BGL_BmpWinInit(&_pInfo->win);
    GF_BGL_BmpWinInit(&_pInfo->subWin);
    GF_BGL_BmpWinInit(&_pInfo->talkWin);

    _pInfo->pWordSetMain = WORDSET_Create(HEAPID_FIELD);
    _pInfo->pWordSetSub = WORDSET_Create(HEAPID_FIELD);
    _pInfo->pWordSetTalk = WORDSET_Create(HEAPID_FIELD);
    _pInfo->bReWrite = FALSE;
    for(i = 0;i < COMM_MACHINE_MAX;i++){
        _pInfo->bNewInfoTrg[i] = FALSE;
    }
    for(i = 0;i < _STRBUF_TEMP_ELEMENTS_NUM; i++){
        _pInfo->pStrBuf[i] = STRBUF_Create( _EVWIN_MSG_BUF_SIZE, HEAPID_FIELD);
    }
    
}

//--------------------------------------------------------------
/**
 * @brief   J
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------

static void _infoFinalize(void)
{
    int i;
    
    for(i = 0;i < _STRBUF_TEMP_ELEMENTS_NUM; i++){
        STRBUF_Delete(_pInfo->pStrBuf[i]);
    }
    sys_FreeMemoryEz(_pInfo->pBconStatus);

    if(_pInfo->pWordSetMain){
        WORDSET_Delete(_pInfo->pWordSetMain);
        _pInfo->pWordSetMain = NULL;
    }
    if(_pInfo->pWordSetSub){
        WORDSET_Delete(_pInfo->pWordSetSub);
        _pInfo->pWordSetSub = NULL;
    }
    if(_pInfo->pWordSetTalk){
        WORDSET_Delete(_pInfo->pWordSetTalk);
        _pInfo->pWordSetTalk = NULL;
    }

    MSGMAN_Delete( _pInfo->msg_man );
    if(_pInfo->talkWin.chrbuf != NULL){
        GF_BGL_BmpWinDel(&_pInfo->talkWin);
    }
    sys_FreeMemoryEz(_pInfo);
    _pInfo = NULL;
}

//--------------------------------------------------------------
/**
 * @brief   I
 * @param   pInfo		[Nf[^̃|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _exit(_INFO_WORK* pInfo)
{
    _pInfo->retCode = COMM_RETVAL_CANCEL;
}

//--------------------------------------------------------------
/**
 * @brief   q@X^[g
 * @param   pInfo		[Nf[^̃|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _childStart(_INFO_WORK* pInfo)
{
    CommFieldStateEnterBattleChild(pInfo->pFSys, pInfo->selectGameMode, _getRegulationNo());
}

///fobOj[e@ĨXg
static const BMPLIST_HEADER _parentMenuListHeader = {
    NULL,  // \f[^|C^
    _parentMenuListCursor,					// J[\ړƂ̃R[obN֐
    NULL,		// \Ƃ̃R[obN֐
    NULL,                   // GF_BGL_BMPWIN* win
    SCAN_PARENT_COUNT_MAX,	// Xgڐ
    _DISP_SCAN_PARENT_COUNT_MAX,	// \ő區ڐ
    0,						// x\wW
    8,						// ڕ\wW
    0,						// J[\\wW
    0,						// \xW
    FBMP_COL_BLACK,			// F
    FBMP_COL_WHITE,			// wiF
    FBMP_COL_BLK_SDW,		// eF
    0,						// Ԋuw
    16,						// Ԋux
    BMPLIST_LRKEY_SKIP,		// y[WXLbv^Cv
    FONT_SYSTEM,				// w
    0,						// afJ[\(allow)\tO(0:ON,1:OFF)
    NULL                    // work
};

//--------------------------------------------------------------
/**
 * @brief   J[\ړ̃R[obN
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------

static void	_parentMenuListCursor(BMPLIST_WORK * wk,u32 param,u8 mode)
{
    _pInfo->bReWrite = TRUE;
}

//--------------------------------------------------------------
/**
 * @brief   eꗗ̂PCR[obN
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------

static void _parentMenuListLineCallBack(BMPLIST_WORK * wk,u32 param,u8 y)
{
    int cntMax = CommMPGetParentCount();
    u16 idx=0;

    if(_pInfo->lw){
        BmpListPosGet(_pInfo->lw, &idx, NULL);
    }
    idx += y;
    
    if(idx < cntMax){
        CommMPGetParentName(idx, _pInfo->pBconStatus);
        WORDSET_RegisterNumber(_pInfo->pWordSetMain, CURRENT_PLAYER_WORD_IDX,
                               idx, 2,
                               NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT);
        WORDSET_RegisterPlayerName(_pInfo->pWordSetMain, TARGET_PLAYER_WORD_IDX,
                                   _pInfo->pBconStatus);
        MSGMAN_GetString( _pInfo->msg_man, DBCParentNameList, _pInfo->pStrBuf[1] );
        WORDSET_ExpandStr(_pInfo->pWordSetMain, _pInfo->pStrBuf[0], _pInfo->pStrBuf[1] );
        GF_STR_PrintSimple(&_pInfo->win, FONT_SYSTEM, _pInfo->pStrBuf[0], 8, y*16, 0, NULL);

        WORDSET_RegisterNumber(_pInfo->pWordSetMain, ASSAILANT_PLAYER_WORD_IDX,
                             MyStatus_GetID(_pInfo->pBconStatus) % 0x10000 , _ID_STR_LENGTH,
                             NUMBER_DISPTYPE_ZERO,  NUMBER_CODETYPE_DEFAULT);
        MSGMAN_GetString( _pInfo->msg_man, DBCParentIDList, _pInfo->pStrBuf[3] );
        WORDSET_ExpandStr(_pInfo->pWordSetMain, _pInfo->pStrBuf[2], _pInfo->pStrBuf[3] );
        GF_STR_PrintSimple( &_pInfo->win, FONT_SYSTEM, _pInfo->pStrBuf[2], 11*8, y*16, 0, NULL );
    }
}

//--------------------------------------------------------------
/**
 * @brief   e@IEChEJ
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------

static void _selectParentWindowOpen(_INFO_WORK* pInfo)
{
    int i;

    // ̖O{ID̕\
    if(!GF_BGL_BmpWinAddCheck(&_pInfo->subWin)){
        GF_BGL_BmpWinAdd(_pInfo->pFSys->bgl,&_pInfo->subWin, GF_BGL_FRAME3_M,
                         23, 2, 8, 4,
                         FLD_SYSFONT_PAL,
                         _CGX_COUNTER_PSUB_NUM);
    }
    BmpMenuWinWrite(&_pInfo->subWin, WINDOW_TRANS_OFF, MENU_WIN_CGX_NUM, MENU_WIN_PAL );
    GF_BGL_BmpWinDataFill(&_pInfo->subWin, 15 );
    GF_BGL_BmpWinOn(&_pInfo->subWin);
    pInfo->bSubWin = TRUE;

    TCB_Add(_commonFunc, pInfo, _MENU_SELECT_PARENT_PRI);
    _myNameAndIDDisp(_pInfo);

    {
        int _msgsChildSelect[]={
            DBCChildSelectTrade,
            DBCChildSelectSingle,
            DBCChildSelectDouble,
            DBCChildSelectMulti,
            DBCChildSelectMulti,
            DBCChildSelectMulti,
            DBCChildSelectNut,
            DBCChildSelectRecord,
            DBCChildSelectContest,
            };
        _talkStart(_msgsChildSelect[_pInfo->selectGameMode], FALSE);
    }
    _changeState(_selectParentListWaitAndListCreate);
}

//--------------------------------------------------------------
/**
 * @brief   OID\
 * @param   pInfo		[N\̂̃|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _myNameAndIDDisp(_INFO_WORK* pInfo)
{

    WORDSET_RegisterPlayerName( _pInfo->pWordSetSub,CURRENT_PLAYER_WORD_IDX, _pInfo->pMyStatus);
    WORDSET_RegisterNumber(_pInfo->pWordSetSub, TARGET_PLAYER_WORD_IDX,
                           MyStatus_GetID(_pInfo->pMyStatus) % 0x10000 , _ID_STR_LENGTH,
                           NUMBER_DISPTYPE_ZERO,  NUMBER_CODETYPE_DEFAULT);

    MSGMAN_GetString( _pInfo->msg_man, DBCNameAndID, _pInfo->pStrBuf[6] );
    WORDSET_ExpandStr(_pInfo->pWordSetSub, _pInfo->pStrBuf[7], _pInfo->pStrBuf[6] );

    // ̖OID\
    GF_STR_PrintSimple( &_pInfo->subWin, FONT_SYSTEM, _pInfo->pStrBuf[7], 2, 2, 0, NULL );


}

//--------------------------------------------------------------
/**
 * @brief   e@ꗗj[̎s
 * @param   tcb			TCBւ̃|C^
 * @param   pInfo		[N\̂̃|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _selectParentListWaitAndListCreate(TCB_PTR tcb, void* work)
{
    u32	ret;
    _INFO_WORK* pInfo = (_INFO_WORK*)work;

//    _myNameAndIDDisp(pInfo);
    if(FldTalkMsgEndCheck(_pInfo->msgIndex)){
		int i;
        
        _pInfo->menulist = BMP_MENULIST_Create( SCAN_PARENT_COUNT_MAX, HEAPID_FIELD );
        for(i=0; i< SCAN_PARENT_COUNT_MAX; i++){
            BMP_MENULIST_AddArchiveString( _pInfo->menulist, _pInfo->msg_man,
                                    DBCParentNoList, 0 );
		}

        _listCreate(_parentMenuListHeader, 1, 2,
                    _PARENT_MENU_LIST_WIDTH, _DISP_SCAN_PARENT_COUNT_MAX*2,
                    _CGX_COUNTER_TOP_NUM);
        _changeState(_selectParentListFunc);

    }
}

//--------------------------------------------------------------
/**
 * @brief   e@ꗗj[̎s
 * @param   tcb			TCBւ̃|C^
 * @param   pInfo		[N\̂̃|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _selectParentListFunc(TCB_PTR tcb, void* work)
{
    u32	ret;
    int i;
    _INFO_WORK* pInfo = (_INFO_WORK*)work;

    _myNameAndIDDisp(pInfo);

    if(CommIsError()){  // G[̓LZɂ
        _pInfo->retCode = COMM_RETVAL_ERROR;
        _commDisconnect();
        _listEnd(tcb, pInfo);
    }
    else{
        ret = BmpListMain(_pInfo->lw);
        switch(ret){
          case BMPLIST_NULL:
            _selectParentSetName(pInfo);
            break;
          case BMPLIST_CANCEL:
            _pInfo->retCode = COMM_RETVAL_CANCEL;
            _commDisconnect();
            _listEnd(tcb, pInfo);
            break;
          default:
            BmpListDirectPosGet(pInfo->lw, &pInfo->connectIndex);
            if(CommMPGetParentCount() > pInfo->connectIndex){
                _changeState(_selectParentExec);
            }
            break;
        }
    }
}


//--------------------------------------------------------------
/**
 * @brief   e@̖OEтɃj[ɒǉ
 * @param   pNet		lbg[N󋵍\̂̃|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _selectParentSetName(_INFO_WORK* pInfo)
{
    int i;

    if(CommMPIsScanListChange() || _pInfo->bReWrite){
        // XgɍXVȂΕ`ύXȂ
        _pInfo->bReWrite = FALSE;
        CommMPResetScanChangeFlag();
        BmpListRewrite(_pInfo->lw); // EChEĕ`
        for(i = 0; i < BmpListParamGet(_pInfo->lw,BMPLIST_ID_LINE); i++){
            _parentMenuListLineCallBack(_pInfo->lw, 0, i);
        }
    }
}

//--------------------------------------------------------------
/**
 * @brief   q@@e@ɐڑNGXgoāAҋ@
 * @param   void
 * @retval  none
 */
//--------------------------------------------------------------
static void _selectParentExec(TCB_PTR tcb, void* work)
{
    _INFO_WORK* pInfo = (_INFO_WORK*)work;

    CommMPGetParentName(pInfo->connectIndex, _pInfo->pBconStatus);
    WORDSET_RegisterPlayerName( pInfo->pWordSetTalk, TARGET_PLAYER_WORD_IDX, _pInfo->pBconStatus);
    if(_getMinPlayNum() <= 2){  //1vs1 1on1̏ꍇ
        _talkStart(DBCChildWait, TRUE);
    }
    else{
        _talkStart(DBCChildWaitMulti, TRUE);
    }
    CommFieldStateConnectBattleChild(pInfo->connectIndex);
    _changeState(_waitWindowFunc);

}

//--------------------------------------------------------------
/**
 * @brief   q@@e@ɐڑNGXgoāAҋ@Ԃ̎s
 * @param   tcb			TCBւ̃|C^
 * @param   pNet		lbg[N󋵍\̂̃|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _waitWindowFunc(TCB_PTR tcb, void* work)
{
    _INFO_WORK* pInfo = work;
    
//    if( CommRecvData(0, CS_NO_TO, NULL, &id) && (id == CommGetCurrentID())){
    if( CommListGet(COMM_PARENT_ID , _YESNO_NO_RESULT) == CommGetCurrentID() ){
        CommListReset();
        _listEnd(tcb, pInfo);
        _startChildConnectNG(pInfo);
    }
//    else if( CommRecvData(0, CS_YES_TO, NULL, &id) && (id == CommGetCurrentID()) ){
    else if( CommListGet(COMM_PARENT_ID , _YESNO_YES_RESULT) == CommGetCurrentID() ){
        CommListReset();
        // e@YESM
        OHNO_PRINT("e@YESM\n");
        _listEnd(tcb, pInfo);
        _startChildConnectOK(pInfo);
    }
    else if(CommRecvIsExit()){     // Sۂꂽꍇ
        _listEnd(tcb, pInfo);
        _startChildConnectNG(pInfo);
    }
    else if(CommIsError()){  // G[͐e@Iɖ߂
        _listEnd(tcb, pInfo);
        _talkStart(DBCConnectError, FALSE);
        _startChildConnectReset(pInfo);
    }
    else if(PAD_BUTTON_B & sys.trg){  // Q߂邩ǂ₢킹
        _talkStart(DBCMemberCancelCheck, FALSE);

        // ͂EChEo
        pInfo->yesNoWork = BmpYesNoSelectInit(_pInfo->pFSys->bgl,
                                               &_yesNoBmpDat, MENU_WIN_CGX_NUM,
                                               MENU_WIN_PAL, HEAPID_FIELD );
        _changeState(_selectParentCancelYesNoCheck);
    }
}


static void _selectParentCancelYesNoCheck(TCB_PTR tcb, void* work)
{
    _INFO_WORK* pInfo = work;
    u32	ret;
    
    ret = BmpYesNoSelectMain(pInfo->yesNoWork, HEAPID_FIELD);
    if(ret == 0){ // ͂Iꍇ
        _listEnd(tcb, pInfo);
        _talkStart(DBCMemberCancel, FALSE);
        _startChildConnectReset(pInfo);
    }
    else if(ret != BMPMENU_NULL){ // Iꍇ
        _listEnd(tcb, pInfo);
        _selectParentWindowOpen(pInfo);
    }
}

///fobOj[e@ĨXg
static const BMPLIST_HEADER _childListHeader = {
    NULL,  // \f[^|C^
    NULL,					// J[\ړƂ̃R[obN֐
    NULL,					// \Ƃ̃R[obN֐
    NULL,                   // win
    _DIRECT_CORNER_CREATURE_MAX,	// Xgڐ
    _DIRECT_CORNER_CREATURE_MAX,	// \ő區ڐ
    0,						// x\wW
    1,						// ڕ\wW
    0,						// J[\\wW
    0,						// \xW
    FBMP_COL_BLACK,			// F
    FBMP_COL_WHITE,			// wiF
    FBMP_COL_BLK_SDW,		// eF
    0,						// Ԋuw
    16,						// Ԋux
    BMPLIST_LRKEY_SKIP,		// y[WXLbv^Cv
    FONT_SYSTEM,				// w
    1,						// afJ[\(allow)\tO(0:ON,1:OFF)
    NULL                    //work
};

//--------------------------------------------------------------
/**
 * @brief   eꗗ̈ꃉCR[obN
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------

static void _childListLineCallBack(BMPLIST_WORK * wk,u32 param,u8 y)
{
    u16 idx=0;

    if(_pInfo->lw){
        BmpListPosGet(_pInfo->lw, &idx, NULL);
    }
    idx += y;
    
    if(NULL != CommInfoGetMyStatus(idx)){
        WORDSET_RegisterPlayerName( _pInfo->pWordSetMain, CURRENT_PLAYER_WORD_IDX,
                                    CommInfoGetMyStatus(idx));
        MSGMAN_GetString( _pInfo->msg_man, DBCChildList,  _pInfo->pStrBuf[1] );
        WORDSET_ExpandStr(  _pInfo->pWordSetMain,  _pInfo->pStrBuf[0],  _pInfo->pStrBuf[1] );
        GF_STR_PrintSimple(&_pInfo->win, FONT_SYSTEM,  _pInfo->pStrBuf[0], 8, y*16, 0, NULL);
        WORDSET_RegisterNumber(_pInfo->pWordSetMain, ASSAILANT_PLAYER_WORD_IDX,
                             MyStatus_GetID(CommInfoGetMyStatus(idx)), _ID_STR_LENGTH,
                             NUMBER_DISPTYPE_ZERO, NUMBER_CODETYPE_DEFAULT);
        MSGMAN_GetString( _pInfo->msg_man, DBCParentIDList,  _pInfo->pStrBuf[3] );
        WORDSET_ExpandStr( _pInfo->pWordSetMain,  _pInfo->pStrBuf[2],  _pInfo->pStrBuf[3] );
        GF_STR_PrintSimple( &_pInfo->win, FONT_SYSTEM,  _pInfo->pStrBuf[2], 9*8, y*16, 0, NULL );
    }
}



static void _parentStart(_INFO_WORK* pInfo)
{
    CommFieldStateEnterBattleParent(pInfo->pFSys, pInfo->selectGameMode, _getRegulationNo() );
    //_childListWindowOpen(pInfo);  // ڑĂq@Xg\
}

//--------------------------------------------------------------
/**
 * @brief   ؒf
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------
static void _commDisconnect(void)
{
    CommFieldStateExitBattle();
}

//==============================================================================
/**
 * ǗXe[g̕ύX
 * @param   state  ςXe[g̊֐
 * @param   time   Xe[gێ
 * @retval  none
 */
//==============================================================================

static void _changeState(STATE_FUNC_PTR pState)
{
    _pInfo->pState = pState;
}

//--------------------------------------------------------------
/**
 * @brief   ڑq@ꗗEChEJ
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------

static void _childListWindowOpen(_INFO_WORK* pInfo)
{
    int i;

    TCB_Add(_commonFunc, pInfo, _MENU_CHILD_LIST_PRI);
    _childListStartMessage();
    
    // ƁHɂ̕\
    if(!GF_BGL_BmpWinAddCheck(&_pInfo->subWin)){
        GF_BGL_BmpWinAdd(_pInfo->pFSys->bgl,&_pInfo->subWin, GF_BGL_FRAME3_M,
                         22, 2, 9, 2,
                         FLD_SYSFONT_PAL,
                         _CGX_COUNTER_CSUB_NUM);
    }
    BmpMenuWinWrite(&_pInfo->subWin, WINDOW_TRANS_OFF, MENU_WIN_CGX_NUM,
                    MENU_WIN_PAL );
    GF_BGL_BmpWinDataFill(&_pInfo->subWin, 15 );
    GF_BGL_BmpWinOn(&_pInfo->subWin);
    pInfo->bSubWin = TRUE;

    // ̃f[^𑗐M
    //CommInfoSendPokeData();
    CommInfoSetEntry(0);// ͂łɎt

    _changeState(_waitAndChildListCreate);

}

static void _childListStartMessage(void)
{
    int _msgsParentWait[]={
        DBCParentWaitTrade,
        DBCParentWaitSingle,
        DBCParentWaitDouble,
        DBCParentWaitMulti,
        DBCParentWaitMulti,
        DBCParentWaitMulti,
        DBCParentWaitNut,
        DBCParentWaitRecord,
        DBCParentWaitContest
        };
    GF_ASSERT(_pInfo->selectGameMode < (sizeof(_msgsParentWait)/sizeof(int)));
    _talkStart(_msgsParentWait[_pInfo->selectGameMode], FALSE);
}


//--------------------------------------------------------------
/**
 * @brief   l̕\
 * @param   pInfo		[N\̂̃|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _numDisp(_INFO_WORK* pInfo)
{
    int msgno,num;

    // l\
    if(CommGetConnectNum() >= _getMinPlayNum()){
        num = CommGetConnectNum();
        msgno = DBCChildPlayNum;
    }
    else{
        num = _getMinPlayNum() - CommGetConnectNum();
        msgno = DBCChildRestNum;
    }
    WORDSET_RegisterNumber( _pInfo->pWordSetSub,
                            CURRENT_PLAYER_WORD_IDX,
                            num,
                            NUM_MODE_ZERO, _ID_STR_LENGTH,
                            NUMBER_CODETYPE_DEFAULT);
    GF_BGL_BmpWinDataFill(&_pInfo->subWin, 15 );
    MSGMAN_GetString( _pInfo->msg_man, msgno,  _pInfo->pStrBuf[7]);
    WORDSET_ExpandStr( _pInfo->pWordSetSub,  _pInfo->pStrBuf[6],  _pInfo->pStrBuf[7] );
    GF_STR_PrintSimple( &_pInfo->subWin, FONT_SYSTEM,
                         _pInfo->pStrBuf[6], 2, 2, 0, NULL );
}


static void _yesnoMemberCheckStart(int netID, _INFO_WORK* pInfo)
{
    // Q[[hɂ킹Ztꗗ
    int _msgsParentCheck[]={
        DBCParentCheckTrade,
        DBCParentCheckSingle,
        DBCParentCheckDouble,
        DBCParentCheckMember,
        DBCParentCheckMember,
        DBCParentCheckMember,
        DBCParentCheckMember,
        DBCParentCheckMember,
        DBCParentCheckMember,
    };
    MYSTATUS* pMy = CommInfoGetMyStatus(netID);

    if(pMy){
        WORDSET_RegisterPlayerName( pInfo->pWordSetTalk, TARGET_PLAYER_WORD_IDX, pMy);
    }
    _talkStart(_msgsParentCheck[pInfo->selectGameMode], TRUE);
}

//--------------------------------------------------------------
/**
 * @brief   e@ꗗj[̎s
 * @param   tcb			TCBւ̃|C^
 * @param   pInfo		[N\̂̃|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _commonFunc(TCB_PTR tcb, void* work)
{
    _INFO_WORK* pInfo = (_INFO_WORK*)work;

    if(_pInfo->pState != NULL){
        STATE_FUNC_PTR state = _pInfo->pState;
        state(tcb, pInfo);
    }

}

//--------------------------------------------------------------
/**
 * @brief   bZ[WoAq@Xgo
 * @param   tcb			TCBւ̃|C^
 * @param   pInfo		[N\̂̃|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _waitAndChildListCreate(TCB_PTR tcb, void* work)
{
    _INFO_WORK* pInfo = (_INFO_WORK*)work;
    u32	ret = BMPLIST_NULL;

    _numDisp(pInfo);

    if(FldTalkMsgEndCheck(_pInfo->msgIndex)){
		int i;
        
        _pInfo->menulist = BMP_MENULIST_Create( _DISP_SCAN_PARENT_COUNT_MAX, HEAPID_FIELD );
        for(i=0; i< _DISP_SCAN_PARENT_COUNT_MAX; i++){
            BMP_MENULIST_AddArchiveString( _pInfo->menulist, _pInfo->msg_man,
                                    DBCParentNoList, 0 );
		}
        _pInfo->bReWrite = TRUE;
        for(i = 0;i < COMM_MACHINE_MAX;i++){
            _pInfo->bNewInfoTrg[i] = FALSE;
        }
        _listCreate(_childListHeader, 1, 2,
                    _CHILD_MENU_LIST_WIDTH, _DISP_CONNECT_CHILD_COUNT_MAX*2,
                    _CGX_COUNTER_TOP_NUM);
        _changeState(_childListSelectFunc);
    }
}

//--------------------------------------------------------------
/**
 * @brief   q@Xg\Ă
 * @param   tcb			TCBւ̃|C^
 * @param   pInfo		[N\̂̃|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _childListSelectFunc(TCB_PTR tcb, void* work)
{
    _INFO_WORK* pInfo = (_INFO_WORK*)work;
    u32	ret = BMPLIST_NULL;
    int i;

    _numDisp(pInfo);



    for(i = 0;i < COMM_MACHINE_MAX;i++){
        if((NULL != CommInfoGetMyStatus(i)) && !_pInfo->bNewInfoTrg[i]){
            _pInfo->bNewInfoTrg[i] = TRUE;
            _pInfo->bReWrite = TRUE;
        }
        if((NULL == CommInfoGetMyStatus(i)) && _pInfo->bNewInfoTrg[i]){
            _pInfo->bNewInfoTrg[i] = FALSE;
            _pInfo->bReWrite = TRUE;
        }
    }

    if(_pInfo->bReWrite){
        _pInfo->bReWrite = FALSE;
        BmpListRewrite(_pInfo->lw); // EChEĕ`
        for(i = 0; i < BmpListParamGet(_pInfo->lw,BMPLIST_ID_LINE); i++){
            _childListLineCallBack(_pInfo->lw, 0, i);
        }
    }
    
    ret = BmpListMain(pInfo->lw);
    if(CommInfoGetNewNameID() != INVALID_NETID){
        pInfo->selectChildNetID = CommInfoGetNewNameID();
        OHNO_PRINT("ڑɂ %d\n", pInfo->selectChildNetID);
        _yesnoMemberCheckStart(pInfo->selectChildNetID, pInfo);
        _changeState(_waitAndYesNoMenuCreate);
        return;
    }
    if(CommIsError()){  // G[̓LZɂ
        // ؒf
        _commDisconnect();
        _listEnd(tcb, pInfo);
        _pInfo->retCode = COMM_RETVAL_ERROR;
        OHNO_PRINT("e@ҋ@ɃG[\n");
    }
    else{
        switch(ret){
          case BMPLIST_NULL:
            break;
          case BMPLIST_CANCEL:  // ߂
            _changeState(_childListBCancelCheck);
            break;
          default:   // ŒlɒBĂJn̊mF
            if(_getMinPlayNum() <= CommInfoGetEntryNum()){  // ŒڑlɒB
                int _msgsParentFinalCheck[]={
                    0,
                    0,
                    0,
                    DBCFinalCheckMulti,
                    DBCFinalCheckMulti,
                    DBCFinalCheckMulti,
                    DBCFinalCheckNut,
                    DBCFinalCheckRecord,
                    DBCFinalCheckContest
                };
                _talkStart(_msgsParentFinalCheck[pInfo->selectGameMode], FALSE);
                _changeState(_childListFinalCheckFunc);
            }
            break;
        }
    }
}


//--------------------------------------------------------------
/**
 * @brief   ͂AEChEo򂷂
 * @param   tcb			TCBւ̃|C^
 * @param   pInfo		[N\̂̃|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _childListSelect_YesNoWait(TCB_PTR tcb, void* work)
{
    _INFO_WORK* pInfo = (_INFO_WORK*)work;
    u32	ret = BMPLIST_NULL;

    _numDisp(pInfo);
    
    BmpListMain(pInfo->lw);
    ret = BmpYesNoSelectMain(pInfo->yesNoWork, HEAPID_FIELD);
    if(CommIsError() ||   // G[̓LZɂ
       CommRecvIsExit()){   // q@ۂĂ
        OHNO_PRINT("e@ҋ@ɃG[\n");
        if(ret == BMPMENU_NULL){
            BmpYesNoWinDel(pInfo->yesNoWork, HEAPID_FIELD);
        }
        CommInfoDeletePlayer( pInfo->selectChildNetID ); // o^
        _talkStart(DBCConnectError, FALSE);
        _changeState(_waitAndChildListSelect2);
    }
    else if(ret == 0){ // ͂Iꍇ
        OHNO_PRINT("ڑĂ %d\n", CommInfoGetNewNameID());
        CommInfoSetEntry( pInfo->selectChildNetID );  //Gg[
        CommListSet(_YESNO_YES_RESULT, pInfo->selectChildNetID);
//        CommSendFixSizeData(CS_YES_TO, &pInfo->selectChildNetID);  // YES𑗐M
        if(_getMaxPlayNum() == CommInfoGetEntryNum()){  // ڑlɒB
            if(_getMaxPlayNum() > 2){ // lȏ̂Ƃ͍ĊmF[h
                _changeState(_childListFinalCheck);
            }
            else{
                _listEnd(tcb,pInfo);   // ̂܂܂ē
                _startParentExec(pInfo);
            }
        }
        else{
            _childListStartMessage();
            _changeState(_waitAndChildListSelect);
        }
    }
    else if(ret != BMPMENU_NULL){ // Iꍇ
        CommInfoDeletePlayer( pInfo->selectChildNetID ); // o^
        CommListSet(_YESNO_NO_RESULT, pInfo->selectChildNetID);
//        CommSendFixSizeData(CS_NO_TO, &pInfo->selectChildNetID); //NO𑗐M
        _childListStartMessage();
        _changeState(_waitAndChildListSelect);
    }
}


//--------------------------------------------------------------
/**
 * @brief   bZ[WoAҋ@ԂւB Xg͏o܂
 * @param   tcb			TCBւ̃|C^
 * @param   pInfo		[N\̂̃|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _waitAndChildListSelect2(TCB_PTR tcb, void* work)
{
    _INFO_WORK* pInfo = (_INFO_WORK*)work;
    u32	ret = BMPLIST_NULL;

    _numDisp(pInfo);
    if(FldTalkMsgEndCheck(_pInfo->msgIndex)){
        _childListStartMessage();
        _changeState(_waitAndChildListSelect);
    }

}


//--------------------------------------------------------------
/**
 * @brief   bZ[WoAҋ@ԂւB Xg͏o܂
 * @param   tcb			TCBւ̃|C^
 * @param   pInfo		[N\̂̃|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _waitAndChildListSelect(TCB_PTR tcb, void* work)
{
    _INFO_WORK* pInfo = (_INFO_WORK*)work;
    u32	ret = BMPLIST_NULL;

    _numDisp(pInfo);
    if(FldTalkMsgEndCheck(_pInfo->msgIndex)){
        _changeState(_childListSelectFunc);
    }

}

//--------------------------------------------------------------
/**
 * @brief   Q[JnĂǂ̂͂EChE
 * @param   tcb			TCBւ̃|C^
 * @param   pInfo		[N\̂̃|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _childListFinalCheck(TCB_PTR tcb, void* work)
{
    _INFO_WORK* pInfo = (_INFO_WORK*)work;
    u32	ret = BMPLIST_NULL;
    int _msgsParentFinalCheck[]={
        0,
        0,
        0,
        DBCFinalCheckMulti,
        DBCFinalCheckMulti,
        DBCFinalCheckMulti,
        DBCFinalCheckNut,
        DBCFinalCheckRecord,
        DBCFinalCheckContest
    };

    _numDisp(pInfo);

    _talkStart(_msgsParentFinalCheck[pInfo->selectGameMode], FALSE);
    _changeState(_childListFinalCheckFunc);
}

//--------------------------------------------------------------
/**
 * @brief   Q[JnĂǂ̂͂EChEҋ@
 * @param   tcb			TCBւ̃|C^
 * @param   pInfo		[N\̂̃|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _childListFinalCheckFunc(TCB_PTR tcb, void* work)
{
    _INFO_WORK* pInfo = (_INFO_WORK*)work;
    u32	ret = BMPLIST_NULL;

    _numDisp(pInfo);

    BmpListMain(pInfo->lw);

    if(FldTalkMsgEndCheck(_pInfo->msgIndex)){
        pInfo->yesNoWork = BmpYesNoSelectInit(_pInfo->pFSys->bgl,
                                               &_yesNoBmpDat,
                                               MENU_WIN_CGX_NUM, MENU_WIN_PAL, HEAPID_FIELD );
        _changeState(_childListFinalCheckFunc2);
    }
}


static void _childListFinalCheckFunc2(TCB_PTR tcb, void* work)
{
    _INFO_WORK* pInfo = (_INFO_WORK*)work;
    u32	ret = BMPLIST_NULL;

    _numDisp(pInfo);

    BmpListMain(pInfo->lw);
    ret = BmpYesNoSelectMain(pInfo->yesNoWork, HEAPID_FIELD);
    if(CommIsError()){  // G[̓LZɂ
        OHNO_PRINT("e@ҋ@ɃG[\n");
        ret = BMPLIST_CANCEL;
    }
    if(ret == 0){ // ͂Iꍇ
        _changeState(_childListGuestRoomMessageWait);
    }
    else if(ret != BMPMENU_NULL){ // Iꍇ
        _changeState(_exitBattle);
    }
}

static void _exitBattle(TCB_PTR tcb, void* work)
{
    _INFO_WORK* pInfo = (_INFO_WORK*)work;
    int msgFinalNOs[]={
        0,
        0,
        0,
        0,
        0,
        0,
        DBCNutFinalNo,
        DBCRecordFinalNo,
        DBCContestFinalNo
        };


    _listEnd(tcb,pInfo);
    _talkStart(msgFinalNOs[ pInfo->selectGameMode ], FALSE);
    CommFieldStateExitBattle();
    TCB_Add(_exitBattleFunc, pInfo, _PARENT_CONNECT_OK_PRI);
}

static void _exitBattleFunc(TCB_PTR tcb, void* work)
{
    if(FldTalkMsgEndCheck(_pInfo->msgIndex)){
        _pInfo->retCode = COMM_RETVAL_CANCEL;
        TCB_Delete(tcb);
    }
}


//--------------------------------------------------------------
/**
 * @brief   BLZŔ鎞̂͂EChE
 * @param   tcb			TCBւ̃|C^
 * @param   pInfo		[N\̂̃|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _childListBCancelCheck(TCB_PTR tcb, void* work)
{
    _INFO_WORK* pInfo = (_INFO_WORK*)work;
    u32	ret = BMPLIST_NULL;
    int _msgsParentBCancel[]={
        0,
        0,
        0,
        DBCBCancelMulti,
        DBCBCancelMulti,
        DBCBCancelMulti,
        DBCBCancelNut,
        DBCBCancelRecord,
        DBCBCancelContest,
    };

    _numDisp(pInfo);

    if(CommInfoGetEntryNum() > 1){
        // q@ꍇ ߂OɊmF
        _talkStart(_msgsParentBCancel[pInfo->selectGameMode], FALSE);
        pInfo->yesNoWork = BmpYesNoSelectInit(_pInfo->pFSys->bgl,
                                               &_yesNoBmpDat,
                                               MENU_WIN_CGX_NUM, MENU_WIN_PAL, HEAPID_FIELD );
        _changeState(_childListBCancelCheckFunc);
    }
    else{   //No^Ȃꍇǂ
        _commDisconnect();
        _listEnd(tcb, pInfo);
        _pInfo->retCode = COMM_RETVAL_CANCEL;
    }
}

//--------------------------------------------------------------
/**
 * @brief   BLZŔ鎞̂͂EChE҂
 * @param   tcb			TCBւ̃|C^
 * @param   pInfo		[N\̂̃|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _childListBCancelCheckFunc(TCB_PTR tcb, void* work)
{
    _INFO_WORK* pInfo = (_INFO_WORK*)work;
    u32	ret = BMPLIST_NULL;

    _numDisp(pInfo);

    BmpListMain(pInfo->lw);
    ret = BmpYesNoSelectMain(pInfo->yesNoWork, HEAPID_FIELD);
    if(CommIsError()){  // G[̓LZɂ
        OHNO_PRINT("e@ҋ@ɃG[\n");
        ret = BMPLIST_CANCEL;
    }
    if(ret == 0){ // ͂Iꍇ
        _commDisconnect();
        _listEnd(tcb, pInfo);
        _pInfo->retCode = COMM_RETVAL_CANCEL;
    }
    else if(ret != BMPMENU_NULL){ // Iꍇ
        _childListStartMessage();
        _changeState(_waitAndChildListSelect);
    }
}

//--------------------------------------------------------------
/**
 * @brief   o^AS̒ʐMJn҂
 * @param   tcb			TCBւ̃|C^
 * @param   pInfo		[N\̂̃|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _childListGuestRoomMessageWait(TCB_PTR tcb, void* work)
{
    _INFO_WORK* pInfo = (_INFO_WORK*)work;
    u32	ret = BMPLIST_NULL;

    _numDisp(pInfo);
    BmpListMain(pInfo->lw);
    CommTimingSyncStart(_TIMING_GUESTROOM); // QXg[ɍsM
    if(CommIsTimingSync(_TIMING_GUESTROOM)){ // Mꍇ
        _listEnd(tcb, pInfo);
        _pleaseGuestRoomStart(pInfo);
    }
}

//--------------------------------------------------------------
/**
 * @brief   bZ[Wҋ@͂EChEo
 * @param   tcb			TCBւ̃|C^
 * @param   pInfo		[N\̂̃|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _waitAndYesNoMenuCreate(TCB_PTR tcb, void* work)
{
    _INFO_WORK* pInfo = (_INFO_WORK*)work;
    u32	ret = BMPLIST_NULL;

    _numDisp(pInfo);

    BmpListMain(pInfo->lw);
    if(FldTalkMsgEndCheck(_pInfo->msgIndex)){
        pInfo->yesNoWork = BmpYesNoSelectInit(_pInfo->pFSys->bgl,
                                               &_yesNoBmpDat,
                                               MENU_WIN_CGX_NUM, MENU_WIN_PAL, HEAPID_FIELD );
        _changeState(_childListSelect_YesNoWait);
    }
}


//--------------------------------------------------------------
/**
 * @brief   q@Xg
 * @param   tcb			TCBւ̃|C^
 * @param   pInfo		[N\̂̃|C^
 * @retval  none
 */
//--------------------------------------------------------------
static void _listEnd(TCB_PTR tcb,_INFO_WORK* pInfo)
{
    GF_BGL_BmpWinDataFill( &_pInfo->talkWin, 15 );
    BmpMenuWinClear(&pInfo->win, WINDOW_TRANS_ON );
    BMP_MENULIST_Delete( pInfo->menulist );
    BmpListExit(pInfo->lw, NULL, NULL);
    GF_BGL_BmpWinOff(&pInfo->win);
    GF_BGL_BmpWinDel(&pInfo->win);

    if(pInfo->bSubWin){
        BmpMenuWinClear(&_pInfo->subWin, WINDOW_TRANS_ON );
        GF_BGL_BmpWinOff(&_pInfo->subWin);
        GF_BGL_BmpWinDel(&_pInfo->subWin);
        pInfo->bSubWin = FALSE;
    }
    if(tcb){
        TCB_Delete(tcb);
    }
}

//--------------------------------------------------------------
/**
 * @brief   I񂾐e@ɐڑɂ
 * @param   pInfo		[N\̂̃|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _startParentExec(_INFO_WORK* pInfo)
{
    WORDSET_RegisterPlayerName( pInfo->pWordSetTalk, TARGET_PLAYER_WORD_IDX, CommInfoGetMyStatus(1));
    _talkStart(DBCChildSelectOk, TRUE);

    TCB_Add(_guestRoomOKFunc, pInfo, _PARENT_CONNECT_OK_PRI);
}

//--------------------------------------------------------------
/**
 * @brief   I񂾐e@ɐڑɂ
 * @param   pInfo		[N\̂̃|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _startChildConnectOK(_INFO_WORK* pInfo)
{
    CommMPGetParentName(pInfo->connectIndex, _pInfo->pBconStatus);
    WORDSET_RegisterPlayerName( pInfo->pWordSetTalk, TARGET_PLAYER_WORD_IDX, _pInfo->pBconStatus);
    _talkStart(DBCChildConnectOK, TRUE);

    TCB_Add(_commonFunc, pInfo, _PARENT_CONNECT_OK_PRI);
    _changeState(_guestRoomOKFunc);
    _pInfo->waitMsgCount = _CHILD_WAIT_MSG_CHANGE_TIME;
}




//--------------------------------------------------------------
/**
 * @brief   S̃R}hM҂Ĉē
 * @param   pInfo		[N\̂̃|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _guestRoomOKFunc(TCB_PTR tcb, void* work)
{
    _INFO_WORK* pInfo = (_INFO_WORK*)work;

    if(CommRecvIsExit()){  // U
        _changeState(_guestRoomExitFunc);
    }
    if(FldTalkMsgEndCheck(_pInfo->msgIndex)){
        CommTimingSyncStart(_TIMING_GUESTROOM); // QXg[ɍsM
        if(CommIsTimingSync(_TIMING_GUESTROOM)){ // Mꍇ
            _pleaseGuestRoomStart(pInfo);
            TCB_Delete(tcb);
        }
        // xԂ߂烁bZ[WύX
        if(_pInfo->waitMsgCount!=0){
            _pInfo->waitMsgCount--;
            if(_pInfo->waitMsgCount==0){
                int _msgsChildOtherWait[]={
                    NULL,
                    NULL,
                    NULL,
                    DBCChildOtherWaitMulti,
                    DBCChildOtherWaitMulti,
                    DBCChildOtherWaitMulti,
                    DBCChildOtherWaitNut,
                    DBCChildOtherWaitRecord,
                    DBCChildOtherWaitContest
                };
                _talkStart(_msgsChildOtherWait[pInfo->selectGameMode], FALSE);
            }
        }
    }
}



//--------------------------------------------------------------
/**
 * @brief   QXgԂɖ߂邱ƂɂȂ
 * @param   pInfo		[N\̂̃|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _guestRoomExitFunc(TCB_PTR tcb, void* work)
{
    _INFO_WORK* pInfo = (_INFO_WORK*)work;

    if(FldTalkMsgEndCheck(_pInfo->msgIndex)){
        _talkStart(DBCConnectError, FALSE);
        _changeState(_guestRoomExitFuncEnd);
    }
}

static void _guestRoomExitFuncEnd(TCB_PTR tcb, void* work)
{
    _INFO_WORK* pInfo = (_INFO_WORK*)work;

    if(FldTalkMsgEndCheck(_pInfo->msgIndex)){
        TCB_Delete(tcb);
        _commDisconnect();
        _pInfo->retCode = COMM_RETVAL_CANCEL;
    }
}

//--------------------------------------------------------------
/**
 * @brief   NGAĂ̂ŐeIтȂ
 * @param   pInfo		[N\̂̃|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _startChildConnectNG(_INFO_WORK* pInfo)
{
    CommMPGetParentName(pInfo->connectIndex, _pInfo->pBconStatus);
    WORDSET_RegisterPlayerName( pInfo->pWordSetTalk, TARGET_PLAYER_WORD_IDX, _pInfo->pBconStatus);
    _talkStart(DBCChildConnectNG, TRUE);
    TCB_Add(_childConnectNGFunc, pInfo, _PARENT_CONNECT_OK_PRI);
//    CommSendData(CS_EXIT, NULL, 0); // S̃R}hMȂ͂ 2005.8.31
}

//--------------------------------------------------------------
/**
 * @brief   NGAĂ̂ŐeIтȂֈړ
 * @param   pInfo		[N\̂̃|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _childConnectNGFunc(TCB_PTR tcb, void* work)
{
    _INFO_WORK* pInfo = (_INFO_WORK*)work;

    if(FldTalkMsgEndCheck(_pInfo->msgIndex)){
        CommFieldStateRebootBattleChild();
        _selectParentWindowOpen(pInfo);
        TCB_Delete(tcb);
    }
}


//--------------------------------------------------------------
/**
 * @brief   G[AċNɂȂ̂ŐeIтȂ
 * @param   pInfo		[N\̂̃|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _startChildConnectReset(_INFO_WORK* pInfo)
{
    TCB_Add(_childConnectResetFunc, pInfo, _PARENT_CONNECT_OK_PRI);
    CommSendData(CS_EXIT, NULL, 0); //ؒfR}hꉞM 悤Ȃ؂
}

//--------------------------------------------------------------
/**
 * @brief   G[AĂ̂ŐeIтȂֈړ
 * @param   pInfo		[N\̂̃|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _childConnectResetFunc(TCB_PTR tcb, void* work)
{
    _INFO_WORK* pInfo = (_INFO_WORK*)work;

    if(FldTalkMsgEndCheck(_pInfo->msgIndex)){
        CommFieldStateRebootBattleChild();
        _selectParentWindowOpen(pInfo);
        TCB_Delete(tcb);
    }
}

static void _pleaseGuestRoomStart(_INFO_WORK* pInfo)
{
    _pInfo->retCode = COMM_RETVAL_OK;
    CommMPSetNoChildError(TRUE);  // NOCHILDG[L
}


//--------------------------------------------------------------
/**
 * @brief   Q[[hɕKvȍŏlA
 * @param   none
 * @retval  ŏl
 */
//--------------------------------------------------------------

int _getMinPlayNum(void)
{
    return CommGetMinEntry(_pInfo->selectGameMode);
}

//--------------------------------------------------------------
/**
 * @brief   Q[[hɕKvȍőlA
 * @param   none
 * @retval  ől
 */
//--------------------------------------------------------------

static int _getMaxPlayNum(void)
{
    return CommGetMaxEntry(_pInfo->selectGameMode);
}

//--------------------------------------------------------------
/**
 * @brief   M[Vl𓾂
 * @param   none
 * @retval  ől
 */
//--------------------------------------------------------------

static int _getRegulationNo(void)
{
    return _pInfo->type1 + (_pInfo->type2 << 4);
}

//--------------------------------------------------------------
/**
 * @brief   Xg
 * @param   pInfo		[N\̂̃|C^
 * @retval  none
 */
//--------------------------------------------------------------
//static void _windowDestroy(_INFO_WORK* pInfo)
//{
  //  GF_BGL_BmpWinDel(&pInfo->talkWin);
//}

//--------------------------------------------------------------
/**
 * @brief   e@IEChEJ
 * @param   FIELDSYS_WORK* pFSys   tB[hVXe[N|C^
 * @param   connectMode      ʐM[h
 * @param   type1            M[V    N
 * @param   type2            ReXg
 * @retval  none
 */
//--------------------------------------------------------------

void CommSelectParentWindowOpen(FIELDSYS_WORK* pFSys,
                                    int connectMode,int type1,int type2)
{
    _infoInitialize(pFSys);
    _pInfo->selectGameMode = connectMode;
    _pInfo->type1 = type1;
    _pInfo->type2 = type2;
    _childStart(_pInfo);
}


void CommParentSelectParentWindowOpen(void)
{
   _selectParentWindowOpen(_pInfo);
}

//--------------------------------------------------------------
/**
 * @brief   e@IEChE
 * @param   none
 * @retval  COMM_RETVAL_NULL    BMPLIST_NULL      I
            COMM_RETVAL_CANCEL  BMPLIST_CANCEL    userLZ
            COMM_RETVAL_OK      (0)               I
            COMM_RETVAL_ERROR   (1)               ʐMG[
 */
//--------------------------------------------------------------

u32 CommSelectParentWindowCheck(void)
{
    u32 ret = _pInfo->retCode;

    if(COMM_RETVAL_NULL != ret){
        OHNO_PRINT("lԂ %d\n",ret);
        _infoFinalize();
    }
    return ret;
}

//--------------------------------------------------------------
/**
 * @brief   q@ꗗEChEJ
 * @param   FIELDSYS_WORK* pFSys   tB[hVXe[N|C^
 * @param   connectMode      ʐM[h
 * @param   type1            M[V    N
 * @param   type2            ReXg
 * @retval  none
 */
//--------------------------------------------------------------

void CommChildWindowOpen(FIELDSYS_WORK* pFSys,
                         int connectMode,int type1,int type2)
{
    _infoInitialize(pFSys);
    _pInfo->selectGameMode = connectMode;
    _pInfo->type1 = type1;
    _pInfo->type2 = type2;
    _parentStart(_pInfo);
}

void CommChildListWindowOpen(void)
{
    _childListWindowOpen(_pInfo);  // ڑĂq@Xg\
}


//--------------------------------------------------------------
/**
 * @brief   e@IEChE
 * @param   none
 * @retval  COMM_RETVAL_NULL    BMPLIST_NULL      I
            COMM_RETVAL_CANCEL  BMPLIST_CANCEL    userLZ
            COMM_RETVAL_OK      (0)               I
            COMM_RETVAL_ERROR   (1)               ʐMG[
 */
//--------------------------------------------------------------

u32 CommChildWindowCheck(void)
{
    u32 ret = _pInfo->retCode;
    if(COMM_RETVAL_NULL != ret){
        OHNO_PRINT("lԂ %d\n",ret);
        _infoFinalize();
    }
    return ret;
}

//--------------------------------------------------------------
/**
 * @brief   _CNgR[i[[ɓ̏
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------

void CommDirectEnterBattleRoom(FIELDSYS_WORK* pFSys)
{
    CommFieldStateEnterBattleRoom(pFSys);
}

//--------------------------------------------------------------
/**
 * @brief   _CNgR[i[IiOďoŁj
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------

void CommDirectEnd(void)
{
    CommFieldStateExitBattle();
}


//==============================================================================
/**
 * IЂƂł󂯎ǂm点
 * @param   none
 * @retval  MĂꍇTRUE MĂȂFALSE
 */
//==============================================================================

BOOL CommRecvIsExit(void)
{
    int i;

    for(i = 0; i < COMM_MACHINE_MAX; i++){
        if( CommRecvData(i, CS_EXIT, NULL, NULL) ){
            return TRUE;
        }
    }
    return FALSE;
}



#if PM_DEBUG

//--------------------------------------------------------------
/**
 * @brief   fobOp_CNgR[i[e@ڑ
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------

void CommDirectParent_Debug(FIELDSYS_WORK* pFSys)
{
    CommFieldStateEnterBattleParent_Debug(_pInfo->pFSys, _pInfo->selectGameMode,
                                          _getRegulationNo());
}

//--------------------------------------------------------------
/**
 * @brief   fobOp_CNgR[i[q@ڑ
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------

void CommDirectChild_Debug(FIELDSYS_WORK* pFSys)
{
    CommFieldStateConnectBattleChild_Debug(_pInfo->pFSys,
                                      _pInfo->selectGameMode, _getRegulationNo(), 0);
}

//--------------------------------------------------------------
/**
 * @brief   fobOp_CNgR[i[ڑ
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------

void CommDirectConnect_Debug(void)
{
    OHNO_PRINT("ڑJn\n");
    // Ɉē郁bZ[W
    _pleaseGuestRoomStart(_pInfo);
}


//--------------------------------------------------------------
/**
 * @brief   fobOp_CNgR[i[p[^ݒ
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------

void CommDirectConnectSetParam_Debug(FIELDSYS_WORK* pFSys,int gameMode, int type1, int type2)
{
    _infoInitialize(pFSys);
    _pInfo->selectGameMode = gameMode;
    _pInfo->type1 = type1;
    _pInfo->type2 = type2;
}


#endif //PM_DEBUG

