//=============================================================================
/**
 * @file	comm_field_state.c
 * @brief	ʐMԂǗT[rX  ʐM̏ʂɂ
 *          XbĥЂƂƂēA̒ʐMԂ⑼̋@
 *          JnIǗ
 *          tB[hŒڊǗ̂communicationfieldɈړ 2005.09.28
 * @author	Katsumi Ohno
 * @date    2005.08.02
 */
//=============================================================================

#include "common.h"
#include "communication/communication.h"
#include "communication/comm_state.h"
#include "system/gamedata.h"
#include "system/pm_str.h"

#include "comm_field_state.h"
#include "underground/ug_manager.h"
#include "field/field.h"
#include "fieldsys.h"
#include "comm_command_field.h"
#include "comm_direct_counter.h"

#include "script.h"							//StartFieldScript
#include "..\fielddata\script\common_scr_def.h"		//SCRID_TRAINER_MOVE_SCRIPT
#include "..\fielddata\script\connect_def.h"		//SCRID_CONNECT_COLOSSEUM

#include "system/pm_overlay.h"

#ifdef PM_DEBUG
#include "d_ohno.h"
#include "field_encount.h"
#endif
//==============================================================================
//	^錾
//==============================================================================
// R[obN֐̏
typedef void (*PTRStateFunc)(void);

FS_EXTERN_OVERLAY(ol_underground);

//==============================================================================
// [N
//==============================================================================

typedef struct{
    COMM_MESSAGE* pCMess;
    FIELDSYS_WORK* pFSys;
    MATHRandContext32 sRand; ///< eq@lSVG[VpL[
    PTRStateFunc state;
    TCB_PTR pTcb;
    u16 timer;
    u8 connectIndex;   // q@ڑe@indexԍ
    u8 bStalth;
    u8 bStateNoChange;
    u8 bUGOverlay;
#ifdef PM_DEBUG		// Debug ROM
    u16 debugTimer;
#endif
} _COMM_STATE_WORK;

static _COMM_STATE_WORK* _pCommState = NULL;  ///<@[N\̂̃|C^

//==============================================================================
// `
//==============================================================================
#define _START_TIME (50)     // Jn
#define _CHILD_P_SEARCH_TIME (12) ///q@ƂĐeT
#define _PARENT_WAIT_TIME (40) ///eƂĂ̂т҂
#define _FINALIZE_TIME (2)
#define _EXIT_SENDING_TIME (5)
#define _PARENT_END_TIME (2)
#define _SEND_NAME_TIME (10)
#define _PARENTSCAN_PA (3)  // e@ƂČm1/3

#define _TCB_COMMCHECK_PRT   (10)    ///< tB[hʐM̊Ď[`PRI


//==============================================================================
// static錾
//==============================================================================

// Xe[g̏

static void _commStateInitialize(FIELDSYS_WORK* pFSys);  // 
static void _commCheckFunc(TCB_PTR tcb, void* work);  // Xe[gsĂ^XN
static void _changeState(PTRStateFunc state, int time);  // Xe[gύX
static void _changeStateDebug(PTRStateFunc state, int time, int line);  // Xe[gύX

#if 0
#define   _CHANGE_STATE(state, time)  _changeStateDebug(state, time, __LINE__)
#else
#define   _CHANGE_STATE(state, time)  _changeState(state, time)
#endif


// n֘AXe[g
static void _underStart(void);           //  + VXȅ
static void _underConnectting(void);     // ڑ
static void _underChildConnecting(void);   // q@e@ɐڑ
static void _underChildConnectInfoWait(void);  // q@ƂĐڑ infoW
static void _underChildConnectSecret(void);    // q@ƂĐڑ
static void _underChildConnectDig(void);    // q@ƂĐڑ
static void _underChildConnect(void);    // q@ƂĐڑ
static void _underChildConnect_JumpFieldStart(void);    // q@ƂĐڑ JumpJn
static void _underChildConnect_JumpField(void);    // q@ƂĐڑ Jump
static void _underChildConnect_JumpFieldEnd(void);    // q@ƂĐڑ Jump
static void _underChildRestart(void);
static void _underChildStalth(void);

static void _underParentWait(void);      // e@Ƃđҋ@
static void _underParentConnect(void);   // e@ƂĐڑ
static void _underParentConnect_JumpFieldStart(void);  // e@ƂĐڑ JumpJn
static void _underParentConnect_JumpField(void);  // e@ƂĐڑ Jump
static void _underParentConnect_JumpFieldEnd(void);  // e@ƂĐڑ JumpI
static void _stateUnderGroundConnectEnd(void);  // nؒf

// og֘AXe[g
static void _battleParentInit(void);     // 퓬pe@Ƃď
static void _battleParentWaiting(void);  // 퓬pe@Ƃđҋ@

static void _battleChildInit(void);     // 퓬pq@Ƃď
static void _battleChildBconScanning(void);  // 퓬pq@ƂĐe@I
static void _battleChildConnecting(void);  // ڑ炢
static void _battleChildSendName(void);  // ̖O݂ȂɑM
static void _battleChildWaiting(void);  // _CNgpq@ҋ@
static void _battleMoveRoomEnter(void); // 퓬O̕ɓđҋ@
static void _battleMoveRoomEnter2(void); // 퓬O̕ɓđҋ@
static void _battleMoveRoom(void); // 퓬O̕ɓđҋ@
static void _battleChildReTry(void);   // q@𒆒f
static void _battleChildReInit(void);   // q@ċN
static void _battleMoveRoomEnd(void);   //og[I 퓬Jn
static void _battleQuit(void);   //og[I

// ̑ʓIȃXe[g
static void _stateNone(void);            // Ȃ
static void _stateConnectError(void);    // ڑG[
static void _stateEnd(void);             // I
static void _stateConnectEnd(void);      // ؒfJn
static void _stateConnectAutoEnd(void);  // ؒfJn

#ifdef PM_DEBUG		// Debug ROM
static void _debugTimerStart(void);   // fobOp
static void _debugTimerDisp(char* msg);
#else
static void _debugTimerStart(void){}   // fobOp
static void _debugTimerDisp(char* msg){}
#endif


//==============================================================================
/**
 * ʐMǗXe[g̏
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _commStateInitialize(FIELDSYS_WORK* pFSys)
{
    void* pWork;

    if(_pCommState!=NULL){   // łɓ쒆̏ꍇKvȂ
        return;
    }
    CommCommandFieldInitialize((void*)pFSys);
    // 
    _pCommState = (_COMM_STATE_WORK*)sys_AllocMemory(HEAPID_COMMUNICATION, sizeof(_COMM_STATE_WORK));
    _pCommState->state = NULL;   // Ȃ
    _pCommState->timer = _START_TIME;
    _pCommState->pTcb = TCB_Add(_commCheckFunc, NULL, _TCB_COMMCHECK_PRT);
    _pCommState->pFSys = pFSys;
    _pCommState->bStalth = FALSE;
    _pCommState->bUGOverlay = FALSE;
    _pCommState->bStateNoChange = FALSE;
    _debugTimerStart();
    CommRandSeedInitialize(&_pCommState->sRand);
}

//==============================================================================
/**
 * ʐMǗXe[g̏I
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _stateFinalize(void)
{
    void* pWork;

    if(_pCommState==NULL){  // łɏIĂ
        return;
    }
    TCB_Delete(_pCommState->pTcb);
    sys_FreeMemoryEz(_pCommState);
//    sys_DeleteHeap(HEAPID_COMMUNICATION);
    _pCommState = NULL;
}

//==============================================================================
/**
 * Xe[g̑Jڂ
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommStateFieldEnableChange(void)
{
    if(_pCommState){
        _pCommState->bStateNoChange = FALSE;
    }
}

//==============================================================================
/**
 * Xe[g̑Jڂ֎~
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommStateFieldDisableChange(void)
{
    if(_pCommState){
        _pCommState->bStateNoChange = TRUE;
    }
}

//==============================================================================
/**
 * nɂ͂̒ʐM
 * @param   pFSys FIELDSYS_WORK
 * @retval  none
 */
//==============================================================================

void CommFieldStateEnterUnderGround(FIELDSYS_WORK* pFSys)
{
    if(_pCommState!=NULL){ // ȂĂꍇ͏O
        return;
    }
    // ڑs
    CommStateEnterUnderGround(SaveData_GetMyStatus(GameSystem_GetSaveData(pFSys)));
    _commStateInitialize(pFSys);
    sys_CreateHeap( HEAPID_BASE_APP, HEAPID_UNDERGROUND, 0x2400 );
}

//==============================================================================
/**
 * nɂ͂āAtB[hnɕς̏
 * @param   pFSys FIELDSYS_WORK
 * @retval  none
 */
//==============================================================================

void CommFieldStateArrivalUnderGround(void)
{
    //

    OHNO_PRINT("ñI[o[C\n");
	Overlay_Load( FS_OVERLAY_ID( ol_underground ), OVERLAY_LOAD_NOT_SYNCHRONIZE );
    _pCommState->bUGOverlay = TRUE;
    
    _CHANGE_STATE(_underStart, 0);
}

//==============================================================================
/**
 * noꍇ̒ʐM
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommFieldStateExitUnderGround(void)
{
    if(_pCommState==NULL){  // łɏIĂ
        return;
    }
    // ؒfXe[gɈڍs  ɐ؂Ȃ
    
    _CHANGE_STATE(_stateUnderGroundConnectEnd, 3);
}

//==============================================================================
/**
 * nʐM~ɂꍇ̒ʐM
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommFieldStateStalthUnderGround(void)
{
    OHNO_PRINT("ؒf --  ċN\n");
    CommUnderOptionFinalize();
    CommStateUnderGroundOfflineSecretBase();
    _CHANGE_STATE(_underChildStalth, 0);
}

//==============================================================================
/**
 * nĐڑꍇ̏
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommFieldStateUnderGroundReConnect(void)
{
    CommSecretBaseInfoChildSendStart();
    _underChildConnect_JumpFieldEnd();
    CommStateUnderGroundOnlineSecretBase();  // ʐMԂONLINEɂǂ
    _CHANGE_STATE(_underConnectting, _CHILD_P_SEARCH_TIME*2);
}

//==============================================================================
/**
 * nJUMPꍇ̒ʐM
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommStateJumpUnderGround(void)
{
    u32 stateAddr = (u32)_pCommState->state;
    u32 parentAddr = (u32)_underParentConnect;
    u32 childAddr = (u32)_underChildConnect;

    if(stateAddr == parentAddr){
        _CHANGE_STATE(_underParentConnect_JumpFieldStart, 0);
    }
    else if(childAddr == stateAddr){
        _CHANGE_STATE(_underChildConnect_JumpFieldStart, 0);
    }
    else{
        // soloplay̏ꍇ
        _CHANGE_STATE(_underParentConnect_JumpFieldStart, 0);
//        GF_ASSERT(0 && "zOstate:vC");
    }
}

//==============================================================================
/**
 * nJUMPIꍇ̏ Xe[gActiveԂɂȂ
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommStateJumpEndUnderGround(void)
{
    u32 stateAddr = (u32)_pCommState->state;
    u32 parentAddr = (u32)_underParentConnect_JumpField;
    u32 childAddr = (u32)_underChildConnect_JumpField;

    if(stateAddr == parentAddr){
        _CHANGE_STATE(_underParentConnect_JumpFieldEnd, 0);
    }
    else if(childAddr == stateAddr){
        _CHANGE_STATE(_underChildConnect_JumpFieldEnd, 0);
    }
    else{
//        GF_ASSERT(0 && "zOstate:vC");
    }
}

//==============================================================================
/**
 * ړ\Xe[gȂ̂ǂԂ
 * @param   none
 * @retval  ړ\ȂTRUE
 */
//==============================================================================

BOOL CommIsUnderGroundMoveState(void)
{
    int i;
    u32 funcTbl[]={
        (u32)_battleMoveRoom,
        (u32)_underChildConnect,
        (u32)_underChildConnect,
        (u32)_underParentConnect,
        (u32)_underChildConnect,
        (u32)_underChildConnectInfoWait,
        (u32)_underChildConnectSecret,
        (u32)_underChildConnectDig,
        (u32)_underChildConnect_JumpFieldStart,
        (u32)_underChildConnect_JumpField,
        (u32)_underChildConnect_JumpFieldEnd,
        (u32)_underParentConnect_JumpFieldStart,
        (u32)_underParentConnect_JumpField,
        (u32)_underParentConnect_JumpFieldEnd,
        0,
    };
    u32 stateAddr = (u32)_pCommState->state;

    if(_pCommState==NULL){  // łɏIĂ
        return FALSE;
    }
    for(i = 0; funcTbl[i] != 0; i++ ){
        if(stateAddr == funcTbl[i]){
            return TRUE;
        }
    }
    return FALSE;
}

//==============================================================================
/**
 * og̐eƂĂ̒ʐMJn
 * @param   serviceNo  ʐMT[rXԍ
 * @retval  none
 */
//==============================================================================

void CommFieldStateEnterBattleParent(FIELDSYS_WORK* pFSys, int serviceNo, int regulationNo)
{
    if(CommIsInitialize()){
        return;      // ȂĂꍇ͏O
    }
#if PM_DEBUG
    CommStateEnterBattleParent(SaveData_GetMyStatus(GameSystem_GetSaveData(pFSys)), serviceNo, regulationNo, SOLO_DEBUG_NO);
#else
    CommStateEnterBattleParent(SaveData_GetMyStatus(GameSystem_GetSaveData(pFSys)), serviceNo, regulationNo);
#endif
    _commStateInitialize(pFSys);
    _CHANGE_STATE(_battleParentInit, 0);
}

//==============================================================================
/**
 * og̎qƂĂ̒ʐMJn
 * @param   serviceNo  ʐMT[rXԍ
 * @retval  none
 */
//==============================================================================

void CommFieldStateEnterBattleChild(FIELDSYS_WORK* pFSys, int serviceNo, int regulationNo)
{
    if(CommIsInitialize()){
        return;      // ȂĂꍇ͏O
    }
    // ʐMq[v쐬
#if PM_DEBUG
    CommStateEnterBattleChild(SaveData_GetMyStatus(GameSystem_GetSaveData(pFSys)), serviceNo, regulationNo, SOLO_DEBUG_NO);
#else
    CommStateEnterBattleChild(SaveData_GetMyStatus(GameSystem_GetSaveData(pFSys)), serviceNo, regulationNo);
#endif
    _commStateInitialize(pFSys);
    _CHANGE_STATE(_battleChildInit, 0);
}

//==============================================================================
/**
 * og̎qƂĂ̒ʐMJn
 * @param   connectIndex ڑe@Index
 * @retval  none
 */
//==============================================================================

void CommFieldStateConnectBattleChild(int connectIndex)
{
    _pCommState->connectIndex = connectIndex;
    _CHANGE_STATE(_battleChildConnecting, 0);
}

//==============================================================================
/**
 * og̎qƂĂ̒ʐMċN
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommFieldStateRebootBattleChild(void)
{
    _CHANGE_STATE(_battleChildReTry, 0);
}

//==============================================================================
/**
 * ogɈړł镔ɓ鎞̏
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommFieldStateEnterBattleRoom(FIELDSYS_WORK* pFSys)
{
    BOOL bDSMode = FALSE;

    OHNO_PRINT("肩΂܂[\n");
    if(_pCommState==NULL){// ĂȂꍇ͏O
        return;
    }
//    _commStateInitialize(pFSys);
    CommSendFixSizeData(CS_DSMP_CHANGE, &bDSMode);  //ړ[hɕύX
    _CHANGE_STATE(_battleMoveRoomEnter, 32);

}

//==============================================================================
/**
 * og̒ʐMI葱
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommFieldStateExitBattle(void)
{
    if(_pCommState==NULL){
        return;      // łɏIĂꍇ͏O
    }
    _CHANGE_STATE(_stateConnectAutoEnd, _EXIT_SENDING_TIME);
}

//==============================================================================
/**
 * ʐMǗXe[g̏
 * @param
 * @retval  none
 */
//==============================================================================

void _commCheckFunc(TCB_PTR tcb, void* work)
{
#ifdef PM_DEBUG
    _pCommState->debugTimer++;
#endif

    if(_pCommState==NULL){
        TCB_Delete(tcb);
    }
    else{
        if(_pCommState->state != NULL){
            PTRStateFunc state = _pCommState->state;
            if(!_pCommState->bStateNoChange){
                state();
            }
        }
    }
}

//==============================================================================
/**
 * ʐMǗXe[g̕ύX
 * @param   state  ςXe[g̊֐
 * @param   time   Xe[gێ
 * @retval  none
 */
//==============================================================================

static void _changeState(PTRStateFunc state, int time)
{
    _pCommState->state = state;
    _pCommState->timer = time;
}

#if PM_DEBUG
static void _changeStateDebug(PTRStateFunc state, int time, int line)
{
    OHNO_PRINT("CF field_state: %d\n",line);
    _changeState(state, time);
}
#endif

//==============================================================================
/**
 * nX^[g
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underStart(void)
{
    if(_pCommState->timer!=0){
        _pCommState->timer--;
        return;
    }
    if(!CommIsVRAMDInitialize()){
        return;  //
    }

    CommUnderOptionInitialize(_pCommState->pFSys);  // nT[rX̋N

    // gɂ񑗂
    CommInfoSendPokeData();
    CommPlayerSendPos(FALSE);
    CommTrapInfoChildSendStart();  //TrapgɑMJn
    CommSecretBaseInfoChildSendStart(); // ̔閧nf[^̐eɑMJn
    CommDigSendStoneData();  // ΂𑗐MJn
    
    _CHANGE_STATE(_underConnectting, _CHILD_P_SEARCH_TIME*2);
}

//==============================================================================
/**
 * lbg[NȂ܂őҋ@
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underConnectting(void)
{
    CommUnderProcess();
    if(CommIsUnderGroundConnectingState()){  // ڑ܂ŌĂё
        if(CommGetCurrentID() == COMM_PARENT_ID){
            OHNO_PRINT("eɂȂ\n");
            _CHANGE_STATE(_underParentWait, 5);
        }
        else{
            OHNO_PRINT("qɂȂ\n");
            _CHANGE_STATE(_underChildConnecting, 4);
        }
    }
}

//==============================================================================
/**
 * q@ƂȂĐڑ
 * @param   none
 * @retval  none
 */
//==============================================================================
static void _underChildConnecting(void)
{
    if(CommIsConnect(CommGetCurrentID())){   // gڑĂ邱ƂmFł
		if(CommGetSendRestSize() != COMM_COMMAND_SEND_SIZE_MAX){  // ɂȂ܂ő҂
			return;
		}
        CommPlayerMyDataInitialize();
//        CommPlayerSendPos(FALSE);
        _debugTimerDisp("q@ڑ----!!!-----");
        _CHANGE_STATE(_underChildConnectInfoWait, 2);
        return;
    }
}

//==============================================================================
/**
 * e@ɂȂAq@ڑĂ̂҂
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underParentWait(void)
{
    CommUnderProcess();

    if(CommIsChildsConnecting()){   // ȊOȂe@Œ
        _debugTimerDisp("e@ڑ");
        CommInfoSendPokeData();
        CommPlayerSendPos(FALSE);
        CommTrapInfoChildSendStart();  //TrapgɑMJn
        CommSecretBaseInfoChildSendStart(); // ̔閧nf[^̐eɑMJn
        CommDigSendStoneData();  // ΂𑗐MJn
        _CHANGE_STATE(_underParentConnect, 0);
        return;
    }
}

//==============================================================================
/**
 * e@ƂĐڑ
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underParentConnect(void)
{
    CommUnderProcess();

    if(CommIsError()){
        OHNO_PRINT("ؒf --  ċN\n");
        CommUnderOptionFinalize();
        _CHANGE_STATE(_underChildRestart, 0);
    }
    
    // ȂɂĂȂ
    // e@́AڑɂȂꍇA[hɖ߂Kv @@OO
}

//==============================================================================
/**
 * e@ƂĐڑ   閧nւ̈ړJn
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underParentConnect_JumpFieldStart(void)
{
    //CommSecretBaseInfoReset();
    //CommTrapInfoReset();
    CommPlayerManagerReset();
    _CHANGE_STATE(_underParentConnect_JumpField, 0);
}

//==============================================================================
/**
 * e@ƂĐڑ   閧nւ̈ړ
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underParentConnect_JumpField(void)
{
    // ̂Ƃ듯sĂ
    _underParentConnect();
}

//==============================================================================
/**
 * e@ƂĐڑ   閧nւ̈ړI
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underParentConnect_JumpFieldEnd(void)
{
    CommSecretBaseInfoJumpEnd();
    //CommSecretBaseInfoReboot();
    //CommTrapInfoReboot();
    CommPlayerManagerReboot();
    _CHANGE_STATE(_underParentConnect, 0);
}

//==============================================================================
/**
 * q@ƂĐڑĂā@infof[^W߂ĂƂ
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underChildConnectInfoWait(void)
{
    if(_pCommState->timer==1){
        CommInfoSendPokeData();  //infof[^𑗂
        CommPlayerSendPos(FALSE);   // ʒu𑗂
    }
    if(_pCommState->timer!=0){
        _pCommState->timer--;
        return;
    }
    
    if(CommInfoIsInfoCollected()){
        _debugTimerDisp("infof[^M");
        CommTrapInfoChildSendStart();  // 㩏񑗐M
        _CHANGE_STATE(_underChildConnectSecret,0);
        return;
    }
    _underChildConnect();
}

//==============================================================================
/**
 * q@ƂĐڑ
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underChildConnectSecret(void)
{
    if(CommTrapInfoIsParentRecv()){
        _debugTimerDisp("e@㩃f[^͂炵");
        CommTrapInfoResetParentRecv();
        CommSecretBaseInfoChildSendStart(); // q@̔閧nf[^MJn
        _CHANGE_STATE(_underChildConnectDig,0);
        return;
    }
    _underChildConnect();
}

//==============================================================================
/**
 * q@ƂĐڑ
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underChildConnectDig(void)
{
    if(CommSecretBaseInfoIsPosRecv()){
        _debugTimerDisp("閧n̈ʒu");
        CommDigSendStoneData();
        CommSecretBaseResetPosRecv();
        _CHANGE_STATE(_underChildConnect,0);
        return;
    }
    _underChildConnect();
}

//==============================================================================
/**
 * q@ƂĐؒf
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underChildRestart(void)
{
    if(CommGetCurrentID() == COMM_PARENT_ID){
        _CHANGE_STATE(_underStart, 0);
    }
}


static void _underChildStalthDeadLoop(void)
{
    CommUnderProcess();
}

static void _underChildStalth(void)
{
    if(CommGetCurrentID() == COMM_PARENT_ID){
        CommUnderOptionInitialize(_pCommState->pFSys);  // nT[rX̋N
        // gɂ񑗂
        CommInfoSendPokeData();
        CommPlayerSendPos(FALSE);
        CommTrapInfoChildSendStart();  //TrapgɑMJn
        CommSecretBaseInfoChildSendStart(); // ̔閧nf[^̐eɑMJn
        CommDigSendStoneData();  // ΂𑗐MJn
        _CHANGE_STATE(_underChildStalthDeadLoop, 0);
    }
}

//==============================================================================
/**
 * q@ƂĐڑ
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underChildConnect(void)
{
    CommUnderProcess();

    // e@ȂȂIĕʐeTɂ
    if(CommMPParentDisconnect()|| CommIsError()){

        OHNO_PRINT("ؒf --  ċN\n");
        CommStateUnderRestart();
        CommUnderOptionFinalize();
        _CHANGE_STATE(_underChildRestart, 0);
    }
}

//==============================================================================
/**
 * q@ƂĐڑ@@@JUMP
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underChildConnect_JumpFieldStart(void)
{
    //CommSecretBaseInfoReset();
    //CommTrapInfoReset();
    CommPlayerManagerReset();
    _CHANGE_STATE(_underChildConnect_JumpField,0);
}

//==============================================================================
/**
 * q@ƂĐڑ@@@JUMP
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underChildConnect_JumpField(void)
{
    // o邾Ȃ
}

//==============================================================================
/**
 * q@ƂĐڑ@@@JUMP
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underChildConnect_JumpFieldEnd(void)
{
    CommSecretBaseInfoJumpEnd();
 //   CommSecretBaseInfoReboot();
//    CommTrapInfoReboot();
    CommPlayerManagerReboot();
    _CHANGE_STATE(_underChildConnect, 0);
}

//==============================================================================
/**
 * e@Ƃďs
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleParentInit(void)
{
    if(!CommIsConnect(CommGetCurrentID())){
//    if(!CommIsVRAMDInitialize()){
        return;
    }
    CommChildListWindowOpen();
    CommInfoSendPokeData();
    _CHANGE_STATE(_battleParentWaiting, 0);
}

//==============================================================================
/**
 * e@Ƃđҋ@
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleParentWaiting(void)
{
    if(CommGetCurrentID() == COMM_PARENT_ID){
        CommInfoSendArray_ServerSide();  // q@₢킹info𑗐M
    }
}

//==============================================================================
/**
 * q@̏
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleChildInit(void)
{
    if(!CommIsVRAMDInitialize()){
        return;
    }
    
    CommParentSelectParentWindowOpen();
    _CHANGE_STATE(_battleChildBconScanning, 0);
}

//==============================================================================
/**
 * q@ҋ@  e@r[RW
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleChildBconScanning(void)
{
//    CommParentBconCheck();
}

//==============================================================================
/**
 * q@ҋ@  e@ɋ炢
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleChildConnecting(void)
{
    CommStateConnectBattleChild(_pCommState->connectIndex);
    _CHANGE_STATE(_battleChildSendName, 0);
}

//==============================================================================
/**
 * q@ҋ@  e@ɏ𑗐M
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleChildSendName(void)
{
    if(!CommIsBattleConnectingState()){
        return;
    }
    CommInfoSendPokeData();
    _CHANGE_STATE(_battleChildWaiting, 0);
}

//==============================================================================
/**
 * q@ҋ@
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleChildWaiting(void)
{
    //Exit󂯎q@ؒf
}

//==============================================================================
/**
 * q@enter  ړ[ɂ͂Ă
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleMoveRoomEnter(void)
{
    void* pWork;
    if(_pCommState->timer!=0){
        _pCommState->timer--;
        return;
    }
    pWork = sys_AllocMemory(HEAPID_COMMUNICATION, CommPlayerGetWorkSize());
    CommPlayerManagerInitialize(pWork, _pCommState->pFSys);
    _CHANGE_STATE(_battleMoveRoomEnter2, 0);
}

//==============================================================================
/**
 * q@ҋ@  ړ[
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleMoveRoomEnter2(void)
{
    if(CommGetCurrentID() == COMM_PARENT_ID){
        CommInfoSendArray_ServerSide();  // q@₢킹info𑗐M
    }
    if(_pCommState->timer!=0){
        _pCommState->timer--;
        return;
    }
    CommPlayerSendPos(FALSE);
    _CHANGE_STATE(_battleMoveRoom,0);
}

//==============================================================================
/**
 * q@ҋ@  ړ[
    ---  Ƃ肠ɃogɔԃCxg悤ɐݒu
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleMoveRoom(void)
{
    if(CommPlayerCheckBattleJump()){
        _CHANGE_STATE(_battleMoveRoomEnd, 30);
    }
    if(CommIsError()){
        _pCommState->pCMess = CommErrorMessageStart(HEAPID_FIELD,
                                                    _pCommState->pFSys->bgl);
        _CHANGE_STATE(_battleQuit, 0);
    }
}

//==============================================================================
/**
 * q@ҋ@  ړ[
    ---  Ƃ肠ɃogɔԃCxg悤ɐݒu
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleMoveRoomEnd(void)
{
    BOOL bDSMode = TRUE;

    if(_pCommState->timer!=0){
        _pCommState->timer--;
        return;
    }
    EventSet_Script( _pCommState->pFSys, SCRID_CONNECT_COLOSSEUM_BATTLE_START, NULL );
    CommPlayerManagerFinalize();
    CommSendFixSizeData(CS_DSMP_CHANGE, &bDSMode);  //og[hɕύX
    _stateFinalize();
}

//==============================================================================
/**
 * G[ɂog̋I
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleQuit(void)
{
    if(sys.trg & (PAD_BUTTON_DECIDE|PAD_BUTTON_CANCEL)){
        CommPlayerManagerFinalize();
        _stateFinalize();
    }
}

//==============================================================================
/**
 * q@I
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleChildReTry(void)
{
    CommStateRebootBattleChild();
    _CHANGE_STATE(_battleChildReInit, _FINALIZE_TIME);
}

//==============================================================================
/**
 * q@IċN
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleChildReInit(void)
{
    if(!CommMPIsStateIdle()){  /// IƏIĂ邱ƂmF
        return;
    }
    _CHANGE_STATE(_battleChildSendName, _SEND_NAME_TIME);
}

//==============================================================================
/**
 * ȂXe[g
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _stateNone(void)
{
    // ȂɂĂȂ
}

//==============================================================================
/**
 * @brief G[
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _stateConnectError(void)
{
}

//==============================================================================
/**
 * @brief  I
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _stateEnd(void)
{
    if(CommIsInitialize()){
        return;
    }
    _stateFinalize();
}

//==============================================================================
/**
 * @brief  nEJn
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _stateUnderGroundConnectEnd(void)
{
    if(_pCommState->timer != 0){
        _pCommState->timer--;
        return;
    }

    CommUnderOptionFinalize();
    CommStateExitUnderGround();
    sys_DeleteHeap(HEAPID_UNDERGROUND);

    _pCommState->bUGOverlay = FALSE; // n~߂
    Overlay_UnloadID( FS_OVERLAY_ID(ol_underground) );

    _stateFinalize();   // state͂ŏI ʐM͌ォ؂
}

//==============================================================================
/**
 * @brief  IJn
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _stateConnectAutoEnd(void)
{
    if(CommSendFixData(CS_AUTO_EXIT)){
        _CHANGE_STATE(_stateEnd, 0);
    }
}

//==============================================================================
/**
 * @brief  IJn
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _stateConnectEnd(void)
{
    if(_pCommState->timer != 0){
        _pCommState->timer--;
        return;
    }
    // ؒf
    CommFinalize();
    _CHANGE_STATE(_stateEnd, 0);
}

#ifdef PM_DEBUG
static void _debugTimerStart(void)
{
    _pCommState->debugTimer=0;
}

static void _debugTimerDisp(char* msg)
{
    OHNO_PRINT("%s Jn %d sync ܂\n", msg, _pCommState->debugTimer * 2);
}

#endif


#ifdef PM_DEBUG


static BOOL GMEVENT_BattleDebug(GMEVENT_CONTROL * event)
{
    if(CommIsInitialize()){
        return FALSE;
    }
    OHNO_PRINT("GMEVENT_BattleDebug  @@@@@@@@@@@@@ \n");
    return TRUE;
}

//==============================================================================
/**
 * q@ҋ@  e@ɏ𑗐M
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleChildWaiting_Debug(void)
{
    
    OHNO_PRINT("ڑ CommGetConnectNum=%d CommMPGetServiceNo=%d \n",CommGetConnectNum(),CommMPGetServiceNo() );
    if(CommGetConnectNum() == (CommGetMaxEntry(CommMPGetServiceNo()))){
        CommDirectConnect_Debug();
        _CHANGE_STATE(_battleChildWaiting, 0);
    }
}

//==============================================================================
/**
 * q@ҋ@  e@ɏ𑗐M
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleChildSendName_Debug(void)
{
    if(_pCommState->timer!=0){
        _pCommState->timer--;
        return;
    }
    if(!CommIsConnect(CommGetCurrentID())){
        return;
    }
    CommInfoSendPokeData();
    _CHANGE_STATE(_battleChildWaiting_Debug, 0);
}

//==============================================================================
/**
 * q@ҋ@  e@ɋ炢ifobOj
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleChildConnecting_Debug(void)
{
    if(CommMPGetGFBss(_pCommState->connectIndex)!=NULL){
        CommStateConnectBattleChild(_pCommState->connectIndex);  // ڑ
        _CHANGE_STATE(_battleChildSendName_Debug, _SEND_NAME_TIME);
    }
}

//==============================================================================
/**
 * og̎qƂĂ̒ʐMJn
 * @param   connectIndex ڑe@Index
 * @retval  none
 */
//==============================================================================

void CommFieldStateConnectBattleChild_Debug( FIELDSYS_WORK* pFSys, int serviceNo, int regulationNo, int connectIndex)
{
    if(CommIsInitialize()){
        return;      // ȂĂꍇ͏O
    }
#if PM_DEBUG
    CommStateEnterBattleChild(SaveData_GetMyStatus(GameSystem_GetSaveData(pFSys)), serviceNo, regulationNo, SOLO_DEBUG_NO + COMMDIRECT_DEBUG_NO);
#else
    CommStateEnterBattleChild(SaveData_GetMyStatus(GameSystem_GetSaveData(pFSys)), serviceNo, regulationNo);
#endif
    _commStateInitialize(pFSys);
    _pCommState->connectIndex = connectIndex;
    _CHANGE_STATE(_battleChildConnecting_Debug, 0);
}


//==============================================================================
/**
 * e@Ƃđҋ@
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleParentWaiting_Debug(void)
{
    if(CommIsChildsConnecting()){
        OHNO_PRINT("ڑ CommGetConnectNum=%d CommMPGetServiceNo=%d \n",CommGetConnectNum(),CommMPGetServiceNo() );
        if(CommGetConnectNum() == (CommGetMaxEntry(CommMPGetServiceNo()))){
            CommDirectConnect_Debug();
            _CHANGE_STATE(_battleParentWaiting, 0);
        }
    }
}

//==============================================================================
/**
 * q@ҋ@  e@I
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleParentSendName_Debug(void)
{
    if(_pCommState->timer!=0){
        _pCommState->timer--;
        return;
    }
    if(!CommIsConnect(CommGetCurrentID())){
        return;
    }
    CommInfoSendPokeData();
    _CHANGE_STATE(_battleParentWaiting_Debug, 0);
}

//==============================================================================
/**
 * e@Ƃďs
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleParentInit_Debug(void)
{
    MYSTATUS* pMyStatus;
    
    if(!CommIsVRAMDInitialize()){
        return;
    }
    _CHANGE_STATE(_battleParentSendName_Debug, _SEND_NAME_TIME);
}

//==============================================================================
/**
 * og̐eƂĂ̒ʐMJn
 * @param   pFSys  tB[h\
 * @param   serviceNo  ʐMT[rXԍ
 * @param   regulationNo  ʐMT[rXԍ
 * @retval  none
 */
//==============================================================================

void CommFieldStateEnterBattleParent_Debug(FIELDSYS_WORK* pFSys, int serviceNo, int regulationNo)
{
    if(CommIsInitialize()){
        return;      // ȂĂꍇ͏O
    }
#if PM_DEBUG
    CommStateEnterBattleParent(SaveData_GetMyStatus(GameSystem_GetSaveData(pFSys)), serviceNo, regulationNo,
                               SOLO_DEBUG_NO + COMMDIRECT_DEBUG_NO);
#else
    CommStateEnterBattleParent(SaveData_GetMyStatus(GameSystem_GetSaveData(pFSys)), serviceNo, regulationNo);
#endif
    _commStateInitialize(pFSys);
    _CHANGE_STATE(_battleParentInit_Debug, 0);

}

#endif




