//=============================================================================
/**
 * @file	comm_player.c
 * @bfief	ʐMő葤̃v[[\
 *            R~jP[Vv[[
 * @author	katsumi ohno
 * @date	05/07/14
 */
//=============================================================================

#include <nitro/os.h>
#include "common.h"
#include "gflib/blact.h"

#include "communication/communication.h"
#include "comm_field_state.h"
#include "underground/ug_manager.h"

#include "system/bmp_menu.h"
#include "worldmap.h"
#include "fieldobj.h"
#include "fieldobj_code.h" //AC_WALK... Aj[VR[h܂Ƃ߂Ă܂B
#include "fieldsys.h"
#include "fieldmap.h"
#include "fld_bmp.h"
#include "system/pm_str.h"
#include "system/fontproc.h"
#include "system/bmp_list.h"
#include "system/window.h"

#include "player.h"
#include "comm_player_condition.h"
#include "system/snd_tool.h"
#include "system/wordset.h"
#include "msgdata/msg_underworld.h"
#include "msgdata/msg_uwflag.h"

#include "field_effect.h"

#include "talk_msg.h"
#include "fldeff_flag.h"

#include "d_ohno.h"  // fobOp

#include <nnsys/g3d/glbstate.h>


//==============================================================================
// `
//==============================================================================

#define _EVWIN_MSG_BUF_SIZE		(100*2)			//bZ[Wobt@TCY

/// ȃtB[h}bvAN^[ԍ
#define _NULL_FIELD_MAP_ACT_ID (-1)
/// lbgv[[̓^XN͌ł
#define _TASK_PRI_NET_PLAYER  (100)
/// lbgv[[͂Ɍ
#define _TASK_PRI_NET_PLAYER_CREATE  (_TASK_PRI_NET_PLAYER+100)
/// BLACT_HEADER worḱ@eq@IDĂꏊ
/// OƂP͖{̃q[[AjŎgpĂ̂łQԂɂȂĂ
#define _WORK_MACHINE_ID (2)

#define _NAME_DISP (0)   ///< v[[ɖO\

#define _NO_PLACE_INITIALIZE (0xff)  ///< ړ̏IĂȂꍇ

#define _PLACEDATA_SEND_SIZE (5)  ///< ꏊf[^𑗐Mꍇ̃TCY
#define _IDPLACEDATA_SEND_SIZE (4)  ///< IDꏊf[^𑗐Mꍇ̃TCY

#define _BLOW_COUNTER_NUM_MAX   (27)  // ӂ΂t[
#define _BIGBLOW_COUNTER_NUM_MAX   (45)  // ӂ΂t[
#define _BLOW_STOP_COUNT (15)  // ŏɓȂ

#define _TALK_TARGET_INDEX_WORK (0)  ///< bf[^@bID̈ʒu
#define _TALK_MY_INDEX_WORK (1)  ///< bf[^@bĂID̈ʒu

// j[EChE^XNɓo^Ăۂ̃vCIeB[
enum menuTaskPri_e {
    _TALK_WINDOW_PRI = 10001,
};

enum _result_e {
    _RESULT_NONE,
    _RESULT_OK,
    _RESULT_NG,
    _RESULT_DELFLAG_OPEN,
};

enum _player_speed {
    _SPEED_2,
    _SPEED_4,
    _SPEED_8,
    _SPEED_16,
};


enum hedFieldEffect {
    _HFE_NONE,
    _HFE_FLAG,
    _HFE_EXCLAMATION,
    _HFE_OK,
};


#define _LOCAL_WIN_PX (2)   // GF_BGL_BmpAddŎgp EChEPXl
#define _LOCAL_WIN_PY (19)   // GF_BGL_BmpAddŎgp EChEPYl
#define _LOCAL_WIN_SX (28)   // GF_BGL_BmpAddŎgp EChESXl
#define _LOCAL_WIN_SY (4)   // GF_BGL_BmpAddŎgp EChESYl

#define _DASH_BIT (0x80)
#define _DEBUG_DASH_BIT (0x40)

#define _MSG_MAX  (50*GLOBAL_MSGLEN)    ///<

#define _KEEP_FLAG_MAX (5)  // LĂID

//==============================================================================
//	^錾
//==============================================================================

typedef struct{
    u16 xpos;
    u16 zpos;
    s8 dir;
    u8 speed;
} _PlayerPlace;

typedef struct{
    u16 xpos;
    u16 zpos;
} _Grid;

typedef struct{
    u8 netID:4;      // bĂl
    u8 targetID:4;   // bĂl
    u8 bItemMenu:1;      //  ACej[JɂĂ
    u8 bPersonalInformation:1;      // lJĂ
} _talkMenuInfo;

typedef struct{
    PLAYER_CONDITION_MGR_PTR pCondMgr;
    PLAYER_STATE_PTR pPlayer[COMM_MACHINE_MAX];   // v[[̃|C^
    EOA_PTR pMark[COMM_MACHINE_MAX];  //܂
    u8 bActive[COMM_MACHINE_MAX];     // v[[݂邩ǂ
    TCB_PTR pTask;          // ^XÑ|C^
    FIELDSYS_WORK* pFSys;
    _talkMenuInfo talkMenuInfo;   // ǂbԂɂ邩ǂL T[oɂ͖
    _PlayerPlace sPlayerPlaceServer[ COMM_MACHINE_MAX ];  // T[o[̃v[[̈ʒu
    _PlayerPlace sPlayerPlace[ COMM_MACHINE_MAX ];  // v[[̈ʒu
    u8 bMoveControl[ COMM_MACHINE_MAX ]; ///< @̃Rg[
    u8 hedFE[ COMM_MACHINE_MAX ]; ///< ̏̃tB[hGtFNgǗ
    s8 blowDir[COMM_MACHINE_MAX];
    u8 blowCounterS[COMM_MACHINE_MAX];   // ΂JE^
    u8 blowDirS[COMM_MACHINE_MAX];
    u8 giddyCounter[COMM_MACHINE_MAX];
    u8 countHole[COMM_MACHINE_MAX];
    u8 bBlowBigS[COMM_MACHINE_MAX];
    u8 bMoveChange[COMM_MACHINE_MAX]; // ړ̂őM邽߂̃tO
    u8 walkCount[COMM_MACHINE_MAX];   // x
    MYSTATUS* pKeepFlag[COMM_MACHINE_MAX][_KEEP_FLAG_MAX];
    MYSTATUS* pNowFlag[COMM_MACHINE_MAX];
    u8 bTalkMenuDisp;   ///<< bEChE\TRUE
    u8 msgIndex;      ///< bZ[WCfbNX bZ[WI҂Ɏgp
    u8 moveSync;     ///< ړʒu
    u8 bPosAllSend;  ///< S̈ʒuđMtO
    u8 bMyMoveControl; ///< @̃Rg[
    u8 bResetting;   ///< Zbg̏ꍇɓȂ悤
} CommPlayerWork;

// VOg
static CommPlayerWork* _pCommPlayerWork = NULL;

//==============================================================================
// static錾
//==============================================================================

static void _setFlagDisp(int netID);
static int _getBlowMoveCount( int counter,int bBigBlow );
static BOOL _blowMove( int netID );
static BOOL _blowAnim( int netID,int padTrg,int padCont,int speed );
static void _commPlayerDataSendTask(TCB_PTR tcb, void *work);
static void _commPlayerDataSendTaskToChild(TCB_PTR tcb, void *work);
static void _commPlayerAdd(u8 netID);
static void _commPlayerMove(TCB_PTR tcb, void *work);
static void _commPlayerDestroy(u8 netID, BOOL bExit);
static void _commPlayerTask(TCB_PTR tcb, void *work);
static void _commPlayerAutoStep(TCB_PTR tcb, void *work);
static void _talkMenuEnd(int selectNo);
static void _talkWindowFunc(TCB_PTR tcb, void* work);
static void _playerMoveClient(int netID);

#if PM_DEBUG
static void _debugGyoeDisp(void);
#endif

//==============================================================================
// ֐
//==============================================================================

//==============================================================================
/**
 * lbgv[[Ǘ}l[W[̏
 *   lbgv[[̎q@IDƃOtBbNтĊǗĂ
 * @param   work_area  [NGA
 * @retval  BOOL TRUE    FALSE s [NGAĂ
 */
//==============================================================================

BOOL CommPlayerManagerInitialize(void* work_area, FIELDSYS_WORK* pFSys)
{
    int i,j;

    if(_pCommPlayerWork){  // ̂Ƃ뉽x̂
        return FALSE;
    }
    if(_pCommPlayerWork == NULL){
        _pCommPlayerWork = work_area;
        MI_CpuFill8(_pCommPlayerWork,0,sizeof(CommPlayerWork));
    }
    _pCommPlayerWork->pCondMgr = sys_AllocMemory(HEAPID_COMMUNICATION,
                                                 CommPlayCondGetWorkSize());
    CommPlayerCondInitialize(_pCommPlayerWork->pCondMgr);
    _pCommPlayerWork->pFSys = pFSys;
    for(i = 0; i < COMM_MACHINE_MAX; i++){
        _pCommPlayerWork->pPlayer[i] = NULL;
        _pCommPlayerWork->pMark[i] = NULL;
        _pCommPlayerWork->bActive[i] = FALSE;
        _pCommPlayerWork->sPlayerPlace[i].dir = DIR_NOT;
        _pCommPlayerWork->sPlayerPlace[i].xpos = COMM_PLAYER_INVALID_GRID;
        _pCommPlayerWork->sPlayerPlace[i].zpos = COMM_PLAYER_INVALID_GRID;
        _pCommPlayerWork->sPlayerPlace[i].speed = _SPEED_8;
        _pCommPlayerWork->sPlayerPlaceServer[i].dir = DIR_NOT;
        _pCommPlayerWork->sPlayerPlaceServer[i].xpos = COMM_PLAYER_INVALID_GRID;
        _pCommPlayerWork->sPlayerPlaceServer[i].zpos = COMM_PLAYER_INVALID_GRID;
        _pCommPlayerWork->sPlayerPlaceServer[i].speed = _SPEED_8;
        _pCommPlayerWork->blowDir[i] = DIR_NOT;
        _pCommPlayerWork->blowCounterS[i] = 0;
        _pCommPlayerWork->bMoveControl[i] = TRUE;
        _pCommPlayerWork->walkCount[i] = 0;
        for(j = 0; j < _KEEP_FLAG_MAX; j++){
            _pCommPlayerWork->pKeepFlag[i][j] = NULL;
        }
        _pCommPlayerWork->pNowFlag[i] = NULL;
    }
    _pCommPlayerWork->bPosAllSend = FALSE;
    _pCommPlayerWork->bTalkMenuDisp=FALSE;
    _pCommPlayerWork->moveSync = FALSE;
    _pCommPlayerWork->bMyMoveControl = TRUE;
    _pCommPlayerWork->bResetting = FALSE;

    _pCommPlayerWork->pTask = TCB_Add(_commPlayerTask, NULL, _TASK_PRI_NET_PLAYER_CREATE);
    CommEnableSendMoveData();

    CommPlayerMyDataInitialize();



    return TRUE;
}

//==============================================================================
/**
 * lbgv[[Ǘ}l[W[̒f
 *   \Ălbgv[[
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommPlayerManagerReset(void)
{
    int i;
    if(_pCommPlayerWork==NULL){
        return;
    }
    for(i = 0; i < COMM_MACHINE_MAX; i++){
        _commPlayerDestroy( i, TRUE );
    }
    _pCommPlayerWork->bResetting = TRUE;
}

//==============================================================================
/**
 * lbgv[[Ǘ}l[W[̕A
 *   Ălbgv[[ĕ\
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommPlayerManagerReboot(void)
{
    if(_pCommPlayerWork==NULL){
        return;
    }
    _pCommPlayerWork->bPosAllSend = TRUE;
    _pCommPlayerWork->bResetting = FALSE;
}

//==============================================================================
/**
 * lbgv[[Ǘ}l[W[̏I
 *   \Ălbgv[[
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommPlayerManagerFinalize(void)
{
    int i;
    if(_pCommPlayerWork){
        for(i = 0; i < COMM_MACHINE_MAX; i++){
            _commPlayerDestroy( i, FALSE );
        }
        TCB_Delete(_pCommPlayerWork->pTask);
        CommPlayerCondFinalize(_pCommPlayerWork->pCondMgr);
        sys_FreeMemoryEz(_pCommPlayerWork->pCondMgr);
        sys_FreeMemoryEz(_pCommPlayerWork);
        _pCommPlayerWork = NULL;
    }
}

//==============================================================================
/**
 * ̃NXꂽǂԂ
 * @retval  ĂTRUE
 */
//==============================================================================

BOOL CommPlayerManagerIsInitialize(void)
{
    return (_pCommPlayerWork!=NULL);
}

//==============================================================================
/**
 * ̃f[^
 * @param   none
 * @retval  none
 */
//==============================================================================
void CommPlayerMyDataInitialize(void)
{
    if(CommGetCurrentID()!=COMM_PARENT_ID){
        _commPlayerDestroy( COMM_PARENT_ID, FALSE );
    }
    _pCommPlayerWork->pPlayer[CommGetCurrentID()] = _pCommPlayerWork->pFSys->player;
    _pCommPlayerWork->bActive[CommGetCurrentID()] = TRUE;
    _pCommPlayerWork->sPlayerPlace[CommGetCurrentID()].xpos = Player_NowGPosXGet( _pCommPlayerWork->pFSys->player );
    _pCommPlayerWork->sPlayerPlace[CommGetCurrentID()].zpos = Player_NowGPosZGet( _pCommPlayerWork->pFSys->player );
    _pCommPlayerWork->sPlayerPlace[CommGetCurrentID()].dir = Player_DirGet( _pCommPlayerWork->pFSys->player );
    _pCommPlayerWork->sPlayerPlaceServer[CommGetCurrentID()].xpos = Player_NowGPosXGet( _pCommPlayerWork->pFSys->player );
    _pCommPlayerWork->sPlayerPlaceServer[CommGetCurrentID()].zpos = Player_NowGPosZGet( _pCommPlayerWork->pFSys->player );
    _pCommPlayerWork->sPlayerPlaceServer[CommGetCurrentID()].dir = Player_DirGet( _pCommPlayerWork->pFSys->player );

    OHNO_PRINT("----------CommGetCurrentID() == %d  %d %d\n",
               CommGetCurrentID(),
               _pCommPlayerWork->sPlayerPlace[CommGetCurrentID()].xpos,
               _pCommPlayerWork->sPlayerPlace[CommGetCurrentID()].zpos);

    
}

//==============================================================================
/**
 * ݂̈ʒu𑗐M  q@e@Ɏ̈ʒu`
 * @param   none
 * @retval  none
 */
//==============================================================================

#define _BIT_LIVE (0x80)

void CommPlayerSendPos(BOOL bLiveMessage)
{
    u8 data[_PLACEDATA_SEND_SIZE+1];
    int xpos = Player_NowGPosXGet( _pCommPlayerWork->pFSys->player );
    int zpos = Player_NowGPosZGet( _pCommPlayerWork->pFSys->player );
    int dir = Player_DirGet( _pCommPlayerWork->pFSys->player );

    data[0] = xpos;
    data[1] = xpos >> 8;
    data[2] = zpos;
    data[3] = zpos >> 8;
    data[4] = dir;

    if(bLiveMessage){
        data[4] = data[4] | _BIT_LIVE;
    }
    
    CommSendFixSizeData(CF_PLAYER_POS, data);
    _pCommPlayerWork->bPosAllSend = TRUE;
    _pCommPlayerWork->bMyMoveControl = FALSE;
    CommPlayerSetMoveControl(TRUE);
//    _pCommPlayerWork->bMyMoveControl = TRUE;
//    CommSendFixSizeData(CF_MOVE_CONTROL,&_pCommPlayerWork->bMyMoveControl);   // M
   // OHNO_PRINT("q@ړf[^M %d %d %d\n",CommGetCurrentID(), xpos, zpos);
}

//==============================================================================
/**
 * ݂̈ʒu@w߂𑗐M
 * @param   netID  LID
 * @param   xpos  O[oXW
 * @param   zpos  O[oYW
 * @param   dir   
 * @param   dash  _bV1
 * @retval  none
 */
//==============================================================================
static void _sendIDPlayerPos(int netID,int xpos, int zpos, u8 dir, u8 speed)
{
    u8 data[_IDPLACEDATA_SEND_SIZE+1];

    if(xpos < 0){   // ͈͊Õf[^͕␳
        xpos = 0;
    }
    else if(xpos >= 0xf000){
        xpos = 0xf000-1;
    }
    if(zpos < 0){
        zpos = 0;
    }
    else if(zpos >= 0xf000){
        zpos = 0xf000-1;
    }

    data[0] = netID & 0xf;
    data[1] = xpos;
    data[2] = ((xpos >> 8)&0xf) + ((zpos >> 4)&0xf0);
    data[3] = zpos;
    data[0] += ((dir % DIR_4_MAX) << 4);
    data[0] += (speed << 6);

   // OHNO_PRINT("T[o[v[[f[^M %d  %d %d\n",netID, xpos, zpos);
    CommSendData_ServerSide(CF_PLAYER_POS_ID, data, 0);
}

//==============================================================================
/**
 * ̃v[[̈ʒuIɑM邽߂̃^XN
 * @param   tcb			TCBւ̃|C^
 * @param   work		none
 * @retval  none
 */
//==============================================================================
void _commPlayerDataSendTask(TCB_PTR tcb, void *work)
{
    // add̎gpĂȂ̂ŁAʒu␳͂ĂȂ 05.09.01
    // ʒu𑗐M
    int mv = Player_MoveValueGet( _pCommPlayerWork->pFSys->player );
    int ms = Player_MoveStateGet( _pCommPlayerWork->pFSys->player );
    
    
    if( (OBJ_MOVE_VALUE_STOP == mv) && CommIsConnect(CommGetCurrentID())){
        if(!_pCommPlayerWork->moveSync){
            CommPlayerSendPos(TRUE);
            _pCommPlayerWork->moveSync = TRUE;
        }
    }
    if((OBJ_MOVE_VALUE_WALK == mv )&&(OBJ_MOVE_STATE_START == ms)){
        // DS̏ꍇ͂
        _pCommPlayerWork->moveSync = FALSE;
    }
}

//==============================================================================
/**
 * ̃v[[̈ʒuq@ɏɑM邽߂̃^XN
 * @param   tcb			TCBւ̃|C^
 * @param   work		none
 * @retval  none
 */
//==============================================================================
static void _commPlayerDataSendTaskToChild(TCB_PTR tcb, void *work)
{
    int i;  // ʒu𑗐M

    for(i = 0; i < COMM_MACHINE_MAX; i++){
        if(_pCommPlayerWork->bActive[i]){
            _PlayerPlace* pPP = &_pCommPlayerWork->sPlayerPlaceServer[i];

            if(_pCommPlayerWork->bMoveChange[i] || _pCommPlayerWork->bPosAllSend){
                _pCommPlayerWork->bMoveChange[i]= FALSE;
                _sendIDPlayerPos( i, pPP->xpos, pPP->zpos, pPP->dir,
                                  pPP->speed);
            }
        }
    }
    _pCommPlayerWork->bPosAllSend = FALSE; // tO𗎂ƂĂ
}

//==============================================================================
/**
 * bXgIɌĂяoĂ炤
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _talkMenuEnd(int selectNo)
{
    if(_pCommPlayerWork){
        _pCommPlayerWork->bTalkMenuDisp=FALSE;
    }
}

//==============================================================================
/**
 * lbgv[[Ǘ}l[W[̃[NTCY擾
 * @param   none
 * @retval  u32   [NTCY
 */
//==============================================================================

u32 CommPlayerGetWorkSize(void)
{
    return sizeof(CommPlayerWork);
}

//==============================================================================
/**
 * lbgv[[ǉ
 * @param   netID  q@e@ID
 * @retval  none
 */
//==============================================================================

static void _commPlayerAdd(u8 netID)
{
    fx32 xpos, zpos;
    PLAYER_STATE_PTR pPlayer;

    if(_pCommPlayerWork->pPlayer[netID]!=NULL){
        return;  //łɂꍇ
    }
    if(_pCommPlayerWork->bResetting){
        OHNO_PRINT("reset %d  \n", netID);
        return;  // 
    }
    {
        MYSTATUS* pMy = CommInfoGetMyStatus(netID);
        if(pMy){
            pPlayer = Player_Init( _pCommPlayerWork->pFSys->fldobjsys,
                                   _pCommPlayerWork->sPlayerPlace[netID].xpos,
                                   _pCommPlayerWork->sPlayerPlace[netID].zpos,
                                   _pCommPlayerWork->sPlayerPlace[netID].dir,
                                   HERO_FORM_NORMAL, MyStatus_GetMySex(pMy), NULL );
            OHNO_PRINT("  id %d=%d\n",netID,MyStatus_GetMySex(pMy));
            GF_ASSERT_RETURN(pPlayer && "NetPlayerłȂ",);
            _pCommPlayerWork->pPlayer[netID] = pPlayer;
        }
    }
	
    // ʒu𑗂Ԃ
//    _pCommPlayerWork->moveSync = FALSE;
 /*   OHNO_PRINT("lbgLo^ %d (%d,%d)\n", netID,
               _pCommPlayerWork->sPlayerPlace[netID].xpos,
               _pCommPlayerWork->sPlayerPlace[netID].zpos);
*/
}

//==============================================================================
/**
 * lbgv[[폜
 * @param   netID  q@e@ID
 * @retval  none
 */
//==============================================================================

static void _commPlayerDestroy(u8 netID, BOOL bExit)
{
    int i;
//    OHNO_PRINT("lbgv[[ %d\n", netID);
    if(_pCommPlayerWork == NULL){
        return;
    }
    if(_pCommPlayerWork->pMark[netID] != NULL){
        EOA_Delete(_pCommPlayerWork->pMark[netID]);
        _pCommPlayerWork->pMark[netID] = NULL;
    }
    if(_pCommPlayerWork->pPlayer[netID] != NULL){
        if(_pCommPlayerWork->pFSys->player != _pCommPlayerWork->pPlayer[netID]){
            Player_Delete(_pCommPlayerWork->pPlayer[netID]);
        }
        _pCommPlayerWork->pPlayer[netID] = NULL;
    }
    if((_pCommPlayerWork->bActive[netID]) && (!bExit)){
        _pCommPlayerWork->bActive[netID] = FALSE;
    }

    if(!bExit){
        for(i = 0; i < _KEEP_FLAG_MAX; i++){
            if(_pCommPlayerWork->pKeepFlag[netID][i] != NULL){
                sys_FreeMemoryEz(_pCommPlayerWork->pKeepFlag[netID][i]);
                _pCommPlayerWork->pKeepFlag[netID][i] = NULL;
            }
        }
        if(_pCommPlayerWork->pNowFlag[netID] != NULL){
            sys_FreeMemoryEz(_pCommPlayerWork->pNowFlag[netID]);
            _pCommPlayerWork->pNowFlag[netID] = NULL;
        }
        if(UgManagerIsInitialize()){
            /// ʐMEl̔閧n
            UgSecretBaseDestroyPlayer(netID);
        }

    }


}

//==============================================================================
/**
 * CommPlayer̒ʏ폈
 * @param   netID  q@e@ID
 * @retval  none
 */
//==============================================================================

static void _commPlayerTask(TCB_PTR tcb, void *work)
{
    if(CommIsInitialize()){
        if(CommGetCurrentID() == COMM_PARENT_ID){
            _commPlayerDataSendTaskToChild(tcb, work); // q@ɈʒuM
            _commPlayerDataSendTask(tcb, work); // bǗ
            CommPlayerCondStep(_pCommPlayerWork->pCondMgr);  // e@ŃRfBV
        }
        else{
            _commPlayerDataSendTask(tcb, work); // bǗ
        }
        _commPlayerAutoStep(tcb, work);  // vC[add deleteǗ
    }
}


//==============================================================================
/**
 * ʐMԂāAlbgv[[zu͂肷
 * @param   tcb			TCBւ̃|C^
 * @param   work		none
 * @retval  none
 */
//==============================================================================

static void _commPlayerAutoStep(TCB_PTR tcb, void *work)
{
    int i, dir;

    for(i = 0; i < COMM_MACHINE_MAX; i++){
        if(CommIsConnect(i)  || (CommGetAloneMode() && (i == COMM_PARENT_ID)) ){  // ICȂ
            _playerMoveClient(i);
            _setFlagDisp(i);
        }
        else{  // ItCȂ
            if(_pCommPlayerWork->bActive[i]){
                if((CommGetCurrentID()==COMM_PARENT_ID) && (i != COMM_PARENT_ID)){
                    u8 creatureID = i;
                    // 
                 //   OHNO_PRINT("ߔs\n");
                    CommSendData_ServerSide(CF_PLAYER_DELETE, &creatureID, 0);
                    _commPlayerDestroy(i, FALSE);  //e@͂ŏ
                }
            }
        }
    }
}

//==============================================================================
/**
 * @̈ړ\Ԃǂ𒲂ׂ
 * @param   none
 * @retval  @ړ\Ԃ̏ꍇTRUE
 */
//==============================================================================

BOOL CommPlayerIsMyMoveControl(void)
{
    if(_pCommPlayerWork != NULL){
        return _pCommPlayerWork->bMyMoveControl;
    }
    return FALSE;
}

//==============================================================================
/**
 * @̈ړ\Ԃǂݒ肷
 *    ԂLĂ gK[e@ɑM
 * @param   bMoveControl  @ړ\Ԃǂ
 * @retval  none
 */
//==============================================================================

void CommPlayerSetMoveControl(BOOL bMoveControl)
{
    if(_pCommPlayerWork != NULL){
        if(_pCommPlayerWork->bMyMoveControl != bMoveControl){
            _pCommPlayerWork->bMyMoveControl = bMoveControl;
            CommSendFixSizeData(CF_MOVE_CONTROL,&_pCommPlayerWork->bMyMoveControl);   // M
        }
    }
}

//==============================================================================
/**
 * ړ\ԂǂM
 * @param   netID    MĂID
 * @param   size     Ăf[^TCY
 * @param   pData    ̃|C^
 * @retval  none
 */
//==============================================================================

void CommPlayerRecvMoveControl(int netID, int size, void* pData, void* pWork)
{
    u8* pBuff = (u8*)pData;

    if(_pCommPlayerWork){
        GF_ASSERT_RETURN(size == 1,);
        GF_ASSERT_RETURN(netID < COMM_MACHINE_MAX,);
        GF_ASSERT_RETURN((pBuff[0] == TRUE)||(pBuff[0] == FALSE),);
        _pCommPlayerWork->bMoveControl[netID] = pBuff[0];
    }
}

//==============================================================================
/**
 * Sړ
 * @param   repw		  FIELDSYS_WORK̃|C^
 * @retval  none
 */
//==============================================================================

void CommPlayersMove(FIELDSYS_WORK * repw, BOOL bMoveControl)
{
    if(_pCommPlayerWork==NULL){
        return;
    }
    CommPlayerSetMoveControl(bMoveControl);  // @̈ړԂݒ
    
    if(repw->player){
        _pCommPlayerWork->pPlayer[CommGetCurrentID()] = repw->player;
    }
    if(CommIsInitialize() && (CommGetCurrentID() == COMM_PARENT_ID)){
        // e@=SERVERړsAq@͂̌ʂœ
        _commPlayerMove(NULL, _pCommPlayerWork);
    }
#if PM_DEBUG
   // _debugGyoeDisp();
#endif
}

//--------------------------------------------------------------
/**
 * L[gKAvX牟Ă擾
 * @param	key_trg 	L[gK
 * @param	key_prs		L[vX
 * @retval	int			ĂBDIR_UP
 */
//--------------------------------------------------------------
static int _keyDirGet( u16 key_trg, u16 key_cont )
{
	if( (key_cont & PAD_KEY_LEFT) ){
		return( DIR_LEFT );
	}
	
	if( (key_cont & PAD_KEY_RIGHT) ){
		return( DIR_RIGHT );
	}
	
	if( (key_cont & PAD_KEY_UP) ){
		return( DIR_UP );
	}
	
	if( (key_cont & PAD_KEY_DOWN) ){
		return( DIR_DOWN );
	}
	
	return( DIR_NOT );
}

//==============================================================================
/**
 * n`ƃlbgv[[̂𔻒
 * @param   tcb      ^XN|C^
 * @param   work     [N\̂̃|C^
 * @retval  HIT݂ꍇTRUE  ꍇFALSE
 */
//==============================================================================

static BOOL _commGetHitAttr(int x, int z, int netID)
{
    int i;

    if((x != COMM_PLAYER_INVALID_GRID) && (z != COMM_PLAYER_INVALID_GRID)){
        for(i = 0; i < COMM_MACHINE_MAX; i++){
            if(i == netID){
                continue;
            }
            if((x == CommPlayerGetGridSX(i)) && (z == CommPlayerGetGridSZ(i))){
                OHNO_PRINT("v[[m̂\n");
                return TRUE;
            }
        }
        if(UgNPCHitCheck(x,z)){
            return TRUE;
        }
        if(UgManagerIsInitialize()){
            if(!UgSecretBaseMoveing(x, z)){
                return TRUE;
            }
        }
    }
    return GetHitAttr(_pCommPlayerWork->pFSys, x, z);
}

//==============================================================================
/**
 * 㩂ɂĂ邩ǂ
 * @param   targetID
 * @retval  ĂTRUE
 */
//==============================================================================

BOOL CommPlayerIsTrapBind(int targetID)
{
    return !CommPlayerIsMoveCondition_ServerSide(
        CommPlayerCondGetWork(_pCommPlayerWork->pCondMgr, targetID));
}

//--------------------------------------------------------------
/**
 * ΂̈ړJEg
 * @param	netID  id
 * @retval	ړl
 */
//--------------------------------------------------------------

static int _getBlowMoveCount( int counter, int bBigBlow)
{
    int max;

    if(counter < 5){
        return 8;
    }
    else if(counter < 10){
        return 4;
    }
    if(bBigBlow){
        max = _BIGBLOW_COUNTER_NUM_MAX;
    }
    else{
        max = _BLOW_COUNTER_NUM_MAX;
    }
    if(counter < (max - _BLOW_STOP_COUNT)){
        return 2;
    }
    return 1;
}

//==============================================================================
/**
 * ML[f[^Ɉړ
 * @param   tcb      ^XN|C^
 * @param   work     [N\̂̃|C^
 * @retval  none
 */
//==============================================================================

static void _commPlayerMove(TCB_PTR tcb, void *work)
{
    u16 trg, cont;
    int dir, x, z, i;
    _PlayerPlace* pPP;
    
    for(i = 0; i < COMM_MACHINE_MAX; i++){
        if(_pCommPlayerWork->bActive[i] && _pCommPlayerWork->bMoveControl[i]){
            pPP = &_pCommPlayerWork->sPlayerPlaceServer[i];
            if(_pCommPlayerWork->walkCount[i] != 0){
                _pCommPlayerWork->walkCount[i]--;
            }
            if(UgManagerIsInitialize()){
                if(CommSecretBaseIsTraveling(i)){   // ꏊړ
                    continue;
                }
            }
            if(_pCommPlayerWork->walkCount[i]==0){   // I^C~O㩌
                if(UgManagerIsInitialize()){
                    if(CommTrapCheckAndSendMessage( i )){ // 㩏
                        continue;
                    }
                }
            }
            if(!CommPlayerIsMoveCondition_ServerSide(CommPlayerCondGetWork(_pCommPlayerWork->pCondMgr, i))){
                continue;
            }
            trg = CommGetPadTrg(i);
            cont = CommGetPadCont(i);
            pPP->speed = _SPEED_8;
            if((CommGetPadCont(i) & JIKI_DASH_BUTTON) != 0){
                pPP->speed = _SPEED_4;
            }
#if PM_DEBUG
            if((CommGetPadCont(i) & DEBUG_WALK_PAD) != 0 ){
                pPP->speed = _SPEED_2;
            }
#endif
            if(_pCommPlayerWork->walkCount[i]!=0){
                continue;
            }
            if(_blowMove(i)){
                _pCommPlayerWork->walkCount[i] = _getBlowMoveCount(_pCommPlayerWork->blowCounterS[i],_pCommPlayerWork->bBlowBigS[i] );
                _pCommPlayerWork->bMoveChange[i]=TRUE;
                continue;
            }
            if(_pCommPlayerWork->countHole[i] == 1){
                u8 bRet = TRUE;
                CommTrapRecvEnd(i, 1, &bRet,NULL);
                _pCommPlayerWork->countHole[i] = 0;
            }
            dir = _keyDirGet(trg,cont);
            x = CommPlayerGetGridSXDirAdd(i);
            z = CommPlayerGetGridSZDirAdd(i);
            if((x!=COMM_PLAYER_INVALID_GRID) && (z !=COMM_PLAYER_INVALID_GRID) && (dir != DIR_NOT)){
                if(pPP->dir != dir){
                    // ړϊ̂
                    pPP->dir = dir;
                    _pCommPlayerWork->walkCount[i] = 4;
                    _pCommPlayerWork->bMoveChange[i]=TRUE;
                    if(_pCommPlayerWork->countHole[i] != 0){
                        _pCommPlayerWork->countHole[i]--;
                        if(_pCommPlayerWork->countHole[i] == 0){
                            u8 bRet = TRUE;
                            CommTrapRecvEnd(i, 1, &bRet,NULL);
                        }
                        else if(_pCommPlayerWork->countHole[i] == 1){
                            u8 id = i;
                            _pCommPlayerWork->walkCount[i] = 20;  //
                            CommSendFixSizeData_ServerSide(CF_TRAP_PRIEND,&id);
                        }
                    }
                }
                else if(_pCommPlayerWork->countHole[i] != 0){
                    continue;
                }
                else if( UgManagerIsInitialize() && (CommSecretBaseSingleStepFunc(i,x,z) == TRUE)){
                    continue;  // 閧nړJn
                }
#ifdef PM_DEBUG
                else if(!_commGetHitAttr( x, z, i) || (pPP->speed == _SPEED_2)){
#else
                else if(!_commGetHitAttr( x, z, i)){
#endif
                    _pCommPlayerWork->bMoveChange[i]=TRUE;
                    pPP->xpos = x;
                    pPP->zpos = z;
                    pPP->dir = dir;
//                    OHNO_SP_PRINT("T[o[ʒu  playerMOVE  %d %d %d\n",x,z,dir);
                    _pCommPlayerWork->walkCount[i] = 8;
                    if(pPP->speed == _SPEED_4){
                        _pCommPlayerWork->walkCount[i] = 4;
                    }
                    if(pPP->speed == _SPEED_2){
                        _pCommPlayerWork->walkCount[i] = 2;
                    }
                    if(_pCommPlayerWork->giddyCounter[i]!=0){
                        _pCommPlayerWork->giddyCounter[i]--;
                        if(_pCommPlayerWork->giddyCounter[i]==0){
                            u8 bRet = TRUE;
                            CommTrapRecvEnd(i, 1, &bRet,NULL);
                        }
                    }
                }
            }
        }
    }
}

//==============================================================================
/**
 * ʒȕM   CF_PLAYER_POS
 * @param   netID    MĂID
 * @param   size     Ăf[^TCY
 * @param   pData    ړ|C^
 * @retval  none
 */
//==============================================================================

void CommPlayerRecvPlace(int netID, int size, void* pBuff, void* pWork)
{
    u8* pData = (u8*)pBuff;
    _PlayerPlace* pPP;

    if(_pCommPlayerWork==NULL){
        return;
    }
    pPP = &_pCommPlayerWork->sPlayerPlaceServer[netID];

    if(pData[4] & _BIT_LIVE){
        if(_pCommPlayerWork->bActive[netID]){
            _pCommPlayerWork->bPosAllSend = TRUE;
//            _pCommPlayerWork->bMoveChange[netID] = TRUE;
            return;
        }
    }
    if(pPP->dir == DIR_NOT){  // ܂Ԃ̏ꍇ
        // ʒuf[^q@ɑM
        _pCommPlayerWork->bPosAllSend = TRUE;
    }
    pPP->xpos = 0;
    pPP->zpos = 0;
    pPP->xpos += ((u32)pData[0]) & 0xff;
    pPP->xpos += ((u32)pData[1] << 8) & 0xff00;
    pPP->zpos += ((u32)pData[2]) & 0xff;
    pPP->zpos += ((u32)pData[3] << 8) & 0xff00;
    pPP->dir = pData[4] & 0x0f;

    OHNO_PRINT("CommPlayerRecvPlace %d %d %d\n", netID, pPP->xpos, pPP->zpos);
    _pCommPlayerWork->bActive[netID] = TRUE;
    _pCommPlayerWork->bMoveChange[netID] = TRUE;
}


//==============================================================================
/**
 * v[[߂M
 * @param   netID    MĂID
 * @param   size     Ăf[^TCY
 * @param   pData    ړ|C^
 * @retval  none
 */
//==============================================================================

void CommPlayerRecvDelete(int netID, int size, void* pBuff, void* pWork)
{
    u8* pData = (u8*)pBuff;
    u8 creatureID = pData[0];
    
    if(_pCommPlayerWork == NULL){
        return;
    }
//    OHNO_PRINT("v[[߂M\n");
    _commPlayerDestroy(creatureID, FALSE);
}

//==============================================================================
/**
 * ꏊ𑗂f[^̃TCYԂ܂
 * @param   none
 * @retval  f[^TCY
 */
//==============================================================================

int CommPlayerGetRecvPlaceSize(void)
{
    return _PLACEDATA_SEND_SIZE;
}


//==============================================================================
/**
 * IDwňʒȕM CF_PLAYER_POS_ID
 * @param   netID    MĂID
 * @param   size     Ăf[^TCY
 * @param   pData    ړ|C^
 * @retval  none
 */
//==============================================================================

void CommPlayerRecvIDPlace(int netID, int size, void* pBuff, void* pWork)
{
    u16 pad;
    u8* pData = (u8*)pBuff;
    _PlayerPlace* pPP;
    int creatureID;

    creatureID = pData[0] & 0xf;
    if(_pCommPlayerWork == NULL){
        OHNO_PRINT("----------󂯎Ȃ PlaceID %d\n", creatureID);
        return;
    }
    
    pPP = &_pCommPlayerWork->sPlayerPlace[creatureID];
    pPP->xpos = 0;
    pPP->zpos = 0;
    pPP->xpos += ((u32)pData[1]) & 0xff;
    pPP->xpos += ((u32)pData[2] << 8) & 0x0f00;
    pPP->zpos += ((u32)pData[3]) & 0xff;
    pPP->zpos += ((u32)pData[2] << 4) & 0x0f00;
    pPP->dir = ((pData[0] >> 4) & 0x3);
    pPP->speed = ((pData[0] >> 6) & 0x3);

    //OHNO_PRINT("-->> PlaceID %d %d %d %d\n", creatureID, pPP->xpos, pPP->zpos, pPP->dir);
    _pCommPlayerWork->bActive[creatureID] = TRUE;
    _commPlayerAdd(creatureID);
}

//--------------------------------------------------------------
/**
 * ΂㩂𓥂񂾏ꍇ̈ړ
 * @param	dir		ړBDIR_UP
 * @retval	ITRUE
 */
//--------------------------------------------------------------
static BOOL _blowAnim( int netID,int padTrg,int padCont,int speed )
{
    FIELD_OBJ_PTR fldobj;
    int idx, dir;
    u8 walkcmd[]={
        AC_WALK_U_2F,				///<Ɉړ@2t[
        AC_WALK_D_2F,				///<Ɉړ@2t[
        AC_WALK_L_2F,				///<Ɉړ@2t[
        AC_WALK_R_2F,				///<EɈړ@2t[
        AC_WALK_U_4F,				///<Ɉړ@4t[
        AC_WALK_D_4F,				///<Ɉړ@4t[
        AC_WALK_L_4F,				///<Ɉړ@4t[
        AC_WALK_R_4F,				///<EɈړ@4t[
        AC_WALK_U_8F,				///<Ɉړ@8t[
        AC_WALK_D_8F,				///<Ɉړ@8t[
        AC_WALK_L_8F,				///<Ɉړ@8t[
        AC_WALK_R_8F,				///<EɈړ@8t[
    };


    if(_pCommPlayerWork->blowDir[netID]==DIR_NOT){
        return FALSE;
    }
    if(_pCommPlayerWork->pPlayer[netID]==NULL){
        return FALSE;
    }

    // oɕĂω
    fldobj = Player_FieldOBJGet( _pCommPlayerWork->pPlayer[netID] );   //@̃tB[hOBJ|C^擾
    if(Player_DirGet(_pCommPlayerWork->pPlayer[netID])!=CommPlayerGetReverseDir(_pCommPlayerWork->blowDir[netID])){
        FieldOBJ_StatusBit_OFF( fldobj, FLDOBJ_STA_BIT_PAUSE_DIR );
        Player_DirSet(_pCommPlayerWork->pPlayer[netID], CommPlayerGetReverseDir(_pCommPlayerWork->blowDir[netID]));
        FieldOBJ_StatusBit_ON( fldobj, FLDOBJ_STA_BIT_PAUSE_DIR );
    }

    if( FieldOBJ_AcmdEndCheck(fldobj) == TRUE ){ //AjI`FbN

	}

    if( FieldOBJ_AcmdSetCheck(fldobj) == TRUE ){//AjZbgł邩?
        switch( speed  ){
          case _SPEED_2:
            FieldOBJ_AcmdSet( fldobj, walkcmd[_pCommPlayerWork->blowDir[netID]] ); //oBɈړ
            break;
          case _SPEED_4:
            FieldOBJ_AcmdSet( fldobj, walkcmd[_pCommPlayerWork->blowDir[netID]+4] ); //oBɈړ
            break;
          case _SPEED_8:
            FieldOBJ_AcmdSet( fldobj, walkcmd[_pCommPlayerWork->blowDir[netID]+8] ); //oBɈړ
            break;
        }
    }else{
        //@@@@@@̃AjsɂoȂBo܂ő҂
    }
    return TRUE;
}

//==============================================================================
/**
 * NCAg̈ړ  P}XÂȂ悤ɂȂĂ
 * @param   netID
 * @retval  none
 */
//==============================================================================

static void _playerMoveClient(int netID)
{
    u16 pad;
    _PlayerPlace* pPP;
    PLAYER_STATE_PTR pPlayerState;

    pPP = &_pCommPlayerWork->sPlayerPlace[netID];
    if((pPP->xpos == COMM_PLAYER_INVALID_GRID) || (pPP->zpos == COMM_PLAYER_INVALID_GRID)){
        return;
    }
    if(_pCommPlayerWork->bResetting){
        return;
    }
    
    pPlayerState = _pCommPlayerWork->pPlayer[netID];
    if( pPlayerState ){
        int x = Player_NowGPosXGet( pPlayerState ) - pPP->xpos;
        int z = Player_NowGPosZGet( pPlayerState ) - pPP->zpos;
        int dir = Player_DirGet( pPlayerState );

        if(abs(x) > abs(z)){
            if(x > 0){
                pad = PAD_KEY_LEFT;
            }
            else{
                pad = PAD_KEY_RIGHT;
            }
        }
        else{
            if(z > 0){
                pad = PAD_KEY_UP;
            }
            else{
                pad = PAD_KEY_DOWN;
            }
        }

        
        if((x == 0) && (z == 0)){
            if(pPP->dir != dir){
                Player_DirSet(pPlayerState, pPP->dir);
            }
            return;
        }

        if(_blowAnim(netID,pad,pad,pPP->speed)){
            return;
        }

        if(pPP->speed == _SPEED_4){
            pad |= JIKI_DASH_BUTTON;
        }
#ifdef PM_DEBUG
        if(pPP->speed == _SPEED_2){
            pad |= DEBUG_WALK_PAD;
        }
#endif
        Player_MoveControl( pPlayerState,
                            _pCommPlayerWork->pFSys->map_cont_dat,
                            DIR_NOT, pad, pad );

        x = Player_NowGPosXGet( pPlayerState );
        z = Player_NowGPosZGet( pPlayerState );
//        OHNO_SP_PRINT("NCAg %d %d\n",x,z);
        
    }
}

//--------------------------------------------------------------
/**
 * ΂㩂𓥂񂾏ꍇ̃T[o[ړ
 * @param	netID  id
 * @retval	ITRUE
 */
//--------------------------------------------------------------
static BOOL _blowMove( int netID )
{
    int x,z;
    _PlayerPlace* pPP;
    
    if(_pCommPlayerWork->blowCounterS[netID]==0){
        return FALSE;
    }
    if(1 == _getBlowMoveCount(_pCommPlayerWork->blowCounterS[netID],_pCommPlayerWork->bBlowBigS[netID] )){
        // ~
        _pCommPlayerWork->blowCounterS[netID]--;
        return TRUE;
    }
    _pCommPlayerWork->blowCounterS[netID]--;
    x = CommPlayerGetGridSX(netID);
    z = CommPlayerGetGridSZ(netID);
    x += FieldOBJ_DirAddValueGX(_pCommPlayerWork->blowDirS[netID]);
    z += FieldOBJ_DirAddValueGZ(_pCommPlayerWork->blowDirS[netID]);

    if(_commGetHitAttr(x, z, netID)){
        _pCommPlayerWork->blowCounterS[netID] = 0;
        {
            u8 bRet = FALSE;
            CommTrapRecvEnd(netID, 1, &bRet,NULL);
        }
        return TRUE;
    }
    if(_pCommPlayerWork->blowCounterS[netID]==0){
        {
            u8 bRet = TRUE;
            CommTrapRecvEnd(netID, 1, &bRet,NULL);
        }
        return TRUE;
    }
    pPP = &_pCommPlayerWork->sPlayerPlaceServer[netID];
    pPP->xpos = x;
    pPP->zpos = z;
    switch(_getBlowMoveCount(_pCommPlayerWork->blowCounterS[netID],_pCommPlayerWork->bBlowBigS[netID] )){
      case 2:
        pPP->speed = _SPEED_2;
        break;
      case 4:
        pPP->speed = _SPEED_4;
        break;
      case 8:
            pPP->speed = _SPEED_8;
        break;
    }
    return TRUE;
}

//--------------------------------------------------------------
/**
 * ΂㩂𓥂񂾏ꍇ̃T[oړJn
 * @param	netID   i
 * @param	dir		ړBDIR_UP
 * @param	bBig    ΂傫
 * @retval	ITRUE
 */
//--------------------------------------------------------------
void CommPlayerBlowStart( int netID, int dir , BOOL bBig)
{
    _PlayerPlace* pPP = &_pCommPlayerWork->sPlayerPlaceServer[netID];

    pPP->dir = CommPlayerGetReverseDir(dir);  // 
    _pCommPlayerWork->blowDirS[netID] = dir;  // ΂
    if(bBig){
        _pCommPlayerWork->bBlowBigS[netID] = TRUE;
        _pCommPlayerWork->blowCounterS[netID] = _BIGBLOW_COUNTER_NUM_MAX + _BLOW_STOP_COUNT;
    }
    else{
        _pCommPlayerWork->bBlowBigS[netID] = FALSE;
        _pCommPlayerWork->blowCounterS[netID] = _BLOW_COUNTER_NUM_MAX + _BLOW_STOP_COUNT;
    }

    _pCommPlayerWork->bMoveChange[netID]=TRUE;
}

//--------------------------------------------------------------
/**
 * ΂㩂Iꍇ̏
 * @param   victimNetID   QID
 * @retval	ITRUE
 */
//--------------------------------------------------------------
void CommPlayerBlowExit(int victimNetID)
{
    _pCommPlayerWork->blowCounterS[victimNetID] = 0;
}

//--------------------------------------------------------------
/**
 * ΂㩂𓥂񂾏ꍇ̈ړJn
 * @param	dir		ړBDIR_UP
 * @retval	ITRUE
 */
//--------------------------------------------------------------
void CommPlayerBlowAnimStart( int netID, int dir , BOOL bBig)
{
	FIELD_OBJ_PTR fldobj;

    if(_pCommPlayerWork->pPlayer[netID]==NULL){
      return;
    }
    fldobj = Player_FieldOBJGet( _pCommPlayerWork->pPlayer[netID] );   //@̃tB[hOBJ|C^擾

    FieldOBJ_StatusBit_ON( fldobj, FLDOBJ_STA_BIT_PAUSE_DIR );
    FieldOBJ_StatusBit_ON( fldobj, FLDOBJ_STA_BIT_PAUSE_ANM );
    FE_DirTrap_Add(_pCommPlayerWork->pFSys,
                   CommPlayerGetGridX(netID),CommPlayerGetGridZ(netID),dir);

    _pCommPlayerWork->blowDir[netID] =dir;
}

//--------------------------------------------------------------
/**
 * ΂㩂𓥂񂾏ꍇ̈ړ~
 * @param	netID   id
 * @retval	none
 */
//--------------------------------------------------------------
void CommPlayerBlowAnimStop( int netID)
{
	FIELD_OBJ_PTR fldobj;
    if(_pCommPlayerWork->pPlayer[netID]==NULL){
      return;
    }
    fldobj = Player_FieldOBJGet( _pCommPlayerWork->pPlayer[netID] );   //@̃tB[hOBJ|C^擾
    FieldOBJ_AcmdEnd(fldobj); 			 //AjSI
    FieldOBJ_StatusBit_OFF( fldobj, FLDOBJ_STA_BIT_PAUSE_DIR );
    FieldOBJ_StatusBit_OFF( fldobj, FLDOBJ_STA_BIT_PAUSE_ANM );
    _pCommPlayerWork->blowDir[netID] = DIR_NOT;
}

//==============================================================================
/**
 * IDŏꏊ𑗂f[^̃TCYԂ܂
 * @param   none
 * @retval  f[^TCY
 */
//==============================================================================

int CommPlayerGetRecvIDPlaceSize(void)
{
    return _IDPLACEDATA_SEND_SIZE;
}

//==============================================================================
/**
 * bf[^M܂
 * @param   netID         b𑗐MĂ
 * @param   size          Mf[^TCY
 * @param   pData         bZ[W܂܂Ăf[^
 * @retval  none
 */
//==============================================================================

static void _recvTalk(int netID, int size, void* pData, void* pWork)
{
}

void CommPlayerRecvTalk(int netID, int size, void* pData, void* pWork)
{
    // ɂ݂ȂɕԐM
    CommSendData_ServerSide(CF_TALK_DISP_SERVER_SIDE, pData, size);
}

void CommPlayerRecvTalk_ServerSide(int netID, int size, void* pData, void* pWork)
{
    _recvTalk(netID, size, pData, pWork);
}


void CommPlayerRecvFixedTalk(int netID, int size, void* pData, void* pWork)
{
    CommSendData_ServerSide(CF_FIXED_TALK_SERVER_SIDE, pData, size);
}

//--------------------------------------------------------------
/**
 * @brief   bZ[W\ꍇ̏IR[obN
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------
static void _msgEndCallBack(int num)
{
    FieldSystemProc_SeqHoldEnd();
}


void CommPlayerRecvFixedTalk_ServerSide(int netID, int size, void* pData, void* pWork)
{
    u8* pBuff = pData;
    
    if(CommGetCurrentID() == pBuff[0]){
        CommMsgTalkWindowStart(CommUnderGetMsgUnderWorld(),
                               pBuff[2],TRUE,_msgEndCallBack);
    }
}

int CommPlayerRecvFixedTalkSize(void)
{
    return 3;
}

//--------------------------------------------------------------
/**
 * @brief   v[[LʐMɂړԂɂ邩ǂ
 * @param   none
 * @retval  ʐMňړꍇTRUE
 */
//--------------------------------------------------------------

BOOL CommPlayerIsControl(void)
{
    if(CommGetAloneMode()){
        return TRUE;
    }
    if(!_pCommPlayerWork){
        return FALSE;
    }
    if(!CommIsConnect(CommGetCurrentID()) ){  // ICȂOK
        return FALSE;
    }
    if(!CommIsUnderGroundMoveState()){
        return FALSE;
    }
    return TRUE;

}

//--------------------------------------------------------------
/**
 * @brief   v[[LẌʒuԂ
 * @param   netID lbg[NłID
 * @retval  X̏ꏊ
 */
//--------------------------------------------------------------

int CommPlayerGetGridX(int netID)
{
    if(!_pCommPlayerWork){
        return COMM_PLAYER_INVALID_GRID;
    }
    else if(CommGetCurrentID() == netID){
        return _pCommPlayerWork->sPlayerPlace[netID].xpos;
    }
    else if(!CommPlayerIsControl() || !_pCommPlayerWork->bActive[netID]){
        return COMM_PLAYER_INVALID_GRID;
    }
    return _pCommPlayerWork->sPlayerPlace[netID].xpos;
}

//--------------------------------------------------------------
/**
 * @brief   v[[LZ̈ʒuԂ
 * @param   netID lbg[NłID
 * @retval  Z̏ꏊ
 */
//--------------------------------------------------------------

int CommPlayerGetGridZ(int netID)
{
    if(!_pCommPlayerWork){
        return COMM_PLAYER_INVALID_GRID;
    }
    else if(CommGetCurrentID() == netID){
        return _pCommPlayerWork->sPlayerPlace[netID].zpos;
    }
    else if(!CommPlayerIsControl() || !_pCommPlayerWork->bActive[netID]){
        return COMM_PLAYER_INVALID_GRID;
    }
    return _pCommPlayerWork->sPlayerPlace[netID].zpos;
}

//--------------------------------------------------------------
/**
 * @brief   v[[L̖ڂ̑ÖʒuԂ
 * @param   netID lbg[NłID
 * @retval  X̏ꏊ
 */
//--------------------------------------------------------------

int CommPlayerGetGridXDirAdd(int netID)
{
    if(CommPlayerGetGridX(netID) == COMM_PLAYER_INVALID_GRID){
        return COMM_PLAYER_INVALID_GRID;
    }
    return _pCommPlayerWork->sPlayerPlace[netID].xpos +
        FieldOBJ_DirAddValueGX(_pCommPlayerWork->sPlayerPlace[netID].dir);
}

//--------------------------------------------------------------
/**
 * @brief   v[[L̖ڂ̑ÖʒuԂ
 * @param   netID lbg[NłID
 * @retval  Z̏ꏊ
 */
//--------------------------------------------------------------

int CommPlayerGetGridZDirAdd(int netID)
{
    if(CommPlayerGetGridZ(netID) == COMM_PLAYER_INVALID_GRID){
        return COMM_PLAYER_INVALID_GRID;
    }
    return _pCommPlayerWork->sPlayerPlace[netID].zpos +
        FieldOBJ_DirAddValueGZ(_pCommPlayerWork->sPlayerPlace[netID].dir);
}

//--------------------------------------------------------------
/**
 * @brief   v[[LẌʒuԂ
 * @param   netID lbg[NłID
 * @retval  X̏ꏊ
 */
//--------------------------------------------------------------

int CommPlayerGetGridSX(int netID)
{
    if(!_pCommPlayerWork){
        return COMM_PLAYER_INVALID_GRID;
    }
    else if(CommGetCurrentID() == netID){
        return _pCommPlayerWork->sPlayerPlaceServer[netID].xpos;
    }
    else if(!CommPlayerIsControl() || !_pCommPlayerWork->bActive[netID]){
        return COMM_PLAYER_INVALID_GRID;
    }
    return _pCommPlayerWork->sPlayerPlaceServer[netID].xpos;
}

//--------------------------------------------------------------
/**
 * @brief   v[[LZ̈ʒuԂ
 * @param   netID lbg[NłID
 * @retval  Z̏ꏊ
 */
//--------------------------------------------------------------

int CommPlayerGetGridSZ(int netID)
{
    if(!_pCommPlayerWork){
        return COMM_PLAYER_INVALID_GRID;
    }
    else if(CommGetCurrentID() == netID){
        return _pCommPlayerWork->sPlayerPlaceServer[netID].zpos;
    }
    else if(!CommPlayerIsControl() || !_pCommPlayerWork->bActive[netID]){
        return COMM_PLAYER_INVALID_GRID;
    }
    return _pCommPlayerWork->sPlayerPlaceServer[netID].zpos;
}

//--------------------------------------------------------------
/**
 * @brief   v[[L̖ڂ̑ÖʒuԂ
 * @param   netID lbg[NłID
 * @retval  X̏ꏊ
 */
//--------------------------------------------------------------

int CommPlayerGetGridSXDirAdd(int netID)
{
    if(CommPlayerGetGridSX(netID) == COMM_PLAYER_INVALID_GRID){
        return COMM_PLAYER_INVALID_GRID;
    }
    return _pCommPlayerWork->sPlayerPlaceServer[netID].xpos +
        FieldOBJ_DirAddValueGX(_pCommPlayerWork->sPlayerPlaceServer[netID].dir);
}

//--------------------------------------------------------------
/**
 * @brief   v[[L̖ڂ̑ÖʒuԂ
 * @param   netID lbg[NłID
 * @retval  Z̏ꏊ
 */
//--------------------------------------------------------------

int CommPlayerGetGridSZDirAdd(int netID)
{
    if(CommPlayerGetGridSZ(netID) == COMM_PLAYER_INVALID_GRID){
        return COMM_PLAYER_INVALID_GRID;
    }
    return _pCommPlayerWork->sPlayerPlaceServer[netID].zpos +
        FieldOBJ_DirAddValueGZ(_pCommPlayerWork->sPlayerPlaceServer[netID].dir);
}

//--------------------------------------------------------------
/**
 * @brief   v[[LdirԂ
 * @param   netID lbg[NłID
 * @retval  dir
 */
//--------------------------------------------------------------

int CommPlayerGetDir(int netID)
{
    if(!CommPlayerIsControl() || !_pCommPlayerWork->bActive[netID]){
        return DIR_NOT;
    }
    return _pCommPlayerWork->sPlayerPlace[netID].dir;
}

//--------------------------------------------------------------
/**
 * @brief   v[[LdirԂ
 * @param   netID lbg[NłID
 * @retval  dir
 */
//--------------------------------------------------------------

int CommPlayerGetSDir(int netID)
{
    if(!CommPlayerIsControl() || !_pCommPlayerWork->bActive[netID]){
        return DIR_NOT;
    }
    return _pCommPlayerWork->sPlayerPlaceServer[netID].dir;
}

//--------------------------------------------------------------
/**
 * @brief   ^[Qbg̊pxnetIDƋtɂ  ƌ͂
 * @param   netID lbg[NłID
 * @param   targetID lbg[Nł̃^[QbgID
 * @retval  none
 */
//--------------------------------------------------------------

void CommPlayerSetLook_Server(int netID, int targetID)
{
    int dir = CommPlayerGetReverseDir(_pCommPlayerWork->sPlayerPlaceServer[netID].dir);
    _pCommPlayerWork->sPlayerPlaceServer[targetID].dir = dir;
}

//--------------------------------------------------------------
/**
 * @brief   ^[Qbg̊pxnetIDƋtɂ  ƌ͂
 * @param   netID lbg[NłID
 * @param   targetID lbg[Nł̃^[QbgID
 * @retval  none
 */
//--------------------------------------------------------------

void CommPlayerSetLook(int netID, int targetID)
{
    int dir = CommPlayerGetReverseDir(_pCommPlayerWork->sPlayerPlace[netID].dir);
    _pCommPlayerWork->sPlayerPlace[targetID].dir = dir;
}

//--------------------------------------------------------------
/**
 * @brief   㩂ɂ̃v[[̏ԂZbg
 * @param   victimNetID  㩂ɂl
 * @param   trapType     㩃^Cv
 * @retval  none
 */
//--------------------------------------------------------------

void CommPlayerSetCondition(int victimNetID, int condition)
{
    CommPlayerCondSetCondition(
        CommPlayerCondGetWork(_pCommPlayerWork->pCondMgr, victimNetID),
        condition);
}

//--------------------------------------------------------------
/**
 * @brief   㩂ɂ̃v[[̏Ԃ
 * @param   victimNetID  㩂ɂl
 * @param   trapType     㩃^Cv
 * @retval  none
 */
//--------------------------------------------------------------

void CommPlayerResetCondition(int victimNetID)
{
    OHNO_PRINT("ZbgRfBV\n");
    CommPlayerCondSetCondition(
        CommPlayerCondGetWork(_pCommPlayerWork->pCondMgr, victimNetID),
        PLAYER_COND_NONE);
}

//--------------------------------------------------------------
/**
 * @brief   ꏊړ
 * @param   netID
 * @param   x
 * @param   y
 * @retval  none
 */
//--------------------------------------------------------------

void CommPlayerBaseTeleportServer(int netID, int x, int z, int dir)
{
    _PlayerPlace* pPP = &_pCommPlayerWork->sPlayerPlaceServer[netID];
    pPP->xpos = x + FieldOBJ_DirAddValueGX(dir);
    pPP->zpos = z + FieldOBJ_DirAddValueGZ(dir);
    pPP->dir = dir;
    _pCommPlayerWork->bMoveChange[netID]=TRUE;
}

//--------------------------------------------------------------
/**
 * @brief   ꏊړ
 * @param   netID
 * @param   x
 * @param   y
 * @retval  none
 */
//--------------------------------------------------------------

void CommPlayerBaseTeleportClient(int netID, int x, int z, int dir)
{
    _PlayerPlace* pPP;
    
    if(!_pCommPlayerWork){
        return;
    }
    pPP = &_pCommPlayerWork->sPlayerPlace[netID];
    pPP->xpos = x;
    pPP->zpos = z;
    pPP->dir = dir;
    if(_pCommPlayerWork->pPlayer[netID]){
        Player_GPosInit( _pCommPlayerWork->pPlayer[netID],
                         x, z, dir );
    }
}

typedef struct{
    u8 bOpen;
    u8 netID;
    u8 targetID;
} _ugMenuOpen;

//--------------------------------------------------------------
/**
 * @brief   YztB[hj[JĂ悢ǂ  CF_CHECK_FIELDMENU_OPEN
 * @param   R[obNp[^[
 * @retval  none
 */
//--------------------------------------------------------------

void CommPlayerRecvCheckFieldMenuOpen(int netID, int size, void* pData, void* pWork)
{
    _ugMenuOpen menuOpen;

    menuOpen.bOpen = _RESULT_NG;
    menuOpen.netID = netID;

    if(_pCommPlayerWork->bMoveControl[ netID ]){
        if(CommPlayerIsFlagData(netID)){
            menuOpen.bOpen = _RESULT_DELFLAG_OPEN;
        }
        else{
            menuOpen.bOpen = _RESULT_OK;
        }
        _pCommPlayerWork->bMoveControl[ netID ] = FALSE;
    }
    CommSendData_ServerSide(CF_RESULT_FIELDMENU_OPEN, &menuOpen, 2);
}

//--------------------------------------------------------------
/**
 * @brief   v[[ɂ邩ǂ
 * @param   xpos  ꏊ
 * @param   zpos
 * @retval  playernetID
 */
//--------------------------------------------------------------

int CommPlayerIsAlive(int xpos, int zpos)
{
    int i,x,y;

    if(!_pCommPlayerWork){
        return COMM_INVALID_ID;
    }
    for(i = 0; i < COMM_MACHINE_MAX; i++){
        if(_pCommPlayerWork->bActive[i] == NULL){
            continue;
        }
        x = _pCommPlayerWork->sPlayerPlaceServer[i].xpos;
        y = _pCommPlayerWork->sPlayerPlaceServer[i].zpos;

        if((xpos == x) && (zpos == y)){
            return i;
        }
    }
    return COMM_INVALID_ID;
}

//--------------------------------------------------------------
/**
 * @brief   STARTj[JĂǂ̃R[obN CF_RESULT_FIELDMENU_OPEN
 * @param   
 * @retval  none
 */
//--------------------------------------------------------------

void CommPlayerRecvResultFieldMenuOpen(int netID, int size, void* pData, void* pWork)
{
    _ugMenuOpen* pMenuOpen = pData;

    OHNO_PRINT("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^R}h\n");
    
    if((pMenuOpen->bOpen == _RESULT_OK) && (pMenuOpen->netID == CommGetCurrentID())){
        Snd_SePlay( SEQ_SE_DP_WIN_OPEN );
        //npj[o
        CommUnderBagInit(_talkMenuEnd, _pCommPlayerWork->pFSys);
    }
    else if((pMenuOpen->bOpen == _RESULT_DELFLAG_OPEN) && (pMenuOpen->netID == CommGetCurrentID())){
        CommUnderBagFlagStart(_talkMenuEnd, _pCommPlayerWork->pFSys);
    }
}

//--------------------------------------------------------------
/**
 * @brief   ₢j[JĂǂ̃R[obN
 *          CF_RESULT_UGMENU_OPEN
 * @param   ʐMR[obN
 * @retval  none
 */
//--------------------------------------------------------------

void CommPlayerRecvResultUGMenuOpen(int netID, int size, void* pData, void* pWork)
{
    _ugMenuOpen* pMenuOpen = pData;
    GF_ASSERT_RETURN(pMenuOpen->netID < COMM_MACHINE_MAX,);

    if(pMenuOpen->bOpen == _RESULT_OK){    // 
        CommPlayerSetLook(pMenuOpen->netID, pMenuOpen->targetID);
    }
    if((pMenuOpen->bOpen == _RESULT_OK) && (pMenuOpen->netID == CommGetCurrentID())){
        CommUnderTalkInit(pMenuOpen->targetID , _talkMenuEnd, _pCommPlayerWork->pFSys);
        _pCommPlayerWork->talkMenuInfo.netID = pMenuOpen->netID ;
        _pCommPlayerWork->talkMenuInfo.targetID = pMenuOpen->targetID;
        _pCommPlayerWork->talkMenuInfo.bItemMenu = FALSE;
        _pCommPlayerWork->talkMenuInfo.bPersonalInformation = FALSE;
    }
    if((pMenuOpen->bOpen == _RESULT_OK) && (pMenuOpen->targetID == CommGetCurrentID())){
        CommUnderTalkBind(pMenuOpen->targetID, pMenuOpen->netID, _pCommPlayerWork->pFSys);
    }
    if((pMenuOpen->bOpen == _RESULT_NG) && (pMenuOpen->netID == CommGetCurrentID())){
        FieldSystemProc_SeqHold();
        CommMsgTalkWindowStart(CommUnderGetMsgUnderWorld(),
                               msg_underworld_03,TRUE,_msgEndCallBack);
    }
}

//--------------------------------------------------------------
/**
 * @brief   ړtO̐ݒ
 * @param   
 * @retval  none
 */
//--------------------------------------------------------------

void CommPlayerSetMoveControl_Server(int netID, BOOL bMoveControl)
{
    if(_pCommPlayerWork->bMoveControl[ netID ] != bMoveControl){
        _pCommPlayerWork->bMoveControl[ netID ] = bMoveControl;
    }

}

//--------------------------------------------------------------
/**
 * @brief   v[[񂫂ɂ邩ǂ
 * @param   netID
 * @retval  Rg[łȂTRUE 荞ݒȂFALSE
 */
//--------------------------------------------------------------

BOOL CommPlayerGetMoveControl(int netID)
{
    return _pCommPlayerWork->bMoveControl[ netID ];
}


//--------------------------------------------------------------
/**
 * @brief   og[ŃvC[ʒuɂǂ
 * @param   none
 * @retval  ʒuɂTRUE
 */
//--------------------------------------------------------------

BOOL CommPlayerCheckBattleJump(void)
{
    _Grid battleGrid[]={{4,7},{11,7},{4,8},{11,8}};
    int machineMax = CommGetMaxEntry(CommMPGetServiceNo());
    int i,j,count=0,stand[4];

    for(i = 0; i < machineMax; i++){
        for(j = 0; j < machineMax; j++){
            if((CommPlayerGetGridX(j) == battleGrid[i].xpos) &&
               (CommPlayerGetGridZ(j) == battleGrid[i].zpos)){
                count++;
                stand[ j ] = i;
                break;
            }
        }
    }
    if(count == machineMax){
        for(i = 0; i < machineMax; i++){
            CommSetStandNo(stand[ i ], i);
        }
        return TRUE;
    }
    return FALSE;
}

//--------------------------------------------------------------
/**
 * 
 * @param	netID   playerID
 * @retval	TRUE
 */
//--------------------------------------------------------------
BOOL CommPlayerDeleteFlagData(int netID)
{
    if(_pCommPlayerWork->pNowFlag[netID] != NULL){
        sys_FreeMemoryEz(_pCommPlayerWork->pNowFlag[netID]);
        _pCommPlayerWork->pNowFlag[netID] = NULL;
        _pCommPlayerWork->hedFE[netID] = _HFE_NONE;
        return TRUE;
    }
    return FALSE;
}

//--------------------------------------------------------------
/**
 * ۑ
 * @param	netID   playerID
 * @retval	TRUE
 */
//--------------------------------------------------------------
BOOL CommPlayerDeliveryFlagData(int netID)
{
    int i;
    
    if(_pCommPlayerWork->pNowFlag[netID] != NULL){
        for(i = 0; i < _KEEP_FLAG_MAX; i++){
            if(_pCommPlayerWork->pKeepFlag[netID][i]){
                if(MyStatus_Compare(_pCommPlayerWork->pNowFlag[netID], _pCommPlayerWork->pKeepFlag[netID][i]) == TRUE){
                    // Sv ͍̊
                    CommPlayerDeleteFlagData(netID);
                    return FALSE;
                }
            }
        }
        if(_pCommPlayerWork->pKeepFlag[netID][_KEEP_FLAG_MAX-1]){
            sys_FreeMemoryEz(_pCommPlayerWork->pKeepFlag[netID][_KEEP_FLAG_MAX-1]);
        }
        for(i = _KEEP_FLAG_MAX - 1; i >= 1; i--){
            _pCommPlayerWork->pKeepFlag[netID][i] = _pCommPlayerWork->pKeepFlag[netID][i-1];
        }
        _pCommPlayerWork->pKeepFlag[netID][0] = _pCommPlayerWork->pNowFlag[netID];

        if(netID == CommGetCurrentID()){  // L^
            UnderGroundAddFlag(SaveData_GetUnderGroundData(GameSystem_GetSaveData(_pCommPlayerWork->pFSys)),
                               _pCommPlayerWork->pNowFlag[netID]);
        }
        _pCommPlayerWork->pNowFlag[netID] = NULL;
        return TRUE;
    }
    return FALSE;
}

//--------------------------------------------------------------
/**
 * Ă邩ǂ
 * @param	netID   playerID
 * @retval	ĂTRUE
 */
//--------------------------------------------------------------
BOOL CommPlayerIsFlagData(int netID)
{
    if(_pCommPlayerWork->pNowFlag[netID] != NULL){
        return TRUE;
    }
    return FALSE;
}

//--------------------------------------------------------------
/**
 * @brief   ̃p\R
 * @param   myNetID   Ƃl
 * @param   targetID  Ƃl
 * @retval  none
 */
//--------------------------------------------------------------

BOOL CommPlayerGetFlag(int myNetID, int targetNetID)
{
    if(_pCommPlayerWork->pNowFlag[myNetID] == NULL){
        MYSTATUS* pTargetStatus = CommInfoGetMyStatus(targetNetID);
        _pCommPlayerWork->pNowFlag[myNetID] = MyStatus_AllocWork(HEAPID_COMMUNICATION);
        MyStatus_Copy(pTargetStatus, _pCommPlayerWork->pNowFlag[myNetID]);
        _pCommPlayerWork->hedFE[myNetID] = _HFE_FLAG;
        return TRUE;
    }
    return FALSE;
}

//--------------------------------------------------------------
/**
 * @brief   ̓
 * @param   myNetID   Ƃl
 * @param   targetID  Ƃl
 * @retval  ƂTRUE
 */
//--------------------------------------------------------------

static BOOL _getHeadFlag(int myNetID, int targetNetID)
{
    if((_pCommPlayerWork->pNowFlag[myNetID] == NULL) &&
       (_pCommPlayerWork->pNowFlag[targetNetID] != NULL)){
        _pCommPlayerWork->pNowFlag[myNetID] = _pCommPlayerWork->pNowFlag[targetNetID];
        _pCommPlayerWork->pNowFlag[targetNetID] = NULL;
        _pCommPlayerWork->hedFE[myNetID] = _HFE_FLAG;
        _pCommPlayerWork->hedFE[targetNetID] = _HFE_NONE;
        return TRUE;
    }
    return FALSE;
}

//--------------------------------------------------------------
/**
 * @brief   w̐lɊo
 * @param   netID        l
 * @retval  none
 */
//--------------------------------------------------------------

static void _setFlagDisp(int netID)
{
    if(!_pCommPlayerWork->bResetting){
        if(_pCommPlayerWork->pPlayer[netID]){
            switch(_pCommPlayerWork->hedFE[netID]){
              case _HFE_OK:
                if(_pCommPlayerWork->pMark[netID]==NULL){
                    FE_Ok_Add( Player_FieldOBJGet(_pCommPlayerWork->pPlayer[netID]) );
                }
                _pCommPlayerWork->hedFE[netID] = _HFE_NONE;
                break;
              case _HFE_EXCLAMATION:
                if(_pCommPlayerWork->pMark[netID]==NULL){
                    _pCommPlayerWork->pMark[netID] =
                        FE_Exclamation_Add( Player_FieldOBJGet(_pCommPlayerWork->pPlayer[netID]) );
                }
                break;
              case _HFE_FLAG:
                if(_pCommPlayerWork->pMark[netID]==NULL){
                    _pCommPlayerWork->pMark[netID] =
                        FE_Flag_Add( Player_FieldOBJGet(_pCommPlayerWork->pPlayer[netID]) );
                }
                break;
              case _HFE_NONE:
                if(_pCommPlayerWork->pMark[netID]!=NULL){
                    EOA_Delete(_pCommPlayerWork->pMark[netID]);
                    _pCommPlayerWork->pMark[netID] = NULL;
                }
                break;
            }
        }
    }
}

//--------------------------------------------------------------
/**
 * @brief   w̐lɂт}[No
 * @param   netID        т}[Nl
 * @retval  none
 */
//--------------------------------------------------------------

void CommPlayerSetFEExclamationAdd(int netID)
{
    if(_pCommPlayerWork->hedFE[ netID ] != _HFE_FLAG){
        _pCommPlayerWork->hedFE[ netID ] = _HFE_EXCLAMATION;
    }
}

//--------------------------------------------------------------
/**
 * @brief   w̐lOK}[No
 * @param   netID        т}[Nl
 * @retval  none
 */
//--------------------------------------------------------------

void CommPlayerSetFEOkAdd(int netID)
{
    if(_pCommPlayerWork->hedFE[ netID ] != _HFE_FLAG){
        _pCommPlayerWork->hedFE[ netID ] = _HFE_OK;
    }
    if(_pCommPlayerWork->pMark[netID]!=NULL){
        EOA_Delete(_pCommPlayerWork->pMark[netID]);
        _pCommPlayerWork->pMark[netID] = NULL;
    }
}

//--------------------------------------------------------------
/**
 * @brief   w̐lɃ}[N
 * @param   netID        l
 * @retval  none
 */
//--------------------------------------------------------------

void CommPlayerSetFENoneAdd(int netID)
{
    if(_pCommPlayerWork->hedFE[ netID ] != _HFE_FLAG){
        _pCommPlayerWork->hedFE[ netID ] = _HFE_NONE;
    }
    if(_pCommPlayerWork->pMark[netID]!=NULL){
        EOA_Delete(_pCommPlayerWork->pMark[netID]);
        _pCommPlayerWork->pMark[netID] = NULL;
    }
}

//--------------------------------------------------------------
/**
 * @brief   ɊւԂT[o[Ԃꍇ̃R}hTCY
 * @param   ʐMR[obN
 * @retval  none
 */
//--------------------------------------------------------------

typedef struct{
    u8 state;
    u8 myNetID;
    u8 targetID;
} _flagStateCallBack;

int CommPlayerRecvFlagStateServerRetGetSize(void)
{
    return sizeof(_flagStateCallBack);
}

//--------------------------------------------------------------
/**
 * @brief   ɊւԂT[o[ɓ͂  CF_FLAG_STATE
 * @param   ʐMR[obN
 * @retval  none
 */
//--------------------------------------------------------------

void CommPlayerRecvFlagState(int netID, int size, void* pData, void* pWork)
{
    u8* pState = pData;
    _flagStateCallBack ret;

    ret.myNetID = netID;
    switch(pState[0]){
      case UNDER_FLAG_DEL:
        ret.state = UNDER_FLAG_DEL;
        CommPlayerDeleteFlagData(netID);
        CommSendFixSizeData_ServerSide(CF_FLAG_STATE_RET,&ret);  // ׂɃNCAgɑM
        break;
      case UNDER_FLAG_DELIVERY:
        ret.state = UNDER_FLAG_DELIVERY;

//        CommPlayerDeliveryFlagData(netID);
        CommSendFixSizeData_ServerSide(CF_FLAG_STATE_RET,&ret);  // ׂɃNCAgɑM
        break;
    }
}


BOOL CommPlayerFlagTalkCheck(int netID, int targetID)
{
    _flagStateCallBack ret;

    if(CommPlayerIsFlagData(netID)){ // Ăꍇ͂
        ret.state = UNDER_FLAG_NOTALK;
    }
    else{
        if(!CommPlayerIsFlagData(targetID)){ // 肪ĂȂ
            return FALSE;
        }
        else{
            ret.state = UNDER_FLAG_RIP_OFF;
        }
    }
    ret.myNetID = netID;
    ret.targetID = targetID;
    CommSendFixSizeData_ServerSide(CF_FLAG_STATE_RET,&ret);  // NCAgɑM
    return TRUE;
}

BOOL CommPlayerFlagDigCheck(int netID)
{
    _flagStateCallBack ret;

    if(CommPlayerIsFlagData(netID)){ // Ăꍇ͂
        ret.state = UNDER_FLAG_NODIG;
    }
    else{
        return FALSE;
    }
    ret.myNetID = netID;
    CommSendFixSizeData_ServerSide(CF_FLAG_STATE_RET,&ret);  // NCAgɑM
    return TRUE;
}

//--------------------------------------------------------------
/**
 * @brief   bZ[W\ꍇ̏IR[obN
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------
static void _msgDeliveryCallBack(int num)
{
    if(num > 0){
        CommMsgRegisterNumber2(CommUnderGetMsgUnderFlag(),num);
        CommMsgTalkWindowStart(CommUnderGetMsgUnderFlag(),
                               mes_uw_flag_09, TRUE, _msgEndCallBack);
    }
    else{
        CommMsgRegisterNumber2(CommUnderGetMsgUnderFlag(),-num);
        CommMsgTalkWindowStart(CommUnderGetMsgUnderFlag(),
                               mes_uw_flag_08, TRUE, _msgEndCallBack);
    }
    SecretBaseRecordSetPoint(SaveData_GetSecretBaseRecord(GameSystem_GetSaveData(_pCommPlayerWork->pFSys)), num); // _Z
}

//--------------------------------------------------------------
/**
 * @brief   ɊւԂNCAgɓ͂  CF_FLAG_STATE_RET
 * @param   ʐMR[obN
 * @retval  none
 */
//--------------------------------------------------------------

void CommPlayerRecvFlagStateServerRet(int netID, int size, void* pData, void* pWork)
{
    _flagStateCallBack* pRet = pData;
    BOOL bDeliv;

    switch(pRet->state){
      case UNDER_FLAG_DEL:
        OHNO_PRINT("-------------1-----------\n");
        CommPlayerDeleteFlagData(pRet->myNetID);
        if(_pCommPlayerWork->pMark[pRet->myNetID] ){
            OHNO_PRINT("-------------2------------\n");
            EOA_Delete( _pCommPlayerWork->pMark[pRet->myNetID] );
            _pCommPlayerWork->pMark[pRet->myNetID] = NULL;
        }
        if(pRet->myNetID == CommGetCurrentID()){
            OHNO_PRINT("-------------3------------\n");
            Snd_FadeOutNextPlaySet(SND_SCENE_FIELD,SEQ_TANKOU,BGM_FADE_TANKOU_TIME,0,0xff,NULL);
        }
        break;
      case UNDER_FLAG_RIP_OFF:
        if(MyStatus_Compare(_pCommPlayerWork->pNowFlag[pRet->targetID],
                            CommInfoGetMyStatus(pRet->myNetID)) == TRUE){  // ͎̊
            // ̊
            CommPlayerDeleteFlagData(pRet->targetID);
            if(pRet->myNetID == CommGetCurrentID()){
                SecretBaseRecordSetFlagReverseNum(SaveData_GetSecretBaseRecord(GameSystem_GetSaveData(_pCommPlayerWork->pFSys)));   // D߂
                FieldSystemProc_SeqHold();
                CommMsgTalkWindowStartSendNum(CommUnderGetMsgUnderFlag(),  // Ƃǂ
                                              mes_uw_flag_18, TRUE, _msgDeliveryCallBack, UNDER_FLAG_POINT_RECAPTURE);
            }
            else if(pRet->targetID == CommGetCurrentID()){
                SecretBaseRecordSetFlagStealNum(SaveData_GetSecretBaseRecord(GameSystem_GetSaveData(_pCommPlayerWork->pFSys)));  // Ƃꂽ
                FieldSystemProc_SeqHold();
                CommMsgRegisterTargetName(CommUnderGetMsgUnderFlag(),CommInfoGetMyStatus(pRet->myNetID));
                CommMsgTalkWindowStartSendNum(CommUnderGetMsgUnderFlag(),  // Dꂽ
                                              mes_uw_flag_16, TRUE, _msgDeliveryCallBack, UNDER_FLAG_POINT_STOLEN);
                Snd_FadeOutNextPlaySet(SND_SCENE_FIELD,SEQ_TANKOU,BGM_FADE_TANKOU_TIME,0,0xff,NULL);
            }
        }
        else if(_getHeadFlag(pRet->myNetID,pRet->targetID)){
            if(pRet->myNetID == CommGetCurrentID()){
                SecretBaseRecordSetFlagConquerNum(SaveData_GetSecretBaseRecord(GameSystem_GetSaveData(_pCommPlayerWork->pFSys)));  // D
                FieldSystemProc_SeqHold();
                CommMsgRegisterTargetName(CommUnderGetMsgUnderFlag(),CommInfoGetMyStatus(pRet->targetID));
                CommMsgTalkWindowStartSendNum(CommUnderGetMsgUnderFlag(),  // D
                                              mes_uw_flag_17, TRUE, _msgDeliveryCallBack, UNDER_FLAG_POINT_RIP_OFF);
                Snd_BgmPlay( SEQ_HATANIGE );
            }
            else if(pRet->targetID == CommGetCurrentID()){
                SecretBaseRecordSetFlagStealNum(SaveData_GetSecretBaseRecord(GameSystem_GetSaveData(_pCommPlayerWork->pFSys)));  // Ƃꂽ
                FieldSystemProc_SeqHold();
                CommMsgRegisterTargetName(CommUnderGetMsgUnderFlag(),CommInfoGetMyStatus(pRet->targetID));
                CommMsgTalkWindowStartSendNum(CommUnderGetMsgUnderFlag(),  // Dꂽ
                                              mes_uw_flag_15, TRUE, _msgDeliveryCallBack, UNDER_FLAG_POINT_STOLEN);
                Snd_FadeOutNextPlaySet(SND_SCENE_FIELD,SEQ_TANKOU,BGM_FADE_TANKOU_TIME,0,0xff,NULL);
            }
        }
        break;
      case UNDER_FLAG_NOTALK:
        if(pRet->myNetID == CommGetCurrentID()){
            FieldSystemProc_SeqHold();
            CommMsgTalkWindowStart(CommUnderGetMsgUnderFlag(),
                                   mes_uw_flag_11, TRUE, _msgEndCallBack);
        }
        break;
      case UNDER_FLAG_NODIG:
        if(pRet->myNetID == CommGetCurrentID()){
            FieldSystemProc_SeqHold();
            CommMsgTalkWindowStart(CommUnderGetMsgUnderFlag(),
                                   mes_uw_flag_10, TRUE, _msgEndCallBack);
        }
        break;
      case UNDER_FLAG_DELIVERY:
        bDeliv = CommPlayerDeliveryFlagData(pRet->myNetID);  // L^
        if(pRet->myNetID == CommGetCurrentID()){  // \
            FieldSystemProc_SeqHold();
            // t@t@[Kv @@OO
            if(bDeliv){
                CommMsgTalkWindowStartSendNum(CommUnderGetMsgUnderFlag(),
                                              mes_uw_flag_12, TRUE, _msgDeliveryCallBack,UNDER_FLAG_POINT_DELIVERY);
            }
            else{
                CommMsgTalkWindowStartSendNum(CommUnderGetMsgUnderFlag(),
                                              mes_uw_flag_12, TRUE, _msgDeliveryCallBack,UNDER_FLAG_POINT_DELIVERY_SECOND);
            }
            Snd_FadeOutNextPlaySet(SND_SCENE_FIELD,SEQ_TANKOU,BGM_FADE_TANKOU_TIME,0,0xff,NULL);
        }
        _pCommPlayerWork->hedFE[pRet->myNetID] = _HFE_NONE;
        CommPlayerSetFENoneAdd(pRet->myNetID); // 
        break;
    }
}



#if PM_DEBUG
//--------------------------------------------------------------
/**
 * fobO   \
 */
//--------------------------------------------------------------

static void _debugGyoeDisp(void)
{
    int i,on = FALSE;
    static PLAYER_STATE_PTR pPlayer[COMM_MACHINE_MAX]={NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL};
    static EOA_PTR pMark[COMM_MACHINE_MAX]={NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL};
    static EOA_PTR pTrap[COMM_MACHINE_MAX]={NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL};
    
    if(!(sys.cont & PAD_BUTTON_R)){
        return;
    }
    if(sys.trg & PAD_BUTTON_Y){
        if(pPlayer[0] == NULL){
            for(i = 0;i < (COMM_MACHINE_MAX - CommGetConnectNum());i++){
                pPlayer[i] = Player_Init( _pCommPlayerWork->pFSys->fldobjsys,
                                          _pCommPlayerWork->sPlayerPlace[0].xpos + (i+1)%8,
                                          _pCommPlayerWork->sPlayerPlace[0].zpos + (i+1)/8,
                                          _pCommPlayerWork->sPlayerPlace[0].dir,
                                          HERO_FORM_NORMAL, PM_FEMALE, NULL );
            }
        }
        else{
            for(i = 0;i < COMM_MACHINE_MAX;i++){
                if(pMark[i]){
                    EOA_Delete( pMark[i] );
                    pMark[i] = NULL;
                }
                if(pPlayer[i]){
                    Player_Delete(pPlayer[i]);
                }
                pPlayer[i] = NULL;
            }
        }
    }
    if(sys.trg & PAD_BUTTON_X){
        if(_pCommPlayerWork->pMark[0] == NULL){
            on = TRUE;
        }
        for(i = 0; i < COMM_MACHINE_MAX; i++){
            if(pMark[i]){
                EOA_Delete( pMark[i] );
                pMark[i] = NULL;
            }
            if(_pCommPlayerWork->pMark[i] ){
                EOA_Delete( _pCommPlayerWork->pMark[i] );
                _pCommPlayerWork->pMark[i] = NULL;
            }
            if(on && _pCommPlayerWork->pPlayer[i]){
                _pCommPlayerWork->pMark[i] =
                    FE_Flag_Add( Player_FieldOBJGet(_pCommPlayerWork->pPlayer[i]) );
            }
            if(on && pPlayer[i]){
                pMark[i] = FE_Flag_Add( Player_FieldOBJGet(pPlayer[i]) );
            }
        }
    }
    if(sys.trg & PAD_BUTTON_B){
        if(pTrap[0] == NULL){
            on = TRUE;
        }
        for(i = 0; i < COMM_MACHINE_MAX; i++){
            if(pTrap[i]){
                EOA_Delete( pTrap[i] );
                pTrap[i] = NULL;
            }
            if(on){
                pTrap[i] = FE_DirTrap_Add( _pCommPlayerWork->pFSys,
                                           _pCommPlayerWork->sPlayerPlace[0].xpos + i%8,
                                           _pCommPlayerWork->sPlayerPlace[0].zpos + i/8,
                                           DIR_UP );
            }
        }
    }

}
#endif

//--------------------------------------------------------------
/**
 * @brief   ̕Ɣ΂̕Ԃ
 * @param   dir 
 * @retval  ΂̕
 */
//--------------------------------------------------------------

int CommPlayerGetReverseDir(int dir)
{
    if(dir == DIR_UP){
        return DIR_DOWN;
    }
    else if(dir == DIR_DOWN){
        return DIR_UP;
    }
    else if(dir == DIR_LEFT){
        return DIR_RIGHT;
    }
    else if(dir == DIR_RIGHT){
        return DIR_LEFT;
    }
    GF_ASSERT(0 && "NOT DIR CODE");
    return DIR_LEFT;
}


//--------------------------------------------------------------
/**
 * @brief   E͂Ă񂪑ԃ^C}[Zbg
 * @param   netID   ID
 * @param   count   JEg
 * @retval  none
 */
//--------------------------------------------------------------

void CommPlayerSetGiddyStep(int netID,int count)
{
    _pCommPlayerWork->giddyCounter[netID] = count;
    _pCommPlayerWork->walkCount[netID] = 15;
}

//--------------------------------------------------------------
/**
 * @brief   E͂Ă񂪑ԃ^C}[I
 * @param   netID   ID
 * @retval  none
 */
//--------------------------------------------------------------

void CommPlayerResetGiddyStep(int netID)
{
    _pCommPlayerWork->giddyCounter[netID] = 0;
}

//--------------------------------------------------------------
/**
 * @brief   ȗp@@̂݋tÕZbg
 * @param   netID   ID
 * @param   count   JEg
 * @retval  none
 */
//--------------------------------------------------------------

void CommPlayerSetHole(int netID,int count)
{
    _pCommPlayerWork->countHole[netID] = count;
    _pCommPlayerWork->walkCount[netID] = 15;
}

//--------------------------------------------------------------
/**
 * @brief   ȗp@@̂݋tÕZbg
 * @param   netID   ID
 * @retval  none
 */
//--------------------------------------------------------------

void CommPlayerResetHole(int netID)
{
    _pCommPlayerWork->countHole[netID] = 0;
}

#if 0
<player.h>

//--------------------------------------------------------------
/**
 * w肳ꂽL[񂩂玩@ۂɎw肷Aj[VR}hR[h擾
 * @param	jiki	PLAYER_STATE_PTR
 * @param	trg		L[gK
 * @param	prs		L[vX
 * @param	speed	JIKI_FRAME_SPEED_32F
 * @param	dash	_bVtO TRUE=_bV\@FALSE=_bVs
 * @retval	u32		AjR[hAC_WALK_D_8F
 */
//--------------------------------------------------------------
u32 Player_KeyMoveSelectAcmdCodeGet(
		PLAYER_STATE_PTR jiki, u16 trg, u16 prs, int speed, int dash )

//--------------------------------------------------------------
/**
 * @Aj[VR}hZbgł邩ǂ
 * @param	jiki	PLAYER_STATE_PTR
 * @retval	int		TRUE=\ FALSE=s
 */
//--------------------------------------------------------------
int Player_AcmdSetCheck( PLAYER_STATE_PTR jiki )

//--------------------------------------------------------------
/**
 * LZ\`FbN
 * @param	jiki	PLAYER_STATE_PTR
 * @retval	int		TRUE=\
 */
//--------------------------------------------------------------
int Player_MoveCancellCheck( PLAYER_STATE_PTR jiki )

//--------------------------------------------------------------
/**
 * @Aj[VR}hZbg
 * @param	jiki	PLAYER_STATE_PTR
 * @param	ac		AjR[hAC_DIR_U
 * @retval	nothing
 */
//--------------------------------------------------------------
void Player_AcmdSet( PLAYER_STATE_PTR jiki, u32 ac )


F
void Test( PLAYER_STATE_PTR jiki, u16 trg, u16 prs )
{
    u32 code = Player_KeyMoveSelectAcmdCodeGet(
        jiki, trg, prs, JIKI_FRAME_SPEED_NORMAL, TRUE );
    
    if( Player_AcmdSetCheck(jiki) == FALSE ){          //Aj[VR}h
        if( Player_MoveCancellCheck(jiki) == FALSE ){  //LZs
            return;
        }
    }
    
    Player_AcmdSet( jiki, code );
}


#endif

